package bodybuilder.test;

import java.util.Map;

import bodybuilder.util.Config;
import bodybuilder.util.ObjectUtils;

/**
 * テストケースマッピング
 */
class TestCaseMapping {

    /**
     * テストケースのマップ
     */
    private static Map testCaseMap = Config.getTestCaseMap();

    /**
     * XMLを取得する。
     * 
     * @param testCaseType テストケースタイプ
     * @return XML
     */
    public static XML getXML(String testCaseType) {
        // テストケースにマップされたXMLを返す。
        String className = ((String) testCaseMap.get(testCaseType + ".xml"));
        return (XML) ObjectUtils.getObject(className);
    }

    /**
     * テストケースXMLを取得する。
     * 
     * @param testCaseType テストケースタイプ
     * @return　テストケースXML
     */
    public static XMLTestCase getTestCase(String testCaseType) {
        // テストケースにマップされたテストケースXMLを返す。
        String className = ((String) testCaseMap.get(testCaseType));
        return (XMLTestCase) ObjectUtils.getObject(className);
    }

}