package bodybuilder.util.dbunit;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableIterator;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import jxl.Workbook;
import jxl.read.biff.BiffException;

/**
 * Java Excel APIデータセット
 */
public class JxlDataSet extends AbstractDataSet {

    /**
     * テーブル
     */
    private ITable[] tables = null;

    /**
     * データセットを生成する。
     * 
     * @param file ファイル
     */
    public JxlDataSet(File file) throws IOException, DataSetException {
        FileInputStream fin = new FileInputStream(file);
        loadTables(fin);
        fin.close();
    }

    /**
     * データセットを生成する。
     * 
     * @param in 入力ストリーム
     */
    public JxlDataSet(InputStream in) throws IOException, DataSetException {
        loadTables(in);
    }

    /**
     * テーブルをロードする。
     *
     * @param in 入力ストリーム
     * @throws DataSetException
     */
    private void loadTables(InputStream in) throws IOException,
            DataSetException {
        try {
            // ワークブックを取得。
            Workbook workbook = Workbook.getWorkbook(in);

            // テーブルを生成。
            tables = new ITable[workbook.getNumberOfSheets()];

            for (int i = 0; i < tables.length; i++) {
                tables[i] = new JxlTable(workbook.getSheet(i));
            }
        } catch (BiffException e) {
            throw new DataSetException(e);
        }
    }

    /**
     * イテレータを生成する。
     * 
     * @param reversed リバースフラグ
     * @return イテレータ
     */
    protected ITableIterator createIterator(boolean reversed)
            throws DataSetException {
        return new DefaultTableIterator(tables, reversed);
    }

    // TODO XLSファイル書き出し用メソッドを追加すること。

}