package bodybuilder.viewer.servlet;

import java.util.Iterator;
import java.util.Map;

import javax.servlet.ServletContext;
import bodybuilder.util.ObjectUtils;
import bodybuilder.util.ServletObjectUtils;
import bodybuilder.viewer.Viewer;
import bodybuilder.viewer.handler.OutputHandler;

/**
 * サーブレットコンテキストビューア
 */
public class ServletContextViewer extends Viewer {

    /**
     * サーブレットコンテキストの内容を出力する。
     * 
     * @param object サーブレットコンテキスト
     * @param handler 出力ハンドラ
     */
    public void output(Object object, OutputHandler handler) {
        // サーブレットコンテキストにキャスト。
        ServletContext context = (ServletContext) object;
        handler.print(ObjectUtils.getInfo(object) + " {");
        handler.indent();

        // 属性を取得。
        Map attributes = ServletObjectUtils
                .getServletContextAttributes(context);
        Iterator attrNames = attributes.keySet().iterator();

        // 属性を出力。
        while (attrNames.hasNext()) {
            String name = (String) attrNames.next();
            handler.print("[\"" + name + "\"]=>");
            dump(context.getAttribute(name), handler);
        }

        handler.unindent();
        handler.print("}");
    }

}