using System;
using System.ComponentModel;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Drawing;
using System.Text.RegularExpressions;
using System.Diagnostics;
using System.Runtime.InteropServices;
using System.Xml;
using System.Net;
using System.Net.Sockets;

namespace Browser.Boon.Control
{
	/// <summary>
	/// gꂽWebBrowserRg[ł
	/// </summary>
	public class WebBrowserEx : WebBrowser
	{
		/// <summary>
		/// ̃NX̃RXgN^łB
		/// </summary>
		public WebBrowserEx()
		{
			this.ScriptErrorsSuppressed = true;
			//this.ScriptErrorsSuppressed = false;

			this.Navigated += new WebBrowserNavigatedEventHandler(WebBrowserEx_Navigated);

			this.initializeCtxHistory();
			this._ism = new InternetSecurityManager(this);
			this._ism.SecurityFlags = SecurityFlags.Script | SecurityFlags.AxExecute;
		}

		void WebBrowserEx_Navigated(object sender, WebBrowserNavigatedEventArgs e)
		{
			try
			{
				if(this.history == null)
				{
					this.history = new ExHtmlHistory(this);
				}
			}
			catch(AccessViolationException ex)
			{
				Debug.Write(ex.Message + " \n" + ex.Source);
			}
		}


		System.Windows.Forms.AxHost.ConnectionPointCookie cookie;
		WebBrowserExtendedEvents events;

		InternetSecurityManager _ism;
		public SecurityFlags SecurityDefault
		{
			get { return this._ism.SecurityFlags; }
			set { this._ism.SecurityFlags = value; }
		}

		// Override
		protected override void CreateSink()
		{
			base.CreateSink();
			events = new WebBrowserExtendedEvents(this);
			cookie = new System.Windows.Forms.AxHost.ConnectionPointCookie(this.ActiveXInstance, events, typeof(DWebBrowserEvents2));
		}
		protected override void DetachSink()
		{
			if(cookie != null)
			{
				cookie.Disconnect();
				cookie = null;
			}

			base.DetachSink();
		}
		protected override void WndProc(ref Message m)
		{
			switch(m.Msg)
			{
				case 0x201: // WM_LMOUSEBUTTON,WM_RMOUSEBUTTON 
				case 0x204:
				case 0x207: // WM_MMOUSEBUTTON
				case 0x21:  //WM_MOUSEACTIVATE
					base.DefWndProc(ref m);
					return;
			}
			base.WndProc(ref m);
		}

		private ExHtmlHistory history = null;
		/// <summary>
		/// ̃uEŨirQ[g̗擾T|[g܂
		/// </summary>
		public ExHtmlHistory History
		{
			get { return this.history; }
		}


		#region +++++++++++  History Manager  ++++++++++++

		/// <summary>
		/// uEU̖߂EiޗReLXgj[ɕ\A
		/// iḰu߂vEuiށv@\񋟂܂
		/// </summary>
		/// <param name="globalLocation">j[\XN[W</param>
		/// <param name="isBackHistory">u߂vtrueAuiށvfalse</param>
		public void ShowHistoryList(Point globalLocation, bool isBackHistory)
		{
			if(this.History == null) return;
			this.travelLog = this.History.EnumEntries(
				isBackHistory ? TLENUMF.TLEF_RELATIVE_BACK : TLENUMF.TLEF_RELATIVE_FORE,
				this.tsmiHistory.Length);
			this.travelLogIsBack = isBackHistory;
			if(this.travelLog != null && this.travelLog.Length > 0)
			{
				this.ctxHistoryList.Items.Clear();
				for(int i=0; i<this.travelLog.Length; i++)
				{
					this.tsmiHistory[i].ImageIndex = isBackHistory ? 0 : 1;
					this.tsmiHistory[i].Text = this.travelLog[i].Title;
					this.ctxHistoryList.Items.Add(tsmiHistory[i]);
				}
				this.ctxHistoryList.Show(globalLocation);
			}
		}
		public TravelLogEntry[] GetBrowserBackHistory
		{
			get { return this.History.EnumEntries(TLENUMF.TLEF_RELATIVE_BACK, 10); }
		}
		public TravelLogEntry[] GetBrowserForwardHistory
		{
			get { return this.History.EnumEntries(TLENUMF.TLEF_RELATIVE_FORE, 10); }
		}
		private TravelLogEntry[] travelLog;
		bool travelLogIsBack = false;
		private ToolStripMenuItem[] tsmiHistory;
		private ContextMenuStrip ctxHistoryList;
		private void initializeCtxHistory()
		{
			this.ctxHistoryList = new ContextMenuStrip();
			this.ctxHistoryList.ImageList = new ImageList();
			this.ctxHistoryList.ImageList.Images.Add(Browser.Properties.Resources.ico_back);
			this.ctxHistoryList.ImageList.Images.Add(Browser.Properties.Resources.ico_forward);
			this.tsmiHistory = new ToolStripMenuItem[10];
			this.ctxHistoryList.ItemClicked +=new ToolStripItemClickedEventHandler(ctxHistoryList_ItemClicked);
			for(int i=0; i<this.tsmiHistory.Length; i++)
			{
				this.tsmiHistory[i] = new ToolStripMenuItem();
				this.tsmiHistory[i].Name = i.ToString();
				this.tsmiHistory[i].ImageIndex = 0;
				this.tsmiHistory[i].Height = 16;
			}
		}

		void ctxHistoryList_ItemClicked(object sender, ToolStripItemClickedEventArgs e)
		{
			int cindex = this.ctxHistoryList.Items.IndexOf(e.ClickedItem);
			MessageBox.Show("Clicked Item :\n" + this.travelLog[cindex].Title + "\n" + this.travelLog[cindex].Url);
			this.History.TravelTo((cindex + 1) * (this.travelLogIsBack ? -1 : 1));
		}

		#endregion


		// --------------------------------------------------- //

		#region Events

		/// <summary>
		/// NavigateJnOɌĂяo܂B
		///  WebBrowserExtendsEventArgsɕϊ\łB
		/// </summary>
		public event EventHandler BeforeNavigate;
		/// <summary>
		/// VEBhEJƂۂɌĂяo܂B
		///  WebBrowserExtendsEventArgsɕϊ\łB
		/// </summary>
		public event EventHandler BeforeNewWindow;
		/// <summary>
		/// 炩̗RɂANavigatesꍇɌĂяo܂B
		/// WebBrowserNavigateErrorEventArgsɕϊ\łB
		/// </summary>
		public event EventHandler NavigateError;


		#region Cxg̎

		protected void OnBeforeNewWindow(string url, out bool cancel)
		{
			EventHandler h = BeforeNewWindow;
			WebBrowserExtendedNavigatingEventArgs args = new WebBrowserExtendedNavigatingEventArgs(url, null);

			if(h != null)
			{
				h(this, args);
			}

			cancel = args.Cancel;
		}

		protected void OnBeforeNavigate(string url, string frame, out bool cancel)
		{
			EventHandler h = BeforeNavigate;
			WebBrowserExtendedNavigatingEventArgs args = new WebBrowserExtendedNavigatingEventArgs(url, frame);

			if(h != null)
			{
				h(this, args);
			}

			cancel = args.Cancel;
		}

		protected void OnNavigateError(string url, string frame, int statusCode, out bool cancel)
		{
			WebBrowserNavigateErrorEventArgs e = new WebBrowserNavigateErrorEventArgs(url, frame, statusCode);
			if(this.NavigateError != null)
			{
				NavigateError(this, e);
			}
			cancel = e.Cancel;
		}


		class WebBrowserExtendedEvents
			: System.Runtime.InteropServices.StandardOleMarshalObject,
			DWebBrowserEvents2
		{
			WebBrowserEx exBrowser_;

			public WebBrowserExtendedEvents(WebBrowserEx exBrowser)
			{
				this.exBrowser_ = exBrowser;
			}

			public void BeforeNavigate2(object pDisp, ref object URL, ref object flags, ref object targetFrameName, ref object postData, ref object headers, ref bool cancel)
			{
				this.exBrowser_.OnBeforeNavigate((string)URL, (string)targetFrameName, out cancel);
			}

			public void NewWindow3(object pDisp, ref bool cancel, ref object flags, ref object URLContext, ref object URL)
			{
				this.exBrowser_.OnBeforeNewWindow((string)URL, out cancel);
			}

			public void NavigateError(object pDisp, ref object url, ref object frame, ref object statusCode, ref bool cancel)
			{
				this.exBrowser_.OnNavigateError((string)url, (string)frame, (Int32)statusCode, out cancel);
			}
		}


		[System.Runtime.InteropServices.ComImport(), System.Runtime.InteropServices.Guid("34A715A0-6587-11D0-924A-0020AFC7AC4D"),
		System.Runtime.InteropServices.InterfaceTypeAttribute(System.Runtime.InteropServices.ComInterfaceType.InterfaceIsIDispatch),
		System.Runtime.InteropServices.TypeLibType(System.Runtime.InteropServices.TypeLibTypeFlags.FHidden)]
		public interface DWebBrowserEvents2
		{
			[System.Runtime.InteropServices.DispId(250)]
			void BeforeNavigate2
			(
				[In, MarshalAs(UnmanagedType.IDispatch)] object pDisp,
				[In] ref object URL,
				[In] ref object flags,
				[In] ref object targetFrameName,
				[In] ref object postData,
				[In] ref object headers,
				[In, Out] ref bool cancel
			);

			[System.Runtime.InteropServices.DispId(273)]
			void NewWindow3
			(
				[In, System.Runtime.InteropServices.MarshalAs(UnmanagedType.IDispatch)] object pDisp,
				[In, System.Runtime.InteropServices.Out] ref bool cancel,
				[In] ref object flags,
				[In] ref object URLContext,
				[In] ref object URL
			);

			[System.Runtime.InteropServices.DispId(271)]
			void NavigateError(
				[System.Runtime.InteropServices.In, System.Runtime.InteropServices.MarshalAs(System.Runtime.InteropServices.UnmanagedType.IDispatch)] object pDisp,
				[In] ref object URL, [In] ref object frame,
				[In] ref object statusCode, [In, Out] ref bool cancel);

		}

		#endregion

		#endregion

	}

	/// <summary>
	/// CancelEventArgs̊głBNavigate\URLȂǂ擾ł܂B
	/// </summary>
	public class WebBrowserExtendedNavigatingEventArgs : CancelEventArgs
	{
		private string url_;
		private string frame_;

		public string Url
		{
			get { return (this.url_); }
		}
		public string Frame
		{
			get { return (this.frame_); }
		}

		public WebBrowserExtendedNavigatingEventArgs(string url, string frame)
			: base()
		{
			this.url_ = url;
			this.frame_ = frame;
		}
	}

	public class WebBrowserNavigateErrorEventArgs : EventArgs
	{
		private String urlValue;
		private String frameValue;
		private Int32 statusCodeValue;
		private Boolean cancelValue;

		public WebBrowserNavigateErrorEventArgs(
			String url, String frame, Int32 statusCode)
		{
			urlValue = url;
			frameValue = frame;
			statusCodeValue = statusCode;
			cancelValue = false;
		}

		public String Url
		{
			get { return urlValue; }
			set { urlValue = value; }
		}
		public String Frame
		{
			get { return frameValue; }
			set { frameValue = value; }
		}
		public Int32 StatusCode
		{
			get { return statusCodeValue; }
			set { statusCodeValue = value; }
		}
		public Boolean Cancel
		{
			get { return cancelValue; }
			set { cancelValue = value; }
		}

	}

	#region Travel Log Management

	/// <summary>
	/// uEŨirQ[V̗Ǘ邽߂̃NXł
	/// </summary>
	public class ExHtmlHistory : IDisposable
	{
		private const int S_OK = 0x0;
		private const int S_FALSE = 0x1;
		private ITravelLogStg travelLog;
		/// <summary>
		/// gbNWebBrowserRg[w肵ẴNX쐬܂
		/// </summary>
		/// <param name="browser"></param>
		public ExHtmlHistory(WebBrowser browser)
		{
			if(browser == null) throw new NullReferenceException();
			IServiceProvider pISP = null;
			object ppvObject = null;
			Guid SID_STravelLogCursor = new Guid("7EBFDD80-AD18-11d3-A4C5-00C04F72D6B8");
			Guid IID_ITravelLogStg = new Guid("7EBFDD80-AD18-11d3-A4C5-00C04F72D6B8");
			pISP = (IServiceProvider)browser.ActiveXInstance;
			pISP.QueryService(ref SID_STravelLogCursor,ref IID_ITravelLogStg,out ppvObject);
			this.travelLog = (ITravelLogStg)ppvObject;
		}
		/// <summary>
		/// ̈ꗗ擾܂
		/// </summary>
		/// <param name="flags">擾闚̃^Cv</param>
		/// <param name="maxEntries">擾闚̍ő吔</param>
		/// <returns>TravelLogEntry̔zAsꍇnull</returns>
		public TravelLogEntry[] EnumEntries(TLENUMF flags, int maxEntries)
		{
			try
			{
				List<TravelLogEntry> history = new List<TravelLogEntry>(maxEntries);
				IEnumTravelLogEntry TLEnum = null;
				if(this.travelLog.EnumEntries(flags, ref TLEnum) == S_FALSE) return null;
				int tmp = 0;
				while(maxEntries > history.Count)
				{
					ITravelLogEntry TLEntry = null;
					int res = TLEnum.Next(1, out TLEntry, out tmp);
					if(TLEntry == null) break;
					history.Add(new TravelLogEntry(TLEntry));
					Marshal.ReleaseComObject(TLEntry);
				}
				Marshal.ReleaseComObject(TLEnum);
				return history.ToArray();
			}
			catch(Exception e) {
				Debug.WriteLine("ExHtmlEntry::EnumEntries / " + e.Message);
				return null;
			}
		}
		/// <summary>
		/// w肵̈ʒuɈړ܂
		/// </summary>
		/// <param name="offset">߂͕̒lAiޕ͐̒l</param>
		public void TravelTo(int offset)
		{
			ITravelLogEntry TLEntry = null;
			this.travelLog.GetRelativeEntry(offset, out TLEntry);
			this.travelLog.TravelTo(TLEntry);
			Marshal.ReleaseComObject(TLEntry);
		}
		public ITravelLogEntry InsertEntry(string url, string title, ITravelLogEntry travelLogEntry, bool prepend)
		{
			ITravelLogEntry TLEntry = null;
			this.travelLog.CreateEntry(url, title, travelLogEntry, prepend, out TLEntry);
			return TLEntry;
		}
		public int GetCount(TLENUMF flags)
		{
			int entries = 0;
			travelLog.GetCount(flags,out entries);
			return entries;
		}
		public ITravelLogEntry GetRelativeEntry(int offset)
		{
			ITravelLogEntry TLEntry = null;
			this.travelLog.GetRelativeEntry(offset,out TLEntry);
			return TLEntry;
		}
		public void RemoveEntry(ITravelLogEntry travelLogEntry)
		{
			this.travelLog.RemoveEntry(travelLogEntry);
		}

		private bool disposedValue = false;

		protected virtual void Dispose(bool disposing)
		{
			if(!this.disposedValue && this.travelLog != null)
			{
				Marshal.ReleaseComObject(this.travelLog);
			}
			this.disposedValue = true;
		}

		#region IDisposable o

		public void Dispose()
		{
			throw new Exception("The method or operation is not implemented.");
		}

		#endregion
	}
	/// <summary>
	/// uEȔ̗ێNXł
	/// </summary>
	public class TravelLogEntry
	{
		const int S_OK = 0x0;
		private string title;
		private string url;

		public TravelLogEntry(ITravelLogEntry iTravLog)
		{
			IntPtr titleptr = IntPtr.Zero;
			IntPtr urlptr = IntPtr.Zero;
			if(iTravLog.GetTitle(out titleptr) == S_OK)
			{
				this.title = Marshal.PtrToStringUni(titleptr);
			}
			if(iTravLog.GetURL(out urlptr) == S_OK)
			{
				this.url = Marshal.PtrToStringUni(urlptr);
			}
		}
		public TravelLogEntry(string _title, string _url)
		{
			this.title = _title;
			this.url = _url;
		}

		public string Title
		{
			get { return this.title; }
			set { this.title = value; }
		}
		public string Url
		{
			get { return this.url; }
			set { this.url = value; }
		}
		public override string ToString()
		{
			return string.Format("{0}({1})", this.title, this.url);
		}
	}


	/// <summary>
	/// ExHtmlHistory痚擾Ƃ̎擾̕@w肵܂
	/// </summary>
	public enum TLENUMF : int
	{
		/// <summary>
		/// ɂ݂͌̃y[W܂݂܂BORłق̃tOƌĎgp܂
		/// </summary>
		TLEF_RELATIVE_INCLUDE_CURRENT = 0x1,
		/// <summary>
		/// u߂vɗ擾܂
		/// </summary>
		TLEF_RELATIVE_BACK = 0x10,
		/// <summary>
		/// uiށvɗ擾܂
		/// </summary>
		TLEF_RELATIVE_FORE = 0x20,
		/// <summary>
		/// ȗ܂݂܂iHj
		/// </summary>
		TLEF_INCLUDE_UNINVOKEABLE = 0x40,
		/// <summary>
		/// ׂĂ̗擾܂B
		/// iINCLUDE_CURRENT | RELATIVE_BACK | RELAVIVE_FOREj ɓłB
		/// </summary>
		TLEF_ABSOLUTE = 0x31,
	}

	#endregion


	#region Security Managemant

	/// <summary>
	/// InternetSecurityManagerɂċANV\܂
	/// rbgtB[h^̃tOł
	/// </summary>
	public enum SecurityFlags : uint
	{
		/// <summary>
		/// Script,JAVA,ActiveX̃ANV͖ɂȂ܂
		/// </summary>
		None		= 0x00000000,
		/// <summary>
		/// Script̎s܂
		/// </summary>
		Script		= 0x00000FFF,
		/// <summary>
		/// JAVA̎s܂
		/// </summary>
		JAVA		= 0x0000F000,
		/// <summary>
		/// ActiveXvOC̎s܂
		/// </summary>
		AxExecute	= 0x00FF0000,
		/// <summary>
		/// ActiveXvOC̃_E[h܂
		/// </summary>
		AxDownload	= 0x0F000000,
	}

	public class InternetSecurityManager
		: IInternetSecurityManager,
		IServiceProviderForIISM
	{
		private SecurityFlags[] _security;
		public SecurityFlags SecurityFlags
		{
			get { return this._security[0]; }
			set { this._security[0] = value; }
		}
		public SecurityFlags SecurityFlagsZoneA
		{
			get { return this._security[1]; }
			set { this._security[1] = value; }
		}
		public SecurityFlags SecurityFragsZoneB
		{
			get { return this._security[2]; }
			set { this._security[2] = value; }
		}

		private List<string> matchA;
		private List<string> matchB;

		public InternetSecurityManager(WebBrowser browser)
		{
			this._security = new SecurityFlags[]{ SecurityFlags.None, SecurityFlags.None, SecurityFlags.None};
			this.matchA = new List<string>();
			this.matchB = new List<string>();

			IServiceProvider pISP = browser.ActiveXInstance as IServiceProvider;

			object obj = null;
			pISP.QueryService(ref ComDefines.SID_SProfferService, ref ComDefines.IID_IProfferService, out obj);
			IProfferService IProf = obj as IProfferService;
			int cookie = 0;
			IProf.ProfferService(ref ComDefines.IID_IInternetSecurityManager, this as IServiceProviderForIISM, ref cookie);
		}

		#region IInternetSecurityManager o

		int IInternetSecurityManager.SetSecuritySite(IInternetSecurityMgrSite pSite)
		{
			return ComDefines.INET_E_DEFAULT_ACTION;
		}

		int IInternetSecurityManager.GetSecuritySite(IInternetSecurityMgrSite pSite)
		{
			return ComDefines.INET_E_DEFAULT_ACTION;
		}

		int IInternetSecurityManager.MapUrlToZone(string pwszUrl, out int pdwZone, int dwFlags)
		{
			pdwZone = 0;
			return ComDefines.INET_E_DEFAULT_ACTION;
		}

		int IInternetSecurityManager.GetSecurityId(string pwszUrl, byte[] pbSecurityId, ref uint pcbSecurityId, uint dwReserved)
		{
			return ComDefines.INET_E_DEFAULT_ACTION;
		}

		int IInternetSecurityManager.ProcessUrlAction(string pwszUrl, int dwAction, out byte pPolicy, int cbPolicy, byte pContext, int cbContext, int dwFlags, int dwReserved)
		{
			Trace.WriteLine(String.Format("{0} : {1:x}", pwszUrl, dwAction));
			pPolicy = 0; int key = 0;
			for(int i = 0; i < this.matchA.Count; ++i)
			{
				if(Regex.IsMatch(pwszUrl, this.matchA[i], RegexOptions.IgnoreCase | RegexOptions.Singleline))
				{
					key = 1; break;
				}
			}
			for(int i = 0; i < this.matchB.Count; ++i)
			{
				if(Regex.IsMatch(pwszUrl, this.matchB[i], RegexOptions.IgnoreCase | RegexOptions.Singleline))
				{
					key = 2; break;
				}
			}
			if(URLACTION.SCRIPT_MIN <= dwAction && dwAction <= URLACTION.SCRIPT_MAX)
			{
				if((this._security[key] & SecurityFlags.Script) == SecurityFlags.Script)
				{
					pPolicy = URLPOLYCY.ALLOW;
					return ComDefines.S_OK;
				}
				else
				{
					pPolicy = URLPOLYCY.DISALLOW;
					return ComDefines.S_OK;
				}
			}
			else if(URLACTION.JAVA_MIN <= dwAction && dwAction <= URLACTION.JAVA_MAX)
			{
				if((this._security[key] & SecurityFlags.JAVA) == SecurityFlags.JAVA)
				{
					pPolicy = URLPOLYCY.ALLOW;
					return ComDefines.S_OK;
				}
				else
				{
					pPolicy = URLPOLYCY.DISALLOW;
					return ComDefines.S_OK;
				}
			}
			else if(URLACTION.ACTIVEX_RUN == dwAction)
			{
				if((this._security[key] & SecurityFlags.AxExecute) == SecurityFlags.AxExecute)
				{
					pPolicy = URLPOLYCY.ALLOW;
					return ComDefines.S_OK;
				}
				else
				{
					pPolicy = URLPOLYCY.DISALLOW;
					return ComDefines.S_OK;
				}
			}
			else if(dwAction == URLACTION.DOWNLOAD_UNSIGNED_ACTIVEX || dwAction == URLACTION.DOWNLOAD_SIGNED_ACTIVEX)
			{
				if((this._security[key] & SecurityFlags.AxDownload) == SecurityFlags.AxDownload)
				{
					pPolicy = URLPOLYCY.ALLOW;
					return ComDefines.S_OK;
				}
				else
				{
					pPolicy = URLPOLYCY.DISALLOW;
					return ComDefines.S_OK;
				}
			}
			if(dwAction == URLACTION.BEHAVIOR_RUN)
			{
				pPolicy = URLPOLYCY.DISALLOW;
				return ComDefines.S_OK;
			}
			return ComDefines.INET_E_DEFAULT_ACTION;
		}

		int IInternetSecurityManager.QueryCustomPolicy(string pwszUrl, ref Guid guidKey, byte ppPolicy, int pcbPolicy, byte pContext, int cbContext, int dwReserved)
		{
			return ComDefines.INET_E_DEFAULT_ACTION;
		}

		int IInternetSecurityManager.SetZoneMapping(int dwZone, string lpszPattern, int dwFlags)
		{
			return ComDefines.INET_E_DEFAULT_ACTION;
		}

		int IInternetSecurityManager.GetZoneMappings(int dwZone, out System.Runtime.InteropServices.ComTypes.IEnumString ppenumString, int dwFlags)
		{
			ppenumString = null;
			return ComDefines.INET_E_DEFAULT_ACTION;
		}

		#endregion

		#region IServiceProviderForIISM o
		
		int IServiceProviderForIISM.QueryService(ref Guid guidService, ref Guid riid, out IInternetSecurityManager ppvObject)
		{
			ppvObject = null;
			if(guidService == ComDefines.IID_IInternetSecurityManager)
			{
				ppvObject = this as IInternetSecurityManager;
				return ComDefines.S_OK;
			}
			return ComDefines.E_NOINTERFACE;
		}
		
		#endregion

	}

	#endregion




}
