using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using NicoNico.Collections;

namespace FavoriteManage
{
		internal partial class AddItemDialog : Form
		{
			FavoriteTreeView _fowner;
			OrderedDictionary<long, FavoriteFolder> folders;

			public AddItemDialog(FavoriteTreeView owner)
			{
				this._fowner = owner;
				InitializeComponent();
			}

			~AddItemDialog()
			{
			}


			internal ImageList ImageListOnTree
			{
				get { return this.treeTarget.ImageList; }
				set { this.treeTarget.ImageList = value; }
			}

			public DialogResult ShowDialog(IWin32Window owner, OrderedDictionary<long, FavoriteItem> collection)
			{
				this.constructTreeOnlyFolder(collection);
				DialogResult d = this.ShowDialog(owner);
				return d;
			}

			private void constructTreeOnlyFolder(OrderedDictionary<long, FavoriteItem> collection)
			{
				this.treeTarget.Nodes.Clear();
				lock(_fowner)
				{
					Stack<TreeNode> stack = new Stack<TreeNode>();
					TreeNode parent = null;
					TreeNode node = null;
					this.folders = new OrderedDictionary<long, FavoriteFolder>();

					foreach(KeyValuePair<long, FavoriteItem> pair in collection)
					{
						if(pair.Value.IsFolder)
						{
							if(pair.Value.ParentKey == 0) // [gvf
							{
								stack.Clear();
								node = this.createNodeFromItem(pair.Value);
								this.treeTarget.Nodes.Add(node);
							}
							else if(pair.Value.ParentKey == (long)parent.Tag) // ŌɒǉFoldere
							{
								node = this.createNodeFromItem(pair.Value);
								parent.Nodes.Add(node);
							}
							else
							{
								while(stack.Count > 0)
								{
									parent = stack.Pop();
									if(pair.Value.ParentKey == (long)parent.Tag)
									{
										node = this.createNodeFromItem(pair.Value);
										parent.Nodes.Add(node);
										break;
									}
								}
							}
							parent = node;
								stack.Push(parent);
							this.folders.Add(pair.Key, pair.Value as FavoriteFolder);
						}
					}

					this.treeTarget.ExpandAll();
				}
			}

			private TreeNode createNodeFromItem(FavoriteItem item)
			{
				TreeNode tn = new TreeNode();
				tn.Text = item.Title;
				tn.Tag = (object)item.AccessKey;
				if(item.IsFolder)
				{
					tn.ImageIndex = FavoriteTreeView.IMAGE_INDEX_FOLDERCLOSED;
					tn.SelectedImageIndex = FavoriteTreeView.IMAGE_INDEX_FOLDERCLOSED;
					tn.Name = FavoriteTreeView.KEY_HEADER_FOLDER + item.AccessKey.ToString();
					if(item.Comment == String.Empty)
					{
						tn.ToolTipText = item.Title;
					}
					else
					{
						tn.ToolTipText = item.Comment;
					}
				}
				else if(item.Type == FavoriteItemType.Page)
				{
					tn.ImageIndex = FavoriteTreeView.IMAGE_INDEX_PAGE;
					tn.SelectedImageIndex = FavoriteTreeView.IMAGE_INDEX_PAGE;
					tn.Name = FavoriteTreeView.KEY_HEADER_PAGE + item.AccessKey.ToString();
					if(item.Comment == String.Empty)
					{
						tn.ToolTipText = item.Title + "\n" + (item as FavoritePage).Url;
					}
					else
					{
						tn.ToolTipText = item.Comment;
					}
				}
				// createNodeł́ANodeFavoriteItem̊֘At͍s킸A
				// FavoriteItemɂ́AFavoriteTreeViewTreeNodeւ̎QƂc܂B
				return tn;
			}

			public bool IsForFolder
			{
				get { return !this.txtUrl.Enabled; }
				set { this.txtUrl.Enabled = !value; }
			}
			public string TitleText
			{
				get { return this.txtTitle.Text; }
				set { this.txtTitle.Text = value; }
			}
			public string UrlText
			{
				get { return this.txtUrl.Text; }
				set { this.txtUrl.Text = value; }
			}
			public string CommentText
			{
				get { return this.txtComment.Text; }
				set { this.txtComment.Text = value; }
			}
			public FavoriteFolder Selected
			{
				get
				{
					if(this.treeTarget.SelectedNode != null)
					{
						return this.folders[(long)this.treeTarget.SelectedNode.Tag];
					}
					else { return null; }
				}
			}

			private void btnCreateFolder_Click(object sender, EventArgs e)
			{
				string title = "NewFolder";
				TreeNode target = null;
				TreeNode newNode = null;
				TextDialog tDialog = new TextDialog();
				tDialog.Value = title;

				if(tDialog.ShowDialog(this) == DialogResult.OK)
				{
					title = tDialog.Value;
					FavoriteFolder folder;
					if(this.treeTarget.SelectedNode != null)
					{
						folder = this.folders[(long)this.treeTarget.SelectedNode.Tag];
						target = folder.RelationNode;
					}
					// C̃c[ւ̒ǉ
					folder = this._fowner.FvAddFolder(title, "", target) as FavoriteFolder;
					// _CAÕc[p̃m[h쐬
					newNode = this.createNodeFromItem(folder);
					if(target != null)
					{
						this.treeTarget.SelectedNode.Nodes.Add(newNode);
						this.treeTarget.SelectedNode.Expand();
					}
					else
					{
						this.treeTarget.Nodes.Add(newNode);
						this.treeTarget.ExpandAll();
					}
					this.folders.Add(folder.AccessKey, folder);
				}

				tDialog.Dispose();
			}


			#region Accept 

			private void accept_Dialog()
			{
				if(this.txtTitle.Text.Length > 0)
				{
					if(!this.txtUrl.Enabled || this.txtUrl.Text.Length > 0)
					{
						this.DialogResult = DialogResult.OK;
					}
					else
					{
						MessageBox.Show("URLɂ邱Ƃ͂ł܂");
					}
				}
				else
				{
					MessageBox.Show("^Cgɂ邱Ƃ͂ł܂");
				}
			}

			private void Accept_on_EnterKeyDown(object sender, KeyEventArgs e)
			{
				if(e.KeyCode == Keys.Enter)
				{
					this.accept_Dialog();
				}
			}

			private void btnOK_Click(object sender, EventArgs e)
			{
				this.accept_Dialog();
			}

			#endregion

		}


}