using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using NicoNico.Collections;
using System.IO;
using System.Xml.Serialization;
using System.Xml;
namespace FavoriteManage
{
	/// <summary>
	/// CɓǗgꂽTreeViewRg[񋟂܂
	/// </summary>
	public class FavoriteTreeView : TreeView
	{
		#region 萔o

		/// <summary>
		/// y[W\ACR̃CfbNX
		/// </summary>
		public const int IMAGE_INDEX_PAGE = 0;
		/// <summary>
		/// tH_iClosedj\ACR̃CfbNX
		/// </summary>
		public const int IMAGE_INDEX_FOLDERCLOSED = 1;
		/// <summary>
		/// tH_iOpenedj\ACR̃CfbNX
		/// </summary>
		public const int IMAGE_INDEX_FOLDEROPENED = 2;
		/// <summary>
		/// TreeNodeNamevpeBŁAړID𕪂̂Ɏgp镶 '_'
		/// </summary>
		/// 
		public const char NAME_KEY_SEPARATOR = '_';
		/// <summary>
		/// TreeNodeNamevpeBŎgpړBy[W\
		/// </summary>
		public static string KEY_HEADER_PAGE { get { return "FVP_"; } }
		/// <summary>
		/// TreeNodeNamevpeBŎgpړBtH_\
		/// </summary>
		public static string KEY_HEADER_FOLDER { get { return "FVF_"; } }

		#endregion


		/// <summary>
		/// CɓRNV
		/// Keyɂ͒ǉԂTicksgp܂B
		/// </summary>
		OrderedDictionary<long, FavoriteItem> favorites;

		/// <summary>
		/// ̃NX̃CX^X쐬܂B
		/// </summary>
		public FavoriteTreeView()
		{
			this.favorites = new OrderedDictionary<long, FavoriteItem>();
			this.InitializeComponent();
		}


		#region J\bh iFv` : {͂̃\bhQǂj

		/// <summary>
		/// VtH_m[hǉARNVɊ֘At܂B
		/// ̑Œǉm[h͎qƂł܂AURLƂ͏o܂B
		/// </summary>
		/// <param name="title">\^Cg</param>
		/// <param name="comment">֘AtRg</param>
		/// <param name="target">Vm[h󂯓em[hBnullnƃ[gɒǉ܂</param>
		public FavoriteItem FvAddFolder(string title, string comment, TreeNode target)
		{
			long key = DateTime.Now.Ticks;
			FavoriteFolder fold = new FavoriteFolder(key, title);
			fold.Comment = comment;

			if(target != null)
			{
				if(!this.favorites[(long)target.Tag].IsFolder)
				{
					target = target.Parent;
				}
				if(target == null)
				{
					fold.ParentFullPath = String.Empty;
					fold.Index = this.Nodes.Count;
				}
				else
				{
					fold.ParentFullPath = target.FullPath;
					fold.Index = target.Nodes.Count;
				}
			}
			else
			{
				fold.ParentFullPath = String.Empty;
				fold.Index = this.Nodes.Count;
			}

			TreeNode node = this.createNodeFromItem(fold);

			this.favorites.Add(key, fold);
			if(target == null)
			{
				this.Nodes.Add(node);
				fold.ParentKey = 0L;
			}
			else
			{
				target.Nodes.Add(node);
				fold.ParentKey = (long)target.Tag;
				target.Expand();
			}
			return fold;
		}
		/// <summary>
		/// VtH_m[hǉARNVɊ֘At܂Bǉe̓_CAOŕύXł܂B
		/// ̑Œǉm[h͎qƂł܂AURLƂ͏o܂B
		/// </summary>
		/// <param name="title">\^Cg</param>
		/// <param name="comment">֘AtRg</param>
		public FavoriteItem FvAddFolder(string title, string comment)
		{
			AddItemDialog aDialog = new AddItemDialog(this);
			aDialog.IsForFolder = true;
			aDialog.TitleText = title;
			aDialog.CommentText = comment;
			FavoriteItem item = null;
			if(aDialog.ShowDialog(this, this.favorites) == DialogResult.OK)
			{
				if(aDialog.TitleText.Length == 0)
				{
					MessageBox.Show("^Cgɂ邱Ƃ͏o܂B");
				}
				else
				{
					FavoriteFolder folder = aDialog.Selected;
					TreeNode tn = folder != null ? folder.RelationNode : null;
					item = this.FvAddFolder(aDialog.TitleText, aDialog.CommentText, tn);
				}
			}
			aDialog.Dispose();

			return item;
		}
		/// <summary>
		/// Vy[Wm[hǉARNVɊ֘At܂B
		/// ̑Œǉ͖̂[m[hŁAURLƂł܂qƂ͏o܂B
		/// </summary>
		/// <param name="title">\^Cg</param>
		/// <param name="url">֘AtURL</param>
		/// <param name="comment">֘AtRg</param>
		/// <param name="target">Vm[h󂯓em[hBnullnƃ[gɒǉ܂</param>
		public FavoriteItem FvAddItem(string title, string url, string comment, TreeNode target)
		{
			long key = DateTime.Now.Ticks;
			FavoritePage item = new FavoritePage(key,title, url);
			item.Comment = comment;

			if(target != null)
			{
				if(!this.favorites[(long)target.Tag].IsFolder)
				{
					target = target.Parent;
				}
				if(target == null)
				{
					item.ParentFullPath = String.Empty;
					item.Index = this.Nodes.Count;
				}
				else
				{
					item.ParentFullPath = target.FullPath;
					item.Index = target.Nodes.Count;
				}
			}
			else
			{
				item.ParentFullPath = String.Empty;
				item.Index = this.Nodes.Count;
			}

			TreeNode node = this.createNodeFromItem(item);

			this.favorites.Add(key, item);
			if(target == null)
			{
				this.Nodes.Add(node);
				item.ParentKey = 0L;
			}
			else
			{
				target.Nodes.Add(node);
				item.ParentKey = (long)target.Tag;
				target.Expand();
			}
			return item;
		}
		/// <summary>
		/// Vy[Wm[hǉARNVɊ֘At܂Bǉe̓_CAOŕύXł܂B
		/// ̑Œǉ͖̂[m[hŁAURLƂł܂qƂ͏o܂B
		/// </summary>
		/// <param name="title">\^Cg</param>
		/// <param name="url">֘AtURL</param>
		/// <param name="comment">֘AtRg</param>
		public FavoriteItem FvAddItem(string title, string url, string comment)
		{
			AddItemDialog aDialog = new AddItemDialog(this);
			aDialog.IsForFolder = false;
			aDialog.TitleText = title;
			aDialog.UrlText = url;
			aDialog.CommentText = comment;
			FavoriteItem item = null;
			if(aDialog.ShowDialog(this, this.favorites) == DialogResult.OK)
			{
				if(aDialog.UrlText.Length == 0 || aDialog.TitleText.Length == 0)
				{
					MessageBox.Show("eɂ邱Ƃ͏o܂");
				}
				else
				{
					FavoriteFolder folder = aDialog.Selected;
					TreeNode tn = folder != null ? folder.RelationNode : null;
					item = this.FvAddItem(aDialog.TitleText, aDialog.UrlText, aDialog.CommentText, tn);
				}
			}
			aDialog.Dispose();
			return item;
		}
		/// <summary>
		/// w肵m[hƊ֘Atꂽvf菜܂B
		/// </summary>
		/// <param name="tn">菜m[h</param>
		/// <returns>Ήvf݂Ȃfalse</returns>
		public bool FvRemoveItem(TreeNode tn)
		{
			if(this.favorites.Remove((long)tn.Tag))
			{

				if(tn.Nodes.Count != 0)
				{
					foreach(TreeNode tnc in tn.Nodes)
					{
						this.FvRemoveItem(tnc);
					}
				}
				TreeNodeCollection parc;
				if(tn.Parent == null)
				{
					parc = this.Nodes;
				}
				else
				{
					parc = tn.Parent.Nodes;
				}
				this.Nodes.Remove(tn);
				foreach(TreeNode tnode in parc)
				{
					this.syncNodePositionChange(tnode);
				}
				return true;
			}
			return false;
		}
		/// <summary>
		/// w肵m[hɑ΂ėvf̕ҏWsAeRNVɓ܂B
		/// </summary>
		/// <param name="tn">ҏWm[h</param>
		/// <param name="title">V\^Cg</param>
		/// <param name="url">V֘AtURL(Foldervfɑ΂Ă͖܂)</param>
		/// <param name="comment">V֘AtRg</param>
		/// <returns></returns>
		public bool FvEditItem(TreeNode tn, string title, string url, string comment)
		{
			FavoriteItem item = this.favorites[(long)tn.Tag];
			item.Title = title;
			if(!item.IsFolder)
			{
				(item as FavoritePage).Url = url;
			}
			item.Comment = comment;

			tn.Text = item.Title;
			if(item.Comment != string.Empty)
			{
				tn.ToolTipText = item.Comment;
			}
			else
			{
				if(item.Type == FavoriteItemType.Page)
				{
					tn.ToolTipText = item.Title + "\n" + (item as FavoritePage).Url;
				}
				else
				{
					tn.ToolTipText = item.Title;
				}
			}
			return true;
		}
		/// <summary>
		/// _CAO\čڂ̕ҏWs܂B
		/// </summary>
		/// <param name="tn">ҏWΏۂ̃m[h</param>
		/// <returns></returns>
		public bool FvEditItem(TreeNode tn)
		{
			FavoriteItem item = this.favorites[(long)tn.Tag];
			if(item != null)
			{
				EditDialog eDialog = new EditDialog();
				eDialog.IsForFolder = item.IsFolder;
				if(item.Type == FavoriteItemType.Page)
				{
					eDialog.UrlText = (item as FavoritePage).Url;
				}
				else { eDialog.UrlText = ""; }
				eDialog.TitleText = item.Title;
				eDialog.CommentText = item.Comment;
				if(eDialog.ShowDialog(this) == DialogResult.OK)
				{
					if(eDialog.UrlText.Length == 0 || eDialog.TitleText.Length == 0)
					{
						MessageBox.Show("eɂ邱Ƃ͏o܂");
					}
					else
					{
						this.FvEditItem(tn, eDialog.TitleText, eDialog.UrlText, eDialog.CommentText);
					}
				}
				return true;
			}
			return false;
		}

		/// <summary>
		/// w肵m[hɊ֘AtꂽCɓACe擾܂
		/// </summary>
		/// <param name="tn">擾ΏۂƂȂm[h</param>
		/// <returns>֘Atꂽm[h</returns>
		public FavoriteItem FvGetItem(TreeNode tn)
		{
			FavoriteItem f = this.favorites[(long)tn.Tag];
			return f;
		}

		/// <summary>
		/// Cɓt@Cɕۑ܂
		/// t@C݂Ƃ͏㏑܂
		/// </summary>
		/// <param name="savepath">ۑt@C̃pX</param>
		/// <returns>true</returns>
		public bool FvSaveFavorite(string savepath)
		{
			//this.favorites.Sort();
			this.recreateForSave();
			if(!Path.IsPathRooted(savepath))
			{
				throw new ArgumentException("̃pX͖ł");
			}

			string xml;
			using(StringWriter writer = new StringWriter())
			{
				XmlSerializer serializer = new XmlSerializer(this.favorites.GetType());
				serializer.Serialize(writer, this.favorites);
				xml = writer.ToString();
			}
			byte[] binary = Encoding.Unicode.GetBytes(xml);
			using(System.IO.FileStream fs = new System.IO.FileStream(savepath, System.IO.FileMode.Create, System.IO.FileAccess.Write))
			{
				using(BinaryWriter writer = new BinaryWriter(fs, Encoding.Unicode))
				{
					writer.Write(binary);
				}
			}
			return true;
		}
		/// <summary>
		/// Cɓt@Cǂݍ݂܂
		/// </summary>
		/// <param name="filepath">ǂݍރt@C̃pX</param>
		/// <returns>true</returns>
		public bool FvLoadFavorite(string filepath)
		{
			string xml = string.Empty;
			byte[] binary;

			using(FileStream file = new FileStream(filepath, FileMode.Open, FileAccess.Read))
			{
				using(BinaryReader reader = new BinaryReader(file, Encoding.Unicode))
				{
					binary = reader.ReadBytes((int)file.Length);
				}
			}
			xml = Encoding.Unicode.GetString(binary);
			OrderedDictionary<long, FavoriteItem> fav = null;
			try
			{
				XmlSerializer serializer = new XmlSerializer(this.favorites.GetType());
				using(StringReader reader = new StringReader(xml))
				{
					fav = (OrderedDictionary<long, FavoriteItem>)serializer.Deserialize(reader);
				}
			}
			catch(IOException e)
			{
				MessageBox.Show("t@C̓ǂݍ݂Ɏs܂\n" + e.Message);
				return false;
			}
			catch(Exception e)
			{
				MessageBox.Show("ǂݍݒɈُm܂\n" + e.Message);
				return false;
			}
			if(fav == null) return false;
			this.constructTree(fav);
			this.favorites = fav;
			return true;
		}

		#endregion

		#region JꂽEvent
		/// <summary>
		/// ̃Rg[uEUɑ΂āAy[Ẅړvɔ܂B
		/// </summary>
		public event EventHandler<UrlEventArgs> FvNavigateRequired;

		protected void OnFvNavigateRequired(string url, bool newWindow)
		{
			if(FvNavigateRequired != null)
			{
				FvNavigateRequired(this, new UrlEventArgs(url, newWindow));
			}
		}

		#endregion

		#region Override / NbNƂ

		protected override void OnMouseDown(MouseEventArgs e)
		{
			if(e.Button == MouseButtons.Middle)
			{
				TreeNode tn = this.GetNodeAt(e.Location);
				if(tn != null && !tn.Bounds.Contains(e.Location))
				{
					tn = null;
				}
				if(tn != null)
				{
					FavoriteItem fav = this.favorites[(long)tn.Tag];
					if(!fav.IsFolder)
					{
						this.OnFvNavigateRequired((fav as FavoritePage).Url, true);
					}
				}
			}
			base.OnMouseDown(e);
		}
		protected override void OnMouseClick(MouseEventArgs e)
		{
			TreeNode tn = this.GetNodeAt(e.Location);
			if(tn != null && !tn.Bounds.Contains(e.Location))
			{
				tn = null;
			}
			if(tn != null)
			{
				FavoriteItem fav;
				if(e.Button == MouseButtons.Left)
				{
					fav = this.favorites[(long)tn.Tag];
					if(!fav.IsFolder)
					{
						this.OnFvNavigateRequired((fav as FavoritePage).Url, false);
					}
				}
				else if(e.Button == MouseButtons.Right)
				{
				}
			}
			else
			{
				this.SelectedNode = null;
			}
			base.OnMouseClick(e);
		}
		protected override void OnMouseUp(MouseEventArgs e)
		{
			if(e.Button == MouseButtons.Right)
			{
				TreeNode tgt = this.GetNodeAt(e.Location);
				if(tgt != null && !tgt.Bounds.Contains(e.Location))
				{
					tgt = null;
				}
				if(tgt != null)
				{
					this.SelectedNode = tgt;
					this.ctxOnPage.Items.Clear();
					if(tgt.ImageIndex == 0) // IsFolderȗ
					{
						this.ctxOnPage.Items.Add(this.tsmiOnItem_Open);
						this.ctxOnPage.Items.Add(this.tsmiOnItem_OpenNew);
						this.ctxOnPage.Items.Add(this.toolStripSeparator1);
						this.ctxOnPage.Items.Add(this.tsmiOnItem_CreateFolder);
						this.ctxOnPage.Items.Add(this.toolStripSeparator2);
						this.ctxOnPage.Items.Add(this.tsmiOnItem_Edit);
						this.ctxOnPage.Items.Add(this.tsmiOnItem_Delete);

						this.ctxOnPage.Tag = (object)tgt;
						this.ctxOnPage.Show(this, e.Location);
					}
					else
					{
						this.ctxOnPage.Items.Add(this.tsmiOnItem_CreateFolder);
						this.ctxOnPage.Items.Add(this.toolStripSeparator2);
						this.ctxOnPage.Items.Add(this.tsmiOnItem_Edit);
						this.ctxOnPage.Items.Add(this.tsmiOnItem_Delete);

						this.ctxOnPage.Tag = (object)tgt;
						this.ctxOnPage.Show(this, e.Location);
					}
				}
				else
				{
					this.ctxMain.Show(this, e.Location);
				}
			}
			base.OnMouseUp(e);
		}

		#endregion

		#region Override / hbOhbv

		protected override void OnDragEnter(DragEventArgs e)
		{
			base.OnDragEnter(e);
		}
		protected override void OnItemDrag(ItemDragEventArgs e)
		{
			this.SelectedNode = (TreeNode)e.Item;
			this.Focus();
			DragDropEffects dde = this.DoDragDrop(e.Item, DragDropEffects.All);
			if((dde & DragDropEffects.Move) == DragDropEffects.Move)
			{
				this.Nodes.Remove((TreeNode)e.Item);
			}
			base.OnItemDrag(e);
		}
		protected override void OnDragOver(DragEventArgs e)
		{
			if(e.Data.GetDataPresent(typeof(TreeNode)))
			{
				if((e.KeyState & 8) == 8 && ((e.AllowedEffect & DragDropEffects.Copy) == DragDropEffects.Copy))
				{
					e.Effect = DragDropEffects.Copy;
				}
				else if((e.AllowedEffect & DragDropEffects.Move) == DragDropEffects.Move)
				{
					e.Effect = DragDropEffects.Move;
				}
				else
				{
					e.Effect = DragDropEffects.None;
				}
			}
			else
			{
				e.Effect = DragDropEffects.None;
			}
			if(e.Effect != DragDropEffects.None)
			{
				Point mpt = this.PointToClient(new Point(e.X, e.Y));
				TreeNode target = this.GetNodeAt(mpt);
				if(target != null && !target.Bounds.Contains(mpt))
				{
					target = null;
				}
				TreeNode source = (TreeNode)e.Data.GetData(typeof(TreeNode));
				if(target != null && target != source && !isChildNode(source, target))
				{
					if(target.IsSelected == false) this.SelectedNode = target;
				}
				else { e.Effect = DragDropEffects.None; }
			}
			base.OnDragOver(e);
		}
		protected override void OnDragDrop(DragEventArgs e)
		{
			if(e.Data.GetDataPresent(typeof(TreeNode)))
			{
				Point mpt = this.PointToClient(new Point(e.X, e.Y));
				TreeNode source = (TreeNode)e.Data.GetData(typeof(TreeNode));
				TreeNode target = this.GetNodeAt(mpt);
				if(target != null && !target.Bounds.Contains(mpt))
				{
					target = null;
				}
				if(target != null && target != source && !isChildNode(source, target))
				{
					TreeNodeCollection scollection;
					TreeNodeCollection tcollection;
					if(source.Parent != null) { scollection = source.Parent.Nodes; }
					else { scollection = this.Nodes; }

					TreeNode clone = (TreeNode)source.Clone();
					if(target.ImageIndex != IMAGE_INDEX_PAGE) // ^[QbgtH_ł邱Ƃ`FbN
					{
						scollection.Remove(source);
						target.Nodes.Add(clone);
						foreach(TreeNode tn in target.Nodes)
						{
							this.syncNodePositionChange(tn);
						}
						if(scollection != target.Nodes)
						{
							foreach(TreeNode tn in scollection)
							{
								this.syncNodePositionChange(tn);
							}
						}
					}
					else
					{
						if(target.Parent != null)
						{
							tcollection = target.Parent.Nodes;
						}
						else
						{
							tcollection = this.Nodes;
						}
						int index = tcollection.IndexOf(target);
						scollection.Remove(source);
						tcollection.Insert(index, clone);
						foreach(TreeNode tn in tcollection)
						{
							this.syncNodePositionChange(tn);
						}
						if(scollection != tcollection)
						{
							foreach(TreeNode tn in scollection)
							{
								this.syncNodePositionChange(tn);
							}
						}
					}
					target.Expand();
					this.SelectedNode = clone;
				}
				else { e.Effect = DragDropEffects.None; }
			}
			else { e.Effect = DragDropEffects.None; }
			base.OnDragDrop(e);
		}

		#endregion


		#region Ƃ

		/// <summary>
		/// w肵KeyƂCɓf[^AVTreeNodẽCX^X쐬܂B
		/// ParentKeyParentFullPathiTreeł̈ʒuɈˑ鍀ځj͍Č܂B
		/// </summary>
		/// <param name="key">RNVŊ֘AtKey</param>
		/// <param name="item">RNVŁAw肵keyɊ֘Atꂽvf</param>
		/// <returns>쐬ꂽCX^XB</returns>
		private TreeNode createNodeFromItem(FavoriteItem item)
		{
			TreeNode tn = new TreeNode();
			tn.Text = item.Title;
			tn.Tag = (object)item.AccessKey;
			if(item.IsFolder)
			{
				tn.ImageIndex = IMAGE_INDEX_FOLDERCLOSED;
				tn.SelectedImageIndex = IMAGE_INDEX_FOLDERCLOSED;
				tn.Name = KEY_HEADER_FOLDER + item.AccessKey.ToString();
				if(item.Comment == String.Empty)
				{
					tn.ToolTipText = item.Title;
				}
				else
				{
					tn.ToolTipText = item.Comment;
				}
				if((item as FavoriteFolder).IsExpanded)
				{
					tn.Expand();
				}
			}
			else if(item.Type == FavoriteItemType.Page)
			{
				tn.ImageIndex = IMAGE_INDEX_PAGE;
				tn.SelectedImageIndex = IMAGE_INDEX_PAGE;
				tn.Name = KEY_HEADER_PAGE + item.AccessKey.ToString();
				if(item.Comment == String.Empty)
				{
					tn.ToolTipText = item.Title + "\n" + (item as FavoritePage).Url;
				}
				else
				{
					tn.ToolTipText = item.Comment;
				}
			}
			item.RelationNode = tn;
			return tn;
		}
		/// <summary>
		/// m[ḧʒuςƂɌĂяoARNVƓ܂B
		/// RNV̊evfɑ΂čsKv܂
		/// </summary>
		/// <param name="node">m[h</param>
		private void syncNodePositionChange(TreeNode node)
		{
			FavoriteItem item = favorites[(long)node.Tag];
			item.Index = node.Index;
			TreeNode par = node.Parent;
			if(par == null)
			{
				item.ParentKey = 0L;
				item.ParentFullPath = String.Empty;
			}
			else
			{
				item.ParentKey = (long)par.Tag;
				item.ParentFullPath = par.FullPath;
			}
		}
		/// <summary>
		/// 󂯎RNVc[gݗĂēǂݍ݂܂
		/// </summary>
		/// <param name="collection">gݗĂ錳ɂȂRNV</param>
		/// <returns>true</returns>
		/// <remarks>̃\bh󂯎RNVł́Ac[ŐeɂvfA
		/// ̎qɂvfɏoKv܂B</remarks>
		private bool constructTree(OrderedDictionary<long, FavoriteItem> collection)
		{
			this.Nodes.Clear();
			TreeNode parent = null; // ŌɒǉFolder
			TreeNode node = null; // ŌɒǉPage
			Stack<TreeNode> stack = new Stack<TreeNode>();
			foreach(KeyValuePair<long, FavoriteItem> pair in collection)
			{
				if(pair.Value.ParentKey == 0) // [gvf
				{
					stack.Clear();
					node = this.createNodeFromItem(pair.Value);
					this.Nodes.Add(node);
				}
				else if(pair.Value.ParentKey == (long)parent.Tag) // ŌɒǉFoldere
				{
					node = this.createNodeFromItem(pair.Value);
					parent.Nodes.Add(node);
				}
				else // ȊOic[kĐeTꍇj
				{
					while(stack.Count > 0)
					{
						parent = stack.Pop();
						if(pair.Value.ParentKey == (long)parent.Tag)
						{
							node = this.createNodeFromItem(pair.Value);
							parent.Nodes.Add(node);
							break;
						}
					}
				}

				if(pair.Value.IsFolder)
				{
					stack.Push(parent);
					parent = node;
				}
			}
			
			return true;
		}

		/// <summary>
		/// ۑ`ɓK悤ɁARNVč\z܂B
		/// </summary>
		/// <returns></returns>
		private bool recreateForSave()
		{
			OrderedDictionary<long, FavoriteItem> collection;
			try
			{
				collection = new OrderedDictionary<long, FavoriteItem>(this.favorites.Count);
				this.make(collection, this.Nodes);
			}
			catch(Exception e)
			{
				MessageBox.Show(e.Message);
				return false;
			}
			this.favorites = collection;
			return true;
		}
		/// <summary>
		/// nc[A[DŒTARNVɒǉ܂
		/// </summary>
		/// <param name="addTarget">\z̃RNV</param>
		/// <param name="source">Tc[</param>
		private void make(OrderedDictionary<long, FavoriteItem> addTarget, TreeNodeCollection source)
		{
			FavoriteItem item;
			foreach(TreeNode tn in source)
			{
				item = this.favorites[(long)tn.Tag];
				addTarget.Add(item.AccessKey ,item);
				if(item.IsFolder)
				{
					this.make(addTarget, tn.Nodes);
				}
			}
		}

		#endregion

		/// <summary>
		/// childAparent̎qm[hł邩𔻒B
		/// </summary>
		/// <param name="parent">cm[h</param>
		/// <param name="child">qm[h</param>
		/// <returns>qłtrue</returns>
		private static bool isChildNode(TreeNode parent, TreeNode child)
		{
			if(child.Parent == parent)
			{
				return true;
			}
			else if(child.Parent != null)
			{
				return isChildNode(parent, child.Parent);
			}
			else { return false; }
		}

		#region fUCi[֘Ão

		private ImageList imageList1;
		private ContextMenuStrip ctxMain;
		private ToolStripMenuItem tsmiMain_NewForlder;
		private ToolStripMenuItem tsmiMain_NewPage;
		private ContextMenuStrip ctxOnPage;
		private ToolStripMenuItem tsmiOnItem_Open;
		private ToolStripMenuItem tsmiOnItem_OpenNew;
		private ToolStripSeparator toolStripSeparator1;
		private ToolStripMenuItem tsmiOnItem_CreateFolder;
		private ToolStripMenuItem tsmiOnItem_Edit;
		private ToolStripMenuItem tsmiOnItem_Delete;
		private ToolStripSeparator toolStripSeparator2;
		private System.ComponentModel.IContainer components;
		/// <summary>
		/// fUCi[̃A
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FavoriteTreeView));
			this.imageList1 = new System.Windows.Forms.ImageList(this.components);
			this.ctxMain = new System.Windows.Forms.ContextMenuStrip(this.components);
			this.tsmiMain_NewForlder = new System.Windows.Forms.ToolStripMenuItem();
			this.tsmiMain_NewPage = new System.Windows.Forms.ToolStripMenuItem();
			this.ctxOnPage = new System.Windows.Forms.ContextMenuStrip(this.components);
			this.tsmiOnItem_Open = new System.Windows.Forms.ToolStripMenuItem();
			this.tsmiOnItem_OpenNew = new System.Windows.Forms.ToolStripMenuItem();
			this.toolStripSeparator1 = new System.Windows.Forms.ToolStripSeparator();
			this.tsmiOnItem_CreateFolder = new System.Windows.Forms.ToolStripMenuItem();
			this.toolStripSeparator2 = new System.Windows.Forms.ToolStripSeparator();
			this.tsmiOnItem_Edit = new System.Windows.Forms.ToolStripMenuItem();
			this.tsmiOnItem_Delete = new System.Windows.Forms.ToolStripMenuItem();
			this.ctxMain.SuspendLayout();
			this.ctxOnPage.SuspendLayout();
			this.SuspendLayout();
			// 
			// imageList1
			// 
			this.imageList1.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList1.ImageStream")));
			this.imageList1.TransparentColor = System.Drawing.Color.Magenta;
			this.imageList1.Images.SetKeyName(0, "NewDocument.bmp");
			this.imageList1.Images.SetKeyName(1, "FolderClosed.bmp");
			this.imageList1.Images.SetKeyName(2, "FolderOpen.bmp");
			// 
			// ctxMain
			// 
			this.ctxMain.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.tsmiMain_NewForlder,
            this.tsmiMain_NewPage});
			this.ctxMain.Name = "ctxMain";
			this.ctxMain.Size = new System.Drawing.Size(207, 48);
			this.ctxMain.ItemClicked += new System.Windows.Forms.ToolStripItemClickedEventHandler(this.ctxMain_ItemClicked);
			// 
			// tsmiMain_NewForlder
			// 
			this.tsmiMain_NewForlder.Name = "tsmiMain_NewForlder";
			this.tsmiMain_NewForlder.Size = new System.Drawing.Size(206, 22);
			this.tsmiMain_NewForlder.Text = "[gɐVtH_쐬";
			// 
			// tsmiMain_NewPage
			// 
			this.tsmiMain_NewPage.Name = "tsmiMain_NewPage";
			this.tsmiMain_NewPage.Size = new System.Drawing.Size(206, 22);
			this.tsmiMain_NewPage.Text = "[gɐVy[W쐬";
			// 
			// ctxOnPage
			// 
			this.ctxOnPage.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.tsmiOnItem_Open,
            this.tsmiOnItem_OpenNew,
            this.toolStripSeparator1,
            this.tsmiOnItem_CreateFolder,
            this.toolStripSeparator2,
            this.tsmiOnItem_Edit,
            this.tsmiOnItem_Delete});
			this.ctxOnPage.Name = "ctxOnItem";
			this.ctxOnPage.Size = new System.Drawing.Size(147, 126);
			this.ctxOnPage.ItemClicked += new System.Windows.Forms.ToolStripItemClickedEventHandler(this.ctxOnPage_ItemClicked);
			// 
			// tsmiOnItem_Open
			// 
			this.tsmiOnItem_Open.Name = "tsmiOnItem_Open";
			this.tsmiOnItem_Open.Size = new System.Drawing.Size(146, 22);
			this.tsmiOnItem_Open.Text = "J";
			// 
			// tsmiOnItem_OpenNew
			// 
			this.tsmiOnItem_OpenNew.Name = "tsmiOnItem_OpenNew";
			this.tsmiOnItem_OpenNew.Size = new System.Drawing.Size(146, 22);
			this.tsmiOnItem_OpenNew.Text = "V^uŊJ";
			// 
			// toolStripSeparator1
			// 
			this.toolStripSeparator1.Name = "toolStripSeparator1";
			this.toolStripSeparator1.Size = new System.Drawing.Size(143, 6);
			// 
			// tsmiOnItem_CreateFolder
			// 
			this.tsmiOnItem_CreateFolder.Name = "tsmiOnItem_CreateFolder";
			this.tsmiOnItem_CreateFolder.Size = new System.Drawing.Size(146, 22);
			this.tsmiOnItem_CreateFolder.Text = "tH_쐻";
			// 
			// toolStripSeparator2
			// 
			this.toolStripSeparator2.Name = "toolStripSeparator2";
			this.toolStripSeparator2.Size = new System.Drawing.Size(143, 6);
			// 
			// tsmiOnItem_Edit
			// 
			this.tsmiOnItem_Edit.Name = "tsmiOnItem_Edit";
			this.tsmiOnItem_Edit.Size = new System.Drawing.Size(146, 22);
			this.tsmiOnItem_Edit.Text = "ҏW";
			// 
			// tsmiOnItem_Delete
			// 
			this.tsmiOnItem_Delete.Name = "tsmiOnItem_Delete";
			this.tsmiOnItem_Delete.Size = new System.Drawing.Size(146, 22);
			this.tsmiOnItem_Delete.Text = "폜";
			// 
			// FavoriteTreeView
			// 
			this.AllowDrop = true;
			this.ContextMenuStrip = this.ctxMain;
			this.HideSelection = false;
			this.ImageIndex = 0;
			this.ImageList = this.imageList1;
			this.LineColor = System.Drawing.Color.Black;
			this.SelectedImageIndex = 0;
			this.ctxMain.ResumeLayout(false);
			this.ctxOnPage.ResumeLayout(false);
			this.ResumeLayout(false);

		}

		#endregion

		/// <summary>
		/// m[ĥȂʒuŕ\ReLXgj[̏
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void ctxMain_ItemClicked(object sender, ToolStripItemClickedEventArgs e)
		{
			if(e.ClickedItem == this.tsmiMain_NewForlder)
			{
				EditDialog eDialog = new EditDialog();
				eDialog.IsForFolder = true;
				eDialog.TitleText = "NewFolder";
				eDialog.CommentText = "";
				if(eDialog.ShowDialog(this)== DialogResult.OK)
				{
					if(eDialog.TitleText.Length == 0)
					{
						MessageBox.Show("eɂ邱Ƃ͏o܂");
					}
					else
					{
						this.FvAddFolder(eDialog.TitleText, eDialog.CommentText, null);
					}
				}
				eDialog.Dispose();
			}
			else if(e.ClickedItem == this.tsmiMain_NewPage)
			{
				EditDialog eDialog = new EditDialog();
				eDialog.IsForFolder = false;
				eDialog.TitleText = "NewPage";
				eDialog.UrlText = "http://www.nicovideo.jp/";
				eDialog.CommentText = "";
				if(eDialog.ShowDialog(this) == DialogResult.OK)
				{
					if(eDialog.UrlText.Length == 0 || eDialog.TitleText.Length == 0)
					{
						MessageBox.Show("eɂ邱Ƃ͏o܂");
					}
					else
					{
						this.FvAddItem(eDialog.TitleText, eDialog.UrlText, eDialog.CommentText, null);
					}
				}
				eDialog.Dispose();
			}
		}
		/// <summary>
		/// m[hŕ\ReLXgj[̏B
		/// ΏۂƂȂm[h̓ReLXgj[TagɊi[Ă܂
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void ctxOnPage_ItemClicked(object sender, ToolStripItemClickedEventArgs e)
		{
			TreeNode tn = this.ctxOnPage.Tag as TreeNode;
			if(e.ClickedItem == this.tsmiOnItem_Open)
			{
				if(tn != null)
				{
					FavoriteItem item = this.favorites[(long)tn.Tag];
					if(item.Type == FavoriteItemType.Page)
					{
						this.OnFvNavigateRequired((item as FavoritePage).Url, false);
					}
				}
			}
			else if(e.ClickedItem == this.tsmiOnItem_OpenNew)
			{
				FavoriteItem item = this.favorites[(long)tn.Tag];
				if(item.Type == FavoriteItemType.Page)
				{
					this.OnFvNavigateRequired((item as FavoritePage).Url, false);
				}
			}
			else if(e.ClickedItem == this.tsmiOnItem_CreateFolder)
			{
				if(tn != null)
				{
					this.FvAddFolder("NewFolder", "", tn);
				}
			}
			else if(e.ClickedItem == this.tsmiOnItem_Edit)
			{
				if(tn != null)
				{
					this.FvEditItem(tn);
				}
			}
			else if(e.ClickedItem == this.tsmiOnItem_Delete)
			{
				if(tn != null)
				{
					if(tn.Nodes.Count != 0)
					{
						if(MessageBox.Show("̃tH_폜ƁAʂ̑SĂ̗vf폜܂B\n\n{ɍ폜܂H", "tH_̍폜", MessageBoxButtons.OKCancel, MessageBoxIcon.Question)
							== DialogResult.Cancel)
						{
							return;
						}
					}
					this.FvRemoveItem(tn);
				}
			}
			this.ctxOnPage.Tag = null;
		}

	}

	/// <summary>
	/// CxgURL󂯓nɗpEventArgs`܂
	/// </summary>
	public class UrlEventArgs : EventArgs
	{
		string _url;
		bool _newwin;
		/// <summary>
		/// vꂽړURL擾܂
		/// </summary>
		public string Url
		{
			get { return this._url; }
		}
		/// <summary>
		/// VEBhEŊJƂvĂ邩ǂ擾܂
		/// </summary>
		public bool NewWindow
		{
			get { return this._newwin; }
		}

		/// <summary>
		/// VCX^X쐬܂
		/// </summary>
		/// <param name="url">ړURL</param>
		/// <param name="newwindow">VEBhEŊJǂ</param>
		public UrlEventArgs(string url, bool newwindow)
		{
			this._url = url;
			this._newwin = newwindow;
		}


	}

	public enum ActionFrags : byte
	{
		ActOnLeftSingle = 0x01,
		ActOnLeftDouble = 0x02,

		Target_CurrentWindowOnLeft = 0x10,
		Target_NewWindowAll = 0x20,
	}
}
