using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Net;
using System.Text;
using System.Threading;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using Browser.Boon.Control;

using Browser.Boon.Net;
using NicoNico.API;
using NicoNico.API.Request;

namespace Browser
{
    public partial class MainForm : Form
    {

        /// <summary>
        /// ۑtH_̑IĂtH_̊SpXłB
        /// tH_̑IύXꂽǂ̔Ɏgp܂B
        /// </summary>
        private string selectedNodeFullPath_ = null;

        /// <summary>
        /// ݒێBoonSerializableConfigIuWFNgłB
        /// </summary>
        private BoonSerializableConfig boonConfig_ = BoonSerializableConfig.getInstance();

        /// <summary>
        /// 
        /// </summary>
        private static NicoService nico__ = Browser.Boon.Net.BoonDownloadManager.getNicoService();

        /// <summary>
        /// RXgN^łB
        /// </summary>
        public MainForm()
        {
			Urlmon.InternetOptionProxy(InternetOpenType.INTERNET_OPEN_TYPE_PROXY, "localhost:8080", "");

            this.InitializeComponent();
			this.Padding = new Padding(0);
			this.SetStyle(ControlStyles.UserPaint, true);
			this.SetStyle(ControlStyles.AllPaintingInWmPaint, true);
			this.SetStyle(ControlStyles.OptimizedDoubleBuffer, true);
			this.toolStripTextBoxUrl.AllowDrop = true;
			this.toolStripTextBoxUrl.DragDrop += new DragEventHandler(toolStripTextBoxUrl_DragDrop);
			this.toolStripTextBoxUrl.DragEnter += new DragEventHandler(toolStripTextBoxUrl_DragEnter);
			this.downloadListView.DragDrop += new DragEventHandler(downloadListView_DragDrop);

			this.FormClosed += new FormClosedEventHandler(MainForm_FormClosed);
			/*
            MainForm.nico__.DownloadFileProgress += new DownloadFileRequest.DownloadFileProgressEventHandler(nico_DownloadFileProgress);
            MainForm.nico__.LoginCompleted += new LoginRequest.LoginCompletedEventHandler(nico_LoginCompleted);
            MainForm.nico__.ThumbnailInfoCompleted += new ThumbnailInfoRequest.ThumbnailInfoCompletedEventHandler(nico_ThumbnailInfoCompleted);
            MainForm.nico__.VideoInfoCompleted += new VideoInfoRequest.VideoInfoCompletedEventHandler(nico_VideoInfoCompleted);
            MainForm.nico__.Login(@"zephyr_japan@hotmail.com", "hogehoge");
            //MainForm.nico__.DownloadCookieAsync(@"http://www.nicovideo.jp");
			*/
        }


        /// <summary>
        /// ݂̃^uJĂURL𕶎ƂĎ擾܂B
        /// </summary>
        /// <returns>݂URL</returns>
        public string getCurrentURL()
        {
            return (this.tabBrowser.TbSelectedBrowser.Url.AbsoluteUri);
        }

        /// <summary>
        /// Formꂽ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێFormClosedEventArgsIuWFNg</param>
		void MainForm_FormClosed(object sender, FormClosedEventArgs e)
		{
		}

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێDragEventArgsIuWFNg</param>
		void toolStripTextBoxUrl_DragEnter(object sender, DragEventArgs e)
		{
		}

        /// <summary>
        /// DownloadListViewD&Dꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێDragEventArgsIuWFNg</param>
		void downloadListView_DragDrop(object sender, DragEventArgs e)
		{
			System.Diagnostics.Debug.WriteLine(e.Data.GetData(typeof(String)));
		}

        /// <summary>
        /// URLeLXg{bNXD&Dꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێDragEventArgsIuWFNg</param>
		void toolStripTextBoxUrl_DragDrop(object sender, DragEventArgs e)
		{
			System.Diagnostics.Debug.WriteLine(e.Data.GetData(typeof(string)));
            // ȂÃ݂^uŉʑJڂs
		}

        /// <summary>
        /// Form[hꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void MainForm_Load(object sender, EventArgs e)
        {
            this.InitializeSaveDirectoryTreeView();

            // ݒɂA삪؂ւ邪̓z[URLV^uŊJ
			this.tabBrowser.TbOpenNewWindow(this.boonConfig_.homeUrl);
        }

        /// <summary>
        /// Form̏IłB
        /// </summary>
        private void endForm()
        {
            // ݊JĂ^ȕԂۑ鏈
            // EChȄԂۑ鏈
            this.Close();
        }

        #region saveDirectoryTreeView֘A

        /// <summary>
        /// saveDirectoryTreeView܂B
        /// </summary>
        private void InitializeSaveDirectoryTreeView()
        {
            TreeNode tn1 = new TreeNode();
            TreeNode tn2 = new TreeNode();
            TreeNode tn3 = new TreeNode();
            tn1.Name = "downloadNode";
            tn1.Text = BoonDefine.DOWNLOAD_FOLDER_NAME;
            tn1.ImageIndex = 0;
            tn2.Name = "saveFolderNode";
            tn2.Text = BoonDefine.SAVE_FOLDER_NAME;
            tn2.ImageIndex = 1;
            tn2.SelectedImageIndex = 3;
            tn3.Name = "searchFilesNode";
            tn3.Text = BoonDefine.SEARCH_FILES_NAME;
            tn3.ImageIndex = 2;

            string[] subDirectories = Directory.GetDirectories(this.boonConfig_.saveFolderPath);

            foreach (string i in subDirectories)
            {
                TreeNode tn = new TreeNode(i.Substring(i.LastIndexOf('\\') + 1));
                tn.ImageIndex = 1;
                tn.SelectedImageIndex = 3;
                tn2.Nodes.Add(tn);
            }
            
            this.saveDirectryTreeView.Nodes.AddRange(new System.Windows.Forms.TreeNode[] {tn1, tn2, tn3});

            this.toggleDownloadListView(BoonDefine.DOWNLOAD_FOLDER_INDEX);

        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void saveDirectryTreeView_NodeMouseClick(object sender, TreeNodeMouseClickEventArgs e)
        {
            if (e.Button == MouseButtons.Left)
            {
                if (e.Node.FullPath.StartsWith(BoonDefine.SAVE_FOLDER_NAME))
                {
                    if (e.Node.Text.Length != e.Node.FullPath.Length)
                    {
                        string[] subDirectories = Directory.GetDirectories(@"C:\" + e.Node.FullPath.Substring(BoonDefine.SAVE_FOLDER_NAME.Length + 1));

                        if (subDirectories.Length > 0)
                        {
                            e.Node.Nodes.Clear();
                            for (int i = 0; i < subDirectories.Length; i++)
                            {
                                TreeNode tn = new TreeNode(subDirectories[i].Substring(subDirectories[i].LastIndexOf('\\') + 1));
                                tn.ImageIndex = 1;
                                tn.SelectedImageIndex = 3;
                                e.Node.Nodes.Add(tn);
                            }
                        }

                        this.updateDownloadListView(@"C:\" + e.Node.FullPath.Substring(BoonDefine.SAVE_FOLDER_NAME.Length + 1));
                    }
                    else
                    {
                        this.updateDownloadListView(@"C:\");
                    }

                    
                }
            }
            else if (e.Button == MouseButtons.Right)
            {
                MessageBox.Show(e.Node.FullPath + "AENbN܂B");
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void saveDirectryTreeView_NodeMouseDoubleClick(object sender, TreeNodeMouseClickEventArgs e)
        {
            //MessageBox.Show(e.Node.FullPath);
            switch (e.Node.Index)
            {
                case BoonDefine.DOWNLOAD_FOLDER_INDEX:
                    break;

                case BoonDefine.SAVE_FOLDER_INDEX:
                    break;

                default:
                    break;
            }

        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void saveDirectryTreeView_AfterSelect(object sender, TreeViewEventArgs e)
        {
            if (e.Node.FullPath.Equals(this.selectedNodeFullPath_)) return;

            this.toggleDownloadListView(this.getListKind(e.Node));
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="n"></param>
        /// <returns></returns>
        private int getListKind(TreeNode n)
        {
            if (n.FullPath.Equals(BoonDefine.DOWNLOAD_FOLDER_NAME))
            {
                return (BoonDefine.DOWNLOAD_FOLDER_INDEX);
            }
            else if (n.FullPath.StartsWith(BoonDefine.SAVE_FOLDER_NAME))
            {
                return (BoonDefine.SAVE_FOLDER_INDEX);
            }
            else if (n.FullPath.Equals(BoonDefine.SEARCH_FILES_NAME))
            {
                return (BoonDefine.SEARCH_FILES_INDEX);
            }

            return (-1);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void saveDirectryTreeView_DragDrop(object sender, DragEventArgs e)
        {

        }

        #endregion

        #region downloadListView֘A

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void downloadListView_SelectedIndexChanged(object sender, EventArgs e)
        {

        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void downloadListView_SizeChanged(object sender, EventArgs e)
        {

        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void downloadListView_ColumnClick(object sender, ColumnClickEventArgs e)
        {
            this.downloadListView.ListViewItemSorter = new DownloadListViewItemComparer(e.Column);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="fullpath"></param>
        private void updateDownloadListView(string fullpath)
        {
            string[] movieFiles = Directory.GetFiles(fullpath, "*.*", SearchOption.TopDirectoryOnly);
            this.downloadListView.Clear();

            for (int i = 0; i < movieFiles.Length; i++)
            {
                FileInfo f = new FileInfo(movieFiles[i]);
                if (!Regex.IsMatch(f.Extension, @"\.(flv|mp4|swf)$", RegexOptions.IgnoreCase)) continue;
                this.downloadListView.Items.Add(new ListViewItem(new string[] { f.Name.Substring(0, f.Name.Length - f.Extension.Length), string.Format("F/f4", (((float) f.Length) / (1024 * 1024) )), f.LastWriteTime.ToString("yyyy/MM/dd HH:mm:ss"), f.Extension }));
            }

        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="listKind"></param>
        private void toggleDownloadListView(int listKind)
        {
            switch (listKind)
            {
                case BoonDefine.DOWNLOAD_FOLDER_INDEX:
                    this.downloadListView.Columns.Clear();
                    this.downloadListView.Columns.AddRange
                    (
                        new System.Windows.Forms.ColumnHeader[]
                        {
                            this.columnHeader1_title,
                            this.columnHeader1_status,
                            this.columnHeader1_size,
                            this.columnHeader1_progress,
                            this.columnHeader1_remainTime,
                            this.columnHeader1_speed,
                            this.columnHeader1_mode,
                            this.columnHeader1_extension,
                            this.columnHeader1_registTimestamp
                        }
                    );

                    break;

                case BoonDefine.SAVE_FOLDER_INDEX:
                    this.downloadListView.Columns.Clear();
                    this.downloadListView.Columns.AddRange
                    (
                        new System.Windows.Forms.ColumnHeader[]
                        {
                            this.columnHeader1_title,
                            this.columnHeader1_size,
                            this.columnHeader1_modifyTimestamp,
                            this.columnHeader1_extension
                        }
                    );

                    break;

                case BoonDefine.SEARCH_FILES_INDEX:
                    this.downloadListView.Clear();
                    this.downloadListView.Columns.AddRange
                    (
                        new System.Windows.Forms.ColumnHeader[]
                        {
                            this.columnHeader1_title,
                            this.columnHeader1_size,
                            this.columnHeader1_registTimestamp,
                            this.columnHeader1_extension,
                            this.columnHeader1_fullpath
                            
                        }
                    );

                    break;

                default:
                    break;
            }
        }

        public ListViewItem getListViewItem(string videoID)
        {
            foreach (ListViewItem i in this.downloadListView.Items)
            {
                if (videoID.Equals(i.Name)) return (i);
            }

            return (null);
        }

        #endregion

        /// <summary>
        /// y[Wǂݍ݊̃CxgłB
        /// 惊Nɑ΂āA_E[hN𖄂ߍ݂܂B
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێWebBrowserDocumentCompletedEventArgsIuWFNg</param>
        private void webBrowser_DocumentCompleted(object sender, WebBrowserDocumentCompletedEventArgs e)
		{
			
            HtmlDocument doc = ((WebBrowserEx)sender).Document;

            this.toolStripButton9_download.Enabled = (Regex.IsMatch(((WebBrowserEx)sender).Url.ToString(), "^http://www.nicovideo.jp/watch/[a-zA-Z0-9]+$"));

            try
            {
                foreach (HtmlElement ele in doc.GetElementsByTagName("A"))
                {
                    if ((ele.InnerHtml != null) && (ele.InnerHtml.StartsWith("<IMG ", StringComparison.CurrentCultureIgnoreCase))) continue;

                    string id = ele.GetAttribute("id");
                    string href = ele.GetAttribute("href");
                    if ((href.StartsWith("http://www.nicovideo.jp/watch") || (href.StartsWith("watch"))) && (!"boon".Equals(id)))
                    {
                        ele.SetAttribute("id", "boon");
                        HtmlElement newEle = doc.CreateElement("A");
                        newEle.SetAttribute("href", this.getBoonLinkString(href));
                        newEle.InnerText = "[download]";
                        ele.InsertAdjacentElement(HtmlElementInsertionOrientation.AfterEnd, newEle);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString());
            }

        }

        /// <summary>
        /// _E[hNp̃N𐶐܂B
        /// </summary>
        /// <param name="url">_E[hN쐬錳URL</param>
        /// <returns>_E[hNpN</returns>
        private string getBoonLinkString(string url)
        {
            Regex regex = new Regex(@"^(http://www.nicovideo.jp/)?watch/([a-zA-Z0-9]+)$");
            Match match = regex.Match(url);

            if (match.Success)
            {
                return ("boon://" + match.Groups[2]);
            }

            return ("");

        }

        /// <summary>
        /// uEȖJڂs܂B
        /// </summary>
        /// <param name="URL">JڐURL</param>
		private void Navigate(string URL)
		{
			if(this.tabBrowser.TbTabCount != 0)
			{
				this.tabBrowser.TbSelectedBrowser.Navigate(URL);
			}
			else
			{
				this.tabBrowser.TbOpenNewWindow(URL);
			}
		}

        #region toolStrip֘A

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
		private void toolStripButton1_back_Click(object sender, EventArgs e)
		{
			if(this.tabBrowser.TbTabCount != 0)
			{
				this.tabBrowser.TbSelectedBrowser.GoBack();
			}
		}

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
		private void toolStripButton01_back_MouseDown(object sender, MouseEventArgs e)
		{
			if(this.tabBrowser.TbTabCount != 0)
			{
				if(e.Button == MouseButtons.Right)
				{
					this.tabBrowser.TbSelectedBrowser.ShowHistoryList(Cursor.Position, true);
				}
			}
		}

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
		private void toolStripButton2_forward_Click(object sender, EventArgs e)
		{
			if(this.tabBrowser.TbTabCount != 0)
			{
				this.tabBrowser.TbSelectedBrowser.GoForward();
			}
		}
		private void toolStripButton02_forward_MouseDown(object sender, MouseEventArgs e)
		{
			if(this.tabBrowser.TbTabCount != 0)
			{
				if(e.Button == MouseButtons.Right)
				{
					this.tabBrowser.TbSelectedBrowser.ShowHistoryList(Cursor.Position, false);
				}
			}
		}

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton3_stop_Click(object sender, EventArgs e)
		{
			if(this.tabBrowser.TbTabCount != 0)
			{
				this.tabBrowser.TbSelectedBrowser.Stop();
			}
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
		private void toolStripButton4_refresh_Click(object sender, EventArgs e)
		{
			if(this.tabBrowser.TbTabCount != 0)
			{
				this.tabBrowser.TbSelectedBrowser.Refresh();
			}
		}

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton5_home_Click(object sender, EventArgs e)
        {
            this.Navigate("http://www.nicovideo.jp");
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton6_favorite_Click(object sender, EventArgs e)
        {
            if (this.toolStripButton6_favorite.Checked)
            {
                if (this.toolStripButton7_history.Checked) this.toolStripButton7_history.Checked = false;
                this.splitContainerBrowsSidebar.Panel1Collapsed = false;
				this.tabSideBar.SelectedIndex = 0;
            }
            else
            {
                this.splitContainerBrowsSidebar.Panel1Collapsed = true;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton7_history_Click(object sender, EventArgs e)
        {
            if (this.toolStripButton7_history.Checked)
            {
                if (this.toolStripButton6_favorite.Checked) this.toolStripButton6_favorite.Checked = false;
                this.splitContainerBrowsSidebar.Panel1Collapsed = false;
				this.tabSideBar.SelectedIndex = 1;
            }
            else
            {
                this.splitContainerBrowsSidebar.Panel1Collapsed = true;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton8_showDownloadList_Click(object sender, EventArgs e)
        {
            this.splitContainerMain.Panel2Collapsed = !(this.toolStripButton8_showDownloadList.Checked);
        }


        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
		private void toolStripButton10_search_Click(object sender, EventArgs e)
		{
			if(this.toolStripComboBoxSearch.Text != "")
			{
				string stxt = this.toolStripComboBoxSearch.Text;
				for(int i = 0; i < this.toolStripComboBoxSearch.Items.Count; i++)
				{
					if(stxt.Equals((string)this.toolStripComboBoxSearch.Items[i]))
					{
						this.toolStripComboBoxSearch.Items.RemoveAt(i);
						break;
					}
				}
				while(this.toolStripComboBoxSearch.Items.Count >= this.toolStripComboBoxSearch.MaxDropDownItems)
				{
					this.toolStripComboBoxSearch.Items.RemoveAt(this.toolStripComboBoxSearch.Items.Count - 1);
				}
				this.toolStripComboBoxSearch.Items.Insert(0, stxt);

				this.navigateToSearchPage(stxt);
			}
		}
        
        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
		private void toolStripButton11_go_Click(object sender, EventArgs e)
		{
			this.navigateByUrlTextbox();
		}
		private void toolStripTextBoxUrl_KeyDown(object sender, KeyEventArgs e)
		{
			if(e.KeyCode == System.Windows.Forms.Keys.Enter)
			{
				e.Handled = true;
				this.navigateByUrlTextbox();
			}
		}

        /// <summary>
        /// 
        /// </summary>
		private void navigateByUrlTextbox()
		{
			if(this.toolStripTextBoxUrl.Text != "")
			{
				this.Navigate(this.toolStripTextBoxUrl.Text);
			}
		}

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripComboBox1_Click(object sender, EventArgs e)
        {

        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripComboBox1_KeyDown(object sender, KeyEventArgs e)
        {
			if(e.KeyCode == System.Windows.Forms.Keys.Enter)
			{
				e.Handled = true;
				if(this.toolStripComboBoxSearch.Text != "")
				{
					this.navigateToSearchPage(this.toolStripComboBoxSearch.Text);
				}
			}
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="searchText"></param>
        private void navigateToSearchPage(string searchText)
        {
            if ((searchText == null) || (searchText.Equals("") )) return;
            this.addURLToComboBox(this.toolStripComboBoxSearch, searchText);
			searchText = Uri.EscapeDataString(searchText);
            this.Navigate(BoonCommon.Url_NicoSearch + searchText);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="comboBox"></param>
        /// <param name="addText"></param>
        private void addURLToComboBox(ToolStripComboBox comboBox, string addText)
        {
            if (comboBox.Items.Contains(addText)) comboBox.Items.RemoveAt(comboBox.Items.IndexOf(addText));

            comboBox.Items.Insert(0, addText);

            if (comboBox.Items.Count > comboBox.MaxDropDownItems)
            {
                comboBox.Items.RemoveAt(comboBox.Items.Count - 1);
            }
        }

        #endregion

        #region browserTabControl֘A

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void browserTabControl_SelectedIndexChanged(object sender, EventArgs e)
        {
        }



        #endregion

        #region mainMenu֘A

        #region t@Cj[

        /// <summary>
        /// t@Cj[́uVEChEJvIꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenu101_OpenNewWindow_Click(object sender, EventArgs e)
        {
            ;
        }

        /// <summary>
        /// t@Cj[́uV^uJvIꂽۂ̃CxgłB
        /// boonConfig_IuWFNgێĂz[URLV^uŊJ܂B
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenu102_OpenNewTag_Click(object sender, EventArgs e)
        {
			this.tabBrowser.TbOpenNewWindow(this.boonConfig_.homeUrl);
        }

        /// <summary>
        /// t@Cj[́u^uvIꂽۂ̃CxgłB
        /// ݊JĂ^u܂B
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenu103_CloseTab_Click(object sender, EventArgs e)
        {
			this.tabBrowser.TbRemove(this.tabBrowser.TbSelectedIndex);
        }

        /// <summary>
        /// t@Cj[́uׂẴ^uvIꂽۂ̃CxgłB
        /// ׂẴ^u܂B
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenu104_CloseAllTabs_Click(object sender, EventArgs e)
        {
			this.tabBrowser.TbClear(false);
        }

        /// <summary>
        /// t@Cj[́uۑtH_explorerŊJvIꂽۂ̃CxgłB
        /// boonConfig_IuWFNgŎw肳ĂۑtH_explorerŊJ܂B
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenu105_OpenSaveFolderWithExplorer_Click(object sender, EventArgs e)
        {
            Process.Start("explorer.exe", "/e," + this.boonConfig_.saveFolderPath);
        }

        /// <summary>
        /// t@Cj[́uNbv{[hURL_E[hvIꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenu106_downloadURLInClipBoard_Click(object sender, EventArgs e)
        {
            if (!Clipboard.ContainsText()) return;
            string targetURL = Clipboard.GetText();

            MessageBox.Show(targetURL);
        }

        /// <summary>
        /// t@Cj[́uIvIꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenu107_Exit_Click(object sender, EventArgs e)
        {
			this.Close();
        }

        #endregion t@Cj[

        #region \j[

        /// <summary>
        /// \j[́u߂vIꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenu201_GoBack_Click(object sender, EventArgs e)
        {
			this.tabBrowser.TbSelectedBrowser.GoBack();
        }

        /// <summary>
        /// \j[́uiށvIꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenu202_GoForward_Click(object sender, EventArgs e)
        {
			this.tabBrowser.TbSelectedBrowser.GoForward();
        }

        /// <summary>
        /// \j[́uz[vIꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenu203_GoHome_Click(object sender, EventArgs e)
        {
			this.tabBrowser.TbSelectedBrowser.GoHome();
        }

        /// <summary>
        /// \j[́u~vIꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenu204_Abort_Click(object sender, EventArgs e)
        {
			this.tabBrowser.TbSelectedBrowser.Stop();
        }

        /// <summary>
        /// \j[́uXVvIꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenu205_Refresh_Click(object sender, EventArgs e)
        {
			this.tabBrowser.TbSelectedBrowser.Refresh();
        }

        /// <summary>
        /// \j[́uׂẴbN^uXVvIꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenu206_RefreshAllLockedTabs_Click(object sender, EventArgs e)
        {
        }

        /// <summary>
        /// \j[́uׂẴ^uXVvIꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenu207_RefreshAllTabs_Click(object sender, EventArgs e)
        {

        }

        /// <summary>
        /// \j[́ũ^uvIꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenu208_NextTab_Click(object sender, EventArgs e)
        {

        }

        /// <summary>
        /// \j[́uÕ^uvIꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenu209_PreviousTab_Click(object sender, EventArgs e)
        {

        }

        /// <summary>
        /// \j[́u_E[hXg̑SvIꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenu210_DeleteAllDownloadList_Click(object sender, EventArgs e)
        {

        }

        /// <summary>
        /// \j[́uCɓ̕\vIꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenu211_ShowFavorite_Click(object sender, EventArgs e)
        {

        }

        /// <summary>
        /// \j[́u̕\vIꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenu212_ShowHistory_Click(object sender, EventArgs e)
        {

        }

        /// <summary>
        /// \j[́u_E[hXg̕\vIꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenu213_ShowDownloadList_Click(object sender, EventArgs e)
        {

        }

        #endregion \j[

        #region Cɓ胁j[

        /// <summary>
        /// Cɓ胁j[́uCɓɒǉvIꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
		private void mainMenu301_AddToFavorite_Click(object sender, EventArgs e)
		{ 
			// Edit 080830 - BaseVer0.0.10
			if(this.tabBrowser.TbSelectedBrowser != null)
			{
				string title = this.tabBrowser.TbSelectedBrowser.DocumentTitle;
				string url = this.tabBrowser.TbSelectedBrowser.Url.ToString();
				this.favoriteTreeView1.FvAddItem(title, url, "");
			}
		}

        /// <summary>
        /// Cɓ胁j[́uCɓ̕\vIꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenu302_ShowFavorite_Click(object sender, EventArgs e)
		{
			// Edit 080830 - BaseVer0.0.10
			this.splitContainerBrowsSidebar.Panel1Collapsed = false;
			this.tabSideBar.SelectedIndex = 0;
        }

        /// <summary>
        /// Cɓ胁j[́uCɓ̐vIꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenu303_readjustFavorite_Click(object sender, EventArgs e)
        {
           // new FavoriteManage.FavoriteForm().Show();
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenuFavorite100_Click(object sender, EventArgs e)
        {

        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenuFavorite101_Click(object sender, EventArgs e)
        {

        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenuFavorite102_Click(object sender, EventArgs e)
        {

        }

        #endregion Cɓ胁j[

        #region IvVj[
        
        /// <summary>
        /// IvVj[́uݒvIꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenu401_Settings_Click(object sender, EventArgs e)
        {
            SettingsForm sf = new SettingsForm(this.boonConfig_);
            sf.Owner = this;
            sf.Show();
        }

        /// <summary>
        /// IvVj[́uɂđOɕ\vIꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenu402_ShowAtMostTop_Click(object sender, EventArgs e)
        {
            this.mainMenu402_ShowAtMostTop.Checked = (!this.mainMenu402_ShowAtMostTop.Checked);
            this.TopMost = this.mainMenu402_ShowAtMostTop.Checked;
        }

        /// <summary>
        /// IvVj[́uXNvgEG[_CAO\vIꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenu403_HideScriptErrorDialogue_Click(object sender, EventArgs e)
        {

        }

        #endregion IvVj[

        #region wvj[

        /// <summary>
        /// wvj[́uwvvIꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenu501_Help_Click(object sender, EventArgs e)
        {

        }

        /// <summary>
        /// wvj[́uz[y[WցvIꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenu502_GoHomePage_Click(object sender, EventArgs e)
        {

        }

        /// <summary>
        /// wvj[́uo[WvIꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void mainMenu503_ShowVersionInformation_Click(object sender, EventArgs e)
        {

        }

        #endregion wvj[

        #endregion mainMenu֘A

        #region contextMenuStrip100֘A

        private int context100TargetIndex { get { return this.tabBrowser.ContextMenuTargetTab; } }

        private void toolStripMenuItem101_CloseTab_Click(object sender, EventArgs e)
        {
			this.tabBrowser.TbRemove(this.context100TargetIndex);
        }

        private void toolStripMenuItem102_CloseAllTabs_Click(object sender, EventArgs e)
        {
			this.tabBrowser.TbClear(false);
        }

        private void toolStripMenuItem103_OpenNewTab_Click(object sender, EventArgs e)
        {
			this.tabBrowser.TbOpenNewWindow("about:blank");
        }

        private void toolStripMenuItem104_Refresh_Click(object sender, EventArgs e)
        {
			this.tabBrowser.TbGetBrowser(this.context100TargetIndex).Refresh();
        }

        private void toolStripMenuItem105_RefreshAllLockedTabs_Click(object sender, EventArgs e)
        {
			//
        }

        private void toolStripMenuItem106_RefreshAllTabs_Click(object sender, EventArgs e)
        {
			int tooMuchTabs = 6;
			if(this.tabBrowser.TbTabCount >= tooMuchTabs)
			{
				if(MessageBox.Show("\̃^uxɍXV悤ƂĂ܂B\n̑̓T[o[ɑ傫ȕׂSz܂B\n\n{Ɏs܂H"
				, "\ׂ̂Ẵ^u̍XV", MessageBoxButtons.OKCancel, MessageBoxIcon.Warning)
					== DialogResult.Cancel)
				{
					return;
				}
			}
			for(int i=0; i<this.tabBrowser.TbTabCount; ++i)
			{
				this.tabBrowser.TbGetBrowser(i).Refresh();
			}
        }

        private void toolStripMenuItem107_LockThisTab_Click(object sender, EventArgs e)
        {

        }

        private void toolStripMenuItem108_CopyTitleAndUrl_Click(object sender, EventArgs e)
		{
			Clipboard.SetText(
				this.tabBrowser.TbGetBrowser(this.context100TargetIndex).DocumentTitle
				+ "\n" +
				this.tabBrowser.TbGetBrowser(this.context100TargetIndex).Url.ToString());
        }

		private void toolStripMenuItem109_CopyTitle_Click(object sender, EventArgs e)
		{
			Clipboard.SetText(this.tabBrowser.TbGetBrowser(this.context100TargetIndex).DocumentTitle);
		}

		private void toolStripMenuItem110_CopyUrl_Click(object sender, EventArgs e)
		{
			Clipboard.SetText(this.tabBrowser.TbGetBrowser(this.context100TargetIndex).Url.ToString());
		}

        #endregion

        #region contextMenuStrip200֘A

        private void toolStripMenuItem201_DeleteDownloadList_Click(object sender, EventArgs e)
        {

        }

        private void toolStripMenuItem202_MakeSubFolder_Click(object sender, EventArgs e)
        {

        }

        private void toolStripMenuItem203_ChangeName_Click(object sender, EventArgs e)
        {

        }

        private void toolStripMenuItem204_DeleteFolder_Click(object sender, EventArgs e)
        {

        }

        private void toolStripMenuItem205_OpenWithExplorer_Click(object sender, EventArgs e)
        {

        }

        #endregion

        #region contextMenuStrip300֘A

        private void toolStripMenuItem301_PlayMovie_Click(object sender, EventArgs e)
        {

        }

        private void toolStripMenuItem302_OpenOriginalMovieByBrowser_Click(object sender, EventArgs e)
        {

        }

        private void toolStripMenuItem303_OpenOriginalMovieByBoon_Click(object sender, EventArgs e)
        {

        }

        private void toolStripMenuItem304_DeleteFile_Click(object sender, EventArgs e)
        {

        }

        private void toolStripMenuItem305_DeleteFromDownloadList_Click(object sender, EventArgs e)
        {

        }

        private void toolStripMenuItem306_DeleteAllFromDownloadList_Click(object sender, EventArgs e)
        {

        }

        private void toolStripMenuItem307_RetryDownload_Click(object sender, EventArgs e)
        {

        }

        private void toolStripMenuItem308_RetryDownloadOnlyMovieFile_Click(object sender, EventArgs e)
        {

        }

        private void toolStripMenuItem309_CopyTitleAndUrl_Click(object sender, EventArgs e)
        {

        }

        private void toolStripMenuItem310_CopyTitle_Click(object sender, EventArgs e)
        {

        }

        private void toolStripMenuItem311_CopyUrl_Click(object sender, EventArgs e)
        {

        }

        private void toolStripMenuItem312_PlayWithOtherMovieFile_Click(object sender, EventArgs e)
        {

        }

        private void toolStripMenuItem313_PlayWithOtherCommentFile_Click(object sender, EventArgs e)
        {

        }

        #endregion

        #region TabBrowserCxg֘A

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێWebBrowserNavigatedEventArgsIuWFNg</param>
        private void tabBrowser_TbNavigated(object sender, WebBrowserNavigatedEventArgs e)
		{
			this.toolStripTextBoxUrl.Text = this.tabBrowser.TbUrlText;
			// Edit 080830 - BaseVer0.0.10
			WebBrowser wex = (WebBrowser)sender;
			if(wex.Document.Url.ToString() == e.Url.ToString())
			{
				string stitle = wex.DocumentTitle;
				if(stitle == "")
				{
					stitle = e.Url.ToString();
				}
				this.history_Add(stitle, e.Url.ToString());
			}
		}

        /// <summary>
        /// ^ȗIύXꂽۂ̃CxgłB
        /// URLeLXg{bNXƁAirQ[g{^̐s܂B
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
		private void tabBrowser_TbSelectedIndexChanged(object sender, EventArgs e)
		{
			this.toolStripTextBoxUrl.Text = this.tabBrowser.TbUrlText;
			if(this.tabBrowser.TbSelectedBrowser != null)
			{
				this.toolStripButton01_back.Enabled = this.tabBrowser.TbSelectedBrowser.CanGoBack;
				this.toolStripButton02_forward.Enabled = this.tabBrowser.TbSelectedBrowser.CanGoForward;
			}
		}

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
		private void tabBrowser_TbStatusTextChanged(object sender, EventArgs e)
		{
		}

        /// <summary>
        /// TabBrowserIuWFNgCanGoBackvpeBωۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
		private void tabBrowser_TbCanGoBackChanged(object sender, EventArgs e)
		{
			this.toolStripButton01_back.Enabled = this.tabBrowser.TbSelectedBrowser.CanGoBack;
		}

        /// <summary>
        /// TabBrowserIuWFNgCanGoForwardvpeBωۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
		private void tabBrowser_TbCanGoForwardChanged(object sender, EventArgs e)
		{
			this.toolStripButton02_forward.Enabled = this.tabBrowser.TbSelectedBrowser.CanGoForward;
        }

        #endregion TabBrowserCxg֘A

        #region NicoServiceCxg֘A

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void nico_LoginCompleted(LoginRequest sender, LoginCompletedEventArgs e)
        {
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void nico_ThumbnailInfoCompleted(ThumbnailInfoRequest sender, ThumbnailInfoCompletedEventArgs e)
        {
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void nico_VideoInfoCompleted(VideoInfoRequest sender, VideoInfoCompletedEventArgs e)
        {
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void nico_DownloadFileProgress(DownloadFileRequest sender, DownloadFileCompletedEventArgs e)
        {
            /*
            DownloadFileResponse res = e.Response;
            ListViewItem lvi = this.getListViewItem(e.UserState);

            if (lvi == null) return;

            lvi.SubItems[2].Text = "" + e.Response.Download + "/" + e.Response
            */
        }

        #endregion

        #region  SidePanel

        int history_max_count = 10;
		private void history_Add(string title, string url) // Add 080830 - BaseVer0.0.10
		{
			while(this.listHistory.Items.Count >= history_max_count)
			{
				this.listHistory.Items.RemoveAt(this.listHistory.Items.Count - 1); // BugFixed 080921/21:00:00
			}
			ListViewItem item = new ListViewItem();
			item.Text = title;
			item.Tag = (object)url;
			item.ToolTipText = title + "\n" + url;
			this.listHistory.Items.Insert(0, item);
		}
		private string history_Get(int entry) // Add 080830 - BaseVer0.0.10
		{
			if(0 <= entry && entry < this.listHistory.Items.Count)
			{
				return (string)this.listHistory.Items[entry].Tag;
			}
			else return string.Empty;
		}
		private bool history_Remove(int entry) // Add 080830 - BaseVer0.0.10
		{
			if(0 <= entry && entry < this.listHistory.Items.Count)
			{
				this.listHistory.Items.RemoveAt(entry);
				return true;
			}
			return false;
		}

		#endregion

        /// <summary>
        /// _E[hNꂽۂ̃CxgłB
        /// DownloadListViewListViewItemǉ܂B
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێMovieDownloadRequiredEventArgsIuWFNg</param>
        private void tabBrowser_MovieDownloadRequired(object sender, MovieDownloadRequiredEventArgs e)
        {
            if (!this.downloadListView.Items.ContainsKey(e.MovieID))
            {
                ThumbnailInfoResponse res = MainForm.nico__.ThumbnailInfo(e.MovieID);
                ListViewItem lvi = new ListViewItem(new string[] { res.Title, "_E[h҂", });
                lvi.Name = e.MovieID;
                this.downloadListView.Items.Add(lvi);

                BoonDownloadManager.addReservation(e.MovieID);
                
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
		private void btnAddFavorite_Click(object sender, EventArgs e)
		{
			if(this.tabBrowser.TbSelectedBrowser != null)
			{
				string title = this.tabBrowser.TbSelectedBrowser.DocumentTitle;
				string url = this.tabBrowser.TbSelectedBrowser.Url.ToString();
				this.favoriteTreeView1.FvAddItem(title, url, "", this.favoriteTreeView1.SelectedNode);
			}
		}

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
		private void tabSideBar_SelectedIndexChanged(object sender, EventArgs e) // Add 080830 - BaseVer0.0.10
		{
			if(this.tabSideBar.SelectedIndex == 0)
			{
				this.toolStripButton6_favorite.Checked = true;
				this.toolStripButton7_history.Checked = false;
				this.btnAddFavorite.Visible = true;
				this.btnAddFavorite.Enabled = true;
			}
			else
			{
				toolStripButton6_favorite.Checked = false;
				this.toolStripButton7_history.Checked = true;
				this.btnAddFavorite.Visible = false;
				this.btnAddFavorite.Enabled = false;
			}
		}

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
		private void favoriteTreeView1_FvNavigateRequired(object sender, FavoriteManage.UrlEventArgs e)// Add 080830 - BaseVer0.0.10
		{
			if(e.NewWindow || this.tabBrowser.TbTabCount == 0)
			{
				this.tabBrowser.TbOpenNewWindow(e.Url, this.tabBrowser.TbSelectedIndex + 1, true);
			}
			else
			{
				this.tabBrowser.TbSelectedBrowser.Navigate(e.Url);
			}
		}

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
		private void splitContainerBrowsSidebar_SplitterMoved(object sender, SplitterEventArgs e)  // Add 080830 - BaseVer0.0.10
		{
			this.btnAddFavorite.Left = e.SplitX - this.btnAddFavorite.Width;
			this.tabSideBar.Width = e.SplitX + 4;
		}

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
		private void listHistory_ItemActivate(object sender, EventArgs e)
		{
			if(this.listHistory.FocusedItem.Tag != null)
			{
				string url = (string)this.listHistory.FocusedItem.Tag;
				this.listHistory.Items.Remove(this.listHistory.FocusedItem);
				if(this.tabBrowser.TbTabCount != 0)
				{
					this.tabBrowser.TbSelectedBrowser.Navigate(url);
				}
				else
				{
					this.tabBrowser.TbOpenNewWindow(url);
				}
			}
		}

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
		private void listHistory_MouseDown(object sender, MouseEventArgs e)
		{
			if(e.Button == MouseButtons.Middle)
			{
				ListViewItem item = this.listHistory.GetItemAt(e.X, e.Y);
				if(item != null)
				{
					if(item.Bounds.Contains(e.Location))
					{
						string url = (string)item.Tag;
						this.tabBrowser.TbOpenNewWindow(url, this.tabBrowser.TbSelectedIndex + 1, true);
					}
				}
			}
		}

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
		private void listHistory_SizeChanged(object sender, EventArgs e)
		{
			// ȂȂƃoOB
			this.listHistoryClmn_Title.Width = this.listHistory.Width - 10;
			this.listHistoryClmn_Title.Width = this.listHistory.Width - 5;
		}

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
		private void tabSideBar_SizeChanged(object sender, EventArgs e)
		{
			this.favoriteTreeView1.Height = this.tabSideBar.Height - 27;
			this.favoriteTreeView1.Width = this.tabSideBar.Width-7;
		}
        
	}

    /// <summary>
    /// DownloadListViewItemRNṼ\[gNXłB
    /// </summary>
    class DownloadListViewItemComparer : System.Collections.IComparer
    {
        /// <summary>
        /// \[gsJ̃CfbNXłB
        /// </summary>
        private int col;

        /// <summary>
        /// RXgN^łB
        /// J̓ftHg0ݒ肳܂B
        /// </summary>
        public DownloadListViewItemComparer()
        {
            this.col = 0;
        }

        /// <summary>
        /// RXgN^łB
        /// </summary>
        /// <param name="column">\[gsJ</param>
        public DownloadListViewItemComparer(int column)
        {
            this.col = column;
        }

        /// <summary>
        /// 2̃IuWFNgrA菬AA傫lԂ܂B
        /// ł̑召r{܂B
        /// </summary>
        /// <param name="x">rΏۂ̑1IuWFNg</param>
        /// <param name="y">rΏۂ̑2IuWFNg</param>
        /// <returns>xy菬Ε̒lA0Axy傫ΐ̒l</returns>
        public int Compare(object x, object y)
        {
            return (String.Compare(((ListViewItem)x).SubItems[this.col].Text, ((ListViewItem)y).SubItems[this.col].Text));
        }
    }
}
