using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;

using Browser.Boon.IO.File;
using NicoNico.API;
using NicoNico.API.Request;

namespace Browser.Boon.Net
{
    /// <summary>
    /// 
    /// </summary>
    class BoonDownloadManager
    {
        private static BoonDownloadManager manager__ = new BoonDownloadManager();

        private static Queue<string> downloadVideoKeys = new Queue<string>();

        private static bool isProcessing_ = false;

        private static int threadCount_ = 0;

        /// <summary>
        /// 
        /// </summary>
        private static NicoService nico__ = new NicoService();

        /// <summary>
        /// RXgN^łB
        /// O͌Ăяo܂B
        /// </summary>
        private BoonDownloadManager()
        {
        }

        private void startDownload()
        {
            System.Windows.Forms.MessageBox.Show(BoonDownloadManager.threadCount_ + "");
            System.Windows.Forms.MessageBox.Show(BoonDownloadManager.downloadVideoKeys.Count + "");
            if ((BoonDownloadManager.threadCount_ == 0) && (BoonDownloadManager.downloadVideoKeys.Count > 0))
            {
                this.increaseThreadCount();
                string videoID = BoonDownloadManager.downloadVideoKeys.Dequeue();
                DownloadVideoThread dvth = new DownloadVideoThread(videoID);
                ThreadStart ts = new ThreadStart(dvth.DownloadVideo);
                Thread newThread = new Thread(ts);
                newThread.Start();
            }

        }

        /// <summary>
        /// ̃NX̗B̃IuWFNg擾܂B
        /// </summary>
        /// <returns>BoonDownloadManagerNX̃IuWFNg</returns>
        public static BoonDownloadManager getInstance()
        {
            return (BoonDownloadManager.manager__);
        }

        /// <summary>
        /// _E[h\񃊃XgɓIDǉ܂B
        /// </summary>
        /// <param name="videoID">\ǉ铮ID</param>
        public static void addReservation(string videoID)
        {
            if (!BoonDownloadManager.downloadVideoKeys.Contains(videoID))
            {
                BoonDownloadManager.downloadVideoKeys.Enqueue(videoID);
                BoonDownloadManager.manager__.startDownload();
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public static NicoService getNicoService()
        {
            return (BoonDownloadManager.nico__);
        }

        public void increaseThreadCount()
        {
            lock (this)
            {
                BoonDownloadManager.threadCount_++;
            }
        }

        public void decreaseThreadCount()
        {
            lock (this)
            {
                BoonDownloadManager.threadCount_--;
            }

            this.startDownload();
        }
    }

    /// <summary>
    /// 
    /// </summary>
    public class DownloadVideoThread
    {
        private NicoService nico_ = BoonDownloadManager.getNicoService();
    
        /// <summary>
        /// Xbh_E[h铮IDłB
        /// </summary>
        private string videoID_;

        /// <summary>
        /// 
        /// </summary>
        private int taskID_;

        /// <summary>
        /// RXgN^łB
        /// </summary>
        public DownloadVideoThread(string videoID)
        {
            this.videoID_ = videoID;

            this.nico_.VideoInfoCompleted += new VideoInfoRequest.VideoInfoCompletedEventHandler(nico_VideoInfoCompleted);
            this.nico_.DownloadFileCompleted += new DownloadFileRequest.DownloadFileCompletedEventHandler(nico_DownloadFileCompleted);
        }

        void nico_VideoInfoCompleted(VideoInfoRequest sender, VideoInfoCompletedEventArgs e)
        {
            if (e.Error != null)
            {
                System.Windows.Forms.MessageBox.Show(e.Error.Message);
            }
            else if (e.Cancelled)
            {
            }
            else
            {
                if (!this.videoID_.Equals(e.Response.VideoId)) return;

                System.Windows.Forms.MessageBox.Show(e.Response.FileUrl);
                this.nico_.DownloadCookie(string.Format(NicoUrl.Watch, e.Response.VideoId));
                this.taskID_ = this.nico_.DownloadFileAsync(e.Response.FileUrl, BoonSerializableConfig.getInstance().saveFolderPath + @"\" + this.videoID_, 1000);
            }

        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        void nico_DownloadFileCompleted(DownloadFileRequest sender, DownloadFileCompletedEventArgs e)
        {
            if (e.Error != null)
            {
                System.Windows.Forms.MessageBox.Show(e.Error.Message);
            }
            else if (e.Cancelled)
            {
            }
            else
            {

                System.Windows.Forms.MessageBox.Show("done");
                BoonDownloadManager.getInstance().decreaseThreadCount();
                
            }
        }

        /// <summary>
        /// t@C̃_E[hs܂B
        /// </summary>
        public void DownloadVideo()
        {
            NicoService nico = BoonDownloadManager.getNicoService();
            nico.VideoInfoAsync(this.videoID_);
        }

        /// <summary>
        /// IuWFNgێ铮IDłB
        /// </summary>
        public string videoID
        {
            get
            {
                return (this.videoID_);
            }
        }
        
    }
}
