// -*- C++ -*-
//  Boost general library 'format'  ---------------------------
//  See http://www.boost.org for updates, documentation, and revision history.

//  (C) Samuel Krempp 2001
//                  krempp@crans.ens-cachan.fr
//  Permission to copy, use, modify, sell and
//  distribute this software is granted provided this copyright notice appears
//  in all copies. This software is provided "as is" without express or implied
//  warranty, and with no claim as to its suitability for any purpose.

// ------------------------------------------------------------------------------
// sample_userType.cc :  format ˥桼Ѥ
// ------------------------------------------------------------------------------

#include <iostream>
#include <iomanip>
#include "boost/format.hpp"


class Rational {
public:
  Rational(int n, unsigned int d) : n_(n), d_(d) {}
  Rational(int n, int d);    // ʬ̵Ѵ
  friend std::ostream& operator<<(std::ostream&, const Rational&);
private:
  int n_;               // ʬ
  unsigned int d_;      // ʬ
};

Rational::Rational(int n, int d) : n_(n) 
{
    if(d < 0) { n_ = -n_; d=-d; }
    d_ = static_cast<unsigned int>(d);
}

std::ostream& operator<<(std::ostream& os, const Rational& r) {
  os << r.n_ << "/";
  std::ios_base::fmtflags oflags = os.flags();
  os << std::noshowpos << r.d_;
  os.flags( oflags);
  return os;
}





int main(){
    using namespace std;
    using boost::format;
    using boost::io::group; 
    using boost::io::str;
    string s;

    Rational  r(16, 9);

    cout << r;
    //          "16/9" ɽ

    cout << showpos << r << ", " << 5;
    //          "+16/9, +5" ɽ

    cout << format("[%+8d] \n") % r ;
    //          "[   +16/9] \n" ɽ

    cout << format("[%0+8d] \n") % r;
    //          "[+00016/9] \n" ɽ

    cout << format("[%0 8d] \n") % r;
    //          "[000 16/9] \n" ɽ
    
    cerr << "\n\nEverything went OK, exiting. \n";
    return 0;
}
