// -*- C++ -*-
//  Boost general library 'format'  ---------------------------
//  See http://www.boost.org for updates, documentation, and revision history.

//  (C) Samuel Krempp 2001
//                  krempp@crans.ens-cachan.fr
//  Permission to copy, use, modify, sell and
//  distribute this software is granted provided this copyright notice appears
//  in all copies. This software is provided "as is" without express or implied
//  warranty, and with no claim as to its suitability for any purpose.

// ------------------------------------------------------------------------------
// sample_advanced.cc :  format ι٤ʻȤ
// ------------------------------------------------------------------------------

#include <iostream>
#include <iomanip>

#include "boost/format.hpp"

int main(){
    using namespace std;
    using boost::format;
    using boost::io::group;
    using boost::io::str;
    string s;
    stringstream oss;



    //------------------------------------------------------------------------
    // ʸϤ줿ʸ 'formatter' ˳Ǽ : 
    // format ֥Ȥ̾Υ֥ȤǤ롣ԡ
    // Ϳȥ꡼˥פƤӰͿǤ롣
    // äơ桼Ϲʤ褦ˤȤȤǤ롣

    format fmter("%1% %2% %3% %1% \n");
    fmter % 10 % 20 % 30; 
    cout  << fmter;
    //          "10 20 30 10 \n" ɽ
    
    // ä fmter ٤ƤΰͿȡ񼰲줿ʸ
    // Ѳǽʤޤ޻Ĥ롣 ( '%' θƤӽФޤ)
    // η̤ str() ؿޤϥȥ꡼ << ̤ѤǤ :
    cout << fmter; 
    //          Ʊʸɽ


    // operator% ƤӸƤӽФȡϥ֥Ȥǥꥢ졢
    // ٤ƤΰͿѴʸ䤤魯Ȥϥ顼ˤʤ롣
    fmter % 1001;
    try  { cout << fmter;   }
    catch (boost::io::too_few_args& exc) { 
      cout <<  exc.what() << "***Dont worry, that was planned\n";
    }

    // ǸĤΰͿɬפ롣кƤӽϤ :
    cout << fmter % 1002 % 1003;
    //          "1001 1002 1003 1001 \n" ɽ

    cout  << fmter % 10 % 1 % 2;
    //          "10 1 2 10 \n" ɽ



    //---------------------------------------------------------------
    // format ֥Ȥ

    // Ϳ줿̿Τ˽񼰲ץ򹹿
    fmter = format("%1% %2% %3% %2% %1% \n");
    fmter.modify_item(4, group(setfill('_'), hex, showbase, setw(5)) );
    cout << fmter % 1 % 2 % 3;
    //          "1 2 3 __0x2 1 \n" ɽ
    
    // ΰĤ« :
    fmter.bind_arg(1, 18);
    cout << fmter % group(hex, showbase, 20) % 30;        // %2  20  20 == 0x14
    //          "18 0x14 30  _0x14 18 \n" ɽ
    
    
    fmter.modify_item(4, setw(0)); // ľ 5 򥭥󥻥뤹
    fmter.bind_arg(1, 77); // ǽΰ˴ؤ 18  77 ֤롣
    cout << fmter % 10 % 20;
    //          "77 10 20 0xa 77 \n" ɽ

    try  
    { 
      cout << fmter % 6 % 7 % 8;   // 䡼arg1 ϤǤ«Ƥ뤫¿
    }
    catch (boost::io::too_many_args& exc) 
    { 
      cout <<  exc.what() << "***Dont worry, that was planned\n";
    }

    // clear() ̾ΰ򥯥ꥢ뤬«줿ѿϥꥢʤ :
    fmter.clear();
    cout << fmter % 2 % 3;
    //          "77 2 3 0x2 77 \n" ɽ

    // ̾ΰ«줿ξ򥯥ꥢˤ clear_binds() Ȥ :
    fmter.clear_binds(); 
    cout << fmter % 1 % 2 % 3;
    //          "1 2 3 0x2 1 \n" ɽ
    
 
    // ˾ߤ㳰ꤹ :
    fmter.exceptions( boost::io::all_error_bits ^( boost::io::too_many_args_bit ) );
    cout << fmter % 1 % 2 % 3 % 4 % 5 % 6 ;


   // -----------------------------------------------------------
    // ¾:

    // ݡȤƤʤ printf ̿ %n  ꥹ-եɤϽ̵뤵롣
    // ˰ͿƤ *ʤʤ* ȥ顼ˤʤ롣
    cout << format("|%5d| %n") % 7 << endl;
    //          "|    7| " ɽ
    cout << format("|%*.*d|")  % 7 << endl;
    //          "|7|" ɽ


    // ʸڤΤ :
    cout << format("%|.2s| %|8c|.\n") % "root" % "user";
    //          "ro        u.\n" ɽ


    // ޥ˥ԥ졼ʸȾͤ : ޥ˥ԥ졼ġ
    cout << format("%2s")  % group(setfill('0'), setw(6), 1) << endl;
    //          "000001" ɽ
    cout << format("%2$5s %1% %2$3s\n")  % 1    % group(setfill('X'), setw(4), 2) ;
    //          "XXX2 1 XXX2\n" ɽ
    //          ϽʸǤϤʤޥ˥ԥ졼ˤäƥåȤ褦 4 Ǥ롣
    
    //  :
    cout << format("%2$014x [%1%] %2$05s\n") % (format("%05s / %s") % -18 % 7)
                                             % group(showbase, -100);
    //          "0x0000ffffff9c [-0018 / 7] -0100\n" ɽ


    cout << "\n\nEverything went OK, exiting. \n";
    return 0;
}
