//  (C) Copyright Steve Cleary & John Maddock 2000.
//  Permission to copy, use, modify, sell and
//  distribute this software is granted provided this copyright notice appears
//  in all copies. This software is provided "as is" without express or implied
//  warranty, and with no claim as to its suitability for any purpose.

//  See http://www.boost.org for most recent version including documentation.

/*
  Japanese Translation Copyright (C) 2003 mikari(Mika.N)<mikarim@m18.alpha-net.ne.jp>.
	
	IWíAyт̒쌠\SĂ̒̕ɌA̕
	ApAύXA̔ĔzzF߂B̃hLǵu邪܂܁v
	ɒ񋟂ĂAȂ閾IAÖٓIۏ؂sȂB܂A
	ȂړIɑ΂ĂA̗pKĂ邱Ƃ֒mȂB
	
	{CũhLg܂ލŐVłɊւẮAhttp://www.boost.org QƂB
	{ŃhLgɊւẮAhttp://boost.cppll.jp QƂ邱ƁB
*/

#include <boost/static_assert.hpp>

//
// all these tests should succeed.
// some of these tests are rather simplistic (ie useless)
// in order to ensure that they compile on all platforms.
//
/*	SẴeXgׂ͐łB
	̃eXg͈ՂŖɗȂ̂łB
	́ÃeXgSẴvbgtH[
	RpC\ȂƂmɊmF邽߂̂̂łB
*/

// Namespace scope
// OԃXR[v
BOOST_STATIC_ASSERT(sizeof(int) >= sizeof(short));
BOOST_STATIC_ASSERT(sizeof(char) == 1);

// Function (block) scope
// ֐XR[v
void f()
{
  BOOST_STATIC_ASSERT(sizeof(int) >= sizeof(short));
  BOOST_STATIC_ASSERT(sizeof(char) == 1);
}

struct Bob
{
  private:  // can be in private, to avoid namespace pollution
  // OԂ̉邽߂ɁAvCx[gɂ邱Ƃo
    BOOST_STATIC_ASSERT(sizeof(int) >= sizeof(short));
    BOOST_STATIC_ASSERT(sizeof(char) == 1);
  public:

  // Member function scope: provides access to member variables
  // o[֐XR[vFo[ϐւ̃ANZX񋟂
  int x;
  char c;
  int f()
  {
#ifndef _MSC_VER // broken sizeof in VC6
    BOOST_STATIC_ASSERT(sizeof(x) >= sizeof(short));
    BOOST_STATIC_ASSERT(sizeof(c) == 1);
#endif
    return x;
  }
};



// Template class scope
// ev[gNXXR[v
template <class Int, class Char>
struct Bill
{
  private:  // can be in private, to avoid namespace pollution
  // OԂ̉邽߂ɁAvCx[gɂ邱Ƃo
    BOOST_STATIC_ASSERT(sizeof(Int) > sizeof(char));
  public:

  // Template member function scope: provides access to member variables
  // ev[go[֐XR[vFo[ϐւ̃ANZX񋟂
  Int x;
  Char c;
  template <class Int2, class Char2>
  void f(Int2 , Char2 )
  {
    BOOST_STATIC_ASSERT(sizeof(Int) == sizeof(Int2));
    BOOST_STATIC_ASSERT(sizeof(Char) == sizeof(Char2));
  }
};

void test_Bill() // BOOST_CT_ASSERTs are not triggerred until instantiated
// BOOST_CT_ASSERT̃eXǵA\[XړIvO܂ł͕]Ȃ
{
  Bill<int, char> z;
  //Bill<int, int> bad; // will not compile  // RpCłȂ낤
  int i = 3;
  char ch = 'a';
  z.f(i, ch);
  //z.f(i, i); // should not compile  // G[ɂȂׂł
}

int main()
{ 
   test_Bill();
   return 0; 
}



