/*
** LuaJIT frontend. Runs commands, scripts, read-eval-print (REPL) etc.
** Copyright (C) 2005-2021 Mike Pall. See Copyright Notice in luajit.h
**
** Major portions taken verbatim or adapted from the Lua interpreter.
** Copyright (C) 1994-2008 Lua.org, PUC-Rio. See Copyright Notice in lua.h
*/

/* Copyright (C) 2020 Momi-g

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
/*SH_doc
title=bootlj section=3 repnl=\040
@name	bootlj
@_brief	make luajit vm
@_syno
 #include "bootlj.h"
 int bootlj_main(int argc, char** argv
     [, const char* filename, const char* optsep, ...]);
     
@tl;dr
		@(code)@
	#include "bootlj.h"
	int main(int argc, char** argv){
	  return bootlj_main(argc, argv, "main.lua", "-J");
	}
	
	~$ cc src.c -static libbootlj.a -ldl -lm 
	~$ ./a.out	#>> no such file 'main.lua'
	~$ echo 'print(123)' > main.lua	#(make main.lua in 'a.out' dir)
	~$ ./a.out	#>> disp '123' etc

	- cwd -+- a.out
	       +- main.lua	(~$ ./a.out executes './main.lua' in the same dir)
		@()
@_desc
	bootlj_main() build a luajit vm. param is:
		@(list)
	'_argc': pass the main() argc
	'_argv': pass the main() argv
	['_filename']: the boot target name. use "main.lua" if set NULL/noset
	['_optsep']: string to separate option. use "-J" if set NULL/noset
	['_...']: ignores the left __VA_ARGS__
		@()

@return_value depends on "main.lua" 1st arg of the return. nil/false/err return 1.
@_eg
	@(code)@
	---
	#include "bootlj.h"
	int main(int argc, char** argv){
	  return bootlj_main(argc, argv, "main.lua", "-J");
	  // same as:  bootlj_main(argc, argv);
	  // same as:  bootlj_main(argc, argv, NULL, NULL);
	}
	
	---
	#include "bootlj.h"
	int main(int argc, char** argv){
	  return bootlj_main(argc, argv, "myapp.lua", "abc");
	}
		
	~$ gcc -static -Wall -pedantic src.c libbootlj.a -ldl -lm 
	~$ ./a.out	#>> no such file 'myapp.lua'
	~$ echo 'print(123)' > myapp.lua
	~$ ./myapp abc -joff abc -h	#~$ luajit -joff -- myapp.lua -h

	- cwd -+- myapp (bin)
	       +- myapp.lua
	@()
@conforming_to posix-2001+
@copyright Copyright 2020 momi-g, GPLv3+
@_ver 2021-08-21 v1.0.1
@_see 'bootlj(1)'
//SH_docE*/
#define bootlj_main(ac,av,...)	bootlj_MC(ac,av,__VA_ARGS__+0, 0)
#define bootlj_MC(ac,av,name,sep, ...) bootlj_main_impl(ac,av,name,sep)
int bootlj_main_impl(int argc, char** argv, const char* name, const char* sep);
