;
; rcsID=$Id: Kana.lisp,v 1.16 2008/04/29 16:25:15 tmatsugaki Exp $
;
;(defparameter *kana* nil)
(proclaim '(optimize speed))

(defun initKana ()
  (setf *kana*
   '(
      (　    . #b000000000000000000000000000000000000000000000000) ; 全角空白１つを含む 
      (| |   . #b000000000000000000000000000000000000000000000000)

; 構成符号
      (|#|   . #b000000000000000000000000000000000000000000001111) ; #     数符
      (|;|   . #b000000000000000000000000000000000000000000000011) ; ;     外字符、字母記号、発音記号符
      (|,|   . #b000000000000000000000000000000000000000000000001) ; ,     大文字符
      ({     . #b000000000000000000000000000000000000000000011001) ; 8     外国語引用符開始
;      (}    . #b000000000000000000000000000000000000000000001011) ; 0     外国語引用符終了（cf. *us_grade1*）
      (|,8|  . #b000000000000000000000000000000000000000001011001) ; ,8    一般の日本語点字中の情報処理用点字挿入開始
;      (|,0| . #b000000000000000000000000000000000000000001001011) ; ,0    一般の日本語点字中の情報処理用点字挿入終了（cf. *us_grade1*）

;静音
      (ア    . #b000000000000000000000000000000000000000000100000) ; a
      (イ    . #b000000000000000000000000000000000000000000110000) ; i
      (ウ    . #b000000000000000000000000000000000000000000100100) ; u
      (エ    . #b000000000000000000000000000000000000000000110100) ; e
      (オ    . #b000000000000000000000000000000000000000000010100) ; o
      (カ    . #b000000000000000000000000000000000000000000100001) ; ka
      (キ    . #b000000000000000000000000000000000000000000110001) ; ki
      (ク    . #b000000000000000000000000000000000000000000100101) ; ku
      (ケ    . #b000000000000000000000000000000000000000000110101) ; ke
      (コ    . #b000000000000000000000000000000000000000000010101) ; ko
      (サ    . #b000000000000000000000000000000000000000000100011) ; sa
      (シ    . #b000000000000000000000000000000000000000000110011) ; shi
      (ス    . #b000000000000000000000000000000000000000000100111) ; su
      (セ    . #b000000000000000000000000000000000000000000110111) ; se
      (ソ    . #b000000000000000000000000000000000000000000010111) ; so
      (タ    . #b000000000000000000000000000000000000000000101010) ; ta
      (チ    . #b000000000000000000000000000000000000000000111010) ; chi
      (ツ    . #b000000000000000000000000000000000000000000101110) ; tsu
      (テ    . #b000000000000000000000000000000000000000000111110) ; te
      (ト    . #b000000000000000000000000000000000000000000011110) ; to
      (ナ    . #b000000000000000000000000000000000000000000101000) ; na
      (ニ    . #b000000000000000000000000000000000000000000111000) ; ni
      (ヌ    . #b000000000000000000000000000000000000000000101100) ; nu
      (ネ    . #b000000000000000000000000000000000000000000111100) ; ne
      (ノ    . #b000000000000000000000000000000000000000000011100) ; no
      (ハ    . #b000000000000000000000000000000000000000000101001) ; ha
      (ヒ    . #b000000000000000000000000000000000000000000111001) ; hi
      (フ    . #b000000000000000000000000000000000000000000101101) ; fu
      (ヘ    . #b000000000000000000000000000000000000000000111101) ; he
      (ホ    . #b000000000000000000000000000000000000000000011101) ; ho
      (マ    . #b000000000000000000000000000000000000000000101011) ; ma
      (ミ    . #b000000000000000000000000000000000000000000111011) ; mi
      (ム    . #b000000000000000000000000000000000000000000101111) ; mu
      (メ    . #b000000000000000000000000000000000000000000111111) ; me
      (モ    . #b000000000000000000000000000000000000000000011111) ; mo
      (ヤ    . #b000000000000000000000000000000000000000000001100) ; ya
      (ユ    . #b000000000000000000000000000000000000000000001101) ; yu
      (ヨ    . #b000000000000000000000000000000000000000000001110) ; yo
      (ラ    . #b000000000000000000000000000000000000000000100010) ; ra
      (リ    . #b000000000000000000000000000000000000000000110010) ; ri
      (ル    . #b000000000000000000000000000000000000000000100110) ; ru
      (レ    . #b000000000000000000000000000000000000000000110110) ; re
      (ロ    . #b000000000000000000000000000000000000000000010110) ; ro
      (ワ    . #b000000000000000000000000000000000000000000001000) ; wa
      (ヲ    . #b000000000000000000000000000000000000000000001010) ; wo
      (ン    . #b000000000000000000000000000000000000000000001011) ; n
      (ッ    . #b000000000000000000000000000000000000000000010000) ; (tsu)
      (ァ    . #b000000000000000000000000000000000000000110100000) ; (a)
      (ィ    . #b000000000000000000000000000000000000000110110000) ; (i)
      (ゥ    . #b000000000000000000000000000000000000000110100100) ; (u)
      (ェ    . #b000000000000000000000000000000000000000110110100) ; (e)
      (ォ    . #b000000000000000000000000000000000000000110010100) ; (wo)
      (ャ    . #b000000000000000000000000000000000000000110001100) ; (ya)
      (ュ    . #b000000000000000000000000000000000000000110001101) ; (yu)
      (ョ    . #b000000000000000000000000000000000000000110001110) ; (yo)
      (ヮ    . #b000000000000000000000000000000000000000110001000) ; (wa)

      (あ    . #b000000000000000000000000000000000000000000100000) ; a
      (い    . #b000000000000000000000000000000000000000000110000) ; i
      (う    . #b000000000000000000000000000000000000000000100100) ; u
      (え    . #b000000000000000000000000000000000000000000110100) ; e
      (お    . #b000000000000000000000000000000000000000000010100) ; o
      (か    . #b000000000000000000000000000000000000000000100001) ; ka
      (き    . #b000000000000000000000000000000000000000000110001) ; ki
      (く    . #b000000000000000000000000000000000000000000100101) ; ku
      (け    . #b000000000000000000000000000000000000000000110101) ; ke
      (こ    . #b000000000000000000000000000000000000000000010101) ; ko
      (さ    . #b000000000000000000000000000000000000000000100011) ; sa
      (し    . #b000000000000000000000000000000000000000000110011) ; shi
      (す    . #b000000000000000000000000000000000000000000100111) ; su
      (せ    . #b000000000000000000000000000000000000000000110111) ; se
      (そ    . #b000000000000000000000000000000000000000000010111) ; so
      (た    . #b000000000000000000000000000000000000000000101010) ; ta
      (ち    . #b000000000000000000000000000000000000000000111010) ; chi
      (つ    . #b000000000000000000000000000000000000000000101110) ; tsu
      (て    . #b000000000000000000000000000000000000000000111110) ; te
      (と    . #b000000000000000000000000000000000000000000011110) ; to
      (な    . #b000000000000000000000000000000000000000000101000) ; na
      (に    . #b000000000000000000000000000000000000000000111000) ; ni
      (ぬ    . #b000000000000000000000000000000000000000000101100) ; nu
      (ね    . #b000000000000000000000000000000000000000000111100) ; ne
      (の    . #b000000000000000000000000000000000000000000011100) ; no
      (は    . #b000000000000000000000000000000000000000000101001) ; ha
      (ひ    . #b000000000000000000000000000000000000000000111001) ; hi
      (ふ    . #b000000000000000000000000000000000000000000101101) ; fu
      (へ    . #b000000000000000000000000000000000000000000111101) ; he
      (ほ    . #b000000000000000000000000000000000000000000011101) ; ho
      (ま    . #b000000000000000000000000000000000000000000101011) ; ma
      (み    . #b000000000000000000000000000000000000000000111011) ; mi
      (む    . #b000000000000000000000000000000000000000000101111) ; mu
      (め    . #b000000000000000000000000000000000000000000111111) ; me
      (も    . #b000000000000000000000000000000000000000000011111) ; mo
      (や    . #b000000000000000000000000000000000000000000001100) ; ya
      (ゆ    . #b000000000000000000000000000000000000000000001101) ; yu
      (よ    . #b000000000000000000000000000000000000000000001110) ; yo
      (ら    . #b000000000000000000000000000000000000000000100010) ; ra
      (り    . #b000000000000000000000000000000000000000000110010) ; ri
      (る    . #b000000000000000000000000000000000000000000100110) ; ru
      (れ    . #b000000000000000000000000000000000000000000110110) ; re
      (ろ    . #b000000000000000000000000000000000000000000010110) ; ro
      (わ    . #b000000000000000000000000000000000000000000001000) ; wa
      (ゐ    . #b000000000000000000000000000000000000000000011000) ; i
      (ゑ    . #b000000000000000000000000000000000000000000011010) ; e
      (を    . #b000000000000000000000000000000000000000000001010) ; wo
      (ん    . #b000000000000000000000000000000000000000000001011) ; n
      (っ    . #b000000000000000000000000000000000000000000010000) ; (tsu)
      (ぁ    . #b000000000000000000000000000000000000000110100000) ; (a)
      (ぃ    . #b000000000000000000000000000000000000000110110000) ; (i)
      (ぅ    . #b000000000000000000000000000000000000000110100100) ; (u)
      (ぇ    . #b000000000000000000000000000000000000000110110100) ; (e)
      (ぉ    . #b000000000000000000000000000000000000000110010100) ; (o)
      (ゃ    . #b000000000000000000000000000000000000000110001100) ; (ya)
      (ゅ    . #b000000000000000000000000000000000000000110001101) ; (yu)
      (ょ    . #b000000000000000000000000000000000000000110001110) ; (yo)
      (ゎ    . #b000000000000000000000000000000000000000110001000) ; (wa)

;濁音・半濁音・拗音
      (ガ    . #b000000000000000000000000000000000000000010100001) ; ga
      (ギ    . #b000000000000000000000000000000000000000010110001) ; gi
      (グ    . #b000000000000000000000000000000000000000010100101) ; gu
      (ゲ    . #b000000000000000000000000000000000000000010110101) ; ge
      (ゴ    . #b000000000000000000000000000000000000000010010101) ; go
      (ザ    . #b000000000000000000000000000000000000000010100011) ; za
      (ジ    . #b000000000000000000000000000000000000000010110011) ; ji
      (ズ    . #b000000000000000000000000000000000000000010100111) ; zu
      (ゼ    . #b000000000000000000000000000000000000000010110111) ; ze
      (ゾ    . #b000000000000000000000000000000000000000010010111) ; zo
      (ダ    . #b000000000000000000000000000000000000000010101010) ; da
      (ヂ    . #b000000000000000000000000000000000000000010111010) ; di
      (ヅ    . #b000000000000000000000000000000000000000010101110) ; du
      (デ    . #b000000000000000000000000000000000000000010111110) ; de
      (ド    . #b000000000000000000000000000000000000000010011110) ; do
      (バ    . #b000000000000000000000000000000000000000010101001) ; ba
      (ビ    . #b000000000000000000000000000000000000000010111001) ; bi
      (ブ    . #b000000000000000000000000000000000000000010101101) ; bu
      (ベ    . #b000000000000000000000000000000000000000010111101) ; be
      (ボ    . #b000000000000000000000000000000000000000010011101) ; bo
      (パ    . #b000000000000000000000000000000000000000001101001) ; pa
      (ピ    . #b000000000000000000000000000000000000000001111001) ; pi
      (プ    . #b000000000000000000000000000000000000000001101101) ; pu
      (ペ    . #b000000000000000000000000000000000000000001111101) ; pe
      (ポ    . #b000000000000000000000000000000000000000001011101) ; po
      (キャ  . #b000000000000000000000000000000000000000100100001) ; kya
      (キュ  . #b000000000000000000000000000000000000000100100101) ; kyu
      (キョ  . #b000000000000000000000000000000000000000100010101) ; kyo
      (シャ  . #b000000000000000000000000000000000000000100100011) ; sha
      (シュ  . #b000000000000000000000000000000000000000100100111) ; shu
      (ショ  . #b000000000000000000000000000000000000000100010111) ; sho
      (チャ  . #b000000000000000000000000000000000000000100101010) ; cha
      (チュ  . #b000000000000000000000000000000000000000100101110) ; chu
      (チョ  . #b000000000000000000000000000000000000000100011110) ; cho
      (ニャ  . #b000000000000000000000000000000000000000100101000) ; nya
      (ニュ  . #b000000000000000000000000000000000000000100101100) ; nyu
      (ニョ  . #b000000000000000000000000000000000000000100011100) ; nyo
      (ヒャ  . #b000000000000000000000000000000000000000100101001) ; hya
      (ヒュ  . #b000000000000000000000000000000000000000100101101) ; hyu
      (ヒョ  . #b000000000000000000000000000000000000000100011101) ; hyo
      (ミャ  . #b000000000000000000000000000000000000000100101011) ; mya
      (ミュ  . #b000000000000000000000000000000000000000100101111) ; myu
      (ミョ  . #b000000000000000000000000000000000000000100011111) ; myo
      (リャ  . #b000000000000000000000000000000000000000100100010) ; rya
      (リュ  . #b000000000000000000000000000000000000000100100110) ; ryu
      (リョ  . #b000000000000000000000000000000000000000100010110) ; ryo
      (ギャ  . #b000000000000000000000000000000000000000110100001) ; gya
      (ギュ  . #b000000000000000000000000000000000000000110100101) ; gyu
      (ギョ  . #b000000000000000000000000000000000000000110010101) ; gyo
      (ジャ  . #b000000000000000000000000000000000000000110100011) ; jya
      (ジュ  . #b000000000000000000000000000000000000000110100111) ; jyu
      (ジョ  . #b000000000000000000000000000000000000000110010111) ; jyo
      (ヂャ  . #b000000000000000000000000000000000000000110101010) ; dya
      (ヂュ  . #b000000000000000000000000000000000000000110101110) ; dyu
      (ヂョ  . #b000000000000000000000000000000000000000110011110) ; dyo
      (ビャ  . #b000000000000000000000000000000000000000110101001) ; bya
      (ビュ  . #b000000000000000000000000000000000000000110101101) ; byu
      (ビョ  . #b000000000000000000000000000000000000000110011101) ; byo
      (ピャ  . #b000000000000000000000000000000000000000101101001) ; pya
      (ピュ  . #b000000000000000000000000000000000000000101101101) ; pyu
      (ピョ  . #b000000000000000000000000000000000000000101011101) ; pyo
      (ファ  . #b000000000000000000000000000000000000010001101001) ; fa
      (フィ  . #b000000000000000000000000000000000000010001111001) ; fi
      (フェ  . #b000000000000000000000000000000000000010001111101) ; fe
      (フォ  . #b000000000000000000000000000000000000010001011101) ; fo

      (が    . #b000000000000000000000000000000000000000010100001) ; ga
      (ぎ    . #b000000000000000000000000000000000000000010110001) ; gi
      (ぐ    . #b000000000000000000000000000000000000000010100101) ; gu
      (げ    . #b000000000000000000000000000000000000000010110101) ; ge
      (ご    . #b000000000000000000000000000000000000000010010101) ; go
      (ざ    . #b000000000000000000000000000000000000000010100011) ; za
      (じ    . #b000000000000000000000000000000000000000010110011) ; zi
      (ず    . #b000000000000000000000000000000000000000010100111) ; zu
      (ぜ    . #b000000000000000000000000000000000000000010110111) ; ze
      (ぞ    . #b000000000000000000000000000000000000000010010111) ; zo
      (だ    . #b000000000000000000000000000000000000000010101010) ; da
      (ぢ    . #b000000000000000000000000000000000000000010111010) ; di
      (づ    . #b000000000000000000000000000000000000000010101110) ; du
      (で    . #b000000000000000000000000000000000000000010111110) ; de
      (ど    . #b000000000000000000000000000000000000000010011110) ; do
      (ば    . #b000000000000000000000000000000000000000010101001) ; ba
      (び    . #b000000000000000000000000000000000000000010111001) ; bi
      (ぶ    . #b000000000000000000000000000000000000000010101101) ; bu
      (べ    . #b000000000000000000000000000000000000000010111101) ; be
      (ぼ    . #b000000000000000000000000000000000000000010011101) ; bo
      (ぱ    . #b000000000000000000000000000000000000000001101001) ; pa
      (ぴ    . #b000000000000000000000000000000000000000001111001) ; pi
      (ぷ    . #b000000000000000000000000000000000000000001101101) ; pu
      (ぺ    . #b000000000000000000000000000000000000000001111101) ; pe
      (ぽ    . #b000000000000000000000000000000000000000001011101) ; po
      (きゃ  . #b000000000000000000000000000000000000000100100001) ; gya
      (きゅ  . #b000000000000000000000000000000000000000100100101) ; gyu
      (きょ  . #b000000000000000000000000000000000000000100010101) ; gyo
      (しゃ  . #b000000000000000000000000000000000000000100100011) ; sya
      (しゅ  . #b000000000000000000000000000000000000000100100111) ; syu
      (しょ  . #b000000000000000000000000000000000000000100010111) ; syo
      (ちゃ  . #b000000000000000000000000000000000000000100101010) ; cha
      (ちゅ  . #b000000000000000000000000000000000000000100101110) ; chu
      (ちょ  . #b000000000000000000000000000000000000000100011110) ; cho
      (にゃ  . #b000000000000000000000000000000000000000100101000) ; nya
      (にゅ  . #b000000000000000000000000000000000000000100101100) ; nyu
      (にょ  . #b000000000000000000000000000000000000000100011100) ; nyo
      (ひゃ  . #b000000000000000000000000000000000000000100101001) ; hya
      (ひゅ  . #b000000000000000000000000000000000000000100101101) ; hyu
      (ひょ  . #b000000000000000000000000000000000000000100011101) ; hyo
      (みゃ  . #b000000000000000000000000000000000000000100101011) ; mya
      (みゅ  . #b000000000000000000000000000000000000000100101111) ; myu
      (みょ  . #b000000000000000000000000000000000000000100011111) ; myo
      (りゃ  . #b000000000000000000000000000000000000000100100010) ; rya
      (りゅ  . #b000000000000000000000000000000000000000100100110) ; ryu
      (りょ  . #b000000000000000000000000000000000000000100010110) ; ryo
      (ぎゃ  . #b000000000000000000000000000000000000000110100001) ; gya
      (ぎゅ  . #b000000000000000000000000000000000000000110100101) ; gyu
      (ぎょ  . #b000000000000000000000000000000000000000110010101) ; gyo
      (じゃ  . #b000000000000000000000000000000000000000110100011) ; jya
      (じゅ  . #b000000000000000000000000000000000000000110100111) ; jyu
      (じょ  . #b000000000000000000000000000000000000000110010111) ; jyo
      (ぢゃ  . #b000000000000000000000000000000000000000110101010) ; dya
      (ぢゅ  . #b000000000000000000000000000000000000000110101110) ; dyu
      (ぢょ  . #b000000000000000000000000000000000000000110011110) ; dyo
      (びゃ  . #b000000000000000000000000000000000000000110101001) ; bya
      (びゅ  . #b000000000000000000000000000000000000000110101101) ; byu
      (びょ  . #b000000000000000000000000000000000000000110011101) ; byo
      (ぴゃ  . #b000000000000000000000000000000000000000101101001) ; pya
      (ぴゅ  . #b000000000000000000000000000000000000000101101101) ; pyu
      (ぴょ  . #b000000000000000000000000000000000000000101011101) ; pyo
      (ふぁ  . #b000000000000000000000000000000000000010001101001) ; fa
      (ふぃ  . #b000000000000000000000000000000000000010001111001) ; fi
      (ふぇ  . #b000000000000000000000000000000000000010001111101) ; fe
      (ふぉ  . #b000000000000000000000000000000000000010001011101) ; fo

;特殊音
      (イェ  . #b000000000000000000000000000000000000000100101001) ; ye
      (キェ  . #b000000000000000000000000000000000000000100110101) ; kye
      (シェ  . #b000000000000000000000000000000000000000100110111) ; she
      (チェ  . #b000000000000000000000000000000000000000100111110) ; che
      (ニェ  . #b000000000000000000000000000000000000000100111100) ; nye
      (ヒェ  . #b000000000000000000000000000000000000000100111101) ; hye
      (スィ  . #b000000000000000000000000000000000000000100110011) ; swi
      (ティ  . #b000000000000000000000000000000000000000100111010) ; thi
      (ジェ  . #b000000000000000000000000000000000000000110110111) ; je
      (ズィ  . #b000000000000000000000000000000000000000110110011) ; zwi
      (ディ  . #b000000000000000000000000000000000000000110111010) ; dhi
      (ウィ  . #b000000000000000000000000000000000000010001110000) ; whi
      (ウェ  . #b000000000000000000000000000000000000010001110100) ; whe
      (ウォ  . #b000000000000000000000000000000000000010001010100) ; who
      (トゥ  . #b000000000000000000000000000000000000010001101110) ; twu
      (クァ  . #b000000000000000000000000000000000000010001100001) ; kwa
      (クィ  . #b000000000000000000000000000000000000010001110001) ; kwi
      (クェ  . #b000000000000000000000000000000000000010001110101) ; kwe
      (クォ  . #b000000000000000000000000000000000000010001010101) ; kwo
      (ドゥ  . #b000000000000000000000000000000000000010011101110) ; dwu
      (グァ  . #b000000000000000000000000000000000000010011100001) ; gwa
      (グィ  . #b000000000000000000000000000000000000010011110001) ; gwi
      (グェ  . #b000000000000000000000000000000000000010011110101) ; gwe
      (グォ  . #b000000000000000000000000000000000000010011010101) ; gwo
      (テュ  . #b000000000000000000000000000000000000000101101110) ; thu
      (フュ  . #b000000000000000000000000000000000000000101001101) ; fyu
      (フョ  . #b000000000000000000000000000000000000000101001110) ; fyo
      (ツァ  . #b000000000000000000000000000000000000010001101010) ; tsa
      (ツィ  . #b000000000000000000000000000000000000010001111010) ; tsi
      (ツェ  . #b000000000000000000000000000000000000010001111110) ; tse
      (ツォ  . #b000000000000000000000000000000000000010001011110) ; tso
      (デュ  . #b000000000000000000000000000000000000000111101110) ; dhu
      (ヴュ  . #b000000000000000000000000000000000000000111001101) ; vyu
      (ヴョ  . #b000000000000000000000000000000000000000111001110) ; vye
      (ヴ    . #b000000000000000000000000000000000000000010100100) ; vu
      (ヴァ  . #b000000000000000000000000000000000000010011101001) ; va
      (ヴィ  . #b000000000000000000000000000000000000010011111001) ; vi
      (ヴェ  . #b000000000000000000000000000000000000010011111101) ; ve
      (ヴォ  . #b000000000000000000000000000000000000010011011101) ; vo

      (いぇ  . #b000000000000000000000000000000000000000100101001) ; ye
      (きぇ  . #b000000000000000000000000000000000000000100110101) ; kye
      (しぇ  . #b000000000000000000000000000000000000000100110111) ; she
      (ちぇ  . #b000000000000000000000000000000000000000100111110) ; che
      (にぇ  . #b000000000000000000000000000000000000000100111100) ; nye
      (ひぇ  . #b000000000000000000000000000000000000000100111101) ; hye
      (すぃ  . #b000000000000000000000000000000000000000100110011) ; swi
      (てぃ  . #b000000000000000000000000000000000000000100111010) ; thi
      (じぇ  . #b000000000000000000000000000000000000000110110111) ; je
      (ずぃ  . #b000000000000000000000000000000000000000110110011) ; zwi
      (でぃ  . #b000000000000000000000000000000000000000110111010) ; dhi
      (うぃ  . #b000000000000000000000000000000000000010001110000) ; whi
      (うぇ  . #b000000000000000000000000000000000000010001110100) ; whe
      (うぉ  . #b000000000000000000000000000000000000010001010100) ; who
      (とぅ  . #b000000000000000000000000000000000000010001101110) ; twu
      (くぁ  . #b000000000000000000000000000000000000010001100001) ; kwa
      (くぃ  . #b000000000000000000000000000000000000010001110001) ; kwi
      (くぇ  . #b000000000000000000000000000000000000010001110101) ; kwe
      (くぉ  . #b000000000000000000000000000000000000010001010101) ; kwo
      (どぅ  . #b000000000000000000000000000000000000010011101110) ; dwu
      (ぐぁ  . #b000000000000000000000000000000000000010011100001) ; gwa
      (ぐぃ  . #b000000000000000000000000000000000000010011110001) ; gwi
      (ぐぇ  . #b000000000000000000000000000000000000010011110101) ; gwe
      (ぐぉ  . #b000000000000000000000000000000000000010011010101) ; gwo
      (てゅ  . #b000000000000000000000000000000000000000101101110) ; thu
      (ふゅ  . #b000000000000000000000000000000000000000101001101) ; fyu
      (ふょ  . #b000000000000000000000000000000000000000101001110) ; fyo
      (つぁ  . #b000000000000000000000000000000000000010001101010) ; tsa
      (つぃ  . #b000000000000000000000000000000000000010001111010) ; tsi
      (つぇ  . #b000000000000000000000000000000000000010001111110) ; tse
      (つぉ  . #b000000000000000000000000000000000000010001011110) ; tso
      (でゅ  . #b000000000000000000000000000000000000000111101110) ; dhu
      (ゔゅ  . #b000000000000000000000000000000000000000111001101) ; vyu
      (ゔぇ  . #b000000000000000000000000000000000000000111001110) ; vye
      (ゔ    . #b000000000000000000000000000000000000000010100100) ; vu
      (ゔぁ  . #b000000000000000000000000000000000000010011101001) ; va
      (ゔぃ  . #b000000000000000000000000000000000000010011111001) ; vi
      (ゔぇ  . #b000000000000000000000000000000000000010011111101) ; ve
      (ゔぉ  . #b000000000000000000000000000000000000010011011101) ; vo
;記号・数字・アルファベット
      (％ . #b000000000000000000000000000000000000000011111100)    ; ;p    パーセント
      (＆ . #b000000000000000000000000000000000000000011111101)    ; ;&    アンパーサント
      (＃ . #b000000000000000000000000000000000000000011100101)    ; ;%    ナンバーサイン
      (＊ . #b000000000000000000000000000000000000000011100001)    ; ;*    ※印
      (◯ . #b000000000000000000000000000000000000000010101011)    ; "z    丸
      (△ . #b000000000000000000000000000000000000000010111011)    ; "(    三角
      (□ . #b000000000000000000000000000000000000000010101111)    ; "y    四角
      (× . #b000000000000000000000000000000000000000010111111)    ; "=    バツ
      (■ . #b000000000000000000000000000000000000000010011111)    ; ")    黒四角
      (． . #b000000000000000000000000000000000000000000010011)    ; 4     ドット
      (．　 . #b000000000000000000000000000000000000010011000000)  ; 40    全角空白１つを含む 
      (。　　 . #b000000000000000000000000000000010011000000000000) ; 400   全角空白２つを含む
      (、　 . #b000000000000000000000000000000000000000011000000)  ; ;0    全角空白１つを含む
      (！ . #b000000000000000000000000000000011010000000000000)    ; 600   エクスクラメーション
      (・ . #b000000000000000000000000000000000000000000000010)    ; "     中点
      (？ . #b000000000000000000000000000000000000000000010001)    ; 5     クエスチョン

      (〜〜   . #b000000000000000000000000000000000000001001001001) ; --  （直交性悪し！！）
      (「     . #b000000000000000000000000000000000000000000001001) ; -    第一カギ（始まり）、第一カギ（終わり）、ダッシュ
      (」     . #b000000000000000000000000000000000000000000001001) ; -    第一カギ（終わり）、第一カギ（始まり）、ダッシュ
      (『     . #b000000000000000000000000000000000000000011001001) ; ;-   二重カギ（始まり）
      (』     . #b000000000000000000000000000000000000001001011000) ; -2   二重カギ（終わり）
      (（     . #b000000000000000000000000000000000000000000011011) ; 7    第一括弧（始まり）
      (）     . #b000000000000000000000000000000000000000000011011) ; 7    第一括弧（終わり）
      (【     . #b000000000000000000000000000000000000000011011011) ; ;7   第二カギ（始まり）
      (】     . #b000000000000000000000000000000000000011011011000) ; 72   第二カギ（終わり）
      (＜     . #b000000000000000000000000000000000000000011001000) ; ;'   小なり
      (／     . #b000000000000000000000000000000000000000000000111) ; _    スラッシュ
      (＞     . #b000000000000000000000000000000000000000001011000) ; ,2   大なり
      (□□□ . #b000000000000000000000000000111101101101101111000) ; _xxl 空欄符号
      (ー     . #b000000000000000000000000000000000000000000010010) ; 3    ハイフン
      (―     . #b000000000000000000000000000000000000000000010010) ; 3    ダッシュ、第一カギ（始まり）、第一カギ（終わり）
      (‥     . #b000000000000000000000000000000000000000000010000) ; 1    点線
    )
  )
)

;(assoc 'ア *kana*)
;(dolist (x *kana*) (print x))
