;
; rcsID=$Id: LiteraryUK.lisp,v 1.16 2008/04/29 16:25:15 tmatsugaki Exp $
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;system version 35
;BRITISH BRAILLE
;A Restatement of Standard English Braille
;Compiled and Authorised by the
;Braille Authority of the United Kingdom
;
;Royal National Institute for the Blind
;Bakewell Road, Orton Southgate
;Peterborough, Cambridgeshire
;PE2 6XU
;
;2001
;ISBN 0 901797 90 1
;© Braille Authority of the United Kingdom 1992, 2001
;Printed by RNIB, Peterborough 2001
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(proclaim '(inline genUkGrade2Dictionary
                   saveUkGrade2ExtFile
                   loadUkGrade2ExtFile
                   genUkGrade2DicInfo
                   updateUkG2DicAccessInfo
                   setUkDicMaxLength))
(proclaim '(optimize speed))

#|
(defparameter *uk_grade1* nil)
(defparameter *uk_grade2* nil)
(defparameter *uk_grade3* nil)
(defparameter *uk_grade4* nil)
(defparameter *uk_grade2_enc_dict* nil)
(defparameter *uk_grade2_dec_dict* nil)
|#

(defun initLiteraryUK ()
  (setf *uk_grade1* *us_grade1*)
  (setf *uk_grade2* *us_grade2*)
  (setf *uk_grade3* *us_grade3*)
  (setf *uk_grade4* *us_grade4*))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 genUkGrade2Dictionary
;; 【機能　】 ファイルのデータから英語グレード２辞書の連想配列やファイルを作成する。
;; 【入力　】 infn : 辞書データファイル（入力）のパス
;; 【出力　】 エラー情報のリスト
;; 【例外　】 なし
;; 【使用例】 (genUkGrade2Dictionary "../dic/uk_grade2.txt")
;;           → nil
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun genUkGrade2Dictionary (infn)
  (let (buff (lineNo 1) (gradeSaver *grade*) (isJP (string= *defaultMode* "JP")) (errList nil))
    (setf *uk_grade2_enc_dict* nil *uk_grade2_dec_dict* nil)
    (initLang 2 "uk")
    ;; 辞書入力ファイルをオープンする。
    (with-open-file (instream infn :direction :input)
      (do ()
        ((null (setf buff (read-line instream nil))) nil)
        ; 1行エンコードする。
        (if (and (> (length buff) 1)
                 (string/= (subseq buff 0 2) _commentMark_)) ; ";;"
          (progn
            (registUkGrade2Dic buff lineNo nil errList)
            (incf lineNo))
          nil))
      ;; 辞書入力ファイルをクローズする。
      (close instream))
    (initLang gradeSaver "uk" isJP)
    (setUkDicMaxLength)
    errList))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 registUkGrade2Dic
;; 【機能　】 バッファのデータから英語グレード２（英国）辞書の連想配列情報を登録する。
;; 【入力　】 buff   : 辞書データファイル（入力）のパス
;;          lineNo : 行番号
;;          scan   : 連想配列を検索するか否か
;; 【出力　】 エラー情報のリスト
;; 【例外　】 なし
;; 【使用例】 (registUkGrade2Dic ",w" 1 nil nil)
;;           → nil
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun registUkGrade2Dic (buff lineNo scan errList)
  (let ((srcStr nil) lst flags (mask 0) enc dec convPair s b e)
    (setf lst (split-string buff _fieldSeparator_))
    (setf buff (nth 0 lst))
    (setf flags (nth 1 lst))
    ; フラグに応じて辞書の結合マスクを設定する。
    ; Whole
    (if (search "w" flags) (setf mask (logior mask _wholeWordMask_)) nil)
    ; Initial
    (if (search "i" flags) (setf mask (logior mask _initialWordMask_)) nil)
    ; Medial
    (if (search "m" flags) (setf mask (logior mask _medialWordMask_)) nil)
    ; Final
    (if (search "f" flags) (setf mask (logior mask _finalWordMask_)) nil)
    (setf convPair (explode-string buff '("→") nil))
    (if (= (length convPair) 2) ; 直接変換がある場合
      (progn
        (setf srcStr (substitute-string (nth 0 convPair) "→" ""))
        (setf buff (nth 1 convPair)))
      nil)
    (multiple-value-setq (s b e) (genUkGrade2DicInfo buff lineNo))
    (if e (push e errList) nil)
    (if srcStr ; 直接変換がある場合
      (progn
        (setf enc (list (intern srcStr) nil mask b 0)
              dec (list (intern b) nil mask srcStr 0))
        ; エンコード用辞書登録
        (if (and scan (assoc (intern srcStr) *uk_grade2_enc_dict*))
          (setf (car (assoc (intern srcStr) *uk_grade2_enc_dict*)) enc)
          (push enc *uk_grade2_enc_dict*))
        ; デコード用辞書登録
        (if (and scan (assoc (intern b) *uk_grade2_dec_dict*))
          (setf (car (assoc (intern b) *uk_grade2_dec_dict*)) dec)
          (setf dec *uk_grade2_dec_dict*)))
      (progn
        (setf enc (list (intern s) nil mask b 0)
              dec (list (intern b) nil mask s 0))
        ; エンコード用辞書登録
        (if (and scan (assoc (intern s) *uk_grade2_enc_dict*))
          (do ((i 0 (1+ i)))
            ((= i (length enc)) nil)
            (setf (nth i (assoc (intern s) *uk_grade2_enc_dict*)) (nth i enc)))
          (push enc *uk_grade2_enc_dict*))
        ; デコード用辞書登録
        (if (and (assoc (intern b) *uk_grade2_dec_dict*))
          (do ((i 0 (1+ i)))
            ((= i (length dec)) nil)
            (setf (nth i (assoc (intern b) *uk_grade2_dec_dict*)) (nth i dec)))
          (push dec *uk_grade2_dec_dict*))))
    (format nil "(~S ~S)" enc dec)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 saveUkGrade2ExtFile
;; 【機能　】 ファイルのデータから英語グレード２辞書のエクストラクトファイルを作成する。
;; 【入力　】 extfn : 辞書エクストラクトファイル（出力用）のパス
;; 【出力　】 エラー情報のリスト
;; 【例外　】 なし
;; 【使用例】 (saveUkGrade2ExtFile "../dic/uk_grade2.ext" t)
;;           → nil
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun saveUkGrade2ExtFile (extfn &optional (collect nil))
  (let ((delim _fieldSeparator_) (errList nil))
    (if (and *uk_grade2_enc_dict* *uk_grade2_dec_dict*)
      (let ((gradeSaver *grade*) (isJP (string= *defaultMode* "JP")))
        (initLang 2 "uk")
        ;; 辞書エクストラクトファイルを削除する。
        (if (probe-file extfn)
          (delete-file extfn)
          nil)
        ;; 辞書エクストラクトファイルをライトオープンする。
        (with-open-file (outstream extfn :direction :output :if-exists :new-version)
          (let ((lineNo 0) g2infoEnc g2infoDec encRefCnt decRefCnt)
            (dolist (xx *uk_grade2_enc_dict*)
              (setf g2infoEnc (nth lineNo *uk_grade2_enc_dict*))
              (setf g2infoDec (nth lineNo *uk_grade2_dec_dict*))
              (if collect
                (progn
                  (setf encRefCnt (getCount (nth _dic_symbol_index_ g2infoEnc)))
                  (setf decRefCnt (getCount (nth _dic_symbol_index_ g2infoDec)))
                  ; エンコード用の辞書の参照回数を更新する。
                  (replace g2infoEnc (list encRefCnt) :start1 _dic_ref_count_index_)
                  ; デコード用の辞書の参照回数を更新する。
                  (replace g2infoDec (list decRefCnt) :start1 _dic_ref_count_index_))
                nil)
              (format outstream "~S~A~S~%" g2infoEnc delim g2infoDec)
              (incf lineNo)))
          ;; 辞書エクストラクトファイルをクローズする。
          (close outstream))
        (initLang gradeSaver "uk" isJP))
      (push "*uk_grade2_enc_dict* または *uk_grade2_dec_dict* が設定されていません。" errList))
    errList))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 loadUkGrade2ExtFile
;; 【機能　】 ファイルのデータから英語グレード２辞書の連想配列やファイルを作成する。
;; 【入力　】 extfn : 辞書エクストラクトファイル（入力）のパス
;; 【出力　】 エラー情報のリスト
;; 【例外　】 なし
;; 【使用例】 (loadUkGrade2ExtFile "../dic/uk_grade2.ext")
;;           → nil
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun loadUkGrade2ExtFile (extfn)
  (let (buff (lineNo 1) (delim _fieldSeparator_) (gradeSaver *grade*) (isJP (string= *defaultMode* "JP")) (errList nil))
    (setf *uk_grade2_enc_dict* nil *uk_grade2_dec_dict* nil)
    (initLang 2 "uk")
    ;; 辞書エクストラクトファイルをリードオープンする。
    (with-open-file (instream extfn :direction :input)
      (let (lst tmp)
        (do ()
          ; 1行読み込み、エンコード・デコード情報を取得する。
          ((null (setf buff (read-line instream nil))) nil)
          (if (and (> (length buff) 1)
                   (string/= (subseq buff 0 1) "("))
            (progn
              ; エンコード情報、デコード情報の区切りは、_fieldSeparator_。
              (setf lst (split-string buff delim))
              ; エンコード情報を追加する。
              (setf tmp (nth 0 lst))
              (if (> *debug* 0)
                (format t "~S:~S~%" lineNo tmp)
                nil)
              (push (read-from-string tmp) *uk_grade2_enc_dict*)
              ; デコード情報を追加する。
              (setf tmp (nth 1 lst))
              (if (> *debug* 0)
                (format t "~S:~S~%" lineNo tmp)
                nil)
              (push (read-from-string tmp) *uk_grade2_dec_dict*)
              (incf lineNo))
            (push buff errList))))
      ;; 辞書エクストラクトファイルをクローズする。
      (close instream))
    (initLang gradeSaver "uk" isJP)
    (setUkDicMaxLength)
    errList))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 genUkGrade2DicInfo
;; 【機能　】 1行の文字列から英語グレード２の辞書の連想配列のメンバー情報を作成する。
;; 【入力　】 buff   : 文字列
;;            lineNo : 行番号
;; 【出力　】 墨字、点字、エラー情報のリスト
;; 【例外　】 なし
;; 【使用例】 (g2uk) (genUkGrade2DicInfo "(st)oreroom" 1) → "storeroom"
;;                                                       "/OREROOM"
;;                                                       NIL
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun genUkGrade2DicInfo (buff lineNo)
  (let ((sret nil) (bret nil) lst ds b tokLen errList)
    (setf lst (explode-string buff '("(" ")") nil))
    (dolist (s lst)
      (setf tokLen (length s))
      (if (string= (subseq s (1- tokLen) tokLen) ")")
        (progn ; 括弧の中はチャンクで処理する。
          (setf ds (string-downcase (substitute-string s ")" "")))
          (setf b (encodeBrailleStr ds nil *defaultMode* 0 t nil t))
          (if (null b) (push (list lineNo buff ds) errList) nil)
          (setf sret (concatenate 'string sret ds))
          (setf bret (concatenate 'string bret b)))
        (if (string/= s "(")
          (let (tlst) ; 括弧の外は一文字づつ処理する。
            (setf ds (string-downcase s))
            (setf tlst (explode-string ds '("")))
            (dolist (ts tlst)
              (if (string/= ts "(")
                (progn
                  ; 半角の空白は変換しない。
                  (if (string= ts _blank_s_)
                    (setf b _blank_s_)
                    (setf b (encodeBrailleStr ts nil *defaultMode* 0 t nil t)))
                  ; "." はマニュアルで "4" に変換する。
                  (if (string= b _dot_s_)
                    (setf b (substitute-string b _dot_s_ _dot_brl_))
                    nil)
                  ; エラー（点字が存在しない。）
                  (if (null b) (push (list lineNo buff ds ts) errList) nil)
                  (setf sret (concatenate 'string sret ts))
                  (setf bret (concatenate 'string bret b)))
                nil)))
          nil)))
    (values sret bret errList)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 updateUkG2DicAccessInfo
;; 【機能　】 ファイルのデータから URLサフィックスリストを作成する。
;; 【入力　】 infn : URLサフィックスファイルのパス
;; 【出力　】 エラー情報のリスト
;; 【例外　】 なし
;; 【使用例】 (updateUkG2DicAccessInfo ) → nil
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun updateUkG2DicAccessInfo (g2info)
  (let (cell (sym (nth _dic_symbol_index_ g2info)) cnt)
    (setf cell (assoc sym *g2DicRefCntList*))
    (if cell
      (progn
        (setf cnt (1+ (cdr cell)))
        ; 以前のコンスセルを削除する。
        (delete-if #'(lambda(x) (equal x cell)) *g2DicRefCntList*))
      (setf cnt 1))
    (setf *g2DicRefCntList* (acons sym cnt *g2DicRefCntList*))
    *g2DicRefCntList*))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 setUkDicMaxLength
;; 【機能　】 英語グレード２辞書メンバーの最大長を設定する。
;; 【入力　】 なし
;; 【出力　】 なし
;; 【例外　】 なし
;; 【使用例】 (setUkDicMaxLength)
;;           → t
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun setUkDicMaxLength ()
  (setf *maxDicBrailleLength*
    (progn
      (let (lst)
        (setf lst (mapcar #'(lambda(x) (length (string (nth _dic_symbol_index_ x)))) *uk_grade2_dec_dict*))
        (apply 'max lst))))
  (setf *maxDicSumijiLength*
    (progn
      (let (lst)
        (setf lst (mapcar #'(lambda(x) (length (string (nth _dic_symbol_index_ x)))) *uk_grade2_enc_dict*))
        (apply 'max lst))))
  nil)

(defun uk_grade2_test (lit)
  (if
    (numberp (cdr (assoc lit *uk_grade2*)))
    (conv lit *uk_grade2* *represent*)
    (let (l (s nil))
      (setf l (cdr (assoc lit *uk_grade2*)))
      (dolist (x l)
        (setf s (concatenate 'string s (conv x *common* *represent*))))
      (values s))))
