;
; rcsID=$Id: Reader.lisp,v 1.16 2008/04/29 16:25:15 tmatsugaki Exp $
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; エンコード用のリードマクロ宣言
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defdelim #\[ #\] (s)
  (bc_encodeBrailleStr (string s)))

(defun bc_encodeBrailleStr (s)
  (let (ret)
    (multiple-value-bind (tmp)
      (encodeBrailleStr s nil *defaultMode* 1 *separatePrepOrInf* *putCapitalSign* nil)
      (setf ret tmp))
    ; 表示用の言語用連想配列を用いて、文字からバイナリのデータを取得する。
    (if *encodeIntoBinary*
      (let ((lst nil) (strlen (length ret)) tmp)
        (do ((i 0 (1+ i)))
          ((>= i strlen) nil)
          (setf lst (append lst (list (cdr (assoc (intern (subseq ret i (1+ i))) *represent*))))))
        (setf tmp (format nil "~{~6,'0b ~}" lst))
        (setf ret (subseq tmp 0 (1- (length tmp)))))
      nil)
    ret))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; デコード用のリードマクロ宣言
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defdelim #\{ #\} (s)
  (bc_decodeBrailleStr (string s)))

(defun bc_decodeBrailleStr (s)
  (let (ret (ss s))
    ; 表示用の言語用連想配列を用いて、バイナリのデータから文字を取得する。
    (if *decodeFromBinary*
      (let (lst)
        (setf lst
          (mapcar #'(lambda (x)
                      (format nil "~A" (car (rassoc (parse-integer x :radix 2) *represent*))))
                      (split-string s)))
        (setf ss (join-string lst _blank_s_)))
      nil)
    (multiple-value-bind (tmp)
      (decodeBrailleStr ss nil *defaultMode* 1 *hankaku* *separatePrepOrInf*
        *emitSigns* *jpPrep*)
      (setf ret tmp))
    ret))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; 辞書登録用のリードマクロ宣言
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defdelim #\% #\% (s)
  (bc_registDic (string s)))

(defun bc_registDic (buff)
  (let ((ret nil))
    (if (and (> (length buff) 1)
             (string/= (subseq buff 0 2) _commentMark_)) ; ";;"
      ; 英語グレード２の辞書にワードを登録する。
      (if (string= (string-downcase *defaultEnglish*) "uk")
        (progn
          (g2uk)
          (setf ret (registUkGrade2Dic buff 0 t nil)))
        (progn
          (g2us)
          (setf ret (registUsGrade2Dic buff 0 t nil))))
      nil)
      ; 英語グレード２の辞書を設定する。
      (if (string= (string-downcase *defaultEnglish*) "uk")
        (setf *grade2_enc_dict* *uk_grade2_enc_dict*
              *grade2_dec_dict* *uk_grade2_dec_dict*)
        (setf *grade2_enc_dict* *us_grade2_enc_dict*
              *grade2_dec_dict* *us_grade2_dec_dict*))
    (format nil "~A" ret)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; 上記リードマクロが使用する設定情報アクセス用マクロの宣言
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defmacro hankaku () (setf *hankaku* t) (setf *defaultMode* *defaultEnglish*))
(defmacro zenkaku () (setf *hankaku* nil) (setf *defaultMode* "JP"))
(defmacro rowBytes (x) (setf *rowBytes* x))
(defmacro pageLines (x) (setf *pageLines* x))
(defmacro separatePrepOrInf (x) (setf *separatePrepOrInf* x))
(defmacro emitSigns (x) (setf *emitSigns* x))
(defmacro jpPrep (x) (setf *jpPrep* x))
(defmacro putCapitalSign (x) (setf *putCapitalSign* x))
(defmacro emitHeader (x) (setf *emitHeader* x))
(defmacro encodeIntoBinary (x) (setf *encodeIntoBinary* x))
(defmacro decodeFromBinary (x) (setf *decodeFromBinary* x))
; デバッグ用
(defmacro useG2dic (x) (setf *useG2dic* x))
