;
; rcsID=$Id: debug.lisp,v 1.17 2008/04/29 16:25:15 tmatsugaki Exp $
;
;(handler-case (read) (error (c) c))
(proclaim '(optimize speed))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ユーティリティー
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun dbg (&optional (level nil))
  (if level
    (setf *debug* level)
    (progn
      (format t "~%デバッグレベル(0-9)")
      (format t "~% 0:デバッグ文を表示しない。")
      (format t "~% 1:チャンクに特化したデバッグ表示をする。")
      (format t "~% 2:英語グレード２の結合情報等と括弧状態の表示をする。")
      (format t "~% 3:点字と墨字を左右に連結して表示する。")
      (format t "~% 4:辞書の登録・参照状況を表示する。")
      (format t "~% 5:maintainSubstrCount の状況を表示する。")
      (format t "~% 6:wordList2String のフラグを表示する。")
      (format t "~% 7:wordList2String の出力時の内部状態を表示する。")
      (format t "~% 8:decideCombination の状況を表示する。")
      (format t "~% 9:wordList2String の入出力を表示する。"))))

(defun debug1-mode (dbgLevel id o_mode n_mode lst showMask)
  (if (/= (logand 1 showMask) 0)
    (progn
      (format t "~%~% ~S ~S-------------------" dbgLevel id)
      (format t "~% ~2A  | ~3A | ~3A | ~4A" "id" "omd" "nmd" "list")
      (format t "~% ----+-----+-----+------"))
    nil)
  (if (/= (logand 2 showMask) 0)
    (progn
      (format t "~%[~2A] | ~3A | ~3A | ~S"   id   o_mode n_mode lst))
    nil))

(defun debug1-desc (dbgLevel id grade o_mode n_mode b s extra symbol bracketStats showMask)
  (if (/= (logand 1 showMask) 0)
    (progn
      (format t "~%~% ~S ~S----------------------------------------------------------------------------------" dbgLevel id)
      (format t "~% ~2A  | ~5A | ~3A | ~3A | ~3A | ~7A | ~7A | ~7A | ~7A | ~A"
                    "id"  "grade" "FG1" "omd" "nmd" "Braille" "Roman" "N/A" "symbol" "bracketStats")
      (format t "~% ----+-------+-----+-----+-----+---------+---------+----------+----------+-------------"))
    nil)
  (if (/= (logand 2 showMask) 0)
    (progn
      (format t "~%[~2A] | ~5A | ~3A | ~3A | ~3A | ~7S | ~7S | ~7S  | ~7S | #b~8,'0b"
                    id  grade *forceGrade1* o_mode n_mode  b    s    extra symbol bracketStats))
    nil))

(defun debug2-enc (dbgLevel id fg1 g2i whole init mid fin sLen tail left past s next substr_cnt b showMask)
  (if (/= (logand 1 showMask) 0)
    (progn
      (format t "~%~% ~S ~S-------------------------------------------------------------------------------------------------------------------" dbgLevel id)
      (format t "~%[~3A][~3A] ( ~3A | ~3A | ~3A | ~3A )[~3A][~10A] [~10A] [~10A] [~10A] [~10A] [~10A] [~10A]"
                   "FG1" "G2I" "whl" "ini" "mid" "fin" "len" "tail" "left" "past"  "Roman"  "next" "substr_cnt" "Braille")
      (format t "~% ------------------------+----+-----------+------------+------------+------------+------------+------------+------------"))
    nil)
  (if (/= (logand 2 showMask) 0)
    (progn
      (format t "~%[~3S][~3S] ( ~3S | ~3S | ~3S | ~3S )[~3S][~10S] [~10S] [~10S] [~10S] [~10S] [~10S] [~10S]"
                    fg1  g2i   whole  init  mid   fin   sLen tail    left   past     s    next substr_cnt b))
    nil))

(defun debug2-dec (dbgLevel id fg1 g2i imd whole init mid fin sLen tail left past b next substr_cnt s showMask)
  (if (/= (logand 1 showMask) 0)
    (progn
      (format t "~%~% ~S ~S-----------------------------------------------------------------------------------------------------------------------------------" dbgLevel id)
      (format t "~%[~3A][~3A][~3A] ( ~3A | ~3A | ~3A | ~3A )[~3A][~10A] [~10A] [~10A] [~10A] [~10A] [~10A] [~10A]"
                  "FG1" "G2I" "IMD" "whl" "ini" "mid" "fin" "len" "tail" "left" "past"  "Braille"  "next" "substr_cnt" "Roman")
      (format t "~% --------------+------+-----+-----+------+----+-----------+------------+------------+------------+------------+------------+------------"))
    nil)
  (if (/= (logand 2 showMask) 0)
    (progn
      (format t "~%[~3S][~3S][~3S] ( ~3S | ~3S | ~3S | ~3S )[~3S][~10S] [~10S] [~10S] [~10S] [~10S] [~10S] [~10S]"
                    fg1   g2i   imd  whole init  mid   fin   sLen  tail   left   past   b     next substr_cnt s))
    nil))

(defun debug6-flags (dbgLevel id txt brl after-prep-inf-conj force-raw-next ocAbbrWordLedByPunc ocAbbrWordFollowedByPunc lwAbbrWordLedByPunc lwAbbrWordFollowedByPunc showMask)
  (if (/= (logand 1 showMask) 0)
    (progn
      (format t "~%~% ~S ~S------------------------------------------------------------------------------------------------------------------------------" dbgLevel id)
      (format t "~%| ~10A | ~10A | ~A | ~A | ~A | ~A | ~A | ~A |"
                   "Roman" "Braille" "after-prep-inf-conj" "force-raw-next" "ocLedByPunc" "ocFollowedByPunc" "lwLedByPunc" "lwFollowedByPunc")
      (format t "~% ------------+------------+---------------------+----------------+-------------+------------------+-------------+------------------"))
    nil)
  (if (/= (logand 2 showMask) 0)
    (progn
      (format t "~%| ~10S | ~10S | ~19S | ~14S | ~11S | ~16S | ~11S | ~16S |"
                     txt  brl after-prep-inf-conj force-raw-next ocAbbrWordLedByPunc ocAbbrWordFollowedByPunc lwAbbrWordLedByPunc lwAbbrWordFollowedByPunc))
    nil))

(defun debug5-maintainSubstrCount (dbgLevel id substr_cnt effective_last_s s b showMask)
  (if (/= (logand 1 showMask) 0)
    (progn
      (format t "~%~% ~S ~S-------------------------------------------------------------------------" dbgLevel id)
      (format t "~% ~10A  | ~16A | ~20A | ~20A"
                    "substr_cnt" "effective_last_s" "Roman" "Braille")
      (format t "~% ------------+------------------+----------------------+----------------------"))
    nil)
  (if (/= (logand 2 showMask) 0)
    (progn
      (format t "~% ~10S  | ~16S | ~20S | ~20S"
                  substr_cnt effective_last_s s b))
    nil))

(defun debug6-intern (dbgLevel id txt brl after-prep-inf-conj force-raw-next ocAbbrWordLedByPunc ocAbbrWordFollowedByPunc lwAbbrWordLedByPunc lwAbbrWordFollowedByPunc lastWord nextWord showMask)
  (if (/= (logand 1 showMask) 0)
    (progn
      (format t "~%~% ~S ~S-------------------------------------------------------------------------------------------------------------------------------------------------------------" dbgLevel id)
      (format t "~%| ~10A | ~10A | ~19A | ~14A | ~11A | ~16A | ~11A | ~16A | ~22A | ~22A |"
                   "Roman" "Braille" "after-prep-inf-conj" "force-raw-next" "ocLedByPunc" "ocFollowedByPunc" "lwLedByPunc" "lwFollowedByPunc" "lastWord" "nextWord")
      (format t "~% ------------+------------+---------------------+----------------+-------------+------------------+-------------+------------------+----------------+-------------"))
    nil)
  (if (/= (logand 2 showMask) 0)
    (progn
      (format t "~%| ~10S | ~10S | ~19S | ~14S | ~11S | ~16S | ~11S | ~16S | ~20S | ~20S |"
                     txt  brl after-prep-inf-conj force-raw-next ocAbbrWordLedByPunc ocAbbrWordFollowedByPunc lwAbbrWordLedByPunc lwAbbrWordFollowedByPunc lastWord nextWord))
    nil))

(defun debug8-decideCombination (dbgLevel id left past next b s hyphenated substr_cnt inhibitMedialDot showMask)
  (if (/= (logand 1 showMask) 0)
    (progn
      (format t "~%~% ~S ~S-------------------------------------------------------------------------------------------------------------------------------------" dbgLevel id)
      (format t "~% ~10A  | ~16A | ~20A | ~20A | ~10A  | ~10A | ~10A | ~16A"
                    "left" "past" "next" "Braille" "Roman" "hyphenated" "substr_cnt" "inhibitMedialDot")
      (format t "~% ------------+------------------+----------------------+----------------------+-------------+------------+------------+-------------------"))
    nil)
  (if (/= (logand 2 showMask) 0)
    (progn
      (format t "~% ~10S  | ~16S | ~20S | ~20S | ~10S  | ~10S | ~10S | ~16S"
                    left past next b s hyphenated substr_cnt inhibitMedialDot))
    nil))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ダイアグノスティック
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun tt ()
  (gc)
  (jp)
  (format t "~% Dir: ")
  (if (string= (compiler-version) "clisp")
    (run-shell-command "pwd")
    nil)
  (format t " Now Testing...~%")
;  (setf *debug* 1)
  (let (s b)
    (setf b (encodeBrailleStr "あ い う じゃ じゅ じょ"))
    (if (string/= b "A B C ^: ^? ^W") (format t "~%Error: 1") nil)
    (setf s (decodeBrailleStr "A B C ^: ^? ^W"))
    (if (string/= s "ア　イ　ウ　ジャ　ジュ　ジョ") (format t "~%Error: 2") nil)
    (setf b (brailleEncoder (intern "あ") *kana*))
    (if (string/= b "A") (format t "~%Error: 3") nil)
    (setf b (brailleEncoder (intern "íː") *pronunciation*))
    (if (string/= b "I3") (format t "~%Error: 4") nil)
    (setf b (brailleEncoder (intern "but") *us_grade2*))
    (if (string/= b "B") (format t "~%Error: 5") nil)
    (setf b (brailleEncoder (intern "about") *us_grade2*))
    (if (string/= b "AB") (format t "~%Error: 6") nil)
    (setf s (brailleDecoder "A" *kana*))
    (if (string/= s "ア") (format t "~%Error: 7") nil)
    (setf s (brailleDecoder "I3" *pronunciation*))
    (if (string/= s "íː") (format t "~%Error: 8") nil)
    (setf s (brailleDecoder "B" *us_grade2* t))
    (if (string/= s "but") (format t "~%Error: 9") nil)
;    (setf s (brailleDecoder_abbr "AB" *us_grade2*))
    (setf s (brailleDecoder "AB" *us_grade2* t))
    (if (string/= s "about") (format t "~%Error: 10") nil)
    (if (not (zerop (chkAllLangDirect))) (format t "~%Error: 11") nil)

    (format t "~%~%[BSE Decode Test]~%should be 32 or lesser.~%")
    (format t "~%~S" (decodeBrailleFile "../bse/test/ts.bse" "../txt/test/mts.txt"))
    (terpri)
    (if (string= (compiler-version) "clisp")
      (shell "diff ../txt/test/ts.txt ../txt/test/mts.txt | wc -l")
      nil)
    (format t "~%[BSE Encode Test]~%should be 4 or lesser.~%")
    (format t "~%~S" (encodeBrailleFile "../txt/test/mts.txt" "../bse/test/mts.bse"))
    (terpri)
    (if (string= (compiler-version) "clisp")
      (shell "diff ../bse/test/ts.bse ../bse/test/mts.bse | wc -l")
      nil)

    (if (string/= (nth _dic_string_index_ (assoc (intern "storeroom") *us_grade2_enc_dict*)) "/OREROOM")
      (format t "~%Error: 12")
      nil)

    (g2us)
    (setf *regist_dict* nil) (setf *lookup_dict* t)
    (format t "~%[BRF Encode/Decode Test]~%should be 0.~%")
    (gc)
    (format t "~%~S" (encodeBrailleFile "../txt/pink floyd/time.txt" "../bse/pink floyd/time.bse"))
    (terpri)
    (gc)
    (format t "~%~S" (decodeBrailleFile "../bse/pink floyd/time.bse" "../txt/pink floyd/time.out" nil nil t t nil nil nil nil))
    (terpri)
    (if (string= (compiler-version) "clisp")
      (shell "diff \"../txt/pink floyd/time.std\" \"../txt/pink floyd/time.out\"")
      nil)

    (setf *regist_dict* nil) (setf *lookup_dict* t)
;    (format t "~%[BRF Decode Test]~%should be 261 or lesser.~%")
;    (format t "~%[BRF Decode Test]~%should be 173 or lesser.~%")
;    (format t "~%[BRF Decode Test]~%should be 169 or lesser.~%")
;    (format t "~%[BRF Decode Test]~%should be 165 or lesser.~%")
;    (format t "~%[BRF Decode Test]~%should be 163 or lesser.~%")
;    (format t "~%[BRF Decode Test]~%should be 161 or lesser.~%")
;    (format t "~%[BRF Decode Test]~%should be 149 or lesser.~%")
;    (format t "~%[BRF Decode Test]~%should be 161 or lesser.~%")
;    (format t "~%[BRF Decode Test]~%should be 153 or lesser.~%")
    (format t "~%[BRF Decode Test]~%should be 149 or lesser.~%")
    (gc)
    (format t "~%~S" (decodeBrailleFile "../brf/Resources/monbas.brf" "../txt/Resources/monbas.out" nil nil t t nil nil nil nil))
    (terpri)
    (if (string= (compiler-version) "clisp")
      (shell "diff \"../brf/Resources/monbas.txt\" \"../txt/Resources/monbas.out\" | wc -l")
      nil)
    (jp)))

;(defun diag (grade)
;  (if (/= grade 2)
;    (g1diag)
;    (g2diag)))

(defun g1diag (&optional (debug 0))
  (let ((src_bse "../bse/biblio/1-01.bse")
        (dst_txt "../txt/test/a.txt")
        (src_txt "../txt/test/a.txt")
        (dst_bse "../bse/test/b.bse"))
    (jp debug)
    (format t "~%Decoding (~S --> ~S) ...~%" src_bse dst_txt)
    (format t "~%~S" (decodeBrailleFile src_bse dst_txt))
    (format t "~%Encoding (~S --> ~S) ...~%" src_txt dst_bse)
    (format t "~%~S" (encodeBrailleFile src_txt dst_bse))
    (format t "~%-- result ---------------------------------~%")
    (shell "diff ../txt/test/1-1.TXT ../txt/test/a.txt | wc -l")
    (shell "diff ../bse/test/1-1.bse ../bse/test/b.bse | wc -l")
    (format t "-- expected -------------------------------~%~4t242~%~4t61")
    (format t "~%-------------------------------------------")))

(defun g2diag (&optional (debug 0))
  (gc)
  (timeStamp)
  (terpri)
  (g2us debug) (encodeBrailleFile "a.txt" "b.txt" nil nil 32 22 t)
  (princ #\Bell)
  (terpri)
  (shell "diff -y -w \"../brf/Mark Twain/The_Adventures_of_Tom_Sawyer_f1.brf\" \"b.txt\" | fgrep -n \"|\"")
  (terpri)
  (blue)
  (bold)
  (blink t)
  (shell "diff -y -w \"../brf/Mark Twain/The_Adventures_of_Tom_Sawyer_f1.brf\" \"b.txt\" | fgrep -n \"|\" | wc -l")
  (blink nil)
  (plain)
  (terpri)
  (timeStamp)
  (terpri)
  (gc)
  (g2us 3) (both-test "a.txt" "../perl/data.txt" nil nil nil nil)
  (princ #\Bell)
  (terpri)
  (timeStamp)
  (gc))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Break 1 [2]> (dicTest "(where)(about)" "whereabout" "\":AB")
; 辞書（墨字／点字）: "whereabout" "\":AB"
; エンコード結果　　: "\":AB"
; デコード結果　　　: "whereabout"
; 
; |whereabout| "(where)(about)" #b110000000000000000000000000000000000000000000000 "\":AB" 0
; |":AB| "(where)(about)" #b110000000000000000000000000000000000000000000000 "whereabout" 0
; T
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun dicTest (w istr ibrl)
  (let ((gradeSaver *grade*) (isJP (string= *defaultMode* "JP"))
       s b e encStr decStr (newEnc nil) (newDec nil) encSaver decSaver)
    (initLang 2 "us")
    (multiple-value-setq (s b e) (genUsGrade2DicInfo w 1))
    ; 当該の辞書情報をセーブする
    (setf encSaver (assoc (intern s) *us_grade2_enc_dict*))
    (setf decSaver (assoc (intern b) *us_grade2_dec_dict*))
    (delete-if #'(lambda(x) (equal x encSaver)) *us_grade2_enc_dict*)
    (delete-if #'(lambda(x) (equal x decSaver)) *us_grade2_dec_dict*)
    ; 新規に辞書情報を作成し設定する（直接変換はサポートしない）
    (setf newEnc (list (intern s) w (nth 2 encSaver) b 0))
    (setf newDec (list (intern b) w (nth 2 decSaver) s 0))
    (push newEnc *us_grade2_enc_dict*)
    (push newDec *us_grade2_dec_dict*)
    (if istr
      (setf encStr (encodeBrailleStr istr nil *defaultMode* 0 nil nil t))
      nil)
    (if ibrl
      (setf decStr (decodeBrailleStr ibrl nil *defaultMode* 1 t t nil nil))
      nil)
    (initLang gradeSaver "us" isJP)
    ; 当該の辞書情報をリストアする
    (delete-if #'(lambda(x) (equal x newEnc)) *us_grade2_enc_dict*)
    (delete-if #'(lambda(x) (equal x newDec)) *us_grade2_dec_dict*)
    (push encSaver *us_grade2_enc_dict*)
    (push decSaver *us_grade2_dec_dict*)
    ; 結果表示(format t "#b~48,'0b" 1)
    (format t "辞書（墨字／点字）: ~S ~S~%" s b)
    (format t "エンコード結果　　: ~S~%" encStr)
    (format t "デコード結果　　　: ~S~%" decStr)
    (format t "~%オリジナル~%(~S ~S #b~48,'0b ~S ~S)"
               (nth _dic_symbol_index_ encSaver)
               (nth _dic_mode_index_ encSaver)
               (nth _dic_flags_index_ encSaver)
               (nth _dic_string_index_ encSaver)
               (nth _dic_ref_count_index_ encSaver))
    (format t "~%(~S ~S #b~48,'0b ~S ~S)~%"
               (nth _dic_symbol_index_ decSaver)
               (nth _dic_mode_index_ decSaver)
               (nth _dic_flags_index_ decSaver)
               (nth _dic_string_index_ decSaver)
               (nth _dic_ref_count_index_ decSaver))
    (and (string= istr decStr) (string= ibrl encStr))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 both-test
;; 【機能　】 墨字ファイル→点字ファイルへの変換をする。
;; 【入力　】 infn       : 墨字ファイル名
;;          outfn      : 点字ファイル名
;;          withHdr    : ヘッダの有無
;; 【出力　】 画面
;; 【例外　】 なし
;; 【使用例】 (g2us 3) (both-test "../txt/pink floyd/time.txt" "../bse/pink floyd/time.bse" nil nil nil t)
;;          (g2us 3) (both-test "a.txt" "../perl/data.txt" nil nil nil nil)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun both-test (infn &optional (resfn nil) (nthLine nil) (nthToken nil) (putCapSign nil) (withHdr nil))
  (let (resbuff buff (mode *defaultMode*) (lineNo 1) errList (errCnt 0))
    (terpri)
    ; 括弧管理情報を初期化する。
    (setf *bracketStats* 0)
    (if resfn
      ;; 資料ファイルをオープンする。
      (with-open-file (resstream resfn :direction :input)
        ;; 入力ファイル（墨字）をオープンする。
        (with-open-file (instream infn :direction :input)
          (let (e_lin (e_m mode) e_e d_lin (d_m mode) d_e)
            (if withHdr
              (setf resbuff (read-line resstream nil))
              nil)
            (do ()
              ((null (setf buff (read-line instream nil))) nil)
              (setf resbuff (read-line resstream nil))
              ; 1行エンコードし、画面出力する。
              (if (or (null nthLine) (= nthLine lineNo))
                (if (> (length buff) 2)
                  (progn
                    (multiple-value-setq (e_lin e_m e_e)
                      (encodeBrailleStr buff nthToken e_m lineNo t putCapSign nil))
                    (if e_e (push e_e errList) nil)
                    (multiple-value-setq (d_lin d_m d_e)
                      (decodeBrailleStr e_lin nthToken d_m lineNo t t t nil))
                    (if (string/= buff d_lin)
                      (progn
                        (incf errCnt)
                        (red)
                        (bold)
                        (format t "L:~04d Err:~04d (should be less than or equal to 10)~%" lineNo errCnt)
                        (plain)
                        (format t "~69A→Org:~66A~%" " " (substitute-string resbuff "                                     " ""))
                        (format t "Txt:~65A→Enc:~66A~%" buff e_lin)
                        (format t "Dec:~65A←Enc:~66A~%~%" d_lin e_lin)
                        (format t "Tips:~%(g2us) (encodeBrailleStr \"~A\" ~S ~S t ~S)~%" buff nthToken e_m lineNo putCapSign)
                        (format t "(g2us) (decodeBrailleStr \"~A\" ~S ~S t t ~S t nil)~%" e_lin nthToken d_m lineNo putCapSign)
                        (format t "-------------------------------------------------------------------------------------------------------------------------------------------~%"))
                      nil)
                    (if d_e (push d_e errList) nil))
                  ; 英語グレード２で空白行を検出したので、括弧管理情報を初期化する。
                  (if (= *grade* 2) (setf *bracketStats* 0) nil))
                nil)
              (incf lineNo)))
          ;; 入力ファイル（墨字）をクローズする。
          (close instream))
        ;; 資料ファイルをクローズする。
        (close resstream))
      ;; 入力ファイル（墨字）をオープンする。
      (with-open-file (instream infn :direction :input)
        (let (e_lin (e_m mode) e_e d_lin (d_m mode) d_e)
          (do ()
            ((null (setf buff (read-line instream nil))) nil)
            ; 1行エンコードし、画面出力する。
            (if (> (length buff) 2)
              (progn
                (multiple-value-setq (e_lin e_m e_e)
                  (encodeBrailleStr buff nil e_m lineNo t putCapSign nil))
                (if e_e (push e_e errList) nil)
                (multiple-value-setq (d_lin d_m d_e)
                  (decodeBrailleStr e_lin nil d_m lineNo t t t nil))
                (if (string/= buff d_lin)
                  (progn
                    (incf errCnt)
                    (red)
                    (bold)
                    (format t "L:~04d Err:~04d~%" lineNo errCnt)
                    (plain)
                    (format t "Txt:~65A→Enc:~66A~%" buff e_lin)
                    (format t "Dec:~65A←Enc:~66A~%~%" d_lin e_lin)
                    (format t "Tips:~%(g2us) (encodeBrailleStr \"~A\" ~S t ~S)~%" buff nil e_m lineNo putCapSign)
                    (format t "(g2us) (decodeBrailleStr \"~A\" ~S ~S ~S t t t nil)~%" e_lin nil d_m lineNo)
                    (format t "-------------------------------------------------------------------------------------------------------------------------------------------~%"))
                  nil)
                (if d_e (push d_e errList) nil))
              ; 英語グレード２で空白行を検出したので、括弧管理情報を初期化する。
              (if (= *grade* 2) (setf *bracketStats* 0) nil))
            (incf lineNo)))
        ;; 入力ファイル（墨字）をクローズする。
        (close instream)))
    errList))

(defun dialog ()
  (let (brls txts lst category (n 0) infile debug assure cmdstr0 cmdstr1)
    (setf brls
      (list "../brf/Resources/monbas.brf"
            "../brf/Resources/monnam.brf"
            "../brf/Resources/monnum.brf"
            "../brf/Resources/directory.brf"
            "../brf/Resources/phoncode.brf"
            "../brl/Resources/a.brl"))
    (setf txts
      (list "../brf/Resources/monbas.txt"
            "../brf/Resources/monnam.txt"
            "../brf/Resources/monnum.txt"
            "../brf/Resources/directory.txt"
            "../brf/Resources/phoncode.txt"
            "../brf/Resources/a.txt"))
    (format t "~%Please enter category (Encode/Decode): ")
    (setf category (string (read)))
    (cond
      ((string= (subseq category 0 1) "E") (setf lst txts))
      (t (setf lst brls)))
    (dolist (f lst)
      (format t "~%~4t~S: ~A" n f) (incf n))
    (format t "~%Please enter input file no (0-~S): " (length lst))
    (setf n (read))
    (cond
      ((and (>= n 0) (< n (1- (length lst)))) (setf infile (nth n lst)))
      (t (setf infile (nth n lst))))
    (format t "~%Please enter debug level (0-3): ")
    (setf debug (read))
    (cond
      ((and (>= debug 0) (<= debug 3)) (setf *debug* debug))
      (t (setf *debug* 0)))
    (if (string= category "E")
      (progn (setf cmdstr0 (format nil "(g2us ~S)" debug)) (setf cmdstr1 (format nil "(encodeBrailleFile \"~A\")" infile)))
      (progn (setf cmdstr0 (format nil "(g2us ~S)" debug)) (setf cmdstr1 (format nil "(decodeBrailleFile \"~A\")" infile))))
    (format t "~%~A~A~%Do you want to execute? (y/n) " cmdstr0 cmdstr1)
    (setf assure (string (read)))
    (if (string= assure "Y")
      (progn
        (eval cmdstr0)
;        (eval (substitute-string cmdstr1 "\"" ""))
        (eval cmdstr1)
        )
      nil)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; *us_grade2* の内容をダンプする
; duplicatedOnly が nil の場合は、全メンバの結合モードと置換文字列をダンプする。
; duplicatedOnly が t の場合は、重複したメンバの生データをダンプする。
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun g2dump (&optional (country "us") (duplicatedOnly nil))
  (if (null duplicatedOnly)
    (let (a b lang)
      (if (string= country "uk")
        (setf lang *uk_grade2*)
        (setf lang *us_grade2*))
      (do ((i 0 (1+ i)))
        ((= i (length lang)) nil)
        (setf a (car (nth i lang))) (setf b (cdr (nth i lang)))
;        (setf lst (seek *represent* 64 b 0 nil))
        (multiple-value-bind (whole init med fin s) (g2info a b)
          (format t "~%~15S: (~A~A~A~A) ~15S ~S" a whole init med fin s country))))
    (let (lastx lst dupSymLst a b lang)
      (if (string= country "uk")
        (setf lang *uk_grade2*)
        (setf lang *us_grade2*))
      ; 重複したシンボルの表示
      (format t "~%duplicated symbols...~%")
      (setf dupSymLst nil)
      (setf lst (stable-sort lang #'string-lessp :key #'car))
      (dolist (x lst)
        (if (equal (car x) (car lastx))
          (pushnew (car x) dupSymLst)
          nil)
        (setf lastx x))
      (dolist (x lst)
        (if (member (car x) dupSymLst)
          (progn
            (setf a (car x)) (setf b (cdr x))
            (multiple-value-bind (whole init med fin s) (g2info a b)
              (format t "~%~15S: (~A~A~A~A) #b~48,'0b ~7S ~S" a whole init med fin b s country)))
          nil))
      ; 重複した値の表示
      (format t "~%~%duplicated values...~%")
      (setf dupSymLst nil)
      (setf lst (stable-sort (mapcar #'(lambda (x) (cons (cdr x) (car x))) lang) #'< :key #'car))
      (dolist (x lst)
        (if (equal (car x) (car lastx))
          (pushnew (car x) dupSymLst)
          nil)
        (setf lastx x))
      (dolist (x lst)
        (if (member (car x) dupSymLst)
          (progn
            (setf b (car x)) (setf a (cdr x))
            (multiple-value-bind (whole init med fin s) (g2info a b)
              (format t "~%~15S: (~A~A~A~A) #b~48,'0b ~7S ~S" a whole init med fin b s country)))
          nil))
      ; 緩く重複した値の表示
      (format t "~%~%loose duplicated values...~%")
      (setf dupSymLst nil)
      (setf lst (stable-sort (mapcar #'(lambda (x) (cons (logand (cdr x) _AllClearBits_) (car x))) lang) #'< :key #'car))
      (dolist (x lst)
        (if (equal (car x) (car lastx))
          (pushnew (car x) dupSymLst)
          nil)
        (setf lastx x))
      (dolist (x lst)
        (if (member (car x) dupSymLst)
          (progn
            (setf b (car x)) (setf a (cdr x))
            (multiple-value-bind (whole init med fin s) (g2info a b)
              (format t "~%~15S: (~A~A~A~A) #b~48,'0b ~7S ~S" a whole init med fin b s country)))
          nil)))))

; 上記で使用されるツール
(defun g2info (a b)
  (let (whole init med fin)
    (if (/= 0 (logand b _wholeWordMask_))
      (setf whole "W") (setf whole " "))
    (if (/= 0 (logand b _initialWordMask_))
      (setf init "I") (setf init " "))
    (if (/= 0 (logand b _medialWordMask_))
      (setf med "M") (setf med " "))
    (if (/= 0 (logand b _finalWordMask_))
      (setf fin "F") (setf fin " "))
    (values whole init med fin (conv a *us_grade2* *represent*))))
;    (values whole init med fin (brailleEncoder a *us_grade2* whole init med fin))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; *us_grade2_enc_dict* や *us_grade2_dec_dict* の内容をダンプする
; country "uk", "us"
; enc_dec 0:*us_grade2_enc_dict*, 1:*us_grade2_dec_dict*
; type  0:全部, 1:旧, 2:新
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun g2ddump (&optional (country "us") (which 0) (type 0))
  (let (f lst (cnt 0))
    (cond
      ((and (string= country "uk") (= which 0)) (setf lst (stable-sort *uk_grade2_enc_dict* #'string-lessp :key #'car)))
      ((and (string= country "uk") (= which 1)) (setf lst (stable-sort *uk_grade2_dec_dict* #'string-lessp :key #'car)))
      ((and (string= country "us") (= which 0)) (setf lst (stable-sort *us_grade2_enc_dict* #'string-lessp :key #'car)))
      ((and (string= country "us") (= which 1)) (setf lst (stable-sort *us_grade2_dec_dict* #'string-lessp :key #'car))))
    (cond
      ((= type 0) (setf f #'(lambda (x) (null nil))))
      ((= type 1) (setf f #'(lambda (x) (not (null x)))))
      ((= type 2) (setf f #'(lambda (x) (null x)))))
    (dolist (x lst)
      (if (funcall f x)
        (progn
          (format t "~%~S" x)
          (incf cnt))
        nil)))
  (dinfo country))

(defun dinfo (country)
  (let ((ec 0) (dc 0))
    (if (string= country "uk")
      (progn
        (dolist (x *uk_grade2_enc_dict*)
          (if (null (nth 1 x))
            (incf ec)
            nil))
        (dolist (x *uk_grade2_dec_dict*)
          (if (null (nth 1 x))
            (incf dc)
            nil))
        (format t "~%~%Dictionary Info.\
Encode: ~S+~S items in *uk_grade2_enc_dict*\
Decode: ~S+~S items in *uk_grade2_dec_dict*"
        (- (length *uk_grade2_enc_dict*) ec) ec
        (- (length *uk_grade2_dec_dict*) dc) dc))
      (progn
        (dolist (x *us_grade2_enc_dict*)
          (if (null (nth 1 x))
            (incf ec)
            nil))
        (dolist (x *us_grade2_dec_dict*)
          (if (null (nth 1 x))
            (incf dc)
            nil))
        (format t "~%~%Dictionary Info.\
Encode: ~S+~S items in *us_grade2_enc_dict*\
Decode: ~S+~S items in *us_grade2_dec_dict*"
        (- (length *us_grade2_enc_dict*) ec) ec
        (- (length *us_grade2_dec_dict*) dc) dc)))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; 可逆の変換(brailleEncoder/brailleDecoder)の可否をチェックする
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun chkAllLangDirect ()
  (let ((ret 0) (j 0) a b)
    (dolist (lang *langList*)
      (if (or (string= (nth j *langNameList*) "UK2")
              (string= (nth j *langNameList*) "US2"))
        (format t "~%*us_grade2* の語の対応は 1対多なので相互変換で内容を確認しない。~%")
        (do ((i 0 (1+ i)))
          ((= i (length lang)) nil)
          (setf a (car (nth i lang)))
          (setf b (brailleEncoder a lang))
          (if (null b)
            (print a)
            (let (s)
              (setf s (brailleDecoder b lang))
              (if (null s)
                (progn (format t "~%Error: ~S ~A" a b) (incf ret))
                nil)))))
      (incf j)
      (princ "*"))
    ret))

(defun testAmericanEdition1994 ()
  (let ((mode *defaultMode*) buff buffs lineNo files fn)
    (setf files '("1. RULE I - PUNCTUATION SIGNS.txt"
                  "2. RULE II - SPECIAL BRAILLE COMPOSITION SIGNS.txt"
                  "5. RULE V - ANGLICIZED AND FOREIGN WORDS, ACCENT.txt"
                  "6. RULE VI - ABBREVIATIONS.txt"
                  "7. RULE VII - NUMBERS AND ROMAN NUMERALS.txt"
                  "8. RULE VIII COINAGE, WEIGHTS, MEASURES AND OT.txt"
                  "9. RULE IX - POETRY, SCANSION AND STRESS.txt"
                  "10. RULE X - GENERAL USE OF CONTRACTIONS.txt"
                  "11. RULE XI - ONE-CELL WHOLE-WORD CONTRACTIONS.txt"
                  "12. RULE XII - ONE-CELL PART-WORD SIGNS.txt"
                  "13. RULE XIII - LOWER SIGNS.txt"
                  "14. RULE XIV - INITIAL-LETTER CONTRACTIONS.txt"
                  "15. RULE XV - FINAL-LETTER CONTRACTIONS.txt"
                  "16. RULE XVI - SHORT-FORM WORDS.txt"))
    (g2us)
    (dolist (fn files)
      ;; 入力ファイルをオープンする。
      (setf lineNo 0)
      (with-open-file (instream (concatenate 'string "../AmericanEdition1994/" fn) :direction :input)
        (let (e_lin (e_m mode) e_e d_lin (d_m mode) d_e)
          (do ()
            ((null (setf buff (read-line instream nil))) nil)
            (setf buffs (split-string buff _fieldSeparator_))
            ; 1行エンコードする。
            (if (and (> (length buff) 2)
                     (string/= (subseq buff 0 2) _commentMark_)) ; ";;"
              (progn
                (multiple-value-setq (e_lin e_m e_e)
                  (encodeBrailleStr (nth 0 buffs) nil e_m lineNo t t nil))
                (multiple-value-setq (d_lin d_m d_e)
                  (decodeBrailleStr (nth 1 buffs) nil d_m lineNo t t nil nil))
                (if (and (string= (nth 0 buffs) d_lin) (string= (nth 1 buffs) e_lin))
                  nil
                  (format t "~%~S [~S] ~S" fn lineNo buff)))
              nil)
            (incf lineNo)))
        ;; 入力ファイルをクローズする。
        (close instream)))))

(defun convall ()
  (let (bf tf bfList tfList dttm outList fn)
    (jp)
    (setf dttm (multiple-value-list (get-decoded-time)))
    (setf fn (format nil "../~4A~2,'0D~2,'0D~2,'0D~2,'0D.log"
              (nth 5 dttm) (nth 4 dttm) (nth 3 dttm) (nth 2 dttm) (nth 1 dttm)))
    ;; ログファイルをオープンする。
    (with-open-file (outstream fn :direction :output)
      (setf bfList
        (list
          "../bse/benricho/01.bse"
          "../bse/benricho/02.bse"
          "../bse/benricho/03.bse"
          "../bse/benricho/04.bse"
          "../bse/benricho/05.bse"
          "../bse/biblio/1-01.bse"
          "../bse/biblio/1-02.bse"
          "../bse/biblio/1-03.bse"
          "../bse/biblio/1-04.bse"
          "../bse/biblio/1-05.bse"
          "../bse/biblio/1-06.bse"
          "../bse/biblio/1-07.bse"
          "../bse/biblio/1-08.bse"
          "../bse/biblio/1-09.bse"
          "../bse/biblio/1-10.bse"
          "../bse/yodaka/yodaka.bse"
          "../bse/seishunki/seishunki1.bse"
          "../bse/seishunki/seishunki2.bse"
          "../bse/seishunki/seishunki3.bse"
          "../bse/seishunki/seishunki4.bse"
          "../bse/seishunki/seishunki5.bse"
          "../bse/seishunki/seishunki6.bse"
          "../bse/seishunki/seishunki7.bse"
          "../bse/hyoten1/hyoten101.bse"
          "../bse/hyoten1/hyoten102.bse"
          "../bse/hyoten1/hyoten103.bse"
          "../bse/hyoten1/hyoten104.bse"
          "../bse/hyoten1/hyoten105.bse"
          "../bse/hyoten1/hyoten106.bse"
          "../bse/hyoten1/hyoten107.bse"
          "../bse/hyoten1/hyoten108.bse"
          "../bse/hyoten1/hyoten109.bse"
          "../bse/hyoten2/hyoten201.bse"
          "../bse/hyoten2/hyoten202.bse"
          "../bse/hyoten2/hyoten203.bse"
          "../bse/hyoten2/hyoten204.bse"
          "../bse/hyoten2/hyoten205.bse"
          "../bse/hyoten2/hyoten206.bse"
          "../bse/hyoten2/hyoten207.bse"
          "../bse/hyoten2/hyoten208.bse"
          "../bse/hyoten2/hyoten209.bse"))
      (dolist (bf bfList)
        (setf tf (string (substitute-string bf "bse" "txt")))
        (format t "~%(~A --> ~A)~%" bf tf)
        (setf outList (decodeBrailleFile bf tf))
        (format outstream "~%(~A --> ~A)~%~S~%~%" bf tf outList))

      (setf tfList
        (list
          "../txt/benricho/01.txt"
          "../txt/benricho/02.txt"
          "../txt/benricho/03.txt"
          "../txt/benricho/04.txt"
          "../txt/benricho/05.txt"
          "../txt/biblio/1-01.txt"
          "../txt/biblio/1-02.txt"
          "../txt/biblio/1-03.txt"
          "../txt/biblio/1-04.txt"
          "../txt/biblio/1-05.txt"
          "../txt/biblio/1-06.txt"
          "../txt/biblio/1-07.txt"
          "../txt/biblio/1-08.txt"
          "../txt/biblio/1-09.txt"
          "../txt/biblio/1-10.txt"
          "../txt/yodaka/yodaka.txt"
          "../txt/seishunki/seishunki1.txt"
          "../txt/seishunki/seishunki2.txt"
          "../txt/seishunki/seishunki3.txt"
          "../txt/seishunki/seishunki4.txt"
          "../txt/seishunki/seishunki5.txt"
          "../txt/seishunki/seishunki6.txt"
          "../txt/seishunki/seishunki7.txt"
          "../txt/hyoten1/hyoten101.txt"
          "../txt/hyoten1/hyoten102.txt"
          "../txt/hyoten1/hyoten103.txt"
          "../txt/hyoten1/hyoten104.txt"
          "../txt/hyoten1/hyoten105.txt"
          "../txt/hyoten1/hyoten106.txt"
          "../txt/hyoten1/hyoten107.txt"
          "../txt/hyoten1/hyoten108.txt"
          "../txt/hyoten1/hyoten109.txt"
          "../txt/hyoten2/hyoten201.txt"
          "../txt/hyoten2/hyoten202.txt"
          "../txt/hyoten2/hyoten203.txt"
          "../txt/hyoten2/hyoten204.txt"
          "../txt/hyoten2/hyoten205.txt"
          "../txt/hyoten2/hyoten206.txt"
          "../txt/hyoten2/hyoten207.txt"
          "../txt/hyoten2/hyoten208.txt"
          "../txt/hyoten2/hyoten209.txt"))
      (dolist (tf tfList)
        (setf bf (string (substitute-string tf "txt" "tmp")))
        (format t "~%(~A --> ~A)~%" tf bf)
        (setf outList (encodeBrailleFile tf bf))
        (format outstream "~%(~A --> ~A)~%~S~%~%" tf bf outList))
      (close outstream))))
