;
; rcsID=$Id: load.lisp,v 1.16 2008/04/29 16:25:15 tmatsugaki Exp $
;
(let ((brc-base-directory
        (make-pathname :name nil :type nil :version nil
                       :defaults (parse-namestring *load-truename*)))
      must-compile)
  (with-compilation-unit ()
    (dolist (file '("Definitions"
                    "Macros"
                    "Tools"
                    "Console"
                    "Utils"
                    "Convert"
                    "Represent"
                    "Common"
                    "Number"
                    "LiteraryUS"
                    "LiteraryUK"
                    "Kana"
                    "Mathematics"
                    "Pronunciation"
                    "Hyphenation"
                    "debug"
                    "tips"
                    "PrePostProcess"
                    "Reader"
                    "Braille"))
      (let ((pathname (make-pathname :name file :type "lisp" :version nil
                                     :defaults brc-base-directory)))
        ;; don't use COMPILE-FILE in Corman Lisp, it's broken - LOAD
        ;; will yield compiled functions anyway
        #-:cormanlisp
        (let ((compiled-pathname (compile-file-pathname pathname)))
          (unless (and (not must-compile)
                       (probe-file compiled-pathname)
                       (< (file-write-date pathname)
                          (file-write-date compiled-pathname)))
            (setq must-compile t)
            (compile-file pathname))
          (setq pathname compiled-pathname))
        (load pathname)))))
