;
; rcsID=$Id: obsoleted.lisp,v 1.16 2008/04/29 16:25:15 tmatsugaki Exp $
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 get_tokens
;; 【機能　】 文字列を指定したデリミタで分割しアトムのリストに変換する。
;; 【入力　】 str : 文字列
;; 【出力　】 リスト
;; 【例外　】 なし
;; 【使用例】 (get_tokens "われらわ、 いずれの") → (われらわ、 いずれの)
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun get_tokens(str)
;  (let ((in (make-string-input-stream str)) lst　tok)
;    ; 文字列ストリームから文字列を読み込む
;    (setf lst nil)
;    (do nil
;      ((null (setf tok (read in nil))) nil)
;      (push tok lst))
;    (close in)
;    (reverse lst)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 rmbar
;; 【機能　】文字列中の "|" を除去する。
;; 【入力　】 istr : 文字列
;; 【出力　】 文字列
;; 【例外　】 なし
;; 【使用例】 (rmbar "A|B|C") → "ABC"
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun rmbar(istr)
;  (if (not (null istr))
;    (let (str i)
;      (setf str nil)
;      (do '(i 0 (1+ i))
;        ((equal i (length istr)) nil)
;        (if (equal (char istr i) #\|)
;          nil
;          (setf str (cons (char istr i) str))))
;      (reverse (coerce str '(array character 1))))
;    nil))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 search-string
;; 【機能　】 文字列を指定した文字列を検索してインデクスを返す。
;; 【入力　】 str : 文字列
;;          mark : 文字列
;; 【出力　】 インデクス
;; 【例外　】 なし
;; 【使用例】 (search-string "ab,,cd,,ef" ",,") → 2
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun search-string(str mark)
;  (let ((ret nil)
;        (strlen (length str)) (marklen (length mark)))
;    (do '(i 0 (1+ i))
;      ((or (>= i strlen) ret) nil)
;      (let (endindex)
;        (setf endindex (+ i marklen))
;        (if (and (<= endindex strlen) (string= mark str :start2 i :end2 endindex))
;          (setf ret i)
;          nil)))
;    (values ret)))

;(defun search-string(str mark &optional (taketail nil))
;  (let ((ret nil) (strlen (length str)) (marklen (length mark)))
;    (do '(i 0 (1+ i))
;      ((or (>= i strlen) ret) nil)
;      (let ((startindex1 i) (endindex1 (+ i marklen)))
;        (if (and (<= endindex1 strlen) (string= mark str :start2 startindex1 :end2 endindex1))
;          (if (null taketail)
;            (setf ret i)
;            (let ((startindex2 (+ startindex1 marklen)) (endindex2 (+ endindex1 marklen)))
;              (if (<= endindex2 strlen)
;                (if (string= mark str :start2 startindex2 :end2 endindex2)
;                  nil
;                  (setf ret (+ i marklen -1)))
;                (setf ret i))))
;          nil)))
;    (values ret)))

;(defun search-string(str mark &optional (lastOne nil))
;  (let ((ret nil) (strlen (length str)) (marklen (length mark)) start end)
;    (if (>= strlen marklen)
;      (if lastOne
;        (do '(i strlen (1- i))
;          ((or (< i marklen) ret) nil)
;          (progn
;            (setf start (- i marklen)) (setf end i)
;            (if (string= mark str :start2 start :end2 end)
;              (setf ret start)
;              nil)))
;        (do '(i 0 (1+ i))
;          ((or (>= i strlen) ret) nil)
;          (progn
;            (setf start i) (setf end (+ i marklen))
;            (if (and (<= end strlen) (string= mark str :start2 start :end2 end))
;              (setf ret start)
;              nil))))
;      nil)
;    (values ret)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 split-string
;; 【機能　】 文字列を指定した1文字の区切りとして分割し、文字列のリストを生成する。
;; 【入力　】 str : 文字列
;;          sep : 文字列（1文字）
;; 【出力　】 文字列のリスト
;; 【例外　】 なし
;; 【使用例】 (split-string "ab cd ef") → ("ab" "cd" "ef")
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun split-string (str &optional (sep " "))
;  (let ((n (position sep str :test #'(lambda (x y) (find y x :test #'char=)))))
;    (if n
;      (cons (subseq str 0 n) (split-string (subseq str (1+ n)) sep))
;      (cons str nil))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 substitute-string
;; 【機能　】 文字列で指定した部分文字列を置換した文字列を生成する。
;; 【入力　】 str : 文字列
;;          src : 文字列
;;          dst : 文字列
;; 【出力　】 文字列
;; 【例外　】 なし
;; 【使用例】 (substitute-string "ab,bc,de" "," "_") → "ab_bc_de"
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun substitute-string (str src dst)
;  (let ((ret nil)
;        (strlen (length str)) (srclen (length src)) (dstlen (length dst)))
;    (do '(i 0 (1+ i))
;      ((>= i strlen) nil)
;      (let (endindex)
;        (setf endindex (+ i srclen))
;        (if (and (<= endindex strlen) (string= src str :start2 i :end2 endindex))
;          (progn
;            (setf ret (concatenate 'string ret dst))
;            (setf i (1- (+ i srclen)))
;          )
;          (setf ret (concatenate 'string ret (subseq str i (1+ i)))))))
;    ret))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 search-last
;; 【機能　】 文字列の全てが全角英字で構成されているか否かを返す。
;; 【入力　】 str : 検索対象の文字列
;; 【出力　】 文字列
;; 【例外　】 
;; 【使用例】 (search_last "   ABC" #\Space) → 2
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun search_last(str ch)
;  (- (1- (length str)) (search (format nil "~A" ch) (reverse str))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 isTag
;; 【機能　】 文字列がタグか否かを返す。
;; 【入力　】 str : 検索対象の文字列
;; 【出力　】 文字列
;; 【例外　】 
;; 【使用例】 (isTag "<abc>") → T
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun isTag(str)
;  (and (stringp str)
;       (> (length str) 0)
;       (equal (char str 0) #\<)
;       (equal (char str (1- (length str))) #\>)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 headBlankStr
;; 【機能　】 文字列の冒頭の空白のみで構成された部分文字列を取得する。
;; 【入力　】 str : 検索対象の文字列
;; 【出力　】 文字列
;; 【例外　】 
;; 【使用例】 (headBlankStr "  ABC") → "  "
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun headBlankStr(str)
;  (let (ret i s)
;    (setf i (search_last str #\Space))
;    (if (and (numberp i) (>= i 0))
;      (progn
;        (setf s (subseq str 0 (1+ i)))
;        (if (and (stringp s) (> (length s) 0) (isWhitespaces s))
;          (setf ret s)
;          nil))
;      nil)
;    ret))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 stripLeadingWhiteSpaces
;; 【機能　】 文字列の冒頭の空白を除去する。
;; 【入力　】 str : 検索対象の文字列
;; 【出力　】 文字列
;; 【例外　】 
;; 【使用例】 (stripLeadingWhiteSpaces "  ABC") → "ABC"
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun stripLeadingWhiteSpaces(str)
;    (subseq str (length (headBlankStr str)) (length str)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 isWhitespaces
;; 【機能　】 文字列の全てが空白で構成されているか否かを返す。
;; 【入力　】 str : 検索対象の文字列
;; 【出力　】 文字列
;; 【例外　】 
;; 【使用例】 (isWhitespaces "abc ") → NIL
;;          (isWhitespaces "    ") → T
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun isWhitespaces(str)
;  (let ((cnt 0) i)
;    (do '(i 0 (1+ i))                             ; 初期化
;      ((and (equal i (length str)) (>= i 0)) nil) ; 終了条件、終了処理
;      (if (equal (char str i) #\Space)            ; 主処理
;        (setf cnt (1+ cnt))
;        (setf cnt -1)))
;    (if (and (equal cnt (length str)) (> cnt 0))
;      T
;      nil)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 isHankakuDigits
;; 【機能　】 文字列の全てが半角数字で構成されているか否かを返す。
;; 【入力　】 str : 検索対象の文字列
;; 【出力　】 文字列
;; 【例外　】 
;; 【使用例】 (isHankakuDigits "123A" nil) → NIL
;;          (isHankakuDigits "0123" nil) → T
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun isHankakuDigits(str ignoreBlank)
;  (let ((cnt 0) i)
;    (do '(i 0 (1+ i))                             ; 初期化
;      ((and (equal i (length str)) (>= i 0)) nil) ; 終了条件、終了処理
;      (if (or (digit-char-p (char str i))         ; 主処理
;              (and ignoreBlank (equal (char str i) #\Space)))
;        (setf cnt (1+ cnt))
;        (setf cnt -1)))
;    (if (and (equal cnt (length str)) (> cnt 0))
;      T
;      nil)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 isZenkakuDigits
;; 【機能　】 文字列の全てが全角数字で構成されているか否かを返す。
;; 【入力　】 str : 検索対象の文字列
;; 【出力　】 文字列
;; 【例外　】 
;; 【使用例】 (isZenkakuDigits "123" nil) → NIL
;;          (isZenkakuDigits "０１２３" nil) → T
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun isZenkakuDigits(str ignoreBlank)
;  (let ((cnt 0) i)
;    (do '(i 0 (1+ i))                                 ; 初期化
;      ((and (equal i (length str)) (>= i 0)) nil)     ; 終了条件、終了処理
;      (if (or (find (char str i) "０１２３４５６７８９") ; 主処理
;              (and ignoreBlank (equal (char str i) #\Space)))
;        (setf cnt (1+ cnt))
;        (setf cnt -1)))
;    (if (and (equal cnt (length str)) (> cnt 0))
;      T
;      nil)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 isHankakuAlphabets
;; 【機能　】 文字列の全てが半角英字で構成されているか否かを返す。
;; 【入力　】 str : 検索対象の文字列
;; 【出力　】 文字列
;; 【例外　】 
;; 【使用例】 (isHankakuAlphabets "Abcあ") → NIL
;;          (isHankakuAlphabets "Abc") → T
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun isHankakuAlphabets(str)
;  (let ((cnt 0) i)
;    (do '(i 0 (1+ i))                             ; 初期化
;      ((and (equal i (length str)) (>= i 0)) nil) ; 終了条件、終了処理
;      (if (both-case-p (char str i))              ; 主処理
;        (setf cnt (1+ cnt))
;        (setf cnt -1)))
;    (if (and (equal cnt (length str)) (> cnt 0))
;      T
;      nil)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 isZenkakuAlphabets
;; 【機能　】 文字列の全てが全角英字で構成されているか否かを返す。
;; 【入力　】 str : 検索対象の文字列
;; 【出力　】 文字列
;; 【例外　】 
;; 【使用例】 (isZenkakuAlphabets "Abc" nil) → NIL
;;          (isZenkakuAlphabets "Ａｂｃ" nil) → T
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun isZenkakuAlphabets(str ignoreBlank)
;  (let ((cnt 0) i)
;    (do '(i 0 (1+ i))                                         ; 初期化
;      ((and (equal i (length str)) (>= i 0)) nil)             ; 終了条件、終了処理
;      (if (or (find (char str i) "ａｂｃｄｅｆｇｈｉｊｋｌｍｎｏｐｑｒｓｔｕｖｗｘｙｚＡＢＣＤＥＦＧＨＩＪＫＬＭＮＯＰＱＲＳＴＵＶＷＸＹＺ")
;              (and ignoreBlank (equal (char str i) #\Space))) ; 主処理
;        (setf cnt (1+ cnt))
;        (setf cnt -1)))
;    (if (and (equal cnt (length str)) (> cnt 0))
;      T
;      nil)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 narrow-stringDigit
;; 【機能　】 全角数字文字列を半角数字文字列に変換する。
;; 【入力　】 str : 検索対象の文字列
;; 【出力　】 文字列
;; 【例外　】 
;; 【使用例】 (narrow-stringDigit "０") → "0"
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun narrow-stringDigit(str)
;  (let (i)
;    (setf i (search str "０１２３４５６７８９"))
;    (if (and (numberp i) (>= i 0))
;      (format nil "~S" i)
;      nil)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 toZenakuDigit
;; 【機能　】 半角数字文字列を全角数字文字列に変換する。
;; 【入力　】 str : 検索対象の文字列
;; 【出力　】 文字列
;; 【例外　】 
;; 【使用例】 (toZenakuDigit "0") → "０"
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun toZenakuDigit(str)
;  (let (i)
;    (setf i (search str "0123456789"))
;    (if (and (numberp i) (>= i 0))
;      (coerce (list (coerce (char "０１２３４５６７８９" i) 'character)) 'string)
;      nil)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 narrow-stringAlphabet
;; 【機能　】 全角数字文字列を半角英字文字列に変換する。
;; 【入力　】 str : 検索対象の文字列
;; 【出力　】 文字列
;; 【例外　】 
;; 【使用例】 (narrow-stringAlphabet "ａ") → "a"
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun narrow-stringAlphabet(str)
;  (let (i)
;    (setf i (search str "ａｂｃｄｅｆｇｈｉｊｋｌｍｎｏｐｑｒｓｔｕｖｗｘｙｚＡＢＣＤＥＦＧＨＩＪＫＬＭＮＯＰＱＲＳＴＵＶＷＸＹＺ　"))
;    (if (and (numberp i) (>= i 0))
;      (coerce (list (coerce (char "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ " i) 'character)) 'string)
;      nil)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 toZenakuAlphabet
;; 【機能　】 半角数字文字列を全角英字文字列に変換する。
;; 【入力　】 str : 検索対象の文字列
;; 【出力　】 文字列
;; 【例外　】 
;; 【使用例】 (toZenakuAlphabet "a") → "ａ"
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun toZenakuAlphabet(str)
;  (let (i)
;    (setf i (search str "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ "))
;    (if (and (numberp i) (>= i 0))
;      (coerce (list (coerce (char "ａｂｃｄｅｆｇｈｉｊｋｌｍｎｏｐｑｒｓｔｕｖｗｘｙｚＡＢＣＤＥＦＧＨＩＪＫＬＭＮＯＰＱＲＳＴＵＶＷＸＹＺ " i) 'character)) 'string)
;      nil)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 tryPushStatus
;; 【機能　】 カレントの墨字を評価し、状態・モード・言語を適宜遷移させる。
;; 【入力　】 str : 検索対象の文字列
;; 【出力　】 状態の遷移があった場合には、T を返す。
;; 【例外　】 なし
;; 【使用例】 (tryPushStatus "") → 2
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun tryPushStatus(word)
;)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 detectCharsetChange
;; 【機能　】 ローマンの場合に、直前の墨字(1文字)とカレントの墨字(1文字)を評価し、文字種の遷移
;;          があった場合に、自動的にタグを生成する。
;; 【入力　】 word : 検索対象の文字列
;;          searchAll : 
;; 【出力　】 状態の遷移があった場合には、T を返す。
;; 【例外　】 なし
;; 【使用例】 (detectCharsetChange "") → 2
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun detectCharsetChange(ch lastCh)
;  (let (c lc ret)
;    (setf c (stripLeadingWhiteSpaces ch))
;    (setf lc (stripLeadingWhiteSpaces lastCh))
;    (setf ret nil)
;    (if
;      (and (stringp c) (stringp lc) (equal (length c) 1) (equal (length lc) 1))
;      (let ((lastMode 0) (curMode 0))
;        (if (isHankakuDigits lc nil) (setf lastMode (logior lastMode #x01)) nil)
;        (if (isZenkakuDigits lc T) (setf lastMode (logior lastMode #x02)) nil)
;        (if (isHankakuAlphabets lc) (setf lastMode (logior lastMode #x02)) nil)
;        (if (isZenkakuAlphabets lc T) (setf lastMode (logior lastMode #x02)) nil)
;        (if (isHankakuDigits c nil) (setf curMode (logior curMode #x01)) nil)
;        (if (isZenkakuDigits c T) (setf curMode (logior curMode #x01)) nil)
;        (if (isHankakuAlphabets c) (setf curMode (logior curMode #x02)) nil)
;        (if (isZenkakuAlphabets c T) (setf curMode (logior curMode #x02)) nil)
;        (if (not (equal lastMode curMode)) (setf ret T) nil)
;      )
;      nil
;    )
;    ret
;  )
;)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 autoPopStatus
;; 【機能　】 カレントのタグでない墨字(1文字)を評価し、自動的な状態・モード・言語の遷移
;;          があった場合に、true を返す。
;; 【入力　】 word : 検索対象の文字列
;;          searchAll : 
;; 【出力　】 状態の遷移があった場合には、T を返す。
;; 【例外　】 なし
;; 【使用例】 (autoPopStatus "") → 2
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun autoPopStatus(word)
;  (let (wd (autoStatChanged nil))
;    (setf wd (stripLeadingWhiteSpaces word))
;    ;; word はタグでなく、以前の状態遷移で言語が push 済みである。
;    (if
;      (and (stringp wd)
;           (not (null (empty statusStack)))
;      )
;      (let (newStatus status)
;        (setf newStatus (peek *statusStack*))
;        (setf status *curStatus*)
;        (if
;          (not (equal curStatus.stat newStatus.stat))
;          (progn
;            (setf newStatus (pop statusStack))
;            (if (and (not (zerop (logand (Status-stat *curStatus*) *statMaskAplpha*))) (null (isHankakuAlphabets wd)) (null (isZenkakuAlphabets wd T)))
;              (progn
;                ;; 次の評価済み文字列がアルファベットでないので自動解除
;                (emit "  [" curStatus.comment "] : fetch non-alphabet. " wd)
;                (emit "  [" curStatus.comment "]-->[" + newStatus.comment "] : stat popped.")
;                (setf *curStatus* newStatus)
;                (setf autoStatChanged T)
;              )
;              nil)
;            (if (and (not (zerop (logand curStatus.stat statMaskDigit))) (null (isHankakuDigits wd nil)) (null (isZenkakuDigits wd T)))
;              (progn
;                ;; 次の評価済み文字列が数字でないので自動解除
;                (emit "  [" curStatus.comment "] : fetch non-digit. " wd)
;                (emit "  [" curStatus.comment "]-->[" newStatus.comment "] : stat popped.")
;                (setf *curStatus* newStatus)
;                (setf autoStatChanged T)
;              )
;              nil))))
;      nil)
;    autoStatChanged))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 brailleEncoder
;; 【機能　】 変換元の連想配列を使用して墨字文字列を数値化する。
;;           その数値が変換先の連想配列の cdr部 と合致するコンスセルの car部 を文字列化
;;           して墨字を生成する。
;; 【入力　】 sym : 墨字シンボル（※intern する文字列に '|' が含まれないこと）
;;           slst : 変換元の連想配列
;; 【出力　】 点字文字列
;; 【例外　】 なし
;; 【使用例】 (brailleEncoder (intern "あ") *kana*) → "A"
;;          (brailleEncoder (intern "íː") *pronunciation*) → "I3"
;;          (brailleEncoder (intern "but ") *us_grade2*) → "B"
;;          (brailleEncoder (intern "about ") *us_grade2*) → "AB"
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun brailleEncoder(sym slist)
;  (if (numberp (cdr (assoc sym slist)))
;    (conv sym slist *represent*)
;    (let (l x (s nil)) ; us_grade2 の展開用
;      (setf l (cdr (assoc sym slist)))
;      (dolist (x l)
;        (setf s (concatenate 'string s (conv x *represent* *represent*))))
;      (values s))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 brailleDecoder_abbr
;; 【機能　】 表示用の連想配列を使用して点字文字列をリスト化する。
;;           そのリストが変換先の連想配列の cdr部 と合致するコンスセルの car部 を文字列化
;;           して墨字を生成する。
;; 【入力　】 str : 点字文字列
;;           dlst : 変換先の連想配列
;; 【出力　】 墨字文字列
;; 【例外　】 なし
;; 【使用例】 (brailleDecoder_abbr "AB" *us_grade2*) → "about"
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun brailleDecoder_abbr(str dlist)
;  (let ((lst nil) i x (s nil) ustr)
;    (setf ustr (string-upcase str))
;    (do '(i 0 (1+ i))
;      ((= i (length str)) nil)
;        (push (intern (subseq ustr i (1+ i))) lst))
;    (setf lst (reverse lst))
;    (dolist (x dlist)
;      (if (equal (cdr x) lst)
;        (setf s (format nil "~S" (car x)))
;        nil))
;    (values (substitute-string s "|" ""))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 getMasterBrailleMode
;; 【機能　】 点字文字列を評価して、点字のモードを取得する。
;; 【入力　】 o_mode : 
;;          o_end : 
;;          n_strt : 
;; 【出力　】 点字モードの文字列
;; 【例外　】 なし
;; 【使用例】 (getMasterBrailleMode "us" "#" " " nil) → "DI"
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun getMasterBrailleMode(o_mode o_end n_strt encode)
;  (let ((ret nil))
;    ; 外語引用モードの場合は、終了のタグ以外の影響は受けない。
;    (if (string= (string-upcase o_mode) "F")
;      (setf ret o_mode)
;      (if encode
;        (let ((oe (narrow-string o_end)) (ns (narrow-string n_strt)) c)
;          (setf c (char ns 0))
;          (if (not (null c))
;            (cond
;              ((string= oe "#") (setf ret "DI"))
;              (t (setf ret o_mode)))
;            (setf ret o_mode)))
;        (let (c)
;          (setf c (char n_strt 0))
;          (if (not (null c))
;            (cond
;              ((string= o_end "#") (setf ret "DI"))
;              (t (setf ret o_mode)))
;            (setf ret o_mode)))))
;    ret))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 convertWord2BrailleProc
;; 【機能　】 カレントの墨字→点字に変換する。（アトミック）
;; 【入力　】 word : 墨字文字列
;; 【出力　】 点字文字列
;; 【例外　】 なし
;; 【使用例】 (convertWord2BrailleProc "あ") → "A"
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun convertWord2BrailleProc(word &optional (lang *defaultLang*))
;  (brailleEncoder (intern word) lang)
;)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 convertBraille2WordProc
;; 【機能　】 点字→カレントの墨字に変換する。（アトミック）
;; 【入力　】 word : 点字文字列
;; 【出力　】 墨字文字列
;; 【例外　】 なし
;; 【使用例】 (convertBraille2WordProc "A") → "ア"
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun convertBraille2WordProc(word &optional (lang *defaultLang*))
;  (brailleDecoder word lang)
;)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 remove-string
;; 【機能　】文字列中から指定した1文字を除去する。
;; 【入力　】 str : 文字列
;;          ch  : 文字列（1文字）
;; 【出力　】 文字列
;; 【例外　】 なし
;; 【使用例】 (remove-string "A|B|C" "|") → "ABC"
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun remove-string (str ch)
;  (let ((n (position ch str :test #'(lambda (x y) (find y x :test #'char=)))))
;    (if n
;      (concatenate 'string (subseq str 0 n) (remove-string (subseq str (1+ n)) ch))
;      (concatenate 'string str nil))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 divide-string
;; 【機能　】 文字列を指定した文字列を区切り文字列として分割し、文字列のリストを生成する。
;; 【入力　】 str : 文字列
;;          mark : 文字列
;; 【出力　】 文字列のリスト
;; 【例外　】 なし
;; 【使用例】 (divide-string "a+b,,c-d,,e*f,,g/h" ",,")
;;           → ("a+b,," "c-d,," "e*f,," "g/h")
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun divide-string(str mark &optional (forgivemarkonly t))
;  (let ((n (search-string str mark (not forgivemarkonly))))
;    (if n
;      (cons (concatenate 'string (subseq str 0 n) mark)
;            (divide-string (subseq str (+ n (length mark))) mark))
;      (cons str nil))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 explode-string
;; 【機能　】 文字列を指定した区切り文字列リストで分割し、文字列のリストを生成する。
;; 【入力　】 str : 文字列
;;          marklst : 文字列リスト
;; 【出力　】 文字列のリスト
;; 【例外　】 なし
;; 【使用例】 (explode-string "a+b,,c-d,,e*f,,g/h" '(",," "+" "-" "*" "/"))
;;           → ("a+" "b,," "c-" "d,," "e*" "f,," "g/" "h")
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun explode-string(str marklst)                           
;  (let (ret tlst)
;    (setf tlst (list str))
;    (dolist (m marklst)
;      (setf ret nil)
;      (dolist (x tlst)
;        (setf ret (push (divide-string x m) ret))
;      )
;      (setf ret (flatten (reverse ret)))
;      (setf tlst ret)
;    )
;    (remove "" ret :test #'string=)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 hasChasen
;; 【機能　】 茶筅の有無を確認する。
;; 【入力　】 str : 検索対象の文字列
;; 【出力　】 文字列
;; 【例外　】 
;; 【使用例】 (hasChasen) → "A"
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun hasChasen
;    boolean ret = false;
;    StringTokenizer tokens = new StringTokenizer(doExec("which chasen"));
;    ret = (tokens.countTokens() == 1) ? true : false;
;    return ret;
;)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 constant-str-string-p
;; 【機能　】 文字列が、全て指定した文字列で構成されているか否かを返す。
;; 【入力　】 str : 文字列
;;          s : 文字列
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (constant-str-string-p "abababab" "ab") → t
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun constant-str-string-p(str s)
;  (let ((cnt 0) (lst (divide-string str s)))
;    (dolist (x lst)
;      (if (string= x s)
;        (setf cnt (1+ cnt))
;        nil))
;    (= cnt (/ (length str) (length s)))))

;(defun directDecode(b)
;  (let (ret)
;    (dolist (x *us_grade2_enc_dict*)
;      (if (string= (nth 2 x) b)
;        (setf ret (string-downcase (string (nth 0 x))))
;        nil))
;    ret))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 doBrackets
;; 【機能　】 デコード時に開始・終了が同じ値のコードを使用するカッコの終端処理をする。
;; 【入力　】 s         : 墨字文字列
;;            lcBraCnt  : "「" または "[" の個数
;;            fwlParCnt : "（" または "(" の個数
;; 【出力　】 適宜インクリメントされた lcBraCnt と fwlParCnt
;; 【例外　】 なし
;; 【使用例】 (doBrackets "「" "" 0 0 1) → "1" "0"
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun doBrackets(s lastStr lcBraCnt fwlParCnt grade)
;  (let ((ret1 s) (ret2 lcBraCnt) (ret3 fwlParCnt))
;    (if (= grade 2)
;      (cond
;        ((string= s "[")
;          (progn
;            (if (= (mod lcBraCnt 2) 1) (setf ret1 "]") nil)
;            (setf ret2 (1+ ret2))))
;        ((string= s "(")
;          (progn
;            (if (= (mod fwlParCnt 2) 1) (setf ret1 ")") nil)
;            (setf ret3 (1+ ret3))))
;        ((string= (subseq s 0 1) ".")
;          (progn (setf ret2 0) (setf ret3 0))))
;      (cond
;        ((string= s "「")
;          (progn
;            (if (= (mod lcBraCnt 2) 1) (setf ret1 "」") nil)
;            (setf ret2 (1+ ret2))))
;        ((string= s "（")
;          (progn
;            (if (= (mod fwlParCnt 2) 1) (setf ret1 "）") nil)
;            (setf ret3 (1+ ret3))))
;  #|
;        ; "「。" "「、" のシーケンスは不正であるので、括弧のカウンタをリセットする。
;        ((and (string= lastStr "「")
;            (or (string= (subseq s 0 1) "。") (string= (subseq s 0 1) "、")))
;          (setf ret2 1))
;        ; "（。" "（、" のシーケンスは不正であるので、括弧のカウンタをリセットする。
;        ((and (string= lastStr "（")
;            (or (string= (subseq s 0 1) "。") (string= (subseq s 0 1) "、")))
;          (setf ret3 1))
;  |#
;        ((string= (subseq s 0 1) "。")
;          (progn (setf ret2 0) (setf ret3 0)))))
;    (values ret1 ret2 ret3)))

;(defun wordPostProcess(mode brl txt lang jpPrep encode)
;  (let ((m mode) (l lang) s
;        (rawM0 (subseq mode 0 1))
;        (rawM1 (subseq mode 1 2))
;        (upcaseM0 (string-upcase (subseq mode 0 1))))
;    (if encode
;      (setf s brl)
;      (setf s txt))
;    ; 外字符をフェッチした。
;    (if (string= s _letterSign_s_)
;      (progn (setf m "us") (setf l (getLang m)))
;      nil)
;    (if encode
;      (cond
;        ; エンコード（日本語モード）
;        ((string= upcaseM0 "J")
;          ; 日本語モードで "8"('｛') (外国語引用符開始)を出力したら、外語引用モードに遷移させる。
;          (if (string= brl _foreignQuotationStartSign_s_)
;            (progn (setf m "fq") (setf l (getLang m)))
;            nil))
;        ; エンコード（英語モード）
;        ((string= upcaseM0 "U")
;          (progn
;            ; 英語モードで "_+" (ACBC開始)を出力したら、米国点字符号モードに遷移させる。
;            (if (string= brl _acbcStartSign_s_)
;              (progn (setf m "ac") (setf l (getLang m)))
;              nil)
;            ; 【括弧モード管理】状態遷移があった場合は、適宜調整する。
;            (if (maintainBrackets brl txt *grade* encode)
;              (progn
;                ; 必要があれば、調整する。
;;                (format t "~%[~S] [~S]" brl txt)
;              )
;              nil)
;            (cond
;              ((= *grade* 1)
;                (progn
;                  ; 【ルール3b】英語モードのハイフン(エンコード時ポスト処理)
;                  ; 英語モードで "-" を出力したら、ポスト処理で "JP"モードに遷移させる。
;                  ;
;                  ;  "-" は日本語モードで "「" または "」" として処理したいところだが、
;                  ; "Ｉ－サン" などを正しく処理するため例外的にプリ処理で英語モードを
;                  ; 維持させるが、"－" 出力後にポスト処理で日本語モードに遷移させる。
;                  ; よって、zero-nine-etc-charp で数字と同列には扱わない。
;                  (if (string= brl "-")
;                    (progn (setf m *defaultMode*) (setf l (getLang m)))
;                    nil)))
;              ((= *grade* 2)
;                (progn
;                  ; 英語グレード２で " ;" 検出による強制英語グレード１モードを解除する。
;                  (if (and (string/= brl _letterSign_s_)
;                           (string/= brl _capitalSign_s_)
;                           (not (both-case-p (char brl 0))))
;                    (setf *forceGrade1* nil)
;                    nil))))))
;        ; エンコード（外語引用モード）
;        ((string= upcaseM0 "F")
;          ; 外語引用モードで "0"('}') (外国語引用符終了)を出力したら、デフォルト（日本語モード）に遷移させる。
;          (if (string= brl _foreignQuotationStopSign_s_)
;            (progn (setf m *defaultMode*) (setf l (getLang m)))
;            nil))
;        ; エンコード（米国点字符号モード）
;        ((string= upcaseM0 "A")
;          ; 米国点字符号モードで "_:" (ACBC終了)を出力したら、デフォルト（英語モード）に遷移させる。
;          (if (string= brl _acbcStopSign_s_)
;            (progn (setf m *defaultMode*) (setf l (getLang m)))
;            nil))
;        ; エンコード（数字モード）
;        ((string= upcaseM0 "D")
;          (progn
;            ; 【ルール2b】数字モードのハイフン(エンコード時ポスト処理)
;            ; 数字モードで "－" を出力したら、ポスト処理で "JP"モードに遷移させる。
;            ;
;            ;  "-" は日本語モードで "「" または "」" として処理したいところだが、
;            ; "＃１０００－＃２０００" などを正しく処理するため例外的に
;            ; プリ処理で数字モードを維持させるが、"－" 出力後にポスト処理で日本語モード
;            ; に遷移させる。よって、zero-nine-etc-charp で数字と同列には扱わない。
;            (if (string= brl "-")
;              (progn (setf m *defaultMode*) (setf l (getLang m)))
;              nil)))
;        ; エンコード（エラー）
;        (t (format t "~%Error: wordPostProcess(エンコード)")))
;      (cond
;        ; デコード（日本語モード）
;        ((string= upcaseM0 "J")
;          (progn
;            ; 【括弧モード管理】状態遷移があった場合は、適宜調整する。
;            (if (maintainBrackets brl txt *grade* encode)
;              (progn
;                ; 括弧や鍵括弧は開始・終了に同じコードを使用しているので、調整する。
;                (cond
;                  ((and (not (inBracket)) (string= txt "（")) (setf s "）"))
;                  ((and (not (inSquareBracket)) (string= txt "「")) (setf s "」")))
;;                (format t "~%[~S] [~S]" brl txt)
;              )
;              nil)
;            ; '{' (外国語引用符開始)を出力したら、外語引用モードに遷移させる。
;            (if (string= txt "{")
;              (progn (setf m "fq") (setf l (getLang m)))
;              nil)
;            ; 濁音・半濁音に '"' や ',' を前置きする。
;            (if jpPrep
;              (setf s (voicedSound-or-pSound s))
;              nil)))
;        ; デコード（英語モード）
;        ((string= upcaseM0 "U")
;          (progn
;;(format t "~%1[~A]" s)
;            (cond
;              ((string= rawM0 "U")
;                (progn
;;(format t "~%2[~A]" s)
;                  ; 大文字変換
;                  ; 【デバッグ中】
;                  (if (and (= *grade* 2) (> (length txt) 1) (string= rawM1 "s"))
;                    ; 英語グレード２で "Us" の場合
;                    (let (fore rest)
;                      (setf fore (subseq txt 0 1))
;                      (setf rest (subseq txt 1 (length txt)))
;                      (setf s (format nil "~A~A" (string-upcase fore) (string-downcase rest))))
;                    ; 英語グレード２で "Us" 以外の場合
;                    (setf s (string-upcase txt)))
;;                (setf s (string-upcase txt))
;                  (cond
;                    ; "Us" モードで 1文字出力したら、"us"モードに降格させる。
;                    ((and (string= m "Us") (both-case-p (char txt 0)))
;                      (progn (setf m "us") (setf l (getLang m))))
;                    ; 二重大文字符モードで "－" "　" を出力したので、"us"モードに降格させる。
;                    ((and (string= m "US") (or (string= txt "－") (string= txt _blank_w_)))
;                      (progn (setf m "us") (setf l (getLang m))))))))
;            ; 【括弧モード管理】状態遷移があった場合は、適宜調整する。
;            (if (maintainBrackets brl txt *grade* encode)
;              (progn
;                (cond
;                  ; 括弧や角括弧や大括弧は開始・終了に同じコードを使用しているので、調整する。
;                  ((and (not (inBracket)) (string= txt "(")) (setf s ")"))
;                  ((and (not (inAngleBracket)) (string= txt "<")) (setf s ">"))
;                  ((and (not (inBraceBracket)) (string= txt "{")) (setf s "}")))
;;                (format t "~%[~S] [~S]" brl txt)
;              )
;              nil)
;            (cond
;              ((= *grade* 1)
;                (progn
;                  ; 【ルール3b】英語モードのハイフン(デコード時ポスト処理)
;                  ; 英語モードで "－" を出力したら、ポスト処理で "JP"モードに遷移させる。
;                  ;
;                  ;  "-" は日本語モードで "「" または "」" として処理したいところだが、
;                  ; "Ｉ－サン" などを正しく処理するため例外的にプリ処理で英語モードを
;                  ; 維持させるが、"－" 出力後にポスト処理で日本語モードに遷移させる。
;                  ; よって、a-j-etc-charp で数字と同列には扱わない。
;                  (if (string= txt "－")
;                    (progn (setf m *defaultMode*) (setf l (getLang m)))
;                    nil)))
;              ((= *grade* 2)
;                (progn
;                  ; 英語グレード２で " ;" 検出による強制英語グレード１モードを解除する。
;                  (if (and (string/= txt _letterSign_s_)
;                           (string/= txt _capitalSign_s_)
;                           (not (both-case-p (char txt 0))))
;                    (setf *forceGrade1* nil)
;                    nil))))))
;        ; デコード（外語引用モード）
;        ((string= upcaseM0 "F")
;          (progn
;            (cond
;              ((string= rawM0 "F")
;                (progn
;                  ; 大文字変換
;                  (setf s (string-upcase txt))
;                  ; "Fq" モードで 1文字出力したら、"fq"モードに降格させる。
;                  (cond
;                    ((and (string= m "Fq") (both-case-p (char txt 0)))
;                      (progn (setf m "fq") (setf l (getLang m)))))
;                  ; "FQ" モードで "." "/" を出力したので、"fq"モードに降格させる。
;                  (cond
;                    ((and (string= m "FQ") (or (char= (char txt 0) #\.) (char= (char txt 0) #\/)))
;                      (progn (setf m "fq") (setf l (getLang m))))))))
;            ; '}' (外国語引用符終了)を出力したら、デフォルト（日本語モード）に遷移させる。
;            (if (string= txt "}")
;              (progn (setf m *defaultMode*) (setf l (getLang m)))
;              nil)))
;        ; デコード（米国点字符号モード）
;        ((string= upcaseM0 "A")
;          (progn
;            (cond
;              ((string= rawM0 "A")
;                (progn
;                  ; 大文字変換
;                  (setf s (string-upcase txt))
;                  ; "Ac" モードで 1文字出力したら、"ac"モードに降格させる。
;                  (cond
;                    ((and (string= m "Ac") (both-case-p (char txt 0)))
;                      (progn (setf m "ac") (setf l (getLang m))))))))
;            ; (ACBC終了)を出力したので、デフォルト（英語モード）に遷移させる。
;            (if (string= txt _acbcStopSign_s_)
;              (progn (setf m *defaultMode*) (setf l (getLang m)))
;              nil)))
;        ; デコード（数字モード）
;        ((string= upcaseM0 "D")
;          (progn
;            ; 【ルール2b】数字モードのハイフン(デコード時ポスト処理)
;            ; 数字モードで "－" を出力したら、ポスト処理で "JP"モードに遷移させる。
;            ;
;            ;  "-" は日本語モードで "「" または "」" として処理したいところだが、
;            ; "＃１０００－＃２０００" などを正しく処理するため例外的に
;            ; プリ処理で数字モードを維持させるが、"－" 出力後にポスト処理で日本語モード
;            ; に遷移させる。よって、a-j-etc-charp で数字と同列には扱わない。
;            (if (string= txt "－")
;              (progn (setf m *defaultMode*) (setf l (getLang m)))
;              nil)))
;        ; デコード（エラー）
;        (t (format t "~%Error: wordPostProcess(デコード)"))))
;    (values m l s)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 string-upcase-w1
;; 【機能　】 文字列中の全角小文字を全角大文字に変換する。
;; 【入力　】 str : 文字列（1文字）
;; 【出力　】 文字列（1文字）
;; 【例外　】 なし
;; 【使用例】 (string-upcase-w1 "ａ") → "Ａ"
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun string-upcase-w1(str)
;  (let ((ret str))
;    (setf ix (search str *wide_down_alphas*))
;    (if (and (numberp ix) (>= ix 0))
;      (setf ret (coerce (list (coerce (char *wide_up_alphas* ix) 'character)) 'string))
;      nil)
;    ret))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 string-upcase-w
;; 【機能　】 文字列中の全角大文字を全角小文字に変換する。
;; 【入力　】 str : 文字列
;; 【出力　】 文字列
;; 【例外　】 なし
;; 【使用例】 (string-upcase-w "ａ") → "Ａ"
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun string-upcase-w(str)
;  (let (ret i)
;    (do '(i 0 (1+ i))
;      ((= i (length str)) nil)
;      (setf ret (concatenate 'string ret (string-upcase-w1 (subseq str i (1+ i))))))
;    ret))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 string-downcase-w
;; 【機能　】 文字列中の全角大文字を全角小文字に変換する。
;; 【入力　】 str : 文字列
;; 【出力　】 文字列
;; 【例外　】 なし
;; 【使用例】 (string-downcase-w "Ａ") → "ａ"
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun string-downcase-w(str)
;  (let (ret i)
;    (do '(i 0 (1+ i))
;      ((= i (length str)) nil)
;      (setf ret (concatenate 'string ret (string-downcase-w1 (subseq str i (1+ i))))))
;    ret))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 string-downcase-w1
;; 【機能　】 文字列中の全角大文字を全角小文字に変換する。
;; 【入力　】 str : 文字列（1文字）
;; 【出力　】 文字列（1文字）
;; 【例外　】 なし
;; 【使用例】 (string-downcase-w1 "Ａ") → "ａ"
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun string-downcase-w1(str)
;  (let ((ret str))
;    (setf ix (search str *wide_up_alphas*))
;    (if (and (numberp ix) (>= ix 0))
;      (setf ret (coerce (list (coerce (char *wide_down_alphas* ix) 'character)) 'string))
;      nil)
;    ret))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 ignoreableRight
;; 【機能　】 未処理の文字列が無視できるか否かを返す。
;; 【入力　】 str    : 文字列
;;            encode : t/nil
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (ignoreableRight " ") → t
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun ignoreableRight (str &optional (encode nil))
;  (let (lst s)
;    (if (null encode)
;      (progn
;        (setf lst (list " "))
;        (setf s (subtract-strings str lst))
;        (if (= (length s) 0)
;          t
;          (or (string= s "4") ; xxx.
;              (string= s "1") ; xxx,
;              (string= s "0") ; xxx"
;              (string= s "8") ; xxx?
;              (string= s "6") ; xxx!
;              (string= s "7") ; xxx)
;              (string= s "3") ; xxx:
;;              (string= s "#") ; #
;              )))
;      (progn
;        (setf lst (list _blank_w_))
;        (setf s (subtract-strings str lst))
;        (if (= (length s) 0)
;          t
;          (or (string= s "．") ; xxx.
;              (string= s "，") ; xxx,
;              (string= s "”")  ; xxx"
;              (string= s "！") ; xxx!
;              (string= s "？") ; xxx?
;              (string= s "）") ; xxx)
;              (string= s "：") ; xxx:
;;              (string= s "＃") ; #
;              ))))))

;(defun wholeWordCandidate(left past s next &optional (encode nil))
;  (let ((tail (subseq s (1- (length s)))))
;    (and
;      (or (= left 0) (ignoreableLeft past encode))
;      (or (ignoreableTail tail encode) (ignoreableRight next encode)))))

;(defun initialWordCandidate(left past s next &optional (encode nil))
;  (let ((tail (subseq s (1- (length s)))))
;    (and
;      (or (= left 0) (ignoreableLeft past encode))
;      (or (= (length s) 1) (null (ignoreableTail tail encode)))
;      (null (ignoreableRight next encode)))))

;(defun medialWordCandidate(left past s next &optional (encode nil))
;  (let ((tail (subseq s (1- (length s)))))
;    (and
;      (and (/= left 0) (null (ignoreableLeft past encode)))
;      (or (= (length s) 1) (null (ignoreableTail tail encode)))
;      (null (ignoreableRight next encode)))))

;(defun terminalWordCandidate(left past s next &optional (encode nil))
;  (let ((tail (subseq s (1- (length s)))))
;    (and
;      (and (/= left 0) (null (ignoreableLeft past encode)))
;      (or (= (length s) 1) (null (ignoreableTail tail encode)))
;      (ignoreableRight next encode))))

;(defparameter *lcBraCnt* 0)             ; "「」"の整形に使用するカウンタ
;(defparameter *fwlParCnt* 0)            ; "（）"の整形に使用するカウンタ

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 quoteLike-p
;; 【機能　】 対象文字列がクォーテーションや外字符等の無視できるものか否かを返す。
;; 【入力　】 last_token : 文字列
;;          encode     : t の場合 token を墨字として処理、nil の場合 token
;;                       を点字として処理する。
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (quoteLike-p "" nil) → t
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun quoteLike-p (last_token encode)
;  (if (null encode)
;    (or (string= last_token "")             ; 冒頭
;        (string= last_token "&")            ; andxxx
;        (string= last_token "=")            ; forxxx
;        (string= last_token "(")            ; ofxxx
;        (string= last_token ")")            ; withxxx
;        (string= last_token "96")           ; intoxxx (03.03.05 Wordsigns sequenced)
;        (string= last_token "6")            ; toxxx   (03.03.02 Wordsigns sequenced)
;        (string= last_token "0")            ; byxxx   (03.03.06 Wordsigns sequenced)
;        (string= last_token _letterSign_s_) ; ";" に連なる。
;        (string= last_token ".7")           ; {xxx 左大括弧に連なる。
;        (string= last_token "^7")           ; [xxx open phonemic bracket に連なる。
;        (string= last_token ",7")           ; [xxx 左カギ括弧に連なる。
;        (string= last_token "7")            ; (xxx 左括弧に連なる。
;        (string= last_token ",8")           ; `xxx シングルクォート開始に連なる。
;        (string= last_token "8"))           ; "xxx ダブルクォート開始に連なる。
;    (or (string= last_token "")             ; 冒頭
;        (string= last_token "ａｎｄ")        ; andxxx 
;        (string= last_token "ｆｏｒ")        ; forxxx
;        (string= last_token "ｏｆ")          ; ofxxx
;        (string= last_token "ｗｉｔｈ")       ; withxxx
;        (string= last_token "ｉｎｔｏ")       ; intoxxx (03.03.05 Wordsigns sequenced)
;        (string= last_token "ｔｏ")          ; toxxx   (03.03.02 Wordsigns sequenced)
;        (string= last_token "ｂｙ")          ; byxxx   (03.03.06 Wordsigns sequenced)
;        (string= last_token _letterSign_w_) ; "；" に連なる。
;        (string= last_token "｛")           ; {xxx 左大括弧に連なる。
;        (string= last_token "［")           ; [xxx に連なる。
;        (string= last_token "（")           ; (xxx 左括弧に連なる。
;        (string= last_token "’")            ; `xxx シングルクォート開始に連なる。
;        (string= last_token "”"))))         ; "xxx ダブルクォート開始に連なる。

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 capitalSign-p
;; 【機能　】 対象文字列が大文字符か否かを返す。
;; 【入力　】 s      : 墨字
;;          b      : 点字
;;          last_b : 直前の点字
;;          encode : t の場合 token を墨字として処理、nil の場合 token
;;                   を点字として処理する。
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (capitalSign-p "," "," "" nil) → t
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun capitalSign-p(s b last_b encode)
;  (if (null encode)
;    (and (string= s _capitalSign_s_)
;         (string= b _capitalSign_s_))
;    (and (string= s _capitalSign_w_)
;         (string= b _capitalSign_w_))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 alpha-etc-charp
;; 【機能　】 文字がアルファベット・カンマであるか否かを返す。
;; 【入力　】 ch : 文字
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (alpha-etc-charp "a") → t
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun alpha-etc-charp (ch)
;  (let (ret)
;    (if (and (not (null ch)) (or (char= #\, ch) (both-case-p ch)))
;      (setf ret t)
;      nil)
;    ret))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 zero-nine-charp
;; 【機能　】 対象文字が [0-9] か否かを返す。
;; 【入力　】 ch : 文字
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (zero-nine-charp (char "0" 0)) → t
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun zero-nine-charp (ch)
;  (let (ret)
;    (if (and (not (null ch)) (char>= ch #\0) (char>= #\9 ch))
;      (setf ret t)
;      nil)
;    ret))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 zero-nine-wcharp
;; 【機能　】 対象文字が [0-9] か否かを返す。
;; 【入力　】 ch : 文字
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (zero-nine-wcharp (char "０" 0)) → t
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun zero-nine-wcharp (ch)
;  (let (ret)
;    (if (and (not (null ch)) (char>= ch #\FULLWIDTH_DIGIT_ZERO) (char>= #\FULLWIDTH_DIGIT_NINE ch))
;      (setf ret t)
;      nil)
;    ret))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; 可逆の変換(brailleEncoder/brailleDecoder)の可否をチェックする（文字列を経由）
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun chkAllLangOrg()
;  (let ((ret 0) i a b lang str)
;    (dolist (lang *langList*)
;      (princ "*")
;      (setf str (allOrgCars lang))
;;      (print str)
;      (let (w lst s b)
;        (setf lst (split-string str))
;        (dolist (w lst)
;          ; （※intern する文字列に '|' が含まれないこと）
;          (setf b (brailleEncoder (intern (substitute-string w "|" "")) lang))
;          (if (null b)
;            (print w)
;            (progn
;              (setf s (brailleDecoder b lang))
;              (if (null s)
;                (progn (format t "~%Error: ~S ~A" w b) (setf ret (1+ ret)))
;                nil))))))
;    ret))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; 指定した lang の car部を連結した文字列を作成する。
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun allOrgCars(lang)
;  (let (i a str)
;    (do '(i 0 (1+ i))
;      ((= i (length lang)) nil)
;      (setf a (car (nth i lang)))
;      (setf str (concatenate 'string str (format nil "~S " a))))
;    (string-right-trim " " str)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; 指定した lang の car部を点字に変換して連結した文字列を作成する。
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun allBrlCars(lang)
;  (let (i a b str)
;    (do '(i 0 (1+ i))
;      ((= i (length lang)) nil)
;      (setf a (car (nth i lang)))
;      (setf b (brailleEncoder a lang))
;      (setf str (concatenate 'string str b " ")))
;    (string-right-trim " " str)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; 指定した lang の 可逆の変換(brailleEncoder/brailleDecoder)の可否をチェックする（文字列を経由）
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun chkBrlCars(lang)
;  (let (i a b s lst)
;    (do '(i 0 (1+ i))
;      ((= i (length lang)) nil)
;      (setf a (car (nth i lang)))
;      (setf b (brailleEncoder a lang))
;      (setf lst (split-string b))
;      (setf s (brailleDecoder (car lst) lang))
;      (if (null s)
;        (format t "~%Error: ~S ~A split-string returns ~S" a b lst)
;        nil))))

;(defun g2test()
;  (g2us)
;  (format t "~%~S" (encodeBrailleFile "../txt/pink floyd/time.txt" "../bse/pink floyd/time.bse" 32 22 t nil nil))
;  (format t "~%~S" (decodeBrailleFile "../bse/pink floyd/time.bse" nil t t t nil nil t))
;  (g1))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 emit
;; 【機能　】 任意の数の引数を連結して画面に表示する。
;; 【入力　】 args : 任意の数の引数
;; 【出力　】 画面への表示
;; 【例外　】 
;; 【使用例】 (emit "ABC" #\Space "def") → "ABC def"
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun emit (&rest args)
;  (with-output-to-string (s)
;    (dolist (a args) (princ a s))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 getMaxItemLength
;; 【機能　】 それぞれの言語の連想配列から墨字・点字の最大長を取得する。
;; 【入力　】 なし
;; 【出力　】 なし
;; 【例外　】 なし
;; 【使用例】 (getMaxItemLength) → nil
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun getMaxItemLength()
;  (let (lst sumiLen brlLen (i 0))
;    (setf *maxItemLengthList* nil)
;    (dolist (xx *langList*)
;      (if xx
;        (progn
;          (setf lst (mapcar #'(lambda (x) (length (string (car x)))) xx))
;          (setf sumiLen (eval (pushnew (intern "MAX") lst)))
;          (setf lst (mapcar #'(lambda (x) (braille-bytes (logand (cdr x) _AllClearBits_))) xx))
;          (setf brlLen (eval (pushnew (intern "MAX") lst)))
;          (pushnew (list (intern (nth i *langNameList*)) sumiLen brlLen) *maxItemLengthList*))
;        nil)
;      (setf i (1+ i)))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 atomic-p
;; 【機能　】 処理済みの文字列が分解できるか否かを返す。
;; 【入力　】 str : 文字列
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (atomic-p ",8") → t
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; マクロに変換した。
;(defun atomic-p (str)
;  (or ; ignoreableTail の対象の文字列で構成されたものうち、アトミックなもの。
;    (string= str "96")   ; intoxxx (03.03.05 Wordsigns sequenced)
;    (string= str "@7")   ; /xxx
;    (string= str "^7")   ; [xxx open phonemic bracket
;    (string= str "_7")   ; <xxx
;    (string= str ".7")   ; {xxx 左大括弧
;    (string= str ",7")   ; [xxx 左カギ括弧
;    (string= str ",8")   ; `xxx シングルクォート開始
;    (string= str "7'")   ; ]
;    (string= str "j'")   ; '
;    (string= str "0'"))) ;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 formatter-decode-p
;; 【機能　】 構成符号を表す文字列か否かを返す。
;; 【入力　】 brl : 点字文字列
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (formatter-decode-p "=") → t
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; マクロに変換した。
;(defun formatter-decode-p (brl)
;  (or
;    (string= brl "=")    ; ドットロケータ
;    (string= brl ">")    ; 詩行符
;    (string= brl "#")    ; 数符
;    (string= brl "@")    ; アクセント符、行継続符、墨字記号符
;    (string= brl "\"3")  ; 印刷インジケータ
;    (string= brl ".")    ; イタリック符
;    (string= brl "..")   ; 二重イタリック符
;    (string= brl ".'")   ; イタリック符解除
;    (string= brl ";")    ; 外字符（レターサイン）、字母記号、発音記号符
;    (string= brl ";;")   ; 二重外字符（レターサイン）
;    (string= brl "_+")   ; ACBC(American Computer Braille Code)開始
;    (string= brl "_:")   ; ACBC(American Computer Braille Code)終了
;    (string= brl ",")    ; 大文字符
;    (string= brl ",,")   ; 連続大文字符
;    (string= brl ",,,")  ; 三重連続大文字符
;    (string= brl ",'")   ; 終止符、第二つなぎ符、大文字符解除
;    (string= brl "-")    ; ハイフン、第一つなぎ符
;    (string= brl "--"))) ; ダッシュ

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 punctuation-p
;; 【機能　】 句読点などを表す文字列（"." "," "-"）か否かを返す。
;;          "?" は【松ルール①】に従って *us_grade2* で直接宣言されているので、適用外。
;;          "!" は頻度が低いと考えられるので、双方とも対処しない。
;; 【入力　】 str : 墨字文字列
;;            brl : 点字文字列
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (punctuation-p "." "4") → t
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; マクロに変換した。
;(defun punctuation-p (str brl)
;  (or
;    (and (string= str ".")  (string= brl "4"))   ; . ピリオド
;    (and (string= str ",")  (string= brl "1"))   ; , カンマ
;    (and (string= str "\"") (string= brl "8"))   ; " ダブルクォート開始
;    (and (string= str ";")  (string= brl "2"))   ; ; セミコロン
;    (and (string= str "-")  (string= brl "-")))) ; - ハイフン

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 prohibit-hankaku-p
;; 【機能　】 エンコード時に墨字を半角化できないか否かを返す。
;; 【入力　】 str : 文字列
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (prohibit-hankaku-p "＜") → nil
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; マクロに変換した。
;(defun prohibit-hankaku-p (str mode)
;  (or
;    (and (string= mode "JP")
;         ; "。" "、" は、直後に全角スペースを伴うため、半角化しない。
;         (or ; これらは narrow-string で全部または一部が半角化されるもの。
;           (string= str _kutenSumiji_)    ; "。"
;           (string= str _toutenSumiji_)   ; "、"
;           (string= str _hyphen_w_)       ; "ー"
;           (string= str _dot_w_)          ; "．"
;           (string= str _exclamation_w_)  ; "！"
;           (string= str _question_w_)     ; "？"
;           (string= str _leftAngBrac_w_)  ; "＜"
;           (string= str _rightAngBrac_w_) ; "＞"
;           (string= str _slash_w_)))      ; "／"
;    (and (string= mode "DI")
;         (string= str _dash_w_))))        ; "－"

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 explode-delims
;; 【機能　】 文字列が全て指定した区切り文字列であれば分割し、文字列のリストを
;;            生成する。
;; 【入力　】 str   : 文字列
;;            delim : 区切り文字列
;; 【出力　】 文字列のリスト
;; 【例外　】 なし
;; 【使用例】 (explode-delims "    " #\Space) → (" " " " " " " ")
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; マクロに変換した。
;(defun explode-delims (str delim)
;  (if (= (count-if #'(lambda (x) (string= x delim)) str) (length str))
;    (explode-string str (list delim))
;    (list str)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 constant-char-stringp
;; 【機能　】 文字列が、全て指定した文字で構成されているか否かを返す。
;; 【入力　】 str : 文字列
;;            chr : 文字
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (constant-char-stringp "        " #\Space) → t
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; マクロに変換した。
;(defun constant-char-stringp (str chr)
;  (= (count-if #'(lambda (x) (string= x (string chr))) str) (length str)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 alpha-etc-charp
;; 【機能　】 文字がアルファベット・カンマであるか否かを返す。
;; 【入力　】 ch : 文字
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (alpha-etc-charp "a") → t
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; マクロに変換した。
;(defun alpha-etc-charp (ch)
;  (and (not (null ch)) (or (char= #\, ch) (both-case-p ch))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 zero-nine-charp
;; 【機能　】 対象文字が [0-9] か否かを返す。
;; 【入力　】 ch : 文字
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (zero-nine-charp (char "0" 0)) → t
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; マクロに変換した。
;(defun zero-nine-charp (ch)
;  (and (not (null ch)) (char>= ch #\0) (char>= #\9 ch)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 zero-nine-wcharp
;; 【機能　】 対象文字が [0-9] か否かを返す。
;; 【入力　】 ch : 文字
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (zero-nine-wcharp (char "０" 0)) → t
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; マクロに変換した。
;(defun zero-nine-wcharp (ch)
;  (and (not (null ch)) (char>= ch #\FULLWIDTH_DIGIT_ZERO) (char>= #\FULLWIDTH_DIGIT_NINE ch)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 makeUsGrade2Dictionary
;; 【機能　】 ファイルのデータから英語グレード２辞書の連想配列やファイルを作成する。
;; 【入力　】 infn       : 辞書入力ファイルのパス
;;          extfn      : 辞書出力ファイルのパス
;;          genExtFile : 英語グレード２の辞書エクストラクトファイル作成の要否
;; 【出力　】 エラー情報のリスト
;; 【例外　】 なし
;; 【使用例】 (makeUsGrade2Dictionary "../dic/us_grade2.txt" "../dic/us_grade2.ext" t)
;;           → nil
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; 以下を実行する関数
;  (setf *us_grade2_enc_dict* ; 英語グレード２のエンコード用辞書の初期化
;   '( ;  シンボル       生データ       置換文字列
;      (|storeroom| "(st)oreroom" "/OREROOM")
;      ...
;    )
;  )
;
;  (setf *us_grade2_dec_dict* ; 英語グレード２のデコード用辞書の初期化
;   '( ; 置換文字列    シンボル
;      (/OREROOM "(st)oreroom" "storeroom")
;      ...
;    )
;  )
;
;(defun makeUsGrade2Dictionary (infn extfn genExtFile)
;  (let (buff (lineNo 1) (delim _fieldSeparator_) s b e errList)
;    (setf *us_grade2_enc_dict* nil *us_grade2_dec_dict* nil)
;    (initLang 2)
;    (if genExtFile
;      (progn
;        ;; 辞書エクストラクトファイルを削除する。
;        (unwind-protect (delete-file extfn))
;        ;; 辞書エクストラクトファイルをライトオープンする。
;        (with-open-file (outstream extfn :direction :output :if-exists :new-version)
;          ;; 辞書入力ファイルをオープンする。
;          (with-open-file (instream infn :direction :input)
;            (let (convPair)
;              (do ()
;                ((null (setf buff (read-line instream nil))) nil)
;                ; 1行エンコードする。
;                (if (and (> (length buff) 1)
;                         (string/= (subseq buff 0 1) _numeralSign_s_)) ; "#"
;                  (let ((srcStr nil) lst flags (mask 0))
;                    (setf lst (split-string buff ","))
;                    (setf buff (nth 0 lst))
;                    (setf flags (nth 1 lst))
;                    ; フラグに応じて辞書の結合マスクを設定する。
;                    (if (search-string flags "w" 0)
;                      (setf mask (logior mask _wholeWordMask_))
;                      nil)
;                    (if (search-string flags "i" 0)
;                      (setf mask (logior mask _initialWordMask_))
;                      nil)
;                    (if (search-string flags "m" 0)
;                      (setf mask (logior mask _medialWordMask_))
;                      nil)
;                    (if (search-string flags "f" 0)
;                      (setf mask (logior mask _finalWordMask_))
;                      nil)
;                    (setf convPair (explode-string buff '("→") nil))
;                    (if (= (length convPair) 2) ; 直接変換がある場合
;                      (progn
;                        (setf srcStr (substitute-string (nth 0 convPair) "→" ""))
;                        (setf buff (nth 1 convPair)))
;                      nil)
;                    (multiple-value-setq (s b e) (genUsGrade2DicInfo buff lineNo))
;                    (if e (push e errList) nil)
;                    (if srcStr ; 直接変換がある場合
;                      (progn
;                        (push (list (intern srcStr) buff mask b) *us_grade2_enc_dict*)
;                        (push (list (intern b) buff mask srcStr) *us_grade2_dec_dict*))
;                      (progn
;                        (push (list (intern s) buff mask b) *us_grade2_enc_dict*)
;                        (push (list (intern b) buff mask s) *us_grade2_dec_dict*)))
;                    (format outstream "~S~A~S~%" (nth 0 *us_grade2_enc_dict*) delim (nth 0 *us_grade2_dec_dict*))
;                    (setf lineNo (1+ lineNo)))
;                  nil)))
;            ;; 辞書入力ファイルをクローズする。
;            (close instream))
;          ;; 辞書エクストラクトファイルをクローズする。
;          (close outstream)))
;      ;; 辞書エクストラクトファイルをリードオープンする。
;      (with-open-file (instream extfn :direction :input)
;        (let (lst)
;          (do ()
;            ((null (setf buff (read-line instream nil))) nil)
;            (setf lst (split-string buff delim))
;            ; 1行読み込み、エンコード・デコード情報を取得する。
;            (push (read-from-string (nth 0 lst)) *us_grade2_enc_dict*)
;            (push (read-from-string (nth 1 lst)) *us_grade2_dec_dict*)
;            (setf lineNo (1+ lineNo))))
;        ;; 辞書エクストラクトファイルをクローズする。
;        (close instream)))
;    (initLang 1)
;    errList))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 concatenateWord
;; 【機能　】 エンコード・デコード結果を出力バッファに追加する。
;; 【入力　】 buff                 : 出力バッファ 
;;            b                : 点字
;;            s                : 墨字
;;            effective_last_s : エンコード時：前回エンコード元の墨字
;;                               デコード時　：前回エンコード結果の有効な墨字
;;            spPrepInf        : エンコード時：入力文字列の前置詞等を連結するか否か
;;                               デコード時　：入力文字列の前置詞等を分割するか否か
;;            g2info           : 英語グレード２のエンコード用辞書情報
;;            i_substr_cnt     : チャンクの部分文字列カウンタ
;;            grade            : グレード
;;            encode           : t の場合 token を墨字として処理、nil の場合 token
;;                               を点字として処理する。
;; 【出力　】 (連結された文字列 部分文字列の数)
;; 【例外　】 なし
;; 【使用例】 (concatenateWord ) → 
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun concatenateWord (buff b s effective_last_s spPrepInf g2info i_substr_cnt grade encode)
;  (let ((ret buff) (substr_cnt i_substr_cnt))
;;(if (> (length ret) 1)
;;(format t "~%~S, ~S, ~S, ~S" ret substr_cnt (subseq ret (1- (length ret))) (string-downcase (narrow-string s grade)))
;;nil)
;
;    (if encode
;      (let ((last_b nil) (hankakuStr (string-downcase (narrow-string s grade))))
;        ; 出力バッファから事前に追加された点字を取得する。
;        (if (>= (length ret) 1)
;          (setf last_b (subseq ret (1- (length ret))))
;          nil)
;;(format t "~%ret:[~S], substr_cnt:[~S], last_b:[~S], s:[~S], b:[~S]" ret substr_cnt last_b (string-downcase (narrow-string s grade)) b)
;        (cond
;          ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;          ; 【エンコードされた点字を出力バッファに追加する】
;          ; 英語グレード２のエンコード時で前置詞・不定詞・接続詞を連結
;          ; するモードで直前の部分文字列が前置詞・不定詞・接続詞であった
;          ; 場合は、以下を行う。
;          ; 当該の部分文字列が空白である場合は、前置詞・不定詞・接続詞が連なっている場合に備えて
;          ; チャンクの部分文字列カウンタを 1 に設定するのみで出力バッファには追加しない。（連結）
;          ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;          ((and (= grade 2)
;                 spPrepInf
;                 (null g2info)
;                 (= substr_cnt 2)
;                 (prep-inf-conj-p (narrow-string effective_last_s grade) t)
;                 (constant-char-stringp b #\Space))
;            (progn
;              (setf substr_cnt 1)
;;              (format t "~%~S -> ~S~%~S~%~S~%~S" i_substr_cnt substr_cnt buff b s)
;            )
;          )
;          ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;          ; 以下の場合は、出力バッファに半角空白と点字を追加する。（分割）
;          ; 直前が "by" を除く前置詞・不定詞・接続詞であり、当該の部分文字列（墨字）が "his "
;          ; （デコードでは、点字"08" は 墨字"by his " で 点字"0 8" は 墨字"was his " 
;          ; 　と処理するため、ここでは、"by his " のエンコード結果 "08" の分割は控える。）
;          ; または
;          ; 直前が前置詞・不定詞・接続詞であり、当該の部分文字列が句読点などである。
;          ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;          ((and (= grade 2)
;                 spPrepInf
;                 (null g2info)
;                 (or (and (= substr_cnt 1)
;                          last_b
;                          (string/= last_b "0") ; "by"
;                          (prep-inf-conj-p last_b nil)
;                          (string= hankakuStr "his "))
;                     (and (= substr_cnt 0)
;                          last_b
;                          (prep-inf-conj-p last_b nil)
;                          (punctuation-p hankakuStr b))))
;            (setf ret (concatenate 'string ret _blank_s_ b)))
;          ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;          ; その他の場合は、出力バッファに追加する。
;          ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;          (t (setf ret (concatenate 'string ret b))))
;;(format t "~%[~S][~S][~S]" (and (punctuation-p s b)) s b)
;          )
;      ;
;      ; 【デコードされた墨字を出力バッファに追加する】
;      (cond
;        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;        ; 英語グレード２のデコード時　で前置詞・不定詞・接続詞を分割するモードで
;        ; 当該の部分文字列（墨字）が前置詞・不定詞・接続詞である場合は、以下を
;        ; 行う。（分割）
;        ; 1.出力バッファに墨字と半角空白（※）を追加する。
;        ; 2.前置詞・不定詞・接続詞が連なっている場合に備えてチャンク
;        ;   の部分文字列カウンタを 0 に設定する。
;        ; （※全角空白でないのは、直後の処理や linePostProcessInDecoding にて
;        ;    半角空白の削除の便宜を図っている。）
;        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;        ((and (= grade 2)
;              spPrepInf
;              (null g2info)
;              (= substr_cnt 1)
;              (prep-inf-conj-p s t))
;          (progn
;            (setf ret (concatenate 'string ret s _blank_s_))
;            (progn
;              (setf substr_cnt 0)
;;              (format t "~%~S -> ~S~%~S~%~S~%~S" i_substr_cnt substr_cnt buff b s)
;            )
;          )
;        )
;        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;        ; 英語グレード２の場合で、前置詞・不定詞・接続詞を分割する場合
;        ; 当該の部分文字列（点字）が句読点などであり、直前の有効な部分文字列が
;        ; 前置詞・不定詞・接続詞であった場合は、直前のステップで付与された
;        ; 出力バッファの末端の半角空白（※）を削除後に墨字を追加する。（連結）
;        ; （※全角空白でないのは、直前の処理や linePostProcessInDecoding にて
;        ;    半角空白の追加／削除の便宜を図っている。）
;        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;        ((and (= grade 2)
;              spPrepInf
;              (null g2info)
;              (punctuation-p s b)
;              (prep-inf-conj-p effective_last_s t)
;              (string= (subseq ret (1- (length ret))) _blank_s_))
;          (progn
;            (setf ret (concatenate 'string (subseq ret 0 (1- (length ret))) s))))
;        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;        ; その他の場合は、出力バッファに追加する。
;        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;        (t (setf ret (concatenate 'string ret s)))))
;    (values ret substr_cnt)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 inhibited-convine-order-p
;; 【機能　】 
;; 【入力　】 wlst      : ワードリスト
;;            encode     : t の場合 token を墨字として処理、nil の場合 token
;;                         を点字として処理する。
;; 【出力　】 墨字または点字の文字列
;; 【例外　】 なし
;; 【使用例】 (inhibited-convine-order-p "for")
;;            → (|for| |a|)
;;            (inhibited-convine-order-p "for" "the")
;;            → (|for| |the|)
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun inhibited-convine-order-p (lastWord &optional (nextWord nil))
;  (if lastWord
;    (if nextWord
;      (find (list (intern lastWord) (intern nextWord)) *inhibit-convine-list* :test #'equal)
;      (find-if #'(lambda (x) (equal (intern lastWord) (car x))) *inhibit-convine-list*))
;  nil))

;; 後続の連結を禁止する。(カレントが空白の場合に適用)
;(defmacro inhibited-convine-order-p (m_lastWord &optional (m_nextWord nil))
;  `(if ,m_lastWord
;    (if ,m_nextWord
;      (find (list (intern ,m_lastWord) (intern ,m_nextWord)) *inhibit-convine-list* :test #'equal)
;      (find-if #'(lambda (x) (equal (intern ,m_lastWord) (car x))) *inhibit-convine-list*))
;  nil))

;(defun inhibited-ocAbbrWord-order-p (lastWord curText nextWord nextNextWord)
;  (and lastWord
;       (string= curText _blank_s_)
;       nextWord
;       (or
;         ; and /for/with 以外の場合は、禁則されていない語順のみ連結する。
;         (inhibited-convine-order-p (nth _idxText_ lastWord) (nth _idxText_ nextWord))
;         ; and /for/with の場合は、分割・連結必須語順("for a", "for the")などが連結対象。
;         (and (prefer-divide-p (nth _idxText_ lastWord))
;              (not (and (prefer-divide-p (nth _idxText_ lastWord) (nth _idxText_ nextWord))
;                        (convine-terminate-p nextNextWord)))))))

;連結禁則点字セットリスト(and /for/with以外)
;(defconstant *inhibit-convine-list*
;  (list
;    ; his の直後には半角空白が連なっている。
;    (list (intern "of") (intern "his "))
;    (list (intern "with") (intern "his "))
;    (list (intern "to") (intern "his "))
;    (list (intern "of") (intern "it"))
;  )
;)

; 後続を変換せず連結する。(カレントが空白の場合に適用)
;(defmacro inhibited-lwAbbrWord-convert-order-p (m_lastWord &optional (m_nextWord nil))
;  `(if ,m_lastWord
;    (if ,m_nextWord
;      (find (list (intern ,m_lastWord) (intern ,m_nextWord)) *inhibit-convert-list* :test #'equal)
;      (find-if #'(lambda (x) (equal (intern ,m_lastWord) (car x))) *inhibit-convert-list*))
;  nil))

;後続を変換せず連結する点字セットリスト
;(defconstant *inhibit-convert-list*
;  (list
;    (list (intern "to") (intern "be"))
;    (list (intern "to") (intern "in"))
;    ; his の直後には半角空白が連なっている。
;    (list (intern "to") (intern "his "))
;    (list (intern "into") (intern "his "))
;    (list (intern "by") (intern "his "))))

;(defun wordList2String (wlst encode)
;  (let (ret (lastWord nil))
;    (if encode
;      ; エンコード
;      (let ((brailleList nil) leader brl txt (nthItem 0)
;           (after-prep-inf-conj nil) (force-raw-next nil) (leadedByCapital nil) (followedByQuote nil))
;        (dolist (w wlst)
;          ; 大文字符などのリーダーがあった場合は、再起呼び出しで事前処理する。
;          (if (nth _idxLeaderList_ w)
;            (setf leader (wordList2String (nth _idxLeaderList_ w) encode))
;            (setf leader nil))
;          ; 通常のワードリスト処理
;          (setf brl (nth _idxBraille_ w))
;          (setf txt (nth _idxText_ w))
;          (if (null lastWord)
;            ; 冒頭のトークン
;            (setf brailleList (append brailleList (list leader brl)))
;            (let (nextWord nextNextWord inhibitedOrder followedByInhibited)
;              (setf nextWord (car (nthcdr (1+ nthItem) wlst)))
;              (setf nextNextWord (car (nthcdr (+ nthItem 2) wlst)))
;              ; 各種フラグのセット
;              ; 連結禁止語順フラグのセット
;              (setf inhibitedOrder (inhibited-ocAbbrWord-order-p lastWord txt nextWord nextNextWord))
;              ; 連結禁止語フラグのセット
;              (setf followedByInhibited (inhibited-convine-next-p lastWord txt nextWord))
;              ; 連結禁止リーダーフラグのセット
;              (setf followedByQuote (followed-by-quote-p txt nextWord))
;              ; 大文字符フラグのセット
;              (setf leadedByCapital (led-by-capital-p w))
;              ;
;              (cond
;                ; 連結時、後続の変換が禁則されている場合は変換しない。
;                (force-raw-next
;                  (progn
;                    (setf brailleList (append brailleList (list leader (string-upcase txt))))
;                    (setf force-raw-next nil)))
;                ; 前置詞・不定詞・接続詞に続く空白は原則的に出力しない（連結）。
;                ; 【例外】 禁則された語順の場合は連結しない。
;                ; 【例外】 後続の点字の冒頭が句読の場合は連結しない。 
;                ;         ここでは punctuation-p は使えないので、_punctuation-list_
;                ;         の car を直接検索する。
;                ((and after-prep-inf-conj
;                      (string= brl _blank_s_)
;                      (not inhibitedOrder)
;                      (not followedByInhibited)
;                      (not followedByQuote))
;                  (setf force-raw-next
;                    (and lastWord
;                         nextWord
;;                         (force-raw-p (nth _idxText_ lastWord))
;                         (inhibited-lwAbbrWord-convert-order-p (nth _idxText_ lastWord) (nth _idxText_ nextWord)))))
;                (t (progn
;                     ; eg. 大文字符の直後に his(8) が来ると `(,8) と競合してしまうので、無変換とする。
;                     (if leadedByCapital
;                       (let ((aPair (raw-capital-follower-p brl)))
;                         (if aPair
;                           (setf brl (string (cadr aPair)))
;                           nil))
;                       nil)
;                     ; 連結禁止リーダーに連なった前置詞・不定詞・接続詞は変換しない。
;#|
;                     (if (and after-prep-inf-conj
;                              (string= brl _blank_s_)
;                              followedByQuote)
;                       (setf (car (last brailleList)) (string-upcase (nth _idxText_ lastWord)))
;                       nil)
;|#
;                    ; 連結する。
;                     (setf brailleList (append brailleList (list leader brl)))
;                    ; *inhibit-convine-list* にあるものが検出された際は、
;                    ; after-prep-inf-conj をリセットし、連結に備える。
;                     (if (and after-prep-inf-conj
;                              (string= brl _blank_s_)
;                              inhibitedOrder)
;                       (setf after-prep-inf-conj nil)
;                       nil))))
;;                  (format t "~%+++ after-prep-inf-conj:~S, text:~S, braille:~S, ~S, ~S" after-prep-inf-conj txt brl lastWord nextWord)
;            ))
;          ; 空白以外の場合、連結フラグを評価する。
;          ; "by" を除いて原則的には連続した前置詞・不定詞・接続詞があっても連結しない。
;          (if (string/= brl _blank_s_)
;            (cond
;              ; 評価の対象は、冒頭の部分文字列。(cf.encodeBrailleChunk)
;              ((= (nth _idxWordNumber_ w) 1)
;                (progn
;                  ; 原則的には連続した前置詞・不定詞・接続詞を連結対象にはしない。
;                  ; 【例外】"by"
;                  (setf after-prep-inf-conj
;                      (and (or (null after-prep-inf-conj) (string= txt "by"))
;;                      (and (null after-prep-inf-conj)
;                           (us_prep-inf-conj-p txt nil t)))))
;              (t (setf after-prep-inf-conj nil)))
;            nil)
;          (setf lastWord w)
;          (incf nthItem))
;        (setf ret (join-string brailleList "")))
;      ; デコード
;      (let ((textList nil) leader txt brl)
;        (dolist (w wlst)
;          ; 大文字符などのリーダーがあった場合は、再起呼び出しで事前処理する。
;          (if (nth _idxLeaderList_ w)
;            (setf leader (wordList2String (nth _idxLeaderList_ w) encode))
;            (setf leader nil))
;          ; 通常のワードリスト処理
;          (setf txt (nth _idxText_ w))
;          (setf brl (nth _idxBraille_ w))
;          (if (null lastWord)
;            ; 冒頭のトークン
;            (setf textList (append textList (list leader txt)))
;            ; 事前が前置詞・不定詞・接続詞の場合は、原則的に空白を追加する。（分割）
;            ; 【例外】後続が句読や空白や#（ナンバーサイン）の場合は分割しない。
;            ;        ここでは punctuation-p でなければならない。
;            (if (and (us_prep-inf-conj-p (nth _idxText_ lastWord) nil t)
;                     (string/= txt _blank_w_)
;                     (string/= txt _numeralSign_s_)
;                     (not (punctuation-p txt brl))
;                     (or (= (nth _idxWordNumber_ w) 2) (= (nth _idxWordNumber_ w) 1) (= (nth _idxWordNumber_ w) 0))
;                     (or
;                       ; and/for/of/with 以外の場合は、無条件で分割する。
;                       (not (prefer-divide-p (nth _idxText_ lastWord)))
;                       ; and/for/of/with の場合は、分割・連結必須語順("for a", "for the")などが分割対象。
;                       (prefer-divide-p (nth _idxText_ lastWord) txt)))
;              (setf textList (append textList (list _blank_s_ leader txt)))
;              (setf textList (append textList (list leader txt)))))
;          (setf lastWord w))
;        (setf ret (narrow-string (join-string textList "") *grade*))))))

;(defmacro force-raw-p (m_str)
;  `(and (not (null ,m_str))
;        (find (intern ,m_str) *force-raw-list*)))

;(defun inhibited-ocAbbrWord-order-p (lastWord curText nextWord nextNextWord)
;  (and lastWord
;       (string= curText _blank_s_)
;       nextWord
;       ; and/for/of/with の場合は、分割・連結必須語順("for a", "for the")などが連結対象。
;       (and (prefer-divide-p (nth _idxText_ lastWord))
;            (not (and (prefer-divide-p (nth _idxText_ lastWord) (nth _idxText_ nextWord))
;                      (convine-terminate-p nextNextWord))))))

; 後続の分割を強制する。
;(defmacro prefer-divide-p (m_lastWord &optional (m_nextWord nil))
;  `(if ,m_lastWord
;    (if ,m_nextWord
;      (find (list (intern ,m_lastWord) (intern ,m_nextWord)) *prefer-divide-list* :test #'equal)
;      (find-if #'(lambda (x) (equal (intern ,m_lastWord) (car x))) *prefer-divide-list*))
;  nil))

;分割必須点字セットリスト(and/for/of/with用)
;(defconstant *prefer-divide-list*
;  (list
;    (list (intern "and") (intern "a"))
;    (list (intern "and") (intern "the"))
;    (list (intern "and") (intern "it"))
;    (list (intern "and") (intern "with"))
;    (list (intern "for") (intern "a"))
;    (list (intern "for") (intern "the"))
;    (list (intern "for") (intern "it"))
;    (list (intern "of") (intern "a"))
;    (list (intern "of") (intern "the"))
;    (list (intern "of") (intern "it"))
;    (list (intern "with") (intern "a"))
;    (list (intern "with") (intern "the"))
;    (list (intern "with") (intern "it"))
;  )
;)

;;-------------------------------------------------------------------------------
;; 大文字符に続く後続を強制的に変換するペア。
;(defmacro raw-capital-follower-p (m_Brl)
;  `(if ,m_Brl
;      (find-if #'(lambda (x) (equal (intern ,m_Brl) (car x))) *force-raw-comma-follower-list*)
;    nil))

;;カンマの後続の変換を禁則する点字セットリスト
;; eg. ",his" は ,8 でなく ,HIS にして ` との競合を避ける。
;(defconstant *force-raw-comma-follower-list*
;  (list
;;    (list (intern "8 ") (intern "HIS "))
;  )
;)

;; テスト中
;(defun led-by-capital-p (curWord)
;  (and (nth _idxLeaderList_ curWord)
;       (string= (nth _idxText_ (first (nth _idxLeaderList_ curWord))) _comma_s_)))

;; 後続の冒頭が文章記号であるので連結を禁止する。（by は例外）
;(defun inhibited-convine-next-p (lastWord curText nextWord)
;  (and lastWord
;       nextWord
;       (string= curText _blank_s_)
;       (string/= (nth _idxText_ lastWord) "by")
;       (or
;         (string= (subseq (nth _idxBraille_ nextWord) 0 1) _dblQuote_s_)
;         (string= (subseq (nth _idxText_ nextWord) 0 1) _hyphen_)
;         (string= (subseq (nth _idxBraille_ nextWord) 0 1) _hyphen_))))

;; 後続がクォーテーションであるので連結を禁止する。
;(defun followed-by-quote-p (curText nextWord)
;  (and nextWord
;       (string= curText _blank_s_)
;       (nth _idxLeaderList_ nextWord)
;       (or
;         (string= (nth _idxText_ (first (nth _idxLeaderList_ nextWord))) _dblQuote_s_)
;         (string= (nth _idxText_ (first (nth _idxLeaderList_ nextWord))) _snglQuote_s_))))

;(defconstant *force-raw-list*
;  (list
;;    (intern "into")
;    (intern "to")
;    (intern "be")
;    (intern "by")))

;(defun search-string (mark str beg &optional (lastOne nil))
;  (let ((ret nil) (strlen (length str)) (marklen (length mark)))
;    (if (>= strlen marklen)
;      (do '(base beg (1+ base))
;        ((or (>= base strlen) ret) nil)
;        (let ((startindex1 base) (endindex1 (+ base marklen)))
;          (if (and (<= endindex1 strlen) (string= mark str :start2 startindex1 :end2 endindex1))
;            ; 部分文字列が見つかった。
;            (if (null lastOne)
;              (setf ret base)
;              (let ((startindex2 startindex1) (endindex2 endindex1))
;                ; 部分文字列が連結されている場合は、最後の部分文字列のインデクスを返す。
;                (do '(disp 1 (1+ disp))
;                  ((or (>= startindex2 strlen) ret) nil)
;                  (incf startindex2)
;                  (incf endindex2)
;                  (if (or (> endindex2 strlen)
;                          (null (string= mark str :start2 startindex2 :end2 endindex2)))
;                    (setf ret (1- startindex2))
;                    nil))))
;            nil)))
;      nil)
;;(let (a)
;;(setf a (search-string2 mark str beg lastOne))
;;(if (not (equal ret a))
;;  (format t "~%~S, ~S, ~S, ~S, ~S, ~S" mark str beg lastOne ret a)
;;  nil))
;    ret))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 power
;; 【機能　】 ベキ乗を求める
;; 【入力　】 x : 基数
;;            n : ベキ乗の回数
;; 【出力　】 数値
;; 【例外　】 なし
;; 【使用例】 (power 2 16) → 65536
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun power (x n)
;   (if (zerop n)
;     1
;     (if (= n 1)
;       x
;       (* x (power x (1- n))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 stripTail
;; 【機能　】 文字列の末端から連続した文字を削除した結果を返す。
;; 【入力　】 s : 文字列
;;          chr : 文字
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (stripTail "abcd    " " ") → "abcd"
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun stripTail (s chr)
;  (if (> (length s) 0)
;    (let ((ret s) rev i)
;      (setf rev (reverse s))
;      (setf i (search-string (string chr) rev 0 t))
;      (if (and i (>= i 0) (constant-char-stringp (subseq rev 0 i) chr))
;        (setf ret (reverse (subseq rev (1+ i))))
;        nil)
;      ret)
;    s))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 explode-delims
;; 【機能　】 文字列が全て指定した区切り文字列であれば分割し、文字列のリストを
;;            生成する。
;; 【入力　】 str   : 文字列
;;            delim : 区切り文字列
;; 【出力　】 文字列のリスト
;; 【例外　】 なし
;; 【使用例】 (explode-delims "    " #\Space) → (" " " " " " " ")
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun explode-delims (m_str m_delim)
;  (if (= (count-if #'(lambda (x) (string= x m_delim)) m_str) (length m_str))
;    (explode-string m_str (list m_delim))
;    (list m_str)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 constant-char-stringp
;; 【機能　】 文字列が、全て指定した文字で構成されているか否かを返す。
;; 【入力　】 str : 文字列
;;            chr : 文字
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (constant-char-stringp "        " #\Space) → t
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun constant-char-stringp (m_str m_chr)
;  (= (count-if #'(lambda (x) (string= x (string m_chr))) m_str) (length m_str)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 digit-stringp
;; 【機能　】 文字列が、全て指定した数字で構成されているか否かを返す。（全角も可）
;; 【入力　】 str : 文字列
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (digit-stringp "0123") → t
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun digit-stringp (m_str)
;  (and (>= (length m_str) 1) (= (count-if #'(lambda (x) (digit-char-p x)) m_str) (length m_str))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 getMaxItemLength
;; 【機能　】 それぞれの言語の連想配列から墨字・点字の最大長を取得する。
;; 【入力　】 なし
;; 【出力　】 なし
;; 【例外　】 なし
;; 【使用例】 (getMaxItemLength) → nil
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun getMaxItemLength ()
;  (let (lst sumiLen brlLen (i 0))
;    (setf *maxItemLengthList* nil)
;    (dolist (xx *langList*)
;      (if xx
;        (progn
;          (setf lst (mapcar #'(lambda (x) (length (string (car x)))) xx))
;          (setf sumiLen (eval (cons 'max lst)))
;          (setf lst (mapcar #'(lambda (x) (braille-bytes (logand (cdr x) _AllClearBits_))) xx))
;          (setf brlLen (eval (cons 'max lst)))
;          (pushnew (list (intern (nth i *langNameList*)) sumiLen brlLen) *maxItemLengthList*))
;        nil)
;      (incf i))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 setUkDicMaxLength
;; 【機能　】 英語グレード２辞書メンバーの最大長を設定する。
;; 【入力　】 なし
;; 【出力　】 なし
;; 【例外　】 なし
;; 【使用例】 (setUkDicMaxLength)
;;           → t
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun setUkDicMaxLength ()
;  (setf *maxDicBrailleLength*
;    (progn
;      (let (lst)
;        (setf lst (mapcar #'(lambda(x) (length (string (nth _dic_symbol_index_ x)))) *uk_grade2_dec_dict*))
;        (eval (cons 'max lst)))))
;  (setf *maxDicSumijiLength*
;    (progn
;      (let (lst)
;        (setf lst (mapcar #'(lambda(x) (length (string (nth _dic_symbol_index_ x)))) *uk_grade2_enc_dict*))
;        (eval (cons 'max lst)))))
;  nil)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 setUsDicMaxLength
;; 【機能　】 英語グレード２辞書メンバーの最大長を設定する。
;; 【入力　】 なし
;; 【出力　】 なし
;; 【例外　】 なし
;; 【使用例】 (setUsDicMaxLength)
;;           → t
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun setUsDicMaxLength ()
;  (setf *maxDicBrailleLength*
;    (progn
;      (let (lst)
;        (setf lst (mapcar #'(lambda(x) (length (string (nth _dic_symbol_index_ x)))) *us_grade2_dec_dict*))
;        (eval (cons 'max lst)))))
;  (setf *maxDicSumijiLength*
;    (progn
;      (let (lst)
;        (setf lst (mapcar #'(lambda(x) (length (string (nth _dic_symbol_index_ x)))) *us_grade2_enc_dict*))
;        (eval (cons 'max lst)))))
;  nil)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 narrow-string
;; 【機能　】 文字列中の半角文字を全角文字に変換する。
;; 【入力　】 str : 文字列
;; 【出力　】 文字列
;; 【例外　】 なし
;; 【使用例】 (narrow-string "Ａｂｃ０１２あいう" 1) → "Abc012あいう"
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun narrow-string (str grade &optional (downing nil))
;  (let ((ret nil) (length (length str)) wide_alphas)
;    (if (= grade 1)
;      (setf wide_alphas _wide_alphas1_)
;      (setf wide_alphas _wide_alphas2_))
;    (do ((i 0 (1+ i)))
;      ((= i length) nil)
;      (let (ix s)
;        (setf s (string (char str i)))
;        (setf ix (search s _wide_digits_))
;        (if (and (numberp ix) (>= ix 0))
;          (setf ret (concatenate 'string ret (format nil "~S" ix)))
;          (progn
;            (setf ix (search s wide_alphas))
;            (if (and (numberp ix) (>= ix 0))
;              (setf ret
;                (concatenate 'string ret
;                  (coerce
;                    (list
;                      (coerce (char _narrow_alphas_ ix) 'character)
;                    ) 'string)))
;              (setf ret (concatenate 'string ret s)))))))
;    (if downing (string-downcase ret) ret)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 wide-string
;; 【機能　】 文字列中の半角文字を全角文字に変換する。
;; 【入力　】 str : 文字列
;; 【出力　】 文字列
;; 【例外　】 なし
;; 【使用例】 (wide-string "Abc012あいう" 1) → "Ａｂｃ０１２あいう"
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun wide-string (str grade)
;  (let ((ret nil) (length (length str)) wide_alphas)
;    (if (= grade 1)
;      (setf wide_alphas _wide_alphas1_)
;      (setf wide_alphas _wide_alphas2_))
;    (do ((i 0 (1+ i)))
;      ((= i length) nil)
;      (let (ix s)
;        (setf s (string (char str i)))
;        (setf ix (search s _narrow_digits_))
;        (if (and (numberp ix) (>= ix 0))
;          (setf ret (concatenate 'string ret (coerce (list (coerce (char _wide_digits_ ix) 'character)) 'string)))
;          (progn
;            (setf ix (search s _narrow_alphas_))
;            (if (and (numberp ix) (>= ix 0))
;              (setf ret
;                (concatenate 'string ret
;                  (coerce
;                    (list
;                      (coerce (char wide_alphas ix) 'character)
;                    ) 'string)))
;              (setf ret (concatenate 'string ret s)))))))
;    ret))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 brailleDecoder
;; 【機能　】 表示用の言語連想配列を使用して点字文字列を数値化する。
;;            その数値が変換先の言語連想配列の cdr部 と合致するコンスセルの car部 を
;;            文字列化して墨字を生成する。
;; 【入力　】 str  : 点字文字列
;;            dlst : 変換先の言語連想配列
;; 【出力　】 墨字文字列
;; 【例外　】 なし
;; 【使用例】 (brailleDecoder "A" *kana*) → ア
;;          (brailleDecoder "I3" *pronunciation*) → íː
;;          (brailleDecoder "B" *us_grade2* t) → but
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;(defun brailleDecoder (str dlist
;         &optional (wholeWord nil) (initWord nil) (midWord nil) (finWord nil))
;  (let ((ret nil) (capital nil) (val 0) cc)
;;(format t "~S~%" (length str))
;    ; 【デコード前処理】
;    (do ((i 0 (1+ i)))
;      ((= i (length str)) nil)
;      (progn
;        (setf cc (assoc (intern (subseq str i (1+ i))) *represent*))
;        (if (and (consp cc) (numberp (cdr cc)))
;          (setf val (+ val (* (cdr cc) (nth (- (length str) (1+ i)) _power_of_64_))))
;          nil)))
;    ; 【デコード主処理】
;    (if (or wholeWord initWord midWord finWord)
;      (let (vList)
;        (setf vList (list val))
;        ; 英語グレード２の initWord-Word は cdr の MSB-1 が立っているので適合させる。
;        (if initWord (setf vList (push (logior val _initialWordMask_) vList)) nil)
;        ; 英語グレード２の midWord-Word は cdr の MSB-2 が立っているので適合させる。
;        (if midWord (setf vList (push (logior val _medialWordMask_) vList)) nil)
;        ; 英語グレード２の finWord-Word は cdr の MSB-3 が立っているので適合させる。
;        (if finWord (setf vList (push (logior val _finalWordMask_) vList)) nil)
;        ; 英語グレード２の Whole-Word は cdr の MSB が立っているので適合させる。
;        (if wholeWord
;          (progn
;            (setf vList (push (logior val _wholeWordMask_) vList))
;            ; 英語グレード２の大文字符は cdr の MSB-4 が立っているので適合させる。（現在は、his[,8] のみ）
;            (setf vList (push (logior val _capitalMask_ _wholeWordMask_) vList)))
;          nil)
;        (dolist (v vList)
;;          (format t "~%[~S]~S, #b~48,'0b" a ret v)
;          (if (null ret)
;            (let (s)
;              (setf s (car (rassoc v dlist)))
;              (if s
;                (progn
;                  (setf ret (string s))
;                  (setf capital (> (logand v _capitalMask_) 0)))
;                nil))
;            nil)
;;          (incf a)
;        ))
;      (let (s)
;        (setf s (car (rassoc val dlist)))
;        (if s
;          (setf ret (string s))
;          nil)))
;    (values (substitute-string ret "|" "") capital)))
