// $Id: BRbWriteNode.cpp,v 1.17 2002/11/06 09:56:48 yuya Exp $

#include "BRbWriteNode.h"

////////////////////////////////////////////////////////////////////////////////

BRbWriteNode::BRbWriteNode(bool debug)
	: BRbNode(), m_debug(debug)
{
}

BRbWriteNode::~BRbWriteNode()
{
}

////////////////////////////////////////////////////////////////////////////////

void
BRbWriteNode::write(NODE* node, BRbOutputBuffer& buffer)
{
	m_debug.printf("writing header.\n");
	write_header();
	m_debug.printf("wrote header.\n");

	m_debug.printf("writing node.\n");
	write_node(node);
	m_debug.printf("wrote node.\n");

	m_strtbl.dump(m_stbuf);

	buffer.write_buffer(m_headbuf);
	buffer.write_buffer(m_stbuf);
	buffer.write_buffer(m_ndbuf);
}

////////////////////////////////////////////////////////////////////////////////

void
BRbWriteNode::write_header()
{
	BRbHeader header;
	header.signature     = BRB_FILE_SIGNATURE;
	header.file_version  = BRB_FILE_VERSION;
	header.ruby_major    = RUBY_VERSION[0] - '0';
	header.ruby_minor    = RUBY_VERSION[2] - '0';
	header.ruby_revision = RUBY_VERSION[4] - '0';

	m_headbuf.write_bytes(&header, sizeof(header));
}

void
BRbWriteNode::write_node(NODE* node)
{
	if ( !node ) {
		//throw "node is null pointer!!";
		write_byte(0xFF);
		return;
	}

 	byte type = (byte)nd_type(node);

	m_debug.printf("W:%02X:%s\n", type, BRbNode::get_node_name(type));

	write_byte(type);

	switch (type) {
		case NODE_ALIAS:
		{
			write_id(node->nd_new);
			write_id(node->nd_old);
			break;
		}
		case NODE_VALIAS:
		{
			write_id(node->nd_new);
			write_id(node->nd_old);
			break;
		}
		case NODE_AND:
		{
			write_node(node->nd_1st);
			write_node(node->nd_2nd);
			break;
		}
		case NODE_OR:
		{
			write_node(node->nd_1st);
			write_node(node->nd_2nd);
			break;
		}
		case NODE_ARGS:
		{
			write_word(node->nd_cnt);
			write_word(node->nd_rest);
			write_node_opt(node->nd_opt);
			break;
		}
	//	case NODE_ARGSCAT:
	//		break;  
	//	case NODE_ARGSPUSH:
	//		break;  
		// člKv
		// m[h\悭ׂ邱
		case NODE_ARRAY:
		{
			/*
			write_word(node->nd_alen);
			NODE* cur = node;
			while ( cur ) {
				write_node(cur->nd_head);
				cur = cur->nd_next;
			}
			*/
			/*
			int len = node->nd_alen;
			write_word(node->nd_alen);
			write_node(node->nd_head);
			write_node_opt(node->nd_next);
			*/
			NODE* cur = 0;
			int n = 0;
			for ( cur = node; cur; cur = cur->nd_next ) {
				n++;
			}
			write_word(n);
			write_word(node->nd_alen);
			for ( cur = node; cur; cur = cur->nd_next ) {
				write_node(cur->nd_head);
			}
			break;
		}
	//	case NODE_ATTRSET:
	//		break;
		case NODE_BACK_REF:
		{
			write_byte(node->nd_nth);
			break;
		}
		case NODE_BEGIN:
		{
			write_node(node->nd_body);
			break;
		}
		case NODE_BLOCK:
		{
			/*
			NodeVector list;
			NodeVector::iterator ite;

			NODE* cur = node;
			while ( cur->nd_next ) {
				list.push_back(cur->nd_head);
				cur = cur->nd_next;
			}
			list.push_back(cur->nd_head);
			
			write_word(list.size());

			for ( ite = list.begin(); ite != list.end(); ite++ ) {
				write_node(*ite);
			}
			*/

			NODE* cur;
			int n = 1;
			for ( cur = node; cur->nd_next; cur = cur->nd_next) {
				n++;
			}

			write_word(n);

			for ( cur = node; cur->nd_next; cur = cur->nd_next) {
				write_node(cur->nd_head);
			}
			write_node(cur->nd_head);

			break;
		}
		// SEGV - unexpected block argument
		case NODE_BLOCK_ARG:
		{
			write_id(node->nd_vid);
			break;
		}
		// SEGV - unexpected block argument
		case NODE_BLOCK_PASS:
		{
			write_node(node->nd_body);
			break;
		}
	//	case NODE_BMETHOD:
	//		break;
		case NODE_BREAK:
		{
			break;
		}
		case NODE_CALL:
		{
			write_id(node->nd_mid);
			write_node(node->nd_recv);
			write_node_opt(node->nd_args);
			break;
		}
		case NODE_FCALL:
		{
			write_id(node->nd_mid);
			write_node_opt(node->nd_args);
			break;
		}
		case NODE_CASE:
		{
			write_node(node->nd_head);
			write_node(node->nd_body);
			break;
		}
		case NODE_WHEN:
		{
			write_node(node->nd_head);
			write_node(node->nd_body);
			write_node_opt(node->nd_next);
			break;
		}
		case NODE_CDECL:
		{
			write_id(node->nd_vid);
			write_node(node->nd_value);
			break;
		}
		case NODE_CLASS:
		{
			write_id(node->nd_cname);
			write_node_opt(node->nd_super);
			write_node_opt(node->nd_body);
			break;
		}
		case NODE_COLON2:
		{
			write_id(node->nd_mid);
			write_node(node->nd_head);
			break;
		}
		case NODE_COLON3:
		{
			write_id(node->nd_mid);
			break;
		}
		case NODE_CONST:
		{
			write_id(node->nd_vid);
			break;
		}
	//	case NODE_CREF:
	//		break;
		// SEGV - unexpected local variable
		case NODE_CVAR:
		{
			write_id(node->nd_vid);
			break;
		}
	//	case NODE_CVAR2:
	//		break;
		case NODE_CVDECL:
		{
			write_id(node->nd_vid);
			write_node(node->nd_value);
			break;
		}
		// SEGV - unexpected local variable @ eval.c:NODE_LVAR
		// ruby_scope->loval_vars L[
		case NODE_CVASGN:
		{
			write_id(node->nd_vid);
			write_node(node->nd_value);
			break;
		}
	//	case NODE_DASGN:
	//		break;
		case NODE_DASGN_CURR:
		{
			write_id(node->nd_vid);
			write_node_opt(node->nd_value);
			break;
		}
		case NODE_DEFINED:
		{
			write_node(node->nd_head);
			break;
		}
		case NODE_DEFN:
		{
			write_id(node->nd_mid);
			write_node(node->nd_defn);
			break;
		}
		case NODE_DEFS:
		{
			write_id(node->nd_mid);
			write_node(node->nd_recv);
			write_node(node->nd_defn);
			break;
		}
	//	case NODE_DMETHOD:
	//		break;
		case NODE_DVAR:
		{
			write_id(node->nd_vid);
			break;
		}
		case NODE_DSTR:
		{
			write_literal(node->nd_lit);
			write_node_opt(node->nd_next);
			break;
		}
	//	case NODE_DXSTR:
	//	case NODE_DREGX:
	//	case NODE_DREGX_ONCE:
	//		break;
		case NODE_ENSURE:
		{
			write_node(node->nd_head);
			write_node(node->nd_ensr);
			break;
		}
		case NODE_FALSE:
		{
			break;
		}
		case NODE_DOT2:
		{
			write_node(node->nd_beg);
			write_node(node->nd_end);
			break;
		}
		case NODE_DOT3:
		{
			write_node(node->nd_beg);
			write_node(node->nd_end);
			break;
		}
		case NODE_FLIP2:
		{
			write_node(node->nd_beg);
			write_node(node->nd_end);
			break;
		}
		case NODE_FLIP3:
		{
			write_node(node->nd_beg);
			write_node(node->nd_end);
			break;
		}
	//	case NODE_FBODY:
	//		break;
		case NODE_FOR:
		{
			write_node(node->nd_iter);
			write_node(node->nd_body);
			write_node(node->nd_var);
			break;
		}
		case NODE_ITER:
		{
			write_node(node->nd_iter);
			write_node(node->nd_body);
			write_node_opt(node->nd_var);
			break;
		}
		case NODE_GASGN:
		{
			write_id(node->nd_entry->id);
			write_node(node->nd_value);
			break;
		}
		case NODE_GVAR:
		{
			write_id(node->nd_entry->id);
			break;
		}
		case NODE_HASH:
		{
			write_node_opt(node->nd_head);
			break;
		}
		// SEGV - unexpected local variable
		case NODE_IASGN:
		{
			write_id(node->nd_vid);
			write_node(node->nd_value);
			break;
		}
		case NODE_IF:
		{
			write_node(node->nd_cond);
			write_node_opt(node->nd_body);
			write_node_opt(node->nd_else);
			break;
		}
		// SEGV - unexpected local variable
		case NODE_IVAR:
		{
			write_id(node->nd_vid);
			break;
		}
		case NODE_LASGN:
		{
			write_id(node->nd_vid);
			write_node_opt(node->nd_value);
			break;
		}
		// ʂs
		case NODE_EVSTR:
		{
			write_literal(node->nd_lit);
			break;
		}
		case NODE_XSTR:
		{
			write_literal(node->nd_lit);
			break;
		}
		case NODE_LIT:
		{
			write_literal(node->nd_lit);
			break;
		}
		case NODE_LVAR:
		{
			write_id(node->nd_vid);
			write_word(node->nd_cnt);
			break;
		}
		// ɑdsȂ
		// foo, bar, baz = 3, 2, 1 #=> [1, nil, nil]
		case NODE_MASGN:
		{
			write_node(node->nd_head);
			write_node(node->nd_value);
			write_node_opt(node->nd_args);
			break;
		}
		case NODE_MATCH:
		{
			write_node(node->nd_head);
			break;
		}
		case NODE_MATCH2:
		{
			write_node(node->nd_recv);
			write_node(node->nd_value);
			break;
		}
		case NODE_MATCH3:
		{
			write_node(node->nd_recv);
			write_node(node->nd_value);
			break;
		}
	//	case NODE_METHOD:
	//		break;
		case NODE_MODULE:
		{
			write_id(node->nd_cname);
			write_node_opt(node->nd_body->nd_next);
			break;
		}
		case NODE_NEWLINE:
		{
			write_word(node->nd_nth);
			write_node(node->nd_next);
			break;
		}
		case NODE_NEXT:
		{
			break;
		}
		case NODE_NIL:
		{
			break;
		}
		case NODE_NOT:
		{
			write_node(node->nd_body);
			break;
		}
		case NODE_NTH_REF:
		{
			write_byte(node->nd_nth);
			break;
		}
	//	case NODE_OP_ASGN1:
	//		break;
	//	case NODE_OP_ASGN2:
	//		break;
	//	case NODE_OP_ASGN_AND:
	//	case NODE_OP_ASGN_OR:
	//		break;
	//	case NODE_OPT_N:
	//		break;
		case NODE_POSTEXE:
		{
			break;
		}
		case NODE_REDO:
		{
			break;
		}
		case NODE_RESCUE:
		{
			write_node(node->nd_head);
			write_node(node->nd_resq);
			write_node_opt(node->nd_else);
			break;
		}
		case NODE_RESBODY:
		{
			write_node(node->nd_body);
			write_node_opt(node->nd_args);
			write_node_opt(node->nd_head);
			break;
		}
		case NODE_RESTARGS:
		{
			write_node(node->nd_head);
			break;
		}
		// ʂs
		case NODE_RETRY:
		{
			break;
		}
		case NODE_RETURN:
		{
			write_node_opt(node->nd_stts);
			break;
		}
		case NODE_SCLASS:
		{
			write_node(node->nd_recv);
			write_node(node->nd_body->nd_next);
			break;
		}
		case NODE_SCOPE:
		{
			write_node_opt(node->nd_next);
			break;
		}
		case NODE_SELF:
		{
			break;
		}
		case NODE_STR:
		{
			write_string(node->nd_lit);
			break;    
		}
		// SEGV - unexpected local variable
		case NODE_SUPER:
		{
			write_node(node->nd_args);
			break;
		}
		case NODE_TRUE:
		{
			break;
		}
		case NODE_UNDEF:
		{
			write_id(node->nd_mid);
			break;
		}
		case NODE_UNTIL:
		{
			write_node(node->nd_cond);
			write_node(node->nd_body);
			write_byte(node->nd_state);
			break;
		}
		case NODE_WHILE:
		{
			write_node(node->nd_cond);
			write_node(node->nd_body);
			write_byte(node->nd_state);
			break;
		}
		case NODE_VCALL:
		{
			write_id(node->nd_mid);
			break;
		}
		case NODE_YIELD:
		{
			write_node_opt(node->nd_stts);
			break;
		}
		case NODE_ZARRAY:
		{
			break;
		}
		case NODE_ZSUPER:
		{
			break;
		}
		default:
		{
			puts("Unknown Node Type!!");
			break;
		}
	}
}

inline void
BRbWriteNode::write_node_opt(NODE* node)
{
	if ( node ) {
		write_byte(1);
		write_node(node);
	} else {
		write_byte(0);
	}
}

inline void
BRbWriteNode::write_byte(byte value)
{
	m_ndbuf.write_byte(value);
}

inline void
BRbWriteNode::write_word(word value)
{
	m_ndbuf.write_word(value);
}

inline void
BRbWriteNode::write_dword(dword value)
{
	m_ndbuf.write_dword(value);
}

inline void
BRbWriteNode::write_cstr(const char* str)
{
	m_ndbuf.write_word(m_strtbl.set(str));
}

inline void
BRbWriteNode::write_cstr(const char* str, word len)
{
	m_ndbuf.write_word(m_strtbl.set(str, len));
}

inline void
BRbWriteNode::write_string(VALUE str)
{
	write_cstr(RSTRING(str)->ptr, (word)RSTRING(str)->len);
}

inline void
BRbWriteNode::write_id(ID id)
{
	write_cstr(::rb_id2name(id));
}

inline void
BRbWriteNode::write_literal(VALUE obj)
{
	if ( FIXNUM_P(obj) ) {
		write_byte(0);
		write_dword(obj);
	} else if ( SYMBOL_P(obj) ) {
		write_byte(1);
		write_id(SYM2ID(obj));
	} else if ( TYPE(obj) == T_STRING ) {
		write_byte(2);
		write_string(obj);
	} else {
		write_byte(3);
		write_object(obj);
	}
}

inline void
BRbWriteNode::write_object(VALUE obj)
{
	static VALUE mod = ::rb_eval_string("::Marshal");
	static ID    mid = ::rb_intern("dump");
	write_string(::rb_funcall(mod, mid, 1, obj));
}

////////////////////////////////////////////////////////////////////////////////
