
require 'testcase'

class NodeTest < BRbTestCase

  def self.def_test(name)
    self.module_eval(<<-EOS)
      def test_#{name}
#BRb.debug = true if "hash" == "#{name}"
        assert(verify('#{name}'))
      end
    EOS
  end

  [
    'alias',
    'and',
    'array',
    'args',
    'begin',
    'block',
    'break', # unexpected local variable assignment
    'case',
    'class',
    'const',
    'cvar',
    'cvdecl',
    'defn',
    'dot2',
    'dot3',
    'false',
    'fcall',
    'for', # unexpected local variable assignment
    'gasgn',
    'gvar',
    'hash', # unexpected local variable assignment
    'iasgn', # unexpected local variable assignment
    'if',
    'iter',
    'ivar', # unexpected local variable assignment
    'lit',
    'match2',
    'module',
    'newline',
    'nil',
    'not',
    'nth_ref',
    'or',
    'rescue',
#    'self', # diff
    'str',
    'true',
    'valias',
  ].each { |name|
    def_test(name)
  }

end
