// $Id: BRbDebug.h,v 1.3 2002/11/07 07:36:46 yuya Exp $

#if !defined(_BRbDebug_h_)
#define _BRbDebug_h_

////////////////////////////////////////////////////////////////////////////////

#include "BRbBase.h"
#include <stdarg.h>

////////////////////////////////////////////////////////////////////////////////

class BRbDebug
{

public:
	BRbDebug(bool debug, FILE* out = stderr);
	virtual ~BRbDebug();

public:
	virtual void printf(const char* format, ...);
	virtual void dumpnode(NODE* node);

protected:
	virtual void p(const char *fmt, ...);
	virtual void lp(int level, const char* fmt, ...);
	virtual void nl();
	virtual char* tail(char* s, char* e);
	virtual void dump_literal(long lit, int level);
	virtual void dump_node(NODE* n, int level);

protected:
	bool  m_debug;
	FILE* m_out;

};

////////////////////////////////////////////////////////////////////////////////

#endif

////////////////////////////////////////////////////////////////////////////////
