// $Id: BRbDebug.h,v 1.7 2002/12/13 08:39:45 yuya Exp $

#ifndef _BRbDebug_h_
#define _BRbDebug_h_

////////////////////////////////////////////////////////////////////////////////

#include "BRbBase.h"

////////////////////////////////////////////////////////////////////////////////

typedef void (*BRB_EXCEPTION)(const char*);

////////////////////////////////////////////////////////////////////////////////

class BRbDebug
{

public:
	BRbDebug(bool debug, FILE* out = stderr, BRB_EXCEPTION excpfunc = NULL);
	virtual ~BRbDebug();

public:
	virtual void printf(const char* format, ...);
	virtual void dumpnode(NODE* node);
	virtual void raise(const char* fmt, ...);

protected:
	virtual void p(const char *fmt, ...);
	virtual void lp(int level, const char* fmt, ...);
	virtual void lpdump(int level, char *name, NODE *node);
	virtual void nl();
	virtual char* tail(char* s, char* e);
	virtual void dump_literal(long lit, int level);
	virtual void dump_node(NODE* n, int level);

protected:
	bool  m_debug;
	FILE* m_out;
	BRB_EXCEPTION m_excpfunc;

};

////////////////////////////////////////////////////////////////////////////////

#endif

////////////////////////////////////////////////////////////////////////////////
