
#==============================================================================#
# test/testcase.rb
# $Id: testcase.rb,v 1.8 2002/12/20 03:45:23 yuya Exp $
#==============================================================================#

require 'test/unit'
require 'test/unit/testcase'
require 'bruby'

#==============================================================================#

class BRbTestCase < Test::Unit::TestCase

  def mkname(name, dir = '')
     rbfile  = dir + 'src/' + name + '.rb'
     rbbfile = dir + 'bin/' + name + '.rbb'
     return [rbfile, rbbfile]
  end

  def verify(rbfile, rbbfile)
     if BRb.verifyfile(rbfile)
       File.open(rbbfile, 'wb') { |file|
         file.print(BRb.dumpfile(rbfile))
       }

       return true
     else
       return false
     end
  end

  def exec_ruby(file)
    return `ruby #{file}`
  end

  def exec_bruby(file)
    return `ruby ../bin/bruby.rb -e #{file}`
  end

end

#==============================================================================#
#==============================================================================#
