// $Id: BRbLevelCounter.cpp,v 1.2 2002/12/21 03:53:13 yuya Exp $

#include "BRbLevelCounter.h"

////////////////////////////////////////////////////////////////////////////////

dword BRbLevelCounter::m_level = 0;
byte  BRbLevelCounter::m_stack[512] = {0};

////////////////////////////////////////////////////////////////////////////////

BRbLevelCounter::BRbLevelCounter(byte type)
{
	m_stack[m_level] = type;
	m_level++;
}

BRbLevelCounter::~BRbLevelCounter()
{
	m_level--;
	m_stack[m_level] = 0;
}

////////////////////////////////////////////////////////////////////////////////

inline dword
BRbLevelCounter::level() const
{
	return m_level;
}

inline byte
BRbLevelCounter::stack(int level) const
{
	return m_stack[m_level + level - 1];
}

void
BRbLevelCounter::print_stack() const {
	::fprintf(stderr, "stack[ ");

	for ( int i = 0; i < m_level; i++ ) {
		::fprintf(stderr, "%02X ", m_stack[i]);
	}

	::fprintf(stderr, "]\n");
}

////////////////////////////////////////////////////////////////////////////////
