// $Id: BRb.cpp,v 1.30 2003/01/14 06:43:44 yuya Exp $

#include "BRb.h"

////////////////////////////////////////////////////////////////////////////////

extern "C" {
	VALUE rb_eval(VALUE, NODE*); // eval.c
}

////////////////////////////////////////////////////////////////////////////////

VALUE
BRb::readfile(VALUE filename)
{
	static ID id_open  = ::rb_intern("open");
	static ID id_read  = ::rb_intern("read");
	static ID id_close = ::rb_intern("close");

	VALUE mode = ::rb_str_new2("rb");
	VALUE file = ::rb_funcall(rb_cFile, id_open, 2, filename, mode);
	VALUE text = ::rb_funcall(file, id_read, 0);
	::rb_funcall(file, id_close, 0);

	return text;
}

#ifdef BRB_WRITER

NODE*
BRb::compile(VALUE code, VALUE filename)
{
	static ID id_basename = ::rb_intern("basename");

	const char* basename = RSTRING(::rb_funcall(rb_cFile, id_basename, 1, filename))->ptr;
	const int   lineno   = 1;

	return ::rb_compile_string(basename, code, lineno);
}

VALUE
BRb::dumpnode(NODE* node, bool debugflag, BRB_EXCEPTION excpfunc)
{
	BRbDebug        debug(debugflag, stderr, excpfunc);
	BRbOutputBuffer buffer;
	BRbWriteNode    writer(debug);

	writer.write(node, buffer);

	return buffer.to_string();
}

VALUE
BRb::dumpcode(VALUE code, VALUE filename, bool debugflag, BRB_EXCEPTION excpfunc)
{
	NODE* node = compile(code, filename);
	VALUE bin  = dumpnode(node, debugflag, excpfunc);

	return bin;
}

VALUE
BRb::dumpfile(VALUE filename, bool debugflag, BRB_EXCEPTION excpfunc)
{
	VALUE code = readfile(filename);
	VALUE bin  = dumpcode(code, filename, debugflag, excpfunc);

	return bin;
}

#endif

#ifdef BRB_READER

NODE*
BRb::loadnode(VALUE code, bool debugflag, BRB_EXCEPTION excpfunc)
{
	BRbDebug       debug(debugflag, stderr, excpfunc);
	BRbInputBuffer buffer(code);
	BRbReadNode    reader(buffer, debug);

	char* sourcefile = ruby_sourcefile;
	ruby_sourcefile = ::rb_source_filename("bruby");
 
	NODE* node = reader.read();

	ruby_sourcefile = sourcefile;

	return node;
}

VALUE
BRb::loadcode(VALUE code, bool debugflag, BRB_EXCEPTION excpfunc)
{
	NODE* node = loadnode(code, debugflag, excpfunc);
	VALUE self = ::rb_eval_string("self");
	return ::rb_eval(self, node);
}

VALUE
BRb::loadfile(VALUE filename, bool debugflag, BRB_EXCEPTION excpfunc)
{
	VALUE code = readfile(filename);
	return loadcode(code, debugflag, excpfunc);
}

#endif

#if defined(BRB_WRITER) && defined(BRB_READER)

bool
BRb::verifycode(VALUE code, VALUE filename, bool debugflag, BRB_EXCEPTION excpfunc)
{
	VALUE bin1 = dumpcode(code, filename, debugflag, excpfunc);
	NODE* node = loadnode(bin1, debugflag, excpfunc);
	VALUE bin2 = dumpnode(node, debugflag, excpfunc);

	return (::rb_funcall(bin1, ::rb_intern("=="), 1, bin2) ? true : false);
}

bool
BRb::verifyfile(VALUE filename, bool debugflag, BRB_EXCEPTION excpfunc)
{
	VALUE code = readfile(filename);
	return (verifycode(code, filename, debugflag, excpfunc) ? true : false);
}

#endif

////////////////////////////////////////////////////////////////////////////////
