// $Id: BRb.h,v 1.4 2003/01/14 05:47:16 yuya Exp $

#ifndef _BRb_h_
#define _BRb_h_

////////////////////////////////////////////////////////////////////////////////

#include "BRbBase.h"
#include "BRbInputBuffer.h"
#include "BRbOutputBuffer.h"
#include "BRbReadNode.h"
#include "BRbWriteNode.h"
#include "BRbDebug.h"

////////////////////////////////////////////////////////////////////////////////

class BRb
{

private:
	BRb();
	virtual ~BRb();

public:
	static VALUE readfile(VALUE filename);
#ifdef BRB_WRITER
	static NODE* compile(VALUE code, VALUE filename);
	static VALUE dumpnode(NODE* node, bool debugflag, BRB_EXCEPTION excpfunc);
	static VALUE dumpcode(VALUE code, VALUE filename, bool debugflag, BRB_EXCEPTION excpfunc);
	static VALUE dumpfile(VALUE filename, bool debugflag, BRB_EXCEPTION excpfunc);
#endif
#ifdef BRB_READER
	static NODE* loadnode(VALUE code, bool debugflag, BRB_EXCEPTION excpfunc);
	static VALUE loadcode(VALUE code, bool debugflag, BRB_EXCEPTION excpfunc);
	static VALUE loadfile(VALUE filename, bool debugflag, BRB_EXCEPTION excpfunc);
#endif
#if defined(BRB_WRITER) && defined(BRB_READER)
	static bool verifycode(VALUE code, VALUE filename, bool debugflag, BRB_EXCEPTION excpfunc);
	static bool verifyfile(VALUE filename, bool debugflag, BRB_EXCEPTION excpfunc);
#endif

};

////////////////////////////////////////////////////////////////////////////////

#endif

////////////////////////////////////////////////////////////////////////////////
