// $Id: bruby.cpp,v 1.4 2003/01/14 05:47:16 yuya Exp $

#include "BRbBase.h"
#include "BRb.h"

////////////////////////////////////////////////////////////////////////////////

static void bruby_exception(const char* msg);

#ifdef BRB_WRITER
static VALUE rb_brb_s_dump(VALUE obj, VALUE source, VALUE filename);
static VALUE rb_brb_s_dumpfile(VALUE obj, VALUE filename);
#endif
#ifdef BRB_READER
static VALUE rb_brb_s_load(VALUE obj, VALUE bytecode);
static VALUE rb_brb_s_loadfile(VALUE obj, VALUE filename);
#endif
#if defined(BRB_WRITER) && defined(BRB_READER)
static VALUE rb_brb_s_verify(VALUE obj, VALUE source, VALUE filename);
static VALUE rb_brb_s_verifyfile(VALUE obj, VALUE filename);
#endif
static VALUE rb_brb_s_debug_get(VALUE obj);
static VALUE rb_brb_s_debug_set(VALUE obj, VALUE debug);

////////////////////////////////////////////////////////////////////////////////

extern "C" void Init_bruby();

////////////////////////////////////////////////////////////////////////////////

static bool  g_debug          = false;
static VALUE rb_mBRb          = 0;
static VALUE rb_mBRbException = 0;

////////////////////////////////////////////////////////////////////////////////

static void
bruby_exception(const char* msg)
{
	::rb_raise(rb_mBRbException, msg);
}

////////////////////////////////////////////////////////////////////////////////

#ifdef BRB_WRITER

static VALUE
rb_brb_s_dump(VALUE obj, VALUE source, VALUE filename)
{
	Check_Type(source,   T_STRING);
	Check_Type(filename, T_STRING);
	return BRb::dumpcode(source, filename, g_debug, bruby_exception);
}

static VALUE
rb_brb_s_dumpfile(VALUE obj, VALUE filename)
{
	Check_Type(filename, T_STRING);
	return BRb::dumpfile(filename, g_debug, bruby_exception);
}

#endif

#ifdef BRB_READER

static VALUE
rb_brb_s_load(VALUE obj, VALUE bytecode)
{
	Check_Type(bytecode, T_STRING);
	return BRb::loadcode(bytecode, g_debug, bruby_exception);
}

static VALUE
rb_brb_s_loadfile(VALUE obj, VALUE filename)
{
	Check_Type(filename, T_STRING);
	return BRb::loadfile(filename, g_debug, bruby_exception);
}

#endif

#if defined(BRB_WRITER) && defined(BRB_READER)

static VALUE
rb_brb_s_verify(VALUE obj, VALUE source, VALUE filename)
{
	Check_Type(source,   T_STRING);
	Check_Type(filename, T_STRING);
	return (BRb::verifycode(source, filename, g_debug, bruby_exception) ? Qtrue : Qfalse);
}

static VALUE
rb_brb_s_verifyfile(VALUE obj, VALUE filename)
{
	Check_Type(filename, T_STRING);
	return (BRb::verifyfile(filename, g_debug, bruby_exception) ? Qtrue : Qfalse);
}

#endif

static VALUE
rb_brb_s_debug_get(VALUE obj)
{
	return (g_debug ? Qtrue : Qfalse);
}

static VALUE
rb_brb_s_debug_set(VALUE obj, VALUE debug)
{
	g_debug = (RTEST(debug) ? true : false);
	return debug;
}

////////////////////////////////////////////////////////////////////////////////

extern "C" void
Init_bruby()
{
	rb_mBRb = ::rb_define_module("BRb");
#ifdef BRB_WRITER
	::rb_define_singleton_method(rb_mBRb, "dump",       (VALUE(*)(...))rb_brb_s_dump,       2);
	::rb_define_singleton_method(rb_mBRb, "dumpfile",   (VALUE(*)(...))rb_brb_s_dumpfile,   1);
#endif
#ifdef BRB_READER
	::rb_define_singleton_method(rb_mBRb, "load",       (VALUE(*)(...))rb_brb_s_load,       1);
	::rb_define_singleton_method(rb_mBRb, "loadfile",   (VALUE(*)(...))rb_brb_s_loadfile,   1);
#endif
#if defined(BRB_WRITER) && defined(BRB_READER)
	::rb_define_singleton_method(rb_mBRb, "verify",     (VALUE(*)(...))rb_brb_s_verify,     2);
	::rb_define_singleton_method(rb_mBRb, "verifyfile", (VALUE(*)(...))rb_brb_s_verifyfile, 1);
#endif
	::rb_define_singleton_method(rb_mBRb, "debug",      (VALUE(*)(...))rb_brb_s_debug_get,  0);
	::rb_define_singleton_method(rb_mBRb, "debug=",     (VALUE(*)(...))rb_brb_s_debug_set,  1);

	rb_mBRbException = ::rb_define_class("BRbException", rb_eException);
}

////////////////////////////////////////////////////////////////////////////////
