// $Id: BRbException.cpp,v 1.4 2002/12/03 03:19:42 yuya Exp $

#include "BRbException.h"
#include <stdarg.h>

////////////////////////////////////////////////////////////////////////////////

BRbException::BRbException(const char *msg, ...)
{
	va_list ap;
	va_start(ap, msg);

#ifdef WIN32
	const int size = 512;
#else
	const int size = ::vsprintf(NULL, msg, ap);
#endif

	m_msg = new char[size + 1];
	m_msg[size] = '\0';

	::vsprintf(m_msg, msg, ap);

	va_end(ap);
}

BRbException::~BRbException()
{
	delete[] m_msg;
}

////////////////////////////////////////////////////////////////////////////////

const char*
BRbException::message() const
{
	return m_msg;
}

////////////////////////////////////////////////////////////////////////////////
