/* -*-tab-width:8;indent-tabs-mode:t;c-file-style:"bsd"-*- */
/*
 * rndis: USB Remote ndis driver for Windows Mobile
 *
 * Copyright 2007 Hashi,Hiroaki <hashiz@meridiani.jp>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE. KEEP THE LOVE.
 *
 * $Id: if_rndisreg.h 351 2007-08-30 17:35:16Z hashiz $
 */

/*
 * rndis message
 */

#define RNDIS_MSG_COMPLETION	htole32(0x80000000)

struct rndis_msg_header {
	u_int32_t	type;
	u_int32_t	length;
} __attribute__ ((packed));
#define RNDIS_MSG_HEADER_SIZE (sizeof(struct rndis_msg_header))

#define RNDIS_MSG_PACKET	htole32(0x00000001)
struct rndis_msg_packet_oob {
	u_int32_t	size;
	u_int32_t	type;
	u_int32_t	inf_offset;
} __attribute__ ((packed));

struct rndis_msg_packet_perpkt {
	u_int32_t	size;
	u_int32_t	type;
	u_int32_t	inf_offset;
} __attribute__ ((packed));

struct rndis_msg_packet_data {
	u_int32_t	offset;
	u_int32_t	length;
	u_int32_t	oob_offset;
	u_int32_t	oob_length;
	u_int32_t	oob_nums;
	u_int32_t	pkt_inf_offset;
	u_int32_t	pkt_inf_length;
	u_int32_t	vc_handle;
	u_int32_t	reserve;
} __attribute__ ((packed));
#define RNDIS_MSG_PACKET_SIZE	(RNDIS_MSG_HEADER_SIZE+sizeof(struct rndis_msg_packet_data))

struct rndis_msg_packet {
	struct rndis_msg_header	h;
	struct rndis_msg_packet_data	d;
} __attribute__ ((packed));

#define RNDIS_MSG_INITIALIZE	htole32(0x00000002)
struct rndis_msg_initialize {
	u_int32_t	req_id;
	u_int32_t	ver_major;
	u_int32_t	ver_minor;
	u_int32_t	max_xfer_size;
} __attribute__ ((packed));
#define RNDIS_MSG_INITIALIZE_SIZE (RNDIS_MSG_HEADER_SIZE+sizeof(struct rndis_msg_initialize))

#define RNDIS_MSG_INITIALIZE_CMPLT	(RNDIS_MSG_INITIALIZE|RNDIS_MSG_COMPLETION)
struct rndis_msg_initialize_cmplt {
	u_int32_t	req_id;
	u_int32_t	status;
	u_int32_t	ver_major;
	u_int32_t	ver_minor;
	u_int32_t	device_flags;
	u_int32_t	medium;
	u_int32_t	max_pkts_per_msg;
	u_int32_t	max_xfer_size;
	u_int32_t	pkt_align_factor;
	u_int32_t	af_list_offset;
	u_int32_t	af_list_size;
} __attribute__ ((packed));
#define RNDIS_MSG_INITIALIZE_CMPLT_SIZE (RNDIS_MSG_HEADER_SIZE+sizeof(struct rndis_msg_initialize_cmplt))

#define RNDIS_MSG_HALT		htole32(0x00000003)
struct rndis_msg_halt {
	u_int32_t	req_id;
} __attribute__ ((packed));
#define RNDIS_MSG_HALT_SIZE (RNDIS_MSG_HEADER_SIZE+sizeof(struct rndis_msg_halt))

#define RNDIS_MSG_QUERY		htole32(0x00000004)
struct rndis_msg_query {
	u_int32_t	req_id;
	u_int32_t	oid;
	u_int32_t	inf_buf_length;
	u_int32_t	inf_buf_offset;
	u_int32_t	device_vc_handle;
} __attribute__ ((packed));
#define RNDIS_MSG_QUERY_SIZE (RNDIS_MSG_HEADER_SIZE+sizeof(struct rndis_msg_query))

#define RNDIS_MSG_QUERY_CMPLT	(RNDIS_MSG_QUERY|RNDIS_MSG_COMPLETION)
struct rndis_msg_query_cmplt {
	u_int32_t	req_id;
	u_int32_t	status;
	u_int32_t	inf_buf_length;
	u_int32_t	inf_buf_offset;
} __attribute__ ((packed));
#define RNDIS_MSG_QUERY_CMPLT_SIZE (RNDIS_MSG_HEADER_SIZE+sizeof(struct rndis_msg_query_cmplt))

#define RNDIS_MSG_SET		htole32(0x00000005)
struct rndis_msg_set {
	u_int32_t	req_id;
	u_int32_t	oid;
	u_int32_t	inf_buf_length;
	u_int32_t	inf_buf_offset;
	u_int32_t	device_vc_handel;
} __attribute__ ((packed));
#define RNDIS_MSG_SET_SIZE (RNDIS_MSG_HEADER_SIZE+sizeof(struct rndis_msg_set))

#define RNDIS_MSG_SET_CMPLT		(RNDIS_MSG_SET|RNDIS_MSG_COMPLETION)
struct rndis_msg_set_cmplt {
	u_int32_t	req_id;
	u_int32_t	status;
} __attribute__ ((packed));
#define RNDIS_MSG_SET_CMPLT_SIZE (RNDIS_MSG_HEADER_SIZE+sizeof(struct rndis_msg_set_cmplt))

#define RNDIS_MSG_RESET		htole32(0x00000006)
struct rndis_msg_reset {
	u_int32_t	reserve;
} __attribute__ ((packed));
#define RNDIS_MSG_RESET_SIZE (RNDIS_MSG_HEADER_SIZE+sizeof(struct rndis_msg_reset))

#define RNDIS_MSG_RESET_CMPLT	(RNDIS_MSG_RESET|RNDIS_MSG_COMPLETION)
struct rndis_msg_reset_cmplt {
	u_int32_t	status;
	u_int32_t	addressing_reset;
} __attribute__ ((packed));
#define RNDIS_MSG_RESET_CMPLT_SIZE (RNDIS_MSG_HEADER_SIZE+sizeof(struct rndis_msg_reset_cmplt))

#define RNDIS_MSG_INDICATE_STATUS	htole32(0x00000007)
struct rndis_msg_indicate_status {
	u_int32_t	status;
	u_int32_t	status_buffer_length;
	u_int32_t	status_buffer_offset;
	u_int32_t	diag_status;
	u_int32_t	err_offset;
	u_int32_t	message;
} __attribute__ ((packed));
#define RNDIS_MSG_INDICATE_STATUS_SIZE (RNDIS_MSG_HEADER_SIZE+sizeof(struct rndis_msg_indicate_status))

#define RNDIS_MSG_KEEPALIVE	htole32(0x00000008)
struct rndis_msg_keepalive {
	u_int32_t	req_id;
} __attribute__ ((packed));
#define RNDIS_MSG_KEEPALIVE_SIZE (RNDIS_MSG_HEADER_SIZE+sizeof(struct rndis_msg_keepalive))

#define RNDIS_MSG_KEEPALIVE_CMPLT	(RNDIS_MSG_KEEPALIVE|RNDIS_MSG_COMPLETION)
struct rndis_msg_keepalive_cmplt {
	u_int32_t	req_id;
	u_int32_t	status;
} __attribute__ ((packed));
#define RNDIS_MSG_KEEPALIVE_CMPLT_SIZE (RNDIS_MSG_HEADER_SIZE+sizeof(struct rndis_msg_keepalive_cmplt))

union rndis_msg_snd_u {
	struct rndis_msg_initialize	initialize;
	struct rndis_msg_halt		halt;
	struct rndis_msg_query		query;
	struct rndis_msg_set		set;
	struct rndis_msg_reset		reset;
	struct rndis_msg_keepalive	keepalive;
	struct rndis_msg_keepalive_cmplt	keepalive_cmplt;
} __attribute__ ((packed));

union rndis_msg_rcv_u {
	struct rndis_msg_initialize_cmplt	initialize_cmplt;
	struct rndis_msg_query_cmplt		query_cmplt;
	struct rndis_msg_set_cmplt		set_cmplt;
	struct rndis_msg_reset_cmplt		reset_cmplt;
	struct rndis_msg_indicate_status	indicate_status;
	struct rndis_msg_keepalive		keepalive;
	struct rndis_msg_keepalive_cmplt	keepalive_cmplt;
} __attribute__ ((packed));

struct rndis_msg_snd {
	struct rndis_msg_header	h;
	union  rndis_msg_snd_u	s;
} __attribute__ ((packed));

struct rndis_msg_rcv {
	struct rndis_msg_header	h;
	union  rndis_msg_rcv_u	r;
} __attribute__ ((packed));
#define	RNDIS_MSG_BUFFER_SIZE		1025
	
/* rndis medium */
#define RNDIS_MEDIUM_802_3		htole32(0x00000000)
#define RNDIS_MEDIUM_802_5		htole32(0x00000001)
#define RNDIS_MEDIUM_FDDI		htole32(0x00000002)
#define RNDIS_MEDIUM_WAN		htole32(0x00000003)
#define RNDIS_MEDIUM_LOCALTALK		htole32(0x00000004)
#define RNDIS_MEDIUM_ARCNETRAW		htole32(0x00000006)
#define RNDIS_MEDIUM_ARCNET878_2	htole32(0x00000007)
#define RNDIS_MEDIUM_ATM		htole32(0x00000008)
#define RNDIS_MEDIUM_IRDA		htole32(0x0000000a)
#define RNDIS_MEDIUM_COWAN		htole32(0x0000000b)

/* rndis status for completion message */
#define RNDIS_STATUS_BUFFER_OVERFLOW	htole32(0x80000005)
#define RNDIS_STATUS_FAILURE		htole32(0xc0000001)
#define RNDIS_STATUS_INVALID_DATA	htole32(0xc0010015)
#define RNDIS_STATUS_MEDIA_CONNECT	htole32(0x4001000b)
#define RNDIS_STATUS_MEDIA_DISCONNECT	htole32(0x4001000c)
#define RNDIS_STATUS_NOT_SUPPORTED	htole32(0xc00000bb)
#define RNDIS_STATUS_PENDING		htole32(0x00000103)
#define RNDIS_STATUS_RESOURCES		htole32(0xc000009a)
#define RNDIS_STATUS_SUCCESS		htole32(0x00000000)

#define	RNDIS_MSG_TIMEOUT_MS	(5 * 1000)

#define RNDIS_TX_TIMEOUT	1000
#define RNDIS_TIMEOUT		10000

struct rndis_softc {
	/* Ethernet */
	struct ifnet		*sc_ifp;
	struct ifmedia		sc_ifmedia;

	/* USB */
	USBBASEDEVICE		sc_dev;		/* base device */
	usbd_device_handle	sc_udev;
	usb_callout_t		sc_ch_ctrl;
	usbd_interface_handle	sc_iface_data;
	usbd_interface_handle	sc_iface_ctrl;
	int			sc_epaddr_rx;	 /* packet rcv endpoint */
	usbd_pipe_handle	sc_pipe_rx;
	int			sc_epaddr_tx;	 /* packet snd endpoint */
	usbd_pipe_handle	sc_pipe_tx;
	/* transfer buffer */
	int			sc_rx_xfer_cnt;
	u_int32_t		sc_rx_remain;
#ifdef RNDIS_CHAINBUF
	struct ue_cdata		sc_cdata;
#else
	usbd_xfer_handle	sc_tx_xfer;
	u_char			*sc_tx_buf;
	int			sc_tx_buf_len;
	struct mbuf		*sc_tx_mbuf;
	usbd_xfer_handle	sc_rx_xfer;
	u_char			*sc_rx_buf;
	int			sc_rx_buf_len;
	struct mbuf		*sc_rx_mbuf;
#endif

	/* driver status */
	int			sc_attached;
	int			sc_dying;
	struct timeval		sc_rx_notice;
	int			sc_rxeof_errors;
	struct usb_qdat		sc_qdat;
	int			sc_link;
	u_int32_t		sc_flags;
	struct mtx		sc_mtx;
	int			sc_refcnt;
	int			sc_rx_errs;

	/* Remote NDIS */
	u_int32_t		sc_req_id;
	int			sc_max_pkts_per_msg;
	int			sc_max_tx_size;
	int			sc_max_rx_size;
	int			sc_pkt_align_bytes;
	u_int32_t		sc_ndis_filter;
};
