/*
 * blanco Framework
 * Copyright (C) 2004-2006 WATANABE Yoshinori
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.commons.sql.format;

/**
 * BlancoSqlFormatter: SQL`c[. SQL߂ꂽ[ɏ]`܂B
 * 
 * tH[}bg{邽߂ɂ́A͂SQLSQLƂđÓł邱ƂOƂȂ܂B
 * 
 * ̃NXSQL`̃[ɂẮALURLQƂB
 * http://homepage2.nifty.com/igat/igapyon/diary/2005/ig050613.html
 * 
 * ̃NX͊e탆[eBeB킦NXł.
 * 
 * @author WATANABE Yoshinori (a-san) : original version at 2005.07.04.
 * @author IGA Tosiki : marge into blanc Framework at 2005.07.04
 */
public class BlancoSqlUtil {
    /**
     * u. ꕶɕ̕ϊΏۂĂ悢B
     * 
     * @param argTargetString
     *            ΏۂƂȂ镶B
     * @param argFrom
     *            ϊO̕B(ex." <")
     * @param argTo
     *            ϊ̕B(ex."&lt;")
     * @return uꂽ̕B
     */
    public static String replace(final String argTargetString,
            final String argFrom, final String argTo) {
        String newStr = "";
        int lastpos = 0;

        for (;;) {
            final int pos = argTargetString.indexOf(argFrom, lastpos);
            if (pos == -1) {
                break;
            }

            newStr += argTargetString.substring(lastpos, pos);
            newStr += argTo;
            lastpos = pos + argFrom.length();
        }

        return newStr + argTargetString.substring(lastpos);
    }
}
