#!/bin/sh

function usage() {
echo "usage: trace.sh [start [lognum]|stop|show|add <symbol>|del <symbol>|list]"
}

if [ $# -eq 0 ]; then
usage 
exit 0;
fi

function evalparam() {
while [ $# -gt 0 ] ; do
eval $1
shift 1
done
}

SYSMAP=/lib/modules/$KVER/build/System.map
[ -f $SYSMAP ] || SYSMAP=/boot/System.map-`uname -r`
[ -f $SYSMAP ] || SYSMAP=/proc/kallsyms

function findsymbol() {
while [ $# -gt 0 ] ; do
ADDR=`printf "%x" $1`
_SYM_=`grep ^$ADDR $SYSMAP | cut -f3 -d\ `
echo $1 $2 $_SYM_
shift 2
done
}

case "$1" in
	start)
	OPT=
	[ "$2" ] && OPT="bsize=$2"
	/sbin/insmod trace_probe.ko $OPT
	;;
	stop)
	/sbin/rmmod trace_probe.ko
	;;
	show)
	cat /proc/tracelogs
	;;
	add)
	[ "$2" ] || (echo "Invalid argument" ;exit 0;)
	evalparam `./disym.sh $2 | tail -n 1 | cut -d\  -f 2,3`
	echo add $addr $size > /proc/traceprobes
	;;
	del)
	[ "$2" ] || (echo "Invalid argument" ;exit 0;)
	evalparam `./disym.sh $2 | tail -n 1 | cut -d\  -f 2,3`
	echo del $addr > /proc/traceprobes
	;;
	list)
	findsymbol `cat /proc/traceprobes`
	;;
	*)
	usage 
	exit 0;
	;;
esac
