/*****************************************************************************/
/* The development of this program is partly supported by IPA                */
/* (Information-Technology Promotion Agency, Japan).                         */
/*****************************************************************************/

/*****************************************************************************/
/*  avl_tree.h - AVL tree library header                                     */
/*  Copyright: Copyright (c) Hitachi, Ltd. 2005-2006                         */
/*             Authors: Yumiko Sugita (sugita@sdl.hitachi.co.jp),            */
/*                      Satoshi Fujiwara (sa-fuji@sdl.hitachi.co.jp)         */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either version 2 of the License, or        */
/*  (at your option) any later version.                                      */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA      */
/*****************************************************************************/

#ifndef __AVLTREE_H__
#define __AVLTREE_H__

typedef struct __node {
	void		*dt;
	struct __node	*left;
	struct __node	*right;
	struct __node	*parent;
	int		balance;
} node;

typedef int (*func_compare)(void *target, void *each);
typedef int (*func_each)(void *each, void *user_data);
/* meaning of the func_each return value is below
 *   1:  break
 *   0:  continue
 *   -1: error exit
 */
typedef void (*func_free)(void *each);
void* search_tree(void*, node*, func_compare);
node* insert_tree(void*, node*, func_compare);
node* delete_tree(void*, node*, func_compare, func_free);
int for_each_node(node*, func_each, void*);
void dump_tree(node*, func_each, void*);
void free_tree(node*, func_free);
long get_node_cnt(node*);

#endif
