/*****************************************************************************/
/* The development of this program is partly supported by IPA                */
/* (Information-Technology Promotion Agency, Japan).                         */
/*****************************************************************************/

/*****************************************************************************/
/*  bt_ar_parse.h - /proc/modules and /proc/PID/maps parse header            */
/*  Copyright: Copyright (c) Hitachi, Ltd. 2005-2006                         */
/*             Authors: Yumiko Sugita (sugita@sdl.hitachi.co.jp),            */
/*                      Satoshi Fujiwara (sa-fuji@sdl.hitachi.co.jp)         */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either version 2 of the License, or        */
/*  (at your option) any later version.                                      */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA      */
/*****************************************************************************/

#ifndef __BT_AR_PARSE_H__
#define __BT_AR_PARSE_H__

#include "bt.h"
#include "bfd_if.h"
#include <libgen.h>
#include <limits.h>

#define	ALL_PID			-1

struct addr_range {
	unsigned long		begin;
	unsigned long		end;
	struct addr_range	*next;
};

struct pid_range {
	pid_t			pid;
	struct addr_range	*range;
	struct pid_range	*next;
};

#define MAX_FIX_FROM_CACHE	1024
struct fix_from_cache {
	unsigned long		from;
	unsigned long		to;
	unsigned long		fixed_from;
	struct range_to_name	*r2n;
	struct path		*path;
	long			id;
	struct fix_from_cache	*next;
};

struct range_to_name {
	unsigned long		begin;
	unsigned long		end;
	unsigned long		offset;
	char			name[PATH_MAX];
	char			*dirname;
	char			*basename;

	struct bfd_if		bi;
	struct path		**pt;
	long			cnt;

	struct fix_from_cache	*fix_from_cache;
};

struct r2n_info {
	struct range_to_name	**all_r2n;
	int			r2n_max;
	int			from_is_next;
};

#define eprintf(...)	fprintf(stderr, __VA_ARGS__)
#ifdef DEBUG
#define dprintf(...)	do { if ((verbose)) printf(__VA_ARGS__) }
#define ddprintf(...)	do { if ((verbose) >=2 ) printf(__VA_ARGS__) }
#else
#define dprintf(...)
#define ddprintf(...)
#endif

int alloc_pid_range(pid_t);
void free_ranges(void);
char* range2ulongs(char*, unsigned long*, unsigned long*);
int add_range(pid_t, unsigned long, unsigned long);
int del_range(pid_t, unsigned long, unsigned long);
void dump_ranges(void);
struct pid_range *get_all_ranges(void);
struct addr_range *get_pid_addr_range(pid_t);
int is_addr_range_match(unsigned long, unsigned long, struct addr_range*);
int get_symbol_addr(struct r2n_info*, const char*, unsigned long*);
int get_symbol_addr_all(struct r2n_info*, const char*, unsigned long**);
int get_func_info(struct r2n_info*, unsigned long, unsigned long*,
		  struct range_to_name**);

int is_exists_maps(char*, char*);

#define PM_WITHOUT_PT	0
#define PM_WITH_PT	1
#define PM_SILENT 	0
#define PM_VERBOSE	1
int parse_modules(struct r2n_info*, char *dir, int with_pt, int verbose);
int parse_maps(struct r2n_info*, char *dir, char *fname,
	       int with_pt, int verbose);

#define	FROM_IS_NEXT_FNAME	"from_is_next"
int chk_from_is_next(char*);

void dump_r2n(struct r2n_info*);
void free_r2n(struct r2n_info*);
struct range_to_name* addr_to_r2n(struct r2n_info*, unsigned long);
int chk_fix_from_cache(struct r2n_info*, unsigned long*, unsigned long,
		       struct range_to_name**, struct path**, long*);

#endif /* __BT_AR_PARSE_H__ */
