/*****************************************************************************/
/* The development of this program is partly supported by IPA                */
/* (Information-Technology Promotion Agency, Japan).                         */
/*****************************************************************************/

/*****************************************************************************/
/*  bt_utils.h - utilities header                                            */
/*  Copyright: Copyright (c) Hitachi, Ltd. 2005-2006                         */
/*             Authors: Yumiko Sugita (sugita@sdl.hitachi.co.jp),            */
/*                      Satoshi Fujiwara (sa-fuji@sdl.hitachi.co.jp)         */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either version 2 of the License, or        */
/*  (at your option) any later version.                                      */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA      */
/*****************************************************************************/

#ifndef __BT_UTILS_H__
#define __BT_UTILS_H__

#include "bt.h"
#include <libgen.h>

int u_open(const char*, off_t*);
int u_close(int);
off_t u_lseek(int, off_t, int);
ssize_t u_read(int, void*, size_t);
ssize_t u_write(int, const void*, size_t);

typedef int (*t_func_each_bt_record)(struct bt_record*, off_t, void*);
int for_each_bt_record(int, off_t, t_func_each_bt_record, void*);
int for_each_block_record(int, off_t, off_t, t_func_each_bt_record, void*);

#endif /* __BT_UTILS_H__ */
