/*****************************************************************************/
/* The development of this program is partly supported by IPA                */
/* (Information-Technology Promotion Agency, Japan).                         */
/*****************************************************************************/

/*****************************************************************************/
/*  bt_hconv.h - coverage output to html converter header                    */
/*  Copyright: Copyright (c) Hitachi, Ltd. 2005-2007                         */
/*             Authors: Yumiko Sugita (sugita@sdl.hitachi.co.jp),            */
/*                      Satoshi Fujiwara (sa-fuji@sdl.hitachi.co.jp)         */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either version 2 of the License, or        */
/*  (at your option) any later version.                                      */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA      */
/*****************************************************************************/

#ifndef __BT_HCONV_H__
#define __BT_HCONV_H__

#define IS_SWITCH_JMP(p)	\
	((p)->type == BTYPE_JMP \
	 && (p)->jmp == UNKNOWN_BADDR && (p)->next_cnt < 0)

#define SET_FC_VALID(fc)	(fc)->invalid = 0
#define SET_FC_UT(fc)		(fc)->invalid = 1
#define SET_FC_NOT_CHECKED(fc)	(fc)->invalid = 2
#define IS_VALID_FC(fc)		((fc)->invalid == 0)
#define IS_UT_FC(fc)		((fc)->invalid == 1 && (fc)->cnt != 0)
#define IS_CHECKED_FC(fc)	(IS_VALID_FC(fc) || IS_UT_FC(fc))

struct func_chk {
	unsigned long	addr;
	unsigned long	cnt;
	int		invalid;
	node		*childs;
	unsigned long	excluded_tree_cnt;
	/* below members are used for caching valid path's information */
	long		i;
	unsigned long	end;
};

struct html_out_data {
	FILE	*in;
	FILE	*summary_out;
	FILE	*ftree_out;
	FILE	*cur_out;
	char	*srcdir;
	char	*outdir;
	char	*name;
	char	abs_path[PATH_MAX + 1];
	int	limit_by_funcs;
};

#define BCOV_TYPE_OK	0
#define BCOV_TYPE_HT	1
#define BCOV_TYPE_NT	2
#define BCOV_TYPE_UT	3
#define BCOV_TYPE_UN	4

#define get_percent(n_exec, n_total) \
	((n_total) == 0 ? (double)100.00 : (double)(n_exec) * 100 / (n_total))

typedef void (*func_do_one_bcov)(struct range_to_name *r2n,
				 struct html_out_data *dt,
				 int bcov_type, unsigned long base,
				 unsigned long branch, long b_cnt,
				 unsigned long fall, long f_cnt);
inline void do_one_branch_coverage(struct range_to_name *r2n,
				   struct html_out_data *dt, struct path *p,
				   func_do_one_bcov func);

int dir_chk_and_create(char *path, int err_on_exists);
int init_html_output(struct html_out_data*);
void out_summary_html_name(struct html_out_data*);

/* function tree */
void out_func_tree_html_start(struct html_out_data*, char *s_inc, char *s_exc);
void out_func_tree_html_each_enter(struct html_out_data *dt,
				   struct range_to_name *r2n,
				   struct func_chk *fc, int nest, int type,
				   int has_child);
void out_func_tree_html_each_exit(struct html_out_data *dt, int nest,
				  int has_child);
void out_func_tree_html_each_invalid(struct html_out_data *dt,
				     struct range_to_name *r2n,
				     struct func_chk *fc);
void out_func_tree_html_end(struct html_out_data*);

/* function coverage */
void out_summary_html_func(struct html_out_data *dt,
			   long n_func, long n_func_all);
void out_func_html_start(struct html_out_data*);
void out_func_html_each(struct html_out_data *dt, struct range_to_name *r2n,
			struct func_chk *fc);
void out_func_html_end(struct html_out_data*);

/* branch coverage */
void out_summary_html_branch(struct html_out_data *dt,
			     long n_br_ok, long n_br_uk,
			     long n_br_ht, long n_br_nt,
			     long n_br_all, long n_uk_all);
void out_branch_html_start(struct html_out_data*);
void out_branch_html_each(struct html_out_data *dt, struct range_to_name *r2n,
			  unsigned long base, unsigned long branch, long b_cnt,
			  unsigned long fall, long f_cnt);
void out_branch_html_end(struct html_out_data*);

/* state coverage */
void out_summary_html_state(struct html_out_data *dt, long n_ok, long n_states);
void out_state_html_start(struct html_out_data*);
void out_state_html_each(struct html_out_data *dt, struct range_to_name *r2n,
			 int is_exec, unsigned long);
#define out_state_html_end out_branch_html_end

int exit_html_output(struct html_out_data*, int limit_by_funcs);

#endif /*__BT_HCONV_H__*/

