/*
 * ide-io djprobe handler 
 * Copyright (c) 2005 Hitachi,Ltd.,
 * Created by Masami Hiramatsu<hiramatu@sdl.hitachi.co.jp>
 */
#include <linux/version.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/ide.h>
#include "djprobe.h"

static long addr=0; //start_request
module_param(addr, long, 0444);
static long size=0;
module_param(size, long, 0444);

#define CALLER(regs) (((unsigned long *)&regs->esp)[0])
#define ARG(n,regs) (((long *)&regs->esp)[n]) /*arg1: ARG(1,stadr)*/

static void probe_func(struct djprobe *djp, struct pt_regs *regs)
{
	struct request *req;
#ifdef CONFIG_REGPARM
	req = (struct request *)regs->ecx;
#else
	req = ARG(2, regs);
#endif
	printk("IDE I/O: req 0x%p, sector %lld+%ld\n", 
	       req, req->sector, req->nr_sectors);
	return ;
}

static struct djprobe djp;

static int install_probe(void) 
{
	int ret;
	if (addr == 0 || size < 5 || size > 16+5-1) {
		return -1;
	}
	djp.addr = (void*)addr;
	djp.size = size;
	djp.handler = probe_func;
	printk("probe install to %p, size %ld\n", (void*)addr, size);
	ret = register_djprobe(&djp);

	if (ret != 0) {
		printk("probe install error: %d\n",ret);
		return -1;
	}
	return 0;
}

static void uninstall_probe(void)
{
	if (djp.addr) {
		printk("uninstall from %p\n", (void*)addr);
		unregister_djprobe(&djp);
	}
}

module_init(install_probe);
module_exit(uninstall_probe);
MODULE_AUTHOR("M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>");
MODULE_LICENSE("GPL");

