<?php
include_once 'class.mailbody.discrete.php';
/**
 * multipart type data handling classes for mail body.
 *
 * This is a part of bytesmailer.
 * @package bytesmailer
 * @version $Id: class.mailbody.composite.php,v 1.1 2003/01/21 14:17:56 haruki Exp $
 * @author  Haruki Setoyama <haruki@planewave.org>
 */
/**
 * class for multipart mail content.
 *
 * @access public
 */
class mailBody_multipart extends mailBody_abstract {

    var $boundary;
    var $type = 'multipart';
    var $subtype = 'mixed';

    var $contents = array();

    var $_msg;
    /**
     * Constructor
     */
    function mailBody_multipart($msg=false){
        $this->boundary = md5(uniqid(time()));
        $this->_msg = $msg;
    }

    function &addPart(&$obj) {
        if(is_a($obj,'mailBody_abstract')){
            $num = count($this->contents);
            $this->contents[$num] =& $obj;
            return $this->contents[$num];
        }
        return false;
    }

    /**
     * set a subtype of the "multipart" Content-Type.
     *  mixed / alternative / parallel (/ digest)
     *  encoding -> 7bit, 8bit, binary only
     * @param sting $str
     */
    function setContentType($type, $subtype){
        $this->type = $type;
        $this->subtype = $subtype;
        return true;
    }

    // TODO: if this is not used, delete this.
    function setBoundary($str){
        $this->boundary = $str;
    }

    /////

    function getHeader(){
        if( count($this->contents) >1 ) {
            return  array(
                    'Content-Type' =>
                        sprintf("multipart/%s;%sboundary=\"%s\"",
                            $this->subtype, _BYTESMAILER_FWS, $this->boundary)
                    );
        }else{
            return array();
        }
    }

    function getBody(){
        $body = '';
        switch(count($this->contents)){

        case 0:
            return '';
        case 1:
            return $this->contents[0]->getAllMessage();

        default:
            if($this->_msg != false)
                $body .= 'This is a multi-part message in MIME format.'._BYTESMAILER_LE._BYTESMAILER_LE;
            //$body .= _BYTESMAILER_LE;
            foreach($this->contents as $obj){
                //$obj->setConfig($this->getConfig());
                $body .= '--'.$this->boundary._BYTESMAILER_LE;
                $body .= $obj->getAllMessage();
                $body .= _BYTESMAILER_LE;
            }
            $body .= '--'.$this->boundary.'--'._BYTESMAILER_LE;
            return $body;
        }
    }
}

class mailBody_html extends mailBody_multipart {

    function &setHtml($data, $charset=''){
        if($charset == ''){
            if(preg_match('/<meta\s+http-equiv\s*=\s*(["\'])Content-Type\1\s+content\s*=\s*(["\'])text\/html;\s+charset=(.+$)\2\s*>/i', $data, $match)){
                $charset = $match[3];
            }
        }
        $obj = new mailBody_singlepart();
        if($charset == ''){
            $obj->setData($data, 'text', 'html');
        }else{
            $text = bm_text_simple::getBlankInstance();
            $text->setCharacterEncoding($charset);
            $text->setData($data);
            $obj->setData($text, 'text', 'html');
        }
        return $this->addPart($obj);
    }

    function &setHtmlFromFile($path, $charset=''){
        $tmp = new mailBody_singlepart();
        $ret = $tmp->getDataFromFile($path);
        if(! $ret) return false;
        list($data, $type, $subtype) = $ret;
        if($type != 'text' || $subtype != 'html') return false;

        $obj =& $this->setHtml($data, $charset);

        $id_base = md5(uniqid(time(),1)).'.';
        $num = 0;
        $dir = dirname($path);
        $added = array();
        if(preg_match_all('/<img\s+src=([\'"])(.+$)\1/i',$data, $matches, PREG_PATTERN_ORDER)){
            foreach($matches as $match){
                if(preg_match('/^http::\/\//i', $match[2])) continue;
                if(substr($match[2], 0, 1) == '/') continue;
                if(!in_array($match[2],$added) && file_exists($dir.'/'.$match[2])){
                    $ret = $this->addInlineImageFromFile($dir.'/'.$match[2], $id_base.$num);
                    if(! $ret) continue;

                    $data = preg_replace($match[0], '<img src='.$match[1].$match[2].$match[1], $data);
                    array_push($added, $match[2]);
                }
            }
            $obj->setData($data);
        }
        return $obj;
    }

    function &addInlineImage($data, $subtype, $id){
        $obj = new mailBody_singlepart();
        $obj->setData($data, 'image', $subtype);
        $obj->beInline($id);
        return $this->addPart($obj);
    }

    function &addInlineImageFromFile($path, $id){
        $obj = new mailBody_singlepart();
        $ret = $obj->getDataFromFile($path);
        if(! $ret) return false;
        list($data, $type, $subtype) = $ret;
        if($type != 'image') return false;

        return $this->addInlineImage($data, $subtype, $id);
    }

}

?>