<?php
/*
* include address class
*/
include_once 'class.address.php';
include_once 'class.text.mail.php';
/**
 * mail header class
 *
 * This class holds infomations for mail sendig,
 * like destination address, subjects, and so on.
 *
 * @access public
 */
class mailHeader {

    /**
     * variables for destination address fields
     *
     *  @access public
     *  @var address $to      Holds all "To" addresses. address-list.
     *  @var address $cc      Holds all "CC" addresses. address-list.
     *  @var address $bcc     Holds all "CC" addresses. address-list.
     */
    var $to;
    var $cc;
    var $bcc;

    /**
     *  variables for originator fields
     *
     *  @access public
     *  @var address $sender      Holds a "sender" address. mailbox.
     *  @var address $from        Holds all "from" addresses. mailbox-list.
     *  @var address $replyTo     Holds all "from" addresses. address-list.
     */
    var $sender;
    var $from;
    var $replyTo;

    /**
     *  variables for optional
     *
     *  @access public
     *  @var address $confirmReadingTo      mailbox-list. rfc2298
     *  @var int $priority
     */
    var $confirmReadingTo;
    var $priority           = 3;

    /**
     *  variables for identification fields
     *
     *  @access public
     *  @var array $inReplyTo      Holds all "InReplyTo" msg-ids
     *  @var array $references     Holds all "References" msg-ids
     *  @var string $messageId     Holds a msg-id
     */
    var $inReplyTo      = array();
    var $references     = array();
    var $messageId      = '';

    /**
     *  variables for Informational fields
     *
     *  @access public
     *  @var string $subject
     *  @var string $comments
     *  @var array of string $keywords
     */
    var $subject;
    var $comments;
    var $keywords   = array();

    /**
     *  variables for Trace fields
     *
     *  @access public
     *  @var string $returnPath  addr-spec, that is just hoge@hoge.com style
     */
    var $returnPath = '';

    /**
     *  custom headers. ex. Reply-By: X-Message-Flag:
     *
     *  @access public
     *  @var array $custom
     */
    var $custom    = array();

    /**
     *  private variables
     *
     *  @access private
     */
    var $_priority_word      = array('urgent','normal','normal','normal','non-urgent');
    var $_importance_word    = array('high','high','normal','low','non-low');

    /**
     * Constructor.
     */
    function mailHeader() {
        //$this->mailContent($mailText);
        $this->to   = new addresslist();
        $this->cc   = new addresslist();
        $this->bcc  = new addresslist();
        $this->from = new mailboxlist();
        $this->sender = new nameaddr();
        $this->replyTo = new addresslist();
        $this->returnPath = new nameaddr();
        $this->confirmReadingTo = new mailboxlist();
        $this->subject = new unstructuredText;
        $this->comments = new unstructuredText;
    }

    /**
     * Assembles message header.
     *
     * @access public
     * @return array
     */
    function getHeader() {
        $header = array();

        if($this->returnPath->countAddress() > 0){
            $addr = $this->returnPath->getAddrspec();
            $header['Return-Path'] = '<'.$addr[0].'>';
        }
        elseif($this->sender->countAddress() > 0){
            $addr = $this->sender->getAddrspec();
            $header['Return-Path'] = '<'.$addr[0].'>';
        }elseif($this->from->countAddress() > 0){
            $objs = $this->from->getContentObjs();
            $addr = $objs[0]->getAddrspec();
            $header['Return-Path'] = '<'.$addr[0].'>';
        }

        $header['Received'] = sprintf("from %s by bytesmailer [%s] with HTTP;%s%s",
               $this->_get_server_var('REMOTE_ADDR'),
               $this->_get_server_var('SERVER_NAME'),
               _BYTESMAILER_FWS,
               $this->_rfc_date());

        if($this->to->countAddress() > 0) {
            $header['To'] = $this->to->getStringForHeader();
            //$header['addrspec']['To'] = $this->to->getAddrspec();
        }
        if($this->cc->countAddress() > 0) {
            $header['Cc'] = $this->cc->getStringForHeader();
            //$header['addrspec']['Cc'] = $this->cc->getAddrspec();
        }
        if($this->bcc->countAddress() > 0) {
            $header['Bcc'] = $this->bcc->getStringForHeader();
            //$header['addrspec']['Bcc'] = $this->bcc->getAddrspec();
        }

        if($this->from->countAddress() > 0){
            $header['From'] = $this->from->getStringForHeader();
        }else{
            $header['From'] = 'unknown';
        }

        if($this->sender->countAddress() > 0){
            //$header['addrspec']['Sender'] = $this->sender->getAddrspec();
            $header['Sender'] = $this->sender->getStringForHeader();
        }else{
            if($this->from->countAddress() >= 2){
                $objs = $this->from->getContentObjs();
                $this->sender = $objs[0];
                $header['Sender'] = $objs[0]->getStringForHeader();
            }
        }

        if($this->replyTo->countAddress() > 0)
            $header['Reply-to'] = $this->replyTo->getStringForHeader();

        $header['Date'] = $this->_rfc_date();

        if($this->subject->issetData())
            $header['Subject'] = $this->subject->getEncodedForHeader();

        if($this->comments->issetData() != '' )
            $header['Comments'] = $this->comments->getEncodedForHeader();

        if($this->messageId != '')
            $header['Message-ID'] = $this->messageId;
        if(!empty($this->inReplyTo))
            $header['In-Reply-To'] = implode(_BYTESMAILER_FWS, $this->inReplyTo);
        if(!empty($this->references))
            $header['References'] = implode(_BYTESMAILER_FWS, $this->references);

        $this->priority = intval($this->priority);
        if($this->priority < 1 || $this->priority > 5)  $this->priority=3;
        if($this->priority != 3){
            $header['X-Priority'] = sprintf("%d",$this->priority);
            $header['Priority'] = $this->_priority_word[$this->priority-1];
            $header['Importance'] = $this->_importance_word[$this->priority-1];
        }

        $header['X-Mailer'] = sprintf("bytesmailer [version %s]", _BYTESMAILER_VERSION );

        if($this->confirmReadingTo->countAddress() > 0)
            $header['Disposition-Notification-To']
                = $this->confirmReadingTo->getStringForHeader();
        if(! empty($this->custom))
            array_merge($header, $this->custom);
        // custom header will be not mime encoded.

        $header['MIME-Version'] = '1.0';

        return $header;
    }

    /**
     * Returns the proper RFC 822 formatted date.
     *
     * @access private
     * @return string
     */
    function _rfc_date() {
        $tz = date("Z");
        $tzs = ($tz < 0) ? "-" : "+";
        $tz = abs($tz);
        $tz = ($tz/3600)*100 + ($tz%3600)/60;
        $date = sprintf("%s %s%04d", date("D, j M Y H:i:s"), $tzs, $tz);
        return $date;
    }

    /**
     * Returns the appropriate server variable.
     *
     * @access private
     * @return mixed
     */
    function _get_server_var($varName) {
        global $HTTP_SERVER_VARS;
        global $HTTP_ENV_VARS;

        if(!isset($_SERVER)){
            $_SERVER = $HTTP_SERVER_VARS;
            if(!isset($_SERVER["REMOTE_ADDR"]))
                $_SERVER = $HTTP_ENV_VARS; // must be Apache
        }

        if(isset($_SERVER[$varName]))
            return $_SERVER[$varName];
        else
            return '';
    }

}

class unstructuredText {

    var $text_obj;

    function setData($data){
        if(! isset($this->text_obj)){
            $this->text_obj = bm_text_mail::getBlankInstance();
        }
        $this->text_obj->setData($data);
    }

    function getEncodedForHeader(){
        return $this->text_obj->getEncodedForHeader(false);
    }

    function isSetData(){
        if(! isset($this->text_obj)) return false;
        return $this->text_obj->isSetData();
    }
}
?>