<?php
/**
 * classe for mail transfar
 *
 * @package bytesmailer
 * @version $Id: class.sender.php,v 1.2 2003/02/02 08:10:54 haruki Exp $
 * @author  Haruki Setoyama <haruki@planewave.org>
 */
/*
* base class of  mail transfar class.
* @access private
*/
class bm_sender_core {

    var $error = array();

    function _make_header_string($header){
        //unset($header['addrspec']);
        $str = '';
        foreach($header as $key => $val){
            if(! is_array($val))
                $str .= wordwrap($key.': '.$val, 78, _BYTESMAILER_FWS)._BYTESMAILER_LE;
        }
        return $str;
    }

    function _recipient_exists(&$header){
        if(!isset($header['To']) && !isset($header['Cc']) && !isset($header['Bcc'])){
            $this->_set_error('No recipient email address.');
            return false;
        }
        return true;
    }

    function _split_header_body($text){
        $bline = strpos($text, _BYTESMAILER_LE._BYTESMAILER_LE);
        $header = substr($text, 0, $bline);
        $body = substr($text, $bline+2*strlen(_BYTESMAILER_LE));
        return array($header, $body);
    }

    function _set_error($msg){
        $this->error[] = $msg;
        if(_BYTESMAILER_DEBUG != false){
            echo '<b>bytesmailer error</b>: '.$msg.'<br />';
        }
    }

    function showLog(){
        echo '';
    }
}

/**
 * Sends mail using the PHP mail() function.
 * This is based on phpmailer's.
 * @access public
 * @return bool
 */
class bm_sender_mail extends bm_sender_core {

    function bm_sender_mail($dummy=''){
        // do nothig
    }

    function send($obj_header, $obj_body) {

        $header = $obj_header->getHeader();
        if(! $this->_recipient_exists($header)) return false;
        $to = implode(',', $obj_header->to->getAddrspec());

        if (isset($header['To'])) unset($header['To']);

        $subject = '';
        if (isset($header['Subject'])){
            $subject = str_replace(_BYTESMAILER_LE, '', $header['Subject']);
            unset($header['Subject']);
        }

        if (isset($header['Return-Path'])) {
            $old_from = ini_get("sendmail_from");
            ini_set("sendmail_from", substr($header['Return-Path'],1,strlen($header['Return-Path'])-2));
            unset($header['Return-Path']);
        }

        if (isset($header['Received'])) unset($header['Received']);

        $msg = $this->_make_header_string($header);
        $msg .= $obj_body->getAllMessage();
        list($headerstr, $body) = $this->_split_header_body($msg);

        $rt = @mail($to, $subject, $body, $headerstr);

        if(isset($old_from)) ini_set("sendmail_from", $old_from);

        if(!$rt){
            $this->_set_error('Could not instantiate mail() function.');
            return false;
        }

        return true;
    }

}

/**
 * Display mail message for debug.
 * @access public
 * @return bool
 */
class bm_sender_debug extends bm_sender_core{

    function bm_sender_debug($dummy=''){
        // do nothig
    }

    function send($obj_header, $obj_body) {

        $header = $obj_header->getHeader();
        $body = $obj_body->getAllMessage();

        echo '<h3>bytesmailer</h3>';

        echo '<h4>mail message</h4><pre>';
        echo htmlspecialchars($this->_make_header_string($header));
        //echo '-----------------------------------<br />';
        echo $body;
        echo '</pre>';

        return true;
    }
}

/**
 * Sends mail via SMTP using PhpSMTP (Author: Chris Ryan).
 * This is based on phpmailer's.
 * @access public
 * @return bool
 */
class bm_sender_smtp extends bm_sender_core{

    /**
     *  Sets the SMTP hosts.
     *  format: [username:[pasword]@]hostname[:port]
     *  (e.g. "me:pass@smtp1.domain.com:25;smtp2.domain.com").
     *  Hosts will be tried in order.
     *  @access public
     *  @var string
     */
    var $host        = 'localhost';

    /**
     *  Sets the default SMTP server port.
     *  @access public
     *  @var int
     */
    var $port        = 25;

    /**
     *  Sets the SMTP HELO of the message.
     *  @access public
     *  @var string
     */
    var $helo        = 'localhost.localdomain';


    /**
     *  Sets the SMTP server timeout in seconds. This function will not
     *  work with the win32 version.
     *  @access public
     *  @var int
     */
    var $timeout      = 10;

    /**
     *  Sets SMTP class debugging on or off.
     *  @access public
     *  @var bool
     */
    var $debug;

    var $smtp;

    function bm_sender_smtp($host='localhost'){
        if($host == '') $host='localhost';
        $this->debug = _BYTESMAILER_DEBUG;
        $this->host = $host;
    }

    /**
     * Sends mail via SMTP using PhpSMTP (Author:
     * Chris Ryan).  Returns bool.  Returns false if there is a
     * bad MAIL FROM, RCPT, or DATA input.
     * @access public
     * @return bool
     */
    function send($obj_header, $obj_body) {

        $header = $obj_header->getHeader();

        if(! $this->_recipient_exists($header)) return false;

        if(! is_array($this->host)) $this->host = array($this->host);
        foreach($this->host as $val){
            if(preg_match('/^(?:([^:@]+)(?::([^:@]+))?@)?([^:@]+)(?::([0-9]+))?$/', $val, $match)){
                if($match[4] == '' ) $match[4] = $this->port;
                $hosts[] = array(    'host' => $match[3],
                                    'port' => intval($match[4]),
                                    'user' => $match[1],
                                    'pass' => $match[2]);
            }
        }

        include_once _BYTESMAILER_DIR.'class/class.smtp.php';

        $smtp = new SMTP;
        $this->smtp =& $smtp;
        $smtp->do_debug = $this->debug;

        // Try to connect to all SMTP servers
        //$hosts = explode(';', $this->host);
        $index = 0;
        $connection = false;

        // Retry while there is no connection
        while($index < count($hosts) && $connection == false){
            if($smtp->Connect($hosts[$index]['host'], $hosts[$index]['port'], $this->timeout))
                $connection = true;
            //printf("%s host could not connect<br>", $hosts[$index]); //debug only
            $index++;
        }
        if(! $connection){
            $this->_set_error('SMTP Error: could not connect to SMTP host server(s).');
            return false;
        }
        // Must perform HELO before authentication
        $smtp->Hello($this->helo);

        // If user requests SMTP authentication
        if($hosts[$index]['user'] != ''){
            if(!$smtp->Authenticate($hosts[$index]['user'], $hosts[$index]['pass'])){
                $this->_set_error('SMTP Error: Could not authenticate to %s:%s.', $hosts[$index]['host'], $hosts[$index]['port']);
                return false;
            }
        }

        if(! $smtp->Mail($header['Return-Path'])){
            $this->_set_error(sprintf("SMTP Error: From address [%s] failed", $header['Return-Path']));
            return false;
        }

        // Attempt to send mail all recipients
        $recipients = array_merge($obj_header->to->getAddrspec()
                                    ,$obj_header->cc->getAddrspec()
                                    ,$obj_header->bcc->getAddrspec());

        $bad_rcpt = array();
        foreach($recipients as $recipt){
            if(! $smtp->Recipient(sprintf("<%s>", $recipt)))
                $bad_rcpt[] = $recipt;
        }

        // Create error message
        if(count($bad_rcpt) > 0){
            $this->_set_error(sprintf("SMTP Error: The following recipients failed [%s]."
                            , implode(', ', $bad_rcpt)));
            return false;
        }

        if(isset($header['Bcc'])) $header['Bcc'] = '';
        if(isset($header['Return-Path'])) unset($header['Return-Path']);
        $data = $this->_make_header_string($header).$obj_body->getAllMessage();

        if(! $smtp->Data(sprintf("%s", $data))){
            $this->_set_error("SMTP Error: Data not accepted");
            return false;
        }
        $smtp->Quit();

        return true;
    }

    function showLog(){
        echo $this->smtp->getLog();
    }

}

/**
 * Sends mail using the $Sendmail program.
 * This is based on phpmailer's.
 * @access public
 * @return bool
 */
class bm_sender_sendmail extends bm_sender_core{

    /**
     * Sets the path of the sendmail program.
     * @access public
     * @var string
     */
    var $sendmail          = '/usr/sbin/sendmail';

    function bm_sender_sendmail($sendmail_path=''){
        if($sendmail_path != '') $this->sendmail = $sendmail_path;
    }

    /**
     * Sends mail using the $Sendmail program.
     * @access public
     * @return bool
     */
    function send($obj_header, $obj_body) {
        $header = $obj_header->getHeader();

        if(! $this->_recipient_exists($header)) return false;

        if (! empty($header['Return-Path']))
            $sendmail = sprintf("%s -oi -f %s -t", $this->sendmail, substr($header['Return-Path'],1,strlen($header['Return-Path'])-2));
        else
            $sendmail = sprintf("%s -oi -t", $this->sendmail);

        if(! (@$mail = popen($sendmail, "w"))){
            $this->_set_error(sprintf("Could not open pipe to %s", $this->sendmail));
            return false;
        }

        $data = $this->_make_header_string($header).$obj_body->getAllMessage();

        fputs($mail, $data, strlen($data));

        $result = pclose($mail) >> 8 & 0xFF;
        if($result != 0){
            $this->_set_error(sprintf("Could not close pipe to %s", $this->sendmail));
            return false;
        }

        return true;
    }
}

?>