<?php
/**
 * text data handling base class.
 *
 * this class holds character encoding data of the text.
 * Based on RFC2045, RFC2047, RFC2822
 * @package bytesmailer
 * @version $Id: class.text.simple.php,v 1.3 2003/01/27 16:15:47 haruki Exp $
 * @author  Haruki Setoyama <haruki@planewave.org>
 */
/**
 * define and include.
 */
if(! defined('_BYTESMAILER_LE'))    define('_BYTESMAILER_LE', "\r\n");
if(! defined('_BYTESMAILER_FWS'))   define('_BYTESMAILER_FWS', _BYTESMAILER_LE.' ');
if(! defined('_BYTESMAILER_MAX_LINE_LENGTH')) define('_BYTESMAILER_MAX_LINE_LENGTH', 998); // 998
if(! defined('_BYTESMAILER_QP_STRICT')) define('_BYTESMAILER_QP_STRICT', true);
include_once 'class.textinfo.php';
include_once 'class.binary.php';
/**
 * text data handling base class.
 *
 * this class holds character encoding data of the text.
 * @access public
 */
class bm_text_simple extends bm_binary{

    var $textinfo;
    var $spliter;

    function bm_text_simple($param=''){
        //
    }

    function &getInstance($param=''){
        static $obj;
        if(! isset($obj)) $obj = new bm_text_simple($param);
        return $obj;
    }

    function getBlankInstance(){
        $obj = bm_text_simple::getInstance();
        $obj->setData('');
        return $obj;
    }

// setter
    function &setCharacterEncoding($encoding_name){
        $obj = new textInfo($encoding_name);
        return $this->setTextinfo($obj);
    }

    function &setTextinfo($obj){
        $this->textinfo = $obj;
        $encoding_name = $this->textinfo->getCharacterEncoding();
        $filename = dirname(__FILE__).'/spliter/class.spliter.'.strtolower(str_replace('-','', $encoding_name)).'.php';
//echo $filename.'<br />';
        if(file_exists($filename)){
            include_once $filename;
            $classname = 'spliter_'.strtolower(str_replace('-','', $encoding_name));
            $this->spliter = new $classname;
            return $this->textinfo;
        }else{
//echo "file not exists<br />";
        }
        if($this->textinfo->isMultibyte){
            if(spliter_mb::isAcceptable($this->textinfo)){
                $this->spliter = new spliter_mb;
                return $this->textinfo;
            }
        }else{
            if(spliter_sb::isAcceptable($this->textinfo)){
                $this->spliter = new spliter_sb;
                return $this->textinfo;
            }
        }
        $this->spliter = new spliter_void;
        return $this->textinfo;
    }

// getter
    function getEncodedForBody(){
//echo $this->data.'<br />';
        $type = $this->textinfo->getEncodeTypeForBody();
        switch($type){
        case 'base64':
            return $this->_get_base64_encoded_for_body();

        case 'quoted-printable':
            return $this->_get_qp_encoded_for_body();

        default:
        case '7bit':
        case '8bit':
            return $this->_get_folded(_BYTESMAILER_MAX_LINE_LENGTH);

        case 'binary':
            return $this->data;
        }
    }

    function getEncodedForHeader($structured=true){
        $type = $this->textinfo->getEncodeTypeForHeader();
        switch($type) {
        case 'base64':
            return $this->_get_base64_encoded_for_header($structured);

        case 'quoted-printable':
            return $this->_get_qp_encoded_for_header($structured);

        default:
            $lines = $this->_fold(73, $this->data);
            if($structured){
                for($i=0; $i < count($lines); $i++){
                    $lines[$i] = $this->_quote_non_atext($lines[$i]);
                }
            }
            return implode(_BYTESMAILER_FWS, $lines);

        case 'binary':
            return $this->data;
        }
    }

    function getEncodedForParam($param_name){
        $type = $this->textinfo->getEncodeTypeForParam();
        switch($type){
        case 'base64':
            return $param_name.'="'.$this->_get_base64_encoded_for_header($structured).'"';

        case 'quoted-printable':
            return $param_name.'="'.$this->_get_qp_encoded_for_header($structured).'"';

        default:
            $lines = $this->_fold(73, $this->data);
            if($structured){
                for($i=0; $i < count($lines); $i++){
                    $lines[$i] = $this->_quote_non_atext($lines[$i]);
                }
            }
            return $param_name.'='.implode(_BYTESMAILER_FWS, $lines);

        case 'binary':
            return $param_name.'='.$this->data;
        }
    }

    function _get_folded($length){
        if($length <= 0){
            return $this->data;
        }
        return implode(_BYTESMAILER_LE, $this->_fold($length, $this->data));
    }

    ///// private functions

    /**
     * fold $text with $length byte
     *
     * @access private
     * @return array
     */
    function _fold($length, $text){
        $text = $this->_fix_eol(_BYTESMAILER_LE, $text);

        if($length < 1) {
            return explode(_BYTESMAILER_LE, $text);
        }

        // main loop
        $ret = array();
        $lines = explode(_BYTESMAILER_LE, $text);
        if(! $this->textinfo->isWordwrapable() ){
        // unable to wordwap, split the line
            foreach($lines as $line){
                array_push($ret, $this->spliter->split($line, $length));
            }
        }else{
        // word wrapable
            $ret = $this->_wordwrap($lines, $length);
        }

        return $ret;
    }

    /**
     * do wordwrap
     *
     * @access private
     * @return array
     */
    function _wordwrap(&$lines, $max_length, $glue=''){
        $max_length -= strlen($glue);
        $ret = array();
        $num_ret = -1;

        foreach($lines as $line){
            $num_ret++;
            if(strlen($line) <= $max_length) {
                $ret[$num_ret] = $line;
                $num_ret++;
            }else{
                $ret[$num_ret] = '';
                $words = $this->_split_to_word($line);
                $words_count = count($words);

                $line_length = 0;
                foreach($words as $word){
                    $word_length = strlen($word);
                    $line_length += $word_length;
                    if($line_length <= $max_length) {
                        $ret[$num_ret] .= $word;
                    }elseif($word_length <= $max_length) {
                        // new line
                        $ret[$num_ret] .= $glue;
                        $num_ret++;
                        $ret[$num_ret] = $word;
                        $line_length = $word_length;
                    }else{
                        // If word is longer than $length, split the word.
                        $first_line_length = $max_length - ($line_length - $word_length);
                        $splited_word = $this->spliter->split($word, $max_length, $first_line_length);
                        if(strlen($splited_word[0]) <= $first_line_length){
                            $ret[$num_ret] .= $splited_word[0];
                        }else{
                            $ret[$num_ret] .= $glue;
                            $num_ret++;
                            $ret[$num_ret] = $splited_word[0];
                        }
                        $num = count($splited_word);
                        for($i=1; $i < $num; $i++){
                            $ret[$num_ret] .= $glue;
                            $num_ret++;
                            $ret[$num_ret] = $splited_word[$i];
                        }
                        $line_length = strlen($ret[$num_ret]);
                    }
                }
            }
        }
        return $ret;
    }

    function _split_to_word($string, $spliter='\s'){
        $ret = array();
        while($string != ''){
            //if(preg_match('/^(.*$'.$spliter.')(.*)$/', $string, $matches)){
            if(preg_match('/^([^'.$spliter.']*'.$spliter.')(.*)$/', $string, $matches)){
                $ret[] = $matches[1];
                $string = $matches[2];
            }else{
                $ret[] = $string;
                $string = '';
            }
        }
        return $ret;
    }

    /**
     * Changes every end of line CR or LF or CRLF to $eol.
     * @access private
     */
    function _fix_eol($eol="\r\n", $text) {
        return str_replace(array("\r\n", "\r", "\n")
                            , array($eol, $eol, $eol)
                            , $text);
    }

    function _is_ascii(){
        if(! $this->textinfo->isAsciiCompatible() )
            return false;

        return !preg_match('/[^\040-\176]/',$text);
    }


    function _get_ascii_prefix_and_lest(){

        if(! $this->textinfo->isAsciiCompatible()){
            return array('', $this->data);
        }
        if(preg_match('/^([\040-\176]*)$/s', $this->data, $matches)){
            return array($matches[1], '');
        }
        elseif(preg_match('/^([\040-\176]+)\040(.*)$/s', $this->data, $matches)){
            return array($matches[1], $matches[2]);
        }
        return array('', $this->data);
    }


    function _get_base64_encoded_for_body(){
        return chunk_split(base64_encode($this->data), 76, _BYTESMAILER_LE);
    }

    function _get_base64_encoded_for_header($structured=true){
        $length = floor((75-8-strlen($this->textinfo->getCharacterEncoding()))/4*3);
        list($prefix, $text) = $this->_get_ascii_prefix_and_lest();
//echo $prefix.', '.$text.'<br />';
        $encoded = array();
        if($prefix != '') {
            $prefix = $this->_fold(73, $prefix);
            foreach($prefix as $val){
                if($structured){
                    $encoded[] = $this->_quote_non_atext($val);
                }else{
                    $encoded[] = $val;
                }
            }
        }
        $lines = $this->_fold($length, $text);
        foreach($lines as $line){
            if(!empty($line))
                $encoded[] = '=?'.$this->textinfo->getCharacterEncoding().'?B?'.base64_encode($line).'?=';
        }
        return implode(_BYTESMAILER_FWS, $encoded);
    }

    function _get_qp_encoded_for_body(){
        $encoded = $this->_fix_eol(_BYTESMAILER_LE, $this->data);
        // Replace every high ascii, control and = characters
        $encoded = preg_replace("/([\001-\010\013\014\016-\037\075\177-\377])/e",
                  "'='.sprintf('%02X', ord('\\1'))", $encoded);
        // !"#$@[\]^`{|}~
        if(_BYTESMAILER_QP_STRICT != false){
            $encoded = preg_replace("/([\041-\044\100\133-\140\173-\176])/e",
                      "'='.sprintf('%02X', ord('\\1'))", $encoded);
        }
        // Replace every spaces and tabs when it's the last character on a line
        $encoded = preg_replace("/([\011\040])"._BYTESMAILER_LE."/e",
                  "'='.sprintf('%02X', ord('\\1'))._BYTESMAILER_LE", $encoded);
        // Maximum line length of 76 characters before CRLF (74 + space + '=')
        //$encoded = implode(_BYTESMAILER_LE, $this->_wordwrap_qp($encoded, 74));
        $lines = explode(_BYTESMAILER_LE, $encoded);
        $encoded = implode(_BYTESMAILER_LE, $this->_wordwrap($lines, 76, '='));
        return $encoded;
    }

    function _get_qp_encoded_for_header($structured=true){
        //$chararr = $this->_get_characters_by_array();
        $encoding = $this->textinfo->getCharacterEncoding();
        $max_length = 75 - 8 - strlen($encoding) - 3;
        list($prefix, $text) = $this->_get_ascii_prefix_and_lest();
        $encoded = array();
        if($prefix != '') {
            $prefix = $this->_fold(73, $prefix);
            foreach($prefix as $val){
                if($structured){
                    $encoded[] = $this->_quote_non_atext($val);
                }else{
                    $encoded[] = $val;
                }
            }
        }
        // Replace every high ascii, control , spaces, tabs and = ? _ characters
        $text = preg_replace("/([\001-\011\013\014\016-\040\075\077\137\177-\377])/e",
                  "'='.sprintf('%02X', ord('\\1'))", $text);
        // !"#$@[\]^`{|}~
        if(_BYTESMAILER_QP_STRICT != false){
            $text = preg_replace("/([\041-\044\100\133-\140\173-\176])/e",
                      "'='.sprintf('%02X', ord('\\1'))", $text);
        }
        $lines = $this->_fold($max_length, $text);
        foreach($lines as $line){
            if(!empty($line))
                $encoded[] = '=?'.$encoding.'?Q?'.$line.'?=';
        }
        return implode(_BYTESMAILER_FWS, $encoded);
    }

    function _quote_non_atext($text){
        if(! $this->_is_atext($text)){
            return $this->_quote($text);
        }
        return $text;
    }

    function _quote($str){
        $str = str_replace('\\', '\\\\', $str); //'
        $str = str_replace('"', '\"', $str);
        $str = '"'.$str.'"';
        return $str;
    }

    function _is_atext(&$text){
        return !preg_match('/[^\043-\047\052\053\055\057\060-\071\075\077\101-\132\136-\176]/',$text);
    }
}

class spliter_sb {

    /**
     * split $string text
     *
     * this is can not split multibyte chars text. Override this.
     * @access private
     * @return array
     */
    function split($string, $length, $first_part_length=0){
        // this function can not split multibyte text

        $st=0;
        $ret = array();

        // first line
        if($first_line_length > 0){
            $ret[] = substr($string, $st, $first_line_length);
            $st += $first_line_length;
        }

        // after the first line
        while ($word_length - $st >= $length) {
            $ret[] = substr($string, $st, $length);
            $st += $length;
        }
        // left
        $ret[] = substr($string, $st);

        return $ret;
    }

    function isAcceptable($text_info){
        if($text_info->isMultibyte() || $text_info->isStateful()){
            return false;
        }
        return true;
    }

}

class spliter_void {

    function split($string, $length, $first_part_length=0){
        // do nothig
        return array($string);
    }

    function isAcceptable($text_info){
        return true;
    }

}

class spliter_mb {
    /**
     * split word (or line)
     *
     * use mb functions
     * @access private
     */
    function _split($word, $length, $first_line_length=0){
        $old = mb_internal_encoding();

        if($this->_bytelen($word) <= $length){
            $ret[] = $word;
        }else{
            while($this->_bytelen($word) > $length) {
                $ret[] = $this->_left_text($word,$length);
            }
            if($this->_bytelen($word) >0)
                $ret[] = $word;
        }

        mb_internal_encoding($old);
        return $ret;
    }

    function _bytelen(&$str){
        return count( unpack('C*', $str) );
    }

    function _left_text(&$str, $width){
        if($this->_bytelen($str) <= $width){
            return '';
        }
        $st = floor($width/2);
        if($this->_bytelen(mb_substr($str, 0, $st)) >= $width){
            $st--;
            while($this->_bytelen(mb_substr($str, 0, $st)) >= $width){
                $st--;
            }
            $ret = mb_substr($str, 0, $st);
            $str = mb_substr($str, $st);
            return $ret;
        }else{
            $st++;
            while($this->_bytelen(mb_substr($str, 0, $st)) < $width){
                $st++;
            }
            $ret = mb_substr($str, 0, $st-1);
            $str = mb_substr($str, $st-1);
            return $ret;
        }
    }

    function isAcceptable($text_info){
        // ??
        if(! function_exists(mb_convert_encoding))
            return false;

        return @mb_convert_encoding('1',$mail_encoding,$internal_encoding);
    }
}
?>