<?php
/**
 * informartions of text handling class.
 *
 * this class treats,
 *  character encoding name,
 *  multibyte encoding or not,
 *  7bit or 8bit,
 *  stateful encoding or not,
 *  when the text have only [0x20-0x7F], it's ascii or not,
 *  language name (with the style of en, ja ...),
 *  possible to wordwrap or not,
 *  MIME encoding type for body, header and parameter.
 * @package bytesmailer
 * @version $Id: class.textinfo.php,v 1.1 2003/01/21 14:17:56 haruki Exp $
 * @author  Haruki Setoyama <haruki@planewave.org>
 */
class textInfo {

    var $character_encoding;
    var $mine_encoding;
    var $language;

    function textInfo($encoding_name){
        $this->setCharacterEncoding($encoding_name);
    }

    function setCharacterEncoding($str){
        $this->character_encoding['name'] = $str;
        $filename = dirname(__FILE__).'/textinfo/'.strtolower(str_replace('-','', $str)).'.php';
        if(is_readable($filename)){
            include $filename;
        }elseif(empty($this->character_encoding)){
            $this->setMultibyte();
            $this->set7bit();
            $this->setStateful();
            $this->setAsciiCompatible();
            $this->setWordWrapable();
        }
    }

    function getCharacterEncoding(){
        return $this->character_encoding['name'];
    }

    function setMultibyte($bl=true){
        $this->character_encoding['mb'] = (! $bl) ? false : true;
    }

    function isMultibyte(){
        return $this->character_encoding['mb'];
    }

    function set7bit($bl=false){
        $this->character_encoding['7bit'] = (! $bl) ? false : true;
    }

    function is7bit(){
        return $this->character_encoding['7bit'];
    }

    function setStateful($bl=false){
        $this->character_encoding['state'] = (! $bl) ? false : true;
    }

    function isStateful(){
        return $this->character_encoding['state'];
    }

    function setAsciiCompatible($bl=true){
        $this->character_encoding['ascii'] = (! $bl) ? false : true;
    }

    function isAsciiCompatible(){
        return $this->character_encoding['ascii'];
    }

    // informations of language

    function setLanguage($str){
        if(strlen($str) == 2) {
            return $this->language['language'] = $str;
        }else{
            return false;
        }
    }

    function getLanguage(){
        return $this->language['language'];
    }

    function setWordWrapable($bl=true){
        $this->language['ww'] = $bl;
    }

    function isWordWrapable(){
        return $this->language['ww'];
    }

    // infomations of mine_encoding

    function setEncodeTypeForBody($str){
        $this->mine_encoding['body'] = $str;
    }

    function getEncodeTypeForBody(){
        if(! empty($this->mine_encoding['body'])){
            return $this->mine_encoding['body'];
        }
        elseif($this->is7bit()){
            return '7bit';
        }
        elseif(! $this->isMultibyte()){
            return 'quoted-printable';
        }
        return 'base64';
    }

    function setEncodeTypeForHeader($str){
        $this->mine_encoding['header'] = $str;
    }

    function getEncodeTypeForHeader(){
        if(! empty($this->mine_encoding['header'])){
            return $this->mine_encoding['header'];
        }
        elseif(! $this->isMultibyte()){
            return 'quoted-printable';
        }
        return 'base64';
    }

    function setEncodeTypeForParam($str){
        $this->mine_encoding['param'] = $str;
    }

    function getEncodeTypeForParam(){
        if(! empty($this->mine_encoding['param'])){
            return $this->mine_encoding['param'];
        }
        elseif(! $this->isMultibyte()){
            return 'quoted-printable';
        }
        return 'base64';
    }
}

?>