#ifndef BMP_H
#define BMP_H

#define bmp_for2(bmp) \
  for(int y;y<bmp.h;y++) \
    for(int x;x<bmp.w;x++)

#define bmp_for3(bmp) \
  for(int y=0;y<bmp.h;y++) \
    for(int x=0;x<bmp.w;x++) \
      for(int z=0;z<3;z++)

template<class T>
struct RGB{
  T r;
  T g;
  T b;
  RGB(){
    r=g=b=0;
  }
  template<class T2>
  T& operator[](T2 t){
    if(t==0)
      return r;
    else if(t==1)
      return g;
    else
      return b;
  }
};

template<class T>
struct Bitmap{
  RGB<T>* dat;
  int w,h;
  RGB<T>& operator()(int x,int y){
    return dat[w*y+x];
  }
  T& operator()(int x,int y,int z){
    return dat[w*y+x][z];
  }
  void
  init(int w,int h){
    if(dat!=NULL)
      delete [] dat;
    dat=new RGB<T>[w*h];
    this->w=w;
    this->h=h;
  }
  int
  read(const char* file){
    char buf[1024];
    int c;
    POPEN(gid,"rb","convert %s ppm:-",file);
    PCHECK(gid,fgets(buf,sizeof(buf),gid)!=(char*)EOF);
    PCHECK(gid,fscanf(gid,"%d %d",&w,&h)==2);
    PCHECK(gid,fscanf(gid,"%d",&c)==1);
    PCHECK(gid,fgets(buf,sizeof(buf),gid)!=(char*)EOF);
    init(w,h);

    unsigned char *b=(unsigned char *)malloc(h*w*3);
    PCHECK(gid,b!=NULL);
    if(fread(b,w*h*3,1,gid)!=1){
      free(b);
      PCHECK(gid,0);
    }

    for(int i=0;i<w*h;i++){
      dat[i][0]=b[i*3];
      dat[i][1]=b[i*3+1];
      dat[i][2]=b[i*3+2];
    }
    free(b);

    pclose(gid);
    return 0;
  }
  int
  write(const char* file){
    char buf[1024];
    POPEN(gid,"wb","convert ppm:- %s",file);
    fprintf(gid,"P6\n");
    fprintf(gid,"%d %d\n",w,h);
    fprintf(gid,"255\n");
    for(int i=0;i<w*h;i++){
      fputc(dat[i][0],gid);
      fputc(dat[i][1],gid);
      fputc(dat[i][2],gid);
    }
    pclose(gid);
    return 0;
  }
  Bitmap(const char* file){
    dat=NULL;
    read(file);
  }
  Bitmap(int w,int h){
    dat=NULL;
    init(w,h);
  }
  Bitmap(){
    dat=NULL;
  }
  Bitmap(Bitmap& d) {
    printf("copy\n");
    dat=NULL;
    init(d.w,d.h);
    for(int i=0;i<w*h;i++)
      dat[i]=d.dat[i];
  }
  ~Bitmap(){
    if(dat!=NULL)
      delete [] dat;
    dat=NULL;
  }
  
};

typedef Bitmap<unsigned short>  BMP;



#endif
