@rem = '--*-Perl-*--
@echo off
if "%OS%" == "Windows_NT" goto WinNT
"%~dp0perl.exe" -x -S "%0" %1 %2 %3 %4 %5 %6 %7 %8 %9
goto endofperl
:WinNT
"%~dp0perl.exe" -x -S %0 %*
if NOT "%COMSPEC%" == "%SystemRoot%\system32\cmd.exe" goto endofperl
if %errorlevel% == 9009 echo You do not have Perl in your PATH.
if errorlevel 1 goto script_failed_so_exit_with_non_zero_val 2>nul
goto endofperl
@rem ';
#!/usr/bin/perl -w
#line 15
use strict;
use warnings;
use CPAN::Mini::App;
CPAN::Mini::App->run;

__END__

=head1 NAME

minicpan - uses CPAN::Mini to create or update a local mirror

=head1 SYNOPSIS

 minicpan [options]

 Options
   -l LOCAL   - where is the local minicpan?     (required)
   -r REMOTE  - where is the remote cpan mirror? (required)
   -d 0###    - permissions (numeric) to use when creating directories
   -f         - check all directories, even if indices are unchanged
   -p         - mirror perl, ponie, and parrot distributions
   -q         - run in quiet mode (don't print status)
   -qq        - run in silent mode (don't even print warnings)
   -c CLASS   - what class to use to mirror (default: CPAN::Mini)
   -C FILE    - what config file to use (default: ~/.minicpanrc)
   -h         - print help and exit
   -v         - print version and exit
   -x         - build an exact mirror, getting even normally disallowed files
   --offline  - operate in offline mode (generally: do nothing)

=head1 DESCRIPTION

This simple shell script just updates (or creates) a miniature CPAN mirror as
described in CPAN::Mini.

=head1 CONFIGURATION FILE

By default, C<minicpan> will read a configuration file to get configuration
information.  The file is a simple set of names and values, as in the following
example:

 local:  /home/rjbs/mirrors/minicpan/
 remote: http://your.favorite.cpan/cpan/
 exact_mirror: 1
 
C<minicpan> tries to find a configuration file through the following process.
It takes the first defined it finds:

=over 4

=item * Use the value specified by C<-C> on the command line

=item * Use the value in the C<CPAN_MINI_CONFIG> environment variable

=item * Use F<~/.minicpanrc>

=item * Use F<CPAN/Mini/minicpan.conf>

=back

If the selected file does not exist, C<minicpan> does not keep looking.

You can override this process with a C<config_file> method in your subclass.

See C<CPAN::Mini> for a full listing of available options.

=head1 TO DO

Improve command-line options.

=head1 SEE ALSO 

Randal Schwartz's original article, which can be found here:

  http://www.stonehenge.com/merlyn/LinuxMag/col42.html

=head1 AUTHORS

Randal Schwartz <F<merlyn@stonehenge.com>> had the bright idea and wrote the
original implementation.

Ricardo SIGNES <F<rjbs@cpan.org>> brazenly took the script, made a module and
distribution, and slowly allowed it to gain features.

This code was copyrighted in 2004, and is released under the same terms as Perl
itself.

=cut

__END__
:endofperl
