# !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
# This file is machine-generated by mktables from the Unicode
# database, Version 5.2.0.  Any changes made here will be lost!

use strict;
use warnings;

# Test qr/\X/ and the \p{} regular expression constructs.  This file is
# constructed by mktables from the tables it generates, so if mktables is
# buggy, this won't necessarily catch those bugs.  Tests are generated for all
# feasible properties; a few aren't currently feasible; see
# is_code_point_usable() in mktables for details.

# Standard test packages are not used because this manipulates SIG_WARN.  It
# exits 0 if every non-skipped test succeeded; -1 if any failed.

my $Tests = 0;
my $Fails = 0;

my $non_ASCII = (ord('A') != 65);

# The 256 8-bit characters in ASCII ordinal order, with the ones that don't
# have Perl names replaced by -1
my @ascii_ordered_chars = (
    "\0",
    (-1) x 6,
    "\a", "\b", "\t", "\n",
    -1,   # No Vt
    "\f", "\r",
    (-1) x 18,
    " ", "!", "\"", "#", '$', "%", "&", "'",
    "(", ")", "*", "+", ",", "-", ".", "/",
    "0", "1", "2", "3", "4", "5", "6", "7", "8", "9",
    ":", ";", "<", "=", ">", "?", "@",
    "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M",
    "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z",
    "[", "\\", "]", "^", "_", "`",
    "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m",
    "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z",
    "{", "|", "}", "~",
    (-1) x 129
);

sub ASCII_ord_to_native ($) {
    # Converts input ordinal number to the native one, if can be done easily.
    # Returns -1 otherwise.

    my $ord = shift;

    return $ord if $ord > 255 || ! $non_ASCII;
    my $result = $ascii_ordered_chars[$ord];
    return $result if $result eq '-1';
    return ord($result);
}

sub Expect($$$$) {
    my $expected = shift;
    my $ord = shift;
    my $regex  = shift;
    my $warning_type = shift;   # Type of warning message, like 'deprecated'
                                # or empty if none
    my $line   = (caller)[2];

    # Convert the non-ASCII code points expressible as characters to their
    # ASCII equivalents, and skip the others.
    $ord = ASCII_ord_to_native($ord);
    if ($ord < 0) {
        $Tests++;
        print "ok $Tests - "
              . sprintf("\"\\x{%04X}\"", $ord)
              . " =~ $regex # Skipped: non-ASCII\n";
        return;
    }

    # Convert the code point to hex form
    my $string = sprintf "\"\\x{%04X}\"", $ord;

    my @tests = "";

    # The first time through, use all warnings.  If the input should generate
    # a warning, add another time through with them turned off
    push @tests, "no warnings '$warning_type';" if $warning_type;

    foreach my $no_warnings (@tests) {

        # Store any warning messages instead of outputting them
        local $SIG{__WARN__} = $SIG{__WARN__};
        my $warning_message;
        $SIG{__WARN__} = sub { $warning_message = $_[0] };

        $Tests++;

        # A string eval is needed because of the 'no warnings'.
        # Assumes no parens in the regular expression
        my $result = eval "$no_warnings
                            my \$RegObj = qr($regex);
                            $string =~ \$RegObj ? 1 : 0";
        if (not defined $result) {
            print "not ok $Tests - couldn't compile /$regex/; line $line: $@\n";
            $Fails++;
        }
        elsif ($result ^ $expected) {
            print "not ok $Tests - expected $expected but got $result for $string =~ qr/$regex/; line $line\n";
            $Fails++;
        }
        elsif ($warning_message) {
            if (! $warning_type || ($warning_type && $no_warnings)) {
                print "not ok $Tests - for qr/$regex/ did not expect warning message '$warning_message'; line $line\n";
                $Fails++;
            }
            else {
                print "ok $Tests - expected and got a warning message for qr/$regex/; line $line\n";
            }
        }
        elsif ($warning_type && ! $no_warnings) {
            print "not ok $Tests - for qr/$regex/ expected a $warning_type warning message, but got none; line $line\n";
            $Fails++;
        }
        else {
            print "ok $Tests - got $result for $string =~ qr/$regex/; line $line\n";
        }
    }
    return;
}

sub Error($) {
    my $regex  = shift;
    $Tests++;
    if (eval { 'x' =~ qr/$regex/; 1 }) {
        $Fails++;
        my $line = (caller)[2];
        print "not ok $Tests - re compiled ok, but expected error for qr/$regex/; line $line: $@\n";
    }
    else {
        my $line = (caller)[2];
        print "ok $Tests - got and expected error for qr/$regex/; line $line\n";
    }
    return;
}

# GCBTest.txt character that separates grapheme clusters
my $breakable_utf8 = my $breakable = chr(0xF7);
utf8::upgrade($breakable_utf8);

# GCBTest.txt character that indicates that the adjoining code points are part
# of the same grapheme cluster
my $nobreak_utf8 = my $nobreak = chr(0xD7);
utf8::upgrade($nobreak_utf8);

sub Test_X($) {
    # Test qr/\X/ matches.  The input is a line from auxiliary/GCBTest.txt
    # Each such line is a sequence of code points given by their hex numbers,
    # separated by the two characters defined just before this subroutine that
    # indicate that either there can or cannot be a break between the adjacent
    # code points.  If there isn't a break, that means the sequence forms an
    # extended grapheme cluster, which means that \X should match the whole
    # thing.  If there is a break, \X should stop there.  This is all
    # converted by this routine into a match:
    #   $string =~ /(\X)/,
    # Each \X should match the next cluster; and that is what is checked.

    my $template = shift;

    my $line   = (caller)[2];

    # The line contains characters above the ASCII range, but in Latin1.  It
    # may or may not be in utf8, and if it is, it may or may not know it.  So,
    # convert these characters to 8 bits.  If knows is in utf8, simply
    # downgrade.
    if (utf8::is_utf8($template)) {
        utf8::downgrade($template);
    } else {

        # Otherwise, if it is in utf8, but doesn't know it, the next lines
        # convert the two problematic characters to their 8-bit equivalents.
        # If it isn't in utf8, they don't harm anything.
        use bytes;
        $template =~ s/$nobreak_utf8/$nobreak/g;
        $template =~ s/$breakable_utf8/$breakable/g;
    }

    # Get rid of the leading and trailing breakables
    $template =~ s/^ \s* $breakable \s* //x;
    $template =~ s/ \s* $breakable \s* $ //x;

    # And no-breaks become just a space.
    $template =~ s/ \s* $nobreak \s* / /xg;

    # Split the input into segments that are breakable between them.
    my @segments = split /\s*$breakable\s*/, $template;

    my $string = "";
    my $display_string = "";
    my @should_match;
    my @should_display;

    # Convert the code point sequence in each segment into a Perl string of
    # characters
    foreach my $segment (@segments) {
        my @code_points = split /\s+/, $segment;
        my $this_string = "";
        my $this_display = "";
        foreach my $code_point (@code_points) {
            my $ord = ASCII_ord_to_native(hex $code_point);
            if ($ord < 0) {
                $Tests++;
                print "ok $Tests - String containing $code_point =~ /(\\X)/g # Skipped: non-ASCII\n";
                return;
            }
            $this_string .= chr $ord;
            $this_display .= "\\x{$code_point}";
        }

        # The next cluster should match the string in this segment.
        push @should_match, $this_string;
        push @should_display, $this_display;
        $string .= $this_string;
        $display_string .= $this_display;
    }

    # If a string can be represented in both non-ut8 and utf8, test both cases
    UPGRADE:
    for my $to_upgrade (0 .. 1) {

        if ($to_upgrade) {

            # If already in utf8, would just be a repeat
            next UPGRADE if utf8::is_utf8($string);

            utf8::upgrade($string);
        }

        # Finally, do the \X match.
        my @matches = $string =~ /(\X)/g;

        # Look through each matched cluster to verify that it matches what we
        # expect.
        my $min = (@matches < @should_match) ? @matches : @should_match;
        for my $i (0 .. $min - 1) {
            $Tests++;
            if ($matches[$i] eq $should_match[$i]) {
                print "ok $Tests - ";
                if ($i == 0) {
                    print "In \"$display_string\" =~ /(\\X)/g, \\X #1";
                } else {
                    print "And \\X #", $i + 1,
                }
                print " correctly matched $should_display[$i]; line $line\n";
            } else {
                $matches[$i] = join("", map { sprintf "\\x{%04X}", $_ }
                                                    unpack("U*", $matches[$i]));
                print "not ok $Tests - In \"$display_string\" =~ /(\\X)/g, \\X #",
                    $i + 1,
                    " should have matched $should_display[$i]",
                    " but instead matched $matches[$i]",
                    ".  Abandoning rest of line $line\n";
                next UPGRADE;
            }
        }

        # And the number of matches should equal the number of expected matches.
        $Tests++;
        if (@matches == @should_match) {
            print "ok $Tests - Nothing was left over; line $line\n";
        } else {
            print "not ok $Tests - There were ", scalar @should_match, " \\X matches expected, but got ", scalar @matches, " instead; line $line\n";
        }
    }

    return;
}

sub Finished() {
    print "1..$Tests\n";
    exit($Fails ? -1 : 0);
}

Error('\p{Script=InGreek}');    # Bug #69018
Test_X("1100 $nobreak 1161");  # Bug #70940
Expect(0, 0x2028, '\p{Print}', ""); # Bug # 71722
Expect(0, 0x2029, '\p{Print}', ""); # Bug # 71722
Expect(1, 0xFF10, '\p{XDigit}', ""); # Bug # 71726
Error('\p{Other_Lowercase:--YES/a/}');
Error('\P{Other_Lowercase:--YES/a/}');
Expect(1, 696, '\p{Other_Lowercase=yes}', 'deprecated');
Expect(0, 696, '\p{^Other_Lowercase=yes}', 'deprecated');
Expect(0, 696, '\P{Other_Lowercase=yes}', 'deprecated');
Expect(1, 696, '\P{^Other_Lowercase=yes}', 'deprecated');
Expect(0, 687, '\p{Other_Lowercase=yes}', 'deprecated');
Expect(1, 687, '\p{^Other_Lowercase=yes}', 'deprecated');
Expect(1, 687, '\P{Other_Lowercase=yes}', 'deprecated');
Expect(0, 687, '\P{^Other_Lowercase=yes}', 'deprecated');
Expect(1, 696, '\p{Other_Lowercase= YES}', 'deprecated');
Expect(0, 696, '\p{^Other_Lowercase= YES}', 'deprecated');
Expect(0, 696, '\P{Other_Lowercase= YES}', 'deprecated');
Expect(1, 696, '\P{^Other_Lowercase= YES}', 'deprecated');
Expect(0, 687, '\p{Other_Lowercase= YES}', 'deprecated');
Expect(1, 687, '\p{^Other_Lowercase= YES}', 'deprecated');
Expect(1, 687, '\P{Other_Lowercase= YES}', 'deprecated');
Expect(0, 687, '\P{^Other_Lowercase= YES}', 'deprecated');
Error('\p{OLower: :=	Y}');
Error('\P{OLower: :=	Y}');
Expect(1, 696, '\p{OLower: y}', 'deprecated');
Expect(0, 696, '\p{^OLower: y}', 'deprecated');
Expect(0, 696, '\P{OLower: y}', 'deprecated');
Expect(1, 696, '\P{^OLower: y}', 'deprecated');
Expect(0, 687, '\p{OLower: y}', 'deprecated');
Expect(1, 687, '\p{^OLower: y}', 'deprecated');
Expect(1, 687, '\P{OLower: y}', 'deprecated');
Expect(0, 687, '\P{^OLower: y}', 'deprecated');
Expect(1, 696, '\p{OLower=  Y}', 'deprecated');
Expect(0, 696, '\p{^OLower=  Y}', 'deprecated');
Expect(0, 696, '\P{OLower=  Y}', 'deprecated');
Expect(1, 696, '\P{^OLower=  Y}', 'deprecated');
Expect(0, 687, '\p{OLower=  Y}', 'deprecated');
Expect(1, 687, '\p{^OLower=  Y}', 'deprecated');
Expect(1, 687, '\P{OLower=  Y}', 'deprecated');
Expect(0, 687, '\P{^OLower=  Y}', 'deprecated');
Error('\p{Is_Other_Lowercase=_:=T}');
Error('\P{Is_Other_Lowercase=_:=T}');
Expect(1, 696, '\p{Is_Other_Lowercase=t}', 'deprecated');
Expect(0, 696, '\p{^Is_Other_Lowercase=t}', 'deprecated');
Expect(0, 696, '\P{Is_Other_Lowercase=t}', 'deprecated');
Expect(1, 696, '\P{^Is_Other_Lowercase=t}', 'deprecated');
Expect(0, 687, '\p{Is_Other_Lowercase=t}', 'deprecated');
Expect(1, 687, '\p{^Is_Other_Lowercase=t}', 'deprecated');
Expect(1, 687, '\P{Is_Other_Lowercase=t}', 'deprecated');
Expect(0, 687, '\P{^Is_Other_Lowercase=t}', 'deprecated');
Expect(1, 696, '\p{Is_Other_Lowercase=_-t}', 'deprecated');
Expect(0, 696, '\p{^Is_Other_Lowercase=_-t}', 'deprecated');
Expect(0, 696, '\P{Is_Other_Lowercase=_-t}', 'deprecated');
Expect(1, 696, '\P{^Is_Other_Lowercase=_-t}', 'deprecated');
Expect(0, 687, '\p{Is_Other_Lowercase=_-t}', 'deprecated');
Expect(1, 687, '\p{^Is_Other_Lowercase=_-t}', 'deprecated');
Expect(1, 687, '\P{Is_Other_Lowercase=_-t}', 'deprecated');
Expect(0, 687, '\P{^Is_Other_Lowercase=_-t}', 'deprecated');
Error('\p{Is_OLower=-/a/true}');
Error('\P{Is_OLower=-/a/true}');
Expect(1, 696, '\p{Is_OLower=true}', 'deprecated');
Expect(0, 696, '\p{^Is_OLower=true}', 'deprecated');
Expect(0, 696, '\P{Is_OLower=true}', 'deprecated');
Expect(1, 696, '\P{^Is_OLower=true}', 'deprecated');
Expect(0, 687, '\p{Is_OLower=true}', 'deprecated');
Expect(1, 687, '\p{^Is_OLower=true}', 'deprecated');
Expect(1, 687, '\P{Is_OLower=true}', 'deprecated');
Expect(0, 687, '\P{^Is_OLower=true}', 'deprecated');
Expect(1, 696, '\p{Is_OLower= True}', 'deprecated');
Expect(0, 696, '\p{^Is_OLower= True}', 'deprecated');
Expect(0, 696, '\P{Is_OLower= True}', 'deprecated');
Expect(1, 696, '\P{^Is_OLower= True}', 'deprecated');
Expect(0, 687, '\p{Is_OLower= True}', 'deprecated');
Expect(1, 687, '\p{^Is_OLower= True}', 'deprecated');
Expect(1, 687, '\P{Is_OLower= True}', 'deprecated');
Expect(0, 687, '\P{^Is_OLower= True}', 'deprecated');
Error('\p{Other_Lowercase=/a/ 	no}');
Error('\P{Other_Lowercase=/a/ 	no}');
Expect(1, 687, '\p{Other_Lowercase=no}', 'deprecated');
Expect(0, 687, '\p{^Other_Lowercase=no}', 'deprecated');
Expect(0, 687, '\P{Other_Lowercase=no}', 'deprecated');
Expect(1, 687, '\P{^Other_Lowercase=no}', 'deprecated');
Expect(0, 696, '\p{Other_Lowercase=no}', 'deprecated');
Expect(1, 696, '\p{^Other_Lowercase=no}', 'deprecated');
Expect(1, 696, '\P{Other_Lowercase=no}', 'deprecated');
Expect(0, 696, '\P{^Other_Lowercase=no}', 'deprecated');
Expect(1, 687, '\p{Other_Lowercase= -No}', 'deprecated');
Expect(0, 687, '\p{^Other_Lowercase= -No}', 'deprecated');
Expect(0, 687, '\P{Other_Lowercase= -No}', 'deprecated');
Expect(1, 687, '\P{^Other_Lowercase= -No}', 'deprecated');
Expect(0, 696, '\p{Other_Lowercase= -No}', 'deprecated');
Expect(1, 696, '\p{^Other_Lowercase= -No}', 'deprecated');
Expect(1, 696, '\P{Other_Lowercase= -No}', 'deprecated');
Expect(0, 696, '\P{^Other_Lowercase= -No}', 'deprecated');
Error('\p{OLower=:=	n}');
Error('\P{OLower=:=	n}');
Expect(1, 687, '\p{OLower=n}', 'deprecated');
Expect(0, 687, '\p{^OLower=n}', 'deprecated');
Expect(0, 687, '\P{OLower=n}', 'deprecated');
Expect(1, 687, '\P{^OLower=n}', 'deprecated');
Expect(0, 696, '\p{OLower=n}', 'deprecated');
Expect(1, 696, '\p{^OLower=n}', 'deprecated');
Expect(1, 696, '\P{OLower=n}', 'deprecated');
Expect(0, 696, '\P{^OLower=n}', 'deprecated');
Expect(1, 687, '\p{OLower=-N}', 'deprecated');
Expect(0, 687, '\p{^OLower=-N}', 'deprecated');
Expect(0, 687, '\P{OLower=-N}', 'deprecated');
Expect(1, 687, '\P{^OLower=-N}', 'deprecated');
Expect(0, 696, '\p{OLower=-N}', 'deprecated');
Expect(1, 696, '\p{^OLower=-N}', 'deprecated');
Expect(1, 696, '\P{OLower=-N}', 'deprecated');
Expect(0, 696, '\P{^OLower=-N}', 'deprecated');
Error('\p{Is_Other_Lowercase=/a/	-F}');
Error('\P{Is_Other_Lowercase=/a/	-F}');
Expect(1, 687, '\p{Is_Other_Lowercase=f}', 'deprecated');
Expect(0, 687, '\p{^Is_Other_Lowercase=f}', 'deprecated');
Expect(0, 687, '\P{Is_Other_Lowercase=f}', 'deprecated');
Expect(1, 687, '\P{^Is_Other_Lowercase=f}', 'deprecated');
Expect(0, 696, '\p{Is_Other_Lowercase=f}', 'deprecated');
Expect(1, 696, '\p{^Is_Other_Lowercase=f}', 'deprecated');
Expect(1, 696, '\P{Is_Other_Lowercase=f}', 'deprecated');
Expect(0, 696, '\P{^Is_Other_Lowercase=f}', 'deprecated');
Expect(1, 687, '\p{Is_Other_Lowercase=		F}', 'deprecated');
Expect(0, 687, '\p{^Is_Other_Lowercase=		F}', 'deprecated');
Expect(0, 687, '\P{Is_Other_Lowercase=		F}', 'deprecated');
Expect(1, 687, '\P{^Is_Other_Lowercase=		F}', 'deprecated');
Expect(0, 696, '\p{Is_Other_Lowercase=		F}', 'deprecated');
Expect(1, 696, '\p{^Is_Other_Lowercase=		F}', 'deprecated');
Expect(1, 696, '\P{Is_Other_Lowercase=		F}', 'deprecated');
Expect(0, 696, '\P{^Is_Other_Lowercase=		F}', 'deprecated');
Error('\p{Is_OLower=/a/__False}');
Error('\P{Is_OLower=/a/__False}');
Expect(1, 687, '\p{Is_OLower=false}', 'deprecated');
Expect(0, 687, '\p{^Is_OLower=false}', 'deprecated');
Expect(0, 687, '\P{Is_OLower=false}', 'deprecated');
Expect(1, 687, '\P{^Is_OLower=false}', 'deprecated');
Expect(0, 696, '\p{Is_OLower=false}', 'deprecated');
Expect(1, 696, '\p{^Is_OLower=false}', 'deprecated');
Expect(1, 696, '\P{Is_OLower=false}', 'deprecated');
Expect(0, 696, '\P{^Is_OLower=false}', 'deprecated');
Expect(1, 687, '\p{Is_OLower=_ FALSE}', 'deprecated');
Expect(0, 687, '\p{^Is_OLower=_ FALSE}', 'deprecated');
Expect(0, 687, '\P{Is_OLower=_ FALSE}', 'deprecated');
Expect(1, 687, '\P{^Is_OLower=_ FALSE}', 'deprecated');
Expect(0, 696, '\p{Is_OLower=_ FALSE}', 'deprecated');
Expect(1, 696, '\p{^Is_OLower=_ FALSE}', 'deprecated');
Expect(1, 696, '\P{Is_OLower=_ FALSE}', 'deprecated');
Expect(0, 696, '\P{^Is_OLower=_ FALSE}', 'deprecated');
Error('\p{Variation_Selector=/a/_Yes}');
Error('\P{Variation_Selector=/a/_Yes}');
Expect(1, 6157, '\p{Variation_Selector=yes}', "");
Expect(0, 6157, '\p{^Variation_Selector=yes}', "");
Expect(0, 6157, '\P{Variation_Selector=yes}', "");
Expect(1, 6157, '\P{^Variation_Selector=yes}', "");
Expect(0, 6154, '\p{Variation_Selector=yes}', "");
Expect(1, 6154, '\p{^Variation_Selector=yes}', "");
Expect(1, 6154, '\P{Variation_Selector=yes}', "");
Expect(0, 6154, '\P{^Variation_Selector=yes}', "");
Expect(1, 6157, '\p{Variation_Selector= 	yes}', "");
Expect(0, 6157, '\p{^Variation_Selector= 	yes}', "");
Expect(0, 6157, '\P{Variation_Selector= 	yes}', "");
Expect(1, 6157, '\P{^Variation_Selector= 	yes}', "");
Expect(0, 6154, '\p{Variation_Selector= 	yes}', "");
Expect(1, 6154, '\p{^Variation_Selector= 	yes}', "");
Expect(1, 6154, '\P{Variation_Selector= 	yes}', "");
Expect(0, 6154, '\P{^Variation_Selector= 	yes}', "");
Error('\p{VS=_ Y/a/}');
Error('\P{VS=_ Y/a/}');
Expect(1, 6157, '\p{VS=y}', "");
Expect(0, 6157, '\p{^VS=y}', "");
Expect(0, 6157, '\P{VS=y}', "");
Expect(1, 6157, '\P{^VS=y}', "");
Expect(0, 6154, '\p{VS=y}', "");
Expect(1, 6154, '\p{^VS=y}', "");
Expect(1, 6154, '\P{VS=y}', "");
Expect(0, 6154, '\P{^VS=y}', "");
Expect(1, 6157, '\p{VS=_Y}', "");
Expect(0, 6157, '\p{^VS=_Y}', "");
Expect(0, 6157, '\P{VS=_Y}', "");
Expect(1, 6157, '\P{^VS=_Y}', "");
Expect(0, 6154, '\p{VS=_Y}', "");
Expect(1, 6154, '\p{^VS=_Y}', "");
Expect(1, 6154, '\P{VS=_Y}', "");
Expect(0, 6154, '\P{^VS=_Y}', "");
Error('\p{Is_Variation_Selector=:=-	T}');
Error('\P{Is_Variation_Selector=:=-	T}');
Expect(1, 6157, '\p{Is_Variation_Selector:   t}', "");
Expect(0, 6157, '\p{^Is_Variation_Selector:   t}', "");
Expect(0, 6157, '\P{Is_Variation_Selector:   t}', "");
Expect(1, 6157, '\P{^Is_Variation_Selector:   t}', "");
Expect(0, 6154, '\p{Is_Variation_Selector:   t}', "");
Expect(1, 6154, '\p{^Is_Variation_Selector:   t}', "");
Expect(1, 6154, '\P{Is_Variation_Selector:   t}', "");
Expect(0, 6154, '\P{^Is_Variation_Selector:   t}', "");
Expect(1, 6157, '\p{Is_Variation_Selector= _T}', "");
Expect(0, 6157, '\p{^Is_Variation_Selector= _T}', "");
Expect(0, 6157, '\P{Is_Variation_Selector= _T}', "");
Expect(1, 6157, '\P{^Is_Variation_Selector= _T}', "");
Expect(0, 6154, '\p{Is_Variation_Selector= _T}', "");
Expect(1, 6154, '\p{^Is_Variation_Selector= _T}', "");
Expect(1, 6154, '\P{Is_Variation_Selector= _T}', "");
Expect(0, 6154, '\P{^Is_Variation_Selector= _T}', "");
Error('\p{Is_VS=_ TRUE/a/}');
Error('\P{Is_VS=_ TRUE/a/}');
Expect(1, 6157, '\p{Is_VS=true}', "");
Expect(0, 6157, '\p{^Is_VS=true}', "");
Expect(0, 6157, '\P{Is_VS=true}', "");
Expect(1, 6157, '\P{^Is_VS=true}', "");
Expect(0, 6154, '\p{Is_VS=true}', "");
Expect(1, 6154, '\p{^Is_VS=true}', "");
Expect(1, 6154, '\P{Is_VS=true}', "");
Expect(0, 6154, '\P{^Is_VS=true}', "");
Expect(1, 6157, '\p{Is_VS= 	True}', "");
Expect(0, 6157, '\p{^Is_VS= 	True}', "");
Expect(0, 6157, '\P{Is_VS= 	True}', "");
Expect(1, 6157, '\P{^Is_VS= 	True}', "");
Expect(0, 6154, '\p{Is_VS= 	True}', "");
Expect(1, 6154, '\p{^Is_VS= 	True}', "");
Expect(1, 6154, '\P{Is_VS= 	True}', "");
Expect(0, 6154, '\P{^Is_VS= 	True}', "");
Error('\p{Variation_Selector=/a/ -No}');
Error('\P{Variation_Selector=/a/ -No}');
Expect(1, 6154, '\p{Variation_Selector=no}', "");
Expect(0, 6154, '\p{^Variation_Selector=no}', "");
Expect(0, 6154, '\P{Variation_Selector=no}', "");
Expect(1, 6154, '\P{^Variation_Selector=no}', "");
Expect(0, 6157, '\p{Variation_Selector=no}', "");
Expect(1, 6157, '\p{^Variation_Selector=no}', "");
Expect(1, 6157, '\P{Variation_Selector=no}', "");
Expect(0, 6157, '\P{^Variation_Selector=no}', "");
Expect(1, 6154, '\p{Variation_Selector=_-no}', "");
Expect(0, 6154, '\p{^Variation_Selector=_-no}', "");
Expect(0, 6154, '\P{Variation_Selector=_-no}', "");
Expect(1, 6154, '\P{^Variation_Selector=_-no}', "");
Expect(0, 6157, '\p{Variation_Selector=_-no}', "");
Expect(1, 6157, '\p{^Variation_Selector=_-no}', "");
Expect(1, 6157, '\P{Variation_Selector=_-no}', "");
Expect(0, 6157, '\P{^Variation_Selector=_-no}', "");
Error('\p{VS=/a/-	N}');
Error('\P{VS=/a/-	N}');
Expect(1, 6154, '\p{VS=n}', "");
Expect(0, 6154, '\p{^VS=n}', "");
Expect(0, 6154, '\P{VS=n}', "");
Expect(1, 6154, '\P{^VS=n}', "");
Expect(0, 6157, '\p{VS=n}', "");
Expect(1, 6157, '\p{^VS=n}', "");
Expect(1, 6157, '\P{VS=n}', "");
Expect(0, 6157, '\P{^VS=n}', "");
Expect(1, 6154, '\p{VS=-	n}', "");
Expect(0, 6154, '\p{^VS=-	n}', "");
Expect(0, 6154, '\P{VS=-	n}', "");
Expect(1, 6154, '\P{^VS=-	n}', "");
Expect(0, 6157, '\p{VS=-	n}', "");
Expect(1, 6157, '\p{^VS=-	n}', "");
Expect(1, 6157, '\P{VS=-	n}', "");
Expect(0, 6157, '\P{^VS=-	n}', "");
Error('\p{Is_Variation_Selector=	-F/a/}');
Error('\P{Is_Variation_Selector=	-F/a/}');
Expect(1, 6154, '\p{Is_Variation_Selector=f}', "");
Expect(0, 6154, '\p{^Is_Variation_Selector=f}', "");
Expect(0, 6154, '\P{Is_Variation_Selector=f}', "");
Expect(1, 6154, '\P{^Is_Variation_Selector=f}', "");
Expect(0, 6157, '\p{Is_Variation_Selector=f}', "");
Expect(1, 6157, '\p{^Is_Variation_Selector=f}', "");
Expect(1, 6157, '\P{Is_Variation_Selector=f}', "");
Expect(0, 6157, '\P{^Is_Variation_Selector=f}', "");
Expect(1, 6154, '\p{Is_Variation_Selector= F}', "");
Expect(0, 6154, '\p{^Is_Variation_Selector= F}', "");
Expect(0, 6154, '\P{Is_Variation_Selector= F}', "");
Expect(1, 6154, '\P{^Is_Variation_Selector= F}', "");
Expect(0, 6157, '\p{Is_Variation_Selector= F}', "");
Expect(1, 6157, '\p{^Is_Variation_Selector= F}', "");
Expect(1, 6157, '\P{Is_Variation_Selector= F}', "");
Expect(0, 6157, '\P{^Is_Variation_Selector= F}', "");
Error('\p{Is_VS=-:=False}');
Error('\P{Is_VS=-:=False}');
Expect(1, 6154, '\p{Is_VS=false}', "");
Expect(0, 6154, '\p{^Is_VS=false}', "");
Expect(0, 6154, '\P{Is_VS=false}', "");
Expect(1, 6154, '\P{^Is_VS=false}', "");
Expect(0, 6157, '\p{Is_VS=false}', "");
Expect(1, 6157, '\p{^Is_VS=false}', "");
Expect(1, 6157, '\P{Is_VS=false}', "");
Expect(0, 6157, '\P{^Is_VS=false}', "");
Expect(1, 6154, '\p{Is_VS=_-False}', "");
Expect(0, 6154, '\p{^Is_VS=_-False}', "");
Expect(0, 6154, '\P{Is_VS=_-False}', "");
Expect(1, 6154, '\P{^Is_VS=_-False}', "");
Expect(0, 6157, '\p{Is_VS=_-False}', "");
Expect(1, 6157, '\p{^Is_VS=_-False}', "");
Expect(1, 6157, '\P{Is_VS=_-False}', "");
Expect(0, 6157, '\P{^Is_VS=_-False}', "");
Error('\p{Full_Composition_Exclusion=	/a/Yes}');
Error('\P{Full_Composition_Exclusion=	/a/Yes}');
Expect(1, 833, '\p{Full_Composition_Exclusion=yes}', "");
Expect(0, 833, '\p{^Full_Composition_Exclusion=yes}', "");
Expect(0, 833, '\P{Full_Composition_Exclusion=yes}', "");
Expect(1, 833, '\P{^Full_Composition_Exclusion=yes}', "");
Expect(0, 831, '\p{Full_Composition_Exclusion=yes}', "");
Expect(1, 831, '\p{^Full_Composition_Exclusion=yes}', "");
Expect(1, 831, '\P{Full_Composition_Exclusion=yes}', "");
Expect(0, 831, '\P{^Full_Composition_Exclusion=yes}', "");
Expect(1, 833, '\p{Full_Composition_Exclusion=-Yes}', "");
Expect(0, 833, '\p{^Full_Composition_Exclusion=-Yes}', "");
Expect(0, 833, '\P{Full_Composition_Exclusion=-Yes}', "");
Expect(1, 833, '\P{^Full_Composition_Exclusion=-Yes}', "");
Expect(0, 831, '\p{Full_Composition_Exclusion=-Yes}', "");
Expect(1, 831, '\p{^Full_Composition_Exclusion=-Yes}', "");
Expect(1, 831, '\P{Full_Composition_Exclusion=-Yes}', "");
Expect(0, 831, '\P{^Full_Composition_Exclusion=-Yes}', "");
Error('\p{Comp_Ex=	 Y/a/}');
Error('\P{Comp_Ex=	 Y/a/}');
Expect(1, 833, '\p{Comp_Ex=y}', "");
Expect(0, 833, '\p{^Comp_Ex=y}', "");
Expect(0, 833, '\P{Comp_Ex=y}', "");
Expect(1, 833, '\P{^Comp_Ex=y}', "");
Expect(0, 831, '\p{Comp_Ex=y}', "");
Expect(1, 831, '\p{^Comp_Ex=y}', "");
Expect(1, 831, '\P{Comp_Ex=y}', "");
Expect(0, 831, '\P{^Comp_Ex=y}', "");
Expect(1, 833, '\p{Comp_Ex= Y}', "");
Expect(0, 833, '\p{^Comp_Ex= Y}', "");
Expect(0, 833, '\P{Comp_Ex= Y}', "");
Expect(1, 833, '\P{^Comp_Ex= Y}', "");
Expect(0, 831, '\p{Comp_Ex= Y}', "");
Expect(1, 831, '\p{^Comp_Ex= Y}', "");
Expect(1, 831, '\P{Comp_Ex= Y}', "");
Expect(0, 831, '\P{^Comp_Ex= Y}', "");
Error('\p{Is_Full_Composition_Exclusion=-	T:=}');
Error('\P{Is_Full_Composition_Exclusion=-	T:=}');
Expect(1, 833, '\p{Is_Full_Composition_Exclusion=t}', "");
Expect(0, 833, '\p{^Is_Full_Composition_Exclusion=t}', "");
Expect(0, 833, '\P{Is_Full_Composition_Exclusion=t}', "");
Expect(1, 833, '\P{^Is_Full_Composition_Exclusion=t}', "");
Expect(0, 831, '\p{Is_Full_Composition_Exclusion=t}', "");
Expect(1, 831, '\p{^Is_Full_Composition_Exclusion=t}', "");
Expect(1, 831, '\P{Is_Full_Composition_Exclusion=t}', "");
Expect(0, 831, '\P{^Is_Full_Composition_Exclusion=t}', "");
Expect(1, 833, '\p{Is_Full_Composition_Exclusion=	T}', "");
Expect(0, 833, '\p{^Is_Full_Composition_Exclusion=	T}', "");
Expect(0, 833, '\P{Is_Full_Composition_Exclusion=	T}', "");
Expect(1, 833, '\P{^Is_Full_Composition_Exclusion=	T}', "");
Expect(0, 831, '\p{Is_Full_Composition_Exclusion=	T}', "");
Expect(1, 831, '\p{^Is_Full_Composition_Exclusion=	T}', "");
Expect(1, 831, '\P{Is_Full_Composition_Exclusion=	T}', "");
Expect(0, 831, '\P{^Is_Full_Composition_Exclusion=	T}', "");
Error('\p{Is_Comp_Ex=/a/_-TRUE}');
Error('\P{Is_Comp_Ex=/a/_-TRUE}');
Expect(1, 833, '\p{Is_Comp_Ex=true}', "");
Expect(0, 833, '\p{^Is_Comp_Ex=true}', "");
Expect(0, 833, '\P{Is_Comp_Ex=true}', "");
Expect(1, 833, '\P{^Is_Comp_Ex=true}', "");
Expect(0, 831, '\p{Is_Comp_Ex=true}', "");
Expect(1, 831, '\p{^Is_Comp_Ex=true}', "");
Expect(1, 831, '\P{Is_Comp_Ex=true}', "");
Expect(0, 831, '\P{^Is_Comp_Ex=true}', "");
Expect(1, 833, '\p{Is_Comp_Ex=  TRUE}', "");
Expect(0, 833, '\p{^Is_Comp_Ex=  TRUE}', "");
Expect(0, 833, '\P{Is_Comp_Ex=  TRUE}', "");
Expect(1, 833, '\P{^Is_Comp_Ex=  TRUE}', "");
Expect(0, 831, '\p{Is_Comp_Ex=  TRUE}', "");
Expect(1, 831, '\p{^Is_Comp_Ex=  TRUE}', "");
Expect(1, 831, '\P{Is_Comp_Ex=  TRUE}', "");
Expect(0, 831, '\P{^Is_Comp_Ex=  TRUE}', "");
Error('\p{Full_Composition_Exclusion:	--no/a/}');
Error('\P{Full_Composition_Exclusion:	--no/a/}');
Expect(1, 831, '\p{Full_Composition_Exclusion=no}', "");
Expect(0, 831, '\p{^Full_Composition_Exclusion=no}', "");
Expect(0, 831, '\P{Full_Composition_Exclusion=no}', "");
Expect(1, 831, '\P{^Full_Composition_Exclusion=no}', "");
Expect(0, 833, '\p{Full_Composition_Exclusion=no}', "");
Expect(1, 833, '\p{^Full_Composition_Exclusion=no}', "");
Expect(1, 833, '\P{Full_Composition_Exclusion=no}', "");
Expect(0, 833, '\P{^Full_Composition_Exclusion=no}', "");
Expect(1, 831, '\p{Full_Composition_Exclusion=--No}', "");
Expect(0, 831, '\p{^Full_Composition_Exclusion=--No}', "");
Expect(0, 831, '\P{Full_Composition_Exclusion=--No}', "");
Expect(1, 831, '\P{^Full_Composition_Exclusion=--No}', "");
Expect(0, 833, '\p{Full_Composition_Exclusion=--No}', "");
Expect(1, 833, '\p{^Full_Composition_Exclusion=--No}', "");
Expect(1, 833, '\P{Full_Composition_Exclusion=--No}', "");
Expect(0, 833, '\P{^Full_Composition_Exclusion=--No}', "");
Error('\p{Comp_Ex=-_N:=}');
Error('\P{Comp_Ex=-_N:=}');
Expect(1, 831, '\p{Comp_Ex=n}', "");
Expect(0, 831, '\p{^Comp_Ex=n}', "");
Expect(0, 831, '\P{Comp_Ex=n}', "");
Expect(1, 831, '\P{^Comp_Ex=n}', "");
Expect(0, 833, '\p{Comp_Ex=n}', "");
Expect(1, 833, '\p{^Comp_Ex=n}', "");
Expect(1, 833, '\P{Comp_Ex=n}', "");
Expect(0, 833, '\P{^Comp_Ex=n}', "");
Expect(1, 831, '\p{Comp_Ex=	 n}', "");
Expect(0, 831, '\p{^Comp_Ex=	 n}', "");
Expect(0, 831, '\P{Comp_Ex=	 n}', "");
Expect(1, 831, '\P{^Comp_Ex=	 n}', "");
Expect(0, 833, '\p{Comp_Ex=	 n}', "");
Expect(1, 833, '\p{^Comp_Ex=	 n}', "");
Expect(1, 833, '\P{Comp_Ex=	 n}', "");
Expect(0, 833, '\P{^Comp_Ex=	 n}', "");
Error('\p{Is_Full_Composition_Exclusion=:=F}');
Error('\P{Is_Full_Composition_Exclusion=:=F}');
Expect(1, 831, '\p{Is_Full_Composition_Exclusion=f}', "");
Expect(0, 831, '\p{^Is_Full_Composition_Exclusion=f}', "");
Expect(0, 831, '\P{Is_Full_Composition_Exclusion=f}', "");
Expect(1, 831, '\P{^Is_Full_Composition_Exclusion=f}', "");
Expect(0, 833, '\p{Is_Full_Composition_Exclusion=f}', "");
Expect(1, 833, '\p{^Is_Full_Composition_Exclusion=f}', "");
Expect(1, 833, '\P{Is_Full_Composition_Exclusion=f}', "");
Expect(0, 833, '\P{^Is_Full_Composition_Exclusion=f}', "");
Error('\p{Is_Comp_Ex=/a/  False}');
Error('\P{Is_Comp_Ex=/a/  False}');
Expect(1, 831, '\p{Is_Comp_Ex=false}', "");
Expect(0, 831, '\p{^Is_Comp_Ex=false}', "");
Expect(0, 831, '\P{Is_Comp_Ex=false}', "");
Expect(1, 831, '\P{^Is_Comp_Ex=false}', "");
Expect(0, 833, '\p{Is_Comp_Ex=false}', "");
Expect(1, 833, '\p{^Is_Comp_Ex=false}', "");
Expect(1, 833, '\P{Is_Comp_Ex=false}', "");
Expect(0, 833, '\P{^Is_Comp_Ex=false}', "");
Expect(1, 831, '\p{Is_Comp_Ex=	False}', "");
Expect(0, 831, '\p{^Is_Comp_Ex=	False}', "");
Expect(0, 831, '\P{Is_Comp_Ex=	False}', "");
Expect(1, 831, '\P{^Is_Comp_Ex=	False}', "");
Expect(0, 833, '\p{Is_Comp_Ex=	False}', "");
Expect(1, 833, '\p{^Is_Comp_Ex=	False}', "");
Expect(1, 833, '\P{Is_Comp_Ex=	False}', "");
Expect(0, 833, '\P{^Is_Comp_Ex=	False}', "");
Error('\p{Changes_When_NFKC_Casefolded=	Yes/a/}');
Error('\P{Changes_When_NFKC_Casefolded=	Yes/a/}');
Expect(1, 90, '\p{Changes_When_NFKC_Casefolded=yes}', "");
Expect(0, 90, '\p{^Changes_When_NFKC_Casefolded=yes}', "");
Expect(0, 90, '\P{Changes_When_NFKC_Casefolded=yes}', "");
Expect(1, 90, '\P{^Changes_When_NFKC_Casefolded=yes}', "");
Expect(0, 64, '\p{Changes_When_NFKC_Casefolded=yes}', "");
Expect(1, 64, '\p{^Changes_When_NFKC_Casefolded=yes}', "");
Expect(1, 64, '\P{Changes_When_NFKC_Casefolded=yes}', "");
Expect(0, 64, '\P{^Changes_When_NFKC_Casefolded=yes}', "");
Expect(1, 90, '\p{Changes_When_NFKC_Casefolded=- Yes}', "");
Expect(0, 90, '\p{^Changes_When_NFKC_Casefolded=- Yes}', "");
Expect(0, 90, '\P{Changes_When_NFKC_Casefolded=- Yes}', "");
Expect(1, 90, '\P{^Changes_When_NFKC_Casefolded=- Yes}', "");
Expect(0, 64, '\p{Changes_When_NFKC_Casefolded=- Yes}', "");
Expect(1, 64, '\p{^Changes_When_NFKC_Casefolded=- Yes}', "");
Expect(1, 64, '\P{Changes_When_NFKC_Casefolded=- Yes}', "");
Expect(0, 64, '\P{^Changes_When_NFKC_Casefolded=- Yes}', "");
Error('\p{CWKCF=_/a/Y}');
Error('\P{CWKCF=_/a/Y}');
Expect(1, 90, '\p{CWKCF:	y}', "");
Expect(0, 90, '\p{^CWKCF:	y}', "");
Expect(0, 90, '\P{CWKCF:	y}', "");
Expect(1, 90, '\P{^CWKCF:	y}', "");
Expect(0, 64, '\p{CWKCF:	y}', "");
Expect(1, 64, '\p{^CWKCF:	y}', "");
Expect(1, 64, '\P{CWKCF:	y}', "");
Expect(0, 64, '\P{^CWKCF:	y}', "");
Expect(1, 90, '\p{CWKCF=	-y}', "");
Expect(0, 90, '\p{^CWKCF=	-y}', "");
Expect(0, 90, '\P{CWKCF=	-y}', "");
Expect(1, 90, '\P{^CWKCF=	-y}', "");
Expect(0, 64, '\p{CWKCF=	-y}', "");
Expect(1, 64, '\p{^CWKCF=	-y}', "");
Expect(1, 64, '\P{CWKCF=	-y}', "");
Expect(0, 64, '\P{^CWKCF=	-y}', "");
Error('\p{Is_Changes_When_NFKC_Casefolded=	 T:=}');
Error('\P{Is_Changes_When_NFKC_Casefolded=	 T:=}');
Expect(1, 90, '\p{Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(0, 90, '\p{^Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(0, 90, '\P{Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(1, 90, '\P{^Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(0, 64, '\p{Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(1, 64, '\p{^Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(1, 64, '\P{Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(0, 64, '\P{^Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(1, 90, '\p{Is_Changes_When_NFKC_Casefolded=_t}', "");
Expect(0, 90, '\p{^Is_Changes_When_NFKC_Casefolded=_t}', "");
Expect(0, 90, '\P{Is_Changes_When_NFKC_Casefolded=_t}', "");
Expect(1, 90, '\P{^Is_Changes_When_NFKC_Casefolded=_t}', "");
Expect(0, 64, '\p{Is_Changes_When_NFKC_Casefolded=_t}', "");
Expect(1, 64, '\p{^Is_Changes_When_NFKC_Casefolded=_t}', "");
Expect(1, 64, '\P{Is_Changes_When_NFKC_Casefolded=_t}', "");
Expect(0, 64, '\P{^Is_Changes_When_NFKC_Casefolded=_t}', "");
Error('\p{Is_CWKCF=:=_ true}');
Error('\P{Is_CWKCF=:=_ true}');
Expect(1, 90, '\p{Is_CWKCF=true}', "");
Expect(0, 90, '\p{^Is_CWKCF=true}', "");
Expect(0, 90, '\P{Is_CWKCF=true}', "");
Expect(1, 90, '\P{^Is_CWKCF=true}', "");
Expect(0, 64, '\p{Is_CWKCF=true}', "");
Expect(1, 64, '\p{^Is_CWKCF=true}', "");
Expect(1, 64, '\P{Is_CWKCF=true}', "");
Expect(0, 64, '\P{^Is_CWKCF=true}', "");
Expect(1, 90, '\p{Is_CWKCF=__TRUE}', "");
Expect(0, 90, '\p{^Is_CWKCF=__TRUE}', "");
Expect(0, 90, '\P{Is_CWKCF=__TRUE}', "");
Expect(1, 90, '\P{^Is_CWKCF=__TRUE}', "");
Expect(0, 64, '\p{Is_CWKCF=__TRUE}', "");
Expect(1, 64, '\p{^Is_CWKCF=__TRUE}', "");
Expect(1, 64, '\P{Is_CWKCF=__TRUE}', "");
Expect(0, 64, '\P{^Is_CWKCF=__TRUE}', "");
Error('\p{Changes_When_NFKC_Casefolded=:=no}');
Error('\P{Changes_When_NFKC_Casefolded=:=no}');
Expect(1, 64, '\p{Changes_When_NFKC_Casefolded=no}', "");
Expect(0, 64, '\p{^Changes_When_NFKC_Casefolded=no}', "");
Expect(0, 64, '\P{Changes_When_NFKC_Casefolded=no}', "");
Expect(1, 64, '\P{^Changes_When_NFKC_Casefolded=no}', "");
Expect(0, 90, '\p{Changes_When_NFKC_Casefolded=no}', "");
Expect(1, 90, '\p{^Changes_When_NFKC_Casefolded=no}', "");
Expect(1, 90, '\P{Changes_When_NFKC_Casefolded=no}', "");
Expect(0, 90, '\P{^Changes_When_NFKC_Casefolded=no}', "");
Expect(1, 64, '\p{Changes_When_NFKC_Casefolded=-_No}', "");
Expect(0, 64, '\p{^Changes_When_NFKC_Casefolded=-_No}', "");
Expect(0, 64, '\P{Changes_When_NFKC_Casefolded=-_No}', "");
Expect(1, 64, '\P{^Changes_When_NFKC_Casefolded=-_No}', "");
Expect(0, 90, '\p{Changes_When_NFKC_Casefolded=-_No}', "");
Expect(1, 90, '\p{^Changes_When_NFKC_Casefolded=-_No}', "");
Expect(1, 90, '\P{Changes_When_NFKC_Casefolded=-_No}', "");
Expect(0, 90, '\P{^Changes_When_NFKC_Casefolded=-_No}', "");
Error('\p{CWKCF=N/a/}');
Error('\P{CWKCF=N/a/}');
Expect(1, 64, '\p{CWKCF=n}', "");
Expect(0, 64, '\p{^CWKCF=n}', "");
Expect(0, 64, '\P{CWKCF=n}', "");
Expect(1, 64, '\P{^CWKCF=n}', "");
Expect(0, 90, '\p{CWKCF=n}', "");
Expect(1, 90, '\p{^CWKCF=n}', "");
Expect(1, 90, '\P{CWKCF=n}', "");
Expect(0, 90, '\P{^CWKCF=n}', "");
Expect(1, 64, '\p{CWKCF= 	n}', "");
Expect(0, 64, '\p{^CWKCF= 	n}', "");
Expect(0, 64, '\P{CWKCF= 	n}', "");
Expect(1, 64, '\P{^CWKCF= 	n}', "");
Expect(0, 90, '\p{CWKCF= 	n}', "");
Expect(1, 90, '\p{^CWKCF= 	n}', "");
Expect(1, 90, '\P{CWKCF= 	n}', "");
Expect(0, 90, '\P{^CWKCF= 	n}', "");
Error('\p{Is_Changes_When_NFKC_Casefolded: 	F:=}');
Error('\P{Is_Changes_When_NFKC_Casefolded: 	F:=}');
Expect(1, 64, '\p{Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(0, 64, '\p{^Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(0, 64, '\P{Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(1, 64, '\P{^Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(0, 90, '\p{Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(1, 90, '\p{^Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(1, 90, '\P{Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(0, 90, '\P{^Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(1, 64, '\p{Is_Changes_When_NFKC_Casefolded=  F}', "");
Expect(0, 64, '\p{^Is_Changes_When_NFKC_Casefolded=  F}', "");
Expect(0, 64, '\P{Is_Changes_When_NFKC_Casefolded=  F}', "");
Expect(1, 64, '\P{^Is_Changes_When_NFKC_Casefolded=  F}', "");
Expect(0, 90, '\p{Is_Changes_When_NFKC_Casefolded=  F}', "");
Expect(1, 90, '\p{^Is_Changes_When_NFKC_Casefolded=  F}', "");
Expect(1, 90, '\P{Is_Changes_When_NFKC_Casefolded=  F}', "");
Expect(0, 90, '\P{^Is_Changes_When_NFKC_Casefolded=  F}', "");
Error('\p{Is_CWKCF=/a/ false}');
Error('\P{Is_CWKCF=/a/ false}');
Expect(1, 64, '\p{Is_CWKCF=false}', "");
Expect(0, 64, '\p{^Is_CWKCF=false}', "");
Expect(0, 64, '\P{Is_CWKCF=false}', "");
Expect(1, 64, '\P{^Is_CWKCF=false}', "");
Expect(0, 90, '\p{Is_CWKCF=false}', "");
Expect(1, 90, '\p{^Is_CWKCF=false}', "");
Expect(1, 90, '\P{Is_CWKCF=false}', "");
Expect(0, 90, '\P{^Is_CWKCF=false}', "");
Expect(1, 64, '\p{Is_CWKCF= -false}', "");
Expect(0, 64, '\p{^Is_CWKCF= -false}', "");
Expect(0, 64, '\P{Is_CWKCF= -false}', "");
Expect(1, 64, '\P{^Is_CWKCF= -false}', "");
Expect(0, 90, '\p{Is_CWKCF= -false}', "");
Expect(1, 90, '\p{^Is_CWKCF= -false}', "");
Expect(1, 90, '\P{Is_CWKCF= -false}', "");
Expect(0, 90, '\P{^Is_CWKCF= -false}', "");
Error('\p{NFKC_Quick_Check=	-yes:=}');
Error('\P{NFKC_Quick_Check=	-yes:=}');
Expect(1, 159, '\p{NFKC_Quick_Check=yes}', "");
Expect(0, 159, '\p{^NFKC_Quick_Check=yes}', "");
Expect(0, 159, '\P{NFKC_Quick_Check=yes}', "");
Expect(1, 159, '\P{^NFKC_Quick_Check=yes}', "");
Expect(0, 160, '\p{NFKC_Quick_Check=yes}', "");
Expect(1, 160, '\p{^NFKC_Quick_Check=yes}', "");
Expect(1, 160, '\P{NFKC_Quick_Check=yes}', "");
Expect(0, 160, '\P{^NFKC_Quick_Check=yes}', "");
Expect(1, 159, '\p{NFKC_Quick_Check=-	YES}', "");
Expect(0, 159, '\p{^NFKC_Quick_Check=-	YES}', "");
Expect(0, 159, '\P{NFKC_Quick_Check=-	YES}', "");
Expect(1, 159, '\P{^NFKC_Quick_Check=-	YES}', "");
Expect(0, 160, '\p{NFKC_Quick_Check=-	YES}', "");
Expect(1, 160, '\p{^NFKC_Quick_Check=-	YES}', "");
Expect(1, 160, '\P{NFKC_Quick_Check=-	YES}', "");
Expect(0, 160, '\P{^NFKC_Quick_Check=-	YES}', "");
Error('\p{NFKC_QC=/a/	 Y}');
Error('\P{NFKC_QC=/a/	 Y}');
Expect(1, 159, '\p{NFKC_QC=y}', "");
Expect(0, 159, '\p{^NFKC_QC=y}', "");
Expect(0, 159, '\P{NFKC_QC=y}', "");
Expect(1, 159, '\P{^NFKC_QC=y}', "");
Expect(0, 160, '\p{NFKC_QC=y}', "");
Expect(1, 160, '\p{^NFKC_QC=y}', "");
Expect(1, 160, '\P{NFKC_QC=y}', "");
Expect(0, 160, '\P{^NFKC_QC=y}', "");
Expect(1, 159, '\p{NFKC_QC=	 Y}', "");
Expect(0, 159, '\p{^NFKC_QC=	 Y}', "");
Expect(0, 159, '\P{NFKC_QC=	 Y}', "");
Expect(1, 159, '\P{^NFKC_QC=	 Y}', "");
Expect(0, 160, '\p{NFKC_QC=	 Y}', "");
Expect(1, 160, '\p{^NFKC_QC=	 Y}', "");
Expect(1, 160, '\P{NFKC_QC=	 Y}', "");
Expect(0, 160, '\P{^NFKC_QC=	 Y}', "");
Error('\p{Is_NFKC_Quick_Check=__Yes/a/}');
Error('\P{Is_NFKC_Quick_Check=__Yes/a/}');
Expect(1, 159, '\p{Is_NFKC_Quick_Check=yes}', "");
Expect(0, 159, '\p{^Is_NFKC_Quick_Check=yes}', "");
Expect(0, 159, '\P{Is_NFKC_Quick_Check=yes}', "");
Expect(1, 159, '\P{^Is_NFKC_Quick_Check=yes}', "");
Expect(0, 160, '\p{Is_NFKC_Quick_Check=yes}', "");
Expect(1, 160, '\p{^Is_NFKC_Quick_Check=yes}', "");
Expect(1, 160, '\P{Is_NFKC_Quick_Check=yes}', "");
Expect(0, 160, '\P{^Is_NFKC_Quick_Check=yes}', "");
Expect(1, 159, '\p{Is_NFKC_Quick_Check= yes}', "");
Expect(0, 159, '\p{^Is_NFKC_Quick_Check= yes}', "");
Expect(0, 159, '\P{Is_NFKC_Quick_Check= yes}', "");
Expect(1, 159, '\P{^Is_NFKC_Quick_Check= yes}', "");
Expect(0, 160, '\p{Is_NFKC_Quick_Check= yes}', "");
Expect(1, 160, '\p{^Is_NFKC_Quick_Check= yes}', "");
Expect(1, 160, '\P{Is_NFKC_Quick_Check= yes}', "");
Expect(0, 160, '\P{^Is_NFKC_Quick_Check= yes}', "");
Error('\p{Is_NFKC_QC=	:=y}');
Error('\P{Is_NFKC_QC=	:=y}');
Expect(1, 159, '\p{Is_NFKC_QC=y}', "");
Expect(0, 159, '\p{^Is_NFKC_QC=y}', "");
Expect(0, 159, '\P{Is_NFKC_QC=y}', "");
Expect(1, 159, '\P{^Is_NFKC_QC=y}', "");
Expect(0, 160, '\p{Is_NFKC_QC=y}', "");
Expect(1, 160, '\p{^Is_NFKC_QC=y}', "");
Expect(1, 160, '\P{Is_NFKC_QC=y}', "");
Expect(0, 160, '\P{^Is_NFKC_QC=y}', "");
Expect(1, 159, '\p{Is_NFKC_QC=Y}', "");
Expect(0, 159, '\p{^Is_NFKC_QC=Y}', "");
Expect(0, 159, '\P{Is_NFKC_QC=Y}', "");
Expect(1, 159, '\P{^Is_NFKC_QC=Y}', "");
Expect(0, 160, '\p{Is_NFKC_QC=Y}', "");
Expect(1, 160, '\p{^Is_NFKC_QC=Y}', "");
Expect(1, 160, '\P{Is_NFKC_QC=Y}', "");
Expect(0, 160, '\P{^Is_NFKC_QC=Y}', "");
Error('\p{NFKC_Quick_Check=no/a/}');
Error('\P{NFKC_Quick_Check=no/a/}');
Expect(1, 160, '\p{NFKC_Quick_Check=no}', "");
Expect(0, 160, '\p{^NFKC_Quick_Check=no}', "");
Expect(0, 160, '\P{NFKC_Quick_Check=no}', "");
Expect(1, 160, '\P{^NFKC_Quick_Check=no}', "");
Expect(0, 159, '\p{NFKC_Quick_Check=no}', "");
Expect(1, 159, '\p{^NFKC_Quick_Check=no}', "");
Expect(1, 159, '\P{NFKC_Quick_Check=no}', "");
Expect(0, 159, '\P{^NFKC_Quick_Check=no}', "");
Expect(1, 160, '\p{NFKC_Quick_Check=-no}', "");
Expect(0, 160, '\p{^NFKC_Quick_Check=-no}', "");
Expect(0, 160, '\P{NFKC_Quick_Check=-no}', "");
Expect(1, 160, '\P{^NFKC_Quick_Check=-no}', "");
Expect(0, 159, '\p{NFKC_Quick_Check=-no}', "");
Expect(1, 159, '\p{^NFKC_Quick_Check=-no}', "");
Expect(1, 159, '\P{NFKC_Quick_Check=-no}', "");
Expect(0, 159, '\P{^NFKC_Quick_Check=-no}', "");
Error('\p{NFKC_QC:	_:=N}');
Error('\P{NFKC_QC:	_:=N}');
Expect(1, 160, '\p{NFKC_QC=n}', "");
Expect(0, 160, '\p{^NFKC_QC=n}', "");
Expect(0, 160, '\P{NFKC_QC=n}', "");
Expect(1, 160, '\P{^NFKC_QC=n}', "");
Expect(0, 159, '\p{NFKC_QC=n}', "");
Expect(1, 159, '\p{^NFKC_QC=n}', "");
Expect(1, 159, '\P{NFKC_QC=n}', "");
Expect(0, 159, '\P{^NFKC_QC=n}', "");
Expect(1, 160, '\p{NFKC_QC= N}', "");
Expect(0, 160, '\p{^NFKC_QC= N}', "");
Expect(0, 160, '\P{NFKC_QC= N}', "");
Expect(1, 160, '\P{^NFKC_QC= N}', "");
Expect(0, 159, '\p{NFKC_QC= N}', "");
Expect(1, 159, '\p{^NFKC_QC= N}', "");
Expect(1, 159, '\P{NFKC_QC= N}', "");
Expect(0, 159, '\P{^NFKC_QC= N}', "");
Error('\p{Is_NFKC_Quick_Check:	 :=NO}');
Error('\P{Is_NFKC_Quick_Check:	 :=NO}');
Expect(1, 160, '\p{Is_NFKC_Quick_Check=no}', "");
Expect(0, 160, '\p{^Is_NFKC_Quick_Check=no}', "");
Expect(0, 160, '\P{Is_NFKC_Quick_Check=no}', "");
Expect(1, 160, '\P{^Is_NFKC_Quick_Check=no}', "");
Expect(0, 159, '\p{Is_NFKC_Quick_Check=no}', "");
Expect(1, 159, '\p{^Is_NFKC_Quick_Check=no}', "");
Expect(1, 159, '\P{Is_NFKC_Quick_Check=no}', "");
Expect(0, 159, '\P{^Is_NFKC_Quick_Check=no}', "");
Expect(1, 160, '\p{Is_NFKC_Quick_Check=_	No}', "");
Expect(0, 160, '\p{^Is_NFKC_Quick_Check=_	No}', "");
Expect(0, 160, '\P{Is_NFKC_Quick_Check=_	No}', "");
Expect(1, 160, '\P{^Is_NFKC_Quick_Check=_	No}', "");
Expect(0, 159, '\p{Is_NFKC_Quick_Check=_	No}', "");
Expect(1, 159, '\p{^Is_NFKC_Quick_Check=_	No}', "");
Expect(1, 159, '\P{Is_NFKC_Quick_Check=_	No}', "");
Expect(0, 159, '\P{^Is_NFKC_Quick_Check=_	No}', "");
Error('\p{Is_NFKC_QC=:=N}');
Error('\P{Is_NFKC_QC=:=N}');
Expect(1, 160, '\p{Is_NFKC_QC=n}', "");
Expect(0, 160, '\p{^Is_NFKC_QC=n}', "");
Expect(0, 160, '\P{Is_NFKC_QC=n}', "");
Expect(1, 160, '\P{^Is_NFKC_QC=n}', "");
Expect(0, 159, '\p{Is_NFKC_QC=n}', "");
Expect(1, 159, '\p{^Is_NFKC_QC=n}', "");
Expect(1, 159, '\P{Is_NFKC_QC=n}', "");
Expect(0, 159, '\P{^Is_NFKC_QC=n}', "");
Expect(1, 160, '\p{Is_NFKC_QC=_ N}', "");
Expect(0, 160, '\p{^Is_NFKC_QC=_ N}', "");
Expect(0, 160, '\P{Is_NFKC_QC=_ N}', "");
Expect(1, 160, '\P{^Is_NFKC_QC=_ N}', "");
Expect(0, 159, '\p{Is_NFKC_QC=_ N}', "");
Expect(1, 159, '\p{^Is_NFKC_QC=_ N}', "");
Expect(1, 159, '\P{Is_NFKC_QC=_ N}', "");
Expect(0, 159, '\P{^Is_NFKC_QC=_ N}', "");
Error('\p{NFKC_Quick_Check=-	MAYBE:=}');
Error('\P{NFKC_Quick_Check=-	MAYBE:=}');
Expect(1, 772, '\p{NFKC_Quick_Check: maybe}', "");
Expect(0, 772, '\p{^NFKC_Quick_Check: maybe}', "");
Expect(0, 772, '\P{NFKC_Quick_Check: maybe}', "");
Expect(1, 772, '\P{^NFKC_Quick_Check: maybe}', "");
Expect(0, 767, '\p{NFKC_Quick_Check: maybe}', "");
Expect(1, 767, '\p{^NFKC_Quick_Check: maybe}', "");
Expect(1, 767, '\P{NFKC_Quick_Check: maybe}', "");
Expect(0, 767, '\P{^NFKC_Quick_Check: maybe}', "");
Expect(1, 772, '\p{NFKC_Quick_Check=__Maybe}', "");
Expect(0, 772, '\p{^NFKC_Quick_Check=__Maybe}', "");
Expect(0, 772, '\P{NFKC_Quick_Check=__Maybe}', "");
Expect(1, 772, '\P{^NFKC_Quick_Check=__Maybe}', "");
Expect(0, 767, '\p{NFKC_Quick_Check=__Maybe}', "");
Expect(1, 767, '\p{^NFKC_Quick_Check=__Maybe}', "");
Expect(1, 767, '\P{NFKC_Quick_Check=__Maybe}', "");
Expect(0, 767, '\P{^NFKC_Quick_Check=__Maybe}', "");
Error('\p{NFKC_QC:   -m/a/}');
Error('\P{NFKC_QC:   -m/a/}');
Expect(1, 772, '\p{NFKC_QC=m}', "");
Expect(0, 772, '\p{^NFKC_QC=m}', "");
Expect(0, 772, '\P{NFKC_QC=m}', "");
Expect(1, 772, '\P{^NFKC_QC=m}', "");
Expect(0, 767, '\p{NFKC_QC=m}', "");
Expect(1, 767, '\p{^NFKC_QC=m}', "");
Expect(1, 767, '\P{NFKC_QC=m}', "");
Expect(0, 767, '\P{^NFKC_QC=m}', "");
Expect(1, 772, '\p{NFKC_QC= _M}', "");
Expect(0, 772, '\p{^NFKC_QC= _M}', "");
Expect(0, 772, '\P{NFKC_QC= _M}', "");
Expect(1, 772, '\P{^NFKC_QC= _M}', "");
Expect(0, 767, '\p{NFKC_QC= _M}', "");
Expect(1, 767, '\p{^NFKC_QC= _M}', "");
Expect(1, 767, '\P{NFKC_QC= _M}', "");
Expect(0, 767, '\P{^NFKC_QC= _M}', "");
Error('\p{Is_NFKC_Quick_Check=/a/-	maybe}');
Error('\P{Is_NFKC_Quick_Check=/a/-	maybe}');
Expect(1, 772, '\p{Is_NFKC_Quick_Check=maybe}', "");
Expect(0, 772, '\p{^Is_NFKC_Quick_Check=maybe}', "");
Expect(0, 772, '\P{Is_NFKC_Quick_Check=maybe}', "");
Expect(1, 772, '\P{^Is_NFKC_Quick_Check=maybe}', "");
Expect(0, 767, '\p{Is_NFKC_Quick_Check=maybe}', "");
Expect(1, 767, '\p{^Is_NFKC_Quick_Check=maybe}', "");
Expect(1, 767, '\P{Is_NFKC_Quick_Check=maybe}', "");
Expect(0, 767, '\P{^Is_NFKC_Quick_Check=maybe}', "");
Expect(1, 772, '\p{Is_NFKC_Quick_Check=	maybe}', "");
Expect(0, 772, '\p{^Is_NFKC_Quick_Check=	maybe}', "");
Expect(0, 772, '\P{Is_NFKC_Quick_Check=	maybe}', "");
Expect(1, 772, '\P{^Is_NFKC_Quick_Check=	maybe}', "");
Expect(0, 767, '\p{Is_NFKC_Quick_Check=	maybe}', "");
Expect(1, 767, '\p{^Is_NFKC_Quick_Check=	maybe}', "");
Expect(1, 767, '\P{Is_NFKC_Quick_Check=	maybe}', "");
Expect(0, 767, '\P{^Is_NFKC_Quick_Check=	maybe}', "");
Error('\p{Is_NFKC_QC=/a/_	M}');
Error('\P{Is_NFKC_QC=/a/_	M}');
Expect(1, 772, '\p{Is_NFKC_QC:m}', "");
Expect(0, 772, '\p{^Is_NFKC_QC:m}', "");
Expect(0, 772, '\P{Is_NFKC_QC:m}', "");
Expect(1, 772, '\P{^Is_NFKC_QC:m}', "");
Expect(0, 767, '\p{Is_NFKC_QC:m}', "");
Expect(1, 767, '\p{^Is_NFKC_QC:m}', "");
Expect(1, 767, '\P{Is_NFKC_QC:m}', "");
Expect(0, 767, '\P{^Is_NFKC_QC:m}', "");
Expect(1, 772, '\p{Is_NFKC_QC= m}', "");
Expect(0, 772, '\p{^Is_NFKC_QC= m}', "");
Expect(0, 772, '\P{Is_NFKC_QC= m}', "");
Expect(1, 772, '\P{^Is_NFKC_QC= m}', "");
Expect(0, 767, '\p{Is_NFKC_QC= m}', "");
Expect(1, 767, '\p{^Is_NFKC_QC= m}', "");
Expect(1, 767, '\P{Is_NFKC_QC= m}', "");
Expect(0, 767, '\P{^Is_NFKC_QC= m}', "");
Error('\p{Jamo_Short_Name=}');
Error('\P{Jamo_Short_Name=}');
Error('\p{JSN=}');
Error('\P{JSN=}');
Error('\p{Is_Jamo_Short_Name=}');
Error('\P{Is_Jamo_Short_Name=}');
Error('\p{Is_JSN=}');
Error('\P{Is_JSN=}');
Error('\p{Jamo_Short_Name=S}');
Error('\P{Jamo_Short_Name=S}');
Error('\p{JSN=S}');
Error('\P{JSN=S}');
Error('\p{Is_Jamo_Short_Name=S}');
Error('\P{Is_Jamo_Short_Name=S}');
Error('\p{Is_JSN=S}');
Error('\P{Is_JSN=S}');
Error('\p{Jamo_Short_Name=GG}');
Error('\P{Jamo_Short_Name=GG}');
Error('\p{JSN=GG}');
Error('\P{JSN=GG}');
Error('\p{Is_Jamo_Short_Name=GG}');
Error('\P{Is_Jamo_Short_Name=GG}');
Error('\p{Is_JSN=GG}');
Error('\P{Is_JSN=GG}');
Error('\p{Jamo_Short_Name=YU}');
Error('\P{Jamo_Short_Name=YU}');
Error('\p{JSN=YU}');
Error('\P{JSN=YU}');
Error('\p{Is_Jamo_Short_Name=YU}');
Error('\P{Is_Jamo_Short_Name=YU}');
Error('\p{Is_JSN=YU}');
Error('\P{Is_JSN=YU}');
Error('\p{Jamo_Short_Name=WE}');
Error('\P{Jamo_Short_Name=WE}');
Error('\p{JSN=WE}');
Error('\P{JSN=WE}');
Error('\p{Is_Jamo_Short_Name=WE}');
Error('\P{Is_Jamo_Short_Name=WE}');
Error('\p{Is_JSN=WE}');
Error('\P{Is_JSN=WE}');
Error('\p{Jamo_Short_Name=LM}');
Error('\P{Jamo_Short_Name=LM}');
Error('\p{JSN=LM}');
Error('\P{JSN=LM}');
Error('\p{Is_Jamo_Short_Name=LM}');
Error('\P{Is_Jamo_Short_Name=LM}');
Error('\p{Is_JSN=LM}');
Error('\P{Is_JSN=LM}');
Error('\p{Jamo_Short_Name=K}');
Error('\P{Jamo_Short_Name=K}');
Error('\p{JSN=K}');
Error('\P{JSN=K}');
Error('\p{Is_Jamo_Short_Name=K}');
Error('\P{Is_Jamo_Short_Name=K}');
Error('\p{Is_JSN=K}');
Error('\P{Is_JSN=K}');
Error('\p{Jamo_Short_Name:	BB}');
Error('\P{Jamo_Short_Name:	BB}');
Error('\p{JSN=BB}');
Error('\P{JSN=BB}');
Error('\p{Is_Jamo_Short_Name=BB}');
Error('\P{Is_Jamo_Short_Name=BB}');
Error('\p{Is_JSN=BB}');
Error('\P{Is_JSN=BB}');
Error('\p{Jamo_Short_Name=D}');
Error('\P{Jamo_Short_Name=D}');
Error('\p{JSN=D}');
Error('\P{JSN=D}');
Error('\p{Is_Jamo_Short_Name=D}');
Error('\P{Is_Jamo_Short_Name=D}');
Error('\p{Is_JSN=D}');
Error('\P{Is_JSN=D}');
Error('\p{Jamo_Short_Name=E}');
Error('\P{Jamo_Short_Name=E}');
Error('\p{JSN=E}');
Error('\P{JSN=E}');
Error('\p{Is_Jamo_Short_Name=E}');
Error('\P{Is_Jamo_Short_Name=E}');
Error('\p{Is_JSN=E}');
Error('\P{Is_JSN=E}');
Error('\p{Jamo_Short_Name=JJ}');
Error('\P{Jamo_Short_Name=JJ}');
Error('\p{JSN=JJ}');
Error('\P{JSN=JJ}');
Error('\p{Is_Jamo_Short_Name=JJ}');
Error('\P{Is_Jamo_Short_Name=JJ}');
Error('\p{Is_JSN=JJ}');
Error('\P{Is_JSN=JJ}');
Error('\p{Jamo_Short_Name=G}');
Error('\P{Jamo_Short_Name=G}');
Error('\p{JSN=G}');
Error('\P{JSN=G}');
Error('\p{Is_Jamo_Short_Name=G}');
Error('\P{Is_Jamo_Short_Name=G}');
Error('\p{Is_JSN=G}');
Error('\P{Is_JSN=G}');
Error('\p{Jamo_Short_Name=YA}');
Error('\P{Jamo_Short_Name=YA}');
Error('\p{JSN=YA}');
Error('\P{JSN=YA}');
Error('\p{Is_Jamo_Short_Name=YA}');
Error('\P{Is_Jamo_Short_Name=YA}');
Error('\p{Is_JSN=YA}');
Error('\P{Is_JSN=YA}');
Error('\p{Jamo_Short_Name=SS}');
Error('\P{Jamo_Short_Name=SS}');
Error('\p{JSN=SS}');
Error('\P{JSN=SS}');
Error('\p{Is_Jamo_Short_Name=SS}');
Error('\P{Is_Jamo_Short_Name=SS}');
Error('\p{Is_JSN=SS}');
Error('\P{Is_JSN=SS}');
Error('\p{Jamo_Short_Name=LB}');
Error('\P{Jamo_Short_Name=LB}');
Error('\p{JSN=LB}');
Error('\P{JSN=LB}');
Error('\p{Is_Jamo_Short_Name=LB}');
Error('\P{Is_Jamo_Short_Name=LB}');
Error('\p{Is_JSN=LB}');
Error('\P{Is_JSN=LB}');
Error('\p{Jamo_Short_Name=J}');
Error('\P{Jamo_Short_Name=J}');
Error('\p{JSN=J}');
Error('\P{JSN=J}');
Error('\p{Is_Jamo_Short_Name=J}');
Error('\P{Is_Jamo_Short_Name=J}');
Error('\p{Is_JSN=J}');
Error('\P{Is_JSN=J}');
Error('\p{Jamo_Short_Name=NH}');
Error('\P{Jamo_Short_Name=NH}');
Error('\p{JSN:NH}');
Error('\P{JSN:NH}');
Error('\p{Is_Jamo_Short_Name=NH}');
Error('\P{Is_Jamo_Short_Name=NH}');
Error('\p{Is_JSN=NH}');
Error('\P{Is_JSN=NH}');
Error('\p{Jamo_Short_Name=YEO}');
Error('\P{Jamo_Short_Name=YEO}');
Error('\p{JSN=YEO}');
Error('\P{JSN=YEO}');
Error('\p{Is_Jamo_Short_Name=YEO}');
Error('\P{Is_Jamo_Short_Name=YEO}');
Error('\p{Is_JSN=YEO}');
Error('\P{Is_JSN=YEO}');
Error('\p{Jamo_Short_Name=LP}');
Error('\P{Jamo_Short_Name=LP}');
Error('\p{JSN=LP}');
Error('\P{JSN=LP}');
Error('\p{Is_Jamo_Short_Name=LP}');
Error('\P{Is_Jamo_Short_Name=LP}');
Error('\p{Is_JSN=LP}');
Error('\P{Is_JSN=LP}');
Error('\p{Jamo_Short_Name=NJ}');
Error('\P{Jamo_Short_Name=NJ}');
Error('\p{JSN=NJ}');
Error('\P{JSN=NJ}');
Error('\p{Is_Jamo_Short_Name=NJ}');
Error('\P{Is_Jamo_Short_Name=NJ}');
Error('\p{Is_JSN=NJ}');
Error('\P{Is_JSN=NJ}');
Error('\p{Jamo_Short_Name=B}');
Error('\P{Jamo_Short_Name=B}');
Error('\p{JSN:	B}');
Error('\P{JSN:	B}');
Error('\p{Is_Jamo_Short_Name=B}');
Error('\P{Is_Jamo_Short_Name=B}');
Error('\p{Is_JSN=B}');
Error('\P{Is_JSN=B}');
Error('\p{Jamo_Short_Name=WA}');
Error('\P{Jamo_Short_Name=WA}');
Error('\p{JSN=WA}');
Error('\P{JSN=WA}');
Error('\p{Is_Jamo_Short_Name=WA}');
Error('\P{Is_Jamo_Short_Name=WA}');
Error('\p{Is_JSN=WA}');
Error('\P{Is_JSN=WA}');
Error('\p{Jamo_Short_Name=LH}');
Error('\P{Jamo_Short_Name=LH}');
Error('\p{JSN:   LH}');
Error('\P{JSN:   LH}');
Error('\p{Is_Jamo_Short_Name=LH}');
Error('\P{Is_Jamo_Short_Name=LH}');
Error('\p{Is_JSN=LH}');
Error('\P{Is_JSN=LH}');
Error('\p{Jamo_Short_Name=YI}');
Error('\P{Jamo_Short_Name=YI}');
Error('\p{JSN=YI}');
Error('\P{JSN=YI}');
Error('\p{Is_Jamo_Short_Name=YI}');
Error('\P{Is_Jamo_Short_Name=YI}');
Error('\p{Is_JSN=YI}');
Error('\P{Is_JSN=YI}');
Error('\p{Jamo_Short_Name=WEO}');
Error('\P{Jamo_Short_Name=WEO}');
Error('\p{JSN=WEO}');
Error('\P{JSN=WEO}');
Error('\p{Is_Jamo_Short_Name=WEO}');
Error('\P{Is_Jamo_Short_Name=WEO}');
Error('\p{Is_JSN=WEO}');
Error('\P{Is_JSN=WEO}');
Error('\p{Jamo_Short_Name=LS}');
Error('\P{Jamo_Short_Name=LS}');
Error('\p{JSN=LS}');
Error('\P{JSN=LS}');
Error('\p{Is_Jamo_Short_Name=LS}');
Error('\P{Is_Jamo_Short_Name=LS}');
Error('\p{Is_JSN=LS}');
Error('\P{Is_JSN=LS}');
Error('\p{Jamo_Short_Name=BS}');
Error('\P{Jamo_Short_Name=BS}');
Error('\p{JSN=BS}');
Error('\P{JSN=BS}');
Error('\p{Is_Jamo_Short_Name=BS}');
Error('\P{Is_Jamo_Short_Name=BS}');
Error('\p{Is_JSN:BS}');
Error('\P{Is_JSN:BS}');
Error('\p{Jamo_Short_Name=YO}');
Error('\P{Jamo_Short_Name=YO}');
Error('\p{JSN=YO}');
Error('\P{JSN=YO}');
Error('\p{Is_Jamo_Short_Name=YO}');
Error('\P{Is_Jamo_Short_Name=YO}');
Error('\p{Is_JSN=YO}');
Error('\P{Is_JSN=YO}');
Error('\p{Jamo_Short_Name=OE}');
Error('\P{Jamo_Short_Name=OE}');
Error('\p{JSN: OE}');
Error('\P{JSN: OE}');
Error('\p{Is_Jamo_Short_Name=OE}');
Error('\P{Is_Jamo_Short_Name=OE}');
Error('\p{Is_JSN=OE}');
Error('\P{Is_JSN=OE}');
Error('\p{Jamo_Short_Name=M}');
Error('\P{Jamo_Short_Name=M}');
Error('\p{JSN=M}');
Error('\P{JSN=M}');
Error('\p{Is_Jamo_Short_Name=M}');
Error('\P{Is_Jamo_Short_Name=M}');
Error('\p{Is_JSN=M}');
Error('\P{Is_JSN=M}');
Error('\p{Jamo_Short_Name=EO}');
Error('\P{Jamo_Short_Name=EO}');
Error('\p{JSN:EO}');
Error('\P{JSN:EO}');
Error('\p{Is_Jamo_Short_Name=EO}');
Error('\P{Is_Jamo_Short_Name=EO}');
Error('\p{Is_JSN=EO}');
Error('\P{Is_JSN=EO}');
Error('\p{Jamo_Short_Name=C}');
Error('\P{Jamo_Short_Name=C}');
Error('\p{JSN=C}');
Error('\P{JSN=C}');
Error('\p{Is_Jamo_Short_Name=C}');
Error('\P{Is_Jamo_Short_Name=C}');
Error('\p{Is_JSN=C}');
Error('\P{Is_JSN=C}');
Error('\p{Jamo_Short_Name=WI}');
Error('\P{Jamo_Short_Name=WI}');
Error('\p{JSN=WI}');
Error('\P{JSN=WI}');
Error('\p{Is_Jamo_Short_Name=WI}');
Error('\P{Is_Jamo_Short_Name=WI}');
Error('\p{Is_JSN=WI}');
Error('\P{Is_JSN=WI}');
Error('\p{Jamo_Short_Name=EU}');
Error('\P{Jamo_Short_Name=EU}');
Error('\p{JSN=EU}');
Error('\P{JSN=EU}');
Error('\p{Is_Jamo_Short_Name=EU}');
Error('\P{Is_Jamo_Short_Name=EU}');
Error('\p{Is_JSN=EU}');
Error('\P{Is_JSN=EU}');
Error('\p{Jamo_Short_Name=LG}');
Error('\P{Jamo_Short_Name=LG}');
Error('\p{JSN=LG}');
Error('\P{JSN=LG}');
Error('\p{Is_Jamo_Short_Name=LG}');
Error('\P{Is_Jamo_Short_Name=LG}');
Error('\p{Is_JSN=LG}');
Error('\P{Is_JSN=LG}');
Error('\p{Jamo_Short_Name=L}');
Error('\P{Jamo_Short_Name=L}');
Error('\p{JSN=L}');
Error('\P{JSN=L}');
Error('\p{Is_Jamo_Short_Name:L}');
Error('\P{Is_Jamo_Short_Name:L}');
Error('\p{Is_JSN=L}');
Error('\P{Is_JSN=L}');
Error('\p{Jamo_Short_Name=P}');
Error('\P{Jamo_Short_Name=P}');
Error('\p{JSN=P}');
Error('\P{JSN=P}');
Error('\p{Is_Jamo_Short_Name=P}');
Error('\P{Is_Jamo_Short_Name=P}');
Error('\p{Is_JSN=P}');
Error('\P{Is_JSN=P}');
Error('\p{Jamo_Short_Name=DD}');
Error('\P{Jamo_Short_Name=DD}');
Error('\p{JSN=DD}');
Error('\P{JSN=DD}');
Error('\p{Is_Jamo_Short_Name=DD}');
Error('\P{Is_Jamo_Short_Name=DD}');
Error('\p{Is_JSN=DD}');
Error('\P{Is_JSN=DD}');
Error('\p{Jamo_Short_Name=NG}');
Error('\P{Jamo_Short_Name=NG}');
Error('\p{JSN=NG}');
Error('\P{JSN=NG}');
Error('\p{Is_Jamo_Short_Name=NG}');
Error('\P{Is_Jamo_Short_Name=NG}');
Error('\p{Is_JSN=NG}');
Error('\P{Is_JSN=NG}');
Error('\p{Jamo_Short_Name=AE}');
Error('\P{Jamo_Short_Name=AE}');
Error('\p{JSN=AE}');
Error('\P{JSN=AE}');
Error('\p{Is_Jamo_Short_Name=AE}');
Error('\P{Is_Jamo_Short_Name=AE}');
Error('\p{Is_JSN=AE}');
Error('\P{Is_JSN=AE}');
Error('\p{Jamo_Short_Name=T}');
Error('\P{Jamo_Short_Name=T}');
Error('\p{JSN: T}');
Error('\P{JSN: T}');
Error('\p{Is_Jamo_Short_Name=T}');
Error('\P{Is_Jamo_Short_Name=T}');
Error('\p{Is_JSN=T}');
Error('\P{Is_JSN=T}');
Error('\p{Jamo_Short_Name=A}');
Error('\P{Jamo_Short_Name=A}');
Error('\p{JSN=A}');
Error('\P{JSN=A}');
Error('\p{Is_Jamo_Short_Name=A}');
Error('\P{Is_Jamo_Short_Name=A}');
Error('\p{Is_JSN=A}');
Error('\P{Is_JSN=A}');
Error('\p{Jamo_Short_Name=N}');
Error('\P{Jamo_Short_Name=N}');
Error('\p{JSN=N}');
Error('\P{JSN=N}');
Error('\p{Is_Jamo_Short_Name=N}');
Error('\P{Is_Jamo_Short_Name=N}');
Error('\p{Is_JSN=N}');
Error('\P{Is_JSN=N}');
Error('\p{Jamo_Short_Name=YAE}');
Error('\P{Jamo_Short_Name=YAE}');
Error('\p{JSN=YAE}');
Error('\P{JSN=YAE}');
Error('\p{Is_Jamo_Short_Name=YAE}');
Error('\P{Is_Jamo_Short_Name=YAE}');
Error('\p{Is_JSN=YAE}');
Error('\P{Is_JSN=YAE}');
Error('\p{Jamo_Short_Name=U}');
Error('\P{Jamo_Short_Name=U}');
Error('\p{JSN=U}');
Error('\P{JSN=U}');
Error('\p{Is_Jamo_Short_Name=U}');
Error('\P{Is_Jamo_Short_Name=U}');
Error('\p{Is_JSN: U}');
Error('\P{Is_JSN: U}');
Error('\p{Jamo_Short_Name=WAE}');
Error('\P{Jamo_Short_Name=WAE}');
Error('\p{JSN=WAE}');
Error('\P{JSN=WAE}');
Error('\p{Is_Jamo_Short_Name=WAE}');
Error('\P{Is_Jamo_Short_Name=WAE}');
Error('\p{Is_JSN=WAE}');
Error('\P{Is_JSN=WAE}');
Error('\p{Jamo_Short_Name=GS}');
Error('\P{Jamo_Short_Name=GS}');
Error('\p{JSN=GS}');
Error('\P{JSN=GS}');
Error('\p{Is_Jamo_Short_Name=GS}');
Error('\P{Is_Jamo_Short_Name=GS}');
Error('\p{Is_JSN:GS}');
Error('\P{Is_JSN:GS}');
Error('\p{Jamo_Short_Name=H}');
Error('\P{Jamo_Short_Name=H}');
Error('\p{JSN=H}');
Error('\P{JSN=H}');
Error('\p{Is_Jamo_Short_Name=H}');
Error('\P{Is_Jamo_Short_Name=H}');
Error('\p{Is_JSN=H}');
Error('\P{Is_JSN=H}');
Error('\p{Jamo_Short_Name=LT}');
Error('\P{Jamo_Short_Name=LT}');
Error('\p{JSN=LT}');
Error('\P{JSN=LT}');
Error('\p{Is_Jamo_Short_Name=LT}');
Error('\P{Is_Jamo_Short_Name=LT}');
Error('\p{Is_JSN=LT}');
Error('\P{Is_JSN=LT}');
Error('\p{Jamo_Short_Name=YE}');
Error('\P{Jamo_Short_Name=YE}');
Error('\p{JSN=YE}');
Error('\P{JSN=YE}');
Error('\p{Is_Jamo_Short_Name: YE}');
Error('\P{Is_Jamo_Short_Name: YE}');
Error('\p{Is_JSN=YE}');
Error('\P{Is_JSN=YE}');
Error('\p{Jamo_Short_Name=I}');
Error('\P{Jamo_Short_Name=I}');
Error('\p{JSN=I}');
Error('\P{JSN=I}');
Error('\p{Is_Jamo_Short_Name: I}');
Error('\P{Is_Jamo_Short_Name: I}');
Error('\p{Is_JSN=I}');
Error('\P{Is_JSN=I}');
Error('\p{Jamo_Short_Name=R}');
Error('\P{Jamo_Short_Name=R}');
Error('\p{JSN=R}');
Error('\P{JSN=R}');
Error('\p{Is_Jamo_Short_Name=R}');
Error('\P{Is_Jamo_Short_Name=R}');
Error('\p{Is_JSN=R}');
Error('\P{Is_JSN=R}');
Error('\p{Jamo_Short_Name=O}');
Error('\P{Jamo_Short_Name=O}');
Error('\p{JSN=O}');
Error('\P{JSN=O}');
Error('\p{Is_Jamo_Short_Name=O}');
Error('\P{Is_Jamo_Short_Name=O}');
Error('\p{Is_JSN=O}');
Error('\P{Is_JSN=O}');
Error('\p{Age=  00-00 00	003.2/a/}');
Error('\P{Age=  00-00 00	003.2/a/}');
Expect(1, 544, '\p{Age=+003.2}', "");
Expect(0, 544, '\p{^Age=+003.2}', "");
Expect(0, 544, '\P{Age=+003.2}', "");
Expect(1, 544, '\P{^Age=+003.2}', "");
Expect(0, 543, '\p{Age=+003.2}', "");
Expect(1, 543, '\p{^Age=+003.2}', "");
Expect(1, 543, '\P{Age=+003.2}', "");
Expect(0, 543, '\P{^Age=+003.2}', "");
Error('\p{Is_Age:   _-+00003.2/a/}');
Error('\P{Is_Age:   _-+00003.2/a/}');
Expect(1, 544, '\p{Is_Age:   +0_0_0_0_0_0_0_003.2}', "");
Expect(0, 544, '\p{^Is_Age:   +0_0_0_0_0_0_0_003.2}', "");
Expect(0, 544, '\P{Is_Age:   +0_0_0_0_0_0_0_003.2}', "");
Expect(1, 544, '\P{^Is_Age:   +0_0_0_0_0_0_0_003.2}', "");
Expect(0, 543, '\p{Is_Age:   +0_0_0_0_0_0_0_003.2}', "");
Expect(1, 543, '\p{^Is_Age:   +0_0_0_0_0_0_0_003.2}', "");
Expect(1, 543, '\P{Is_Age:   +0_0_0_0_0_0_0_003.2}', "");
Expect(0, 543, '\P{^Is_Age:   +0_0_0_0_0_0_0_003.2}', "");
Error('\p{Age=_0_0-0	0/a/0_0_0-02.0}');
Error('\P{Age=_0_0-0	0/a/0_0_0-02.0}');
Expect(1, 1441, '\p{Age=+000_000_02.0}', "");
Expect(0, 1441, '\p{^Age=+000_000_02.0}', "");
Expect(0, 1441, '\P{Age=+000_000_02.0}', "");
Expect(1, 1441, '\P{^Age=+000_000_02.0}', "");
Expect(0, 1424, '\p{Age=+000_000_02.0}', "");
Expect(1, 1424, '\p{^Age=+000_000_02.0}', "");
Expect(1, 1424, '\P{Age=+000_000_02.0}', "");
Expect(0, 1424, '\P{^Age=+000_000_02.0}', "");
Error('\p{Is_Age= :=02.0}');
Error('\P{Is_Age= :=02.0}');
Expect(1, 1441, '\p{Is_Age=+0_0_0_0_002.0}', "");
Expect(0, 1441, '\p{^Is_Age=+0_0_0_0_002.0}', "");
Expect(0, 1441, '\P{Is_Age=+0_0_0_0_002.0}', "");
Expect(1, 1441, '\P{^Is_Age=+0_0_0_0_002.0}', "");
Expect(0, 1424, '\p{Is_Age=+0_0_0_0_002.0}', "");
Expect(1, 1424, '\p{^Is_Age=+0_0_0_0_002.0}', "");
Expect(1, 1424, '\P{Is_Age=+0_0_0_0_002.0}', "");
Expect(0, 1424, '\P{^Is_Age=+0_0_0_0_002.0}', "");
Error('\p{Age=_/a/000000001.1}');
Error('\P{Age=_/a/000000001.1}');
Expect(1, 501, '\p{Age=000_000_1.1}', "");
Expect(0, 501, '\p{^Age=000_000_1.1}', "");
Expect(0, 501, '\P{Age=000_000_1.1}', "");
Expect(1, 501, '\P{^Age=000_000_1.1}', "");
Expect(0, 505, '\p{Age=000_000_1.1}', "");
Expect(1, 505, '\p{^Age=000_000_1.1}', "");
Expect(1, 505, '\P{Age=000_000_1.1}', "");
Expect(0, 505, '\P{^Age=000_000_1.1}', "");
Error('\p{Is_Age=-_+00000001.1/a/}');
Error('\P{Is_Age=-_+00000001.1/a/}');
Expect(1, 501, '\p{Is_Age=0001.1}', "");
Expect(0, 501, '\p{^Is_Age=0001.1}', "");
Expect(0, 501, '\P{Is_Age=0001.1}', "");
Expect(1, 501, '\P{^Is_Age=0001.1}', "");
Expect(0, 505, '\p{Is_Age=0001.1}', "");
Expect(1, 505, '\p{^Is_Age=0001.1}', "");
Expect(1, 505, '\P{Is_Age=0001.1}', "");
Expect(0, 505, '\P{^Is_Age=0001.1}', "");
Error('\p{Age= /a/0005.0}');
Error('\P{Age= /a/0005.0}');
Expect(1, 591, '\p{Age=+00000005.0}', "");
Expect(0, 591, '\p{^Age=+00000005.0}', "");
Expect(0, 591, '\P{Age=+00000005.0}', "");
Expect(1, 591, '\P{^Age=+00000005.0}', "");
Expect(0, 577, '\p{Age=+00000005.0}', "");
Expect(1, 577, '\p{^Age=+00000005.0}', "");
Expect(1, 577, '\P{Age=+00000005.0}', "");
Expect(0, 577, '\P{^Age=+00000005.0}', "");
Error('\p{Is_Age=	/a/+0000000 5.0}');
Error('\P{Is_Age=	/a/+0000000 5.0}');
Expect(1, 591, '\p{Is_Age=5.0}', "");
Expect(0, 591, '\p{^Is_Age=5.0}', "");
Expect(0, 591, '\P{Is_Age=5.0}', "");
Expect(1, 591, '\P{^Is_Age=5.0}', "");
Expect(0, 577, '\p{Is_Age=5.0}', "");
Expect(1, 577, '\p{^Is_Age=5.0}', "");
Expect(1, 577, '\P{Is_Age=5.0}', "");
Expect(0, 577, '\P{^Is_Age=5.0}', "");
Error('\p{Age:   :=		0000003.0}');
Error('\P{Age:   :=		0000003.0}');
Expect(1, 505, '\p{Age=0000003.0}', "");
Expect(0, 505, '\p{^Age=0000003.0}', "");
Expect(0, 505, '\P{Age=0000003.0}', "");
Expect(1, 505, '\P{^Age=0000003.0}', "");
Expect(0, 501, '\p{Age=0000003.0}', "");
Expect(1, 501, '\p{^Age=0000003.0}', "");
Expect(1, 501, '\P{Age=0000003.0}', "");
Expect(0, 501, '\P{^Age=0000003.0}', "");
Error('\p{Is_Age=/a/ _0 0_03.0}');
Error('\P{Is_Age=/a/ _0 0_03.0}');
Expect(1, 505, '\p{Is_Age=3.0}', "");
Expect(0, 505, '\p{^Is_Age=3.0}', "");
Expect(0, 505, '\P{Is_Age=3.0}', "");
Expect(1, 505, '\P{^Is_Age=3.0}', "");
Expect(0, 501, '\p{Is_Age=3.0}', "");
Expect(1, 501, '\p{^Is_Age=3.0}', "");
Expect(1, 501, '\P{Is_Age=3.0}', "");
Expect(0, 501, '\P{^Is_Age=3.0}', "");
Error('\p{Age=	/a/UNASSIGNED}');
Error('\P{Age=	/a/UNASSIGNED}');
Expect(1, 889, '\p{Age=unassigned}', "");
Expect(0, 889, '\p{^Age=unassigned}', "");
Expect(0, 889, '\P{Age=unassigned}', "");
Expect(1, 889, '\P{^Age=unassigned}', "");
Expect(0, 887, '\p{Age=unassigned}', "");
Expect(1, 887, '\p{^Age=unassigned}', "");
Expect(1, 887, '\P{Age=unassigned}', "");
Expect(0, 887, '\P{^Age=unassigned}', "");
Expect(1, 889, '\p{Age=__UNASSIGNED}', "");
Expect(0, 889, '\p{^Age=__UNASSIGNED}', "");
Expect(0, 889, '\P{Age=__UNASSIGNED}', "");
Expect(1, 889, '\P{^Age=__UNASSIGNED}', "");
Expect(0, 887, '\p{Age=__UNASSIGNED}', "");
Expect(1, 887, '\p{^Age=__UNASSIGNED}', "");
Expect(1, 887, '\P{Age=__UNASSIGNED}', "");
Expect(0, 887, '\P{^Age=__UNASSIGNED}', "");
Error('\p{Is_Age=	:=unassigned}');
Error('\P{Is_Age=	:=unassigned}');
Expect(1, 889, '\p{Is_Age=unassigned}', "");
Expect(0, 889, '\p{^Is_Age=unassigned}', "");
Expect(0, 889, '\P{Is_Age=unassigned}', "");
Expect(1, 889, '\P{^Is_Age=unassigned}', "");
Expect(0, 887, '\p{Is_Age=unassigned}', "");
Expect(1, 887, '\p{^Is_Age=unassigned}', "");
Expect(1, 887, '\P{Is_Age=unassigned}', "");
Expect(0, 887, '\P{^Is_Age=unassigned}', "");
Expect(1, 889, '\p{Is_Age:   Unassigned}', "");
Expect(0, 889, '\p{^Is_Age:   Unassigned}', "");
Expect(0, 889, '\P{Is_Age:   Unassigned}', "");
Expect(1, 889, '\P{^Is_Age:   Unassigned}', "");
Expect(0, 887, '\p{Is_Age:   Unassigned}', "");
Expect(1, 887, '\p{^Is_Age:   Unassigned}', "");
Expect(1, 887, '\P{Is_Age:   Unassigned}', "");
Expect(0, 887, '\P{^Is_Age:   Unassigned}', "");
Error('\p{Age=_+0-0 00	05.1:=}');
Error('\P{Age=_+0-0 00	05.1:=}');
Expect(1, 883, '\p{Age=0_0_0_005.1}', "");
Expect(0, 883, '\p{^Age=0_0_0_005.1}', "");
Expect(0, 883, '\P{Age=0_0_0_005.1}', "");
Expect(1, 883, '\P{^Age=0_0_0_005.1}', "");
Expect(0, 879, '\p{Age=0_0_0_005.1}', "");
Expect(1, 879, '\p{^Age=0_0_0_005.1}', "");
Expect(1, 879, '\P{Age=0_0_0_005.1}', "");
Expect(0, 879, '\P{^Age=0_0_0_005.1}', "");
Error('\p{Is_Age=/a/__5.1}');
Error('\P{Is_Age=/a/__5.1}');
Expect(1, 883, '\p{Is_Age=00000_5.1}', "");
Expect(0, 883, '\p{^Is_Age=00000_5.1}', "");
Expect(0, 883, '\P{Is_Age=00000_5.1}', "");
Expect(1, 883, '\P{^Is_Age=00000_5.1}', "");
Expect(0, 879, '\p{Is_Age=00000_5.1}', "");
Expect(1, 879, '\p{^Is_Age=00000_5.1}', "");
Expect(1, 879, '\P{Is_Age=00000_5.1}', "");
Expect(0, 879, '\P{^Is_Age=00000_5.1}', "");
Error('\p{Age= 0	00_0:=0_0004.0}');
Error('\P{Age= 0	00_0:=0_0004.0}');
Expect(1, 545, '\p{Age=00_00_4.0}', "");
Expect(0, 545, '\p{^Age=00_00_4.0}', "");
Expect(0, 545, '\P{Age=00_00_4.0}', "");
Expect(1, 545, '\P{^Age=00_00_4.0}', "");
Expect(0, 544, '\p{Age=00_00_4.0}', "");
Expect(1, 544, '\p{^Age=00_00_4.0}', "");
Expect(1, 544, '\P{Age=00_00_4.0}', "");
Expect(0, 544, '\P{^Age=00_00_4.0}', "");
Error('\p{Is_Age=/a/ _+0_4.0}');
Error('\P{Is_Age=/a/ _+0_4.0}');
Expect(1, 545, '\p{Is_Age=0000004.0}', "");
Expect(0, 545, '\p{^Is_Age=0000004.0}', "");
Expect(0, 545, '\P{Is_Age=0000004.0}', "");
Expect(1, 545, '\P{^Is_Age=0000004.0}', "");
Expect(0, 544, '\p{Is_Age=0000004.0}', "");
Expect(1, 544, '\p{^Is_Age=0000004.0}', "");
Expect(1, 544, '\P{Is_Age=0000004.0}', "");
Expect(0, 544, '\P{^Is_Age=0000004.0}', "");
Error('\p{Age=_0	0_0_0	005.2/a/}');
Error('\P{Age=_0	0_0_0	005.2/a/}');
Expect(1, 1317, '\p{Age=0_0_0_005.2}', "");
Expect(0, 1317, '\p{^Age=0_0_0_005.2}', "");
Expect(0, 1317, '\P{Age=0_0_0_005.2}', "");
Expect(1, 1317, '\P{^Age=0_0_0_005.2}', "");
Expect(0, 1315, '\p{Age=0_0_0_005.2}', "");
Expect(1, 1315, '\p{^Age=0_0_0_005.2}', "");
Expect(1, 1315, '\P{Age=0_0_0_005.2}', "");
Expect(0, 1315, '\P{^Age=0_0_0_005.2}', "");
Error('\p{Is_Age=_:=00 00_0005.2}');
Error('\P{Is_Age=_:=00 00_0005.2}');
Expect(1, 1317, '\p{Is_Age=+00005.2}', "");
Expect(0, 1317, '\p{^Is_Age=+00005.2}', "");
Expect(0, 1317, '\P{Is_Age=+00005.2}', "");
Expect(1, 1317, '\P{^Is_Age=+00005.2}', "");
Expect(0, 1315, '\p{Is_Age=+00005.2}', "");
Expect(1, 1315, '\p{^Is_Age=+00005.2}', "");
Expect(1, 1315, '\P{Is_Age=+00005.2}', "");
Expect(0, 1315, '\P{^Is_Age=+00005.2}', "");
Error('\p{Age=:=_0003.1}');
Error('\P{Age=:=_0003.1}');
Expect(1, 1013, '\p{Age=00_00_03.1}', "");
Expect(0, 1013, '\p{^Age=00_00_03.1}', "");
Expect(0, 1013, '\P{Age=00_00_03.1}', "");
Expect(1, 1013, '\P{^Age=00_00_03.1}', "");
Expect(0, 1011, '\p{Age=00_00_03.1}', "");
Expect(1, 1011, '\p{^Age=00_00_03.1}', "");
Expect(1, 1011, '\P{Age=00_00_03.1}', "");
Expect(0, 1011, '\P{^Age=00_00_03.1}', "");
Error('\p{Is_Age=/a/00 00	00-03.1}');
Error('\P{Is_Age=/a/00 00	00-03.1}');
Expect(1, 1013, '\p{Is_Age=000_3.1}', "");
Expect(0, 1013, '\p{^Is_Age=000_3.1}', "");
Expect(0, 1013, '\P{Is_Age=000_3.1}', "");
Expect(1, 1013, '\P{^Is_Age=000_3.1}', "");
Expect(0, 1011, '\p{Is_Age=000_3.1}', "");
Expect(1, 1011, '\p{^Is_Age=000_3.1}', "");
Expect(1, 1011, '\P{Is_Age=000_3.1}', "");
Expect(0, 1011, '\P{^Is_Age=000_3.1}', "");
Error('\p{Age=-00	2.1:=}');
Error('\P{Age=-00	2.1:=}');
Expect(1, 8364, '\p{Age=0_0_02.1}', "");
Expect(0, 8364, '\p{^Age=0_0_02.1}', "");
Expect(0, 8364, '\P{Age=0_0_02.1}', "");
Expect(1, 8364, '\P{^Age=0_0_02.1}', "");
Expect(0, 8363, '\p{Age=0_0_02.1}', "");
Expect(1, 8363, '\p{^Age=0_0_02.1}', "");
Expect(1, 8363, '\P{Age=0_0_02.1}', "");
Expect(0, 8363, '\P{^Age=0_0_02.1}', "");
Error('\p{Is_Age=- 0000000002.1:=}');
Error('\P{Is_Age=- 0000000002.1:=}');
Expect(1, 8364, '\p{Is_Age=0000000002.1}', "");
Expect(0, 8364, '\p{^Is_Age=0000000002.1}', "");
Expect(0, 8364, '\P{Is_Age=0000000002.1}', "");
Expect(1, 8364, '\P{^Is_Age=0000000002.1}', "");
Expect(0, 8363, '\p{Is_Age=0000000002.1}', "");
Expect(1, 8363, '\p{^Is_Age=0000000002.1}', "");
Expect(1, 8363, '\P{Is_Age=0000000002.1}', "");
Expect(0, 8363, '\P{^Is_Age=0000000002.1}', "");
Error('\p{Age=_004.1:=}');
Error('\P{Age=_004.1:=}');
Expect(1, 577, '\p{Age=+00000004.1}', "");
Expect(0, 577, '\p{^Age=+00000004.1}', "");
Expect(0, 577, '\P{Age=+00000004.1}', "");
Expect(1, 577, '\P{^Age=+00000004.1}', "");
Expect(0, 566, '\p{Age=+00000004.1}', "");
Expect(1, 566, '\p{^Age=+00000004.1}', "");
Expect(1, 566, '\P{Age=+00000004.1}', "");
Expect(0, 566, '\P{^Age=+00000004.1}', "");
Error('\p{Is_Age=--+0-0/a/0	0 00	0_004.1}');
Error('\P{Is_Age=--+0-0/a/0	0 00	0_004.1}');
Expect(1, 577, '\p{Is_Age=+00004.1}', "");
Expect(0, 577, '\p{^Is_Age=+00004.1}', "");
Expect(0, 577, '\P{Is_Age=+00004.1}', "");
Expect(1, 577, '\P{^Is_Age=+00004.1}', "");
Expect(0, 566, '\p{Is_Age=+00004.1}', "");
Expect(1, 566, '\p{^Is_Age=+00004.1}', "");
Expect(1, 566, '\P{Is_Age=+00004.1}', "");
Expect(0, 566, '\P{^Is_Age=+00004.1}', "");
Error('\p{Expands_On_NFKD=Yes}');
Error('\P{Expands_On_NFKD=Yes}');
Error('\p{XO_NFKD=Y}');
Error('\P{XO_NFKD=Y}');
Error('\p{Is_Expands_On_NFKD=T}');
Error('\P{Is_Expands_On_NFKD=T}');
Error('\p{Is_XO_NFKD=True}');
Error('\P{Is_XO_NFKD=True}');
Error('\p{Expands_On_NFKD=No}');
Error('\P{Expands_On_NFKD=No}');
Error('\p{XO_NFKD=N}');
Error('\P{XO_NFKD=N}');
Error('\p{Is_Expands_On_NFKD=F}');
Error('\P{Is_Expands_On_NFKD=F}');
Error('\p{Is_XO_NFKD=False}');
Error('\P{Is_XO_NFKD=False}');
Error('\p{Grapheme_Cluster_Break=/a/--spacingmark}');
Error('\P{Grapheme_Cluster_Break=/a/--spacingmark}');
Expect(1, 2307, '\p{Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 2307, '\p{^Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 2307, '\P{Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 2307, '\P{^Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 2306, '\p{Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 2306, '\p{^Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 2306, '\P{Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 2306, '\P{^Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 2307, '\p{Grapheme_Cluster_Break= -spacingmark}', "");
Expect(0, 2307, '\p{^Grapheme_Cluster_Break= -spacingmark}', "");
Expect(0, 2307, '\P{Grapheme_Cluster_Break= -spacingmark}', "");
Expect(1, 2307, '\P{^Grapheme_Cluster_Break= -spacingmark}', "");
Expect(0, 2306, '\p{Grapheme_Cluster_Break= -spacingmark}', "");
Expect(1, 2306, '\p{^Grapheme_Cluster_Break= -spacingmark}', "");
Expect(1, 2306, '\P{Grapheme_Cluster_Break= -spacingmark}', "");
Expect(0, 2306, '\P{^Grapheme_Cluster_Break= -spacingmark}', "");
Error('\p{GCB=-SM:=}');
Error('\P{GCB=-SM:=}');
Expect(1, 2307, '\p{GCB:	sm}', "");
Expect(0, 2307, '\p{^GCB:	sm}', "");
Expect(0, 2307, '\P{GCB:	sm}', "");
Expect(1, 2307, '\P{^GCB:	sm}', "");
Expect(0, 2306, '\p{GCB:	sm}', "");
Expect(1, 2306, '\p{^GCB:	sm}', "");
Expect(1, 2306, '\P{GCB:	sm}', "");
Expect(0, 2306, '\P{^GCB:	sm}', "");
Expect(1, 2307, '\p{GCB= -SM}', "");
Expect(0, 2307, '\p{^GCB= -SM}', "");
Expect(0, 2307, '\P{GCB= -SM}', "");
Expect(1, 2307, '\P{^GCB= -SM}', "");
Expect(0, 2306, '\p{GCB= -SM}', "");
Expect(1, 2306, '\p{^GCB= -SM}', "");
Expect(1, 2306, '\P{GCB= -SM}', "");
Expect(0, 2306, '\P{^GCB= -SM}', "");
Error('\p{Is_Grapheme_Cluster_Break=-:=SpacingMark}');
Error('\P{Is_Grapheme_Cluster_Break=-:=SpacingMark}');
Expect(1, 2307, '\p{Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 2307, '\p{^Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 2307, '\P{Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 2307, '\P{^Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 2306, '\p{Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 2306, '\p{^Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 2306, '\P{Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 2306, '\P{^Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 2307, '\p{Is_Grapheme_Cluster_Break=_	SPACINGMARK}', "");
Expect(0, 2307, '\p{^Is_Grapheme_Cluster_Break=_	SPACINGMARK}', "");
Expect(0, 2307, '\P{Is_Grapheme_Cluster_Break=_	SPACINGMARK}', "");
Expect(1, 2307, '\P{^Is_Grapheme_Cluster_Break=_	SPACINGMARK}', "");
Expect(0, 2306, '\p{Is_Grapheme_Cluster_Break=_	SPACINGMARK}', "");
Expect(1, 2306, '\p{^Is_Grapheme_Cluster_Break=_	SPACINGMARK}', "");
Expect(1, 2306, '\P{Is_Grapheme_Cluster_Break=_	SPACINGMARK}', "");
Expect(0, 2306, '\P{^Is_Grapheme_Cluster_Break=_	SPACINGMARK}', "");
Error('\p{Is_GCB=	/a/SM}');
Error('\P{Is_GCB=	/a/SM}');
Expect(1, 2307, '\p{Is_GCB=sm}', "");
Expect(0, 2307, '\p{^Is_GCB=sm}', "");
Expect(0, 2307, '\P{Is_GCB=sm}', "");
Expect(1, 2307, '\P{^Is_GCB=sm}', "");
Expect(0, 2306, '\p{Is_GCB=sm}', "");
Expect(1, 2306, '\p{^Is_GCB=sm}', "");
Expect(1, 2306, '\P{Is_GCB=sm}', "");
Expect(0, 2306, '\P{^Is_GCB=sm}', "");
Expect(1, 2307, '\p{Is_GCB:    SM}', "");
Expect(0, 2307, '\p{^Is_GCB:    SM}', "");
Expect(0, 2307, '\P{Is_GCB:    SM}', "");
Expect(1, 2307, '\P{^Is_GCB:    SM}', "");
Expect(0, 2306, '\p{Is_GCB:    SM}', "");
Expect(1, 2306, '\p{^Is_GCB:    SM}', "");
Expect(1, 2306, '\P{Is_GCB:    SM}', "");
Expect(0, 2306, '\P{^Is_GCB:    SM}', "");
Error('\p{Grapheme_Cluster_Break=_/a/T}');
Error('\P{Grapheme_Cluster_Break=_/a/T}');
Expect(1, 4607, '\p{Grapheme_Cluster_Break=t}', "");
Expect(0, 4607, '\p{^Grapheme_Cluster_Break=t}', "");
Expect(0, 4607, '\P{Grapheme_Cluster_Break=t}', "");
Expect(1, 4607, '\P{^Grapheme_Cluster_Break=t}', "");
Expect(0, 4519, '\p{Grapheme_Cluster_Break=t}', "");
Expect(1, 4519, '\p{^Grapheme_Cluster_Break=t}', "");
Expect(1, 4519, '\P{Grapheme_Cluster_Break=t}', "");
Expect(0, 4519, '\P{^Grapheme_Cluster_Break=t}', "");
Expect(1, 4607, '\p{Grapheme_Cluster_Break=_-T}', "");
Expect(0, 4607, '\p{^Grapheme_Cluster_Break=_-T}', "");
Expect(0, 4607, '\P{Grapheme_Cluster_Break=_-T}', "");
Expect(1, 4607, '\P{^Grapheme_Cluster_Break=_-T}', "");
Expect(0, 4519, '\p{Grapheme_Cluster_Break=_-T}', "");
Expect(1, 4519, '\p{^Grapheme_Cluster_Break=_-T}', "");
Expect(1, 4519, '\P{Grapheme_Cluster_Break=_-T}', "");
Expect(0, 4519, '\P{^Grapheme_Cluster_Break=_-T}', "");
Error('\p{GCB=_/a/T}');
Error('\P{GCB=_/a/T}');
Expect(1, 4607, '\p{GCB=t}', "");
Expect(0, 4607, '\p{^GCB=t}', "");
Expect(0, 4607, '\P{GCB=t}', "");
Expect(1, 4607, '\P{^GCB=t}', "");
Expect(0, 4519, '\p{GCB=t}', "");
Expect(1, 4519, '\p{^GCB=t}', "");
Expect(1, 4519, '\P{GCB=t}', "");
Expect(0, 4519, '\P{^GCB=t}', "");
Expect(1, 4607, '\p{GCB:  T}', "");
Expect(0, 4607, '\p{^GCB:  T}', "");
Expect(0, 4607, '\P{GCB:  T}', "");
Expect(1, 4607, '\P{^GCB:  T}', "");
Expect(0, 4519, '\p{GCB:  T}', "");
Expect(1, 4519, '\p{^GCB:  T}', "");
Expect(1, 4519, '\P{GCB:  T}', "");
Expect(0, 4519, '\P{^GCB:  T}', "");
Error('\p{Is_Grapheme_Cluster_Break= /a/T}');
Error('\P{Is_Grapheme_Cluster_Break= /a/T}');
Expect(1, 4607, '\p{Is_Grapheme_Cluster_Break=t}', "");
Expect(0, 4607, '\p{^Is_Grapheme_Cluster_Break=t}', "");
Expect(0, 4607, '\P{Is_Grapheme_Cluster_Break=t}', "");
Expect(1, 4607, '\P{^Is_Grapheme_Cluster_Break=t}', "");
Expect(0, 4519, '\p{Is_Grapheme_Cluster_Break=t}', "");
Expect(1, 4519, '\p{^Is_Grapheme_Cluster_Break=t}', "");
Expect(1, 4519, '\P{Is_Grapheme_Cluster_Break=t}', "");
Expect(0, 4519, '\P{^Is_Grapheme_Cluster_Break=t}', "");
Expect(1, 4607, '\p{Is_Grapheme_Cluster_Break=_-t}', "");
Expect(0, 4607, '\p{^Is_Grapheme_Cluster_Break=_-t}', "");
Expect(0, 4607, '\P{Is_Grapheme_Cluster_Break=_-t}', "");
Expect(1, 4607, '\P{^Is_Grapheme_Cluster_Break=_-t}', "");
Expect(0, 4519, '\p{Is_Grapheme_Cluster_Break=_-t}', "");
Expect(1, 4519, '\p{^Is_Grapheme_Cluster_Break=_-t}', "");
Expect(1, 4519, '\P{Is_Grapheme_Cluster_Break=_-t}', "");
Expect(0, 4519, '\P{^Is_Grapheme_Cluster_Break=_-t}', "");
Error('\p{Is_GCB=-_T/a/}');
Error('\P{Is_GCB=-_T/a/}');
Expect(1, 4607, '\p{Is_GCB=t}', "");
Expect(0, 4607, '\p{^Is_GCB=t}', "");
Expect(0, 4607, '\P{Is_GCB=t}', "");
Expect(1, 4607, '\P{^Is_GCB=t}', "");
Expect(0, 4519, '\p{Is_GCB=t}', "");
Expect(1, 4519, '\p{^Is_GCB=t}', "");
Expect(1, 4519, '\P{Is_GCB=t}', "");
Expect(0, 4519, '\P{^Is_GCB=t}', "");
Expect(1, 4607, '\p{Is_GCB: __T}', "");
Expect(0, 4607, '\p{^Is_GCB: __T}', "");
Expect(0, 4607, '\P{Is_GCB: __T}', "");
Expect(1, 4607, '\P{^Is_GCB: __T}', "");
Expect(0, 4519, '\p{Is_GCB: __T}', "");
Expect(1, 4519, '\p{^Is_GCB: __T}', "");
Expect(1, 4519, '\P{Is_GCB: __T}', "");
Expect(0, 4519, '\P{^Is_GCB: __T}', "");
Error('\p{Grapheme_Cluster_Break:	:=_ LVT}');
Error('\P{Grapheme_Cluster_Break:	:=_ LVT}');
Expect(1, 44059, '\p{Grapheme_Cluster_Break=lvt}', "");
Expect(0, 44059, '\p{^Grapheme_Cluster_Break=lvt}', "");
Expect(0, 44059, '\P{Grapheme_Cluster_Break=lvt}', "");
Expect(1, 44059, '\P{^Grapheme_Cluster_Break=lvt}', "");
Expect(0, 44032, '\p{Grapheme_Cluster_Break=lvt}', "");
Expect(1, 44032, '\p{^Grapheme_Cluster_Break=lvt}', "");
Expect(1, 44032, '\P{Grapheme_Cluster_Break=lvt}', "");
Expect(0, 44032, '\P{^Grapheme_Cluster_Break=lvt}', "");
Expect(1, 44059, '\p{Grapheme_Cluster_Break=	LVT}', "");
Expect(0, 44059, '\p{^Grapheme_Cluster_Break=	LVT}', "");
Expect(0, 44059, '\P{Grapheme_Cluster_Break=	LVT}', "");
Expect(1, 44059, '\P{^Grapheme_Cluster_Break=	LVT}', "");
Expect(0, 44032, '\p{Grapheme_Cluster_Break=	LVT}', "");
Expect(1, 44032, '\p{^Grapheme_Cluster_Break=	LVT}', "");
Expect(1, 44032, '\P{Grapheme_Cluster_Break=	LVT}', "");
Expect(0, 44032, '\P{^Grapheme_Cluster_Break=	LVT}', "");
Error('\p{GCB=- lvt/a/}');
Error('\P{GCB=- lvt/a/}');
Expect(1, 44059, '\p{GCB=lvt}', "");
Expect(0, 44059, '\p{^GCB=lvt}', "");
Expect(0, 44059, '\P{GCB=lvt}', "");
Expect(1, 44059, '\P{^GCB=lvt}', "");
Expect(0, 44032, '\p{GCB=lvt}', "");
Expect(1, 44032, '\p{^GCB=lvt}', "");
Expect(1, 44032, '\P{GCB=lvt}', "");
Expect(0, 44032, '\P{^GCB=lvt}', "");
Expect(1, 44059, '\p{GCB=_-LVT}', "");
Expect(0, 44059, '\p{^GCB=_-LVT}', "");
Expect(0, 44059, '\P{GCB=_-LVT}', "");
Expect(1, 44059, '\P{^GCB=_-LVT}', "");
Expect(0, 44032, '\p{GCB=_-LVT}', "");
Expect(1, 44032, '\p{^GCB=_-LVT}', "");
Expect(1, 44032, '\P{GCB=_-LVT}', "");
Expect(0, 44032, '\P{^GCB=_-LVT}', "");
Error('\p{Is_Grapheme_Cluster_Break:			LVT/a/}');
Error('\P{Is_Grapheme_Cluster_Break:			LVT/a/}');
Expect(1, 44059, '\p{Is_Grapheme_Cluster_Break:	lvt}', "");
Expect(0, 44059, '\p{^Is_Grapheme_Cluster_Break:	lvt}', "");
Expect(0, 44059, '\P{Is_Grapheme_Cluster_Break:	lvt}', "");
Expect(1, 44059, '\P{^Is_Grapheme_Cluster_Break:	lvt}', "");
Expect(0, 44032, '\p{Is_Grapheme_Cluster_Break:	lvt}', "");
Expect(1, 44032, '\p{^Is_Grapheme_Cluster_Break:	lvt}', "");
Expect(1, 44032, '\P{Is_Grapheme_Cluster_Break:	lvt}', "");
Expect(0, 44032, '\P{^Is_Grapheme_Cluster_Break:	lvt}', "");
Expect(1, 44059, '\p{Is_Grapheme_Cluster_Break: --lvt}', "");
Expect(0, 44059, '\p{^Is_Grapheme_Cluster_Break: --lvt}', "");
Expect(0, 44059, '\P{Is_Grapheme_Cluster_Break: --lvt}', "");
Expect(1, 44059, '\P{^Is_Grapheme_Cluster_Break: --lvt}', "");
Expect(0, 44032, '\p{Is_Grapheme_Cluster_Break: --lvt}', "");
Expect(1, 44032, '\p{^Is_Grapheme_Cluster_Break: --lvt}', "");
Expect(1, 44032, '\P{Is_Grapheme_Cluster_Break: --lvt}', "");
Expect(0, 44032, '\P{^Is_Grapheme_Cluster_Break: --lvt}', "");
Error('\p{Is_GCB=_/a/LVT}');
Error('\P{Is_GCB=_/a/LVT}');
Expect(1, 44059, '\p{Is_GCB:   lvt}', "");
Expect(0, 44059, '\p{^Is_GCB:   lvt}', "");
Expect(0, 44059, '\P{Is_GCB:   lvt}', "");
Expect(1, 44059, '\P{^Is_GCB:   lvt}', "");
Expect(0, 44032, '\p{Is_GCB:   lvt}', "");
Expect(1, 44032, '\p{^Is_GCB:   lvt}', "");
Expect(1, 44032, '\P{Is_GCB:   lvt}', "");
Expect(0, 44032, '\P{^Is_GCB:   lvt}', "");
Expect(1, 44059, '\p{Is_GCB=	 LVT}', "");
Expect(0, 44059, '\p{^Is_GCB=	 LVT}', "");
Expect(0, 44059, '\P{Is_GCB=	 LVT}', "");
Expect(1, 44059, '\P{^Is_GCB=	 LVT}', "");
Expect(0, 44032, '\p{Is_GCB=	 LVT}', "");
Expect(1, 44032, '\p{^Is_GCB=	 LVT}', "");
Expect(1, 44032, '\P{Is_GCB=	 LVT}', "");
Expect(0, 44032, '\P{^Is_GCB=	 LVT}', "");
Error('\p{Grapheme_Cluster_Break=:=_	control}');
Error('\P{Grapheme_Cluster_Break=:=_	control}');
Expect(1, 9, '\p{Grapheme_Cluster_Break=control}', "");
Expect(0, 9, '\p{^Grapheme_Cluster_Break=control}', "");
Expect(0, 9, '\P{Grapheme_Cluster_Break=control}', "");
Expect(1, 9, '\P{^Grapheme_Cluster_Break=control}', "");
Expect(0, 10, '\p{Grapheme_Cluster_Break=control}', "");
Expect(1, 10, '\p{^Grapheme_Cluster_Break=control}', "");
Expect(1, 10, '\P{Grapheme_Cluster_Break=control}', "");
Expect(0, 10, '\P{^Grapheme_Cluster_Break=control}', "");
Expect(1, 9, '\p{Grapheme_Cluster_Break:    -Control}', "");
Expect(0, 9, '\p{^Grapheme_Cluster_Break:    -Control}', "");
Expect(0, 9, '\P{Grapheme_Cluster_Break:    -Control}', "");
Expect(1, 9, '\P{^Grapheme_Cluster_Break:    -Control}', "");
Expect(0, 10, '\p{Grapheme_Cluster_Break:    -Control}', "");
Expect(1, 10, '\p{^Grapheme_Cluster_Break:    -Control}', "");
Expect(1, 10, '\P{Grapheme_Cluster_Break:    -Control}', "");
Expect(0, 10, '\P{^Grapheme_Cluster_Break:    -Control}', "");
Error('\p{GCB= :=CN}');
Error('\P{GCB= :=CN}');
Expect(1, 9, '\p{GCB=cn}', "");
Expect(0, 9, '\p{^GCB=cn}', "");
Expect(0, 9, '\P{GCB=cn}', "");
Expect(1, 9, '\P{^GCB=cn}', "");
Expect(0, 10, '\p{GCB=cn}', "");
Expect(1, 10, '\p{^GCB=cn}', "");
Expect(1, 10, '\P{GCB=cn}', "");
Expect(0, 10, '\P{^GCB=cn}', "");
Expect(1, 9, '\p{GCB:	 _cn}', "");
Expect(0, 9, '\p{^GCB:	 _cn}', "");
Expect(0, 9, '\P{GCB:	 _cn}', "");
Expect(1, 9, '\P{^GCB:	 _cn}', "");
Expect(0, 10, '\p{GCB:	 _cn}', "");
Expect(1, 10, '\p{^GCB:	 _cn}', "");
Expect(1, 10, '\P{GCB:	 _cn}', "");
Expect(0, 10, '\P{^GCB:	 _cn}', "");
Error('\p{Is_Grapheme_Cluster_Break: /a/ -CONTROL}');
Error('\P{Is_Grapheme_Cluster_Break: /a/ -CONTROL}');
Expect(1, 9, '\p{Is_Grapheme_Cluster_Break=control}', "");
Expect(0, 9, '\p{^Is_Grapheme_Cluster_Break=control}', "");
Expect(0, 9, '\P{Is_Grapheme_Cluster_Break=control}', "");
Expect(1, 9, '\P{^Is_Grapheme_Cluster_Break=control}', "");
Expect(0, 10, '\p{Is_Grapheme_Cluster_Break=control}', "");
Expect(1, 10, '\p{^Is_Grapheme_Cluster_Break=control}', "");
Expect(1, 10, '\P{Is_Grapheme_Cluster_Break=control}', "");
Expect(0, 10, '\P{^Is_Grapheme_Cluster_Break=control}', "");
Expect(1, 9, '\p{Is_Grapheme_Cluster_Break=-CONTROL}', "");
Expect(0, 9, '\p{^Is_Grapheme_Cluster_Break=-CONTROL}', "");
Expect(0, 9, '\P{Is_Grapheme_Cluster_Break=-CONTROL}', "");
Expect(1, 9, '\P{^Is_Grapheme_Cluster_Break=-CONTROL}', "");
Expect(0, 10, '\p{Is_Grapheme_Cluster_Break=-CONTROL}', "");
Expect(1, 10, '\p{^Is_Grapheme_Cluster_Break=-CONTROL}', "");
Expect(1, 10, '\P{Is_Grapheme_Cluster_Break=-CONTROL}', "");
Expect(0, 10, '\P{^Is_Grapheme_Cluster_Break=-CONTROL}', "");
Error('\p{Is_GCB=_/a/cn}');
Error('\P{Is_GCB=_/a/cn}');
Expect(1, 9, '\p{Is_GCB=cn}', "");
Expect(0, 9, '\p{^Is_GCB=cn}', "");
Expect(0, 9, '\P{Is_GCB=cn}', "");
Expect(1, 9, '\P{^Is_GCB=cn}', "");
Expect(0, 10, '\p{Is_GCB=cn}', "");
Expect(1, 10, '\p{^Is_GCB=cn}', "");
Expect(1, 10, '\P{Is_GCB=cn}', "");
Expect(0, 10, '\P{^Is_GCB=cn}', "");
Expect(1, 9, '\p{Is_GCB=-CN}', "");
Expect(0, 9, '\p{^Is_GCB=-CN}', "");
Expect(0, 9, '\P{Is_GCB=-CN}', "");
Expect(1, 9, '\P{^Is_GCB=-CN}', "");
Expect(0, 10, '\p{Is_GCB=-CN}', "");
Expect(1, 10, '\p{^Is_GCB=-CN}', "");
Expect(1, 10, '\P{Is_GCB=-CN}', "");
Expect(0, 10, '\P{^Is_GCB=-CN}', "");
Error('\p{Grapheme_Cluster_Break=	PREPEND:=}');
Error('\P{Grapheme_Cluster_Break=	PREPEND:=}');
Expect(1, 3652, '\p{Grapheme_Cluster_Break=prepend}', "");
Expect(0, 3652, '\p{^Grapheme_Cluster_Break=prepend}', "");
Expect(0, 3652, '\P{Grapheme_Cluster_Break=prepend}', "");
Expect(1, 3652, '\P{^Grapheme_Cluster_Break=prepend}', "");
Expect(0, 3647, '\p{Grapheme_Cluster_Break=prepend}', "");
Expect(1, 3647, '\p{^Grapheme_Cluster_Break=prepend}', "");
Expect(1, 3647, '\P{Grapheme_Cluster_Break=prepend}', "");
Expect(0, 3647, '\P{^Grapheme_Cluster_Break=prepend}', "");
Expect(1, 3652, '\p{Grapheme_Cluster_Break=	Prepend}', "");
Expect(0, 3652, '\p{^Grapheme_Cluster_Break=	Prepend}', "");
Expect(0, 3652, '\P{Grapheme_Cluster_Break=	Prepend}', "");
Expect(1, 3652, '\P{^Grapheme_Cluster_Break=	Prepend}', "");
Expect(0, 3647, '\p{Grapheme_Cluster_Break=	Prepend}', "");
Expect(1, 3647, '\p{^Grapheme_Cluster_Break=	Prepend}', "");
Expect(1, 3647, '\P{Grapheme_Cluster_Break=	Prepend}', "");
Expect(0, 3647, '\P{^Grapheme_Cluster_Break=	Prepend}', "");
Error('\p{GCB=/a/-PP}');
Error('\P{GCB=/a/-PP}');
Expect(1, 3652, '\p{GCB:   pp}', "");
Expect(0, 3652, '\p{^GCB:   pp}', "");
Expect(0, 3652, '\P{GCB:   pp}', "");
Expect(1, 3652, '\P{^GCB:   pp}', "");
Expect(0, 3647, '\p{GCB:   pp}', "");
Expect(1, 3647, '\p{^GCB:   pp}', "");
Expect(1, 3647, '\P{GCB:   pp}', "");
Expect(0, 3647, '\P{^GCB:   pp}', "");
Expect(1, 3652, '\p{GCB=- PP}', "");
Expect(0, 3652, '\p{^GCB=- PP}', "");
Expect(0, 3652, '\P{GCB=- PP}', "");
Expect(1, 3652, '\P{^GCB=- PP}', "");
Expect(0, 3647, '\p{GCB=- PP}', "");
Expect(1, 3647, '\p{^GCB=- PP}', "");
Expect(1, 3647, '\P{GCB=- PP}', "");
Expect(0, 3647, '\P{^GCB=- PP}', "");
Error('\p{Is_Grapheme_Cluster_Break=:= prepend}');
Error('\P{Is_Grapheme_Cluster_Break=:= prepend}');
Expect(1, 3652, '\p{Is_Grapheme_Cluster_Break=prepend}', "");
Expect(0, 3652, '\p{^Is_Grapheme_Cluster_Break=prepend}', "");
Expect(0, 3652, '\P{Is_Grapheme_Cluster_Break=prepend}', "");
Expect(1, 3652, '\P{^Is_Grapheme_Cluster_Break=prepend}', "");
Expect(0, 3647, '\p{Is_Grapheme_Cluster_Break=prepend}', "");
Expect(1, 3647, '\p{^Is_Grapheme_Cluster_Break=prepend}', "");
Expect(1, 3647, '\P{Is_Grapheme_Cluster_Break=prepend}', "");
Expect(0, 3647, '\P{^Is_Grapheme_Cluster_Break=prepend}', "");
Expect(1, 3652, '\p{Is_Grapheme_Cluster_Break:	 Prepend}', "");
Expect(0, 3652, '\p{^Is_Grapheme_Cluster_Break:	 Prepend}', "");
Expect(0, 3652, '\P{Is_Grapheme_Cluster_Break:	 Prepend}', "");
Expect(1, 3652, '\P{^Is_Grapheme_Cluster_Break:	 Prepend}', "");
Expect(0, 3647, '\p{Is_Grapheme_Cluster_Break:	 Prepend}', "");
Expect(1, 3647, '\p{^Is_Grapheme_Cluster_Break:	 Prepend}', "");
Expect(1, 3647, '\P{Is_Grapheme_Cluster_Break:	 Prepend}', "");
Expect(0, 3647, '\P{^Is_Grapheme_Cluster_Break:	 Prepend}', "");
Error('\p{Is_GCB:	:= 	pp}');
Error('\P{Is_GCB:	:= 	pp}');
Expect(1, 3652, '\p{Is_GCB:   pp}', "");
Expect(0, 3652, '\p{^Is_GCB:   pp}', "");
Expect(0, 3652, '\P{Is_GCB:   pp}', "");
Expect(1, 3652, '\P{^Is_GCB:   pp}', "");
Expect(0, 3647, '\p{Is_GCB:   pp}', "");
Expect(1, 3647, '\p{^Is_GCB:   pp}', "");
Expect(1, 3647, '\P{Is_GCB:   pp}', "");
Expect(0, 3647, '\P{^Is_GCB:   pp}', "");
Expect(1, 3652, '\p{Is_GCB=	 PP}', "");
Expect(0, 3652, '\p{^Is_GCB=	 PP}', "");
Expect(0, 3652, '\P{Is_GCB=	 PP}', "");
Expect(1, 3652, '\P{^Is_GCB=	 PP}', "");
Expect(0, 3647, '\p{Is_GCB=	 PP}', "");
Expect(1, 3647, '\p{^Is_GCB=	 PP}', "");
Expect(1, 3647, '\P{Is_GCB=	 PP}', "");
Expect(0, 3647, '\P{^Is_GCB=	 PP}', "");
Error('\p{Grapheme_Cluster_Break:	:=LV}');
Error('\P{Grapheme_Cluster_Break:	:=LV}');
Expect(1, 44032, '\p{Grapheme_Cluster_Break=lv}', "");
Expect(0, 44032, '\p{^Grapheme_Cluster_Break=lv}', "");
Expect(0, 44032, '\P{Grapheme_Cluster_Break=lv}', "");
Expect(1, 44032, '\P{^Grapheme_Cluster_Break=lv}', "");
Expect(0, 44031, '\p{Grapheme_Cluster_Break=lv}', "");
Expect(1, 44031, '\p{^Grapheme_Cluster_Break=lv}', "");
Expect(1, 44031, '\P{Grapheme_Cluster_Break=lv}', "");
Expect(0, 44031, '\P{^Grapheme_Cluster_Break=lv}', "");
Expect(1, 44032, '\p{Grapheme_Cluster_Break=__lv}', "");
Expect(0, 44032, '\p{^Grapheme_Cluster_Break=__lv}', "");
Expect(0, 44032, '\P{Grapheme_Cluster_Break=__lv}', "");
Expect(1, 44032, '\P{^Grapheme_Cluster_Break=__lv}', "");
Expect(0, 44031, '\p{Grapheme_Cluster_Break=__lv}', "");
Expect(1, 44031, '\p{^Grapheme_Cluster_Break=__lv}', "");
Expect(1, 44031, '\P{Grapheme_Cluster_Break=__lv}', "");
Expect(0, 44031, '\P{^Grapheme_Cluster_Break=__lv}', "");
Error('\p{GCB=/a/		LV}');
Error('\P{GCB=/a/		LV}');
Expect(1, 44032, '\p{GCB=lv}', "");
Expect(0, 44032, '\p{^GCB=lv}', "");
Expect(0, 44032, '\P{GCB=lv}', "");
Expect(1, 44032, '\P{^GCB=lv}', "");
Expect(0, 44031, '\p{GCB=lv}', "");
Expect(1, 44031, '\p{^GCB=lv}', "");
Expect(1, 44031, '\P{GCB=lv}', "");
Expect(0, 44031, '\P{^GCB=lv}', "");
Expect(1, 44032, '\p{GCB=_lv}', "");
Expect(0, 44032, '\p{^GCB=_lv}', "");
Expect(0, 44032, '\P{GCB=_lv}', "");
Expect(1, 44032, '\P{^GCB=_lv}', "");
Expect(0, 44031, '\p{GCB=_lv}', "");
Expect(1, 44031, '\p{^GCB=_lv}', "");
Expect(1, 44031, '\P{GCB=_lv}', "");
Expect(0, 44031, '\P{^GCB=_lv}', "");
Error('\p{Is_Grapheme_Cluster_Break=-/a/LV}');
Error('\P{Is_Grapheme_Cluster_Break=-/a/LV}');
Expect(1, 44032, '\p{Is_Grapheme_Cluster_Break=lv}', "");
Expect(0, 44032, '\p{^Is_Grapheme_Cluster_Break=lv}', "");
Expect(0, 44032, '\P{Is_Grapheme_Cluster_Break=lv}', "");
Expect(1, 44032, '\P{^Is_Grapheme_Cluster_Break=lv}', "");
Expect(0, 44031, '\p{Is_Grapheme_Cluster_Break=lv}', "");
Expect(1, 44031, '\p{^Is_Grapheme_Cluster_Break=lv}', "");
Expect(1, 44031, '\P{Is_Grapheme_Cluster_Break=lv}', "");
Expect(0, 44031, '\P{^Is_Grapheme_Cluster_Break=lv}', "");
Expect(1, 44032, '\p{Is_Grapheme_Cluster_Break= -LV}', "");
Expect(0, 44032, '\p{^Is_Grapheme_Cluster_Break= -LV}', "");
Expect(0, 44032, '\P{Is_Grapheme_Cluster_Break= -LV}', "");
Expect(1, 44032, '\P{^Is_Grapheme_Cluster_Break= -LV}', "");
Expect(0, 44031, '\p{Is_Grapheme_Cluster_Break= -LV}', "");
Expect(1, 44031, '\p{^Is_Grapheme_Cluster_Break= -LV}', "");
Expect(1, 44031, '\P{Is_Grapheme_Cluster_Break= -LV}', "");
Expect(0, 44031, '\P{^Is_Grapheme_Cluster_Break= -LV}', "");
Error('\p{Is_GCB= lv/a/}');
Error('\P{Is_GCB= lv/a/}');
Expect(1, 44032, '\p{Is_GCB=lv}', "");
Expect(0, 44032, '\p{^Is_GCB=lv}', "");
Expect(0, 44032, '\P{Is_GCB=lv}', "");
Expect(1, 44032, '\P{^Is_GCB=lv}', "");
Expect(0, 44031, '\p{Is_GCB=lv}', "");
Expect(1, 44031, '\p{^Is_GCB=lv}', "");
Expect(1, 44031, '\P{Is_GCB=lv}', "");
Expect(0, 44031, '\P{^Is_GCB=lv}', "");
Expect(1, 44032, '\p{Is_GCB=	_LV}', "");
Expect(0, 44032, '\p{^Is_GCB=	_LV}', "");
Expect(0, 44032, '\P{Is_GCB=	_LV}', "");
Expect(1, 44032, '\P{^Is_GCB=	_LV}', "");
Expect(0, 44031, '\p{Is_GCB=	_LV}', "");
Expect(1, 44031, '\p{^Is_GCB=	_LV}', "");
Expect(1, 44031, '\P{Is_GCB=	_LV}', "");
Expect(0, 44031, '\P{^Is_GCB=	_LV}', "");
Error('\p{Grapheme_Cluster_Break=_CR:=}');
Error('\P{Grapheme_Cluster_Break=_CR:=}');
Expect(1, 13, '\p{Grapheme_Cluster_Break=cr}', "");
Expect(0, 13, '\p{^Grapheme_Cluster_Break=cr}', "");
Expect(0, 13, '\P{Grapheme_Cluster_Break=cr}', "");
Expect(1, 13, '\P{^Grapheme_Cluster_Break=cr}', "");
Expect(0, 12, '\p{Grapheme_Cluster_Break=cr}', "");
Expect(1, 12, '\p{^Grapheme_Cluster_Break=cr}', "");
Expect(1, 12, '\P{Grapheme_Cluster_Break=cr}', "");
Expect(0, 12, '\P{^Grapheme_Cluster_Break=cr}', "");
Expect(1, 13, '\p{Grapheme_Cluster_Break:	-	CR}', "");
Expect(0, 13, '\p{^Grapheme_Cluster_Break:	-	CR}', "");
Expect(0, 13, '\P{Grapheme_Cluster_Break:	-	CR}', "");
Expect(1, 13, '\P{^Grapheme_Cluster_Break:	-	CR}', "");
Expect(0, 12, '\p{Grapheme_Cluster_Break:	-	CR}', "");
Expect(1, 12, '\p{^Grapheme_Cluster_Break:	-	CR}', "");
Expect(1, 12, '\P{Grapheme_Cluster_Break:	-	CR}', "");
Expect(0, 12, '\P{^Grapheme_Cluster_Break:	-	CR}', "");
Error('\p{GCB=/a/CR}');
Error('\P{GCB=/a/CR}');
Expect(1, 13, '\p{GCB=cr}', "");
Expect(0, 13, '\p{^GCB=cr}', "");
Expect(0, 13, '\P{GCB=cr}', "");
Expect(1, 13, '\P{^GCB=cr}', "");
Expect(0, 12, '\p{GCB=cr}', "");
Expect(1, 12, '\p{^GCB=cr}', "");
Expect(1, 12, '\P{GCB=cr}', "");
Expect(0, 12, '\P{^GCB=cr}', "");
Expect(1, 13, '\p{GCB=_ CR}', "");
Expect(0, 13, '\p{^GCB=_ CR}', "");
Expect(0, 13, '\P{GCB=_ CR}', "");
Expect(1, 13, '\P{^GCB=_ CR}', "");
Expect(0, 12, '\p{GCB=_ CR}', "");
Expect(1, 12, '\p{^GCB=_ CR}', "");
Expect(1, 12, '\P{GCB=_ CR}', "");
Expect(0, 12, '\P{^GCB=_ CR}', "");
Error('\p{Is_Grapheme_Cluster_Break=	:=CR}');
Error('\P{Is_Grapheme_Cluster_Break=	:=CR}');
Expect(1, 13, '\p{Is_Grapheme_Cluster_Break=cr}', "");
Expect(0, 13, '\p{^Is_Grapheme_Cluster_Break=cr}', "");
Expect(0, 13, '\P{Is_Grapheme_Cluster_Break=cr}', "");
Expect(1, 13, '\P{^Is_Grapheme_Cluster_Break=cr}', "");
Expect(0, 12, '\p{Is_Grapheme_Cluster_Break=cr}', "");
Expect(1, 12, '\p{^Is_Grapheme_Cluster_Break=cr}', "");
Expect(1, 12, '\P{Is_Grapheme_Cluster_Break=cr}', "");
Expect(0, 12, '\P{^Is_Grapheme_Cluster_Break=cr}', "");
Expect(1, 13, '\p{Is_Grapheme_Cluster_Break=_-CR}', "");
Expect(0, 13, '\p{^Is_Grapheme_Cluster_Break=_-CR}', "");
Expect(0, 13, '\P{Is_Grapheme_Cluster_Break=_-CR}', "");
Expect(1, 13, '\P{^Is_Grapheme_Cluster_Break=_-CR}', "");
Expect(0, 12, '\p{Is_Grapheme_Cluster_Break=_-CR}', "");
Expect(1, 12, '\p{^Is_Grapheme_Cluster_Break=_-CR}', "");
Expect(1, 12, '\P{Is_Grapheme_Cluster_Break=_-CR}', "");
Expect(0, 12, '\P{^Is_Grapheme_Cluster_Break=_-CR}', "");
Error('\p{Is_GCB=:=-CR}');
Error('\P{Is_GCB=:=-CR}');
Expect(1, 13, '\p{Is_GCB=cr}', "");
Expect(0, 13, '\p{^Is_GCB=cr}', "");
Expect(0, 13, '\P{Is_GCB=cr}', "");
Expect(1, 13, '\P{^Is_GCB=cr}', "");
Expect(0, 12, '\p{Is_GCB=cr}', "");
Expect(1, 12, '\p{^Is_GCB=cr}', "");
Expect(1, 12, '\P{Is_GCB=cr}', "");
Expect(0, 12, '\P{^Is_GCB=cr}', "");
Expect(1, 13, '\p{Is_GCB:	CR}', "");
Expect(0, 13, '\p{^Is_GCB:	CR}', "");
Expect(0, 13, '\P{Is_GCB:	CR}', "");
Expect(1, 13, '\P{^Is_GCB:	CR}', "");
Expect(0, 12, '\p{Is_GCB:	CR}', "");
Expect(1, 12, '\p{^Is_GCB:	CR}', "");
Expect(1, 12, '\P{Is_GCB:	CR}', "");
Expect(0, 12, '\P{^Is_GCB:	CR}', "");
Error('\p{Grapheme_Cluster_Break=		other/a/}');
Error('\P{Grapheme_Cluster_Break=		other/a/}');
Expect(1, 126, '\p{Grapheme_Cluster_Break:   other}', "");
Expect(0, 126, '\p{^Grapheme_Cluster_Break:   other}', "");
Expect(0, 126, '\P{Grapheme_Cluster_Break:   other}', "");
Expect(1, 126, '\P{^Grapheme_Cluster_Break:   other}', "");
Expect(0, 31, '\p{Grapheme_Cluster_Break:   other}', "");
Expect(1, 31, '\p{^Grapheme_Cluster_Break:   other}', "");
Expect(1, 31, '\P{Grapheme_Cluster_Break:   other}', "");
Expect(0, 31, '\P{^Grapheme_Cluster_Break:   other}', "");
Expect(1, 126, '\p{Grapheme_Cluster_Break=	Other}', "");
Expect(0, 126, '\p{^Grapheme_Cluster_Break=	Other}', "");
Expect(0, 126, '\P{Grapheme_Cluster_Break=	Other}', "");
Expect(1, 126, '\P{^Grapheme_Cluster_Break=	Other}', "");
Expect(0, 31, '\p{Grapheme_Cluster_Break=	Other}', "");
Expect(1, 31, '\p{^Grapheme_Cluster_Break=	Other}', "");
Expect(1, 31, '\P{Grapheme_Cluster_Break=	Other}', "");
Expect(0, 31, '\P{^Grapheme_Cluster_Break=	Other}', "");
Error('\p{GCB=_	xx/a/}');
Error('\P{GCB=_	xx/a/}');
Expect(1, 126, '\p{GCB=xx}', "");
Expect(0, 126, '\p{^GCB=xx}', "");
Expect(0, 126, '\P{GCB=xx}', "");
Expect(1, 126, '\P{^GCB=xx}', "");
Expect(0, 31, '\p{GCB=xx}', "");
Expect(1, 31, '\p{^GCB=xx}', "");
Expect(1, 31, '\P{GCB=xx}', "");
Expect(0, 31, '\P{^GCB=xx}', "");
Expect(1, 126, '\p{GCB:    XX}', "");
Expect(0, 126, '\p{^GCB:    XX}', "");
Expect(0, 126, '\P{GCB:    XX}', "");
Expect(1, 126, '\P{^GCB:    XX}', "");
Expect(0, 31, '\p{GCB:    XX}', "");
Expect(1, 31, '\p{^GCB:    XX}', "");
Expect(1, 31, '\P{GCB:    XX}', "");
Expect(0, 31, '\P{^GCB:    XX}', "");
Error('\p{Is_Grapheme_Cluster_Break:	_/a/Other}');
Error('\P{Is_Grapheme_Cluster_Break:	_/a/Other}');
Expect(1, 126, '\p{Is_Grapheme_Cluster_Break=other}', "");
Expect(0, 126, '\p{^Is_Grapheme_Cluster_Break=other}', "");
Expect(0, 126, '\P{Is_Grapheme_Cluster_Break=other}', "");
Expect(1, 126, '\P{^Is_Grapheme_Cluster_Break=other}', "");
Expect(0, 31, '\p{Is_Grapheme_Cluster_Break=other}', "");
Expect(1, 31, '\p{^Is_Grapheme_Cluster_Break=other}', "");
Expect(1, 31, '\P{Is_Grapheme_Cluster_Break=other}', "");
Expect(0, 31, '\P{^Is_Grapheme_Cluster_Break=other}', "");
Expect(1, 126, '\p{Is_Grapheme_Cluster_Break=	-Other}', "");
Expect(0, 126, '\p{^Is_Grapheme_Cluster_Break=	-Other}', "");
Expect(0, 126, '\P{Is_Grapheme_Cluster_Break=	-Other}', "");
Expect(1, 126, '\P{^Is_Grapheme_Cluster_Break=	-Other}', "");
Expect(0, 31, '\p{Is_Grapheme_Cluster_Break=	-Other}', "");
Expect(1, 31, '\p{^Is_Grapheme_Cluster_Break=	-Other}', "");
Expect(1, 31, '\P{Is_Grapheme_Cluster_Break=	-Other}', "");
Expect(0, 31, '\P{^Is_Grapheme_Cluster_Break=	-Other}', "");
Error('\p{Is_GCB=:=		XX}');
Error('\P{Is_GCB=:=		XX}');
Expect(1, 126, '\p{Is_GCB=xx}', "");
Expect(0, 126, '\p{^Is_GCB=xx}', "");
Expect(0, 126, '\P{Is_GCB=xx}', "");
Expect(1, 126, '\P{^Is_GCB=xx}', "");
Expect(0, 31, '\p{Is_GCB=xx}', "");
Expect(1, 31, '\p{^Is_GCB=xx}', "");
Expect(1, 31, '\P{Is_GCB=xx}', "");
Expect(0, 31, '\P{^Is_GCB=xx}', "");
Expect(1, 126, '\p{Is_GCB= 	XX}', "");
Expect(0, 126, '\p{^Is_GCB= 	XX}', "");
Expect(0, 126, '\P{Is_GCB= 	XX}', "");
Expect(1, 126, '\P{^Is_GCB= 	XX}', "");
Expect(0, 31, '\p{Is_GCB= 	XX}', "");
Expect(1, 31, '\p{^Is_GCB= 	XX}', "");
Expect(1, 31, '\P{Is_GCB= 	XX}', "");
Expect(0, 31, '\P{^Is_GCB= 	XX}', "");
Error('\p{Grapheme_Cluster_Break=	-Extend:=}');
Error('\P{Grapheme_Cluster_Break=	-Extend:=}');
Expect(1, 879, '\p{Grapheme_Cluster_Break=extend}', "");
Expect(0, 879, '\p{^Grapheme_Cluster_Break=extend}', "");
Expect(0, 879, '\P{Grapheme_Cluster_Break=extend}', "");
Expect(1, 879, '\P{^Grapheme_Cluster_Break=extend}', "");
Expect(0, 767, '\p{Grapheme_Cluster_Break=extend}', "");
Expect(1, 767, '\p{^Grapheme_Cluster_Break=extend}', "");
Expect(1, 767, '\P{Grapheme_Cluster_Break=extend}', "");
Expect(0, 767, '\P{^Grapheme_Cluster_Break=extend}', "");
Expect(1, 879, '\p{Grapheme_Cluster_Break=-_Extend}', "");
Expect(0, 879, '\p{^Grapheme_Cluster_Break=-_Extend}', "");
Expect(0, 879, '\P{Grapheme_Cluster_Break=-_Extend}', "");
Expect(1, 879, '\P{^Grapheme_Cluster_Break=-_Extend}', "");
Expect(0, 767, '\p{Grapheme_Cluster_Break=-_Extend}', "");
Expect(1, 767, '\p{^Grapheme_Cluster_Break=-_Extend}', "");
Expect(1, 767, '\P{Grapheme_Cluster_Break=-_Extend}', "");
Expect(0, 767, '\P{^Grapheme_Cluster_Break=-_Extend}', "");
Error('\p{GCB=-:=ex}');
Error('\P{GCB=-:=ex}');
Expect(1, 879, '\p{GCB=ex}', "");
Expect(0, 879, '\p{^GCB=ex}', "");
Expect(0, 879, '\P{GCB=ex}', "");
Expect(1, 879, '\P{^GCB=ex}', "");
Expect(0, 767, '\p{GCB=ex}', "");
Expect(1, 767, '\p{^GCB=ex}', "");
Expect(1, 767, '\P{GCB=ex}', "");
Expect(0, 767, '\P{^GCB=ex}', "");
Expect(1, 879, '\p{GCB=	-EX}', "");
Expect(0, 879, '\p{^GCB=	-EX}', "");
Expect(0, 879, '\P{GCB=	-EX}', "");
Expect(1, 879, '\P{^GCB=	-EX}', "");
Expect(0, 767, '\p{GCB=	-EX}', "");
Expect(1, 767, '\p{^GCB=	-EX}', "");
Expect(1, 767, '\P{GCB=	-EX}', "");
Expect(0, 767, '\P{^GCB=	-EX}', "");
Error('\p{Is_Grapheme_Cluster_Break= extend/a/}');
Error('\P{Is_Grapheme_Cluster_Break= extend/a/}');
Expect(1, 879, '\p{Is_Grapheme_Cluster_Break=extend}', "");
Expect(0, 879, '\p{^Is_Grapheme_Cluster_Break=extend}', "");
Expect(0, 879, '\P{Is_Grapheme_Cluster_Break=extend}', "");
Expect(1, 879, '\P{^Is_Grapheme_Cluster_Break=extend}', "");
Expect(0, 767, '\p{Is_Grapheme_Cluster_Break=extend}', "");
Expect(1, 767, '\p{^Is_Grapheme_Cluster_Break=extend}', "");
Expect(1, 767, '\P{Is_Grapheme_Cluster_Break=extend}', "");
Expect(0, 767, '\P{^Is_Grapheme_Cluster_Break=extend}', "");
Expect(1, 879, '\p{Is_Grapheme_Cluster_Break= -Extend}', "");
Expect(0, 879, '\p{^Is_Grapheme_Cluster_Break= -Extend}', "");
Expect(0, 879, '\P{Is_Grapheme_Cluster_Break= -Extend}', "");
Expect(1, 879, '\P{^Is_Grapheme_Cluster_Break= -Extend}', "");
Expect(0, 767, '\p{Is_Grapheme_Cluster_Break= -Extend}', "");
Expect(1, 767, '\p{^Is_Grapheme_Cluster_Break= -Extend}', "");
Expect(1, 767, '\P{Is_Grapheme_Cluster_Break= -Extend}', "");
Expect(0, 767, '\P{^Is_Grapheme_Cluster_Break= -Extend}', "");
Error('\p{Is_GCB=	:=ex}');
Error('\P{Is_GCB=	:=ex}');
Expect(1, 879, '\p{Is_GCB=ex}', "");
Expect(0, 879, '\p{^Is_GCB=ex}', "");
Expect(0, 879, '\P{Is_GCB=ex}', "");
Expect(1, 879, '\P{^Is_GCB=ex}', "");
Expect(0, 767, '\p{Is_GCB=ex}', "");
Expect(1, 767, '\p{^Is_GCB=ex}', "");
Expect(1, 767, '\P{Is_GCB=ex}', "");
Expect(0, 767, '\P{^Is_GCB=ex}', "");
Expect(1, 879, '\p{Is_GCB: -_ex}', "");
Expect(0, 879, '\p{^Is_GCB: -_ex}', "");
Expect(0, 879, '\P{Is_GCB: -_ex}', "");
Expect(1, 879, '\P{^Is_GCB: -_ex}', "");
Expect(0, 767, '\p{Is_GCB: -_ex}', "");
Expect(1, 767, '\p{^Is_GCB: -_ex}', "");
Expect(1, 767, '\P{Is_GCB: -_ex}', "");
Expect(0, 767, '\P{^Is_GCB: -_ex}', "");
Error('\p{Grapheme_Cluster_Break=-v/a/}');
Error('\P{Grapheme_Cluster_Break=-v/a/}');
Expect(1, 4519, '\p{Grapheme_Cluster_Break=v}', "");
Expect(0, 4519, '\p{^Grapheme_Cluster_Break=v}', "");
Expect(0, 4519, '\P{Grapheme_Cluster_Break=v}', "");
Expect(1, 4519, '\P{^Grapheme_Cluster_Break=v}', "");
Expect(0, 4447, '\p{Grapheme_Cluster_Break=v}', "");
Expect(1, 4447, '\p{^Grapheme_Cluster_Break=v}', "");
Expect(1, 4447, '\P{Grapheme_Cluster_Break=v}', "");
Expect(0, 4447, '\P{^Grapheme_Cluster_Break=v}', "");
Expect(1, 4519, '\p{Grapheme_Cluster_Break= v}', "");
Expect(0, 4519, '\p{^Grapheme_Cluster_Break= v}', "");
Expect(0, 4519, '\P{Grapheme_Cluster_Break= v}', "");
Expect(1, 4519, '\P{^Grapheme_Cluster_Break= v}', "");
Expect(0, 4447, '\p{Grapheme_Cluster_Break= v}', "");
Expect(1, 4447, '\p{^Grapheme_Cluster_Break= v}', "");
Expect(1, 4447, '\P{Grapheme_Cluster_Break= v}', "");
Expect(0, 4447, '\P{^Grapheme_Cluster_Break= v}', "");
Error('\p{GCB=:=	V}');
Error('\P{GCB=:=	V}');
Expect(1, 4519, '\p{GCB=v}', "");
Expect(0, 4519, '\p{^GCB=v}', "");
Expect(0, 4519, '\P{GCB=v}', "");
Expect(1, 4519, '\P{^GCB=v}', "");
Expect(0, 4447, '\p{GCB=v}', "");
Expect(1, 4447, '\p{^GCB=v}', "");
Expect(1, 4447, '\P{GCB=v}', "");
Expect(0, 4447, '\P{^GCB=v}', "");
Expect(1, 4519, '\p{GCB=  V}', "");
Expect(0, 4519, '\p{^GCB=  V}', "");
Expect(0, 4519, '\P{GCB=  V}', "");
Expect(1, 4519, '\P{^GCB=  V}', "");
Expect(0, 4447, '\p{GCB=  V}', "");
Expect(1, 4447, '\p{^GCB=  V}', "");
Expect(1, 4447, '\P{GCB=  V}', "");
Expect(0, 4447, '\P{^GCB=  V}', "");
Error('\p{Is_Grapheme_Cluster_Break=:=		V}');
Error('\P{Is_Grapheme_Cluster_Break=:=		V}');
Expect(1, 4519, '\p{Is_Grapheme_Cluster_Break=v}', "");
Expect(0, 4519, '\p{^Is_Grapheme_Cluster_Break=v}', "");
Expect(0, 4519, '\P{Is_Grapheme_Cluster_Break=v}', "");
Expect(1, 4519, '\P{^Is_Grapheme_Cluster_Break=v}', "");
Expect(0, 4447, '\p{Is_Grapheme_Cluster_Break=v}', "");
Expect(1, 4447, '\p{^Is_Grapheme_Cluster_Break=v}', "");
Expect(1, 4447, '\P{Is_Grapheme_Cluster_Break=v}', "");
Expect(0, 4447, '\P{^Is_Grapheme_Cluster_Break=v}', "");
Expect(1, 4519, '\p{Is_Grapheme_Cluster_Break=  V}', "");
Expect(0, 4519, '\p{^Is_Grapheme_Cluster_Break=  V}', "");
Expect(0, 4519, '\P{Is_Grapheme_Cluster_Break=  V}', "");
Expect(1, 4519, '\P{^Is_Grapheme_Cluster_Break=  V}', "");
Expect(0, 4447, '\p{Is_Grapheme_Cluster_Break=  V}', "");
Expect(1, 4447, '\p{^Is_Grapheme_Cluster_Break=  V}', "");
Expect(1, 4447, '\P{Is_Grapheme_Cluster_Break=  V}', "");
Expect(0, 4447, '\P{^Is_Grapheme_Cluster_Break=  V}', "");
Error('\p{Is_GCB=	:=v}');
Error('\P{Is_GCB=	:=v}');
Expect(1, 4519, '\p{Is_GCB=v}', "");
Expect(0, 4519, '\p{^Is_GCB=v}', "");
Expect(0, 4519, '\P{Is_GCB=v}', "");
Expect(1, 4519, '\P{^Is_GCB=v}', "");
Expect(0, 4447, '\p{Is_GCB=v}', "");
Expect(1, 4447, '\p{^Is_GCB=v}', "");
Expect(1, 4447, '\P{Is_GCB=v}', "");
Expect(0, 4447, '\P{^Is_GCB=v}', "");
Expect(1, 4519, '\p{Is_GCB=-	V}', "");
Expect(0, 4519, '\p{^Is_GCB=-	V}', "");
Expect(0, 4519, '\P{Is_GCB=-	V}', "");
Expect(1, 4519, '\P{^Is_GCB=-	V}', "");
Expect(0, 4447, '\p{Is_GCB=-	V}', "");
Expect(1, 4447, '\p{^Is_GCB=-	V}', "");
Expect(1, 4447, '\P{Is_GCB=-	V}', "");
Expect(0, 4447, '\P{^Is_GCB=-	V}', "");
Error('\p{Grapheme_Cluster_Break=/a/	 LF}');
Error('\P{Grapheme_Cluster_Break=/a/	 LF}');
Expect(1, 10, '\p{Grapheme_Cluster_Break=lf}', "");
Expect(0, 10, '\p{^Grapheme_Cluster_Break=lf}', "");
Expect(0, 10, '\P{Grapheme_Cluster_Break=lf}', "");
Expect(1, 10, '\P{^Grapheme_Cluster_Break=lf}', "");
Expect(0, 9, '\p{Grapheme_Cluster_Break=lf}', "");
Expect(1, 9, '\p{^Grapheme_Cluster_Break=lf}', "");
Expect(1, 9, '\P{Grapheme_Cluster_Break=lf}', "");
Expect(0, 9, '\P{^Grapheme_Cluster_Break=lf}', "");
Expect(1, 10, '\p{Grapheme_Cluster_Break=	-LF}', "");
Expect(0, 10, '\p{^Grapheme_Cluster_Break=	-LF}', "");
Expect(0, 10, '\P{Grapheme_Cluster_Break=	-LF}', "");
Expect(1, 10, '\P{^Grapheme_Cluster_Break=	-LF}', "");
Expect(0, 9, '\p{Grapheme_Cluster_Break=	-LF}', "");
Expect(1, 9, '\p{^Grapheme_Cluster_Break=	-LF}', "");
Expect(1, 9, '\P{Grapheme_Cluster_Break=	-LF}', "");
Expect(0, 9, '\P{^Grapheme_Cluster_Break=	-LF}', "");
Error('\p{GCB=-:=LF}');
Error('\P{GCB=-:=LF}');
Expect(1, 10, '\p{GCB: lf}', "");
Expect(0, 10, '\p{^GCB: lf}', "");
Expect(0, 10, '\P{GCB: lf}', "");
Expect(1, 10, '\P{^GCB: lf}', "");
Expect(0, 9, '\p{GCB: lf}', "");
Expect(1, 9, '\p{^GCB: lf}', "");
Expect(1, 9, '\P{GCB: lf}', "");
Expect(0, 9, '\P{^GCB: lf}', "");
Expect(1, 10, '\p{GCB=- LF}', "");
Expect(0, 10, '\p{^GCB=- LF}', "");
Expect(0, 10, '\P{GCB=- LF}', "");
Expect(1, 10, '\P{^GCB=- LF}', "");
Expect(0, 9, '\p{GCB=- LF}', "");
Expect(1, 9, '\p{^GCB=- LF}', "");
Expect(1, 9, '\P{GCB=- LF}', "");
Expect(0, 9, '\P{^GCB=- LF}', "");
Error('\p{Is_Grapheme_Cluster_Break=	LF:=}');
Error('\P{Is_Grapheme_Cluster_Break=	LF:=}');
Expect(1, 10, '\p{Is_Grapheme_Cluster_Break=lf}', "");
Expect(0, 10, '\p{^Is_Grapheme_Cluster_Break=lf}', "");
Expect(0, 10, '\P{Is_Grapheme_Cluster_Break=lf}', "");
Expect(1, 10, '\P{^Is_Grapheme_Cluster_Break=lf}', "");
Expect(0, 9, '\p{Is_Grapheme_Cluster_Break=lf}', "");
Expect(1, 9, '\p{^Is_Grapheme_Cluster_Break=lf}', "");
Expect(1, 9, '\P{Is_Grapheme_Cluster_Break=lf}', "");
Expect(0, 9, '\P{^Is_Grapheme_Cluster_Break=lf}', "");
Expect(1, 10, '\p{Is_Grapheme_Cluster_Break=	 lf}', "");
Expect(0, 10, '\p{^Is_Grapheme_Cluster_Break=	 lf}', "");
Expect(0, 10, '\P{Is_Grapheme_Cluster_Break=	 lf}', "");
Expect(1, 10, '\P{^Is_Grapheme_Cluster_Break=	 lf}', "");
Expect(0, 9, '\p{Is_Grapheme_Cluster_Break=	 lf}', "");
Expect(1, 9, '\p{^Is_Grapheme_Cluster_Break=	 lf}', "");
Expect(1, 9, '\P{Is_Grapheme_Cluster_Break=	 lf}', "");
Expect(0, 9, '\P{^Is_Grapheme_Cluster_Break=	 lf}', "");
Error('\p{Is_GCB= /a/LF}');
Error('\P{Is_GCB= /a/LF}');
Expect(1, 10, '\p{Is_GCB=lf}', "");
Expect(0, 10, '\p{^Is_GCB=lf}', "");
Expect(0, 10, '\P{Is_GCB=lf}', "");
Expect(1, 10, '\P{^Is_GCB=lf}', "");
Expect(0, 9, '\p{Is_GCB=lf}', "");
Expect(1, 9, '\p{^Is_GCB=lf}', "");
Expect(1, 9, '\P{Is_GCB=lf}', "");
Expect(0, 9, '\P{^Is_GCB=lf}', "");
Expect(1, 10, '\p{Is_GCB=  LF}', "");
Expect(0, 10, '\p{^Is_GCB=  LF}', "");
Expect(0, 10, '\P{Is_GCB=  LF}', "");
Expect(1, 10, '\P{^Is_GCB=  LF}', "");
Expect(0, 9, '\p{Is_GCB=  LF}', "");
Expect(1, 9, '\p{^Is_GCB=  LF}', "");
Expect(1, 9, '\P{Is_GCB=  LF}', "");
Expect(0, 9, '\P{^Is_GCB=  LF}', "");
Error('\p{Grapheme_Cluster_Break=/a/ L}');
Error('\P{Grapheme_Cluster_Break=/a/ L}');
Expect(1, 4447, '\p{Grapheme_Cluster_Break=l}', "");
Expect(0, 4447, '\p{^Grapheme_Cluster_Break=l}', "");
Expect(0, 4447, '\P{Grapheme_Cluster_Break=l}', "");
Expect(1, 4447, '\P{^Grapheme_Cluster_Break=l}', "");
Expect(0, 4351, '\p{Grapheme_Cluster_Break=l}', "");
Expect(1, 4351, '\p{^Grapheme_Cluster_Break=l}', "");
Expect(1, 4351, '\P{Grapheme_Cluster_Break=l}', "");
Expect(0, 4351, '\P{^Grapheme_Cluster_Break=l}', "");
Expect(1, 4447, '\p{Grapheme_Cluster_Break=-L}', "");
Expect(0, 4447, '\p{^Grapheme_Cluster_Break=-L}', "");
Expect(0, 4447, '\P{Grapheme_Cluster_Break=-L}', "");
Expect(1, 4447, '\P{^Grapheme_Cluster_Break=-L}', "");
Expect(0, 4351, '\p{Grapheme_Cluster_Break=-L}', "");
Expect(1, 4351, '\p{^Grapheme_Cluster_Break=-L}', "");
Expect(1, 4351, '\P{Grapheme_Cluster_Break=-L}', "");
Expect(0, 4351, '\P{^Grapheme_Cluster_Break=-L}', "");
Error('\p{GCB=-L:=}');
Error('\P{GCB=-L:=}');
Expect(1, 4447, '\p{GCB=l}', "");
Expect(0, 4447, '\p{^GCB=l}', "");
Expect(0, 4447, '\P{GCB=l}', "");
Expect(1, 4447, '\P{^GCB=l}', "");
Expect(0, 4351, '\p{GCB=l}', "");
Expect(1, 4351, '\p{^GCB=l}', "");
Expect(1, 4351, '\P{GCB=l}', "");
Expect(0, 4351, '\P{^GCB=l}', "");
Expect(1, 4447, '\p{GCB=	l}', "");
Expect(0, 4447, '\p{^GCB=	l}', "");
Expect(0, 4447, '\P{GCB=	l}', "");
Expect(1, 4447, '\P{^GCB=	l}', "");
Expect(0, 4351, '\p{GCB=	l}', "");
Expect(1, 4351, '\p{^GCB=	l}', "");
Expect(1, 4351, '\P{GCB=	l}', "");
Expect(0, 4351, '\P{^GCB=	l}', "");
Error('\p{Is_Grapheme_Cluster_Break=		L:=}');
Error('\P{Is_Grapheme_Cluster_Break=		L:=}');
Expect(1, 4447, '\p{Is_Grapheme_Cluster_Break=l}', "");
Expect(0, 4447, '\p{^Is_Grapheme_Cluster_Break=l}', "");
Expect(0, 4447, '\P{Is_Grapheme_Cluster_Break=l}', "");
Expect(1, 4447, '\P{^Is_Grapheme_Cluster_Break=l}', "");
Expect(0, 4351, '\p{Is_Grapheme_Cluster_Break=l}', "");
Expect(1, 4351, '\p{^Is_Grapheme_Cluster_Break=l}', "");
Expect(1, 4351, '\P{Is_Grapheme_Cluster_Break=l}', "");
Expect(0, 4351, '\P{^Is_Grapheme_Cluster_Break=l}', "");
Expect(1, 4447, '\p{Is_Grapheme_Cluster_Break=_-L}', "");
Expect(0, 4447, '\p{^Is_Grapheme_Cluster_Break=_-L}', "");
Expect(0, 4447, '\P{Is_Grapheme_Cluster_Break=_-L}', "");
Expect(1, 4447, '\P{^Is_Grapheme_Cluster_Break=_-L}', "");
Expect(0, 4351, '\p{Is_Grapheme_Cluster_Break=_-L}', "");
Expect(1, 4351, '\p{^Is_Grapheme_Cluster_Break=_-L}', "");
Expect(1, 4351, '\P{Is_Grapheme_Cluster_Break=_-L}', "");
Expect(0, 4351, '\P{^Is_Grapheme_Cluster_Break=_-L}', "");
Error('\p{Is_GCB= _L/a/}');
Error('\P{Is_GCB= _L/a/}');
Expect(1, 4447, '\p{Is_GCB=l}', "");
Expect(0, 4447, '\p{^Is_GCB=l}', "");
Expect(0, 4447, '\P{Is_GCB=l}', "");
Expect(1, 4447, '\P{^Is_GCB=l}', "");
Expect(0, 4351, '\p{Is_GCB=l}', "");
Expect(1, 4351, '\p{^Is_GCB=l}', "");
Expect(1, 4351, '\P{Is_GCB=l}', "");
Expect(0, 4351, '\P{^Is_GCB=l}', "");
Expect(1, 4447, '\p{Is_GCB= L}', "");
Expect(0, 4447, '\p{^Is_GCB= L}', "");
Expect(0, 4447, '\P{Is_GCB= L}', "");
Expect(1, 4447, '\P{^Is_GCB= L}', "");
Expect(0, 4351, '\p{Is_GCB= L}', "");
Expect(1, 4351, '\p{^Is_GCB= L}', "");
Expect(1, 4351, '\P{Is_GCB= L}', "");
Expect(0, 4351, '\P{^Is_GCB= L}', "");
Error('\p{Logical_Order_Exception=:=-Yes}');
Error('\P{Logical_Order_Exception=:=-Yes}');
Expect(1, 3652, '\p{Logical_Order_Exception=yes}', "");
Expect(0, 3652, '\p{^Logical_Order_Exception=yes}', "");
Expect(0, 3652, '\P{Logical_Order_Exception=yes}', "");
Expect(1, 3652, '\P{^Logical_Order_Exception=yes}', "");
Expect(0, 3647, '\p{Logical_Order_Exception=yes}', "");
Expect(1, 3647, '\p{^Logical_Order_Exception=yes}', "");
Expect(1, 3647, '\P{Logical_Order_Exception=yes}', "");
Expect(0, 3647, '\P{^Logical_Order_Exception=yes}', "");
Expect(1, 3652, '\p{Logical_Order_Exception:	_yes}', "");
Expect(0, 3652, '\p{^Logical_Order_Exception:	_yes}', "");
Expect(0, 3652, '\P{Logical_Order_Exception:	_yes}', "");
Expect(1, 3652, '\P{^Logical_Order_Exception:	_yes}', "");
Expect(0, 3647, '\p{Logical_Order_Exception:	_yes}', "");
Expect(1, 3647, '\p{^Logical_Order_Exception:	_yes}', "");
Expect(1, 3647, '\P{Logical_Order_Exception:	_yes}', "");
Expect(0, 3647, '\P{^Logical_Order_Exception:	_yes}', "");
Error('\p{LOE=_:=y}');
Error('\P{LOE=_:=y}');
Expect(1, 3652, '\p{LOE=y}', "");
Expect(0, 3652, '\p{^LOE=y}', "");
Expect(0, 3652, '\P{LOE=y}', "");
Expect(1, 3652, '\P{^LOE=y}', "");
Expect(0, 3647, '\p{LOE=y}', "");
Expect(1, 3647, '\p{^LOE=y}', "");
Expect(1, 3647, '\P{LOE=y}', "");
Expect(0, 3647, '\P{^LOE=y}', "");
Expect(1, 3652, '\p{LOE=-Y}', "");
Expect(0, 3652, '\p{^LOE=-Y}', "");
Expect(0, 3652, '\P{LOE=-Y}', "");
Expect(1, 3652, '\P{^LOE=-Y}', "");
Expect(0, 3647, '\p{LOE=-Y}', "");
Expect(1, 3647, '\p{^LOE=-Y}', "");
Expect(1, 3647, '\P{LOE=-Y}', "");
Expect(0, 3647, '\P{^LOE=-Y}', "");
Error('\p{Is_Logical_Order_Exception= /a/T}');
Error('\P{Is_Logical_Order_Exception= /a/T}');
Expect(1, 3652, '\p{Is_Logical_Order_Exception=t}', "");
Expect(0, 3652, '\p{^Is_Logical_Order_Exception=t}', "");
Expect(0, 3652, '\P{Is_Logical_Order_Exception=t}', "");
Expect(1, 3652, '\P{^Is_Logical_Order_Exception=t}', "");
Expect(0, 3647, '\p{Is_Logical_Order_Exception=t}', "");
Expect(1, 3647, '\p{^Is_Logical_Order_Exception=t}', "");
Expect(1, 3647, '\P{Is_Logical_Order_Exception=t}', "");
Expect(0, 3647, '\P{^Is_Logical_Order_Exception=t}', "");
Expect(1, 3652, '\p{Is_Logical_Order_Exception= -t}', "");
Expect(0, 3652, '\p{^Is_Logical_Order_Exception= -t}', "");
Expect(0, 3652, '\P{Is_Logical_Order_Exception= -t}', "");
Expect(1, 3652, '\P{^Is_Logical_Order_Exception= -t}', "");
Expect(0, 3647, '\p{Is_Logical_Order_Exception= -t}', "");
Expect(1, 3647, '\p{^Is_Logical_Order_Exception= -t}', "");
Expect(1, 3647, '\P{Is_Logical_Order_Exception= -t}', "");
Expect(0, 3647, '\P{^Is_Logical_Order_Exception= -t}', "");
Error('\p{Is_LOE=/a/	_True}');
Error('\P{Is_LOE=/a/	_True}');
Expect(1, 3652, '\p{Is_LOE=true}', "");
Expect(0, 3652, '\p{^Is_LOE=true}', "");
Expect(0, 3652, '\P{Is_LOE=true}', "");
Expect(1, 3652, '\P{^Is_LOE=true}', "");
Expect(0, 3647, '\p{Is_LOE=true}', "");
Expect(1, 3647, '\p{^Is_LOE=true}', "");
Expect(1, 3647, '\P{Is_LOE=true}', "");
Expect(0, 3647, '\P{^Is_LOE=true}', "");
Expect(1, 3652, '\p{Is_LOE=__True}', "");
Expect(0, 3652, '\p{^Is_LOE=__True}', "");
Expect(0, 3652, '\P{Is_LOE=__True}', "");
Expect(1, 3652, '\P{^Is_LOE=__True}', "");
Expect(0, 3647, '\p{Is_LOE=__True}', "");
Expect(1, 3647, '\p{^Is_LOE=__True}', "");
Expect(1, 3647, '\P{Is_LOE=__True}', "");
Expect(0, 3647, '\P{^Is_LOE=__True}', "");
Error('\p{Logical_Order_Exception=	-No/a/}');
Error('\P{Logical_Order_Exception=	-No/a/}');
Expect(1, 3647, '\p{Logical_Order_Exception=no}', "");
Expect(0, 3647, '\p{^Logical_Order_Exception=no}', "");
Expect(0, 3647, '\P{Logical_Order_Exception=no}', "");
Expect(1, 3647, '\P{^Logical_Order_Exception=no}', "");
Expect(0, 3652, '\p{Logical_Order_Exception=no}', "");
Expect(1, 3652, '\p{^Logical_Order_Exception=no}', "");
Expect(1, 3652, '\P{Logical_Order_Exception=no}', "");
Expect(0, 3652, '\P{^Logical_Order_Exception=no}', "");
Expect(1, 3647, '\p{Logical_Order_Exception: -No}', "");
Expect(0, 3647, '\p{^Logical_Order_Exception: -No}', "");
Expect(0, 3647, '\P{Logical_Order_Exception: -No}', "");
Expect(1, 3647, '\P{^Logical_Order_Exception: -No}', "");
Expect(0, 3652, '\p{Logical_Order_Exception: -No}', "");
Expect(1, 3652, '\p{^Logical_Order_Exception: -No}', "");
Expect(1, 3652, '\P{Logical_Order_Exception: -No}', "");
Expect(0, 3652, '\P{^Logical_Order_Exception: -No}', "");
Error('\p{LOE=_n/a/}');
Error('\P{LOE=_n/a/}');
Expect(1, 3647, '\p{LOE:   n}', "");
Expect(0, 3647, '\p{^LOE:   n}', "");
Expect(0, 3647, '\P{LOE:   n}', "");
Expect(1, 3647, '\P{^LOE:   n}', "");
Expect(0, 3652, '\p{LOE:   n}', "");
Expect(1, 3652, '\p{^LOE:   n}', "");
Expect(1, 3652, '\P{LOE:   n}', "");
Expect(0, 3652, '\P{^LOE:   n}', "");
Expect(1, 3647, '\p{LOE=_-N}', "");
Expect(0, 3647, '\p{^LOE=_-N}', "");
Expect(0, 3647, '\P{LOE=_-N}', "");
Expect(1, 3647, '\P{^LOE=_-N}', "");
Expect(0, 3652, '\p{LOE=_-N}', "");
Expect(1, 3652, '\p{^LOE=_-N}', "");
Expect(1, 3652, '\P{LOE=_-N}', "");
Expect(0, 3652, '\P{^LOE=_-N}', "");
Error('\p{Is_Logical_Order_Exception=	 F:=}');
Error('\P{Is_Logical_Order_Exception=	 F:=}');
Expect(1, 3647, '\p{Is_Logical_Order_Exception=f}', "");
Expect(0, 3647, '\p{^Is_Logical_Order_Exception=f}', "");
Expect(0, 3647, '\P{Is_Logical_Order_Exception=f}', "");
Expect(1, 3647, '\P{^Is_Logical_Order_Exception=f}', "");
Expect(0, 3652, '\p{Is_Logical_Order_Exception=f}', "");
Expect(1, 3652, '\p{^Is_Logical_Order_Exception=f}', "");
Expect(1, 3652, '\P{Is_Logical_Order_Exception=f}', "");
Expect(0, 3652, '\P{^Is_Logical_Order_Exception=f}', "");
Expect(1, 3647, '\p{Is_Logical_Order_Exception=F}', "");
Expect(0, 3647, '\p{^Is_Logical_Order_Exception=F}', "");
Expect(0, 3647, '\P{Is_Logical_Order_Exception=F}', "");
Expect(1, 3647, '\P{^Is_Logical_Order_Exception=F}', "");
Expect(0, 3652, '\p{Is_Logical_Order_Exception=F}', "");
Expect(1, 3652, '\p{^Is_Logical_Order_Exception=F}', "");
Expect(1, 3652, '\P{Is_Logical_Order_Exception=F}', "");
Expect(0, 3652, '\P{^Is_Logical_Order_Exception=F}', "");
Error('\p{Is_LOE= _False/a/}');
Error('\P{Is_LOE= _False/a/}');
Expect(1, 3647, '\p{Is_LOE:false}', "");
Expect(0, 3647, '\p{^Is_LOE:false}', "");
Expect(0, 3647, '\P{Is_LOE:false}', "");
Expect(1, 3647, '\P{^Is_LOE:false}', "");
Expect(0, 3652, '\p{Is_LOE:false}', "");
Expect(1, 3652, '\p{^Is_LOE:false}', "");
Expect(1, 3652, '\P{Is_LOE:false}', "");
Expect(0, 3652, '\P{^Is_LOE:false}', "");
Expect(1, 3647, '\p{Is_LOE=--False}', "");
Expect(0, 3647, '\p{^Is_LOE=--False}', "");
Expect(0, 3647, '\P{Is_LOE=--False}', "");
Expect(1, 3647, '\P{^Is_LOE=--False}', "");
Expect(0, 3652, '\p{Is_LOE=--False}', "");
Expect(1, 3652, '\p{^Is_LOE=--False}', "");
Expect(1, 3652, '\P{Is_LOE=--False}', "");
Expect(0, 3652, '\P{^Is_LOE=--False}', "");
Error('\p{Bidi_Mirrored=/a/yes}');
Error('\P{Bidi_Mirrored=/a/yes}');
Expect(1, 41, '\p{Bidi_Mirrored=yes}', "");
Expect(0, 41, '\p{^Bidi_Mirrored=yes}', "");
Expect(0, 41, '\P{Bidi_Mirrored=yes}', "");
Expect(1, 41, '\P{^Bidi_Mirrored=yes}', "");
Expect(0, 39, '\p{Bidi_Mirrored=yes}', "");
Expect(1, 39, '\p{^Bidi_Mirrored=yes}', "");
Expect(1, 39, '\P{Bidi_Mirrored=yes}', "");
Expect(0, 39, '\P{^Bidi_Mirrored=yes}', "");
Expect(1, 41, '\p{Bidi_Mirrored= -yes}', "");
Expect(0, 41, '\p{^Bidi_Mirrored= -yes}', "");
Expect(0, 41, '\P{Bidi_Mirrored= -yes}', "");
Expect(1, 41, '\P{^Bidi_Mirrored= -yes}', "");
Expect(0, 39, '\p{Bidi_Mirrored= -yes}', "");
Expect(1, 39, '\p{^Bidi_Mirrored= -yes}', "");
Expect(1, 39, '\P{Bidi_Mirrored= -yes}', "");
Expect(0, 39, '\P{^Bidi_Mirrored= -yes}', "");
Error('\p{Bidi_M:	:=	-Y}');
Error('\P{Bidi_M:	:=	-Y}');
Expect(1, 41, '\p{Bidi_M=y}', "");
Expect(0, 41, '\p{^Bidi_M=y}', "");
Expect(0, 41, '\P{Bidi_M=y}', "");
Expect(1, 41, '\P{^Bidi_M=y}', "");
Expect(0, 39, '\p{Bidi_M=y}', "");
Expect(1, 39, '\p{^Bidi_M=y}', "");
Expect(1, 39, '\P{Bidi_M=y}', "");
Expect(0, 39, '\P{^Bidi_M=y}', "");
Expect(1, 41, '\p{Bidi_M=_y}', "");
Expect(0, 41, '\p{^Bidi_M=_y}', "");
Expect(0, 41, '\P{Bidi_M=_y}', "");
Expect(1, 41, '\P{^Bidi_M=_y}', "");
Expect(0, 39, '\p{Bidi_M=_y}', "");
Expect(1, 39, '\p{^Bidi_M=_y}', "");
Expect(1, 39, '\P{Bidi_M=_y}', "");
Expect(0, 39, '\P{^Bidi_M=_y}', "");
Error('\p{Is_Bidi_Mirrored=	T:=}');
Error('\P{Is_Bidi_Mirrored=	T:=}');
Expect(1, 41, '\p{Is_Bidi_Mirrored=t}', "");
Expect(0, 41, '\p{^Is_Bidi_Mirrored=t}', "");
Expect(0, 41, '\P{Is_Bidi_Mirrored=t}', "");
Expect(1, 41, '\P{^Is_Bidi_Mirrored=t}', "");
Expect(0, 39, '\p{Is_Bidi_Mirrored=t}', "");
Expect(1, 39, '\p{^Is_Bidi_Mirrored=t}', "");
Expect(1, 39, '\P{Is_Bidi_Mirrored=t}', "");
Expect(0, 39, '\P{^Is_Bidi_Mirrored=t}', "");
Expect(1, 41, '\p{Is_Bidi_Mirrored=_ T}', "");
Expect(0, 41, '\p{^Is_Bidi_Mirrored=_ T}', "");
Expect(0, 41, '\P{Is_Bidi_Mirrored=_ T}', "");
Expect(1, 41, '\P{^Is_Bidi_Mirrored=_ T}', "");
Expect(0, 39, '\p{Is_Bidi_Mirrored=_ T}', "");
Expect(1, 39, '\p{^Is_Bidi_Mirrored=_ T}', "");
Expect(1, 39, '\P{Is_Bidi_Mirrored=_ T}', "");
Expect(0, 39, '\P{^Is_Bidi_Mirrored=_ T}', "");
Error('\p{Is_Bidi_M=_/a/True}');
Error('\P{Is_Bidi_M=_/a/True}');
Expect(1, 41, '\p{Is_Bidi_M=true}', "");
Expect(0, 41, '\p{^Is_Bidi_M=true}', "");
Expect(0, 41, '\P{Is_Bidi_M=true}', "");
Expect(1, 41, '\P{^Is_Bidi_M=true}', "");
Expect(0, 39, '\p{Is_Bidi_M=true}', "");
Expect(1, 39, '\p{^Is_Bidi_M=true}', "");
Expect(1, 39, '\P{Is_Bidi_M=true}', "");
Expect(0, 39, '\P{^Is_Bidi_M=true}', "");
Expect(1, 41, '\p{Is_Bidi_M=_	True}', "");
Expect(0, 41, '\p{^Is_Bidi_M=_	True}', "");
Expect(0, 41, '\P{Is_Bidi_M=_	True}', "");
Expect(1, 41, '\P{^Is_Bidi_M=_	True}', "");
Expect(0, 39, '\p{Is_Bidi_M=_	True}', "");
Expect(1, 39, '\p{^Is_Bidi_M=_	True}', "");
Expect(1, 39, '\P{Is_Bidi_M=_	True}', "");
Expect(0, 39, '\P{^Is_Bidi_M=_	True}', "");
Error('\p{Bidi_Mirrored= :=No}');
Error('\P{Bidi_Mirrored= :=No}');
Expect(1, 39, '\p{Bidi_Mirrored=no}', "");
Expect(0, 39, '\p{^Bidi_Mirrored=no}', "");
Expect(0, 39, '\P{Bidi_Mirrored=no}', "");
Expect(1, 39, '\P{^Bidi_Mirrored=no}', "");
Expect(0, 41, '\p{Bidi_Mirrored=no}', "");
Expect(1, 41, '\p{^Bidi_Mirrored=no}', "");
Expect(1, 41, '\P{Bidi_Mirrored=no}', "");
Expect(0, 41, '\P{^Bidi_Mirrored=no}', "");
Expect(1, 39, '\p{Bidi_Mirrored=__No}', "");
Expect(0, 39, '\p{^Bidi_Mirrored=__No}', "");
Expect(0, 39, '\P{Bidi_Mirrored=__No}', "");
Expect(1, 39, '\P{^Bidi_Mirrored=__No}', "");
Expect(0, 41, '\p{Bidi_Mirrored=__No}', "");
Expect(1, 41, '\p{^Bidi_Mirrored=__No}', "");
Expect(1, 41, '\P{Bidi_Mirrored=__No}', "");
Expect(0, 41, '\P{^Bidi_Mirrored=__No}', "");
Error('\p{Bidi_M= :=N}');
Error('\P{Bidi_M= :=N}');
Expect(1, 39, '\p{Bidi_M=n}', "");
Expect(0, 39, '\p{^Bidi_M=n}', "");
Expect(0, 39, '\P{Bidi_M=n}', "");
Expect(1, 39, '\P{^Bidi_M=n}', "");
Expect(0, 41, '\p{Bidi_M=n}', "");
Expect(1, 41, '\p{^Bidi_M=n}', "");
Expect(1, 41, '\P{Bidi_M=n}', "");
Expect(0, 41, '\P{^Bidi_M=n}', "");
Expect(1, 39, '\p{Bidi_M= N}', "");
Expect(0, 39, '\p{^Bidi_M= N}', "");
Expect(0, 39, '\P{Bidi_M= N}', "");
Expect(1, 39, '\P{^Bidi_M= N}', "");
Expect(0, 41, '\p{Bidi_M= N}', "");
Expect(1, 41, '\p{^Bidi_M= N}', "");
Expect(1, 41, '\P{Bidi_M= N}', "");
Expect(0, 41, '\P{^Bidi_M= N}', "");
Error('\p{Is_Bidi_Mirrored=/a/- F}');
Error('\P{Is_Bidi_Mirrored=/a/- F}');
Expect(1, 39, '\p{Is_Bidi_Mirrored=f}', "");
Expect(0, 39, '\p{^Is_Bidi_Mirrored=f}', "");
Expect(0, 39, '\P{Is_Bidi_Mirrored=f}', "");
Expect(1, 39, '\P{^Is_Bidi_Mirrored=f}', "");
Expect(0, 41, '\p{Is_Bidi_Mirrored=f}', "");
Expect(1, 41, '\p{^Is_Bidi_Mirrored=f}', "");
Expect(1, 41, '\P{Is_Bidi_Mirrored=f}', "");
Expect(0, 41, '\P{^Is_Bidi_Mirrored=f}', "");
Expect(1, 39, '\p{Is_Bidi_Mirrored=_f}', "");
Expect(0, 39, '\p{^Is_Bidi_Mirrored=_f}', "");
Expect(0, 39, '\P{Is_Bidi_Mirrored=_f}', "");
Expect(1, 39, '\P{^Is_Bidi_Mirrored=_f}', "");
Expect(0, 41, '\p{Is_Bidi_Mirrored=_f}', "");
Expect(1, 41, '\p{^Is_Bidi_Mirrored=_f}', "");
Expect(1, 41, '\P{Is_Bidi_Mirrored=_f}', "");
Expect(0, 41, '\P{^Is_Bidi_Mirrored=_f}', "");
Error('\p{Is_Bidi_M=  FALSE/a/}');
Error('\P{Is_Bidi_M=  FALSE/a/}');
Expect(1, 39, '\p{Is_Bidi_M=false}', "");
Expect(0, 39, '\p{^Is_Bidi_M=false}', "");
Expect(0, 39, '\P{Is_Bidi_M=false}', "");
Expect(1, 39, '\P{^Is_Bidi_M=false}', "");
Expect(0, 41, '\p{Is_Bidi_M=false}', "");
Expect(1, 41, '\p{^Is_Bidi_M=false}', "");
Expect(1, 41, '\P{Is_Bidi_M=false}', "");
Expect(0, 41, '\P{^Is_Bidi_M=false}', "");
Expect(1, 39, '\p{Is_Bidi_M:	-	False}', "");
Expect(0, 39, '\p{^Is_Bidi_M:	-	False}', "");
Expect(0, 39, '\P{Is_Bidi_M:	-	False}', "");
Expect(1, 39, '\P{^Is_Bidi_M:	-	False}', "");
Expect(0, 41, '\p{Is_Bidi_M:	-	False}', "");
Expect(1, 41, '\p{^Is_Bidi_M:	-	False}', "");
Expect(1, 41, '\P{Is_Bidi_M:	-	False}', "");
Expect(0, 41, '\P{^Is_Bidi_M:	-	False}', "");
Error('\p{Lowercase=:= YES}');
Error('\P{Lowercase=:= YES}');
Expect(1, 122, '\p{Lowercase=yes}', "");
Expect(0, 122, '\p{^Lowercase=yes}', "");
Expect(0, 122, '\P{Lowercase=yes}', "");
Expect(1, 122, '\P{^Lowercase=yes}', "");
Expect(0, 96, '\p{Lowercase=yes}', "");
Expect(1, 96, '\p{^Lowercase=yes}', "");
Expect(1, 96, '\P{Lowercase=yes}', "");
Expect(0, 96, '\P{^Lowercase=yes}', "");
Expect(1, 122, '\p{Lowercase=	 yes}', "");
Expect(0, 122, '\p{^Lowercase=	 yes}', "");
Expect(0, 122, '\P{Lowercase=	 yes}', "");
Expect(1, 122, '\P{^Lowercase=	 yes}', "");
Expect(0, 96, '\p{Lowercase=	 yes}', "");
Expect(1, 96, '\p{^Lowercase=	 yes}', "");
Expect(1, 96, '\P{Lowercase=	 yes}', "");
Expect(0, 96, '\P{^Lowercase=	 yes}', "");
Error('\p{Lower= Y/a/}');
Error('\P{Lower= Y/a/}');
Expect(1, 122, '\p{Lower=y}', "");
Expect(0, 122, '\p{^Lower=y}', "");
Expect(0, 122, '\P{Lower=y}', "");
Expect(1, 122, '\P{^Lower=y}', "");
Expect(0, 96, '\p{Lower=y}', "");
Expect(1, 96, '\p{^Lower=y}', "");
Expect(1, 96, '\P{Lower=y}', "");
Expect(0, 96, '\P{^Lower=y}', "");
Expect(1, 122, '\p{Lower:	-Y}', "");
Expect(0, 122, '\p{^Lower:	-Y}', "");
Expect(0, 122, '\P{Lower:	-Y}', "");
Expect(1, 122, '\P{^Lower:	-Y}', "");
Expect(0, 96, '\p{Lower:	-Y}', "");
Expect(1, 96, '\p{^Lower:	-Y}', "");
Expect(1, 96, '\P{Lower:	-Y}', "");
Expect(0, 96, '\P{^Lower:	-Y}', "");
Error('\p{Is_Lowercase=	T:=}');
Error('\P{Is_Lowercase=	T:=}');
Expect(1, 122, '\p{Is_Lowercase=t}', "");
Expect(0, 122, '\p{^Is_Lowercase=t}', "");
Expect(0, 122, '\P{Is_Lowercase=t}', "");
Expect(1, 122, '\P{^Is_Lowercase=t}', "");
Expect(0, 96, '\p{Is_Lowercase=t}', "");
Expect(1, 96, '\p{^Is_Lowercase=t}', "");
Expect(1, 96, '\P{Is_Lowercase=t}', "");
Expect(0, 96, '\P{^Is_Lowercase=t}', "");
Expect(1, 122, '\p{Is_Lowercase:	-_T}', "");
Expect(0, 122, '\p{^Is_Lowercase:	-_T}', "");
Expect(0, 122, '\P{Is_Lowercase:	-_T}', "");
Expect(1, 122, '\P{^Is_Lowercase:	-_T}', "");
Expect(0, 96, '\p{Is_Lowercase:	-_T}', "");
Expect(1, 96, '\p{^Is_Lowercase:	-_T}', "");
Expect(1, 96, '\P{Is_Lowercase:	-_T}', "");
Expect(0, 96, '\P{^Is_Lowercase:	-_T}', "");
Error('\p{Is_Lower=-	True:=}');
Error('\P{Is_Lower=-	True:=}');
Expect(1, 122, '\p{Is_Lower=true}', "");
Expect(0, 122, '\p{^Is_Lower=true}', "");
Expect(0, 122, '\P{Is_Lower=true}', "");
Expect(1, 122, '\P{^Is_Lower=true}', "");
Expect(0, 96, '\p{Is_Lower=true}', "");
Expect(1, 96, '\p{^Is_Lower=true}', "");
Expect(1, 96, '\P{Is_Lower=true}', "");
Expect(0, 96, '\P{^Is_Lower=true}', "");
Expect(1, 122, '\p{Is_Lower= _true}', "");
Expect(0, 122, '\p{^Is_Lower= _true}', "");
Expect(0, 122, '\P{Is_Lower= _true}', "");
Expect(1, 122, '\P{^Is_Lower= _true}', "");
Expect(0, 96, '\p{Is_Lower= _true}', "");
Expect(1, 96, '\p{^Is_Lower= _true}', "");
Expect(1, 96, '\P{Is_Lower= _true}', "");
Expect(0, 96, '\P{^Is_Lower= _true}', "");
Error('\p{Lowercase=-:=No}');
Error('\P{Lowercase=-:=No}');
Expect(1, 96, '\p{Lowercase=no}', "");
Expect(0, 96, '\p{^Lowercase=no}', "");
Expect(0, 96, '\P{Lowercase=no}', "");
Expect(1, 96, '\P{^Lowercase=no}', "");
Expect(0, 122, '\p{Lowercase=no}', "");
Expect(1, 122, '\p{^Lowercase=no}', "");
Expect(1, 122, '\P{Lowercase=no}', "");
Expect(0, 122, '\P{^Lowercase=no}', "");
Expect(1, 96, '\p{Lowercase=--No}', "");
Expect(0, 96, '\p{^Lowercase=--No}', "");
Expect(0, 96, '\P{Lowercase=--No}', "");
Expect(1, 96, '\P{^Lowercase=--No}', "");
Expect(0, 122, '\p{Lowercase=--No}', "");
Expect(1, 122, '\p{^Lowercase=--No}', "");
Expect(1, 122, '\P{Lowercase=--No}', "");
Expect(0, 122, '\P{^Lowercase=--No}', "");
Error('\p{Lower=/a/__N}');
Error('\P{Lower=/a/__N}');
Expect(1, 96, '\p{Lower=n}', "");
Expect(0, 96, '\p{^Lower=n}', "");
Expect(0, 96, '\P{Lower=n}', "");
Expect(1, 96, '\P{^Lower=n}', "");
Expect(0, 122, '\p{Lower=n}', "");
Expect(1, 122, '\p{^Lower=n}', "");
Expect(1, 122, '\P{Lower=n}', "");
Expect(0, 122, '\P{^Lower=n}', "");
Expect(1, 96, '\p{Lower= 	n}', "");
Expect(0, 96, '\p{^Lower= 	n}', "");
Expect(0, 96, '\P{Lower= 	n}', "");
Expect(1, 96, '\P{^Lower= 	n}', "");
Expect(0, 122, '\p{Lower= 	n}', "");
Expect(1, 122, '\p{^Lower= 	n}', "");
Expect(1, 122, '\P{Lower= 	n}', "");
Expect(0, 122, '\P{^Lower= 	n}', "");
Error('\p{Is_Lowercase=_F/a/}');
Error('\P{Is_Lowercase=_F/a/}');
Expect(1, 96, '\p{Is_Lowercase=f}', "");
Expect(0, 96, '\p{^Is_Lowercase=f}', "");
Expect(0, 96, '\P{Is_Lowercase=f}', "");
Expect(1, 96, '\P{^Is_Lowercase=f}', "");
Expect(0, 122, '\p{Is_Lowercase=f}', "");
Expect(1, 122, '\p{^Is_Lowercase=f}', "");
Expect(1, 122, '\P{Is_Lowercase=f}', "");
Expect(0, 122, '\P{^Is_Lowercase=f}', "");
Expect(1, 96, '\p{Is_Lowercase= F}', "");
Expect(0, 96, '\p{^Is_Lowercase= F}', "");
Expect(0, 96, '\P{Is_Lowercase= F}', "");
Expect(1, 96, '\P{^Is_Lowercase= F}', "");
Expect(0, 122, '\p{Is_Lowercase= F}', "");
Expect(1, 122, '\p{^Is_Lowercase= F}', "");
Expect(1, 122, '\P{Is_Lowercase= F}', "");
Expect(0, 122, '\P{^Is_Lowercase= F}', "");
Error('\p{Is_Lower= /a/FALSE}');
Error('\P{Is_Lower= /a/FALSE}');
Expect(1, 96, '\p{Is_Lower=false}', "");
Expect(0, 96, '\p{^Is_Lower=false}', "");
Expect(0, 96, '\P{Is_Lower=false}', "");
Expect(1, 96, '\P{^Is_Lower=false}', "");
Expect(0, 122, '\p{Is_Lower=false}', "");
Expect(1, 122, '\p{^Is_Lower=false}', "");
Expect(1, 122, '\P{Is_Lower=false}', "");
Expect(0, 122, '\P{^Is_Lower=false}', "");
Expect(1, 96, '\p{Is_Lower=- false}', "");
Expect(0, 96, '\p{^Is_Lower=- false}', "");
Expect(0, 96, '\P{Is_Lower=- false}', "");
Expect(1, 96, '\P{^Is_Lower=- false}', "");
Expect(0, 122, '\p{Is_Lower=- false}', "");
Expect(1, 122, '\p{^Is_Lower=- false}', "");
Expect(1, 122, '\P{Is_Lower=- false}', "");
Expect(0, 122, '\P{^Is_Lower=- false}', "");
Error('\p{Uppercase= YES/a/}');
Error('\P{Uppercase= YES/a/}');
Expect(1, 90, '\p{Uppercase=yes}', "");
Expect(0, 90, '\p{^Uppercase=yes}', "");
Expect(0, 90, '\P{Uppercase=yes}', "");
Expect(1, 90, '\P{^Uppercase=yes}', "");
Expect(0, 64, '\p{Uppercase=yes}', "");
Expect(1, 64, '\p{^Uppercase=yes}', "");
Expect(1, 64, '\P{Uppercase=yes}', "");
Expect(0, 64, '\P{^Uppercase=yes}', "");
Expect(1, 90, '\p{Uppercase=  Yes}', "");
Expect(0, 90, '\p{^Uppercase=  Yes}', "");
Expect(0, 90, '\P{Uppercase=  Yes}', "");
Expect(1, 90, '\P{^Uppercase=  Yes}', "");
Expect(0, 64, '\p{Uppercase=  Yes}', "");
Expect(1, 64, '\p{^Uppercase=  Yes}', "");
Expect(1, 64, '\P{Uppercase=  Yes}', "");
Expect(0, 64, '\P{^Uppercase=  Yes}', "");
Error('\p{Upper: :=Y}');
Error('\P{Upper: :=Y}');
Expect(1, 90, '\p{Upper=y}', "");
Expect(0, 90, '\p{^Upper=y}', "");
Expect(0, 90, '\P{Upper=y}', "");
Expect(1, 90, '\P{^Upper=y}', "");
Expect(0, 64, '\p{Upper=y}', "");
Expect(1, 64, '\p{^Upper=y}', "");
Expect(1, 64, '\P{Upper=y}', "");
Expect(0, 64, '\P{^Upper=y}', "");
Expect(1, 90, '\p{Upper=	y}', "");
Expect(0, 90, '\p{^Upper=	y}', "");
Expect(0, 90, '\P{Upper=	y}', "");
Expect(1, 90, '\P{^Upper=	y}', "");
Expect(0, 64, '\p{Upper=	y}', "");
Expect(1, 64, '\p{^Upper=	y}', "");
Expect(1, 64, '\P{Upper=	y}', "");
Expect(0, 64, '\P{^Upper=	y}', "");
Error('\p{Is_Uppercase=/a/__T}');
Error('\P{Is_Uppercase=/a/__T}');
Expect(1, 90, '\p{Is_Uppercase:   t}', "");
Expect(0, 90, '\p{^Is_Uppercase:   t}', "");
Expect(0, 90, '\P{Is_Uppercase:   t}', "");
Expect(1, 90, '\P{^Is_Uppercase:   t}', "");
Expect(0, 64, '\p{Is_Uppercase:   t}', "");
Expect(1, 64, '\p{^Is_Uppercase:   t}', "");
Expect(1, 64, '\P{Is_Uppercase:   t}', "");
Expect(0, 64, '\P{^Is_Uppercase:   t}', "");
Expect(1, 90, '\p{Is_Uppercase=_T}', "");
Expect(0, 90, '\p{^Is_Uppercase=_T}', "");
Expect(0, 90, '\P{Is_Uppercase=_T}', "");
Expect(1, 90, '\P{^Is_Uppercase=_T}', "");
Expect(0, 64, '\p{Is_Uppercase=_T}', "");
Expect(1, 64, '\p{^Is_Uppercase=_T}', "");
Expect(1, 64, '\P{Is_Uppercase=_T}', "");
Expect(0, 64, '\P{^Is_Uppercase=_T}', "");
Error('\p{Is_Upper=_/a/True}');
Error('\P{Is_Upper=_/a/True}');
Expect(1, 90, '\p{Is_Upper=true}', "");
Expect(0, 90, '\p{^Is_Upper=true}', "");
Expect(0, 90, '\P{Is_Upper=true}', "");
Expect(1, 90, '\P{^Is_Upper=true}', "");
Expect(0, 64, '\p{Is_Upper=true}', "");
Expect(1, 64, '\p{^Is_Upper=true}', "");
Expect(1, 64, '\P{Is_Upper=true}', "");
Expect(0, 64, '\P{^Is_Upper=true}', "");
Expect(1, 90, '\p{Is_Upper=_True}', "");
Expect(0, 90, '\p{^Is_Upper=_True}', "");
Expect(0, 90, '\P{Is_Upper=_True}', "");
Expect(1, 90, '\P{^Is_Upper=_True}', "");
Expect(0, 64, '\p{Is_Upper=_True}', "");
Expect(1, 64, '\p{^Is_Upper=_True}', "");
Expect(1, 64, '\P{Is_Upper=_True}', "");
Expect(0, 64, '\P{^Is_Upper=_True}', "");
Error('\p{Uppercase=/a/_	no}');
Error('\P{Uppercase=/a/_	no}');
Expect(1, 64, '\p{Uppercase=no}', "");
Expect(0, 64, '\p{^Uppercase=no}', "");
Expect(0, 64, '\P{Uppercase=no}', "");
Expect(1, 64, '\P{^Uppercase=no}', "");
Expect(0, 90, '\p{Uppercase=no}', "");
Expect(1, 90, '\p{^Uppercase=no}', "");
Expect(1, 90, '\P{Uppercase=no}', "");
Expect(0, 90, '\P{^Uppercase=no}', "");
Expect(1, 64, '\p{Uppercase= no}', "");
Expect(0, 64, '\p{^Uppercase= no}', "");
Expect(0, 64, '\P{Uppercase= no}', "");
Expect(1, 64, '\P{^Uppercase= no}', "");
Expect(0, 90, '\p{Uppercase= no}', "");
Expect(1, 90, '\p{^Uppercase= no}', "");
Expect(1, 90, '\P{Uppercase= no}', "");
Expect(0, 90, '\P{^Uppercase= no}', "");
Error('\p{Upper=__N:=}');
Error('\P{Upper=__N:=}');
Expect(1, 64, '\p{Upper=n}', "");
Expect(0, 64, '\p{^Upper=n}', "");
Expect(0, 64, '\P{Upper=n}', "");
Expect(1, 64, '\P{^Upper=n}', "");
Expect(0, 90, '\p{Upper=n}', "");
Expect(1, 90, '\p{^Upper=n}', "");
Expect(1, 90, '\P{Upper=n}', "");
Expect(0, 90, '\P{^Upper=n}', "");
Expect(1, 64, '\p{Upper:   	N}', "");
Expect(0, 64, '\p{^Upper:   	N}', "");
Expect(0, 64, '\P{Upper:   	N}', "");
Expect(1, 64, '\P{^Upper:   	N}', "");
Expect(0, 90, '\p{Upper:   	N}', "");
Expect(1, 90, '\p{^Upper:   	N}', "");
Expect(1, 90, '\P{Upper:   	N}', "");
Expect(0, 90, '\P{^Upper:   	N}', "");
Error('\p{Is_Uppercase=/a/F}');
Error('\P{Is_Uppercase=/a/F}');
Expect(1, 64, '\p{Is_Uppercase=f}', "");
Expect(0, 64, '\p{^Is_Uppercase=f}', "");
Expect(0, 64, '\P{Is_Uppercase=f}', "");
Expect(1, 64, '\P{^Is_Uppercase=f}', "");
Expect(0, 90, '\p{Is_Uppercase=f}', "");
Expect(1, 90, '\p{^Is_Uppercase=f}', "");
Expect(1, 90, '\P{Is_Uppercase=f}', "");
Expect(0, 90, '\P{^Is_Uppercase=f}', "");
Expect(1, 64, '\p{Is_Uppercase= -F}', "");
Expect(0, 64, '\p{^Is_Uppercase= -F}', "");
Expect(0, 64, '\P{Is_Uppercase= -F}', "");
Expect(1, 64, '\P{^Is_Uppercase= -F}', "");
Expect(0, 90, '\p{Is_Uppercase= -F}', "");
Expect(1, 90, '\p{^Is_Uppercase= -F}', "");
Expect(1, 90, '\P{Is_Uppercase= -F}', "");
Expect(0, 90, '\P{^Is_Uppercase= -F}', "");
Error('\p{Is_Upper=		FALSE:=}');
Error('\P{Is_Upper=		FALSE:=}');
Expect(1, 64, '\p{Is_Upper=false}', "");
Expect(0, 64, '\p{^Is_Upper=false}', "");
Expect(0, 64, '\P{Is_Upper=false}', "");
Expect(1, 64, '\P{^Is_Upper=false}', "");
Expect(0, 90, '\p{Is_Upper=false}', "");
Expect(1, 90, '\p{^Is_Upper=false}', "");
Expect(1, 90, '\P{Is_Upper=false}', "");
Expect(0, 90, '\P{^Is_Upper=false}', "");
Expect(1, 64, '\p{Is_Upper=_	False}', "");
Expect(0, 64, '\p{^Is_Upper=_	False}', "");
Expect(0, 64, '\P{Is_Upper=_	False}', "");
Expect(1, 64, '\P{^Is_Upper=_	False}', "");
Expect(0, 90, '\p{Is_Upper=_	False}', "");
Expect(1, 90, '\p{^Is_Upper=_	False}', "");
Expect(1, 90, '\P{Is_Upper=_	False}', "");
Expect(0, 90, '\P{^Is_Upper=_	False}', "");
Error('\p{Expands_On_NFKC=Yes}');
Error('\P{Expands_On_NFKC=Yes}');
Error('\p{XO_NFKC=Y}');
Error('\P{XO_NFKC=Y}');
Error('\p{Is_Expands_On_NFKC=T}');
Error('\P{Is_Expands_On_NFKC=T}');
Error('\p{Is_XO_NFKC=True}');
Error('\P{Is_XO_NFKC=True}');
Error('\p{Expands_On_NFKC:	No}');
Error('\P{Expands_On_NFKC:	No}');
Error('\p{XO_NFKC=N}');
Error('\P{XO_NFKC=N}');
Error('\p{Is_Expands_On_NFKC:F}');
Error('\P{Is_Expands_On_NFKC:F}');
Error('\p{Is_XO_NFKC: False}');
Error('\P{Is_XO_NFKC: False}');
Error('\p{NFD_Quick_Check=__YES/a/}');
Error('\P{NFD_Quick_Check=__YES/a/}');
Expect(1, 191, '\p{NFD_Quick_Check=yes}', "");
Expect(0, 191, '\p{^NFD_Quick_Check=yes}', "");
Expect(0, 191, '\P{NFD_Quick_Check=yes}', "");
Expect(1, 191, '\P{^NFD_Quick_Check=yes}', "");
Expect(0, 197, '\p{NFD_Quick_Check=yes}', "");
Expect(1, 197, '\p{^NFD_Quick_Check=yes}', "");
Expect(1, 197, '\P{NFD_Quick_Check=yes}', "");
Expect(0, 197, '\P{^NFD_Quick_Check=yes}', "");
Expect(1, 191, '\p{NFD_Quick_Check=-	yes}', "");
Expect(0, 191, '\p{^NFD_Quick_Check=-	yes}', "");
Expect(0, 191, '\P{NFD_Quick_Check=-	yes}', "");
Expect(1, 191, '\P{^NFD_Quick_Check=-	yes}', "");
Expect(0, 197, '\p{NFD_Quick_Check=-	yes}', "");
Expect(1, 197, '\p{^NFD_Quick_Check=-	yes}', "");
Expect(1, 197, '\P{NFD_Quick_Check=-	yes}', "");
Expect(0, 197, '\P{^NFD_Quick_Check=-	yes}', "");
Error('\p{NFD_QC:   	/a/Y}');
Error('\P{NFD_QC:   	/a/Y}');
Expect(1, 191, '\p{NFD_QC=y}', "");
Expect(0, 191, '\p{^NFD_QC=y}', "");
Expect(0, 191, '\P{NFD_QC=y}', "");
Expect(1, 191, '\P{^NFD_QC=y}', "");
Expect(0, 197, '\p{NFD_QC=y}', "");
Expect(1, 197, '\p{^NFD_QC=y}', "");
Expect(1, 197, '\P{NFD_QC=y}', "");
Expect(0, 197, '\P{^NFD_QC=y}', "");
Expect(1, 191, '\p{NFD_QC= _Y}', "");
Expect(0, 191, '\p{^NFD_QC= _Y}', "");
Expect(0, 191, '\P{NFD_QC= _Y}', "");
Expect(1, 191, '\P{^NFD_QC= _Y}', "");
Expect(0, 197, '\p{NFD_QC= _Y}', "");
Expect(1, 197, '\p{^NFD_QC= _Y}', "");
Expect(1, 197, '\P{NFD_QC= _Y}', "");
Expect(0, 197, '\P{^NFD_QC= _Y}', "");
Error('\p{Is_NFD_Quick_Check= Yes:=}');
Error('\P{Is_NFD_Quick_Check= Yes:=}');
Expect(1, 191, '\p{Is_NFD_Quick_Check=yes}', "");
Expect(0, 191, '\p{^Is_NFD_Quick_Check=yes}', "");
Expect(0, 191, '\P{Is_NFD_Quick_Check=yes}', "");
Expect(1, 191, '\P{^Is_NFD_Quick_Check=yes}', "");
Expect(0, 197, '\p{Is_NFD_Quick_Check=yes}', "");
Expect(1, 197, '\p{^Is_NFD_Quick_Check=yes}', "");
Expect(1, 197, '\P{Is_NFD_Quick_Check=yes}', "");
Expect(0, 197, '\P{^Is_NFD_Quick_Check=yes}', "");
Expect(1, 191, '\p{Is_NFD_Quick_Check= 	yes}', "");
Expect(0, 191, '\p{^Is_NFD_Quick_Check= 	yes}', "");
Expect(0, 191, '\P{Is_NFD_Quick_Check= 	yes}', "");
Expect(1, 191, '\P{^Is_NFD_Quick_Check= 	yes}', "");
Expect(0, 197, '\p{Is_NFD_Quick_Check= 	yes}', "");
Expect(1, 197, '\p{^Is_NFD_Quick_Check= 	yes}', "");
Expect(1, 197, '\P{Is_NFD_Quick_Check= 	yes}', "");
Expect(0, 197, '\P{^Is_NFD_Quick_Check= 	yes}', "");
Error('\p{Is_NFD_QC=/a/-	Y}');
Error('\P{Is_NFD_QC=/a/-	Y}');
Expect(1, 191, '\p{Is_NFD_QC=y}', "");
Expect(0, 191, '\p{^Is_NFD_QC=y}', "");
Expect(0, 191, '\P{Is_NFD_QC=y}', "");
Expect(1, 191, '\P{^Is_NFD_QC=y}', "");
Expect(0, 197, '\p{Is_NFD_QC=y}', "");
Expect(1, 197, '\p{^Is_NFD_QC=y}', "");
Expect(1, 197, '\P{Is_NFD_QC=y}', "");
Expect(0, 197, '\P{^Is_NFD_QC=y}', "");
Expect(1, 191, '\p{Is_NFD_QC= -Y}', "");
Expect(0, 191, '\p{^Is_NFD_QC= -Y}', "");
Expect(0, 191, '\P{Is_NFD_QC= -Y}', "");
Expect(1, 191, '\P{^Is_NFD_QC= -Y}', "");
Expect(0, 197, '\p{Is_NFD_QC= -Y}', "");
Expect(1, 197, '\p{^Is_NFD_QC= -Y}', "");
Expect(1, 197, '\P{Is_NFD_QC= -Y}', "");
Expect(0, 197, '\P{^Is_NFD_QC= -Y}', "");
Error('\p{NFD_Quick_Check=:=_ No}');
Error('\P{NFD_Quick_Check=:=_ No}');
Expect(1, 197, '\p{NFD_Quick_Check: no}', "");
Expect(0, 197, '\p{^NFD_Quick_Check: no}', "");
Expect(0, 197, '\P{NFD_Quick_Check: no}', "");
Expect(1, 197, '\P{^NFD_Quick_Check: no}', "");
Expect(0, 191, '\p{NFD_Quick_Check: no}', "");
Expect(1, 191, '\p{^NFD_Quick_Check: no}', "");
Expect(1, 191, '\P{NFD_Quick_Check: no}', "");
Expect(0, 191, '\P{^NFD_Quick_Check: no}', "");
Expect(1, 197, '\p{NFD_Quick_Check= 	NO}', "");
Expect(0, 197, '\p{^NFD_Quick_Check= 	NO}', "");
Expect(0, 197, '\P{NFD_Quick_Check= 	NO}', "");
Expect(1, 197, '\P{^NFD_Quick_Check= 	NO}', "");
Expect(0, 191, '\p{NFD_Quick_Check= 	NO}', "");
Expect(1, 191, '\p{^NFD_Quick_Check= 	NO}', "");
Expect(1, 191, '\P{NFD_Quick_Check= 	NO}', "");
Expect(0, 191, '\P{^NFD_Quick_Check= 	NO}', "");
Error('\p{NFD_QC=	:=N}');
Error('\P{NFD_QC=	:=N}');
Expect(1, 197, '\p{NFD_QC: n}', "");
Expect(0, 197, '\p{^NFD_QC: n}', "");
Expect(0, 197, '\P{NFD_QC: n}', "");
Expect(1, 197, '\P{^NFD_QC: n}', "");
Expect(0, 191, '\p{NFD_QC: n}', "");
Expect(1, 191, '\p{^NFD_QC: n}', "");
Expect(1, 191, '\P{NFD_QC: n}', "");
Expect(0, 191, '\P{^NFD_QC: n}', "");
Expect(1, 197, '\p{NFD_QC:	_n}', "");
Expect(0, 197, '\p{^NFD_QC:	_n}', "");
Expect(0, 197, '\P{NFD_QC:	_n}', "");
Expect(1, 197, '\P{^NFD_QC:	_n}', "");
Expect(0, 191, '\p{NFD_QC:	_n}', "");
Expect(1, 191, '\p{^NFD_QC:	_n}', "");
Expect(1, 191, '\P{NFD_QC:	_n}', "");
Expect(0, 191, '\P{^NFD_QC:	_n}', "");
Error('\p{Is_NFD_Quick_Check=/a/_no}');
Error('\P{Is_NFD_Quick_Check=/a/_no}');
Expect(1, 197, '\p{Is_NFD_Quick_Check=no}', "");
Expect(0, 197, '\p{^Is_NFD_Quick_Check=no}', "");
Expect(0, 197, '\P{Is_NFD_Quick_Check=no}', "");
Expect(1, 197, '\P{^Is_NFD_Quick_Check=no}', "");
Expect(0, 191, '\p{Is_NFD_Quick_Check=no}', "");
Expect(1, 191, '\p{^Is_NFD_Quick_Check=no}', "");
Expect(1, 191, '\P{Is_NFD_Quick_Check=no}', "");
Expect(0, 191, '\P{^Is_NFD_Quick_Check=no}', "");
Expect(1, 197, '\p{Is_NFD_Quick_Check:-	No}', "");
Expect(0, 197, '\p{^Is_NFD_Quick_Check:-	No}', "");
Expect(0, 197, '\P{Is_NFD_Quick_Check:-	No}', "");
Expect(1, 197, '\P{^Is_NFD_Quick_Check:-	No}', "");
Expect(0, 191, '\p{Is_NFD_Quick_Check:-	No}', "");
Expect(1, 191, '\p{^Is_NFD_Quick_Check:-	No}', "");
Expect(1, 191, '\P{Is_NFD_Quick_Check:-	No}', "");
Expect(0, 191, '\P{^Is_NFD_Quick_Check:-	No}', "");
Error('\p{Is_NFD_QC=	:=N}');
Error('\P{Is_NFD_QC=	:=N}');
Expect(1, 197, '\p{Is_NFD_QC=n}', "");
Expect(0, 197, '\p{^Is_NFD_QC=n}', "");
Expect(0, 197, '\P{Is_NFD_QC=n}', "");
Expect(1, 197, '\P{^Is_NFD_QC=n}', "");
Expect(0, 191, '\p{Is_NFD_QC=n}', "");
Expect(1, 191, '\p{^Is_NFD_QC=n}', "");
Expect(1, 191, '\P{Is_NFD_QC=n}', "");
Expect(0, 191, '\P{^Is_NFD_QC=n}', "");
Expect(1, 197, '\p{Is_NFD_QC=_ n}', "");
Expect(0, 197, '\p{^Is_NFD_QC=_ n}', "");
Expect(0, 197, '\P{Is_NFD_QC=_ n}', "");
Expect(1, 197, '\P{^Is_NFD_QC=_ n}', "");
Expect(0, 191, '\p{Is_NFD_QC=_ n}', "");
Expect(1, 191, '\p{^Is_NFD_QC=_ n}', "");
Expect(1, 191, '\P{Is_NFD_QC=_ n}', "");
Expect(0, 191, '\P{^Is_NFD_QC=_ n}', "");
Error('\p{Line_Break= -Space:=}');
Error('\P{Line_Break= -Space:=}');
Expect(1, 32, '\p{Line_Break:   space}', "");
Expect(0, 32, '\p{^Line_Break:   space}', "");
Expect(0, 32, '\P{Line_Break:   space}', "");
Expect(1, 32, '\P{^Line_Break:   space}', "");
Expect(0, 31, '\p{Line_Break:   space}', "");
Expect(1, 31, '\p{^Line_Break:   space}', "");
Expect(1, 31, '\P{Line_Break:   space}', "");
Expect(0, 31, '\P{^Line_Break:   space}', "");
Expect(1, 32, '\p{Line_Break=	SPACE}', "");
Expect(0, 32, '\p{^Line_Break=	SPACE}', "");
Expect(0, 32, '\P{Line_Break=	SPACE}', "");
Expect(1, 32, '\P{^Line_Break=	SPACE}', "");
Expect(0, 31, '\p{Line_Break=	SPACE}', "");
Expect(1, 31, '\p{^Line_Break=	SPACE}', "");
Expect(1, 31, '\P{Line_Break=	SPACE}', "");
Expect(0, 31, '\P{^Line_Break=	SPACE}', "");
Error('\p{Lb=:=-	SP}');
Error('\P{Lb=:=-	SP}');
Expect(1, 32, '\p{Lb=sp}', "");
Expect(0, 32, '\p{^Lb=sp}', "");
Expect(0, 32, '\P{Lb=sp}', "");
Expect(1, 32, '\P{^Lb=sp}', "");
Expect(0, 31, '\p{Lb=sp}', "");
Expect(1, 31, '\p{^Lb=sp}', "");
Expect(1, 31, '\P{Lb=sp}', "");
Expect(0, 31, '\P{^Lb=sp}', "");
Expect(1, 32, '\p{Lb: 	sp}', "");
Expect(0, 32, '\p{^Lb: 	sp}', "");
Expect(0, 32, '\P{Lb: 	sp}', "");
Expect(1, 32, '\P{^Lb: 	sp}', "");
Expect(0, 31, '\p{Lb: 	sp}', "");
Expect(1, 31, '\p{^Lb: 	sp}', "");
Expect(1, 31, '\P{Lb: 	sp}', "");
Expect(0, 31, '\P{^Lb: 	sp}', "");
Error('\p{Is_Line_Break=_:=Space}');
Error('\P{Is_Line_Break=_:=Space}');
Expect(1, 32, '\p{Is_Line_Break:space}', "");
Expect(0, 32, '\p{^Is_Line_Break:space}', "");
Expect(0, 32, '\P{Is_Line_Break:space}', "");
Expect(1, 32, '\P{^Is_Line_Break:space}', "");
Expect(0, 31, '\p{Is_Line_Break:space}', "");
Expect(1, 31, '\p{^Is_Line_Break:space}', "");
Expect(1, 31, '\P{Is_Line_Break:space}', "");
Expect(0, 31, '\P{^Is_Line_Break:space}', "");
Expect(1, 32, '\p{Is_Line_Break=--space}', "");
Expect(0, 32, '\p{^Is_Line_Break=--space}', "");
Expect(0, 32, '\P{Is_Line_Break=--space}', "");
Expect(1, 32, '\P{^Is_Line_Break=--space}', "");
Expect(0, 31, '\p{Is_Line_Break=--space}', "");
Expect(1, 31, '\p{^Is_Line_Break=--space}', "");
Expect(1, 31, '\P{Is_Line_Break=--space}', "");
Expect(0, 31, '\P{^Is_Line_Break=--space}', "");
Error('\p{Is_Lb=- sp:=}');
Error('\P{Is_Lb=- sp:=}');
Expect(1, 32, '\p{Is_Lb=sp}', "");
Expect(0, 32, '\p{^Is_Lb=sp}', "");
Expect(0, 32, '\P{Is_Lb=sp}', "");
Expect(1, 32, '\P{^Is_Lb=sp}', "");
Expect(0, 31, '\p{Is_Lb=sp}', "");
Expect(1, 31, '\p{^Is_Lb=sp}', "");
Expect(1, 31, '\P{Is_Lb=sp}', "");
Expect(0, 31, '\P{^Is_Lb=sp}', "");
Expect(1, 32, '\p{Is_Lb=SP}', "");
Expect(0, 32, '\p{^Is_Lb=SP}', "");
Expect(0, 32, '\P{Is_Lb=SP}', "");
Expect(1, 32, '\P{^Is_Lb=SP}', "");
Expect(0, 31, '\p{Is_Lb=SP}', "");
Expect(1, 31, '\p{^Is_Lb=SP}', "");
Expect(1, 31, '\P{Is_Lb=SP}', "");
Expect(0, 31, '\P{^Is_Lb=SP}', "");
Error('\p{Line_Break= -GLUE:=}');
Error('\P{Line_Break= -GLUE:=}');
Expect(1, 160, '\p{Line_Break=glue}', "");
Expect(0, 160, '\p{^Line_Break=glue}', "");
Expect(0, 160, '\P{Line_Break=glue}', "");
Expect(1, 160, '\P{^Line_Break=glue}', "");
Expect(0, 159, '\p{Line_Break=glue}', "");
Expect(1, 159, '\p{^Line_Break=glue}', "");
Expect(1, 159, '\P{Line_Break=glue}', "");
Expect(0, 159, '\P{^Line_Break=glue}', "");
Error('\p{Lb=:=		GL}');
Error('\P{Lb=:=		GL}');
Expect(1, 160, '\p{Lb=gl}', "");
Expect(0, 160, '\p{^Lb=gl}', "");
Expect(0, 160, '\P{Lb=gl}', "");
Expect(1, 160, '\P{^Lb=gl}', "");
Expect(0, 159, '\p{Lb=gl}', "");
Expect(1, 159, '\p{^Lb=gl}', "");
Expect(1, 159, '\P{Lb=gl}', "");
Expect(0, 159, '\P{^Lb=gl}', "");
Expect(1, 160, '\p{Lb=_-GL}', "");
Expect(0, 160, '\p{^Lb=_-GL}', "");
Expect(0, 160, '\P{Lb=_-GL}', "");
Expect(1, 160, '\P{^Lb=_-GL}', "");
Expect(0, 159, '\p{Lb=_-GL}', "");
Expect(1, 159, '\p{^Lb=_-GL}', "");
Expect(1, 159, '\P{Lb=_-GL}', "");
Expect(0, 159, '\P{^Lb=_-GL}', "");
Error('\p{Is_Line_Break=/a/	Glue}');
Error('\P{Is_Line_Break=/a/	Glue}');
Expect(1, 160, '\p{Is_Line_Break=glue}', "");
Expect(0, 160, '\p{^Is_Line_Break=glue}', "");
Expect(0, 160, '\P{Is_Line_Break=glue}', "");
Expect(1, 160, '\P{^Is_Line_Break=glue}', "");
Expect(0, 159, '\p{Is_Line_Break=glue}', "");
Expect(1, 159, '\p{^Is_Line_Break=glue}', "");
Expect(1, 159, '\P{Is_Line_Break=glue}', "");
Expect(0, 159, '\P{^Is_Line_Break=glue}', "");
Expect(1, 160, '\p{Is_Line_Break=_glue}', "");
Expect(0, 160, '\p{^Is_Line_Break=_glue}', "");
Expect(0, 160, '\P{Is_Line_Break=_glue}', "");
Expect(1, 160, '\P{^Is_Line_Break=_glue}', "");
Expect(0, 159, '\p{Is_Line_Break=_glue}', "");
Expect(1, 159, '\p{^Is_Line_Break=_glue}', "");
Expect(1, 159, '\P{Is_Line_Break=_glue}', "");
Expect(0, 159, '\P{^Is_Line_Break=_glue}', "");
Error('\p{Is_Lb=/a/_gl}');
Error('\P{Is_Lb=/a/_gl}');
Expect(1, 160, '\p{Is_Lb=gl}', "");
Expect(0, 160, '\p{^Is_Lb=gl}', "");
Expect(0, 160, '\P{Is_Lb=gl}', "");
Expect(1, 160, '\P{^Is_Lb=gl}', "");
Expect(0, 159, '\p{Is_Lb=gl}', "");
Expect(1, 159, '\p{^Is_Lb=gl}', "");
Expect(1, 159, '\P{Is_Lb=gl}', "");
Expect(0, 159, '\P{^Is_Lb=gl}', "");
Expect(1, 160, '\p{Is_Lb= 	GL}', "");
Expect(0, 160, '\p{^Is_Lb= 	GL}', "");
Expect(0, 160, '\P{Is_Lb= 	GL}', "");
Expect(1, 160, '\P{^Is_Lb= 	GL}', "");
Expect(0, 159, '\p{Is_Lb= 	GL}', "");
Expect(1, 159, '\p{^Is_Lb= 	GL}', "");
Expect(1, 159, '\P{Is_Lb= 	GL}', "");
Expect(0, 159, '\P{^Is_Lb= 	GL}', "");
Error('\p{Line_Break=/a/-SURROGATE}');
Error('\P{Line_Break=/a/-SURROGATE}');
Expect(0, 55295, '\p{Line_Break=surrogate}', 'deprecated');
Expect(1, 55295, '\p{^Line_Break=surrogate}', 'deprecated');
Expect(1, 55295, '\P{Line_Break=surrogate}', 'deprecated');
Expect(0, 55295, '\P{^Line_Break=surrogate}', 'deprecated');
Expect(0, 55295, '\p{Line_Break=-_SURROGATE}', 'deprecated');
Expect(1, 55295, '\p{^Line_Break=-_SURROGATE}', 'deprecated');
Expect(1, 55295, '\P{Line_Break=-_SURROGATE}', 'deprecated');
Expect(0, 55295, '\P{^Line_Break=-_SURROGATE}', 'deprecated');
Error('\p{Lb=		SG:=}');
Error('\P{Lb=		SG:=}');
Expect(0, 55295, '\p{Lb=sg}', 'deprecated');
Expect(1, 55295, '\p{^Lb=sg}', 'deprecated');
Expect(1, 55295, '\P{Lb=sg}', 'deprecated');
Expect(0, 55295, '\P{^Lb=sg}', 'deprecated');
Expect(0, 55295, '\p{Lb=--sg}', 'deprecated');
Expect(1, 55295, '\p{^Lb=--sg}', 'deprecated');
Expect(1, 55295, '\P{Lb=--sg}', 'deprecated');
Expect(0, 55295, '\P{^Lb=--sg}', 'deprecated');
Error('\p{Is_Line_Break=:= -Surrogate}');
Error('\P{Is_Line_Break=:= -Surrogate}');
Expect(0, 55295, '\p{Is_Line_Break:   surrogate}', 'deprecated');
Expect(1, 55295, '\p{^Is_Line_Break:   surrogate}', 'deprecated');
Expect(1, 55295, '\P{Is_Line_Break:   surrogate}', 'deprecated');
Expect(0, 55295, '\P{^Is_Line_Break:   surrogate}', 'deprecated');
Expect(0, 55295, '\p{Is_Line_Break: 	_Surrogate}', 'deprecated');
Expect(1, 55295, '\p{^Is_Line_Break: 	_Surrogate}', 'deprecated');
Expect(1, 55295, '\P{Is_Line_Break: 	_Surrogate}', 'deprecated');
Expect(0, 55295, '\P{^Is_Line_Break: 	_Surrogate}', 'deprecated');
Error('\p{Is_Lb=/a/SG}');
Error('\P{Is_Lb=/a/SG}');
Expect(0, 55295, '\p{Is_Lb=sg}', 'deprecated');
Expect(1, 55295, '\p{^Is_Lb=sg}', 'deprecated');
Expect(1, 55295, '\P{Is_Lb=sg}', 'deprecated');
Expect(0, 55295, '\P{^Is_Lb=sg}', 'deprecated');
Expect(0, 55295, '\p{Is_Lb=_SG}', 'deprecated');
Expect(1, 55295, '\p{^Is_Lb=_SG}', 'deprecated');
Expect(1, 55295, '\P{Is_Lb=_SG}', 'deprecated');
Expect(0, 55295, '\P{^Is_Lb=_SG}', 'deprecated');
Error('\p{Line_Break= Unknown:=}');
Error('\P{Line_Break= Unknown:=}');
Expect(1, 889, '\p{Line_Break=unknown}', "");
Expect(0, 889, '\p{^Line_Break=unknown}', "");
Expect(0, 889, '\P{Line_Break=unknown}', "");
Expect(1, 889, '\P{^Line_Break=unknown}', "");
Expect(0, 887, '\p{Line_Break=unknown}', "");
Expect(1, 887, '\p{^Line_Break=unknown}', "");
Expect(1, 887, '\P{Line_Break=unknown}', "");
Expect(0, 887, '\P{^Line_Break=unknown}', "");
Expect(1, 889, '\p{Line_Break=__UNKNOWN}', "");
Expect(0, 889, '\p{^Line_Break=__UNKNOWN}', "");
Expect(0, 889, '\P{Line_Break=__UNKNOWN}', "");
Expect(1, 889, '\P{^Line_Break=__UNKNOWN}', "");
Expect(0, 887, '\p{Line_Break=__UNKNOWN}', "");
Expect(1, 887, '\p{^Line_Break=__UNKNOWN}', "");
Expect(1, 887, '\P{Line_Break=__UNKNOWN}', "");
Expect(0, 887, '\P{^Line_Break=__UNKNOWN}', "");
Error('\p{Lb=/a/ XX}');
Error('\P{Lb=/a/ XX}');
Expect(1, 889, '\p{Lb:	xx}', "");
Expect(0, 889, '\p{^Lb:	xx}', "");
Expect(0, 889, '\P{Lb:	xx}', "");
Expect(1, 889, '\P{^Lb:	xx}', "");
Expect(0, 887, '\p{Lb:	xx}', "");
Expect(1, 887, '\p{^Lb:	xx}', "");
Expect(1, 887, '\P{Lb:	xx}', "");
Expect(0, 887, '\P{^Lb:	xx}', "");
Expect(1, 889, '\p{Lb= -xx}', "");
Expect(0, 889, '\p{^Lb= -xx}', "");
Expect(0, 889, '\P{Lb= -xx}', "");
Expect(1, 889, '\P{^Lb= -xx}', "");
Expect(0, 887, '\p{Lb= -xx}', "");
Expect(1, 887, '\p{^Lb= -xx}', "");
Expect(1, 887, '\P{Lb= -xx}', "");
Expect(0, 887, '\P{^Lb= -xx}', "");
Error('\p{Is_Line_Break=	 Unknown:=}');
Error('\P{Is_Line_Break=	 Unknown:=}');
Expect(1, 889, '\p{Is_Line_Break:	unknown}', "");
Expect(0, 889, '\p{^Is_Line_Break:	unknown}', "");
Expect(0, 889, '\P{Is_Line_Break:	unknown}', "");
Expect(1, 889, '\P{^Is_Line_Break:	unknown}', "");
Expect(0, 887, '\p{Is_Line_Break:	unknown}', "");
Expect(1, 887, '\p{^Is_Line_Break:	unknown}', "");
Expect(1, 887, '\P{Is_Line_Break:	unknown}', "");
Expect(0, 887, '\P{^Is_Line_Break:	unknown}', "");
Expect(1, 889, '\p{Is_Line_Break=_ UNKNOWN}', "");
Expect(0, 889, '\p{^Is_Line_Break=_ UNKNOWN}', "");
Expect(0, 889, '\P{Is_Line_Break=_ UNKNOWN}', "");
Expect(1, 889, '\P{^Is_Line_Break=_ UNKNOWN}', "");
Expect(0, 887, '\p{Is_Line_Break=_ UNKNOWN}', "");
Expect(1, 887, '\p{^Is_Line_Break=_ UNKNOWN}', "");
Expect(1, 887, '\P{Is_Line_Break=_ UNKNOWN}', "");
Expect(0, 887, '\P{^Is_Line_Break=_ UNKNOWN}', "");
Error('\p{Is_Lb= XX:=}');
Error('\P{Is_Lb= XX:=}');
Expect(1, 889, '\p{Is_Lb=xx}', "");
Expect(0, 889, '\p{^Is_Lb=xx}', "");
Expect(0, 889, '\P{Is_Lb=xx}', "");
Expect(1, 889, '\P{^Is_Lb=xx}', "");
Expect(0, 887, '\p{Is_Lb=xx}', "");
Expect(1, 887, '\p{^Is_Lb=xx}', "");
Expect(1, 887, '\P{Is_Lb=xx}', "");
Expect(0, 887, '\P{^Is_Lb=xx}', "");
Expect(1, 889, '\p{Is_Lb= -XX}', "");
Expect(0, 889, '\p{^Is_Lb= -XX}', "");
Expect(0, 889, '\P{Is_Lb= -XX}', "");
Expect(1, 889, '\P{^Is_Lb= -XX}', "");
Expect(0, 887, '\p{Is_Lb= -XX}', "");
Expect(1, 887, '\p{^Is_Lb= -XX}', "");
Expect(1, 887, '\P{Is_Lb= -XX}', "");
Expect(0, 887, '\P{^Is_Lb= -XX}', "");
Error('\p{Line_Break=_-Numeric:=}');
Error('\P{Line_Break=_-Numeric:=}');
Expect(1, 57, '\p{Line_Break=numeric}', "");
Expect(0, 57, '\p{^Line_Break=numeric}', "");
Expect(0, 57, '\P{Line_Break=numeric}', "");
Expect(1, 57, '\P{^Line_Break=numeric}', "");
Expect(0, 47, '\p{Line_Break=numeric}', "");
Expect(1, 47, '\p{^Line_Break=numeric}', "");
Expect(1, 47, '\P{Line_Break=numeric}', "");
Expect(0, 47, '\P{^Line_Break=numeric}', "");
Expect(1, 57, '\p{Line_Break=__Numeric}', "");
Expect(0, 57, '\p{^Line_Break=__Numeric}', "");
Expect(0, 57, '\P{Line_Break=__Numeric}', "");
Expect(1, 57, '\P{^Line_Break=__Numeric}', "");
Expect(0, 47, '\p{Line_Break=__Numeric}', "");
Expect(1, 47, '\p{^Line_Break=__Numeric}', "");
Expect(1, 47, '\P{Line_Break=__Numeric}', "");
Expect(0, 47, '\P{^Line_Break=__Numeric}', "");
Error('\p{Lb=-_NU/a/}');
Error('\P{Lb=-_NU/a/}');
Expect(1, 57, '\p{Lb: nu}', "");
Expect(0, 57, '\p{^Lb: nu}', "");
Expect(0, 57, '\P{Lb: nu}', "");
Expect(1, 57, '\P{^Lb: nu}', "");
Expect(0, 47, '\p{Lb: nu}', "");
Expect(1, 47, '\p{^Lb: nu}', "");
Expect(1, 47, '\P{Lb: nu}', "");
Expect(0, 47, '\P{^Lb: nu}', "");
Expect(1, 57, '\p{Lb:	--NU}', "");
Expect(0, 57, '\p{^Lb:	--NU}', "");
Expect(0, 57, '\P{Lb:	--NU}', "");
Expect(1, 57, '\P{^Lb:	--NU}', "");
Expect(0, 47, '\p{Lb:	--NU}', "");
Expect(1, 47, '\p{^Lb:	--NU}', "");
Expect(1, 47, '\P{Lb:	--NU}', "");
Expect(0, 47, '\P{^Lb:	--NU}', "");
Error('\p{Is_Line_Break=-:=Numeric}');
Error('\P{Is_Line_Break=-:=Numeric}');
Expect(1, 57, '\p{Is_Line_Break=numeric}', "");
Expect(0, 57, '\p{^Is_Line_Break=numeric}', "");
Expect(0, 57, '\P{Is_Line_Break=numeric}', "");
Expect(1, 57, '\P{^Is_Line_Break=numeric}', "");
Expect(0, 47, '\p{Is_Line_Break=numeric}', "");
Expect(1, 47, '\p{^Is_Line_Break=numeric}', "");
Expect(1, 47, '\P{Is_Line_Break=numeric}', "");
Expect(0, 47, '\P{^Is_Line_Break=numeric}', "");
Expect(1, 57, '\p{Is_Line_Break=	Numeric}', "");
Expect(0, 57, '\p{^Is_Line_Break=	Numeric}', "");
Expect(0, 57, '\P{Is_Line_Break=	Numeric}', "");
Expect(1, 57, '\P{^Is_Line_Break=	Numeric}', "");
Expect(0, 47, '\p{Is_Line_Break=	Numeric}', "");
Expect(1, 47, '\p{^Is_Line_Break=	Numeric}', "");
Expect(1, 47, '\P{Is_Line_Break=	Numeric}', "");
Expect(0, 47, '\P{^Is_Line_Break=	Numeric}', "");
Error('\p{Is_Lb=_NU:=}');
Error('\P{Is_Lb=_NU:=}');
Expect(1, 57, '\p{Is_Lb=nu}', "");
Expect(0, 57, '\p{^Is_Lb=nu}', "");
Expect(0, 57, '\P{Is_Lb=nu}', "");
Expect(1, 57, '\P{^Is_Lb=nu}', "");
Expect(0, 47, '\p{Is_Lb=nu}', "");
Expect(1, 47, '\p{^Is_Lb=nu}', "");
Expect(1, 47, '\P{Is_Lb=nu}', "");
Expect(0, 47, '\P{^Is_Lb=nu}', "");
Expect(1, 57, '\p{Is_Lb= _nu}', "");
Expect(0, 57, '\p{^Is_Lb= _nu}', "");
Expect(0, 57, '\P{Is_Lb= _nu}', "");
Expect(1, 57, '\P{^Is_Lb= _nu}', "");
Expect(0, 47, '\p{Is_Lb= _nu}', "");
Expect(1, 47, '\p{^Is_Lb= _nu}', "");
Expect(1, 47, '\P{Is_Lb= _nu}', "");
Expect(0, 47, '\P{^Is_Lb= _nu}', "");
Error('\p{Line_Break=_BREAK/a/BEFORE}');
Error('\P{Line_Break=_BREAK/a/BEFORE}');
Expect(1, 180, '\p{Line_Break=breakbefore}', "");
Expect(0, 180, '\p{^Line_Break=breakbefore}', "");
Expect(0, 180, '\P{Line_Break=breakbefore}', "");
Expect(1, 180, '\P{^Line_Break=breakbefore}', "");
Expect(0, 179, '\p{Line_Break=breakbefore}', "");
Expect(1, 179, '\p{^Line_Break=breakbefore}', "");
Expect(1, 179, '\P{Line_Break=breakbefore}', "");
Expect(0, 179, '\P{^Line_Break=breakbefore}', "");
Expect(1, 180, '\p{Line_Break= _BREAKBefore}', "");
Expect(0, 180, '\p{^Line_Break= _BREAKBefore}', "");
Expect(0, 180, '\P{Line_Break= _BREAKBefore}', "");
Expect(1, 180, '\P{^Line_Break= _BREAKBefore}', "");
Expect(0, 179, '\p{Line_Break= _BREAKBefore}', "");
Expect(1, 179, '\p{^Line_Break= _BREAKBefore}', "");
Expect(1, 179, '\P{Line_Break= _BREAKBefore}', "");
Expect(0, 179, '\P{^Line_Break= _BREAKBefore}', "");
Error('\p{Lb=	-BB/a/}');
Error('\P{Lb=	-BB/a/}');
Expect(1, 180, '\p{Lb=bb}', "");
Expect(0, 180, '\p{^Lb=bb}', "");
Expect(0, 180, '\P{Lb=bb}', "");
Expect(1, 180, '\P{^Lb=bb}', "");
Expect(0, 179, '\p{Lb=bb}', "");
Expect(1, 179, '\p{^Lb=bb}', "");
Expect(1, 179, '\P{Lb=bb}', "");
Expect(0, 179, '\P{^Lb=bb}', "");
Expect(1, 180, '\p{Lb= 	BB}', "");
Expect(0, 180, '\p{^Lb= 	BB}', "");
Expect(0, 180, '\P{Lb= 	BB}', "");
Expect(1, 180, '\P{^Lb= 	BB}', "");
Expect(0, 179, '\p{Lb= 	BB}', "");
Expect(1, 179, '\p{^Lb= 	BB}', "");
Expect(1, 179, '\P{Lb= 	BB}', "");
Expect(0, 179, '\P{^Lb= 	BB}', "");
Error('\p{Is_Line_Break=/a/break	Before}');
Error('\P{Is_Line_Break=/a/break	Before}');
Expect(1, 180, '\p{Is_Line_Break=breakbefore}', "");
Expect(0, 180, '\p{^Is_Line_Break=breakbefore}', "");
Expect(0, 180, '\P{Is_Line_Break=breakbefore}', "");
Expect(1, 180, '\P{^Is_Line_Break=breakbefore}', "");
Expect(0, 179, '\p{Is_Line_Break=breakbefore}', "");
Expect(1, 179, '\p{^Is_Line_Break=breakbefore}', "");
Expect(1, 179, '\P{Is_Line_Break=breakbefore}', "");
Expect(0, 179, '\P{^Is_Line_Break=breakbefore}', "");
Expect(1, 180, '\p{Is_Line_Break=	-BREAK	Before}', "");
Expect(0, 180, '\p{^Is_Line_Break=	-BREAK	Before}', "");
Expect(0, 180, '\P{Is_Line_Break=	-BREAK	Before}', "");
Expect(1, 180, '\P{^Is_Line_Break=	-BREAK	Before}', "");
Expect(0, 179, '\p{Is_Line_Break=	-BREAK	Before}', "");
Expect(1, 179, '\p{^Is_Line_Break=	-BREAK	Before}', "");
Expect(1, 179, '\P{Is_Line_Break=	-BREAK	Before}', "");
Expect(0, 179, '\P{^Is_Line_Break=	-BREAK	Before}', "");
Error('\p{Is_Lb=/a/BB}');
Error('\P{Is_Lb=/a/BB}');
Expect(1, 180, '\p{Is_Lb=bb}', "");
Expect(0, 180, '\p{^Is_Lb=bb}', "");
Expect(0, 180, '\P{Is_Lb=bb}', "");
Expect(1, 180, '\P{^Is_Lb=bb}', "");
Expect(0, 179, '\p{Is_Lb=bb}', "");
Expect(1, 179, '\p{^Is_Lb=bb}', "");
Expect(1, 179, '\P{Is_Lb=bb}', "");
Expect(0, 179, '\P{^Is_Lb=bb}', "");
Expect(1, 180, '\p{Is_Lb= BB}', "");
Expect(0, 180, '\p{^Is_Lb= BB}', "");
Expect(0, 180, '\P{Is_Lb= BB}', "");
Expect(1, 180, '\P{^Is_Lb= BB}', "");
Expect(0, 179, '\p{Is_Lb= BB}', "");
Expect(1, 179, '\p{^Is_Lb= BB}', "");
Expect(1, 179, '\P{Is_Lb= BB}', "");
Expect(0, 179, '\P{^Is_Lb= BB}', "");
Error('\p{Line_Break=/a/_ zwspace}');
Error('\P{Line_Break=/a/_ zwspace}');
Expect(1, 8203, '\p{Line_Break=zwspace}', "");
Expect(0, 8203, '\p{^Line_Break=zwspace}', "");
Expect(0, 8203, '\P{Line_Break=zwspace}', "");
Expect(1, 8203, '\P{^Line_Break=zwspace}', "");
Expect(0, 8202, '\p{Line_Break=zwspace}', "");
Expect(1, 8202, '\p{^Line_Break=zwspace}', "");
Expect(1, 8202, '\P{Line_Break=zwspace}', "");
Expect(0, 8202, '\P{^Line_Break=zwspace}', "");
Expect(1, 8203, '\p{Line_Break:-ZWSpace}', "");
Expect(0, 8203, '\p{^Line_Break:-ZWSpace}', "");
Expect(0, 8203, '\P{Line_Break:-ZWSpace}', "");
Expect(1, 8203, '\P{^Line_Break:-ZWSpace}', "");
Expect(0, 8202, '\p{Line_Break:-ZWSpace}', "");
Expect(1, 8202, '\p{^Line_Break:-ZWSpace}', "");
Expect(1, 8202, '\P{Line_Break:-ZWSpace}', "");
Expect(0, 8202, '\P{^Line_Break:-ZWSpace}', "");
Error('\p{Lb=	_ZW/a/}');
Error('\P{Lb=	_ZW/a/}');
Expect(1, 8203, '\p{Lb=zw}', "");
Expect(0, 8203, '\p{^Lb=zw}', "");
Expect(0, 8203, '\P{Lb=zw}', "");
Expect(1, 8203, '\P{^Lb=zw}', "");
Expect(0, 8202, '\p{Lb=zw}', "");
Expect(1, 8202, '\p{^Lb=zw}', "");
Expect(1, 8202, '\P{Lb=zw}', "");
Expect(0, 8202, '\P{^Lb=zw}', "");
Expect(1, 8203, '\p{Lb= 	ZW}', "");
Expect(0, 8203, '\p{^Lb= 	ZW}', "");
Expect(0, 8203, '\P{Lb= 	ZW}', "");
Expect(1, 8203, '\P{^Lb= 	ZW}', "");
Expect(0, 8202, '\p{Lb= 	ZW}', "");
Expect(1, 8202, '\p{^Lb= 	ZW}', "");
Expect(1, 8202, '\P{Lb= 	ZW}', "");
Expect(0, 8202, '\P{^Lb= 	ZW}', "");
Error('\p{Is_Line_Break=/a/--ZWSpace}');
Error('\P{Is_Line_Break=/a/--ZWSpace}');
Expect(1, 8203, '\p{Is_Line_Break=zwspace}', "");
Expect(0, 8203, '\p{^Is_Line_Break=zwspace}', "");
Expect(0, 8203, '\P{Is_Line_Break=zwspace}', "");
Expect(1, 8203, '\P{^Is_Line_Break=zwspace}', "");
Expect(0, 8202, '\p{Is_Line_Break=zwspace}', "");
Expect(1, 8202, '\p{^Is_Line_Break=zwspace}', "");
Expect(1, 8202, '\P{Is_Line_Break=zwspace}', "");
Expect(0, 8202, '\P{^Is_Line_Break=zwspace}', "");
Expect(1, 8203, '\p{Is_Line_Break=_	zwspace}', "");
Expect(0, 8203, '\p{^Is_Line_Break=_	zwspace}', "");
Expect(0, 8203, '\P{Is_Line_Break=_	zwspace}', "");
Expect(1, 8203, '\P{^Is_Line_Break=_	zwspace}', "");
Expect(0, 8202, '\p{Is_Line_Break=_	zwspace}', "");
Expect(1, 8202, '\p{^Is_Line_Break=_	zwspace}', "");
Expect(1, 8202, '\P{Is_Line_Break=_	zwspace}', "");
Expect(0, 8202, '\P{^Is_Line_Break=_	zwspace}', "");
Error('\p{Is_Lb=	-zw:=}');
Error('\P{Is_Lb=	-zw:=}');
Expect(1, 8203, '\p{Is_Lb=zw}', "");
Expect(0, 8203, '\p{^Is_Lb=zw}', "");
Expect(0, 8203, '\P{Is_Lb=zw}', "");
Expect(1, 8203, '\P{^Is_Lb=zw}', "");
Expect(0, 8202, '\p{Is_Lb=zw}', "");
Expect(1, 8202, '\p{^Is_Lb=zw}', "");
Expect(1, 8202, '\P{Is_Lb=zw}', "");
Expect(0, 8202, '\P{^Is_Lb=zw}', "");
Expect(1, 8203, '\p{Is_Lb= ZW}', "");
Expect(0, 8203, '\p{^Is_Lb= ZW}', "");
Expect(0, 8203, '\P{Is_Lb= ZW}', "");
Expect(1, 8203, '\P{^Is_Lb= ZW}', "");
Expect(0, 8202, '\p{Is_Lb= ZW}', "");
Expect(1, 8202, '\p{^Is_Lb= ZW}', "");
Expect(1, 8202, '\P{Is_Lb= ZW}', "");
Expect(0, 8202, '\P{^Is_Lb= ZW}', "");
Error('\p{Line_Break=:=  JL}');
Error('\P{Line_Break=:=  JL}');
Expect(1, 4447, '\p{Line_Break=jl}', "");
Expect(0, 4447, '\p{^Line_Break=jl}', "");
Expect(0, 4447, '\P{Line_Break=jl}', "");
Expect(1, 4447, '\P{^Line_Break=jl}', "");
Expect(0, 4351, '\p{Line_Break=jl}', "");
Expect(1, 4351, '\p{^Line_Break=jl}', "");
Expect(1, 4351, '\P{Line_Break=jl}', "");
Expect(0, 4351, '\P{^Line_Break=jl}', "");
Expect(1, 4447, '\p{Line_Break=-JL}', "");
Expect(0, 4447, '\p{^Line_Break=-JL}', "");
Expect(0, 4447, '\P{Line_Break=-JL}', "");
Expect(1, 4447, '\P{^Line_Break=-JL}', "");
Expect(0, 4351, '\p{Line_Break=-JL}', "");
Expect(1, 4351, '\p{^Line_Break=-JL}', "");
Expect(1, 4351, '\P{Line_Break=-JL}', "");
Expect(0, 4351, '\P{^Line_Break=-JL}', "");
Error('\p{Lb=/a/  JL}');
Error('\P{Lb=/a/  JL}');
Expect(1, 4447, '\p{Lb=jl}', "");
Expect(0, 4447, '\p{^Lb=jl}', "");
Expect(0, 4447, '\P{Lb=jl}', "");
Expect(1, 4447, '\P{^Lb=jl}', "");
Expect(0, 4351, '\p{Lb=jl}', "");
Expect(1, 4351, '\p{^Lb=jl}', "");
Expect(1, 4351, '\P{Lb=jl}', "");
Expect(0, 4351, '\P{^Lb=jl}', "");
Expect(1, 4447, '\p{Lb=-JL}', "");
Expect(0, 4447, '\p{^Lb=-JL}', "");
Expect(0, 4447, '\P{Lb=-JL}', "");
Expect(1, 4447, '\P{^Lb=-JL}', "");
Expect(0, 4351, '\p{Lb=-JL}', "");
Expect(1, 4351, '\p{^Lb=-JL}', "");
Expect(1, 4351, '\P{Lb=-JL}', "");
Expect(0, 4351, '\P{^Lb=-JL}', "");
Error('\p{Is_Line_Break: 	 JL/a/}');
Error('\P{Is_Line_Break: 	 JL/a/}');
Expect(1, 4447, '\p{Is_Line_Break=jl}', "");
Expect(0, 4447, '\p{^Is_Line_Break=jl}', "");
Expect(0, 4447, '\P{Is_Line_Break=jl}', "");
Expect(1, 4447, '\P{^Is_Line_Break=jl}', "");
Expect(0, 4351, '\p{Is_Line_Break=jl}', "");
Expect(1, 4351, '\p{^Is_Line_Break=jl}', "");
Expect(1, 4351, '\P{Is_Line_Break=jl}', "");
Expect(0, 4351, '\P{^Is_Line_Break=jl}', "");
Expect(1, 4447, '\p{Is_Line_Break= -jl}', "");
Expect(0, 4447, '\p{^Is_Line_Break= -jl}', "");
Expect(0, 4447, '\P{Is_Line_Break= -jl}', "");
Expect(1, 4447, '\P{^Is_Line_Break= -jl}', "");
Expect(0, 4351, '\p{Is_Line_Break= -jl}', "");
Expect(1, 4351, '\p{^Is_Line_Break= -jl}', "");
Expect(1, 4351, '\P{Is_Line_Break= -jl}', "");
Expect(0, 4351, '\P{^Is_Line_Break= -jl}', "");
Error('\p{Is_Lb=	:=JL}');
Error('\P{Is_Lb=	:=JL}');
Expect(1, 4447, '\p{Is_Lb=jl}', "");
Expect(0, 4447, '\p{^Is_Lb=jl}', "");
Expect(0, 4447, '\P{Is_Lb=jl}', "");
Expect(1, 4447, '\P{^Is_Lb=jl}', "");
Expect(0, 4351, '\p{Is_Lb=jl}', "");
Expect(1, 4351, '\p{^Is_Lb=jl}', "");
Expect(1, 4351, '\P{Is_Lb=jl}', "");
Expect(0, 4351, '\P{^Is_Lb=jl}', "");
Expect(1, 4447, '\p{Is_Lb=	_jl}', "");
Expect(0, 4447, '\p{^Is_Lb=	_jl}', "");
Expect(0, 4447, '\P{Is_Lb=	_jl}', "");
Expect(1, 4447, '\P{^Is_Lb=	_jl}', "");
Expect(0, 4351, '\p{Is_Lb=	_jl}', "");
Expect(1, 4351, '\p{^Is_Lb=	_jl}', "");
Expect(1, 4351, '\P{Is_Lb=	_jl}', "");
Expect(0, 4351, '\P{^Is_Lb=	_jl}', "");
Error('\p{Line_Break=-:=Break Symbols}');
Error('\P{Line_Break=-:=Break Symbols}');
Expect(1, 47, '\p{Line_Break=breaksymbols}', "");
Expect(0, 47, '\p{^Line_Break=breaksymbols}', "");
Expect(0, 47, '\P{Line_Break=breaksymbols}', "");
Expect(1, 47, '\P{^Line_Break=breaksymbols}', "");
Expect(0, 46, '\p{Line_Break=breaksymbols}', "");
Expect(1, 46, '\p{^Line_Break=breaksymbols}', "");
Expect(1, 46, '\P{Line_Break=breaksymbols}', "");
Expect(0, 46, '\P{^Line_Break=breaksymbols}', "");
Expect(1, 47, '\p{Line_Break=-Break_Symbols}', "");
Expect(0, 47, '\p{^Line_Break=-Break_Symbols}', "");
Expect(0, 47, '\P{Line_Break=-Break_Symbols}', "");
Expect(1, 47, '\P{^Line_Break=-Break_Symbols}', "");
Expect(0, 46, '\p{Line_Break=-Break_Symbols}', "");
Expect(1, 46, '\p{^Line_Break=-Break_Symbols}', "");
Expect(1, 46, '\P{Line_Break=-Break_Symbols}', "");
Expect(0, 46, '\P{^Line_Break=-Break_Symbols}', "");
Error('\p{Lb=_ SY/a/}');
Error('\P{Lb=_ SY/a/}');
Expect(1, 47, '\p{Lb=sy}', "");
Expect(0, 47, '\p{^Lb=sy}', "");
Expect(0, 47, '\P{Lb=sy}', "");
Expect(1, 47, '\P{^Lb=sy}', "");
Expect(0, 46, '\p{Lb=sy}', "");
Expect(1, 46, '\p{^Lb=sy}', "");
Expect(1, 46, '\P{Lb=sy}', "");
Expect(0, 46, '\P{^Lb=sy}', "");
Expect(1, 47, '\p{Lb=	 SY}', "");
Expect(0, 47, '\p{^Lb=	 SY}', "");
Expect(0, 47, '\P{Lb=	 SY}', "");
Expect(1, 47, '\P{^Lb=	 SY}', "");
Expect(0, 46, '\p{Lb=	 SY}', "");
Expect(1, 46, '\p{^Lb=	 SY}', "");
Expect(1, 46, '\P{Lb=	 SY}', "");
Expect(0, 46, '\P{^Lb=	 SY}', "");
Error('\p{Is_Line_Break=	_BREAK/a/SYMBOLS}');
Error('\P{Is_Line_Break=	_BREAK/a/SYMBOLS}');
Expect(1, 47, '\p{Is_Line_Break=breaksymbols}', "");
Expect(0, 47, '\p{^Is_Line_Break=breaksymbols}', "");
Expect(0, 47, '\P{Is_Line_Break=breaksymbols}', "");
Expect(1, 47, '\P{^Is_Line_Break=breaksymbols}', "");
Expect(0, 46, '\p{Is_Line_Break=breaksymbols}', "");
Expect(1, 46, '\p{^Is_Line_Break=breaksymbols}', "");
Expect(1, 46, '\P{Is_Line_Break=breaksymbols}', "");
Expect(0, 46, '\P{^Is_Line_Break=breaksymbols}', "");
Expect(1, 47, '\p{Is_Line_Break=  break_Symbols}', "");
Expect(0, 47, '\p{^Is_Line_Break=  break_Symbols}', "");
Expect(0, 47, '\P{Is_Line_Break=  break_Symbols}', "");
Expect(1, 47, '\P{^Is_Line_Break=  break_Symbols}', "");
Expect(0, 46, '\p{Is_Line_Break=  break_Symbols}', "");
Expect(1, 46, '\p{^Is_Line_Break=  break_Symbols}', "");
Expect(1, 46, '\P{Is_Line_Break=  break_Symbols}', "");
Expect(0, 46, '\P{^Is_Line_Break=  break_Symbols}', "");
Error('\p{Is_Lb= sy/a/}');
Error('\P{Is_Lb= sy/a/}');
Expect(1, 47, '\p{Is_Lb=sy}', "");
Expect(0, 47, '\p{^Is_Lb=sy}', "");
Expect(0, 47, '\P{Is_Lb=sy}', "");
Expect(1, 47, '\P{^Is_Lb=sy}', "");
Expect(0, 46, '\p{Is_Lb=sy}', "");
Expect(1, 46, '\p{^Is_Lb=sy}', "");
Expect(1, 46, '\P{Is_Lb=sy}', "");
Expect(0, 46, '\P{^Is_Lb=sy}', "");
Expect(1, 47, '\p{Is_Lb=_-SY}', "");
Expect(0, 47, '\p{^Is_Lb=_-SY}', "");
Expect(0, 47, '\P{Is_Lb=_-SY}', "");
Expect(1, 47, '\P{^Is_Lb=_-SY}', "");
Expect(0, 46, '\p{Is_Lb=_-SY}', "");
Expect(1, 46, '\p{^Is_Lb=_-SY}', "");
Expect(1, 46, '\P{Is_Lb=_-SY}', "");
Expect(0, 46, '\P{^Is_Lb=_-SY}', "");
Error('\p{Line_Break=-prefix	numeric/a/}');
Error('\P{Line_Break=-prefix	numeric/a/}');
Expect(1, 36, '\p{Line_Break:	prefixnumeric}', "");
Expect(0, 36, '\p{^Line_Break:	prefixnumeric}', "");
Expect(0, 36, '\P{Line_Break:	prefixnumeric}', "");
Expect(1, 36, '\P{^Line_Break:	prefixnumeric}', "");
Expect(0, 35, '\p{Line_Break:	prefixnumeric}', "");
Expect(1, 35, '\p{^Line_Break:	prefixnumeric}', "");
Expect(1, 35, '\P{Line_Break:	prefixnumeric}', "");
Expect(0, 35, '\P{^Line_Break:	prefixnumeric}', "");
Expect(1, 36, '\p{Line_Break=-prefix numeric}', "");
Expect(0, 36, '\p{^Line_Break=-prefix numeric}', "");
Expect(0, 36, '\P{Line_Break=-prefix numeric}', "");
Expect(1, 36, '\P{^Line_Break=-prefix numeric}', "");
Expect(0, 35, '\p{Line_Break=-prefix numeric}', "");
Expect(1, 35, '\p{^Line_Break=-prefix numeric}', "");
Expect(1, 35, '\P{Line_Break=-prefix numeric}', "");
Expect(0, 35, '\P{^Line_Break=-prefix numeric}', "");
Error('\p{Lb=	:=PR}');
Error('\P{Lb=	:=PR}');
Expect(1, 36, '\p{Lb=pr}', "");
Expect(0, 36, '\p{^Lb=pr}', "");
Expect(0, 36, '\P{Lb=pr}', "");
Expect(1, 36, '\P{^Lb=pr}', "");
Expect(0, 35, '\p{Lb=pr}', "");
Expect(1, 35, '\p{^Lb=pr}', "");
Expect(1, 35, '\P{Lb=pr}', "");
Expect(0, 35, '\P{^Lb=pr}', "");
Expect(1, 36, '\p{Lb:	PR}', "");
Expect(0, 36, '\p{^Lb:	PR}', "");
Expect(0, 36, '\P{Lb:	PR}', "");
Expect(1, 36, '\P{^Lb:	PR}', "");
Expect(0, 35, '\p{Lb:	PR}', "");
Expect(1, 35, '\p{^Lb:	PR}', "");
Expect(1, 35, '\P{Lb:	PR}', "");
Expect(0, 35, '\P{^Lb:	PR}', "");
Error('\p{Is_Line_Break=/a/ _Prefix	NUMERIC}');
Error('\P{Is_Line_Break=/a/ _Prefix	NUMERIC}');
Expect(1, 36, '\p{Is_Line_Break=prefixnumeric}', "");
Expect(0, 36, '\p{^Is_Line_Break=prefixnumeric}', "");
Expect(0, 36, '\P{Is_Line_Break=prefixnumeric}', "");
Expect(1, 36, '\P{^Is_Line_Break=prefixnumeric}', "");
Expect(0, 35, '\p{Is_Line_Break=prefixnumeric}', "");
Expect(1, 35, '\p{^Is_Line_Break=prefixnumeric}', "");
Expect(1, 35, '\P{Is_Line_Break=prefixnumeric}', "");
Expect(0, 35, '\P{^Is_Line_Break=prefixnumeric}', "");
Expect(1, 36, '\p{Is_Line_Break=-Prefix_numeric}', "");
Expect(0, 36, '\p{^Is_Line_Break=-Prefix_numeric}', "");
Expect(0, 36, '\P{Is_Line_Break=-Prefix_numeric}', "");
Expect(1, 36, '\P{^Is_Line_Break=-Prefix_numeric}', "");
Expect(0, 35, '\p{Is_Line_Break=-Prefix_numeric}', "");
Expect(1, 35, '\p{^Is_Line_Break=-Prefix_numeric}', "");
Expect(1, 35, '\P{Is_Line_Break=-Prefix_numeric}', "");
Expect(0, 35, '\P{^Is_Line_Break=-Prefix_numeric}', "");
Error('\p{Is_Lb:-/a/pr}');
Error('\P{Is_Lb:-/a/pr}');
Expect(1, 36, '\p{Is_Lb=pr}', "");
Expect(0, 36, '\p{^Is_Lb=pr}', "");
Expect(0, 36, '\P{Is_Lb=pr}', "");
Expect(1, 36, '\P{^Is_Lb=pr}', "");
Expect(0, 35, '\p{Is_Lb=pr}', "");
Expect(1, 35, '\p{^Is_Lb=pr}', "");
Expect(1, 35, '\P{Is_Lb=pr}', "");
Expect(0, 35, '\P{^Is_Lb=pr}', "");
Expect(1, 36, '\p{Is_Lb= 	pr}', "");
Expect(0, 36, '\p{^Is_Lb= 	pr}', "");
Expect(0, 36, '\P{Is_Lb= 	pr}', "");
Expect(1, 36, '\P{^Is_Lb= 	pr}', "");
Expect(0, 35, '\p{Is_Lb= 	pr}', "");
Expect(1, 35, '\p{^Is_Lb= 	pr}', "");
Expect(1, 35, '\P{Is_Lb= 	pr}', "");
Expect(0, 35, '\P{^Is_Lb= 	pr}', "");
Error('\p{Line_Break=/a/  close PARENTHESIS}');
Error('\P{Line_Break=/a/  close PARENTHESIS}');
Expect(1, 41, '\p{Line_Break=closeparenthesis}', "");
Expect(0, 41, '\p{^Line_Break=closeparenthesis}', "");
Expect(0, 41, '\P{Line_Break=closeparenthesis}', "");
Expect(1, 41, '\P{^Line_Break=closeparenthesis}', "");
Expect(0, 40, '\p{Line_Break=closeparenthesis}', "");
Expect(1, 40, '\p{^Line_Break=closeparenthesis}', "");
Expect(1, 40, '\P{Line_Break=closeparenthesis}', "");
Expect(0, 40, '\P{^Line_Break=closeparenthesis}', "");
Expect(1, 41, '\p{Line_Break=-	CLOSE-PARENTHESIS}', "");
Expect(0, 41, '\p{^Line_Break=-	CLOSE-PARENTHESIS}', "");
Expect(0, 41, '\P{Line_Break=-	CLOSE-PARENTHESIS}', "");
Expect(1, 41, '\P{^Line_Break=-	CLOSE-PARENTHESIS}', "");
Expect(0, 40, '\p{Line_Break=-	CLOSE-PARENTHESIS}', "");
Expect(1, 40, '\p{^Line_Break=-	CLOSE-PARENTHESIS}', "");
Expect(1, 40, '\P{Line_Break=-	CLOSE-PARENTHESIS}', "");
Expect(0, 40, '\P{^Line_Break=-	CLOSE-PARENTHESIS}', "");
Error('\p{Lb:/a/  CP}');
Error('\P{Lb:/a/  CP}');
Expect(1, 41, '\p{Lb:   cp}', "");
Expect(0, 41, '\p{^Lb:   cp}', "");
Expect(0, 41, '\P{Lb:   cp}', "");
Expect(1, 41, '\P{^Lb:   cp}', "");
Expect(0, 40, '\p{Lb:   cp}', "");
Expect(1, 40, '\p{^Lb:   cp}', "");
Expect(1, 40, '\P{Lb:   cp}', "");
Expect(0, 40, '\P{^Lb:   cp}', "");
Expect(1, 41, '\p{Lb=-CP}', "");
Expect(0, 41, '\p{^Lb=-CP}', "");
Expect(0, 41, '\P{Lb=-CP}', "");
Expect(1, 41, '\P{^Lb=-CP}', "");
Expect(0, 40, '\p{Lb=-CP}', "");
Expect(1, 40, '\p{^Lb=-CP}', "");
Expect(1, 40, '\P{Lb=-CP}', "");
Expect(0, 40, '\P{^Lb=-CP}', "");
Error('\p{Is_Line_Break=CloseParenthesis/a/}');
Error('\P{Is_Line_Break=CloseParenthesis/a/}');
Expect(1, 41, '\p{Is_Line_Break:	closeparenthesis}', "");
Expect(0, 41, '\p{^Is_Line_Break:	closeparenthesis}', "");
Expect(0, 41, '\P{Is_Line_Break:	closeparenthesis}', "");
Expect(1, 41, '\P{^Is_Line_Break:	closeparenthesis}', "");
Expect(0, 40, '\p{Is_Line_Break:	closeparenthesis}', "");
Expect(1, 40, '\p{^Is_Line_Break:	closeparenthesis}', "");
Expect(1, 40, '\P{Is_Line_Break:	closeparenthesis}', "");
Expect(0, 40, '\P{^Is_Line_Break:	closeparenthesis}', "");
Expect(1, 41, '\p{Is_Line_Break=-Close	PARENTHESIS}', "");
Expect(0, 41, '\p{^Is_Line_Break=-Close	PARENTHESIS}', "");
Expect(0, 41, '\P{Is_Line_Break=-Close	PARENTHESIS}', "");
Expect(1, 41, '\P{^Is_Line_Break=-Close	PARENTHESIS}', "");
Expect(0, 40, '\p{Is_Line_Break=-Close	PARENTHESIS}', "");
Expect(1, 40, '\p{^Is_Line_Break=-Close	PARENTHESIS}', "");
Expect(1, 40, '\P{Is_Line_Break=-Close	PARENTHESIS}', "");
Expect(0, 40, '\P{^Is_Line_Break=-Close	PARENTHESIS}', "");
Error('\p{Is_Lb=	:=CP}');
Error('\P{Is_Lb=	:=CP}');
Expect(1, 41, '\p{Is_Lb:cp}', "");
Expect(0, 41, '\p{^Is_Lb:cp}', "");
Expect(0, 41, '\P{Is_Lb:cp}', "");
Expect(1, 41, '\P{^Is_Lb:cp}', "");
Expect(0, 40, '\p{Is_Lb:cp}', "");
Expect(1, 40, '\p{^Is_Lb:cp}', "");
Expect(1, 40, '\P{Is_Lb:cp}', "");
Expect(0, 40, '\P{^Is_Lb:cp}', "");
Expect(1, 41, '\p{Is_Lb= _CP}', "");
Expect(0, 41, '\p{^Is_Lb= _CP}', "");
Expect(0, 41, '\P{Is_Lb= _CP}', "");
Expect(1, 41, '\P{^Is_Lb= _CP}', "");
Expect(0, 40, '\p{Is_Lb= _CP}', "");
Expect(1, 40, '\p{^Is_Lb= _CP}', "");
Expect(1, 40, '\P{Is_Lb= _CP}', "");
Expect(0, 40, '\P{^Is_Lb= _CP}', "");
Error('\p{Line_Break=-/a/h3}');
Error('\P{Line_Break=-/a/h3}');
Expect(1, 44059, '\p{Line_Break:h3}', "");
Expect(0, 44059, '\p{^Line_Break:h3}', "");
Expect(0, 44059, '\P{Line_Break:h3}', "");
Expect(1, 44059, '\P{^Line_Break:h3}', "");
Expect(0, 44032, '\p{Line_Break:h3}', "");
Expect(1, 44032, '\p{^Line_Break:h3}', "");
Expect(1, 44032, '\P{Line_Break:h3}', "");
Expect(0, 44032, '\P{^Line_Break:h3}', "");
Expect(1, 44059, '\p{Line_Break=	H3}', "");
Expect(0, 44059, '\p{^Line_Break=	H3}', "");
Expect(0, 44059, '\P{Line_Break=	H3}', "");
Expect(1, 44059, '\P{^Line_Break=	H3}', "");
Expect(0, 44032, '\p{Line_Break=	H3}', "");
Expect(1, 44032, '\p{^Line_Break=	H3}', "");
Expect(1, 44032, '\P{Line_Break=	H3}', "");
Expect(0, 44032, '\P{^Line_Break=	H3}', "");
Error('\p{Lb=	:=H3}');
Error('\P{Lb=	:=H3}');
Expect(1, 44059, '\p{Lb=h3}', "");
Expect(0, 44059, '\p{^Lb=h3}', "");
Expect(0, 44059, '\P{Lb=h3}', "");
Expect(1, 44059, '\P{^Lb=h3}', "");
Expect(0, 44032, '\p{Lb=h3}', "");
Expect(1, 44032, '\p{^Lb=h3}', "");
Expect(1, 44032, '\P{Lb=h3}', "");
Expect(0, 44032, '\P{^Lb=h3}', "");
Expect(1, 44059, '\p{Lb=-H3}', "");
Expect(0, 44059, '\p{^Lb=-H3}', "");
Expect(0, 44059, '\P{Lb=-H3}', "");
Expect(1, 44059, '\P{^Lb=-H3}', "");
Expect(0, 44032, '\p{Lb=-H3}', "");
Expect(1, 44032, '\p{^Lb=-H3}', "");
Expect(1, 44032, '\P{Lb=-H3}', "");
Expect(0, 44032, '\P{^Lb=-H3}', "");
Error('\p{Is_Line_Break: -	H3/a/}');
Error('\P{Is_Line_Break: -	H3/a/}');
Expect(1, 44059, '\p{Is_Line_Break=h3}', "");
Expect(0, 44059, '\p{^Is_Line_Break=h3}', "");
Expect(0, 44059, '\P{Is_Line_Break=h3}', "");
Expect(1, 44059, '\P{^Is_Line_Break=h3}', "");
Expect(0, 44032, '\p{Is_Line_Break=h3}', "");
Expect(1, 44032, '\p{^Is_Line_Break=h3}', "");
Expect(1, 44032, '\P{Is_Line_Break=h3}', "");
Expect(0, 44032, '\P{^Is_Line_Break=h3}', "");
Expect(1, 44059, '\p{Is_Line_Break=-H3}', "");
Expect(0, 44059, '\p{^Is_Line_Break=-H3}', "");
Expect(0, 44059, '\P{Is_Line_Break=-H3}', "");
Expect(1, 44059, '\P{^Is_Line_Break=-H3}', "");
Expect(0, 44032, '\p{Is_Line_Break=-H3}', "");
Expect(1, 44032, '\p{^Is_Line_Break=-H3}', "");
Expect(1, 44032, '\P{Is_Line_Break=-H3}', "");
Expect(0, 44032, '\P{^Is_Line_Break=-H3}', "");
Error('\p{Is_Lb=/a/H3}');
Error('\P{Is_Lb=/a/H3}');
Expect(1, 44059, '\p{Is_Lb=h3}', "");
Expect(0, 44059, '\p{^Is_Lb=h3}', "");
Expect(0, 44059, '\P{Is_Lb=h3}', "");
Expect(1, 44059, '\P{^Is_Lb=h3}', "");
Expect(0, 44032, '\p{Is_Lb=h3}', "");
Expect(1, 44032, '\p{^Is_Lb=h3}', "");
Expect(1, 44032, '\P{Is_Lb=h3}', "");
Expect(0, 44032, '\P{^Is_Lb=h3}', "");
Expect(1, 44059, '\p{Is_Lb:	_ h3}', "");
Expect(0, 44059, '\p{^Is_Lb:	_ h3}', "");
Expect(0, 44059, '\P{Is_Lb:	_ h3}', "");
Expect(1, 44059, '\P{^Is_Lb:	_ h3}', "");
Expect(0, 44032, '\p{Is_Lb:	_ h3}', "");
Expect(1, 44032, '\p{^Is_Lb:	_ h3}', "");
Expect(1, 44032, '\P{Is_Lb:	_ h3}', "");
Expect(0, 44032, '\P{^Is_Lb:	_ h3}', "");
Error('\p{Line_Break=- carriage-Return/a/}');
Error('\P{Line_Break=- carriage-Return/a/}');
Expect(1, 13, '\p{Line_Break:   carriagereturn}', "");
Expect(0, 13, '\p{^Line_Break:   carriagereturn}', "");
Expect(0, 13, '\P{Line_Break:   carriagereturn}', "");
Expect(1, 13, '\P{^Line_Break:   carriagereturn}', "");
Expect(0, 12, '\p{Line_Break:   carriagereturn}', "");
Expect(1, 12, '\p{^Line_Break:   carriagereturn}', "");
Expect(1, 12, '\P{Line_Break:   carriagereturn}', "");
Expect(0, 12, '\P{^Line_Break:   carriagereturn}', "");
Expect(1, 13, '\p{Line_Break=-Carriage	return}', "");
Expect(0, 13, '\p{^Line_Break=-Carriage	return}', "");
Expect(0, 13, '\P{Line_Break=-Carriage	return}', "");
Expect(1, 13, '\P{^Line_Break=-Carriage	return}', "");
Expect(0, 12, '\p{Line_Break=-Carriage	return}', "");
Expect(1, 12, '\p{^Line_Break=-Carriage	return}', "");
Expect(1, 12, '\P{Line_Break=-Carriage	return}', "");
Expect(0, 12, '\P{^Line_Break=-Carriage	return}', "");
Error('\p{Lb=	/a/CR}');
Error('\P{Lb=	/a/CR}');
Expect(1, 13, '\p{Lb=cr}', "");
Expect(0, 13, '\p{^Lb=cr}', "");
Expect(0, 13, '\P{Lb=cr}', "");
Expect(1, 13, '\P{^Lb=cr}', "");
Expect(0, 12, '\p{Lb=cr}', "");
Expect(1, 12, '\p{^Lb=cr}', "");
Expect(1, 12, '\P{Lb=cr}', "");
Expect(0, 12, '\P{^Lb=cr}', "");
Expect(1, 13, '\p{Lb=_-CR}', "");
Expect(0, 13, '\p{^Lb=_-CR}', "");
Expect(0, 13, '\P{Lb=_-CR}', "");
Expect(1, 13, '\P{^Lb=_-CR}', "");
Expect(0, 12, '\p{Lb=_-CR}', "");
Expect(1, 12, '\p{^Lb=_-CR}', "");
Expect(1, 12, '\P{Lb=_-CR}', "");
Expect(0, 12, '\P{^Lb=_-CR}', "");
Error('\p{Is_Line_Break= :=carriage Return}');
Error('\P{Is_Line_Break= :=carriage Return}');
Expect(1, 13, '\p{Is_Line_Break=carriagereturn}', "");
Expect(0, 13, '\p{^Is_Line_Break=carriagereturn}', "");
Expect(0, 13, '\P{Is_Line_Break=carriagereturn}', "");
Expect(1, 13, '\P{^Is_Line_Break=carriagereturn}', "");
Expect(0, 12, '\p{Is_Line_Break=carriagereturn}', "");
Expect(1, 12, '\p{^Is_Line_Break=carriagereturn}', "");
Expect(1, 12, '\P{Is_Line_Break=carriagereturn}', "");
Expect(0, 12, '\P{^Is_Line_Break=carriagereturn}', "");
Expect(1, 13, '\p{Is_Line_Break=-_Carriage RETURN}', "");
Expect(0, 13, '\p{^Is_Line_Break=-_Carriage RETURN}', "");
Expect(0, 13, '\P{Is_Line_Break=-_Carriage RETURN}', "");
Expect(1, 13, '\P{^Is_Line_Break=-_Carriage RETURN}', "");
Expect(0, 12, '\p{Is_Line_Break=-_Carriage RETURN}', "");
Expect(1, 12, '\p{^Is_Line_Break=-_Carriage RETURN}', "");
Expect(1, 12, '\P{Is_Line_Break=-_Carriage RETURN}', "");
Expect(0, 12, '\P{^Is_Line_Break=-_Carriage RETURN}', "");
Error('\p{Is_Lb=  CR:=}');
Error('\P{Is_Lb=  CR:=}');
Expect(1, 13, '\p{Is_Lb=cr}', "");
Expect(0, 13, '\p{^Is_Lb=cr}', "");
Expect(0, 13, '\P{Is_Lb=cr}', "");
Expect(1, 13, '\P{^Is_Lb=cr}', "");
Expect(0, 12, '\p{Is_Lb=cr}', "");
Expect(1, 12, '\p{^Is_Lb=cr}', "");
Expect(1, 12, '\P{Is_Lb=cr}', "");
Expect(0, 12, '\P{^Is_Lb=cr}', "");
Expect(1, 13, '\p{Is_Lb:   -	CR}', "");
Expect(0, 13, '\p{^Is_Lb:   -	CR}', "");
Expect(0, 13, '\P{Is_Lb:   -	CR}', "");
Expect(1, 13, '\P{^Is_Lb:   -	CR}', "");
Expect(0, 12, '\p{Is_Lb:   -	CR}', "");
Expect(1, 12, '\p{^Is_Lb:   -	CR}', "");
Expect(1, 12, '\P{Is_Lb:   -	CR}', "");
Expect(0, 12, '\P{^Is_Lb:   -	CR}', "");
Error('\p{Line_Break=:=  Closepunctuation}');
Error('\P{Line_Break=:=  Closepunctuation}');
Expect(1, 125, '\p{Line_Break=closepunctuation}', "");
Expect(0, 125, '\p{^Line_Break=closepunctuation}', "");
Expect(0, 125, '\P{Line_Break=closepunctuation}', "");
Expect(1, 125, '\P{^Line_Break=closepunctuation}', "");
Expect(0, 124, '\p{Line_Break=closepunctuation}', "");
Expect(1, 124, '\p{^Line_Break=closepunctuation}', "");
Expect(1, 124, '\P{Line_Break=closepunctuation}', "");
Expect(0, 124, '\P{^Line_Break=closepunctuation}', "");
Expect(1, 125, '\p{Line_Break:   _-CLOSE punctuation}', "");
Expect(0, 125, '\p{^Line_Break:   _-CLOSE punctuation}', "");
Expect(0, 125, '\P{Line_Break:   _-CLOSE punctuation}', "");
Expect(1, 125, '\P{^Line_Break:   _-CLOSE punctuation}', "");
Expect(0, 124, '\p{Line_Break:   _-CLOSE punctuation}', "");
Expect(1, 124, '\p{^Line_Break:   _-CLOSE punctuation}', "");
Expect(1, 124, '\P{Line_Break:   _-CLOSE punctuation}', "");
Expect(0, 124, '\P{^Line_Break:   _-CLOSE punctuation}', "");
Error('\p{Lb=:=-_CL}');
Error('\P{Lb=:=-_CL}');
Expect(1, 125, '\p{Lb: cl}', "");
Expect(0, 125, '\p{^Lb: cl}', "");
Expect(0, 125, '\P{Lb: cl}', "");
Expect(1, 125, '\P{^Lb: cl}', "");
Expect(0, 124, '\p{Lb: cl}', "");
Expect(1, 124, '\p{^Lb: cl}', "");
Expect(1, 124, '\P{Lb: cl}', "");
Expect(0, 124, '\P{^Lb: cl}', "");
Expect(1, 125, '\p{Lb=--CL}', "");
Expect(0, 125, '\p{^Lb=--CL}', "");
Expect(0, 125, '\P{Lb=--CL}', "");
Expect(1, 125, '\P{^Lb=--CL}', "");
Expect(0, 124, '\p{Lb=--CL}', "");
Expect(1, 124, '\p{^Lb=--CL}', "");
Expect(1, 124, '\P{Lb=--CL}', "");
Expect(0, 124, '\P{^Lb=--CL}', "");
Error('\p{Is_Line_Break=:=__Close-PUNCTUATION}');
Error('\P{Is_Line_Break=:=__Close-PUNCTUATION}');
Expect(1, 125, '\p{Is_Line_Break=closepunctuation}', "");
Expect(0, 125, '\p{^Is_Line_Break=closepunctuation}', "");
Expect(0, 125, '\P{Is_Line_Break=closepunctuation}', "");
Expect(1, 125, '\P{^Is_Line_Break=closepunctuation}', "");
Expect(0, 124, '\p{Is_Line_Break=closepunctuation}', "");
Expect(1, 124, '\p{^Is_Line_Break=closepunctuation}', "");
Expect(1, 124, '\P{Is_Line_Break=closepunctuation}', "");
Expect(0, 124, '\P{^Is_Line_Break=closepunctuation}', "");
Expect(1, 125, '\p{Is_Line_Break=_Close-PUNCTUATION}', "");
Expect(0, 125, '\p{^Is_Line_Break=_Close-PUNCTUATION}', "");
Expect(0, 125, '\P{Is_Line_Break=_Close-PUNCTUATION}', "");
Expect(1, 125, '\P{^Is_Line_Break=_Close-PUNCTUATION}', "");
Expect(0, 124, '\p{Is_Line_Break=_Close-PUNCTUATION}', "");
Expect(1, 124, '\p{^Is_Line_Break=_Close-PUNCTUATION}', "");
Expect(1, 124, '\P{Is_Line_Break=_Close-PUNCTUATION}', "");
Expect(0, 124, '\P{^Is_Line_Break=_Close-PUNCTUATION}', "");
Error('\p{Is_Lb=	:=cl}');
Error('\P{Is_Lb=	:=cl}');
Expect(1, 125, '\p{Is_Lb=cl}', "");
Expect(0, 125, '\p{^Is_Lb=cl}', "");
Expect(0, 125, '\P{Is_Lb=cl}', "");
Expect(1, 125, '\P{^Is_Lb=cl}', "");
Expect(0, 124, '\p{Is_Lb=cl}', "");
Expect(1, 124, '\p{^Is_Lb=cl}', "");
Expect(1, 124, '\P{Is_Lb=cl}', "");
Expect(0, 124, '\P{^Is_Lb=cl}', "");
Expect(1, 125, '\p{Is_Lb=_CL}', "");
Expect(0, 125, '\p{^Is_Lb=_CL}', "");
Expect(0, 125, '\P{Is_Lb=_CL}', "");
Expect(1, 125, '\P{^Is_Lb=_CL}', "");
Expect(0, 124, '\p{Is_Lb=_CL}', "");
Expect(1, 124, '\p{^Is_Lb=_CL}', "");
Expect(1, 124, '\P{Is_Lb=_CL}', "");
Expect(0, 124, '\P{^Is_Lb=_CL}', "");
Error('\p{Line_Break=:= -Combining	Mark}');
Error('\P{Line_Break=:= -Combining	Mark}');
Expect(1, 8, '\p{Line_Break=combiningmark}', "");
Expect(0, 8, '\p{^Line_Break=combiningmark}', "");
Expect(0, 8, '\P{Line_Break=combiningmark}', "");
Expect(1, 8, '\P{^Line_Break=combiningmark}', "");
Expect(0, 13, '\p{Line_Break=combiningmark}', "");
Expect(1, 13, '\p{^Line_Break=combiningmark}', "");
Expect(1, 13, '\P{Line_Break=combiningmark}', "");
Expect(0, 13, '\P{^Line_Break=combiningmark}', "");
Expect(1, 8, '\p{Line_Break=-combiningMark}', "");
Expect(0, 8, '\p{^Line_Break=-combiningMark}', "");
Expect(0, 8, '\P{Line_Break=-combiningMark}', "");
Expect(1, 8, '\P{^Line_Break=-combiningMark}', "");
Expect(0, 13, '\p{Line_Break=-combiningMark}', "");
Expect(1, 13, '\p{^Line_Break=-combiningMark}', "");
Expect(1, 13, '\P{Line_Break=-combiningMark}', "");
Expect(0, 13, '\P{^Line_Break=-combiningMark}', "");
Error('\p{Lb=:=cm}');
Error('\P{Lb=:=cm}');
Expect(1, 8, '\p{Lb=cm}', "");
Expect(0, 8, '\p{^Lb=cm}', "");
Expect(0, 8, '\P{Lb=cm}', "");
Expect(1, 8, '\P{^Lb=cm}', "");
Expect(0, 13, '\p{Lb=cm}', "");
Expect(1, 13, '\p{^Lb=cm}', "");
Expect(1, 13, '\P{Lb=cm}', "");
Expect(0, 13, '\P{^Lb=cm}', "");
Expect(1, 8, '\p{Lb=	cm}', "");
Expect(0, 8, '\p{^Lb=	cm}', "");
Expect(0, 8, '\P{Lb=	cm}', "");
Expect(1, 8, '\P{^Lb=	cm}', "");
Expect(0, 13, '\p{Lb=	cm}', "");
Expect(1, 13, '\p{^Lb=	cm}', "");
Expect(1, 13, '\P{Lb=	cm}', "");
Expect(0, 13, '\P{^Lb=	cm}', "");
Error('\p{Is_Line_Break= _Combining-MARK:=}');
Error('\P{Is_Line_Break= _Combining-MARK:=}');
Expect(1, 8, '\p{Is_Line_Break=combiningmark}', "");
Expect(0, 8, '\p{^Is_Line_Break=combiningmark}', "");
Expect(0, 8, '\P{Is_Line_Break=combiningmark}', "");
Expect(1, 8, '\P{^Is_Line_Break=combiningmark}', "");
Expect(0, 13, '\p{Is_Line_Break=combiningmark}', "");
Expect(1, 13, '\p{^Is_Line_Break=combiningmark}', "");
Expect(1, 13, '\P{Is_Line_Break=combiningmark}', "");
Expect(0, 13, '\P{^Is_Line_Break=combiningmark}', "");
Expect(1, 8, '\p{Is_Line_Break=_	Combiningmark}', "");
Expect(0, 8, '\p{^Is_Line_Break=_	Combiningmark}', "");
Expect(0, 8, '\P{Is_Line_Break=_	Combiningmark}', "");
Expect(1, 8, '\P{^Is_Line_Break=_	Combiningmark}', "");
Expect(0, 13, '\p{Is_Line_Break=_	Combiningmark}', "");
Expect(1, 13, '\p{^Is_Line_Break=_	Combiningmark}', "");
Expect(1, 13, '\P{Is_Line_Break=_	Combiningmark}', "");
Expect(0, 13, '\P{^Is_Line_Break=_	Combiningmark}', "");
Error('\p{Is_Lb=-/a/CM}');
Error('\P{Is_Lb=-/a/CM}');
Expect(1, 8, '\p{Is_Lb=cm}', "");
Expect(0, 8, '\p{^Is_Lb=cm}', "");
Expect(0, 8, '\P{Is_Lb=cm}', "");
Expect(1, 8, '\P{^Is_Lb=cm}', "");
Expect(0, 13, '\p{Is_Lb=cm}', "");
Expect(1, 13, '\p{^Is_Lb=cm}', "");
Expect(1, 13, '\P{Is_Lb=cm}', "");
Expect(0, 13, '\P{^Is_Lb=cm}', "");
Expect(1, 8, '\p{Is_Lb:_CM}', "");
Expect(0, 8, '\p{^Is_Lb:_CM}', "");
Expect(0, 8, '\P{Is_Lb:_CM}', "");
Expect(1, 8, '\P{^Is_Lb:_CM}', "");
Expect(0, 13, '\p{Is_Lb:_CM}', "");
Expect(1, 13, '\p{^Is_Lb:_CM}', "");
Expect(1, 13, '\P{Is_Lb:_CM}', "");
Expect(0, 13, '\P{^Is_Lb:_CM}', "");
Error('\p{Line_Break=:=-MANDATORY	Break}');
Error('\P{Line_Break=:=-MANDATORY	Break}');
Expect(1, 12, '\p{Line_Break:	mandatorybreak}', "");
Expect(0, 12, '\p{^Line_Break:	mandatorybreak}', "");
Expect(0, 12, '\P{Line_Break:	mandatorybreak}', "");
Expect(1, 12, '\P{^Line_Break:	mandatorybreak}', "");
Expect(0, 10, '\p{Line_Break:	mandatorybreak}', "");
Expect(1, 10, '\p{^Line_Break:	mandatorybreak}', "");
Expect(1, 10, '\P{Line_Break:	mandatorybreak}', "");
Expect(0, 10, '\P{^Line_Break:	mandatorybreak}', "");
Expect(1, 12, '\p{Line_Break=-MandatoryBreak}', "");
Expect(0, 12, '\p{^Line_Break=-MandatoryBreak}', "");
Expect(0, 12, '\P{Line_Break=-MandatoryBreak}', "");
Expect(1, 12, '\P{^Line_Break=-MandatoryBreak}', "");
Expect(0, 10, '\p{Line_Break=-MandatoryBreak}', "");
Expect(1, 10, '\p{^Line_Break=-MandatoryBreak}', "");
Expect(1, 10, '\P{Line_Break=-MandatoryBreak}', "");
Expect(0, 10, '\P{^Line_Break=-MandatoryBreak}', "");
Error('\p{Lb=	:=BK}');
Error('\P{Lb=	:=BK}');
Expect(1, 12, '\p{Lb=bk}', "");
Expect(0, 12, '\p{^Lb=bk}', "");
Expect(0, 12, '\P{Lb=bk}', "");
Expect(1, 12, '\P{^Lb=bk}', "");
Expect(0, 10, '\p{Lb=bk}', "");
Expect(1, 10, '\p{^Lb=bk}', "");
Expect(1, 10, '\P{Lb=bk}', "");
Expect(0, 10, '\P{^Lb=bk}', "");
Expect(1, 12, '\p{Lb: - BK}', "");
Expect(0, 12, '\p{^Lb: - BK}', "");
Expect(0, 12, '\P{Lb: - BK}', "");
Expect(1, 12, '\P{^Lb: - BK}', "");
Expect(0, 10, '\p{Lb: - BK}', "");
Expect(1, 10, '\p{^Lb: - BK}', "");
Expect(1, 10, '\P{Lb: - BK}', "");
Expect(0, 10, '\P{^Lb: - BK}', "");
Error('\p{Is_Line_Break=_Mandatory-break/a/}');
Error('\P{Is_Line_Break=_Mandatory-break/a/}');
Expect(1, 12, '\p{Is_Line_Break=mandatorybreak}', "");
Expect(0, 12, '\p{^Is_Line_Break=mandatorybreak}', "");
Expect(0, 12, '\P{Is_Line_Break=mandatorybreak}', "");
Expect(1, 12, '\P{^Is_Line_Break=mandatorybreak}', "");
Expect(0, 10, '\p{Is_Line_Break=mandatorybreak}', "");
Expect(1, 10, '\p{^Is_Line_Break=mandatorybreak}', "");
Expect(1, 10, '\P{Is_Line_Break=mandatorybreak}', "");
Expect(0, 10, '\P{^Is_Line_Break=mandatorybreak}', "");
Expect(1, 12, '\p{Is_Line_Break= -Mandatory_Break}', "");
Expect(0, 12, '\p{^Is_Line_Break= -Mandatory_Break}', "");
Expect(0, 12, '\P{Is_Line_Break= -Mandatory_Break}', "");
Expect(1, 12, '\P{^Is_Line_Break= -Mandatory_Break}', "");
Expect(0, 10, '\p{Is_Line_Break= -Mandatory_Break}', "");
Expect(1, 10, '\p{^Is_Line_Break= -Mandatory_Break}', "");
Expect(1, 10, '\P{Is_Line_Break= -Mandatory_Break}', "");
Expect(0, 10, '\P{^Is_Line_Break= -Mandatory_Break}', "");
Error('\p{Is_Lb=- bk:=}');
Error('\P{Is_Lb=- bk:=}');
Expect(1, 12, '\p{Is_Lb=bk}', "");
Expect(0, 12, '\p{^Is_Lb=bk}', "");
Expect(0, 12, '\P{Is_Lb=bk}', "");
Expect(1, 12, '\P{^Is_Lb=bk}', "");
Expect(0, 10, '\p{Is_Lb=bk}', "");
Expect(1, 10, '\p{^Is_Lb=bk}', "");
Expect(1, 10, '\P{Is_Lb=bk}', "");
Expect(0, 10, '\P{^Is_Lb=bk}', "");
Expect(1, 12, '\p{Is_Lb=-_bk}', "");
Expect(0, 12, '\p{^Is_Lb=-_bk}', "");
Expect(0, 12, '\P{Is_Lb=-_bk}', "");
Expect(1, 12, '\P{^Is_Lb=-_bk}', "");
Expect(0, 10, '\p{Is_Lb=-_bk}', "");
Expect(1, 10, '\p{^Is_Lb=-_bk}', "");
Expect(1, 10, '\P{Is_Lb=-_bk}', "");
Expect(0, 10, '\P{^Is_Lb=-_bk}', "");
Error('\p{Line_Break=__Nonstarter/a/}');
Error('\P{Line_Break=__Nonstarter/a/}');
Expect(1, 6102, '\p{Line_Break=nonstarter}', "");
Expect(0, 6102, '\p{^Line_Break=nonstarter}', "");
Expect(0, 6102, '\P{Line_Break=nonstarter}', "");
Expect(1, 6102, '\P{^Line_Break=nonstarter}', "");
Expect(0, 6101, '\p{Line_Break=nonstarter}', "");
Expect(1, 6101, '\p{^Line_Break=nonstarter}', "");
Expect(1, 6101, '\P{Line_Break=nonstarter}', "");
Expect(0, 6101, '\P{^Line_Break=nonstarter}', "");
Expect(1, 6102, '\p{Line_Break=-NONSTARTER}', "");
Expect(0, 6102, '\p{^Line_Break=-NONSTARTER}', "");
Expect(0, 6102, '\P{Line_Break=-NONSTARTER}', "");
Expect(1, 6102, '\P{^Line_Break=-NONSTARTER}', "");
Expect(0, 6101, '\p{Line_Break=-NONSTARTER}', "");
Expect(1, 6101, '\p{^Line_Break=-NONSTARTER}', "");
Expect(1, 6101, '\P{Line_Break=-NONSTARTER}', "");
Expect(0, 6101, '\P{^Line_Break=-NONSTARTER}', "");
Error('\p{Lb=:=	 NS}');
Error('\P{Lb=:=	 NS}');
Expect(1, 6102, '\p{Lb=ns}', "");
Expect(0, 6102, '\p{^Lb=ns}', "");
Expect(0, 6102, '\P{Lb=ns}', "");
Expect(1, 6102, '\P{^Lb=ns}', "");
Expect(0, 6101, '\p{Lb=ns}', "");
Expect(1, 6101, '\p{^Lb=ns}', "");
Expect(1, 6101, '\P{Lb=ns}', "");
Expect(0, 6101, '\P{^Lb=ns}', "");
Expect(1, 6102, '\p{Lb= _NS}', "");
Expect(0, 6102, '\p{^Lb= _NS}', "");
Expect(0, 6102, '\P{Lb= _NS}', "");
Expect(1, 6102, '\P{^Lb= _NS}', "");
Expect(0, 6101, '\p{Lb= _NS}', "");
Expect(1, 6101, '\p{^Lb= _NS}', "");
Expect(1, 6101, '\P{Lb= _NS}', "");
Expect(0, 6101, '\P{^Lb= _NS}', "");
Error('\p{Is_Line_Break=	:=NONSTARTER}');
Error('\P{Is_Line_Break=	:=NONSTARTER}');
Expect(1, 6102, '\p{Is_Line_Break:nonstarter}', "");
Expect(0, 6102, '\p{^Is_Line_Break:nonstarter}', "");
Expect(0, 6102, '\P{Is_Line_Break:nonstarter}', "");
Expect(1, 6102, '\P{^Is_Line_Break:nonstarter}', "");
Expect(0, 6101, '\p{Is_Line_Break:nonstarter}', "");
Expect(1, 6101, '\p{^Is_Line_Break:nonstarter}', "");
Expect(1, 6101, '\P{Is_Line_Break:nonstarter}', "");
Expect(0, 6101, '\P{^Is_Line_Break:nonstarter}', "");
Expect(1, 6102, '\p{Is_Line_Break=_nonstarter}', "");
Expect(0, 6102, '\p{^Is_Line_Break=_nonstarter}', "");
Expect(0, 6102, '\P{Is_Line_Break=_nonstarter}', "");
Expect(1, 6102, '\P{^Is_Line_Break=_nonstarter}', "");
Expect(0, 6101, '\p{Is_Line_Break=_nonstarter}', "");
Expect(1, 6101, '\p{^Is_Line_Break=_nonstarter}', "");
Expect(1, 6101, '\P{Is_Line_Break=_nonstarter}', "");
Expect(0, 6101, '\P{^Is_Line_Break=_nonstarter}', "");
Error('\p{Is_Lb=:=__NS}');
Error('\P{Is_Lb=:=__NS}');
Expect(1, 6102, '\p{Is_Lb=ns}', "");
Expect(0, 6102, '\p{^Is_Lb=ns}', "");
Expect(0, 6102, '\P{Is_Lb=ns}', "");
Expect(1, 6102, '\P{^Is_Lb=ns}', "");
Expect(0, 6101, '\p{Is_Lb=ns}', "");
Expect(1, 6101, '\p{^Is_Lb=ns}', "");
Expect(1, 6101, '\P{Is_Lb=ns}', "");
Expect(0, 6101, '\P{^Is_Lb=ns}', "");
Expect(1, 6102, '\p{Is_Lb=_-NS}', "");
Expect(0, 6102, '\p{^Is_Lb=_-NS}', "");
Expect(0, 6102, '\P{Is_Lb=_-NS}', "");
Expect(1, 6102, '\P{^Is_Lb=_-NS}', "");
Expect(0, 6101, '\p{Is_Lb=_-NS}', "");
Expect(1, 6101, '\p{^Is_Lb=_-NS}', "");
Expect(1, 6101, '\P{Is_Lb=_-NS}', "");
Expect(0, 6101, '\P{^Is_Lb=_-NS}', "");
Error('\p{Line_Break=/a/JV}');
Error('\P{Line_Break=/a/JV}');
Expect(1, 4519, '\p{Line_Break=jv}', "");
Expect(0, 4519, '\p{^Line_Break=jv}', "");
Expect(0, 4519, '\P{Line_Break=jv}', "");
Expect(1, 4519, '\P{^Line_Break=jv}', "");
Expect(0, 4447, '\p{Line_Break=jv}', "");
Expect(1, 4447, '\p{^Line_Break=jv}', "");
Expect(1, 4447, '\P{Line_Break=jv}', "");
Expect(0, 4447, '\P{^Line_Break=jv}', "");
Expect(1, 4519, '\p{Line_Break=	JV}', "");
Expect(0, 4519, '\p{^Line_Break=	JV}', "");
Expect(0, 4519, '\P{Line_Break=	JV}', "");
Expect(1, 4519, '\P{^Line_Break=	JV}', "");
Expect(0, 4447, '\p{Line_Break=	JV}', "");
Expect(1, 4447, '\p{^Line_Break=	JV}', "");
Expect(1, 4447, '\P{Line_Break=	JV}', "");
Expect(0, 4447, '\P{^Line_Break=	JV}', "");
Error('\p{Lb= jv/a/}');
Error('\P{Lb= jv/a/}');
Expect(1, 4519, '\p{Lb=jv}', "");
Expect(0, 4519, '\p{^Lb=jv}', "");
Expect(0, 4519, '\P{Lb=jv}', "");
Expect(1, 4519, '\P{^Lb=jv}', "");
Expect(0, 4447, '\p{Lb=jv}', "");
Expect(1, 4447, '\p{^Lb=jv}', "");
Expect(1, 4447, '\P{Lb=jv}', "");
Expect(0, 4447, '\P{^Lb=jv}', "");
Expect(1, 4519, '\p{Lb=-JV}', "");
Expect(0, 4519, '\p{^Lb=-JV}', "");
Expect(0, 4519, '\P{Lb=-JV}', "");
Expect(1, 4519, '\P{^Lb=-JV}', "");
Expect(0, 4447, '\p{Lb=-JV}', "");
Expect(1, 4447, '\p{^Lb=-JV}', "");
Expect(1, 4447, '\P{Lb=-JV}', "");
Expect(0, 4447, '\P{^Lb=-JV}', "");
Error('\p{Is_Line_Break=/a/	JV}');
Error('\P{Is_Line_Break=/a/	JV}');
Expect(1, 4519, '\p{Is_Line_Break:jv}', "");
Expect(0, 4519, '\p{^Is_Line_Break:jv}', "");
Expect(0, 4519, '\P{Is_Line_Break:jv}', "");
Expect(1, 4519, '\P{^Is_Line_Break:jv}', "");
Expect(0, 4447, '\p{Is_Line_Break:jv}', "");
Expect(1, 4447, '\p{^Is_Line_Break:jv}', "");
Expect(1, 4447, '\P{Is_Line_Break:jv}', "");
Expect(0, 4447, '\P{^Is_Line_Break:jv}', "");
Expect(1, 4519, '\p{Is_Line_Break=- JV}', "");
Expect(0, 4519, '\p{^Is_Line_Break=- JV}', "");
Expect(0, 4519, '\P{Is_Line_Break=- JV}', "");
Expect(1, 4519, '\P{^Is_Line_Break=- JV}', "");
Expect(0, 4447, '\p{Is_Line_Break=- JV}', "");
Expect(1, 4447, '\p{^Is_Line_Break=- JV}', "");
Expect(1, 4447, '\P{Is_Line_Break=- JV}', "");
Expect(0, 4447, '\P{^Is_Line_Break=- JV}', "");
Error('\p{Is_Lb=:=JV}');
Error('\P{Is_Lb=:=JV}');
Expect(1, 4519, '\p{Is_Lb=jv}', "");
Expect(0, 4519, '\p{^Is_Lb=jv}', "");
Expect(0, 4519, '\P{Is_Lb=jv}', "");
Expect(1, 4519, '\P{^Is_Lb=jv}', "");
Expect(0, 4447, '\p{Is_Lb=jv}', "");
Expect(1, 4447, '\p{^Is_Lb=jv}', "");
Expect(1, 4447, '\P{Is_Lb=jv}', "");
Expect(0, 4447, '\P{^Is_Lb=jv}', "");
Expect(1, 4519, '\p{Is_Lb=JV}', "");
Expect(0, 4519, '\p{^Is_Lb=JV}', "");
Expect(0, 4519, '\P{Is_Lb=JV}', "");
Expect(1, 4519, '\P{^Is_Lb=JV}', "");
Expect(0, 4447, '\p{Is_Lb=JV}', "");
Expect(1, 4447, '\p{^Is_Lb=JV}', "");
Expect(1, 4447, '\P{Is_Lb=JV}', "");
Expect(0, 4447, '\P{^Is_Lb=JV}', "");
Error('\p{Line_Break:	:=_-Quotation}');
Error('\P{Line_Break:	:=_-Quotation}');
Expect(1, 34, '\p{Line_Break=quotation}', "");
Expect(0, 34, '\p{^Line_Break=quotation}', "");
Expect(0, 34, '\P{Line_Break=quotation}', "");
Expect(1, 34, '\P{^Line_Break=quotation}', "");
Expect(0, 33, '\p{Line_Break=quotation}', "");
Expect(1, 33, '\p{^Line_Break=quotation}', "");
Expect(1, 33, '\P{Line_Break=quotation}', "");
Expect(0, 33, '\P{^Line_Break=quotation}', "");
Expect(1, 34, '\p{Line_Break= 	Quotation}', "");
Expect(0, 34, '\p{^Line_Break= 	Quotation}', "");
Expect(0, 34, '\P{Line_Break= 	Quotation}', "");
Expect(1, 34, '\P{^Line_Break= 	Quotation}', "");
Expect(0, 33, '\p{Line_Break= 	Quotation}', "");
Expect(1, 33, '\p{^Line_Break= 	Quotation}', "");
Expect(1, 33, '\P{Line_Break= 	Quotation}', "");
Expect(0, 33, '\P{^Line_Break= 	Quotation}', "");
Error('\p{Lb=_	QU:=}');
Error('\P{Lb=_	QU:=}');
Expect(1, 34, '\p{Lb=qu}', "");
Expect(0, 34, '\p{^Lb=qu}', "");
Expect(0, 34, '\P{Lb=qu}', "");
Expect(1, 34, '\P{^Lb=qu}', "");
Expect(0, 33, '\p{Lb=qu}', "");
Expect(1, 33, '\p{^Lb=qu}', "");
Expect(1, 33, '\P{Lb=qu}', "");
Expect(0, 33, '\P{^Lb=qu}', "");
Expect(1, 34, '\p{Lb:    -qu}', "");
Expect(0, 34, '\p{^Lb:    -qu}', "");
Expect(0, 34, '\P{Lb:    -qu}', "");
Expect(1, 34, '\P{^Lb:    -qu}', "");
Expect(0, 33, '\p{Lb:    -qu}', "");
Expect(1, 33, '\p{^Lb:    -qu}', "");
Expect(1, 33, '\P{Lb:    -qu}', "");
Expect(0, 33, '\P{^Lb:    -qu}', "");
Error('\p{Is_Line_Break=-/a/Quotation}');
Error('\P{Is_Line_Break=-/a/Quotation}');
Expect(1, 34, '\p{Is_Line_Break=quotation}', "");
Expect(0, 34, '\p{^Is_Line_Break=quotation}', "");
Expect(0, 34, '\P{Is_Line_Break=quotation}', "");
Expect(1, 34, '\P{^Is_Line_Break=quotation}', "");
Expect(0, 33, '\p{Is_Line_Break=quotation}', "");
Expect(1, 33, '\p{^Is_Line_Break=quotation}', "");
Expect(1, 33, '\P{Is_Line_Break=quotation}', "");
Expect(0, 33, '\P{^Is_Line_Break=quotation}', "");
Expect(1, 34, '\p{Is_Line_Break=-	quotation}', "");
Expect(0, 34, '\p{^Is_Line_Break=-	quotation}', "");
Expect(0, 34, '\P{Is_Line_Break=-	quotation}', "");
Expect(1, 34, '\P{^Is_Line_Break=-	quotation}', "");
Expect(0, 33, '\p{Is_Line_Break=-	quotation}', "");
Expect(1, 33, '\p{^Is_Line_Break=-	quotation}', "");
Expect(1, 33, '\P{Is_Line_Break=-	quotation}', "");
Expect(0, 33, '\P{^Is_Line_Break=-	quotation}', "");
Error('\p{Is_Lb=:=_	QU}');
Error('\P{Is_Lb=:=_	QU}');
Expect(1, 34, '\p{Is_Lb=qu}', "");
Expect(0, 34, '\p{^Is_Lb=qu}', "");
Expect(0, 34, '\P{Is_Lb=qu}', "");
Expect(1, 34, '\P{^Is_Lb=qu}', "");
Expect(0, 33, '\p{Is_Lb=qu}', "");
Expect(1, 33, '\p{^Is_Lb=qu}', "");
Expect(1, 33, '\P{Is_Lb=qu}', "");
Expect(0, 33, '\P{^Is_Lb=qu}', "");
Expect(1, 34, '\p{Is_Lb=	qu}', "");
Expect(0, 34, '\p{^Is_Lb=	qu}', "");
Expect(0, 34, '\P{Is_Lb=	qu}', "");
Expect(1, 34, '\P{^Is_Lb=	qu}', "");
Expect(0, 33, '\p{Is_Lb=	qu}', "");
Expect(1, 33, '\p{^Is_Lb=	qu}', "");
Expect(1, 33, '\P{Is_Lb=	qu}', "");
Expect(0, 33, '\P{^Is_Lb=	qu}', "");
Error('\p{Line_Break= :=Infix_Numeric}');
Error('\P{Line_Break= :=Infix_Numeric}');
Expect(1, 44, '\p{Line_Break=infixnumeric}', "");
Expect(0, 44, '\p{^Line_Break=infixnumeric}', "");
Expect(0, 44, '\P{Line_Break=infixnumeric}', "");
Expect(1, 44, '\P{^Line_Break=infixnumeric}', "");
Expect(0, 43, '\p{Line_Break=infixnumeric}', "");
Expect(1, 43, '\p{^Line_Break=infixnumeric}', "");
Expect(1, 43, '\P{Line_Break=infixnumeric}', "");
Expect(0, 43, '\P{^Line_Break=infixnumeric}', "");
Expect(1, 44, '\p{Line_Break= INFIXNumeric}', "");
Expect(0, 44, '\p{^Line_Break= INFIXNumeric}', "");
Expect(0, 44, '\P{Line_Break= INFIXNumeric}', "");
Expect(1, 44, '\P{^Line_Break= INFIXNumeric}', "");
Expect(0, 43, '\p{Line_Break= INFIXNumeric}', "");
Expect(1, 43, '\p{^Line_Break= INFIXNumeric}', "");
Expect(1, 43, '\P{Line_Break= INFIXNumeric}', "");
Expect(0, 43, '\P{^Line_Break= INFIXNumeric}', "");
Error('\p{Lb=_-IS:=}');
Error('\P{Lb=_-IS:=}');
Expect(1, 44, '\p{Lb=is}', "");
Expect(0, 44, '\p{^Lb=is}', "");
Expect(0, 44, '\P{Lb=is}', "");
Expect(1, 44, '\P{^Lb=is}', "");
Expect(0, 43, '\p{Lb=is}', "");
Expect(1, 43, '\p{^Lb=is}', "");
Expect(1, 43, '\P{Lb=is}', "");
Expect(0, 43, '\P{^Lb=is}', "");
Expect(1, 44, '\p{Lb:	 is}', "");
Expect(0, 44, '\p{^Lb:	 is}', "");
Expect(0, 44, '\P{Lb:	 is}', "");
Expect(1, 44, '\P{^Lb:	 is}', "");
Expect(0, 43, '\p{Lb:	 is}', "");
Expect(1, 43, '\p{^Lb:	 is}', "");
Expect(1, 43, '\P{Lb:	 is}', "");
Expect(0, 43, '\P{^Lb:	 is}', "");
Error('\p{Is_Line_Break=:=-INFIX NUMERIC}');
Error('\P{Is_Line_Break=:=-INFIX NUMERIC}');
Expect(1, 44, '\p{Is_Line_Break=infixnumeric}', "");
Expect(0, 44, '\p{^Is_Line_Break=infixnumeric}', "");
Expect(0, 44, '\P{Is_Line_Break=infixnumeric}', "");
Expect(1, 44, '\P{^Is_Line_Break=infixnumeric}', "");
Expect(0, 43, '\p{Is_Line_Break=infixnumeric}', "");
Expect(1, 43, '\p{^Is_Line_Break=infixnumeric}', "");
Expect(1, 43, '\P{Is_Line_Break=infixnumeric}', "");
Expect(0, 43, '\P{^Is_Line_Break=infixnumeric}', "");
Expect(1, 44, '\p{Is_Line_Break= Infixnumeric}', "");
Expect(0, 44, '\p{^Is_Line_Break= Infixnumeric}', "");
Expect(0, 44, '\P{Is_Line_Break= Infixnumeric}', "");
Expect(1, 44, '\P{^Is_Line_Break= Infixnumeric}', "");
Expect(0, 43, '\p{Is_Line_Break= Infixnumeric}', "");
Expect(1, 43, '\p{^Is_Line_Break= Infixnumeric}', "");
Expect(1, 43, '\P{Is_Line_Break= Infixnumeric}', "");
Expect(0, 43, '\P{^Is_Line_Break= Infixnumeric}', "");
Error('\p{Is_Lb=_	IS/a/}');
Error('\P{Is_Lb=_	IS/a/}');
Expect(1, 44, '\p{Is_Lb: is}', "");
Expect(0, 44, '\p{^Is_Lb: is}', "");
Expect(0, 44, '\P{Is_Lb: is}', "");
Expect(1, 44, '\P{^Is_Lb: is}', "");
Expect(0, 43, '\p{Is_Lb: is}', "");
Expect(1, 43, '\p{^Is_Lb: is}', "");
Expect(1, 43, '\P{Is_Lb: is}', "");
Expect(0, 43, '\P{^Is_Lb: is}', "");
Expect(1, 44, '\p{Is_Lb=	 is}', "");
Expect(0, 44, '\p{^Is_Lb=	 is}', "");
Expect(0, 44, '\P{Is_Lb=	 is}', "");
Expect(1, 44, '\P{^Is_Lb=	 is}', "");
Expect(0, 43, '\p{Is_Lb=	 is}', "");
Expect(1, 43, '\p{^Is_Lb=	 is}', "");
Expect(1, 43, '\P{Is_Lb=	 is}', "");
Expect(0, 43, '\P{^Is_Lb=	 is}', "");
Error('\p{Line_Break=_ Inseparable/a/}');
Error('\P{Line_Break=_ Inseparable/a/}');
Expect(1, 8230, '\p{Line_Break=inseparable}', "");
Expect(0, 8230, '\p{^Line_Break=inseparable}', "");
Expect(0, 8230, '\P{Line_Break=inseparable}', "");
Expect(1, 8230, '\P{^Line_Break=inseparable}', "");
Expect(0, 8227, '\p{Line_Break=inseparable}', "");
Expect(1, 8227, '\p{^Line_Break=inseparable}', "");
Expect(1, 8227, '\P{Line_Break=inseparable}', "");
Expect(0, 8227, '\P{^Line_Break=inseparable}', "");
Expect(1, 8230, '\p{Line_Break=-Inseparable}', "");
Expect(0, 8230, '\p{^Line_Break=-Inseparable}', "");
Expect(0, 8230, '\P{Line_Break=-Inseparable}', "");
Expect(1, 8230, '\P{^Line_Break=-Inseparable}', "");
Expect(0, 8227, '\p{Line_Break=-Inseparable}', "");
Expect(1, 8227, '\p{^Line_Break=-Inseparable}', "");
Expect(1, 8227, '\P{Line_Break=-Inseparable}', "");
Expect(0, 8227, '\P{^Line_Break=-Inseparable}', "");
Error('\p{Lb:		/a/IN}');
Error('\P{Lb:		/a/IN}');
Expect(1, 8230, '\p{Lb=in}', "");
Expect(0, 8230, '\p{^Lb=in}', "");
Expect(0, 8230, '\P{Lb=in}', "");
Expect(1, 8230, '\P{^Lb=in}', "");
Expect(0, 8227, '\p{Lb=in}', "");
Expect(1, 8227, '\p{^Lb=in}', "");
Expect(1, 8227, '\P{Lb=in}', "");
Expect(0, 8227, '\P{^Lb=in}', "");
Expect(1, 8230, '\p{Lb=--in}', "");
Expect(0, 8230, '\p{^Lb=--in}', "");
Expect(0, 8230, '\P{Lb=--in}', "");
Expect(1, 8230, '\P{^Lb=--in}', "");
Expect(0, 8227, '\p{Lb=--in}', "");
Expect(1, 8227, '\p{^Lb=--in}', "");
Expect(1, 8227, '\P{Lb=--in}', "");
Expect(0, 8227, '\P{^Lb=--in}', "");
Error('\p{Is_Line_Break=		inseperable/a/}');
Error('\P{Is_Line_Break=		inseperable/a/}');
Expect(1, 8230, '\p{Is_Line_Break=inseperable}', "");
Expect(0, 8230, '\p{^Is_Line_Break=inseperable}', "");
Expect(0, 8230, '\P{Is_Line_Break=inseperable}', "");
Expect(1, 8230, '\P{^Is_Line_Break=inseperable}', "");
Expect(0, 8227, '\p{Is_Line_Break=inseperable}', "");
Expect(1, 8227, '\p{^Is_Line_Break=inseperable}', "");
Expect(1, 8227, '\P{Is_Line_Break=inseperable}', "");
Expect(0, 8227, '\P{^Is_Line_Break=inseperable}', "");
Expect(1, 8230, '\p{Is_Line_Break=_inseperable}', "");
Expect(0, 8230, '\p{^Is_Line_Break=_inseperable}', "");
Expect(0, 8230, '\P{Is_Line_Break=_inseperable}', "");
Expect(1, 8230, '\P{^Is_Line_Break=_inseperable}', "");
Expect(0, 8227, '\p{Is_Line_Break=_inseperable}', "");
Expect(1, 8227, '\p{^Is_Line_Break=_inseperable}', "");
Expect(1, 8227, '\P{Is_Line_Break=_inseperable}', "");
Expect(0, 8227, '\P{^Is_Line_Break=_inseperable}', "");
Error('\p{Is_Lb=_INSEPARABLE:=}');
Error('\P{Is_Lb=_INSEPARABLE:=}');
Expect(1, 8230, '\p{Is_Lb=inseparable}', "");
Expect(0, 8230, '\p{^Is_Lb=inseparable}', "");
Expect(0, 8230, '\P{Is_Lb=inseparable}', "");
Expect(1, 8230, '\P{^Is_Lb=inseparable}', "");
Expect(0, 8227, '\p{Is_Lb=inseparable}', "");
Expect(1, 8227, '\p{^Is_Lb=inseparable}', "");
Expect(1, 8227, '\P{Is_Lb=inseparable}', "");
Expect(0, 8227, '\P{^Is_Lb=inseparable}', "");
Expect(1, 8230, '\p{Is_Lb=_inseparable}', "");
Expect(0, 8230, '\p{^Is_Lb=_inseparable}', "");
Expect(0, 8230, '\P{Is_Lb=_inseparable}', "");
Expect(1, 8230, '\P{^Is_Lb=_inseparable}', "");
Expect(0, 8227, '\p{Is_Lb=_inseparable}', "");
Expect(1, 8227, '\p{^Is_Lb=_inseparable}', "");
Expect(1, 8227, '\P{Is_Lb=_inseparable}', "");
Expect(0, 8227, '\P{^Is_Lb=_inseparable}', "");
Error('\p{Line_Break=:=- Complex	Context}');
Error('\P{Line_Break=:=- Complex	Context}');
Expect(1, 3642, '\p{Line_Break: complexcontext}', "");
Expect(0, 3642, '\p{^Line_Break: complexcontext}', "");
Expect(0, 3642, '\P{Line_Break: complexcontext}', "");
Expect(1, 3642, '\P{^Line_Break: complexcontext}', "");
Expect(0, 3584, '\p{Line_Break: complexcontext}', "");
Expect(1, 3584, '\p{^Line_Break: complexcontext}', "");
Expect(1, 3584, '\P{Line_Break: complexcontext}', "");
Expect(0, 3584, '\P{^Line_Break: complexcontext}', "");
Expect(1, 3642, '\p{Line_Break=_ complexContext}', "");
Expect(0, 3642, '\p{^Line_Break=_ complexContext}', "");
Expect(0, 3642, '\P{Line_Break=_ complexContext}', "");
Expect(1, 3642, '\P{^Line_Break=_ complexContext}', "");
Expect(0, 3584, '\p{Line_Break=_ complexContext}', "");
Expect(1, 3584, '\p{^Line_Break=_ complexContext}', "");
Expect(1, 3584, '\P{Line_Break=_ complexContext}', "");
Expect(0, 3584, '\P{^Line_Break=_ complexContext}', "");
Error('\p{Lb=/a/SA}');
Error('\P{Lb=/a/SA}');
Expect(1, 3642, '\p{Lb=sa}', "");
Expect(0, 3642, '\p{^Lb=sa}', "");
Expect(0, 3642, '\P{Lb=sa}', "");
Expect(1, 3642, '\P{^Lb=sa}', "");
Expect(0, 3584, '\p{Lb=sa}', "");
Expect(1, 3584, '\p{^Lb=sa}', "");
Expect(1, 3584, '\P{Lb=sa}', "");
Expect(0, 3584, '\P{^Lb=sa}', "");
Expect(1, 3642, '\p{Lb=-_SA}', "");
Expect(0, 3642, '\p{^Lb=-_SA}', "");
Expect(0, 3642, '\P{Lb=-_SA}', "");
Expect(1, 3642, '\P{^Lb=-_SA}', "");
Expect(0, 3584, '\p{Lb=-_SA}', "");
Expect(1, 3584, '\p{^Lb=-_SA}', "");
Expect(1, 3584, '\P{Lb=-_SA}', "");
Expect(0, 3584, '\P{^Lb=-_SA}', "");
Error('\p{Is_Line_Break= :=ComplexCONTEXT}');
Error('\P{Is_Line_Break= :=ComplexCONTEXT}');
Expect(1, 3642, '\p{Is_Line_Break=complexcontext}', "");
Expect(0, 3642, '\p{^Is_Line_Break=complexcontext}', "");
Expect(0, 3642, '\P{Is_Line_Break=complexcontext}', "");
Expect(1, 3642, '\P{^Is_Line_Break=complexcontext}', "");
Expect(0, 3584, '\p{Is_Line_Break=complexcontext}', "");
Expect(1, 3584, '\p{^Is_Line_Break=complexcontext}', "");
Expect(1, 3584, '\P{Is_Line_Break=complexcontext}', "");
Expect(0, 3584, '\P{^Is_Line_Break=complexcontext}', "");
Expect(1, 3642, '\p{Is_Line_Break=_-Complex	Context}', "");
Expect(0, 3642, '\p{^Is_Line_Break=_-Complex	Context}', "");
Expect(0, 3642, '\P{Is_Line_Break=_-Complex	Context}', "");
Expect(1, 3642, '\P{^Is_Line_Break=_-Complex	Context}', "");
Expect(0, 3584, '\p{Is_Line_Break=_-Complex	Context}', "");
Expect(1, 3584, '\p{^Is_Line_Break=_-Complex	Context}', "");
Expect(1, 3584, '\P{Is_Line_Break=_-Complex	Context}', "");
Expect(0, 3584, '\P{^Is_Line_Break=_-Complex	Context}', "");
Error('\p{Is_Lb=:=	 SA}');
Error('\P{Is_Lb=:=	 SA}');
Expect(1, 3642, '\p{Is_Lb=sa}', "");
Expect(0, 3642, '\p{^Is_Lb=sa}', "");
Expect(0, 3642, '\P{Is_Lb=sa}', "");
Expect(1, 3642, '\P{^Is_Lb=sa}', "");
Expect(0, 3584, '\p{Is_Lb=sa}', "");
Expect(1, 3584, '\p{^Is_Lb=sa}', "");
Expect(1, 3584, '\P{Is_Lb=sa}', "");
Expect(0, 3584, '\P{^Is_Lb=sa}', "");
Expect(1, 3642, '\p{Is_Lb= sa}', "");
Expect(0, 3642, '\p{^Is_Lb= sa}', "");
Expect(0, 3642, '\P{Is_Lb= sa}', "");
Expect(1, 3642, '\P{^Is_Lb= sa}', "");
Expect(0, 3584, '\p{Is_Lb= sa}', "");
Expect(1, 3584, '\p{^Is_Lb= sa}', "");
Expect(1, 3584, '\P{Is_Lb= sa}', "");
Expect(0, 3584, '\P{^Is_Lb= sa}', "");
Error('\p{Line_Break=	/a/HYPHEN}');
Error('\P{Line_Break=	/a/HYPHEN}');
Expect(1, 45, '\p{Line_Break=hyphen}', "");
Expect(0, 45, '\p{^Line_Break=hyphen}', "");
Expect(0, 45, '\P{Line_Break=hyphen}', "");
Expect(1, 45, '\P{^Line_Break=hyphen}', "");
Expect(0, 44, '\p{Line_Break=hyphen}', "");
Expect(1, 44, '\p{^Line_Break=hyphen}', "");
Expect(1, 44, '\P{Line_Break=hyphen}', "");
Expect(0, 44, '\P{^Line_Break=hyphen}', "");
Expect(1, 45, '\p{Line_Break=		hyphen}', "");
Expect(0, 45, '\p{^Line_Break=		hyphen}', "");
Expect(0, 45, '\P{Line_Break=		hyphen}', "");
Expect(1, 45, '\P{^Line_Break=		hyphen}', "");
Expect(0, 44, '\p{Line_Break=		hyphen}', "");
Expect(1, 44, '\p{^Line_Break=		hyphen}', "");
Expect(1, 44, '\P{Line_Break=		hyphen}', "");
Expect(0, 44, '\P{^Line_Break=		hyphen}', "");
Error('\p{Lb=_ HY:=}');
Error('\P{Lb=_ HY:=}');
Expect(1, 45, '\p{Lb=hy}', "");
Expect(0, 45, '\p{^Lb=hy}', "");
Expect(0, 45, '\P{Lb=hy}', "");
Expect(1, 45, '\P{^Lb=hy}', "");
Expect(0, 44, '\p{Lb=hy}', "");
Expect(1, 44, '\p{^Lb=hy}', "");
Expect(1, 44, '\P{Lb=hy}', "");
Expect(0, 44, '\P{^Lb=hy}', "");
Expect(1, 45, '\p{Lb=_	hy}', "");
Expect(0, 45, '\p{^Lb=_	hy}', "");
Expect(0, 45, '\P{Lb=_	hy}', "");
Expect(1, 45, '\P{^Lb=_	hy}', "");
Expect(0, 44, '\p{Lb=_	hy}', "");
Expect(1, 44, '\p{^Lb=_	hy}', "");
Expect(1, 44, '\P{Lb=_	hy}', "");
Expect(0, 44, '\P{^Lb=_	hy}', "");
Error('\p{Is_Line_Break=	-HYPHEN/a/}');
Error('\P{Is_Line_Break=	-HYPHEN/a/}');
Expect(1, 45, '\p{Is_Line_Break=hyphen}', "");
Expect(0, 45, '\p{^Is_Line_Break=hyphen}', "");
Expect(0, 45, '\P{Is_Line_Break=hyphen}', "");
Expect(1, 45, '\P{^Is_Line_Break=hyphen}', "");
Expect(0, 44, '\p{Is_Line_Break=hyphen}', "");
Expect(1, 44, '\p{^Is_Line_Break=hyphen}', "");
Expect(1, 44, '\P{Is_Line_Break=hyphen}', "");
Expect(0, 44, '\P{^Is_Line_Break=hyphen}', "");
Expect(1, 45, '\p{Is_Line_Break=_Hyphen}', "");
Expect(0, 45, '\p{^Is_Line_Break=_Hyphen}', "");
Expect(0, 45, '\P{Is_Line_Break=_Hyphen}', "");
Expect(1, 45, '\P{^Is_Line_Break=_Hyphen}', "");
Expect(0, 44, '\p{Is_Line_Break=_Hyphen}', "");
Expect(1, 44, '\p{^Is_Line_Break=_Hyphen}', "");
Expect(1, 44, '\P{Is_Line_Break=_Hyphen}', "");
Expect(0, 44, '\P{^Is_Line_Break=_Hyphen}', "");
Error('\p{Is_Lb=		hy:=}');
Error('\P{Is_Lb=		hy:=}');
Expect(1, 45, '\p{Is_Lb=hy}', "");
Expect(0, 45, '\p{^Is_Lb=hy}', "");
Expect(0, 45, '\P{Is_Lb=hy}', "");
Expect(1, 45, '\P{^Is_Lb=hy}', "");
Expect(0, 44, '\p{Is_Lb=hy}', "");
Expect(1, 44, '\p{^Is_Lb=hy}', "");
Expect(1, 44, '\P{Is_Lb=hy}', "");
Expect(0, 44, '\P{^Is_Lb=hy}', "");
Expect(1, 45, '\p{Is_Lb=-_HY}', "");
Expect(0, 45, '\p{^Is_Lb=-_HY}', "");
Expect(0, 45, '\P{Is_Lb=-_HY}', "");
Expect(1, 45, '\P{^Is_Lb=-_HY}', "");
Expect(0, 44, '\p{Is_Lb=-_HY}', "");
Expect(1, 44, '\p{^Is_Lb=-_HY}', "");
Expect(1, 44, '\P{Is_Lb=-_HY}', "");
Expect(0, 44, '\P{^Is_Lb=-_HY}', "");
Error('\p{Line_Break=_-break/a/after}');
Error('\P{Line_Break=_-break/a/after}');
Expect(1, 9, '\p{Line_Break=breakafter}', "");
Expect(0, 9, '\p{^Line_Break=breakafter}', "");
Expect(0, 9, '\P{Line_Break=breakafter}', "");
Expect(1, 9, '\P{^Line_Break=breakafter}', "");
Expect(0, 8, '\p{Line_Break=breakafter}', "");
Expect(1, 8, '\p{^Line_Break=breakafter}', "");
Expect(1, 8, '\P{Line_Break=breakafter}', "");
Expect(0, 8, '\P{^Line_Break=breakafter}', "");
Expect(1, 9, '\p{Line_Break=-	break_After}', "");
Expect(0, 9, '\p{^Line_Break=-	break_After}', "");
Expect(0, 9, '\P{Line_Break=-	break_After}', "");
Expect(1, 9, '\P{^Line_Break=-	break_After}', "");
Expect(0, 8, '\p{Line_Break=-	break_After}', "");
Expect(1, 8, '\p{^Line_Break=-	break_After}', "");
Expect(1, 8, '\P{Line_Break=-	break_After}', "");
Expect(0, 8, '\P{^Line_Break=-	break_After}', "");
Error('\p{Lb=:=_BA}');
Error('\P{Lb=:=_BA}');
Expect(1, 9, '\p{Lb=ba}', "");
Expect(0, 9, '\p{^Lb=ba}', "");
Expect(0, 9, '\P{Lb=ba}', "");
Expect(1, 9, '\P{^Lb=ba}', "");
Expect(0, 8, '\p{Lb=ba}', "");
Expect(1, 8, '\p{^Lb=ba}', "");
Expect(1, 8, '\P{Lb=ba}', "");
Expect(0, 8, '\P{^Lb=ba}', "");
Expect(1, 9, '\p{Lb=-BA}', "");
Expect(0, 9, '\p{^Lb=-BA}', "");
Expect(0, 9, '\P{Lb=-BA}', "");
Expect(1, 9, '\P{^Lb=-BA}', "");
Expect(0, 8, '\p{Lb=-BA}', "");
Expect(1, 8, '\p{^Lb=-BA}', "");
Expect(1, 8, '\P{Lb=-BA}', "");
Expect(0, 8, '\P{^Lb=-BA}', "");
Error('\p{Is_Line_Break=-Break	After/a/}');
Error('\P{Is_Line_Break=-Break	After/a/}');
Expect(1, 9, '\p{Is_Line_Break=breakafter}', "");
Expect(0, 9, '\p{^Is_Line_Break=breakafter}', "");
Expect(0, 9, '\P{Is_Line_Break=breakafter}', "");
Expect(1, 9, '\P{^Is_Line_Break=breakafter}', "");
Expect(0, 8, '\p{Is_Line_Break=breakafter}', "");
Expect(1, 8, '\p{^Is_Line_Break=breakafter}', "");
Expect(1, 8, '\P{Is_Line_Break=breakafter}', "");
Expect(0, 8, '\P{^Is_Line_Break=breakafter}', "");
Expect(1, 9, '\p{Is_Line_Break=-_BreakAfter}', "");
Expect(0, 9, '\p{^Is_Line_Break=-_BreakAfter}', "");
Expect(0, 9, '\P{Is_Line_Break=-_BreakAfter}', "");
Expect(1, 9, '\P{^Is_Line_Break=-_BreakAfter}', "");
Expect(0, 8, '\p{Is_Line_Break=-_BreakAfter}', "");
Expect(1, 8, '\p{^Is_Line_Break=-_BreakAfter}', "");
Expect(1, 8, '\P{Is_Line_Break=-_BreakAfter}', "");
Expect(0, 8, '\P{^Is_Line_Break=-_BreakAfter}', "");
Error('\p{Is_Lb=-BA/a/}');
Error('\P{Is_Lb=-BA/a/}');
Expect(1, 9, '\p{Is_Lb=ba}', "");
Expect(0, 9, '\p{^Is_Lb=ba}', "");
Expect(0, 9, '\P{Is_Lb=ba}', "");
Expect(1, 9, '\P{^Is_Lb=ba}', "");
Expect(0, 8, '\p{Is_Lb=ba}', "");
Expect(1, 8, '\p{^Is_Lb=ba}', "");
Expect(1, 8, '\P{Is_Lb=ba}', "");
Expect(0, 8, '\P{^Is_Lb=ba}', "");
Expect(1, 9, '\p{Is_Lb=_	BA}', "");
Expect(0, 9, '\p{^Is_Lb=_	BA}', "");
Expect(0, 9, '\P{Is_Lb=_	BA}', "");
Expect(1, 9, '\P{^Is_Lb=_	BA}', "");
Expect(0, 8, '\p{Is_Lb=_	BA}', "");
Expect(1, 8, '\p{^Is_Lb=_	BA}', "");
Expect(1, 8, '\P{Is_Lb=_	BA}', "");
Expect(0, 8, '\P{^Is_Lb=_	BA}', "");
Error('\p{Line_Break=_	LINE feed:=}');
Error('\P{Line_Break=_	LINE feed:=}');
Expect(1, 10, '\p{Line_Break=linefeed}', "");
Expect(0, 10, '\p{^Line_Break=linefeed}', "");
Expect(0, 10, '\P{Line_Break=linefeed}', "");
Expect(1, 10, '\P{^Line_Break=linefeed}', "");
Expect(0, 9, '\p{Line_Break=linefeed}', "");
Expect(1, 9, '\p{^Line_Break=linefeed}', "");
Expect(1, 9, '\P{Line_Break=linefeed}', "");
Expect(0, 9, '\P{^Line_Break=linefeed}', "");
Expect(1, 10, '\p{Line_Break:	_LINE_feed}', "");
Expect(0, 10, '\p{^Line_Break:	_LINE_feed}', "");
Expect(0, 10, '\P{Line_Break:	_LINE_feed}', "");
Expect(1, 10, '\P{^Line_Break:	_LINE_feed}', "");
Expect(0, 9, '\p{Line_Break:	_LINE_feed}', "");
Expect(1, 9, '\p{^Line_Break:	_LINE_feed}', "");
Expect(1, 9, '\P{Line_Break:	_LINE_feed}', "");
Expect(0, 9, '\P{^Line_Break:	_LINE_feed}', "");
Error('\p{Lb=:= -LF}');
Error('\P{Lb=:= -LF}');
Expect(1, 10, '\p{Lb=lf}', "");
Expect(0, 10, '\p{^Lb=lf}', "");
Expect(0, 10, '\P{Lb=lf}', "");
Expect(1, 10, '\P{^Lb=lf}', "");
Expect(0, 9, '\p{Lb=lf}', "");
Expect(1, 9, '\p{^Lb=lf}', "");
Expect(1, 9, '\P{Lb=lf}', "");
Expect(0, 9, '\P{^Lb=lf}', "");
Error('\p{Is_Line_Break=/a/- Line	FEED}');
Error('\P{Is_Line_Break=/a/- Line	FEED}');
Expect(1, 10, '\p{Is_Line_Break=linefeed}', "");
Expect(0, 10, '\p{^Is_Line_Break=linefeed}', "");
Expect(0, 10, '\P{Is_Line_Break=linefeed}', "");
Expect(1, 10, '\P{^Is_Line_Break=linefeed}', "");
Expect(0, 9, '\p{Is_Line_Break=linefeed}', "");
Expect(1, 9, '\p{^Is_Line_Break=linefeed}', "");
Expect(1, 9, '\P{Is_Line_Break=linefeed}', "");
Expect(0, 9, '\P{^Is_Line_Break=linefeed}', "");
Expect(1, 10, '\p{Is_Line_Break:   	 Line	FEED}', "");
Expect(0, 10, '\p{^Is_Line_Break:   	 Line	FEED}', "");
Expect(0, 10, '\P{Is_Line_Break:   	 Line	FEED}', "");
Expect(1, 10, '\P{^Is_Line_Break:   	 Line	FEED}', "");
Expect(0, 9, '\p{Is_Line_Break:   	 Line	FEED}', "");
Expect(1, 9, '\p{^Is_Line_Break:   	 Line	FEED}', "");
Expect(1, 9, '\P{Is_Line_Break:   	 Line	FEED}', "");
Expect(0, 9, '\P{^Is_Line_Break:   	 Line	FEED}', "");
Error('\p{Is_Lb=	:=LF}');
Error('\P{Is_Lb=	:=LF}');
Expect(1, 10, '\p{Is_Lb=lf}', "");
Expect(0, 10, '\p{^Is_Lb=lf}', "");
Expect(0, 10, '\P{Is_Lb=lf}', "");
Expect(1, 10, '\P{^Is_Lb=lf}', "");
Expect(0, 9, '\p{Is_Lb=lf}', "");
Expect(1, 9, '\p{^Is_Lb=lf}', "");
Expect(1, 9, '\P{Is_Lb=lf}', "");
Expect(0, 9, '\P{^Is_Lb=lf}', "");
Expect(1, 10, '\p{Is_Lb:   _-lf}', "");
Expect(0, 10, '\p{^Is_Lb:   _-lf}', "");
Expect(0, 10, '\P{Is_Lb:   _-lf}', "");
Expect(1, 10, '\P{^Is_Lb:   _-lf}', "");
Expect(0, 9, '\p{Is_Lb:   _-lf}', "");
Expect(1, 9, '\p{^Is_Lb:   _-lf}', "");
Expect(1, 9, '\P{Is_Lb:   _-lf}', "");
Expect(0, 9, '\P{^Is_Lb:   _-lf}', "");
Error('\p{Line_Break=_AMBIGUOUS:=}');
Error('\P{Line_Break=_AMBIGUOUS:=}');
Expect(1, 168, '\p{Line_Break=ambiguous}', "");
Expect(0, 168, '\p{^Line_Break=ambiguous}', "");
Expect(0, 168, '\P{Line_Break=ambiguous}', "");
Expect(1, 168, '\P{^Line_Break=ambiguous}', "");
Expect(0, 166, '\p{Line_Break=ambiguous}', "");
Expect(1, 166, '\p{^Line_Break=ambiguous}', "");
Expect(1, 166, '\P{Line_Break=ambiguous}', "");
Expect(0, 166, '\P{^Line_Break=ambiguous}', "");
Expect(1, 168, '\p{Line_Break=--Ambiguous}', "");
Expect(0, 168, '\p{^Line_Break=--Ambiguous}', "");
Expect(0, 168, '\P{Line_Break=--Ambiguous}', "");
Expect(1, 168, '\P{^Line_Break=--Ambiguous}', "");
Expect(0, 166, '\p{Line_Break=--Ambiguous}', "");
Expect(1, 166, '\p{^Line_Break=--Ambiguous}', "");
Expect(1, 166, '\P{Line_Break=--Ambiguous}', "");
Expect(0, 166, '\P{^Line_Break=--Ambiguous}', "");
Error('\p{Lb=-	AI/a/}');
Error('\P{Lb=-	AI/a/}');
Expect(1, 168, '\p{Lb=ai}', "");
Expect(0, 168, '\p{^Lb=ai}', "");
Expect(0, 168, '\P{Lb=ai}', "");
Expect(1, 168, '\P{^Lb=ai}', "");
Expect(0, 166, '\p{Lb=ai}', "");
Expect(1, 166, '\p{^Lb=ai}', "");
Expect(1, 166, '\P{Lb=ai}', "");
Expect(0, 166, '\P{^Lb=ai}', "");
Expect(1, 168, '\p{Lb=--AI}', "");
Expect(0, 168, '\p{^Lb=--AI}', "");
Expect(0, 168, '\P{Lb=--AI}', "");
Expect(1, 168, '\P{^Lb=--AI}', "");
Expect(0, 166, '\p{Lb=--AI}', "");
Expect(1, 166, '\p{^Lb=--AI}', "");
Expect(1, 166, '\P{Lb=--AI}', "");
Expect(0, 166, '\P{^Lb=--AI}', "");
Error('\p{Is_Line_Break= :=Ambiguous}');
Error('\P{Is_Line_Break= :=Ambiguous}');
Expect(1, 168, '\p{Is_Line_Break=ambiguous}', "");
Expect(0, 168, '\p{^Is_Line_Break=ambiguous}', "");
Expect(0, 168, '\P{Is_Line_Break=ambiguous}', "");
Expect(1, 168, '\P{^Is_Line_Break=ambiguous}', "");
Expect(0, 166, '\p{Is_Line_Break=ambiguous}', "");
Expect(1, 166, '\p{^Is_Line_Break=ambiguous}', "");
Expect(1, 166, '\P{Is_Line_Break=ambiguous}', "");
Expect(0, 166, '\P{^Is_Line_Break=ambiguous}', "");
Expect(1, 168, '\p{Is_Line_Break= AMBIGUOUS}', "");
Expect(0, 168, '\p{^Is_Line_Break= AMBIGUOUS}', "");
Expect(0, 168, '\P{Is_Line_Break= AMBIGUOUS}', "");
Expect(1, 168, '\P{^Is_Line_Break= AMBIGUOUS}', "");
Expect(0, 166, '\p{Is_Line_Break= AMBIGUOUS}', "");
Expect(1, 166, '\p{^Is_Line_Break= AMBIGUOUS}', "");
Expect(1, 166, '\P{Is_Line_Break= AMBIGUOUS}', "");
Expect(0, 166, '\P{^Is_Line_Break= AMBIGUOUS}', "");
Error('\p{Is_Lb=-ai/a/}');
Error('\P{Is_Lb=-ai/a/}');
Expect(1, 168, '\p{Is_Lb=ai}', "");
Expect(0, 168, '\p{^Is_Lb=ai}', "");
Expect(0, 168, '\P{Is_Lb=ai}', "");
Expect(1, 168, '\P{^Is_Lb=ai}', "");
Expect(0, 166, '\p{Is_Lb=ai}', "");
Expect(1, 166, '\p{^Is_Lb=ai}', "");
Expect(1, 166, '\P{Is_Lb=ai}', "");
Expect(0, 166, '\P{^Is_Lb=ai}', "");
Expect(1, 168, '\p{Is_Lb=		AI}', "");
Expect(0, 168, '\p{^Is_Lb=		AI}', "");
Expect(0, 168, '\P{Is_Lb=		AI}', "");
Expect(1, 168, '\P{^Is_Lb=		AI}', "");
Expect(0, 166, '\p{Is_Lb=		AI}', "");
Expect(1, 166, '\p{^Is_Lb=		AI}', "");
Expect(1, 166, '\P{Is_Lb=		AI}', "");
Expect(0, 166, '\P{^Is_Lb=		AI}', "");
Error('\p{Line_Break: /a/Contingent_Break}');
Error('\P{Line_Break: /a/Contingent_Break}');
Expect(1, 65532, '\p{Line_Break=contingentbreak}', "");
Expect(0, 65532, '\p{^Line_Break=contingentbreak}', "");
Expect(0, 65532, '\P{Line_Break=contingentbreak}', "");
Expect(1, 65532, '\P{^Line_Break=contingentbreak}', "");
Expect(0, 65531, '\p{Line_Break=contingentbreak}', "");
Expect(1, 65531, '\p{^Line_Break=contingentbreak}', "");
Expect(1, 65531, '\P{Line_Break=contingentbreak}', "");
Expect(0, 65531, '\P{^Line_Break=contingentbreak}', "");
Expect(1, 65532, '\p{Line_Break=_Contingent-BREAK}', "");
Expect(0, 65532, '\p{^Line_Break=_Contingent-BREAK}', "");
Expect(0, 65532, '\P{Line_Break=_Contingent-BREAK}', "");
Expect(1, 65532, '\P{^Line_Break=_Contingent-BREAK}', "");
Expect(0, 65531, '\p{Line_Break=_Contingent-BREAK}', "");
Expect(1, 65531, '\p{^Line_Break=_Contingent-BREAK}', "");
Expect(1, 65531, '\P{Line_Break=_Contingent-BREAK}', "");
Expect(0, 65531, '\P{^Line_Break=_Contingent-BREAK}', "");
Error('\p{Lb=_ CB:=}');
Error('\P{Lb=_ CB:=}');
Expect(1, 65532, '\p{Lb=cb}', "");
Expect(0, 65532, '\p{^Lb=cb}', "");
Expect(0, 65532, '\P{Lb=cb}', "");
Expect(1, 65532, '\P{^Lb=cb}', "");
Expect(0, 65531, '\p{Lb=cb}', "");
Expect(1, 65531, '\p{^Lb=cb}', "");
Expect(1, 65531, '\P{Lb=cb}', "");
Expect(0, 65531, '\P{^Lb=cb}', "");
Expect(1, 65532, '\p{Lb:_-CB}', "");
Expect(0, 65532, '\p{^Lb:_-CB}', "");
Expect(0, 65532, '\P{Lb:_-CB}', "");
Expect(1, 65532, '\P{^Lb:_-CB}', "");
Expect(0, 65531, '\p{Lb:_-CB}', "");
Expect(1, 65531, '\p{^Lb:_-CB}', "");
Expect(1, 65531, '\P{Lb:_-CB}', "");
Expect(0, 65531, '\P{^Lb:_-CB}', "");
Error('\p{Is_Line_Break=-	contingent:=break}');
Error('\P{Is_Line_Break=-	contingent:=break}');
Expect(1, 65532, '\p{Is_Line_Break=contingentbreak}', "");
Expect(0, 65532, '\p{^Is_Line_Break=contingentbreak}', "");
Expect(0, 65532, '\P{Is_Line_Break=contingentbreak}', "");
Expect(1, 65532, '\P{^Is_Line_Break=contingentbreak}', "");
Expect(0, 65531, '\p{Is_Line_Break=contingentbreak}', "");
Expect(1, 65531, '\p{^Is_Line_Break=contingentbreak}', "");
Expect(1, 65531, '\P{Is_Line_Break=contingentbreak}', "");
Expect(0, 65531, '\P{^Is_Line_Break=contingentbreak}', "");
Expect(1, 65532, '\p{Is_Line_Break=  Contingent_break}', "");
Expect(0, 65532, '\p{^Is_Line_Break=  Contingent_break}', "");
Expect(0, 65532, '\P{Is_Line_Break=  Contingent_break}', "");
Expect(1, 65532, '\P{^Is_Line_Break=  Contingent_break}', "");
Expect(0, 65531, '\p{Is_Line_Break=  Contingent_break}', "");
Expect(1, 65531, '\p{^Is_Line_Break=  Contingent_break}', "");
Expect(1, 65531, '\P{Is_Line_Break=  Contingent_break}', "");
Expect(0, 65531, '\P{^Is_Line_Break=  Contingent_break}', "");
Error('\p{Is_Lb=:=_CB}');
Error('\P{Is_Lb=:=_CB}');
Expect(1, 65532, '\p{Is_Lb=cb}', "");
Expect(0, 65532, '\p{^Is_Lb=cb}', "");
Expect(0, 65532, '\P{Is_Lb=cb}', "");
Expect(1, 65532, '\P{^Is_Lb=cb}', "");
Expect(0, 65531, '\p{Is_Lb=cb}', "");
Expect(1, 65531, '\p{^Is_Lb=cb}', "");
Expect(1, 65531, '\P{Is_Lb=cb}', "");
Expect(0, 65531, '\P{^Is_Lb=cb}', "");
Expect(1, 65532, '\p{Is_Lb:-_CB}', "");
Expect(0, 65532, '\p{^Is_Lb:-_CB}', "");
Expect(0, 65532, '\P{Is_Lb:-_CB}', "");
Expect(1, 65532, '\P{^Is_Lb:-_CB}', "");
Expect(0, 65531, '\p{Is_Lb:-_CB}', "");
Expect(1, 65531, '\p{^Is_Lb:-_CB}', "");
Expect(1, 65531, '\P{Is_Lb:-_CB}', "");
Expect(0, 65531, '\P{^Is_Lb:-_CB}', "");
Error('\p{Line_Break=:=		Exclamation}');
Error('\P{Line_Break=:=		Exclamation}');
Expect(1, 33, '\p{Line_Break=exclamation}', "");
Expect(0, 33, '\p{^Line_Break=exclamation}', "");
Expect(0, 33, '\P{Line_Break=exclamation}', "");
Expect(1, 33, '\P{^Line_Break=exclamation}', "");
Expect(0, 32, '\p{Line_Break=exclamation}', "");
Expect(1, 32, '\p{^Line_Break=exclamation}', "");
Expect(1, 32, '\P{Line_Break=exclamation}', "");
Expect(0, 32, '\P{^Line_Break=exclamation}', "");
Expect(1, 33, '\p{Line_Break= Exclamation}', "");
Expect(0, 33, '\p{^Line_Break= Exclamation}', "");
Expect(0, 33, '\P{Line_Break= Exclamation}', "");
Expect(1, 33, '\P{^Line_Break= Exclamation}', "");
Expect(0, 32, '\p{Line_Break= Exclamation}', "");
Expect(1, 32, '\p{^Line_Break= Exclamation}', "");
Expect(1, 32, '\P{Line_Break= Exclamation}', "");
Expect(0, 32, '\P{^Line_Break= Exclamation}', "");
Error('\p{Lb=-	EX/a/}');
Error('\P{Lb=-	EX/a/}');
Expect(1, 33, '\p{Lb=ex}', "");
Expect(0, 33, '\p{^Lb=ex}', "");
Expect(0, 33, '\P{Lb=ex}', "");
Expect(1, 33, '\P{^Lb=ex}', "");
Expect(0, 32, '\p{Lb=ex}', "");
Expect(1, 32, '\p{^Lb=ex}', "");
Expect(1, 32, '\P{Lb=ex}', "");
Expect(0, 32, '\P{^Lb=ex}', "");
Expect(1, 33, '\p{Lb= _EX}', "");
Expect(0, 33, '\p{^Lb= _EX}', "");
Expect(0, 33, '\P{Lb= _EX}', "");
Expect(1, 33, '\P{^Lb= _EX}', "");
Expect(0, 32, '\p{Lb= _EX}', "");
Expect(1, 32, '\p{^Lb= _EX}', "");
Expect(1, 32, '\P{Lb= _EX}', "");
Expect(0, 32, '\P{^Lb= _EX}', "");
Error('\p{Is_Line_Break=-Exclamation:=}');
Error('\P{Is_Line_Break=-Exclamation:=}');
Expect(1, 33, '\p{Is_Line_Break=exclamation}', "");
Expect(0, 33, '\p{^Is_Line_Break=exclamation}', "");
Expect(0, 33, '\P{Is_Line_Break=exclamation}', "");
Expect(1, 33, '\P{^Is_Line_Break=exclamation}', "");
Expect(0, 32, '\p{Is_Line_Break=exclamation}', "");
Expect(1, 32, '\p{^Is_Line_Break=exclamation}', "");
Expect(1, 32, '\P{Is_Line_Break=exclamation}', "");
Expect(0, 32, '\P{^Is_Line_Break=exclamation}', "");
Expect(1, 33, '\p{Is_Line_Break=	EXCLAMATION}', "");
Expect(0, 33, '\p{^Is_Line_Break=	EXCLAMATION}', "");
Expect(0, 33, '\P{Is_Line_Break=	EXCLAMATION}', "");
Expect(1, 33, '\P{^Is_Line_Break=	EXCLAMATION}', "");
Expect(0, 32, '\p{Is_Line_Break=	EXCLAMATION}', "");
Expect(1, 32, '\p{^Is_Line_Break=	EXCLAMATION}', "");
Expect(1, 32, '\P{Is_Line_Break=	EXCLAMATION}', "");
Expect(0, 32, '\P{^Is_Line_Break=	EXCLAMATION}', "");
Error('\p{Is_Lb=_/a/EX}');
Error('\P{Is_Lb=_/a/EX}');
Expect(1, 33, '\p{Is_Lb:ex}', "");
Expect(0, 33, '\p{^Is_Lb:ex}', "");
Expect(0, 33, '\P{Is_Lb:ex}', "");
Expect(1, 33, '\P{^Is_Lb:ex}', "");
Expect(0, 32, '\p{Is_Lb:ex}', "");
Expect(1, 32, '\p{^Is_Lb:ex}', "");
Expect(1, 32, '\P{Is_Lb:ex}', "");
Expect(0, 32, '\P{^Is_Lb:ex}', "");
Expect(1, 33, '\p{Is_Lb=-_ex}', "");
Expect(0, 33, '\p{^Is_Lb=-_ex}', "");
Expect(0, 33, '\P{Is_Lb=-_ex}', "");
Expect(1, 33, '\P{^Is_Lb=-_ex}', "");
Expect(0, 32, '\p{Is_Lb=-_ex}', "");
Expect(1, 32, '\p{^Is_Lb=-_ex}', "");
Expect(1, 32, '\P{Is_Lb=-_ex}', "");
Expect(0, 32, '\P{^Is_Lb=-_ex}', "");
Error('\p{Line_Break=:=_ Ideographic}');
Error('\P{Line_Break=:=_ Ideographic}');
Expect(1, 11929, '\p{Line_Break=ideographic}', "");
Expect(0, 11929, '\p{^Line_Break=ideographic}', "");
Expect(0, 11929, '\P{Line_Break=ideographic}', "");
Expect(1, 11929, '\P{^Line_Break=ideographic}', "");
Expect(0, 11903, '\p{Line_Break=ideographic}', "");
Expect(1, 11903, '\p{^Line_Break=ideographic}', "");
Expect(1, 11903, '\P{Line_Break=ideographic}', "");
Expect(0, 11903, '\P{^Line_Break=ideographic}', "");
Expect(1, 11929, '\p{Line_Break=- Ideographic}', "");
Expect(0, 11929, '\p{^Line_Break=- Ideographic}', "");
Expect(0, 11929, '\P{Line_Break=- Ideographic}', "");
Expect(1, 11929, '\P{^Line_Break=- Ideographic}', "");
Expect(0, 11903, '\p{Line_Break=- Ideographic}', "");
Expect(1, 11903, '\p{^Line_Break=- Ideographic}', "");
Expect(1, 11903, '\P{Line_Break=- Ideographic}', "");
Expect(0, 11903, '\P{^Line_Break=- Ideographic}', "");
Error('\p{Lb= :=ID}');
Error('\P{Lb= :=ID}');
Expect(1, 11929, '\p{Lb=id}', "");
Expect(0, 11929, '\p{^Lb=id}', "");
Expect(0, 11929, '\P{Lb=id}', "");
Expect(1, 11929, '\P{^Lb=id}', "");
Expect(0, 11903, '\p{Lb=id}', "");
Expect(1, 11903, '\p{^Lb=id}', "");
Expect(1, 11903, '\P{Lb=id}', "");
Expect(0, 11903, '\P{^Lb=id}', "");
Expect(1, 11929, '\p{Lb= _ID}', "");
Expect(0, 11929, '\p{^Lb= _ID}', "");
Expect(0, 11929, '\P{Lb= _ID}', "");
Expect(1, 11929, '\P{^Lb= _ID}', "");
Expect(0, 11903, '\p{Lb= _ID}', "");
Expect(1, 11903, '\p{^Lb= _ID}', "");
Expect(1, 11903, '\P{Lb= _ID}', "");
Expect(0, 11903, '\P{^Lb= _ID}', "");
Error('\p{Is_Line_Break=:=_Ideographic}');
Error('\P{Is_Line_Break=:=_Ideographic}');
Expect(1, 11929, '\p{Is_Line_Break=ideographic}', "");
Expect(0, 11929, '\p{^Is_Line_Break=ideographic}', "");
Expect(0, 11929, '\P{Is_Line_Break=ideographic}', "");
Expect(1, 11929, '\P{^Is_Line_Break=ideographic}', "");
Expect(0, 11903, '\p{Is_Line_Break=ideographic}', "");
Expect(1, 11903, '\p{^Is_Line_Break=ideographic}', "");
Expect(1, 11903, '\P{Is_Line_Break=ideographic}', "");
Expect(0, 11903, '\P{^Is_Line_Break=ideographic}', "");
Expect(1, 11929, '\p{Is_Line_Break=		ideographic}', "");
Expect(0, 11929, '\p{^Is_Line_Break=		ideographic}', "");
Expect(0, 11929, '\P{Is_Line_Break=		ideographic}', "");
Expect(1, 11929, '\P{^Is_Line_Break=		ideographic}', "");
Expect(0, 11903, '\p{Is_Line_Break=		ideographic}', "");
Expect(1, 11903, '\p{^Is_Line_Break=		ideographic}', "");
Expect(1, 11903, '\P{Is_Line_Break=		ideographic}', "");
Expect(0, 11903, '\P{^Is_Line_Break=		ideographic}', "");
Error('\p{Is_Lb=		ID/a/}');
Error('\P{Is_Lb=		ID/a/}');
Expect(1, 11929, '\p{Is_Lb=id}', "");
Expect(0, 11929, '\p{^Is_Lb=id}', "");
Expect(0, 11929, '\P{Is_Lb=id}', "");
Expect(1, 11929, '\P{^Is_Lb=id}', "");
Expect(0, 11903, '\p{Is_Lb=id}', "");
Expect(1, 11903, '\p{^Is_Lb=id}', "");
Expect(1, 11903, '\P{Is_Lb=id}', "");
Expect(0, 11903, '\P{^Is_Lb=id}', "");
Expect(1, 11929, '\p{Is_Lb=-ID}', "");
Expect(0, 11929, '\p{^Is_Lb=-ID}', "");
Expect(0, 11929, '\P{Is_Lb=-ID}', "");
Expect(1, 11929, '\P{^Is_Lb=-ID}', "");
Expect(0, 11903, '\p{Is_Lb=-ID}', "");
Expect(1, 11903, '\p{^Is_Lb=-ID}', "");
Expect(1, 11903, '\P{Is_Lb=-ID}', "");
Expect(0, 11903, '\P{^Is_Lb=-ID}', "");
Error('\p{Line_Break=WORD:=joiner}');
Error('\P{Line_Break=WORD:=joiner}');
Expect(1, 8288, '\p{Line_Break=wordjoiner}', "");
Expect(0, 8288, '\p{^Line_Break=wordjoiner}', "");
Expect(0, 8288, '\P{Line_Break=wordjoiner}', "");
Expect(1, 8288, '\P{^Line_Break=wordjoiner}', "");
Expect(0, 8287, '\p{Line_Break=wordjoiner}', "");
Expect(1, 8287, '\p{^Line_Break=wordjoiner}', "");
Expect(1, 8287, '\P{Line_Break=wordjoiner}', "");
Expect(0, 8287, '\P{^Line_Break=wordjoiner}', "");
Expect(1, 8288, '\p{Line_Break= _word-JOINER}', "");
Expect(0, 8288, '\p{^Line_Break= _word-JOINER}', "");
Expect(0, 8288, '\P{Line_Break= _word-JOINER}', "");
Expect(1, 8288, '\P{^Line_Break= _word-JOINER}', "");
Expect(0, 8287, '\p{Line_Break= _word-JOINER}', "");
Expect(1, 8287, '\p{^Line_Break= _word-JOINER}', "");
Expect(1, 8287, '\P{Line_Break= _word-JOINER}', "");
Expect(0, 8287, '\P{^Line_Break= _word-JOINER}', "");
Error('\p{Lb=-WJ/a/}');
Error('\P{Lb=-WJ/a/}');
Expect(1, 8288, '\p{Lb:	wj}', "");
Expect(0, 8288, '\p{^Lb:	wj}', "");
Expect(0, 8288, '\P{Lb:	wj}', "");
Expect(1, 8288, '\P{^Lb:	wj}', "");
Expect(0, 8287, '\p{Lb:	wj}', "");
Expect(1, 8287, '\p{^Lb:	wj}', "");
Expect(1, 8287, '\P{Lb:	wj}', "");
Expect(0, 8287, '\P{^Lb:	wj}', "");
Expect(1, 8288, '\p{Lb= WJ}', "");
Expect(0, 8288, '\p{^Lb= WJ}', "");
Expect(0, 8288, '\P{Lb= WJ}', "");
Expect(1, 8288, '\P{^Lb= WJ}', "");
Expect(0, 8287, '\p{Lb= WJ}', "");
Expect(1, 8287, '\p{^Lb= WJ}', "");
Expect(1, 8287, '\P{Lb= WJ}', "");
Expect(0, 8287, '\P{^Lb= WJ}', "");
Error('\p{Is_Line_Break=/a/ wordJOINER}');
Error('\P{Is_Line_Break=/a/ wordJOINER}');
Expect(1, 8288, '\p{Is_Line_Break:wordjoiner}', "");
Expect(0, 8288, '\p{^Is_Line_Break:wordjoiner}', "");
Expect(0, 8288, '\P{Is_Line_Break:wordjoiner}', "");
Expect(1, 8288, '\P{^Is_Line_Break:wordjoiner}', "");
Expect(0, 8287, '\p{Is_Line_Break:wordjoiner}', "");
Expect(1, 8287, '\p{^Is_Line_Break:wordjoiner}', "");
Expect(1, 8287, '\P{Is_Line_Break:wordjoiner}', "");
Expect(0, 8287, '\P{^Is_Line_Break:wordjoiner}', "");
Expect(1, 8288, '\p{Is_Line_Break=_ Word	Joiner}', "");
Expect(0, 8288, '\p{^Is_Line_Break=_ Word	Joiner}', "");
Expect(0, 8288, '\P{Is_Line_Break=_ Word	Joiner}', "");
Expect(1, 8288, '\P{^Is_Line_Break=_ Word	Joiner}', "");
Expect(0, 8287, '\p{Is_Line_Break=_ Word	Joiner}', "");
Expect(1, 8287, '\p{^Is_Line_Break=_ Word	Joiner}', "");
Expect(1, 8287, '\P{Is_Line_Break=_ Word	Joiner}', "");
Expect(0, 8287, '\P{^Is_Line_Break=_ Word	Joiner}', "");
Error('\p{Is_Lb=/a/_wj}');
Error('\P{Is_Lb=/a/_wj}');
Expect(1, 8288, '\p{Is_Lb=wj}', "");
Expect(0, 8288, '\p{^Is_Lb=wj}', "");
Expect(0, 8288, '\P{Is_Lb=wj}', "");
Expect(1, 8288, '\P{^Is_Lb=wj}', "");
Expect(0, 8287, '\p{Is_Lb=wj}', "");
Expect(1, 8287, '\p{^Is_Lb=wj}', "");
Expect(1, 8287, '\P{Is_Lb=wj}', "");
Expect(0, 8287, '\P{^Is_Lb=wj}', "");
Expect(1, 8288, '\p{Is_Lb=-	WJ}', "");
Expect(0, 8288, '\p{^Is_Lb=-	WJ}', "");
Expect(0, 8288, '\P{Is_Lb=-	WJ}', "");
Expect(1, 8288, '\P{^Is_Lb=-	WJ}', "");
Expect(0, 8287, '\p{Is_Lb=-	WJ}', "");
Expect(1, 8287, '\p{^Is_Lb=-	WJ}', "");
Expect(1, 8287, '\P{Is_Lb=-	WJ}', "");
Expect(0, 8287, '\P{^Is_Lb=-	WJ}', "");
Error('\p{Line_Break=:=h2}');
Error('\P{Line_Break=:=h2}');
Expect(1, 44032, '\p{Line_Break=h2}', "");
Expect(0, 44032, '\p{^Line_Break=h2}', "");
Expect(0, 44032, '\P{Line_Break=h2}', "");
Expect(1, 44032, '\P{^Line_Break=h2}', "");
Expect(0, 44031, '\p{Line_Break=h2}', "");
Expect(1, 44031, '\p{^Line_Break=h2}', "");
Expect(1, 44031, '\P{Line_Break=h2}', "");
Expect(0, 44031, '\P{^Line_Break=h2}', "");
Expect(1, 44032, '\p{Line_Break=-H2}', "");
Expect(0, 44032, '\p{^Line_Break=-H2}', "");
Expect(0, 44032, '\P{Line_Break=-H2}', "");
Expect(1, 44032, '\P{^Line_Break=-H2}', "");
Expect(0, 44031, '\p{Line_Break=-H2}', "");
Expect(1, 44031, '\p{^Line_Break=-H2}', "");
Expect(1, 44031, '\P{Line_Break=-H2}', "");
Expect(0, 44031, '\P{^Line_Break=-H2}', "");
Error('\p{Lb=-	h2:=}');
Error('\P{Lb=-	h2:=}');
Expect(1, 44032, '\p{Lb=h2}', "");
Expect(0, 44032, '\p{^Lb=h2}', "");
Expect(0, 44032, '\P{Lb=h2}', "");
Expect(1, 44032, '\P{^Lb=h2}', "");
Expect(0, 44031, '\p{Lb=h2}', "");
Expect(1, 44031, '\p{^Lb=h2}', "");
Expect(1, 44031, '\P{Lb=h2}', "");
Expect(0, 44031, '\P{^Lb=h2}', "");
Expect(1, 44032, '\p{Lb=_H2}', "");
Expect(0, 44032, '\p{^Lb=_H2}', "");
Expect(0, 44032, '\P{Lb=_H2}', "");
Expect(1, 44032, '\P{^Lb=_H2}', "");
Expect(0, 44031, '\p{Lb=_H2}', "");
Expect(1, 44031, '\p{^Lb=_H2}', "");
Expect(1, 44031, '\P{Lb=_H2}', "");
Expect(0, 44031, '\P{^Lb=_H2}', "");
Error('\p{Is_Line_Break=/a/	-h2}');
Error('\P{Is_Line_Break=/a/	-h2}');
Expect(1, 44032, '\p{Is_Line_Break=h2}', "");
Expect(0, 44032, '\p{^Is_Line_Break=h2}', "");
Expect(0, 44032, '\P{Is_Line_Break=h2}', "");
Expect(1, 44032, '\P{^Is_Line_Break=h2}', "");
Expect(0, 44031, '\p{Is_Line_Break=h2}', "");
Expect(1, 44031, '\p{^Is_Line_Break=h2}', "");
Expect(1, 44031, '\P{Is_Line_Break=h2}', "");
Expect(0, 44031, '\P{^Is_Line_Break=h2}', "");
Expect(1, 44032, '\p{Is_Line_Break=  H2}', "");
Expect(0, 44032, '\p{^Is_Line_Break=  H2}', "");
Expect(0, 44032, '\P{Is_Line_Break=  H2}', "");
Expect(1, 44032, '\P{^Is_Line_Break=  H2}', "");
Expect(0, 44031, '\p{Is_Line_Break=  H2}', "");
Expect(1, 44031, '\p{^Is_Line_Break=  H2}', "");
Expect(1, 44031, '\P{Is_Line_Break=  H2}', "");
Expect(0, 44031, '\P{^Is_Line_Break=  H2}', "");
Error('\p{Is_Lb=:=H2}');
Error('\P{Is_Lb=:=H2}');
Expect(1, 44032, '\p{Is_Lb=h2}', "");
Expect(0, 44032, '\p{^Is_Lb=h2}', "");
Expect(0, 44032, '\P{Is_Lb=h2}', "");
Expect(1, 44032, '\P{^Is_Lb=h2}', "");
Expect(0, 44031, '\p{Is_Lb=h2}', "");
Expect(1, 44031, '\p{^Is_Lb=h2}', "");
Expect(1, 44031, '\P{Is_Lb=h2}', "");
Expect(0, 44031, '\P{^Is_Lb=h2}', "");
Expect(1, 44032, '\p{Is_Lb=-h2}', "");
Expect(0, 44032, '\p{^Is_Lb=-h2}', "");
Expect(0, 44032, '\P{Is_Lb=-h2}', "");
Expect(1, 44032, '\P{^Is_Lb=-h2}', "");
Expect(0, 44031, '\p{Is_Lb=-h2}', "");
Expect(1, 44031, '\p{^Is_Lb=-h2}', "");
Expect(1, 44031, '\P{Is_Lb=-h2}', "");
Expect(0, 44031, '\P{^Is_Lb=-h2}', "");
Error('\p{Line_Break= -BREAK_both/a/}');
Error('\P{Line_Break= -BREAK_both/a/}');
Expect(1, 8212, '\p{Line_Break=breakboth}', "");
Expect(0, 8212, '\p{^Line_Break=breakboth}', "");
Expect(0, 8212, '\P{Line_Break=breakboth}', "");
Expect(1, 8212, '\P{^Line_Break=breakboth}', "");
Expect(0, 8211, '\p{Line_Break=breakboth}', "");
Expect(1, 8211, '\p{^Line_Break=breakboth}', "");
Expect(1, 8211, '\P{Line_Break=breakboth}', "");
Expect(0, 8211, '\P{^Line_Break=breakboth}', "");
Expect(1, 8212, '\p{Line_Break=__Break	BOTH}', "");
Expect(0, 8212, '\p{^Line_Break=__Break	BOTH}', "");
Expect(0, 8212, '\P{Line_Break=__Break	BOTH}', "");
Expect(1, 8212, '\P{^Line_Break=__Break	BOTH}', "");
Expect(0, 8211, '\p{Line_Break=__Break	BOTH}', "");
Expect(1, 8211, '\p{^Line_Break=__Break	BOTH}', "");
Expect(1, 8211, '\P{Line_Break=__Break	BOTH}', "");
Expect(0, 8211, '\P{^Line_Break=__Break	BOTH}', "");
Error('\p{Lb=/a/B2}');
Error('\P{Lb=/a/B2}');
Expect(1, 8212, '\p{Lb=b2}', "");
Expect(0, 8212, '\p{^Lb=b2}', "");
Expect(0, 8212, '\P{Lb=b2}', "");
Expect(1, 8212, '\P{^Lb=b2}', "");
Expect(0, 8211, '\p{Lb=b2}', "");
Expect(1, 8211, '\p{^Lb=b2}', "");
Expect(1, 8211, '\P{Lb=b2}', "");
Expect(0, 8211, '\P{^Lb=b2}', "");
Expect(1, 8212, '\p{Lb= _B2}', "");
Expect(0, 8212, '\p{^Lb= _B2}', "");
Expect(0, 8212, '\P{Lb= _B2}', "");
Expect(1, 8212, '\P{^Lb= _B2}', "");
Expect(0, 8211, '\p{Lb= _B2}', "");
Expect(1, 8211, '\p{^Lb= _B2}', "");
Expect(1, 8211, '\P{Lb= _B2}', "");
Expect(0, 8211, '\P{^Lb= _B2}', "");
Error('\p{Is_Line_Break=-	BreakBoth:=}');
Error('\P{Is_Line_Break=-	BreakBoth:=}');
Expect(1, 8212, '\p{Is_Line_Break=breakboth}', "");
Expect(0, 8212, '\p{^Is_Line_Break=breakboth}', "");
Expect(0, 8212, '\P{Is_Line_Break=breakboth}', "");
Expect(1, 8212, '\P{^Is_Line_Break=breakboth}', "");
Expect(0, 8211, '\p{Is_Line_Break=breakboth}', "");
Expect(1, 8211, '\p{^Is_Line_Break=breakboth}', "");
Expect(1, 8211, '\P{Is_Line_Break=breakboth}', "");
Expect(0, 8211, '\P{^Is_Line_Break=breakboth}', "");
Expect(1, 8212, '\p{Is_Line_Break=-BREAK	both}', "");
Expect(0, 8212, '\p{^Is_Line_Break=-BREAK	both}', "");
Expect(0, 8212, '\P{Is_Line_Break=-BREAK	both}', "");
Expect(1, 8212, '\P{^Is_Line_Break=-BREAK	both}', "");
Expect(0, 8211, '\p{Is_Line_Break=-BREAK	both}', "");
Expect(1, 8211, '\p{^Is_Line_Break=-BREAK	both}', "");
Expect(1, 8211, '\P{Is_Line_Break=-BREAK	both}', "");
Expect(0, 8211, '\P{^Is_Line_Break=-BREAK	both}', "");
Error('\p{Is_Lb= /a/b2}');
Error('\P{Is_Lb= /a/b2}');
Expect(1, 8212, '\p{Is_Lb:b2}', "");
Expect(0, 8212, '\p{^Is_Lb:b2}', "");
Expect(0, 8212, '\P{Is_Lb:b2}', "");
Expect(1, 8212, '\P{^Is_Lb:b2}', "");
Expect(0, 8211, '\p{Is_Lb:b2}', "");
Expect(1, 8211, '\p{^Is_Lb:b2}', "");
Expect(1, 8211, '\P{Is_Lb:b2}', "");
Expect(0, 8211, '\P{^Is_Lb:b2}', "");
Expect(1, 8212, '\p{Is_Lb=-B2}', "");
Expect(0, 8212, '\p{^Is_Lb=-B2}', "");
Expect(0, 8212, '\P{Is_Lb=-B2}', "");
Expect(1, 8212, '\P{^Is_Lb=-B2}', "");
Expect(0, 8211, '\p{Is_Lb=-B2}', "");
Expect(1, 8211, '\p{^Is_Lb=-B2}', "");
Expect(1, 8211, '\P{Is_Lb=-B2}', "");
Expect(0, 8211, '\P{^Is_Lb=-B2}', "");
Error('\p{Line_Break=	Alphabetic/a/}');
Error('\P{Line_Break=	Alphabetic/a/}');
Expect(1, 35, '\p{Line_Break:alphabetic}', "");
Expect(0, 35, '\p{^Line_Break:alphabetic}', "");
Expect(0, 35, '\P{Line_Break:alphabetic}', "");
Expect(1, 35, '\P{^Line_Break:alphabetic}', "");
Expect(0, 34, '\p{Line_Break:alphabetic}', "");
Expect(1, 34, '\p{^Line_Break:alphabetic}', "");
Expect(1, 34, '\P{Line_Break:alphabetic}', "");
Expect(0, 34, '\P{^Line_Break:alphabetic}', "");
Expect(1, 35, '\p{Line_Break=-_Alphabetic}', "");
Expect(0, 35, '\p{^Line_Break=-_Alphabetic}', "");
Expect(0, 35, '\P{Line_Break=-_Alphabetic}', "");
Expect(1, 35, '\P{^Line_Break=-_Alphabetic}', "");
Expect(0, 34, '\p{Line_Break=-_Alphabetic}', "");
Expect(1, 34, '\p{^Line_Break=-_Alphabetic}', "");
Expect(1, 34, '\P{Line_Break=-_Alphabetic}', "");
Expect(0, 34, '\P{^Line_Break=-_Alphabetic}', "");
Error('\p{Lb= :=al}');
Error('\P{Lb= :=al}');
Expect(1, 35, '\p{Lb=al}', "");
Expect(0, 35, '\p{^Lb=al}', "");
Expect(0, 35, '\P{Lb=al}', "");
Expect(1, 35, '\P{^Lb=al}', "");
Expect(0, 34, '\p{Lb=al}', "");
Expect(1, 34, '\p{^Lb=al}', "");
Expect(1, 34, '\P{Lb=al}', "");
Expect(0, 34, '\P{^Lb=al}', "");
Expect(1, 35, '\p{Lb=AL}', "");
Expect(0, 35, '\p{^Lb=AL}', "");
Expect(0, 35, '\P{Lb=AL}', "");
Expect(1, 35, '\P{^Lb=AL}', "");
Expect(0, 34, '\p{Lb=AL}', "");
Expect(1, 34, '\p{^Lb=AL}', "");
Expect(1, 34, '\P{Lb=AL}', "");
Expect(0, 34, '\P{^Lb=AL}', "");
Error('\p{Is_Line_Break=-/a/alphabetic}');
Error('\P{Is_Line_Break=-/a/alphabetic}');
Expect(1, 35, '\p{Is_Line_Break=alphabetic}', "");
Expect(0, 35, '\p{^Is_Line_Break=alphabetic}', "");
Expect(0, 35, '\P{Is_Line_Break=alphabetic}', "");
Expect(1, 35, '\P{^Is_Line_Break=alphabetic}', "");
Expect(0, 34, '\p{Is_Line_Break=alphabetic}', "");
Expect(1, 34, '\p{^Is_Line_Break=alphabetic}', "");
Expect(1, 34, '\P{Is_Line_Break=alphabetic}', "");
Expect(0, 34, '\P{^Is_Line_Break=alphabetic}', "");
Expect(1, 35, '\p{Is_Line_Break=	_alphabetic}', "");
Expect(0, 35, '\p{^Is_Line_Break=	_alphabetic}', "");
Expect(0, 35, '\P{Is_Line_Break=	_alphabetic}', "");
Expect(1, 35, '\P{^Is_Line_Break=	_alphabetic}', "");
Expect(0, 34, '\p{Is_Line_Break=	_alphabetic}', "");
Expect(1, 34, '\p{^Is_Line_Break=	_alphabetic}', "");
Expect(1, 34, '\P{Is_Line_Break=	_alphabetic}', "");
Expect(0, 34, '\P{^Is_Line_Break=	_alphabetic}', "");
Error('\p{Is_Lb:-	AL:=}');
Error('\P{Is_Lb:-	AL:=}');
Expect(1, 35, '\p{Is_Lb=al}', "");
Expect(0, 35, '\p{^Is_Lb=al}', "");
Expect(0, 35, '\P{Is_Lb=al}', "");
Expect(1, 35, '\P{^Is_Lb=al}', "");
Expect(0, 34, '\p{Is_Lb=al}', "");
Expect(1, 34, '\p{^Is_Lb=al}', "");
Expect(1, 34, '\P{Is_Lb=al}', "");
Expect(0, 34, '\P{^Is_Lb=al}', "");
Expect(1, 35, '\p{Is_Lb= _al}', "");
Expect(0, 35, '\p{^Is_Lb= _al}', "");
Expect(0, 35, '\P{Is_Lb= _al}', "");
Expect(1, 35, '\P{^Is_Lb= _al}', "");
Expect(0, 34, '\p{Is_Lb= _al}', "");
Expect(1, 34, '\p{^Is_Lb= _al}', "");
Expect(1, 34, '\P{Is_Lb= _al}', "");
Expect(0, 34, '\P{^Is_Lb= _al}', "");
Error('\p{Line_Break= :=postfixNUMERIC}');
Error('\P{Line_Break= :=postfixNUMERIC}');
Expect(1, 37, '\p{Line_Break=postfixnumeric}', "");
Expect(0, 37, '\p{^Line_Break=postfixnumeric}', "");
Expect(0, 37, '\P{Line_Break=postfixnumeric}', "");
Expect(1, 37, '\P{^Line_Break=postfixnumeric}', "");
Expect(0, 36, '\p{Line_Break=postfixnumeric}', "");
Expect(1, 36, '\p{^Line_Break=postfixnumeric}', "");
Expect(1, 36, '\P{Line_Break=postfixnumeric}', "");
Expect(0, 36, '\P{^Line_Break=postfixnumeric}', "");
Expect(1, 37, '\p{Line_Break=__POSTFIX Numeric}', "");
Expect(0, 37, '\p{^Line_Break=__POSTFIX Numeric}', "");
Expect(0, 37, '\P{Line_Break=__POSTFIX Numeric}', "");
Expect(1, 37, '\P{^Line_Break=__POSTFIX Numeric}', "");
Expect(0, 36, '\p{Line_Break=__POSTFIX Numeric}', "");
Expect(1, 36, '\p{^Line_Break=__POSTFIX Numeric}', "");
Expect(1, 36, '\P{Line_Break=__POSTFIX Numeric}', "");
Expect(0, 36, '\P{^Line_Break=__POSTFIX Numeric}', "");
Error('\p{Lb=/a/po}');
Error('\P{Lb=/a/po}');
Expect(1, 37, '\p{Lb=po}', "");
Expect(0, 37, '\p{^Lb=po}', "");
Expect(0, 37, '\P{Lb=po}', "");
Expect(1, 37, '\P{^Lb=po}', "");
Expect(0, 36, '\p{Lb=po}', "");
Expect(1, 36, '\p{^Lb=po}', "");
Expect(1, 36, '\P{Lb=po}', "");
Expect(0, 36, '\P{^Lb=po}', "");
Error('\p{Is_Line_Break=--postfixNumeric:=}');
Error('\P{Is_Line_Break=--postfixNumeric:=}');
Expect(1, 37, '\p{Is_Line_Break:   postfixnumeric}', "");
Expect(0, 37, '\p{^Is_Line_Break:   postfixnumeric}', "");
Expect(0, 37, '\P{Is_Line_Break:   postfixnumeric}', "");
Expect(1, 37, '\P{^Is_Line_Break:   postfixnumeric}', "");
Expect(0, 36, '\p{Is_Line_Break:   postfixnumeric}', "");
Expect(1, 36, '\p{^Is_Line_Break:   postfixnumeric}', "");
Expect(1, 36, '\P{Is_Line_Break:   postfixnumeric}', "");
Expect(0, 36, '\P{^Is_Line_Break:   postfixnumeric}', "");
Expect(1, 37, '\p{Is_Line_Break=	-Postfixnumeric}', "");
Expect(0, 37, '\p{^Is_Line_Break=	-Postfixnumeric}', "");
Expect(0, 37, '\P{Is_Line_Break=	-Postfixnumeric}', "");
Expect(1, 37, '\P{^Is_Line_Break=	-Postfixnumeric}', "");
Expect(0, 36, '\p{Is_Line_Break=	-Postfixnumeric}', "");
Expect(1, 36, '\p{^Is_Line_Break=	-Postfixnumeric}', "");
Expect(1, 36, '\P{Is_Line_Break=	-Postfixnumeric}', "");
Expect(0, 36, '\P{^Is_Line_Break=	-Postfixnumeric}', "");
Error('\p{Is_Lb=:= 	po}');
Error('\P{Is_Lb=:= 	po}');
Expect(1, 37, '\p{Is_Lb=po}', "");
Expect(0, 37, '\p{^Is_Lb=po}', "");
Expect(0, 37, '\P{Is_Lb=po}', "");
Expect(1, 37, '\P{^Is_Lb=po}', "");
Expect(0, 36, '\p{Is_Lb=po}', "");
Expect(1, 36, '\p{^Is_Lb=po}', "");
Expect(1, 36, '\P{Is_Lb=po}', "");
Expect(0, 36, '\P{^Is_Lb=po}', "");
Expect(1, 37, '\p{Is_Lb=_PO}', "");
Expect(0, 37, '\p{^Is_Lb=_PO}', "");
Expect(0, 37, '\P{Is_Lb=_PO}', "");
Expect(1, 37, '\P{^Is_Lb=_PO}', "");
Expect(0, 36, '\p{Is_Lb=_PO}', "");
Expect(1, 36, '\p{^Is_Lb=_PO}', "");
Expect(1, 36, '\P{Is_Lb=_PO}', "");
Expect(0, 36, '\P{^Is_Lb=_PO}', "");
Error('\p{Line_Break=-openPunctuation/a/}');
Error('\P{Line_Break=-openPunctuation/a/}');
Expect(1, 40, '\p{Line_Break=openpunctuation}', "");
Expect(0, 40, '\p{^Line_Break=openpunctuation}', "");
Expect(0, 40, '\P{Line_Break=openpunctuation}', "");
Expect(1, 40, '\P{^Line_Break=openpunctuation}', "");
Expect(0, 39, '\p{Line_Break=openpunctuation}', "");
Expect(1, 39, '\p{^Line_Break=openpunctuation}', "");
Expect(1, 39, '\P{Line_Break=openpunctuation}', "");
Expect(0, 39, '\P{^Line_Break=openpunctuation}', "");
Expect(1, 40, '\p{Line_Break=_	Open	PUNCTUATION}', "");
Expect(0, 40, '\p{^Line_Break=_	Open	PUNCTUATION}', "");
Expect(0, 40, '\P{Line_Break=_	Open	PUNCTUATION}', "");
Expect(1, 40, '\P{^Line_Break=_	Open	PUNCTUATION}', "");
Expect(0, 39, '\p{Line_Break=_	Open	PUNCTUATION}', "");
Expect(1, 39, '\p{^Line_Break=_	Open	PUNCTUATION}', "");
Expect(1, 39, '\P{Line_Break=_	Open	PUNCTUATION}', "");
Expect(0, 39, '\P{^Line_Break=_	Open	PUNCTUATION}', "");
Error('\p{Lb=:=- OP}');
Error('\P{Lb=:=- OP}');
Expect(1, 40, '\p{Lb=op}', "");
Expect(0, 40, '\p{^Lb=op}', "");
Expect(0, 40, '\P{Lb=op}', "");
Expect(1, 40, '\P{^Lb=op}', "");
Expect(0, 39, '\p{Lb=op}', "");
Expect(1, 39, '\p{^Lb=op}', "");
Expect(1, 39, '\P{Lb=op}', "");
Expect(0, 39, '\P{^Lb=op}', "");
Expect(1, 40, '\p{Lb=- OP}', "");
Expect(0, 40, '\p{^Lb=- OP}', "");
Expect(0, 40, '\P{Lb=- OP}', "");
Expect(1, 40, '\P{^Lb=- OP}', "");
Expect(0, 39, '\p{Lb=- OP}', "");
Expect(1, 39, '\p{^Lb=- OP}', "");
Expect(1, 39, '\P{Lb=- OP}', "");
Expect(0, 39, '\P{^Lb=- OP}', "");
Error('\p{Is_Line_Break=_/a/Open_Punctuation}');
Error('\P{Is_Line_Break=_/a/Open_Punctuation}');
Expect(1, 40, '\p{Is_Line_Break:   openpunctuation}', "");
Expect(0, 40, '\p{^Is_Line_Break:   openpunctuation}', "");
Expect(0, 40, '\P{Is_Line_Break:   openpunctuation}', "");
Expect(1, 40, '\P{^Is_Line_Break:   openpunctuation}', "");
Expect(0, 39, '\p{Is_Line_Break:   openpunctuation}', "");
Expect(1, 39, '\p{^Is_Line_Break:   openpunctuation}', "");
Expect(1, 39, '\P{Is_Line_Break:   openpunctuation}', "");
Expect(0, 39, '\P{^Is_Line_Break:   openpunctuation}', "");
Expect(1, 40, '\p{Is_Line_Break:   	open punctuation}', "");
Expect(0, 40, '\p{^Is_Line_Break:   	open punctuation}', "");
Expect(0, 40, '\P{Is_Line_Break:   	open punctuation}', "");
Expect(1, 40, '\P{^Is_Line_Break:   	open punctuation}', "");
Expect(0, 39, '\p{Is_Line_Break:   	open punctuation}', "");
Expect(1, 39, '\p{^Is_Line_Break:   	open punctuation}', "");
Expect(1, 39, '\P{Is_Line_Break:   	open punctuation}', "");
Expect(0, 39, '\P{^Is_Line_Break:   	open punctuation}', "");
Error('\p{Is_Lb=/a/_	OP}');
Error('\P{Is_Lb=/a/_	OP}');
Expect(1, 40, '\p{Is_Lb=op}', "");
Expect(0, 40, '\p{^Is_Lb=op}', "");
Expect(0, 40, '\P{Is_Lb=op}', "");
Expect(1, 40, '\P{^Is_Lb=op}', "");
Expect(0, 39, '\p{Is_Lb=op}', "");
Expect(1, 39, '\p{^Is_Lb=op}', "");
Expect(1, 39, '\P{Is_Lb=op}', "");
Expect(0, 39, '\P{^Is_Lb=op}', "");
Expect(1, 40, '\p{Is_Lb=- OP}', "");
Expect(0, 40, '\p{^Is_Lb=- OP}', "");
Expect(0, 40, '\P{Is_Lb=- OP}', "");
Expect(1, 40, '\P{^Is_Lb=- OP}', "");
Expect(0, 39, '\p{Is_Lb=- OP}', "");
Expect(1, 39, '\p{^Is_Lb=- OP}', "");
Expect(1, 39, '\P{Is_Lb=- OP}', "");
Expect(0, 39, '\P{^Is_Lb=- OP}', "");
Error('\p{Line_Break:	 -next	line:=}');
Error('\P{Line_Break:	 -next	line:=}');
Expect(1, 133, '\p{Line_Break=nextline}', "");
Expect(0, 133, '\p{^Line_Break=nextline}', "");
Expect(0, 133, '\P{Line_Break=nextline}', "");
Expect(1, 133, '\P{^Line_Break=nextline}', "");
Expect(0, 132, '\p{Line_Break=nextline}', "");
Expect(1, 132, '\p{^Line_Break=nextline}', "");
Expect(1, 132, '\P{Line_Break=nextline}', "");
Expect(0, 132, '\P{^Line_Break=nextline}', "");
Expect(1, 133, '\p{Line_Break=_-NEXT-Line}', "");
Expect(0, 133, '\p{^Line_Break=_-NEXT-Line}', "");
Expect(0, 133, '\P{Line_Break=_-NEXT-Line}', "");
Expect(1, 133, '\P{^Line_Break=_-NEXT-Line}', "");
Expect(0, 132, '\p{Line_Break=_-NEXT-Line}', "");
Expect(1, 132, '\p{^Line_Break=_-NEXT-Line}', "");
Expect(1, 132, '\P{Line_Break=_-NEXT-Line}', "");
Expect(0, 132, '\P{^Line_Break=_-NEXT-Line}', "");
Error('\p{Lb=_NL/a/}');
Error('\P{Lb=_NL/a/}');
Expect(1, 133, '\p{Lb=nl}', "");
Expect(0, 133, '\p{^Lb=nl}', "");
Expect(0, 133, '\P{Lb=nl}', "");
Expect(1, 133, '\P{^Lb=nl}', "");
Expect(0, 132, '\p{Lb=nl}', "");
Expect(1, 132, '\p{^Lb=nl}', "");
Expect(1, 132, '\P{Lb=nl}', "");
Expect(0, 132, '\P{^Lb=nl}', "");
Expect(1, 133, '\p{Lb=-NL}', "");
Expect(0, 133, '\p{^Lb=-NL}', "");
Expect(0, 133, '\P{Lb=-NL}', "");
Expect(1, 133, '\P{^Lb=-NL}', "");
Expect(0, 132, '\p{Lb=-NL}', "");
Expect(1, 132, '\p{^Lb=-NL}', "");
Expect(1, 132, '\P{Lb=-NL}', "");
Expect(0, 132, '\P{^Lb=-NL}', "");
Error('\p{Is_Line_Break=next	Line/a/}');
Error('\P{Is_Line_Break=next	Line/a/}');
Expect(1, 133, '\p{Is_Line_Break=nextline}', "");
Expect(0, 133, '\p{^Is_Line_Break=nextline}', "");
Expect(0, 133, '\P{Is_Line_Break=nextline}', "");
Expect(1, 133, '\P{^Is_Line_Break=nextline}', "");
Expect(0, 132, '\p{Is_Line_Break=nextline}', "");
Expect(1, 132, '\p{^Is_Line_Break=nextline}', "");
Expect(1, 132, '\P{Is_Line_Break=nextline}', "");
Expect(0, 132, '\P{^Is_Line_Break=nextline}', "");
Expect(1, 133, '\p{Is_Line_Break=-	Next_LINE}', "");
Expect(0, 133, '\p{^Is_Line_Break=-	Next_LINE}', "");
Expect(0, 133, '\P{Is_Line_Break=-	Next_LINE}', "");
Expect(1, 133, '\P{^Is_Line_Break=-	Next_LINE}', "");
Expect(0, 132, '\p{Is_Line_Break=-	Next_LINE}', "");
Expect(1, 132, '\p{^Is_Line_Break=-	Next_LINE}', "");
Expect(1, 132, '\P{Is_Line_Break=-	Next_LINE}', "");
Expect(0, 132, '\P{^Is_Line_Break=-	Next_LINE}', "");
Error('\p{Is_Lb=:=NL}');
Error('\P{Is_Lb=:=NL}');
Expect(1, 133, '\p{Is_Lb=nl}', "");
Expect(0, 133, '\p{^Is_Lb=nl}', "");
Expect(0, 133, '\P{Is_Lb=nl}', "");
Expect(1, 133, '\P{^Is_Lb=nl}', "");
Expect(0, 132, '\p{Is_Lb=nl}', "");
Expect(1, 132, '\p{^Is_Lb=nl}', "");
Expect(1, 132, '\P{Is_Lb=nl}', "");
Expect(0, 132, '\P{^Is_Lb=nl}', "");
Expect(1, 133, '\p{Is_Lb=	 NL}', "");
Expect(0, 133, '\p{^Is_Lb=	 NL}', "");
Expect(0, 133, '\P{Is_Lb=	 NL}', "");
Expect(1, 133, '\P{^Is_Lb=	 NL}', "");
Expect(0, 132, '\p{Is_Lb=	 NL}', "");
Expect(1, 132, '\p{^Is_Lb=	 NL}', "");
Expect(1, 132, '\P{Is_Lb=	 NL}', "");
Expect(0, 132, '\P{^Is_Lb=	 NL}', "");
Error('\p{Line_Break=-:=JT}');
Error('\P{Line_Break=-:=JT}');
Expect(1, 4607, '\p{Line_Break=jt}', "");
Expect(0, 4607, '\p{^Line_Break=jt}', "");
Expect(0, 4607, '\P{Line_Break=jt}', "");
Expect(1, 4607, '\P{^Line_Break=jt}', "");
Expect(0, 4519, '\p{Line_Break=jt}', "");
Expect(1, 4519, '\p{^Line_Break=jt}', "");
Expect(1, 4519, '\P{Line_Break=jt}', "");
Expect(0, 4519, '\P{^Line_Break=jt}', "");
Expect(1, 4607, '\p{Line_Break= -JT}', "");
Expect(0, 4607, '\p{^Line_Break= -JT}', "");
Expect(0, 4607, '\P{Line_Break= -JT}', "");
Expect(1, 4607, '\P{^Line_Break= -JT}', "");
Expect(0, 4519, '\p{Line_Break= -JT}', "");
Expect(1, 4519, '\p{^Line_Break= -JT}', "");
Expect(1, 4519, '\P{Line_Break= -JT}', "");
Expect(0, 4519, '\P{^Line_Break= -JT}', "");
Error('\p{Lb=:= jt}');
Error('\P{Lb=:= jt}');
Expect(1, 4607, '\p{Lb=jt}', "");
Expect(0, 4607, '\p{^Lb=jt}', "");
Expect(0, 4607, '\P{Lb=jt}', "");
Expect(1, 4607, '\P{^Lb=jt}', "");
Expect(0, 4519, '\p{Lb=jt}', "");
Expect(1, 4519, '\p{^Lb=jt}', "");
Expect(1, 4519, '\P{Lb=jt}', "");
Expect(0, 4519, '\P{^Lb=jt}', "");
Expect(1, 4607, '\p{Lb=--JT}', "");
Expect(0, 4607, '\p{^Lb=--JT}', "");
Expect(0, 4607, '\P{Lb=--JT}', "");
Expect(1, 4607, '\P{^Lb=--JT}', "");
Expect(0, 4519, '\p{Lb=--JT}', "");
Expect(1, 4519, '\p{^Lb=--JT}', "");
Expect(1, 4519, '\P{Lb=--JT}', "");
Expect(0, 4519, '\P{^Lb=--JT}', "");
Error('\p{Is_Line_Break=/a/JT}');
Error('\P{Is_Line_Break=/a/JT}');
Expect(1, 4607, '\p{Is_Line_Break=jt}', "");
Expect(0, 4607, '\p{^Is_Line_Break=jt}', "");
Expect(0, 4607, '\P{Is_Line_Break=jt}', "");
Expect(1, 4607, '\P{^Is_Line_Break=jt}', "");
Expect(0, 4519, '\p{Is_Line_Break=jt}', "");
Expect(1, 4519, '\p{^Is_Line_Break=jt}', "");
Expect(1, 4519, '\P{Is_Line_Break=jt}', "");
Expect(0, 4519, '\P{^Is_Line_Break=jt}', "");
Expect(1, 4607, '\p{Is_Line_Break=_JT}', "");
Expect(0, 4607, '\p{^Is_Line_Break=_JT}', "");
Expect(0, 4607, '\P{Is_Line_Break=_JT}', "");
Expect(1, 4607, '\P{^Is_Line_Break=_JT}', "");
Expect(0, 4519, '\p{Is_Line_Break=_JT}', "");
Expect(1, 4519, '\p{^Is_Line_Break=_JT}', "");
Expect(1, 4519, '\P{Is_Line_Break=_JT}', "");
Expect(0, 4519, '\P{^Is_Line_Break=_JT}', "");
Error('\p{Is_Lb=	:=JT}');
Error('\P{Is_Lb=	:=JT}');
Expect(1, 4607, '\p{Is_Lb=jt}', "");
Expect(0, 4607, '\p{^Is_Lb=jt}', "");
Expect(0, 4607, '\P{Is_Lb=jt}', "");
Expect(1, 4607, '\P{^Is_Lb=jt}', "");
Expect(0, 4519, '\p{Is_Lb=jt}', "");
Expect(1, 4519, '\p{^Is_Lb=jt}', "");
Expect(1, 4519, '\P{Is_Lb=jt}', "");
Expect(0, 4519, '\P{^Is_Lb=jt}', "");
Expect(1, 4607, '\p{Is_Lb=-	JT}', "");
Expect(0, 4607, '\p{^Is_Lb=-	JT}', "");
Expect(0, 4607, '\P{Is_Lb=-	JT}', "");
Expect(1, 4607, '\P{^Is_Lb=-	JT}', "");
Expect(0, 4519, '\p{Is_Lb=-	JT}', "");
Expect(1, 4519, '\p{^Is_Lb=-	JT}', "");
Expect(1, 4519, '\P{Is_Lb=-	JT}', "");
Expect(0, 4519, '\P{^Is_Lb=-	JT}', "");
Error('\p{Block=-:=new_Tai-Lue}');
Error('\P{Block=-:=new_Tai-Lue}');
Expect(1, 6623, '\p{Block=newtailue}', "");
Expect(0, 6623, '\p{^Block=newtailue}', "");
Expect(0, 6623, '\P{Block=newtailue}', "");
Expect(1, 6623, '\P{^Block=newtailue}', "");
Expect(0, 6527, '\p{Block=newtailue}', "");
Expect(1, 6527, '\p{^Block=newtailue}', "");
Expect(1, 6527, '\P{Block=newtailue}', "");
Expect(0, 6527, '\P{^Block=newtailue}', "");
Expect(1, 6623, '\p{Block=_ New-TAI_Lue}', "");
Expect(0, 6623, '\p{^Block=_ New-TAI_Lue}', "");
Expect(0, 6623, '\P{Block=_ New-TAI_Lue}', "");
Expect(1, 6623, '\P{^Block=_ New-TAI_Lue}', "");
Expect(0, 6527, '\p{Block=_ New-TAI_Lue}', "");
Expect(1, 6527, '\p{^Block=_ New-TAI_Lue}', "");
Expect(1, 6527, '\P{Block=_ New-TAI_Lue}', "");
Expect(0, 6527, '\P{^Block=_ New-TAI_Lue}', "");
Error('\p{Blk:	-	New-tai:=LUE}');
Error('\P{Blk:	-	New-tai:=LUE}');
Expect(1, 6623, '\p{Blk=newtailue}', "");
Expect(0, 6623, '\p{^Blk=newtailue}', "");
Expect(0, 6623, '\P{Blk=newtailue}', "");
Expect(1, 6623, '\P{^Blk=newtailue}', "");
Expect(0, 6527, '\p{Blk=newtailue}', "");
Expect(1, 6527, '\p{^Blk=newtailue}', "");
Expect(1, 6527, '\P{Blk=newtailue}', "");
Expect(0, 6527, '\P{^Blk=newtailue}', "");
Expect(1, 6623, '\p{Blk=	NEW	TAILue}', "");
Expect(0, 6623, '\p{^Blk=	NEW	TAILue}', "");
Expect(0, 6623, '\P{Blk=	NEW	TAILue}', "");
Expect(1, 6623, '\P{^Blk=	NEW	TAILue}', "");
Expect(0, 6527, '\p{Blk=	NEW	TAILue}', "");
Expect(1, 6527, '\p{^Blk=	NEW	TAILue}', "");
Expect(1, 6527, '\P{Blk=	NEW	TAILue}', "");
Expect(0, 6527, '\P{^Blk=	NEW	TAILue}', "");
Error('\p{Is_Block=/a/	_New TAI_Lue}');
Error('\P{Is_Block=/a/	_New TAI_Lue}');
Expect(1, 6623, '\p{Is_Block=newtailue}', "");
Expect(0, 6623, '\p{^Is_Block=newtailue}', "");
Expect(0, 6623, '\P{Is_Block=newtailue}', "");
Expect(1, 6623, '\P{^Is_Block=newtailue}', "");
Expect(0, 6527, '\p{Is_Block=newtailue}', "");
Expect(1, 6527, '\p{^Is_Block=newtailue}', "");
Expect(1, 6527, '\P{Is_Block=newtailue}', "");
Expect(0, 6527, '\P{^Is_Block=newtailue}', "");
Expect(1, 6623, '\p{Is_Block=__New	tailue}', "");
Expect(0, 6623, '\p{^Is_Block=__New	tailue}', "");
Expect(0, 6623, '\P{Is_Block=__New	tailue}', "");
Expect(1, 6623, '\P{^Is_Block=__New	tailue}', "");
Expect(0, 6527, '\p{Is_Block=__New	tailue}', "");
Expect(1, 6527, '\p{^Is_Block=__New	tailue}', "");
Expect(1, 6527, '\P{Is_Block=__New	tailue}', "");
Expect(0, 6527, '\P{^Is_Block=__New	tailue}', "");
Error('\p{Is_Blk=_ New	Tai/a/Lue}');
Error('\P{Is_Blk=_ New	Tai/a/Lue}');
Expect(1, 6623, '\p{Is_Blk: newtailue}', "");
Expect(0, 6623, '\p{^Is_Blk: newtailue}', "");
Expect(0, 6623, '\P{Is_Blk: newtailue}', "");
Expect(1, 6623, '\P{^Is_Blk: newtailue}', "");
Expect(0, 6527, '\p{Is_Blk: newtailue}', "");
Expect(1, 6527, '\p{^Is_Blk: newtailue}', "");
Expect(1, 6527, '\P{Is_Blk: newtailue}', "");
Expect(0, 6527, '\P{^Is_Blk: newtailue}', "");
Expect(1, 6623, '\p{Is_Blk=- New	Tai lue}', "");
Expect(0, 6623, '\p{^Is_Blk=- New	Tai lue}', "");
Expect(0, 6623, '\P{Is_Blk=- New	Tai lue}', "");
Expect(1, 6623, '\P{^Is_Blk=- New	Tai lue}', "");
Expect(0, 6527, '\p{Is_Blk=- New	Tai lue}', "");
Expect(1, 6527, '\p{^Is_Blk=- New	Tai lue}', "");
Expect(1, 6527, '\P{Is_Blk=- New	Tai lue}', "");
Expect(0, 6527, '\P{^Is_Blk=- New	Tai lue}', "");
Error('\p{Block= :=CJK UNIFIED	Ideographs	Extensiona}');
Error('\P{Block= :=CJK UNIFIED	Ideographs	Extensiona}');
Expect(1, 19903, '\p{Block=cjkunifiedideographsextensiona}', "");
Expect(0, 19903, '\p{^Block=cjkunifiedideographsextensiona}', "");
Expect(0, 19903, '\P{Block=cjkunifiedideographsextensiona}', "");
Expect(1, 19903, '\P{^Block=cjkunifiedideographsextensiona}', "");
Expect(0, 13311, '\p{Block=cjkunifiedideographsextensiona}', "");
Expect(1, 13311, '\p{^Block=cjkunifiedideographsextensiona}', "");
Expect(1, 13311, '\P{Block=cjkunifiedideographsextensiona}', "");
Expect(0, 13311, '\P{^Block=cjkunifiedideographsextensiona}', "");
Expect(1, 19903, '\p{Block:   _	CJK	UNIFIED-IDEOGRAPHS-ExtensionA}', "");
Expect(0, 19903, '\p{^Block:   _	CJK	UNIFIED-IDEOGRAPHS-ExtensionA}', "");
Expect(0, 19903, '\P{Block:   _	CJK	UNIFIED-IDEOGRAPHS-ExtensionA}', "");
Expect(1, 19903, '\P{^Block:   _	CJK	UNIFIED-IDEOGRAPHS-ExtensionA}', "");
Expect(0, 13311, '\p{Block:   _	CJK	UNIFIED-IDEOGRAPHS-ExtensionA}', "");
Expect(1, 13311, '\p{^Block:   _	CJK	UNIFIED-IDEOGRAPHS-ExtensionA}', "");
Expect(1, 13311, '\P{Block:   _	CJK	UNIFIED-IDEOGRAPHS-ExtensionA}', "");
Expect(0, 13311, '\P{^Block:   _	CJK	UNIFIED-IDEOGRAPHS-ExtensionA}', "");
Error('\p{Blk=	/a/CJK_Unified_Ideographsextension A}');
Error('\P{Blk=	/a/CJK_Unified_Ideographsextension A}');
Expect(1, 19903, '\p{Blk=cjkunifiedideographsextensiona}', "");
Expect(0, 19903, '\p{^Blk=cjkunifiedideographsextensiona}', "");
Expect(0, 19903, '\P{Blk=cjkunifiedideographsextensiona}', "");
Expect(1, 19903, '\P{^Blk=cjkunifiedideographsextensiona}', "");
Expect(0, 13311, '\p{Blk=cjkunifiedideographsextensiona}', "");
Expect(1, 13311, '\p{^Blk=cjkunifiedideographsextensiona}', "");
Expect(1, 13311, '\P{Blk=cjkunifiedideographsextensiona}', "");
Expect(0, 13311, '\P{^Blk=cjkunifiedideographsextensiona}', "");
Expect(1, 19903, '\p{Blk= cjk	Unified-IDEOGRAPHS-EXTENSION-A}', "");
Expect(0, 19903, '\p{^Blk= cjk	Unified-IDEOGRAPHS-EXTENSION-A}', "");
Expect(0, 19903, '\P{Blk= cjk	Unified-IDEOGRAPHS-EXTENSION-A}', "");
Expect(1, 19903, '\P{^Blk= cjk	Unified-IDEOGRAPHS-EXTENSION-A}', "");
Expect(0, 13311, '\p{Blk= cjk	Unified-IDEOGRAPHS-EXTENSION-A}', "");
Expect(1, 13311, '\p{^Blk= cjk	Unified-IDEOGRAPHS-EXTENSION-A}', "");
Expect(1, 13311, '\P{Blk= cjk	Unified-IDEOGRAPHS-EXTENSION-A}', "");
Expect(0, 13311, '\P{^Blk= cjk	Unified-IDEOGRAPHS-EXTENSION-A}', "");
Error('\p{Is_Block=CJK-Unified/a/Ideographs_ExtensionA}');
Error('\P{Is_Block=CJK-Unified/a/Ideographs_ExtensionA}');
Expect(1, 19903, '\p{Is_Block=cjkunifiedideographsextensiona}', "");
Expect(0, 19903, '\p{^Is_Block=cjkunifiedideographsextensiona}', "");
Expect(0, 19903, '\P{Is_Block=cjkunifiedideographsextensiona}', "");
Expect(1, 19903, '\P{^Is_Block=cjkunifiedideographsextensiona}', "");
Expect(0, 13311, '\p{Is_Block=cjkunifiedideographsextensiona}', "");
Expect(1, 13311, '\p{^Is_Block=cjkunifiedideographsextensiona}', "");
Expect(1, 13311, '\P{Is_Block=cjkunifiedideographsextensiona}', "");
Expect(0, 13311, '\P{^Is_Block=cjkunifiedideographsextensiona}', "");
Expect(1, 19903, '\p{Is_Block=	-CJK-UnifiedIDEOGRAPHSextension	A}', "");
Expect(0, 19903, '\p{^Is_Block=	-CJK-UnifiedIDEOGRAPHSextension	A}', "");
Expect(0, 19903, '\P{Is_Block=	-CJK-UnifiedIDEOGRAPHSextension	A}', "");
Expect(1, 19903, '\P{^Is_Block=	-CJK-UnifiedIDEOGRAPHSextension	A}', "");
Expect(0, 13311, '\p{Is_Block=	-CJK-UnifiedIDEOGRAPHSextension	A}', "");
Expect(1, 13311, '\p{^Is_Block=	-CJK-UnifiedIDEOGRAPHSextension	A}', "");
Expect(1, 13311, '\P{Is_Block=	-CJK-UnifiedIDEOGRAPHSextension	A}', "");
Expect(0, 13311, '\P{^Is_Block=	-CJK-UnifiedIDEOGRAPHSextension	A}', "");
Error('\p{Is_Blk: 	CJKunified:=ideographs	EXTENSION-A}');
Error('\P{Is_Blk: 	CJKunified:=ideographs	EXTENSION-A}');
Expect(1, 19903, '\p{Is_Blk=cjkunifiedideographsextensiona}', "");
Expect(0, 19903, '\p{^Is_Blk=cjkunifiedideographsextensiona}', "");
Expect(0, 19903, '\P{Is_Blk=cjkunifiedideographsextensiona}', "");
Expect(1, 19903, '\P{^Is_Blk=cjkunifiedideographsextensiona}', "");
Expect(0, 13311, '\p{Is_Blk=cjkunifiedideographsextensiona}', "");
Expect(1, 13311, '\p{^Is_Blk=cjkunifiedideographsextensiona}', "");
Expect(1, 13311, '\P{Is_Blk=cjkunifiedideographsextensiona}', "");
Expect(0, 13311, '\P{^Is_Blk=cjkunifiedideographsextensiona}', "");
Expect(1, 19903, '\p{Is_Blk=_-CJK	Unified-Ideographs EXTENSION-A}', "");
Expect(0, 19903, '\p{^Is_Blk=_-CJK	Unified-Ideographs EXTENSION-A}', "");
Expect(0, 19903, '\P{Is_Blk=_-CJK	Unified-Ideographs EXTENSION-A}', "");
Expect(1, 19903, '\P{^Is_Blk=_-CJK	Unified-Ideographs EXTENSION-A}', "");
Expect(0, 13311, '\p{Is_Blk=_-CJK	Unified-Ideographs EXTENSION-A}', "");
Expect(1, 13311, '\p{^Is_Blk=_-CJK	Unified-Ideographs EXTENSION-A}', "");
Expect(1, 13311, '\P{Is_Blk=_-CJK	Unified-Ideographs EXTENSION-A}', "");
Expect(0, 13311, '\P{^Is_Blk=_-CJK	Unified-Ideographs EXTENSION-A}', "");
Error('\p{Block=-HANGULJAMO/a/}');
Error('\P{Block=-HANGULJAMO/a/}');
Expect(1, 4607, '\p{Block=hanguljamo}', "");
Expect(0, 4607, '\p{^Block=hanguljamo}', "");
Expect(0, 4607, '\P{Block=hanguljamo}', "");
Expect(1, 4607, '\P{^Block=hanguljamo}', "");
Expect(0, 4351, '\p{Block=hanguljamo}', "");
Expect(1, 4351, '\p{^Block=hanguljamo}', "");
Expect(1, 4351, '\P{Block=hanguljamo}', "");
Expect(0, 4351, '\P{^Block=hanguljamo}', "");
Expect(1, 4607, '\p{Block= -Hangul-jamo}', "");
Expect(0, 4607, '\p{^Block= -Hangul-jamo}', "");
Expect(0, 4607, '\P{Block= -Hangul-jamo}', "");
Expect(1, 4607, '\P{^Block= -Hangul-jamo}', "");
Expect(0, 4351, '\p{Block= -Hangul-jamo}', "");
Expect(1, 4351, '\p{^Block= -Hangul-jamo}', "");
Expect(1, 4351, '\P{Block= -Hangul-jamo}', "");
Expect(0, 4351, '\P{^Block= -Hangul-jamo}', "");
Error('\p{Blk=Hanguljamo:=}');
Error('\P{Blk=Hanguljamo:=}');
Expect(1, 4607, '\p{Blk=hanguljamo}', "");
Expect(0, 4607, '\p{^Blk=hanguljamo}', "");
Expect(0, 4607, '\P{Blk=hanguljamo}', "");
Expect(1, 4607, '\P{^Blk=hanguljamo}', "");
Expect(0, 4351, '\p{Blk=hanguljamo}', "");
Expect(1, 4351, '\p{^Blk=hanguljamo}', "");
Expect(1, 4351, '\P{Blk=hanguljamo}', "");
Expect(0, 4351, '\P{^Blk=hanguljamo}', "");
Expect(1, 4607, '\p{Blk:	-HangulJamo}', "");
Expect(0, 4607, '\p{^Blk:	-HangulJamo}', "");
Expect(0, 4607, '\P{Blk:	-HangulJamo}', "");
Expect(1, 4607, '\P{^Blk:	-HangulJamo}', "");
Expect(0, 4351, '\p{Blk:	-HangulJamo}', "");
Expect(1, 4351, '\p{^Blk:	-HangulJamo}', "");
Expect(1, 4351, '\P{Blk:	-HangulJamo}', "");
Expect(0, 4351, '\P{^Blk:	-HangulJamo}', "");
Error('\p{Is_Block=_hanguljamo:=}');
Error('\P{Is_Block=_hanguljamo:=}');
Expect(1, 4607, '\p{Is_Block=hanguljamo}', "");
Expect(0, 4607, '\p{^Is_Block=hanguljamo}', "");
Expect(0, 4607, '\P{Is_Block=hanguljamo}', "");
Expect(1, 4607, '\P{^Is_Block=hanguljamo}', "");
Expect(0, 4351, '\p{Is_Block=hanguljamo}', "");
Expect(1, 4351, '\p{^Is_Block=hanguljamo}', "");
Expect(1, 4351, '\P{Is_Block=hanguljamo}', "");
Expect(0, 4351, '\P{^Is_Block=hanguljamo}', "");
Expect(1, 4607, '\p{Is_Block=	 HANGUL	Jamo}', "");
Expect(0, 4607, '\p{^Is_Block=	 HANGUL	Jamo}', "");
Expect(0, 4607, '\P{Is_Block=	 HANGUL	Jamo}', "");
Expect(1, 4607, '\P{^Is_Block=	 HANGUL	Jamo}', "");
Expect(0, 4351, '\p{Is_Block=	 HANGUL	Jamo}', "");
Expect(1, 4351, '\p{^Is_Block=	 HANGUL	Jamo}', "");
Expect(1, 4351, '\P{Is_Block=	 HANGUL	Jamo}', "");
Expect(0, 4351, '\P{^Is_Block=	 HANGUL	Jamo}', "");
Error('\p{Is_Blk:	 /a/HANGUL-Jamo}');
Error('\P{Is_Blk:	 /a/HANGUL-Jamo}');
Expect(1, 4607, '\p{Is_Blk=hanguljamo}', "");
Expect(0, 4607, '\p{^Is_Blk=hanguljamo}', "");
Expect(0, 4607, '\P{Is_Blk=hanguljamo}', "");
Expect(1, 4607, '\P{^Is_Blk=hanguljamo}', "");
Expect(0, 4351, '\p{Is_Blk=hanguljamo}', "");
Expect(1, 4351, '\p{^Is_Blk=hanguljamo}', "");
Expect(1, 4351, '\P{Is_Blk=hanguljamo}', "");
Expect(0, 4351, '\P{^Is_Blk=hanguljamo}', "");
Expect(1, 4607, '\p{Is_Blk= HANGUL_Jamo}', "");
Expect(0, 4607, '\p{^Is_Blk= HANGUL_Jamo}', "");
Expect(0, 4607, '\P{Is_Blk= HANGUL_Jamo}', "");
Expect(1, 4607, '\P{^Is_Blk= HANGUL_Jamo}', "");
Expect(0, 4351, '\p{Is_Blk= HANGUL_Jamo}', "");
Expect(1, 4351, '\p{^Is_Blk= HANGUL_Jamo}', "");
Expect(1, 4351, '\P{Is_Blk= HANGUL_Jamo}', "");
Expect(0, 4351, '\P{^Is_Blk= HANGUL_Jamo}', "");
Error('\p{Block:		Dingbats/a/}');
Error('\P{Block:		Dingbats/a/}');
Expect(1, 10175, '\p{Block=dingbats}', "");
Expect(0, 10175, '\p{^Block=dingbats}', "");
Expect(0, 10175, '\P{Block=dingbats}', "");
Expect(1, 10175, '\P{^Block=dingbats}', "");
Expect(0, 9983, '\p{Block=dingbats}', "");
Expect(1, 9983, '\p{^Block=dingbats}', "");
Expect(1, 9983, '\P{Block=dingbats}', "");
Expect(0, 9983, '\P{^Block=dingbats}', "");
Expect(1, 10175, '\p{Block=- DINGBATS}', "");
Expect(0, 10175, '\p{^Block=- DINGBATS}', "");
Expect(0, 10175, '\P{Block=- DINGBATS}', "");
Expect(1, 10175, '\P{^Block=- DINGBATS}', "");
Expect(0, 9983, '\p{Block=- DINGBATS}', "");
Expect(1, 9983, '\p{^Block=- DINGBATS}', "");
Expect(1, 9983, '\P{Block=- DINGBATS}', "");
Expect(0, 9983, '\P{^Block=- DINGBATS}', "");
Error('\p{Blk= -Dingbats:=}');
Error('\P{Blk= -Dingbats:=}');
Expect(1, 10175, '\p{Blk=dingbats}', "");
Expect(0, 10175, '\p{^Blk=dingbats}', "");
Expect(0, 10175, '\P{Blk=dingbats}', "");
Expect(1, 10175, '\P{^Blk=dingbats}', "");
Expect(0, 9983, '\p{Blk=dingbats}', "");
Expect(1, 9983, '\p{^Blk=dingbats}', "");
Expect(1, 9983, '\P{Blk=dingbats}', "");
Expect(0, 9983, '\P{^Blk=dingbats}', "");
Expect(1, 10175, '\p{Blk= 	dingbats}', "");
Expect(0, 10175, '\p{^Blk= 	dingbats}', "");
Expect(0, 10175, '\P{Blk= 	dingbats}', "");
Expect(1, 10175, '\P{^Blk= 	dingbats}', "");
Expect(0, 9983, '\p{Blk= 	dingbats}', "");
Expect(1, 9983, '\p{^Blk= 	dingbats}', "");
Expect(1, 9983, '\P{Blk= 	dingbats}', "");
Expect(0, 9983, '\P{^Blk= 	dingbats}', "");
Error('\p{Is_Block=:=_dingbats}');
Error('\P{Is_Block=:=_dingbats}');
Expect(1, 10175, '\p{Is_Block=dingbats}', "");
Expect(0, 10175, '\p{^Is_Block=dingbats}', "");
Expect(0, 10175, '\P{Is_Block=dingbats}', "");
Expect(1, 10175, '\P{^Is_Block=dingbats}', "");
Expect(0, 9983, '\p{Is_Block=dingbats}', "");
Expect(1, 9983, '\p{^Is_Block=dingbats}', "");
Expect(1, 9983, '\P{Is_Block=dingbats}', "");
Expect(0, 9983, '\P{^Is_Block=dingbats}', "");
Expect(1, 10175, '\p{Is_Block=Dingbats}', "");
Expect(0, 10175, '\p{^Is_Block=Dingbats}', "");
Expect(0, 10175, '\P{Is_Block=Dingbats}', "");
Expect(1, 10175, '\P{^Is_Block=Dingbats}', "");
Expect(0, 9983, '\p{Is_Block=Dingbats}', "");
Expect(1, 9983, '\p{^Is_Block=Dingbats}', "");
Expect(1, 9983, '\P{Is_Block=Dingbats}', "");
Expect(0, 9983, '\P{^Is_Block=Dingbats}', "");
Error('\p{Is_Blk=/a/dingbats}');
Error('\P{Is_Blk=/a/dingbats}');
Expect(1, 10175, '\p{Is_Blk:dingbats}', "");
Expect(0, 10175, '\p{^Is_Blk:dingbats}', "");
Expect(0, 10175, '\P{Is_Blk:dingbats}', "");
Expect(1, 10175, '\P{^Is_Blk:dingbats}', "");
Expect(0, 9983, '\p{Is_Blk:dingbats}', "");
Expect(1, 9983, '\p{^Is_Blk:dingbats}', "");
Expect(1, 9983, '\P{Is_Blk:dingbats}', "");
Expect(0, 9983, '\P{^Is_Blk:dingbats}', "");
Expect(1, 10175, '\p{Is_Blk=-	Dingbats}', "");
Expect(0, 10175, '\p{^Is_Blk=-	Dingbats}', "");
Expect(0, 10175, '\P{Is_Blk=-	Dingbats}', "");
Expect(1, 10175, '\P{^Is_Blk=-	Dingbats}', "");
Expect(0, 9983, '\p{Is_Blk=-	Dingbats}', "");
Expect(1, 9983, '\p{^Is_Blk=-	Dingbats}', "");
Expect(1, 9983, '\P{Is_Blk=-	Dingbats}', "");
Expect(0, 9983, '\P{^Is_Blk=-	Dingbats}', "");
Error('\p{Block=:=	 Bamum}');
Error('\P{Block=:=	 Bamum}');
Expect(1, 42751, '\p{Block=bamum}', "");
Expect(0, 42751, '\p{^Block=bamum}', "");
Expect(0, 42751, '\P{Block=bamum}', "");
Expect(1, 42751, '\P{^Block=bamum}', "");
Expect(0, 42655, '\p{Block=bamum}', "");
Expect(1, 42655, '\p{^Block=bamum}', "");
Expect(1, 42655, '\P{Block=bamum}', "");
Expect(0, 42655, '\P{^Block=bamum}', "");
Expect(1, 42751, '\p{Block=	 bamum}', "");
Expect(0, 42751, '\p{^Block=	 bamum}', "");
Expect(0, 42751, '\P{Block=	 bamum}', "");
Expect(1, 42751, '\P{^Block=	 bamum}', "");
Expect(0, 42655, '\p{Block=	 bamum}', "");
Expect(1, 42655, '\p{^Block=	 bamum}', "");
Expect(1, 42655, '\P{Block=	 bamum}', "");
Expect(0, 42655, '\P{^Block=	 bamum}', "");
Error('\p{Blk= /a/bamum}');
Error('\P{Blk= /a/bamum}');
Expect(1, 42751, '\p{Blk=bamum}', "");
Expect(0, 42751, '\p{^Blk=bamum}', "");
Expect(0, 42751, '\P{Blk=bamum}', "");
Expect(1, 42751, '\P{^Blk=bamum}', "");
Expect(0, 42655, '\p{Blk=bamum}', "");
Expect(1, 42655, '\p{^Blk=bamum}', "");
Expect(1, 42655, '\P{Blk=bamum}', "");
Expect(0, 42655, '\P{^Blk=bamum}', "");
Expect(1, 42751, '\p{Blk= 	BAMUM}', "");
Expect(0, 42751, '\p{^Blk= 	BAMUM}', "");
Expect(0, 42751, '\P{Blk= 	BAMUM}', "");
Expect(1, 42751, '\P{^Blk= 	BAMUM}', "");
Expect(0, 42655, '\p{Blk= 	BAMUM}', "");
Expect(1, 42655, '\p{^Blk= 	BAMUM}', "");
Expect(1, 42655, '\P{Blk= 	BAMUM}', "");
Expect(0, 42655, '\P{^Blk= 	BAMUM}', "");
Error('\p{Is_Block=:=-_bamum}');
Error('\P{Is_Block=:=-_bamum}');
Expect(1, 42751, '\p{Is_Block=bamum}', "");
Expect(0, 42751, '\p{^Is_Block=bamum}', "");
Expect(0, 42751, '\P{Is_Block=bamum}', "");
Expect(1, 42751, '\P{^Is_Block=bamum}', "");
Expect(0, 42655, '\p{Is_Block=bamum}', "");
Expect(1, 42655, '\p{^Is_Block=bamum}', "");
Expect(1, 42655, '\P{Is_Block=bamum}', "");
Expect(0, 42655, '\P{^Is_Block=bamum}', "");
Expect(1, 42751, '\p{Is_Block=	-BAMUM}', "");
Expect(0, 42751, '\p{^Is_Block=	-BAMUM}', "");
Expect(0, 42751, '\P{Is_Block=	-BAMUM}', "");
Expect(1, 42751, '\P{^Is_Block=	-BAMUM}', "");
Expect(0, 42655, '\p{Is_Block=	-BAMUM}', "");
Expect(1, 42655, '\p{^Is_Block=	-BAMUM}', "");
Expect(1, 42655, '\P{Is_Block=	-BAMUM}', "");
Expect(0, 42655, '\P{^Is_Block=	-BAMUM}', "");
Error('\p{Is_Blk=:=_bamum}');
Error('\P{Is_Blk=:=_bamum}');
Expect(1, 42751, '\p{Is_Blk=bamum}', "");
Expect(0, 42751, '\p{^Is_Blk=bamum}', "");
Expect(0, 42751, '\P{Is_Blk=bamum}', "");
Expect(1, 42751, '\P{^Is_Blk=bamum}', "");
Expect(0, 42655, '\p{Is_Blk=bamum}', "");
Expect(1, 42655, '\p{^Is_Blk=bamum}', "");
Expect(1, 42655, '\P{Is_Blk=bamum}', "");
Expect(0, 42655, '\P{^Is_Blk=bamum}', "");
Expect(1, 42751, '\p{Is_Blk=--Bamum}', "");
Expect(0, 42751, '\p{^Is_Blk=--Bamum}', "");
Expect(0, 42751, '\P{Is_Blk=--Bamum}', "");
Expect(1, 42751, '\P{^Is_Blk=--Bamum}', "");
Expect(0, 42655, '\p{Is_Blk=--Bamum}', "");
Expect(1, 42655, '\p{^Is_Blk=--Bamum}', "");
Expect(1, 42655, '\P{Is_Blk=--Bamum}', "");
Expect(0, 42655, '\P{^Is_Blk=--Bamum}', "");
Error('\p{Block=/a/	_Inscriptional	Parthian}');
Error('\P{Block=/a/	_Inscriptional	Parthian}');
Expect(1, 68447, '\p{Block=inscriptionalparthian}', "");
Expect(0, 68447, '\p{^Block=inscriptionalparthian}', "");
Expect(0, 68447, '\P{Block=inscriptionalparthian}', "");
Expect(1, 68447, '\P{^Block=inscriptionalparthian}', "");
Expect(0, 68415, '\p{Block=inscriptionalparthian}', "");
Expect(1, 68415, '\p{^Block=inscriptionalparthian}', "");
Expect(1, 68415, '\P{Block=inscriptionalparthian}', "");
Expect(0, 68415, '\P{^Block=inscriptionalparthian}', "");
Expect(1, 68447, '\p{Block:   	_InscriptionalParthian}', "");
Expect(0, 68447, '\p{^Block:   	_InscriptionalParthian}', "");
Expect(0, 68447, '\P{Block:   	_InscriptionalParthian}', "");
Expect(1, 68447, '\P{^Block:   	_InscriptionalParthian}', "");
Expect(0, 68415, '\p{Block:   	_InscriptionalParthian}', "");
Expect(1, 68415, '\p{^Block:   	_InscriptionalParthian}', "");
Expect(1, 68415, '\P{Block:   	_InscriptionalParthian}', "");
Expect(0, 68415, '\P{^Block:   	_InscriptionalParthian}', "");
Error('\p{Blk=/a/	INSCRIPTIONALparthian}');
Error('\P{Blk=/a/	INSCRIPTIONALparthian}');
Expect(1, 68447, '\p{Blk=inscriptionalparthian}', "");
Expect(0, 68447, '\p{^Blk=inscriptionalparthian}', "");
Expect(0, 68447, '\P{Blk=inscriptionalparthian}', "");
Expect(1, 68447, '\P{^Blk=inscriptionalparthian}', "");
Expect(0, 68415, '\p{Blk=inscriptionalparthian}', "");
Expect(1, 68415, '\p{^Blk=inscriptionalparthian}', "");
Expect(1, 68415, '\P{Blk=inscriptionalparthian}', "");
Expect(0, 68415, '\P{^Blk=inscriptionalparthian}', "");
Expect(1, 68447, '\p{Blk=  INSCRIPTIONAL	Parthian}', "");
Expect(0, 68447, '\p{^Blk=  INSCRIPTIONAL	Parthian}', "");
Expect(0, 68447, '\P{Blk=  INSCRIPTIONAL	Parthian}', "");
Expect(1, 68447, '\P{^Blk=  INSCRIPTIONAL	Parthian}', "");
Expect(0, 68415, '\p{Blk=  INSCRIPTIONAL	Parthian}', "");
Expect(1, 68415, '\p{^Blk=  INSCRIPTIONAL	Parthian}', "");
Expect(1, 68415, '\P{Blk=  INSCRIPTIONAL	Parthian}', "");
Expect(0, 68415, '\P{^Blk=  INSCRIPTIONAL	Parthian}', "");
Error('\p{Is_Block=	 INSCRIPTIONAL	PARTHIAN:=}');
Error('\P{Is_Block=	 INSCRIPTIONAL	PARTHIAN:=}');
Expect(1, 68447, '\p{Is_Block=inscriptionalparthian}', "");
Expect(0, 68447, '\p{^Is_Block=inscriptionalparthian}', "");
Expect(0, 68447, '\P{Is_Block=inscriptionalparthian}', "");
Expect(1, 68447, '\P{^Is_Block=inscriptionalparthian}', "");
Expect(0, 68415, '\p{Is_Block=inscriptionalparthian}', "");
Expect(1, 68415, '\p{^Is_Block=inscriptionalparthian}', "");
Expect(1, 68415, '\P{Is_Block=inscriptionalparthian}', "");
Expect(0, 68415, '\P{^Is_Block=inscriptionalparthian}', "");
Expect(1, 68447, '\p{Is_Block=-	Inscriptional PARTHIAN}', "");
Expect(0, 68447, '\p{^Is_Block=-	Inscriptional PARTHIAN}', "");
Expect(0, 68447, '\P{Is_Block=-	Inscriptional PARTHIAN}', "");
Expect(1, 68447, '\P{^Is_Block=-	Inscriptional PARTHIAN}', "");
Expect(0, 68415, '\p{Is_Block=-	Inscriptional PARTHIAN}', "");
Expect(1, 68415, '\p{^Is_Block=-	Inscriptional PARTHIAN}', "");
Expect(1, 68415, '\P{Is_Block=-	Inscriptional PARTHIAN}', "");
Expect(0, 68415, '\P{^Is_Block=-	Inscriptional PARTHIAN}', "");
Error('\p{Is_Blk= :=inscriptional parthian}');
Error('\P{Is_Blk= :=inscriptional parthian}');
Expect(1, 68447, '\p{Is_Blk=inscriptionalparthian}', "");
Expect(0, 68447, '\p{^Is_Blk=inscriptionalparthian}', "");
Expect(0, 68447, '\P{Is_Blk=inscriptionalparthian}', "");
Expect(1, 68447, '\P{^Is_Blk=inscriptionalparthian}', "");
Expect(0, 68415, '\p{Is_Blk=inscriptionalparthian}', "");
Expect(1, 68415, '\p{^Is_Blk=inscriptionalparthian}', "");
Expect(1, 68415, '\P{Is_Blk=inscriptionalparthian}', "");
Expect(0, 68415, '\P{^Is_Blk=inscriptionalparthian}', "");
Expect(1, 68447, '\p{Is_Blk= 	INSCRIPTIONAL-Parthian}', "");
Expect(0, 68447, '\p{^Is_Blk= 	INSCRIPTIONAL-Parthian}', "");
Expect(0, 68447, '\P{Is_Blk= 	INSCRIPTIONAL-Parthian}', "");
Expect(1, 68447, '\P{^Is_Blk= 	INSCRIPTIONAL-Parthian}', "");
Expect(0, 68415, '\p{Is_Blk= 	INSCRIPTIONAL-Parthian}', "");
Expect(1, 68415, '\p{^Is_Blk= 	INSCRIPTIONAL-Parthian}', "");
Expect(1, 68415, '\P{Is_Blk= 	INSCRIPTIONAL-Parthian}', "");
Expect(0, 68415, '\P{^Is_Blk= 	INSCRIPTIONAL-Parthian}', "");
Error('\p{Block=-:=UNIFIEDCanadian-Aboriginal-SYLLABICS}');
Error('\P{Block=-:=UNIFIEDCanadian-Aboriginal-SYLLABICS}');
Expect(1, 5759, '\p{Block=unifiedcanadianaboriginalsyllabics}', "");
Expect(0, 5759, '\p{^Block=unifiedcanadianaboriginalsyllabics}', "");
Expect(0, 5759, '\P{Block=unifiedcanadianaboriginalsyllabics}', "");
Expect(1, 5759, '\P{^Block=unifiedcanadianaboriginalsyllabics}', "");
Expect(0, 5119, '\p{Block=unifiedcanadianaboriginalsyllabics}', "");
Expect(1, 5119, '\p{^Block=unifiedcanadianaboriginalsyllabics}', "");
Expect(1, 5119, '\P{Block=unifiedcanadianaboriginalsyllabics}', "");
Expect(0, 5119, '\P{^Block=unifiedcanadianaboriginalsyllabics}', "");
Expect(1, 5759, '\p{Block=-UnifiedCANADIAN	Aboriginal Syllabics}', "");
Expect(0, 5759, '\p{^Block=-UnifiedCANADIAN	Aboriginal Syllabics}', "");
Expect(0, 5759, '\P{Block=-UnifiedCANADIAN	Aboriginal Syllabics}', "");
Expect(1, 5759, '\P{^Block=-UnifiedCANADIAN	Aboriginal Syllabics}', "");
Expect(0, 5119, '\p{Block=-UnifiedCANADIAN	Aboriginal Syllabics}', "");
Expect(1, 5119, '\p{^Block=-UnifiedCANADIAN	Aboriginal Syllabics}', "");
Expect(1, 5119, '\P{Block=-UnifiedCANADIAN	Aboriginal Syllabics}', "");
Expect(0, 5119, '\P{^Block=-UnifiedCANADIAN	Aboriginal Syllabics}', "");
Error('\p{Blk=-Canadian/a/SYLLABICS}');
Error('\P{Blk=-Canadian/a/SYLLABICS}');
Expect(1, 5759, '\p{Blk=canadiansyllabics}', "");
Expect(0, 5759, '\p{^Blk=canadiansyllabics}', "");
Expect(0, 5759, '\P{Blk=canadiansyllabics}', "");
Expect(1, 5759, '\P{^Blk=canadiansyllabics}', "");
Expect(0, 5119, '\p{Blk=canadiansyllabics}', "");
Expect(1, 5119, '\p{^Blk=canadiansyllabics}', "");
Expect(1, 5119, '\P{Blk=canadiansyllabics}', "");
Expect(0, 5119, '\P{^Blk=canadiansyllabics}', "");
Expect(1, 5759, '\p{Blk= canadian	Syllabics}', "");
Expect(0, 5759, '\p{^Blk= canadian	Syllabics}', "");
Expect(0, 5759, '\P{Blk= canadian	Syllabics}', "");
Expect(1, 5759, '\P{^Blk= canadian	Syllabics}', "");
Expect(0, 5119, '\p{Blk= canadian	Syllabics}', "");
Expect(1, 5119, '\p{^Blk= canadian	Syllabics}', "");
Expect(1, 5119, '\P{Blk= canadian	Syllabics}', "");
Expect(0, 5119, '\P{^Blk= canadian	Syllabics}', "");
Error('\p{Is_Block=__Unified-CANADIAN:=Aboriginal	SYLLABICS}');
Error('\P{Is_Block=__Unified-CANADIAN:=Aboriginal	SYLLABICS}');
Expect(1, 5759, '\p{Is_Block=unifiedcanadianaboriginalsyllabics}', "");
Expect(0, 5759, '\p{^Is_Block=unifiedcanadianaboriginalsyllabics}', "");
Expect(0, 5759, '\P{Is_Block=unifiedcanadianaboriginalsyllabics}', "");
Expect(1, 5759, '\P{^Is_Block=unifiedcanadianaboriginalsyllabics}', "");
Expect(0, 5119, '\p{Is_Block=unifiedcanadianaboriginalsyllabics}', "");
Expect(1, 5119, '\p{^Is_Block=unifiedcanadianaboriginalsyllabics}', "");
Expect(1, 5119, '\P{Is_Block=unifiedcanadianaboriginalsyllabics}', "");
Expect(0, 5119, '\P{^Is_Block=unifiedcanadianaboriginalsyllabics}', "");
Expect(1, 5759, '\p{Is_Block=_	UNIFIED CANADIAN ABORIGINAL-Syllabics}', "");
Expect(0, 5759, '\p{^Is_Block=_	UNIFIED CANADIAN ABORIGINAL-Syllabics}', "");
Expect(0, 5759, '\P{Is_Block=_	UNIFIED CANADIAN ABORIGINAL-Syllabics}', "");
Expect(1, 5759, '\P{^Is_Block=_	UNIFIED CANADIAN ABORIGINAL-Syllabics}', "");
Expect(0, 5119, '\p{Is_Block=_	UNIFIED CANADIAN ABORIGINAL-Syllabics}', "");
Expect(1, 5119, '\p{^Is_Block=_	UNIFIED CANADIAN ABORIGINAL-Syllabics}', "");
Expect(1, 5119, '\P{Is_Block=_	UNIFIED CANADIAN ABORIGINAL-Syllabics}', "");
Expect(0, 5119, '\P{^Is_Block=_	UNIFIED CANADIAN ABORIGINAL-Syllabics}', "");
Error('\p{Is_Blk=_:=CanadianSyllabics}');
Error('\P{Is_Blk=_:=CanadianSyllabics}');
Expect(1, 5759, '\p{Is_Blk=canadiansyllabics}', "");
Expect(0, 5759, '\p{^Is_Blk=canadiansyllabics}', "");
Expect(0, 5759, '\P{Is_Blk=canadiansyllabics}', "");
Expect(1, 5759, '\P{^Is_Blk=canadiansyllabics}', "");
Expect(0, 5119, '\p{Is_Blk=canadiansyllabics}', "");
Expect(1, 5119, '\p{^Is_Blk=canadiansyllabics}', "");
Expect(1, 5119, '\P{Is_Blk=canadiansyllabics}', "");
Expect(0, 5119, '\P{^Is_Blk=canadiansyllabics}', "");
Expect(1, 5759, '\p{Is_Blk=_	CANADIANSyllabics}', "");
Expect(0, 5759, '\p{^Is_Blk=_	CANADIANSyllabics}', "");
Expect(0, 5759, '\P{Is_Blk=_	CANADIANSyllabics}', "");
Expect(1, 5759, '\P{^Is_Blk=_	CANADIANSyllabics}', "");
Expect(0, 5119, '\p{Is_Blk=_	CANADIANSyllabics}', "");
Expect(1, 5119, '\p{^Is_Blk=_	CANADIANSyllabics}', "");
Expect(1, 5119, '\P{Is_Blk=_	CANADIANSyllabics}', "");
Expect(0, 5119, '\P{^Is_Blk=_	CANADIANSyllabics}', "");
Error('\p{Block=/a/ Variation Selectors}');
Error('\P{Block=/a/ Variation Selectors}');
Expect(1, 65039, '\p{Block=variationselectors}', "");
Expect(0, 65039, '\p{^Block=variationselectors}', "");
Expect(0, 65039, '\P{Block=variationselectors}', "");
Expect(1, 65039, '\P{^Block=variationselectors}', "");
Expect(0, 65023, '\p{Block=variationselectors}', "");
Expect(1, 65023, '\p{^Block=variationselectors}', "");
Expect(1, 65023, '\P{Block=variationselectors}', "");
Expect(0, 65023, '\P{^Block=variationselectors}', "");
Expect(1, 65039, '\p{Block=	-VariationSelectors}', "");
Expect(0, 65039, '\p{^Block=	-VariationSelectors}', "");
Expect(0, 65039, '\P{Block=	-VariationSelectors}', "");
Expect(1, 65039, '\P{^Block=	-VariationSelectors}', "");
Expect(0, 65023, '\p{Block=	-VariationSelectors}', "");
Expect(1, 65023, '\p{^Block=	-VariationSelectors}', "");
Expect(1, 65023, '\P{Block=	-VariationSelectors}', "");
Expect(0, 65023, '\P{^Block=	-VariationSelectors}', "");
Error('\p{Blk: Variation	SELECTORS/a/}');
Error('\P{Blk: Variation	SELECTORS/a/}');
Expect(1, 65039, '\p{Blk=variationselectors}', "");
Expect(0, 65039, '\p{^Blk=variationselectors}', "");
Expect(0, 65039, '\P{Blk=variationselectors}', "");
Expect(1, 65039, '\P{^Blk=variationselectors}', "");
Expect(0, 65023, '\p{Blk=variationselectors}', "");
Expect(1, 65023, '\p{^Blk=variationselectors}', "");
Expect(1, 65023, '\P{Blk=variationselectors}', "");
Expect(0, 65023, '\P{^Blk=variationselectors}', "");
Expect(1, 65039, '\p{Blk=_variation_Selectors}', "");
Expect(0, 65039, '\p{^Blk=_variation_Selectors}', "");
Expect(0, 65039, '\P{Blk=_variation_Selectors}', "");
Expect(1, 65039, '\P{^Blk=_variation_Selectors}', "");
Expect(0, 65023, '\p{Blk=_variation_Selectors}', "");
Expect(1, 65023, '\p{^Blk=_variation_Selectors}', "");
Expect(1, 65023, '\P{Blk=_variation_Selectors}', "");
Expect(0, 65023, '\P{^Blk=_variation_Selectors}', "");
Error('\p{Is_Block=:= 	Variation SELECTORS}');
Error('\P{Is_Block=:= 	Variation SELECTORS}');
Expect(1, 65039, '\p{Is_Block=variationselectors}', "");
Expect(0, 65039, '\p{^Is_Block=variationselectors}', "");
Expect(0, 65039, '\P{Is_Block=variationselectors}', "");
Expect(1, 65039, '\P{^Is_Block=variationselectors}', "");
Expect(0, 65023, '\p{Is_Block=variationselectors}', "");
Expect(1, 65023, '\p{^Is_Block=variationselectors}', "");
Expect(1, 65023, '\P{Is_Block=variationselectors}', "");
Expect(0, 65023, '\P{^Is_Block=variationselectors}', "");
Expect(1, 65039, '\p{Is_Block=  variation SELECTORS}', "");
Expect(0, 65039, '\p{^Is_Block=  variation SELECTORS}', "");
Expect(0, 65039, '\P{Is_Block=  variation SELECTORS}', "");
Expect(1, 65039, '\P{^Is_Block=  variation SELECTORS}', "");
Expect(0, 65023, '\p{Is_Block=  variation SELECTORS}', "");
Expect(1, 65023, '\p{^Is_Block=  variation SELECTORS}', "");
Expect(1, 65023, '\P{Is_Block=  variation SELECTORS}', "");
Expect(0, 65023, '\P{^Is_Block=  variation SELECTORS}', "");
Error('\p{Is_Blk=	:=VARIATION	SELECTORS}');
Error('\P{Is_Blk=	:=VARIATION	SELECTORS}');
Expect(1, 65039, '\p{Is_Blk=variationselectors}', "");
Expect(0, 65039, '\p{^Is_Blk=variationselectors}', "");
Expect(0, 65039, '\P{Is_Blk=variationselectors}', "");
Expect(1, 65039, '\P{^Is_Blk=variationselectors}', "");
Expect(0, 65023, '\p{Is_Blk=variationselectors}', "");
Expect(1, 65023, '\p{^Is_Blk=variationselectors}', "");
Expect(1, 65023, '\P{Is_Blk=variationselectors}', "");
Expect(0, 65023, '\P{^Is_Blk=variationselectors}', "");
Expect(1, 65039, '\p{Is_Blk=VARIATION_Selectors}', "");
Expect(0, 65039, '\p{^Is_Blk=VARIATION_Selectors}', "");
Expect(0, 65039, '\P{Is_Blk=VARIATION_Selectors}', "");
Expect(1, 65039, '\P{^Is_Blk=VARIATION_Selectors}', "");
Expect(0, 65023, '\p{Is_Blk=VARIATION_Selectors}', "");
Expect(1, 65023, '\p{^Is_Blk=VARIATION_Selectors}', "");
Expect(1, 65023, '\P{Is_Blk=VARIATION_Selectors}', "");
Expect(0, 65023, '\P{^Is_Blk=VARIATION_Selectors}', "");
Error('\p{Block= -Number:=Forms}');
Error('\P{Block= -Number:=Forms}');
Expect(1, 8591, '\p{Block:	numberforms}', "");
Expect(0, 8591, '\p{^Block:	numberforms}', "");
Expect(0, 8591, '\P{Block:	numberforms}', "");
Expect(1, 8591, '\P{^Block:	numberforms}', "");
Expect(0, 8527, '\p{Block:	numberforms}', "");
Expect(1, 8527, '\p{^Block:	numberforms}', "");
Expect(1, 8527, '\P{Block:	numberforms}', "");
Expect(0, 8527, '\P{^Block:	numberforms}', "");
Expect(1, 8591, '\p{Block=-NumberFORMS}', "");
Expect(0, 8591, '\p{^Block=-NumberFORMS}', "");
Expect(0, 8591, '\P{Block=-NumberFORMS}', "");
Expect(1, 8591, '\P{^Block=-NumberFORMS}', "");
Expect(0, 8527, '\p{Block=-NumberFORMS}', "");
Expect(1, 8527, '\p{^Block=-NumberFORMS}', "");
Expect(1, 8527, '\P{Block=-NumberFORMS}', "");
Expect(0, 8527, '\P{^Block=-NumberFORMS}', "");
Error('\p{Blk= Number:=Forms}');
Error('\P{Blk= Number:=Forms}');
Expect(1, 8591, '\p{Blk=numberforms}', "");
Expect(0, 8591, '\p{^Blk=numberforms}', "");
Expect(0, 8591, '\P{Blk=numberforms}', "");
Expect(1, 8591, '\P{^Blk=numberforms}', "");
Expect(0, 8527, '\p{Blk=numberforms}', "");
Expect(1, 8527, '\p{^Blk=numberforms}', "");
Expect(1, 8527, '\P{Blk=numberforms}', "");
Expect(0, 8527, '\P{^Blk=numberforms}', "");
Expect(1, 8591, '\p{Blk:_ numberforms}', "");
Expect(0, 8591, '\p{^Blk:_ numberforms}', "");
Expect(0, 8591, '\P{Blk:_ numberforms}', "");
Expect(1, 8591, '\P{^Blk:_ numberforms}', "");
Expect(0, 8527, '\p{Blk:_ numberforms}', "");
Expect(1, 8527, '\p{^Blk:_ numberforms}', "");
Expect(1, 8527, '\P{Blk:_ numberforms}', "");
Expect(0, 8527, '\P{^Blk:_ numberforms}', "");
Error('\p{Is_Block=/a/ _number-Forms}');
Error('\P{Is_Block=/a/ _number-Forms}');
Expect(1, 8591, '\p{Is_Block=numberforms}', "");
Expect(0, 8591, '\p{^Is_Block=numberforms}', "");
Expect(0, 8591, '\P{Is_Block=numberforms}', "");
Expect(1, 8591, '\P{^Is_Block=numberforms}', "");
Expect(0, 8527, '\p{Is_Block=numberforms}', "");
Expect(1, 8527, '\p{^Is_Block=numberforms}', "");
Expect(1, 8527, '\P{Is_Block=numberforms}', "");
Expect(0, 8527, '\P{^Is_Block=numberforms}', "");
Expect(1, 8591, '\p{Is_Block=_Number	Forms}', "");
Expect(0, 8591, '\p{^Is_Block=_Number	Forms}', "");
Expect(0, 8591, '\P{Is_Block=_Number	Forms}', "");
Expect(1, 8591, '\P{^Is_Block=_Number	Forms}', "");
Expect(0, 8527, '\p{Is_Block=_Number	Forms}', "");
Expect(1, 8527, '\p{^Is_Block=_Number	Forms}', "");
Expect(1, 8527, '\P{Is_Block=_Number	Forms}', "");
Expect(0, 8527, '\P{^Is_Block=_Number	Forms}', "");
Error('\p{Is_Blk= _Number:=Forms}');
Error('\P{Is_Blk= _Number:=Forms}');
Expect(1, 8591, '\p{Is_Blk=numberforms}', "");
Expect(0, 8591, '\p{^Is_Blk=numberforms}', "");
Expect(0, 8591, '\P{Is_Blk=numberforms}', "");
Expect(1, 8591, '\P{^Is_Blk=numberforms}', "");
Expect(0, 8527, '\p{Is_Blk=numberforms}', "");
Expect(1, 8527, '\p{^Is_Blk=numberforms}', "");
Expect(1, 8527, '\P{Is_Blk=numberforms}', "");
Expect(0, 8527, '\P{^Is_Blk=numberforms}', "");
Expect(1, 8591, '\p{Is_Blk=	 Number	Forms}', "");
Expect(0, 8591, '\p{^Is_Blk=	 Number	Forms}', "");
Expect(0, 8591, '\P{Is_Blk=	 Number	Forms}', "");
Expect(1, 8591, '\P{^Is_Blk=	 Number	Forms}', "");
Expect(0, 8527, '\p{Is_Blk=	 Number	Forms}', "");
Expect(1, 8527, '\p{^Is_Blk=	 Number	Forms}', "");
Expect(1, 8527, '\P{Is_Blk=	 Number	Forms}', "");
Expect(0, 8527, '\P{^Is_Blk=	 Number	Forms}', "");
Error('\p{Block=/a/_	CONTROL	pictures}');
Error('\P{Block=/a/_	CONTROL	pictures}');
Expect(1, 9279, '\p{Block:controlpictures}', "");
Expect(0, 9279, '\p{^Block:controlpictures}', "");
Expect(0, 9279, '\P{Block:controlpictures}', "");
Expect(1, 9279, '\P{^Block:controlpictures}', "");
Expect(0, 9215, '\p{Block:controlpictures}', "");
Expect(1, 9215, '\p{^Block:controlpictures}', "");
Expect(1, 9215, '\P{Block:controlpictures}', "");
Expect(0, 9215, '\P{^Block:controlpictures}', "");
Expect(1, 9279, '\p{Block: 	Control	pictures}', "");
Expect(0, 9279, '\p{^Block: 	Control	pictures}', "");
Expect(0, 9279, '\P{Block: 	Control	pictures}', "");
Expect(1, 9279, '\P{^Block: 	Control	pictures}', "");
Expect(0, 9215, '\p{Block: 	Control	pictures}', "");
Expect(1, 9215, '\p{^Block: 	Control	pictures}', "");
Expect(1, 9215, '\P{Block: 	Control	pictures}', "");
Expect(0, 9215, '\P{^Block: 	Control	pictures}', "");
Error('\p{Blk=:=-Control pictures}');
Error('\P{Blk=:=-Control pictures}');
Expect(1, 9279, '\p{Blk:	controlpictures}', "");
Expect(0, 9279, '\p{^Blk:	controlpictures}', "");
Expect(0, 9279, '\P{Blk:	controlpictures}', "");
Expect(1, 9279, '\P{^Blk:	controlpictures}', "");
Expect(0, 9215, '\p{Blk:	controlpictures}', "");
Expect(1, 9215, '\p{^Blk:	controlpictures}', "");
Expect(1, 9215, '\P{Blk:	controlpictures}', "");
Expect(0, 9215, '\P{^Blk:	controlpictures}', "");
Expect(1, 9279, '\p{Blk=-Control	Pictures}', "");
Expect(0, 9279, '\p{^Blk=-Control	Pictures}', "");
Expect(0, 9279, '\P{Blk=-Control	Pictures}', "");
Expect(1, 9279, '\P{^Blk=-Control	Pictures}', "");
Expect(0, 9215, '\p{Blk=-Control	Pictures}', "");
Expect(1, 9215, '\p{^Blk=-Control	Pictures}', "");
Expect(1, 9215, '\P{Blk=-Control	Pictures}', "");
Expect(0, 9215, '\P{^Blk=-Control	Pictures}', "");
Error('\p{Is_Block=	/a/Control Pictures}');
Error('\P{Is_Block=	/a/Control Pictures}');
Expect(1, 9279, '\p{Is_Block=controlpictures}', "");
Expect(0, 9279, '\p{^Is_Block=controlpictures}', "");
Expect(0, 9279, '\P{Is_Block=controlpictures}', "");
Expect(1, 9279, '\P{^Is_Block=controlpictures}', "");
Expect(0, 9215, '\p{Is_Block=controlpictures}', "");
Expect(1, 9215, '\p{^Is_Block=controlpictures}', "");
Expect(1, 9215, '\P{Is_Block=controlpictures}', "");
Expect(0, 9215, '\P{^Is_Block=controlpictures}', "");
Expect(1, 9279, '\p{Is_Block= 	control	Pictures}', "");
Expect(0, 9279, '\p{^Is_Block= 	control	Pictures}', "");
Expect(0, 9279, '\P{Is_Block= 	control	Pictures}', "");
Expect(1, 9279, '\P{^Is_Block= 	control	Pictures}', "");
Expect(0, 9215, '\p{Is_Block= 	control	Pictures}', "");
Expect(1, 9215, '\p{^Is_Block= 	control	Pictures}', "");
Expect(1, 9215, '\P{Is_Block= 	control	Pictures}', "");
Expect(0, 9215, '\P{^Is_Block= 	control	Pictures}', "");
Error('\p{Is_Blk=/a/_control pictures}');
Error('\P{Is_Blk=/a/_control pictures}');
Expect(1, 9279, '\p{Is_Blk=controlpictures}', "");
Expect(0, 9279, '\p{^Is_Blk=controlpictures}', "");
Expect(0, 9279, '\P{Is_Blk=controlpictures}', "");
Expect(1, 9279, '\P{^Is_Blk=controlpictures}', "");
Expect(0, 9215, '\p{Is_Blk=controlpictures}', "");
Expect(1, 9215, '\p{^Is_Blk=controlpictures}', "");
Expect(1, 9215, '\P{Is_Blk=controlpictures}', "");
Expect(0, 9215, '\P{^Is_Blk=controlpictures}', "");
Expect(1, 9279, '\p{Is_Blk=-Controlpictures}', "");
Expect(0, 9279, '\p{^Is_Blk=-Controlpictures}', "");
Expect(0, 9279, '\P{Is_Blk=-Controlpictures}', "");
Expect(1, 9279, '\P{^Is_Blk=-Controlpictures}', "");
Expect(0, 9215, '\p{Is_Blk=-Controlpictures}', "");
Expect(1, 9215, '\p{^Is_Blk=-Controlpictures}', "");
Expect(1, 9215, '\P{Is_Blk=-Controlpictures}', "");
Expect(0, 9215, '\P{^Is_Blk=-Controlpictures}', "");
Error('\p{Block:     High Private:=Use Surrogates}');
Error('\P{Block:     High Private:=Use Surrogates}');
Expect(0, 1, '\p{Block:highprivateusesurrogates}', "");
Expect(1, 1, '\p{^Block:highprivateusesurrogates}', "");
Expect(1, 1, '\P{Block:highprivateusesurrogates}', "");
Expect(0, 1, '\P{^Block:highprivateusesurrogates}', "");
Expect(0, 1, '\p{Block=	 high_Private Use	SURROGATES}', "");
Expect(1, 1, '\p{^Block=	 high_Private Use	SURROGATES}', "");
Expect(1, 1, '\P{Block=	 high_Private Use	SURROGATES}', "");
Expect(0, 1, '\P{^Block=	 high_Private Use	SURROGATES}', "");
Error('\p{Blk=-HIGH-Private:=use Surrogates}');
Error('\P{Blk=-HIGH-Private:=use Surrogates}');
Expect(0, 1, '\p{Blk=highprivateusesurrogates}', "");
Expect(1, 1, '\p{^Blk=highprivateusesurrogates}', "");
Expect(1, 1, '\P{Blk=highprivateusesurrogates}', "");
Expect(0, 1, '\P{^Blk=highprivateusesurrogates}', "");
Expect(0, 1, '\p{Blk= _HIGHPrivateUse	SURROGATES}', "");
Expect(1, 1, '\p{^Blk= _HIGHPrivateUse	SURROGATES}', "");
Expect(1, 1, '\P{Blk= _HIGHPrivateUse	SURROGATES}', "");
Expect(0, 1, '\P{^Blk= _HIGHPrivateUse	SURROGATES}', "");
Error('\p{Is_Block=	:=High PRIVATE-USESurrogates}');
Error('\P{Is_Block=	:=High PRIVATE-USESurrogates}');
Expect(0, 1, '\p{Is_Block=highprivateusesurrogates}', "");
Expect(1, 1, '\p{^Is_Block=highprivateusesurrogates}', "");
Expect(1, 1, '\P{Is_Block=highprivateusesurrogates}', "");
Expect(0, 1, '\P{^Is_Block=highprivateusesurrogates}', "");
Expect(0, 1, '\p{Is_Block=	high	Private	Use_SURROGATES}', "");
Expect(1, 1, '\p{^Is_Block=	high	Private	Use_SURROGATES}', "");
Expect(1, 1, '\P{Is_Block=	high	Private	Use_SURROGATES}', "");
Expect(0, 1, '\P{^Is_Block=	high	Private	Use_SURROGATES}', "");
Error('\p{Is_Blk=_/a/High-private_use_surrogates}');
Error('\P{Is_Blk=_/a/High-private_use_surrogates}');
Expect(0, 1, '\p{Is_Blk=highprivateusesurrogates}', "");
Expect(1, 1, '\p{^Is_Blk=highprivateusesurrogates}', "");
Expect(1, 1, '\P{Is_Blk=highprivateusesurrogates}', "");
Expect(0, 1, '\P{^Is_Blk=highprivateusesurrogates}', "");
Expect(0, 1, '\p{Is_Blk=-	HIGH-private_USE_Surrogates}', "");
Expect(1, 1, '\p{^Is_Blk=-	HIGH-private_USE_Surrogates}', "");
Expect(1, 1, '\P{Is_Blk=-	HIGH-private_USE_Surrogates}', "");
Expect(0, 1, '\P{^Is_Blk=-	HIGH-private_USE_Surrogates}', "");
Error('\p{Block:   	 Ugaritic:=}');
Error('\P{Block:   	 Ugaritic:=}');
Expect(1, 66463, '\p{Block=ugaritic}', "");
Expect(0, 66463, '\p{^Block=ugaritic}', "");
Expect(0, 66463, '\P{Block=ugaritic}', "");
Expect(1, 66463, '\P{^Block=ugaritic}', "");
Expect(0, 66431, '\p{Block=ugaritic}', "");
Expect(1, 66431, '\p{^Block=ugaritic}', "");
Expect(1, 66431, '\P{Block=ugaritic}', "");
Expect(0, 66431, '\P{^Block=ugaritic}', "");
Expect(1, 66463, '\p{Block=	_Ugaritic}', "");
Expect(0, 66463, '\p{^Block=	_Ugaritic}', "");
Expect(0, 66463, '\P{Block=	_Ugaritic}', "");
Expect(1, 66463, '\P{^Block=	_Ugaritic}', "");
Expect(0, 66431, '\p{Block=	_Ugaritic}', "");
Expect(1, 66431, '\p{^Block=	_Ugaritic}', "");
Expect(1, 66431, '\P{Block=	_Ugaritic}', "");
Expect(0, 66431, '\P{^Block=	_Ugaritic}', "");
Error('\p{Blk=/a/__UGARITIC}');
Error('\P{Blk=/a/__UGARITIC}');
Expect(1, 66463, '\p{Blk=ugaritic}', "");
Expect(0, 66463, '\p{^Blk=ugaritic}', "");
Expect(0, 66463, '\P{Blk=ugaritic}', "");
Expect(1, 66463, '\P{^Blk=ugaritic}', "");
Expect(0, 66431, '\p{Blk=ugaritic}', "");
Expect(1, 66431, '\p{^Blk=ugaritic}', "");
Expect(1, 66431, '\P{Blk=ugaritic}', "");
Expect(0, 66431, '\P{^Blk=ugaritic}', "");
Expect(1, 66463, '\p{Blk=		Ugaritic}', "");
Expect(0, 66463, '\p{^Blk=		Ugaritic}', "");
Expect(0, 66463, '\P{Blk=		Ugaritic}', "");
Expect(1, 66463, '\P{^Blk=		Ugaritic}', "");
Expect(0, 66431, '\p{Blk=		Ugaritic}', "");
Expect(1, 66431, '\p{^Blk=		Ugaritic}', "");
Expect(1, 66431, '\P{Blk=		Ugaritic}', "");
Expect(0, 66431, '\P{^Blk=		Ugaritic}', "");
Error('\p{Is_Block=--Ugaritic/a/}');
Error('\P{Is_Block=--Ugaritic/a/}');
Expect(1, 66463, '\p{Is_Block=ugaritic}', "");
Expect(0, 66463, '\p{^Is_Block=ugaritic}', "");
Expect(0, 66463, '\P{Is_Block=ugaritic}', "");
Expect(1, 66463, '\P{^Is_Block=ugaritic}', "");
Expect(0, 66431, '\p{Is_Block=ugaritic}', "");
Expect(1, 66431, '\p{^Is_Block=ugaritic}', "");
Expect(1, 66431, '\P{Is_Block=ugaritic}', "");
Expect(0, 66431, '\P{^Is_Block=ugaritic}', "");
Expect(1, 66463, '\p{Is_Block:     ugaritic}', "");
Expect(0, 66463, '\p{^Is_Block:     ugaritic}', "");
Expect(0, 66463, '\P{Is_Block:     ugaritic}', "");
Expect(1, 66463, '\P{^Is_Block:     ugaritic}', "");
Expect(0, 66431, '\p{Is_Block:     ugaritic}', "");
Expect(1, 66431, '\p{^Is_Block:     ugaritic}', "");
Expect(1, 66431, '\P{Is_Block:     ugaritic}', "");
Expect(0, 66431, '\P{^Is_Block:     ugaritic}', "");
Error('\p{Is_Blk=		Ugaritic/a/}');
Error('\P{Is_Blk=		Ugaritic/a/}');
Expect(1, 66463, '\p{Is_Blk=ugaritic}', "");
Expect(0, 66463, '\p{^Is_Blk=ugaritic}', "");
Expect(0, 66463, '\P{Is_Blk=ugaritic}', "");
Expect(1, 66463, '\P{^Is_Blk=ugaritic}', "");
Expect(0, 66431, '\p{Is_Blk=ugaritic}', "");
Expect(1, 66431, '\p{^Is_Blk=ugaritic}', "");
Expect(1, 66431, '\P{Is_Blk=ugaritic}', "");
Expect(0, 66431, '\P{^Is_Blk=ugaritic}', "");
Expect(1, 66463, '\p{Is_Blk=-_ugaritic}', "");
Expect(0, 66463, '\p{^Is_Blk=-_ugaritic}', "");
Expect(0, 66463, '\P{Is_Blk=-_ugaritic}', "");
Expect(1, 66463, '\P{^Is_Blk=-_ugaritic}', "");
Expect(0, 66431, '\p{Is_Blk=-_ugaritic}', "");
Expect(1, 66431, '\p{^Is_Blk=-_ugaritic}', "");
Expect(1, 66431, '\P{Is_Blk=-_ugaritic}', "");
Expect(0, 66431, '\P{^Is_Blk=-_ugaritic}', "");
Error('\p{Block=_/a/ARMENIAN}');
Error('\P{Block=_/a/ARMENIAN}');
Expect(1, 1423, '\p{Block=armenian}', "");
Expect(0, 1423, '\p{^Block=armenian}', "");
Expect(0, 1423, '\P{Block=armenian}', "");
Expect(1, 1423, '\P{^Block=armenian}', "");
Expect(0, 1327, '\p{Block=armenian}', "");
Expect(1, 1327, '\p{^Block=armenian}', "");
Expect(1, 1327, '\P{Block=armenian}', "");
Expect(0, 1327, '\P{^Block=armenian}', "");
Expect(1, 1423, '\p{Block=Armenian}', "");
Expect(0, 1423, '\p{^Block=Armenian}', "");
Expect(0, 1423, '\P{Block=Armenian}', "");
Expect(1, 1423, '\P{^Block=Armenian}', "");
Expect(0, 1327, '\p{Block=Armenian}', "");
Expect(1, 1327, '\p{^Block=Armenian}', "");
Expect(1, 1327, '\P{Block=Armenian}', "");
Expect(0, 1327, '\P{^Block=Armenian}', "");
Error('\p{Blk=:=-	ARMENIAN}');
Error('\P{Blk=:=-	ARMENIAN}');
Expect(1, 1423, '\p{Blk=armenian}', "");
Expect(0, 1423, '\p{^Blk=armenian}', "");
Expect(0, 1423, '\P{Blk=armenian}', "");
Expect(1, 1423, '\P{^Blk=armenian}', "");
Expect(0, 1327, '\p{Blk=armenian}', "");
Expect(1, 1327, '\p{^Blk=armenian}', "");
Expect(1, 1327, '\P{Blk=armenian}', "");
Expect(0, 1327, '\P{^Blk=armenian}', "");
Expect(1, 1423, '\p{Blk:_ Armenian}', "");
Expect(0, 1423, '\p{^Blk:_ Armenian}', "");
Expect(0, 1423, '\P{Blk:_ Armenian}', "");
Expect(1, 1423, '\P{^Blk:_ Armenian}', "");
Expect(0, 1327, '\p{Blk:_ Armenian}', "");
Expect(1, 1327, '\p{^Blk:_ Armenian}', "");
Expect(1, 1327, '\P{Blk:_ Armenian}', "");
Expect(0, 1327, '\P{^Blk:_ Armenian}', "");
Error('\p{Is_Block=:= ARMENIAN}');
Error('\P{Is_Block=:= ARMENIAN}');
Expect(1, 1423, '\p{Is_Block=armenian}', "");
Expect(0, 1423, '\p{^Is_Block=armenian}', "");
Expect(0, 1423, '\P{Is_Block=armenian}', "");
Expect(1, 1423, '\P{^Is_Block=armenian}', "");
Expect(0, 1327, '\p{Is_Block=armenian}', "");
Expect(1, 1327, '\p{^Is_Block=armenian}', "");
Expect(1, 1327, '\P{Is_Block=armenian}', "");
Expect(0, 1327, '\P{^Is_Block=armenian}', "");
Expect(1, 1423, '\p{Is_Block=_-ARMENIAN}', "");
Expect(0, 1423, '\p{^Is_Block=_-ARMENIAN}', "");
Expect(0, 1423, '\P{Is_Block=_-ARMENIAN}', "");
Expect(1, 1423, '\P{^Is_Block=_-ARMENIAN}', "");
Expect(0, 1327, '\p{Is_Block=_-ARMENIAN}', "");
Expect(1, 1327, '\p{^Is_Block=_-ARMENIAN}', "");
Expect(1, 1327, '\P{Is_Block=_-ARMENIAN}', "");
Expect(0, 1327, '\P{^Is_Block=_-ARMENIAN}', "");
Error('\p{Is_Blk=-:=Armenian}');
Error('\P{Is_Blk=-:=Armenian}');
Expect(1, 1423, '\p{Is_Blk=armenian}', "");
Expect(0, 1423, '\p{^Is_Blk=armenian}', "");
Expect(0, 1423, '\P{Is_Blk=armenian}', "");
Expect(1, 1423, '\P{^Is_Blk=armenian}', "");
Expect(0, 1327, '\p{Is_Blk=armenian}', "");
Expect(1, 1327, '\p{^Is_Blk=armenian}', "");
Expect(1, 1327, '\P{Is_Blk=armenian}', "");
Expect(0, 1327, '\P{^Is_Blk=armenian}', "");
Expect(1, 1423, '\p{Is_Blk=_Armenian}', "");
Expect(0, 1423, '\p{^Is_Blk=_Armenian}', "");
Expect(0, 1423, '\P{Is_Blk=_Armenian}', "");
Expect(1, 1423, '\P{^Is_Blk=_Armenian}', "");
Expect(0, 1327, '\p{Is_Blk=_Armenian}', "");
Expect(1, 1327, '\p{^Is_Blk=_Armenian}', "");
Expect(1, 1327, '\P{Is_Blk=_Armenian}', "");
Expect(0, 1327, '\P{^Is_Blk=_Armenian}', "");
Error('\p{Block=PRIVATE:=Use_area}');
Error('\P{Block=PRIVATE:=Use_area}');
Expect(1, 63743, '\p{Block=privateusearea}', "");
Expect(0, 63743, '\p{^Block=privateusearea}', "");
Expect(0, 63743, '\P{Block=privateusearea}', "");
Expect(1, 63743, '\P{^Block=privateusearea}', "");
Expect(0, 1, '\p{Block=privateusearea}', "");
Expect(1, 1, '\p{^Block=privateusearea}', "");
Expect(1, 1, '\P{Block=privateusearea}', "");
Expect(0, 1, '\P{^Block=privateusearea}', "");
Expect(1, 63743, '\p{Block=	-PRIVATE_USEarea}', "");
Expect(0, 63743, '\p{^Block=	-PRIVATE_USEarea}', "");
Expect(0, 63743, '\P{Block=	-PRIVATE_USEarea}', "");
Expect(1, 63743, '\P{^Block=	-PRIVATE_USEarea}', "");
Expect(0, 1, '\p{Block=	-PRIVATE_USEarea}', "");
Expect(1, 1, '\p{^Block=	-PRIVATE_USEarea}', "");
Expect(1, 1, '\P{Block=	-PRIVATE_USEarea}', "");
Expect(0, 1, '\P{^Block=	-PRIVATE_USEarea}', "");
Error('\p{Blk=:=--Private USE}');
Error('\P{Blk=:=--Private USE}');
Expect(1, 63743, '\p{Blk=privateuse}', "");
Expect(0, 63743, '\p{^Blk=privateuse}', "");
Expect(0, 63743, '\P{Blk=privateuse}', "");
Expect(1, 63743, '\P{^Blk=privateuse}', "");
Expect(0, 1, '\p{Blk=privateuse}', "");
Expect(1, 1, '\p{^Blk=privateuse}', "");
Expect(1, 1, '\P{Blk=privateuse}', "");
Expect(0, 1, '\P{^Blk=privateuse}', "");
Expect(1, 63743, '\p{Blk=-Private-use}', "");
Expect(0, 63743, '\p{^Blk=-Private-use}', "");
Expect(0, 63743, '\P{Blk=-Private-use}', "");
Expect(1, 63743, '\P{^Blk=-Private-use}', "");
Expect(0, 1, '\p{Blk=-Private-use}', "");
Expect(1, 1, '\p{^Blk=-Private-use}', "");
Expect(1, 1, '\P{Blk=-Private-use}', "");
Expect(0, 1, '\P{^Blk=-Private-use}', "");
Error('\p{Is_Block=  PRIVATE/a/use-Area}');
Error('\P{Is_Block=  PRIVATE/a/use-Area}');
Expect(1, 63743, '\p{Is_Block=privateusearea}', "");
Expect(0, 63743, '\p{^Is_Block=privateusearea}', "");
Expect(0, 63743, '\P{Is_Block=privateusearea}', "");
Expect(1, 63743, '\P{^Is_Block=privateusearea}', "");
Expect(0, 1, '\p{Is_Block=privateusearea}', "");
Expect(1, 1, '\p{^Is_Block=privateusearea}', "");
Expect(1, 1, '\P{Is_Block=privateusearea}', "");
Expect(0, 1, '\P{^Is_Block=privateusearea}', "");
Expect(1, 63743, '\p{Is_Block=-_PRIVATE UseArea}', "");
Expect(0, 63743, '\p{^Is_Block=-_PRIVATE UseArea}', "");
Expect(0, 63743, '\P{Is_Block=-_PRIVATE UseArea}', "");
Expect(1, 63743, '\P{^Is_Block=-_PRIVATE UseArea}', "");
Expect(0, 1, '\p{Is_Block=-_PRIVATE UseArea}', "");
Expect(1, 1, '\p{^Is_Block=-_PRIVATE UseArea}', "");
Expect(1, 1, '\P{Is_Block=-_PRIVATE UseArea}', "");
Expect(0, 1, '\P{^Is_Block=-_PRIVATE UseArea}', "");
Error('\p{Is_Blk=:= PRIVATEUse}');
Error('\P{Is_Blk=:= PRIVATEUse}');
Expect(1, 63743, '\p{Is_Blk=privateuse}', "");
Expect(0, 63743, '\p{^Is_Blk=privateuse}', "");
Expect(0, 63743, '\P{Is_Blk=privateuse}', "");
Expect(1, 63743, '\P{^Is_Blk=privateuse}', "");
Expect(0, 1, '\p{Is_Blk=privateuse}', "");
Expect(1, 1, '\p{^Is_Blk=privateuse}', "");
Expect(1, 1, '\P{Is_Blk=privateuse}', "");
Expect(0, 1, '\P{^Is_Blk=privateuse}', "");
Expect(1, 63743, '\p{Is_Blk=_PRIVATE-use}', "");
Expect(0, 63743, '\p{^Is_Blk=_PRIVATE-use}', "");
Expect(0, 63743, '\P{Is_Blk=_PRIVATE-use}', "");
Expect(1, 63743, '\P{^Is_Blk=_PRIVATE-use}', "");
Expect(0, 1, '\p{Is_Blk=_PRIVATE-use}', "");
Expect(1, 1, '\p{^Is_Blk=_PRIVATE-use}', "");
Expect(1, 1, '\P{Is_Blk=_PRIVATE-use}', "");
Expect(0, 1, '\P{^Is_Blk=_PRIVATE-use}', "");
Error('\p{Block=_-Syriac:=}');
Error('\P{Block=_-Syriac:=}');
Expect(1, 1871, '\p{Block=syriac}', "");
Expect(0, 1871, '\p{^Block=syriac}', "");
Expect(0, 1871, '\P{Block=syriac}', "");
Expect(1, 1871, '\P{^Block=syriac}', "");
Expect(0, 1791, '\p{Block=syriac}', "");
Expect(1, 1791, '\p{^Block=syriac}', "");
Expect(1, 1791, '\P{Block=syriac}', "");
Expect(0, 1791, '\P{^Block=syriac}', "");
Expect(1, 1871, '\p{Block=	Syriac}', "");
Expect(0, 1871, '\p{^Block=	Syriac}', "");
Expect(0, 1871, '\P{Block=	Syriac}', "");
Expect(1, 1871, '\P{^Block=	Syriac}', "");
Expect(0, 1791, '\p{Block=	Syriac}', "");
Expect(1, 1791, '\p{^Block=	Syriac}', "");
Expect(1, 1791, '\P{Block=	Syriac}', "");
Expect(0, 1791, '\P{^Block=	Syriac}', "");
Error('\p{Blk=/a/	SYRIAC}');
Error('\P{Blk=/a/	SYRIAC}');
Expect(1, 1871, '\p{Blk=syriac}', "");
Expect(0, 1871, '\p{^Blk=syriac}', "");
Expect(0, 1871, '\P{Blk=syriac}', "");
Expect(1, 1871, '\P{^Blk=syriac}', "");
Expect(0, 1791, '\p{Blk=syriac}', "");
Expect(1, 1791, '\p{^Blk=syriac}', "");
Expect(1, 1791, '\P{Blk=syriac}', "");
Expect(0, 1791, '\P{^Blk=syriac}', "");
Expect(1, 1871, '\p{Blk=__Syriac}', "");
Expect(0, 1871, '\p{^Blk=__Syriac}', "");
Expect(0, 1871, '\P{Blk=__Syriac}', "");
Expect(1, 1871, '\P{^Blk=__Syriac}', "");
Expect(0, 1791, '\p{Blk=__Syriac}', "");
Expect(1, 1791, '\p{^Blk=__Syriac}', "");
Expect(1, 1791, '\P{Blk=__Syriac}', "");
Expect(0, 1791, '\P{^Blk=__Syriac}', "");
Error('\p{Is_Block=-Syriac/a/}');
Error('\P{Is_Block=-Syriac/a/}');
Expect(1, 1871, '\p{Is_Block: syriac}', "");
Expect(0, 1871, '\p{^Is_Block: syriac}', "");
Expect(0, 1871, '\P{Is_Block: syriac}', "");
Expect(1, 1871, '\P{^Is_Block: syriac}', "");
Expect(0, 1791, '\p{Is_Block: syriac}', "");
Expect(1, 1791, '\p{^Is_Block: syriac}', "");
Expect(1, 1791, '\P{Is_Block: syriac}', "");
Expect(0, 1791, '\P{^Is_Block: syriac}', "");
Expect(1, 1871, '\p{Is_Block=	Syriac}', "");
Expect(0, 1871, '\p{^Is_Block=	Syriac}', "");
Expect(0, 1871, '\P{Is_Block=	Syriac}', "");
Expect(1, 1871, '\P{^Is_Block=	Syriac}', "");
Expect(0, 1791, '\p{Is_Block=	Syriac}', "");
Expect(1, 1791, '\p{^Is_Block=	Syriac}', "");
Expect(1, 1791, '\P{Is_Block=	Syriac}', "");
Expect(0, 1791, '\P{^Is_Block=	Syriac}', "");
Error('\p{Is_Blk=_SYRIAC/a/}');
Error('\P{Is_Blk=_SYRIAC/a/}');
Expect(1, 1871, '\p{Is_Blk=syriac}', "");
Expect(0, 1871, '\p{^Is_Blk=syriac}', "");
Expect(0, 1871, '\P{Is_Blk=syriac}', "");
Expect(1, 1871, '\P{^Is_Blk=syriac}', "");
Expect(0, 1791, '\p{Is_Blk=syriac}', "");
Expect(1, 1791, '\p{^Is_Blk=syriac}', "");
Expect(1, 1791, '\P{Is_Blk=syriac}', "");
Expect(0, 1791, '\P{^Is_Blk=syriac}', "");
Expect(1, 1871, '\p{Is_Blk=	 Syriac}', "");
Expect(0, 1871, '\p{^Is_Blk=	 Syriac}', "");
Expect(0, 1871, '\P{Is_Blk=	 Syriac}', "");
Expect(1, 1871, '\P{^Is_Blk=	 Syriac}', "");
Expect(0, 1791, '\p{Is_Blk=	 Syriac}', "");
Expect(1, 1791, '\p{^Is_Blk=	 Syriac}', "");
Expect(1, 1791, '\P{Is_Blk=	 Syriac}', "");
Expect(0, 1791, '\P{^Is_Blk=	 Syriac}', "");
Error('\p{Block:	_:=ancient-Greek Musical	Notation}');
Error('\P{Block:	_:=ancient-Greek Musical	Notation}');
Expect(1, 119375, '\p{Block=ancientgreekmusicalnotation}', "");
Expect(0, 119375, '\p{^Block=ancientgreekmusicalnotation}', "");
Expect(0, 119375, '\P{Block=ancientgreekmusicalnotation}', "");
Expect(1, 119375, '\P{^Block=ancientgreekmusicalnotation}', "");
Expect(0, 119295, '\p{Block=ancientgreekmusicalnotation}', "");
Expect(1, 119295, '\p{^Block=ancientgreekmusicalnotation}', "");
Expect(1, 119295, '\P{Block=ancientgreekmusicalnotation}', "");
Expect(0, 119295, '\P{^Block=ancientgreekmusicalnotation}', "");
Expect(1, 119375, '\p{Block= 	Ancient-Greek_Musical	Notation}', "");
Expect(0, 119375, '\p{^Block= 	Ancient-Greek_Musical	Notation}', "");
Expect(0, 119375, '\P{Block= 	Ancient-Greek_Musical	Notation}', "");
Expect(1, 119375, '\P{^Block= 	Ancient-Greek_Musical	Notation}', "");
Expect(0, 119295, '\p{Block= 	Ancient-Greek_Musical	Notation}', "");
Expect(1, 119295, '\p{^Block= 	Ancient-Greek_Musical	Notation}', "");
Expect(1, 119295, '\P{Block= 	Ancient-Greek_Musical	Notation}', "");
Expect(0, 119295, '\P{^Block= 	Ancient-Greek_Musical	Notation}', "");
Error('\p{Blk=  Ancient/a/Greek-Musical-Notation}');
Error('\P{Blk=  Ancient/a/Greek-Musical-Notation}');
Expect(1, 119375, '\p{Blk=ancientgreekmusicalnotation}', "");
Expect(0, 119375, '\p{^Blk=ancientgreekmusicalnotation}', "");
Expect(0, 119375, '\P{Blk=ancientgreekmusicalnotation}', "");
Expect(1, 119375, '\P{^Blk=ancientgreekmusicalnotation}', "");
Expect(0, 119295, '\p{Blk=ancientgreekmusicalnotation}', "");
Expect(1, 119295, '\p{^Blk=ancientgreekmusicalnotation}', "");
Expect(1, 119295, '\P{Blk=ancientgreekmusicalnotation}', "");
Expect(0, 119295, '\P{^Blk=ancientgreekmusicalnotation}', "");
Expect(1, 119375, '\p{Blk=_	ancientgreek	MUSICAL-Notation}', "");
Expect(0, 119375, '\p{^Blk=_	ancientgreek	MUSICAL-Notation}', "");
Expect(0, 119375, '\P{Blk=_	ancientgreek	MUSICAL-Notation}', "");
Expect(1, 119375, '\P{^Blk=_	ancientgreek	MUSICAL-Notation}', "");
Expect(0, 119295, '\p{Blk=_	ancientgreek	MUSICAL-Notation}', "");
Expect(1, 119295, '\p{^Blk=_	ancientgreek	MUSICAL-Notation}', "");
Expect(1, 119295, '\P{Blk=_	ancientgreek	MUSICAL-Notation}', "");
Expect(0, 119295, '\P{^Blk=_	ancientgreek	MUSICAL-Notation}', "");
Error('\p{Is_Block= ANCIENT/a/GREEK-Musical notation}');
Error('\P{Is_Block= ANCIENT/a/GREEK-Musical notation}');
Expect(1, 119375, '\p{Is_Block=ancientgreekmusicalnotation}', "");
Expect(0, 119375, '\p{^Is_Block=ancientgreekmusicalnotation}', "");
Expect(0, 119375, '\P{Is_Block=ancientgreekmusicalnotation}', "");
Expect(1, 119375, '\P{^Is_Block=ancientgreekmusicalnotation}', "");
Expect(0, 119295, '\p{Is_Block=ancientgreekmusicalnotation}', "");
Expect(1, 119295, '\p{^Is_Block=ancientgreekmusicalnotation}', "");
Expect(1, 119295, '\P{Is_Block=ancientgreekmusicalnotation}', "");
Expect(0, 119295, '\P{^Is_Block=ancientgreekmusicalnotation}', "");
Expect(1, 119375, '\p{Is_Block=  Ancient	Greek_Musical_Notation}', "");
Expect(0, 119375, '\p{^Is_Block=  Ancient	Greek_Musical_Notation}', "");
Expect(0, 119375, '\P{Is_Block=  Ancient	Greek_Musical_Notation}', "");
Expect(1, 119375, '\P{^Is_Block=  Ancient	Greek_Musical_Notation}', "");
Expect(0, 119295, '\p{Is_Block=  Ancient	Greek_Musical_Notation}', "");
Expect(1, 119295, '\p{^Is_Block=  Ancient	Greek_Musical_Notation}', "");
Expect(1, 119295, '\P{Is_Block=  Ancient	Greek_Musical_Notation}', "");
Expect(0, 119295, '\P{^Is_Block=  Ancient	Greek_Musical_Notation}', "");
Error('\p{Is_Blk= 	Ancient:=Greek	MUSICAL-NOTATION}');
Error('\P{Is_Blk= 	Ancient:=Greek	MUSICAL-NOTATION}');
Expect(1, 119375, '\p{Is_Blk=ancientgreekmusicalnotation}', "");
Expect(0, 119375, '\p{^Is_Blk=ancientgreekmusicalnotation}', "");
Expect(0, 119375, '\P{Is_Blk=ancientgreekmusicalnotation}', "");
Expect(1, 119375, '\P{^Is_Blk=ancientgreekmusicalnotation}', "");
Expect(0, 119295, '\p{Is_Blk=ancientgreekmusicalnotation}', "");
Expect(1, 119295, '\p{^Is_Blk=ancientgreekmusicalnotation}', "");
Expect(1, 119295, '\P{Is_Blk=ancientgreekmusicalnotation}', "");
Expect(0, 119295, '\P{^Is_Blk=ancientgreekmusicalnotation}', "");
Expect(1, 119375, '\p{Is_Blk=_ANCIENT-greek_musical	Notation}', "");
Expect(0, 119375, '\p{^Is_Blk=_ANCIENT-greek_musical	Notation}', "");
Expect(0, 119375, '\P{Is_Blk=_ANCIENT-greek_musical	Notation}', "");
Expect(1, 119375, '\P{^Is_Blk=_ANCIENT-greek_musical	Notation}', "");
Expect(0, 119295, '\p{Is_Blk=_ANCIENT-greek_musical	Notation}', "");
Expect(1, 119295, '\p{^Is_Blk=_ANCIENT-greek_musical	Notation}', "");
Expect(1, 119295, '\P{Is_Blk=_ANCIENT-greek_musical	Notation}', "");
Expect(0, 119295, '\P{^Is_Blk=_ANCIENT-greek_musical	Notation}', "");
Error('\p{Block= :=Phags_Pa}');
Error('\P{Block= :=Phags_Pa}');
Expect(1, 43135, '\p{Block=phagspa}', "");
Expect(0, 43135, '\p{^Block=phagspa}', "");
Expect(0, 43135, '\P{Block=phagspa}', "");
Expect(1, 43135, '\P{^Block=phagspa}', "");
Expect(0, 43071, '\p{Block=phagspa}', "");
Expect(1, 43071, '\p{^Block=phagspa}', "");
Expect(1, 43071, '\P{Block=phagspa}', "");
Expect(0, 43071, '\P{^Block=phagspa}', "");
Expect(1, 43135, '\p{Block=__Phagspa}', "");
Expect(0, 43135, '\p{^Block=__Phagspa}', "");
Expect(0, 43135, '\P{Block=__Phagspa}', "");
Expect(1, 43135, '\P{^Block=__Phagspa}', "");
Expect(0, 43071, '\p{Block=__Phagspa}', "");
Expect(1, 43071, '\p{^Block=__Phagspa}', "");
Expect(1, 43071, '\P{Block=__Phagspa}', "");
Expect(0, 43071, '\P{^Block=__Phagspa}', "");
Error('\p{Blk= 	Phagspa:=}');
Error('\P{Blk= 	Phagspa:=}');
Expect(1, 43135, '\p{Blk=phagspa}', "");
Expect(0, 43135, '\p{^Blk=phagspa}', "");
Expect(0, 43135, '\P{Blk=phagspa}', "");
Expect(1, 43135, '\P{^Blk=phagspa}', "");
Expect(0, 43071, '\p{Blk=phagspa}', "");
Expect(1, 43071, '\p{^Blk=phagspa}', "");
Expect(1, 43071, '\P{Blk=phagspa}', "");
Expect(0, 43071, '\P{^Blk=phagspa}', "");
Expect(1, 43135, '\p{Blk=	Phags	Pa}', "");
Expect(0, 43135, '\p{^Blk=	Phags	Pa}', "");
Expect(0, 43135, '\P{Blk=	Phags	Pa}', "");
Expect(1, 43135, '\P{^Blk=	Phags	Pa}', "");
Expect(0, 43071, '\p{Blk=	Phags	Pa}', "");
Expect(1, 43071, '\p{^Blk=	Phags	Pa}', "");
Expect(1, 43071, '\P{Blk=	Phags	Pa}', "");
Expect(0, 43071, '\P{^Blk=	Phags	Pa}', "");
Error('\p{Is_Block=/a/phags	Pa}');
Error('\P{Is_Block=/a/phags	Pa}');
Expect(1, 43135, '\p{Is_Block=phagspa}', "");
Expect(0, 43135, '\p{^Is_Block=phagspa}', "");
Expect(0, 43135, '\P{Is_Block=phagspa}', "");
Expect(1, 43135, '\P{^Is_Block=phagspa}', "");
Expect(0, 43071, '\p{Is_Block=phagspa}', "");
Expect(1, 43071, '\p{^Is_Block=phagspa}', "");
Expect(1, 43071, '\P{Is_Block=phagspa}', "");
Expect(0, 43071, '\P{^Is_Block=phagspa}', "");
Expect(1, 43135, '\p{Is_Block=	_PHAGS	Pa}', "");
Expect(0, 43135, '\p{^Is_Block=	_PHAGS	Pa}', "");
Expect(0, 43135, '\P{Is_Block=	_PHAGS	Pa}', "");
Expect(1, 43135, '\P{^Is_Block=	_PHAGS	Pa}', "");
Expect(0, 43071, '\p{Is_Block=	_PHAGS	Pa}', "");
Expect(1, 43071, '\p{^Is_Block=	_PHAGS	Pa}', "");
Expect(1, 43071, '\P{Is_Block=	_PHAGS	Pa}', "");
Expect(0, 43071, '\P{^Is_Block=	_PHAGS	Pa}', "");
Error('\p{Is_Blk=_ Phags	pa/a/}');
Error('\P{Is_Blk=_ Phags	pa/a/}');
Expect(1, 43135, '\p{Is_Blk=phagspa}', "");
Expect(0, 43135, '\p{^Is_Blk=phagspa}', "");
Expect(0, 43135, '\P{Is_Blk=phagspa}', "");
Expect(1, 43135, '\P{^Is_Blk=phagspa}', "");
Expect(0, 43071, '\p{Is_Blk=phagspa}', "");
Expect(1, 43071, '\p{^Is_Blk=phagspa}', "");
Expect(1, 43071, '\P{Is_Blk=phagspa}', "");
Expect(0, 43071, '\P{^Is_Blk=phagspa}', "");
Expect(1, 43135, '\p{Is_Blk=_ phags pa}', "");
Expect(0, 43135, '\p{^Is_Blk=_ phags pa}', "");
Expect(0, 43135, '\P{Is_Blk=_ phags pa}', "");
Expect(1, 43135, '\P{^Is_Blk=_ phags pa}', "");
Expect(0, 43071, '\p{Is_Blk=_ phags pa}', "");
Expect(1, 43071, '\p{^Is_Blk=_ phags pa}', "");
Expect(1, 43071, '\P{Is_Blk=_ phags pa}', "");
Expect(0, 43071, '\P{^Is_Blk=_ phags pa}', "");
Error('\p{Block=_:=CJKCompatibility-Ideographs}');
Error('\P{Block=_:=CJKCompatibility-Ideographs}');
Expect(1, 64255, '\p{Block=cjkcompatibilityideographs}', "");
Expect(0, 64255, '\p{^Block=cjkcompatibilityideographs}', "");
Expect(0, 64255, '\P{Block=cjkcompatibilityideographs}', "");
Expect(1, 64255, '\P{^Block=cjkcompatibilityideographs}', "");
Expect(0, 63743, '\p{Block=cjkcompatibilityideographs}', "");
Expect(1, 63743, '\p{^Block=cjkcompatibilityideographs}', "");
Expect(1, 63743, '\P{Block=cjkcompatibilityideographs}', "");
Expect(0, 63743, '\P{^Block=cjkcompatibilityideographs}', "");
Expect(1, 64255, '\p{Block:_CJK_compatibility-IDEOGRAPHS}', "");
Expect(0, 64255, '\p{^Block:_CJK_compatibility-IDEOGRAPHS}', "");
Expect(0, 64255, '\P{Block:_CJK_compatibility-IDEOGRAPHS}', "");
Expect(1, 64255, '\P{^Block:_CJK_compatibility-IDEOGRAPHS}', "");
Expect(0, 63743, '\p{Block:_CJK_compatibility-IDEOGRAPHS}', "");
Expect(1, 63743, '\p{^Block:_CJK_compatibility-IDEOGRAPHS}', "");
Expect(1, 63743, '\P{Block:_CJK_compatibility-IDEOGRAPHS}', "");
Expect(0, 63743, '\P{^Block:_CJK_compatibility-IDEOGRAPHS}', "");
Error('\p{Blk=_ CJK/a/Compatibility ideographs}');
Error('\P{Blk=_ CJK/a/Compatibility ideographs}');
Expect(1, 64255, '\p{Blk=cjkcompatibilityideographs}', "");
Expect(0, 64255, '\p{^Blk=cjkcompatibilityideographs}', "");
Expect(0, 64255, '\P{Blk=cjkcompatibilityideographs}', "");
Expect(1, 64255, '\P{^Blk=cjkcompatibilityideographs}', "");
Expect(0, 63743, '\p{Blk=cjkcompatibilityideographs}', "");
Expect(1, 63743, '\p{^Blk=cjkcompatibilityideographs}', "");
Expect(1, 63743, '\P{Blk=cjkcompatibilityideographs}', "");
Expect(0, 63743, '\P{^Blk=cjkcompatibilityideographs}', "");
Expect(1, 64255, '\p{Blk=--CJKCOMPATIBILITYIdeographs}', "");
Expect(0, 64255, '\p{^Blk=--CJKCOMPATIBILITYIdeographs}', "");
Expect(0, 64255, '\P{Blk=--CJKCOMPATIBILITYIdeographs}', "");
Expect(1, 64255, '\P{^Blk=--CJKCOMPATIBILITYIdeographs}', "");
Expect(0, 63743, '\p{Blk=--CJKCOMPATIBILITYIdeographs}', "");
Expect(1, 63743, '\p{^Blk=--CJKCOMPATIBILITYIdeographs}', "");
Expect(1, 63743, '\P{Blk=--CJKCOMPATIBILITYIdeographs}', "");
Expect(0, 63743, '\P{^Blk=--CJKCOMPATIBILITYIdeographs}', "");
Error('\p{Is_Block=:=_ cjk_COMPATIBILITY	Ideographs}');
Error('\P{Is_Block=:=_ cjk_COMPATIBILITY	Ideographs}');
Expect(1, 64255, '\p{Is_Block=cjkcompatibilityideographs}', "");
Expect(0, 64255, '\p{^Is_Block=cjkcompatibilityideographs}', "");
Expect(0, 64255, '\P{Is_Block=cjkcompatibilityideographs}', "");
Expect(1, 64255, '\P{^Is_Block=cjkcompatibilityideographs}', "");
Expect(0, 63743, '\p{Is_Block=cjkcompatibilityideographs}', "");
Expect(1, 63743, '\p{^Is_Block=cjkcompatibilityideographs}', "");
Expect(1, 63743, '\P{Is_Block=cjkcompatibilityideographs}', "");
Expect(0, 63743, '\P{^Is_Block=cjkcompatibilityideographs}', "");
Expect(1, 64255, '\p{Is_Block:	CJK Compatibility Ideographs}', "");
Expect(0, 64255, '\p{^Is_Block:	CJK Compatibility Ideographs}', "");
Expect(0, 64255, '\P{Is_Block:	CJK Compatibility Ideographs}', "");
Expect(1, 64255, '\P{^Is_Block:	CJK Compatibility Ideographs}', "");
Expect(0, 63743, '\p{Is_Block:	CJK Compatibility Ideographs}', "");
Expect(1, 63743, '\p{^Is_Block:	CJK Compatibility Ideographs}', "");
Expect(1, 63743, '\P{Is_Block:	CJK Compatibility Ideographs}', "");
Expect(0, 63743, '\P{^Is_Block:	CJK Compatibility Ideographs}', "");
Error('\p{Is_Blk= cjk_COMPATIBILITY ideographs:=}');
Error('\P{Is_Blk= cjk_COMPATIBILITY ideographs:=}');
Expect(1, 64255, '\p{Is_Blk=cjkcompatibilityideographs}', "");
Expect(0, 64255, '\p{^Is_Blk=cjkcompatibilityideographs}', "");
Expect(0, 64255, '\P{Is_Blk=cjkcompatibilityideographs}', "");
Expect(1, 64255, '\P{^Is_Blk=cjkcompatibilityideographs}', "");
Expect(0, 63743, '\p{Is_Blk=cjkcompatibilityideographs}', "");
Expect(1, 63743, '\p{^Is_Blk=cjkcompatibilityideographs}', "");
Expect(1, 63743, '\P{Is_Blk=cjkcompatibilityideographs}', "");
Expect(0, 63743, '\P{^Is_Blk=cjkcompatibilityideographs}', "");
Expect(1, 64255, '\p{Is_Blk=	 CJK-compatibility Ideographs}', "");
Expect(0, 64255, '\p{^Is_Blk=	 CJK-compatibility Ideographs}', "");
Expect(0, 64255, '\P{Is_Blk=	 CJK-compatibility Ideographs}', "");
Expect(1, 64255, '\P{^Is_Blk=	 CJK-compatibility Ideographs}', "");
Expect(0, 63743, '\p{Is_Blk=	 CJK-compatibility Ideographs}', "");
Expect(1, 63743, '\p{^Is_Blk=	 CJK-compatibility Ideographs}', "");
Expect(1, 63743, '\P{Is_Blk=	 CJK-compatibility Ideographs}', "");
Expect(0, 63743, '\P{^Is_Blk=	 CJK-compatibility Ideographs}', "");
Error('\p{Block=:=_-Thaana}');
Error('\P{Block=:=_-Thaana}');
Expect(1, 1983, '\p{Block=thaana}', "");
Expect(0, 1983, '\p{^Block=thaana}', "");
Expect(0, 1983, '\P{Block=thaana}', "");
Expect(1, 1983, '\P{^Block=thaana}', "");
Expect(0, 1919, '\p{Block=thaana}', "");
Expect(1, 1919, '\p{^Block=thaana}', "");
Expect(1, 1919, '\P{Block=thaana}', "");
Expect(0, 1919, '\P{^Block=thaana}', "");
Expect(1, 1983, '\p{Block=_	Thaana}', "");
Expect(0, 1983, '\p{^Block=_	Thaana}', "");
Expect(0, 1983, '\P{Block=_	Thaana}', "");
Expect(1, 1983, '\P{^Block=_	Thaana}', "");
Expect(0, 1919, '\p{Block=_	Thaana}', "");
Expect(1, 1919, '\p{^Block=_	Thaana}', "");
Expect(1, 1919, '\P{Block=_	Thaana}', "");
Expect(0, 1919, '\P{^Block=_	Thaana}', "");
Error('\p{Blk= :=Thaana}');
Error('\P{Blk= :=Thaana}');
Expect(1, 1983, '\p{Blk=thaana}', "");
Expect(0, 1983, '\p{^Blk=thaana}', "");
Expect(0, 1983, '\P{Blk=thaana}', "");
Expect(1, 1983, '\P{^Blk=thaana}', "");
Expect(0, 1919, '\p{Blk=thaana}', "");
Expect(1, 1919, '\p{^Blk=thaana}', "");
Expect(1, 1919, '\P{Blk=thaana}', "");
Expect(0, 1919, '\P{^Blk=thaana}', "");
Expect(1, 1983, '\p{Blk= _thaana}', "");
Expect(0, 1983, '\p{^Blk= _thaana}', "");
Expect(0, 1983, '\P{Blk= _thaana}', "");
Expect(1, 1983, '\P{^Blk= _thaana}', "");
Expect(0, 1919, '\p{Blk= _thaana}', "");
Expect(1, 1919, '\p{^Blk= _thaana}', "");
Expect(1, 1919, '\P{Blk= _thaana}', "");
Expect(0, 1919, '\P{^Blk= _thaana}', "");
Error('\p{Is_Block=/a/THAANA}');
Error('\P{Is_Block=/a/THAANA}');
Expect(1, 1983, '\p{Is_Block=thaana}', "");
Expect(0, 1983, '\p{^Is_Block=thaana}', "");
Expect(0, 1983, '\P{Is_Block=thaana}', "");
Expect(1, 1983, '\P{^Is_Block=thaana}', "");
Expect(0, 1919, '\p{Is_Block=thaana}', "");
Expect(1, 1919, '\p{^Is_Block=thaana}', "");
Expect(1, 1919, '\P{Is_Block=thaana}', "");
Expect(0, 1919, '\P{^Is_Block=thaana}', "");
Expect(1, 1983, '\p{Is_Block=	Thaana}', "");
Expect(0, 1983, '\p{^Is_Block=	Thaana}', "");
Expect(0, 1983, '\P{Is_Block=	Thaana}', "");
Expect(1, 1983, '\P{^Is_Block=	Thaana}', "");
Expect(0, 1919, '\p{Is_Block=	Thaana}', "");
Expect(1, 1919, '\p{^Is_Block=	Thaana}', "");
Expect(1, 1919, '\P{Is_Block=	Thaana}', "");
Expect(0, 1919, '\P{^Is_Block=	Thaana}', "");
Error('\p{Is_Blk=_:=Thaana}');
Error('\P{Is_Blk=_:=Thaana}');
Expect(1, 1983, '\p{Is_Blk=thaana}', "");
Expect(0, 1983, '\p{^Is_Blk=thaana}', "");
Expect(0, 1983, '\P{Is_Blk=thaana}', "");
Expect(1, 1983, '\P{^Is_Blk=thaana}', "");
Expect(0, 1919, '\p{Is_Blk=thaana}', "");
Expect(1, 1919, '\p{^Is_Blk=thaana}', "");
Expect(1, 1919, '\P{Is_Blk=thaana}', "");
Expect(0, 1919, '\P{^Is_Blk=thaana}', "");
Expect(1, 1983, '\p{Is_Blk=_-Thaana}', "");
Expect(0, 1983, '\p{^Is_Blk=_-Thaana}', "");
Expect(0, 1983, '\P{Is_Blk=_-Thaana}', "");
Expect(1, 1983, '\P{^Is_Blk=_-Thaana}', "");
Expect(0, 1919, '\p{Is_Blk=_-Thaana}', "");
Expect(1, 1919, '\p{^Is_Blk=_-Thaana}', "");
Expect(1, 1919, '\P{Is_Blk=_-Thaana}', "");
Expect(0, 1919, '\P{^Is_Blk=_-Thaana}', "");
Error('\p{Block=/a/-Enclosed-alphanumeric-Supplement}');
Error('\P{Block=/a/-Enclosed-alphanumeric-Supplement}');
Expect(1, 127487, '\p{Block:   enclosedalphanumericsupplement}', "");
Expect(0, 127487, '\p{^Block:   enclosedalphanumericsupplement}', "");
Expect(0, 127487, '\P{Block:   enclosedalphanumericsupplement}', "");
Expect(1, 127487, '\P{^Block:   enclosedalphanumericsupplement}', "");
Expect(0, 127231, '\p{Block:   enclosedalphanumericsupplement}', "");
Expect(1, 127231, '\p{^Block:   enclosedalphanumericsupplement}', "");
Expect(1, 127231, '\P{Block:   enclosedalphanumericsupplement}', "");
Expect(0, 127231, '\P{^Block:   enclosedalphanumericsupplement}', "");
Expect(1, 127487, '\p{Block=- ENCLOSED-alphanumeric supplement}', "");
Expect(0, 127487, '\p{^Block=- ENCLOSED-alphanumeric supplement}', "");
Expect(0, 127487, '\P{Block=- ENCLOSED-alphanumeric supplement}', "");
Expect(1, 127487, '\P{^Block=- ENCLOSED-alphanumeric supplement}', "");
Expect(0, 127231, '\p{Block=- ENCLOSED-alphanumeric supplement}', "");
Expect(1, 127231, '\p{^Block=- ENCLOSED-alphanumeric supplement}', "");
Expect(1, 127231, '\P{Block=- ENCLOSED-alphanumeric supplement}', "");
Expect(0, 127231, '\P{^Block=- ENCLOSED-alphanumeric supplement}', "");
Error('\p{Blk= -enclosed_Alphanumeric	Supplement:=}');
Error('\P{Blk= -enclosed_Alphanumeric	Supplement:=}');
Expect(1, 127487, '\p{Blk=enclosedalphanumericsupplement}', "");
Expect(0, 127487, '\p{^Blk=enclosedalphanumericsupplement}', "");
Expect(0, 127487, '\P{Blk=enclosedalphanumericsupplement}', "");
Expect(1, 127487, '\P{^Blk=enclosedalphanumericsupplement}', "");
Expect(0, 127231, '\p{Blk=enclosedalphanumericsupplement}', "");
Expect(1, 127231, '\p{^Blk=enclosedalphanumericsupplement}', "");
Expect(1, 127231, '\P{Blk=enclosedalphanumericsupplement}', "");
Expect(0, 127231, '\P{^Blk=enclosedalphanumericsupplement}', "");
Expect(1, 127487, '\p{Blk=-	ENCLOSED_Alphanumeric	supplement}', "");
Expect(0, 127487, '\p{^Blk=-	ENCLOSED_Alphanumeric	supplement}', "");
Expect(0, 127487, '\P{Blk=-	ENCLOSED_Alphanumeric	supplement}', "");
Expect(1, 127487, '\P{^Blk=-	ENCLOSED_Alphanumeric	supplement}', "");
Expect(0, 127231, '\p{Blk=-	ENCLOSED_Alphanumeric	supplement}', "");
Expect(1, 127231, '\p{^Blk=-	ENCLOSED_Alphanumeric	supplement}', "");
Expect(1, 127231, '\P{Blk=-	ENCLOSED_Alphanumeric	supplement}', "");
Expect(0, 127231, '\P{^Blk=-	ENCLOSED_Alphanumeric	supplement}', "");
Error('\p{Is_Block= -Enclosed	alphanumeric/a/Supplement}');
Error('\P{Is_Block= -Enclosed	alphanumeric/a/Supplement}');
Expect(1, 127487, '\p{Is_Block=enclosedalphanumericsupplement}', "");
Expect(0, 127487, '\p{^Is_Block=enclosedalphanumericsupplement}', "");
Expect(0, 127487, '\P{Is_Block=enclosedalphanumericsupplement}', "");
Expect(1, 127487, '\P{^Is_Block=enclosedalphanumericsupplement}', "");
Expect(0, 127231, '\p{Is_Block=enclosedalphanumericsupplement}', "");
Expect(1, 127231, '\p{^Is_Block=enclosedalphanumericsupplement}', "");
Expect(1, 127231, '\P{Is_Block=enclosedalphanumericsupplement}', "");
Expect(0, 127231, '\P{^Is_Block=enclosedalphanumericsupplement}', "");
Expect(1, 127487, '\p{Is_Block=	 EnclosedalphanumericSupplement}', "");
Expect(0, 127487, '\p{^Is_Block=	 EnclosedalphanumericSupplement}', "");
Expect(0, 127487, '\P{Is_Block=	 EnclosedalphanumericSupplement}', "");
Expect(1, 127487, '\P{^Is_Block=	 EnclosedalphanumericSupplement}', "");
Expect(0, 127231, '\p{Is_Block=	 EnclosedalphanumericSupplement}', "");
Expect(1, 127231, '\p{^Is_Block=	 EnclosedalphanumericSupplement}', "");
Expect(1, 127231, '\P{Is_Block=	 EnclosedalphanumericSupplement}', "");
Expect(0, 127231, '\P{^Is_Block=	 EnclosedalphanumericSupplement}', "");
Error('\p{Is_Blk=_ENCLOSED:=ALPHANUMERIC-supplement}');
Error('\P{Is_Blk=_ENCLOSED:=ALPHANUMERIC-supplement}');
Expect(1, 127487, '\p{Is_Blk=enclosedalphanumericsupplement}', "");
Expect(0, 127487, '\p{^Is_Blk=enclosedalphanumericsupplement}', "");
Expect(0, 127487, '\P{Is_Blk=enclosedalphanumericsupplement}', "");
Expect(1, 127487, '\P{^Is_Blk=enclosedalphanumericsupplement}', "");
Expect(0, 127231, '\p{Is_Blk=enclosedalphanumericsupplement}', "");
Expect(1, 127231, '\p{^Is_Blk=enclosedalphanumericsupplement}', "");
Expect(1, 127231, '\P{Is_Blk=enclosedalphanumericsupplement}', "");
Expect(0, 127231, '\P{^Is_Blk=enclosedalphanumericsupplement}', "");
Expect(1, 127487, '\p{Is_Blk=enclosed	Alphanumeric_SUPPLEMENT}', "");
Expect(0, 127487, '\p{^Is_Blk=enclosed	Alphanumeric_SUPPLEMENT}', "");
Expect(0, 127487, '\P{Is_Blk=enclosed	Alphanumeric_SUPPLEMENT}', "");
Expect(1, 127487, '\P{^Is_Blk=enclosed	Alphanumeric_SUPPLEMENT}', "");
Expect(0, 127231, '\p{Is_Blk=enclosed	Alphanumeric_SUPPLEMENT}', "");
Expect(1, 127231, '\p{^Is_Blk=enclosed	Alphanumeric_SUPPLEMENT}', "");
Expect(1, 127231, '\P{Is_Blk=enclosed	Alphanumeric_SUPPLEMENT}', "");
Expect(0, 127231, '\P{^Is_Blk=enclosed	Alphanumeric_SUPPLEMENT}', "");
Error('\p{Block:	 Ethiopic_extended/a/}');
Error('\P{Block:	 Ethiopic_extended/a/}');
Expect(1, 11743, '\p{Block=ethiopicextended}', "");
Expect(0, 11743, '\p{^Block=ethiopicextended}', "");
Expect(0, 11743, '\P{Block=ethiopicextended}', "");
Expect(1, 11743, '\P{^Block=ethiopicextended}', "");
Expect(0, 11647, '\p{Block=ethiopicextended}', "");
Expect(1, 11647, '\p{^Block=ethiopicextended}', "");
Expect(1, 11647, '\P{Block=ethiopicextended}', "");
Expect(0, 11647, '\P{^Block=ethiopicextended}', "");
Expect(1, 11743, '\p{Block=_	ETHIOPICExtended}', "");
Expect(0, 11743, '\p{^Block=_	ETHIOPICExtended}', "");
Expect(0, 11743, '\P{Block=_	ETHIOPICExtended}', "");
Expect(1, 11743, '\P{^Block=_	ETHIOPICExtended}', "");
Expect(0, 11647, '\p{Block=_	ETHIOPICExtended}', "");
Expect(1, 11647, '\p{^Block=_	ETHIOPICExtended}', "");
Expect(1, 11647, '\P{Block=_	ETHIOPICExtended}', "");
Expect(0, 11647, '\P{^Block=_	ETHIOPICExtended}', "");
Error('\p{Blk=-/a/ETHIOPIC extended}');
Error('\P{Blk=-/a/ETHIOPIC extended}');
Expect(1, 11743, '\p{Blk=ethiopicextended}', "");
Expect(0, 11743, '\p{^Blk=ethiopicextended}', "");
Expect(0, 11743, '\P{Blk=ethiopicextended}', "");
Expect(1, 11743, '\P{^Blk=ethiopicextended}', "");
Expect(0, 11647, '\p{Blk=ethiopicextended}', "");
Expect(1, 11647, '\p{^Blk=ethiopicextended}', "");
Expect(1, 11647, '\P{Blk=ethiopicextended}', "");
Expect(0, 11647, '\P{^Blk=ethiopicextended}', "");
Expect(1, 11743, '\p{Blk:		ETHIOPIC-Extended}', "");
Expect(0, 11743, '\p{^Blk:		ETHIOPIC-Extended}', "");
Expect(0, 11743, '\P{Blk:		ETHIOPIC-Extended}', "");
Expect(1, 11743, '\P{^Blk:		ETHIOPIC-Extended}', "");
Expect(0, 11647, '\p{Blk:		ETHIOPIC-Extended}', "");
Expect(1, 11647, '\p{^Blk:		ETHIOPIC-Extended}', "");
Expect(1, 11647, '\P{Blk:		ETHIOPIC-Extended}', "");
Expect(0, 11647, '\P{^Blk:		ETHIOPIC-Extended}', "");
Error('\p{Is_Block=-/a/ETHIOPIC_Extended}');
Error('\P{Is_Block=-/a/ETHIOPIC_Extended}');
Expect(1, 11743, '\p{Is_Block=ethiopicextended}', "");
Expect(0, 11743, '\p{^Is_Block=ethiopicextended}', "");
Expect(0, 11743, '\P{Is_Block=ethiopicextended}', "");
Expect(1, 11743, '\P{^Is_Block=ethiopicextended}', "");
Expect(0, 11647, '\p{Is_Block=ethiopicextended}', "");
Expect(1, 11647, '\p{^Is_Block=ethiopicextended}', "");
Expect(1, 11647, '\P{Is_Block=ethiopicextended}', "");
Expect(0, 11647, '\P{^Is_Block=ethiopicextended}', "");
Expect(1, 11743, '\p{Is_Block=--Ethiopic_extended}', "");
Expect(0, 11743, '\p{^Is_Block=--Ethiopic_extended}', "");
Expect(0, 11743, '\P{Is_Block=--Ethiopic_extended}', "");
Expect(1, 11743, '\P{^Is_Block=--Ethiopic_extended}', "");
Expect(0, 11647, '\p{Is_Block=--Ethiopic_extended}', "");
Expect(1, 11647, '\p{^Is_Block=--Ethiopic_extended}', "");
Expect(1, 11647, '\P{Is_Block=--Ethiopic_extended}', "");
Expect(0, 11647, '\P{^Is_Block=--Ethiopic_extended}', "");
Error('\p{Is_Blk=-/a/Ethiopic_extended}');
Error('\P{Is_Blk=-/a/Ethiopic_extended}');
Expect(1, 11743, '\p{Is_Blk=ethiopicextended}', "");
Expect(0, 11743, '\p{^Is_Blk=ethiopicextended}', "");
Expect(0, 11743, '\P{Is_Blk=ethiopicextended}', "");
Expect(1, 11743, '\P{^Is_Blk=ethiopicextended}', "");
Expect(0, 11647, '\p{Is_Blk=ethiopicextended}', "");
Expect(1, 11647, '\p{^Is_Blk=ethiopicextended}', "");
Expect(1, 11647, '\P{Is_Blk=ethiopicextended}', "");
Expect(0, 11647, '\P{^Is_Blk=ethiopicextended}', "");
Expect(1, 11743, '\p{Is_Blk=	ETHIOPIC	Extended}', "");
Expect(0, 11743, '\p{^Is_Blk=	ETHIOPIC	Extended}', "");
Expect(0, 11743, '\P{Is_Blk=	ETHIOPIC	Extended}', "");
Expect(1, 11743, '\P{^Is_Blk=	ETHIOPIC	Extended}', "");
Expect(0, 11647, '\p{Is_Blk=	ETHIOPIC	Extended}', "");
Expect(1, 11647, '\p{^Is_Blk=	ETHIOPIC	Extended}', "");
Expect(1, 11647, '\P{Is_Blk=	ETHIOPIC	Extended}', "");
Expect(0, 11647, '\P{^Is_Blk=	ETHIOPIC	Extended}', "");
Error('\p{Block=_PHOENICIAN/a/}');
Error('\P{Block=_PHOENICIAN/a/}');
Expect(1, 67871, '\p{Block=phoenician}', "");
Expect(0, 67871, '\p{^Block=phoenician}', "");
Expect(0, 67871, '\P{Block=phoenician}', "");
Expect(1, 67871, '\P{^Block=phoenician}', "");
Expect(0, 67839, '\p{Block=phoenician}', "");
Expect(1, 67839, '\p{^Block=phoenician}', "");
Expect(1, 67839, '\P{Block=phoenician}', "");
Expect(0, 67839, '\P{^Block=phoenician}', "");
Expect(1, 67871, '\p{Block= 	Phoenician}', "");
Expect(0, 67871, '\p{^Block= 	Phoenician}', "");
Expect(0, 67871, '\P{Block= 	Phoenician}', "");
Expect(1, 67871, '\P{^Block= 	Phoenician}', "");
Expect(0, 67839, '\p{Block= 	Phoenician}', "");
Expect(1, 67839, '\p{^Block= 	Phoenician}', "");
Expect(1, 67839, '\P{Block= 	Phoenician}', "");
Expect(0, 67839, '\P{^Block= 	Phoenician}', "");
Error('\p{Blk::= PHOENICIAN}');
Error('\P{Blk::= PHOENICIAN}');
Expect(1, 67871, '\p{Blk=phoenician}', "");
Expect(0, 67871, '\p{^Blk=phoenician}', "");
Expect(0, 67871, '\P{Blk=phoenician}', "");
Expect(1, 67871, '\P{^Blk=phoenician}', "");
Expect(0, 67839, '\p{Blk=phoenician}', "");
Expect(1, 67839, '\p{^Blk=phoenician}', "");
Expect(1, 67839, '\P{Blk=phoenician}', "");
Expect(0, 67839, '\P{^Blk=phoenician}', "");
Expect(1, 67871, '\p{Blk=	-Phoenician}', "");
Expect(0, 67871, '\p{^Blk=	-Phoenician}', "");
Expect(0, 67871, '\P{Blk=	-Phoenician}', "");
Expect(1, 67871, '\P{^Blk=	-Phoenician}', "");
Expect(0, 67839, '\p{Blk=	-Phoenician}', "");
Expect(1, 67839, '\p{^Blk=	-Phoenician}', "");
Expect(1, 67839, '\P{Blk=	-Phoenician}', "");
Expect(0, 67839, '\P{^Blk=	-Phoenician}', "");
Error('\p{Is_Block=-	phoenician/a/}');
Error('\P{Is_Block=-	phoenician/a/}');
Expect(1, 67871, '\p{Is_Block=phoenician}', "");
Expect(0, 67871, '\p{^Is_Block=phoenician}', "");
Expect(0, 67871, '\P{Is_Block=phoenician}', "");
Expect(1, 67871, '\P{^Is_Block=phoenician}', "");
Expect(0, 67839, '\p{Is_Block=phoenician}', "");
Expect(1, 67839, '\p{^Is_Block=phoenician}', "");
Expect(1, 67839, '\P{Is_Block=phoenician}', "");
Expect(0, 67839, '\P{^Is_Block=phoenician}', "");
Expect(1, 67871, '\p{Is_Block=_phoenician}', "");
Expect(0, 67871, '\p{^Is_Block=_phoenician}', "");
Expect(0, 67871, '\P{Is_Block=_phoenician}', "");
Expect(1, 67871, '\P{^Is_Block=_phoenician}', "");
Expect(0, 67839, '\p{Is_Block=_phoenician}', "");
Expect(1, 67839, '\p{^Is_Block=_phoenician}', "");
Expect(1, 67839, '\P{Is_Block=_phoenician}', "");
Expect(0, 67839, '\P{^Is_Block=_phoenician}', "");
Error('\p{Is_Blk=/a/	_PHOENICIAN}');
Error('\P{Is_Blk=/a/	_PHOENICIAN}');
Expect(1, 67871, '\p{Is_Blk=phoenician}', "");
Expect(0, 67871, '\p{^Is_Blk=phoenician}', "");
Expect(0, 67871, '\P{Is_Blk=phoenician}', "");
Expect(1, 67871, '\P{^Is_Blk=phoenician}', "");
Expect(0, 67839, '\p{Is_Blk=phoenician}', "");
Expect(1, 67839, '\p{^Is_Blk=phoenician}', "");
Expect(1, 67839, '\P{Is_Blk=phoenician}', "");
Expect(0, 67839, '\P{^Is_Blk=phoenician}', "");
Expect(1, 67871, '\p{Is_Blk=_PHOENICIAN}', "");
Expect(0, 67871, '\p{^Is_Blk=_PHOENICIAN}', "");
Expect(0, 67871, '\P{Is_Blk=_PHOENICIAN}', "");
Expect(1, 67871, '\P{^Is_Blk=_PHOENICIAN}', "");
Expect(0, 67839, '\p{Is_Blk=_PHOENICIAN}', "");
Expect(1, 67839, '\p{^Is_Blk=_PHOENICIAN}', "");
Expect(1, 67839, '\P{Is_Blk=_PHOENICIAN}', "");
Expect(0, 67839, '\P{^Is_Blk=_PHOENICIAN}', "");
Error('\p{Block=:=  Latin	1-supplement}');
Error('\P{Block=:=  Latin	1-supplement}');
Expect(1, 255, '\p{Block=latin1supplement}', "");
Expect(0, 255, '\p{^Block=latin1supplement}', "");
Expect(0, 255, '\P{Block=latin1supplement}', "");
Expect(1, 255, '\P{^Block=latin1supplement}', "");
Expect(0, 127, '\p{Block=latin1supplement}', "");
Expect(1, 127, '\p{^Block=latin1supplement}', "");
Expect(1, 127, '\P{Block=latin1supplement}', "");
Expect(0, 127, '\P{^Block=latin1supplement}', "");
Expect(1, 255, '\p{Block=- Latin 1-Supplement}', "");
Expect(0, 255, '\p{^Block=- Latin 1-Supplement}', "");
Expect(0, 255, '\P{Block=- Latin 1-Supplement}', "");
Expect(1, 255, '\P{^Block=- Latin 1-Supplement}', "");
Expect(0, 127, '\p{Block=- Latin 1-Supplement}', "");
Expect(1, 127, '\p{^Block=- Latin 1-Supplement}', "");
Expect(1, 127, '\P{Block=- Latin 1-Supplement}', "");
Expect(0, 127, '\P{^Block=- Latin 1-Supplement}', "");
Error('\p{Blk=/a/		Latin1}');
Error('\P{Blk=/a/		Latin1}');
Expect(1, 255, '\p{Blk=latin1}', "");
Expect(0, 255, '\p{^Blk=latin1}', "");
Expect(0, 255, '\P{Blk=latin1}', "");
Expect(1, 255, '\P{^Blk=latin1}', "");
Expect(0, 127, '\p{Blk=latin1}', "");
Expect(1, 127, '\p{^Blk=latin1}', "");
Expect(1, 127, '\P{Blk=latin1}', "");
Expect(0, 127, '\P{^Blk=latin1}', "");
Expect(1, 255, '\p{Blk=		latin 1}', "");
Expect(0, 255, '\p{^Blk=		latin 1}', "");
Expect(0, 255, '\P{Blk=		latin 1}', "");
Expect(1, 255, '\P{^Blk=		latin 1}', "");
Expect(0, 127, '\p{Blk=		latin 1}', "");
Expect(1, 127, '\p{^Blk=		latin 1}', "");
Expect(1, 127, '\P{Blk=		latin 1}', "");
Expect(0, 127, '\P{^Blk=		latin 1}', "");
Error('\p{Is_Block= :=latin	1-SUPPLEMENT}');
Error('\P{Is_Block= :=latin	1-SUPPLEMENT}');
Expect(1, 255, '\p{Is_Block=latin1supplement}', "");
Expect(0, 255, '\p{^Is_Block=latin1supplement}', "");
Expect(0, 255, '\P{Is_Block=latin1supplement}', "");
Expect(1, 255, '\P{^Is_Block=latin1supplement}', "");
Expect(0, 127, '\p{Is_Block=latin1supplement}', "");
Expect(1, 127, '\p{^Is_Block=latin1supplement}', "");
Expect(1, 127, '\P{Is_Block=latin1supplement}', "");
Expect(0, 127, '\P{^Is_Block=latin1supplement}', "");
Expect(1, 255, '\p{Is_Block=-latin1supplement}', "");
Expect(0, 255, '\p{^Is_Block=-latin1supplement}', "");
Expect(0, 255, '\P{Is_Block=-latin1supplement}', "");
Expect(1, 255, '\P{^Is_Block=-latin1supplement}', "");
Expect(0, 127, '\p{Is_Block=-latin1supplement}', "");
Expect(1, 127, '\p{^Is_Block=-latin1supplement}', "");
Expect(1, 127, '\P{Is_Block=-latin1supplement}', "");
Expect(0, 127, '\P{^Is_Block=-latin1supplement}', "");
Error('\p{Is_Blk=  LATIN:=1}');
Error('\P{Is_Blk=  LATIN:=1}');
Expect(1, 255, '\p{Is_Blk=latin1}', "");
Expect(0, 255, '\p{^Is_Blk=latin1}', "");
Expect(0, 255, '\P{Is_Blk=latin1}', "");
Expect(1, 255, '\P{^Is_Blk=latin1}', "");
Expect(0, 127, '\p{Is_Blk=latin1}', "");
Expect(1, 127, '\p{^Is_Blk=latin1}', "");
Expect(1, 127, '\P{Is_Blk=latin1}', "");
Expect(0, 127, '\P{^Is_Blk=latin1}', "");
Expect(1, 255, '\p{Is_Blk=__Latin 1}', "");
Expect(0, 255, '\p{^Is_Blk=__Latin 1}', "");
Expect(0, 255, '\P{Is_Blk=__Latin 1}', "");
Expect(1, 255, '\P{^Is_Blk=__Latin 1}', "");
Expect(0, 127, '\p{Is_Blk=__Latin 1}', "");
Expect(1, 127, '\p{^Is_Blk=__Latin 1}', "");
Expect(1, 127, '\P{Is_Blk=__Latin 1}', "");
Expect(0, 127, '\P{^Is_Blk=__Latin 1}', "");
Error('\p{Block:	 Devanagari/a/}');
Error('\P{Block:	 Devanagari/a/}');
Expect(1, 2431, '\p{Block=devanagari}', "");
Expect(0, 2431, '\p{^Block=devanagari}', "");
Expect(0, 2431, '\P{Block=devanagari}', "");
Expect(1, 2431, '\P{^Block=devanagari}', "");
Expect(0, 2303, '\p{Block=devanagari}', "");
Expect(1, 2303, '\p{^Block=devanagari}', "");
Expect(1, 2303, '\P{Block=devanagari}', "");
Expect(0, 2303, '\P{^Block=devanagari}', "");
Expect(1, 2431, '\p{Block=Devanagari}', "");
Expect(0, 2431, '\p{^Block=Devanagari}', "");
Expect(0, 2431, '\P{Block=Devanagari}', "");
Expect(1, 2431, '\P{^Block=Devanagari}', "");
Expect(0, 2303, '\p{Block=Devanagari}', "");
Expect(1, 2303, '\p{^Block=Devanagari}', "");
Expect(1, 2303, '\P{Block=Devanagari}', "");
Expect(0, 2303, '\P{^Block=Devanagari}', "");
Error('\p{Blk=/a/-DEVANAGARI}');
Error('\P{Blk=/a/-DEVANAGARI}');
Expect(1, 2431, '\p{Blk=devanagari}', "");
Expect(0, 2431, '\p{^Blk=devanagari}', "");
Expect(0, 2431, '\P{Blk=devanagari}', "");
Expect(1, 2431, '\P{^Blk=devanagari}', "");
Expect(0, 2303, '\p{Blk=devanagari}', "");
Expect(1, 2303, '\p{^Blk=devanagari}', "");
Expect(1, 2303, '\P{Blk=devanagari}', "");
Expect(0, 2303, '\P{^Blk=devanagari}', "");
Expect(1, 2431, '\p{Blk=- Devanagari}', "");
Expect(0, 2431, '\p{^Blk=- Devanagari}', "");
Expect(0, 2431, '\P{Blk=- Devanagari}', "");
Expect(1, 2431, '\P{^Blk=- Devanagari}', "");
Expect(0, 2303, '\p{Blk=- Devanagari}', "");
Expect(1, 2303, '\p{^Blk=- Devanagari}', "");
Expect(1, 2303, '\P{Blk=- Devanagari}', "");
Expect(0, 2303, '\P{^Blk=- Devanagari}', "");
Error('\p{Is_Block= 	devanagari:=}');
Error('\P{Is_Block= 	devanagari:=}');
Expect(1, 2431, '\p{Is_Block:   devanagari}', "");
Expect(0, 2431, '\p{^Is_Block:   devanagari}', "");
Expect(0, 2431, '\P{Is_Block:   devanagari}', "");
Expect(1, 2431, '\P{^Is_Block:   devanagari}', "");
Expect(0, 2303, '\p{Is_Block:   devanagari}', "");
Expect(1, 2303, '\p{^Is_Block:   devanagari}', "");
Expect(1, 2303, '\P{Is_Block:   devanagari}', "");
Expect(0, 2303, '\P{^Is_Block:   devanagari}', "");
Expect(1, 2431, '\p{Is_Block: 	Devanagari}', "");
Expect(0, 2431, '\p{^Is_Block: 	Devanagari}', "");
Expect(0, 2431, '\P{Is_Block: 	Devanagari}', "");
Expect(1, 2431, '\P{^Is_Block: 	Devanagari}', "");
Expect(0, 2303, '\p{Is_Block: 	Devanagari}', "");
Expect(1, 2303, '\p{^Is_Block: 	Devanagari}', "");
Expect(1, 2303, '\P{Is_Block: 	Devanagari}', "");
Expect(0, 2303, '\P{^Is_Block: 	Devanagari}', "");
Error('\p{Is_Blk=/a/-Devanagari}');
Error('\P{Is_Blk=/a/-Devanagari}');
Expect(1, 2431, '\p{Is_Blk=devanagari}', "");
Expect(0, 2431, '\p{^Is_Blk=devanagari}', "");
Expect(0, 2431, '\P{Is_Blk=devanagari}', "");
Expect(1, 2431, '\P{^Is_Blk=devanagari}', "");
Expect(0, 2303, '\p{Is_Blk=devanagari}', "");
Expect(1, 2303, '\p{^Is_Blk=devanagari}', "");
Expect(1, 2303, '\P{Is_Blk=devanagari}', "");
Expect(0, 2303, '\P{^Is_Blk=devanagari}', "");
Expect(1, 2431, '\p{Is_Blk= DEVANAGARI}', "");
Expect(0, 2431, '\p{^Is_Blk= DEVANAGARI}', "");
Expect(0, 2431, '\P{Is_Blk= DEVANAGARI}', "");
Expect(1, 2431, '\P{^Is_Blk= DEVANAGARI}', "");
Expect(0, 2303, '\p{Is_Blk= DEVANAGARI}', "");
Expect(1, 2303, '\p{^Is_Blk= DEVANAGARI}', "");
Expect(1, 2303, '\P{Is_Blk= DEVANAGARI}', "");
Expect(0, 2303, '\P{^Is_Blk= DEVANAGARI}', "");
Error('\p{Block:   __HANGULJamo	EXTENDED-A:=}');
Error('\P{Block:   __HANGULJamo	EXTENDED-A:=}');
Expect(1, 43391, '\p{Block=hanguljamoextendeda}', "");
Expect(0, 43391, '\p{^Block=hanguljamoextendeda}', "");
Expect(0, 43391, '\P{Block=hanguljamoextendeda}', "");
Expect(1, 43391, '\P{^Block=hanguljamoextendeda}', "");
Expect(0, 43359, '\p{Block=hanguljamoextendeda}', "");
Expect(1, 43359, '\p{^Block=hanguljamoextendeda}', "");
Expect(1, 43359, '\P{Block=hanguljamoextendeda}', "");
Expect(0, 43359, '\P{^Block=hanguljamoextendeda}', "");
Expect(1, 43391, '\p{Block= 	Hangul_Jamo	extended a}', "");
Expect(0, 43391, '\p{^Block= 	Hangul_Jamo	extended a}', "");
Expect(0, 43391, '\P{Block= 	Hangul_Jamo	extended a}', "");
Expect(1, 43391, '\P{^Block= 	Hangul_Jamo	extended a}', "");
Expect(0, 43359, '\p{Block= 	Hangul_Jamo	extended a}', "");
Expect(1, 43359, '\p{^Block= 	Hangul_Jamo	extended a}', "");
Expect(1, 43359, '\P{Block= 	Hangul_Jamo	extended a}', "");
Expect(0, 43359, '\P{^Block= 	Hangul_Jamo	extended a}', "");
Error('\p{Blk= HANGUL	JAMO	Extended_A:=}');
Error('\P{Blk= HANGUL	JAMO	Extended_A:=}');
Expect(1, 43391, '\p{Blk=hanguljamoextendeda}', "");
Expect(0, 43391, '\p{^Blk=hanguljamoextendeda}', "");
Expect(0, 43391, '\P{Blk=hanguljamoextendeda}', "");
Expect(1, 43391, '\P{^Blk=hanguljamoextendeda}', "");
Expect(0, 43359, '\p{Blk=hanguljamoextendeda}', "");
Expect(1, 43359, '\p{^Blk=hanguljamoextendeda}', "");
Expect(1, 43359, '\P{Blk=hanguljamoextendeda}', "");
Expect(0, 43359, '\P{^Blk=hanguljamoextendeda}', "");
Expect(1, 43391, '\p{Blk= 	hangul-JAMO EXTENDED_A}', "");
Expect(0, 43391, '\p{^Blk= 	hangul-JAMO EXTENDED_A}', "");
Expect(0, 43391, '\P{Blk= 	hangul-JAMO EXTENDED_A}', "");
Expect(1, 43391, '\P{^Blk= 	hangul-JAMO EXTENDED_A}', "");
Expect(0, 43359, '\p{Blk= 	hangul-JAMO EXTENDED_A}', "");
Expect(1, 43359, '\p{^Blk= 	hangul-JAMO EXTENDED_A}', "");
Expect(1, 43359, '\P{Blk= 	hangul-JAMO EXTENDED_A}', "");
Expect(0, 43359, '\P{^Blk= 	hangul-JAMO EXTENDED_A}', "");
Error('\p{Is_Block= 	HANGULJAMO	Extended-A:=}');
Error('\P{Is_Block= 	HANGULJAMO	Extended-A:=}');
Expect(1, 43391, '\p{Is_Block=hanguljamoextendeda}', "");
Expect(0, 43391, '\p{^Is_Block=hanguljamoextendeda}', "");
Expect(0, 43391, '\P{Is_Block=hanguljamoextendeda}', "");
Expect(1, 43391, '\P{^Is_Block=hanguljamoextendeda}', "");
Expect(0, 43359, '\p{Is_Block=hanguljamoextendeda}', "");
Expect(1, 43359, '\p{^Is_Block=hanguljamoextendeda}', "");
Expect(1, 43359, '\P{Is_Block=hanguljamoextendeda}', "");
Expect(0, 43359, '\P{^Is_Block=hanguljamoextendeda}', "");
Expect(1, 43391, '\p{Is_Block=	hangul jamo	extended	a}', "");
Expect(0, 43391, '\p{^Is_Block=	hangul jamo	extended	a}', "");
Expect(0, 43391, '\P{Is_Block=	hangul jamo	extended	a}', "");
Expect(1, 43391, '\P{^Is_Block=	hangul jamo	extended	a}', "");
Expect(0, 43359, '\p{Is_Block=	hangul jamo	extended	a}', "");
Expect(1, 43359, '\p{^Is_Block=	hangul jamo	extended	a}', "");
Expect(1, 43359, '\P{Is_Block=	hangul jamo	extended	a}', "");
Expect(0, 43359, '\P{^Is_Block=	hangul jamo	extended	a}', "");
Error('\p{Is_Blk=- HangulJamo_EXTENDED/a/a}');
Error('\P{Is_Blk=- HangulJamo_EXTENDED/a/a}');
Expect(1, 43391, '\p{Is_Blk=hanguljamoextendeda}', "");
Expect(0, 43391, '\p{^Is_Blk=hanguljamoextendeda}', "");
Expect(0, 43391, '\P{Is_Blk=hanguljamoextendeda}', "");
Expect(1, 43391, '\P{^Is_Blk=hanguljamoextendeda}', "");
Expect(0, 43359, '\p{Is_Blk=hanguljamoextendeda}', "");
Expect(1, 43359, '\p{^Is_Blk=hanguljamoextendeda}', "");
Expect(1, 43359, '\P{Is_Blk=hanguljamoextendeda}', "");
Expect(0, 43359, '\P{^Is_Blk=hanguljamoextendeda}', "");
Expect(1, 43391, '\p{Is_Blk= 	Hangul	Jamo EXTENDED A}', "");
Expect(0, 43391, '\p{^Is_Blk= 	Hangul	Jamo EXTENDED A}', "");
Expect(0, 43391, '\P{Is_Blk= 	Hangul	Jamo EXTENDED A}', "");
Expect(1, 43391, '\P{^Is_Blk= 	Hangul	Jamo EXTENDED A}', "");
Expect(0, 43359, '\p{Is_Blk= 	Hangul	Jamo EXTENDED A}', "");
Expect(1, 43359, '\p{^Is_Blk= 	Hangul	Jamo EXTENDED A}', "");
Expect(1, 43359, '\P{Is_Blk= 	Hangul	Jamo EXTENDED A}', "");
Expect(0, 43359, '\P{^Is_Blk= 	Hangul	Jamo EXTENDED A}', "");
Error('\p{Block=:=Carian}');
Error('\P{Block=:=Carian}');
Expect(1, 66271, '\p{Block=carian}', "");
Expect(0, 66271, '\p{^Block=carian}', "");
Expect(0, 66271, '\P{Block=carian}', "");
Expect(1, 66271, '\P{^Block=carian}', "");
Expect(0, 66207, '\p{Block=carian}', "");
Expect(1, 66207, '\p{^Block=carian}', "");
Expect(1, 66207, '\P{Block=carian}', "");
Expect(0, 66207, '\P{^Block=carian}', "");
Expect(1, 66271, '\p{Block=  CARIAN}', "");
Expect(0, 66271, '\p{^Block=  CARIAN}', "");
Expect(0, 66271, '\P{Block=  CARIAN}', "");
Expect(1, 66271, '\P{^Block=  CARIAN}', "");
Expect(0, 66207, '\p{Block=  CARIAN}', "");
Expect(1, 66207, '\p{^Block=  CARIAN}', "");
Expect(1, 66207, '\P{Block=  CARIAN}', "");
Expect(0, 66207, '\P{^Block=  CARIAN}', "");
Error('\p{Blk=	 Carian/a/}');
Error('\P{Blk=	 Carian/a/}');
Expect(1, 66271, '\p{Blk=carian}', "");
Expect(0, 66271, '\p{^Blk=carian}', "");
Expect(0, 66271, '\P{Blk=carian}', "");
Expect(1, 66271, '\P{^Blk=carian}', "");
Expect(0, 66207, '\p{Blk=carian}', "");
Expect(1, 66207, '\p{^Blk=carian}', "");
Expect(1, 66207, '\P{Blk=carian}', "");
Expect(0, 66207, '\P{^Blk=carian}', "");
Expect(1, 66271, '\p{Blk=	Carian}', "");
Expect(0, 66271, '\p{^Blk=	Carian}', "");
Expect(0, 66271, '\P{Blk=	Carian}', "");
Expect(1, 66271, '\P{^Blk=	Carian}', "");
Expect(0, 66207, '\p{Blk=	Carian}', "");
Expect(1, 66207, '\p{^Blk=	Carian}', "");
Expect(1, 66207, '\P{Blk=	Carian}', "");
Expect(0, 66207, '\P{^Blk=	Carian}', "");
Error('\p{Is_Block=:= Carian}');
Error('\P{Is_Block=:= Carian}');
Expect(1, 66271, '\p{Is_Block:carian}', "");
Expect(0, 66271, '\p{^Is_Block:carian}', "");
Expect(0, 66271, '\P{Is_Block:carian}', "");
Expect(1, 66271, '\P{^Is_Block:carian}', "");
Expect(0, 66207, '\p{Is_Block:carian}', "");
Expect(1, 66207, '\p{^Is_Block:carian}', "");
Expect(1, 66207, '\P{Is_Block:carian}', "");
Expect(0, 66207, '\P{^Is_Block:carian}', "");
Expect(1, 66271, '\p{Is_Block=	 CARIAN}', "");
Expect(0, 66271, '\p{^Is_Block=	 CARIAN}', "");
Expect(0, 66271, '\P{Is_Block=	 CARIAN}', "");
Expect(1, 66271, '\P{^Is_Block=	 CARIAN}', "");
Expect(0, 66207, '\p{Is_Block=	 CARIAN}', "");
Expect(1, 66207, '\p{^Is_Block=	 CARIAN}', "");
Expect(1, 66207, '\P{Is_Block=	 CARIAN}', "");
Expect(0, 66207, '\P{^Is_Block=	 CARIAN}', "");
Error('\p{Is_Blk:    /a/carian}');
Error('\P{Is_Blk:    /a/carian}');
Expect(1, 66271, '\p{Is_Blk=carian}', "");
Expect(0, 66271, '\p{^Is_Blk=carian}', "");
Expect(0, 66271, '\P{Is_Blk=carian}', "");
Expect(1, 66271, '\P{^Is_Blk=carian}', "");
Expect(0, 66207, '\p{Is_Blk=carian}', "");
Expect(1, 66207, '\p{^Is_Blk=carian}', "");
Expect(1, 66207, '\P{Is_Blk=carian}', "");
Expect(0, 66207, '\P{^Is_Blk=carian}', "");
Expect(1, 66271, '\p{Is_Blk=-_CARIAN}', "");
Expect(0, 66271, '\p{^Is_Blk=-_CARIAN}', "");
Expect(0, 66271, '\P{Is_Blk=-_CARIAN}', "");
Expect(1, 66271, '\P{^Is_Blk=-_CARIAN}', "");
Expect(0, 66207, '\p{Is_Blk=-_CARIAN}', "");
Expect(1, 66207, '\p{^Is_Blk=-_CARIAN}', "");
Expect(1, 66207, '\P{Is_Blk=-_CARIAN}', "");
Expect(0, 66207, '\P{^Is_Blk=-_CARIAN}', "");
Error('\p{Block=_/a/BUHID}');
Error('\P{Block=_/a/BUHID}');
Expect(1, 5983, '\p{Block=buhid}', "");
Expect(0, 5983, '\p{^Block=buhid}', "");
Expect(0, 5983, '\P{Block=buhid}', "");
Expect(1, 5983, '\P{^Block=buhid}', "");
Expect(0, 5951, '\p{Block=buhid}', "");
Expect(1, 5951, '\p{^Block=buhid}', "");
Expect(1, 5951, '\P{Block=buhid}', "");
Expect(0, 5951, '\P{^Block=buhid}', "");
Expect(1, 5983, '\p{Block=_Buhid}', "");
Expect(0, 5983, '\p{^Block=_Buhid}', "");
Expect(0, 5983, '\P{Block=_Buhid}', "");
Expect(1, 5983, '\P{^Block=_Buhid}', "");
Expect(0, 5951, '\p{Block=_Buhid}', "");
Expect(1, 5951, '\p{^Block=_Buhid}', "");
Expect(1, 5951, '\P{Block=_Buhid}', "");
Expect(0, 5951, '\P{^Block=_Buhid}', "");
Error('\p{Blk=_-Buhid/a/}');
Error('\P{Blk=_-Buhid/a/}');
Expect(1, 5983, '\p{Blk=buhid}', "");
Expect(0, 5983, '\p{^Blk=buhid}', "");
Expect(0, 5983, '\P{Blk=buhid}', "");
Expect(1, 5983, '\P{^Blk=buhid}', "");
Expect(0, 5951, '\p{Blk=buhid}', "");
Expect(1, 5951, '\p{^Blk=buhid}', "");
Expect(1, 5951, '\P{Blk=buhid}', "");
Expect(0, 5951, '\P{^Blk=buhid}', "");
Expect(1, 5983, '\p{Blk=  Buhid}', "");
Expect(0, 5983, '\p{^Blk=  Buhid}', "");
Expect(0, 5983, '\P{Blk=  Buhid}', "");
Expect(1, 5983, '\P{^Blk=  Buhid}', "");
Expect(0, 5951, '\p{Blk=  Buhid}', "");
Expect(1, 5951, '\p{^Blk=  Buhid}', "");
Expect(1, 5951, '\P{Blk=  Buhid}', "");
Expect(0, 5951, '\P{^Blk=  Buhid}', "");
Error('\p{Is_Block=/a/Buhid}');
Error('\P{Is_Block=/a/Buhid}');
Expect(1, 5983, '\p{Is_Block=buhid}', "");
Expect(0, 5983, '\p{^Is_Block=buhid}', "");
Expect(0, 5983, '\P{Is_Block=buhid}', "");
Expect(1, 5983, '\P{^Is_Block=buhid}', "");
Expect(0, 5951, '\p{Is_Block=buhid}', "");
Expect(1, 5951, '\p{^Is_Block=buhid}', "");
Expect(1, 5951, '\P{Is_Block=buhid}', "");
Expect(0, 5951, '\P{^Is_Block=buhid}', "");
Expect(1, 5983, '\p{Is_Block= Buhid}', "");
Expect(0, 5983, '\p{^Is_Block= Buhid}', "");
Expect(0, 5983, '\P{Is_Block= Buhid}', "");
Expect(1, 5983, '\P{^Is_Block= Buhid}', "");
Expect(0, 5951, '\p{Is_Block= Buhid}', "");
Expect(1, 5951, '\p{^Is_Block= Buhid}', "");
Expect(1, 5951, '\P{Is_Block= Buhid}', "");
Expect(0, 5951, '\P{^Is_Block= Buhid}', "");
Error('\p{Is_Blk=:= _buhid}');
Error('\P{Is_Blk=:= _buhid}');
Expect(1, 5983, '\p{Is_Blk=buhid}', "");
Expect(0, 5983, '\p{^Is_Blk=buhid}', "");
Expect(0, 5983, '\P{Is_Blk=buhid}', "");
Expect(1, 5983, '\P{^Is_Blk=buhid}', "");
Expect(0, 5951, '\p{Is_Blk=buhid}', "");
Expect(1, 5951, '\p{^Is_Blk=buhid}', "");
Expect(1, 5951, '\P{Is_Blk=buhid}', "");
Expect(0, 5951, '\P{^Is_Blk=buhid}', "");
Expect(1, 5983, '\p{Is_Blk=	_buhid}', "");
Expect(0, 5983, '\p{^Is_Blk=	_buhid}', "");
Expect(0, 5983, '\P{Is_Blk=	_buhid}', "");
Expect(1, 5983, '\P{^Is_Blk=	_buhid}', "");
Expect(0, 5951, '\p{Is_Blk=	_buhid}', "");
Expect(1, 5951, '\p{^Is_Blk=	_buhid}', "");
Expect(1, 5951, '\P{Is_Blk=	_buhid}', "");
Expect(0, 5951, '\P{^Is_Blk=	_buhid}', "");
Error('\p{Block=:=-Ideographic DescriptionCharacters}');
Error('\P{Block=:=-Ideographic DescriptionCharacters}');
Expect(1, 12287, '\p{Block=ideographicdescriptioncharacters}', "");
Expect(0, 12287, '\p{^Block=ideographicdescriptioncharacters}', "");
Expect(0, 12287, '\P{Block=ideographicdescriptioncharacters}', "");
Expect(1, 12287, '\P{^Block=ideographicdescriptioncharacters}', "");
Expect(0, 12271, '\p{Block=ideographicdescriptioncharacters}', "");
Expect(1, 12271, '\p{^Block=ideographicdescriptioncharacters}', "");
Expect(1, 12271, '\P{Block=ideographicdescriptioncharacters}', "");
Expect(0, 12271, '\P{^Block=ideographicdescriptioncharacters}', "");
Expect(1, 12287, '\p{Block=  Ideographic	Description	Characters}', "");
Expect(0, 12287, '\p{^Block=  Ideographic	Description	Characters}', "");
Expect(0, 12287, '\P{Block=  Ideographic	Description	Characters}', "");
Expect(1, 12287, '\P{^Block=  Ideographic	Description	Characters}', "");
Expect(0, 12271, '\p{Block=  Ideographic	Description	Characters}', "");
Expect(1, 12271, '\p{^Block=  Ideographic	Description	Characters}', "");
Expect(1, 12271, '\P{Block=  Ideographic	Description	Characters}', "");
Expect(0, 12271, '\P{^Block=  Ideographic	Description	Characters}', "");
Error('\p{Blk=-_ideographic_Descriptioncharacters/a/}');
Error('\P{Blk=-_ideographic_Descriptioncharacters/a/}');
Expect(1, 12287, '\p{Blk:   ideographicdescriptioncharacters}', "");
Expect(0, 12287, '\p{^Blk:   ideographicdescriptioncharacters}', "");
Expect(0, 12287, '\P{Blk:   ideographicdescriptioncharacters}', "");
Expect(1, 12287, '\P{^Blk:   ideographicdescriptioncharacters}', "");
Expect(0, 12271, '\p{Blk:   ideographicdescriptioncharacters}', "");
Expect(1, 12271, '\p{^Blk:   ideographicdescriptioncharacters}', "");
Expect(1, 12271, '\P{Blk:   ideographicdescriptioncharacters}', "");
Expect(0, 12271, '\P{^Blk:   ideographicdescriptioncharacters}', "");
Expect(1, 12287, '\p{Blk=	-Ideographic description Characters}', "");
Expect(0, 12287, '\p{^Blk=	-Ideographic description Characters}', "");
Expect(0, 12287, '\P{Blk=	-Ideographic description Characters}', "");
Expect(1, 12287, '\P{^Blk=	-Ideographic description Characters}', "");
Expect(0, 12271, '\p{Blk=	-Ideographic description Characters}', "");
Expect(1, 12271, '\p{^Blk=	-Ideographic description Characters}', "");
Expect(1, 12271, '\P{Blk=	-Ideographic description Characters}', "");
Expect(0, 12271, '\P{^Blk=	-Ideographic description Characters}', "");
Error('\p{Is_Block=/a/  IDEOGRAPHIC_Description	Characters}');
Error('\P{Is_Block=/a/  IDEOGRAPHIC_Description	Characters}');
Expect(1, 12287, '\p{Is_Block: ideographicdescriptioncharacters}', "");
Expect(0, 12287, '\p{^Is_Block: ideographicdescriptioncharacters}', "");
Expect(0, 12287, '\P{Is_Block: ideographicdescriptioncharacters}', "");
Expect(1, 12287, '\P{^Is_Block: ideographicdescriptioncharacters}', "");
Expect(0, 12271, '\p{Is_Block: ideographicdescriptioncharacters}', "");
Expect(1, 12271, '\p{^Is_Block: ideographicdescriptioncharacters}', "");
Expect(1, 12271, '\P{Is_Block: ideographicdescriptioncharacters}', "");
Expect(0, 12271, '\P{^Is_Block: ideographicdescriptioncharacters}', "");
Expect(1, 12287, '\p{Is_Block:	-Ideographic descriptioncharacters}', "");
Expect(0, 12287, '\p{^Is_Block:	-Ideographic descriptioncharacters}', "");
Expect(0, 12287, '\P{Is_Block:	-Ideographic descriptioncharacters}', "");
Expect(1, 12287, '\P{^Is_Block:	-Ideographic descriptioncharacters}', "");
Expect(0, 12271, '\p{Is_Block:	-Ideographic descriptioncharacters}', "");
Expect(1, 12271, '\p{^Is_Block:	-Ideographic descriptioncharacters}', "");
Expect(1, 12271, '\P{Is_Block:	-Ideographic descriptioncharacters}', "");
Expect(0, 12271, '\P{^Is_Block:	-Ideographic descriptioncharacters}', "");
Error('\p{Is_Blk=:= 	IDEOGRAPHIC_Descriptioncharacters}');
Error('\P{Is_Blk=:= 	IDEOGRAPHIC_Descriptioncharacters}');
Expect(1, 12287, '\p{Is_Blk:   ideographicdescriptioncharacters}', "");
Expect(0, 12287, '\p{^Is_Blk:   ideographicdescriptioncharacters}', "");
Expect(0, 12287, '\P{Is_Blk:   ideographicdescriptioncharacters}', "");
Expect(1, 12287, '\P{^Is_Blk:   ideographicdescriptioncharacters}', "");
Expect(0, 12271, '\p{Is_Blk:   ideographicdescriptioncharacters}', "");
Expect(1, 12271, '\p{^Is_Blk:   ideographicdescriptioncharacters}', "");
Expect(1, 12271, '\P{Is_Blk:   ideographicdescriptioncharacters}', "");
Expect(0, 12271, '\P{^Is_Blk:   ideographicdescriptioncharacters}', "");
Expect(1, 12287, '\p{Is_Blk=_	IDEOGRAPHIC	Description_Characters}', "");
Expect(0, 12287, '\p{^Is_Blk=_	IDEOGRAPHIC	Description_Characters}', "");
Expect(0, 12287, '\P{Is_Blk=_	IDEOGRAPHIC	Description_Characters}', "");
Expect(1, 12287, '\P{^Is_Blk=_	IDEOGRAPHIC	Description_Characters}', "");
Expect(0, 12271, '\p{Is_Blk=_	IDEOGRAPHIC	Description_Characters}', "");
Expect(1, 12271, '\p{^Is_Blk=_	IDEOGRAPHIC	Description_Characters}', "");
Expect(1, 12271, '\P{Is_Blk=_	IDEOGRAPHIC	Description_Characters}', "");
Expect(0, 12271, '\P{^Is_Blk=_	IDEOGRAPHIC	Description_Characters}', "");
Error('\p{Block:CJK_Unified/a/IDEOGRAPHS	Extension_B}');
Error('\P{Block:CJK_Unified/a/IDEOGRAPHS	Extension_B}');
Expect(1, 173791, '\p{Block=cjkunifiedideographsextensionb}', "");
Expect(0, 173791, '\p{^Block=cjkunifiedideographsextensionb}', "");
Expect(0, 173791, '\P{Block=cjkunifiedideographsextensionb}', "");
Expect(1, 173791, '\P{^Block=cjkunifiedideographsextensionb}', "");
Expect(0, 1, '\p{Block=cjkunifiedideographsextensionb}', "");
Expect(1, 1, '\p{^Block=cjkunifiedideographsextensionb}', "");
Expect(1, 1, '\P{Block=cjkunifiedideographsextensionb}', "");
Expect(0, 1, '\P{^Block=cjkunifiedideographsextensionb}', "");
Expect(1, 173791, '\p{Block=	CJKUNIFIEDIdeographsExtension B}', "");
Expect(0, 173791, '\p{^Block=	CJKUNIFIEDIdeographsExtension B}', "");
Expect(0, 173791, '\P{Block=	CJKUNIFIEDIdeographsExtension B}', "");
Expect(1, 173791, '\P{^Block=	CJKUNIFIEDIdeographsExtension B}', "");
Expect(0, 1, '\p{Block=	CJKUNIFIEDIdeographsExtension B}', "");
Expect(1, 1, '\p{^Block=	CJKUNIFIEDIdeographsExtension B}', "");
Expect(1, 1, '\P{Block=	CJKUNIFIEDIdeographsExtension B}', "");
Expect(0, 1, '\P{^Block=	CJKUNIFIEDIdeographsExtension B}', "");
Error('\p{Blk= :=CJK Unified_IDEOGRAPHS Extension-B}');
Error('\P{Blk= :=CJK Unified_IDEOGRAPHS Extension-B}');
Expect(1, 173791, '\p{Blk=cjkunifiedideographsextensionb}', "");
Expect(0, 173791, '\p{^Blk=cjkunifiedideographsextensionb}', "");
Expect(0, 173791, '\P{Blk=cjkunifiedideographsextensionb}', "");
Expect(1, 173791, '\P{^Blk=cjkunifiedideographsextensionb}', "");
Expect(0, 1, '\p{Blk=cjkunifiedideographsextensionb}', "");
Expect(1, 1, '\p{^Blk=cjkunifiedideographsextensionb}', "");
Expect(1, 1, '\P{Blk=cjkunifiedideographsextensionb}', "");
Expect(0, 1, '\P{^Blk=cjkunifiedideographsextensionb}', "");
Expect(1, 173791, '\p{Blk=__CJK	Unified ideographsEXTENSIONB}', "");
Expect(0, 173791, '\p{^Blk=__CJK	Unified ideographsEXTENSIONB}', "");
Expect(0, 173791, '\P{Blk=__CJK	Unified ideographsEXTENSIONB}', "");
Expect(1, 173791, '\P{^Blk=__CJK	Unified ideographsEXTENSIONB}', "");
Expect(0, 1, '\p{Blk=__CJK	Unified ideographsEXTENSIONB}', "");
Expect(1, 1, '\p{^Blk=__CJK	Unified ideographsEXTENSIONB}', "");
Expect(1, 1, '\P{Blk=__CJK	Unified ideographsEXTENSIONB}', "");
Expect(0, 1, '\P{^Blk=__CJK	Unified ideographsEXTENSIONB}', "");
Error('\p{Is_Block:  	CJK/a/Unified-Ideographs_Extension-B}');
Error('\P{Is_Block:  	CJK/a/Unified-Ideographs_Extension-B}');
Expect(1, 173791, '\p{Is_Block=cjkunifiedideographsextensionb}', "");
Expect(0, 173791, '\p{^Is_Block=cjkunifiedideographsextensionb}', "");
Expect(0, 173791, '\P{Is_Block=cjkunifiedideographsextensionb}', "");
Expect(1, 173791, '\P{^Is_Block=cjkunifiedideographsextensionb}', "");
Expect(0, 1, '\p{Is_Block=cjkunifiedideographsextensionb}', "");
Expect(1, 1, '\p{^Is_Block=cjkunifiedideographsextensionb}', "");
Expect(1, 1, '\P{Is_Block=cjkunifiedideographsextensionb}', "");
Expect(0, 1, '\P{^Is_Block=cjkunifiedideographsextensionb}', "");
Expect(1, 173791, '\p{Is_Block=	CJK-Unified_Ideographs_Extension b}', "");
Expect(0, 173791, '\p{^Is_Block=	CJK-Unified_Ideographs_Extension b}', "");
Expect(0, 173791, '\P{Is_Block=	CJK-Unified_Ideographs_Extension b}', "");
Expect(1, 173791, '\P{^Is_Block=	CJK-Unified_Ideographs_Extension b}', "");
Expect(0, 1, '\p{Is_Block=	CJK-Unified_Ideographs_Extension b}', "");
Expect(1, 1, '\p{^Is_Block=	CJK-Unified_Ideographs_Extension b}', "");
Expect(1, 1, '\P{Is_Block=	CJK-Unified_Ideographs_Extension b}', "");
Expect(0, 1, '\P{^Is_Block=	CJK-Unified_Ideographs_Extension b}', "");
Error('\p{Is_Blk=	_CJK_UNIFIED_Ideographs_ExtensionB:=}');
Error('\P{Is_Blk=	_CJK_UNIFIED_Ideographs_ExtensionB:=}');
Expect(1, 173791, '\p{Is_Blk=cjkunifiedideographsextensionb}', "");
Expect(0, 173791, '\p{^Is_Blk=cjkunifiedideographsextensionb}', "");
Expect(0, 173791, '\P{Is_Blk=cjkunifiedideographsextensionb}', "");
Expect(1, 173791, '\P{^Is_Blk=cjkunifiedideographsextensionb}', "");
Expect(0, 1, '\p{Is_Blk=cjkunifiedideographsextensionb}', "");
Expect(1, 1, '\p{^Is_Blk=cjkunifiedideographsextensionb}', "");
Expect(1, 1, '\P{Is_Blk=cjkunifiedideographsextensionb}', "");
Expect(0, 1, '\P{^Is_Blk=cjkunifiedideographsextensionb}', "");
Expect(1, 173791, '\p{Is_Blk=_	CJK_unified_Ideographs EXTENSION B}', "");
Expect(0, 173791, '\p{^Is_Blk=_	CJK_unified_Ideographs EXTENSION B}', "");
Expect(0, 173791, '\P{Is_Blk=_	CJK_unified_Ideographs EXTENSION B}', "");
Expect(1, 173791, '\P{^Is_Blk=_	CJK_unified_Ideographs EXTENSION B}', "");
Expect(0, 1, '\p{Is_Blk=_	CJK_unified_Ideographs EXTENSION B}', "");
Expect(1, 1, '\p{^Is_Blk=_	CJK_unified_Ideographs EXTENSION B}', "");
Expect(1, 1, '\P{Is_Blk=_	CJK_unified_Ideographs EXTENSION B}', "");
Expect(0, 1, '\P{^Is_Blk=_	CJK_unified_Ideographs EXTENSION B}', "");
Error('\p{Block=:=-Old	italic}');
Error('\P{Block=:=-Old	italic}');
Expect(1, 66351, '\p{Block=olditalic}', "");
Expect(0, 66351, '\p{^Block=olditalic}', "");
Expect(0, 66351, '\P{Block=olditalic}', "");
Expect(1, 66351, '\P{^Block=olditalic}', "");
Expect(0, 66303, '\p{Block=olditalic}', "");
Expect(1, 66303, '\p{^Block=olditalic}', "");
Expect(1, 66303, '\P{Block=olditalic}', "");
Expect(0, 66303, '\P{^Block=olditalic}', "");
Expect(1, 66351, '\p{Block=	_old_Italic}', "");
Expect(0, 66351, '\p{^Block=	_old_Italic}', "");
Expect(0, 66351, '\P{Block=	_old_Italic}', "");
Expect(1, 66351, '\P{^Block=	_old_Italic}', "");
Expect(0, 66303, '\p{Block=	_old_Italic}', "");
Expect(1, 66303, '\p{^Block=	_old_Italic}', "");
Expect(1, 66303, '\P{Block=	_old_Italic}', "");
Expect(0, 66303, '\P{^Block=	_old_Italic}', "");
Error('\p{Blk=:=_	OLD-Italic}');
Error('\P{Blk=:=_	OLD-Italic}');
Expect(1, 66351, '\p{Blk=olditalic}', "");
Expect(0, 66351, '\p{^Blk=olditalic}', "");
Expect(0, 66351, '\P{Blk=olditalic}', "");
Expect(1, 66351, '\P{^Blk=olditalic}', "");
Expect(0, 66303, '\p{Blk=olditalic}', "");
Expect(1, 66303, '\p{^Blk=olditalic}', "");
Expect(1, 66303, '\P{Blk=olditalic}', "");
Expect(0, 66303, '\P{^Blk=olditalic}', "");
Expect(1, 66351, '\p{Blk=_Old	Italic}', "");
Expect(0, 66351, '\p{^Blk=_Old	Italic}', "");
Expect(0, 66351, '\P{Blk=_Old	Italic}', "");
Expect(1, 66351, '\P{^Blk=_Old	Italic}', "");
Expect(0, 66303, '\p{Blk=_Old	Italic}', "");
Expect(1, 66303, '\p{^Blk=_Old	Italic}', "");
Expect(1, 66303, '\P{Blk=_Old	Italic}', "");
Expect(0, 66303, '\P{^Blk=_Old	Italic}', "");
Error('\p{Is_Block=	-OLD-italic:=}');
Error('\P{Is_Block=	-OLD-italic:=}');
Expect(1, 66351, '\p{Is_Block=olditalic}', "");
Expect(0, 66351, '\p{^Is_Block=olditalic}', "");
Expect(0, 66351, '\P{Is_Block=olditalic}', "");
Expect(1, 66351, '\P{^Is_Block=olditalic}', "");
Expect(0, 66303, '\p{Is_Block=olditalic}', "");
Expect(1, 66303, '\p{^Is_Block=olditalic}', "");
Expect(1, 66303, '\P{Is_Block=olditalic}', "");
Expect(0, 66303, '\P{^Is_Block=olditalic}', "");
Expect(1, 66351, '\p{Is_Block=- Old ITALIC}', "");
Expect(0, 66351, '\p{^Is_Block=- Old ITALIC}', "");
Expect(0, 66351, '\P{Is_Block=- Old ITALIC}', "");
Expect(1, 66351, '\P{^Is_Block=- Old ITALIC}', "");
Expect(0, 66303, '\p{Is_Block=- Old ITALIC}', "");
Expect(1, 66303, '\p{^Is_Block=- Old ITALIC}', "");
Expect(1, 66303, '\P{Is_Block=- Old ITALIC}', "");
Expect(0, 66303, '\P{^Is_Block=- Old ITALIC}', "");
Error('\p{Is_Blk= -Old_Italic:=}');
Error('\P{Is_Blk= -Old_Italic:=}');
Expect(1, 66351, '\p{Is_Blk=olditalic}', "");
Expect(0, 66351, '\p{^Is_Blk=olditalic}', "");
Expect(0, 66351, '\P{Is_Blk=olditalic}', "");
Expect(1, 66351, '\P{^Is_Blk=olditalic}', "");
Expect(0, 66303, '\p{Is_Blk=olditalic}', "");
Expect(1, 66303, '\p{^Is_Blk=olditalic}', "");
Expect(1, 66303, '\P{Is_Blk=olditalic}', "");
Expect(0, 66303, '\P{^Is_Blk=olditalic}', "");
Expect(1, 66351, '\p{Is_Blk=- OldItalic}', "");
Expect(0, 66351, '\p{^Is_Blk=- OldItalic}', "");
Expect(0, 66351, '\P{Is_Blk=- OldItalic}', "");
Expect(1, 66351, '\P{^Is_Blk=- OldItalic}', "");
Expect(0, 66303, '\p{Is_Blk=- OldItalic}', "");
Expect(1, 66303, '\p{^Is_Blk=- OldItalic}', "");
Expect(1, 66303, '\P{Is_Blk=- OldItalic}', "");
Expect(0, 66303, '\P{^Is_Blk=- OldItalic}', "");
Error('\p{Block:--Hangul	SYLLABLES/a/}');
Error('\P{Block:--Hangul	SYLLABLES/a/}');
Expect(1, 55215, '\p{Block=hangulsyllables}', "");
Expect(0, 55215, '\p{^Block=hangulsyllables}', "");
Expect(0, 55215, '\P{Block=hangulsyllables}', "");
Expect(1, 55215, '\P{^Block=hangulsyllables}', "");
Expect(0, 44031, '\p{Block=hangulsyllables}', "");
Expect(1, 44031, '\p{^Block=hangulsyllables}', "");
Expect(1, 44031, '\P{Block=hangulsyllables}', "");
Expect(0, 44031, '\P{^Block=hangulsyllables}', "");
Expect(1, 55215, '\p{Block=  Hangul	syllables}', "");
Expect(0, 55215, '\p{^Block=  Hangul	syllables}', "");
Expect(0, 55215, '\P{Block=  Hangul	syllables}', "");
Expect(1, 55215, '\P{^Block=  Hangul	syllables}', "");
Expect(0, 44031, '\p{Block=  Hangul	syllables}', "");
Expect(1, 44031, '\p{^Block=  Hangul	syllables}', "");
Expect(1, 44031, '\P{Block=  Hangul	syllables}', "");
Expect(0, 44031, '\P{^Block=  Hangul	syllables}', "");
Error('\p{Blk= hangul/a/Syllables}');
Error('\P{Blk= hangul/a/Syllables}');
Expect(1, 55215, '\p{Blk=hangulsyllables}', "");
Expect(0, 55215, '\p{^Blk=hangulsyllables}', "");
Expect(0, 55215, '\P{Blk=hangulsyllables}', "");
Expect(1, 55215, '\P{^Blk=hangulsyllables}', "");
Expect(0, 44031, '\p{Blk=hangulsyllables}', "");
Expect(1, 44031, '\p{^Blk=hangulsyllables}', "");
Expect(1, 44031, '\P{Blk=hangulsyllables}', "");
Expect(0, 44031, '\P{^Blk=hangulsyllables}', "");
Expect(1, 55215, '\p{Blk=	-HANGUL SYLLABLES}', "");
Expect(0, 55215, '\p{^Blk=	-HANGUL SYLLABLES}', "");
Expect(0, 55215, '\P{Blk=	-HANGUL SYLLABLES}', "");
Expect(1, 55215, '\P{^Blk=	-HANGUL SYLLABLES}', "");
Expect(0, 44031, '\p{Blk=	-HANGUL SYLLABLES}', "");
Expect(1, 44031, '\p{^Blk=	-HANGUL SYLLABLES}', "");
Expect(1, 44031, '\P{Blk=	-HANGUL SYLLABLES}', "");
Expect(0, 44031, '\P{^Blk=	-HANGUL SYLLABLES}', "");
Error('\p{Is_Block=-	HANGUL	SYLLABLES/a/}');
Error('\P{Is_Block=-	HANGUL	SYLLABLES/a/}');
Expect(1, 55215, '\p{Is_Block=hangulsyllables}', "");
Expect(0, 55215, '\p{^Is_Block=hangulsyllables}', "");
Expect(0, 55215, '\P{Is_Block=hangulsyllables}', "");
Expect(1, 55215, '\P{^Is_Block=hangulsyllables}', "");
Expect(0, 44031, '\p{Is_Block=hangulsyllables}', "");
Expect(1, 44031, '\p{^Is_Block=hangulsyllables}', "");
Expect(1, 44031, '\P{Is_Block=hangulsyllables}', "");
Expect(0, 44031, '\P{^Is_Block=hangulsyllables}', "");
Expect(1, 55215, '\p{Is_Block=-_Hangul-Syllables}', "");
Expect(0, 55215, '\p{^Is_Block=-_Hangul-Syllables}', "");
Expect(0, 55215, '\P{Is_Block=-_Hangul-Syllables}', "");
Expect(1, 55215, '\P{^Is_Block=-_Hangul-Syllables}', "");
Expect(0, 44031, '\p{Is_Block=-_Hangul-Syllables}', "");
Expect(1, 44031, '\p{^Is_Block=-_Hangul-Syllables}', "");
Expect(1, 44031, '\P{Is_Block=-_Hangul-Syllables}', "");
Expect(0, 44031, '\P{^Is_Block=-_Hangul-Syllables}', "");
Error('\p{Is_Blk=:=--HANGUL SYLLABLES}');
Error('\P{Is_Blk=:=--HANGUL SYLLABLES}');
Expect(1, 55215, '\p{Is_Blk=hangulsyllables}', "");
Expect(0, 55215, '\p{^Is_Blk=hangulsyllables}', "");
Expect(0, 55215, '\P{Is_Blk=hangulsyllables}', "");
Expect(1, 55215, '\P{^Is_Blk=hangulsyllables}', "");
Expect(0, 44031, '\p{Is_Blk=hangulsyllables}', "");
Expect(1, 44031, '\p{^Is_Blk=hangulsyllables}', "");
Expect(1, 44031, '\P{Is_Blk=hangulsyllables}', "");
Expect(0, 44031, '\P{^Is_Blk=hangulsyllables}', "");
Expect(1, 55215, '\p{Is_Blk=hangul SYLLABLES}', "");
Expect(0, 55215, '\p{^Is_Blk=hangul SYLLABLES}', "");
Expect(0, 55215, '\P{Is_Blk=hangul SYLLABLES}', "");
Expect(1, 55215, '\P{^Is_Blk=hangul SYLLABLES}', "");
Expect(0, 44031, '\p{Is_Blk=hangul SYLLABLES}', "");
Expect(1, 44031, '\p{^Is_Blk=hangul SYLLABLES}', "");
Expect(1, 44031, '\P{Is_Blk=hangul SYLLABLES}', "");
Expect(0, 44031, '\P{^Is_Blk=hangul SYLLABLES}', "");
Error('\p{Block=	Yijing-HEXAGRAM_SYMBOLS:=}');
Error('\P{Block=	Yijing-HEXAGRAM_SYMBOLS:=}');
Expect(1, 19967, '\p{Block=yijinghexagramsymbols}', "");
Expect(0, 19967, '\p{^Block=yijinghexagramsymbols}', "");
Expect(0, 19967, '\P{Block=yijinghexagramsymbols}', "");
Expect(1, 19967, '\P{^Block=yijinghexagramsymbols}', "");
Expect(0, 19903, '\p{Block=yijinghexagramsymbols}', "");
Expect(1, 19903, '\p{^Block=yijinghexagramsymbols}', "");
Expect(1, 19903, '\P{Block=yijinghexagramsymbols}', "");
Expect(0, 19903, '\P{^Block=yijinghexagramsymbols}', "");
Expect(1, 19967, '\p{Block=		YIJING HEXAGRAM	SYMBOLS}', "");
Expect(0, 19967, '\p{^Block=		YIJING HEXAGRAM	SYMBOLS}', "");
Expect(0, 19967, '\P{Block=		YIJING HEXAGRAM	SYMBOLS}', "");
Expect(1, 19967, '\P{^Block=		YIJING HEXAGRAM	SYMBOLS}', "");
Expect(0, 19903, '\p{Block=		YIJING HEXAGRAM	SYMBOLS}', "");
Expect(1, 19903, '\p{^Block=		YIJING HEXAGRAM	SYMBOLS}', "");
Expect(1, 19903, '\P{Block=		YIJING HEXAGRAM	SYMBOLS}', "");
Expect(0, 19903, '\P{^Block=		YIJING HEXAGRAM	SYMBOLS}', "");
Error('\p{Blk=/a/Yijing-Hexagram Symbols}');
Error('\P{Blk=/a/Yijing-Hexagram Symbols}');
Expect(1, 19967, '\p{Blk=yijinghexagramsymbols}', "");
Expect(0, 19967, '\p{^Blk=yijinghexagramsymbols}', "");
Expect(0, 19967, '\P{Blk=yijinghexagramsymbols}', "");
Expect(1, 19967, '\P{^Blk=yijinghexagramsymbols}', "");
Expect(0, 19903, '\p{Blk=yijinghexagramsymbols}', "");
Expect(1, 19903, '\p{^Blk=yijinghexagramsymbols}', "");
Expect(1, 19903, '\P{Blk=yijinghexagramsymbols}', "");
Expect(0, 19903, '\P{^Blk=yijinghexagramsymbols}', "");
Expect(1, 19967, '\p{Blk=_yijing-HEXAGRAM_symbols}', "");
Expect(0, 19967, '\p{^Blk=_yijing-HEXAGRAM_symbols}', "");
Expect(0, 19967, '\P{Blk=_yijing-HEXAGRAM_symbols}', "");
Expect(1, 19967, '\P{^Blk=_yijing-HEXAGRAM_symbols}', "");
Expect(0, 19903, '\p{Blk=_yijing-HEXAGRAM_symbols}', "");
Expect(1, 19903, '\p{^Blk=_yijing-HEXAGRAM_symbols}', "");
Expect(1, 19903, '\P{Blk=_yijing-HEXAGRAM_symbols}', "");
Expect(0, 19903, '\P{^Blk=_yijing-HEXAGRAM_symbols}', "");
Error('\p{Is_Block=	_Yijing/a/HexagramSymbols}');
Error('\P{Is_Block=	_Yijing/a/HexagramSymbols}');
Expect(1, 19967, '\p{Is_Block=yijinghexagramsymbols}', "");
Expect(0, 19967, '\p{^Is_Block=yijinghexagramsymbols}', "");
Expect(0, 19967, '\P{Is_Block=yijinghexagramsymbols}', "");
Expect(1, 19967, '\P{^Is_Block=yijinghexagramsymbols}', "");
Expect(0, 19903, '\p{Is_Block=yijinghexagramsymbols}', "");
Expect(1, 19903, '\p{^Is_Block=yijinghexagramsymbols}', "");
Expect(1, 19903, '\P{Is_Block=yijinghexagramsymbols}', "");
Expect(0, 19903, '\P{^Is_Block=yijinghexagramsymbols}', "");
Expect(1, 19967, '\p{Is_Block=_ yijing Hexagramsymbols}', "");
Expect(0, 19967, '\p{^Is_Block=_ yijing Hexagramsymbols}', "");
Expect(0, 19967, '\P{Is_Block=_ yijing Hexagramsymbols}', "");
Expect(1, 19967, '\P{^Is_Block=_ yijing Hexagramsymbols}', "");
Expect(0, 19903, '\p{Is_Block=_ yijing Hexagramsymbols}', "");
Expect(1, 19903, '\p{^Is_Block=_ yijing Hexagramsymbols}', "");
Expect(1, 19903, '\P{Is_Block=_ yijing Hexagramsymbols}', "");
Expect(0, 19903, '\P{^Is_Block=_ yijing Hexagramsymbols}', "");
Error('\p{Is_Blk=-/a/Yijing-Hexagram-Symbols}');
Error('\P{Is_Blk=-/a/Yijing-Hexagram-Symbols}');
Expect(1, 19967, '\p{Is_Blk=yijinghexagramsymbols}', "");
Expect(0, 19967, '\p{^Is_Blk=yijinghexagramsymbols}', "");
Expect(0, 19967, '\P{Is_Blk=yijinghexagramsymbols}', "");
Expect(1, 19967, '\P{^Is_Blk=yijinghexagramsymbols}', "");
Expect(0, 19903, '\p{Is_Blk=yijinghexagramsymbols}', "");
Expect(1, 19903, '\p{^Is_Blk=yijinghexagramsymbols}', "");
Expect(1, 19903, '\P{Is_Blk=yijinghexagramsymbols}', "");
Expect(0, 19903, '\P{^Is_Blk=yijinghexagramsymbols}', "");
Expect(1, 19967, '\p{Is_Blk=		yijing HEXAGRAM-SYMBOLS}', "");
Expect(0, 19967, '\p{^Is_Blk=		yijing HEXAGRAM-SYMBOLS}', "");
Expect(0, 19967, '\P{Is_Blk=		yijing HEXAGRAM-SYMBOLS}', "");
Expect(1, 19967, '\P{^Is_Blk=		yijing HEXAGRAM-SYMBOLS}', "");
Expect(0, 19903, '\p{Is_Blk=		yijing HEXAGRAM-SYMBOLS}', "");
Expect(1, 19903, '\p{^Is_Blk=		yijing HEXAGRAM-SYMBOLS}', "");
Expect(1, 19903, '\P{Is_Blk=		yijing HEXAGRAM-SYMBOLS}', "");
Expect(0, 19903, '\P{^Is_Blk=		yijing HEXAGRAM-SYMBOLS}', "");
Error('\p{Block=	_Phaistos	DISC/a/}');
Error('\P{Block=	_Phaistos	DISC/a/}');
Expect(1, 66047, '\p{Block=phaistosdisc}', "");
Expect(0, 66047, '\p{^Block=phaistosdisc}', "");
Expect(0, 66047, '\P{Block=phaistosdisc}', "");
Expect(1, 66047, '\P{^Block=phaistosdisc}', "");
Expect(0, 65999, '\p{Block=phaistosdisc}', "");
Expect(1, 65999, '\p{^Block=phaistosdisc}', "");
Expect(1, 65999, '\P{Block=phaistosdisc}', "");
Expect(0, 65999, '\P{^Block=phaistosdisc}', "");
Expect(1, 66047, '\p{Block: -Phaistos_DISC}', "");
Expect(0, 66047, '\p{^Block: -Phaistos_DISC}', "");
Expect(0, 66047, '\P{Block: -Phaistos_DISC}', "");
Expect(1, 66047, '\P{^Block: -Phaistos_DISC}', "");
Expect(0, 65999, '\p{Block: -Phaistos_DISC}', "");
Expect(1, 65999, '\p{^Block: -Phaistos_DISC}', "");
Expect(1, 65999, '\P{Block: -Phaistos_DISC}', "");
Expect(0, 65999, '\P{^Block: -Phaistos_DISC}', "");
Error('\p{Blk:	:=Phaistos-disc}');
Error('\P{Blk:	:=Phaistos-disc}');
Expect(1, 66047, '\p{Blk=phaistosdisc}', "");
Expect(0, 66047, '\p{^Blk=phaistosdisc}', "");
Expect(0, 66047, '\P{Blk=phaistosdisc}', "");
Expect(1, 66047, '\P{^Blk=phaistosdisc}', "");
Expect(0, 65999, '\p{Blk=phaistosdisc}', "");
Expect(1, 65999, '\p{^Blk=phaistosdisc}', "");
Expect(1, 65999, '\P{Blk=phaistosdisc}', "");
Expect(0, 65999, '\P{^Blk=phaistosdisc}', "");
Expect(1, 66047, '\p{Blk=--Phaistos-Disc}', "");
Expect(0, 66047, '\p{^Blk=--Phaistos-Disc}', "");
Expect(0, 66047, '\P{Blk=--Phaistos-Disc}', "");
Expect(1, 66047, '\P{^Blk=--Phaistos-Disc}', "");
Expect(0, 65999, '\p{Blk=--Phaistos-Disc}', "");
Expect(1, 65999, '\p{^Blk=--Phaistos-Disc}', "");
Expect(1, 65999, '\P{Blk=--Phaistos-Disc}', "");
Expect(0, 65999, '\P{^Blk=--Phaistos-Disc}', "");
Error('\p{Is_Block=-/a/PHAISTOS-disc}');
Error('\P{Is_Block=-/a/PHAISTOS-disc}');
Expect(1, 66047, '\p{Is_Block=phaistosdisc}', "");
Expect(0, 66047, '\p{^Is_Block=phaistosdisc}', "");
Expect(0, 66047, '\P{Is_Block=phaistosdisc}', "");
Expect(1, 66047, '\P{^Is_Block=phaistosdisc}', "");
Expect(0, 65999, '\p{Is_Block=phaistosdisc}', "");
Expect(1, 65999, '\p{^Is_Block=phaistosdisc}', "");
Expect(1, 65999, '\P{Is_Block=phaistosdisc}', "");
Expect(0, 65999, '\P{^Is_Block=phaistosdisc}', "");
Expect(1, 66047, '\p{Is_Block=-Phaistos-disc}', "");
Expect(0, 66047, '\p{^Is_Block=-Phaistos-disc}', "");
Expect(0, 66047, '\P{Is_Block=-Phaistos-disc}', "");
Expect(1, 66047, '\P{^Is_Block=-Phaistos-disc}', "");
Expect(0, 65999, '\p{Is_Block=-Phaistos-disc}', "");
Expect(1, 65999, '\p{^Is_Block=-Phaistos-disc}', "");
Expect(1, 65999, '\P{Is_Block=-Phaistos-disc}', "");
Expect(0, 65999, '\P{^Is_Block=-Phaistos-disc}', "");
Error('\p{Is_Blk=__Phaistos	Disc:=}');
Error('\P{Is_Blk=__Phaistos	Disc:=}');
Expect(1, 66047, '\p{Is_Blk=phaistosdisc}', "");
Expect(0, 66047, '\p{^Is_Blk=phaistosdisc}', "");
Expect(0, 66047, '\P{Is_Blk=phaistosdisc}', "");
Expect(1, 66047, '\P{^Is_Blk=phaistosdisc}', "");
Expect(0, 65999, '\p{Is_Blk=phaistosdisc}', "");
Expect(1, 65999, '\p{^Is_Blk=phaistosdisc}', "");
Expect(1, 65999, '\P{Is_Blk=phaistosdisc}', "");
Expect(0, 65999, '\P{^Is_Blk=phaistosdisc}', "");
Expect(1, 66047, '\p{Is_Blk=		PhaistosDisc}', "");
Expect(0, 66047, '\p{^Is_Blk=		PhaistosDisc}', "");
Expect(0, 66047, '\P{Is_Blk=		PhaistosDisc}', "");
Expect(1, 66047, '\P{^Is_Blk=		PhaistosDisc}', "");
Expect(0, 65999, '\p{Is_Blk=		PhaistosDisc}', "");
Expect(1, 65999, '\p{^Is_Blk=		PhaistosDisc}', "");
Expect(1, 65999, '\P{Is_Blk=		PhaistosDisc}', "");
Expect(0, 65999, '\P{^Is_Blk=		PhaistosDisc}', "");
Error('\p{Block=- small:=form-Variants}');
Error('\P{Block=- small:=form-Variants}');
Expect(1, 65135, '\p{Block=smallformvariants}', "");
Expect(0, 65135, '\p{^Block=smallformvariants}', "");
Expect(0, 65135, '\P{Block=smallformvariants}', "");
Expect(1, 65135, '\P{^Block=smallformvariants}', "");
Expect(0, 65103, '\p{Block=smallformvariants}', "");
Expect(1, 65103, '\p{^Block=smallformvariants}', "");
Expect(1, 65103, '\P{Block=smallformvariants}', "");
Expect(0, 65103, '\P{^Block=smallformvariants}', "");
Expect(1, 65135, '\p{Block:	 	small-form_Variants}', "");
Expect(0, 65135, '\p{^Block:	 	small-form_Variants}', "");
Expect(0, 65135, '\P{Block:	 	small-form_Variants}', "");
Expect(1, 65135, '\P{^Block:	 	small-form_Variants}', "");
Expect(0, 65103, '\p{Block:	 	small-form_Variants}', "");
Expect(1, 65103, '\p{^Block:	 	small-form_Variants}', "");
Expect(1, 65103, '\P{Block:	 	small-form_Variants}', "");
Expect(0, 65103, '\P{^Block:	 	small-form_Variants}', "");
Error('\p{Blk= -SMALL:=form Variants}');
Error('\P{Blk= -SMALL:=form Variants}');
Expect(1, 65135, '\p{Blk=smallformvariants}', "");
Expect(0, 65135, '\p{^Blk=smallformvariants}', "");
Expect(0, 65135, '\P{Blk=smallformvariants}', "");
Expect(1, 65135, '\P{^Blk=smallformvariants}', "");
Expect(0, 65103, '\p{Blk=smallformvariants}', "");
Expect(1, 65103, '\p{^Blk=smallformvariants}', "");
Expect(1, 65103, '\P{Blk=smallformvariants}', "");
Expect(0, 65103, '\P{^Blk=smallformvariants}', "");
Expect(1, 65135, '\p{Blk=__Small Form_variants}', "");
Expect(0, 65135, '\p{^Blk=__Small Form_variants}', "");
Expect(0, 65135, '\P{Blk=__Small Form_variants}', "");
Expect(1, 65135, '\P{^Blk=__Small Form_variants}', "");
Expect(0, 65103, '\p{Blk=__Small Form_variants}', "");
Expect(1, 65103, '\p{^Blk=__Small Form_variants}', "");
Expect(1, 65103, '\P{Blk=__Small Form_variants}', "");
Expect(0, 65103, '\P{^Blk=__Small Form_variants}', "");
Error('\p{Is_Block:		Small:=form-Variants}');
Error('\P{Is_Block:		Small:=form-Variants}');
Expect(1, 65135, '\p{Is_Block=smallformvariants}', "");
Expect(0, 65135, '\p{^Is_Block=smallformvariants}', "");
Expect(0, 65135, '\P{Is_Block=smallformvariants}', "");
Expect(1, 65135, '\P{^Is_Block=smallformvariants}', "");
Expect(0, 65103, '\p{Is_Block=smallformvariants}', "");
Expect(1, 65103, '\p{^Is_Block=smallformvariants}', "");
Expect(1, 65103, '\P{Is_Block=smallformvariants}', "");
Expect(0, 65103, '\P{^Is_Block=smallformvariants}', "");
Expect(1, 65135, '\p{Is_Block=--Small	Form_Variants}', "");
Expect(0, 65135, '\p{^Is_Block=--Small	Form_Variants}', "");
Expect(0, 65135, '\P{Is_Block=--Small	Form_Variants}', "");
Expect(1, 65135, '\P{^Is_Block=--Small	Form_Variants}', "");
Expect(0, 65103, '\p{Is_Block=--Small	Form_Variants}', "");
Expect(1, 65103, '\p{^Is_Block=--Small	Form_Variants}', "");
Expect(1, 65103, '\P{Is_Block=--Small	Form_Variants}', "");
Expect(0, 65103, '\P{^Is_Block=--Small	Form_Variants}', "");
Error('\p{Is_Blk=- small_Form/a/variants}');
Error('\P{Is_Blk=- small_Form/a/variants}');
Expect(1, 65135, '\p{Is_Blk=smallformvariants}', "");
Expect(0, 65135, '\p{^Is_Blk=smallformvariants}', "");
Expect(0, 65135, '\P{Is_Blk=smallformvariants}', "");
Expect(1, 65135, '\P{^Is_Blk=smallformvariants}', "");
Expect(0, 65103, '\p{Is_Blk=smallformvariants}', "");
Expect(1, 65103, '\p{^Is_Blk=smallformvariants}', "");
Expect(1, 65103, '\P{Is_Blk=smallformvariants}', "");
Expect(0, 65103, '\P{^Is_Blk=smallformvariants}', "");
Expect(1, 65135, '\p{Is_Blk=		Small FORM Variants}', "");
Expect(0, 65135, '\p{^Is_Blk=		Small FORM Variants}', "");
Expect(0, 65135, '\P{Is_Blk=		Small FORM Variants}', "");
Expect(1, 65135, '\P{^Is_Blk=		Small FORM Variants}', "");
Expect(0, 65103, '\p{Is_Blk=		Small FORM Variants}', "");
Expect(1, 65103, '\p{^Is_Blk=		Small FORM Variants}', "");
Expect(1, 65103, '\P{Is_Blk=		Small FORM Variants}', "");
Expect(0, 65103, '\P{^Is_Blk=		Small FORM Variants}', "");
Error('\p{Block=_:=EGYPTIANHieroglyphs}');
Error('\P{Block=_:=EGYPTIANHieroglyphs}');
Expect(1, 78895, '\p{Block=egyptianhieroglyphs}', "");
Expect(0, 78895, '\p{^Block=egyptianhieroglyphs}', "");
Expect(0, 78895, '\P{Block=egyptianhieroglyphs}', "");
Expect(1, 78895, '\P{^Block=egyptianhieroglyphs}', "");
Expect(0, 77823, '\p{Block=egyptianhieroglyphs}', "");
Expect(1, 77823, '\p{^Block=egyptianhieroglyphs}', "");
Expect(1, 77823, '\P{Block=egyptianhieroglyphs}', "");
Expect(0, 77823, '\P{^Block=egyptianhieroglyphs}', "");
Expect(1, 78895, '\p{Block=egyptian_hieroglyphs}', "");
Expect(0, 78895, '\p{^Block=egyptian_hieroglyphs}', "");
Expect(0, 78895, '\P{Block=egyptian_hieroglyphs}', "");
Expect(1, 78895, '\P{^Block=egyptian_hieroglyphs}', "");
Expect(0, 77823, '\p{Block=egyptian_hieroglyphs}', "");
Expect(1, 77823, '\p{^Block=egyptian_hieroglyphs}', "");
Expect(1, 77823, '\P{Block=egyptian_hieroglyphs}', "");
Expect(0, 77823, '\P{^Block=egyptian_hieroglyphs}', "");
Error('\p{Blk=:=	-egyptian	HIEROGLYPHS}');
Error('\P{Blk=:=	-egyptian	HIEROGLYPHS}');
Expect(1, 78895, '\p{Blk:   egyptianhieroglyphs}', "");
Expect(0, 78895, '\p{^Blk:   egyptianhieroglyphs}', "");
Expect(0, 78895, '\P{Blk:   egyptianhieroglyphs}', "");
Expect(1, 78895, '\P{^Blk:   egyptianhieroglyphs}', "");
Expect(0, 77823, '\p{Blk:   egyptianhieroglyphs}', "");
Expect(1, 77823, '\p{^Blk:   egyptianhieroglyphs}', "");
Expect(1, 77823, '\P{Blk:   egyptianhieroglyphs}', "");
Expect(0, 77823, '\P{^Blk:   egyptianhieroglyphs}', "");
Expect(1, 78895, '\p{Blk=	-EGYPTIAN HIEROGLYPHS}', "");
Expect(0, 78895, '\p{^Blk=	-EGYPTIAN HIEROGLYPHS}', "");
Expect(0, 78895, '\P{Blk=	-EGYPTIAN HIEROGLYPHS}', "");
Expect(1, 78895, '\P{^Blk=	-EGYPTIAN HIEROGLYPHS}', "");
Expect(0, 77823, '\p{Blk=	-EGYPTIAN HIEROGLYPHS}', "");
Expect(1, 77823, '\p{^Blk=	-EGYPTIAN HIEROGLYPHS}', "");
Expect(1, 77823, '\P{Blk=	-EGYPTIAN HIEROGLYPHS}', "");
Expect(0, 77823, '\P{^Blk=	-EGYPTIAN HIEROGLYPHS}', "");
Error('\p{Is_Block=  EGYPTIAN:=hieroglyphs}');
Error('\P{Is_Block=  EGYPTIAN:=hieroglyphs}');
Expect(1, 78895, '\p{Is_Block=egyptianhieroglyphs}', "");
Expect(0, 78895, '\p{^Is_Block=egyptianhieroglyphs}', "");
Expect(0, 78895, '\P{Is_Block=egyptianhieroglyphs}', "");
Expect(1, 78895, '\P{^Is_Block=egyptianhieroglyphs}', "");
Expect(0, 77823, '\p{Is_Block=egyptianhieroglyphs}', "");
Expect(1, 77823, '\p{^Is_Block=egyptianhieroglyphs}', "");
Expect(1, 77823, '\P{Is_Block=egyptianhieroglyphs}', "");
Expect(0, 77823, '\P{^Is_Block=egyptianhieroglyphs}', "");
Expect(1, 78895, '\p{Is_Block: --egyptian-HIEROGLYPHS}', "");
Expect(0, 78895, '\p{^Is_Block: --egyptian-HIEROGLYPHS}', "");
Expect(0, 78895, '\P{Is_Block: --egyptian-HIEROGLYPHS}', "");
Expect(1, 78895, '\P{^Is_Block: --egyptian-HIEROGLYPHS}', "");
Expect(0, 77823, '\p{Is_Block: --egyptian-HIEROGLYPHS}', "");
Expect(1, 77823, '\p{^Is_Block: --egyptian-HIEROGLYPHS}', "");
Expect(1, 77823, '\P{Is_Block: --egyptian-HIEROGLYPHS}', "");
Expect(0, 77823, '\P{^Is_Block: --egyptian-HIEROGLYPHS}', "");
Error('\p{Is_Blk=  Egyptian-HIEROGLYPHS/a/}');
Error('\P{Is_Blk=  Egyptian-HIEROGLYPHS/a/}');
Expect(1, 78895, '\p{Is_Blk=egyptianhieroglyphs}', "");
Expect(0, 78895, '\p{^Is_Blk=egyptianhieroglyphs}', "");
Expect(0, 78895, '\P{Is_Blk=egyptianhieroglyphs}', "");
Expect(1, 78895, '\P{^Is_Blk=egyptianhieroglyphs}', "");
Expect(0, 77823, '\p{Is_Blk=egyptianhieroglyphs}', "");
Expect(1, 77823, '\p{^Is_Blk=egyptianhieroglyphs}', "");
Expect(1, 77823, '\P{Is_Blk=egyptianhieroglyphs}', "");
Expect(0, 77823, '\P{^Is_Blk=egyptianhieroglyphs}', "");
Expect(1, 78895, '\p{Is_Blk=	-Egyptian	HIEROGLYPHS}', "");
Expect(0, 78895, '\p{^Is_Blk=	-Egyptian	HIEROGLYPHS}', "");
Expect(0, 78895, '\P{Is_Blk=	-Egyptian	HIEROGLYPHS}', "");
Expect(1, 78895, '\P{^Is_Blk=	-Egyptian	HIEROGLYPHS}', "");
Expect(0, 77823, '\p{Is_Blk=	-Egyptian	HIEROGLYPHS}', "");
Expect(1, 77823, '\p{^Is_Blk=	-Egyptian	HIEROGLYPHS}', "");
Expect(1, 77823, '\P{Is_Blk=	-Egyptian	HIEROGLYPHS}', "");
Expect(0, 77823, '\P{^Is_Blk=	-Egyptian	HIEROGLYPHS}', "");
Error('\p{Block= Latin:=Extended D}');
Error('\P{Block= Latin:=Extended D}');
Expect(1, 43007, '\p{Block=latinextendedd}', "");
Expect(0, 43007, '\p{^Block=latinextendedd}', "");
Expect(0, 43007, '\P{Block=latinextendedd}', "");
Expect(1, 43007, '\P{^Block=latinextendedd}', "");
Expect(0, 42783, '\p{Block=latinextendedd}', "");
Expect(1, 42783, '\p{^Block=latinextendedd}', "");
Expect(1, 42783, '\P{Block=latinextendedd}', "");
Expect(0, 42783, '\P{^Block=latinextendedd}', "");
Expect(1, 43007, '\p{Block:   __Latin Extended-D}', "");
Expect(0, 43007, '\p{^Block:   __Latin Extended-D}', "");
Expect(0, 43007, '\P{Block:   __Latin Extended-D}', "");
Expect(1, 43007, '\P{^Block:   __Latin Extended-D}', "");
Expect(0, 42783, '\p{Block:   __Latin Extended-D}', "");
Expect(1, 42783, '\p{^Block:   __Latin Extended-D}', "");
Expect(1, 42783, '\P{Block:   __Latin Extended-D}', "");
Expect(0, 42783, '\P{^Block:   __Latin Extended-D}', "");
Error('\p{Blk=:=latin-EXTENDED	D}');
Error('\P{Blk=:=latin-EXTENDED	D}');
Expect(1, 43007, '\p{Blk=latinextendedd}', "");
Expect(0, 43007, '\p{^Blk=latinextendedd}', "");
Expect(0, 43007, '\P{Blk=latinextendedd}', "");
Expect(1, 43007, '\P{^Blk=latinextendedd}', "");
Expect(0, 42783, '\p{Blk=latinextendedd}', "");
Expect(1, 42783, '\p{^Blk=latinextendedd}', "");
Expect(1, 42783, '\P{Blk=latinextendedd}', "");
Expect(0, 42783, '\P{^Blk=latinextendedd}', "");
Expect(1, 43007, '\p{Blk=_Latin-EXTENDED_D}', "");
Expect(0, 43007, '\p{^Blk=_Latin-EXTENDED_D}', "");
Expect(0, 43007, '\P{Blk=_Latin-EXTENDED_D}', "");
Expect(1, 43007, '\P{^Blk=_Latin-EXTENDED_D}', "");
Expect(0, 42783, '\p{Blk=_Latin-EXTENDED_D}', "");
Expect(1, 42783, '\p{^Blk=_Latin-EXTENDED_D}', "");
Expect(1, 42783, '\P{Blk=_Latin-EXTENDED_D}', "");
Expect(0, 42783, '\P{^Blk=_Latin-EXTENDED_D}', "");
Error('\p{Is_Block=_	Latin/a/EXTENDED	d}');
Error('\P{Is_Block=_	Latin/a/EXTENDED	d}');
Expect(1, 43007, '\p{Is_Block:latinextendedd}', "");
Expect(0, 43007, '\p{^Is_Block:latinextendedd}', "");
Expect(0, 43007, '\P{Is_Block:latinextendedd}', "");
Expect(1, 43007, '\P{^Is_Block:latinextendedd}', "");
Expect(0, 42783, '\p{Is_Block:latinextendedd}', "");
Expect(1, 42783, '\p{^Is_Block:latinextendedd}', "");
Expect(1, 42783, '\P{Is_Block:latinextendedd}', "");
Expect(0, 42783, '\P{^Is_Block:latinextendedd}', "");
Expect(1, 43007, '\p{Is_Block= -Latin_Extended-D}', "");
Expect(0, 43007, '\p{^Is_Block= -Latin_Extended-D}', "");
Expect(0, 43007, '\P{Is_Block= -Latin_Extended-D}', "");
Expect(1, 43007, '\P{^Is_Block= -Latin_Extended-D}', "");
Expect(0, 42783, '\p{Is_Block= -Latin_Extended-D}', "");
Expect(1, 42783, '\p{^Is_Block= -Latin_Extended-D}', "");
Expect(1, 42783, '\P{Is_Block= -Latin_Extended-D}', "");
Expect(0, 42783, '\P{^Is_Block= -Latin_Extended-D}', "");
Error('\p{Is_Blk=-_latin	extended-D/a/}');
Error('\P{Is_Blk=-_latin	extended-D/a/}');
Expect(1, 43007, '\p{Is_Blk=latinextendedd}', "");
Expect(0, 43007, '\p{^Is_Blk=latinextendedd}', "");
Expect(0, 43007, '\P{Is_Blk=latinextendedd}', "");
Expect(1, 43007, '\P{^Is_Blk=latinextendedd}', "");
Expect(0, 42783, '\p{Is_Blk=latinextendedd}', "");
Expect(1, 42783, '\p{^Is_Blk=latinextendedd}', "");
Expect(1, 42783, '\P{Is_Blk=latinextendedd}', "");
Expect(0, 42783, '\P{^Is_Blk=latinextendedd}', "");
Expect(1, 43007, '\p{Is_Blk=_	Latin-ExtendedD}', "");
Expect(0, 43007, '\p{^Is_Blk=_	Latin-ExtendedD}', "");
Expect(0, 43007, '\P{Is_Blk=_	Latin-ExtendedD}', "");
Expect(1, 43007, '\P{^Is_Blk=_	Latin-ExtendedD}', "");
Expect(0, 42783, '\p{Is_Blk=_	Latin-ExtendedD}', "");
Expect(1, 42783, '\p{^Is_Blk=_	Latin-ExtendedD}', "");
Expect(1, 42783, '\P{Is_Blk=_	Latin-ExtendedD}', "");
Expect(0, 42783, '\P{^Is_Blk=_	Latin-ExtendedD}', "");
Error('\p{Block=/a/Alphabetic	presentation	forms}');
Error('\P{Block=/a/Alphabetic	presentation	forms}');
Expect(1, 64335, '\p{Block:alphabeticpresentationforms}', "");
Expect(0, 64335, '\p{^Block:alphabeticpresentationforms}', "");
Expect(0, 64335, '\P{Block:alphabeticpresentationforms}', "");
Expect(1, 64335, '\P{^Block:alphabeticpresentationforms}', "");
Expect(0, 64255, '\p{Block:alphabeticpresentationforms}', "");
Expect(1, 64255, '\p{^Block:alphabeticpresentationforms}', "");
Expect(1, 64255, '\P{Block:alphabeticpresentationforms}', "");
Expect(0, 64255, '\P{^Block:alphabeticpresentationforms}', "");
Expect(1, 64335, '\p{Block= Alphabetic	PRESENTATION FORMS}', "");
Expect(0, 64335, '\p{^Block= Alphabetic	PRESENTATION FORMS}', "");
Expect(0, 64335, '\P{Block= Alphabetic	PRESENTATION FORMS}', "");
Expect(1, 64335, '\P{^Block= Alphabetic	PRESENTATION FORMS}', "");
Expect(0, 64255, '\p{Block= Alphabetic	PRESENTATION FORMS}', "");
Expect(1, 64255, '\p{^Block= Alphabetic	PRESENTATION FORMS}', "");
Expect(1, 64255, '\P{Block= Alphabetic	PRESENTATION FORMS}', "");
Expect(0, 64255, '\P{^Block= Alphabetic	PRESENTATION FORMS}', "");
Error('\p{Blk=-	Alphabetic/a/Presentation_forms}');
Error('\P{Blk=-	Alphabetic/a/Presentation_forms}');
Expect(1, 64335, '\p{Blk=alphabeticpresentationforms}', "");
Expect(0, 64335, '\p{^Blk=alphabeticpresentationforms}', "");
Expect(0, 64335, '\P{Blk=alphabeticpresentationforms}', "");
Expect(1, 64335, '\P{^Blk=alphabeticpresentationforms}', "");
Expect(0, 64255, '\p{Blk=alphabeticpresentationforms}', "");
Expect(1, 64255, '\p{^Blk=alphabeticpresentationforms}', "");
Expect(1, 64255, '\P{Blk=alphabeticpresentationforms}', "");
Expect(0, 64255, '\P{^Blk=alphabeticpresentationforms}', "");
Expect(1, 64335, '\p{Blk=- ALPHABETIC_PresentationForms}', "");
Expect(0, 64335, '\p{^Blk=- ALPHABETIC_PresentationForms}', "");
Expect(0, 64335, '\P{Blk=- ALPHABETIC_PresentationForms}', "");
Expect(1, 64335, '\P{^Blk=- ALPHABETIC_PresentationForms}', "");
Expect(0, 64255, '\p{Blk=- ALPHABETIC_PresentationForms}', "");
Expect(1, 64255, '\p{^Blk=- ALPHABETIC_PresentationForms}', "");
Expect(1, 64255, '\P{Blk=- ALPHABETIC_PresentationForms}', "");
Expect(0, 64255, '\P{^Blk=- ALPHABETIC_PresentationForms}', "");
Error('\p{Is_Block=:= Alphabetic-Presentation	FORMS}');
Error('\P{Is_Block=:= Alphabetic-Presentation	FORMS}');
Expect(1, 64335, '\p{Is_Block=alphabeticpresentationforms}', "");
Expect(0, 64335, '\p{^Is_Block=alphabeticpresentationforms}', "");
Expect(0, 64335, '\P{Is_Block=alphabeticpresentationforms}', "");
Expect(1, 64335, '\P{^Is_Block=alphabeticpresentationforms}', "");
Expect(0, 64255, '\p{Is_Block=alphabeticpresentationforms}', "");
Expect(1, 64255, '\p{^Is_Block=alphabeticpresentationforms}', "");
Expect(1, 64255, '\P{Is_Block=alphabeticpresentationforms}', "");
Expect(0, 64255, '\P{^Is_Block=alphabeticpresentationforms}', "");
Expect(1, 64335, '\p{Is_Block=	alphabetic presentation_FORMS}', "");
Expect(0, 64335, '\p{^Is_Block=	alphabetic presentation_FORMS}', "");
Expect(0, 64335, '\P{Is_Block=	alphabetic presentation_FORMS}', "");
Expect(1, 64335, '\P{^Is_Block=	alphabetic presentation_FORMS}', "");
Expect(0, 64255, '\p{Is_Block=	alphabetic presentation_FORMS}', "");
Expect(1, 64255, '\p{^Is_Block=	alphabetic presentation_FORMS}', "");
Expect(1, 64255, '\P{Is_Block=	alphabetic presentation_FORMS}', "");
Expect(0, 64255, '\P{^Is_Block=	alphabetic presentation_FORMS}', "");
Error('\p{Is_Blk= 	Alphabetic:=Presentation_Forms}');
Error('\P{Is_Blk= 	Alphabetic:=Presentation_Forms}');
Expect(1, 64335, '\p{Is_Blk=alphabeticpresentationforms}', "");
Expect(0, 64335, '\p{^Is_Blk=alphabeticpresentationforms}', "");
Expect(0, 64335, '\P{Is_Blk=alphabeticpresentationforms}', "");
Expect(1, 64335, '\P{^Is_Blk=alphabeticpresentationforms}', "");
Expect(0, 64255, '\p{Is_Blk=alphabeticpresentationforms}', "");
Expect(1, 64255, '\p{^Is_Blk=alphabeticpresentationforms}', "");
Expect(1, 64255, '\P{Is_Blk=alphabeticpresentationforms}', "");
Expect(0, 64255, '\P{^Is_Blk=alphabeticpresentationforms}', "");
Expect(1, 64335, '\p{Is_Blk=-_Alphabetic-PRESENTATION_forms}', "");
Expect(0, 64335, '\p{^Is_Blk=-_Alphabetic-PRESENTATION_forms}', "");
Expect(0, 64335, '\P{Is_Blk=-_Alphabetic-PRESENTATION_forms}', "");
Expect(1, 64335, '\P{^Is_Blk=-_Alphabetic-PRESENTATION_forms}', "");
Expect(0, 64255, '\p{Is_Blk=-_Alphabetic-PRESENTATION_forms}', "");
Expect(1, 64255, '\p{^Is_Blk=-_Alphabetic-PRESENTATION_forms}', "");
Expect(1, 64255, '\P{Is_Blk=-_Alphabetic-PRESENTATION_forms}', "");
Expect(0, 64255, '\P{^Is_Blk=-_Alphabetic-PRESENTATION_forms}', "");
Error('\p{Block= 	Optical_character	recognition:=}');
Error('\P{Block= 	Optical_character	recognition:=}');
Expect(1, 9311, '\p{Block=opticalcharacterrecognition}', "");
Expect(0, 9311, '\p{^Block=opticalcharacterrecognition}', "");
Expect(0, 9311, '\P{Block=opticalcharacterrecognition}', "");
Expect(1, 9311, '\P{^Block=opticalcharacterrecognition}', "");
Expect(0, 9279, '\p{Block=opticalcharacterrecognition}', "");
Expect(1, 9279, '\p{^Block=opticalcharacterrecognition}', "");
Expect(1, 9279, '\P{Block=opticalcharacterrecognition}', "");
Expect(0, 9279, '\P{^Block=opticalcharacterrecognition}', "");
Expect(1, 9311, '\p{Block= OPTICAL_Character_Recognition}', "");
Expect(0, 9311, '\p{^Block= OPTICAL_Character_Recognition}', "");
Expect(0, 9311, '\P{Block= OPTICAL_Character_Recognition}', "");
Expect(1, 9311, '\P{^Block= OPTICAL_Character_Recognition}', "");
Expect(0, 9279, '\p{Block= OPTICAL_Character_Recognition}', "");
Expect(1, 9279, '\p{^Block= OPTICAL_Character_Recognition}', "");
Expect(1, 9279, '\P{Block= OPTICAL_Character_Recognition}', "");
Expect(0, 9279, '\P{^Block= OPTICAL_Character_Recognition}', "");
Error('\p{Blk=/a/--OPTICAL_Character	recognition}');
Error('\P{Blk=/a/--OPTICAL_Character	recognition}');
Expect(1, 9311, '\p{Blk=opticalcharacterrecognition}', "");
Expect(0, 9311, '\p{^Blk=opticalcharacterrecognition}', "");
Expect(0, 9311, '\P{Blk=opticalcharacterrecognition}', "");
Expect(1, 9311, '\P{^Blk=opticalcharacterrecognition}', "");
Expect(0, 9279, '\p{Blk=opticalcharacterrecognition}', "");
Expect(1, 9279, '\p{^Blk=opticalcharacterrecognition}', "");
Expect(1, 9279, '\P{Blk=opticalcharacterrecognition}', "");
Expect(0, 9279, '\P{^Blk=opticalcharacterrecognition}', "");
Expect(1, 9311, '\p{Blk=	-Optical	Character Recognition}', "");
Expect(0, 9311, '\p{^Blk=	-Optical	Character Recognition}', "");
Expect(0, 9311, '\P{Blk=	-Optical	Character Recognition}', "");
Expect(1, 9311, '\P{^Blk=	-Optical	Character Recognition}', "");
Expect(0, 9279, '\p{Blk=	-Optical	Character Recognition}', "");
Expect(1, 9279, '\p{^Blk=	-Optical	Character Recognition}', "");
Expect(1, 9279, '\P{Blk=	-Optical	Character Recognition}', "");
Expect(0, 9279, '\P{^Blk=	-Optical	Character Recognition}', "");
Error('\p{Is_Block:-Optical	character-recognition:=}');
Error('\P{Is_Block:-Optical	character-recognition:=}');
Expect(1, 9311, '\p{Is_Block=opticalcharacterrecognition}', "");
Expect(0, 9311, '\p{^Is_Block=opticalcharacterrecognition}', "");
Expect(0, 9311, '\P{Is_Block=opticalcharacterrecognition}', "");
Expect(1, 9311, '\P{^Is_Block=opticalcharacterrecognition}', "");
Expect(0, 9279, '\p{Is_Block=opticalcharacterrecognition}', "");
Expect(1, 9279, '\p{^Is_Block=opticalcharacterrecognition}', "");
Expect(1, 9279, '\P{Is_Block=opticalcharacterrecognition}', "");
Expect(0, 9279, '\P{^Is_Block=opticalcharacterrecognition}', "");
Expect(1, 9311, '\p{Is_Block=-Optical-Character	recognition}', "");
Expect(0, 9311, '\p{^Is_Block=-Optical-Character	recognition}', "");
Expect(0, 9311, '\P{Is_Block=-Optical-Character	recognition}', "");
Expect(1, 9311, '\P{^Is_Block=-Optical-Character	recognition}', "");
Expect(0, 9279, '\p{Is_Block=-Optical-Character	recognition}', "");
Expect(1, 9279, '\p{^Is_Block=-Optical-Character	recognition}', "");
Expect(1, 9279, '\P{Is_Block=-Optical-Character	recognition}', "");
Expect(0, 9279, '\P{^Is_Block=-Optical-Character	recognition}', "");
Error('\p{Is_Blk=	/a/optical	characterRECOGNITION}');
Error('\P{Is_Blk=	/a/optical	characterRECOGNITION}');
Expect(1, 9311, '\p{Is_Blk=opticalcharacterrecognition}', "");
Expect(0, 9311, '\p{^Is_Blk=opticalcharacterrecognition}', "");
Expect(0, 9311, '\P{Is_Blk=opticalcharacterrecognition}', "");
Expect(1, 9311, '\P{^Is_Blk=opticalcharacterrecognition}', "");
Expect(0, 9279, '\p{Is_Blk=opticalcharacterrecognition}', "");
Expect(1, 9279, '\p{^Is_Blk=opticalcharacterrecognition}', "");
Expect(1, 9279, '\P{Is_Blk=opticalcharacterrecognition}', "");
Expect(0, 9279, '\P{^Is_Blk=opticalcharacterrecognition}', "");
Expect(1, 9311, '\p{Is_Blk:   -OpticalCHARACTERrecognition}', "");
Expect(0, 9311, '\p{^Is_Blk:   -OpticalCHARACTERrecognition}', "");
Expect(0, 9311, '\P{Is_Blk:   -OpticalCHARACTERrecognition}', "");
Expect(1, 9311, '\P{^Is_Blk:   -OpticalCHARACTERrecognition}', "");
Expect(0, 9279, '\p{Is_Blk:   -OpticalCHARACTERrecognition}', "");
Expect(1, 9279, '\p{^Is_Blk:   -OpticalCHARACTERrecognition}', "");
Expect(1, 9279, '\P{Is_Blk:   -OpticalCHARACTERrecognition}', "");
Expect(0, 9279, '\P{^Is_Blk:   -OpticalCHARACTERrecognition}', "");
Error('\p{Block=:= 	CJK	Unified_ideographs}');
Error('\P{Block=:= 	CJK	Unified_ideographs}');
Expect(1, 40959, '\p{Block=cjkunifiedideographs}', "");
Expect(0, 40959, '\p{^Block=cjkunifiedideographs}', "");
Expect(0, 40959, '\P{Block=cjkunifiedideographs}', "");
Expect(1, 40959, '\P{^Block=cjkunifiedideographs}', "");
Expect(0, 19967, '\p{Block=cjkunifiedideographs}', "");
Expect(1, 19967, '\p{^Block=cjkunifiedideographs}', "");
Expect(1, 19967, '\P{Block=cjkunifiedideographs}', "");
Expect(0, 19967, '\P{^Block=cjkunifiedideographs}', "");
Expect(1, 40959, '\p{Block=_ cjkunified	Ideographs}', "");
Expect(0, 40959, '\p{^Block=_ cjkunified	Ideographs}', "");
Expect(0, 40959, '\P{Block=_ cjkunified	Ideographs}', "");
Expect(1, 40959, '\P{^Block=_ cjkunified	Ideographs}', "");
Expect(0, 19967, '\p{Block=_ cjkunified	Ideographs}', "");
Expect(1, 19967, '\p{^Block=_ cjkunified	Ideographs}', "");
Expect(1, 19967, '\P{Block=_ cjkunified	Ideographs}', "");
Expect(0, 19967, '\P{^Block=_ cjkunified	Ideographs}', "");
Error('\p{Blk= -CJK:=Unified-ideographs}');
Error('\P{Blk= -CJK:=Unified-ideographs}');
Expect(1, 40959, '\p{Blk=cjkunifiedideographs}', "");
Expect(0, 40959, '\p{^Blk=cjkunifiedideographs}', "");
Expect(0, 40959, '\P{Blk=cjkunifiedideographs}', "");
Expect(1, 40959, '\P{^Blk=cjkunifiedideographs}', "");
Expect(0, 19967, '\p{Blk=cjkunifiedideographs}', "");
Expect(1, 19967, '\p{^Blk=cjkunifiedideographs}', "");
Expect(1, 19967, '\P{Blk=cjkunifiedideographs}', "");
Expect(0, 19967, '\P{^Blk=cjkunifiedideographs}', "");
Expect(1, 40959, '\p{Blk= CJK UNIFIED-Ideographs}', "");
Expect(0, 40959, '\p{^Blk= CJK UNIFIED-Ideographs}', "");
Expect(0, 40959, '\P{Blk= CJK UNIFIED-Ideographs}', "");
Expect(1, 40959, '\P{^Blk= CJK UNIFIED-Ideographs}', "");
Expect(0, 19967, '\p{Blk= CJK UNIFIED-Ideographs}', "");
Expect(1, 19967, '\p{^Blk= CJK UNIFIED-Ideographs}', "");
Expect(1, 19967, '\P{Blk= CJK UNIFIED-Ideographs}', "");
Expect(0, 19967, '\P{^Blk= CJK UNIFIED-Ideographs}', "");
Error('\p{Is_Block:_CJKUnified	Ideographs:=}');
Error('\P{Is_Block:_CJKUnified	Ideographs:=}');
Expect(1, 40959, '\p{Is_Block=cjkunifiedideographs}', "");
Expect(0, 40959, '\p{^Is_Block=cjkunifiedideographs}', "");
Expect(0, 40959, '\P{Is_Block=cjkunifiedideographs}', "");
Expect(1, 40959, '\P{^Is_Block=cjkunifiedideographs}', "");
Expect(0, 19967, '\p{Is_Block=cjkunifiedideographs}', "");
Expect(1, 19967, '\p{^Is_Block=cjkunifiedideographs}', "");
Expect(1, 19967, '\P{Is_Block=cjkunifiedideographs}', "");
Expect(0, 19967, '\P{^Is_Block=cjkunifiedideographs}', "");
Expect(1, 40959, '\p{Is_Block=		CJK_Unified IDEOGRAPHS}', "");
Expect(0, 40959, '\p{^Is_Block=		CJK_Unified IDEOGRAPHS}', "");
Expect(0, 40959, '\P{Is_Block=		CJK_Unified IDEOGRAPHS}', "");
Expect(1, 40959, '\P{^Is_Block=		CJK_Unified IDEOGRAPHS}', "");
Expect(0, 19967, '\p{Is_Block=		CJK_Unified IDEOGRAPHS}', "");
Expect(1, 19967, '\p{^Is_Block=		CJK_Unified IDEOGRAPHS}', "");
Expect(1, 19967, '\P{Is_Block=		CJK_Unified IDEOGRAPHS}', "");
Expect(0, 19967, '\P{^Is_Block=		CJK_Unified IDEOGRAPHS}', "");
Error('\p{Is_Blk=		cjk:=Unified ideographs}');
Error('\P{Is_Blk=		cjk:=Unified ideographs}');
Expect(1, 40959, '\p{Is_Blk=cjkunifiedideographs}', "");
Expect(0, 40959, '\p{^Is_Blk=cjkunifiedideographs}', "");
Expect(0, 40959, '\P{Is_Blk=cjkunifiedideographs}', "");
Expect(1, 40959, '\P{^Is_Blk=cjkunifiedideographs}', "");
Expect(0, 19967, '\p{Is_Blk=cjkunifiedideographs}', "");
Expect(1, 19967, '\p{^Is_Blk=cjkunifiedideographs}', "");
Expect(1, 19967, '\P{Is_Blk=cjkunifiedideographs}', "");
Expect(0, 19967, '\P{^Is_Blk=cjkunifiedideographs}', "");
Expect(1, 40959, '\p{Is_Blk=_-cjk Unified IDEOGRAPHS}', "");
Expect(0, 40959, '\p{^Is_Blk=_-cjk Unified IDEOGRAPHS}', "");
Expect(0, 40959, '\P{Is_Blk=_-cjk Unified IDEOGRAPHS}', "");
Expect(1, 40959, '\P{^Is_Blk=_-cjk Unified IDEOGRAPHS}', "");
Expect(0, 19967, '\p{Is_Blk=_-cjk Unified IDEOGRAPHS}', "");
Expect(1, 19967, '\p{^Is_Blk=_-cjk Unified IDEOGRAPHS}', "");
Expect(1, 19967, '\P{Is_Blk=_-cjk Unified IDEOGRAPHS}', "");
Expect(0, 19967, '\P{^Is_Blk=_-cjk Unified IDEOGRAPHS}', "");
Error('\p{Block= :=ANCIENT-SYMBOLS}');
Error('\P{Block= :=ANCIENT-SYMBOLS}');
Expect(1, 65999, '\p{Block:	ancientsymbols}', "");
Expect(0, 65999, '\p{^Block:	ancientsymbols}', "");
Expect(0, 65999, '\P{Block:	ancientsymbols}', "");
Expect(1, 65999, '\P{^Block:	ancientsymbols}', "");
Expect(0, 65935, '\p{Block:	ancientsymbols}', "");
Expect(1, 65935, '\p{^Block:	ancientsymbols}', "");
Expect(1, 65935, '\P{Block:	ancientsymbols}', "");
Expect(0, 65935, '\P{^Block:	ancientsymbols}', "");
Expect(1, 65999, '\p{Block=-	ANCIENT_symbols}', "");
Expect(0, 65999, '\p{^Block=-	ANCIENT_symbols}', "");
Expect(0, 65999, '\P{Block=-	ANCIENT_symbols}', "");
Expect(1, 65999, '\P{^Block=-	ANCIENT_symbols}', "");
Expect(0, 65935, '\p{Block=-	ANCIENT_symbols}', "");
Expect(1, 65935, '\p{^Block=-	ANCIENT_symbols}', "");
Expect(1, 65935, '\P{Block=-	ANCIENT_symbols}', "");
Expect(0, 65935, '\P{^Block=-	ANCIENT_symbols}', "");
Error('\p{Blk=	-ancient/a/symbols}');
Error('\P{Blk=	-ancient/a/symbols}');
Expect(1, 65999, '\p{Blk=ancientsymbols}', "");
Expect(0, 65999, '\p{^Blk=ancientsymbols}', "");
Expect(0, 65999, '\P{Blk=ancientsymbols}', "");
Expect(1, 65999, '\P{^Blk=ancientsymbols}', "");
Expect(0, 65935, '\p{Blk=ancientsymbols}', "");
Expect(1, 65935, '\p{^Blk=ancientsymbols}', "");
Expect(1, 65935, '\P{Blk=ancientsymbols}', "");
Expect(0, 65935, '\P{^Blk=ancientsymbols}', "");
Expect(1, 65999, '\p{Blk=	Ancient_SYMBOLS}', "");
Expect(0, 65999, '\p{^Blk=	Ancient_SYMBOLS}', "");
Expect(0, 65999, '\P{Blk=	Ancient_SYMBOLS}', "");
Expect(1, 65999, '\P{^Blk=	Ancient_SYMBOLS}', "");
Expect(0, 65935, '\p{Blk=	Ancient_SYMBOLS}', "");
Expect(1, 65935, '\p{^Blk=	Ancient_SYMBOLS}', "");
Expect(1, 65935, '\P{Blk=	Ancient_SYMBOLS}', "");
Expect(0, 65935, '\P{^Blk=	Ancient_SYMBOLS}', "");
Error('\p{Is_Block=-	AncientSymbols/a/}');
Error('\P{Is_Block=-	AncientSymbols/a/}');
Expect(1, 65999, '\p{Is_Block=ancientsymbols}', "");
Expect(0, 65999, '\p{^Is_Block=ancientsymbols}', "");
Expect(0, 65999, '\P{Is_Block=ancientsymbols}', "");
Expect(1, 65999, '\P{^Is_Block=ancientsymbols}', "");
Expect(0, 65935, '\p{Is_Block=ancientsymbols}', "");
Expect(1, 65935, '\p{^Is_Block=ancientsymbols}', "");
Expect(1, 65935, '\P{Is_Block=ancientsymbols}', "");
Expect(0, 65935, '\P{^Is_Block=ancientsymbols}', "");
Expect(1, 65999, '\p{Is_Block=	-Ancient-Symbols}', "");
Expect(0, 65999, '\p{^Is_Block=	-Ancient-Symbols}', "");
Expect(0, 65999, '\P{Is_Block=	-Ancient-Symbols}', "");
Expect(1, 65999, '\P{^Is_Block=	-Ancient-Symbols}', "");
Expect(0, 65935, '\p{Is_Block=	-Ancient-Symbols}', "");
Expect(1, 65935, '\p{^Is_Block=	-Ancient-Symbols}', "");
Expect(1, 65935, '\P{Is_Block=	-Ancient-Symbols}', "");
Expect(0, 65935, '\P{^Is_Block=	-Ancient-Symbols}', "");
Error('\p{Is_Blk=:=ANCIENT SYMBOLS}');
Error('\P{Is_Blk=:=ANCIENT SYMBOLS}');
Expect(1, 65999, '\p{Is_Blk=ancientsymbols}', "");
Expect(0, 65999, '\p{^Is_Blk=ancientsymbols}', "");
Expect(0, 65999, '\P{Is_Blk=ancientsymbols}', "");
Expect(1, 65999, '\P{^Is_Blk=ancientsymbols}', "");
Expect(0, 65935, '\p{Is_Blk=ancientsymbols}', "");
Expect(1, 65935, '\p{^Is_Blk=ancientsymbols}', "");
Expect(1, 65935, '\P{Is_Blk=ancientsymbols}', "");
Expect(0, 65935, '\P{^Is_Blk=ancientsymbols}', "");
Expect(1, 65999, '\p{Is_Blk=_Ancient	symbols}', "");
Expect(0, 65999, '\p{^Is_Blk=_Ancient	symbols}', "");
Expect(0, 65999, '\P{Is_Blk=_Ancient	symbols}', "");
Expect(1, 65999, '\P{^Is_Blk=_Ancient	symbols}', "");
Expect(0, 65935, '\p{Is_Blk=_Ancient	symbols}', "");
Expect(1, 65935, '\p{^Is_Blk=_Ancient	symbols}', "");
Expect(1, 65935, '\P{Is_Blk=_Ancient	symbols}', "");
Expect(0, 65935, '\P{^Is_Blk=_Ancient	symbols}', "");
Error('\p{Block=:=- Gothic}');
Error('\P{Block=:=- Gothic}');
Expect(1, 66383, '\p{Block=gothic}', "");
Expect(0, 66383, '\p{^Block=gothic}', "");
Expect(0, 66383, '\P{Block=gothic}', "");
Expect(1, 66383, '\P{^Block=gothic}', "");
Expect(0, 66351, '\p{Block=gothic}', "");
Expect(1, 66351, '\p{^Block=gothic}', "");
Expect(1, 66351, '\P{Block=gothic}', "");
Expect(0, 66351, '\P{^Block=gothic}', "");
Expect(1, 66383, '\p{Block=_gothic}', "");
Expect(0, 66383, '\p{^Block=_gothic}', "");
Expect(0, 66383, '\P{Block=_gothic}', "");
Expect(1, 66383, '\P{^Block=_gothic}', "");
Expect(0, 66351, '\p{Block=_gothic}', "");
Expect(1, 66351, '\p{^Block=_gothic}', "");
Expect(1, 66351, '\P{Block=_gothic}', "");
Expect(0, 66351, '\P{^Block=_gothic}', "");
Error('\p{Blk=:=	Gothic}');
Error('\P{Blk=:=	Gothic}');
Expect(1, 66383, '\p{Blk=gothic}', "");
Expect(0, 66383, '\p{^Blk=gothic}', "");
Expect(0, 66383, '\P{Blk=gothic}', "");
Expect(1, 66383, '\P{^Blk=gothic}', "");
Expect(0, 66351, '\p{Blk=gothic}', "");
Expect(1, 66351, '\p{^Blk=gothic}', "");
Expect(1, 66351, '\P{Blk=gothic}', "");
Expect(0, 66351, '\P{^Blk=gothic}', "");
Expect(1, 66383, '\p{Blk=-_Gothic}', "");
Expect(0, 66383, '\p{^Blk=-_Gothic}', "");
Expect(0, 66383, '\P{Blk=-_Gothic}', "");
Expect(1, 66383, '\P{^Blk=-_Gothic}', "");
Expect(0, 66351, '\p{Blk=-_Gothic}', "");
Expect(1, 66351, '\p{^Blk=-_Gothic}', "");
Expect(1, 66351, '\P{Blk=-_Gothic}', "");
Expect(0, 66351, '\P{^Blk=-_Gothic}', "");
Error('\p{Is_Block=:=Gothic}');
Error('\P{Is_Block=:=Gothic}');
Expect(1, 66383, '\p{Is_Block=gothic}', "");
Expect(0, 66383, '\p{^Is_Block=gothic}', "");
Expect(0, 66383, '\P{Is_Block=gothic}', "");
Expect(1, 66383, '\P{^Is_Block=gothic}', "");
Expect(0, 66351, '\p{Is_Block=gothic}', "");
Expect(1, 66351, '\p{^Is_Block=gothic}', "");
Expect(1, 66351, '\P{Is_Block=gothic}', "");
Expect(0, 66351, '\P{^Is_Block=gothic}', "");
Expect(1, 66383, '\p{Is_Block= GOTHIC}', "");
Expect(0, 66383, '\p{^Is_Block= GOTHIC}', "");
Expect(0, 66383, '\P{Is_Block= GOTHIC}', "");
Expect(1, 66383, '\P{^Is_Block= GOTHIC}', "");
Expect(0, 66351, '\p{Is_Block= GOTHIC}', "");
Expect(1, 66351, '\p{^Is_Block= GOTHIC}', "");
Expect(1, 66351, '\P{Is_Block= GOTHIC}', "");
Expect(0, 66351, '\P{^Is_Block= GOTHIC}', "");
Error('\p{Is_Blk=:=GOTHIC}');
Error('\P{Is_Blk=:=GOTHIC}');
Expect(1, 66383, '\p{Is_Blk=gothic}', "");
Expect(0, 66383, '\p{^Is_Blk=gothic}', "");
Expect(0, 66383, '\P{Is_Blk=gothic}', "");
Expect(1, 66383, '\P{^Is_Blk=gothic}', "");
Expect(0, 66351, '\p{Is_Blk=gothic}', "");
Expect(1, 66351, '\p{^Is_Blk=gothic}', "");
Expect(1, 66351, '\P{Is_Blk=gothic}', "");
Expect(0, 66351, '\P{^Is_Blk=gothic}', "");
Expect(1, 66383, '\p{Is_Blk=_-Gothic}', "");
Expect(0, 66383, '\p{^Is_Blk=_-Gothic}', "");
Expect(0, 66383, '\P{Is_Blk=_-Gothic}', "");
Expect(1, 66383, '\P{^Is_Blk=_-Gothic}', "");
Expect(0, 66351, '\p{Is_Blk=_-Gothic}', "");
Expect(1, 66351, '\p{^Is_Blk=_-Gothic}', "");
Expect(1, 66351, '\P{Is_Blk=_-Gothic}', "");
Expect(0, 66351, '\P{^Is_Blk=_-Gothic}', "");
Error('\p{Block=_:=ETHIOPIC}');
Error('\P{Block=_:=ETHIOPIC}');
Expect(1, 4991, '\p{Block=ethiopic}', "");
Expect(0, 4991, '\p{^Block=ethiopic}', "");
Expect(0, 4991, '\P{Block=ethiopic}', "");
Expect(1, 4991, '\P{^Block=ethiopic}', "");
Expect(0, 4607, '\p{Block=ethiopic}', "");
Expect(1, 4607, '\p{^Block=ethiopic}', "");
Expect(1, 4607, '\P{Block=ethiopic}', "");
Expect(0, 4607, '\P{^Block=ethiopic}', "");
Expect(1, 4991, '\p{Block= Ethiopic}', "");
Expect(0, 4991, '\p{^Block= Ethiopic}', "");
Expect(0, 4991, '\P{Block= Ethiopic}', "");
Expect(1, 4991, '\P{^Block= Ethiopic}', "");
Expect(0, 4607, '\p{Block= Ethiopic}', "");
Expect(1, 4607, '\p{^Block= Ethiopic}', "");
Expect(1, 4607, '\P{Block= Ethiopic}', "");
Expect(0, 4607, '\P{^Block= Ethiopic}', "");
Error('\p{Blk=-	Ethiopic/a/}');
Error('\P{Blk=-	Ethiopic/a/}');
Expect(1, 4991, '\p{Blk=ethiopic}', "");
Expect(0, 4991, '\p{^Blk=ethiopic}', "");
Expect(0, 4991, '\P{Blk=ethiopic}', "");
Expect(1, 4991, '\P{^Blk=ethiopic}', "");
Expect(0, 4607, '\p{Blk=ethiopic}', "");
Expect(1, 4607, '\p{^Blk=ethiopic}', "");
Expect(1, 4607, '\P{Blk=ethiopic}', "");
Expect(0, 4607, '\P{^Blk=ethiopic}', "");
Expect(1, 4991, '\p{Blk=		ETHIOPIC}', "");
Expect(0, 4991, '\p{^Blk=		ETHIOPIC}', "");
Expect(0, 4991, '\P{Blk=		ETHIOPIC}', "");
Expect(1, 4991, '\P{^Blk=		ETHIOPIC}', "");
Expect(0, 4607, '\p{Blk=		ETHIOPIC}', "");
Expect(1, 4607, '\p{^Blk=		ETHIOPIC}', "");
Expect(1, 4607, '\P{Blk=		ETHIOPIC}', "");
Expect(0, 4607, '\P{^Blk=		ETHIOPIC}', "");
Error('\p{Is_Block:_/a/ETHIOPIC}');
Error('\P{Is_Block:_/a/ETHIOPIC}');
Expect(1, 4991, '\p{Is_Block=ethiopic}', "");
Expect(0, 4991, '\p{^Is_Block=ethiopic}', "");
Expect(0, 4991, '\P{Is_Block=ethiopic}', "");
Expect(1, 4991, '\P{^Is_Block=ethiopic}', "");
Expect(0, 4607, '\p{Is_Block=ethiopic}', "");
Expect(1, 4607, '\p{^Is_Block=ethiopic}', "");
Expect(1, 4607, '\P{Is_Block=ethiopic}', "");
Expect(0, 4607, '\P{^Is_Block=ethiopic}', "");
Expect(1, 4991, '\p{Is_Block= Ethiopic}', "");
Expect(0, 4991, '\p{^Is_Block= Ethiopic}', "");
Expect(0, 4991, '\P{Is_Block= Ethiopic}', "");
Expect(1, 4991, '\P{^Is_Block= Ethiopic}', "");
Expect(0, 4607, '\p{Is_Block= Ethiopic}', "");
Expect(1, 4607, '\p{^Is_Block= Ethiopic}', "");
Expect(1, 4607, '\P{Is_Block= Ethiopic}', "");
Expect(0, 4607, '\P{^Is_Block= Ethiopic}', "");
Error('\p{Is_Blk=/a/_ Ethiopic}');
Error('\P{Is_Blk=/a/_ Ethiopic}');
Expect(1, 4991, '\p{Is_Blk=ethiopic}', "");
Expect(0, 4991, '\p{^Is_Blk=ethiopic}', "");
Expect(0, 4991, '\P{Is_Blk=ethiopic}', "");
Expect(1, 4991, '\P{^Is_Blk=ethiopic}', "");
Expect(0, 4607, '\p{Is_Blk=ethiopic}', "");
Expect(1, 4607, '\p{^Is_Blk=ethiopic}', "");
Expect(1, 4607, '\P{Is_Blk=ethiopic}', "");
Expect(0, 4607, '\P{^Is_Blk=ethiopic}', "");
Expect(1, 4991, '\p{Is_Blk=_Ethiopic}', "");
Expect(0, 4991, '\p{^Is_Blk=_Ethiopic}', "");
Expect(0, 4991, '\P{Is_Blk=_Ethiopic}', "");
Expect(1, 4991, '\P{^Is_Blk=_Ethiopic}', "");
Expect(0, 4607, '\p{Is_Blk=_Ethiopic}', "");
Expect(1, 4607, '\p{^Is_Blk=_Ethiopic}', "");
Expect(1, 4607, '\P{Is_Blk=_Ethiopic}', "");
Expect(0, 4607, '\P{^Is_Blk=_Ethiopic}', "");
Error('\p{Block=_ BUGINESE:=}');
Error('\P{Block=_ BUGINESE:=}');
Expect(1, 6687, '\p{Block=buginese}', "");
Expect(0, 6687, '\p{^Block=buginese}', "");
Expect(0, 6687, '\P{Block=buginese}', "");
Expect(1, 6687, '\P{^Block=buginese}', "");
Expect(0, 6655, '\p{Block=buginese}', "");
Expect(1, 6655, '\p{^Block=buginese}', "");
Expect(1, 6655, '\P{Block=buginese}', "");
Expect(0, 6655, '\P{^Block=buginese}', "");
Expect(1, 6687, '\p{Block=	BUGINESE}', "");
Expect(0, 6687, '\p{^Block=	BUGINESE}', "");
Expect(0, 6687, '\P{Block=	BUGINESE}', "");
Expect(1, 6687, '\P{^Block=	BUGINESE}', "");
Expect(0, 6655, '\p{Block=	BUGINESE}', "");
Expect(1, 6655, '\p{^Block=	BUGINESE}', "");
Expect(1, 6655, '\P{Block=	BUGINESE}', "");
Expect(0, 6655, '\P{^Block=	BUGINESE}', "");
Error('\p{Blk= :=Buginese}');
Error('\P{Blk= :=Buginese}');
Expect(1, 6687, '\p{Blk=buginese}', "");
Expect(0, 6687, '\p{^Blk=buginese}', "");
Expect(0, 6687, '\P{Blk=buginese}', "");
Expect(1, 6687, '\P{^Blk=buginese}', "");
Expect(0, 6655, '\p{Blk=buginese}', "");
Expect(1, 6655, '\p{^Blk=buginese}', "");
Expect(1, 6655, '\P{Blk=buginese}', "");
Expect(0, 6655, '\P{^Blk=buginese}', "");
Expect(1, 6687, '\p{Blk:	 Buginese}', "");
Expect(0, 6687, '\p{^Blk:	 Buginese}', "");
Expect(0, 6687, '\P{Blk:	 Buginese}', "");
Expect(1, 6687, '\P{^Blk:	 Buginese}', "");
Expect(0, 6655, '\p{Blk:	 Buginese}', "");
Expect(1, 6655, '\p{^Blk:	 Buginese}', "");
Expect(1, 6655, '\P{Blk:	 Buginese}', "");
Expect(0, 6655, '\P{^Blk:	 Buginese}', "");
Error('\p{Is_Block=/a/ buginese}');
Error('\P{Is_Block=/a/ buginese}');
Expect(1, 6687, '\p{Is_Block=buginese}', "");
Expect(0, 6687, '\p{^Is_Block=buginese}', "");
Expect(0, 6687, '\P{Is_Block=buginese}', "");
Expect(1, 6687, '\P{^Is_Block=buginese}', "");
Expect(0, 6655, '\p{Is_Block=buginese}', "");
Expect(1, 6655, '\p{^Is_Block=buginese}', "");
Expect(1, 6655, '\P{Is_Block=buginese}', "");
Expect(0, 6655, '\P{^Is_Block=buginese}', "");
Expect(1, 6687, '\p{Is_Block:	 	Buginese}', "");
Expect(0, 6687, '\p{^Is_Block:	 	Buginese}', "");
Expect(0, 6687, '\P{Is_Block:	 	Buginese}', "");
Expect(1, 6687, '\P{^Is_Block:	 	Buginese}', "");
Expect(0, 6655, '\p{Is_Block:	 	Buginese}', "");
Expect(1, 6655, '\p{^Is_Block:	 	Buginese}', "");
Expect(1, 6655, '\P{Is_Block:	 	Buginese}', "");
Expect(0, 6655, '\P{^Is_Block:	 	Buginese}', "");
Error('\p{Is_Blk=	/a/BUGINESE}');
Error('\P{Is_Blk=	/a/BUGINESE}');
Expect(1, 6687, '\p{Is_Blk:   buginese}', "");
Expect(0, 6687, '\p{^Is_Blk:   buginese}', "");
Expect(0, 6687, '\P{Is_Blk:   buginese}', "");
Expect(1, 6687, '\P{^Is_Blk:   buginese}', "");
Expect(0, 6655, '\p{Is_Blk:   buginese}', "");
Expect(1, 6655, '\p{^Is_Blk:   buginese}', "");
Expect(1, 6655, '\P{Is_Blk:   buginese}', "");
Expect(0, 6655, '\P{^Is_Blk:   buginese}', "");
Expect(1, 6687, '\p{Is_Blk=--BUGINESE}', "");
Expect(0, 6687, '\p{^Is_Blk=--BUGINESE}', "");
Expect(0, 6687, '\P{Is_Blk=--BUGINESE}', "");
Expect(1, 6687, '\P{^Is_Blk=--BUGINESE}', "");
Expect(0, 6655, '\p{Is_Blk=--BUGINESE}', "");
Expect(1, 6655, '\p{^Is_Blk=--BUGINESE}', "");
Expect(1, 6655, '\P{Is_Blk=--BUGINESE}', "");
Expect(0, 6655, '\P{^Is_Blk=--BUGINESE}', "");
Error('\p{Block=-	MATHEMATICAL:=Alphanumeric	Symbols}');
Error('\P{Block=-	MATHEMATICAL:=Alphanumeric	Symbols}');
Expect(1, 120831, '\p{Block=mathematicalalphanumericsymbols}', "");
Expect(0, 120831, '\p{^Block=mathematicalalphanumericsymbols}', "");
Expect(0, 120831, '\P{Block=mathematicalalphanumericsymbols}', "");
Expect(1, 120831, '\P{^Block=mathematicalalphanumericsymbols}', "");
Expect(0, 119807, '\p{Block=mathematicalalphanumericsymbols}', "");
Expect(1, 119807, '\p{^Block=mathematicalalphanumericsymbols}', "");
Expect(1, 119807, '\P{Block=mathematicalalphanumericsymbols}', "");
Expect(0, 119807, '\P{^Block=mathematicalalphanumericsymbols}', "");
Expect(1, 120831, '\p{Block= MathematicalAlphanumericSYMBOLS}', "");
Expect(0, 120831, '\p{^Block= MathematicalAlphanumericSYMBOLS}', "");
Expect(0, 120831, '\P{Block= MathematicalAlphanumericSYMBOLS}', "");
Expect(1, 120831, '\P{^Block= MathematicalAlphanumericSYMBOLS}', "");
Expect(0, 119807, '\p{Block= MathematicalAlphanumericSYMBOLS}', "");
Expect(1, 119807, '\p{^Block= MathematicalAlphanumericSYMBOLS}', "");
Expect(1, 119807, '\P{Block= MathematicalAlphanumericSYMBOLS}', "");
Expect(0, 119807, '\P{^Block= MathematicalAlphanumericSYMBOLS}', "");
Error('\p{Blk=	-MATHEMATICAL/a/ALPHANUMERIC	symbols}');
Error('\P{Blk=	-MATHEMATICAL/a/ALPHANUMERIC	symbols}');
Expect(1, 120831, '\p{Blk=mathematicalalphanumericsymbols}', "");
Expect(0, 120831, '\p{^Blk=mathematicalalphanumericsymbols}', "");
Expect(0, 120831, '\P{Blk=mathematicalalphanumericsymbols}', "");
Expect(1, 120831, '\P{^Blk=mathematicalalphanumericsymbols}', "");
Expect(0, 119807, '\p{Blk=mathematicalalphanumericsymbols}', "");
Expect(1, 119807, '\p{^Blk=mathematicalalphanumericsymbols}', "");
Expect(1, 119807, '\P{Blk=mathematicalalphanumericsymbols}', "");
Expect(0, 119807, '\P{^Blk=mathematicalalphanumericsymbols}', "");
Expect(1, 120831, '\p{Blk= Mathematical	Alphanumeric symbols}', "");
Expect(0, 120831, '\p{^Blk= Mathematical	Alphanumeric symbols}', "");
Expect(0, 120831, '\P{Blk= Mathematical	Alphanumeric symbols}', "");
Expect(1, 120831, '\P{^Blk= Mathematical	Alphanumeric symbols}', "");
Expect(0, 119807, '\p{Blk= Mathematical	Alphanumeric symbols}', "");
Expect(1, 119807, '\p{^Blk= Mathematical	Alphanumeric symbols}', "");
Expect(1, 119807, '\P{Blk= Mathematical	Alphanumeric symbols}', "");
Expect(0, 119807, '\P{^Blk= Mathematical	Alphanumeric symbols}', "");
Error('\p{Is_Block=	/a/mathematical_AlphanumericSymbols}');
Error('\P{Is_Block=	/a/mathematical_AlphanumericSymbols}');
Expect(1, 120831, '\p{Is_Block=mathematicalalphanumericsymbols}', "");
Expect(0, 120831, '\p{^Is_Block=mathematicalalphanumericsymbols}', "");
Expect(0, 120831, '\P{Is_Block=mathematicalalphanumericsymbols}', "");
Expect(1, 120831, '\P{^Is_Block=mathematicalalphanumericsymbols}', "");
Expect(0, 119807, '\p{Is_Block=mathematicalalphanumericsymbols}', "");
Expect(1, 119807, '\p{^Is_Block=mathematicalalphanumericsymbols}', "");
Expect(1, 119807, '\P{Is_Block=mathematicalalphanumericsymbols}', "");
Expect(0, 119807, '\P{^Is_Block=mathematicalalphanumericsymbols}', "");
Expect(1, 120831, '\p{Is_Block:_Mathematical Alphanumeric_Symbols}', "");
Expect(0, 120831, '\p{^Is_Block:_Mathematical Alphanumeric_Symbols}', "");
Expect(0, 120831, '\P{Is_Block:_Mathematical Alphanumeric_Symbols}', "");
Expect(1, 120831, '\P{^Is_Block:_Mathematical Alphanumeric_Symbols}', "");
Expect(0, 119807, '\p{Is_Block:_Mathematical Alphanumeric_Symbols}', "");
Expect(1, 119807, '\p{^Is_Block:_Mathematical Alphanumeric_Symbols}', "");
Expect(1, 119807, '\P{Is_Block:_Mathematical Alphanumeric_Symbols}', "");
Expect(0, 119807, '\P{^Is_Block:_Mathematical Alphanumeric_Symbols}', "");
Error('\p{Is_Blk=		MATHEMATICAL:=ALPHANUMERIC-symbols}');
Error('\P{Is_Blk=		MATHEMATICAL:=ALPHANUMERIC-symbols}');
Expect(1, 120831, '\p{Is_Blk=mathematicalalphanumericsymbols}', "");
Expect(0, 120831, '\p{^Is_Blk=mathematicalalphanumericsymbols}', "");
Expect(0, 120831, '\P{Is_Blk=mathematicalalphanumericsymbols}', "");
Expect(1, 120831, '\P{^Is_Blk=mathematicalalphanumericsymbols}', "");
Expect(0, 119807, '\p{Is_Blk=mathematicalalphanumericsymbols}', "");
Expect(1, 119807, '\p{^Is_Blk=mathematicalalphanumericsymbols}', "");
Expect(1, 119807, '\P{Is_Blk=mathematicalalphanumericsymbols}', "");
Expect(0, 119807, '\P{^Is_Blk=mathematicalalphanumericsymbols}', "");
Expect(1, 120831, '\p{Is_Blk=- MathematicalALPHANUMERIC_Symbols}', "");
Expect(0, 120831, '\p{^Is_Blk=- MathematicalALPHANUMERIC_Symbols}', "");
Expect(0, 120831, '\P{Is_Blk=- MathematicalALPHANUMERIC_Symbols}', "");
Expect(1, 120831, '\P{^Is_Blk=- MathematicalALPHANUMERIC_Symbols}', "");
Expect(0, 119807, '\p{Is_Blk=- MathematicalALPHANUMERIC_Symbols}', "");
Expect(1, 119807, '\p{^Is_Blk=- MathematicalALPHANUMERIC_Symbols}', "");
Expect(1, 119807, '\P{Is_Blk=- MathematicalALPHANUMERIC_Symbols}', "");
Expect(0, 119807, '\P{^Is_Blk=- MathematicalALPHANUMERIC_Symbols}', "");
Error('\p{Block:	 _Inscriptional	Pahlavi:=}');
Error('\P{Block:	 _Inscriptional	Pahlavi:=}');
Expect(1, 68479, '\p{Block=inscriptionalpahlavi}', "");
Expect(0, 68479, '\p{^Block=inscriptionalpahlavi}', "");
Expect(0, 68479, '\P{Block=inscriptionalpahlavi}', "");
Expect(1, 68479, '\P{^Block=inscriptionalpahlavi}', "");
Expect(0, 68447, '\p{Block=inscriptionalpahlavi}', "");
Expect(1, 68447, '\p{^Block=inscriptionalpahlavi}', "");
Expect(1, 68447, '\P{Block=inscriptionalpahlavi}', "");
Expect(0, 68447, '\P{^Block=inscriptionalpahlavi}', "");
Expect(1, 68479, '\p{Block=		Inscriptional	Pahlavi}', "");
Expect(0, 68479, '\p{^Block=		Inscriptional	Pahlavi}', "");
Expect(0, 68479, '\P{Block=		Inscriptional	Pahlavi}', "");
Expect(1, 68479, '\P{^Block=		Inscriptional	Pahlavi}', "");
Expect(0, 68447, '\p{Block=		Inscriptional	Pahlavi}', "");
Expect(1, 68447, '\p{^Block=		Inscriptional	Pahlavi}', "");
Expect(1, 68447, '\P{Block=		Inscriptional	Pahlavi}', "");
Expect(0, 68447, '\P{^Block=		Inscriptional	Pahlavi}', "");
Error('\p{Blk=/a/_Inscriptional_Pahlavi}');
Error('\P{Blk=/a/_Inscriptional_Pahlavi}');
Expect(1, 68479, '\p{Blk=inscriptionalpahlavi}', "");
Expect(0, 68479, '\p{^Blk=inscriptionalpahlavi}', "");
Expect(0, 68479, '\P{Blk=inscriptionalpahlavi}', "");
Expect(1, 68479, '\P{^Blk=inscriptionalpahlavi}', "");
Expect(0, 68447, '\p{Blk=inscriptionalpahlavi}', "");
Expect(1, 68447, '\p{^Blk=inscriptionalpahlavi}', "");
Expect(1, 68447, '\P{Blk=inscriptionalpahlavi}', "");
Expect(0, 68447, '\P{^Blk=inscriptionalpahlavi}', "");
Expect(1, 68479, '\p{Blk=INSCRIPTIONAL	Pahlavi}', "");
Expect(0, 68479, '\p{^Blk=INSCRIPTIONAL	Pahlavi}', "");
Expect(0, 68479, '\P{Blk=INSCRIPTIONAL	Pahlavi}', "");
Expect(1, 68479, '\P{^Blk=INSCRIPTIONAL	Pahlavi}', "");
Expect(0, 68447, '\p{Blk=INSCRIPTIONAL	Pahlavi}', "");
Expect(1, 68447, '\p{^Blk=INSCRIPTIONAL	Pahlavi}', "");
Expect(1, 68447, '\P{Blk=INSCRIPTIONAL	Pahlavi}', "");
Expect(0, 68447, '\P{^Blk=INSCRIPTIONAL	Pahlavi}', "");
Error('\p{Is_Block:	 _inscriptional Pahlavi/a/}');
Error('\P{Is_Block:	 _inscriptional Pahlavi/a/}');
Expect(1, 68479, '\p{Is_Block=inscriptionalpahlavi}', "");
Expect(0, 68479, '\p{^Is_Block=inscriptionalpahlavi}', "");
Expect(0, 68479, '\P{Is_Block=inscriptionalpahlavi}', "");
Expect(1, 68479, '\P{^Is_Block=inscriptionalpahlavi}', "");
Expect(0, 68447, '\p{Is_Block=inscriptionalpahlavi}', "");
Expect(1, 68447, '\p{^Is_Block=inscriptionalpahlavi}', "");
Expect(1, 68447, '\P{Is_Block=inscriptionalpahlavi}', "");
Expect(0, 68447, '\P{^Is_Block=inscriptionalpahlavi}', "");
Expect(1, 68479, '\p{Is_Block=_inscriptionalpahlavi}', "");
Expect(0, 68479, '\p{^Is_Block=_inscriptionalpahlavi}', "");
Expect(0, 68479, '\P{Is_Block=_inscriptionalpahlavi}', "");
Expect(1, 68479, '\P{^Is_Block=_inscriptionalpahlavi}', "");
Expect(0, 68447, '\p{Is_Block=_inscriptionalpahlavi}', "");
Expect(1, 68447, '\p{^Is_Block=_inscriptionalpahlavi}', "");
Expect(1, 68447, '\P{Is_Block=_inscriptionalpahlavi}', "");
Expect(0, 68447, '\P{^Is_Block=_inscriptionalpahlavi}', "");
Error('\p{Is_Blk= _Inscriptional-pahlavi:=}');
Error('\P{Is_Blk= _Inscriptional-pahlavi:=}');
Expect(1, 68479, '\p{Is_Blk=inscriptionalpahlavi}', "");
Expect(0, 68479, '\p{^Is_Blk=inscriptionalpahlavi}', "");
Expect(0, 68479, '\P{Is_Blk=inscriptionalpahlavi}', "");
Expect(1, 68479, '\P{^Is_Blk=inscriptionalpahlavi}', "");
Expect(0, 68447, '\p{Is_Blk=inscriptionalpahlavi}', "");
Expect(1, 68447, '\p{^Is_Blk=inscriptionalpahlavi}', "");
Expect(1, 68447, '\P{Is_Blk=inscriptionalpahlavi}', "");
Expect(0, 68447, '\P{^Is_Blk=inscriptionalpahlavi}', "");
Expect(1, 68479, '\p{Is_Blk=_	InscriptionalPahlavi}', "");
Expect(0, 68479, '\p{^Is_Blk=_	InscriptionalPahlavi}', "");
Expect(0, 68479, '\P{Is_Blk=_	InscriptionalPahlavi}', "");
Expect(1, 68479, '\P{^Is_Blk=_	InscriptionalPahlavi}', "");
Expect(0, 68447, '\p{Is_Blk=_	InscriptionalPahlavi}', "");
Expect(1, 68447, '\p{^Is_Blk=_	InscriptionalPahlavi}', "");
Expect(1, 68447, '\P{Is_Blk=_	InscriptionalPahlavi}', "");
Expect(0, 68447, '\P{^Is_Blk=_	InscriptionalPahlavi}', "");
Error('\p{Block= /a/Unified_CANADIAN-Aboriginal_syllabics-Extended}');
Error('\P{Block= /a/Unified_CANADIAN-Aboriginal_syllabics-Extended}');
Expect(1, 6399, '\p{Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6399, '\p{^Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6399, '\P{Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6399, '\P{^Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6319, '\p{Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6319, '\p{^Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6319, '\P{Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6319, '\P{^Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6399, '\p{Block= unifiedCanadianAboriginalSYLLABICSEXTENDED}', "");
Expect(0, 6399, '\p{^Block= unifiedCanadianAboriginalSYLLABICSEXTENDED}', "");
Expect(0, 6399, '\P{Block= unifiedCanadianAboriginalSYLLABICSEXTENDED}', "");
Expect(1, 6399, '\P{^Block= unifiedCanadianAboriginalSYLLABICSEXTENDED}', "");
Expect(0, 6319, '\p{Block= unifiedCanadianAboriginalSYLLABICSEXTENDED}', "");
Expect(1, 6319, '\p{^Block= unifiedCanadianAboriginalSYLLABICSEXTENDED}', "");
Expect(1, 6319, '\P{Block= unifiedCanadianAboriginalSYLLABICSEXTENDED}', "");
Expect(0, 6319, '\P{^Block= unifiedCanadianAboriginalSYLLABICSEXTENDED}', "");
Error('\p{Blk=_ UnifiedCanadian:=ABORIGINAL	Syllabics-Extended}');
Error('\P{Blk=_ UnifiedCanadian:=ABORIGINAL	Syllabics-Extended}');
Expect(1, 6399, '\p{Blk=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6399, '\p{^Blk=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6399, '\P{Blk=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6399, '\P{^Blk=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6319, '\p{Blk=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6319, '\p{^Blk=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6319, '\P{Blk=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6319, '\P{^Blk=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6399, '\p{Blk:    	UNIFIED	CANADIANAboriginal SYLLABICS-extended}', "");
Expect(0, 6399, '\p{^Blk:    	UNIFIED	CANADIANAboriginal SYLLABICS-extended}', "");
Expect(0, 6399, '\P{Blk:    	UNIFIED	CANADIANAboriginal SYLLABICS-extended}', "");
Expect(1, 6399, '\P{^Blk:    	UNIFIED	CANADIANAboriginal SYLLABICS-extended}', "");
Expect(0, 6319, '\p{Blk:    	UNIFIED	CANADIANAboriginal SYLLABICS-extended}', "");
Expect(1, 6319, '\p{^Blk:    	UNIFIED	CANADIANAboriginal SYLLABICS-extended}', "");
Expect(1, 6319, '\P{Blk:    	UNIFIED	CANADIANAboriginal SYLLABICS-extended}', "");
Expect(0, 6319, '\P{^Blk:    	UNIFIED	CANADIANAboriginal SYLLABICS-extended}', "");
Error('\p{Is_Block=-Unified-Canadian/a/Aboriginal-syllabics Extended}');
Error('\P{Is_Block=-Unified-Canadian/a/Aboriginal-syllabics Extended}');
Expect(1, 6399, '\p{Is_Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6399, '\p{^Is_Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6399, '\P{Is_Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6399, '\P{^Is_Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6319, '\p{Is_Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6319, '\p{^Is_Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6319, '\P{Is_Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6319, '\P{^Is_Block=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6399, '\p{Is_Block=	 UNIFIED-Canadian	AboriginalSyllabics extended}', "");
Expect(0, 6399, '\p{^Is_Block=	 UNIFIED-Canadian	AboriginalSyllabics extended}', "");
Expect(0, 6399, '\P{Is_Block=	 UNIFIED-Canadian	AboriginalSyllabics extended}', "");
Expect(1, 6399, '\P{^Is_Block=	 UNIFIED-Canadian	AboriginalSyllabics extended}', "");
Expect(0, 6319, '\p{Is_Block=	 UNIFIED-Canadian	AboriginalSyllabics extended}', "");
Expect(1, 6319, '\p{^Is_Block=	 UNIFIED-Canadian	AboriginalSyllabics extended}', "");
Expect(1, 6319, '\P{Is_Block=	 UNIFIED-Canadian	AboriginalSyllabics extended}', "");
Expect(0, 6319, '\P{^Is_Block=	 UNIFIED-Canadian	AboriginalSyllabics extended}', "");
Error('\p{Is_Blk=:=- Unifiedcanadian Aboriginal_SYLLABICS	Extended}');
Error('\P{Is_Blk=:=- Unifiedcanadian Aboriginal_SYLLABICS	Extended}');
Expect(1, 6399, '\p{Is_Blk=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6399, '\p{^Is_Blk=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6399, '\P{Is_Blk=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6399, '\P{^Is_Blk=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6319, '\p{Is_Blk=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6319, '\p{^Is_Blk=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6319, '\P{Is_Blk=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(0, 6319, '\P{^Is_Blk=unifiedcanadianaboriginalsyllabicsextended}', "");
Expect(1, 6399, '\p{Is_Blk:	 unified canadian	ABORIGINAL	syllabics_EXTENDED}', "");
Expect(0, 6399, '\p{^Is_Blk:	 unified canadian	ABORIGINAL	syllabics_EXTENDED}', "");
Expect(0, 6399, '\P{Is_Blk:	 unified canadian	ABORIGINAL	syllabics_EXTENDED}', "");
Expect(1, 6399, '\P{^Is_Blk:	 unified canadian	ABORIGINAL	syllabics_EXTENDED}', "");
Expect(0, 6319, '\p{Is_Blk:	 unified canadian	ABORIGINAL	syllabics_EXTENDED}', "");
Expect(1, 6319, '\p{^Is_Blk:	 unified canadian	ABORIGINAL	syllabics_EXTENDED}', "");
Expect(1, 6319, '\P{Is_Blk:	 unified canadian	ABORIGINAL	syllabics_EXTENDED}', "");
Expect(0, 6319, '\P{^Is_Blk:	 unified canadian	ABORIGINAL	syllabics_EXTENDED}', "");
Error('\p{Block: -Kangxi_radicals/a/}');
Error('\P{Block: -Kangxi_radicals/a/}');
Expect(1, 12255, '\p{Block=kangxiradicals}', "");
Expect(0, 12255, '\p{^Block=kangxiradicals}', "");
Expect(0, 12255, '\P{Block=kangxiradicals}', "");
Expect(1, 12255, '\P{^Block=kangxiradicals}', "");
Expect(0, 12031, '\p{Block=kangxiradicals}', "");
Expect(1, 12031, '\p{^Block=kangxiradicals}', "");
Expect(1, 12031, '\P{Block=kangxiradicals}', "");
Expect(0, 12031, '\P{^Block=kangxiradicals}', "");
Expect(1, 12255, '\p{Block:KANGXI-Radicals}', "");
Expect(0, 12255, '\p{^Block:KANGXI-Radicals}', "");
Expect(0, 12255, '\P{Block:KANGXI-Radicals}', "");
Expect(1, 12255, '\P{^Block:KANGXI-Radicals}', "");
Expect(0, 12031, '\p{Block:KANGXI-Radicals}', "");
Expect(1, 12031, '\p{^Block:KANGXI-Radicals}', "");
Expect(1, 12031, '\P{Block:KANGXI-Radicals}', "");
Expect(0, 12031, '\P{^Block:KANGXI-Radicals}', "");
Error('\p{Blk:    _KANGXIradicals/a/}');
Error('\P{Blk:    _KANGXIradicals/a/}');
Expect(1, 12255, '\p{Blk=kangxiradicals}', "");
Expect(0, 12255, '\p{^Blk=kangxiradicals}', "");
Expect(0, 12255, '\P{Blk=kangxiradicals}', "");
Expect(1, 12255, '\P{^Blk=kangxiradicals}', "");
Expect(0, 12031, '\p{Blk=kangxiradicals}', "");
Expect(1, 12031, '\p{^Blk=kangxiradicals}', "");
Expect(1, 12031, '\P{Blk=kangxiradicals}', "");
Expect(0, 12031, '\P{^Blk=kangxiradicals}', "");
Expect(1, 12255, '\p{Blk=  kangxi_Radicals}', "");
Expect(0, 12255, '\p{^Blk=  kangxi_Radicals}', "");
Expect(0, 12255, '\P{Blk=  kangxi_Radicals}', "");
Expect(1, 12255, '\P{^Blk=  kangxi_Radicals}', "");
Expect(0, 12031, '\p{Blk=  kangxi_Radicals}', "");
Expect(1, 12031, '\p{^Blk=  kangxi_Radicals}', "");
Expect(1, 12031, '\P{Blk=  kangxi_Radicals}', "");
Expect(0, 12031, '\P{^Blk=  kangxi_Radicals}', "");
Error('\p{Is_Block=--Kangxi RADICALS/a/}');
Error('\P{Is_Block=--Kangxi RADICALS/a/}');
Expect(1, 12255, '\p{Is_Block=kangxiradicals}', "");
Expect(0, 12255, '\p{^Is_Block=kangxiradicals}', "");
Expect(0, 12255, '\P{Is_Block=kangxiradicals}', "");
Expect(1, 12255, '\P{^Is_Block=kangxiradicals}', "");
Expect(0, 12031, '\p{Is_Block=kangxiradicals}', "");
Expect(1, 12031, '\p{^Is_Block=kangxiradicals}', "");
Expect(1, 12031, '\P{Is_Block=kangxiradicals}', "");
Expect(0, 12031, '\P{^Is_Block=kangxiradicals}', "");
Expect(1, 12255, '\p{Is_Block=_ Kangxi-radicals}', "");
Expect(0, 12255, '\p{^Is_Block=_ Kangxi-radicals}', "");
Expect(0, 12255, '\P{Is_Block=_ Kangxi-radicals}', "");
Expect(1, 12255, '\P{^Is_Block=_ Kangxi-radicals}', "");
Expect(0, 12031, '\p{Is_Block=_ Kangxi-radicals}', "");
Expect(1, 12031, '\p{^Is_Block=_ Kangxi-radicals}', "");
Expect(1, 12031, '\P{Is_Block=_ Kangxi-radicals}', "");
Expect(0, 12031, '\P{^Is_Block=_ Kangxi-radicals}', "");
Error('\p{Is_Blk:	/a/KangxiRadicals}');
Error('\P{Is_Blk:	/a/KangxiRadicals}');
Expect(1, 12255, '\p{Is_Blk=kangxiradicals}', "");
Expect(0, 12255, '\p{^Is_Blk=kangxiradicals}', "");
Expect(0, 12255, '\P{Is_Blk=kangxiradicals}', "");
Expect(1, 12255, '\P{^Is_Blk=kangxiradicals}', "");
Expect(0, 12031, '\p{Is_Blk=kangxiradicals}', "");
Expect(1, 12031, '\p{^Is_Blk=kangxiradicals}', "");
Expect(1, 12031, '\P{Is_Blk=kangxiradicals}', "");
Expect(0, 12031, '\P{^Is_Blk=kangxiradicals}', "");
Expect(1, 12255, '\p{Is_Blk=	Kangxi-radicals}', "");
Expect(0, 12255, '\p{^Is_Blk=	Kangxi-radicals}', "");
Expect(0, 12255, '\P{Is_Blk=	Kangxi-radicals}', "");
Expect(1, 12255, '\P{^Is_Blk=	Kangxi-radicals}', "");
Expect(0, 12031, '\p{Is_Blk=	Kangxi-radicals}', "");
Expect(1, 12031, '\p{^Is_Blk=	Kangxi-radicals}', "");
Expect(1, 12031, '\P{Is_Blk=	Kangxi-radicals}', "");
Expect(0, 12031, '\P{^Is_Blk=	Kangxi-radicals}', "");
Error('\p{Block=-_Arabic presentation	FORMS_b:=}');
Error('\P{Block=-_Arabic presentation	FORMS_b:=}');
Expect(1, 65279, '\p{Block=arabicpresentationformsb}', "");
Expect(0, 65279, '\p{^Block=arabicpresentationformsb}', "");
Expect(0, 65279, '\P{Block=arabicpresentationformsb}', "");
Expect(1, 65279, '\P{^Block=arabicpresentationformsb}', "");
Expect(0, 65135, '\p{Block=arabicpresentationformsb}', "");
Expect(1, 65135, '\p{^Block=arabicpresentationformsb}', "");
Expect(1, 65135, '\P{Block=arabicpresentationformsb}', "");
Expect(0, 65135, '\P{^Block=arabicpresentationformsb}', "");
Expect(1, 65279, '\p{Block=_Arabic	presentation	FORMS-B}', "");
Expect(0, 65279, '\p{^Block=_Arabic	presentation	FORMS-B}', "");
Expect(0, 65279, '\P{Block=_Arabic	presentation	FORMS-B}', "");
Expect(1, 65279, '\P{^Block=_Arabic	presentation	FORMS-B}', "");
Expect(0, 65135, '\p{Block=_Arabic	presentation	FORMS-B}', "");
Expect(1, 65135, '\p{^Block=_Arabic	presentation	FORMS-B}', "");
Expect(1, 65135, '\P{Block=_Arabic	presentation	FORMS-B}', "");
Expect(0, 65135, '\P{^Block=_Arabic	presentation	FORMS-B}', "");
Error('\p{Blk=_-ARABIC/a/PresentationForms-B}');
Error('\P{Blk=_-ARABIC/a/PresentationForms-B}');
Expect(1, 65279, '\p{Blk=arabicpresentationformsb}', "");
Expect(0, 65279, '\p{^Blk=arabicpresentationformsb}', "");
Expect(0, 65279, '\P{Blk=arabicpresentationformsb}', "");
Expect(1, 65279, '\P{^Blk=arabicpresentationformsb}', "");
Expect(0, 65135, '\p{Blk=arabicpresentationformsb}', "");
Expect(1, 65135, '\p{^Blk=arabicpresentationformsb}', "");
Expect(1, 65135, '\P{Blk=arabicpresentationformsb}', "");
Expect(0, 65135, '\P{^Blk=arabicpresentationformsb}', "");
Expect(1, 65279, '\p{Blk=_	ArabicPRESENTATION FORMS B}', "");
Expect(0, 65279, '\p{^Blk=_	ArabicPRESENTATION FORMS B}', "");
Expect(0, 65279, '\P{Blk=_	ArabicPRESENTATION FORMS B}', "");
Expect(1, 65279, '\P{^Blk=_	ArabicPRESENTATION FORMS B}', "");
Expect(0, 65135, '\p{Blk=_	ArabicPRESENTATION FORMS B}', "");
Expect(1, 65135, '\p{^Blk=_	ArabicPRESENTATION FORMS B}', "");
Expect(1, 65135, '\P{Blk=_	ArabicPRESENTATION FORMS B}', "");
Expect(0, 65135, '\P{^Blk=_	ArabicPRESENTATION FORMS B}', "");
Error('\p{Is_Block=/a/	ARABIC	Presentation FORMSB}');
Error('\P{Is_Block=/a/	ARABIC	Presentation FORMSB}');
Expect(1, 65279, '\p{Is_Block=arabicpresentationformsb}', "");
Expect(0, 65279, '\p{^Is_Block=arabicpresentationformsb}', "");
Expect(0, 65279, '\P{Is_Block=arabicpresentationformsb}', "");
Expect(1, 65279, '\P{^Is_Block=arabicpresentationformsb}', "");
Expect(0, 65135, '\p{Is_Block=arabicpresentationformsb}', "");
Expect(1, 65135, '\p{^Is_Block=arabicpresentationformsb}', "");
Expect(1, 65135, '\P{Is_Block=arabicpresentationformsb}', "");
Expect(0, 65135, '\P{^Is_Block=arabicpresentationformsb}', "");
Expect(1, 65279, '\p{Is_Block=	arabic_presentation	Forms_b}', "");
Expect(0, 65279, '\p{^Is_Block=	arabic_presentation	Forms_b}', "");
Expect(0, 65279, '\P{Is_Block=	arabic_presentation	Forms_b}', "");
Expect(1, 65279, '\P{^Is_Block=	arabic_presentation	Forms_b}', "");
Expect(0, 65135, '\p{Is_Block=	arabic_presentation	Forms_b}', "");
Expect(1, 65135, '\p{^Is_Block=	arabic_presentation	Forms_b}', "");
Expect(1, 65135, '\P{Is_Block=	arabic_presentation	Forms_b}', "");
Expect(0, 65135, '\P{^Is_Block=	arabic_presentation	Forms_b}', "");
Error('\p{Is_Blk= :=arabic_presentation Forms B}');
Error('\P{Is_Blk= :=arabic_presentation Forms B}');
Expect(1, 65279, '\p{Is_Blk=arabicpresentationformsb}', "");
Expect(0, 65279, '\p{^Is_Blk=arabicpresentationformsb}', "");
Expect(0, 65279, '\P{Is_Blk=arabicpresentationformsb}', "");
Expect(1, 65279, '\P{^Is_Blk=arabicpresentationformsb}', "");
Expect(0, 65135, '\p{Is_Blk=arabicpresentationformsb}', "");
Expect(1, 65135, '\p{^Is_Blk=arabicpresentationformsb}', "");
Expect(1, 65135, '\P{Is_Blk=arabicpresentationformsb}', "");
Expect(0, 65135, '\P{^Is_Blk=arabicpresentationformsb}', "");
Expect(1, 65279, '\p{Is_Blk=_ARABIC_presentation_FORMS B}', "");
Expect(0, 65279, '\p{^Is_Blk=_ARABIC_presentation_FORMS B}', "");
Expect(0, 65279, '\P{Is_Blk=_ARABIC_presentation_FORMS B}', "");
Expect(1, 65279, '\P{^Is_Blk=_ARABIC_presentation_FORMS B}', "");
Expect(0, 65135, '\p{Is_Blk=_ARABIC_presentation_FORMS B}', "");
Expect(1, 65135, '\p{^Is_Blk=_ARABIC_presentation_FORMS B}', "");
Expect(1, 65135, '\P{Is_Blk=_ARABIC_presentation_FORMS B}', "");
Expect(0, 65135, '\P{^Is_Blk=_ARABIC_presentation_FORMS B}', "");
Error('\p{Block=:=-_Gurmukhi}');
Error('\P{Block=:=-_Gurmukhi}');
Expect(1, 2687, '\p{Block=gurmukhi}', "");
Expect(0, 2687, '\p{^Block=gurmukhi}', "");
Expect(0, 2687, '\P{Block=gurmukhi}', "");
Expect(1, 2687, '\P{^Block=gurmukhi}', "");
Expect(0, 2559, '\p{Block=gurmukhi}', "");
Expect(1, 2559, '\p{^Block=gurmukhi}', "");
Expect(1, 2559, '\P{Block=gurmukhi}', "");
Expect(0, 2559, '\P{^Block=gurmukhi}', "");
Expect(1, 2687, '\p{Block=  GURMUKHI}', "");
Expect(0, 2687, '\p{^Block=  GURMUKHI}', "");
Expect(0, 2687, '\P{Block=  GURMUKHI}', "");
Expect(1, 2687, '\P{^Block=  GURMUKHI}', "");
Expect(0, 2559, '\p{Block=  GURMUKHI}', "");
Expect(1, 2559, '\p{^Block=  GURMUKHI}', "");
Expect(1, 2559, '\P{Block=  GURMUKHI}', "");
Expect(0, 2559, '\P{^Block=  GURMUKHI}', "");
Error('\p{Blk=-/a/Gurmukhi}');
Error('\P{Blk=-/a/Gurmukhi}');
Expect(1, 2687, '\p{Blk=gurmukhi}', "");
Expect(0, 2687, '\p{^Blk=gurmukhi}', "");
Expect(0, 2687, '\P{Blk=gurmukhi}', "");
Expect(1, 2687, '\P{^Blk=gurmukhi}', "");
Expect(0, 2559, '\p{Blk=gurmukhi}', "");
Expect(1, 2559, '\p{^Blk=gurmukhi}', "");
Expect(1, 2559, '\P{Blk=gurmukhi}', "");
Expect(0, 2559, '\P{^Blk=gurmukhi}', "");
Expect(1, 2687, '\p{Blk=_Gurmukhi}', "");
Expect(0, 2687, '\p{^Blk=_Gurmukhi}', "");
Expect(0, 2687, '\P{Blk=_Gurmukhi}', "");
Expect(1, 2687, '\P{^Blk=_Gurmukhi}', "");
Expect(0, 2559, '\p{Blk=_Gurmukhi}', "");
Expect(1, 2559, '\p{^Blk=_Gurmukhi}', "");
Expect(1, 2559, '\P{Blk=_Gurmukhi}', "");
Expect(0, 2559, '\P{^Blk=_Gurmukhi}', "");
Error('\p{Is_Block=/a/-GURMUKHI}');
Error('\P{Is_Block=/a/-GURMUKHI}');
Expect(1, 2687, '\p{Is_Block=gurmukhi}', "");
Expect(0, 2687, '\p{^Is_Block=gurmukhi}', "");
Expect(0, 2687, '\P{Is_Block=gurmukhi}', "");
Expect(1, 2687, '\P{^Is_Block=gurmukhi}', "");
Expect(0, 2559, '\p{Is_Block=gurmukhi}', "");
Expect(1, 2559, '\p{^Is_Block=gurmukhi}', "");
Expect(1, 2559, '\P{Is_Block=gurmukhi}', "");
Expect(0, 2559, '\P{^Is_Block=gurmukhi}', "");
Expect(1, 2687, '\p{Is_Block:    gurmukhi}', "");
Expect(0, 2687, '\p{^Is_Block:    gurmukhi}', "");
Expect(0, 2687, '\P{Is_Block:    gurmukhi}', "");
Expect(1, 2687, '\P{^Is_Block:    gurmukhi}', "");
Expect(0, 2559, '\p{Is_Block:    gurmukhi}', "");
Expect(1, 2559, '\p{^Is_Block:    gurmukhi}', "");
Expect(1, 2559, '\P{Is_Block:    gurmukhi}', "");
Expect(0, 2559, '\P{^Is_Block:    gurmukhi}', "");
Error('\p{Is_Blk:   :=--gurmukhi}');
Error('\P{Is_Blk:   :=--gurmukhi}');
Expect(1, 2687, '\p{Is_Blk=gurmukhi}', "");
Expect(0, 2687, '\p{^Is_Blk=gurmukhi}', "");
Expect(0, 2687, '\P{Is_Blk=gurmukhi}', "");
Expect(1, 2687, '\P{^Is_Blk=gurmukhi}', "");
Expect(0, 2559, '\p{Is_Blk=gurmukhi}', "");
Expect(1, 2559, '\p{^Is_Blk=gurmukhi}', "");
Expect(1, 2559, '\P{Is_Blk=gurmukhi}', "");
Expect(0, 2559, '\P{^Is_Blk=gurmukhi}', "");
Expect(1, 2687, '\p{Is_Blk=	Gurmukhi}', "");
Expect(0, 2687, '\p{^Is_Blk=	Gurmukhi}', "");
Expect(0, 2687, '\P{Is_Blk=	Gurmukhi}', "");
Expect(1, 2687, '\P{^Is_Blk=	Gurmukhi}', "");
Expect(0, 2559, '\p{Is_Blk=	Gurmukhi}', "");
Expect(1, 2559, '\p{^Is_Blk=	Gurmukhi}', "");
Expect(1, 2559, '\P{Is_Blk=	Gurmukhi}', "");
Expect(0, 2559, '\P{^Is_Blk=	Gurmukhi}', "");
Error('\p{Block= /a/ENCLOSED_Ideographic	Supplement}');
Error('\P{Block= /a/ENCLOSED_Ideographic	Supplement}');
Expect(1, 127743, '\p{Block=enclosedideographicsupplement}', "");
Expect(0, 127743, '\p{^Block=enclosedideographicsupplement}', "");
Expect(0, 127743, '\P{Block=enclosedideographicsupplement}', "");
Expect(1, 127743, '\P{^Block=enclosedideographicsupplement}', "");
Expect(0, 127487, '\p{Block=enclosedideographicsupplement}', "");
Expect(1, 127487, '\p{^Block=enclosedideographicsupplement}', "");
Expect(1, 127487, '\P{Block=enclosedideographicsupplement}', "");
Expect(0, 127487, '\P{^Block=enclosedideographicsupplement}', "");
Expect(1, 127743, '\p{Block= Enclosed	ideographic-Supplement}', "");
Expect(0, 127743, '\p{^Block= Enclosed	ideographic-Supplement}', "");
Expect(0, 127743, '\P{Block= Enclosed	ideographic-Supplement}', "");
Expect(1, 127743, '\P{^Block= Enclosed	ideographic-Supplement}', "");
Expect(0, 127487, '\p{Block= Enclosed	ideographic-Supplement}', "");
Expect(1, 127487, '\p{^Block= Enclosed	ideographic-Supplement}', "");
Expect(1, 127487, '\P{Block= Enclosed	ideographic-Supplement}', "");
Expect(0, 127487, '\P{^Block= Enclosed	ideographic-Supplement}', "");
Error('\p{Blk=-	ENCLOSED_IDEOGRAPHIC_Supplement/a/}');
Error('\P{Blk=-	ENCLOSED_IDEOGRAPHIC_Supplement/a/}');
Expect(1, 127743, '\p{Blk=enclosedideographicsupplement}', "");
Expect(0, 127743, '\p{^Blk=enclosedideographicsupplement}', "");
Expect(0, 127743, '\P{Blk=enclosedideographicsupplement}', "");
Expect(1, 127743, '\P{^Blk=enclosedideographicsupplement}', "");
Expect(0, 127487, '\p{Blk=enclosedideographicsupplement}', "");
Expect(1, 127487, '\p{^Blk=enclosedideographicsupplement}', "");
Expect(1, 127487, '\P{Blk=enclosedideographicsupplement}', "");
Expect(0, 127487, '\P{^Blk=enclosedideographicsupplement}', "");
Expect(1, 127743, '\p{Blk= ENCLOSED_Ideographic-Supplement}', "");
Expect(0, 127743, '\p{^Blk= ENCLOSED_Ideographic-Supplement}', "");
Expect(0, 127743, '\P{Blk= ENCLOSED_Ideographic-Supplement}', "");
Expect(1, 127743, '\P{^Blk= ENCLOSED_Ideographic-Supplement}', "");
Expect(0, 127487, '\p{Blk= ENCLOSED_Ideographic-Supplement}', "");
Expect(1, 127487, '\p{^Blk= ENCLOSED_Ideographic-Supplement}', "");
Expect(1, 127487, '\P{Blk= ENCLOSED_Ideographic-Supplement}', "");
Expect(0, 127487, '\P{^Blk= ENCLOSED_Ideographic-Supplement}', "");
Error('\p{Is_Block:- ENCLOSED ideographic	supplement:=}');
Error('\P{Is_Block:- ENCLOSED ideographic	supplement:=}');
Expect(1, 127743, '\p{Is_Block=enclosedideographicsupplement}', "");
Expect(0, 127743, '\p{^Is_Block=enclosedideographicsupplement}', "");
Expect(0, 127743, '\P{Is_Block=enclosedideographicsupplement}', "");
Expect(1, 127743, '\P{^Is_Block=enclosedideographicsupplement}', "");
Expect(0, 127487, '\p{Is_Block=enclosedideographicsupplement}', "");
Expect(1, 127487, '\p{^Is_Block=enclosedideographicsupplement}', "");
Expect(1, 127487, '\P{Is_Block=enclosedideographicsupplement}', "");
Expect(0, 127487, '\P{^Is_Block=enclosedideographicsupplement}', "");
Expect(1, 127743, '\p{Is_Block= ENCLOSED-Ideographic	Supplement}', "");
Expect(0, 127743, '\p{^Is_Block= ENCLOSED-Ideographic	Supplement}', "");
Expect(0, 127743, '\P{Is_Block= ENCLOSED-Ideographic	Supplement}', "");
Expect(1, 127743, '\P{^Is_Block= ENCLOSED-Ideographic	Supplement}', "");
Expect(0, 127487, '\p{Is_Block= ENCLOSED-Ideographic	Supplement}', "");
Expect(1, 127487, '\p{^Is_Block= ENCLOSED-Ideographic	Supplement}', "");
Expect(1, 127487, '\P{Is_Block= ENCLOSED-Ideographic	Supplement}', "");
Expect(0, 127487, '\P{^Is_Block= ENCLOSED-Ideographic	Supplement}', "");
Error('\p{Is_Blk=_-Enclosed-IDEOGRAPHIC/a/SUPPLEMENT}');
Error('\P{Is_Blk=_-Enclosed-IDEOGRAPHIC/a/SUPPLEMENT}');
Expect(1, 127743, '\p{Is_Blk:   enclosedideographicsupplement}', "");
Expect(0, 127743, '\p{^Is_Blk:   enclosedideographicsupplement}', "");
Expect(0, 127743, '\P{Is_Blk:   enclosedideographicsupplement}', "");
Expect(1, 127743, '\P{^Is_Blk:   enclosedideographicsupplement}', "");
Expect(0, 127487, '\p{Is_Blk:   enclosedideographicsupplement}', "");
Expect(1, 127487, '\p{^Is_Blk:   enclosedideographicsupplement}', "");
Expect(1, 127487, '\P{Is_Blk:   enclosedideographicsupplement}', "");
Expect(0, 127487, '\P{^Is_Blk:   enclosedideographicsupplement}', "");
Expect(1, 127743, '\p{Is_Blk= Enclosed	Ideographic-Supplement}', "");
Expect(0, 127743, '\p{^Is_Blk= Enclosed	Ideographic-Supplement}', "");
Expect(0, 127743, '\P{Is_Blk= Enclosed	Ideographic-Supplement}', "");
Expect(1, 127743, '\P{^Is_Blk= Enclosed	Ideographic-Supplement}', "");
Expect(0, 127487, '\p{Is_Blk= Enclosed	Ideographic-Supplement}', "");
Expect(1, 127487, '\p{^Is_Blk= Enclosed	Ideographic-Supplement}', "");
Expect(1, 127487, '\P{Is_Blk= Enclosed	Ideographic-Supplement}', "");
Expect(0, 127487, '\P{^Is_Blk= Enclosed	Ideographic-Supplement}', "");
Error('\p{Block= _phoneticExtensions SUPPLEMENT/a/}');
Error('\P{Block= _phoneticExtensions SUPPLEMENT/a/}');
Expect(1, 7615, '\p{Block=phoneticextensionssupplement}', "");
Expect(0, 7615, '\p{^Block=phoneticextensionssupplement}', "");
Expect(0, 7615, '\P{Block=phoneticextensionssupplement}', "");
Expect(1, 7615, '\P{^Block=phoneticextensionssupplement}', "");
Expect(0, 7551, '\p{Block=phoneticextensionssupplement}', "");
Expect(1, 7551, '\p{^Block=phoneticextensionssupplement}', "");
Expect(1, 7551, '\P{Block=phoneticextensionssupplement}', "");
Expect(0, 7551, '\P{^Block=phoneticextensionssupplement}', "");
Expect(1, 7615, '\p{Block=_-PHONETIC_Extensions-Supplement}', "");
Expect(0, 7615, '\p{^Block=_-PHONETIC_Extensions-Supplement}', "");
Expect(0, 7615, '\P{Block=_-PHONETIC_Extensions-Supplement}', "");
Expect(1, 7615, '\P{^Block=_-PHONETIC_Extensions-Supplement}', "");
Expect(0, 7551, '\p{Block=_-PHONETIC_Extensions-Supplement}', "");
Expect(1, 7551, '\p{^Block=_-PHONETIC_Extensions-Supplement}', "");
Expect(1, 7551, '\P{Block=_-PHONETIC_Extensions-Supplement}', "");
Expect(0, 7551, '\P{^Block=_-PHONETIC_Extensions-Supplement}', "");
Error('\p{Blk=:=phonetic_extensions	Supplement}');
Error('\P{Blk=:=phonetic_extensions	Supplement}');
Expect(1, 7615, '\p{Blk=phoneticextensionssupplement}', "");
Expect(0, 7615, '\p{^Blk=phoneticextensionssupplement}', "");
Expect(0, 7615, '\P{Blk=phoneticextensionssupplement}', "");
Expect(1, 7615, '\P{^Blk=phoneticextensionssupplement}', "");
Expect(0, 7551, '\p{Blk=phoneticextensionssupplement}', "");
Expect(1, 7551, '\p{^Blk=phoneticextensionssupplement}', "");
Expect(1, 7551, '\P{Blk=phoneticextensionssupplement}', "");
Expect(0, 7551, '\P{^Blk=phoneticextensionssupplement}', "");
Expect(1, 7615, '\p{Blk= 	Phonetic_Extensions	supplement}', "");
Expect(0, 7615, '\p{^Blk= 	Phonetic_Extensions	supplement}', "");
Expect(0, 7615, '\P{Blk= 	Phonetic_Extensions	supplement}', "");
Expect(1, 7615, '\P{^Blk= 	Phonetic_Extensions	supplement}', "");
Expect(0, 7551, '\p{Blk= 	Phonetic_Extensions	supplement}', "");
Expect(1, 7551, '\p{^Blk= 	Phonetic_Extensions	supplement}', "");
Expect(1, 7551, '\P{Blk= 	Phonetic_Extensions	supplement}', "");
Expect(0, 7551, '\P{^Blk= 	Phonetic_Extensions	supplement}', "");
Error('\p{Is_Block=	Phonetic_Extensions/a/supplement}');
Error('\P{Is_Block=	Phonetic_Extensions/a/supplement}');
Expect(1, 7615, '\p{Is_Block:	phoneticextensionssupplement}', "");
Expect(0, 7615, '\p{^Is_Block:	phoneticextensionssupplement}', "");
Expect(0, 7615, '\P{Is_Block:	phoneticextensionssupplement}', "");
Expect(1, 7615, '\P{^Is_Block:	phoneticextensionssupplement}', "");
Expect(0, 7551, '\p{Is_Block:	phoneticextensionssupplement}', "");
Expect(1, 7551, '\p{^Is_Block:	phoneticextensionssupplement}', "");
Expect(1, 7551, '\P{Is_Block:	phoneticextensionssupplement}', "");
Expect(0, 7551, '\P{^Is_Block:	phoneticextensionssupplement}', "");
Expect(1, 7615, '\p{Is_Block:__PHONETIC_EXTENSIONSSUPPLEMENT}', "");
Expect(0, 7615, '\p{^Is_Block:__PHONETIC_EXTENSIONSSUPPLEMENT}', "");
Expect(0, 7615, '\P{Is_Block:__PHONETIC_EXTENSIONSSUPPLEMENT}', "");
Expect(1, 7615, '\P{^Is_Block:__PHONETIC_EXTENSIONSSUPPLEMENT}', "");
Expect(0, 7551, '\p{Is_Block:__PHONETIC_EXTENSIONSSUPPLEMENT}', "");
Expect(1, 7551, '\p{^Is_Block:__PHONETIC_EXTENSIONSSUPPLEMENT}', "");
Expect(1, 7551, '\P{Is_Block:__PHONETIC_EXTENSIONSSUPPLEMENT}', "");
Expect(0, 7551, '\P{^Is_Block:__PHONETIC_EXTENSIONSSUPPLEMENT}', "");
Error('\p{Is_Blk=:=phonetic	ExtensionsSupplement}');
Error('\P{Is_Blk=:=phonetic	ExtensionsSupplement}');
Expect(1, 7615, '\p{Is_Blk=phoneticextensionssupplement}', "");
Expect(0, 7615, '\p{^Is_Blk=phoneticextensionssupplement}', "");
Expect(0, 7615, '\P{Is_Blk=phoneticextensionssupplement}', "");
Expect(1, 7615, '\P{^Is_Blk=phoneticextensionssupplement}', "");
Expect(0, 7551, '\p{Is_Blk=phoneticextensionssupplement}', "");
Expect(1, 7551, '\p{^Is_Blk=phoneticextensionssupplement}', "");
Expect(1, 7551, '\P{Is_Blk=phoneticextensionssupplement}', "");
Expect(0, 7551, '\P{^Is_Blk=phoneticextensionssupplement}', "");
Expect(1, 7615, '\p{Is_Blk=- Phonetic-extensions_supplement}', "");
Expect(0, 7615, '\p{^Is_Blk=- Phonetic-extensions_supplement}', "");
Expect(0, 7615, '\P{Is_Blk=- Phonetic-extensions_supplement}', "");
Expect(1, 7615, '\P{^Is_Blk=- Phonetic-extensions_supplement}', "");
Expect(0, 7551, '\p{Is_Blk=- Phonetic-extensions_supplement}', "");
Expect(1, 7551, '\p{^Is_Blk=- Phonetic-extensions_supplement}', "");
Expect(1, 7551, '\P{Is_Blk=- Phonetic-extensions_supplement}', "");
Expect(0, 7551, '\P{^Is_Blk=- Phonetic-extensions_supplement}', "");
Error('\p{Block:   -GREEK/a/Extended}');
Error('\P{Block:   -GREEK/a/Extended}');
Expect(1, 8191, '\p{Block=greekextended}', "");
Expect(0, 8191, '\p{^Block=greekextended}', "");
Expect(0, 8191, '\P{Block=greekextended}', "");
Expect(1, 8191, '\P{^Block=greekextended}', "");
Expect(0, 7935, '\p{Block=greekextended}', "");
Expect(1, 7935, '\p{^Block=greekextended}', "");
Expect(1, 7935, '\P{Block=greekextended}', "");
Expect(0, 7935, '\P{^Block=greekextended}', "");
Expect(1, 8191, '\p{Block:  	greek Extended}', "");
Expect(0, 8191, '\p{^Block:  	greek Extended}', "");
Expect(0, 8191, '\P{Block:  	greek Extended}', "");
Expect(1, 8191, '\P{^Block:  	greek Extended}', "");
Expect(0, 7935, '\p{Block:  	greek Extended}', "");
Expect(1, 7935, '\p{^Block:  	greek Extended}', "");
Expect(1, 7935, '\P{Block:  	greek Extended}', "");
Expect(0, 7935, '\P{^Block:  	greek Extended}', "");
Error('\p{Blk=_/a/Greek EXTENDED}');
Error('\P{Blk=_/a/Greek EXTENDED}');
Expect(1, 8191, '\p{Blk:greekextended}', "");
Expect(0, 8191, '\p{^Blk:greekextended}', "");
Expect(0, 8191, '\P{Blk:greekextended}', "");
Expect(1, 8191, '\P{^Blk:greekextended}', "");
Expect(0, 7935, '\p{Blk:greekextended}', "");
Expect(1, 7935, '\p{^Blk:greekextended}', "");
Expect(1, 7935, '\P{Blk:greekextended}', "");
Expect(0, 7935, '\P{^Blk:greekextended}', "");
Expect(1, 8191, '\p{Blk=-	greek-Extended}', "");
Expect(0, 8191, '\p{^Blk=-	greek-Extended}', "");
Expect(0, 8191, '\P{Blk=-	greek-Extended}', "");
Expect(1, 8191, '\P{^Blk=-	greek-Extended}', "");
Expect(0, 7935, '\p{Blk=-	greek-Extended}', "");
Expect(1, 7935, '\p{^Blk=-	greek-Extended}', "");
Expect(1, 7935, '\P{Blk=-	greek-Extended}', "");
Expect(0, 7935, '\P{^Blk=-	greek-Extended}', "");
Error('\p{Is_Block:  /a/Greek_extended}');
Error('\P{Is_Block:  /a/Greek_extended}');
Expect(1, 8191, '\p{Is_Block: greekextended}', "");
Expect(0, 8191, '\p{^Is_Block: greekextended}', "");
Expect(0, 8191, '\P{Is_Block: greekextended}', "");
Expect(1, 8191, '\P{^Is_Block: greekextended}', "");
Expect(0, 7935, '\p{Is_Block: greekextended}', "");
Expect(1, 7935, '\p{^Is_Block: greekextended}', "");
Expect(1, 7935, '\P{Is_Block: greekextended}', "");
Expect(0, 7935, '\P{^Is_Block: greekextended}', "");
Expect(1, 8191, '\p{Is_Block:	_Greek Extended}', "");
Expect(0, 8191, '\p{^Is_Block:	_Greek Extended}', "");
Expect(0, 8191, '\P{Is_Block:	_Greek Extended}', "");
Expect(1, 8191, '\P{^Is_Block:	_Greek Extended}', "");
Expect(0, 7935, '\p{Is_Block:	_Greek Extended}', "");
Expect(1, 7935, '\p{^Is_Block:	_Greek Extended}', "");
Expect(1, 7935, '\P{Is_Block:	_Greek Extended}', "");
Expect(0, 7935, '\P{^Is_Block:	_Greek Extended}', "");
Error('\p{Is_Blk=/a/__GREEK_Extended}');
Error('\P{Is_Blk=/a/__GREEK_Extended}');
Expect(1, 8191, '\p{Is_Blk=greekextended}', "");
Expect(0, 8191, '\p{^Is_Blk=greekextended}', "");
Expect(0, 8191, '\P{Is_Blk=greekextended}', "");
Expect(1, 8191, '\P{^Is_Blk=greekextended}', "");
Expect(0, 7935, '\p{Is_Blk=greekextended}', "");
Expect(1, 7935, '\p{^Is_Blk=greekextended}', "");
Expect(1, 7935, '\P{Is_Blk=greekextended}', "");
Expect(0, 7935, '\P{^Is_Blk=greekextended}', "");
Expect(1, 8191, '\p{Is_Blk=greek_extended}', "");
Expect(0, 8191, '\p{^Is_Blk=greek_extended}', "");
Expect(0, 8191, '\P{Is_Blk=greek_extended}', "");
Expect(1, 8191, '\P{^Is_Blk=greek_extended}', "");
Expect(0, 7935, '\p{Is_Blk=greek_extended}', "");
Expect(1, 7935, '\p{^Is_Blk=greek_extended}', "");
Expect(1, 7935, '\P{Is_Blk=greek_extended}', "");
Expect(0, 7935, '\P{^Is_Blk=greek_extended}', "");
Error('\p{Block=/a/_deseret}');
Error('\P{Block=/a/_deseret}');
Expect(1, 66639, '\p{Block=deseret}', "");
Expect(0, 66639, '\p{^Block=deseret}', "");
Expect(0, 66639, '\P{Block=deseret}', "");
Expect(1, 66639, '\P{^Block=deseret}', "");
Expect(0, 66559, '\p{Block=deseret}', "");
Expect(1, 66559, '\p{^Block=deseret}', "");
Expect(1, 66559, '\P{Block=deseret}', "");
Expect(0, 66559, '\P{^Block=deseret}', "");
Expect(1, 66639, '\p{Block=_-Deseret}', "");
Expect(0, 66639, '\p{^Block=_-Deseret}', "");
Expect(0, 66639, '\P{Block=_-Deseret}', "");
Expect(1, 66639, '\P{^Block=_-Deseret}', "");
Expect(0, 66559, '\p{Block=_-Deseret}', "");
Expect(1, 66559, '\p{^Block=_-Deseret}', "");
Expect(1, 66559, '\P{Block=_-Deseret}', "");
Expect(0, 66559, '\P{^Block=_-Deseret}', "");
Error('\p{Blk= deseret/a/}');
Error('\P{Blk= deseret/a/}');
Expect(1, 66639, '\p{Blk=deseret}', "");
Expect(0, 66639, '\p{^Blk=deseret}', "");
Expect(0, 66639, '\P{Blk=deseret}', "");
Expect(1, 66639, '\P{^Blk=deseret}', "");
Expect(0, 66559, '\p{Blk=deseret}', "");
Expect(1, 66559, '\p{^Blk=deseret}', "");
Expect(1, 66559, '\P{Blk=deseret}', "");
Expect(0, 66559, '\P{^Blk=deseret}', "");
Expect(1, 66639, '\p{Blk=_DESERET}', "");
Expect(0, 66639, '\p{^Blk=_DESERET}', "");
Expect(0, 66639, '\P{Blk=_DESERET}', "");
Expect(1, 66639, '\P{^Blk=_DESERET}', "");
Expect(0, 66559, '\p{Blk=_DESERET}', "");
Expect(1, 66559, '\p{^Blk=_DESERET}', "");
Expect(1, 66559, '\P{Blk=_DESERET}', "");
Expect(0, 66559, '\P{^Blk=_DESERET}', "");
Error('\p{Is_Block=/a/Deseret}');
Error('\P{Is_Block=/a/Deseret}');
Expect(1, 66639, '\p{Is_Block=deseret}', "");
Expect(0, 66639, '\p{^Is_Block=deseret}', "");
Expect(0, 66639, '\P{Is_Block=deseret}', "");
Expect(1, 66639, '\P{^Is_Block=deseret}', "");
Expect(0, 66559, '\p{Is_Block=deseret}', "");
Expect(1, 66559, '\p{^Is_Block=deseret}', "");
Expect(1, 66559, '\P{Is_Block=deseret}', "");
Expect(0, 66559, '\P{^Is_Block=deseret}', "");
Expect(1, 66639, '\p{Is_Block=- Deseret}', "");
Expect(0, 66639, '\p{^Is_Block=- Deseret}', "");
Expect(0, 66639, '\P{Is_Block=- Deseret}', "");
Expect(1, 66639, '\P{^Is_Block=- Deseret}', "");
Expect(0, 66559, '\p{Is_Block=- Deseret}', "");
Expect(1, 66559, '\p{^Is_Block=- Deseret}', "");
Expect(1, 66559, '\P{Is_Block=- Deseret}', "");
Expect(0, 66559, '\P{^Is_Block=- Deseret}', "");
Error('\p{Is_Blk= :=DESERET}');
Error('\P{Is_Blk= :=DESERET}');
Expect(1, 66639, '\p{Is_Blk=deseret}', "");
Expect(0, 66639, '\p{^Is_Blk=deseret}', "");
Expect(0, 66639, '\P{Is_Blk=deseret}', "");
Expect(1, 66639, '\P{^Is_Blk=deseret}', "");
Expect(0, 66559, '\p{Is_Blk=deseret}', "");
Expect(1, 66559, '\p{^Is_Blk=deseret}', "");
Expect(1, 66559, '\P{Is_Blk=deseret}', "");
Expect(0, 66559, '\P{^Is_Blk=deseret}', "");
Expect(1, 66639, '\p{Is_Blk=	_DESERET}', "");
Expect(0, 66639, '\p{^Is_Blk=	_DESERET}', "");
Expect(0, 66639, '\P{Is_Blk=	_DESERET}', "");
Expect(1, 66639, '\P{^Is_Blk=	_DESERET}', "");
Expect(0, 66559, '\p{Is_Blk=	_DESERET}', "");
Expect(1, 66559, '\p{^Is_Blk=	_DESERET}', "");
Expect(1, 66559, '\P{Is_Blk=	_DESERET}', "");
Expect(0, 66559, '\P{^Is_Blk=	_DESERET}', "");
Error('\p{Block= Tai:=THAM}');
Error('\P{Block= Tai:=THAM}');
Expect(1, 6831, '\p{Block=taitham}', "");
Expect(0, 6831, '\p{^Block=taitham}', "");
Expect(0, 6831, '\P{Block=taitham}', "");
Expect(1, 6831, '\P{^Block=taitham}', "");
Expect(0, 6687, '\p{Block=taitham}', "");
Expect(1, 6687, '\p{^Block=taitham}', "");
Expect(1, 6687, '\P{Block=taitham}', "");
Expect(0, 6687, '\P{^Block=taitham}', "");
Expect(1, 6831, '\p{Block=_-TAI-Tham}', "");
Expect(0, 6831, '\p{^Block=_-TAI-Tham}', "");
Expect(0, 6831, '\P{Block=_-TAI-Tham}', "");
Expect(1, 6831, '\P{^Block=_-TAI-Tham}', "");
Expect(0, 6687, '\p{Block=_-TAI-Tham}', "");
Expect(1, 6687, '\p{^Block=_-TAI-Tham}', "");
Expect(1, 6687, '\P{Block=_-TAI-Tham}', "");
Expect(0, 6687, '\P{^Block=_-TAI-Tham}', "");
Error('\p{Blk=- Tai/a/Tham}');
Error('\P{Blk=- Tai/a/Tham}');
Expect(1, 6831, '\p{Blk=taitham}', "");
Expect(0, 6831, '\p{^Blk=taitham}', "");
Expect(0, 6831, '\P{Blk=taitham}', "");
Expect(1, 6831, '\P{^Blk=taitham}', "");
Expect(0, 6687, '\p{Blk=taitham}', "");
Expect(1, 6687, '\p{^Blk=taitham}', "");
Expect(1, 6687, '\P{Blk=taitham}', "");
Expect(0, 6687, '\P{^Blk=taitham}', "");
Expect(1, 6831, '\p{Blk=_-Tai_Tham}', "");
Expect(0, 6831, '\p{^Blk=_-Tai_Tham}', "");
Expect(0, 6831, '\P{Blk=_-Tai_Tham}', "");
Expect(1, 6831, '\P{^Blk=_-Tai_Tham}', "");
Expect(0, 6687, '\p{Blk=_-Tai_Tham}', "");
Expect(1, 6687, '\p{^Blk=_-Tai_Tham}', "");
Expect(1, 6687, '\P{Blk=_-Tai_Tham}', "");
Expect(0, 6687, '\P{^Blk=_-Tai_Tham}', "");
Error('\p{Is_Block: - Tai:=THAM}');
Error('\P{Is_Block: - Tai:=THAM}');
Expect(1, 6831, '\p{Is_Block:	taitham}', "");
Expect(0, 6831, '\p{^Is_Block:	taitham}', "");
Expect(0, 6831, '\P{Is_Block:	taitham}', "");
Expect(1, 6831, '\P{^Is_Block:	taitham}', "");
Expect(0, 6687, '\p{Is_Block:	taitham}', "");
Expect(1, 6687, '\p{^Is_Block:	taitham}', "");
Expect(1, 6687, '\P{Is_Block:	taitham}', "");
Expect(0, 6687, '\P{^Is_Block:	taitham}', "");
Expect(1, 6831, '\p{Is_Block= _TaiTham}', "");
Expect(0, 6831, '\p{^Is_Block= _TaiTham}', "");
Expect(0, 6831, '\P{Is_Block= _TaiTham}', "");
Expect(1, 6831, '\P{^Is_Block= _TaiTham}', "");
Expect(0, 6687, '\p{Is_Block= _TaiTham}', "");
Expect(1, 6687, '\p{^Is_Block= _TaiTham}', "");
Expect(1, 6687, '\P{Is_Block= _TaiTham}', "");
Expect(0, 6687, '\P{^Is_Block= _TaiTham}', "");
Error('\p{Is_Blk= Tai-Tham/a/}');
Error('\P{Is_Blk= Tai-Tham/a/}');
Expect(1, 6831, '\p{Is_Blk=taitham}', "");
Expect(0, 6831, '\p{^Is_Blk=taitham}', "");
Expect(0, 6831, '\P{Is_Blk=taitham}', "");
Expect(1, 6831, '\P{^Is_Blk=taitham}', "");
Expect(0, 6687, '\p{Is_Blk=taitham}', "");
Expect(1, 6687, '\p{^Is_Blk=taitham}', "");
Expect(1, 6687, '\P{Is_Blk=taitham}', "");
Expect(0, 6687, '\P{^Is_Blk=taitham}', "");
Expect(1, 6831, '\p{Is_Blk=__TAI-tham}', "");
Expect(0, 6831, '\p{^Is_Blk=__TAI-tham}', "");
Expect(0, 6831, '\P{Is_Blk=__TAI-tham}', "");
Expect(1, 6831, '\P{^Is_Blk=__TAI-tham}', "");
Expect(0, 6687, '\p{Is_Blk=__TAI-tham}', "");
Expect(1, 6687, '\p{^Is_Blk=__TAI-tham}', "");
Expect(1, 6687, '\P{Is_Blk=__TAI-tham}', "");
Expect(0, 6687, '\P{^Is_Blk=__TAI-tham}', "");
Error('\p{Block=:=_tagbanwa}');
Error('\P{Block=:=_tagbanwa}');
Expect(1, 6015, '\p{Block=tagbanwa}', "");
Expect(0, 6015, '\p{^Block=tagbanwa}', "");
Expect(0, 6015, '\P{Block=tagbanwa}', "");
Expect(1, 6015, '\P{^Block=tagbanwa}', "");
Expect(0, 5983, '\p{Block=tagbanwa}', "");
Expect(1, 5983, '\p{^Block=tagbanwa}', "");
Expect(1, 5983, '\P{Block=tagbanwa}', "");
Expect(0, 5983, '\P{^Block=tagbanwa}', "");
Expect(1, 6015, '\p{Block=_	Tagbanwa}', "");
Expect(0, 6015, '\p{^Block=_	Tagbanwa}', "");
Expect(0, 6015, '\P{Block=_	Tagbanwa}', "");
Expect(1, 6015, '\P{^Block=_	Tagbanwa}', "");
Expect(0, 5983, '\p{Block=_	Tagbanwa}', "");
Expect(1, 5983, '\p{^Block=_	Tagbanwa}', "");
Expect(1, 5983, '\P{Block=_	Tagbanwa}', "");
Expect(0, 5983, '\P{^Block=_	Tagbanwa}', "");
Error('\p{Blk:   /a/TAGBANWA}');
Error('\P{Blk:   /a/TAGBANWA}');
Expect(1, 6015, '\p{Blk=tagbanwa}', "");
Expect(0, 6015, '\p{^Blk=tagbanwa}', "");
Expect(0, 6015, '\P{Blk=tagbanwa}', "");
Expect(1, 6015, '\P{^Blk=tagbanwa}', "");
Expect(0, 5983, '\p{Blk=tagbanwa}', "");
Expect(1, 5983, '\p{^Blk=tagbanwa}', "");
Expect(1, 5983, '\P{Blk=tagbanwa}', "");
Expect(0, 5983, '\P{^Blk=tagbanwa}', "");
Expect(1, 6015, '\p{Blk= -TAGBANWA}', "");
Expect(0, 6015, '\p{^Blk= -TAGBANWA}', "");
Expect(0, 6015, '\P{Blk= -TAGBANWA}', "");
Expect(1, 6015, '\P{^Blk= -TAGBANWA}', "");
Expect(0, 5983, '\p{Blk= -TAGBANWA}', "");
Expect(1, 5983, '\p{^Blk= -TAGBANWA}', "");
Expect(1, 5983, '\P{Blk= -TAGBANWA}', "");
Expect(0, 5983, '\P{^Blk= -TAGBANWA}', "");
Error('\p{Is_Block=/a/	_Tagbanwa}');
Error('\P{Is_Block=/a/	_Tagbanwa}');
Expect(1, 6015, '\p{Is_Block=tagbanwa}', "");
Expect(0, 6015, '\p{^Is_Block=tagbanwa}', "");
Expect(0, 6015, '\P{Is_Block=tagbanwa}', "");
Expect(1, 6015, '\P{^Is_Block=tagbanwa}', "");
Expect(0, 5983, '\p{Is_Block=tagbanwa}', "");
Expect(1, 5983, '\p{^Is_Block=tagbanwa}', "");
Expect(1, 5983, '\P{Is_Block=tagbanwa}', "");
Expect(0, 5983, '\P{^Is_Block=tagbanwa}', "");
Expect(1, 6015, '\p{Is_Block:   	-Tagbanwa}', "");
Expect(0, 6015, '\p{^Is_Block:   	-Tagbanwa}', "");
Expect(0, 6015, '\P{Is_Block:   	-Tagbanwa}', "");
Expect(1, 6015, '\P{^Is_Block:   	-Tagbanwa}', "");
Expect(0, 5983, '\p{Is_Block:   	-Tagbanwa}', "");
Expect(1, 5983, '\p{^Is_Block:   	-Tagbanwa}', "");
Expect(1, 5983, '\P{Is_Block:   	-Tagbanwa}', "");
Expect(0, 5983, '\P{^Is_Block:   	-Tagbanwa}', "");
Error('\p{Is_Blk=	tagbanwa:=}');
Error('\P{Is_Blk=	tagbanwa:=}');
Expect(1, 6015, '\p{Is_Blk=tagbanwa}', "");
Expect(0, 6015, '\p{^Is_Blk=tagbanwa}', "");
Expect(0, 6015, '\P{Is_Blk=tagbanwa}', "");
Expect(1, 6015, '\P{^Is_Blk=tagbanwa}', "");
Expect(0, 5983, '\p{Is_Blk=tagbanwa}', "");
Expect(1, 5983, '\p{^Is_Blk=tagbanwa}', "");
Expect(1, 5983, '\P{Is_Blk=tagbanwa}', "");
Expect(0, 5983, '\P{^Is_Blk=tagbanwa}', "");
Expect(1, 6015, '\p{Is_Blk=	Tagbanwa}', "");
Expect(0, 6015, '\p{^Is_Blk=	Tagbanwa}', "");
Expect(0, 6015, '\P{Is_Blk=	Tagbanwa}', "");
Expect(1, 6015, '\P{^Is_Blk=	Tagbanwa}', "");
Expect(0, 5983, '\p{Is_Blk=	Tagbanwa}', "");
Expect(1, 5983, '\p{^Is_Blk=	Tagbanwa}', "");
Expect(1, 5983, '\P{Is_Blk=	Tagbanwa}', "");
Expect(0, 5983, '\P{^Is_Blk=	Tagbanwa}', "");
Error('\p{Block=	:=Arabic}');
Error('\P{Block=	:=Arabic}');
Expect(1, 1791, '\p{Block=arabic}', "");
Expect(0, 1791, '\p{^Block=arabic}', "");
Expect(0, 1791, '\P{Block=arabic}', "");
Expect(1, 1791, '\P{^Block=arabic}', "");
Expect(0, 1535, '\p{Block=arabic}', "");
Expect(1, 1535, '\p{^Block=arabic}', "");
Expect(1, 1535, '\P{Block=arabic}', "");
Expect(0, 1535, '\P{^Block=arabic}', "");
Expect(1, 1791, '\p{Block:	 arabic}', "");
Expect(0, 1791, '\p{^Block:	 arabic}', "");
Expect(0, 1791, '\P{Block:	 arabic}', "");
Expect(1, 1791, '\P{^Block:	 arabic}', "");
Expect(0, 1535, '\p{Block:	 arabic}', "");
Expect(1, 1535, '\p{^Block:	 arabic}', "");
Expect(1, 1535, '\P{Block:	 arabic}', "");
Expect(0, 1535, '\P{^Block:	 arabic}', "");
Error('\p{Blk=/a/Arabic}');
Error('\P{Blk=/a/Arabic}');
Expect(1, 1791, '\p{Blk:	arabic}', "");
Expect(0, 1791, '\p{^Blk:	arabic}', "");
Expect(0, 1791, '\P{Blk:	arabic}', "");
Expect(1, 1791, '\P{^Blk:	arabic}', "");
Expect(0, 1535, '\p{Blk:	arabic}', "");
Expect(1, 1535, '\p{^Blk:	arabic}', "");
Expect(1, 1535, '\P{Blk:	arabic}', "");
Expect(0, 1535, '\P{^Blk:	arabic}', "");
Expect(1, 1791, '\p{Blk=_ARABIC}', "");
Expect(0, 1791, '\p{^Blk=_ARABIC}', "");
Expect(0, 1791, '\P{Blk=_ARABIC}', "");
Expect(1, 1791, '\P{^Blk=_ARABIC}', "");
Expect(0, 1535, '\p{Blk=_ARABIC}', "");
Expect(1, 1535, '\p{^Blk=_ARABIC}', "");
Expect(1, 1535, '\P{Blk=_ARABIC}', "");
Expect(0, 1535, '\P{^Blk=_ARABIC}', "");
Error('\p{Is_Block:	_-Arabic:=}');
Error('\P{Is_Block:	_-Arabic:=}');
Expect(1, 1791, '\p{Is_Block: arabic}', "");
Expect(0, 1791, '\p{^Is_Block: arabic}', "");
Expect(0, 1791, '\P{Is_Block: arabic}', "");
Expect(1, 1791, '\P{^Is_Block: arabic}', "");
Expect(0, 1535, '\p{Is_Block: arabic}', "");
Expect(1, 1535, '\p{^Is_Block: arabic}', "");
Expect(1, 1535, '\P{Is_Block: arabic}', "");
Expect(0, 1535, '\P{^Is_Block: arabic}', "");
Expect(1, 1791, '\p{Is_Block= 	Arabic}', "");
Expect(0, 1791, '\p{^Is_Block= 	Arabic}', "");
Expect(0, 1791, '\P{Is_Block= 	Arabic}', "");
Expect(1, 1791, '\P{^Is_Block= 	Arabic}', "");
Expect(0, 1535, '\p{Is_Block= 	Arabic}', "");
Expect(1, 1535, '\p{^Is_Block= 	Arabic}', "");
Expect(1, 1535, '\P{Is_Block= 	Arabic}', "");
Expect(0, 1535, '\P{^Is_Block= 	Arabic}', "");
Error('\p{Is_Blk=	/a/Arabic}');
Error('\P{Is_Blk=	/a/Arabic}');
Expect(1, 1791, '\p{Is_Blk=arabic}', "");
Expect(0, 1791, '\p{^Is_Blk=arabic}', "");
Expect(0, 1791, '\P{Is_Blk=arabic}', "");
Expect(1, 1791, '\P{^Is_Blk=arabic}', "");
Expect(0, 1535, '\p{Is_Blk=arabic}', "");
Expect(1, 1535, '\p{^Is_Blk=arabic}', "");
Expect(1, 1535, '\P{Is_Blk=arabic}', "");
Expect(0, 1535, '\P{^Is_Blk=arabic}', "");
Expect(1, 1791, '\p{Is_Blk=  Arabic}', "");
Expect(0, 1791, '\p{^Is_Blk=  Arabic}', "");
Expect(0, 1791, '\P{Is_Blk=  Arabic}', "");
Expect(1, 1791, '\P{^Is_Blk=  Arabic}', "");
Expect(0, 1535, '\p{Is_Blk=  Arabic}', "");
Expect(1, 1535, '\p{^Is_Blk=  Arabic}', "");
Expect(1, 1535, '\P{Is_Blk=  Arabic}', "");
Expect(0, 1535, '\P{^Is_Blk=  Arabic}', "");
Error('\p{Block=_katakana Phonetic_Extensions:=}');
Error('\P{Block=_katakana Phonetic_Extensions:=}');
Expect(1, 12799, '\p{Block=katakanaphoneticextensions}', "");
Expect(0, 12799, '\p{^Block=katakanaphoneticextensions}', "");
Expect(0, 12799, '\P{Block=katakanaphoneticextensions}', "");
Expect(1, 12799, '\P{^Block=katakanaphoneticextensions}', "");
Expect(0, 12783, '\p{Block=katakanaphoneticextensions}', "");
Expect(1, 12783, '\p{^Block=katakanaphoneticextensions}', "");
Expect(1, 12783, '\P{Block=katakanaphoneticextensions}', "");
Expect(0, 12783, '\P{^Block=katakanaphoneticextensions}', "");
Expect(1, 12799, '\p{Block:	katakanaPhoneticExtensions}', "");
Expect(0, 12799, '\p{^Block:	katakanaPhoneticExtensions}', "");
Expect(0, 12799, '\P{Block:	katakanaPhoneticExtensions}', "");
Expect(1, 12799, '\P{^Block:	katakanaPhoneticExtensions}', "");
Expect(0, 12783, '\p{Block:	katakanaPhoneticExtensions}', "");
Expect(1, 12783, '\p{^Block:	katakanaPhoneticExtensions}', "");
Expect(1, 12783, '\P{Block:	katakanaPhoneticExtensions}', "");
Expect(0, 12783, '\P{^Block:	katakanaPhoneticExtensions}', "");
Error('\p{Blk=_-KATAKANAphonetic	EXTENSIONS:=}');
Error('\P{Blk=_-KATAKANAphonetic	EXTENSIONS:=}');
Expect(1, 12799, '\p{Blk=katakanaphoneticextensions}', "");
Expect(0, 12799, '\p{^Blk=katakanaphoneticextensions}', "");
Expect(0, 12799, '\P{Blk=katakanaphoneticextensions}', "");
Expect(1, 12799, '\P{^Blk=katakanaphoneticextensions}', "");
Expect(0, 12783, '\p{Blk=katakanaphoneticextensions}', "");
Expect(1, 12783, '\p{^Blk=katakanaphoneticextensions}', "");
Expect(1, 12783, '\P{Blk=katakanaphoneticextensions}', "");
Expect(0, 12783, '\P{^Blk=katakanaphoneticextensions}', "");
Expect(1, 12799, '\p{Blk= 	katakanaPHONETIC	Extensions}', "");
Expect(0, 12799, '\p{^Blk= 	katakanaPHONETIC	Extensions}', "");
Expect(0, 12799, '\P{Blk= 	katakanaPHONETIC	Extensions}', "");
Expect(1, 12799, '\P{^Blk= 	katakanaPHONETIC	Extensions}', "");
Expect(0, 12783, '\p{Blk= 	katakanaPHONETIC	Extensions}', "");
Expect(1, 12783, '\p{^Blk= 	katakanaPHONETIC	Extensions}', "");
Expect(1, 12783, '\P{Blk= 	katakanaPHONETIC	Extensions}', "");
Expect(0, 12783, '\P{^Blk= 	katakanaPHONETIC	Extensions}', "");
Error('\p{Is_Block= Katakana_Phonetic	Extensions:=}');
Error('\P{Is_Block= Katakana_Phonetic	Extensions:=}');
Expect(1, 12799, '\p{Is_Block:katakanaphoneticextensions}', "");
Expect(0, 12799, '\p{^Is_Block:katakanaphoneticextensions}', "");
Expect(0, 12799, '\P{Is_Block:katakanaphoneticextensions}', "");
Expect(1, 12799, '\P{^Is_Block:katakanaphoneticextensions}', "");
Expect(0, 12783, '\p{Is_Block:katakanaphoneticextensions}', "");
Expect(1, 12783, '\p{^Is_Block:katakanaphoneticextensions}', "");
Expect(1, 12783, '\P{Is_Block:katakanaphoneticextensions}', "");
Expect(0, 12783, '\P{^Is_Block:katakanaphoneticextensions}', "");
Expect(1, 12799, '\p{Is_Block=- Katakana_Phonetic extensions}', "");
Expect(0, 12799, '\p{^Is_Block=- Katakana_Phonetic extensions}', "");
Expect(0, 12799, '\P{Is_Block=- Katakana_Phonetic extensions}', "");
Expect(1, 12799, '\P{^Is_Block=- Katakana_Phonetic extensions}', "");
Expect(0, 12783, '\p{Is_Block=- Katakana_Phonetic extensions}', "");
Expect(1, 12783, '\p{^Is_Block=- Katakana_Phonetic extensions}', "");
Expect(1, 12783, '\P{Is_Block=- Katakana_Phonetic extensions}', "");
Expect(0, 12783, '\P{^Is_Block=- Katakana_Phonetic extensions}', "");
Error('\p{Is_Blk=	katakana_Phonetic	EXTENSIONS:=}');
Error('\P{Is_Blk=	katakana_Phonetic	EXTENSIONS:=}');
Expect(1, 12799, '\p{Is_Blk=katakanaphoneticextensions}', "");
Expect(0, 12799, '\p{^Is_Blk=katakanaphoneticextensions}', "");
Expect(0, 12799, '\P{Is_Blk=katakanaphoneticextensions}', "");
Expect(1, 12799, '\P{^Is_Blk=katakanaphoneticextensions}', "");
Expect(0, 12783, '\p{Is_Blk=katakanaphoneticextensions}', "");
Expect(1, 12783, '\p{^Is_Blk=katakanaphoneticextensions}', "");
Expect(1, 12783, '\P{Is_Blk=katakanaphoneticextensions}', "");
Expect(0, 12783, '\P{^Is_Blk=katakanaphoneticextensions}', "");
Expect(1, 12799, '\p{Is_Blk= katakana phonetic-Extensions}', "");
Expect(0, 12799, '\p{^Is_Blk= katakana phonetic-Extensions}', "");
Expect(0, 12799, '\P{Is_Blk= katakana phonetic-Extensions}', "");
Expect(1, 12799, '\P{^Is_Blk= katakana phonetic-Extensions}', "");
Expect(0, 12783, '\p{Is_Blk= katakana phonetic-Extensions}', "");
Expect(1, 12783, '\p{^Is_Blk= katakana phonetic-Extensions}', "");
Expect(1, 12783, '\P{Is_Blk= katakana phonetic-Extensions}', "");
Expect(0, 12783, '\P{^Is_Blk= katakana phonetic-Extensions}', "");
Error('\p{Block=_/a/LETTERLIKESymbols}');
Error('\P{Block=_/a/LETTERLIKESymbols}');
Expect(1, 8527, '\p{Block=letterlikesymbols}', "");
Expect(0, 8527, '\p{^Block=letterlikesymbols}', "");
Expect(0, 8527, '\P{Block=letterlikesymbols}', "");
Expect(1, 8527, '\P{^Block=letterlikesymbols}', "");
Expect(0, 8447, '\p{Block=letterlikesymbols}', "");
Expect(1, 8447, '\p{^Block=letterlikesymbols}', "");
Expect(1, 8447, '\P{Block=letterlikesymbols}', "");
Expect(0, 8447, '\P{^Block=letterlikesymbols}', "");
Expect(1, 8527, '\p{Block=	_LETTERLIKESymbols}', "");
Expect(0, 8527, '\p{^Block=	_LETTERLIKESymbols}', "");
Expect(0, 8527, '\P{Block=	_LETTERLIKESymbols}', "");
Expect(1, 8527, '\P{^Block=	_LETTERLIKESymbols}', "");
Expect(0, 8447, '\p{Block=	_LETTERLIKESymbols}', "");
Expect(1, 8447, '\p{^Block=	_LETTERLIKESymbols}', "");
Expect(1, 8447, '\P{Block=	_LETTERLIKESymbols}', "");
Expect(0, 8447, '\P{^Block=	_LETTERLIKESymbols}', "");
Error('\p{Blk=	_Letterlike	Symbols:=}');
Error('\P{Blk=	_Letterlike	Symbols:=}');
Expect(1, 8527, '\p{Blk=letterlikesymbols}', "");
Expect(0, 8527, '\p{^Blk=letterlikesymbols}', "");
Expect(0, 8527, '\P{Blk=letterlikesymbols}', "");
Expect(1, 8527, '\P{^Blk=letterlikesymbols}', "");
Expect(0, 8447, '\p{Blk=letterlikesymbols}', "");
Expect(1, 8447, '\p{^Blk=letterlikesymbols}', "");
Expect(1, 8447, '\P{Blk=letterlikesymbols}', "");
Expect(0, 8447, '\P{^Blk=letterlikesymbols}', "");
Expect(1, 8527, '\p{Blk=  letterlike Symbols}', "");
Expect(0, 8527, '\p{^Blk=  letterlike Symbols}', "");
Expect(0, 8527, '\P{Blk=  letterlike Symbols}', "");
Expect(1, 8527, '\P{^Blk=  letterlike Symbols}', "");
Expect(0, 8447, '\p{Blk=  letterlike Symbols}', "");
Expect(1, 8447, '\p{^Blk=  letterlike Symbols}', "");
Expect(1, 8447, '\P{Blk=  letterlike Symbols}', "");
Expect(0, 8447, '\P{^Blk=  letterlike Symbols}', "");
Error('\p{Is_Block=:= letterlikeSymbols}');
Error('\P{Is_Block=:= letterlikeSymbols}');
Expect(1, 8527, '\p{Is_Block=letterlikesymbols}', "");
Expect(0, 8527, '\p{^Is_Block=letterlikesymbols}', "");
Expect(0, 8527, '\P{Is_Block=letterlikesymbols}', "");
Expect(1, 8527, '\P{^Is_Block=letterlikesymbols}', "");
Expect(0, 8447, '\p{Is_Block=letterlikesymbols}', "");
Expect(1, 8447, '\p{^Is_Block=letterlikesymbols}', "");
Expect(1, 8447, '\P{Is_Block=letterlikesymbols}', "");
Expect(0, 8447, '\P{^Is_Block=letterlikesymbols}', "");
Expect(1, 8527, '\p{Is_Block=Letterlike-symbols}', "");
Expect(0, 8527, '\p{^Is_Block=Letterlike-symbols}', "");
Expect(0, 8527, '\P{Is_Block=Letterlike-symbols}', "");
Expect(1, 8527, '\P{^Is_Block=Letterlike-symbols}', "");
Expect(0, 8447, '\p{Is_Block=Letterlike-symbols}', "");
Expect(1, 8447, '\p{^Is_Block=Letterlike-symbols}', "");
Expect(1, 8447, '\P{Is_Block=Letterlike-symbols}', "");
Expect(0, 8447, '\P{^Is_Block=Letterlike-symbols}', "");
Error('\p{Is_Blk=-Letterlike/a/SYMBOLS}');
Error('\P{Is_Blk=-Letterlike/a/SYMBOLS}');
Expect(1, 8527, '\p{Is_Blk=letterlikesymbols}', "");
Expect(0, 8527, '\p{^Is_Blk=letterlikesymbols}', "");
Expect(0, 8527, '\P{Is_Blk=letterlikesymbols}', "");
Expect(1, 8527, '\P{^Is_Blk=letterlikesymbols}', "");
Expect(0, 8447, '\p{Is_Blk=letterlikesymbols}', "");
Expect(1, 8447, '\p{^Is_Blk=letterlikesymbols}', "");
Expect(1, 8447, '\P{Is_Blk=letterlikesymbols}', "");
Expect(0, 8447, '\P{^Is_Blk=letterlikesymbols}', "");
Expect(1, 8527, '\p{Is_Blk: -	Letterlike_Symbols}', "");
Expect(0, 8527, '\p{^Is_Blk: -	Letterlike_Symbols}', "");
Expect(0, 8527, '\P{Is_Blk: -	Letterlike_Symbols}', "");
Expect(1, 8527, '\P{^Is_Blk: -	Letterlike_Symbols}', "");
Expect(0, 8447, '\p{Is_Blk: -	Letterlike_Symbols}', "");
Expect(1, 8447, '\p{^Is_Blk: -	Letterlike_Symbols}', "");
Expect(1, 8447, '\P{Is_Blk: -	Letterlike_Symbols}', "");
Expect(0, 8447, '\P{^Is_Blk: -	Letterlike_Symbols}', "");
Error('\p{Block=	_LATIN:=EXTENDED	C}');
Error('\P{Block=	_LATIN:=EXTENDED	C}');
Expect(1, 11391, '\p{Block=latinextendedc}', "");
Expect(0, 11391, '\p{^Block=latinextendedc}', "");
Expect(0, 11391, '\P{Block=latinextendedc}', "");
Expect(1, 11391, '\P{^Block=latinextendedc}', "");
Expect(0, 11359, '\p{Block=latinextendedc}', "");
Expect(1, 11359, '\p{^Block=latinextendedc}', "");
Expect(1, 11359, '\P{Block=latinextendedc}', "");
Expect(0, 11359, '\P{^Block=latinextendedc}', "");
Expect(1, 11391, '\p{Block=_LatinEXTENDED	c}', "");
Expect(0, 11391, '\p{^Block=_LatinEXTENDED	c}', "");
Expect(0, 11391, '\P{Block=_LatinEXTENDED	c}', "");
Expect(1, 11391, '\P{^Block=_LatinEXTENDED	c}', "");
Expect(0, 11359, '\p{Block=_LatinEXTENDED	c}', "");
Expect(1, 11359, '\p{^Block=_LatinEXTENDED	c}', "");
Expect(1, 11359, '\P{Block=_LatinEXTENDED	c}', "");
Expect(0, 11359, '\P{^Block=_LatinEXTENDED	c}', "");
Error('\p{Blk:   -/a/Latin	EXTENDED C}');
Error('\P{Blk:   -/a/Latin	EXTENDED C}');
Expect(1, 11391, '\p{Blk=latinextendedc}', "");
Expect(0, 11391, '\p{^Blk=latinextendedc}', "");
Expect(0, 11391, '\P{Blk=latinextendedc}', "");
Expect(1, 11391, '\P{^Blk=latinextendedc}', "");
Expect(0, 11359, '\p{Blk=latinextendedc}', "");
Expect(1, 11359, '\p{^Blk=latinextendedc}', "");
Expect(1, 11359, '\P{Blk=latinextendedc}', "");
Expect(0, 11359, '\P{^Blk=latinextendedc}', "");
Expect(1, 11391, '\p{Blk=		LATINEXTENDEDc}', "");
Expect(0, 11391, '\p{^Blk=		LATINEXTENDEDc}', "");
Expect(0, 11391, '\P{Blk=		LATINEXTENDEDc}', "");
Expect(1, 11391, '\P{^Blk=		LATINEXTENDEDc}', "");
Expect(0, 11359, '\p{Blk=		LATINEXTENDEDc}', "");
Expect(1, 11359, '\p{^Blk=		LATINEXTENDEDc}', "");
Expect(1, 11359, '\P{Blk=		LATINEXTENDEDc}', "");
Expect(0, 11359, '\P{^Blk=		LATINEXTENDEDc}', "");
Error('\p{Is_Block= _LATIN_extended/a/C}');
Error('\P{Is_Block= _LATIN_extended/a/C}');
Expect(1, 11391, '\p{Is_Block=latinextendedc}', "");
Expect(0, 11391, '\p{^Is_Block=latinextendedc}', "");
Expect(0, 11391, '\P{Is_Block=latinextendedc}', "");
Expect(1, 11391, '\P{^Is_Block=latinextendedc}', "");
Expect(0, 11359, '\p{Is_Block=latinextendedc}', "");
Expect(1, 11359, '\p{^Is_Block=latinextendedc}', "");
Expect(1, 11359, '\P{Is_Block=latinextendedc}', "");
Expect(0, 11359, '\P{^Is_Block=latinextendedc}', "");
Expect(1, 11391, '\p{Is_Block=	_latinextended-C}', "");
Expect(0, 11391, '\p{^Is_Block=	_latinextended-C}', "");
Expect(0, 11391, '\P{Is_Block=	_latinextended-C}', "");
Expect(1, 11391, '\P{^Is_Block=	_latinextended-C}', "");
Expect(0, 11359, '\p{Is_Block=	_latinextended-C}', "");
Expect(1, 11359, '\p{^Is_Block=	_latinextended-C}', "");
Expect(1, 11359, '\P{Is_Block=	_latinextended-C}', "");
Expect(0, 11359, '\P{^Is_Block=	_latinextended-C}', "");
Error('\p{Is_Blk:		:=latin-Extended	C}');
Error('\P{Is_Blk:		:=latin-Extended	C}');
Expect(1, 11391, '\p{Is_Blk=latinextendedc}', "");
Expect(0, 11391, '\p{^Is_Blk=latinextendedc}', "");
Expect(0, 11391, '\P{Is_Blk=latinextendedc}', "");
Expect(1, 11391, '\P{^Is_Blk=latinextendedc}', "");
Expect(0, 11359, '\p{Is_Blk=latinextendedc}', "");
Expect(1, 11359, '\p{^Is_Blk=latinextendedc}', "");
Expect(1, 11359, '\P{Is_Blk=latinextendedc}', "");
Expect(0, 11359, '\P{^Is_Blk=latinextendedc}', "");
Expect(1, 11391, '\p{Is_Blk=	_LATIN_extended	c}', "");
Expect(0, 11391, '\p{^Is_Blk=	_LATIN_extended	c}', "");
Expect(0, 11391, '\P{Is_Blk=	_LATIN_extended	c}', "");
Expect(1, 11391, '\P{^Is_Blk=	_LATIN_extended	c}', "");
Expect(0, 11359, '\p{Is_Blk=	_LATIN_extended	c}', "");
Expect(1, 11359, '\p{^Is_Blk=	_LATIN_extended	c}', "");
Expect(1, 11359, '\P{Is_Blk=	_LATIN_extended	c}', "");
Expect(0, 11359, '\P{^Is_Blk=	_LATIN_extended	c}', "");
Error('\p{Block=/a/-	common-indic number Forms}');
Error('\P{Block=/a/-	common-indic number Forms}');
Expect(1, 43071, '\p{Block:   commonindicnumberforms}', "");
Expect(0, 43071, '\p{^Block:   commonindicnumberforms}', "");
Expect(0, 43071, '\P{Block:   commonindicnumberforms}', "");
Expect(1, 43071, '\P{^Block:   commonindicnumberforms}', "");
Expect(0, 43055, '\p{Block:   commonindicnumberforms}', "");
Expect(1, 43055, '\p{^Block:   commonindicnumberforms}', "");
Expect(1, 43055, '\P{Block:   commonindicnumberforms}', "");
Expect(0, 43055, '\P{^Block:   commonindicnumberforms}', "");
Expect(1, 43071, '\p{Block=		common-INDIC_NUMBER forms}', "");
Expect(0, 43071, '\p{^Block=		common-INDIC_NUMBER forms}', "");
Expect(0, 43071, '\P{Block=		common-INDIC_NUMBER forms}', "");
Expect(1, 43071, '\P{^Block=		common-INDIC_NUMBER forms}', "");
Expect(0, 43055, '\p{Block=		common-INDIC_NUMBER forms}', "");
Expect(1, 43055, '\p{^Block=		common-INDIC_NUMBER forms}', "");
Expect(1, 43055, '\P{Block=		common-INDIC_NUMBER forms}', "");
Expect(0, 43055, '\P{^Block=		common-INDIC_NUMBER forms}', "");
Error('\p{Blk= Common/a/Indic Number	forms}');
Error('\P{Blk= Common/a/Indic Number	forms}');
Expect(1, 43071, '\p{Blk: commonindicnumberforms}', "");
Expect(0, 43071, '\p{^Blk: commonindicnumberforms}', "");
Expect(0, 43071, '\P{Blk: commonindicnumberforms}', "");
Expect(1, 43071, '\P{^Blk: commonindicnumberforms}', "");
Expect(0, 43055, '\p{Blk: commonindicnumberforms}', "");
Expect(1, 43055, '\p{^Blk: commonindicnumberforms}', "");
Expect(1, 43055, '\P{Blk: commonindicnumberforms}', "");
Expect(0, 43055, '\P{^Blk: commonindicnumberforms}', "");
Expect(1, 43071, '\p{Blk=	common_Indic_Number	Forms}', "");
Expect(0, 43071, '\p{^Blk=	common_Indic_Number	Forms}', "");
Expect(0, 43071, '\P{Blk=	common_Indic_Number	Forms}', "");
Expect(1, 43071, '\P{^Blk=	common_Indic_Number	Forms}', "");
Expect(0, 43055, '\p{Blk=	common_Indic_Number	Forms}', "");
Expect(1, 43055, '\p{^Blk=	common_Indic_Number	Forms}', "");
Expect(1, 43055, '\P{Blk=	common_Indic_Number	Forms}', "");
Expect(0, 43055, '\P{^Blk=	common_Indic_Number	Forms}', "");
Error('\p{Is_Block=:=COMMON Indic_NUMBER FORMS}');
Error('\P{Is_Block=:=COMMON Indic_NUMBER FORMS}');
Expect(1, 43071, '\p{Is_Block:commonindicnumberforms}', "");
Expect(0, 43071, '\p{^Is_Block:commonindicnumberforms}', "");
Expect(0, 43071, '\P{Is_Block:commonindicnumberforms}', "");
Expect(1, 43071, '\P{^Is_Block:commonindicnumberforms}', "");
Expect(0, 43055, '\p{Is_Block:commonindicnumberforms}', "");
Expect(1, 43055, '\p{^Is_Block:commonindicnumberforms}', "");
Expect(1, 43055, '\P{Is_Block:commonindicnumberforms}', "");
Expect(0, 43055, '\P{^Is_Block:commonindicnumberforms}', "");
Expect(1, 43071, '\p{Is_Block=	_COMMON-Indic	Number_Forms}', "");
Expect(0, 43071, '\p{^Is_Block=	_COMMON-Indic	Number_Forms}', "");
Expect(0, 43071, '\P{Is_Block=	_COMMON-Indic	Number_Forms}', "");
Expect(1, 43071, '\P{^Is_Block=	_COMMON-Indic	Number_Forms}', "");
Expect(0, 43055, '\p{Is_Block=	_COMMON-Indic	Number_Forms}', "");
Expect(1, 43055, '\p{^Is_Block=	_COMMON-Indic	Number_Forms}', "");
Expect(1, 43055, '\P{Is_Block=	_COMMON-Indic	Number_Forms}', "");
Expect(0, 43055, '\P{^Is_Block=	_COMMON-Indic	Number_Forms}', "");
Error('\p{Is_Blk=	:=Common-INDIC number	Forms}');
Error('\P{Is_Blk=	:=Common-INDIC number	Forms}');
Expect(1, 43071, '\p{Is_Blk=commonindicnumberforms}', "");
Expect(0, 43071, '\p{^Is_Blk=commonindicnumberforms}', "");
Expect(0, 43071, '\P{Is_Blk=commonindicnumberforms}', "");
Expect(1, 43071, '\P{^Is_Blk=commonindicnumberforms}', "");
Expect(0, 43055, '\p{Is_Blk=commonindicnumberforms}', "");
Expect(1, 43055, '\p{^Is_Blk=commonindicnumberforms}', "");
Expect(1, 43055, '\P{Is_Blk=commonindicnumberforms}', "");
Expect(0, 43055, '\P{^Is_Blk=commonindicnumberforms}', "");
Expect(1, 43071, '\p{Is_Blk=-COMMON-IndicNumber-forms}', "");
Expect(0, 43071, '\p{^Is_Blk=-COMMON-IndicNumber-forms}', "");
Expect(0, 43071, '\P{Is_Blk=-COMMON-IndicNumber-forms}', "");
Expect(1, 43071, '\P{^Is_Blk=-COMMON-IndicNumber-forms}', "");
Expect(0, 43055, '\p{Is_Blk=-COMMON-IndicNumber-forms}', "");
Expect(1, 43055, '\p{^Is_Blk=-COMMON-IndicNumber-forms}', "");
Expect(1, 43055, '\P{Is_Blk=-COMMON-IndicNumber-forms}', "");
Expect(0, 43055, '\P{^Is_Blk=-COMMON-IndicNumber-forms}', "");
Error('\p{Block=	-Meetei:=MAYEK}');
Error('\P{Block=	-Meetei:=MAYEK}');
Expect(1, 44031, '\p{Block=meeteimayek}', "");
Expect(0, 44031, '\p{^Block=meeteimayek}', "");
Expect(0, 44031, '\P{Block=meeteimayek}', "");
Expect(1, 44031, '\P{^Block=meeteimayek}', "");
Expect(0, 43967, '\p{Block=meeteimayek}', "");
Expect(1, 43967, '\p{^Block=meeteimayek}', "");
Expect(1, 43967, '\P{Block=meeteimayek}', "");
Expect(0, 43967, '\P{^Block=meeteimayek}', "");
Expect(1, 44031, '\p{Block=	Meetei_Mayek}', "");
Expect(0, 44031, '\p{^Block=	Meetei_Mayek}', "");
Expect(0, 44031, '\P{Block=	Meetei_Mayek}', "");
Expect(1, 44031, '\P{^Block=	Meetei_Mayek}', "");
Expect(0, 43967, '\p{Block=	Meetei_Mayek}', "");
Expect(1, 43967, '\p{^Block=	Meetei_Mayek}', "");
Expect(1, 43967, '\P{Block=	Meetei_Mayek}', "");
Expect(0, 43967, '\P{^Block=	Meetei_Mayek}', "");
Error('\p{Blk:	 :=Meetei	MAYEK}');
Error('\P{Blk:	 :=Meetei	MAYEK}');
Expect(1, 44031, '\p{Blk=meeteimayek}', "");
Expect(0, 44031, '\p{^Blk=meeteimayek}', "");
Expect(0, 44031, '\P{Blk=meeteimayek}', "");
Expect(1, 44031, '\P{^Blk=meeteimayek}', "");
Expect(0, 43967, '\p{Blk=meeteimayek}', "");
Expect(1, 43967, '\p{^Blk=meeteimayek}', "");
Expect(1, 43967, '\P{Blk=meeteimayek}', "");
Expect(0, 43967, '\P{^Blk=meeteimayek}', "");
Expect(1, 44031, '\p{Blk=_	MeeteiMayek}', "");
Expect(0, 44031, '\p{^Blk=_	MeeteiMayek}', "");
Expect(0, 44031, '\P{Blk=_	MeeteiMayek}', "");
Expect(1, 44031, '\P{^Blk=_	MeeteiMayek}', "");
Expect(0, 43967, '\p{Blk=_	MeeteiMayek}', "");
Expect(1, 43967, '\p{^Blk=_	MeeteiMayek}', "");
Expect(1, 43967, '\P{Blk=_	MeeteiMayek}', "");
Expect(0, 43967, '\P{^Blk=_	MeeteiMayek}', "");
Error('\p{Is_Block=:=MEETEI Mayek}');
Error('\P{Is_Block=:=MEETEI Mayek}');
Expect(1, 44031, '\p{Is_Block=meeteimayek}', "");
Expect(0, 44031, '\p{^Is_Block=meeteimayek}', "");
Expect(0, 44031, '\P{Is_Block=meeteimayek}', "");
Expect(1, 44031, '\P{^Is_Block=meeteimayek}', "");
Expect(0, 43967, '\p{Is_Block=meeteimayek}', "");
Expect(1, 43967, '\p{^Is_Block=meeteimayek}', "");
Expect(1, 43967, '\P{Is_Block=meeteimayek}', "");
Expect(0, 43967, '\P{^Is_Block=meeteimayek}', "");
Expect(1, 44031, '\p{Is_Block=		Meetei mayek}', "");
Expect(0, 44031, '\p{^Is_Block=		Meetei mayek}', "");
Expect(0, 44031, '\P{Is_Block=		Meetei mayek}', "");
Expect(1, 44031, '\P{^Is_Block=		Meetei mayek}', "");
Expect(0, 43967, '\p{Is_Block=		Meetei mayek}', "");
Expect(1, 43967, '\p{^Is_Block=		Meetei mayek}', "");
Expect(1, 43967, '\P{Is_Block=		Meetei mayek}', "");
Expect(0, 43967, '\P{^Is_Block=		Meetei mayek}', "");
Error('\p{Is_Blk:	  MEETEI	mayek/a/}');
Error('\P{Is_Blk:	  MEETEI	mayek/a/}');
Expect(1, 44031, '\p{Is_Blk=meeteimayek}', "");
Expect(0, 44031, '\p{^Is_Blk=meeteimayek}', "");
Expect(0, 44031, '\P{Is_Blk=meeteimayek}', "");
Expect(1, 44031, '\P{^Is_Blk=meeteimayek}', "");
Expect(0, 43967, '\p{Is_Blk=meeteimayek}', "");
Expect(1, 43967, '\p{^Is_Blk=meeteimayek}', "");
Expect(1, 43967, '\P{Is_Blk=meeteimayek}', "");
Expect(0, 43967, '\P{^Is_Blk=meeteimayek}', "");
Expect(1, 44031, '\p{Is_Blk=- meetei-mayek}', "");
Expect(0, 44031, '\p{^Is_Blk=- meetei-mayek}', "");
Expect(0, 44031, '\P{Is_Blk=- meetei-mayek}', "");
Expect(1, 44031, '\P{^Is_Blk=- meetei-mayek}', "");
Expect(0, 43967, '\p{Is_Blk=- meetei-mayek}', "");
Expect(1, 43967, '\p{^Is_Blk=- meetei-mayek}', "");
Expect(1, 43967, '\P{Is_Blk=- meetei-mayek}', "");
Expect(0, 43967, '\P{^Is_Blk=- meetei-mayek}', "");
Error('\p{Block= :=Supplemental	mathematical-OPERATORS}');
Error('\P{Block= :=Supplemental	mathematical-OPERATORS}');
Expect(1, 11007, '\p{Block:supplementalmathematicaloperators}', "");
Expect(0, 11007, '\p{^Block:supplementalmathematicaloperators}', "");
Expect(0, 11007, '\P{Block:supplementalmathematicaloperators}', "");
Expect(1, 11007, '\P{^Block:supplementalmathematicaloperators}', "");
Expect(0, 10751, '\p{Block:supplementalmathematicaloperators}', "");
Expect(1, 10751, '\p{^Block:supplementalmathematicaloperators}', "");
Expect(1, 10751, '\P{Block:supplementalmathematicaloperators}', "");
Expect(0, 10751, '\P{^Block:supplementalmathematicaloperators}', "");
Expect(1, 11007, '\p{Block=	 SUPPLEMENTAL-MATHEMATICAL	operators}', "");
Expect(0, 11007, '\p{^Block=	 SUPPLEMENTAL-MATHEMATICAL	operators}', "");
Expect(0, 11007, '\P{Block=	 SUPPLEMENTAL-MATHEMATICAL	operators}', "");
Expect(1, 11007, '\P{^Block=	 SUPPLEMENTAL-MATHEMATICAL	operators}', "");
Expect(0, 10751, '\p{Block=	 SUPPLEMENTAL-MATHEMATICAL	operators}', "");
Expect(1, 10751, '\p{^Block=	 SUPPLEMENTAL-MATHEMATICAL	operators}', "");
Expect(1, 10751, '\P{Block=	 SUPPLEMENTAL-MATHEMATICAL	operators}', "");
Expect(0, 10751, '\P{^Block=	 SUPPLEMENTAL-MATHEMATICAL	operators}', "");
Error('\p{Blk=_:=SUPPLEMENTALMathematicalOPERATORS}');
Error('\P{Blk=_:=SUPPLEMENTALMathematicalOPERATORS}');
Expect(1, 11007, '\p{Blk=supplementalmathematicaloperators}', "");
Expect(0, 11007, '\p{^Blk=supplementalmathematicaloperators}', "");
Expect(0, 11007, '\P{Blk=supplementalmathematicaloperators}', "");
Expect(1, 11007, '\P{^Blk=supplementalmathematicaloperators}', "");
Expect(0, 10751, '\p{Blk=supplementalmathematicaloperators}', "");
Expect(1, 10751, '\p{^Blk=supplementalmathematicaloperators}', "");
Expect(1, 10751, '\P{Blk=supplementalmathematicaloperators}', "");
Expect(0, 10751, '\P{^Blk=supplementalmathematicaloperators}', "");
Expect(1, 11007, '\p{Blk=--Supplemental-Mathematicaloperators}', "");
Expect(0, 11007, '\p{^Blk=--Supplemental-Mathematicaloperators}', "");
Expect(0, 11007, '\P{Blk=--Supplemental-Mathematicaloperators}', "");
Expect(1, 11007, '\P{^Blk=--Supplemental-Mathematicaloperators}', "");
Expect(0, 10751, '\p{Blk=--Supplemental-Mathematicaloperators}', "");
Expect(1, 10751, '\p{^Blk=--Supplemental-Mathematicaloperators}', "");
Expect(1, 10751, '\P{Blk=--Supplemental-Mathematicaloperators}', "");
Expect(0, 10751, '\P{^Blk=--Supplemental-Mathematicaloperators}', "");
Error('\p{Is_Block=__Supplemental/a/Mathematical-Operators}');
Error('\P{Is_Block=__Supplemental/a/Mathematical-Operators}');
Expect(1, 11007, '\p{Is_Block=supplementalmathematicaloperators}', "");
Expect(0, 11007, '\p{^Is_Block=supplementalmathematicaloperators}', "");
Expect(0, 11007, '\P{Is_Block=supplementalmathematicaloperators}', "");
Expect(1, 11007, '\P{^Is_Block=supplementalmathematicaloperators}', "");
Expect(0, 10751, '\p{Is_Block=supplementalmathematicaloperators}', "");
Expect(1, 10751, '\p{^Is_Block=supplementalmathematicaloperators}', "");
Expect(1, 10751, '\P{Is_Block=supplementalmathematicaloperators}', "");
Expect(0, 10751, '\P{^Is_Block=supplementalmathematicaloperators}', "");
Expect(1, 11007, '\p{Is_Block=_ supplemental_Mathematical-operators}', "");
Expect(0, 11007, '\p{^Is_Block=_ supplemental_Mathematical-operators}', "");
Expect(0, 11007, '\P{Is_Block=_ supplemental_Mathematical-operators}', "");
Expect(1, 11007, '\P{^Is_Block=_ supplemental_Mathematical-operators}', "");
Expect(0, 10751, '\p{Is_Block=_ supplemental_Mathematical-operators}', "");
Expect(1, 10751, '\p{^Is_Block=_ supplemental_Mathematical-operators}', "");
Expect(1, 10751, '\P{Is_Block=_ supplemental_Mathematical-operators}', "");
Expect(0, 10751, '\P{^Is_Block=_ supplemental_Mathematical-operators}', "");
Error('\p{Is_Blk= SUPPLEMENTAL:=Mathematical_Operators}');
Error('\P{Is_Blk= SUPPLEMENTAL:=Mathematical_Operators}');
Expect(1, 11007, '\p{Is_Blk=supplementalmathematicaloperators}', "");
Expect(0, 11007, '\p{^Is_Blk=supplementalmathematicaloperators}', "");
Expect(0, 11007, '\P{Is_Blk=supplementalmathematicaloperators}', "");
Expect(1, 11007, '\P{^Is_Blk=supplementalmathematicaloperators}', "");
Expect(0, 10751, '\p{Is_Blk=supplementalmathematicaloperators}', "");
Expect(1, 10751, '\p{^Is_Blk=supplementalmathematicaloperators}', "");
Expect(1, 10751, '\P{Is_Blk=supplementalmathematicaloperators}', "");
Expect(0, 10751, '\P{^Is_Blk=supplementalmathematicaloperators}', "");
Expect(1, 11007, '\p{Is_Blk:	supplemental_Mathematical	Operators}', "");
Expect(0, 11007, '\p{^Is_Blk:	supplemental_Mathematical	Operators}', "");
Expect(0, 11007, '\P{Is_Blk:	supplemental_Mathematical	Operators}', "");
Expect(1, 11007, '\P{^Is_Blk:	supplemental_Mathematical	Operators}', "");
Expect(0, 10751, '\p{Is_Blk:	supplemental_Mathematical	Operators}', "");
Expect(1, 10751, '\p{^Is_Blk:	supplemental_Mathematical	Operators}', "");
Expect(1, 10751, '\P{Is_Blk:	supplemental_Mathematical	Operators}', "");
Expect(0, 10751, '\P{^Is_Blk:	supplemental_Mathematical	Operators}', "");
Error('\p{Block=:= Shavian}');
Error('\P{Block=:= Shavian}');
Expect(1, 66687, '\p{Block:	shavian}', "");
Expect(0, 66687, '\p{^Block:	shavian}', "");
Expect(0, 66687, '\P{Block:	shavian}', "");
Expect(1, 66687, '\P{^Block:	shavian}', "");
Expect(0, 66639, '\p{Block:	shavian}', "");
Expect(1, 66639, '\p{^Block:	shavian}', "");
Expect(1, 66639, '\P{Block:	shavian}', "");
Expect(0, 66639, '\P{^Block:	shavian}', "");
Expect(1, 66687, '\p{Block=	Shavian}', "");
Expect(0, 66687, '\p{^Block=	Shavian}', "");
Expect(0, 66687, '\P{Block=	Shavian}', "");
Expect(1, 66687, '\P{^Block=	Shavian}', "");
Expect(0, 66639, '\p{Block=	Shavian}', "");
Expect(1, 66639, '\p{^Block=	Shavian}', "");
Expect(1, 66639, '\P{Block=	Shavian}', "");
Expect(0, 66639, '\P{^Block=	Shavian}', "");
Error('\p{Blk=		shavian:=}');
Error('\P{Blk=		shavian:=}');
Expect(1, 66687, '\p{Blk=shavian}', "");
Expect(0, 66687, '\p{^Blk=shavian}', "");
Expect(0, 66687, '\P{Blk=shavian}', "");
Expect(1, 66687, '\P{^Blk=shavian}', "");
Expect(0, 66639, '\p{Blk=shavian}', "");
Expect(1, 66639, '\p{^Blk=shavian}', "");
Expect(1, 66639, '\P{Blk=shavian}', "");
Expect(0, 66639, '\P{^Blk=shavian}', "");
Expect(1, 66687, '\p{Blk:   -shavian}', "");
Expect(0, 66687, '\p{^Blk:   -shavian}', "");
Expect(0, 66687, '\P{Blk:   -shavian}', "");
Expect(1, 66687, '\P{^Blk:   -shavian}', "");
Expect(0, 66639, '\p{Blk:   -shavian}', "");
Expect(1, 66639, '\p{^Blk:   -shavian}', "");
Expect(1, 66639, '\P{Blk:   -shavian}', "");
Expect(0, 66639, '\P{^Blk:   -shavian}', "");
Error('\p{Is_Block:   	/a/Shavian}');
Error('\P{Is_Block:   	/a/Shavian}');
Expect(1, 66687, '\p{Is_Block:	shavian}', "");
Expect(0, 66687, '\p{^Is_Block:	shavian}', "");
Expect(0, 66687, '\P{Is_Block:	shavian}', "");
Expect(1, 66687, '\P{^Is_Block:	shavian}', "");
Expect(0, 66639, '\p{Is_Block:	shavian}', "");
Expect(1, 66639, '\p{^Is_Block:	shavian}', "");
Expect(1, 66639, '\P{Is_Block:	shavian}', "");
Expect(0, 66639, '\P{^Is_Block:	shavian}', "");
Expect(1, 66687, '\p{Is_Block=	SHAVIAN}', "");
Expect(0, 66687, '\p{^Is_Block=	SHAVIAN}', "");
Expect(0, 66687, '\P{Is_Block=	SHAVIAN}', "");
Expect(1, 66687, '\P{^Is_Block=	SHAVIAN}', "");
Expect(0, 66639, '\p{Is_Block=	SHAVIAN}', "");
Expect(1, 66639, '\p{^Is_Block=	SHAVIAN}', "");
Expect(1, 66639, '\P{Is_Block=	SHAVIAN}', "");
Expect(0, 66639, '\P{^Is_Block=	SHAVIAN}', "");
Error('\p{Is_Blk:	:=Shavian}');
Error('\P{Is_Blk:	:=Shavian}');
Expect(1, 66687, '\p{Is_Blk=shavian}', "");
Expect(0, 66687, '\p{^Is_Blk=shavian}', "");
Expect(0, 66687, '\P{Is_Blk=shavian}', "");
Expect(1, 66687, '\P{^Is_Blk=shavian}', "");
Expect(0, 66639, '\p{Is_Blk=shavian}', "");
Expect(1, 66639, '\p{^Is_Blk=shavian}', "");
Expect(1, 66639, '\P{Is_Blk=shavian}', "");
Expect(0, 66639, '\P{^Is_Blk=shavian}', "");
Expect(1, 66687, '\p{Is_Blk=_shavian}', "");
Expect(0, 66687, '\p{^Is_Blk=_shavian}', "");
Expect(0, 66687, '\P{Is_Blk=_shavian}', "");
Expect(1, 66687, '\P{^Is_Blk=_shavian}', "");
Expect(0, 66639, '\p{Is_Blk=_shavian}', "");
Expect(1, 66639, '\p{^Is_Blk=_shavian}', "");
Expect(1, 66639, '\P{Is_Blk=_shavian}', "");
Expect(0, 66639, '\P{^Is_Blk=_shavian}', "");
Error('\p{Block=:= 	Lydian}');
Error('\P{Block=:= 	Lydian}');
Expect(1, 67903, '\p{Block=lydian}', "");
Expect(0, 67903, '\p{^Block=lydian}', "");
Expect(0, 67903, '\P{Block=lydian}', "");
Expect(1, 67903, '\P{^Block=lydian}', "");
Expect(0, 67871, '\p{Block=lydian}', "");
Expect(1, 67871, '\p{^Block=lydian}', "");
Expect(1, 67871, '\P{Block=lydian}', "");
Expect(0, 67871, '\P{^Block=lydian}', "");
Expect(1, 67903, '\p{Block=		lydian}', "");
Expect(0, 67903, '\p{^Block=		lydian}', "");
Expect(0, 67903, '\P{Block=		lydian}', "");
Expect(1, 67903, '\P{^Block=		lydian}', "");
Expect(0, 67871, '\p{Block=		lydian}', "");
Expect(1, 67871, '\p{^Block=		lydian}', "");
Expect(1, 67871, '\P{Block=		lydian}', "");
Expect(0, 67871, '\P{^Block=		lydian}', "");
Error('\p{Blk=-:=lydian}');
Error('\P{Blk=-:=lydian}');
Expect(1, 67903, '\p{Blk: lydian}', "");
Expect(0, 67903, '\p{^Blk: lydian}', "");
Expect(0, 67903, '\P{Blk: lydian}', "");
Expect(1, 67903, '\P{^Blk: lydian}', "");
Expect(0, 67871, '\p{Blk: lydian}', "");
Expect(1, 67871, '\p{^Blk: lydian}', "");
Expect(1, 67871, '\P{Blk: lydian}', "");
Expect(0, 67871, '\P{^Blk: lydian}', "");
Expect(1, 67903, '\p{Blk=	lydian}', "");
Expect(0, 67903, '\p{^Blk=	lydian}', "");
Expect(0, 67903, '\P{Blk=	lydian}', "");
Expect(1, 67903, '\P{^Blk=	lydian}', "");
Expect(0, 67871, '\p{Blk=	lydian}', "");
Expect(1, 67871, '\p{^Blk=	lydian}', "");
Expect(1, 67871, '\P{Blk=	lydian}', "");
Expect(0, 67871, '\P{^Blk=	lydian}', "");
Error('\p{Is_Block=-/a/Lydian}');
Error('\P{Is_Block=-/a/Lydian}');
Expect(1, 67903, '\p{Is_Block=lydian}', "");
Expect(0, 67903, '\p{^Is_Block=lydian}', "");
Expect(0, 67903, '\P{Is_Block=lydian}', "");
Expect(1, 67903, '\P{^Is_Block=lydian}', "");
Expect(0, 67871, '\p{Is_Block=lydian}', "");
Expect(1, 67871, '\p{^Is_Block=lydian}', "");
Expect(1, 67871, '\P{Is_Block=lydian}', "");
Expect(0, 67871, '\P{^Is_Block=lydian}', "");
Expect(1, 67903, '\p{Is_Block=_ Lydian}', "");
Expect(0, 67903, '\p{^Is_Block=_ Lydian}', "");
Expect(0, 67903, '\P{Is_Block=_ Lydian}', "");
Expect(1, 67903, '\P{^Is_Block=_ Lydian}', "");
Expect(0, 67871, '\p{Is_Block=_ Lydian}', "");
Expect(1, 67871, '\p{^Is_Block=_ Lydian}', "");
Expect(1, 67871, '\P{Is_Block=_ Lydian}', "");
Expect(0, 67871, '\P{^Is_Block=_ Lydian}', "");
Error('\p{Is_Blk=-/a/Lydian}');
Error('\P{Is_Blk=-/a/Lydian}');
Expect(1, 67903, '\p{Is_Blk=lydian}', "");
Expect(0, 67903, '\p{^Is_Blk=lydian}', "");
Expect(0, 67903, '\P{Is_Blk=lydian}', "");
Expect(1, 67903, '\P{^Is_Blk=lydian}', "");
Expect(0, 67871, '\p{Is_Blk=lydian}', "");
Expect(1, 67871, '\p{^Is_Blk=lydian}', "");
Expect(1, 67871, '\P{Is_Blk=lydian}', "");
Expect(0, 67871, '\P{^Is_Blk=lydian}', "");
Expect(1, 67903, '\p{Is_Blk=	-LYDIAN}', "");
Expect(0, 67903, '\p{^Is_Blk=	-LYDIAN}', "");
Expect(0, 67903, '\P{Is_Blk=	-LYDIAN}', "");
Expect(1, 67903, '\P{^Is_Blk=	-LYDIAN}', "");
Expect(0, 67871, '\p{Is_Blk=	-LYDIAN}', "");
Expect(1, 67871, '\p{^Is_Blk=	-LYDIAN}', "");
Expect(1, 67871, '\P{Is_Blk=	-LYDIAN}', "");
Expect(0, 67871, '\P{^Is_Blk=	-LYDIAN}', "");
Error('\p{Block=  cjkUnifiedIdeographs:=ExtensionC}');
Error('\P{Block=  cjkUnifiedIdeographs:=ExtensionC}');
Expect(1, 177983, '\p{Block=cjkunifiedideographsextensionc}', "");
Expect(0, 177983, '\p{^Block=cjkunifiedideographsextensionc}', "");
Expect(0, 177983, '\P{Block=cjkunifiedideographsextensionc}', "");
Expect(1, 177983, '\P{^Block=cjkunifiedideographsextensionc}', "");
Expect(0, 173823, '\p{Block=cjkunifiedideographsextensionc}', "");
Expect(1, 173823, '\p{^Block=cjkunifiedideographsextensionc}', "");
Expect(1, 173823, '\P{Block=cjkunifiedideographsextensionc}', "");
Expect(0, 173823, '\P{^Block=cjkunifiedideographsextensionc}', "");
Expect(1, 177983, '\p{Block=_CJK	Unified ideographs	EXTENSION	C}', "");
Expect(0, 177983, '\p{^Block=_CJK	Unified ideographs	EXTENSION	C}', "");
Expect(0, 177983, '\P{Block=_CJK	Unified ideographs	EXTENSION	C}', "");
Expect(1, 177983, '\P{^Block=_CJK	Unified ideographs	EXTENSION	C}', "");
Expect(0, 173823, '\p{Block=_CJK	Unified ideographs	EXTENSION	C}', "");
Expect(1, 173823, '\p{^Block=_CJK	Unified ideographs	EXTENSION	C}', "");
Expect(1, 173823, '\P{Block=_CJK	Unified ideographs	EXTENSION	C}', "");
Expect(0, 173823, '\P{^Block=_CJK	Unified ideographs	EXTENSION	C}', "");
Error('\p{Blk=	CJK Unified_IDEOGRAPHS-Extension_c:=}');
Error('\P{Blk=	CJK Unified_IDEOGRAPHS-Extension_c:=}');
Expect(1, 177983, '\p{Blk=cjkunifiedideographsextensionc}', "");
Expect(0, 177983, '\p{^Blk=cjkunifiedideographsextensionc}', "");
Expect(0, 177983, '\P{Blk=cjkunifiedideographsextensionc}', "");
Expect(1, 177983, '\P{^Blk=cjkunifiedideographsextensionc}', "");
Expect(0, 173823, '\p{Blk=cjkunifiedideographsextensionc}', "");
Expect(1, 173823, '\p{^Blk=cjkunifiedideographsextensionc}', "");
Expect(1, 173823, '\P{Blk=cjkunifiedideographsextensionc}', "");
Expect(0, 173823, '\P{^Blk=cjkunifiedideographsextensionc}', "");
Expect(1, 177983, '\p{Blk= _cjk	UNIFIED Ideographs_Extension-C}', "");
Expect(0, 177983, '\p{^Blk= _cjk	UNIFIED Ideographs_Extension-C}', "");
Expect(0, 177983, '\P{Blk= _cjk	UNIFIED Ideographs_Extension-C}', "");
Expect(1, 177983, '\P{^Blk= _cjk	UNIFIED Ideographs_Extension-C}', "");
Expect(0, 173823, '\p{Blk= _cjk	UNIFIED Ideographs_Extension-C}', "");
Expect(1, 173823, '\p{^Blk= _cjk	UNIFIED Ideographs_Extension-C}', "");
Expect(1, 173823, '\P{Blk= _cjk	UNIFIED Ideographs_Extension-C}', "");
Expect(0, 173823, '\P{^Blk= _cjk	UNIFIED Ideographs_Extension-C}', "");
Error('\p{Is_Block=:=	cjk unified_Ideographs-extension_C}');
Error('\P{Is_Block=:=	cjk unified_Ideographs-extension_C}');
Expect(1, 177983, '\p{Is_Block=cjkunifiedideographsextensionc}', "");
Expect(0, 177983, '\p{^Is_Block=cjkunifiedideographsextensionc}', "");
Expect(0, 177983, '\P{Is_Block=cjkunifiedideographsextensionc}', "");
Expect(1, 177983, '\P{^Is_Block=cjkunifiedideographsextensionc}', "");
Expect(0, 173823, '\p{Is_Block=cjkunifiedideographsextensionc}', "");
Expect(1, 173823, '\p{^Is_Block=cjkunifiedideographsextensionc}', "");
Expect(1, 173823, '\P{Is_Block=cjkunifiedideographsextensionc}', "");
Expect(0, 173823, '\P{^Is_Block=cjkunifiedideographsextensionc}', "");
Expect(1, 177983, '\p{Is_Block:	 CJK UNIFIED-ideographs-Extension-c}', "");
Expect(0, 177983, '\p{^Is_Block:	 CJK UNIFIED-ideographs-Extension-c}', "");
Expect(0, 177983, '\P{Is_Block:	 CJK UNIFIED-ideographs-Extension-c}', "");
Expect(1, 177983, '\P{^Is_Block:	 CJK UNIFIED-ideographs-Extension-c}', "");
Expect(0, 173823, '\p{Is_Block:	 CJK UNIFIED-ideographs-Extension-c}', "");
Expect(1, 173823, '\p{^Is_Block:	 CJK UNIFIED-ideographs-Extension-c}', "");
Expect(1, 173823, '\P{Is_Block:	 CJK UNIFIED-ideographs-Extension-c}', "");
Expect(0, 173823, '\P{^Is_Block:	 CJK UNIFIED-ideographs-Extension-c}', "");
Error('\p{Is_Blk=--CJK:=Unified_ideographs Extension_C}');
Error('\P{Is_Blk=--CJK:=Unified_ideographs Extension_C}');
Expect(1, 177983, '\p{Is_Blk: cjkunifiedideographsextensionc}', "");
Expect(0, 177983, '\p{^Is_Blk: cjkunifiedideographsextensionc}', "");
Expect(0, 177983, '\P{Is_Blk: cjkunifiedideographsextensionc}', "");
Expect(1, 177983, '\P{^Is_Blk: cjkunifiedideographsextensionc}', "");
Expect(0, 173823, '\p{Is_Blk: cjkunifiedideographsextensionc}', "");
Expect(1, 173823, '\p{^Is_Blk: cjkunifiedideographsextensionc}', "");
Expect(1, 173823, '\P{Is_Blk: cjkunifiedideographsextensionc}', "");
Expect(0, 173823, '\P{^Is_Blk: cjkunifiedideographsextensionc}', "");
Expect(1, 177983, '\p{Is_Blk=_	CJK_UnifiedideographsExtension_c}', "");
Expect(0, 177983, '\p{^Is_Blk=_	CJK_UnifiedideographsExtension_c}', "");
Expect(0, 177983, '\P{Is_Blk=_	CJK_UnifiedideographsExtension_c}', "");
Expect(1, 177983, '\P{^Is_Blk=_	CJK_UnifiedideographsExtension_c}', "");
Expect(0, 173823, '\p{Is_Blk=_	CJK_UnifiedideographsExtension_c}', "");
Expect(1, 173823, '\p{^Is_Blk=_	CJK_UnifiedideographsExtension_c}', "");
Expect(1, 173823, '\P{Is_Blk=_	CJK_UnifiedideographsExtension_c}', "");
Expect(0, 173823, '\P{^Is_Blk=_	CJK_UnifiedideographsExtension_c}', "");
Error('\p{Block:    Mongolian:=}');
Error('\P{Block:    Mongolian:=}');
Expect(1, 6319, '\p{Block=mongolian}', "");
Expect(0, 6319, '\p{^Block=mongolian}', "");
Expect(0, 6319, '\P{Block=mongolian}', "");
Expect(1, 6319, '\P{^Block=mongolian}', "");
Expect(0, 6143, '\p{Block=mongolian}', "");
Expect(1, 6143, '\p{^Block=mongolian}', "");
Expect(1, 6143, '\P{Block=mongolian}', "");
Expect(0, 6143, '\P{^Block=mongolian}', "");
Expect(1, 6319, '\p{Block=_Mongolian}', "");
Expect(0, 6319, '\p{^Block=_Mongolian}', "");
Expect(0, 6319, '\P{Block=_Mongolian}', "");
Expect(1, 6319, '\P{^Block=_Mongolian}', "");
Expect(0, 6143, '\p{Block=_Mongolian}', "");
Expect(1, 6143, '\p{^Block=_Mongolian}', "");
Expect(1, 6143, '\P{Block=_Mongolian}', "");
Expect(0, 6143, '\P{^Block=_Mongolian}', "");
Error('\p{Blk=:=Mongolian}');
Error('\P{Blk=:=Mongolian}');
Expect(1, 6319, '\p{Blk:   mongolian}', "");
Expect(0, 6319, '\p{^Blk:   mongolian}', "");
Expect(0, 6319, '\P{Blk:   mongolian}', "");
Expect(1, 6319, '\P{^Blk:   mongolian}', "");
Expect(0, 6143, '\p{Blk:   mongolian}', "");
Expect(1, 6143, '\p{^Blk:   mongolian}', "");
Expect(1, 6143, '\P{Blk:   mongolian}', "");
Expect(0, 6143, '\P{^Blk:   mongolian}', "");
Expect(1, 6319, '\p{Blk=	MONGOLIAN}', "");
Expect(0, 6319, '\p{^Blk=	MONGOLIAN}', "");
Expect(0, 6319, '\P{Blk=	MONGOLIAN}', "");
Expect(1, 6319, '\P{^Blk=	MONGOLIAN}', "");
Expect(0, 6143, '\p{Blk=	MONGOLIAN}', "");
Expect(1, 6143, '\p{^Blk=	MONGOLIAN}', "");
Expect(1, 6143, '\P{Blk=	MONGOLIAN}', "");
Expect(0, 6143, '\P{^Blk=	MONGOLIAN}', "");
Error('\p{Is_Block=/a/ _Mongolian}');
Error('\P{Is_Block=/a/ _Mongolian}');
Expect(1, 6319, '\p{Is_Block=mongolian}', "");
Expect(0, 6319, '\p{^Is_Block=mongolian}', "");
Expect(0, 6319, '\P{Is_Block=mongolian}', "");
Expect(1, 6319, '\P{^Is_Block=mongolian}', "");
Expect(0, 6143, '\p{Is_Block=mongolian}', "");
Expect(1, 6143, '\p{^Is_Block=mongolian}', "");
Expect(1, 6143, '\P{Is_Block=mongolian}', "");
Expect(0, 6143, '\P{^Is_Block=mongolian}', "");
Expect(1, 6319, '\p{Is_Block=-_mongolian}', "");
Expect(0, 6319, '\p{^Is_Block=-_mongolian}', "");
Expect(0, 6319, '\P{Is_Block=-_mongolian}', "");
Expect(1, 6319, '\P{^Is_Block=-_mongolian}', "");
Expect(0, 6143, '\p{Is_Block=-_mongolian}', "");
Expect(1, 6143, '\p{^Is_Block=-_mongolian}', "");
Expect(1, 6143, '\P{Is_Block=-_mongolian}', "");
Expect(0, 6143, '\P{^Is_Block=-_mongolian}', "");
Error('\p{Is_Blk=:= -mongolian}');
Error('\P{Is_Blk=:= -mongolian}');
Expect(1, 6319, '\p{Is_Blk=mongolian}', "");
Expect(0, 6319, '\p{^Is_Blk=mongolian}', "");
Expect(0, 6319, '\P{Is_Blk=mongolian}', "");
Expect(1, 6319, '\P{^Is_Blk=mongolian}', "");
Expect(0, 6143, '\p{Is_Blk=mongolian}', "");
Expect(1, 6143, '\p{^Is_Blk=mongolian}', "");
Expect(1, 6143, '\P{Is_Blk=mongolian}', "");
Expect(0, 6143, '\P{^Is_Blk=mongolian}', "");
Expect(1, 6319, '\p{Is_Blk=  MONGOLIAN}', "");
Expect(0, 6319, '\p{^Is_Blk=  MONGOLIAN}', "");
Expect(0, 6319, '\P{Is_Blk=  MONGOLIAN}', "");
Expect(1, 6319, '\P{^Is_Blk=  MONGOLIAN}', "");
Expect(0, 6143, '\p{Is_Blk=  MONGOLIAN}', "");
Expect(1, 6143, '\p{^Is_Blk=  MONGOLIAN}', "");
Expect(1, 6143, '\P{Is_Blk=  MONGOLIAN}', "");
Expect(0, 6143, '\P{^Is_Blk=  MONGOLIAN}', "");
Error('\p{Block=/a/ Lao}');
Error('\P{Block=/a/ Lao}');
Expect(1, 3839, '\p{Block=lao}', "");
Expect(0, 3839, '\p{^Block=lao}', "");
Expect(0, 3839, '\P{Block=lao}', "");
Expect(1, 3839, '\P{^Block=lao}', "");
Expect(0, 3711, '\p{Block=lao}', "");
Expect(1, 3711, '\p{^Block=lao}', "");
Expect(1, 3711, '\P{Block=lao}', "");
Expect(0, 3711, '\P{^Block=lao}', "");
Expect(1, 3839, '\p{Block=  Lao}', "");
Expect(0, 3839, '\p{^Block=  Lao}', "");
Expect(0, 3839, '\P{Block=  Lao}', "");
Expect(1, 3839, '\P{^Block=  Lao}', "");
Expect(0, 3711, '\p{Block=  Lao}', "");
Expect(1, 3711, '\p{^Block=  Lao}', "");
Expect(1, 3711, '\P{Block=  Lao}', "");
Expect(0, 3711, '\P{^Block=  Lao}', "");
Error('\p{Blk=/a/  lao}');
Error('\P{Blk=/a/  lao}');
Expect(1, 3839, '\p{Blk:   lao}', "");
Expect(0, 3839, '\p{^Blk:   lao}', "");
Expect(0, 3839, '\P{Blk:   lao}', "");
Expect(1, 3839, '\P{^Blk:   lao}', "");
Expect(0, 3711, '\p{Blk:   lao}', "");
Expect(1, 3711, '\p{^Blk:   lao}', "");
Expect(1, 3711, '\P{Blk:   lao}', "");
Expect(0, 3711, '\P{^Blk:   lao}', "");
Expect(1, 3839, '\p{Blk=- LAO}', "");
Expect(0, 3839, '\p{^Blk=- LAO}', "");
Expect(0, 3839, '\P{Blk=- LAO}', "");
Expect(1, 3839, '\P{^Blk=- LAO}', "");
Expect(0, 3711, '\p{Blk=- LAO}', "");
Expect(1, 3711, '\p{^Blk=- LAO}', "");
Expect(1, 3711, '\P{Blk=- LAO}', "");
Expect(0, 3711, '\P{^Blk=- LAO}', "");
Error('\p{Is_Block=:= -lao}');
Error('\P{Is_Block=:= -lao}');
Expect(1, 3839, '\p{Is_Block=lao}', "");
Expect(0, 3839, '\p{^Is_Block=lao}', "");
Expect(0, 3839, '\P{Is_Block=lao}', "");
Expect(1, 3839, '\P{^Is_Block=lao}', "");
Expect(0, 3711, '\p{Is_Block=lao}', "");
Expect(1, 3711, '\p{^Is_Block=lao}', "");
Expect(1, 3711, '\P{Is_Block=lao}', "");
Expect(0, 3711, '\P{^Is_Block=lao}', "");
Expect(1, 3839, '\p{Is_Block=	 lao}', "");
Expect(0, 3839, '\p{^Is_Block=	 lao}', "");
Expect(0, 3839, '\P{Is_Block=	 lao}', "");
Expect(1, 3839, '\P{^Is_Block=	 lao}', "");
Expect(0, 3711, '\p{Is_Block=	 lao}', "");
Expect(1, 3711, '\p{^Is_Block=	 lao}', "");
Expect(1, 3711, '\P{Is_Block=	 lao}', "");
Expect(0, 3711, '\P{^Is_Block=	 lao}', "");
Error('\p{Is_Blk=/a/_Lao}');
Error('\P{Is_Blk=/a/_Lao}');
Expect(1, 3839, '\p{Is_Blk:	lao}', "");
Expect(0, 3839, '\p{^Is_Blk:	lao}', "");
Expect(0, 3839, '\P{Is_Blk:	lao}', "");
Expect(1, 3839, '\P{^Is_Blk:	lao}', "");
Expect(0, 3711, '\p{Is_Blk:	lao}', "");
Expect(1, 3711, '\p{^Is_Blk:	lao}', "");
Expect(1, 3711, '\P{Is_Blk:	lao}', "");
Expect(0, 3711, '\P{^Is_Blk:	lao}', "");
Expect(1, 3839, '\p{Is_Blk=-	Lao}', "");
Expect(0, 3839, '\p{^Is_Blk=-	Lao}', "");
Expect(0, 3839, '\P{Is_Blk=-	Lao}', "");
Expect(1, 3839, '\P{^Is_Blk=-	Lao}', "");
Expect(0, 3711, '\p{Is_Blk=-	Lao}', "");
Expect(1, 3711, '\p{^Is_Blk=-	Lao}', "");
Expect(1, 3711, '\P{Is_Blk=-	Lao}', "");
Expect(0, 3711, '\P{^Is_Blk=-	Lao}', "");
Error('\p{Block=/a/	_Hiragana}');
Error('\P{Block=/a/	_Hiragana}');
Expect(1, 12447, '\p{Block=hiragana}', "");
Expect(0, 12447, '\p{^Block=hiragana}', "");
Expect(0, 12447, '\P{Block=hiragana}', "");
Expect(1, 12447, '\P{^Block=hiragana}', "");
Expect(0, 12351, '\p{Block=hiragana}', "");
Expect(1, 12351, '\p{^Block=hiragana}', "");
Expect(1, 12351, '\P{Block=hiragana}', "");
Expect(0, 12351, '\P{^Block=hiragana}', "");
Expect(1, 12447, '\p{Block=_HIRAGANA}', "");
Expect(0, 12447, '\p{^Block=_HIRAGANA}', "");
Expect(0, 12447, '\P{Block=_HIRAGANA}', "");
Expect(1, 12447, '\P{^Block=_HIRAGANA}', "");
Expect(0, 12351, '\p{Block=_HIRAGANA}', "");
Expect(1, 12351, '\p{^Block=_HIRAGANA}', "");
Expect(1, 12351, '\P{Block=_HIRAGANA}', "");
Expect(0, 12351, '\P{^Block=_HIRAGANA}', "");
Error('\p{Blk=:=_	hiragana}');
Error('\P{Blk=:=_	hiragana}');
Expect(1, 12447, '\p{Blk: hiragana}', "");
Expect(0, 12447, '\p{^Blk: hiragana}', "");
Expect(0, 12447, '\P{Blk: hiragana}', "");
Expect(1, 12447, '\P{^Blk: hiragana}', "");
Expect(0, 12351, '\p{Blk: hiragana}', "");
Expect(1, 12351, '\p{^Blk: hiragana}', "");
Expect(1, 12351, '\P{Blk: hiragana}', "");
Expect(0, 12351, '\P{^Blk: hiragana}', "");
Expect(1, 12447, '\p{Blk=  Hiragana}', "");
Expect(0, 12447, '\p{^Blk=  Hiragana}', "");
Expect(0, 12447, '\P{Blk=  Hiragana}', "");
Expect(1, 12447, '\P{^Blk=  Hiragana}', "");
Expect(0, 12351, '\p{Blk=  Hiragana}', "");
Expect(1, 12351, '\p{^Blk=  Hiragana}', "");
Expect(1, 12351, '\P{Blk=  Hiragana}', "");
Expect(0, 12351, '\P{^Blk=  Hiragana}', "");
Error('\p{Is_Block=:= HIRAGANA}');
Error('\P{Is_Block=:= HIRAGANA}');
Expect(1, 12447, '\p{Is_Block: hiragana}', "");
Expect(0, 12447, '\p{^Is_Block: hiragana}', "");
Expect(0, 12447, '\P{Is_Block: hiragana}', "");
Expect(1, 12447, '\P{^Is_Block: hiragana}', "");
Expect(0, 12351, '\p{Is_Block: hiragana}', "");
Expect(1, 12351, '\p{^Is_Block: hiragana}', "");
Expect(1, 12351, '\P{Is_Block: hiragana}', "");
Expect(0, 12351, '\P{^Is_Block: hiragana}', "");
Expect(1, 12447, '\p{Is_Block=-_Hiragana}', "");
Expect(0, 12447, '\p{^Is_Block=-_Hiragana}', "");
Expect(0, 12447, '\P{Is_Block=-_Hiragana}', "");
Expect(1, 12447, '\P{^Is_Block=-_Hiragana}', "");
Expect(0, 12351, '\p{Is_Block=-_Hiragana}', "");
Expect(1, 12351, '\p{^Is_Block=-_Hiragana}', "");
Expect(1, 12351, '\P{Is_Block=-_Hiragana}', "");
Expect(0, 12351, '\P{^Is_Block=-_Hiragana}', "");
Error('\p{Is_Blk: -:=hiragana}');
Error('\P{Is_Blk: -:=hiragana}');
Expect(1, 12447, '\p{Is_Blk=hiragana}', "");
Expect(0, 12447, '\p{^Is_Blk=hiragana}', "");
Expect(0, 12447, '\P{Is_Blk=hiragana}', "");
Expect(1, 12447, '\P{^Is_Blk=hiragana}', "");
Expect(0, 12351, '\p{Is_Blk=hiragana}', "");
Expect(1, 12351, '\p{^Is_Blk=hiragana}', "");
Expect(1, 12351, '\P{Is_Blk=hiragana}', "");
Expect(0, 12351, '\P{^Is_Blk=hiragana}', "");
Expect(1, 12447, '\p{Is_Blk=		Hiragana}', "");
Expect(0, 12447, '\p{^Is_Blk=		Hiragana}', "");
Expect(0, 12447, '\P{Is_Blk=		Hiragana}', "");
Expect(1, 12447, '\P{^Is_Blk=		Hiragana}', "");
Expect(0, 12351, '\p{Is_Blk=		Hiragana}', "");
Expect(1, 12351, '\p{^Is_Blk=		Hiragana}', "");
Expect(1, 12351, '\P{Is_Blk=		Hiragana}', "");
Expect(0, 12351, '\P{^Is_Blk=		Hiragana}', "");
Error('\p{Block=-LEPCHA/a/}');
Error('\P{Block=-LEPCHA/a/}');
Expect(1, 7247, '\p{Block=lepcha}', "");
Expect(0, 7247, '\p{^Block=lepcha}', "");
Expect(0, 7247, '\P{Block=lepcha}', "");
Expect(1, 7247, '\P{^Block=lepcha}', "");
Expect(0, 7167, '\p{Block=lepcha}', "");
Expect(1, 7167, '\p{^Block=lepcha}', "");
Expect(1, 7167, '\P{Block=lepcha}', "");
Expect(0, 7167, '\P{^Block=lepcha}', "");
Expect(1, 7247, '\p{Block= _lepcha}', "");
Expect(0, 7247, '\p{^Block= _lepcha}', "");
Expect(0, 7247, '\P{Block= _lepcha}', "");
Expect(1, 7247, '\P{^Block= _lepcha}', "");
Expect(0, 7167, '\p{Block= _lepcha}', "");
Expect(1, 7167, '\p{^Block= _lepcha}', "");
Expect(1, 7167, '\P{Block= _lepcha}', "");
Expect(0, 7167, '\P{^Block= _lepcha}', "");
Error('\p{Blk=/a/_ lepcha}');
Error('\P{Blk=/a/_ lepcha}');
Expect(1, 7247, '\p{Blk=lepcha}', "");
Expect(0, 7247, '\p{^Blk=lepcha}', "");
Expect(0, 7247, '\P{Blk=lepcha}', "");
Expect(1, 7247, '\P{^Blk=lepcha}', "");
Expect(0, 7167, '\p{Blk=lepcha}', "");
Expect(1, 7167, '\p{^Blk=lepcha}', "");
Expect(1, 7167, '\P{Blk=lepcha}', "");
Expect(0, 7167, '\P{^Blk=lepcha}', "");
Expect(1, 7247, '\p{Blk=-Lepcha}', "");
Expect(0, 7247, '\p{^Blk=-Lepcha}', "");
Expect(0, 7247, '\P{Blk=-Lepcha}', "");
Expect(1, 7247, '\P{^Blk=-Lepcha}', "");
Expect(0, 7167, '\p{Blk=-Lepcha}', "");
Expect(1, 7167, '\p{^Blk=-Lepcha}', "");
Expect(1, 7167, '\P{Blk=-Lepcha}', "");
Expect(0, 7167, '\P{^Blk=-Lepcha}', "");
Error('\p{Is_Block= _Lepcha:=}');
Error('\P{Is_Block= _Lepcha:=}');
Expect(1, 7247, '\p{Is_Block=lepcha}', "");
Expect(0, 7247, '\p{^Is_Block=lepcha}', "");
Expect(0, 7247, '\P{Is_Block=lepcha}', "");
Expect(1, 7247, '\P{^Is_Block=lepcha}', "");
Expect(0, 7167, '\p{Is_Block=lepcha}', "");
Expect(1, 7167, '\p{^Is_Block=lepcha}', "");
Expect(1, 7167, '\P{Is_Block=lepcha}', "");
Expect(0, 7167, '\P{^Is_Block=lepcha}', "");
Expect(1, 7247, '\p{Is_Block=-_Lepcha}', "");
Expect(0, 7247, '\p{^Is_Block=-_Lepcha}', "");
Expect(0, 7247, '\P{Is_Block=-_Lepcha}', "");
Expect(1, 7247, '\P{^Is_Block=-_Lepcha}', "");
Expect(0, 7167, '\p{Is_Block=-_Lepcha}', "");
Expect(1, 7167, '\p{^Is_Block=-_Lepcha}', "");
Expect(1, 7167, '\P{Is_Block=-_Lepcha}', "");
Expect(0, 7167, '\P{^Is_Block=-_Lepcha}', "");
Error('\p{Is_Blk=-:=LEPCHA}');
Error('\P{Is_Blk=-:=LEPCHA}');
Expect(1, 7247, '\p{Is_Blk:lepcha}', "");
Expect(0, 7247, '\p{^Is_Blk:lepcha}', "");
Expect(0, 7247, '\P{Is_Blk:lepcha}', "");
Expect(1, 7247, '\P{^Is_Blk:lepcha}', "");
Expect(0, 7167, '\p{Is_Blk:lepcha}', "");
Expect(1, 7167, '\p{^Is_Blk:lepcha}', "");
Expect(1, 7167, '\P{Is_Blk:lepcha}', "");
Expect(0, 7167, '\P{^Is_Blk:lepcha}', "");
Expect(1, 7247, '\p{Is_Blk=-	lepcha}', "");
Expect(0, 7247, '\p{^Is_Blk=-	lepcha}', "");
Expect(0, 7247, '\P{Is_Blk=-	lepcha}', "");
Expect(1, 7247, '\P{^Is_Blk=-	lepcha}', "");
Expect(0, 7167, '\p{Is_Blk=-	lepcha}', "");
Expect(1, 7167, '\p{^Is_Blk=-	lepcha}', "");
Expect(1, 7167, '\P{Is_Blk=-	lepcha}', "");
Expect(0, 7167, '\P{^Is_Blk=-	lepcha}', "");
Error('\p{Block=_ Syloti-nagri/a/}');
Error('\P{Block=_ Syloti-nagri/a/}');
Expect(1, 43055, '\p{Block=sylotinagri}', "");
Expect(0, 43055, '\p{^Block=sylotinagri}', "");
Expect(0, 43055, '\P{Block=sylotinagri}', "");
Expect(1, 43055, '\P{^Block=sylotinagri}', "");
Expect(0, 43007, '\p{Block=sylotinagri}', "");
Expect(1, 43007, '\p{^Block=sylotinagri}', "");
Expect(1, 43007, '\P{Block=sylotinagri}', "");
Expect(0, 43007, '\P{^Block=sylotinagri}', "");
Expect(1, 43055, '\p{Block=  syloti NAGRI}', "");
Expect(0, 43055, '\p{^Block=  syloti NAGRI}', "");
Expect(0, 43055, '\P{Block=  syloti NAGRI}', "");
Expect(1, 43055, '\P{^Block=  syloti NAGRI}', "");
Expect(0, 43007, '\p{Block=  syloti NAGRI}', "");
Expect(1, 43007, '\p{^Block=  syloti NAGRI}', "");
Expect(1, 43007, '\P{Block=  syloti NAGRI}', "");
Expect(0, 43007, '\P{^Block=  syloti NAGRI}', "");
Error('\p{Blk=:= -Syloti_Nagri}');
Error('\P{Blk=:= -Syloti_Nagri}');
Expect(1, 43055, '\p{Blk=sylotinagri}', "");
Expect(0, 43055, '\p{^Blk=sylotinagri}', "");
Expect(0, 43055, '\P{Blk=sylotinagri}', "");
Expect(1, 43055, '\P{^Blk=sylotinagri}', "");
Expect(0, 43007, '\p{Blk=sylotinagri}', "");
Expect(1, 43007, '\p{^Blk=sylotinagri}', "");
Expect(1, 43007, '\P{Blk=sylotinagri}', "");
Expect(0, 43007, '\P{^Blk=sylotinagri}', "");
Expect(1, 43055, '\p{Blk= sylotiNagri}', "");
Expect(0, 43055, '\p{^Blk= sylotiNagri}', "");
Expect(0, 43055, '\P{Blk= sylotiNagri}', "");
Expect(1, 43055, '\P{^Blk= sylotiNagri}', "");
Expect(0, 43007, '\p{Blk= sylotiNagri}', "");
Expect(1, 43007, '\p{^Blk= sylotiNagri}', "");
Expect(1, 43007, '\P{Blk= sylotiNagri}', "");
Expect(0, 43007, '\P{^Blk= sylotiNagri}', "");
Error('\p{Is_Block= :=Syloti_Nagri}');
Error('\P{Is_Block= :=Syloti_Nagri}');
Expect(1, 43055, '\p{Is_Block:   sylotinagri}', "");
Expect(0, 43055, '\p{^Is_Block:   sylotinagri}', "");
Expect(0, 43055, '\P{Is_Block:   sylotinagri}', "");
Expect(1, 43055, '\P{^Is_Block:   sylotinagri}', "");
Expect(0, 43007, '\p{Is_Block:   sylotinagri}', "");
Expect(1, 43007, '\p{^Is_Block:   sylotinagri}', "");
Expect(1, 43007, '\P{Is_Block:   sylotinagri}', "");
Expect(0, 43007, '\P{^Is_Block:   sylotinagri}', "");
Expect(1, 43055, '\p{Is_Block=_ syloti_Nagri}', "");
Expect(0, 43055, '\p{^Is_Block=_ syloti_Nagri}', "");
Expect(0, 43055, '\P{Is_Block=_ syloti_Nagri}', "");
Expect(1, 43055, '\P{^Is_Block=_ syloti_Nagri}', "");
Expect(0, 43007, '\p{Is_Block=_ syloti_Nagri}', "");
Expect(1, 43007, '\p{^Is_Block=_ syloti_Nagri}', "");
Expect(1, 43007, '\P{Is_Block=_ syloti_Nagri}', "");
Expect(0, 43007, '\P{^Is_Block=_ syloti_Nagri}', "");
Error('\p{Is_Blk=	 SYLOTI Nagri/a/}');
Error('\P{Is_Blk=	 SYLOTI Nagri/a/}');
Expect(1, 43055, '\p{Is_Blk=sylotinagri}', "");
Expect(0, 43055, '\p{^Is_Blk=sylotinagri}', "");
Expect(0, 43055, '\P{Is_Blk=sylotinagri}', "");
Expect(1, 43055, '\P{^Is_Blk=sylotinagri}', "");
Expect(0, 43007, '\p{Is_Blk=sylotinagri}', "");
Expect(1, 43007, '\p{^Is_Blk=sylotinagri}', "");
Expect(1, 43007, '\P{Is_Blk=sylotinagri}', "");
Expect(0, 43007, '\P{^Is_Blk=sylotinagri}', "");
Expect(1, 43055, '\p{Is_Blk= -Sylotinagri}', "");
Expect(0, 43055, '\p{^Is_Blk= -Sylotinagri}', "");
Expect(0, 43055, '\P{Is_Blk= -Sylotinagri}', "");
Expect(1, 43055, '\P{^Is_Blk= -Sylotinagri}', "");
Expect(0, 43007, '\p{Is_Blk= -Sylotinagri}', "");
Expect(1, 43007, '\p{^Is_Blk= -Sylotinagri}', "");
Expect(1, 43007, '\P{Is_Blk= -Sylotinagri}', "");
Expect(0, 43007, '\P{^Is_Blk= -Sylotinagri}', "");
Error('\p{Block= COMBINING/a/DIACRITICAL	marks	FOR	symbols}');
Error('\P{Block= COMBINING/a/DIACRITICAL	marks	FOR	symbols}');
Expect(1, 8447, '\p{Block=combiningdiacriticalmarksforsymbols}', "");
Expect(0, 8447, '\p{^Block=combiningdiacriticalmarksforsymbols}', "");
Expect(0, 8447, '\P{Block=combiningdiacriticalmarksforsymbols}', "");
Expect(1, 8447, '\P{^Block=combiningdiacriticalmarksforsymbols}', "");
Expect(0, 8399, '\p{Block=combiningdiacriticalmarksforsymbols}', "");
Expect(1, 8399, '\p{^Block=combiningdiacriticalmarksforsymbols}', "");
Expect(1, 8399, '\P{Block=combiningdiacriticalmarksforsymbols}', "");
Expect(0, 8399, '\P{^Block=combiningdiacriticalmarksforsymbols}', "");
Expect(1, 8447, '\p{Block=		combining	DIACRITICAL Marks	For-SYMBOLS}', "");
Expect(0, 8447, '\p{^Block=		combining	DIACRITICAL Marks	For-SYMBOLS}', "");
Expect(0, 8447, '\P{Block=		combining	DIACRITICAL Marks	For-SYMBOLS}', "");
Expect(1, 8447, '\P{^Block=		combining	DIACRITICAL Marks	For-SYMBOLS}', "");
Expect(0, 8399, '\p{Block=		combining	DIACRITICAL Marks	For-SYMBOLS}', "");
Expect(1, 8399, '\p{^Block=		combining	DIACRITICAL Marks	For-SYMBOLS}', "");
Expect(1, 8399, '\P{Block=		combining	DIACRITICAL Marks	For-SYMBOLS}', "");
Expect(0, 8399, '\P{^Block=		combining	DIACRITICAL Marks	For-SYMBOLS}', "");
Error('\p{Blk=-:=combiningmarks For SYMBOLS}');
Error('\P{Blk=-:=combiningmarks For SYMBOLS}');
Expect(1, 8447, '\p{Blk=combiningmarksforsymbols}', "");
Expect(0, 8447, '\p{^Blk=combiningmarksforsymbols}', "");
Expect(0, 8447, '\P{Blk=combiningmarksforsymbols}', "");
Expect(1, 8447, '\P{^Blk=combiningmarksforsymbols}', "");
Expect(0, 8399, '\p{Blk=combiningmarksforsymbols}', "");
Expect(1, 8399, '\p{^Blk=combiningmarksforsymbols}', "");
Expect(1, 8399, '\P{Blk=combiningmarksforsymbols}', "");
Expect(0, 8399, '\P{^Blk=combiningmarksforsymbols}', "");
Expect(1, 8447, '\p{Blk= 	Combining marks for_Symbols}', "");
Expect(0, 8447, '\p{^Blk= 	Combining marks for_Symbols}', "");
Expect(0, 8447, '\P{Blk= 	Combining marks for_Symbols}', "");
Expect(1, 8447, '\P{^Blk= 	Combining marks for_Symbols}', "");
Expect(0, 8399, '\p{Blk= 	Combining marks for_Symbols}', "");
Expect(1, 8399, '\p{^Blk= 	Combining marks for_Symbols}', "");
Expect(1, 8399, '\P{Blk= 	Combining marks for_Symbols}', "");
Expect(0, 8399, '\P{^Blk= 	Combining marks for_Symbols}', "");
Error('\p{Is_Block= :=combining_Diacritical marks For_symbols}');
Error('\P{Is_Block= :=combining_Diacritical marks For_symbols}');
Expect(1, 8447, '\p{Is_Block=combiningdiacriticalmarksforsymbols}', "");
Expect(0, 8447, '\p{^Is_Block=combiningdiacriticalmarksforsymbols}', "");
Expect(0, 8447, '\P{Is_Block=combiningdiacriticalmarksforsymbols}', "");
Expect(1, 8447, '\P{^Is_Block=combiningdiacriticalmarksforsymbols}', "");
Expect(0, 8399, '\p{Is_Block=combiningdiacriticalmarksforsymbols}', "");
Expect(1, 8399, '\p{^Is_Block=combiningdiacriticalmarksforsymbols}', "");
Expect(1, 8399, '\P{Is_Block=combiningdiacriticalmarksforsymbols}', "");
Expect(0, 8399, '\P{^Is_Block=combiningdiacriticalmarksforsymbols}', "");
Expect(1, 8447, '\p{Is_Block=Combiningdiacritical_Marks-For-symbols}', "");
Expect(0, 8447, '\p{^Is_Block=Combiningdiacritical_Marks-For-symbols}', "");
Expect(0, 8447, '\P{Is_Block=Combiningdiacritical_Marks-For-symbols}', "");
Expect(1, 8447, '\P{^Is_Block=Combiningdiacritical_Marks-For-symbols}', "");
Expect(0, 8399, '\p{Is_Block=Combiningdiacritical_Marks-For-symbols}', "");
Expect(1, 8399, '\p{^Is_Block=Combiningdiacritical_Marks-For-symbols}', "");
Expect(1, 8399, '\P{Is_Block=Combiningdiacritical_Marks-For-symbols}', "");
Expect(0, 8399, '\P{^Is_Block=Combiningdiacritical_Marks-For-symbols}', "");
Error('\p{Is_Blk=_/a/Combining	Marks-For	Symbols}');
Error('\P{Is_Blk=_/a/Combining	Marks-For	Symbols}');
Expect(1, 8447, '\p{Is_Blk=combiningmarksforsymbols}', "");
Expect(0, 8447, '\p{^Is_Blk=combiningmarksforsymbols}', "");
Expect(0, 8447, '\P{Is_Blk=combiningmarksforsymbols}', "");
Expect(1, 8447, '\P{^Is_Blk=combiningmarksforsymbols}', "");
Expect(0, 8399, '\p{Is_Blk=combiningmarksforsymbols}', "");
Expect(1, 8399, '\p{^Is_Blk=combiningmarksforsymbols}', "");
Expect(1, 8399, '\P{Is_Blk=combiningmarksforsymbols}', "");
Expect(0, 8399, '\P{^Is_Blk=combiningmarksforsymbols}', "");
Expect(1, 8447, '\p{Is_Blk=_COMBINING Marks_FOR	symbols}', "");
Expect(0, 8447, '\p{^Is_Blk=_COMBINING Marks_FOR	symbols}', "");
Expect(0, 8447, '\P{Is_Blk=_COMBINING Marks_FOR	symbols}', "");
Expect(1, 8447, '\P{^Is_Blk=_COMBINING Marks_FOR	symbols}', "");
Expect(0, 8399, '\p{Is_Blk=_COMBINING Marks_FOR	symbols}', "");
Expect(1, 8399, '\p{^Is_Blk=_COMBINING Marks_FOR	symbols}', "");
Expect(1, 8399, '\P{Is_Blk=_COMBINING Marks_FOR	symbols}', "");
Expect(0, 8399, '\P{^Is_Blk=_COMBINING Marks_FOR	symbols}', "");
Error('\p{Block=	:=BasicLATIN}');
Error('\P{Block=	:=BasicLATIN}');
Expect(1, 127, '\p{Block=basiclatin}', "");
Expect(0, 127, '\p{^Block=basiclatin}', "");
Expect(0, 127, '\P{Block=basiclatin}', "");
Expect(1, 127, '\P{^Block=basiclatin}', "");
Expect(0, 128, '\p{Block=basiclatin}', "");
Expect(1, 128, '\p{^Block=basiclatin}', "");
Expect(1, 128, '\P{Block=basiclatin}', "");
Expect(0, 128, '\P{^Block=basiclatin}', "");
Expect(1, 127, '\p{Block=__basic	Latin}', "");
Expect(0, 127, '\p{^Block=__basic	Latin}', "");
Expect(0, 127, '\P{Block=__basic	Latin}', "");
Expect(1, 127, '\P{^Block=__basic	Latin}', "");
Expect(0, 128, '\p{Block=__basic	Latin}', "");
Expect(1, 128, '\p{^Block=__basic	Latin}', "");
Expect(1, 128, '\P{Block=__basic	Latin}', "");
Expect(0, 128, '\P{^Block=__basic	Latin}', "");
Error('\p{Blk=	ASCII/a/}');
Error('\P{Blk=	ASCII/a/}');
Expect(1, 127, '\p{Blk=ascii}', "");
Expect(0, 127, '\p{^Blk=ascii}', "");
Expect(0, 127, '\P{Blk=ascii}', "");
Expect(1, 127, '\P{^Blk=ascii}', "");
Expect(0, 128, '\p{Blk=ascii}', "");
Expect(1, 128, '\p{^Blk=ascii}', "");
Expect(1, 128, '\P{Blk=ascii}', "");
Expect(0, 128, '\P{^Blk=ascii}', "");
Expect(1, 127, '\p{Blk= ASCII}', "");
Expect(0, 127, '\p{^Blk= ASCII}', "");
Expect(0, 127, '\P{Blk= ASCII}', "");
Expect(1, 127, '\P{^Blk= ASCII}', "");
Expect(0, 128, '\p{Blk= ASCII}', "");
Expect(1, 128, '\p{^Blk= ASCII}', "");
Expect(1, 128, '\P{Blk= ASCII}', "");
Expect(0, 128, '\P{^Blk= ASCII}', "");
Error('\p{Is_Block=- Basic	Latin/a/}');
Error('\P{Is_Block=- Basic	Latin/a/}');
Expect(1, 127, '\p{Is_Block=basiclatin}', "");
Expect(0, 127, '\p{^Is_Block=basiclatin}', "");
Expect(0, 127, '\P{Is_Block=basiclatin}', "");
Expect(1, 127, '\P{^Is_Block=basiclatin}', "");
Expect(0, 128, '\p{Is_Block=basiclatin}', "");
Expect(1, 128, '\p{^Is_Block=basiclatin}', "");
Expect(1, 128, '\P{Is_Block=basiclatin}', "");
Expect(0, 128, '\P{^Is_Block=basiclatin}', "");
Expect(1, 127, '\p{Is_Block=	-BASICLATIN}', "");
Expect(0, 127, '\p{^Is_Block=	-BASICLATIN}', "");
Expect(0, 127, '\P{Is_Block=	-BASICLATIN}', "");
Expect(1, 127, '\P{^Is_Block=	-BASICLATIN}', "");
Expect(0, 128, '\p{Is_Block=	-BASICLATIN}', "");
Expect(1, 128, '\p{^Is_Block=	-BASICLATIN}', "");
Expect(1, 128, '\P{Is_Block=	-BASICLATIN}', "");
Expect(0, 128, '\P{^Is_Block=	-BASICLATIN}', "");
Error('\p{Is_Blk=/a/	 ascii}');
Error('\P{Is_Blk=/a/	 ascii}');
Expect(1, 127, '\p{Is_Blk:   ascii}', "");
Expect(0, 127, '\p{^Is_Blk:   ascii}', "");
Expect(0, 127, '\P{Is_Blk:   ascii}', "");
Expect(1, 127, '\P{^Is_Blk:   ascii}', "");
Expect(0, 128, '\p{Is_Blk:   ascii}', "");
Expect(1, 128, '\p{^Is_Blk:   ascii}', "");
Expect(1, 128, '\P{Is_Blk:   ascii}', "");
Expect(0, 128, '\P{^Is_Blk:   ascii}', "");
Expect(1, 127, '\p{Is_Blk=-	ASCII}', "");
Expect(0, 127, '\p{^Is_Blk=-	ASCII}', "");
Expect(0, 127, '\P{Is_Blk=-	ASCII}', "");
Expect(1, 127, '\P{^Is_Blk=-	ASCII}', "");
Expect(0, 128, '\p{Is_Blk=-	ASCII}', "");
Expect(1, 128, '\p{^Is_Blk=-	ASCII}', "");
Expect(1, 128, '\P{Is_Blk=-	ASCII}', "");
Expect(0, 128, '\P{^Is_Blk=-	ASCII}', "");
Error('\p{Block=	/a/Limbu}');
Error('\P{Block=	/a/Limbu}');
Expect(1, 6479, '\p{Block: limbu}', "");
Expect(0, 6479, '\p{^Block: limbu}', "");
Expect(0, 6479, '\P{Block: limbu}', "");
Expect(1, 6479, '\P{^Block: limbu}', "");
Expect(0, 6399, '\p{Block: limbu}', "");
Expect(1, 6399, '\p{^Block: limbu}', "");
Expect(1, 6399, '\P{Block: limbu}', "");
Expect(0, 6399, '\P{^Block: limbu}', "");
Expect(1, 6479, '\p{Block=		Limbu}', "");
Expect(0, 6479, '\p{^Block=		Limbu}', "");
Expect(0, 6479, '\P{Block=		Limbu}', "");
Expect(1, 6479, '\P{^Block=		Limbu}', "");
Expect(0, 6399, '\p{Block=		Limbu}', "");
Expect(1, 6399, '\p{^Block=		Limbu}', "");
Expect(1, 6399, '\P{Block=		Limbu}', "");
Expect(0, 6399, '\P{^Block=		Limbu}', "");
Error('\p{Blk=:=Limbu}');
Error('\P{Blk=:=Limbu}');
Expect(1, 6479, '\p{Blk:	limbu}', "");
Expect(0, 6479, '\p{^Blk:	limbu}', "");
Expect(0, 6479, '\P{Blk:	limbu}', "");
Expect(1, 6479, '\P{^Blk:	limbu}', "");
Expect(0, 6399, '\p{Blk:	limbu}', "");
Expect(1, 6399, '\p{^Blk:	limbu}', "");
Expect(1, 6399, '\P{Blk:	limbu}', "");
Expect(0, 6399, '\P{^Blk:	limbu}', "");
Expect(1, 6479, '\p{Blk=- Limbu}', "");
Expect(0, 6479, '\p{^Blk=- Limbu}', "");
Expect(0, 6479, '\P{Blk=- Limbu}', "");
Expect(1, 6479, '\P{^Blk=- Limbu}', "");
Expect(0, 6399, '\p{Blk=- Limbu}', "");
Expect(1, 6399, '\p{^Blk=- Limbu}', "");
Expect(1, 6399, '\P{Blk=- Limbu}', "");
Expect(0, 6399, '\P{^Blk=- Limbu}', "");
Error('\p{Is_Block:    	LIMBU:=}');
Error('\P{Is_Block:    	LIMBU:=}');
Expect(1, 6479, '\p{Is_Block=limbu}', "");
Expect(0, 6479, '\p{^Is_Block=limbu}', "");
Expect(0, 6479, '\P{Is_Block=limbu}', "");
Expect(1, 6479, '\P{^Is_Block=limbu}', "");
Expect(0, 6399, '\p{Is_Block=limbu}', "");
Expect(1, 6399, '\p{^Is_Block=limbu}', "");
Expect(1, 6399, '\P{Is_Block=limbu}', "");
Expect(0, 6399, '\P{^Is_Block=limbu}', "");
Expect(1, 6479, '\p{Is_Block=	LIMBU}', "");
Expect(0, 6479, '\p{^Is_Block=	LIMBU}', "");
Expect(0, 6479, '\P{Is_Block=	LIMBU}', "");
Expect(1, 6479, '\P{^Is_Block=	LIMBU}', "");
Expect(0, 6399, '\p{Is_Block=	LIMBU}', "");
Expect(1, 6399, '\p{^Is_Block=	LIMBU}', "");
Expect(1, 6399, '\P{Is_Block=	LIMBU}', "");
Expect(0, 6399, '\P{^Is_Block=	LIMBU}', "");
Error('\p{Is_Blk= -Limbu:=}');
Error('\P{Is_Blk= -Limbu:=}');
Expect(1, 6479, '\p{Is_Blk:	limbu}', "");
Expect(0, 6479, '\p{^Is_Blk:	limbu}', "");
Expect(0, 6479, '\P{Is_Blk:	limbu}', "");
Expect(1, 6479, '\P{^Is_Blk:	limbu}', "");
Expect(0, 6399, '\p{Is_Blk:	limbu}', "");
Expect(1, 6399, '\p{^Is_Blk:	limbu}', "");
Expect(1, 6399, '\P{Is_Blk:	limbu}', "");
Expect(0, 6399, '\P{^Is_Blk:	limbu}', "");
Expect(1, 6479, '\p{Is_Blk=_-limbu}', "");
Expect(0, 6479, '\p{^Is_Blk=_-limbu}', "");
Expect(0, 6479, '\P{Is_Blk=_-limbu}', "");
Expect(1, 6479, '\P{^Is_Blk=_-limbu}', "");
Expect(0, 6399, '\p{Is_Blk=_-limbu}', "");
Expect(1, 6399, '\p{^Is_Blk=_-limbu}', "");
Expect(1, 6399, '\P{Is_Blk=_-limbu}', "");
Expect(0, 6399, '\P{^Is_Blk=_-limbu}', "");
Error('\p{Block=:=_-CURRENCY_symbols}');
Error('\P{Block=:=_-CURRENCY_symbols}');
Expect(1, 8399, '\p{Block=currencysymbols}', "");
Expect(0, 8399, '\p{^Block=currencysymbols}', "");
Expect(0, 8399, '\P{Block=currencysymbols}', "");
Expect(1, 8399, '\P{^Block=currencysymbols}', "");
Expect(0, 8351, '\p{Block=currencysymbols}', "");
Expect(1, 8351, '\p{^Block=currencysymbols}', "");
Expect(1, 8351, '\P{Block=currencysymbols}', "");
Expect(0, 8351, '\P{^Block=currencysymbols}', "");
Expect(1, 8399, '\p{Block=--currency	Symbols}', "");
Expect(0, 8399, '\p{^Block=--currency	Symbols}', "");
Expect(0, 8399, '\P{Block=--currency	Symbols}', "");
Expect(1, 8399, '\P{^Block=--currency	Symbols}', "");
Expect(0, 8351, '\p{Block=--currency	Symbols}', "");
Expect(1, 8351, '\p{^Block=--currency	Symbols}', "");
Expect(1, 8351, '\P{Block=--currency	Symbols}', "");
Expect(0, 8351, '\P{^Block=--currency	Symbols}', "");
Error('\p{Blk=/a/Currency Symbols}');
Error('\P{Blk=/a/Currency Symbols}');
Expect(1, 8399, '\p{Blk=currencysymbols}', "");
Expect(0, 8399, '\p{^Blk=currencysymbols}', "");
Expect(0, 8399, '\P{Blk=currencysymbols}', "");
Expect(1, 8399, '\P{^Blk=currencysymbols}', "");
Expect(0, 8351, '\p{Blk=currencysymbols}', "");
Expect(1, 8351, '\p{^Blk=currencysymbols}', "");
Expect(1, 8351, '\P{Blk=currencysymbols}', "");
Expect(0, 8351, '\P{^Blk=currencysymbols}', "");
Expect(1, 8399, '\p{Blk=-CURRENCY	symbols}', "");
Expect(0, 8399, '\p{^Blk=-CURRENCY	symbols}', "");
Expect(0, 8399, '\P{Blk=-CURRENCY	symbols}', "");
Expect(1, 8399, '\P{^Blk=-CURRENCY	symbols}', "");
Expect(0, 8351, '\p{Blk=-CURRENCY	symbols}', "");
Expect(1, 8351, '\p{^Blk=-CURRENCY	symbols}', "");
Expect(1, 8351, '\P{Blk=-CURRENCY	symbols}', "");
Expect(0, 8351, '\P{^Blk=-CURRENCY	symbols}', "");
Error('\p{Is_Block=_ Currency	Symbols:=}');
Error('\P{Is_Block=_ Currency	Symbols:=}');
Expect(1, 8399, '\p{Is_Block=currencysymbols}', "");
Expect(0, 8399, '\p{^Is_Block=currencysymbols}', "");
Expect(0, 8399, '\P{Is_Block=currencysymbols}', "");
Expect(1, 8399, '\P{^Is_Block=currencysymbols}', "");
Expect(0, 8351, '\p{Is_Block=currencysymbols}', "");
Expect(1, 8351, '\p{^Is_Block=currencysymbols}', "");
Expect(1, 8351, '\P{Is_Block=currencysymbols}', "");
Expect(0, 8351, '\P{^Is_Block=currencysymbols}', "");
Expect(1, 8399, '\p{Is_Block=CURRENCY Symbols}', "");
Expect(0, 8399, '\p{^Is_Block=CURRENCY Symbols}', "");
Expect(0, 8399, '\P{Is_Block=CURRENCY Symbols}', "");
Expect(1, 8399, '\P{^Is_Block=CURRENCY Symbols}', "");
Expect(0, 8351, '\p{Is_Block=CURRENCY Symbols}', "");
Expect(1, 8351, '\p{^Is_Block=CURRENCY Symbols}', "");
Expect(1, 8351, '\P{Is_Block=CURRENCY Symbols}', "");
Expect(0, 8351, '\P{^Is_Block=CURRENCY Symbols}', "");
Error('\p{Is_Blk=:=_currency_Symbols}');
Error('\P{Is_Blk=:=_currency_Symbols}');
Expect(1, 8399, '\p{Is_Blk=currencysymbols}', "");
Expect(0, 8399, '\p{^Is_Blk=currencysymbols}', "");
Expect(0, 8399, '\P{Is_Blk=currencysymbols}', "");
Expect(1, 8399, '\P{^Is_Blk=currencysymbols}', "");
Expect(0, 8351, '\p{Is_Blk=currencysymbols}', "");
Expect(1, 8351, '\p{^Is_Blk=currencysymbols}', "");
Expect(1, 8351, '\P{Is_Blk=currencysymbols}', "");
Expect(0, 8351, '\P{^Is_Blk=currencysymbols}', "");
Expect(1, 8399, '\p{Is_Blk=-CURRENCY Symbols}', "");
Expect(0, 8399, '\p{^Is_Blk=-CURRENCY Symbols}', "");
Expect(0, 8399, '\P{Is_Blk=-CURRENCY Symbols}', "");
Expect(1, 8399, '\P{^Is_Blk=-CURRENCY Symbols}', "");
Expect(0, 8351, '\p{Is_Blk=-CURRENCY Symbols}', "");
Expect(1, 8351, '\p{^Is_Blk=-CURRENCY Symbols}', "");
Expect(1, 8351, '\P{Is_Blk=-CURRENCY Symbols}', "");
Expect(0, 8351, '\P{^Is_Blk=-CURRENCY Symbols}', "");
Error('\p{Block:   :=-_Spacing	modifierLetters}');
Error('\P{Block:   :=-_Spacing	modifierLetters}');
Expect(1, 767, '\p{Block:   spacingmodifierletters}', "");
Expect(0, 767, '\p{^Block:   spacingmodifierletters}', "");
Expect(0, 767, '\P{Block:   spacingmodifierletters}', "");
Expect(1, 767, '\P{^Block:   spacingmodifierletters}', "");
Expect(0, 687, '\p{Block:   spacingmodifierletters}', "");
Expect(1, 687, '\p{^Block:   spacingmodifierletters}', "");
Expect(1, 687, '\P{Block:   spacingmodifierletters}', "");
Expect(0, 687, '\P{^Block:   spacingmodifierletters}', "");
Expect(1, 767, '\p{Block=	_Spacing Modifier_Letters}', "");
Expect(0, 767, '\p{^Block=	_Spacing Modifier_Letters}', "");
Expect(0, 767, '\P{Block=	_Spacing Modifier_Letters}', "");
Expect(1, 767, '\P{^Block=	_Spacing Modifier_Letters}', "");
Expect(0, 687, '\p{Block=	_Spacing Modifier_Letters}', "");
Expect(1, 687, '\p{^Block=	_Spacing Modifier_Letters}', "");
Expect(1, 687, '\P{Block=	_Spacing Modifier_Letters}', "");
Expect(0, 687, '\P{^Block=	_Spacing Modifier_Letters}', "");
Error('\p{Blk=	Spacing-Modifier/a/Letters}');
Error('\P{Blk=	Spacing-Modifier/a/Letters}');
Expect(1, 767, '\p{Blk=spacingmodifierletters}', "");
Expect(0, 767, '\p{^Blk=spacingmodifierletters}', "");
Expect(0, 767, '\P{Blk=spacingmodifierletters}', "");
Expect(1, 767, '\P{^Blk=spacingmodifierletters}', "");
Expect(0, 687, '\p{Blk=spacingmodifierletters}', "");
Expect(1, 687, '\p{^Blk=spacingmodifierletters}', "");
Expect(1, 687, '\P{Blk=spacingmodifierletters}', "");
Expect(0, 687, '\P{^Blk=spacingmodifierletters}', "");
Expect(1, 767, '\p{Blk=	-SpacingMODIFIER-letters}', "");
Expect(0, 767, '\p{^Blk=	-SpacingMODIFIER-letters}', "");
Expect(0, 767, '\P{Blk=	-SpacingMODIFIER-letters}', "");
Expect(1, 767, '\P{^Blk=	-SpacingMODIFIER-letters}', "");
Expect(0, 687, '\p{Blk=	-SpacingMODIFIER-letters}', "");
Expect(1, 687, '\p{^Blk=	-SpacingMODIFIER-letters}', "");
Expect(1, 687, '\P{Blk=	-SpacingMODIFIER-letters}', "");
Expect(0, 687, '\P{^Blk=	-SpacingMODIFIER-letters}', "");
Error('\p{Is_Block=:=_ Spacing-Modifier	LETTERS}');
Error('\P{Is_Block=:=_ Spacing-Modifier	LETTERS}');
Expect(1, 767, '\p{Is_Block=spacingmodifierletters}', "");
Expect(0, 767, '\p{^Is_Block=spacingmodifierletters}', "");
Expect(0, 767, '\P{Is_Block=spacingmodifierletters}', "");
Expect(1, 767, '\P{^Is_Block=spacingmodifierletters}', "");
Expect(0, 687, '\p{Is_Block=spacingmodifierletters}', "");
Expect(1, 687, '\p{^Is_Block=spacingmodifierletters}', "");
Expect(1, 687, '\P{Is_Block=spacingmodifierletters}', "");
Expect(0, 687, '\P{^Is_Block=spacingmodifierletters}', "");
Expect(1, 767, '\p{Is_Block=-	SPACING_MODIFIER	Letters}', "");
Expect(0, 767, '\p{^Is_Block=-	SPACING_MODIFIER	Letters}', "");
Expect(0, 767, '\P{Is_Block=-	SPACING_MODIFIER	Letters}', "");
Expect(1, 767, '\P{^Is_Block=-	SPACING_MODIFIER	Letters}', "");
Expect(0, 687, '\p{Is_Block=-	SPACING_MODIFIER	Letters}', "");
Expect(1, 687, '\p{^Is_Block=-	SPACING_MODIFIER	Letters}', "");
Expect(1, 687, '\P{Is_Block=-	SPACING_MODIFIER	Letters}', "");
Expect(0, 687, '\P{^Is_Block=-	SPACING_MODIFIER	Letters}', "");
Error('\p{Is_Blk=		SPACING-Modifier	Letters:=}');
Error('\P{Is_Blk=		SPACING-Modifier	Letters:=}');
Expect(1, 767, '\p{Is_Blk=spacingmodifierletters}', "");
Expect(0, 767, '\p{^Is_Blk=spacingmodifierletters}', "");
Expect(0, 767, '\P{Is_Blk=spacingmodifierletters}', "");
Expect(1, 767, '\P{^Is_Blk=spacingmodifierletters}', "");
Expect(0, 687, '\p{Is_Blk=spacingmodifierletters}', "");
Expect(1, 687, '\p{^Is_Blk=spacingmodifierletters}', "");
Expect(1, 687, '\P{Is_Blk=spacingmodifierletters}', "");
Expect(0, 687, '\P{^Is_Blk=spacingmodifierletters}', "");
Expect(1, 767, '\p{Is_Blk= -SPACING Modifier LETTERS}', "");
Expect(0, 767, '\p{^Is_Blk= -SPACING Modifier LETTERS}', "");
Expect(0, 767, '\P{Is_Blk= -SPACING Modifier LETTERS}', "");
Expect(1, 767, '\P{^Is_Blk= -SPACING Modifier LETTERS}', "");
Expect(0, 687, '\p{Is_Blk= -SPACING Modifier LETTERS}', "");
Expect(1, 687, '\p{^Is_Blk= -SPACING Modifier LETTERS}', "");
Expect(1, 687, '\P{Is_Blk= -SPACING Modifier LETTERS}', "");
Expect(0, 687, '\P{^Is_Blk= -SPACING Modifier LETTERS}', "");
Error('\p{Block= :=BOX DRAWING}');
Error('\P{Block= :=BOX DRAWING}');
Expect(1, 9599, '\p{Block=boxdrawing}', "");
Expect(0, 9599, '\p{^Block=boxdrawing}', "");
Expect(0, 9599, '\P{Block=boxdrawing}', "");
Expect(1, 9599, '\P{^Block=boxdrawing}', "");
Expect(0, 9471, '\p{Block=boxdrawing}', "");
Expect(1, 9471, '\p{^Block=boxdrawing}', "");
Expect(1, 9471, '\P{Block=boxdrawing}', "");
Expect(0, 9471, '\P{^Block=boxdrawing}', "");
Expect(1, 9599, '\p{Block=		Box DRAWING}', "");
Expect(0, 9599, '\p{^Block=		Box DRAWING}', "");
Expect(0, 9599, '\P{Block=		Box DRAWING}', "");
Expect(1, 9599, '\P{^Block=		Box DRAWING}', "");
Expect(0, 9471, '\p{Block=		Box DRAWING}', "");
Expect(1, 9471, '\p{^Block=		Box DRAWING}', "");
Expect(1, 9471, '\P{Block=		Box DRAWING}', "");
Expect(0, 9471, '\P{^Block=		Box DRAWING}', "");
Error('\p{Blk=- box_drawing/a/}');
Error('\P{Blk=- box_drawing/a/}');
Expect(1, 9599, '\p{Blk=boxdrawing}', "");
Expect(0, 9599, '\p{^Blk=boxdrawing}', "");
Expect(0, 9599, '\P{Blk=boxdrawing}', "");
Expect(1, 9599, '\P{^Blk=boxdrawing}', "");
Expect(0, 9471, '\p{Blk=boxdrawing}', "");
Expect(1, 9471, '\p{^Blk=boxdrawing}', "");
Expect(1, 9471, '\P{Blk=boxdrawing}', "");
Expect(0, 9471, '\P{^Blk=boxdrawing}', "");
Expect(1, 9599, '\p{Blk=	 box_Drawing}', "");
Expect(0, 9599, '\p{^Blk=	 box_Drawing}', "");
Expect(0, 9599, '\P{Blk=	 box_Drawing}', "");
Expect(1, 9599, '\P{^Blk=	 box_Drawing}', "");
Expect(0, 9471, '\p{Blk=	 box_Drawing}', "");
Expect(1, 9471, '\p{^Blk=	 box_Drawing}', "");
Expect(1, 9471, '\P{Blk=	 box_Drawing}', "");
Expect(0, 9471, '\P{^Blk=	 box_Drawing}', "");
Error('\p{Is_Block=:=	-Box_Drawing}');
Error('\P{Is_Block=:=	-Box_Drawing}');
Expect(1, 9599, '\p{Is_Block=boxdrawing}', "");
Expect(0, 9599, '\p{^Is_Block=boxdrawing}', "");
Expect(0, 9599, '\P{Is_Block=boxdrawing}', "");
Expect(1, 9599, '\P{^Is_Block=boxdrawing}', "");
Expect(0, 9471, '\p{Is_Block=boxdrawing}', "");
Expect(1, 9471, '\p{^Is_Block=boxdrawing}', "");
Expect(1, 9471, '\P{Is_Block=boxdrawing}', "");
Expect(0, 9471, '\P{^Is_Block=boxdrawing}', "");
Expect(1, 9599, '\p{Is_Block=-Box_drawing}', "");
Expect(0, 9599, '\p{^Is_Block=-Box_drawing}', "");
Expect(0, 9599, '\P{Is_Block=-Box_drawing}', "");
Expect(1, 9599, '\P{^Is_Block=-Box_drawing}', "");
Expect(0, 9471, '\p{Is_Block=-Box_drawing}', "");
Expect(1, 9471, '\p{^Is_Block=-Box_drawing}', "");
Expect(1, 9471, '\P{Is_Block=-Box_drawing}', "");
Expect(0, 9471, '\P{^Is_Block=-Box_drawing}', "");
Error('\p{Is_Blk=	/a/BoxDrawing}');
Error('\P{Is_Blk=	/a/BoxDrawing}');
Expect(1, 9599, '\p{Is_Blk=boxdrawing}', "");
Expect(0, 9599, '\p{^Is_Blk=boxdrawing}', "");
Expect(0, 9599, '\P{Is_Blk=boxdrawing}', "");
Expect(1, 9599, '\P{^Is_Blk=boxdrawing}', "");
Expect(0, 9471, '\p{Is_Blk=boxdrawing}', "");
Expect(1, 9471, '\p{^Is_Blk=boxdrawing}', "");
Expect(1, 9471, '\P{Is_Blk=boxdrawing}', "");
Expect(0, 9471, '\P{^Is_Blk=boxdrawing}', "");
Expect(1, 9599, '\p{Is_Blk= Box	Drawing}', "");
Expect(0, 9599, '\p{^Is_Blk= Box	Drawing}', "");
Expect(0, 9599, '\P{Is_Blk= Box	Drawing}', "");
Expect(1, 9599, '\P{^Is_Blk= Box	Drawing}', "");
Expect(0, 9471, '\p{Is_Blk= Box	Drawing}', "");
Expect(1, 9471, '\p{^Is_Blk= Box	Drawing}', "");
Expect(1, 9471, '\P{Is_Blk= Box	Drawing}', "");
Expect(0, 9471, '\P{^Is_Blk= Box	Drawing}', "");
Error('\p{Block= /a/SUPERSCRIPTS	AndSubscripts}');
Error('\P{Block= /a/SUPERSCRIPTS	AndSubscripts}');
Expect(1, 8351, '\p{Block=superscriptsandsubscripts}', "");
Expect(0, 8351, '\p{^Block=superscriptsandsubscripts}', "");
Expect(0, 8351, '\P{Block=superscriptsandsubscripts}', "");
Expect(1, 8351, '\P{^Block=superscriptsandsubscripts}', "");
Expect(0, 8303, '\p{Block=superscriptsandsubscripts}', "");
Expect(1, 8303, '\p{^Block=superscriptsandsubscripts}', "");
Expect(1, 8303, '\P{Block=superscriptsandsubscripts}', "");
Expect(0, 8303, '\P{^Block=superscriptsandsubscripts}', "");
Expect(1, 8351, '\p{Block=_-superscripts	AND-Subscripts}', "");
Expect(0, 8351, '\p{^Block=_-superscripts	AND-Subscripts}', "");
Expect(0, 8351, '\P{Block=_-superscripts	AND-Subscripts}', "");
Expect(1, 8351, '\P{^Block=_-superscripts	AND-Subscripts}', "");
Expect(0, 8303, '\p{Block=_-superscripts	AND-Subscripts}', "");
Expect(1, 8303, '\p{^Block=_-superscripts	AND-Subscripts}', "");
Expect(1, 8303, '\P{Block=_-superscripts	AND-Subscripts}', "");
Expect(0, 8303, '\P{^Block=_-superscripts	AND-Subscripts}', "");
Error('\p{Blk= 	Superscripts_and-Subscripts/a/}');
Error('\P{Blk= 	Superscripts_and-Subscripts/a/}');
Expect(1, 8351, '\p{Blk=superscriptsandsubscripts}', "");
Expect(0, 8351, '\p{^Blk=superscriptsandsubscripts}', "");
Expect(0, 8351, '\P{Blk=superscriptsandsubscripts}', "");
Expect(1, 8351, '\P{^Blk=superscriptsandsubscripts}', "");
Expect(0, 8303, '\p{Blk=superscriptsandsubscripts}', "");
Expect(1, 8303, '\p{^Blk=superscriptsandsubscripts}', "");
Expect(1, 8303, '\P{Blk=superscriptsandsubscripts}', "");
Expect(0, 8303, '\P{^Blk=superscriptsandsubscripts}', "");
Expect(1, 8351, '\p{Blk=_ Superscripts	And Subscripts}', "");
Expect(0, 8351, '\p{^Blk=_ Superscripts	And Subscripts}', "");
Expect(0, 8351, '\P{Blk=_ Superscripts	And Subscripts}', "");
Expect(1, 8351, '\P{^Blk=_ Superscripts	And Subscripts}', "");
Expect(0, 8303, '\p{Blk=_ Superscripts	And Subscripts}', "");
Expect(1, 8303, '\p{^Blk=_ Superscripts	And Subscripts}', "");
Expect(1, 8303, '\P{Blk=_ Superscripts	And Subscripts}', "");
Expect(0, 8303, '\P{^Blk=_ Superscripts	And Subscripts}', "");
Error('\p{Is_Block=/a/ _superscripts_AND_subscripts}');
Error('\P{Is_Block=/a/ _superscripts_AND_subscripts}');
Expect(1, 8351, '\p{Is_Block=superscriptsandsubscripts}', "");
Expect(0, 8351, '\p{^Is_Block=superscriptsandsubscripts}', "");
Expect(0, 8351, '\P{Is_Block=superscriptsandsubscripts}', "");
Expect(1, 8351, '\P{^Is_Block=superscriptsandsubscripts}', "");
Expect(0, 8303, '\p{Is_Block=superscriptsandsubscripts}', "");
Expect(1, 8303, '\p{^Is_Block=superscriptsandsubscripts}', "");
Expect(1, 8303, '\P{Is_Block=superscriptsandsubscripts}', "");
Expect(0, 8303, '\P{^Is_Block=superscriptsandsubscripts}', "");
Expect(1, 8351, '\p{Is_Block:   _-Superscripts	and	subscripts}', "");
Expect(0, 8351, '\p{^Is_Block:   _-Superscripts	and	subscripts}', "");
Expect(0, 8351, '\P{Is_Block:   _-Superscripts	and	subscripts}', "");
Expect(1, 8351, '\P{^Is_Block:   _-Superscripts	and	subscripts}', "");
Expect(0, 8303, '\p{Is_Block:   _-Superscripts	and	subscripts}', "");
Expect(1, 8303, '\p{^Is_Block:   _-Superscripts	and	subscripts}', "");
Expect(1, 8303, '\P{Is_Block:   _-Superscripts	and	subscripts}', "");
Expect(0, 8303, '\P{^Is_Block:   _-Superscripts	and	subscripts}', "");
Error('\p{Is_Blk=/a/- SUPERSCRIPTS_ANDSubscripts}');
Error('\P{Is_Blk=/a/- SUPERSCRIPTS_ANDSubscripts}');
Expect(1, 8351, '\p{Is_Blk=superscriptsandsubscripts}', "");
Expect(0, 8351, '\p{^Is_Blk=superscriptsandsubscripts}', "");
Expect(0, 8351, '\P{Is_Blk=superscriptsandsubscripts}', "");
Expect(1, 8351, '\P{^Is_Blk=superscriptsandsubscripts}', "");
Expect(0, 8303, '\p{Is_Blk=superscriptsandsubscripts}', "");
Expect(1, 8303, '\p{^Is_Blk=superscriptsandsubscripts}', "");
Expect(1, 8303, '\P{Is_Blk=superscriptsandsubscripts}', "");
Expect(0, 8303, '\P{^Is_Blk=superscriptsandsubscripts}', "");
Expect(1, 8351, '\p{Is_Blk=	_SUPERSCRIPTS and subscripts}', "");
Expect(0, 8351, '\p{^Is_Blk=	_SUPERSCRIPTS and subscripts}', "");
Expect(0, 8351, '\P{Is_Blk=	_SUPERSCRIPTS and subscripts}', "");
Expect(1, 8351, '\P{^Is_Blk=	_SUPERSCRIPTS and subscripts}', "");
Expect(0, 8303, '\p{Is_Blk=	_SUPERSCRIPTS and subscripts}', "");
Expect(1, 8303, '\p{^Is_Blk=	_SUPERSCRIPTS and subscripts}', "");
Expect(1, 8303, '\P{Is_Blk=	_SUPERSCRIPTS and subscripts}', "");
Expect(0, 8303, '\P{^Is_Blk=	_SUPERSCRIPTS and subscripts}', "");
Error('\p{Block=_Ancient-Greek-numbers/a/}');
Error('\P{Block=_Ancient-Greek-numbers/a/}');
Expect(1, 65935, '\p{Block=ancientgreeknumbers}', "");
Expect(0, 65935, '\p{^Block=ancientgreeknumbers}', "");
Expect(0, 65935, '\P{Block=ancientgreeknumbers}', "");
Expect(1, 65935, '\P{^Block=ancientgreeknumbers}', "");
Expect(0, 65855, '\p{Block=ancientgreeknumbers}', "");
Expect(1, 65855, '\p{^Block=ancientgreeknumbers}', "");
Expect(1, 65855, '\P{Block=ancientgreeknumbers}', "");
Expect(0, 65855, '\P{^Block=ancientgreeknumbers}', "");
Expect(1, 65935, '\p{Block=_-ANCIENT	Greek NUMBERS}', "");
Expect(0, 65935, '\p{^Block=_-ANCIENT	Greek NUMBERS}', "");
Expect(0, 65935, '\P{Block=_-ANCIENT	Greek NUMBERS}', "");
Expect(1, 65935, '\P{^Block=_-ANCIENT	Greek NUMBERS}', "");
Expect(0, 65855, '\p{Block=_-ANCIENT	Greek NUMBERS}', "");
Expect(1, 65855, '\p{^Block=_-ANCIENT	Greek NUMBERS}', "");
Expect(1, 65855, '\P{Block=_-ANCIENT	Greek NUMBERS}', "");
Expect(0, 65855, '\P{^Block=_-ANCIENT	Greek NUMBERS}', "");
Error('\p{Blk=/a/	ANCIENT_Greek	NUMBERS}');
Error('\P{Blk=/a/	ANCIENT_Greek	NUMBERS}');
Expect(1, 65935, '\p{Blk=ancientgreeknumbers}', "");
Expect(0, 65935, '\p{^Blk=ancientgreeknumbers}', "");
Expect(0, 65935, '\P{Blk=ancientgreeknumbers}', "");
Expect(1, 65935, '\P{^Blk=ancientgreeknumbers}', "");
Expect(0, 65855, '\p{Blk=ancientgreeknumbers}', "");
Expect(1, 65855, '\p{^Blk=ancientgreeknumbers}', "");
Expect(1, 65855, '\P{Blk=ancientgreeknumbers}', "");
Expect(0, 65855, '\P{^Blk=ancientgreeknumbers}', "");
Expect(1, 65935, '\p{Blk=_ Ancient-GREEK	numbers}', "");
Expect(0, 65935, '\p{^Blk=_ Ancient-GREEK	numbers}', "");
Expect(0, 65935, '\P{Blk=_ Ancient-GREEK	numbers}', "");
Expect(1, 65935, '\P{^Blk=_ Ancient-GREEK	numbers}', "");
Expect(0, 65855, '\p{Blk=_ Ancient-GREEK	numbers}', "");
Expect(1, 65855, '\p{^Blk=_ Ancient-GREEK	numbers}', "");
Expect(1, 65855, '\P{Blk=_ Ancient-GREEK	numbers}', "");
Expect(0, 65855, '\P{^Blk=_ Ancient-GREEK	numbers}', "");
Error('\p{Is_Block=/a/_ancient GREEK numbers}');
Error('\P{Is_Block=/a/_ancient GREEK numbers}');
Expect(1, 65935, '\p{Is_Block=ancientgreeknumbers}', "");
Expect(0, 65935, '\p{^Is_Block=ancientgreeknumbers}', "");
Expect(0, 65935, '\P{Is_Block=ancientgreeknumbers}', "");
Expect(1, 65935, '\P{^Is_Block=ancientgreeknumbers}', "");
Expect(0, 65855, '\p{Is_Block=ancientgreeknumbers}', "");
Expect(1, 65855, '\p{^Is_Block=ancientgreeknumbers}', "");
Expect(1, 65855, '\P{Is_Block=ancientgreeknumbers}', "");
Expect(0, 65855, '\P{^Is_Block=ancientgreeknumbers}', "");
Expect(1, 65935, '\p{Is_Block=  Ancient-greek Numbers}', "");
Expect(0, 65935, '\p{^Is_Block=  Ancient-greek Numbers}', "");
Expect(0, 65935, '\P{Is_Block=  Ancient-greek Numbers}', "");
Expect(1, 65935, '\P{^Is_Block=  Ancient-greek Numbers}', "");
Expect(0, 65855, '\p{Is_Block=  Ancient-greek Numbers}', "");
Expect(1, 65855, '\p{^Is_Block=  Ancient-greek Numbers}', "");
Expect(1, 65855, '\P{Is_Block=  Ancient-greek Numbers}', "");
Expect(0, 65855, '\P{^Is_Block=  Ancient-greek Numbers}', "");
Error('\p{Is_Blk=	-Ancient greek_Numbers:=}');
Error('\P{Is_Blk=	-Ancient greek_Numbers:=}');
Expect(1, 65935, '\p{Is_Blk=ancientgreeknumbers}', "");
Expect(0, 65935, '\p{^Is_Blk=ancientgreeknumbers}', "");
Expect(0, 65935, '\P{Is_Blk=ancientgreeknumbers}', "");
Expect(1, 65935, '\P{^Is_Blk=ancientgreeknumbers}', "");
Expect(0, 65855, '\p{Is_Blk=ancientgreeknumbers}', "");
Expect(1, 65855, '\p{^Is_Blk=ancientgreeknumbers}', "");
Expect(1, 65855, '\P{Is_Blk=ancientgreeknumbers}', "");
Expect(0, 65855, '\P{^Is_Blk=ancientgreeknumbers}', "");
Expect(1, 65935, '\p{Is_Blk= ANCIENT_GREEK	numbers}', "");
Expect(0, 65935, '\p{^Is_Blk= ANCIENT_GREEK	numbers}', "");
Expect(0, 65935, '\P{Is_Blk= ANCIENT_GREEK	numbers}', "");
Expect(1, 65935, '\P{^Is_Blk= ANCIENT_GREEK	numbers}', "");
Expect(0, 65855, '\p{Is_Blk= ANCIENT_GREEK	numbers}', "");
Expect(1, 65855, '\p{^Is_Blk= ANCIENT_GREEK	numbers}', "");
Expect(1, 65855, '\P{Is_Blk= ANCIENT_GREEK	numbers}', "");
Expect(0, 65855, '\P{^Is_Blk= ANCIENT_GREEK	numbers}', "");
Error('\p{Block=-NKo/a/}');
Error('\P{Block=-NKo/a/}');
Expect(1, 2047, '\p{Block=nko}', "");
Expect(0, 2047, '\p{^Block=nko}', "");
Expect(0, 2047, '\P{Block=nko}', "");
Expect(1, 2047, '\P{^Block=nko}', "");
Expect(0, 1983, '\p{Block=nko}', "");
Expect(1, 1983, '\p{^Block=nko}', "");
Expect(1, 1983, '\P{Block=nko}', "");
Expect(0, 1983, '\P{^Block=nko}', "");
Expect(1, 2047, '\p{Block=	NKo}', "");
Expect(0, 2047, '\p{^Block=	NKo}', "");
Expect(0, 2047, '\P{Block=	NKo}', "");
Expect(1, 2047, '\P{^Block=	NKo}', "");
Expect(0, 1983, '\p{Block=	NKo}', "");
Expect(1, 1983, '\p{^Block=	NKo}', "");
Expect(1, 1983, '\P{Block=	NKo}', "");
Expect(0, 1983, '\P{^Block=	NKo}', "");
Error('\p{Blk:/a/--NKo}');
Error('\P{Blk:/a/--NKo}');
Expect(1, 2047, '\p{Blk=nko}', "");
Expect(0, 2047, '\p{^Blk=nko}', "");
Expect(0, 2047, '\P{Blk=nko}', "");
Expect(1, 2047, '\P{^Blk=nko}', "");
Expect(0, 1983, '\p{Blk=nko}', "");
Expect(1, 1983, '\p{^Blk=nko}', "");
Expect(1, 1983, '\P{Blk=nko}', "");
Expect(0, 1983, '\P{^Blk=nko}', "");
Expect(1, 2047, '\p{Blk:	- NKO}', "");
Expect(0, 2047, '\p{^Blk:	- NKO}', "");
Expect(0, 2047, '\P{Blk:	- NKO}', "");
Expect(1, 2047, '\P{^Blk:	- NKO}', "");
Expect(0, 1983, '\p{Blk:	- NKO}', "");
Expect(1, 1983, '\p{^Blk:	- NKO}', "");
Expect(1, 1983, '\P{Blk:	- NKO}', "");
Expect(0, 1983, '\P{^Blk:	- NKO}', "");
Error('\p{Is_Block=-/a/NKO}');
Error('\P{Is_Block=-/a/NKO}');
Expect(1, 2047, '\p{Is_Block=nko}', "");
Expect(0, 2047, '\p{^Is_Block=nko}', "");
Expect(0, 2047, '\P{Is_Block=nko}', "");
Expect(1, 2047, '\P{^Is_Block=nko}', "");
Expect(0, 1983, '\p{Is_Block=nko}', "");
Expect(1, 1983, '\p{^Is_Block=nko}', "");
Expect(1, 1983, '\P{Is_Block=nko}', "");
Expect(0, 1983, '\P{^Is_Block=nko}', "");
Expect(1, 2047, '\p{Is_Block= NKo}', "");
Expect(0, 2047, '\p{^Is_Block= NKo}', "");
Expect(0, 2047, '\P{Is_Block= NKo}', "");
Expect(1, 2047, '\P{^Is_Block= NKo}', "");
Expect(0, 1983, '\p{Is_Block= NKo}', "");
Expect(1, 1983, '\p{^Is_Block= NKo}', "");
Expect(1, 1983, '\P{Is_Block= NKo}', "");
Expect(0, 1983, '\P{^Is_Block= NKo}', "");
Error('\p{Is_Blk=-/a/NKo}');
Error('\P{Is_Blk=-/a/NKo}');
Expect(1, 2047, '\p{Is_Blk=nko}', "");
Expect(0, 2047, '\p{^Is_Blk=nko}', "");
Expect(0, 2047, '\P{Is_Blk=nko}', "");
Expect(1, 2047, '\P{^Is_Blk=nko}', "");
Expect(0, 1983, '\p{Is_Blk=nko}', "");
Expect(1, 1983, '\p{^Is_Blk=nko}', "");
Expect(1, 1983, '\P{Is_Blk=nko}', "");
Expect(0, 1983, '\P{^Is_Blk=nko}', "");
Expect(1, 2047, '\p{Is_Blk=__NKo}', "");
Expect(0, 2047, '\p{^Is_Blk=__NKo}', "");
Expect(0, 2047, '\P{Is_Blk=__NKo}', "");
Expect(1, 2047, '\P{^Is_Blk=__NKo}', "");
Expect(0, 1983, '\p{Is_Blk=__NKo}', "");
Expect(1, 1983, '\p{^Is_Blk=__NKo}', "");
Expect(1, 1983, '\P{Is_Blk=__NKo}', "");
Expect(0, 1983, '\P{^Is_Blk=__NKo}', "");
Error('\p{Block= 	MUSICAL:=Symbols}');
Error('\P{Block= 	MUSICAL:=Symbols}');
Expect(1, 119295, '\p{Block=musicalsymbols}', "");
Expect(0, 119295, '\p{^Block=musicalsymbols}', "");
Expect(0, 119295, '\P{Block=musicalsymbols}', "");
Expect(1, 119295, '\P{^Block=musicalsymbols}', "");
Expect(0, 119039, '\p{Block=musicalsymbols}', "");
Expect(1, 119039, '\p{^Block=musicalsymbols}', "");
Expect(1, 119039, '\P{Block=musicalsymbols}', "");
Expect(0, 119039, '\P{^Block=musicalsymbols}', "");
Expect(1, 119295, '\p{Block= _Musical-Symbols}', "");
Expect(0, 119295, '\p{^Block= _Musical-Symbols}', "");
Expect(0, 119295, '\P{Block= _Musical-Symbols}', "");
Expect(1, 119295, '\P{^Block= _Musical-Symbols}', "");
Expect(0, 119039, '\p{Block= _Musical-Symbols}', "");
Expect(1, 119039, '\p{^Block= _Musical-Symbols}', "");
Expect(1, 119039, '\P{Block= _Musical-Symbols}', "");
Expect(0, 119039, '\P{^Block= _Musical-Symbols}', "");
Error('\p{Blk=:=_MUSICAL_symbols}');
Error('\P{Blk=:=_MUSICAL_symbols}');
Expect(1, 119295, '\p{Blk=musicalsymbols}', "");
Expect(0, 119295, '\p{^Blk=musicalsymbols}', "");
Expect(0, 119295, '\P{Blk=musicalsymbols}', "");
Expect(1, 119295, '\P{^Blk=musicalsymbols}', "");
Expect(0, 119039, '\p{Blk=musicalsymbols}', "");
Expect(1, 119039, '\p{^Blk=musicalsymbols}', "");
Expect(1, 119039, '\P{Blk=musicalsymbols}', "");
Expect(0, 119039, '\P{^Blk=musicalsymbols}', "");
Expect(1, 119295, '\p{Blk=	-musical-Symbols}', "");
Expect(0, 119295, '\p{^Blk=	-musical-Symbols}', "");
Expect(0, 119295, '\P{Blk=	-musical-Symbols}', "");
Expect(1, 119295, '\P{^Blk=	-musical-Symbols}', "");
Expect(0, 119039, '\p{Blk=	-musical-Symbols}', "");
Expect(1, 119039, '\p{^Blk=	-musical-Symbols}', "");
Expect(1, 119039, '\P{Blk=	-musical-Symbols}', "");
Expect(0, 119039, '\P{^Blk=	-musical-Symbols}', "");
Error('\p{Is_Block=/a/ 	musical	symbols}');
Error('\P{Is_Block=/a/ 	musical	symbols}');
Expect(1, 119295, '\p{Is_Block=musicalsymbols}', "");
Expect(0, 119295, '\p{^Is_Block=musicalsymbols}', "");
Expect(0, 119295, '\P{Is_Block=musicalsymbols}', "");
Expect(1, 119295, '\P{^Is_Block=musicalsymbols}', "");
Expect(0, 119039, '\p{Is_Block=musicalsymbols}', "");
Expect(1, 119039, '\p{^Is_Block=musicalsymbols}', "");
Expect(1, 119039, '\P{Is_Block=musicalsymbols}', "");
Expect(0, 119039, '\P{^Is_Block=musicalsymbols}', "");
Expect(1, 119295, '\p{Is_Block=__Musicalsymbols}', "");
Expect(0, 119295, '\p{^Is_Block=__Musicalsymbols}', "");
Expect(0, 119295, '\P{Is_Block=__Musicalsymbols}', "");
Expect(1, 119295, '\P{^Is_Block=__Musicalsymbols}', "");
Expect(0, 119039, '\p{Is_Block=__Musicalsymbols}', "");
Expect(1, 119039, '\p{^Is_Block=__Musicalsymbols}', "");
Expect(1, 119039, '\P{Is_Block=__Musicalsymbols}', "");
Expect(0, 119039, '\P{^Is_Block=__Musicalsymbols}', "");
Error('\p{Is_Blk=Musical/a/Symbols}');
Error('\P{Is_Blk=Musical/a/Symbols}');
Expect(1, 119295, '\p{Is_Blk=musicalsymbols}', "");
Expect(0, 119295, '\p{^Is_Blk=musicalsymbols}', "");
Expect(0, 119295, '\P{Is_Blk=musicalsymbols}', "");
Expect(1, 119295, '\P{^Is_Blk=musicalsymbols}', "");
Expect(0, 119039, '\p{Is_Blk=musicalsymbols}', "");
Expect(1, 119039, '\p{^Is_Blk=musicalsymbols}', "");
Expect(1, 119039, '\P{Is_Blk=musicalsymbols}', "");
Expect(0, 119039, '\P{^Is_Blk=musicalsymbols}', "");
Expect(1, 119295, '\p{Is_Blk=-_Musical Symbols}', "");
Expect(0, 119295, '\p{^Is_Blk=-_Musical Symbols}', "");
Expect(0, 119295, '\P{Is_Blk=-_Musical Symbols}', "");
Expect(1, 119295, '\P{^Is_Blk=-_Musical Symbols}', "");
Expect(0, 119039, '\p{Is_Blk=-_Musical Symbols}', "");
Expect(1, 119039, '\p{^Is_Blk=-_Musical Symbols}', "");
Expect(1, 119039, '\P{Is_Blk=-_Musical Symbols}', "");
Expect(0, 119039, '\P{^Is_Blk=-_Musical Symbols}', "");
Error('\p{Block=/a/Miscellaneous	Symbols}');
Error('\P{Block=/a/Miscellaneous	Symbols}');
Expect(1, 9983, '\p{Block:	miscellaneoussymbols}', "");
Expect(0, 9983, '\p{^Block:	miscellaneoussymbols}', "");
Expect(0, 9983, '\P{Block:	miscellaneoussymbols}', "");
Expect(1, 9983, '\P{^Block:	miscellaneoussymbols}', "");
Expect(0, 9727, '\p{Block:	miscellaneoussymbols}', "");
Expect(1, 9727, '\p{^Block:	miscellaneoussymbols}', "");
Expect(1, 9727, '\P{Block:	miscellaneoussymbols}', "");
Expect(0, 9727, '\P{^Block:	miscellaneoussymbols}', "");
Expect(1, 9983, '\p{Block:		Miscellaneoussymbols}', "");
Expect(0, 9983, '\p{^Block:		Miscellaneoussymbols}', "");
Expect(0, 9983, '\P{Block:		Miscellaneoussymbols}', "");
Expect(1, 9983, '\P{^Block:		Miscellaneoussymbols}', "");
Expect(0, 9727, '\p{Block:		Miscellaneoussymbols}', "");
Expect(1, 9727, '\p{^Block:		Miscellaneoussymbols}', "");
Expect(1, 9727, '\P{Block:		Miscellaneoussymbols}', "");
Expect(0, 9727, '\P{^Block:		Miscellaneoussymbols}', "");
Error('\p{Blk:   	-MiscellaneousSymbols:=}');
Error('\P{Blk:   	-MiscellaneousSymbols:=}');
Expect(1, 9983, '\p{Blk=miscellaneoussymbols}', "");
Expect(0, 9983, '\p{^Blk=miscellaneoussymbols}', "");
Expect(0, 9983, '\P{Blk=miscellaneoussymbols}', "");
Expect(1, 9983, '\P{^Blk=miscellaneoussymbols}', "");
Expect(0, 9727, '\p{Blk=miscellaneoussymbols}', "");
Expect(1, 9727, '\p{^Blk=miscellaneoussymbols}', "");
Expect(1, 9727, '\P{Blk=miscellaneoussymbols}', "");
Expect(0, 9727, '\P{^Blk=miscellaneoussymbols}', "");
Expect(1, 9983, '\p{Blk=_-MISCELLANEOUS Symbols}', "");
Expect(0, 9983, '\p{^Blk=_-MISCELLANEOUS Symbols}', "");
Expect(0, 9983, '\P{Blk=_-MISCELLANEOUS Symbols}', "");
Expect(1, 9983, '\P{^Blk=_-MISCELLANEOUS Symbols}', "");
Expect(0, 9727, '\p{Blk=_-MISCELLANEOUS Symbols}', "");
Expect(1, 9727, '\p{^Blk=_-MISCELLANEOUS Symbols}', "");
Expect(1, 9727, '\P{Blk=_-MISCELLANEOUS Symbols}', "");
Expect(0, 9727, '\P{^Blk=_-MISCELLANEOUS Symbols}', "");
Error('\p{Is_Block=-/a/miscellaneous	Symbols}');
Error('\P{Is_Block=-/a/miscellaneous	Symbols}');
Expect(1, 9983, '\p{Is_Block=miscellaneoussymbols}', "");
Expect(0, 9983, '\p{^Is_Block=miscellaneoussymbols}', "");
Expect(0, 9983, '\P{Is_Block=miscellaneoussymbols}', "");
Expect(1, 9983, '\P{^Is_Block=miscellaneoussymbols}', "");
Expect(0, 9727, '\p{Is_Block=miscellaneoussymbols}', "");
Expect(1, 9727, '\p{^Is_Block=miscellaneoussymbols}', "");
Expect(1, 9727, '\P{Is_Block=miscellaneoussymbols}', "");
Expect(0, 9727, '\P{^Is_Block=miscellaneoussymbols}', "");
Expect(1, 9983, '\p{Is_Block=	MISCELLANEOUS-Symbols}', "");
Expect(0, 9983, '\p{^Is_Block=	MISCELLANEOUS-Symbols}', "");
Expect(0, 9983, '\P{Is_Block=	MISCELLANEOUS-Symbols}', "");
Expect(1, 9983, '\P{^Is_Block=	MISCELLANEOUS-Symbols}', "");
Expect(0, 9727, '\p{Is_Block=	MISCELLANEOUS-Symbols}', "");
Expect(1, 9727, '\p{^Is_Block=	MISCELLANEOUS-Symbols}', "");
Expect(1, 9727, '\P{Is_Block=	MISCELLANEOUS-Symbols}', "");
Expect(0, 9727, '\P{^Is_Block=	MISCELLANEOUS-Symbols}', "");
Error('\p{Is_Blk:	MISCELLANEOUS:=Symbols}');
Error('\P{Is_Blk:	MISCELLANEOUS:=Symbols}');
Expect(1, 9983, '\p{Is_Blk=miscellaneoussymbols}', "");
Expect(0, 9983, '\p{^Is_Blk=miscellaneoussymbols}', "");
Expect(0, 9983, '\P{Is_Blk=miscellaneoussymbols}', "");
Expect(1, 9983, '\P{^Is_Blk=miscellaneoussymbols}', "");
Expect(0, 9727, '\p{Is_Blk=miscellaneoussymbols}', "");
Expect(1, 9727, '\p{^Is_Blk=miscellaneoussymbols}', "");
Expect(1, 9727, '\P{Is_Blk=miscellaneoussymbols}', "");
Expect(0, 9727, '\P{^Is_Blk=miscellaneoussymbols}', "");
Expect(1, 9983, '\p{Is_Blk:    -MISCELLANEOUS	SYMBOLS}', "");
Expect(0, 9983, '\p{^Is_Blk:    -MISCELLANEOUS	SYMBOLS}', "");
Expect(0, 9983, '\P{Is_Blk:    -MISCELLANEOUS	SYMBOLS}', "");
Expect(1, 9983, '\P{^Is_Blk:    -MISCELLANEOUS	SYMBOLS}', "");
Expect(0, 9727, '\p{Is_Blk:    -MISCELLANEOUS	SYMBOLS}', "");
Expect(1, 9727, '\p{^Is_Blk:    -MISCELLANEOUS	SYMBOLS}', "");
Expect(1, 9727, '\P{Is_Blk:    -MISCELLANEOUS	SYMBOLS}', "");
Expect(0, 9727, '\P{^Is_Blk:    -MISCELLANEOUS	SYMBOLS}', "");
Error('\p{Block:   :=  RUNIC}');
Error('\P{Block:   :=  RUNIC}');
Expect(1, 5887, '\p{Block=runic}', "");
Expect(0, 5887, '\p{^Block=runic}', "");
Expect(0, 5887, '\P{Block=runic}', "");
Expect(1, 5887, '\P{^Block=runic}', "");
Expect(0, 5791, '\p{Block=runic}', "");
Expect(1, 5791, '\p{^Block=runic}', "");
Expect(1, 5791, '\P{Block=runic}', "");
Expect(0, 5791, '\P{^Block=runic}', "");
Expect(1, 5887, '\p{Block=	-Runic}', "");
Expect(0, 5887, '\p{^Block=	-Runic}', "");
Expect(0, 5887, '\P{Block=	-Runic}', "");
Expect(1, 5887, '\P{^Block=	-Runic}', "");
Expect(0, 5791, '\p{Block=	-Runic}', "");
Expect(1, 5791, '\p{^Block=	-Runic}', "");
Expect(1, 5791, '\P{Block=	-Runic}', "");
Expect(0, 5791, '\P{^Block=	-Runic}', "");
Error('\p{Blk= 	Runic/a/}');
Error('\P{Blk= 	Runic/a/}');
Expect(1, 5887, '\p{Blk=runic}', "");
Expect(0, 5887, '\p{^Blk=runic}', "");
Expect(0, 5887, '\P{Blk=runic}', "");
Expect(1, 5887, '\P{^Blk=runic}', "");
Expect(0, 5791, '\p{Blk=runic}', "");
Expect(1, 5791, '\p{^Blk=runic}', "");
Expect(1, 5791, '\P{Blk=runic}', "");
Expect(0, 5791, '\P{^Blk=runic}', "");
Expect(1, 5887, '\p{Blk=--RUNIC}', "");
Expect(0, 5887, '\p{^Blk=--RUNIC}', "");
Expect(0, 5887, '\P{Blk=--RUNIC}', "");
Expect(1, 5887, '\P{^Blk=--RUNIC}', "");
Expect(0, 5791, '\p{Blk=--RUNIC}', "");
Expect(1, 5791, '\p{^Blk=--RUNIC}', "");
Expect(1, 5791, '\P{Blk=--RUNIC}', "");
Expect(0, 5791, '\P{^Blk=--RUNIC}', "");
Error('\p{Is_Block=:=		Runic}');
Error('\P{Is_Block=:=		Runic}');
Expect(1, 5887, '\p{Is_Block=runic}', "");
Expect(0, 5887, '\p{^Is_Block=runic}', "");
Expect(0, 5887, '\P{Is_Block=runic}', "");
Expect(1, 5887, '\P{^Is_Block=runic}', "");
Expect(0, 5791, '\p{Is_Block=runic}', "");
Expect(1, 5791, '\p{^Is_Block=runic}', "");
Expect(1, 5791, '\P{Is_Block=runic}', "");
Expect(0, 5791, '\P{^Is_Block=runic}', "");
Expect(1, 5887, '\p{Is_Block=_ Runic}', "");
Expect(0, 5887, '\p{^Is_Block=_ Runic}', "");
Expect(0, 5887, '\P{Is_Block=_ Runic}', "");
Expect(1, 5887, '\P{^Is_Block=_ Runic}', "");
Expect(0, 5791, '\p{Is_Block=_ Runic}', "");
Expect(1, 5791, '\p{^Is_Block=_ Runic}', "");
Expect(1, 5791, '\P{Is_Block=_ Runic}', "");
Expect(0, 5791, '\P{^Is_Block=_ Runic}', "");
Error('\p{Is_Blk=-/a/runic}');
Error('\P{Is_Blk=-/a/runic}');
Expect(1, 5887, '\p{Is_Blk=runic}', "");
Expect(0, 5887, '\p{^Is_Blk=runic}', "");
Expect(0, 5887, '\P{Is_Blk=runic}', "");
Expect(1, 5887, '\P{^Is_Blk=runic}', "");
Expect(0, 5791, '\p{Is_Blk=runic}', "");
Expect(1, 5791, '\p{^Is_Blk=runic}', "");
Expect(1, 5791, '\P{Is_Blk=runic}', "");
Expect(0, 5791, '\P{^Is_Blk=runic}', "");
Expect(1, 5887, '\p{Is_Blk=	 Runic}', "");
Expect(0, 5887, '\p{^Is_Blk=	 Runic}', "");
Expect(0, 5887, '\P{Is_Blk=	 Runic}', "");
Expect(1, 5887, '\P{^Is_Blk=	 Runic}', "");
Expect(0, 5791, '\p{Is_Blk=	 Runic}', "");
Expect(1, 5791, '\p{^Is_Blk=	 Runic}', "");
Expect(1, 5791, '\P{Is_Blk=	 Runic}', "");
Expect(0, 5791, '\P{^Is_Blk=	 Runic}', "");
Error('\p{Block=:=	_lycian}');
Error('\P{Block=:=	_lycian}');
Expect(1, 66207, '\p{Block=lycian}', "");
Expect(0, 66207, '\p{^Block=lycian}', "");
Expect(0, 66207, '\P{Block=lycian}', "");
Expect(1, 66207, '\P{^Block=lycian}', "");
Expect(0, 66175, '\p{Block=lycian}', "");
Expect(1, 66175, '\p{^Block=lycian}', "");
Expect(1, 66175, '\P{Block=lycian}', "");
Expect(0, 66175, '\P{^Block=lycian}', "");
Expect(1, 66207, '\p{Block= _lycian}', "");
Expect(0, 66207, '\p{^Block= _lycian}', "");
Expect(0, 66207, '\P{Block= _lycian}', "");
Expect(1, 66207, '\P{^Block= _lycian}', "");
Expect(0, 66175, '\p{Block= _lycian}', "");
Expect(1, 66175, '\p{^Block= _lycian}', "");
Expect(1, 66175, '\P{Block= _lycian}', "");
Expect(0, 66175, '\P{^Block= _lycian}', "");
Error('\p{Blk:	_	lycian:=}');
Error('\P{Blk:	_	lycian:=}');
Expect(1, 66207, '\p{Blk=lycian}', "");
Expect(0, 66207, '\p{^Blk=lycian}', "");
Expect(0, 66207, '\P{Blk=lycian}', "");
Expect(1, 66207, '\P{^Blk=lycian}', "");
Expect(0, 66175, '\p{Blk=lycian}', "");
Expect(1, 66175, '\p{^Blk=lycian}', "");
Expect(1, 66175, '\P{Blk=lycian}', "");
Expect(0, 66175, '\P{^Blk=lycian}', "");
Expect(1, 66207, '\p{Blk=_	Lycian}', "");
Expect(0, 66207, '\p{^Blk=_	Lycian}', "");
Expect(0, 66207, '\P{Blk=_	Lycian}', "");
Expect(1, 66207, '\P{^Blk=_	Lycian}', "");
Expect(0, 66175, '\p{Blk=_	Lycian}', "");
Expect(1, 66175, '\p{^Blk=_	Lycian}', "");
Expect(1, 66175, '\P{Blk=_	Lycian}', "");
Expect(0, 66175, '\P{^Blk=_	Lycian}', "");
Error('\p{Is_Block=Lycian/a/}');
Error('\P{Is_Block=Lycian/a/}');
Expect(1, 66207, '\p{Is_Block:lycian}', "");
Expect(0, 66207, '\p{^Is_Block:lycian}', "");
Expect(0, 66207, '\P{Is_Block:lycian}', "");
Expect(1, 66207, '\P{^Is_Block:lycian}', "");
Expect(0, 66175, '\p{Is_Block:lycian}', "");
Expect(1, 66175, '\p{^Is_Block:lycian}', "");
Expect(1, 66175, '\P{Is_Block:lycian}', "");
Expect(0, 66175, '\P{^Is_Block:lycian}', "");
Expect(1, 66207, '\p{Is_Block=Lycian}', "");
Expect(0, 66207, '\p{^Is_Block=Lycian}', "");
Expect(0, 66207, '\P{Is_Block=Lycian}', "");
Expect(1, 66207, '\P{^Is_Block=Lycian}', "");
Expect(0, 66175, '\p{Is_Block=Lycian}', "");
Expect(1, 66175, '\p{^Is_Block=Lycian}', "");
Expect(1, 66175, '\P{Is_Block=Lycian}', "");
Expect(0, 66175, '\P{^Is_Block=Lycian}', "");
Error('\p{Is_Blk=:=Lycian}');
Error('\P{Is_Blk=:=Lycian}');
Expect(1, 66207, '\p{Is_Blk=lycian}', "");
Expect(0, 66207, '\p{^Is_Blk=lycian}', "");
Expect(0, 66207, '\P{Is_Blk=lycian}', "");
Expect(1, 66207, '\P{^Is_Blk=lycian}', "");
Expect(0, 66175, '\p{Is_Blk=lycian}', "");
Expect(1, 66175, '\p{^Is_Blk=lycian}', "");
Expect(1, 66175, '\P{Is_Blk=lycian}', "");
Expect(0, 66175, '\P{^Is_Blk=lycian}', "");
Expect(1, 66207, '\p{Is_Blk=- Lycian}', "");
Expect(0, 66207, '\p{^Is_Blk=- Lycian}', "");
Expect(0, 66207, '\P{Is_Blk=- Lycian}', "");
Expect(1, 66207, '\P{^Is_Blk=- Lycian}', "");
Expect(0, 66175, '\p{Is_Blk=- Lycian}', "");
Expect(1, 66175, '\p{^Is_Blk=- Lycian}', "");
Expect(1, 66175, '\P{Is_Blk=- Lycian}', "");
Expect(0, 66175, '\P{^Is_Blk=- Lycian}', "");
Error('\p{Block:   :=Geometric_Shapes}');
Error('\P{Block:   :=Geometric_Shapes}');
Expect(1, 9727, '\p{Block=geometricshapes}', "");
Expect(0, 9727, '\p{^Block=geometricshapes}', "");
Expect(0, 9727, '\P{Block=geometricshapes}', "");
Expect(1, 9727, '\P{^Block=geometricshapes}', "");
Expect(0, 9631, '\p{Block=geometricshapes}', "");
Expect(1, 9631, '\p{^Block=geometricshapes}', "");
Expect(1, 9631, '\P{Block=geometricshapes}', "");
Expect(0, 9631, '\P{^Block=geometricshapes}', "");
Expect(1, 9727, '\p{Block=		geometric	shapes}', "");
Expect(0, 9727, '\p{^Block=		geometric	shapes}', "");
Expect(0, 9727, '\P{Block=		geometric	shapes}', "");
Expect(1, 9727, '\P{^Block=		geometric	shapes}', "");
Expect(0, 9631, '\p{Block=		geometric	shapes}', "");
Expect(1, 9631, '\p{^Block=		geometric	shapes}', "");
Expect(1, 9631, '\P{Block=		geometric	shapes}', "");
Expect(0, 9631, '\P{^Block=		geometric	shapes}', "");
Error('\p{Blk:__Geometric:=shapes}');
Error('\P{Blk:__Geometric:=shapes}');
Expect(1, 9727, '\p{Blk=geometricshapes}', "");
Expect(0, 9727, '\p{^Blk=geometricshapes}', "");
Expect(0, 9727, '\P{Blk=geometricshapes}', "");
Expect(1, 9727, '\P{^Blk=geometricshapes}', "");
Expect(0, 9631, '\p{Blk=geometricshapes}', "");
Expect(1, 9631, '\p{^Blk=geometricshapes}', "");
Expect(1, 9631, '\P{Blk=geometricshapes}', "");
Expect(0, 9631, '\P{^Blk=geometricshapes}', "");
Expect(1, 9727, '\p{Blk:-GEOMETRIC	Shapes}', "");
Expect(0, 9727, '\p{^Blk:-GEOMETRIC	Shapes}', "");
Expect(0, 9727, '\P{Blk:-GEOMETRIC	Shapes}', "");
Expect(1, 9727, '\P{^Blk:-GEOMETRIC	Shapes}', "");
Expect(0, 9631, '\p{Blk:-GEOMETRIC	Shapes}', "");
Expect(1, 9631, '\p{^Blk:-GEOMETRIC	Shapes}', "");
Expect(1, 9631, '\P{Blk:-GEOMETRIC	Shapes}', "");
Expect(0, 9631, '\P{^Blk:-GEOMETRIC	Shapes}', "");
Error('\p{Is_Block=:=Geometric-Shapes}');
Error('\P{Is_Block=:=Geometric-Shapes}');
Expect(1, 9727, '\p{Is_Block:	geometricshapes}', "");
Expect(0, 9727, '\p{^Is_Block:	geometricshapes}', "");
Expect(0, 9727, '\P{Is_Block:	geometricshapes}', "");
Expect(1, 9727, '\P{^Is_Block:	geometricshapes}', "");
Expect(0, 9631, '\p{Is_Block:	geometricshapes}', "");
Expect(1, 9631, '\p{^Is_Block:	geometricshapes}', "");
Expect(1, 9631, '\P{Is_Block:	geometricshapes}', "");
Expect(0, 9631, '\P{^Is_Block:	geometricshapes}', "");
Expect(1, 9727, '\p{Is_Block=	geometricSHAPES}', "");
Expect(0, 9727, '\p{^Is_Block=	geometricSHAPES}', "");
Expect(0, 9727, '\P{Is_Block=	geometricSHAPES}', "");
Expect(1, 9727, '\P{^Is_Block=	geometricSHAPES}', "");
Expect(0, 9631, '\p{Is_Block=	geometricSHAPES}', "");
Expect(1, 9631, '\p{^Is_Block=	geometricSHAPES}', "");
Expect(1, 9631, '\P{Is_Block=	geometricSHAPES}', "");
Expect(0, 9631, '\P{^Is_Block=	geometricSHAPES}', "");
Error('\p{Is_Blk=	-Geometric SHAPES/a/}');
Error('\P{Is_Blk=	-Geometric SHAPES/a/}');
Expect(1, 9727, '\p{Is_Blk=geometricshapes}', "");
Expect(0, 9727, '\p{^Is_Blk=geometricshapes}', "");
Expect(0, 9727, '\P{Is_Blk=geometricshapes}', "");
Expect(1, 9727, '\P{^Is_Blk=geometricshapes}', "");
Expect(0, 9631, '\p{Is_Blk=geometricshapes}', "");
Expect(1, 9631, '\p{^Is_Blk=geometricshapes}', "");
Expect(1, 9631, '\P{Is_Blk=geometricshapes}', "");
Expect(0, 9631, '\P{^Is_Blk=geometricshapes}', "");
Expect(1, 9727, '\p{Is_Blk:	 Geometric	shapes}', "");
Expect(0, 9727, '\p{^Is_Blk:	 Geometric	shapes}', "");
Expect(0, 9727, '\P{Is_Blk:	 Geometric	shapes}', "");
Expect(1, 9727, '\P{^Is_Blk:	 Geometric	shapes}', "");
Expect(0, 9631, '\p{Is_Blk:	 Geometric	shapes}', "");
Expect(1, 9631, '\p{^Is_Blk:	 Geometric	shapes}', "");
Expect(1, 9631, '\P{Is_Blk:	 Geometric	shapes}', "");
Expect(0, 9631, '\P{^Is_Blk:	 Geometric	shapes}', "");
Error('\p{Block=_/a/Aegean_Numbers}');
Error('\P{Block=_/a/Aegean_Numbers}');
Expect(1, 65855, '\p{Block:	aegeannumbers}', "");
Expect(0, 65855, '\p{^Block:	aegeannumbers}', "");
Expect(0, 65855, '\P{Block:	aegeannumbers}', "");
Expect(1, 65855, '\P{^Block:	aegeannumbers}', "");
Expect(0, 65791, '\p{Block:	aegeannumbers}', "");
Expect(1, 65791, '\p{^Block:	aegeannumbers}', "");
Expect(1, 65791, '\P{Block:	aegeannumbers}', "");
Expect(0, 65791, '\P{^Block:	aegeannumbers}', "");
Expect(1, 65855, '\p{Block:_Aegean-NUMBERS}', "");
Expect(0, 65855, '\p{^Block:_Aegean-NUMBERS}', "");
Expect(0, 65855, '\P{Block:_Aegean-NUMBERS}', "");
Expect(1, 65855, '\P{^Block:_Aegean-NUMBERS}', "");
Expect(0, 65791, '\p{Block:_Aegean-NUMBERS}', "");
Expect(1, 65791, '\p{^Block:_Aegean-NUMBERS}', "");
Expect(1, 65791, '\P{Block:_Aegean-NUMBERS}', "");
Expect(0, 65791, '\P{^Block:_Aegean-NUMBERS}', "");
Error('\p{Blk= Aegean_numbers/a/}');
Error('\P{Blk= Aegean_numbers/a/}');
Expect(1, 65855, '\p{Blk=aegeannumbers}', "");
Expect(0, 65855, '\p{^Blk=aegeannumbers}', "");
Expect(0, 65855, '\P{Blk=aegeannumbers}', "");
Expect(1, 65855, '\P{^Blk=aegeannumbers}', "");
Expect(0, 65791, '\p{Blk=aegeannumbers}', "");
Expect(1, 65791, '\p{^Blk=aegeannumbers}', "");
Expect(1, 65791, '\P{Blk=aegeannumbers}', "");
Expect(0, 65791, '\P{^Blk=aegeannumbers}', "");
Expect(1, 65855, '\p{Blk=__AEGEAN_numbers}', "");
Expect(0, 65855, '\p{^Blk=__AEGEAN_numbers}', "");
Expect(0, 65855, '\P{Blk=__AEGEAN_numbers}', "");
Expect(1, 65855, '\P{^Blk=__AEGEAN_numbers}', "");
Expect(0, 65791, '\p{Blk=__AEGEAN_numbers}', "");
Expect(1, 65791, '\p{^Blk=__AEGEAN_numbers}', "");
Expect(1, 65791, '\P{Blk=__AEGEAN_numbers}', "");
Expect(0, 65791, '\P{^Blk=__AEGEAN_numbers}', "");
Error('\p{Is_Block=_ Aegean numbers/a/}');
Error('\P{Is_Block=_ Aegean numbers/a/}');
Expect(1, 65855, '\p{Is_Block=aegeannumbers}', "");
Expect(0, 65855, '\p{^Is_Block=aegeannumbers}', "");
Expect(0, 65855, '\P{Is_Block=aegeannumbers}', "");
Expect(1, 65855, '\P{^Is_Block=aegeannumbers}', "");
Expect(0, 65791, '\p{Is_Block=aegeannumbers}', "");
Expect(1, 65791, '\p{^Is_Block=aegeannumbers}', "");
Expect(1, 65791, '\P{Is_Block=aegeannumbers}', "");
Expect(0, 65791, '\P{^Is_Block=aegeannumbers}', "");
Expect(1, 65855, '\p{Is_Block= 	Aegean-numbers}', "");
Expect(0, 65855, '\p{^Is_Block= 	Aegean-numbers}', "");
Expect(0, 65855, '\P{Is_Block= 	Aegean-numbers}', "");
Expect(1, 65855, '\P{^Is_Block= 	Aegean-numbers}', "");
Expect(0, 65791, '\p{Is_Block= 	Aegean-numbers}', "");
Expect(1, 65791, '\p{^Is_Block= 	Aegean-numbers}', "");
Expect(1, 65791, '\P{Is_Block= 	Aegean-numbers}', "");
Expect(0, 65791, '\P{^Is_Block= 	Aegean-numbers}', "");
Error('\p{Is_Blk= :=Aegean Numbers}');
Error('\P{Is_Blk= :=Aegean Numbers}');
Expect(1, 65855, '\p{Is_Blk=aegeannumbers}', "");
Expect(0, 65855, '\p{^Is_Blk=aegeannumbers}', "");
Expect(0, 65855, '\P{Is_Blk=aegeannumbers}', "");
Expect(1, 65855, '\P{^Is_Blk=aegeannumbers}', "");
Expect(0, 65791, '\p{Is_Blk=aegeannumbers}', "");
Expect(1, 65791, '\p{^Is_Blk=aegeannumbers}', "");
Expect(1, 65791, '\P{Is_Blk=aegeannumbers}', "");
Expect(0, 65791, '\P{^Is_Blk=aegeannumbers}', "");
Expect(1, 65855, '\p{Is_Blk=aegean_numbers}', "");
Expect(0, 65855, '\p{^Is_Blk=aegean_numbers}', "");
Expect(0, 65855, '\P{Is_Blk=aegean_numbers}', "");
Expect(1, 65855, '\P{^Is_Blk=aegean_numbers}', "");
Expect(0, 65791, '\p{Is_Blk=aegean_numbers}', "");
Expect(1, 65791, '\p{^Is_Blk=aegean_numbers}', "");
Expect(1, 65791, '\P{Is_Blk=aegean_numbers}', "");
Expect(0, 65791, '\P{^Is_Blk=aegean_numbers}', "");
Error('\p{Block:   /a/ _khmer symbols}');
Error('\P{Block:   /a/ _khmer symbols}');
Expect(1, 6655, '\p{Block: khmersymbols}', "");
Expect(0, 6655, '\p{^Block: khmersymbols}', "");
Expect(0, 6655, '\P{Block: khmersymbols}', "");
Expect(1, 6655, '\P{^Block: khmersymbols}', "");
Expect(0, 6623, '\p{Block: khmersymbols}', "");
Expect(1, 6623, '\p{^Block: khmersymbols}', "");
Expect(1, 6623, '\P{Block: khmersymbols}', "");
Expect(0, 6623, '\P{^Block: khmersymbols}', "");
Expect(1, 6655, '\p{Block= _KHMER Symbols}', "");
Expect(0, 6655, '\p{^Block= _KHMER Symbols}', "");
Expect(0, 6655, '\P{Block= _KHMER Symbols}', "");
Expect(1, 6655, '\P{^Block= _KHMER Symbols}', "");
Expect(0, 6623, '\p{Block= _KHMER Symbols}', "");
Expect(1, 6623, '\p{^Block= _KHMER Symbols}', "");
Expect(1, 6623, '\P{Block= _KHMER Symbols}', "");
Expect(0, 6623, '\P{^Block= _KHMER Symbols}', "");
Error('\p{Blk= _Khmer	Symbols:=}');
Error('\P{Blk= _Khmer	Symbols:=}');
Expect(1, 6655, '\p{Blk=khmersymbols}', "");
Expect(0, 6655, '\p{^Blk=khmersymbols}', "");
Expect(0, 6655, '\P{Blk=khmersymbols}', "");
Expect(1, 6655, '\P{^Blk=khmersymbols}', "");
Expect(0, 6623, '\p{Blk=khmersymbols}', "");
Expect(1, 6623, '\p{^Blk=khmersymbols}', "");
Expect(1, 6623, '\P{Blk=khmersymbols}', "");
Expect(0, 6623, '\P{^Blk=khmersymbols}', "");
Expect(1, 6655, '\p{Blk: 	Khmer-Symbols}', "");
Expect(0, 6655, '\p{^Blk: 	Khmer-Symbols}', "");
Expect(0, 6655, '\P{Blk: 	Khmer-Symbols}', "");
Expect(1, 6655, '\P{^Blk: 	Khmer-Symbols}', "");
Expect(0, 6623, '\p{Blk: 	Khmer-Symbols}', "");
Expect(1, 6623, '\p{^Blk: 	Khmer-Symbols}', "");
Expect(1, 6623, '\P{Blk: 	Khmer-Symbols}', "");
Expect(0, 6623, '\P{^Blk: 	Khmer-Symbols}', "");
Error('\p{Is_Block=-/a/Khmer	Symbols}');
Error('\P{Is_Block=-/a/Khmer	Symbols}');
Expect(1, 6655, '\p{Is_Block=khmersymbols}', "");
Expect(0, 6655, '\p{^Is_Block=khmersymbols}', "");
Expect(0, 6655, '\P{Is_Block=khmersymbols}', "");
Expect(1, 6655, '\P{^Is_Block=khmersymbols}', "");
Expect(0, 6623, '\p{Is_Block=khmersymbols}', "");
Expect(1, 6623, '\p{^Is_Block=khmersymbols}', "");
Expect(1, 6623, '\P{Is_Block=khmersymbols}', "");
Expect(0, 6623, '\P{^Is_Block=khmersymbols}', "");
Expect(1, 6655, '\p{Is_Block=	Khmer_symbols}', "");
Expect(0, 6655, '\p{^Is_Block=	Khmer_symbols}', "");
Expect(0, 6655, '\P{Is_Block=	Khmer_symbols}', "");
Expect(1, 6655, '\P{^Is_Block=	Khmer_symbols}', "");
Expect(0, 6623, '\p{Is_Block=	Khmer_symbols}', "");
Expect(1, 6623, '\p{^Is_Block=	Khmer_symbols}', "");
Expect(1, 6623, '\P{Is_Block=	Khmer_symbols}', "");
Expect(0, 6623, '\P{^Is_Block=	Khmer_symbols}', "");
Error('\p{Is_Blk=:=khmer_symbols}');
Error('\P{Is_Blk=:=khmer_symbols}');
Expect(1, 6655, '\p{Is_Blk=khmersymbols}', "");
Expect(0, 6655, '\p{^Is_Blk=khmersymbols}', "");
Expect(0, 6655, '\P{Is_Blk=khmersymbols}', "");
Expect(1, 6655, '\P{^Is_Blk=khmersymbols}', "");
Expect(0, 6623, '\p{Is_Blk=khmersymbols}', "");
Expect(1, 6623, '\p{^Is_Blk=khmersymbols}', "");
Expect(1, 6623, '\P{Is_Blk=khmersymbols}', "");
Expect(0, 6623, '\P{^Is_Blk=khmersymbols}', "");
Expect(1, 6655, '\p{Is_Blk:	_	KHMER	SYMBOLS}', "");
Expect(0, 6655, '\p{^Is_Blk:	_	KHMER	SYMBOLS}', "");
Expect(0, 6655, '\P{Is_Blk:	_	KHMER	SYMBOLS}', "");
Expect(1, 6655, '\P{^Is_Blk:	_	KHMER	SYMBOLS}', "");
Expect(0, 6623, '\p{Is_Blk:	_	KHMER	SYMBOLS}', "");
Expect(1, 6623, '\p{^Is_Blk:	_	KHMER	SYMBOLS}', "");
Expect(1, 6623, '\P{Is_Blk:	_	KHMER	SYMBOLS}', "");
Expect(0, 6623, '\P{^Is_Blk:	_	KHMER	SYMBOLS}', "");
Error('\p{Block=:=CJK-Radicals	SUPPLEMENT}');
Error('\P{Block=:=CJK-Radicals	SUPPLEMENT}');
Expect(1, 12031, '\p{Block=cjkradicalssupplement}', "");
Expect(0, 12031, '\p{^Block=cjkradicalssupplement}', "");
Expect(0, 12031, '\P{Block=cjkradicalssupplement}', "");
Expect(1, 12031, '\P{^Block=cjkradicalssupplement}', "");
Expect(0, 11903, '\p{Block=cjkradicalssupplement}', "");
Expect(1, 11903, '\p{^Block=cjkradicalssupplement}', "");
Expect(1, 11903, '\P{Block=cjkradicalssupplement}', "");
Expect(0, 11903, '\P{^Block=cjkradicalssupplement}', "");
Expect(1, 12031, '\p{Block=-CJK	Radicalssupplement}', "");
Expect(0, 12031, '\p{^Block=-CJK	Radicalssupplement}', "");
Expect(0, 12031, '\P{Block=-CJK	Radicalssupplement}', "");
Expect(1, 12031, '\P{^Block=-CJK	Radicalssupplement}', "");
Expect(0, 11903, '\p{Block=-CJK	Radicalssupplement}', "");
Expect(1, 11903, '\p{^Block=-CJK	Radicalssupplement}', "");
Expect(1, 11903, '\P{Block=-CJK	Radicalssupplement}', "");
Expect(0, 11903, '\P{^Block=-CJK	Radicalssupplement}', "");
Error('\p{Blk=-CJK:=radicals SUPPLEMENT}');
Error('\P{Blk=-CJK:=radicals SUPPLEMENT}');
Expect(1, 12031, '\p{Blk=cjkradicalssupplement}', "");
Expect(0, 12031, '\p{^Blk=cjkradicalssupplement}', "");
Expect(0, 12031, '\P{Blk=cjkradicalssupplement}', "");
Expect(1, 12031, '\P{^Blk=cjkradicalssupplement}', "");
Expect(0, 11903, '\p{Blk=cjkradicalssupplement}', "");
Expect(1, 11903, '\p{^Blk=cjkradicalssupplement}', "");
Expect(1, 11903, '\P{Blk=cjkradicalssupplement}', "");
Expect(0, 11903, '\P{^Blk=cjkradicalssupplement}', "");
Expect(1, 12031, '\p{Blk=_ CJK_radicals-SUPPLEMENT}', "");
Expect(0, 12031, '\p{^Blk=_ CJK_radicals-SUPPLEMENT}', "");
Expect(0, 12031, '\P{Blk=_ CJK_radicals-SUPPLEMENT}', "");
Expect(1, 12031, '\P{^Blk=_ CJK_radicals-SUPPLEMENT}', "");
Expect(0, 11903, '\p{Blk=_ CJK_radicals-SUPPLEMENT}', "");
Expect(1, 11903, '\p{^Blk=_ CJK_radicals-SUPPLEMENT}', "");
Expect(1, 11903, '\P{Blk=_ CJK_radicals-SUPPLEMENT}', "");
Expect(0, 11903, '\P{^Blk=_ CJK_radicals-SUPPLEMENT}', "");
Error('\p{Is_Block=:=CJKradicals-SUPPLEMENT}');
Error('\P{Is_Block=:=CJKradicals-SUPPLEMENT}');
Expect(1, 12031, '\p{Is_Block=cjkradicalssupplement}', "");
Expect(0, 12031, '\p{^Is_Block=cjkradicalssupplement}', "");
Expect(0, 12031, '\P{Is_Block=cjkradicalssupplement}', "");
Expect(1, 12031, '\P{^Is_Block=cjkradicalssupplement}', "");
Expect(0, 11903, '\p{Is_Block=cjkradicalssupplement}', "");
Expect(1, 11903, '\p{^Is_Block=cjkradicalssupplement}', "");
Expect(1, 11903, '\P{Is_Block=cjkradicalssupplement}', "");
Expect(0, 11903, '\P{^Is_Block=cjkradicalssupplement}', "");
Expect(1, 12031, '\p{Is_Block=  cjk	radicals Supplement}', "");
Expect(0, 12031, '\p{^Is_Block=  cjk	radicals Supplement}', "");
Expect(0, 12031, '\P{Is_Block=  cjk	radicals Supplement}', "");
Expect(1, 12031, '\P{^Is_Block=  cjk	radicals Supplement}', "");
Expect(0, 11903, '\p{Is_Block=  cjk	radicals Supplement}', "");
Expect(1, 11903, '\p{^Is_Block=  cjk	radicals Supplement}', "");
Expect(1, 11903, '\P{Is_Block=  cjk	radicals Supplement}', "");
Expect(0, 11903, '\P{^Is_Block=  cjk	radicals Supplement}', "");
Error('\p{Is_Blk=:=CJK-radicals	SUPPLEMENT}');
Error('\P{Is_Blk=:=CJK-radicals	SUPPLEMENT}');
Expect(1, 12031, '\p{Is_Blk=cjkradicalssupplement}', "");
Expect(0, 12031, '\p{^Is_Blk=cjkradicalssupplement}', "");
Expect(0, 12031, '\P{Is_Blk=cjkradicalssupplement}', "");
Expect(1, 12031, '\P{^Is_Blk=cjkradicalssupplement}', "");
Expect(0, 11903, '\p{Is_Blk=cjkradicalssupplement}', "");
Expect(1, 11903, '\p{^Is_Blk=cjkradicalssupplement}', "");
Expect(1, 11903, '\P{Is_Blk=cjkradicalssupplement}', "");
Expect(0, 11903, '\P{^Is_Blk=cjkradicalssupplement}', "");
Expect(1, 12031, '\p{Is_Blk= _cjkRadicals-Supplement}', "");
Expect(0, 12031, '\p{^Is_Blk= _cjkRadicals-Supplement}', "");
Expect(0, 12031, '\P{Is_Blk= _cjkRadicals-Supplement}', "");
Expect(1, 12031, '\P{^Is_Blk= _cjkRadicals-Supplement}', "");
Expect(0, 11903, '\p{Is_Blk= _cjkRadicals-Supplement}', "");
Expect(1, 11903, '\p{^Is_Blk= _cjkRadicals-Supplement}', "");
Expect(1, 11903, '\P{Is_Blk= _cjkRadicals-Supplement}', "");
Expect(0, 11903, '\P{^Is_Blk= _cjkRadicals-Supplement}', "");
Error('\p{Block=/a/ImperialAramaic}');
Error('\P{Block=/a/ImperialAramaic}');
Expect(1, 67679, '\p{Block=imperialaramaic}', "");
Expect(0, 67679, '\p{^Block=imperialaramaic}', "");
Expect(0, 67679, '\P{Block=imperialaramaic}', "");
Expect(1, 67679, '\P{^Block=imperialaramaic}', "");
Expect(0, 67647, '\p{Block=imperialaramaic}', "");
Expect(1, 67647, '\p{^Block=imperialaramaic}', "");
Expect(1, 67647, '\P{Block=imperialaramaic}', "");
Expect(0, 67647, '\P{^Block=imperialaramaic}', "");
Expect(1, 67679, '\p{Block=	Imperial_Aramaic}', "");
Expect(0, 67679, '\p{^Block=	Imperial_Aramaic}', "");
Expect(0, 67679, '\P{Block=	Imperial_Aramaic}', "");
Expect(1, 67679, '\P{^Block=	Imperial_Aramaic}', "");
Expect(0, 67647, '\p{Block=	Imperial_Aramaic}', "");
Expect(1, 67647, '\p{^Block=	Imperial_Aramaic}', "");
Expect(1, 67647, '\P{Block=	Imperial_Aramaic}', "");
Expect(0, 67647, '\P{^Block=	Imperial_Aramaic}', "");
Error('\p{Blk: _ IMPERIAL aramaic/a/}');
Error('\P{Blk: _ IMPERIAL aramaic/a/}');
Expect(1, 67679, '\p{Blk=imperialaramaic}', "");
Expect(0, 67679, '\p{^Blk=imperialaramaic}', "");
Expect(0, 67679, '\P{Blk=imperialaramaic}', "");
Expect(1, 67679, '\P{^Blk=imperialaramaic}', "");
Expect(0, 67647, '\p{Blk=imperialaramaic}', "");
Expect(1, 67647, '\p{^Blk=imperialaramaic}', "");
Expect(1, 67647, '\P{Blk=imperialaramaic}', "");
Expect(0, 67647, '\P{^Blk=imperialaramaic}', "");
Expect(1, 67679, '\p{Blk=--imperial	Aramaic}', "");
Expect(0, 67679, '\p{^Blk=--imperial	Aramaic}', "");
Expect(0, 67679, '\P{Blk=--imperial	Aramaic}', "");
Expect(1, 67679, '\P{^Blk=--imperial	Aramaic}', "");
Expect(0, 67647, '\p{Blk=--imperial	Aramaic}', "");
Expect(1, 67647, '\p{^Blk=--imperial	Aramaic}', "");
Expect(1, 67647, '\P{Blk=--imperial	Aramaic}', "");
Expect(0, 67647, '\P{^Blk=--imperial	Aramaic}', "");
Error('\p{Is_Block:    /a/imperial aramaic}');
Error('\P{Is_Block:    /a/imperial aramaic}');
Expect(1, 67679, '\p{Is_Block=imperialaramaic}', "");
Expect(0, 67679, '\p{^Is_Block=imperialaramaic}', "");
Expect(0, 67679, '\P{Is_Block=imperialaramaic}', "");
Expect(1, 67679, '\P{^Is_Block=imperialaramaic}', "");
Expect(0, 67647, '\p{Is_Block=imperialaramaic}', "");
Expect(1, 67647, '\p{^Is_Block=imperialaramaic}', "");
Expect(1, 67647, '\P{Is_Block=imperialaramaic}', "");
Expect(0, 67647, '\P{^Is_Block=imperialaramaic}', "");
Expect(1, 67679, '\p{Is_Block=-_Imperial_aramaic}', "");
Expect(0, 67679, '\p{^Is_Block=-_Imperial_aramaic}', "");
Expect(0, 67679, '\P{Is_Block=-_Imperial_aramaic}', "");
Expect(1, 67679, '\P{^Is_Block=-_Imperial_aramaic}', "");
Expect(0, 67647, '\p{Is_Block=-_Imperial_aramaic}', "");
Expect(1, 67647, '\p{^Is_Block=-_Imperial_aramaic}', "");
Expect(1, 67647, '\P{Is_Block=-_Imperial_aramaic}', "");
Expect(0, 67647, '\P{^Is_Block=-_Imperial_aramaic}', "");
Error('\p{Is_Blk= Imperial-aramaic/a/}');
Error('\P{Is_Blk= Imperial-aramaic/a/}');
Expect(1, 67679, '\p{Is_Blk:	imperialaramaic}', "");
Expect(0, 67679, '\p{^Is_Blk:	imperialaramaic}', "");
Expect(0, 67679, '\P{Is_Blk:	imperialaramaic}', "");
Expect(1, 67679, '\P{^Is_Blk:	imperialaramaic}', "");
Expect(0, 67647, '\p{Is_Blk:	imperialaramaic}', "");
Expect(1, 67647, '\p{^Is_Blk:	imperialaramaic}', "");
Expect(1, 67647, '\P{Is_Blk:	imperialaramaic}', "");
Expect(0, 67647, '\P{^Is_Blk:	imperialaramaic}', "");
Expect(1, 67679, '\p{Is_Blk=_	imperial ARAMAIC}', "");
Expect(0, 67679, '\p{^Is_Blk=_	imperial ARAMAIC}', "");
Expect(0, 67679, '\P{Is_Blk=_	imperial ARAMAIC}', "");
Expect(1, 67679, '\P{^Is_Blk=_	imperial ARAMAIC}', "");
Expect(0, 67647, '\p{Is_Blk=_	imperial ARAMAIC}', "");
Expect(1, 67647, '\p{^Is_Blk=_	imperial ARAMAIC}', "");
Expect(1, 67647, '\P{Is_Blk=_	imperial ARAMAIC}', "");
Expect(0, 67647, '\P{^Is_Blk=_	imperial ARAMAIC}', "");
Error('\p{Block=_	Mathematical	OPERATORS/a/}');
Error('\P{Block=_	Mathematical	OPERATORS/a/}');
Expect(1, 8959, '\p{Block=mathematicaloperators}', "");
Expect(0, 8959, '\p{^Block=mathematicaloperators}', "");
Expect(0, 8959, '\P{Block=mathematicaloperators}', "");
Expect(1, 8959, '\P{^Block=mathematicaloperators}', "");
Expect(0, 8703, '\p{Block=mathematicaloperators}', "");
Expect(1, 8703, '\p{^Block=mathematicaloperators}', "");
Expect(1, 8703, '\P{Block=mathematicaloperators}', "");
Expect(0, 8703, '\P{^Block=mathematicaloperators}', "");
Expect(1, 8959, '\p{Block=MATHEMATICAL-Operators}', "");
Expect(0, 8959, '\p{^Block=MATHEMATICAL-Operators}', "");
Expect(0, 8959, '\P{Block=MATHEMATICAL-Operators}', "");
Expect(1, 8959, '\P{^Block=MATHEMATICAL-Operators}', "");
Expect(0, 8703, '\p{Block=MATHEMATICAL-Operators}', "");
Expect(1, 8703, '\p{^Block=MATHEMATICAL-Operators}', "");
Expect(1, 8703, '\P{Block=MATHEMATICAL-Operators}', "");
Expect(0, 8703, '\P{^Block=MATHEMATICAL-Operators}', "");
Error('\p{Blk: 	/a/mathematicalOperators}');
Error('\P{Blk: 	/a/mathematicalOperators}');
Expect(1, 8959, '\p{Blk=mathematicaloperators}', "");
Expect(0, 8959, '\p{^Blk=mathematicaloperators}', "");
Expect(0, 8959, '\P{Blk=mathematicaloperators}', "");
Expect(1, 8959, '\P{^Blk=mathematicaloperators}', "");
Expect(0, 8703, '\p{Blk=mathematicaloperators}', "");
Expect(1, 8703, '\p{^Blk=mathematicaloperators}', "");
Expect(1, 8703, '\P{Blk=mathematicaloperators}', "");
Expect(0, 8703, '\P{^Blk=mathematicaloperators}', "");
Expect(1, 8959, '\p{Blk:	MATHEMATICAL	OPERATORS}', "");
Expect(0, 8959, '\p{^Blk:	MATHEMATICAL	OPERATORS}', "");
Expect(0, 8959, '\P{Blk:	MATHEMATICAL	OPERATORS}', "");
Expect(1, 8959, '\P{^Blk:	MATHEMATICAL	OPERATORS}', "");
Expect(0, 8703, '\p{Blk:	MATHEMATICAL	OPERATORS}', "");
Expect(1, 8703, '\p{^Blk:	MATHEMATICAL	OPERATORS}', "");
Expect(1, 8703, '\P{Blk:	MATHEMATICAL	OPERATORS}', "");
Expect(0, 8703, '\P{^Blk:	MATHEMATICAL	OPERATORS}', "");
Error('\p{Is_Block=:=_mathematical-operators}');
Error('\P{Is_Block=:=_mathematical-operators}');
Expect(1, 8959, '\p{Is_Block=mathematicaloperators}', "");
Expect(0, 8959, '\p{^Is_Block=mathematicaloperators}', "");
Expect(0, 8959, '\P{Is_Block=mathematicaloperators}', "");
Expect(1, 8959, '\P{^Is_Block=mathematicaloperators}', "");
Expect(0, 8703, '\p{Is_Block=mathematicaloperators}', "");
Expect(1, 8703, '\p{^Is_Block=mathematicaloperators}', "");
Expect(1, 8703, '\P{Is_Block=mathematicaloperators}', "");
Expect(0, 8703, '\P{^Is_Block=mathematicaloperators}', "");
Expect(1, 8959, '\p{Is_Block=-_Mathematical_Operators}', "");
Expect(0, 8959, '\p{^Is_Block=-_Mathematical_Operators}', "");
Expect(0, 8959, '\P{Is_Block=-_Mathematical_Operators}', "");
Expect(1, 8959, '\P{^Is_Block=-_Mathematical_Operators}', "");
Expect(0, 8703, '\p{Is_Block=-_Mathematical_Operators}', "");
Expect(1, 8703, '\p{^Is_Block=-_Mathematical_Operators}', "");
Expect(1, 8703, '\P{Is_Block=-_Mathematical_Operators}', "");
Expect(0, 8703, '\P{^Is_Block=-_Mathematical_Operators}', "");
Error('\p{Is_Blk=	_MATHEMATICAL-Operators:=}');
Error('\P{Is_Blk=	_MATHEMATICAL-Operators:=}');
Expect(1, 8959, '\p{Is_Blk=mathematicaloperators}', "");
Expect(0, 8959, '\p{^Is_Blk=mathematicaloperators}', "");
Expect(0, 8959, '\P{Is_Blk=mathematicaloperators}', "");
Expect(1, 8959, '\P{^Is_Blk=mathematicaloperators}', "");
Expect(0, 8703, '\p{Is_Blk=mathematicaloperators}', "");
Expect(1, 8703, '\p{^Is_Blk=mathematicaloperators}', "");
Expect(1, 8703, '\P{Is_Blk=mathematicaloperators}', "");
Expect(0, 8703, '\P{^Is_Blk=mathematicaloperators}', "");
Expect(1, 8959, '\p{Is_Blk=	-MATHEMATICAL Operators}', "");
Expect(0, 8959, '\p{^Is_Blk=	-MATHEMATICAL Operators}', "");
Expect(0, 8959, '\P{Is_Blk=	-MATHEMATICAL Operators}', "");
Expect(1, 8959, '\P{^Is_Blk=	-MATHEMATICAL Operators}', "");
Expect(0, 8703, '\p{Is_Blk=	-MATHEMATICAL Operators}', "");
Expect(1, 8703, '\p{^Is_Blk=	-MATHEMATICAL Operators}', "");
Expect(1, 8703, '\P{Is_Blk=	-MATHEMATICAL Operators}', "");
Expect(0, 8703, '\P{^Is_Blk=	-MATHEMATICAL Operators}', "");
Error('\p{Block=- CJK/a/compatibilityIdeographs supplement}');
Error('\P{Block=- CJK/a/compatibilityIdeographs supplement}');
Expect(1, 195103, '\p{Block:cjkcompatibilityideographssupplement}', "");
Expect(0, 195103, '\p{^Block:cjkcompatibilityideographssupplement}', "");
Expect(0, 195103, '\P{Block:cjkcompatibilityideographssupplement}', "");
Expect(1, 195103, '\P{^Block:cjkcompatibilityideographssupplement}', "");
Expect(0, 194559, '\p{Block:cjkcompatibilityideographssupplement}', "");
Expect(1, 194559, '\p{^Block:cjkcompatibilityideographssupplement}', "");
Expect(1, 194559, '\P{Block:cjkcompatibilityideographssupplement}', "");
Expect(0, 194559, '\P{^Block:cjkcompatibilityideographssupplement}', "");
Expect(1, 195103, '\p{Block:			CJK_compatibilityIdeographs_SUPPLEMENT}', "");
Expect(0, 195103, '\p{^Block:			CJK_compatibilityIdeographs_SUPPLEMENT}', "");
Expect(0, 195103, '\P{Block:			CJK_compatibilityIdeographs_SUPPLEMENT}', "");
Expect(1, 195103, '\P{^Block:			CJK_compatibilityIdeographs_SUPPLEMENT}', "");
Expect(0, 194559, '\p{Block:			CJK_compatibilityIdeographs_SUPPLEMENT}', "");
Expect(1, 194559, '\p{^Block:			CJK_compatibilityIdeographs_SUPPLEMENT}', "");
Expect(1, 194559, '\P{Block:			CJK_compatibilityIdeographs_SUPPLEMENT}', "");
Expect(0, 194559, '\P{^Block:			CJK_compatibilityIdeographs_SUPPLEMENT}', "");
Error('\p{Blk= 	CJK-Compatibility_Ideographs_Supplement/a/}');
Error('\P{Blk= 	CJK-Compatibility_Ideographs_Supplement/a/}');
Expect(1, 195103, '\p{Blk=cjkcompatibilityideographssupplement}', "");
Expect(0, 195103, '\p{^Blk=cjkcompatibilityideographssupplement}', "");
Expect(0, 195103, '\P{Blk=cjkcompatibilityideographssupplement}', "");
Expect(1, 195103, '\P{^Blk=cjkcompatibilityideographssupplement}', "");
Expect(0, 194559, '\p{Blk=cjkcompatibilityideographssupplement}', "");
Expect(1, 194559, '\p{^Blk=cjkcompatibilityideographssupplement}', "");
Expect(1, 194559, '\P{Blk=cjkcompatibilityideographssupplement}', "");
Expect(0, 194559, '\P{^Blk=cjkcompatibilityideographssupplement}', "");
Expect(1, 195103, '\p{Blk:		CJK_Compatibility Ideographs	Supplement}', "");
Expect(0, 195103, '\p{^Blk:		CJK_Compatibility Ideographs	Supplement}', "");
Expect(0, 195103, '\P{Blk:		CJK_Compatibility Ideographs	Supplement}', "");
Expect(1, 195103, '\P{^Blk:		CJK_Compatibility Ideographs	Supplement}', "");
Expect(0, 194559, '\p{Blk:		CJK_Compatibility Ideographs	Supplement}', "");
Expect(1, 194559, '\p{^Blk:		CJK_Compatibility Ideographs	Supplement}', "");
Expect(1, 194559, '\P{Blk:		CJK_Compatibility Ideographs	Supplement}', "");
Expect(0, 194559, '\P{^Blk:		CJK_Compatibility Ideographs	Supplement}', "");
Error('\p{Is_Block= _cjk:=Compatibility_Ideographs_Supplement}');
Error('\P{Is_Block= _cjk:=Compatibility_Ideographs_Supplement}');
Expect(1, 195103, '\p{Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(0, 195103, '\p{^Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(0, 195103, '\P{Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(1, 195103, '\P{^Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(0, 194559, '\p{Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(1, 194559, '\p{^Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(1, 194559, '\P{Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(0, 194559, '\P{^Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(1, 195103, '\p{Is_Block=--cjk	Compatibility-ideographs	supplement}', "");
Expect(0, 195103, '\p{^Is_Block=--cjk	Compatibility-ideographs	supplement}', "");
Expect(0, 195103, '\P{Is_Block=--cjk	Compatibility-ideographs	supplement}', "");
Expect(1, 195103, '\P{^Is_Block=--cjk	Compatibility-ideographs	supplement}', "");
Expect(0, 194559, '\p{Is_Block=--cjk	Compatibility-ideographs	supplement}', "");
Expect(1, 194559, '\p{^Is_Block=--cjk	Compatibility-ideographs	supplement}', "");
Expect(1, 194559, '\P{Is_Block=--cjk	Compatibility-ideographs	supplement}', "");
Expect(0, 194559, '\P{^Is_Block=--cjk	Compatibility-ideographs	supplement}', "");
Error('\p{Is_Blk=	-cjk COMPATIBILITY	Ideographs:=supplement}');
Error('\P{Is_Blk=	-cjk COMPATIBILITY	Ideographs:=supplement}');
Expect(1, 195103, '\p{Is_Blk=cjkcompatibilityideographssupplement}', "");
Expect(0, 195103, '\p{^Is_Blk=cjkcompatibilityideographssupplement}', "");
Expect(0, 195103, '\P{Is_Blk=cjkcompatibilityideographssupplement}', "");
Expect(1, 195103, '\P{^Is_Blk=cjkcompatibilityideographssupplement}', "");
Expect(0, 194559, '\p{Is_Blk=cjkcompatibilityideographssupplement}', "");
Expect(1, 194559, '\p{^Is_Blk=cjkcompatibilityideographssupplement}', "");
Expect(1, 194559, '\P{Is_Blk=cjkcompatibilityideographssupplement}', "");
Expect(0, 194559, '\P{^Is_Blk=cjkcompatibilityideographssupplement}', "");
Expect(1, 195103, '\p{Is_Blk=__CJKcompatibility	IDEOGRAPHSSupplement}', "");
Expect(0, 195103, '\p{^Is_Blk=__CJKcompatibility	IDEOGRAPHSSupplement}', "");
Expect(0, 195103, '\P{Is_Blk=__CJKcompatibility	IDEOGRAPHSSupplement}', "");
Expect(1, 195103, '\P{^Is_Blk=__CJKcompatibility	IDEOGRAPHSSupplement}', "");
Expect(0, 194559, '\p{Is_Blk=__CJKcompatibility	IDEOGRAPHSSupplement}', "");
Expect(1, 194559, '\p{^Is_Blk=__CJKcompatibility	IDEOGRAPHSSupplement}', "");
Expect(1, 194559, '\P{Is_Blk=__CJKcompatibility	IDEOGRAPHSSupplement}', "");
Expect(0, 194559, '\P{^Is_Blk=__CJKcompatibility	IDEOGRAPHSSupplement}', "");
Error('\p{Block=:=  IPA	extensions}');
Error('\P{Block=:=  IPA	extensions}');
Expect(1, 687, '\p{Block=ipaextensions}', "");
Expect(0, 687, '\p{^Block=ipaextensions}', "");
Expect(0, 687, '\P{Block=ipaextensions}', "");
Expect(1, 687, '\P{^Block=ipaextensions}', "");
Expect(0, 591, '\p{Block=ipaextensions}', "");
Expect(1, 591, '\p{^Block=ipaextensions}', "");
Expect(1, 591, '\P{Block=ipaextensions}', "");
Expect(0, 591, '\P{^Block=ipaextensions}', "");
Expect(1, 687, '\p{Block=-IPA_extensions}', "");
Expect(0, 687, '\p{^Block=-IPA_extensions}', "");
Expect(0, 687, '\P{Block=-IPA_extensions}', "");
Expect(1, 687, '\P{^Block=-IPA_extensions}', "");
Expect(0, 591, '\p{Block=-IPA_extensions}', "");
Expect(1, 591, '\p{^Block=-IPA_extensions}', "");
Expect(1, 591, '\P{Block=-IPA_extensions}', "");
Expect(0, 591, '\P{^Block=-IPA_extensions}', "");
Error('\p{Blk=:=_ IPA-EXTENSIONS}');
Error('\P{Blk=:=_ IPA-EXTENSIONS}');
Expect(1, 687, '\p{Blk=ipaextensions}', "");
Expect(0, 687, '\p{^Blk=ipaextensions}', "");
Expect(0, 687, '\P{Blk=ipaextensions}', "");
Expect(1, 687, '\P{^Blk=ipaextensions}', "");
Expect(0, 591, '\p{Blk=ipaextensions}', "");
Expect(1, 591, '\p{^Blk=ipaextensions}', "");
Expect(1, 591, '\P{Blk=ipaextensions}', "");
Expect(0, 591, '\P{^Blk=ipaextensions}', "");
Expect(1, 687, '\p{Blk=IPA-Extensions}', "");
Expect(0, 687, '\p{^Blk=IPA-Extensions}', "");
Expect(0, 687, '\P{Blk=IPA-Extensions}', "");
Expect(1, 687, '\P{^Blk=IPA-Extensions}', "");
Expect(0, 591, '\p{Blk=IPA-Extensions}', "");
Expect(1, 591, '\p{^Blk=IPA-Extensions}', "");
Expect(1, 591, '\P{Blk=IPA-Extensions}', "");
Expect(0, 591, '\P{^Blk=IPA-Extensions}', "");
Error('\p{Is_Block=:= ipa	EXTENSIONS}');
Error('\P{Is_Block=:= ipa	EXTENSIONS}');
Expect(1, 687, '\p{Is_Block=ipaextensions}', "");
Expect(0, 687, '\p{^Is_Block=ipaextensions}', "");
Expect(0, 687, '\P{Is_Block=ipaextensions}', "");
Expect(1, 687, '\P{^Is_Block=ipaextensions}', "");
Expect(0, 591, '\p{Is_Block=ipaextensions}', "");
Expect(1, 591, '\p{^Is_Block=ipaextensions}', "");
Expect(1, 591, '\P{Is_Block=ipaextensions}', "");
Expect(0, 591, '\P{^Is_Block=ipaextensions}', "");
Expect(1, 687, '\p{Is_Block=_IPA_Extensions}', "");
Expect(0, 687, '\p{^Is_Block=_IPA_Extensions}', "");
Expect(0, 687, '\P{Is_Block=_IPA_Extensions}', "");
Expect(1, 687, '\P{^Is_Block=_IPA_Extensions}', "");
Expect(0, 591, '\p{Is_Block=_IPA_Extensions}', "");
Expect(1, 591, '\p{^Is_Block=_IPA_Extensions}', "");
Expect(1, 591, '\P{Is_Block=_IPA_Extensions}', "");
Expect(0, 591, '\P{^Is_Block=_IPA_Extensions}', "");
Error('\p{Is_Blk=:=IPAExtensions}');
Error('\P{Is_Blk=:=IPAExtensions}');
Expect(1, 687, '\p{Is_Blk=ipaextensions}', "");
Expect(0, 687, '\p{^Is_Blk=ipaextensions}', "");
Expect(0, 687, '\P{Is_Blk=ipaextensions}', "");
Expect(1, 687, '\P{^Is_Blk=ipaextensions}', "");
Expect(0, 591, '\p{Is_Blk=ipaextensions}', "");
Expect(1, 591, '\p{^Is_Blk=ipaextensions}', "");
Expect(1, 591, '\P{Is_Blk=ipaextensions}', "");
Expect(0, 591, '\P{^Is_Blk=ipaextensions}', "");
Expect(1, 687, '\p{Is_Blk:   	IPA extensions}', "");
Expect(0, 687, '\p{^Is_Blk:   	IPA extensions}', "");
Expect(0, 687, '\P{Is_Blk:   	IPA extensions}', "");
Expect(1, 687, '\P{^Is_Blk:   	IPA extensions}', "");
Expect(0, 591, '\p{Is_Blk:   	IPA extensions}', "");
Expect(1, 591, '\p{^Is_Blk:   	IPA extensions}', "");
Expect(1, 591, '\P{Is_Blk:   	IPA extensions}', "");
Expect(0, 591, '\P{^Is_Blk:   	IPA extensions}', "");
Error('\p{Block=  kannada:=}');
Error('\P{Block=  kannada:=}');
Expect(1, 3327, '\p{Block=kannada}', "");
Expect(0, 3327, '\p{^Block=kannada}', "");
Expect(0, 3327, '\P{Block=kannada}', "");
Expect(1, 3327, '\P{^Block=kannada}', "");
Expect(0, 3199, '\p{Block=kannada}', "");
Expect(1, 3199, '\p{^Block=kannada}', "");
Expect(1, 3199, '\P{Block=kannada}', "");
Expect(0, 3199, '\P{^Block=kannada}', "");
Expect(1, 3327, '\p{Block:   	_Kannada}', "");
Expect(0, 3327, '\p{^Block:   	_Kannada}', "");
Expect(0, 3327, '\P{Block:   	_Kannada}', "");
Expect(1, 3327, '\P{^Block:   	_Kannada}', "");
Expect(0, 3199, '\p{Block:   	_Kannada}', "");
Expect(1, 3199, '\p{^Block:   	_Kannada}', "");
Expect(1, 3199, '\P{Block:   	_Kannada}', "");
Expect(0, 3199, '\P{^Block:   	_Kannada}', "");
Error('\p{Blk=  kannada:=}');
Error('\P{Blk=  kannada:=}');
Expect(1, 3327, '\p{Blk=kannada}', "");
Expect(0, 3327, '\p{^Blk=kannada}', "");
Expect(0, 3327, '\P{Blk=kannada}', "");
Expect(1, 3327, '\P{^Blk=kannada}', "");
Expect(0, 3199, '\p{Blk=kannada}', "");
Expect(1, 3199, '\p{^Blk=kannada}', "");
Expect(1, 3199, '\P{Blk=kannada}', "");
Expect(0, 3199, '\P{^Blk=kannada}', "");
Expect(1, 3327, '\p{Blk=	Kannada}', "");
Expect(0, 3327, '\p{^Blk=	Kannada}', "");
Expect(0, 3327, '\P{Blk=	Kannada}', "");
Expect(1, 3327, '\P{^Blk=	Kannada}', "");
Expect(0, 3199, '\p{Blk=	Kannada}', "");
Expect(1, 3199, '\p{^Blk=	Kannada}', "");
Expect(1, 3199, '\P{Blk=	Kannada}', "");
Expect(0, 3199, '\P{^Blk=	Kannada}', "");
Error('\p{Is_Block=/a/- Kannada}');
Error('\P{Is_Block=/a/- Kannada}');
Expect(1, 3327, '\p{Is_Block=kannada}', "");
Expect(0, 3327, '\p{^Is_Block=kannada}', "");
Expect(0, 3327, '\P{Is_Block=kannada}', "");
Expect(1, 3327, '\P{^Is_Block=kannada}', "");
Expect(0, 3199, '\p{Is_Block=kannada}', "");
Expect(1, 3199, '\p{^Is_Block=kannada}', "");
Expect(1, 3199, '\P{Is_Block=kannada}', "");
Expect(0, 3199, '\P{^Is_Block=kannada}', "");
Expect(1, 3327, '\p{Is_Block= Kannada}', "");
Expect(0, 3327, '\p{^Is_Block= Kannada}', "");
Expect(0, 3327, '\P{Is_Block= Kannada}', "");
Expect(1, 3327, '\P{^Is_Block= Kannada}', "");
Expect(0, 3199, '\p{Is_Block= Kannada}', "");
Expect(1, 3199, '\p{^Is_Block= Kannada}', "");
Expect(1, 3199, '\P{Is_Block= Kannada}', "");
Expect(0, 3199, '\P{^Is_Block= Kannada}', "");
Error('\p{Is_Blk=_:=kannada}');
Error('\P{Is_Blk=_:=kannada}');
Expect(1, 3327, '\p{Is_Blk=kannada}', "");
Expect(0, 3327, '\p{^Is_Blk=kannada}', "");
Expect(0, 3327, '\P{Is_Blk=kannada}', "");
Expect(1, 3327, '\P{^Is_Blk=kannada}', "");
Expect(0, 3199, '\p{Is_Blk=kannada}', "");
Expect(1, 3199, '\p{^Is_Blk=kannada}', "");
Expect(1, 3199, '\P{Is_Blk=kannada}', "");
Expect(0, 3199, '\P{^Is_Blk=kannada}', "");
Expect(1, 3327, '\p{Is_Blk=	kannada}', "");
Expect(0, 3327, '\p{^Is_Blk=	kannada}', "");
Expect(0, 3327, '\P{Is_Blk=	kannada}', "");
Expect(1, 3327, '\P{^Is_Blk=	kannada}', "");
Expect(0, 3199, '\p{Is_Blk=	kannada}', "");
Expect(1, 3199, '\p{^Is_Blk=	kannada}', "");
Expect(1, 3199, '\P{Is_Blk=	kannada}', "");
Expect(0, 3199, '\P{^Is_Blk=	kannada}', "");
Error('\p{Block=:=	_latin_extended_Additional}');
Error('\P{Block=:=	_latin_extended_Additional}');
Expect(1, 7935, '\p{Block=latinextendedadditional}', "");
Expect(0, 7935, '\p{^Block=latinextendedadditional}', "");
Expect(0, 7935, '\P{Block=latinextendedadditional}', "");
Expect(1, 7935, '\P{^Block=latinextendedadditional}', "");
Expect(0, 7679, '\p{Block=latinextendedadditional}', "");
Expect(1, 7679, '\p{^Block=latinextendedadditional}', "");
Expect(1, 7679, '\P{Block=latinextendedadditional}', "");
Expect(0, 7679, '\P{^Block=latinextendedadditional}', "");
Expect(1, 7935, '\p{Block:	-Latin	EXTENDED_Additional}', "");
Expect(0, 7935, '\p{^Block:	-Latin	EXTENDED_Additional}', "");
Expect(0, 7935, '\P{Block:	-Latin	EXTENDED_Additional}', "");
Expect(1, 7935, '\P{^Block:	-Latin	EXTENDED_Additional}', "");
Expect(0, 7679, '\p{Block:	-Latin	EXTENDED_Additional}', "");
Expect(1, 7679, '\p{^Block:	-Latin	EXTENDED_Additional}', "");
Expect(1, 7679, '\P{Block:	-Latin	EXTENDED_Additional}', "");
Expect(0, 7679, '\P{^Block:	-Latin	EXTENDED_Additional}', "");
Error('\p{Blk=:=LATIN_extended_ADDITIONAL}');
Error('\P{Blk=:=LATIN_extended_ADDITIONAL}');
Expect(1, 7935, '\p{Blk=latinextendedadditional}', "");
Expect(0, 7935, '\p{^Blk=latinextendedadditional}', "");
Expect(0, 7935, '\P{Blk=latinextendedadditional}', "");
Expect(1, 7935, '\P{^Blk=latinextendedadditional}', "");
Expect(0, 7679, '\p{Blk=latinextendedadditional}', "");
Expect(1, 7679, '\p{^Blk=latinextendedadditional}', "");
Expect(1, 7679, '\P{Blk=latinextendedadditional}', "");
Expect(0, 7679, '\P{^Blk=latinextendedadditional}', "");
Expect(1, 7935, '\p{Blk=Latin	extended_Additional}', "");
Expect(0, 7935, '\p{^Blk=Latin	extended_Additional}', "");
Expect(0, 7935, '\P{Blk=Latin	extended_Additional}', "");
Expect(1, 7935, '\P{^Blk=Latin	extended_Additional}', "");
Expect(0, 7679, '\p{Blk=Latin	extended_Additional}', "");
Expect(1, 7679, '\p{^Blk=Latin	extended_Additional}', "");
Expect(1, 7679, '\P{Blk=Latin	extended_Additional}', "");
Expect(0, 7679, '\P{^Blk=Latin	extended_Additional}', "");
Error('\p{Is_Block: _	latin/a/EXTENDED-additional}');
Error('\P{Is_Block: _	latin/a/EXTENDED-additional}');
Expect(1, 7935, '\p{Is_Block=latinextendedadditional}', "");
Expect(0, 7935, '\p{^Is_Block=latinextendedadditional}', "");
Expect(0, 7935, '\P{Is_Block=latinextendedadditional}', "");
Expect(1, 7935, '\P{^Is_Block=latinextendedadditional}', "");
Expect(0, 7679, '\p{Is_Block=latinextendedadditional}', "");
Expect(1, 7679, '\p{^Is_Block=latinextendedadditional}', "");
Expect(1, 7679, '\P{Is_Block=latinextendedadditional}', "");
Expect(0, 7679, '\P{^Is_Block=latinextendedadditional}', "");
Expect(1, 7935, '\p{Is_Block=	Latin-Extended_ADDITIONAL}', "");
Expect(0, 7935, '\p{^Is_Block=	Latin-Extended_ADDITIONAL}', "");
Expect(0, 7935, '\P{Is_Block=	Latin-Extended_ADDITIONAL}', "");
Expect(1, 7935, '\P{^Is_Block=	Latin-Extended_ADDITIONAL}', "");
Expect(0, 7679, '\p{Is_Block=	Latin-Extended_ADDITIONAL}', "");
Expect(1, 7679, '\p{^Is_Block=	Latin-Extended_ADDITIONAL}', "");
Expect(1, 7679, '\P{Is_Block=	Latin-Extended_ADDITIONAL}', "");
Expect(0, 7679, '\P{^Is_Block=	Latin-Extended_ADDITIONAL}', "");
Error('\p{Is_Blk=_-Latin_Extended-Additional/a/}');
Error('\P{Is_Blk=_-Latin_Extended-Additional/a/}');
Expect(1, 7935, '\p{Is_Blk=latinextendedadditional}', "");
Expect(0, 7935, '\p{^Is_Blk=latinextendedadditional}', "");
Expect(0, 7935, '\P{Is_Blk=latinextendedadditional}', "");
Expect(1, 7935, '\P{^Is_Blk=latinextendedadditional}', "");
Expect(0, 7679, '\p{Is_Blk=latinextendedadditional}', "");
Expect(1, 7679, '\p{^Is_Blk=latinextendedadditional}', "");
Expect(1, 7679, '\P{Is_Blk=latinextendedadditional}', "");
Expect(0, 7679, '\P{^Is_Blk=latinextendedadditional}', "");
Expect(1, 7935, '\p{Is_Blk=  latin	ExtendedAdditional}', "");
Expect(0, 7935, '\p{^Is_Blk=  latin	ExtendedAdditional}', "");
Expect(0, 7935, '\P{Is_Blk=  latin	ExtendedAdditional}', "");
Expect(1, 7935, '\P{^Is_Blk=  latin	ExtendedAdditional}', "");
Expect(0, 7679, '\p{Is_Blk=  latin	ExtendedAdditional}', "");
Expect(1, 7679, '\p{^Is_Blk=  latin	ExtendedAdditional}', "");
Expect(1, 7679, '\P{Is_Blk=  latin	ExtendedAdditional}', "");
Expect(0, 7679, '\P{^Is_Blk=  latin	ExtendedAdditional}', "");
Error('\p{Block=/a/-Cham}');
Error('\P{Block=/a/-Cham}');
Expect(1, 43615, '\p{Block=cham}', "");
Expect(0, 43615, '\p{^Block=cham}', "");
Expect(0, 43615, '\P{Block=cham}', "");
Expect(1, 43615, '\P{^Block=cham}', "");
Expect(0, 43519, '\p{Block=cham}', "");
Expect(1, 43519, '\p{^Block=cham}', "");
Expect(1, 43519, '\P{Block=cham}', "");
Expect(0, 43519, '\P{^Block=cham}', "");
Expect(1, 43615, '\p{Block=  CHAM}', "");
Expect(0, 43615, '\p{^Block=  CHAM}', "");
Expect(0, 43615, '\P{Block=  CHAM}', "");
Expect(1, 43615, '\P{^Block=  CHAM}', "");
Expect(0, 43519, '\p{Block=  CHAM}', "");
Expect(1, 43519, '\p{^Block=  CHAM}', "");
Expect(1, 43519, '\P{Block=  CHAM}', "");
Expect(0, 43519, '\P{^Block=  CHAM}', "");
Error('\p{Blk=_-cham/a/}');
Error('\P{Blk=_-cham/a/}');
Expect(1, 43615, '\p{Blk: cham}', "");
Expect(0, 43615, '\p{^Blk: cham}', "");
Expect(0, 43615, '\P{Blk: cham}', "");
Expect(1, 43615, '\P{^Blk: cham}', "");
Expect(0, 43519, '\p{Blk: cham}', "");
Expect(1, 43519, '\p{^Blk: cham}', "");
Expect(1, 43519, '\P{Blk: cham}', "");
Expect(0, 43519, '\P{^Blk: cham}', "");
Expect(1, 43615, '\p{Blk= 	Cham}', "");
Expect(0, 43615, '\p{^Blk= 	Cham}', "");
Expect(0, 43615, '\P{Blk= 	Cham}', "");
Expect(1, 43615, '\P{^Blk= 	Cham}', "");
Expect(0, 43519, '\p{Blk= 	Cham}', "");
Expect(1, 43519, '\p{^Blk= 	Cham}', "");
Expect(1, 43519, '\P{Blk= 	Cham}', "");
Expect(0, 43519, '\P{^Blk= 	Cham}', "");
Error('\p{Is_Block=:=__Cham}');
Error('\P{Is_Block=:=__Cham}');
Expect(1, 43615, '\p{Is_Block=cham}', "");
Expect(0, 43615, '\p{^Is_Block=cham}', "");
Expect(0, 43615, '\P{Is_Block=cham}', "");
Expect(1, 43615, '\P{^Is_Block=cham}', "");
Expect(0, 43519, '\p{Is_Block=cham}', "");
Expect(1, 43519, '\p{^Is_Block=cham}', "");
Expect(1, 43519, '\P{Is_Block=cham}', "");
Expect(0, 43519, '\P{^Is_Block=cham}', "");
Expect(1, 43615, '\p{Is_Block= 	Cham}', "");
Expect(0, 43615, '\p{^Is_Block= 	Cham}', "");
Expect(0, 43615, '\P{Is_Block= 	Cham}', "");
Expect(1, 43615, '\P{^Is_Block= 	Cham}', "");
Expect(0, 43519, '\p{Is_Block= 	Cham}', "");
Expect(1, 43519, '\p{^Is_Block= 	Cham}', "");
Expect(1, 43519, '\P{Is_Block= 	Cham}', "");
Expect(0, 43519, '\P{^Is_Block= 	Cham}', "");
Error('\p{Is_Blk:   /a/_CHAM}');
Error('\P{Is_Blk:   /a/_CHAM}');
Expect(1, 43615, '\p{Is_Blk=cham}', "");
Expect(0, 43615, '\p{^Is_Blk=cham}', "");
Expect(0, 43615, '\P{Is_Blk=cham}', "");
Expect(1, 43615, '\P{^Is_Blk=cham}', "");
Expect(0, 43519, '\p{Is_Blk=cham}', "");
Expect(1, 43519, '\p{^Is_Blk=cham}', "");
Expect(1, 43519, '\P{Is_Blk=cham}', "");
Expect(0, 43519, '\P{^Is_Blk=cham}', "");
Expect(1, 43615, '\p{Is_Blk= Cham}', "");
Expect(0, 43615, '\p{^Is_Blk= Cham}', "");
Expect(0, 43615, '\P{Is_Blk= Cham}', "");
Expect(1, 43615, '\P{^Is_Blk= Cham}', "");
Expect(0, 43519, '\p{Is_Blk= Cham}', "");
Expect(1, 43519, '\p{^Is_Blk= Cham}', "");
Expect(1, 43519, '\P{Is_Blk= Cham}', "");
Expect(0, 43519, '\P{^Is_Blk= Cham}', "");
Error('\p{Block=_:=Cyrillic-supplement}');
Error('\P{Block=_:=Cyrillic-supplement}');
Expect(1, 1327, '\p{Block=cyrillicsupplement}', "");
Expect(0, 1327, '\p{^Block=cyrillicsupplement}', "");
Expect(0, 1327, '\P{Block=cyrillicsupplement}', "");
Expect(1, 1327, '\P{^Block=cyrillicsupplement}', "");
Expect(0, 1279, '\p{Block=cyrillicsupplement}', "");
Expect(1, 1279, '\p{^Block=cyrillicsupplement}', "");
Expect(1, 1279, '\P{Block=cyrillicsupplement}', "");
Expect(0, 1279, '\P{^Block=cyrillicsupplement}', "");
Expect(1, 1327, '\p{Block:	-_CYRILLIC	Supplement}', "");
Expect(0, 1327, '\p{^Block:	-_CYRILLIC	Supplement}', "");
Expect(0, 1327, '\P{Block:	-_CYRILLIC	Supplement}', "");
Expect(1, 1327, '\P{^Block:	-_CYRILLIC	Supplement}', "");
Expect(0, 1279, '\p{Block:	-_CYRILLIC	Supplement}', "");
Expect(1, 1279, '\p{^Block:	-_CYRILLIC	Supplement}', "");
Expect(1, 1279, '\P{Block:	-_CYRILLIC	Supplement}', "");
Expect(0, 1279, '\P{^Block:	-_CYRILLIC	Supplement}', "");
Error('\p{Blk=:= CYRILLIC-SUPPLEMENTARY}');
Error('\P{Blk=:= CYRILLIC-SUPPLEMENTARY}');
Expect(1, 1327, '\p{Blk=cyrillicsupplementary}', "");
Expect(0, 1327, '\p{^Blk=cyrillicsupplementary}', "");
Expect(0, 1327, '\P{Blk=cyrillicsupplementary}', "");
Expect(1, 1327, '\P{^Blk=cyrillicsupplementary}', "");
Expect(0, 1279, '\p{Blk=cyrillicsupplementary}', "");
Expect(1, 1279, '\p{^Blk=cyrillicsupplementary}', "");
Expect(1, 1279, '\P{Blk=cyrillicsupplementary}', "");
Expect(0, 1279, '\P{^Blk=cyrillicsupplementary}', "");
Expect(1, 1327, '\p{Blk=--CYRILLIC supplementary}', "");
Expect(0, 1327, '\p{^Blk=--CYRILLIC supplementary}', "");
Expect(0, 1327, '\P{Blk=--CYRILLIC supplementary}', "");
Expect(1, 1327, '\P{^Blk=--CYRILLIC supplementary}', "");
Expect(0, 1279, '\p{Blk=--CYRILLIC supplementary}', "");
Expect(1, 1279, '\p{^Blk=--CYRILLIC supplementary}', "");
Expect(1, 1279, '\P{Blk=--CYRILLIC supplementary}', "");
Expect(0, 1279, '\P{^Blk=--CYRILLIC supplementary}', "");
Error('\p{Is_Block=:=	-CYRILLIC-Supplement}');
Error('\P{Is_Block=:=	-CYRILLIC-Supplement}');
Expect(1, 1327, '\p{Is_Block=cyrillicsupplement}', "");
Expect(0, 1327, '\p{^Is_Block=cyrillicsupplement}', "");
Expect(0, 1327, '\P{Is_Block=cyrillicsupplement}', "");
Expect(1, 1327, '\P{^Is_Block=cyrillicsupplement}', "");
Expect(0, 1279, '\p{Is_Block=cyrillicsupplement}', "");
Expect(1, 1279, '\p{^Is_Block=cyrillicsupplement}', "");
Expect(1, 1279, '\P{Is_Block=cyrillicsupplement}', "");
Expect(0, 1279, '\P{^Is_Block=cyrillicsupplement}', "");
Expect(1, 1327, '\p{Is_Block= Cyrillic	supplement}', "");
Expect(0, 1327, '\p{^Is_Block= Cyrillic	supplement}', "");
Expect(0, 1327, '\P{Is_Block= Cyrillic	supplement}', "");
Expect(1, 1327, '\P{^Is_Block= Cyrillic	supplement}', "");
Expect(0, 1279, '\p{Is_Block= Cyrillic	supplement}', "");
Expect(1, 1279, '\p{^Is_Block= Cyrillic	supplement}', "");
Expect(1, 1279, '\P{Is_Block= Cyrillic	supplement}', "");
Expect(0, 1279, '\P{^Is_Block= Cyrillic	supplement}', "");
Error('\p{Is_Blk=/a/		CYRILLIC-supplementary}');
Error('\P{Is_Blk=/a/		CYRILLIC-supplementary}');
Expect(1, 1327, '\p{Is_Blk=cyrillicsupplementary}', "");
Expect(0, 1327, '\p{^Is_Blk=cyrillicsupplementary}', "");
Expect(0, 1327, '\P{Is_Blk=cyrillicsupplementary}', "");
Expect(1, 1327, '\P{^Is_Blk=cyrillicsupplementary}', "");
Expect(0, 1279, '\p{Is_Blk=cyrillicsupplementary}', "");
Expect(1, 1279, '\p{^Is_Blk=cyrillicsupplementary}', "");
Expect(1, 1279, '\P{Is_Blk=cyrillicsupplementary}', "");
Expect(0, 1279, '\P{^Is_Blk=cyrillicsupplementary}', "");
Expect(1, 1327, '\p{Is_Blk=-	Cyrillic Supplementary}', "");
Expect(0, 1327, '\p{^Is_Blk=-	Cyrillic Supplementary}', "");
Expect(0, 1327, '\P{Is_Blk=-	Cyrillic Supplementary}', "");
Expect(1, 1327, '\P{^Is_Blk=-	Cyrillic Supplementary}', "");
Expect(0, 1279, '\p{Is_Blk=-	Cyrillic Supplementary}', "");
Expect(1, 1279, '\p{^Is_Blk=-	Cyrillic Supplementary}', "");
Expect(1, 1279, '\P{Is_Blk=-	Cyrillic Supplementary}', "");
Expect(0, 1279, '\P{^Is_Blk=-	Cyrillic Supplementary}', "");
Error('\p{Block=/a/greek andCOPTIC}');
Error('\P{Block=/a/greek andCOPTIC}');
Expect(1, 1023, '\p{Block: greekandcoptic}', "");
Expect(0, 1023, '\p{^Block: greekandcoptic}', "");
Expect(0, 1023, '\P{Block: greekandcoptic}', "");
Expect(1, 1023, '\P{^Block: greekandcoptic}', "");
Expect(0, 879, '\p{Block: greekandcoptic}', "");
Expect(1, 879, '\p{^Block: greekandcoptic}', "");
Expect(1, 879, '\P{Block: greekandcoptic}', "");
Expect(0, 879, '\P{^Block: greekandcoptic}', "");
Expect(1, 1023, '\p{Block=-Greek_And	coptic}', "");
Expect(0, 1023, '\p{^Block=-Greek_And	coptic}', "");
Expect(0, 1023, '\P{Block=-Greek_And	coptic}', "");
Expect(1, 1023, '\P{^Block=-Greek_And	coptic}', "");
Expect(0, 879, '\p{Block=-Greek_And	coptic}', "");
Expect(1, 879, '\p{^Block=-Greek_And	coptic}', "");
Expect(1, 879, '\P{Block=-Greek_And	coptic}', "");
Expect(0, 879, '\P{^Block=-Greek_And	coptic}', "");
Error('\p{Blk=-:=Greek}');
Error('\P{Blk=-:=Greek}');
Expect(1, 1023, '\p{Blk=greek}', "");
Expect(0, 1023, '\p{^Blk=greek}', "");
Expect(0, 1023, '\P{Blk=greek}', "");
Expect(1, 1023, '\P{^Blk=greek}', "");
Expect(0, 879, '\p{Blk=greek}', "");
Expect(1, 879, '\p{^Blk=greek}', "");
Expect(1, 879, '\P{Blk=greek}', "");
Expect(0, 879, '\P{^Blk=greek}', "");
Expect(1, 1023, '\p{Blk=_	greek}', "");
Expect(0, 1023, '\p{^Blk=_	greek}', "");
Expect(0, 1023, '\P{Blk=_	greek}', "");
Expect(1, 1023, '\P{^Blk=_	greek}', "");
Expect(0, 879, '\p{Blk=_	greek}', "");
Expect(1, 879, '\p{^Blk=_	greek}', "");
Expect(1, 879, '\P{Blk=_	greek}', "");
Expect(0, 879, '\P{^Blk=_	greek}', "");
Error('\p{Is_Block:   Greek:=And-Coptic}');
Error('\P{Is_Block:   Greek:=And-Coptic}');
Expect(1, 1023, '\p{Is_Block=greekandcoptic}', "");
Expect(0, 1023, '\p{^Is_Block=greekandcoptic}', "");
Expect(0, 1023, '\P{Is_Block=greekandcoptic}', "");
Expect(1, 1023, '\P{^Is_Block=greekandcoptic}', "");
Expect(0, 879, '\p{Is_Block=greekandcoptic}', "");
Expect(1, 879, '\p{^Is_Block=greekandcoptic}', "");
Expect(1, 879, '\P{Is_Block=greekandcoptic}', "");
Expect(0, 879, '\P{^Is_Block=greekandcoptic}', "");
Expect(1, 1023, '\p{Is_Block=- greekand_coptic}', "");
Expect(0, 1023, '\p{^Is_Block=- greekand_coptic}', "");
Expect(0, 1023, '\P{Is_Block=- greekand_coptic}', "");
Expect(1, 1023, '\P{^Is_Block=- greekand_coptic}', "");
Expect(0, 879, '\p{Is_Block=- greekand_coptic}', "");
Expect(1, 879, '\p{^Is_Block=- greekand_coptic}', "");
Expect(1, 879, '\P{Is_Block=- greekand_coptic}', "");
Expect(0, 879, '\P{^Is_Block=- greekand_coptic}', "");
Error('\p{Is_Blk= 	GREEK/a/}');
Error('\P{Is_Blk= 	GREEK/a/}');
Expect(1, 1023, '\p{Is_Blk=greek}', "");
Expect(0, 1023, '\p{^Is_Blk=greek}', "");
Expect(0, 1023, '\P{Is_Blk=greek}', "");
Expect(1, 1023, '\P{^Is_Blk=greek}', "");
Expect(0, 879, '\p{Is_Blk=greek}', "");
Expect(1, 879, '\p{^Is_Blk=greek}', "");
Expect(1, 879, '\P{Is_Blk=greek}', "");
Expect(0, 879, '\P{^Is_Blk=greek}', "");
Expect(1, 1023, '\p{Is_Blk=- GREEK}', "");
Expect(0, 1023, '\p{^Is_Blk=- GREEK}', "");
Expect(0, 1023, '\P{Is_Blk=- GREEK}', "");
Expect(1, 1023, '\P{^Is_Blk=- GREEK}', "");
Expect(0, 879, '\p{Is_Blk=- GREEK}', "");
Expect(1, 879, '\p{^Is_Blk=- GREEK}', "");
Expect(1, 879, '\P{Is_Blk=- GREEK}', "");
Expect(0, 879, '\P{^Is_Blk=- GREEK}', "");
Error('\p{Block=- MISCELLANEOUS:=Mathematical Symbols_B}');
Error('\P{Block=- MISCELLANEOUS:=Mathematical Symbols_B}');
Expect(1, 10751, '\p{Block=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10751, '\p{^Block=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10751, '\P{Block=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10751, '\P{^Block=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10623, '\p{Block=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10623, '\p{^Block=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10623, '\P{Block=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10623, '\P{^Block=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10751, '\p{Block=-	MiscellaneousMathematicalSymbolsB}', "");
Expect(0, 10751, '\p{^Block=-	MiscellaneousMathematicalSymbolsB}', "");
Expect(0, 10751, '\P{Block=-	MiscellaneousMathematicalSymbolsB}', "");
Expect(1, 10751, '\P{^Block=-	MiscellaneousMathematicalSymbolsB}', "");
Expect(0, 10623, '\p{Block=-	MiscellaneousMathematicalSymbolsB}', "");
Expect(1, 10623, '\p{^Block=-	MiscellaneousMathematicalSymbolsB}', "");
Expect(1, 10623, '\P{Block=-	MiscellaneousMathematicalSymbolsB}', "");
Expect(0, 10623, '\P{^Block=-	MiscellaneousMathematicalSymbolsB}', "");
Error('\p{Blk:-Miscellaneous-Mathematical_Symbols:=B}');
Error('\P{Blk:-Miscellaneous-Mathematical_Symbols:=B}');
Expect(1, 10751, '\p{Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10751, '\p{^Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10751, '\P{Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10751, '\P{^Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10623, '\p{Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10623, '\p{^Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10623, '\P{Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10623, '\P{^Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10751, '\p{Blk:   Miscellaneousmathematical_SYMBOLSB}', "");
Expect(0, 10751, '\p{^Blk:   Miscellaneousmathematical_SYMBOLSB}', "");
Expect(0, 10751, '\P{Blk:   Miscellaneousmathematical_SYMBOLSB}', "");
Expect(1, 10751, '\P{^Blk:   Miscellaneousmathematical_SYMBOLSB}', "");
Expect(0, 10623, '\p{Blk:   Miscellaneousmathematical_SYMBOLSB}', "");
Expect(1, 10623, '\p{^Blk:   Miscellaneousmathematical_SYMBOLSB}', "");
Expect(1, 10623, '\P{Blk:   Miscellaneousmathematical_SYMBOLSB}', "");
Expect(0, 10623, '\P{^Blk:   Miscellaneousmathematical_SYMBOLSB}', "");
Error('\p{Is_Block= _Miscellaneous:=MATHEMATICAL_SYMBOLS-B}');
Error('\P{Is_Block= _Miscellaneous:=MATHEMATICAL_SYMBOLS-B}');
Expect(1, 10751, '\p{Is_Block=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10751, '\p{^Is_Block=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10751, '\P{Is_Block=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10751, '\P{^Is_Block=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10623, '\p{Is_Block=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10623, '\p{^Is_Block=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10623, '\P{Is_Block=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10623, '\P{^Is_Block=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10751, '\p{Is_Block=	 Miscellaneous MathematicalSymbols-B}', "");
Expect(0, 10751, '\p{^Is_Block=	 Miscellaneous MathematicalSymbols-B}', "");
Expect(0, 10751, '\P{Is_Block=	 Miscellaneous MathematicalSymbols-B}', "");
Expect(1, 10751, '\P{^Is_Block=	 Miscellaneous MathematicalSymbols-B}', "");
Expect(0, 10623, '\p{Is_Block=	 Miscellaneous MathematicalSymbols-B}', "");
Expect(1, 10623, '\p{^Is_Block=	 Miscellaneous MathematicalSymbols-B}', "");
Expect(1, 10623, '\P{Is_Block=	 Miscellaneous MathematicalSymbols-B}', "");
Expect(0, 10623, '\P{^Is_Block=	 Miscellaneous MathematicalSymbols-B}', "");
Error('\p{Is_Blk=/a/miscellaneous	mathematical symbols_B}');
Error('\P{Is_Blk=/a/miscellaneous	mathematical symbols_B}');
Expect(1, 10751, '\p{Is_Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10751, '\p{^Is_Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10751, '\P{Is_Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10751, '\P{^Is_Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10623, '\p{Is_Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10623, '\p{^Is_Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10623, '\P{Is_Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(0, 10623, '\P{^Is_Blk=miscellaneousmathematicalsymbolsb}', "");
Expect(1, 10751, '\p{Is_Blk=	 MISCELLANEOUS_mathematicalSymbols B}', "");
Expect(0, 10751, '\p{^Is_Blk=	 MISCELLANEOUS_mathematicalSymbols B}', "");
Expect(0, 10751, '\P{Is_Blk=	 MISCELLANEOUS_mathematicalSymbols B}', "");
Expect(1, 10751, '\P{^Is_Blk=	 MISCELLANEOUS_mathematicalSymbols B}', "");
Expect(0, 10623, '\p{Is_Blk=	 MISCELLANEOUS_mathematicalSymbols B}', "");
Expect(1, 10623, '\p{^Is_Blk=	 MISCELLANEOUS_mathematicalSymbols B}', "");
Expect(1, 10623, '\P{Is_Blk=	 MISCELLANEOUS_mathematicalSymbols B}', "");
Expect(0, 10623, '\P{^Is_Blk=	 MISCELLANEOUS_mathematicalSymbols B}', "");
Error('\p{Block=	/a/Bengali}');
Error('\P{Block=	/a/Bengali}');
Expect(1, 2559, '\p{Block=bengali}', "");
Expect(0, 2559, '\p{^Block=bengali}', "");
Expect(0, 2559, '\P{Block=bengali}', "");
Expect(1, 2559, '\P{^Block=bengali}', "");
Expect(0, 2431, '\p{Block=bengali}', "");
Expect(1, 2431, '\p{^Block=bengali}', "");
Expect(1, 2431, '\P{Block=bengali}', "");
Expect(0, 2431, '\P{^Block=bengali}', "");
Expect(1, 2559, '\p{Block=		bengali}', "");
Expect(0, 2559, '\p{^Block=		bengali}', "");
Expect(0, 2559, '\P{Block=		bengali}', "");
Expect(1, 2559, '\P{^Block=		bengali}', "");
Expect(0, 2431, '\p{Block=		bengali}', "");
Expect(1, 2431, '\p{^Block=		bengali}', "");
Expect(1, 2431, '\P{Block=		bengali}', "");
Expect(0, 2431, '\P{^Block=		bengali}', "");
Error('\p{Blk=:=-_Bengali}');
Error('\P{Blk=:=-_Bengali}');
Expect(1, 2559, '\p{Blk=bengali}', "");
Expect(0, 2559, '\p{^Blk=bengali}', "");
Expect(0, 2559, '\P{Blk=bengali}', "");
Expect(1, 2559, '\P{^Blk=bengali}', "");
Expect(0, 2431, '\p{Blk=bengali}', "");
Expect(1, 2431, '\p{^Blk=bengali}', "");
Expect(1, 2431, '\P{Blk=bengali}', "");
Expect(0, 2431, '\P{^Blk=bengali}', "");
Expect(1, 2559, '\p{Blk=-Bengali}', "");
Expect(0, 2559, '\p{^Blk=-Bengali}', "");
Expect(0, 2559, '\P{Blk=-Bengali}', "");
Expect(1, 2559, '\P{^Blk=-Bengali}', "");
Expect(0, 2431, '\p{Blk=-Bengali}', "");
Expect(1, 2431, '\p{^Blk=-Bengali}', "");
Expect(1, 2431, '\P{Blk=-Bengali}', "");
Expect(0, 2431, '\P{^Blk=-Bengali}', "");
Error('\p{Is_Block:   :=_BENGALI}');
Error('\P{Is_Block:   :=_BENGALI}');
Expect(1, 2559, '\p{Is_Block=bengali}', "");
Expect(0, 2559, '\p{^Is_Block=bengali}', "");
Expect(0, 2559, '\P{Is_Block=bengali}', "");
Expect(1, 2559, '\P{^Is_Block=bengali}', "");
Expect(0, 2431, '\p{Is_Block=bengali}', "");
Expect(1, 2431, '\p{^Is_Block=bengali}', "");
Expect(1, 2431, '\P{Is_Block=bengali}', "");
Expect(0, 2431, '\P{^Is_Block=bengali}', "");
Expect(1, 2559, '\p{Is_Block=_BENGALI}', "");
Expect(0, 2559, '\p{^Is_Block=_BENGALI}', "");
Expect(0, 2559, '\P{Is_Block=_BENGALI}', "");
Expect(1, 2559, '\P{^Is_Block=_BENGALI}', "");
Expect(0, 2431, '\p{Is_Block=_BENGALI}', "");
Expect(1, 2431, '\p{^Is_Block=_BENGALI}', "");
Expect(1, 2431, '\P{Is_Block=_BENGALI}', "");
Expect(0, 2431, '\P{^Is_Block=_BENGALI}', "");
Error('\p{Is_Blk= :=Bengali}');
Error('\P{Is_Blk= :=Bengali}');
Expect(1, 2559, '\p{Is_Blk=bengali}', "");
Expect(0, 2559, '\p{^Is_Blk=bengali}', "");
Expect(0, 2559, '\P{Is_Blk=bengali}', "");
Expect(1, 2559, '\P{^Is_Blk=bengali}', "");
Expect(0, 2431, '\p{Is_Blk=bengali}', "");
Expect(1, 2431, '\p{^Is_Blk=bengali}', "");
Expect(1, 2431, '\P{Is_Blk=bengali}', "");
Expect(0, 2431, '\P{^Is_Blk=bengali}', "");
Expect(1, 2559, '\p{Is_Blk=		BENGALI}', "");
Expect(0, 2559, '\p{^Is_Blk=		BENGALI}', "");
Expect(0, 2559, '\P{Is_Blk=		BENGALI}', "");
Expect(1, 2559, '\P{^Is_Blk=		BENGALI}', "");
Expect(0, 2431, '\p{Is_Blk=		BENGALI}', "");
Expect(1, 2431, '\p{^Is_Blk=		BENGALI}', "");
Expect(1, 2431, '\P{Is_Blk=		BENGALI}', "");
Expect(0, 2431, '\P{^Is_Blk=		BENGALI}', "");
Error('\p{Block= Cypriot/a/Syllabary}');
Error('\P{Block= Cypriot/a/Syllabary}');
Expect(1, 67647, '\p{Block=cypriotsyllabary}', "");
Expect(0, 67647, '\p{^Block=cypriotsyllabary}', "");
Expect(0, 67647, '\P{Block=cypriotsyllabary}', "");
Expect(1, 67647, '\P{^Block=cypriotsyllabary}', "");
Expect(0, 67583, '\p{Block=cypriotsyllabary}', "");
Expect(1, 67583, '\p{^Block=cypriotsyllabary}', "");
Expect(1, 67583, '\P{Block=cypriotsyllabary}', "");
Expect(0, 67583, '\P{^Block=cypriotsyllabary}', "");
Expect(1, 67647, '\p{Block=CYPRIOT Syllabary}', "");
Expect(0, 67647, '\p{^Block=CYPRIOT Syllabary}', "");
Expect(0, 67647, '\P{Block=CYPRIOT Syllabary}', "");
Expect(1, 67647, '\P{^Block=CYPRIOT Syllabary}', "");
Expect(0, 67583, '\p{Block=CYPRIOT Syllabary}', "");
Expect(1, 67583, '\p{^Block=CYPRIOT Syllabary}', "");
Expect(1, 67583, '\P{Block=CYPRIOT Syllabary}', "");
Expect(0, 67583, '\P{^Block=CYPRIOT Syllabary}', "");
Error('\p{Blk=-/a/cypriot-Syllabary}');
Error('\P{Blk=-/a/cypriot-Syllabary}');
Expect(1, 67647, '\p{Blk=cypriotsyllabary}', "");
Expect(0, 67647, '\p{^Blk=cypriotsyllabary}', "");
Expect(0, 67647, '\P{Blk=cypriotsyllabary}', "");
Expect(1, 67647, '\P{^Blk=cypriotsyllabary}', "");
Expect(0, 67583, '\p{Blk=cypriotsyllabary}', "");
Expect(1, 67583, '\p{^Blk=cypriotsyllabary}', "");
Expect(1, 67583, '\P{Blk=cypriotsyllabary}', "");
Expect(0, 67583, '\P{^Blk=cypriotsyllabary}', "");
Expect(1, 67647, '\p{Blk=	CYPRIOTSYLLABARY}', "");
Expect(0, 67647, '\p{^Blk=	CYPRIOTSYLLABARY}', "");
Expect(0, 67647, '\P{Blk=	CYPRIOTSYLLABARY}', "");
Expect(1, 67647, '\P{^Blk=	CYPRIOTSYLLABARY}', "");
Expect(0, 67583, '\p{Blk=	CYPRIOTSYLLABARY}', "");
Expect(1, 67583, '\p{^Blk=	CYPRIOTSYLLABARY}', "");
Expect(1, 67583, '\P{Blk=	CYPRIOTSYLLABARY}', "");
Expect(0, 67583, '\P{^Blk=	CYPRIOTSYLLABARY}', "");
Error('\p{Is_Block=_:=CypriotSyllabary}');
Error('\P{Is_Block=_:=CypriotSyllabary}');
Expect(1, 67647, '\p{Is_Block=cypriotsyllabary}', "");
Expect(0, 67647, '\p{^Is_Block=cypriotsyllabary}', "");
Expect(0, 67647, '\P{Is_Block=cypriotsyllabary}', "");
Expect(1, 67647, '\P{^Is_Block=cypriotsyllabary}', "");
Expect(0, 67583, '\p{Is_Block=cypriotsyllabary}', "");
Expect(1, 67583, '\p{^Is_Block=cypriotsyllabary}', "");
Expect(1, 67583, '\P{Is_Block=cypriotsyllabary}', "");
Expect(0, 67583, '\P{^Is_Block=cypriotsyllabary}', "");
Expect(1, 67647, '\p{Is_Block:   _CYPRIOTSYLLABARY}', "");
Expect(0, 67647, '\p{^Is_Block:   _CYPRIOTSYLLABARY}', "");
Expect(0, 67647, '\P{Is_Block:   _CYPRIOTSYLLABARY}', "");
Expect(1, 67647, '\P{^Is_Block:   _CYPRIOTSYLLABARY}', "");
Expect(0, 67583, '\p{Is_Block:   _CYPRIOTSYLLABARY}', "");
Expect(1, 67583, '\p{^Is_Block:   _CYPRIOTSYLLABARY}', "");
Expect(1, 67583, '\P{Is_Block:   _CYPRIOTSYLLABARY}', "");
Expect(0, 67583, '\P{^Is_Block:   _CYPRIOTSYLLABARY}', "");
Error('\p{Is_Blk=_/a/Cypriot_Syllabary}');
Error('\P{Is_Blk=_/a/Cypriot_Syllabary}');
Expect(1, 67647, '\p{Is_Blk=cypriotsyllabary}', "");
Expect(0, 67647, '\p{^Is_Blk=cypriotsyllabary}', "");
Expect(0, 67647, '\P{Is_Blk=cypriotsyllabary}', "");
Expect(1, 67647, '\P{^Is_Blk=cypriotsyllabary}', "");
Expect(0, 67583, '\p{Is_Blk=cypriotsyllabary}', "");
Expect(1, 67583, '\p{^Is_Blk=cypriotsyllabary}', "");
Expect(1, 67583, '\P{Is_Blk=cypriotsyllabary}', "");
Expect(0, 67583, '\P{^Is_Blk=cypriotsyllabary}', "");
Expect(1, 67647, '\p{Is_Blk=	-CypriotSyllabary}', "");
Expect(0, 67647, '\p{^Is_Blk=	-CypriotSyllabary}', "");
Expect(0, 67647, '\P{Is_Blk=	-CypriotSyllabary}', "");
Expect(1, 67647, '\P{^Is_Blk=	-CypriotSyllabary}', "");
Expect(0, 67583, '\p{Is_Blk=	-CypriotSyllabary}', "");
Expect(1, 67583, '\p{^Is_Blk=	-CypriotSyllabary}', "");
Expect(1, 67583, '\P{Is_Blk=	-CypriotSyllabary}', "");
Expect(0, 67583, '\P{^Is_Blk=	-CypriotSyllabary}', "");
Error('\p{Block=	/a/SUPPLEMENTAL-Punctuation}');
Error('\P{Block=	/a/SUPPLEMENTAL-Punctuation}');
Expect(1, 11903, '\p{Block=supplementalpunctuation}', "");
Expect(0, 11903, '\p{^Block=supplementalpunctuation}', "");
Expect(0, 11903, '\P{Block=supplementalpunctuation}', "");
Expect(1, 11903, '\P{^Block=supplementalpunctuation}', "");
Expect(0, 11775, '\p{Block=supplementalpunctuation}', "");
Expect(1, 11775, '\p{^Block=supplementalpunctuation}', "");
Expect(1, 11775, '\P{Block=supplementalpunctuation}', "");
Expect(0, 11775, '\P{^Block=supplementalpunctuation}', "");
Expect(1, 11903, '\p{Block=_SUPPLEMENTAL Punctuation}', "");
Expect(0, 11903, '\p{^Block=_SUPPLEMENTAL Punctuation}', "");
Expect(0, 11903, '\P{Block=_SUPPLEMENTAL Punctuation}', "");
Expect(1, 11903, '\P{^Block=_SUPPLEMENTAL Punctuation}', "");
Expect(0, 11775, '\p{Block=_SUPPLEMENTAL Punctuation}', "");
Expect(1, 11775, '\p{^Block=_SUPPLEMENTAL Punctuation}', "");
Expect(1, 11775, '\P{Block=_SUPPLEMENTAL Punctuation}', "");
Expect(0, 11775, '\P{^Block=_SUPPLEMENTAL Punctuation}', "");
Error('\p{Blk= supplemental-PUNCTUATION/a/}');
Error('\P{Blk= supplemental-PUNCTUATION/a/}');
Expect(1, 11903, '\p{Blk=supplementalpunctuation}', "");
Expect(0, 11903, '\p{^Blk=supplementalpunctuation}', "");
Expect(0, 11903, '\P{Blk=supplementalpunctuation}', "");
Expect(1, 11903, '\P{^Blk=supplementalpunctuation}', "");
Expect(0, 11775, '\p{Blk=supplementalpunctuation}', "");
Expect(1, 11775, '\p{^Blk=supplementalpunctuation}', "");
Expect(1, 11775, '\P{Blk=supplementalpunctuation}', "");
Expect(0, 11775, '\P{^Blk=supplementalpunctuation}', "");
Expect(1, 11903, '\p{Blk=-supplementalPUNCTUATION}', "");
Expect(0, 11903, '\p{^Blk=-supplementalPUNCTUATION}', "");
Expect(0, 11903, '\P{Blk=-supplementalPUNCTUATION}', "");
Expect(1, 11903, '\P{^Blk=-supplementalPUNCTUATION}', "");
Expect(0, 11775, '\p{Blk=-supplementalPUNCTUATION}', "");
Expect(1, 11775, '\p{^Blk=-supplementalPUNCTUATION}', "");
Expect(1, 11775, '\P{Blk=-supplementalPUNCTUATION}', "");
Expect(0, 11775, '\P{^Blk=-supplementalPUNCTUATION}', "");
Error('\p{Is_Block= :=supplemental_Punctuation}');
Error('\P{Is_Block= :=supplemental_Punctuation}');
Expect(1, 11903, '\p{Is_Block=supplementalpunctuation}', "");
Expect(0, 11903, '\p{^Is_Block=supplementalpunctuation}', "");
Expect(0, 11903, '\P{Is_Block=supplementalpunctuation}', "");
Expect(1, 11903, '\P{^Is_Block=supplementalpunctuation}', "");
Expect(0, 11775, '\p{Is_Block=supplementalpunctuation}', "");
Expect(1, 11775, '\p{^Is_Block=supplementalpunctuation}', "");
Expect(1, 11775, '\P{Is_Block=supplementalpunctuation}', "");
Expect(0, 11775, '\P{^Is_Block=supplementalpunctuation}', "");
Expect(1, 11903, '\p{Is_Block:		-supplemental Punctuation}', "");
Expect(0, 11903, '\p{^Is_Block:		-supplemental Punctuation}', "");
Expect(0, 11903, '\P{Is_Block:		-supplemental Punctuation}', "");
Expect(1, 11903, '\P{^Is_Block:		-supplemental Punctuation}', "");
Expect(0, 11775, '\p{Is_Block:		-supplemental Punctuation}', "");
Expect(1, 11775, '\p{^Is_Block:		-supplemental Punctuation}', "");
Expect(1, 11775, '\P{Is_Block:		-supplemental Punctuation}', "");
Expect(0, 11775, '\P{^Is_Block:		-supplemental Punctuation}', "");
Error('\p{Is_Blk=/a/-	Supplemental	Punctuation}');
Error('\P{Is_Blk=/a/-	Supplemental	Punctuation}');
Expect(1, 11903, '\p{Is_Blk: supplementalpunctuation}', "");
Expect(0, 11903, '\p{^Is_Blk: supplementalpunctuation}', "");
Expect(0, 11903, '\P{Is_Blk: supplementalpunctuation}', "");
Expect(1, 11903, '\P{^Is_Blk: supplementalpunctuation}', "");
Expect(0, 11775, '\p{Is_Blk: supplementalpunctuation}', "");
Expect(1, 11775, '\p{^Is_Blk: supplementalpunctuation}', "");
Expect(1, 11775, '\P{Is_Blk: supplementalpunctuation}', "");
Expect(0, 11775, '\P{^Is_Blk: supplementalpunctuation}', "");
Expect(1, 11903, '\p{Is_Blk= supplemental	PUNCTUATION}', "");
Expect(0, 11903, '\p{^Is_Blk= supplemental	PUNCTUATION}', "");
Expect(0, 11903, '\P{Is_Blk= supplemental	PUNCTUATION}', "");
Expect(1, 11903, '\P{^Is_Blk= supplemental	PUNCTUATION}', "");
Expect(0, 11775, '\p{Is_Blk= supplemental	PUNCTUATION}', "");
Expect(1, 11775, '\p{^Is_Blk= supplemental	PUNCTUATION}', "");
Expect(1, 11775, '\P{Is_Blk= supplemental	PUNCTUATION}', "");
Expect(0, 11775, '\P{^Is_Blk= supplemental	PUNCTUATION}', "");
Error('\p{Block=		Coptic:=}');
Error('\P{Block=		Coptic:=}');
Expect(1, 11519, '\p{Block=coptic}', "");
Expect(0, 11519, '\p{^Block=coptic}', "");
Expect(0, 11519, '\P{Block=coptic}', "");
Expect(1, 11519, '\P{^Block=coptic}', "");
Expect(0, 11391, '\p{Block=coptic}', "");
Expect(1, 11391, '\p{^Block=coptic}', "");
Expect(1, 11391, '\P{Block=coptic}', "");
Expect(0, 11391, '\P{^Block=coptic}', "");
Expect(1, 11519, '\p{Block= _COPTIC}', "");
Expect(0, 11519, '\p{^Block= _COPTIC}', "");
Expect(0, 11519, '\P{Block= _COPTIC}', "");
Expect(1, 11519, '\P{^Block= _COPTIC}', "");
Expect(0, 11391, '\p{Block= _COPTIC}', "");
Expect(1, 11391, '\p{^Block= _COPTIC}', "");
Expect(1, 11391, '\P{Block= _COPTIC}', "");
Expect(0, 11391, '\P{^Block= _COPTIC}', "");
Error('\p{Blk=/a/coptic}');
Error('\P{Blk=/a/coptic}');
Expect(1, 11519, '\p{Blk=coptic}', "");
Expect(0, 11519, '\p{^Blk=coptic}', "");
Expect(0, 11519, '\P{Blk=coptic}', "");
Expect(1, 11519, '\P{^Blk=coptic}', "");
Expect(0, 11391, '\p{Blk=coptic}', "");
Expect(1, 11391, '\p{^Blk=coptic}', "");
Expect(1, 11391, '\P{Blk=coptic}', "");
Expect(0, 11391, '\P{^Blk=coptic}', "");
Expect(1, 11519, '\p{Blk= Coptic}', "");
Expect(0, 11519, '\p{^Blk= Coptic}', "");
Expect(0, 11519, '\P{Blk= Coptic}', "");
Expect(1, 11519, '\P{^Blk= Coptic}', "");
Expect(0, 11391, '\p{Blk= Coptic}', "");
Expect(1, 11391, '\p{^Blk= Coptic}', "");
Expect(1, 11391, '\P{Blk= Coptic}', "");
Expect(0, 11391, '\P{^Blk= Coptic}', "");
Error('\p{Is_Block=_ Coptic:=}');
Error('\P{Is_Block=_ Coptic:=}');
Expect(1, 11519, '\p{Is_Block=coptic}', "");
Expect(0, 11519, '\p{^Is_Block=coptic}', "");
Expect(0, 11519, '\P{Is_Block=coptic}', "");
Expect(1, 11519, '\P{^Is_Block=coptic}', "");
Expect(0, 11391, '\p{Is_Block=coptic}', "");
Expect(1, 11391, '\p{^Is_Block=coptic}', "");
Expect(1, 11391, '\P{Is_Block=coptic}', "");
Expect(0, 11391, '\P{^Is_Block=coptic}', "");
Expect(1, 11519, '\p{Is_Block= 	COPTIC}', "");
Expect(0, 11519, '\p{^Is_Block= 	COPTIC}', "");
Expect(0, 11519, '\P{Is_Block= 	COPTIC}', "");
Expect(1, 11519, '\P{^Is_Block= 	COPTIC}', "");
Expect(0, 11391, '\p{Is_Block= 	COPTIC}', "");
Expect(1, 11391, '\p{^Is_Block= 	COPTIC}', "");
Expect(1, 11391, '\P{Is_Block= 	COPTIC}', "");
Expect(0, 11391, '\P{^Is_Block= 	COPTIC}', "");
Error('\p{Is_Blk=_:=Coptic}');
Error('\P{Is_Blk=_:=Coptic}');
Expect(1, 11519, '\p{Is_Blk=coptic}', "");
Expect(0, 11519, '\p{^Is_Blk=coptic}', "");
Expect(0, 11519, '\P{Is_Blk=coptic}', "");
Expect(1, 11519, '\P{^Is_Blk=coptic}', "");
Expect(0, 11391, '\p{Is_Blk=coptic}', "");
Expect(1, 11391, '\p{^Is_Blk=coptic}', "");
Expect(1, 11391, '\P{Is_Blk=coptic}', "");
Expect(0, 11391, '\P{^Is_Blk=coptic}', "");
Expect(1, 11519, '\p{Is_Blk=	Coptic}', "");
Expect(0, 11519, '\p{^Is_Blk=	Coptic}', "");
Expect(0, 11519, '\P{Is_Blk=	Coptic}', "");
Expect(1, 11519, '\P{^Is_Blk=	Coptic}', "");
Expect(0, 11391, '\p{Is_Blk=	Coptic}', "");
Expect(1, 11391, '\p{^Is_Blk=	Coptic}', "");
Expect(1, 11391, '\P{Is_Blk=	Coptic}', "");
Expect(0, 11391, '\P{^Is_Blk=	Coptic}', "");
Error('\p{Block=_-SUPPLEMENTAL ARROWS:=B}');
Error('\P{Block=_-SUPPLEMENTAL ARROWS:=B}');
Expect(1, 10623, '\p{Block=supplementalarrowsb}', "");
Expect(0, 10623, '\p{^Block=supplementalarrowsb}', "");
Expect(0, 10623, '\P{Block=supplementalarrowsb}', "");
Expect(1, 10623, '\P{^Block=supplementalarrowsb}', "");
Expect(0, 10495, '\p{Block=supplementalarrowsb}', "");
Expect(1, 10495, '\p{^Block=supplementalarrowsb}', "");
Expect(1, 10495, '\P{Block=supplementalarrowsb}', "");
Expect(0, 10495, '\P{^Block=supplementalarrowsb}', "");
Expect(1, 10623, '\p{Block=Supplementalarrows	B}', "");
Expect(0, 10623, '\p{^Block=Supplementalarrows	B}', "");
Expect(0, 10623, '\P{Block=Supplementalarrows	B}', "");
Expect(1, 10623, '\P{^Block=Supplementalarrows	B}', "");
Expect(0, 10495, '\p{Block=Supplementalarrows	B}', "");
Expect(1, 10495, '\p{^Block=Supplementalarrows	B}', "");
Expect(1, 10495, '\P{Block=Supplementalarrows	B}', "");
Expect(0, 10495, '\P{^Block=Supplementalarrows	B}', "");
Error('\p{Blk=-:=Supplemental ARROWSB}');
Error('\P{Blk=-:=Supplemental ARROWSB}');
Expect(1, 10623, '\p{Blk=supplementalarrowsb}', "");
Expect(0, 10623, '\p{^Blk=supplementalarrowsb}', "");
Expect(0, 10623, '\P{Blk=supplementalarrowsb}', "");
Expect(1, 10623, '\P{^Blk=supplementalarrowsb}', "");
Expect(0, 10495, '\p{Blk=supplementalarrowsb}', "");
Expect(1, 10495, '\p{^Blk=supplementalarrowsb}', "");
Expect(1, 10495, '\P{Blk=supplementalarrowsb}', "");
Expect(0, 10495, '\P{^Blk=supplementalarrowsb}', "");
Expect(1, 10623, '\p{Blk= SUPPLEMENTAL_Arrows	B}', "");
Expect(0, 10623, '\p{^Blk= SUPPLEMENTAL_Arrows	B}', "");
Expect(0, 10623, '\P{Blk= SUPPLEMENTAL_Arrows	B}', "");
Expect(1, 10623, '\P{^Blk= SUPPLEMENTAL_Arrows	B}', "");
Expect(0, 10495, '\p{Blk= SUPPLEMENTAL_Arrows	B}', "");
Expect(1, 10495, '\p{^Blk= SUPPLEMENTAL_Arrows	B}', "");
Expect(1, 10495, '\P{Blk= SUPPLEMENTAL_Arrows	B}', "");
Expect(0, 10495, '\P{^Blk= SUPPLEMENTAL_Arrows	B}', "");
Error('\p{Is_Block=_SUPPLEMENTAL	Arrows:=B}');
Error('\P{Is_Block=_SUPPLEMENTAL	Arrows:=B}');
Expect(1, 10623, '\p{Is_Block=supplementalarrowsb}', "");
Expect(0, 10623, '\p{^Is_Block=supplementalarrowsb}', "");
Expect(0, 10623, '\P{Is_Block=supplementalarrowsb}', "");
Expect(1, 10623, '\P{^Is_Block=supplementalarrowsb}', "");
Expect(0, 10495, '\p{Is_Block=supplementalarrowsb}', "");
Expect(1, 10495, '\p{^Is_Block=supplementalarrowsb}', "");
Expect(1, 10495, '\P{Is_Block=supplementalarrowsb}', "");
Expect(0, 10495, '\P{^Is_Block=supplementalarrowsb}', "");
Expect(1, 10623, '\p{Is_Block= SupplementalArrows B}', "");
Expect(0, 10623, '\p{^Is_Block= SupplementalArrows B}', "");
Expect(0, 10623, '\P{Is_Block= SupplementalArrows B}', "");
Expect(1, 10623, '\P{^Is_Block= SupplementalArrows B}', "");
Expect(0, 10495, '\p{Is_Block= SupplementalArrows B}', "");
Expect(1, 10495, '\p{^Is_Block= SupplementalArrows B}', "");
Expect(1, 10495, '\P{Is_Block= SupplementalArrows B}', "");
Expect(0, 10495, '\P{^Is_Block= SupplementalArrows B}', "");
Error('\p{Is_Blk=	SUPPLEMENTAL:=arrowsB}');
Error('\P{Is_Blk=	SUPPLEMENTAL:=arrowsB}');
Expect(1, 10623, '\p{Is_Blk=supplementalarrowsb}', "");
Expect(0, 10623, '\p{^Is_Blk=supplementalarrowsb}', "");
Expect(0, 10623, '\P{Is_Blk=supplementalarrowsb}', "");
Expect(1, 10623, '\P{^Is_Blk=supplementalarrowsb}', "");
Expect(0, 10495, '\p{Is_Blk=supplementalarrowsb}', "");
Expect(1, 10495, '\p{^Is_Blk=supplementalarrowsb}', "");
Expect(1, 10495, '\P{Is_Blk=supplementalarrowsb}', "");
Expect(0, 10495, '\P{^Is_Blk=supplementalarrowsb}', "");
Expect(1, 10623, '\p{Is_Blk=_-Supplementalarrows-B}', "");
Expect(0, 10623, '\p{^Is_Blk=_-Supplementalarrows-B}', "");
Expect(0, 10623, '\P{Is_Blk=_-Supplementalarrows-B}', "");
Expect(1, 10623, '\P{^Is_Blk=_-Supplementalarrows-B}', "");
Expect(0, 10495, '\p{Is_Blk=_-Supplementalarrows-B}', "");
Expect(1, 10495, '\p{^Is_Blk=_-Supplementalarrows-B}', "");
Expect(1, 10495, '\P{Is_Blk=_-Supplementalarrows-B}', "");
Expect(0, 10495, '\P{^Is_Blk=_-Supplementalarrows-B}', "");
Error('\p{Block=-:=Tibetan}');
Error('\P{Block=-:=Tibetan}');
Expect(1, 4095, '\p{Block=tibetan}', "");
Expect(0, 4095, '\p{^Block=tibetan}', "");
Expect(0, 4095, '\P{Block=tibetan}', "");
Expect(1, 4095, '\P{^Block=tibetan}', "");
Expect(0, 3839, '\p{Block=tibetan}', "");
Expect(1, 3839, '\p{^Block=tibetan}', "");
Expect(1, 3839, '\P{Block=tibetan}', "");
Expect(0, 3839, '\P{^Block=tibetan}', "");
Expect(1, 4095, '\p{Block=--TIBETAN}', "");
Expect(0, 4095, '\p{^Block=--TIBETAN}', "");
Expect(0, 4095, '\P{Block=--TIBETAN}', "");
Expect(1, 4095, '\P{^Block=--TIBETAN}', "");
Expect(0, 3839, '\p{Block=--TIBETAN}', "");
Expect(1, 3839, '\p{^Block=--TIBETAN}', "");
Expect(1, 3839, '\P{Block=--TIBETAN}', "");
Expect(0, 3839, '\P{^Block=--TIBETAN}', "");
Error('\p{Blk=_tibetan:=}');
Error('\P{Blk=_tibetan:=}');
Expect(1, 4095, '\p{Blk=tibetan}', "");
Expect(0, 4095, '\p{^Blk=tibetan}', "");
Expect(0, 4095, '\P{Blk=tibetan}', "");
Expect(1, 4095, '\P{^Blk=tibetan}', "");
Expect(0, 3839, '\p{Blk=tibetan}', "");
Expect(1, 3839, '\p{^Blk=tibetan}', "");
Expect(1, 3839, '\P{Blk=tibetan}', "");
Expect(0, 3839, '\P{^Blk=tibetan}', "");
Expect(1, 4095, '\p{Blk=_Tibetan}', "");
Expect(0, 4095, '\p{^Blk=_Tibetan}', "");
Expect(0, 4095, '\P{Blk=_Tibetan}', "");
Expect(1, 4095, '\P{^Blk=_Tibetan}', "");
Expect(0, 3839, '\p{Blk=_Tibetan}', "");
Expect(1, 3839, '\p{^Blk=_Tibetan}', "");
Expect(1, 3839, '\P{Blk=_Tibetan}', "");
Expect(0, 3839, '\P{^Blk=_Tibetan}', "");
Error('\p{Is_Block:	tibetan/a/}');
Error('\P{Is_Block:	tibetan/a/}');
Expect(1, 4095, '\p{Is_Block=tibetan}', "");
Expect(0, 4095, '\p{^Is_Block=tibetan}', "");
Expect(0, 4095, '\P{Is_Block=tibetan}', "");
Expect(1, 4095, '\P{^Is_Block=tibetan}', "");
Expect(0, 3839, '\p{Is_Block=tibetan}', "");
Expect(1, 3839, '\p{^Is_Block=tibetan}', "");
Expect(1, 3839, '\P{Is_Block=tibetan}', "");
Expect(0, 3839, '\P{^Is_Block=tibetan}', "");
Expect(1, 4095, '\p{Is_Block= 	TIBETAN}', "");
Expect(0, 4095, '\p{^Is_Block= 	TIBETAN}', "");
Expect(0, 4095, '\P{Is_Block= 	TIBETAN}', "");
Expect(1, 4095, '\P{^Is_Block= 	TIBETAN}', "");
Expect(0, 3839, '\p{Is_Block= 	TIBETAN}', "");
Expect(1, 3839, '\p{^Is_Block= 	TIBETAN}', "");
Expect(1, 3839, '\P{Is_Block= 	TIBETAN}', "");
Expect(0, 3839, '\P{^Is_Block= 	TIBETAN}', "");
Error('\p{Is_Blk=:=_-TIBETAN}');
Error('\P{Is_Blk=:=_-TIBETAN}');
Expect(1, 4095, '\p{Is_Blk=tibetan}', "");
Expect(0, 4095, '\p{^Is_Blk=tibetan}', "");
Expect(0, 4095, '\P{Is_Blk=tibetan}', "");
Expect(1, 4095, '\P{^Is_Blk=tibetan}', "");
Expect(0, 3839, '\p{Is_Blk=tibetan}', "");
Expect(1, 3839, '\p{^Is_Blk=tibetan}', "");
Expect(1, 3839, '\P{Is_Blk=tibetan}', "");
Expect(0, 3839, '\P{^Is_Blk=tibetan}', "");
Expect(1, 4095, '\p{Is_Blk=--tibetan}', "");
Expect(0, 4095, '\p{^Is_Blk=--tibetan}', "");
Expect(0, 4095, '\P{Is_Blk=--tibetan}', "");
Expect(1, 4095, '\P{^Is_Blk=--tibetan}', "");
Expect(0, 3839, '\p{Is_Blk=--tibetan}', "");
Expect(1, 3839, '\p{^Is_Blk=--tibetan}', "");
Expect(1, 3839, '\P{Is_Blk=--tibetan}', "");
Expect(0, 3839, '\P{^Is_Blk=--tibetan}', "");
Error('\p{Block=-:=domino Tiles}');
Error('\P{Block=-:=domino Tiles}');
Expect(1, 127135, '\p{Block=dominotiles}', "");
Expect(0, 127135, '\p{^Block=dominotiles}', "");
Expect(0, 127135, '\P{Block=dominotiles}', "");
Expect(1, 127135, '\P{^Block=dominotiles}', "");
Expect(0, 127023, '\p{Block=dominotiles}', "");
Expect(1, 127023, '\p{^Block=dominotiles}', "");
Expect(1, 127023, '\P{Block=dominotiles}', "");
Expect(0, 127023, '\P{^Block=dominotiles}', "");
Expect(1, 127135, '\p{Block=		domino-Tiles}', "");
Expect(0, 127135, '\p{^Block=		domino-Tiles}', "");
Expect(0, 127135, '\P{Block=		domino-Tiles}', "");
Expect(1, 127135, '\P{^Block=		domino-Tiles}', "");
Expect(0, 127023, '\p{Block=		domino-Tiles}', "");
Expect(1, 127023, '\p{^Block=		domino-Tiles}', "");
Expect(1, 127023, '\P{Block=		domino-Tiles}', "");
Expect(0, 127023, '\P{^Block=		domino-Tiles}', "");
Error('\p{Blk:/a/-Domino	Tiles}');
Error('\P{Blk:/a/-Domino	Tiles}');
Expect(1, 127135, '\p{Blk:	dominotiles}', "");
Expect(0, 127135, '\p{^Blk:	dominotiles}', "");
Expect(0, 127135, '\P{Blk:	dominotiles}', "");
Expect(1, 127135, '\P{^Blk:	dominotiles}', "");
Expect(0, 127023, '\p{Blk:	dominotiles}', "");
Expect(1, 127023, '\p{^Blk:	dominotiles}', "");
Expect(1, 127023, '\P{Blk:	dominotiles}', "");
Expect(0, 127023, '\P{^Blk:	dominotiles}', "");
Expect(1, 127135, '\p{Blk=_	DOMINO_Tiles}', "");
Expect(0, 127135, '\p{^Blk=_	DOMINO_Tiles}', "");
Expect(0, 127135, '\P{Blk=_	DOMINO_Tiles}', "");
Expect(1, 127135, '\P{^Blk=_	DOMINO_Tiles}', "");
Expect(0, 127023, '\p{Blk=_	DOMINO_Tiles}', "");
Expect(1, 127023, '\p{^Blk=_	DOMINO_Tiles}', "");
Expect(1, 127023, '\P{Blk=_	DOMINO_Tiles}', "");
Expect(0, 127023, '\P{^Blk=_	DOMINO_Tiles}', "");
Error('\p{Is_Block=	Domino:=Tiles}');
Error('\P{Is_Block=	Domino:=Tiles}');
Expect(1, 127135, '\p{Is_Block=dominotiles}', "");
Expect(0, 127135, '\p{^Is_Block=dominotiles}', "");
Expect(0, 127135, '\P{Is_Block=dominotiles}', "");
Expect(1, 127135, '\P{^Is_Block=dominotiles}', "");
Expect(0, 127023, '\p{Is_Block=dominotiles}', "");
Expect(1, 127023, '\p{^Is_Block=dominotiles}', "");
Expect(1, 127023, '\P{Is_Block=dominotiles}', "");
Expect(0, 127023, '\P{^Is_Block=dominotiles}', "");
Expect(1, 127135, '\p{Is_Block:	 domino_TILES}', "");
Expect(0, 127135, '\p{^Is_Block:	 domino_TILES}', "");
Expect(0, 127135, '\P{Is_Block:	 domino_TILES}', "");
Expect(1, 127135, '\P{^Is_Block:	 domino_TILES}', "");
Expect(0, 127023, '\p{Is_Block:	 domino_TILES}', "");
Expect(1, 127023, '\p{^Is_Block:	 domino_TILES}', "");
Expect(1, 127023, '\P{Is_Block:	 domino_TILES}', "");
Expect(0, 127023, '\P{^Is_Block:	 domino_TILES}', "");
Error('\p{Is_Blk=/a/ domino TILES}');
Error('\P{Is_Blk=/a/ domino TILES}');
Expect(1, 127135, '\p{Is_Blk=dominotiles}', "");
Expect(0, 127135, '\p{^Is_Blk=dominotiles}', "");
Expect(0, 127135, '\P{Is_Blk=dominotiles}', "");
Expect(1, 127135, '\P{^Is_Blk=dominotiles}', "");
Expect(0, 127023, '\p{Is_Blk=dominotiles}', "");
Expect(1, 127023, '\p{^Is_Blk=dominotiles}', "");
Expect(1, 127023, '\P{Is_Blk=dominotiles}', "");
Expect(0, 127023, '\P{^Is_Blk=dominotiles}', "");
Expect(1, 127135, '\p{Is_Blk=	Domino	Tiles}', "");
Expect(0, 127135, '\p{^Is_Blk=	Domino	Tiles}', "");
Expect(0, 127135, '\P{Is_Blk=	Domino	Tiles}', "");
Expect(1, 127135, '\P{^Is_Blk=	Domino	Tiles}', "");
Expect(0, 127023, '\p{Is_Blk=	Domino	Tiles}', "");
Expect(1, 127023, '\p{^Is_Blk=	Domino	Tiles}', "");
Expect(1, 127023, '\P{Is_Blk=	Domino	Tiles}', "");
Expect(0, 127023, '\P{^Is_Blk=	Domino	Tiles}', "");
Error('\p{Block=/a/CJK-Symbols And	punctuation}');
Error('\P{Block=/a/CJK-Symbols And	punctuation}');
Expect(1, 12351, '\p{Block=cjksymbolsandpunctuation}', "");
Expect(0, 12351, '\p{^Block=cjksymbolsandpunctuation}', "");
Expect(0, 12351, '\P{Block=cjksymbolsandpunctuation}', "");
Expect(1, 12351, '\P{^Block=cjksymbolsandpunctuation}', "");
Expect(0, 12287, '\p{Block=cjksymbolsandpunctuation}', "");
Expect(1, 12287, '\p{^Block=cjksymbolsandpunctuation}', "");
Expect(1, 12287, '\P{Block=cjksymbolsandpunctuation}', "");
Expect(0, 12287, '\P{^Block=cjksymbolsandpunctuation}', "");
Expect(1, 12351, '\p{Block:	CJK_SYMBOLSAND-PUNCTUATION}', "");
Expect(0, 12351, '\p{^Block:	CJK_SYMBOLSAND-PUNCTUATION}', "");
Expect(0, 12351, '\P{Block:	CJK_SYMBOLSAND-PUNCTUATION}', "");
Expect(1, 12351, '\P{^Block:	CJK_SYMBOLSAND-PUNCTUATION}', "");
Expect(0, 12287, '\p{Block:	CJK_SYMBOLSAND-PUNCTUATION}', "");
Expect(1, 12287, '\p{^Block:	CJK_SYMBOLSAND-PUNCTUATION}', "");
Expect(1, 12287, '\P{Block:	CJK_SYMBOLSAND-PUNCTUATION}', "");
Expect(0, 12287, '\P{^Block:	CJK_SYMBOLSAND-PUNCTUATION}', "");
Error('\p{Blk=	_CJK SYMBOLS and/a/Punctuation}');
Error('\P{Blk=	_CJK SYMBOLS and/a/Punctuation}');
Expect(1, 12351, '\p{Blk=cjksymbolsandpunctuation}', "");
Expect(0, 12351, '\p{^Blk=cjksymbolsandpunctuation}', "");
Expect(0, 12351, '\P{Blk=cjksymbolsandpunctuation}', "");
Expect(1, 12351, '\P{^Blk=cjksymbolsandpunctuation}', "");
Expect(0, 12287, '\p{Blk=cjksymbolsandpunctuation}', "");
Expect(1, 12287, '\p{^Blk=cjksymbolsandpunctuation}', "");
Expect(1, 12287, '\P{Blk=cjksymbolsandpunctuation}', "");
Expect(0, 12287, '\P{^Blk=cjksymbolsandpunctuation}', "");
Expect(1, 12351, '\p{Blk=-_CJK_symbols Andpunctuation}', "");
Expect(0, 12351, '\p{^Blk=-_CJK_symbols Andpunctuation}', "");
Expect(0, 12351, '\P{Blk=-_CJK_symbols Andpunctuation}', "");
Expect(1, 12351, '\P{^Blk=-_CJK_symbols Andpunctuation}', "");
Expect(0, 12287, '\p{Blk=-_CJK_symbols Andpunctuation}', "");
Expect(1, 12287, '\p{^Blk=-_CJK_symbols Andpunctuation}', "");
Expect(1, 12287, '\P{Blk=-_CJK_symbols Andpunctuation}', "");
Expect(0, 12287, '\P{^Blk=-_CJK_symbols Andpunctuation}', "");
Error('\p{Is_Block=-	cjk_Symbols/a/AND	punctuation}');
Error('\P{Is_Block=-	cjk_Symbols/a/AND	punctuation}');
Expect(1, 12351, '\p{Is_Block:cjksymbolsandpunctuation}', "");
Expect(0, 12351, '\p{^Is_Block:cjksymbolsandpunctuation}', "");
Expect(0, 12351, '\P{Is_Block:cjksymbolsandpunctuation}', "");
Expect(1, 12351, '\P{^Is_Block:cjksymbolsandpunctuation}', "");
Expect(0, 12287, '\p{Is_Block:cjksymbolsandpunctuation}', "");
Expect(1, 12287, '\p{^Is_Block:cjksymbolsandpunctuation}', "");
Expect(1, 12287, '\P{Is_Block:cjksymbolsandpunctuation}', "");
Expect(0, 12287, '\P{^Is_Block:cjksymbolsandpunctuation}', "");
Expect(1, 12351, '\p{Is_Block=		CJK-symbols	And punctuation}', "");
Expect(0, 12351, '\p{^Is_Block=		CJK-symbols	And punctuation}', "");
Expect(0, 12351, '\P{Is_Block=		CJK-symbols	And punctuation}', "");
Expect(1, 12351, '\P{^Is_Block=		CJK-symbols	And punctuation}', "");
Expect(0, 12287, '\p{Is_Block=		CJK-symbols	And punctuation}', "");
Expect(1, 12287, '\p{^Is_Block=		CJK-symbols	And punctuation}', "");
Expect(1, 12287, '\P{Is_Block=		CJK-symbols	And punctuation}', "");
Expect(0, 12287, '\P{^Is_Block=		CJK-symbols	And punctuation}', "");
Error('\p{Is_Blk:   -/a/CJK-symbolsANDpunctuation}');
Error('\P{Is_Blk:   -/a/CJK-symbolsANDpunctuation}');
Expect(1, 12351, '\p{Is_Blk=cjksymbolsandpunctuation}', "");
Expect(0, 12351, '\p{^Is_Blk=cjksymbolsandpunctuation}', "");
Expect(0, 12351, '\P{Is_Blk=cjksymbolsandpunctuation}', "");
Expect(1, 12351, '\P{^Is_Blk=cjksymbolsandpunctuation}', "");
Expect(0, 12287, '\p{Is_Blk=cjksymbolsandpunctuation}', "");
Expect(1, 12287, '\p{^Is_Blk=cjksymbolsandpunctuation}', "");
Expect(1, 12287, '\P{Is_Blk=cjksymbolsandpunctuation}', "");
Expect(0, 12287, '\P{^Is_Blk=cjksymbolsandpunctuation}', "");
Expect(1, 12351, '\p{Is_Blk=_CJKSymbolsand-PUNCTUATION}', "");
Expect(0, 12351, '\p{^Is_Blk=_CJKSymbolsand-PUNCTUATION}', "");
Expect(0, 12351, '\P{Is_Blk=_CJKSymbolsand-PUNCTUATION}', "");
Expect(1, 12351, '\P{^Is_Blk=_CJKSymbolsand-PUNCTUATION}', "");
Expect(0, 12287, '\p{Is_Blk=_CJKSymbolsand-PUNCTUATION}', "");
Expect(1, 12287, '\p{^Is_Blk=_CJKSymbolsand-PUNCTUATION}', "");
Expect(1, 12287, '\P{Is_Blk=_CJKSymbolsand-PUNCTUATION}', "");
Expect(0, 12287, '\P{^Is_Blk=_CJKSymbolsand-PUNCTUATION}', "");
Error('\p{Block= hangulCOMPATIBILITY Jamo:=}');
Error('\P{Block= hangulCOMPATIBILITY Jamo:=}');
Expect(1, 12687, '\p{Block=hangulcompatibilityjamo}', "");
Expect(0, 12687, '\p{^Block=hangulcompatibilityjamo}', "");
Expect(0, 12687, '\P{Block=hangulcompatibilityjamo}', "");
Expect(1, 12687, '\P{^Block=hangulcompatibilityjamo}', "");
Expect(0, 12591, '\p{Block=hangulcompatibilityjamo}', "");
Expect(1, 12591, '\p{^Block=hangulcompatibilityjamo}', "");
Expect(1, 12591, '\P{Block=hangulcompatibilityjamo}', "");
Expect(0, 12591, '\P{^Block=hangulcompatibilityjamo}', "");
Expect(1, 12687, '\p{Block=_Hangul_compatibility jamo}', "");
Expect(0, 12687, '\p{^Block=_Hangul_compatibility jamo}', "");
Expect(0, 12687, '\P{Block=_Hangul_compatibility jamo}', "");
Expect(1, 12687, '\P{^Block=_Hangul_compatibility jamo}', "");
Expect(0, 12591, '\p{Block=_Hangul_compatibility jamo}', "");
Expect(1, 12591, '\p{^Block=_Hangul_compatibility jamo}', "");
Expect(1, 12591, '\P{Block=_Hangul_compatibility jamo}', "");
Expect(0, 12591, '\P{^Block=_Hangul_compatibility jamo}', "");
Error('\p{Blk=		Hangul:=compatibility jamo}');
Error('\P{Blk=		Hangul:=compatibility jamo}');
Expect(1, 12687, '\p{Blk=hangulcompatibilityjamo}', "");
Expect(0, 12687, '\p{^Blk=hangulcompatibilityjamo}', "");
Expect(0, 12687, '\P{Blk=hangulcompatibilityjamo}', "");
Expect(1, 12687, '\P{^Blk=hangulcompatibilityjamo}', "");
Expect(0, 12591, '\p{Blk=hangulcompatibilityjamo}', "");
Expect(1, 12591, '\p{^Blk=hangulcompatibilityjamo}', "");
Expect(1, 12591, '\P{Blk=hangulcompatibilityjamo}', "");
Expect(0, 12591, '\P{^Blk=hangulcompatibilityjamo}', "");
Expect(1, 12687, '\p{Blk= -hangulCompatibility_JAMO}', "");
Expect(0, 12687, '\p{^Blk= -hangulCompatibility_JAMO}', "");
Expect(0, 12687, '\P{Blk= -hangulCompatibility_JAMO}', "");
Expect(1, 12687, '\P{^Blk= -hangulCompatibility_JAMO}', "");
Expect(0, 12591, '\p{Blk= -hangulCompatibility_JAMO}', "");
Expect(1, 12591, '\p{^Blk= -hangulCompatibility_JAMO}', "");
Expect(1, 12591, '\P{Blk= -hangulCompatibility_JAMO}', "");
Expect(0, 12591, '\P{^Blk= -hangulCompatibility_JAMO}', "");
Error('\p{Is_Block:   :=HANGUL_compatibility JAMO}');
Error('\P{Is_Block:   :=HANGUL_compatibility JAMO}');
Expect(1, 12687, '\p{Is_Block=hangulcompatibilityjamo}', "");
Expect(0, 12687, '\p{^Is_Block=hangulcompatibilityjamo}', "");
Expect(0, 12687, '\P{Is_Block=hangulcompatibilityjamo}', "");
Expect(1, 12687, '\P{^Is_Block=hangulcompatibilityjamo}', "");
Expect(0, 12591, '\p{Is_Block=hangulcompatibilityjamo}', "");
Expect(1, 12591, '\p{^Is_Block=hangulcompatibilityjamo}', "");
Expect(1, 12591, '\P{Is_Block=hangulcompatibilityjamo}', "");
Expect(0, 12591, '\P{^Is_Block=hangulcompatibilityjamo}', "");
Expect(1, 12687, '\p{Is_Block=_ HangulCompatibilityJamo}', "");
Expect(0, 12687, '\p{^Is_Block=_ HangulCompatibilityJamo}', "");
Expect(0, 12687, '\P{Is_Block=_ HangulCompatibilityJamo}', "");
Expect(1, 12687, '\P{^Is_Block=_ HangulCompatibilityJamo}', "");
Expect(0, 12591, '\p{Is_Block=_ HangulCompatibilityJamo}', "");
Expect(1, 12591, '\p{^Is_Block=_ HangulCompatibilityJamo}', "");
Expect(1, 12591, '\P{Is_Block=_ HangulCompatibilityJamo}', "");
Expect(0, 12591, '\P{^Is_Block=_ HangulCompatibilityJamo}', "");
Error('\p{Is_Blk=/a/Hangul-COMPATIBILITY	Jamo}');
Error('\P{Is_Blk=/a/Hangul-COMPATIBILITY	Jamo}');
Expect(1, 12687, '\p{Is_Blk=hangulcompatibilityjamo}', "");
Expect(0, 12687, '\p{^Is_Blk=hangulcompatibilityjamo}', "");
Expect(0, 12687, '\P{Is_Blk=hangulcompatibilityjamo}', "");
Expect(1, 12687, '\P{^Is_Blk=hangulcompatibilityjamo}', "");
Expect(0, 12591, '\p{Is_Blk=hangulcompatibilityjamo}', "");
Expect(1, 12591, '\p{^Is_Blk=hangulcompatibilityjamo}', "");
Expect(1, 12591, '\P{Is_Blk=hangulcompatibilityjamo}', "");
Expect(0, 12591, '\P{^Is_Blk=hangulcompatibilityjamo}', "");
Expect(1, 12687, '\p{Is_Blk=__hangulCOMPATIBILITY	jamo}', "");
Expect(0, 12687, '\p{^Is_Blk=__hangulCOMPATIBILITY	jamo}', "");
Expect(0, 12687, '\P{Is_Blk=__hangulCOMPATIBILITY	jamo}', "");
Expect(1, 12687, '\P{^Is_Blk=__hangulCOMPATIBILITY	jamo}', "");
Expect(0, 12591, '\p{Is_Blk=__hangulCOMPATIBILITY	jamo}', "");
Expect(1, 12591, '\p{^Is_Blk=__hangulCOMPATIBILITY	jamo}', "");
Expect(1, 12591, '\P{Is_Blk=__hangulCOMPATIBILITY	jamo}', "");
Expect(0, 12591, '\P{^Is_Blk=__hangulCOMPATIBILITY	jamo}', "");
Error('\p{Block:-	old:=PERSIAN}');
Error('\P{Block:-	old:=PERSIAN}');
Expect(1, 66527, '\p{Block=oldpersian}', "");
Expect(0, 66527, '\p{^Block=oldpersian}', "");
Expect(0, 66527, '\P{Block=oldpersian}', "");
Expect(1, 66527, '\P{^Block=oldpersian}', "");
Expect(0, 66463, '\p{Block=oldpersian}', "");
Expect(1, 66463, '\p{^Block=oldpersian}', "");
Expect(1, 66463, '\P{Block=oldpersian}', "");
Expect(0, 66463, '\P{^Block=oldpersian}', "");
Expect(1, 66527, '\p{Block=-	OLD PERSIAN}', "");
Expect(0, 66527, '\p{^Block=-	OLD PERSIAN}', "");
Expect(0, 66527, '\P{Block=-	OLD PERSIAN}', "");
Expect(1, 66527, '\P{^Block=-	OLD PERSIAN}', "");
Expect(0, 66463, '\p{Block=-	OLD PERSIAN}', "");
Expect(1, 66463, '\p{^Block=-	OLD PERSIAN}', "");
Expect(1, 66463, '\P{Block=-	OLD PERSIAN}', "");
Expect(0, 66463, '\P{^Block=-	OLD PERSIAN}', "");
Error('\p{Blk:   /a/_OLD	Persian}');
Error('\P{Blk:   /a/_OLD	Persian}');
Expect(1, 66527, '\p{Blk=oldpersian}', "");
Expect(0, 66527, '\p{^Blk=oldpersian}', "");
Expect(0, 66527, '\P{Blk=oldpersian}', "");
Expect(1, 66527, '\P{^Blk=oldpersian}', "");
Expect(0, 66463, '\p{Blk=oldpersian}', "");
Expect(1, 66463, '\p{^Blk=oldpersian}', "");
Expect(1, 66463, '\P{Blk=oldpersian}', "");
Expect(0, 66463, '\P{^Blk=oldpersian}', "");
Expect(1, 66527, '\p{Blk=-Old-PERSIAN}', "");
Expect(0, 66527, '\p{^Blk=-Old-PERSIAN}', "");
Expect(0, 66527, '\P{Blk=-Old-PERSIAN}', "");
Expect(1, 66527, '\P{^Blk=-Old-PERSIAN}', "");
Expect(0, 66463, '\p{Blk=-Old-PERSIAN}', "");
Expect(1, 66463, '\p{^Blk=-Old-PERSIAN}', "");
Expect(1, 66463, '\P{Blk=-Old-PERSIAN}', "");
Expect(0, 66463, '\P{^Blk=-Old-PERSIAN}', "");
Error('\p{Is_Block=old-persian/a/}');
Error('\P{Is_Block=old-persian/a/}');
Expect(1, 66527, '\p{Is_Block=oldpersian}', "");
Expect(0, 66527, '\p{^Is_Block=oldpersian}', "");
Expect(0, 66527, '\P{Is_Block=oldpersian}', "");
Expect(1, 66527, '\P{^Is_Block=oldpersian}', "");
Expect(0, 66463, '\p{Is_Block=oldpersian}', "");
Expect(1, 66463, '\p{^Is_Block=oldpersian}', "");
Expect(1, 66463, '\P{Is_Block=oldpersian}', "");
Expect(0, 66463, '\P{^Is_Block=oldpersian}', "");
Expect(1, 66527, '\p{Is_Block=-Old Persian}', "");
Expect(0, 66527, '\p{^Is_Block=-Old Persian}', "");
Expect(0, 66527, '\P{Is_Block=-Old Persian}', "");
Expect(1, 66527, '\P{^Is_Block=-Old Persian}', "");
Expect(0, 66463, '\p{Is_Block=-Old Persian}', "");
Expect(1, 66463, '\p{^Is_Block=-Old Persian}', "");
Expect(1, 66463, '\P{Is_Block=-Old Persian}', "");
Expect(0, 66463, '\P{^Is_Block=-Old Persian}', "");
Error('\p{Is_Blk= :=Old-Persian}');
Error('\P{Is_Blk= :=Old-Persian}');
Expect(1, 66527, '\p{Is_Blk:oldpersian}', "");
Expect(0, 66527, '\p{^Is_Blk:oldpersian}', "");
Expect(0, 66527, '\P{Is_Blk:oldpersian}', "");
Expect(1, 66527, '\P{^Is_Blk:oldpersian}', "");
Expect(0, 66463, '\p{Is_Blk:oldpersian}', "");
Expect(1, 66463, '\p{^Is_Blk:oldpersian}', "");
Expect(1, 66463, '\P{Is_Blk:oldpersian}', "");
Expect(0, 66463, '\P{^Is_Blk:oldpersian}', "");
Expect(1, 66527, '\p{Is_Blk= Oldpersian}', "");
Expect(0, 66527, '\p{^Is_Blk= Oldpersian}', "");
Expect(0, 66527, '\P{Is_Blk= Oldpersian}', "");
Expect(1, 66527, '\P{^Is_Blk= Oldpersian}', "");
Expect(0, 66463, '\p{Is_Blk= Oldpersian}', "");
Expect(1, 66463, '\p{^Is_Blk= Oldpersian}', "");
Expect(1, 66463, '\P{Is_Blk= Oldpersian}', "");
Expect(0, 66463, '\P{^Is_Blk= Oldpersian}', "");
Error('\p{Block=Modifier_Tone_Letters/a/}');
Error('\P{Block=Modifier_Tone_Letters/a/}');
Expect(1, 42783, '\p{Block=modifiertoneletters}', "");
Expect(0, 42783, '\p{^Block=modifiertoneletters}', "");
Expect(0, 42783, '\P{Block=modifiertoneletters}', "");
Expect(1, 42783, '\P{^Block=modifiertoneletters}', "");
Expect(0, 42751, '\p{Block=modifiertoneletters}', "");
Expect(1, 42751, '\p{^Block=modifiertoneletters}', "");
Expect(1, 42751, '\P{Block=modifiertoneletters}', "");
Expect(0, 42751, '\P{^Block=modifiertoneletters}', "");
Expect(1, 42783, '\p{Block=__Modifier Tone_Letters}', "");
Expect(0, 42783, '\p{^Block=__Modifier Tone_Letters}', "");
Expect(0, 42783, '\P{Block=__Modifier Tone_Letters}', "");
Expect(1, 42783, '\P{^Block=__Modifier Tone_Letters}', "");
Expect(0, 42751, '\p{Block=__Modifier Tone_Letters}', "");
Expect(1, 42751, '\p{^Block=__Modifier Tone_Letters}', "");
Expect(1, 42751, '\P{Block=__Modifier Tone_Letters}', "");
Expect(0, 42751, '\P{^Block=__Modifier Tone_Letters}', "");
Error('\p{Blk=MODIFIER-Tone/a/letters}');
Error('\P{Blk=MODIFIER-Tone/a/letters}');
Expect(1, 42783, '\p{Blk=modifiertoneletters}', "");
Expect(0, 42783, '\p{^Blk=modifiertoneletters}', "");
Expect(0, 42783, '\P{Blk=modifiertoneletters}', "");
Expect(1, 42783, '\P{^Blk=modifiertoneletters}', "");
Expect(0, 42751, '\p{Blk=modifiertoneletters}', "");
Expect(1, 42751, '\p{^Blk=modifiertoneletters}', "");
Expect(1, 42751, '\P{Blk=modifiertoneletters}', "");
Expect(0, 42751, '\P{^Blk=modifiertoneletters}', "");
Expect(1, 42783, '\p{Blk= -MODIFIERTONE	letters}', "");
Expect(0, 42783, '\p{^Blk= -MODIFIERTONE	letters}', "");
Expect(0, 42783, '\P{Blk= -MODIFIERTONE	letters}', "");
Expect(1, 42783, '\P{^Blk= -MODIFIERTONE	letters}', "");
Expect(0, 42751, '\p{Blk= -MODIFIERTONE	letters}', "");
Expect(1, 42751, '\p{^Blk= -MODIFIERTONE	letters}', "");
Expect(1, 42751, '\P{Blk= -MODIFIERTONE	letters}', "");
Expect(0, 42751, '\P{^Blk= -MODIFIERTONE	letters}', "");
Error('\p{Is_Block= -Modifier TONE_Letters:=}');
Error('\P{Is_Block= -Modifier TONE_Letters:=}');
Expect(1, 42783, '\p{Is_Block=modifiertoneletters}', "");
Expect(0, 42783, '\p{^Is_Block=modifiertoneletters}', "");
Expect(0, 42783, '\P{Is_Block=modifiertoneletters}', "");
Expect(1, 42783, '\P{^Is_Block=modifiertoneletters}', "");
Expect(0, 42751, '\p{Is_Block=modifiertoneletters}', "");
Expect(1, 42751, '\p{^Is_Block=modifiertoneletters}', "");
Expect(1, 42751, '\P{Is_Block=modifiertoneletters}', "");
Expect(0, 42751, '\P{^Is_Block=modifiertoneletters}', "");
Expect(1, 42783, '\p{Is_Block=	_modifier	TONE	LETTERS}', "");
Expect(0, 42783, '\p{^Is_Block=	_modifier	TONE	LETTERS}', "");
Expect(0, 42783, '\P{Is_Block=	_modifier	TONE	LETTERS}', "");
Expect(1, 42783, '\P{^Is_Block=	_modifier	TONE	LETTERS}', "");
Expect(0, 42751, '\p{Is_Block=	_modifier	TONE	LETTERS}', "");
Expect(1, 42751, '\p{^Is_Block=	_modifier	TONE	LETTERS}', "");
Expect(1, 42751, '\P{Is_Block=	_modifier	TONE	LETTERS}', "");
Expect(0, 42751, '\P{^Is_Block=	_modifier	TONE	LETTERS}', "");
Error('\p{Is_Blk=_-MODIFIER	tone	letters/a/}');
Error('\P{Is_Blk=_-MODIFIER	tone	letters/a/}');
Expect(1, 42783, '\p{Is_Blk=modifiertoneletters}', "");
Expect(0, 42783, '\p{^Is_Blk=modifiertoneletters}', "");
Expect(0, 42783, '\P{Is_Blk=modifiertoneletters}', "");
Expect(1, 42783, '\P{^Is_Blk=modifiertoneletters}', "");
Expect(0, 42751, '\p{Is_Blk=modifiertoneletters}', "");
Expect(1, 42751, '\p{^Is_Blk=modifiertoneletters}', "");
Expect(1, 42751, '\P{Is_Blk=modifiertoneletters}', "");
Expect(0, 42751, '\P{^Is_Blk=modifiertoneletters}', "");
Expect(1, 42783, '\p{Is_Blk=-	modifier-Tone letters}', "");
Expect(0, 42783, '\p{^Is_Blk=-	modifier-Tone letters}', "");
Expect(0, 42783, '\P{Is_Blk=-	modifier-Tone letters}', "");
Expect(1, 42783, '\P{^Is_Blk=-	modifier-Tone letters}', "");
Expect(0, 42751, '\p{Is_Blk=-	modifier-Tone letters}', "");
Expect(1, 42751, '\p{^Is_Blk=-	modifier-Tone letters}', "");
Expect(1, 42751, '\P{Is_Blk=-	modifier-Tone letters}', "");
Expect(0, 42751, '\P{^Is_Blk=-	modifier-Tone letters}', "");
Error('\p{Block= :=Ethiopic-SUPPLEMENT}');
Error('\P{Block= :=Ethiopic-SUPPLEMENT}');
Expect(1, 5023, '\p{Block=ethiopicsupplement}', "");
Expect(0, 5023, '\p{^Block=ethiopicsupplement}', "");
Expect(0, 5023, '\P{Block=ethiopicsupplement}', "");
Expect(1, 5023, '\P{^Block=ethiopicsupplement}', "");
Expect(0, 4991, '\p{Block=ethiopicsupplement}', "");
Expect(1, 4991, '\p{^Block=ethiopicsupplement}', "");
Expect(1, 4991, '\P{Block=ethiopicsupplement}', "");
Expect(0, 4991, '\P{^Block=ethiopicsupplement}', "");
Expect(1, 5023, '\p{Block=	-ethiopic Supplement}', "");
Expect(0, 5023, '\p{^Block=	-ethiopic Supplement}', "");
Expect(0, 5023, '\P{Block=	-ethiopic Supplement}', "");
Expect(1, 5023, '\P{^Block=	-ethiopic Supplement}', "");
Expect(0, 4991, '\p{Block=	-ethiopic Supplement}', "");
Expect(1, 4991, '\p{^Block=	-ethiopic Supplement}', "");
Expect(1, 4991, '\P{Block=	-ethiopic Supplement}', "");
Expect(0, 4991, '\P{^Block=	-ethiopic Supplement}', "");
Error('\p{Blk=__ethiopicSupplement:=}');
Error('\P{Blk=__ethiopicSupplement:=}');
Expect(1, 5023, '\p{Blk=ethiopicsupplement}', "");
Expect(0, 5023, '\p{^Blk=ethiopicsupplement}', "");
Expect(0, 5023, '\P{Blk=ethiopicsupplement}', "");
Expect(1, 5023, '\P{^Blk=ethiopicsupplement}', "");
Expect(0, 4991, '\p{Blk=ethiopicsupplement}', "");
Expect(1, 4991, '\p{^Blk=ethiopicsupplement}', "");
Expect(1, 4991, '\P{Blk=ethiopicsupplement}', "");
Expect(0, 4991, '\P{^Blk=ethiopicsupplement}', "");
Expect(1, 5023, '\p{Blk=-	Ethiopic	Supplement}', "");
Expect(0, 5023, '\p{^Blk=-	Ethiopic	Supplement}', "");
Expect(0, 5023, '\P{Blk=-	Ethiopic	Supplement}', "");
Expect(1, 5023, '\P{^Blk=-	Ethiopic	Supplement}', "");
Expect(0, 4991, '\p{Blk=-	Ethiopic	Supplement}', "");
Expect(1, 4991, '\p{^Blk=-	Ethiopic	Supplement}', "");
Expect(1, 4991, '\P{Blk=-	Ethiopic	Supplement}', "");
Expect(0, 4991, '\P{^Blk=-	Ethiopic	Supplement}', "");
Error('\p{Is_Block=	-Ethiopic Supplement/a/}');
Error('\P{Is_Block=	-Ethiopic Supplement/a/}');
Expect(1, 5023, '\p{Is_Block=ethiopicsupplement}', "");
Expect(0, 5023, '\p{^Is_Block=ethiopicsupplement}', "");
Expect(0, 5023, '\P{Is_Block=ethiopicsupplement}', "");
Expect(1, 5023, '\P{^Is_Block=ethiopicsupplement}', "");
Expect(0, 4991, '\p{Is_Block=ethiopicsupplement}', "");
Expect(1, 4991, '\p{^Is_Block=ethiopicsupplement}', "");
Expect(1, 4991, '\P{Is_Block=ethiopicsupplement}', "");
Expect(0, 4991, '\P{^Is_Block=ethiopicsupplement}', "");
Expect(1, 5023, '\p{Is_Block=	Ethiopic SUPPLEMENT}', "");
Expect(0, 5023, '\p{^Is_Block=	Ethiopic SUPPLEMENT}', "");
Expect(0, 5023, '\P{Is_Block=	Ethiopic SUPPLEMENT}', "");
Expect(1, 5023, '\P{^Is_Block=	Ethiopic SUPPLEMENT}', "");
Expect(0, 4991, '\p{Is_Block=	Ethiopic SUPPLEMENT}', "");
Expect(1, 4991, '\p{^Is_Block=	Ethiopic SUPPLEMENT}', "");
Expect(1, 4991, '\P{Is_Block=	Ethiopic SUPPLEMENT}', "");
Expect(0, 4991, '\P{^Is_Block=	Ethiopic SUPPLEMENT}', "");
Error('\p{Is_Blk= -Ethiopic/a/Supplement}');
Error('\P{Is_Blk= -Ethiopic/a/Supplement}');
Expect(1, 5023, '\p{Is_Blk=ethiopicsupplement}', "");
Expect(0, 5023, '\p{^Is_Blk=ethiopicsupplement}', "");
Expect(0, 5023, '\P{Is_Blk=ethiopicsupplement}', "");
Expect(1, 5023, '\P{^Is_Blk=ethiopicsupplement}', "");
Expect(0, 4991, '\p{Is_Blk=ethiopicsupplement}', "");
Expect(1, 4991, '\p{^Is_Blk=ethiopicsupplement}', "");
Expect(1, 4991, '\P{Is_Blk=ethiopicsupplement}', "");
Expect(0, 4991, '\P{^Is_Blk=ethiopicsupplement}', "");
Expect(1, 5023, '\p{Is_Blk= 	Ethiopic	Supplement}', "");
Expect(0, 5023, '\p{^Is_Blk= 	Ethiopic	Supplement}', "");
Expect(0, 5023, '\P{Is_Blk= 	Ethiopic	Supplement}', "");
Expect(1, 5023, '\P{^Is_Blk= 	Ethiopic	Supplement}', "");
Expect(0, 4991, '\p{Is_Blk= 	Ethiopic	Supplement}', "");
Expect(1, 4991, '\p{^Is_Blk= 	Ethiopic	Supplement}', "");
Expect(1, 4991, '\P{Is_Blk= 	Ethiopic	Supplement}', "");
Expect(0, 4991, '\P{^Is_Blk= 	Ethiopic	Supplement}', "");
Error('\p{Block= :=linear-B SYLLABARY}');
Error('\P{Block= :=linear-B SYLLABARY}');
Expect(1, 65663, '\p{Block=linearbsyllabary}', "");
Expect(0, 65663, '\p{^Block=linearbsyllabary}', "");
Expect(0, 65663, '\P{Block=linearbsyllabary}', "");
Expect(1, 65663, '\P{^Block=linearbsyllabary}', "");
Expect(0, 1, '\p{Block=linearbsyllabary}', "");
Expect(1, 1, '\p{^Block=linearbsyllabary}', "");
Expect(1, 1, '\P{Block=linearbsyllabary}', "");
Expect(0, 1, '\P{^Block=linearbsyllabary}', "");
Expect(1, 65663, '\p{Block=  Linear_B_syllabary}', "");
Expect(0, 65663, '\p{^Block=  Linear_B_syllabary}', "");
Expect(0, 65663, '\P{Block=  Linear_B_syllabary}', "");
Expect(1, 65663, '\P{^Block=  Linear_B_syllabary}', "");
Expect(0, 1, '\p{Block=  Linear_B_syllabary}', "");
Expect(1, 1, '\p{^Block=  Linear_B_syllabary}', "");
Expect(1, 1, '\P{Block=  Linear_B_syllabary}', "");
Expect(0, 1, '\P{^Block=  Linear_B_syllabary}', "");
Error('\p{Blk=:=_-linear_B	SYLLABARY}');
Error('\P{Blk=:=_-linear_B	SYLLABARY}');
Expect(1, 65663, '\p{Blk=linearbsyllabary}', "");
Expect(0, 65663, '\p{^Blk=linearbsyllabary}', "");
Expect(0, 65663, '\P{Blk=linearbsyllabary}', "");
Expect(1, 65663, '\P{^Blk=linearbsyllabary}', "");
Expect(0, 1, '\p{Blk=linearbsyllabary}', "");
Expect(1, 1, '\p{^Blk=linearbsyllabary}', "");
Expect(1, 1, '\P{Blk=linearbsyllabary}', "");
Expect(0, 1, '\P{^Blk=linearbsyllabary}', "");
Expect(1, 65663, '\p{Blk=--Linear B_SYLLABARY}', "");
Expect(0, 65663, '\p{^Blk=--Linear B_SYLLABARY}', "");
Expect(0, 65663, '\P{Blk=--Linear B_SYLLABARY}', "");
Expect(1, 65663, '\P{^Blk=--Linear B_SYLLABARY}', "");
Expect(0, 1, '\p{Blk=--Linear B_SYLLABARY}', "");
Expect(1, 1, '\p{^Blk=--Linear B_SYLLABARY}', "");
Expect(1, 1, '\P{Blk=--Linear B_SYLLABARY}', "");
Expect(0, 1, '\P{^Blk=--Linear B_SYLLABARY}', "");
Error('\p{Is_Block=:=_	LinearbSyllabary}');
Error('\P{Is_Block=:=_	LinearbSyllabary}');
Expect(1, 65663, '\p{Is_Block=linearbsyllabary}', "");
Expect(0, 65663, '\p{^Is_Block=linearbsyllabary}', "");
Expect(0, 65663, '\P{Is_Block=linearbsyllabary}', "");
Expect(1, 65663, '\P{^Is_Block=linearbsyllabary}', "");
Expect(0, 1, '\p{Is_Block=linearbsyllabary}', "");
Expect(1, 1, '\p{^Is_Block=linearbsyllabary}', "");
Expect(1, 1, '\P{Is_Block=linearbsyllabary}', "");
Expect(0, 1, '\P{^Is_Block=linearbsyllabary}', "");
Expect(1, 65663, '\p{Is_Block= -linear_B Syllabary}', "");
Expect(0, 65663, '\p{^Is_Block= -linear_B Syllabary}', "");
Expect(0, 65663, '\P{Is_Block= -linear_B Syllabary}', "");
Expect(1, 65663, '\P{^Is_Block= -linear_B Syllabary}', "");
Expect(0, 1, '\p{Is_Block= -linear_B Syllabary}', "");
Expect(1, 1, '\p{^Is_Block= -linear_B Syllabary}', "");
Expect(1, 1, '\P{Is_Block= -linear_B Syllabary}', "");
Expect(0, 1, '\P{^Is_Block= -linear_B Syllabary}', "");
Error('\p{Is_Blk=-:=Linear-b_Syllabary}');
Error('\P{Is_Blk=-:=Linear-b_Syllabary}');
Expect(1, 65663, '\p{Is_Blk=linearbsyllabary}', "");
Expect(0, 65663, '\p{^Is_Blk=linearbsyllabary}', "");
Expect(0, 65663, '\P{Is_Blk=linearbsyllabary}', "");
Expect(1, 65663, '\P{^Is_Blk=linearbsyllabary}', "");
Expect(0, 1, '\p{Is_Blk=linearbsyllabary}', "");
Expect(1, 1, '\p{^Is_Blk=linearbsyllabary}', "");
Expect(1, 1, '\P{Is_Blk=linearbsyllabary}', "");
Expect(0, 1, '\P{^Is_Blk=linearbsyllabary}', "");
Expect(1, 65663, '\p{Is_Blk= Linear B_syllabary}', "");
Expect(0, 65663, '\p{^Is_Blk= Linear B_syllabary}', "");
Expect(0, 65663, '\P{Is_Blk= Linear B_syllabary}', "");
Expect(1, 65663, '\P{^Is_Blk= Linear B_syllabary}', "");
Expect(0, 1, '\p{Is_Blk= Linear B_syllabary}', "");
Expect(1, 1, '\p{^Is_Blk= Linear B_syllabary}', "");
Expect(1, 1, '\P{Is_Blk= Linear B_syllabary}', "");
Expect(0, 1, '\P{^Is_Blk= Linear B_syllabary}', "");
Error('\p{Block= -Enclosed CJK-letters	and:=Months}');
Error('\P{Block= -Enclosed CJK-letters	and:=Months}');
Expect(1, 13055, '\p{Block=enclosedcjklettersandmonths}', "");
Expect(0, 13055, '\p{^Block=enclosedcjklettersandmonths}', "");
Expect(0, 13055, '\P{Block=enclosedcjklettersandmonths}', "");
Expect(1, 13055, '\P{^Block=enclosedcjklettersandmonths}', "");
Expect(0, 12799, '\p{Block=enclosedcjklettersandmonths}', "");
Expect(1, 12799, '\p{^Block=enclosedcjklettersandmonths}', "");
Expect(1, 12799, '\P{Block=enclosedcjklettersandmonths}', "");
Expect(0, 12799, '\P{^Block=enclosedcjklettersandmonths}', "");
Expect(1, 13055, '\p{Block=__enclosedcjk-Letters-and-Months}', "");
Expect(0, 13055, '\p{^Block=__enclosedcjk-Letters-and-Months}', "");
Expect(0, 13055, '\P{Block=__enclosedcjk-Letters-and-Months}', "");
Expect(1, 13055, '\P{^Block=__enclosedcjk-Letters-and-Months}', "");
Expect(0, 12799, '\p{Block=__enclosedcjk-Letters-and-Months}', "");
Expect(1, 12799, '\p{^Block=__enclosedcjk-Letters-and-Months}', "");
Expect(1, 12799, '\P{Block=__enclosedcjk-Letters-and-Months}', "");
Expect(0, 12799, '\P{^Block=__enclosedcjk-Letters-and-Months}', "");
Error('\p{Blk=  enclosedcjk Letters:=andMonths}');
Error('\P{Blk=  enclosedcjk Letters:=andMonths}');
Expect(1, 13055, '\p{Blk=enclosedcjklettersandmonths}', "");
Expect(0, 13055, '\p{^Blk=enclosedcjklettersandmonths}', "");
Expect(0, 13055, '\P{Blk=enclosedcjklettersandmonths}', "");
Expect(1, 13055, '\P{^Blk=enclosedcjklettersandmonths}', "");
Expect(0, 12799, '\p{Blk=enclosedcjklettersandmonths}', "");
Expect(1, 12799, '\p{^Blk=enclosedcjklettersandmonths}', "");
Expect(1, 12799, '\P{Blk=enclosedcjklettersandmonths}', "");
Expect(0, 12799, '\P{^Blk=enclosedcjklettersandmonths}', "");
Expect(1, 13055, '\p{Blk:	 Enclosed CJK	LETTERS And-Months}', "");
Expect(0, 13055, '\p{^Blk:	 Enclosed CJK	LETTERS And-Months}', "");
Expect(0, 13055, '\P{Blk:	 Enclosed CJK	LETTERS And-Months}', "");
Expect(1, 13055, '\P{^Blk:	 Enclosed CJK	LETTERS And-Months}', "");
Expect(0, 12799, '\p{Blk:	 Enclosed CJK	LETTERS And-Months}', "");
Expect(1, 12799, '\p{^Blk:	 Enclosed CJK	LETTERS And-Months}', "");
Expect(1, 12799, '\P{Blk:	 Enclosed CJK	LETTERS And-Months}', "");
Expect(0, 12799, '\P{^Blk:	 Enclosed CJK	LETTERS And-Months}', "");
Error('\p{Is_Block=_/a/EnclosedcjkLetters AND	months}');
Error('\P{Is_Block=_/a/EnclosedcjkLetters AND	months}');
Expect(1, 13055, '\p{Is_Block=enclosedcjklettersandmonths}', "");
Expect(0, 13055, '\p{^Is_Block=enclosedcjklettersandmonths}', "");
Expect(0, 13055, '\P{Is_Block=enclosedcjklettersandmonths}', "");
Expect(1, 13055, '\P{^Is_Block=enclosedcjklettersandmonths}', "");
Expect(0, 12799, '\p{Is_Block=enclosedcjklettersandmonths}', "");
Expect(1, 12799, '\p{^Is_Block=enclosedcjklettersandmonths}', "");
Expect(1, 12799, '\P{Is_Block=enclosedcjklettersandmonths}', "");
Expect(0, 12799, '\P{^Is_Block=enclosedcjklettersandmonths}', "");
Expect(1, 13055, '\p{Is_Block=__enclosed CJK-letters	AndMONTHS}', "");
Expect(0, 13055, '\p{^Is_Block=__enclosed CJK-letters	AndMONTHS}', "");
Expect(0, 13055, '\P{Is_Block=__enclosed CJK-letters	AndMONTHS}', "");
Expect(1, 13055, '\P{^Is_Block=__enclosed CJK-letters	AndMONTHS}', "");
Expect(0, 12799, '\p{Is_Block=__enclosed CJK-letters	AndMONTHS}', "");
Expect(1, 12799, '\p{^Is_Block=__enclosed CJK-letters	AndMONTHS}', "");
Expect(1, 12799, '\P{Is_Block=__enclosed CJK-letters	AndMONTHS}', "");
Expect(0, 12799, '\P{^Is_Block=__enclosed CJK-letters	AndMONTHS}', "");
Error('\p{Is_Blk=-ENCLOSED cjkLetters:=ANDMonths}');
Error('\P{Is_Blk=-ENCLOSED cjkLetters:=ANDMonths}');
Expect(1, 13055, '\p{Is_Blk=enclosedcjklettersandmonths}', "");
Expect(0, 13055, '\p{^Is_Blk=enclosedcjklettersandmonths}', "");
Expect(0, 13055, '\P{Is_Blk=enclosedcjklettersandmonths}', "");
Expect(1, 13055, '\P{^Is_Blk=enclosedcjklettersandmonths}', "");
Expect(0, 12799, '\p{Is_Blk=enclosedcjklettersandmonths}', "");
Expect(1, 12799, '\p{^Is_Blk=enclosedcjklettersandmonths}', "");
Expect(1, 12799, '\P{Is_Blk=enclosedcjklettersandmonths}', "");
Expect(0, 12799, '\P{^Is_Blk=enclosedcjklettersandmonths}', "");
Expect(1, 13055, '\p{Is_Blk=-Enclosed	CJKLetters And	months}', "");
Expect(0, 13055, '\p{^Is_Blk=-Enclosed	CJKLetters And	months}', "");
Expect(0, 13055, '\P{Is_Blk=-Enclosed	CJKLetters And	months}', "");
Expect(1, 13055, '\P{^Is_Blk=-Enclosed	CJKLetters And	months}', "");
Expect(0, 12799, '\p{Is_Blk=-Enclosed	CJKLetters And	months}', "");
Expect(1, 12799, '\p{^Is_Blk=-Enclosed	CJKLetters And	months}', "");
Expect(1, 12799, '\P{Is_Blk=-Enclosed	CJKLetters And	months}', "");
Expect(0, 12799, '\P{^Is_Blk=-Enclosed	CJKLetters And	months}', "");
Error('\p{Block= /a/Combining_Diacritical_Marks_supplement}');
Error('\P{Block= /a/Combining_Diacritical_Marks_supplement}');
Expect(1, 7679, '\p{Block=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7679, '\p{^Block=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7679, '\P{Block=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7679, '\P{^Block=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7615, '\p{Block=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7615, '\p{^Block=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7615, '\P{Block=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7615, '\P{^Block=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7679, '\p{Block=	combining	diacritical marksSupplement}', "");
Expect(0, 7679, '\p{^Block=	combining	diacritical marksSupplement}', "");
Expect(0, 7679, '\P{Block=	combining	diacritical marksSupplement}', "");
Expect(1, 7679, '\P{^Block=	combining	diacritical marksSupplement}', "");
Expect(0, 7615, '\p{Block=	combining	diacritical marksSupplement}', "");
Expect(1, 7615, '\p{^Block=	combining	diacritical marksSupplement}', "");
Expect(1, 7615, '\P{Block=	combining	diacritical marksSupplement}', "");
Expect(0, 7615, '\P{^Block=	combining	diacritical marksSupplement}', "");
Error('\p{Blk=--COMBINING:=diacritical-MarksSupplement}');
Error('\P{Blk=--COMBINING:=diacritical-MarksSupplement}');
Expect(1, 7679, '\p{Blk=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7679, '\p{^Blk=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7679, '\P{Blk=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7679, '\P{^Blk=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7615, '\p{Blk=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7615, '\p{^Blk=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7615, '\P{Blk=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7615, '\P{^Blk=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7679, '\p{Blk=		Combining diacritical MARKS-Supplement}', "");
Expect(0, 7679, '\p{^Blk=		Combining diacritical MARKS-Supplement}', "");
Expect(0, 7679, '\P{Blk=		Combining diacritical MARKS-Supplement}', "");
Expect(1, 7679, '\P{^Blk=		Combining diacritical MARKS-Supplement}', "");
Expect(0, 7615, '\p{Blk=		Combining diacritical MARKS-Supplement}', "");
Expect(1, 7615, '\p{^Blk=		Combining diacritical MARKS-Supplement}', "");
Expect(1, 7615, '\P{Blk=		Combining diacritical MARKS-Supplement}', "");
Expect(0, 7615, '\P{^Blk=		Combining diacritical MARKS-Supplement}', "");
Error('\p{Is_Block= Combining DIACRITICAL:=marks-Supplement}');
Error('\P{Is_Block= Combining DIACRITICAL:=marks-Supplement}');
Expect(1, 7679, '\p{Is_Block=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7679, '\p{^Is_Block=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7679, '\P{Is_Block=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7679, '\P{^Is_Block=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7615, '\p{Is_Block=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7615, '\p{^Is_Block=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7615, '\P{Is_Block=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7615, '\P{^Is_Block=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7679, '\p{Is_Block= Combining-DIACRITICAL	Marks_Supplement}', "");
Expect(0, 7679, '\p{^Is_Block= Combining-DIACRITICAL	Marks_Supplement}', "");
Expect(0, 7679, '\P{Is_Block= Combining-DIACRITICAL	Marks_Supplement}', "");
Expect(1, 7679, '\P{^Is_Block= Combining-DIACRITICAL	Marks_Supplement}', "");
Expect(0, 7615, '\p{Is_Block= Combining-DIACRITICAL	Marks_Supplement}', "");
Expect(1, 7615, '\p{^Is_Block= Combining-DIACRITICAL	Marks_Supplement}', "");
Expect(1, 7615, '\P{Is_Block= Combining-DIACRITICAL	Marks_Supplement}', "");
Expect(0, 7615, '\P{^Is_Block= Combining-DIACRITICAL	Marks_Supplement}', "");
Error('\p{Is_Blk= /a/Combiningdiacritical marks	SUPPLEMENT}');
Error('\P{Is_Blk= /a/Combiningdiacritical marks	SUPPLEMENT}');
Expect(1, 7679, '\p{Is_Blk=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7679, '\p{^Is_Blk=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7679, '\P{Is_Blk=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7679, '\P{^Is_Blk=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7615, '\p{Is_Blk=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7615, '\p{^Is_Blk=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7615, '\P{Is_Blk=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7615, '\P{^Is_Blk=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7679, '\p{Is_Blk=	_combining-DIACRITICALmarks_Supplement}', "");
Expect(0, 7679, '\p{^Is_Blk=	_combining-DIACRITICALmarks_Supplement}', "");
Expect(0, 7679, '\P{Is_Blk=	_combining-DIACRITICALmarks_Supplement}', "");
Expect(1, 7679, '\P{^Is_Blk=	_combining-DIACRITICALmarks_Supplement}', "");
Expect(0, 7615, '\p{Is_Blk=	_combining-DIACRITICALmarks_Supplement}', "");
Expect(1, 7615, '\p{^Is_Blk=	_combining-DIACRITICALmarks_Supplement}', "");
Expect(1, 7615, '\P{Is_Blk=	_combining-DIACRITICALmarks_Supplement}', "");
Expect(0, 7615, '\P{^Is_Blk=	_combining-DIACRITICALmarks_Supplement}', "");
Error('\p{Block=/a/	 BOPOMOFO}');
Error('\P{Block=/a/	 BOPOMOFO}');
Expect(1, 12591, '\p{Block=bopomofo}', "");
Expect(0, 12591, '\p{^Block=bopomofo}', "");
Expect(0, 12591, '\P{Block=bopomofo}', "");
Expect(1, 12591, '\P{^Block=bopomofo}', "");
Expect(0, 12543, '\p{Block=bopomofo}', "");
Expect(1, 12543, '\p{^Block=bopomofo}', "");
Expect(1, 12543, '\P{Block=bopomofo}', "");
Expect(0, 12543, '\P{^Block=bopomofo}', "");
Expect(1, 12591, '\p{Block=- Bopomofo}', "");
Expect(0, 12591, '\p{^Block=- Bopomofo}', "");
Expect(0, 12591, '\P{Block=- Bopomofo}', "");
Expect(1, 12591, '\P{^Block=- Bopomofo}', "");
Expect(0, 12543, '\p{Block=- Bopomofo}', "");
Expect(1, 12543, '\p{^Block=- Bopomofo}', "");
Expect(1, 12543, '\P{Block=- Bopomofo}', "");
Expect(0, 12543, '\P{^Block=- Bopomofo}', "");
Error('\p{Blk=	BOPOMOFO:=}');
Error('\P{Blk=	BOPOMOFO:=}');
Expect(1, 12591, '\p{Blk=bopomofo}', "");
Expect(0, 12591, '\p{^Blk=bopomofo}', "");
Expect(0, 12591, '\P{Blk=bopomofo}', "");
Expect(1, 12591, '\P{^Blk=bopomofo}', "");
Expect(0, 12543, '\p{Blk=bopomofo}', "");
Expect(1, 12543, '\p{^Blk=bopomofo}', "");
Expect(1, 12543, '\P{Blk=bopomofo}', "");
Expect(0, 12543, '\P{^Blk=bopomofo}', "");
Expect(1, 12591, '\p{Blk:   		BOPOMOFO}', "");
Expect(0, 12591, '\p{^Blk:   		BOPOMOFO}', "");
Expect(0, 12591, '\P{Blk:   		BOPOMOFO}', "");
Expect(1, 12591, '\P{^Blk:   		BOPOMOFO}', "");
Expect(0, 12543, '\p{Blk:   		BOPOMOFO}', "");
Expect(1, 12543, '\p{^Blk:   		BOPOMOFO}', "");
Expect(1, 12543, '\P{Blk:   		BOPOMOFO}', "");
Expect(0, 12543, '\P{^Blk:   		BOPOMOFO}', "");
Error('\p{Is_Block=/a/- BOPOMOFO}');
Error('\P{Is_Block=/a/- BOPOMOFO}');
Expect(1, 12591, '\p{Is_Block=bopomofo}', "");
Expect(0, 12591, '\p{^Is_Block=bopomofo}', "");
Expect(0, 12591, '\P{Is_Block=bopomofo}', "");
Expect(1, 12591, '\P{^Is_Block=bopomofo}', "");
Expect(0, 12543, '\p{Is_Block=bopomofo}', "");
Expect(1, 12543, '\p{^Is_Block=bopomofo}', "");
Expect(1, 12543, '\P{Is_Block=bopomofo}', "");
Expect(0, 12543, '\P{^Is_Block=bopomofo}', "");
Expect(1, 12591, '\p{Is_Block=_ BOPOMOFO}', "");
Expect(0, 12591, '\p{^Is_Block=_ BOPOMOFO}', "");
Expect(0, 12591, '\P{Is_Block=_ BOPOMOFO}', "");
Expect(1, 12591, '\P{^Is_Block=_ BOPOMOFO}', "");
Expect(0, 12543, '\p{Is_Block=_ BOPOMOFO}', "");
Expect(1, 12543, '\p{^Is_Block=_ BOPOMOFO}', "");
Expect(1, 12543, '\P{Is_Block=_ BOPOMOFO}', "");
Expect(0, 12543, '\P{^Is_Block=_ BOPOMOFO}', "");
Error('\p{Is_Blk: :=  bopomofo}');
Error('\P{Is_Blk: :=  bopomofo}');
Expect(1, 12591, '\p{Is_Blk=bopomofo}', "");
Expect(0, 12591, '\p{^Is_Blk=bopomofo}', "");
Expect(0, 12591, '\P{Is_Blk=bopomofo}', "");
Expect(1, 12591, '\P{^Is_Blk=bopomofo}', "");
Expect(0, 12543, '\p{Is_Blk=bopomofo}', "");
Expect(1, 12543, '\p{^Is_Blk=bopomofo}', "");
Expect(1, 12543, '\P{Is_Blk=bopomofo}', "");
Expect(0, 12543, '\P{^Is_Blk=bopomofo}', "");
Expect(1, 12591, '\p{Is_Blk=		Bopomofo}', "");
Expect(0, 12591, '\p{^Is_Blk=		Bopomofo}', "");
Expect(0, 12591, '\P{Is_Blk=		Bopomofo}', "");
Expect(1, 12591, '\P{^Is_Blk=		Bopomofo}', "");
Expect(0, 12543, '\p{Is_Blk=		Bopomofo}', "");
Expect(1, 12543, '\p{^Is_Blk=		Bopomofo}', "");
Expect(1, 12543, '\P{Is_Blk=		Bopomofo}', "");
Expect(0, 12543, '\P{^Is_Blk=		Bopomofo}', "");
Error('\p{Block=/a/ _MISCELLANEOUS-technical}');
Error('\P{Block=/a/ _MISCELLANEOUS-technical}');
Expect(1, 9215, '\p{Block=miscellaneoustechnical}', "");
Expect(0, 9215, '\p{^Block=miscellaneoustechnical}', "");
Expect(0, 9215, '\P{Block=miscellaneoustechnical}', "");
Expect(1, 9215, '\P{^Block=miscellaneoustechnical}', "");
Expect(0, 8959, '\p{Block=miscellaneoustechnical}', "");
Expect(1, 8959, '\p{^Block=miscellaneoustechnical}', "");
Expect(1, 8959, '\P{Block=miscellaneoustechnical}', "");
Expect(0, 8959, '\P{^Block=miscellaneoustechnical}', "");
Expect(1, 9215, '\p{Block= Miscellaneous-TECHNICAL}', "");
Expect(0, 9215, '\p{^Block= Miscellaneous-TECHNICAL}', "");
Expect(0, 9215, '\P{Block= Miscellaneous-TECHNICAL}', "");
Expect(1, 9215, '\P{^Block= Miscellaneous-TECHNICAL}', "");
Expect(0, 8959, '\p{Block= Miscellaneous-TECHNICAL}', "");
Expect(1, 8959, '\p{^Block= Miscellaneous-TECHNICAL}', "");
Expect(1, 8959, '\P{Block= Miscellaneous-TECHNICAL}', "");
Expect(0, 8959, '\P{^Block= Miscellaneous-TECHNICAL}', "");
Error('\p{Blk=_MISCELLANEOUS/a/Technical}');
Error('\P{Blk=_MISCELLANEOUS/a/Technical}');
Expect(1, 9215, '\p{Blk=miscellaneoustechnical}', "");
Expect(0, 9215, '\p{^Blk=miscellaneoustechnical}', "");
Expect(0, 9215, '\P{Blk=miscellaneoustechnical}', "");
Expect(1, 9215, '\P{^Blk=miscellaneoustechnical}', "");
Expect(0, 8959, '\p{Blk=miscellaneoustechnical}', "");
Expect(1, 8959, '\p{^Blk=miscellaneoustechnical}', "");
Expect(1, 8959, '\P{Blk=miscellaneoustechnical}', "");
Expect(0, 8959, '\P{^Blk=miscellaneoustechnical}', "");
Expect(1, 9215, '\p{Blk=MiscellaneousTechnical}', "");
Expect(0, 9215, '\p{^Blk=MiscellaneousTechnical}', "");
Expect(0, 9215, '\P{Blk=MiscellaneousTechnical}', "");
Expect(1, 9215, '\P{^Blk=MiscellaneousTechnical}', "");
Expect(0, 8959, '\p{Blk=MiscellaneousTechnical}', "");
Expect(1, 8959, '\p{^Blk=MiscellaneousTechnical}', "");
Expect(1, 8959, '\P{Blk=MiscellaneousTechnical}', "");
Expect(0, 8959, '\P{^Blk=MiscellaneousTechnical}', "");
Error('\p{Is_Block=/a/	Miscellaneous-Technical}');
Error('\P{Is_Block=/a/	Miscellaneous-Technical}');
Expect(1, 9215, '\p{Is_Block=miscellaneoustechnical}', "");
Expect(0, 9215, '\p{^Is_Block=miscellaneoustechnical}', "");
Expect(0, 9215, '\P{Is_Block=miscellaneoustechnical}', "");
Expect(1, 9215, '\P{^Is_Block=miscellaneoustechnical}', "");
Expect(0, 8959, '\p{Is_Block=miscellaneoustechnical}', "");
Expect(1, 8959, '\p{^Is_Block=miscellaneoustechnical}', "");
Expect(1, 8959, '\P{Is_Block=miscellaneoustechnical}', "");
Expect(0, 8959, '\P{^Is_Block=miscellaneoustechnical}', "");
Expect(1, 9215, '\p{Is_Block=_Miscellaneous TECHNICAL}', "");
Expect(0, 9215, '\p{^Is_Block=_Miscellaneous TECHNICAL}', "");
Expect(0, 9215, '\P{Is_Block=_Miscellaneous TECHNICAL}', "");
Expect(1, 9215, '\P{^Is_Block=_Miscellaneous TECHNICAL}', "");
Expect(0, 8959, '\p{Is_Block=_Miscellaneous TECHNICAL}', "");
Expect(1, 8959, '\p{^Is_Block=_Miscellaneous TECHNICAL}', "");
Expect(1, 8959, '\P{Is_Block=_Miscellaneous TECHNICAL}', "");
Expect(0, 8959, '\P{^Is_Block=_Miscellaneous TECHNICAL}', "");
Error('\p{Is_Blk=_/a/MISCELLANEOUS Technical}');
Error('\P{Is_Blk=_/a/MISCELLANEOUS Technical}');
Expect(1, 9215, '\p{Is_Blk=miscellaneoustechnical}', "");
Expect(0, 9215, '\p{^Is_Blk=miscellaneoustechnical}', "");
Expect(0, 9215, '\P{Is_Blk=miscellaneoustechnical}', "");
Expect(1, 9215, '\P{^Is_Blk=miscellaneoustechnical}', "");
Expect(0, 8959, '\p{Is_Blk=miscellaneoustechnical}', "");
Expect(1, 8959, '\p{^Is_Blk=miscellaneoustechnical}', "");
Expect(1, 8959, '\P{Is_Blk=miscellaneoustechnical}', "");
Expect(0, 8959, '\P{^Is_Blk=miscellaneoustechnical}', "");
Expect(1, 9215, '\p{Is_Blk= _miscellaneous	TECHNICAL}', "");
Expect(0, 9215, '\p{^Is_Blk= _miscellaneous	TECHNICAL}', "");
Expect(0, 9215, '\P{Is_Blk= _miscellaneous	TECHNICAL}', "");
Expect(1, 9215, '\P{^Is_Blk= _miscellaneous	TECHNICAL}', "");
Expect(0, 8959, '\p{Is_Blk= _miscellaneous	TECHNICAL}', "");
Expect(1, 8959, '\p{^Is_Blk= _miscellaneous	TECHNICAL}', "");
Expect(1, 8959, '\P{Is_Blk= _miscellaneous	TECHNICAL}', "");
Expect(0, 8959, '\P{^Is_Blk= _miscellaneous	TECHNICAL}', "");
Error('\p{Block=	_Osmanya/a/}');
Error('\P{Block=	_Osmanya/a/}');
Expect(1, 66735, '\p{Block=osmanya}', "");
Expect(0, 66735, '\p{^Block=osmanya}', "");
Expect(0, 66735, '\P{Block=osmanya}', "");
Expect(1, 66735, '\P{^Block=osmanya}', "");
Expect(0, 66687, '\p{Block=osmanya}', "");
Expect(1, 66687, '\p{^Block=osmanya}', "");
Expect(1, 66687, '\P{Block=osmanya}', "");
Expect(0, 66687, '\P{^Block=osmanya}', "");
Expect(1, 66735, '\p{Block=_	Osmanya}', "");
Expect(0, 66735, '\p{^Block=_	Osmanya}', "");
Expect(0, 66735, '\P{Block=_	Osmanya}', "");
Expect(1, 66735, '\P{^Block=_	Osmanya}', "");
Expect(0, 66687, '\p{Block=_	Osmanya}', "");
Expect(1, 66687, '\p{^Block=_	Osmanya}', "");
Expect(1, 66687, '\P{Block=_	Osmanya}', "");
Expect(0, 66687, '\P{^Block=_	Osmanya}', "");
Error('\p{Blk=-/a/OSMANYA}');
Error('\P{Blk=-/a/OSMANYA}');
Expect(1, 66735, '\p{Blk=osmanya}', "");
Expect(0, 66735, '\p{^Blk=osmanya}', "");
Expect(0, 66735, '\P{Blk=osmanya}', "");
Expect(1, 66735, '\P{^Blk=osmanya}', "");
Expect(0, 66687, '\p{Blk=osmanya}', "");
Expect(1, 66687, '\p{^Blk=osmanya}', "");
Expect(1, 66687, '\P{Blk=osmanya}', "");
Expect(0, 66687, '\P{^Blk=osmanya}', "");
Expect(1, 66735, '\p{Blk=	-OSMANYA}', "");
Expect(0, 66735, '\p{^Blk=	-OSMANYA}', "");
Expect(0, 66735, '\P{Blk=	-OSMANYA}', "");
Expect(1, 66735, '\P{^Blk=	-OSMANYA}', "");
Expect(0, 66687, '\p{Blk=	-OSMANYA}', "");
Expect(1, 66687, '\p{^Blk=	-OSMANYA}', "");
Expect(1, 66687, '\P{Blk=	-OSMANYA}', "");
Expect(0, 66687, '\P{^Blk=	-OSMANYA}', "");
Error('\p{Is_Block= :=OSMANYA}');
Error('\P{Is_Block= :=OSMANYA}');
Expect(1, 66735, '\p{Is_Block=osmanya}', "");
Expect(0, 66735, '\p{^Is_Block=osmanya}', "");
Expect(0, 66735, '\P{Is_Block=osmanya}', "");
Expect(1, 66735, '\P{^Is_Block=osmanya}', "");
Expect(0, 66687, '\p{Is_Block=osmanya}', "");
Expect(1, 66687, '\p{^Is_Block=osmanya}', "");
Expect(1, 66687, '\P{Is_Block=osmanya}', "");
Expect(0, 66687, '\P{^Is_Block=osmanya}', "");
Expect(1, 66735, '\p{Is_Block=  Osmanya}', "");
Expect(0, 66735, '\p{^Is_Block=  Osmanya}', "");
Expect(0, 66735, '\P{Is_Block=  Osmanya}', "");
Expect(1, 66735, '\P{^Is_Block=  Osmanya}', "");
Expect(0, 66687, '\p{Is_Block=  Osmanya}', "");
Expect(1, 66687, '\p{^Is_Block=  Osmanya}', "");
Expect(1, 66687, '\P{Is_Block=  Osmanya}', "");
Expect(0, 66687, '\P{^Is_Block=  Osmanya}', "");
Error('\p{Is_Blk=:=- osmanya}');
Error('\P{Is_Blk=:=- osmanya}');
Expect(1, 66735, '\p{Is_Blk=osmanya}', "");
Expect(0, 66735, '\p{^Is_Blk=osmanya}', "");
Expect(0, 66735, '\P{Is_Blk=osmanya}', "");
Expect(1, 66735, '\P{^Is_Blk=osmanya}', "");
Expect(0, 66687, '\p{Is_Blk=osmanya}', "");
Expect(1, 66687, '\p{^Is_Blk=osmanya}', "");
Expect(1, 66687, '\P{Is_Blk=osmanya}', "");
Expect(0, 66687, '\P{^Is_Blk=osmanya}', "");
Expect(1, 66735, '\p{Is_Blk=-OSMANYA}', "");
Expect(0, 66735, '\p{^Is_Blk=-OSMANYA}', "");
Expect(0, 66735, '\P{Is_Blk=-OSMANYA}', "");
Expect(1, 66735, '\P{^Is_Blk=-OSMANYA}', "");
Expect(0, 66687, '\p{Is_Blk=-OSMANYA}', "");
Expect(1, 66687, '\p{^Is_Blk=-OSMANYA}', "");
Expect(1, 66687, '\P{Is_Blk=-OSMANYA}', "");
Expect(0, 66687, '\P{^Is_Blk=-OSMANYA}', "");
Error('\p{Block=_ MAHJONG:=tiles}');
Error('\P{Block=_ MAHJONG:=tiles}');
Expect(1, 127023, '\p{Block=mahjongtiles}', "");
Expect(0, 127023, '\p{^Block=mahjongtiles}', "");
Expect(0, 127023, '\P{Block=mahjongtiles}', "");
Expect(1, 127023, '\P{^Block=mahjongtiles}', "");
Expect(0, 126975, '\p{Block=mahjongtiles}', "");
Expect(1, 126975, '\p{^Block=mahjongtiles}', "");
Expect(1, 126975, '\P{Block=mahjongtiles}', "");
Expect(0, 126975, '\P{^Block=mahjongtiles}', "");
Expect(1, 127023, '\p{Block=_-Mahjong	Tiles}', "");
Expect(0, 127023, '\p{^Block=_-Mahjong	Tiles}', "");
Expect(0, 127023, '\P{Block=_-Mahjong	Tiles}', "");
Expect(1, 127023, '\P{^Block=_-Mahjong	Tiles}', "");
Expect(0, 126975, '\p{Block=_-Mahjong	Tiles}', "");
Expect(1, 126975, '\p{^Block=_-Mahjong	Tiles}', "");
Expect(1, 126975, '\P{Block=_-Mahjong	Tiles}', "");
Expect(0, 126975, '\P{^Block=_-Mahjong	Tiles}', "");
Error('\p{Blk=_ Mahjong:=Tiles}');
Error('\P{Blk=_ Mahjong:=Tiles}');
Expect(1, 127023, '\p{Blk=mahjongtiles}', "");
Expect(0, 127023, '\p{^Blk=mahjongtiles}', "");
Expect(0, 127023, '\P{Blk=mahjongtiles}', "");
Expect(1, 127023, '\P{^Blk=mahjongtiles}', "");
Expect(0, 126975, '\p{Blk=mahjongtiles}', "");
Expect(1, 126975, '\p{^Blk=mahjongtiles}', "");
Expect(1, 126975, '\P{Blk=mahjongtiles}', "");
Expect(0, 126975, '\P{^Blk=mahjongtiles}', "");
Expect(1, 127023, '\p{Blk=_mahjong-Tiles}', "");
Expect(0, 127023, '\p{^Blk=_mahjong-Tiles}', "");
Expect(0, 127023, '\P{Blk=_mahjong-Tiles}', "");
Expect(1, 127023, '\P{^Blk=_mahjong-Tiles}', "");
Expect(0, 126975, '\p{Blk=_mahjong-Tiles}', "");
Expect(1, 126975, '\p{^Blk=_mahjong-Tiles}', "");
Expect(1, 126975, '\P{Blk=_mahjong-Tiles}', "");
Expect(0, 126975, '\P{^Blk=_mahjong-Tiles}', "");
Error('\p{Is_Block=/a/Mahjong	TILES}');
Error('\P{Is_Block=/a/Mahjong	TILES}');
Expect(1, 127023, '\p{Is_Block=mahjongtiles}', "");
Expect(0, 127023, '\p{^Is_Block=mahjongtiles}', "");
Expect(0, 127023, '\P{Is_Block=mahjongtiles}', "");
Expect(1, 127023, '\P{^Is_Block=mahjongtiles}', "");
Expect(0, 126975, '\p{Is_Block=mahjongtiles}', "");
Expect(1, 126975, '\p{^Is_Block=mahjongtiles}', "");
Expect(1, 126975, '\P{Is_Block=mahjongtiles}', "");
Expect(0, 126975, '\P{^Is_Block=mahjongtiles}', "");
Expect(1, 127023, '\p{Is_Block=_mahjong_tiles}', "");
Expect(0, 127023, '\p{^Is_Block=_mahjong_tiles}', "");
Expect(0, 127023, '\P{Is_Block=_mahjong_tiles}', "");
Expect(1, 127023, '\P{^Is_Block=_mahjong_tiles}', "");
Expect(0, 126975, '\p{Is_Block=_mahjong_tiles}', "");
Expect(1, 126975, '\p{^Is_Block=_mahjong_tiles}', "");
Expect(1, 126975, '\P{Is_Block=_mahjong_tiles}', "");
Expect(0, 126975, '\P{^Is_Block=_mahjong_tiles}', "");
Error('\p{Is_Blk:	/a/	Mahjong-TILES}');
Error('\P{Is_Blk:	/a/	Mahjong-TILES}');
Expect(1, 127023, '\p{Is_Blk=mahjongtiles}', "");
Expect(0, 127023, '\p{^Is_Blk=mahjongtiles}', "");
Expect(0, 127023, '\P{Is_Blk=mahjongtiles}', "");
Expect(1, 127023, '\P{^Is_Blk=mahjongtiles}', "");
Expect(0, 126975, '\p{Is_Blk=mahjongtiles}', "");
Expect(1, 126975, '\p{^Is_Blk=mahjongtiles}', "");
Expect(1, 126975, '\P{Is_Blk=mahjongtiles}', "");
Expect(0, 126975, '\P{^Is_Blk=mahjongtiles}', "");
Expect(1, 127023, '\p{Is_Blk= _mahjong_TILES}', "");
Expect(0, 127023, '\p{^Is_Blk= _mahjong_TILES}', "");
Expect(0, 127023, '\P{Is_Blk= _mahjong_TILES}', "");
Expect(1, 127023, '\P{^Is_Blk= _mahjong_TILES}', "");
Expect(0, 126975, '\p{Is_Blk= _mahjong_TILES}', "");
Expect(1, 126975, '\p{^Is_Blk= _mahjong_TILES}', "");
Expect(1, 126975, '\P{Is_Blk= _mahjong_TILES}', "");
Expect(0, 126975, '\P{^Is_Blk= _mahjong_TILES}', "");
Error('\p{Block=		ARROWS/a/}');
Error('\P{Block=		ARROWS/a/}');
Expect(1, 8703, '\p{Block: arrows}', "");
Expect(0, 8703, '\p{^Block: arrows}', "");
Expect(0, 8703, '\P{Block: arrows}', "");
Expect(1, 8703, '\P{^Block: arrows}', "");
Expect(0, 8591, '\p{Block: arrows}', "");
Expect(1, 8591, '\p{^Block: arrows}', "");
Expect(1, 8591, '\P{Block: arrows}', "");
Expect(0, 8591, '\P{^Block: arrows}', "");
Expect(1, 8703, '\p{Block=	-Arrows}', "");
Expect(0, 8703, '\p{^Block=	-Arrows}', "");
Expect(0, 8703, '\P{Block=	-Arrows}', "");
Expect(1, 8703, '\P{^Block=	-Arrows}', "");
Expect(0, 8591, '\p{Block=	-Arrows}', "");
Expect(1, 8591, '\p{^Block=	-Arrows}', "");
Expect(1, 8591, '\P{Block=	-Arrows}', "");
Expect(0, 8591, '\P{^Block=	-Arrows}', "");
Error('\p{Blk=	_ARROWS/a/}');
Error('\P{Blk=	_ARROWS/a/}');
Expect(1, 8703, '\p{Blk=arrows}', "");
Expect(0, 8703, '\p{^Blk=arrows}', "");
Expect(0, 8703, '\P{Blk=arrows}', "");
Expect(1, 8703, '\P{^Blk=arrows}', "");
Expect(0, 8591, '\p{Blk=arrows}', "");
Expect(1, 8591, '\p{^Blk=arrows}', "");
Expect(1, 8591, '\P{Blk=arrows}', "");
Expect(0, 8591, '\P{^Blk=arrows}', "");
Expect(1, 8703, '\p{Blk= _arrows}', "");
Expect(0, 8703, '\p{^Blk= _arrows}', "");
Expect(0, 8703, '\P{Blk= _arrows}', "");
Expect(1, 8703, '\P{^Blk= _arrows}', "");
Expect(0, 8591, '\p{Blk= _arrows}', "");
Expect(1, 8591, '\p{^Blk= _arrows}', "");
Expect(1, 8591, '\P{Blk= _arrows}', "");
Expect(0, 8591, '\P{^Blk= _arrows}', "");
Error('\p{Is_Block=:=Arrows}');
Error('\P{Is_Block=:=Arrows}');
Expect(1, 8703, '\p{Is_Block=arrows}', "");
Expect(0, 8703, '\p{^Is_Block=arrows}', "");
Expect(0, 8703, '\P{Is_Block=arrows}', "");
Expect(1, 8703, '\P{^Is_Block=arrows}', "");
Expect(0, 8591, '\p{Is_Block=arrows}', "");
Expect(1, 8591, '\p{^Is_Block=arrows}', "");
Expect(1, 8591, '\P{Is_Block=arrows}', "");
Expect(0, 8591, '\P{^Is_Block=arrows}', "");
Expect(1, 8703, '\p{Is_Block=  Arrows}', "");
Expect(0, 8703, '\p{^Is_Block=  Arrows}', "");
Expect(0, 8703, '\P{Is_Block=  Arrows}', "");
Expect(1, 8703, '\P{^Is_Block=  Arrows}', "");
Expect(0, 8591, '\p{Is_Block=  Arrows}', "");
Expect(1, 8591, '\p{^Is_Block=  Arrows}', "");
Expect(1, 8591, '\P{Is_Block=  Arrows}', "");
Expect(0, 8591, '\P{^Is_Block=  Arrows}', "");
Error('\p{Is_Blk=:=	Arrows}');
Error('\P{Is_Blk=:=	Arrows}');
Expect(1, 8703, '\p{Is_Blk=arrows}', "");
Expect(0, 8703, '\p{^Is_Blk=arrows}', "");
Expect(0, 8703, '\P{Is_Blk=arrows}', "");
Expect(1, 8703, '\P{^Is_Blk=arrows}', "");
Expect(0, 8591, '\p{Is_Blk=arrows}', "");
Expect(1, 8591, '\p{^Is_Blk=arrows}', "");
Expect(1, 8591, '\P{Is_Blk=arrows}', "");
Expect(0, 8591, '\P{^Is_Blk=arrows}', "");
Expect(1, 8703, '\p{Is_Blk=--Arrows}', "");
Expect(0, 8703, '\p{^Is_Blk=--Arrows}', "");
Expect(0, 8703, '\P{Is_Blk=--Arrows}', "");
Expect(1, 8703, '\P{^Is_Blk=--Arrows}', "");
Expect(0, 8591, '\p{Is_Blk=--Arrows}', "");
Expect(1, 8591, '\p{^Is_Blk=--Arrows}', "");
Expect(1, 8591, '\P{Is_Blk=--Arrows}', "");
Expect(0, 8591, '\P{^Is_Blk=--Arrows}', "");
Error('\p{Block=		block/a/elements}');
Error('\P{Block=		block/a/elements}');
Expect(1, 9631, '\p{Block=blockelements}', "");
Expect(0, 9631, '\p{^Block=blockelements}', "");
Expect(0, 9631, '\P{Block=blockelements}', "");
Expect(1, 9631, '\P{^Block=blockelements}', "");
Expect(0, 9599, '\p{Block=blockelements}', "");
Expect(1, 9599, '\p{^Block=blockelements}', "");
Expect(1, 9599, '\P{Block=blockelements}', "");
Expect(0, 9599, '\P{^Block=blockelements}', "");
Expect(1, 9631, '\p{Block=	BLOCKElements}', "");
Expect(0, 9631, '\p{^Block=	BLOCKElements}', "");
Expect(0, 9631, '\P{Block=	BLOCKElements}', "");
Expect(1, 9631, '\P{^Block=	BLOCKElements}', "");
Expect(0, 9599, '\p{Block=	BLOCKElements}', "");
Expect(1, 9599, '\p{^Block=	BLOCKElements}', "");
Expect(1, 9599, '\P{Block=	BLOCKElements}', "");
Expect(0, 9599, '\P{^Block=	BLOCKElements}', "");
Error('\p{Blk=	:=block Elements}');
Error('\P{Blk=	:=block Elements}');
Expect(1, 9631, '\p{Blk=blockelements}', "");
Expect(0, 9631, '\p{^Blk=blockelements}', "");
Expect(0, 9631, '\P{Blk=blockelements}', "");
Expect(1, 9631, '\P{^Blk=blockelements}', "");
Expect(0, 9599, '\p{Blk=blockelements}', "");
Expect(1, 9599, '\p{^Blk=blockelements}', "");
Expect(1, 9599, '\P{Blk=blockelements}', "");
Expect(0, 9599, '\P{^Blk=blockelements}', "");
Expect(1, 9631, '\p{Blk:_ BlockELEMENTS}', "");
Expect(0, 9631, '\p{^Blk:_ BlockELEMENTS}', "");
Expect(0, 9631, '\P{Blk:_ BlockELEMENTS}', "");
Expect(1, 9631, '\P{^Blk:_ BlockELEMENTS}', "");
Expect(0, 9599, '\p{Blk:_ BlockELEMENTS}', "");
Expect(1, 9599, '\p{^Blk:_ BlockELEMENTS}', "");
Expect(1, 9599, '\P{Blk:_ BlockELEMENTS}', "");
Expect(0, 9599, '\P{^Blk:_ BlockELEMENTS}', "");
Error('\p{Is_Block:--BLOCK/a/elements}');
Error('\P{Is_Block:--BLOCK/a/elements}');
Expect(1, 9631, '\p{Is_Block:   blockelements}', "");
Expect(0, 9631, '\p{^Is_Block:   blockelements}', "");
Expect(0, 9631, '\P{Is_Block:   blockelements}', "");
Expect(1, 9631, '\P{^Is_Block:   blockelements}', "");
Expect(0, 9599, '\p{Is_Block:   blockelements}', "");
Expect(1, 9599, '\p{^Is_Block:   blockelements}', "");
Expect(1, 9599, '\P{Is_Block:   blockelements}', "");
Expect(0, 9599, '\P{^Is_Block:   blockelements}', "");
Expect(1, 9631, '\p{Is_Block=	-BLOCK-Elements}', "");
Expect(0, 9631, '\p{^Is_Block=	-BLOCK-Elements}', "");
Expect(0, 9631, '\P{Is_Block=	-BLOCK-Elements}', "");
Expect(1, 9631, '\P{^Is_Block=	-BLOCK-Elements}', "");
Expect(0, 9599, '\p{Is_Block=	-BLOCK-Elements}', "");
Expect(1, 9599, '\p{^Is_Block=	-BLOCK-Elements}', "");
Expect(1, 9599, '\P{Is_Block=	-BLOCK-Elements}', "");
Expect(0, 9599, '\P{^Is_Block=	-BLOCK-Elements}', "");
Error('\p{Is_Blk=		Block_ELEMENTS:=}');
Error('\P{Is_Blk=		Block_ELEMENTS:=}');
Expect(1, 9631, '\p{Is_Blk=blockelements}', "");
Expect(0, 9631, '\p{^Is_Blk=blockelements}', "");
Expect(0, 9631, '\P{Is_Blk=blockelements}', "");
Expect(1, 9631, '\P{^Is_Blk=blockelements}', "");
Expect(0, 9599, '\p{Is_Blk=blockelements}', "");
Expect(1, 9599, '\p{^Is_Blk=blockelements}', "");
Expect(1, 9599, '\P{Is_Blk=blockelements}', "");
Expect(0, 9599, '\P{^Is_Blk=blockelements}', "");
Expect(1, 9631, '\p{Is_Blk=_	BLOCK_Elements}', "");
Expect(0, 9631, '\p{^Is_Blk=_	BLOCK_Elements}', "");
Expect(0, 9631, '\P{Is_Blk=_	BLOCK_Elements}', "");
Expect(1, 9631, '\P{^Is_Blk=_	BLOCK_Elements}', "");
Expect(0, 9599, '\p{Is_Blk=_	BLOCK_Elements}', "");
Expect(1, 9599, '\p{^Is_Blk=_	BLOCK_Elements}', "");
Expect(1, 9599, '\P{Is_Blk=_	BLOCK_Elements}', "");
Expect(0, 9599, '\P{^Is_Blk=_	BLOCK_Elements}', "");
Error('\p{Block= _cjk Strokes:=}');
Error('\P{Block= _cjk Strokes:=}');
Expect(1, 12783, '\p{Block=cjkstrokes}', "");
Expect(0, 12783, '\p{^Block=cjkstrokes}', "");
Expect(0, 12783, '\P{Block=cjkstrokes}', "");
Expect(1, 12783, '\P{^Block=cjkstrokes}', "");
Expect(0, 12735, '\p{Block=cjkstrokes}', "");
Expect(1, 12735, '\p{^Block=cjkstrokes}', "");
Expect(1, 12735, '\P{Block=cjkstrokes}', "");
Expect(0, 12735, '\P{^Block=cjkstrokes}', "");
Expect(1, 12783, '\p{Block=_ CJK_strokes}', "");
Expect(0, 12783, '\p{^Block=_ CJK_strokes}', "");
Expect(0, 12783, '\P{Block=_ CJK_strokes}', "");
Expect(1, 12783, '\P{^Block=_ CJK_strokes}', "");
Expect(0, 12735, '\p{Block=_ CJK_strokes}', "");
Expect(1, 12735, '\p{^Block=_ CJK_strokes}', "");
Expect(1, 12735, '\P{Block=_ CJK_strokes}', "");
Expect(0, 12735, '\P{^Block=_ CJK_strokes}', "");
Error('\p{Blk=	/a/CJK_STROKES}');
Error('\P{Blk=	/a/CJK_STROKES}');
Expect(1, 12783, '\p{Blk: cjkstrokes}', "");
Expect(0, 12783, '\p{^Blk: cjkstrokes}', "");
Expect(0, 12783, '\P{Blk: cjkstrokes}', "");
Expect(1, 12783, '\P{^Blk: cjkstrokes}', "");
Expect(0, 12735, '\p{Blk: cjkstrokes}', "");
Expect(1, 12735, '\p{^Blk: cjkstrokes}', "");
Expect(1, 12735, '\P{Blk: cjkstrokes}', "");
Expect(0, 12735, '\P{^Blk: cjkstrokes}', "");
Expect(1, 12783, '\p{Blk= cjk-strokes}', "");
Expect(0, 12783, '\p{^Blk= cjk-strokes}', "");
Expect(0, 12783, '\P{Blk= cjk-strokes}', "");
Expect(1, 12783, '\P{^Blk= cjk-strokes}', "");
Expect(0, 12735, '\p{Blk= cjk-strokes}', "");
Expect(1, 12735, '\p{^Blk= cjk-strokes}', "");
Expect(1, 12735, '\P{Blk= cjk-strokes}', "");
Expect(0, 12735, '\P{^Blk= cjk-strokes}', "");
Error('\p{Is_Block:	CJK	strokes/a/}');
Error('\P{Is_Block:	CJK	strokes/a/}');
Expect(1, 12783, '\p{Is_Block=cjkstrokes}', "");
Expect(0, 12783, '\p{^Is_Block=cjkstrokes}', "");
Expect(0, 12783, '\P{Is_Block=cjkstrokes}', "");
Expect(1, 12783, '\P{^Is_Block=cjkstrokes}', "");
Expect(0, 12735, '\p{Is_Block=cjkstrokes}', "");
Expect(1, 12735, '\p{^Is_Block=cjkstrokes}', "");
Expect(1, 12735, '\P{Is_Block=cjkstrokes}', "");
Expect(0, 12735, '\P{^Is_Block=cjkstrokes}', "");
Expect(1, 12783, '\p{Is_Block=		CJK	strokes}', "");
Expect(0, 12783, '\p{^Is_Block=		CJK	strokes}', "");
Expect(0, 12783, '\P{Is_Block=		CJK	strokes}', "");
Expect(1, 12783, '\P{^Is_Block=		CJK	strokes}', "");
Expect(0, 12735, '\p{Is_Block=		CJK	strokes}', "");
Expect(1, 12735, '\p{^Is_Block=		CJK	strokes}', "");
Expect(1, 12735, '\P{Is_Block=		CJK	strokes}', "");
Expect(0, 12735, '\P{^Is_Block=		CJK	strokes}', "");
Error('\p{Is_Blk=	:=cjk	Strokes}');
Error('\P{Is_Blk=	:=cjk	Strokes}');
Expect(1, 12783, '\p{Is_Blk=cjkstrokes}', "");
Expect(0, 12783, '\p{^Is_Blk=cjkstrokes}', "");
Expect(0, 12783, '\P{Is_Blk=cjkstrokes}', "");
Expect(1, 12783, '\P{^Is_Blk=cjkstrokes}', "");
Expect(0, 12735, '\p{Is_Blk=cjkstrokes}', "");
Expect(1, 12735, '\p{^Is_Blk=cjkstrokes}', "");
Expect(1, 12735, '\P{Is_Blk=cjkstrokes}', "");
Expect(0, 12735, '\P{^Is_Blk=cjkstrokes}', "");
Expect(1, 12783, '\p{Is_Blk=_	CJK Strokes}', "");
Expect(0, 12783, '\p{^Is_Blk=_	CJK Strokes}', "");
Expect(0, 12783, '\P{Is_Blk=_	CJK Strokes}', "");
Expect(1, 12783, '\P{^Is_Blk=_	CJK Strokes}', "");
Expect(0, 12735, '\p{Is_Blk=_	CJK Strokes}', "");
Expect(1, 12735, '\p{^Is_Blk=_	CJK Strokes}', "");
Expect(1, 12735, '\P{Is_Blk=_	CJK Strokes}', "");
Expect(0, 12735, '\P{^Is_Blk=_	CJK Strokes}', "");
Error('\p{Block=	/a/no	Block}');
Error('\P{Block=	/a/no	Block}');
Expect(1, 2303, '\p{Block=noblock}', "");
Expect(0, 2303, '\p{^Block=noblock}', "");
Expect(0, 2303, '\P{Block=noblock}', "");
Expect(1, 2303, '\P{^Block=noblock}', "");
Expect(0, 2111, '\p{Block=noblock}', "");
Expect(1, 2111, '\p{^Block=noblock}', "");
Expect(1, 2111, '\P{Block=noblock}', "");
Expect(0, 2111, '\P{^Block=noblock}', "");
Expect(1, 2303, '\p{Block=-noBLOCK}', "");
Expect(0, 2303, '\p{^Block=-noBLOCK}', "");
Expect(0, 2303, '\P{Block=-noBLOCK}', "");
Expect(1, 2303, '\P{^Block=-noBLOCK}', "");
Expect(0, 2111, '\p{Block=-noBLOCK}', "");
Expect(1, 2111, '\p{^Block=-noBLOCK}', "");
Expect(1, 2111, '\P{Block=-noBLOCK}', "");
Expect(0, 2111, '\P{^Block=-noBLOCK}', "");
Error('\p{Blk=/a/		No Block}');
Error('\P{Blk=/a/		No Block}');
Expect(1, 2303, '\p{Blk=noblock}', "");
Expect(0, 2303, '\p{^Blk=noblock}', "");
Expect(0, 2303, '\P{Blk=noblock}', "");
Expect(1, 2303, '\P{^Blk=noblock}', "");
Expect(0, 2111, '\p{Blk=noblock}', "");
Expect(1, 2111, '\p{^Blk=noblock}', "");
Expect(1, 2111, '\P{Blk=noblock}', "");
Expect(0, 2111, '\P{^Blk=noblock}', "");
Expect(1, 2303, '\p{Blk= no	block}', "");
Expect(0, 2303, '\p{^Blk= no	block}', "");
Expect(0, 2303, '\P{Blk= no	block}', "");
Expect(1, 2303, '\P{^Blk= no	block}', "");
Expect(0, 2111, '\p{Blk= no	block}', "");
Expect(1, 2111, '\p{^Blk= no	block}', "");
Expect(1, 2111, '\P{Blk= no	block}', "");
Expect(0, 2111, '\P{^Blk= no	block}', "");
Error('\p{Is_Block=:=_ NO_Block}');
Error('\P{Is_Block=:=_ NO_Block}');
Expect(1, 2303, '\p{Is_Block=noblock}', "");
Expect(0, 2303, '\p{^Is_Block=noblock}', "");
Expect(0, 2303, '\P{Is_Block=noblock}', "");
Expect(1, 2303, '\P{^Is_Block=noblock}', "");
Expect(0, 2111, '\p{Is_Block=noblock}', "");
Expect(1, 2111, '\p{^Is_Block=noblock}', "");
Expect(1, 2111, '\P{Is_Block=noblock}', "");
Expect(0, 2111, '\P{^Is_Block=noblock}', "");
Expect(1, 2303, '\p{Is_Block:		 NO	Block}', "");
Expect(0, 2303, '\p{^Is_Block:		 NO	Block}', "");
Expect(0, 2303, '\P{Is_Block:		 NO	Block}', "");
Expect(1, 2303, '\P{^Is_Block:		 NO	Block}', "");
Expect(0, 2111, '\p{Is_Block:		 NO	Block}', "");
Expect(1, 2111, '\p{^Is_Block:		 NO	Block}', "");
Expect(1, 2111, '\P{Is_Block:		 NO	Block}', "");
Expect(0, 2111, '\P{^Is_Block:		 NO	Block}', "");
Error('\p{Is_Blk=	no-Block:=}');
Error('\P{Is_Blk=	no-Block:=}');
Expect(1, 2303, '\p{Is_Blk: noblock}', "");
Expect(0, 2303, '\p{^Is_Blk: noblock}', "");
Expect(0, 2303, '\P{Is_Blk: noblock}', "");
Expect(1, 2303, '\P{^Is_Blk: noblock}', "");
Expect(0, 2111, '\p{Is_Blk: noblock}', "");
Expect(1, 2111, '\p{^Is_Blk: noblock}', "");
Expect(1, 2111, '\P{Is_Blk: noblock}', "");
Expect(0, 2111, '\P{^Is_Blk: noblock}', "");
Expect(1, 2303, '\p{Is_Blk=no_block}', "");
Expect(0, 2303, '\p{^Is_Blk=no_block}', "");
Expect(0, 2303, '\P{Is_Blk=no_block}', "");
Expect(1, 2303, '\P{^Is_Blk=no_block}', "");
Expect(0, 2111, '\p{Is_Blk=no_block}', "");
Expect(1, 2111, '\p{^Is_Blk=no_block}', "");
Expect(1, 2111, '\P{Is_Blk=no_block}', "");
Expect(0, 2111, '\P{^Is_Blk=no_block}', "");
Error('\p{Block=:= _CJK-Compatibility}');
Error('\P{Block=:= _CJK-Compatibility}');
Expect(1, 13311, '\p{Block=cjkcompatibility}', "");
Expect(0, 13311, '\p{^Block=cjkcompatibility}', "");
Expect(0, 13311, '\P{Block=cjkcompatibility}', "");
Expect(1, 13311, '\P{^Block=cjkcompatibility}', "");
Expect(0, 13055, '\p{Block=cjkcompatibility}', "");
Expect(1, 13055, '\p{^Block=cjkcompatibility}', "");
Expect(1, 13055, '\P{Block=cjkcompatibility}', "");
Expect(0, 13055, '\P{^Block=cjkcompatibility}', "");
Expect(1, 13311, '\p{Block=-	CJKCompatibility}', "");
Expect(0, 13311, '\p{^Block=-	CJKCompatibility}', "");
Expect(0, 13311, '\P{Block=-	CJKCompatibility}', "");
Expect(1, 13311, '\P{^Block=-	CJKCompatibility}', "");
Expect(0, 13055, '\p{Block=-	CJKCompatibility}', "");
Expect(1, 13055, '\p{^Block=-	CJKCompatibility}', "");
Expect(1, 13055, '\P{Block=-	CJKCompatibility}', "");
Expect(0, 13055, '\P{^Block=-	CJKCompatibility}', "");
Error('\p{Blk=-CJK/a/COMPATIBILITY}');
Error('\P{Blk=-CJK/a/COMPATIBILITY}');
Expect(1, 13311, '\p{Blk=cjkcompatibility}', "");
Expect(0, 13311, '\p{^Blk=cjkcompatibility}', "");
Expect(0, 13311, '\P{Blk=cjkcompatibility}', "");
Expect(1, 13311, '\P{^Blk=cjkcompatibility}', "");
Expect(0, 13055, '\p{Blk=cjkcompatibility}', "");
Expect(1, 13055, '\p{^Blk=cjkcompatibility}', "");
Expect(1, 13055, '\P{Blk=cjkcompatibility}', "");
Expect(0, 13055, '\P{^Blk=cjkcompatibility}', "");
Expect(1, 13311, '\p{Blk= _cjk_COMPATIBILITY}', "");
Expect(0, 13311, '\p{^Blk= _cjk_COMPATIBILITY}', "");
Expect(0, 13311, '\P{Blk= _cjk_COMPATIBILITY}', "");
Expect(1, 13311, '\P{^Blk= _cjk_COMPATIBILITY}', "");
Expect(0, 13055, '\p{Blk= _cjk_COMPATIBILITY}', "");
Expect(1, 13055, '\p{^Blk= _cjk_COMPATIBILITY}', "");
Expect(1, 13055, '\P{Blk= _cjk_COMPATIBILITY}', "");
Expect(0, 13055, '\P{^Blk= _cjk_COMPATIBILITY}', "");
Error('\p{Is_Block=/a/-	CJK	Compatibility}');
Error('\P{Is_Block=/a/-	CJK	Compatibility}');
Expect(1, 13311, '\p{Is_Block:cjkcompatibility}', "");
Expect(0, 13311, '\p{^Is_Block:cjkcompatibility}', "");
Expect(0, 13311, '\P{Is_Block:cjkcompatibility}', "");
Expect(1, 13311, '\P{^Is_Block:cjkcompatibility}', "");
Expect(0, 13055, '\p{Is_Block:cjkcompatibility}', "");
Expect(1, 13055, '\p{^Is_Block:cjkcompatibility}', "");
Expect(1, 13055, '\P{Is_Block:cjkcompatibility}', "");
Expect(0, 13055, '\P{^Is_Block:cjkcompatibility}', "");
Expect(1, 13311, '\p{Is_Block= -CJK	Compatibility}', "");
Expect(0, 13311, '\p{^Is_Block= -CJK	Compatibility}', "");
Expect(0, 13311, '\P{Is_Block= -CJK	Compatibility}', "");
Expect(1, 13311, '\P{^Is_Block= -CJK	Compatibility}', "");
Expect(0, 13055, '\p{Is_Block= -CJK	Compatibility}', "");
Expect(1, 13055, '\p{^Is_Block= -CJK	Compatibility}', "");
Expect(1, 13055, '\P{Is_Block= -CJK	Compatibility}', "");
Expect(0, 13055, '\P{^Is_Block= -CJK	Compatibility}', "");
Error('\p{Is_Blk=CJK-compatibility/a/}');
Error('\P{Is_Blk=CJK-compatibility/a/}');
Expect(1, 13311, '\p{Is_Blk:   cjkcompatibility}', "");
Expect(0, 13311, '\p{^Is_Blk:   cjkcompatibility}', "");
Expect(0, 13311, '\P{Is_Blk:   cjkcompatibility}', "");
Expect(1, 13311, '\P{^Is_Blk:   cjkcompatibility}', "");
Expect(0, 13055, '\p{Is_Blk:   cjkcompatibility}', "");
Expect(1, 13055, '\p{^Is_Blk:   cjkcompatibility}', "");
Expect(1, 13055, '\P{Is_Blk:   cjkcompatibility}', "");
Expect(0, 13055, '\P{^Is_Blk:   cjkcompatibility}', "");
Expect(1, 13311, '\p{Is_Blk= CJK	Compatibility}', "");
Expect(0, 13311, '\p{^Is_Blk= CJK	Compatibility}', "");
Expect(0, 13311, '\P{Is_Blk= CJK	Compatibility}', "");
Expect(1, 13311, '\P{^Is_Blk= CJK	Compatibility}', "");
Expect(0, 13055, '\p{Is_Blk= CJK	Compatibility}', "");
Expect(1, 13055, '\p{^Is_Blk= CJK	Compatibility}', "");
Expect(1, 13055, '\P{Is_Blk= CJK	Compatibility}', "");
Expect(0, 13055, '\P{^Is_Blk= CJK	Compatibility}', "");
Error('\p{Block=-:=VEDIC-EXTENSIONS}');
Error('\P{Block=-:=VEDIC-EXTENSIONS}');
Expect(1, 7423, '\p{Block=vedicextensions}', "");
Expect(0, 7423, '\p{^Block=vedicextensions}', "");
Expect(0, 7423, '\P{Block=vedicextensions}', "");
Expect(1, 7423, '\P{^Block=vedicextensions}', "");
Expect(0, 7375, '\p{Block=vedicextensions}', "");
Expect(1, 7375, '\p{^Block=vedicextensions}', "");
Expect(1, 7375, '\P{Block=vedicextensions}', "");
Expect(0, 7375, '\P{^Block=vedicextensions}', "");
Expect(1, 7423, '\p{Block=	 VEDIC_Extensions}', "");
Expect(0, 7423, '\p{^Block=	 VEDIC_Extensions}', "");
Expect(0, 7423, '\P{Block=	 VEDIC_Extensions}', "");
Expect(1, 7423, '\P{^Block=	 VEDIC_Extensions}', "");
Expect(0, 7375, '\p{Block=	 VEDIC_Extensions}', "");
Expect(1, 7375, '\p{^Block=	 VEDIC_Extensions}', "");
Expect(1, 7375, '\P{Block=	 VEDIC_Extensions}', "");
Expect(0, 7375, '\P{^Block=	 VEDIC_Extensions}', "");
Error('\p{Blk=:=-	Vedicextensions}');
Error('\P{Blk=:=-	Vedicextensions}');
Expect(1, 7423, '\p{Blk=vedicextensions}', "");
Expect(0, 7423, '\p{^Blk=vedicextensions}', "");
Expect(0, 7423, '\P{Blk=vedicextensions}', "");
Expect(1, 7423, '\P{^Blk=vedicextensions}', "");
Expect(0, 7375, '\p{Blk=vedicextensions}', "");
Expect(1, 7375, '\p{^Blk=vedicextensions}', "");
Expect(1, 7375, '\P{Blk=vedicextensions}', "");
Expect(0, 7375, '\P{^Blk=vedicextensions}', "");
Expect(1, 7423, '\p{Blk=- Vedic-extensions}', "");
Expect(0, 7423, '\p{^Blk=- Vedic-extensions}', "");
Expect(0, 7423, '\P{Blk=- Vedic-extensions}', "");
Expect(1, 7423, '\P{^Blk=- Vedic-extensions}', "");
Expect(0, 7375, '\p{Blk=- Vedic-extensions}', "");
Expect(1, 7375, '\p{^Blk=- Vedic-extensions}', "");
Expect(1, 7375, '\P{Blk=- Vedic-extensions}', "");
Expect(0, 7375, '\P{^Blk=- Vedic-extensions}', "");
Error('\p{Is_Block=:=__vedic-extensions}');
Error('\P{Is_Block=:=__vedic-extensions}');
Expect(1, 7423, '\p{Is_Block=vedicextensions}', "");
Expect(0, 7423, '\p{^Is_Block=vedicextensions}', "");
Expect(0, 7423, '\P{Is_Block=vedicextensions}', "");
Expect(1, 7423, '\P{^Is_Block=vedicextensions}', "");
Expect(0, 7375, '\p{Is_Block=vedicextensions}', "");
Expect(1, 7375, '\p{^Is_Block=vedicextensions}', "");
Expect(1, 7375, '\P{Is_Block=vedicextensions}', "");
Expect(0, 7375, '\P{^Is_Block=vedicextensions}', "");
Expect(1, 7423, '\p{Is_Block= 	Vedic	Extensions}', "");
Expect(0, 7423, '\p{^Is_Block= 	Vedic	Extensions}', "");
Expect(0, 7423, '\P{Is_Block= 	Vedic	Extensions}', "");
Expect(1, 7423, '\P{^Is_Block= 	Vedic	Extensions}', "");
Expect(0, 7375, '\p{Is_Block= 	Vedic	Extensions}', "");
Expect(1, 7375, '\p{^Is_Block= 	Vedic	Extensions}', "");
Expect(1, 7375, '\P{Is_Block= 	Vedic	Extensions}', "");
Expect(0, 7375, '\P{^Is_Block= 	Vedic	Extensions}', "");
Error('\p{Is_Blk= :=vedic-Extensions}');
Error('\P{Is_Blk= :=vedic-Extensions}');
Expect(1, 7423, '\p{Is_Blk=vedicextensions}', "");
Expect(0, 7423, '\p{^Is_Blk=vedicextensions}', "");
Expect(0, 7423, '\P{Is_Blk=vedicextensions}', "");
Expect(1, 7423, '\P{^Is_Blk=vedicextensions}', "");
Expect(0, 7375, '\p{Is_Blk=vedicextensions}', "");
Expect(1, 7375, '\p{^Is_Blk=vedicextensions}', "");
Expect(1, 7375, '\P{Is_Blk=vedicextensions}', "");
Expect(0, 7375, '\P{^Is_Blk=vedicextensions}', "");
Expect(1, 7423, '\p{Is_Blk=_-Vedicextensions}', "");
Expect(0, 7423, '\p{^Is_Blk=_-Vedicextensions}', "");
Expect(0, 7423, '\P{Is_Blk=_-Vedicextensions}', "");
Expect(1, 7423, '\P{^Is_Blk=_-Vedicextensions}', "");
Expect(0, 7375, '\p{Is_Blk=_-Vedicextensions}', "");
Expect(1, 7375, '\p{^Is_Blk=_-Vedicextensions}', "");
Expect(1, 7375, '\P{Is_Blk=_-Vedicextensions}', "");
Expect(0, 7375, '\P{^Is_Blk=_-Vedicextensions}', "");
Error('\p{Block:		:=Tai_VIET}');
Error('\P{Block:		:=Tai_VIET}');
Expect(1, 43743, '\p{Block=taiviet}', "");
Expect(0, 43743, '\p{^Block=taiviet}', "");
Expect(0, 43743, '\P{Block=taiviet}', "");
Expect(1, 43743, '\P{^Block=taiviet}', "");
Expect(0, 43647, '\p{Block=taiviet}', "");
Expect(1, 43647, '\p{^Block=taiviet}', "");
Expect(1, 43647, '\P{Block=taiviet}', "");
Expect(0, 43647, '\P{^Block=taiviet}', "");
Expect(1, 43743, '\p{Block=	TAI	viet}', "");
Expect(0, 43743, '\p{^Block=	TAI	viet}', "");
Expect(0, 43743, '\P{Block=	TAI	viet}', "");
Expect(1, 43743, '\P{^Block=	TAI	viet}', "");
Expect(0, 43647, '\p{Block=	TAI	viet}', "");
Expect(1, 43647, '\p{^Block=	TAI	viet}', "");
Expect(1, 43647, '\P{Block=	TAI	viet}', "");
Expect(0, 43647, '\P{^Block=	TAI	viet}', "");
Error('\p{Blk=:=  Tai	Viet}');
Error('\P{Blk=:=  Tai	Viet}');
Expect(1, 43743, '\p{Blk=taiviet}', "");
Expect(0, 43743, '\p{^Blk=taiviet}', "");
Expect(0, 43743, '\P{Blk=taiviet}', "");
Expect(1, 43743, '\P{^Blk=taiviet}', "");
Expect(0, 43647, '\p{Blk=taiviet}', "");
Expect(1, 43647, '\p{^Blk=taiviet}', "");
Expect(1, 43647, '\P{Blk=taiviet}', "");
Expect(0, 43647, '\P{^Blk=taiviet}', "");
Expect(1, 43743, '\p{Blk=_ Tai-viet}', "");
Expect(0, 43743, '\p{^Blk=_ Tai-viet}', "");
Expect(0, 43743, '\P{Blk=_ Tai-viet}', "");
Expect(1, 43743, '\P{^Blk=_ Tai-viet}', "");
Expect(0, 43647, '\p{Blk=_ Tai-viet}', "");
Expect(1, 43647, '\p{^Blk=_ Tai-viet}', "");
Expect(1, 43647, '\P{Blk=_ Tai-viet}', "");
Expect(0, 43647, '\P{^Blk=_ Tai-viet}', "");
Error('\p{Is_Block=--Tai	VIET:=}');
Error('\P{Is_Block=--Tai	VIET:=}');
Expect(1, 43743, '\p{Is_Block=taiviet}', "");
Expect(0, 43743, '\p{^Is_Block=taiviet}', "");
Expect(0, 43743, '\P{Is_Block=taiviet}', "");
Expect(1, 43743, '\P{^Is_Block=taiviet}', "");
Expect(0, 43647, '\p{Is_Block=taiviet}', "");
Expect(1, 43647, '\p{^Is_Block=taiviet}', "");
Expect(1, 43647, '\P{Is_Block=taiviet}', "");
Expect(0, 43647, '\P{^Is_Block=taiviet}', "");
Expect(1, 43743, '\p{Is_Block=_	tai_Viet}', "");
Expect(0, 43743, '\p{^Is_Block=_	tai_Viet}', "");
Expect(0, 43743, '\P{Is_Block=_	tai_Viet}', "");
Expect(1, 43743, '\P{^Is_Block=_	tai_Viet}', "");
Expect(0, 43647, '\p{Is_Block=_	tai_Viet}', "");
Expect(1, 43647, '\p{^Is_Block=_	tai_Viet}', "");
Expect(1, 43647, '\P{Is_Block=_	tai_Viet}', "");
Expect(0, 43647, '\P{^Is_Block=_	tai_Viet}', "");
Error('\p{Is_Blk=_/a/TaiViet}');
Error('\P{Is_Blk=_/a/TaiViet}');
Expect(1, 43743, '\p{Is_Blk:	taiviet}', "");
Expect(0, 43743, '\p{^Is_Blk:	taiviet}', "");
Expect(0, 43743, '\P{Is_Blk:	taiviet}', "");
Expect(1, 43743, '\P{^Is_Blk:	taiviet}', "");
Expect(0, 43647, '\p{Is_Blk:	taiviet}', "");
Expect(1, 43647, '\p{^Is_Blk:	taiviet}', "");
Expect(1, 43647, '\P{Is_Blk:	taiviet}', "");
Expect(0, 43647, '\P{^Is_Blk:	taiviet}', "");
Expect(1, 43743, '\p{Is_Blk:	_-tai viet}', "");
Expect(0, 43743, '\p{^Is_Blk:	_-tai viet}', "");
Expect(0, 43743, '\P{Is_Blk:	_-tai viet}', "");
Expect(1, 43743, '\P{^Is_Blk:	_-tai viet}', "");
Expect(0, 43647, '\p{Is_Blk:	_-tai viet}', "");
Expect(1, 43647, '\p{^Is_Blk:	_-tai viet}', "");
Expect(1, 43647, '\P{Is_Blk:	_-tai viet}', "");
Expect(0, 43647, '\P{^Is_Blk:	_-tai viet}', "");
Error('\p{Block=:=-CYRILLIC_Extended	b}');
Error('\P{Block=:=-CYRILLIC_Extended	b}');
Expect(1, 42655, '\p{Block:	cyrillicextendedb}', "");
Expect(0, 42655, '\p{^Block:	cyrillicextendedb}', "");
Expect(0, 42655, '\P{Block:	cyrillicextendedb}', "");
Expect(1, 42655, '\P{^Block:	cyrillicextendedb}', "");
Expect(0, 42559, '\p{Block:	cyrillicextendedb}', "");
Expect(1, 42559, '\p{^Block:	cyrillicextendedb}', "");
Expect(1, 42559, '\P{Block:	cyrillicextendedb}', "");
Expect(0, 42559, '\P{^Block:	cyrillicextendedb}', "");
Expect(1, 42655, '\p{Block= -CYRILLIC extended-b}', "");
Expect(0, 42655, '\p{^Block= -CYRILLIC extended-b}', "");
Expect(0, 42655, '\P{Block= -CYRILLIC extended-b}', "");
Expect(1, 42655, '\P{^Block= -CYRILLIC extended-b}', "");
Expect(0, 42559, '\p{Block= -CYRILLIC extended-b}', "");
Expect(1, 42559, '\p{^Block= -CYRILLIC extended-b}', "");
Expect(1, 42559, '\P{Block= -CYRILLIC extended-b}', "");
Expect(0, 42559, '\P{^Block= -CYRILLIC extended-b}', "");
Error('\p{Blk=-cyrillic/a/Extended-B}');
Error('\P{Blk=-cyrillic/a/Extended-B}');
Expect(1, 42655, '\p{Blk=cyrillicextendedb}', "");
Expect(0, 42655, '\p{^Blk=cyrillicextendedb}', "");
Expect(0, 42655, '\P{Blk=cyrillicextendedb}', "");
Expect(1, 42655, '\P{^Blk=cyrillicextendedb}', "");
Expect(0, 42559, '\p{Blk=cyrillicextendedb}', "");
Expect(1, 42559, '\p{^Blk=cyrillicextendedb}', "");
Expect(1, 42559, '\P{Blk=cyrillicextendedb}', "");
Expect(0, 42559, '\P{^Blk=cyrillicextendedb}', "");
Expect(1, 42655, '\p{Blk=_cyrillic Extended	B}', "");
Expect(0, 42655, '\p{^Blk=_cyrillic Extended	B}', "");
Expect(0, 42655, '\P{Blk=_cyrillic Extended	B}', "");
Expect(1, 42655, '\P{^Blk=_cyrillic Extended	B}', "");
Expect(0, 42559, '\p{Blk=_cyrillic Extended	B}', "");
Expect(1, 42559, '\p{^Blk=_cyrillic Extended	B}', "");
Expect(1, 42559, '\P{Blk=_cyrillic Extended	B}', "");
Expect(0, 42559, '\P{^Blk=_cyrillic Extended	B}', "");
Error('\p{Is_Block=-CYRILLIC-Extended-B/a/}');
Error('\P{Is_Block=-CYRILLIC-Extended-B/a/}');
Expect(1, 42655, '\p{Is_Block=cyrillicextendedb}', "");
Expect(0, 42655, '\p{^Is_Block=cyrillicextendedb}', "");
Expect(0, 42655, '\P{Is_Block=cyrillicextendedb}', "");
Expect(1, 42655, '\P{^Is_Block=cyrillicextendedb}', "");
Expect(0, 42559, '\p{Is_Block=cyrillicextendedb}', "");
Expect(1, 42559, '\p{^Is_Block=cyrillicextendedb}', "");
Expect(1, 42559, '\P{Is_Block=cyrillicextendedb}', "");
Expect(0, 42559, '\P{^Is_Block=cyrillicextendedb}', "");
Expect(1, 42655, '\p{Is_Block= 	CYRILLICExtended-b}', "");
Expect(0, 42655, '\p{^Is_Block= 	CYRILLICExtended-b}', "");
Expect(0, 42655, '\P{Is_Block= 	CYRILLICExtended-b}', "");
Expect(1, 42655, '\P{^Is_Block= 	CYRILLICExtended-b}', "");
Expect(0, 42559, '\p{Is_Block= 	CYRILLICExtended-b}', "");
Expect(1, 42559, '\p{^Is_Block= 	CYRILLICExtended-b}', "");
Expect(1, 42559, '\P{Is_Block= 	CYRILLICExtended-b}', "");
Expect(0, 42559, '\P{^Is_Block= 	CYRILLICExtended-b}', "");
Error('\p{Is_Blk=/a/-	cyrillic_EXTENDED-B}');
Error('\P{Is_Blk=/a/-	cyrillic_EXTENDED-B}');
Expect(1, 42655, '\p{Is_Blk:	cyrillicextendedb}', "");
Expect(0, 42655, '\p{^Is_Blk:	cyrillicextendedb}', "");
Expect(0, 42655, '\P{Is_Blk:	cyrillicextendedb}', "");
Expect(1, 42655, '\P{^Is_Blk:	cyrillicextendedb}', "");
Expect(0, 42559, '\p{Is_Blk:	cyrillicextendedb}', "");
Expect(1, 42559, '\p{^Is_Blk:	cyrillicextendedb}', "");
Expect(1, 42559, '\P{Is_Blk:	cyrillicextendedb}', "");
Expect(0, 42559, '\P{^Is_Blk:	cyrillicextendedb}', "");
Expect(1, 42655, '\p{Is_Blk=_Cyrillic Extended_B}', "");
Expect(0, 42655, '\p{^Is_Blk=_Cyrillic Extended_B}', "");
Expect(0, 42655, '\P{Is_Blk=_Cyrillic Extended_B}', "");
Expect(1, 42655, '\P{^Is_Blk=_Cyrillic Extended_B}', "");
Expect(0, 42559, '\p{Is_Blk=_Cyrillic Extended_B}', "");
Expect(1, 42559, '\p{^Is_Blk=_Cyrillic Extended_B}', "");
Expect(1, 42559, '\P{Is_Blk=_Cyrillic Extended_B}', "");
Expect(0, 42559, '\P{^Is_Blk=_Cyrillic Extended_B}', "");
Error('\p{Block:	/a/phonetic	Extensions}');
Error('\P{Block:	/a/phonetic	Extensions}');
Expect(1, 7551, '\p{Block=phoneticextensions}', "");
Expect(0, 7551, '\p{^Block=phoneticextensions}', "");
Expect(0, 7551, '\P{Block=phoneticextensions}', "");
Expect(1, 7551, '\P{^Block=phoneticextensions}', "");
Expect(0, 7423, '\p{Block=phoneticextensions}', "");
Expect(1, 7423, '\p{^Block=phoneticextensions}', "");
Expect(1, 7423, '\P{Block=phoneticextensions}', "");
Expect(0, 7423, '\P{^Block=phoneticextensions}', "");
Expect(1, 7551, '\p{Block= _PHONETIC-Extensions}', "");
Expect(0, 7551, '\p{^Block= _PHONETIC-Extensions}', "");
Expect(0, 7551, '\P{Block= _PHONETIC-Extensions}', "");
Expect(1, 7551, '\P{^Block= _PHONETIC-Extensions}', "");
Expect(0, 7423, '\p{Block= _PHONETIC-Extensions}', "");
Expect(1, 7423, '\p{^Block= _PHONETIC-Extensions}', "");
Expect(1, 7423, '\P{Block= _PHONETIC-Extensions}', "");
Expect(0, 7423, '\P{^Block= _PHONETIC-Extensions}', "");
Error('\p{Blk=:= _phonetic-EXTENSIONS}');
Error('\P{Blk=:= _phonetic-EXTENSIONS}');
Expect(1, 7551, '\p{Blk:	phoneticextensions}', "");
Expect(0, 7551, '\p{^Blk:	phoneticextensions}', "");
Expect(0, 7551, '\P{Blk:	phoneticextensions}', "");
Expect(1, 7551, '\P{^Blk:	phoneticextensions}', "");
Expect(0, 7423, '\p{Blk:	phoneticextensions}', "");
Expect(1, 7423, '\p{^Blk:	phoneticextensions}', "");
Expect(1, 7423, '\P{Blk:	phoneticextensions}', "");
Expect(0, 7423, '\P{^Blk:	phoneticextensions}', "");
Expect(1, 7551, '\p{Blk=	PHONETIC-Extensions}', "");
Expect(0, 7551, '\p{^Blk=	PHONETIC-Extensions}', "");
Expect(0, 7551, '\P{Blk=	PHONETIC-Extensions}', "");
Expect(1, 7551, '\P{^Blk=	PHONETIC-Extensions}', "");
Expect(0, 7423, '\p{Blk=	PHONETIC-Extensions}', "");
Expect(1, 7423, '\p{^Blk=	PHONETIC-Extensions}', "");
Expect(1, 7423, '\P{Blk=	PHONETIC-Extensions}', "");
Expect(0, 7423, '\P{^Blk=	PHONETIC-Extensions}', "");
Error('\p{Is_Block=-_Phonetic_Extensions:=}');
Error('\P{Is_Block=-_Phonetic_Extensions:=}');
Expect(1, 7551, '\p{Is_Block=phoneticextensions}', "");
Expect(0, 7551, '\p{^Is_Block=phoneticextensions}', "");
Expect(0, 7551, '\P{Is_Block=phoneticextensions}', "");
Expect(1, 7551, '\P{^Is_Block=phoneticextensions}', "");
Expect(0, 7423, '\p{Is_Block=phoneticextensions}', "");
Expect(1, 7423, '\p{^Is_Block=phoneticextensions}', "");
Expect(1, 7423, '\P{Is_Block=phoneticextensions}', "");
Expect(0, 7423, '\P{^Is_Block=phoneticextensions}', "");
Expect(1, 7551, '\p{Is_Block=_	phonetic_Extensions}', "");
Expect(0, 7551, '\p{^Is_Block=_	phonetic_Extensions}', "");
Expect(0, 7551, '\P{Is_Block=_	phonetic_Extensions}', "");
Expect(1, 7551, '\P{^Is_Block=_	phonetic_Extensions}', "");
Expect(0, 7423, '\p{Is_Block=_	phonetic_Extensions}', "");
Expect(1, 7423, '\p{^Is_Block=_	phonetic_Extensions}', "");
Expect(1, 7423, '\P{Is_Block=_	phonetic_Extensions}', "");
Expect(0, 7423, '\P{^Is_Block=_	phonetic_Extensions}', "");
Error('\p{Is_Blk=	-Phonetic:=EXTENSIONS}');
Error('\P{Is_Blk=	-Phonetic:=EXTENSIONS}');
Expect(1, 7551, '\p{Is_Blk=phoneticextensions}', "");
Expect(0, 7551, '\p{^Is_Blk=phoneticextensions}', "");
Expect(0, 7551, '\P{Is_Blk=phoneticextensions}', "");
Expect(1, 7551, '\P{^Is_Blk=phoneticextensions}', "");
Expect(0, 7423, '\p{Is_Blk=phoneticextensions}', "");
Expect(1, 7423, '\p{^Is_Blk=phoneticextensions}', "");
Expect(1, 7423, '\P{Is_Blk=phoneticextensions}', "");
Expect(0, 7423, '\P{^Is_Blk=phoneticextensions}', "");
Expect(1, 7551, '\p{Is_Blk= _Phonetic	extensions}', "");
Expect(0, 7551, '\p{^Is_Blk= _Phonetic	extensions}', "");
Expect(0, 7551, '\P{Is_Blk= _Phonetic	extensions}', "");
Expect(1, 7551, '\P{^Is_Blk= _Phonetic	extensions}', "");
Expect(0, 7423, '\p{Is_Blk= _Phonetic	extensions}', "");
Expect(1, 7423, '\p{^Is_Blk= _Phonetic	extensions}', "");
Expect(1, 7423, '\P{Is_Blk= _Phonetic	extensions}', "");
Expect(0, 7423, '\P{^Is_Blk= _Phonetic	extensions}', "");
Error('\p{Block=/a/tai_Xuan	JING Symbols}');
Error('\P{Block=/a/tai_Xuan	JING Symbols}');
Expect(1, 119647, '\p{Block=taixuanjingsymbols}', "");
Expect(0, 119647, '\p{^Block=taixuanjingsymbols}', "");
Expect(0, 119647, '\P{Block=taixuanjingsymbols}', "");
Expect(1, 119647, '\P{^Block=taixuanjingsymbols}', "");
Expect(0, 119551, '\p{Block=taixuanjingsymbols}', "");
Expect(1, 119551, '\p{^Block=taixuanjingsymbols}', "");
Expect(1, 119551, '\P{Block=taixuanjingsymbols}', "");
Expect(0, 119551, '\P{^Block=taixuanjingsymbols}', "");
Expect(1, 119647, '\p{Block=--tai	Xuan Jing symbols}', "");
Expect(0, 119647, '\p{^Block=--tai	Xuan Jing symbols}', "");
Expect(0, 119647, '\P{Block=--tai	Xuan Jing symbols}', "");
Expect(1, 119647, '\P{^Block=--tai	Xuan Jing symbols}', "");
Expect(0, 119551, '\p{Block=--tai	Xuan Jing symbols}', "");
Expect(1, 119551, '\p{^Block=--tai	Xuan Jing symbols}', "");
Expect(1, 119551, '\P{Block=--tai	Xuan Jing symbols}', "");
Expect(0, 119551, '\P{^Block=--tai	Xuan Jing symbols}', "");
Error('\p{Blk= 	taiXuanJINGSymbols:=}');
Error('\P{Blk= 	taiXuanJINGSymbols:=}');
Expect(1, 119647, '\p{Blk=taixuanjingsymbols}', "");
Expect(0, 119647, '\p{^Blk=taixuanjingsymbols}', "");
Expect(0, 119647, '\P{Blk=taixuanjingsymbols}', "");
Expect(1, 119647, '\P{^Blk=taixuanjingsymbols}', "");
Expect(0, 119551, '\p{Blk=taixuanjingsymbols}', "");
Expect(1, 119551, '\p{^Blk=taixuanjingsymbols}', "");
Expect(1, 119551, '\P{Blk=taixuanjingsymbols}', "");
Expect(0, 119551, '\P{^Blk=taixuanjingsymbols}', "");
Expect(1, 119647, '\p{Blk= TAI	Xuan_JINGSymbols}', "");
Expect(0, 119647, '\p{^Blk= TAI	Xuan_JINGSymbols}', "");
Expect(0, 119647, '\P{Blk= TAI	Xuan_JINGSymbols}', "");
Expect(1, 119647, '\P{^Blk= TAI	Xuan_JINGSymbols}', "");
Expect(0, 119551, '\p{Blk= TAI	Xuan_JINGSymbols}', "");
Expect(1, 119551, '\p{^Blk= TAI	Xuan_JINGSymbols}', "");
Expect(1, 119551, '\P{Blk= TAI	Xuan_JINGSymbols}', "");
Expect(0, 119551, '\P{^Blk= TAI	Xuan_JINGSymbols}', "");
Error('\p{Is_Block=/a/_Taixuan_Jing_SYMBOLS}');
Error('\P{Is_Block=/a/_Taixuan_Jing_SYMBOLS}');
Expect(1, 119647, '\p{Is_Block=taixuanjingsymbols}', "");
Expect(0, 119647, '\p{^Is_Block=taixuanjingsymbols}', "");
Expect(0, 119647, '\P{Is_Block=taixuanjingsymbols}', "");
Expect(1, 119647, '\P{^Is_Block=taixuanjingsymbols}', "");
Expect(0, 119551, '\p{Is_Block=taixuanjingsymbols}', "");
Expect(1, 119551, '\p{^Is_Block=taixuanjingsymbols}', "");
Expect(1, 119551, '\P{Is_Block=taixuanjingsymbols}', "");
Expect(0, 119551, '\P{^Is_Block=taixuanjingsymbols}', "");
Expect(1, 119647, '\p{Is_Block=--tai Xuan Jing-Symbols}', "");
Expect(0, 119647, '\p{^Is_Block=--tai Xuan Jing-Symbols}', "");
Expect(0, 119647, '\P{Is_Block=--tai Xuan Jing-Symbols}', "");
Expect(1, 119647, '\P{^Is_Block=--tai Xuan Jing-Symbols}', "");
Expect(0, 119551, '\p{Is_Block=--tai Xuan Jing-Symbols}', "");
Expect(1, 119551, '\p{^Is_Block=--tai Xuan Jing-Symbols}', "");
Expect(1, 119551, '\P{Is_Block=--tai Xuan Jing-Symbols}', "");
Expect(0, 119551, '\P{^Is_Block=--tai Xuan Jing-Symbols}', "");
Error('\p{Is_Blk= TAI	Xuan:=JING	SYMBOLS}');
Error('\P{Is_Blk= TAI	Xuan:=JING	SYMBOLS}');
Expect(1, 119647, '\p{Is_Blk: taixuanjingsymbols}', "");
Expect(0, 119647, '\p{^Is_Blk: taixuanjingsymbols}', "");
Expect(0, 119647, '\P{Is_Blk: taixuanjingsymbols}', "");
Expect(1, 119647, '\P{^Is_Blk: taixuanjingsymbols}', "");
Expect(0, 119551, '\p{Is_Blk: taixuanjingsymbols}', "");
Expect(1, 119551, '\p{^Is_Blk: taixuanjingsymbols}', "");
Expect(1, 119551, '\P{Is_Blk: taixuanjingsymbols}', "");
Expect(0, 119551, '\P{^Is_Blk: taixuanjingsymbols}', "");
Expect(1, 119647, '\p{Is_Blk= _taiXUAN jing	Symbols}', "");
Expect(0, 119647, '\p{^Is_Blk= _taiXUAN jing	Symbols}', "");
Expect(0, 119647, '\P{Is_Blk= _taiXUAN jing	Symbols}', "");
Expect(1, 119647, '\P{^Is_Blk= _taiXUAN jing	Symbols}', "");
Expect(0, 119551, '\p{Is_Blk= _taiXUAN jing	Symbols}', "");
Expect(1, 119551, '\p{^Is_Blk= _taiXUAN jing	Symbols}', "");
Expect(1, 119551, '\P{Is_Blk= _taiXUAN jing	Symbols}', "");
Expect(0, 119551, '\P{^Is_Blk= _taiXUAN jing	Symbols}', "");
Error('\p{Block=:=Malayalam}');
Error('\P{Block=:=Malayalam}');
Expect(1, 3455, '\p{Block=malayalam}', "");
Expect(0, 3455, '\p{^Block=malayalam}', "");
Expect(0, 3455, '\P{Block=malayalam}', "");
Expect(1, 3455, '\P{^Block=malayalam}', "");
Expect(0, 3327, '\p{Block=malayalam}', "");
Expect(1, 3327, '\p{^Block=malayalam}', "");
Expect(1, 3327, '\P{Block=malayalam}', "");
Expect(0, 3327, '\P{^Block=malayalam}', "");
Expect(1, 3455, '\p{Block= -Malayalam}', "");
Expect(0, 3455, '\p{^Block= -Malayalam}', "");
Expect(0, 3455, '\P{Block= -Malayalam}', "");
Expect(1, 3455, '\P{^Block= -Malayalam}', "");
Expect(0, 3327, '\p{Block= -Malayalam}', "");
Expect(1, 3327, '\p{^Block= -Malayalam}', "");
Expect(1, 3327, '\P{Block= -Malayalam}', "");
Expect(0, 3327, '\P{^Block= -Malayalam}', "");
Error('\p{Blk=-	Malayalam:=}');
Error('\P{Blk=-	Malayalam:=}');
Expect(1, 3455, '\p{Blk=malayalam}', "");
Expect(0, 3455, '\p{^Blk=malayalam}', "");
Expect(0, 3455, '\P{Blk=malayalam}', "");
Expect(1, 3455, '\P{^Blk=malayalam}', "");
Expect(0, 3327, '\p{Blk=malayalam}', "");
Expect(1, 3327, '\p{^Blk=malayalam}', "");
Expect(1, 3327, '\P{Blk=malayalam}', "");
Expect(0, 3327, '\P{^Blk=malayalam}', "");
Expect(1, 3455, '\p{Blk=-_malayalam}', "");
Expect(0, 3455, '\p{^Blk=-_malayalam}', "");
Expect(0, 3455, '\P{Blk=-_malayalam}', "");
Expect(1, 3455, '\P{^Blk=-_malayalam}', "");
Expect(0, 3327, '\p{Blk=-_malayalam}', "");
Expect(1, 3327, '\p{^Blk=-_malayalam}', "");
Expect(1, 3327, '\P{Blk=-_malayalam}', "");
Expect(0, 3327, '\P{^Blk=-_malayalam}', "");
Error('\p{Is_Block=/a/		Malayalam}');
Error('\P{Is_Block=/a/		Malayalam}');
Expect(1, 3455, '\p{Is_Block=malayalam}', "");
Expect(0, 3455, '\p{^Is_Block=malayalam}', "");
Expect(0, 3455, '\P{Is_Block=malayalam}', "");
Expect(1, 3455, '\P{^Is_Block=malayalam}', "");
Expect(0, 3327, '\p{Is_Block=malayalam}', "");
Expect(1, 3327, '\p{^Is_Block=malayalam}', "");
Expect(1, 3327, '\P{Is_Block=malayalam}', "");
Expect(0, 3327, '\P{^Is_Block=malayalam}', "");
Expect(1, 3455, '\p{Is_Block: - Malayalam}', "");
Expect(0, 3455, '\p{^Is_Block: - Malayalam}', "");
Expect(0, 3455, '\P{Is_Block: - Malayalam}', "");
Expect(1, 3455, '\P{^Is_Block: - Malayalam}', "");
Expect(0, 3327, '\p{Is_Block: - Malayalam}', "");
Expect(1, 3327, '\p{^Is_Block: - Malayalam}', "");
Expect(1, 3327, '\P{Is_Block: - Malayalam}', "");
Expect(0, 3327, '\P{^Is_Block: - Malayalam}', "");
Error('\p{Is_Blk=__Malayalam/a/}');
Error('\P{Is_Blk=__Malayalam/a/}');
Expect(1, 3455, '\p{Is_Blk=malayalam}', "");
Expect(0, 3455, '\p{^Is_Blk=malayalam}', "");
Expect(0, 3455, '\P{Is_Blk=malayalam}', "");
Expect(1, 3455, '\P{^Is_Blk=malayalam}', "");
Expect(0, 3327, '\p{Is_Blk=malayalam}', "");
Expect(1, 3327, '\p{^Is_Blk=malayalam}', "");
Expect(1, 3327, '\P{Is_Blk=malayalam}', "");
Expect(0, 3327, '\P{^Is_Blk=malayalam}', "");
Expect(1, 3455, '\p{Is_Blk=  malayalam}', "");
Expect(0, 3455, '\p{^Is_Blk=  malayalam}', "");
Expect(0, 3455, '\P{Is_Blk=  malayalam}', "");
Expect(1, 3455, '\P{^Is_Blk=  malayalam}', "");
Expect(0, 3327, '\p{Is_Blk=  malayalam}', "");
Expect(1, 3327, '\p{^Is_Blk=  malayalam}', "");
Expect(1, 3327, '\P{Is_Blk=  malayalam}', "");
Expect(0, 3327, '\P{^Is_Blk=  malayalam}', "");
Error('\p{Block=	_lisu:=}');
Error('\P{Block=	_lisu:=}');
Expect(1, 42239, '\p{Block=lisu}', "");
Expect(0, 42239, '\p{^Block=lisu}', "");
Expect(0, 42239, '\P{Block=lisu}', "");
Expect(1, 42239, '\P{^Block=lisu}', "");
Expect(0, 42191, '\p{Block=lisu}', "");
Expect(1, 42191, '\p{^Block=lisu}', "");
Expect(1, 42191, '\P{Block=lisu}', "");
Expect(0, 42191, '\P{^Block=lisu}', "");
Expect(1, 42239, '\p{Block= 	Lisu}', "");
Expect(0, 42239, '\p{^Block= 	Lisu}', "");
Expect(0, 42239, '\P{Block= 	Lisu}', "");
Expect(1, 42239, '\P{^Block= 	Lisu}', "");
Expect(0, 42191, '\p{Block= 	Lisu}', "");
Expect(1, 42191, '\p{^Block= 	Lisu}', "");
Expect(1, 42191, '\P{Block= 	Lisu}', "");
Expect(0, 42191, '\P{^Block= 	Lisu}', "");
Error('\p{Blk=_:=Lisu}');
Error('\P{Blk=_:=Lisu}');
Expect(1, 42239, '\p{Blk=lisu}', "");
Expect(0, 42239, '\p{^Blk=lisu}', "");
Expect(0, 42239, '\P{Blk=lisu}', "");
Expect(1, 42239, '\P{^Blk=lisu}', "");
Expect(0, 42191, '\p{Blk=lisu}', "");
Expect(1, 42191, '\p{^Blk=lisu}', "");
Expect(1, 42191, '\P{Blk=lisu}', "");
Expect(0, 42191, '\P{^Blk=lisu}', "");
Expect(1, 42239, '\p{Blk= -LISU}', "");
Expect(0, 42239, '\p{^Blk= -LISU}', "");
Expect(0, 42239, '\P{Blk= -LISU}', "");
Expect(1, 42239, '\P{^Blk= -LISU}', "");
Expect(0, 42191, '\p{Blk= -LISU}', "");
Expect(1, 42191, '\p{^Blk= -LISU}', "");
Expect(1, 42191, '\P{Blk= -LISU}', "");
Expect(0, 42191, '\P{^Blk= -LISU}', "");
Error('\p{Is_Block=:= lisu}');
Error('\P{Is_Block=:= lisu}');
Expect(1, 42239, '\p{Is_Block=lisu}', "");
Expect(0, 42239, '\p{^Is_Block=lisu}', "");
Expect(0, 42239, '\P{Is_Block=lisu}', "");
Expect(1, 42239, '\P{^Is_Block=lisu}', "");
Expect(0, 42191, '\p{Is_Block=lisu}', "");
Expect(1, 42191, '\p{^Is_Block=lisu}', "");
Expect(1, 42191, '\P{Is_Block=lisu}', "");
Expect(0, 42191, '\P{^Is_Block=lisu}', "");
Expect(1, 42239, '\p{Is_Block=	-Lisu}', "");
Expect(0, 42239, '\p{^Is_Block=	-Lisu}', "");
Expect(0, 42239, '\P{Is_Block=	-Lisu}', "");
Expect(1, 42239, '\P{^Is_Block=	-Lisu}', "");
Expect(0, 42191, '\p{Is_Block=	-Lisu}', "");
Expect(1, 42191, '\p{^Is_Block=	-Lisu}', "");
Expect(1, 42191, '\P{Is_Block=	-Lisu}', "");
Expect(0, 42191, '\P{^Is_Block=	-Lisu}', "");
Error('\p{Is_Blk= 	lisu/a/}');
Error('\P{Is_Blk= 	lisu/a/}');
Expect(1, 42239, '\p{Is_Blk=lisu}', "");
Expect(0, 42239, '\p{^Is_Blk=lisu}', "");
Expect(0, 42239, '\P{Is_Blk=lisu}', "");
Expect(1, 42239, '\P{^Is_Blk=lisu}', "");
Expect(0, 42191, '\p{Is_Blk=lisu}', "");
Expect(1, 42191, '\p{^Is_Blk=lisu}', "");
Expect(1, 42191, '\P{Is_Blk=lisu}', "");
Expect(0, 42191, '\P{^Is_Blk=lisu}', "");
Expect(1, 42239, '\p{Is_Blk= 	LISU}', "");
Expect(0, 42239, '\p{^Is_Blk= 	LISU}', "");
Expect(0, 42239, '\P{Is_Blk= 	LISU}', "");
Expect(1, 42239, '\P{^Is_Blk= 	LISU}', "");
Expect(0, 42191, '\p{Is_Blk= 	LISU}', "");
Expect(1, 42191, '\p{^Is_Blk= 	LISU}', "");
Expect(1, 42191, '\P{Is_Blk= 	LISU}', "");
Expect(0, 42191, '\P{^Is_Blk= 	LISU}', "");
Error('\p{Block:	_-ARABIC PresentationFORMS:=A}');
Error('\P{Block:	_-ARABIC PresentationFORMS:=A}');
Expect(1, 65023, '\p{Block=arabicpresentationformsa}', "");
Expect(0, 65023, '\p{^Block=arabicpresentationformsa}', "");
Expect(0, 65023, '\P{Block=arabicpresentationformsa}', "");
Expect(1, 65023, '\P{^Block=arabicpresentationformsa}', "");
Expect(0, 64335, '\p{Block=arabicpresentationformsa}', "");
Expect(1, 64335, '\p{^Block=arabicpresentationformsa}', "");
Expect(1, 64335, '\P{Block=arabicpresentationformsa}', "");
Expect(0, 64335, '\P{^Block=arabicpresentationformsa}', "");
Expect(1, 65023, '\p{Block=-Arabic Presentation-FORMSA}', "");
Expect(0, 65023, '\p{^Block=-Arabic Presentation-FORMSA}', "");
Expect(0, 65023, '\P{Block=-Arabic Presentation-FORMSA}', "");
Expect(1, 65023, '\P{^Block=-Arabic Presentation-FORMSA}', "");
Expect(0, 64335, '\p{Block=-Arabic Presentation-FORMSA}', "");
Expect(1, 64335, '\p{^Block=-Arabic Presentation-FORMSA}', "");
Expect(1, 64335, '\P{Block=-Arabic Presentation-FORMSA}', "");
Expect(0, 64335, '\P{^Block=-Arabic Presentation-FORMSA}', "");
Error('\p{Blk=	:=Arabic-Presentation-Forms A}');
Error('\P{Blk=	:=Arabic-Presentation-Forms A}');
Expect(1, 65023, '\p{Blk=arabicpresentationformsa}', "");
Expect(0, 65023, '\p{^Blk=arabicpresentationformsa}', "");
Expect(0, 65023, '\P{Blk=arabicpresentationformsa}', "");
Expect(1, 65023, '\P{^Blk=arabicpresentationformsa}', "");
Expect(0, 64335, '\p{Blk=arabicpresentationformsa}', "");
Expect(1, 64335, '\p{^Blk=arabicpresentationformsa}', "");
Expect(1, 64335, '\P{Blk=arabicpresentationformsa}', "");
Expect(0, 64335, '\P{^Blk=arabicpresentationformsa}', "");
Expect(1, 65023, '\p{Blk=ARABIC	Presentation FORMSA}', "");
Expect(0, 65023, '\p{^Blk=ARABIC	Presentation FORMSA}', "");
Expect(0, 65023, '\P{Blk=ARABIC	Presentation FORMSA}', "");
Expect(1, 65023, '\P{^Blk=ARABIC	Presentation FORMSA}', "");
Expect(0, 64335, '\p{Blk=ARABIC	Presentation FORMSA}', "");
Expect(1, 64335, '\p{^Blk=ARABIC	Presentation FORMSA}', "");
Expect(1, 64335, '\P{Blk=ARABIC	Presentation FORMSA}', "");
Expect(0, 64335, '\P{^Blk=ARABIC	Presentation FORMSA}', "");
Error('\p{Is_Block=_:=Arabic	presentation	forms-A}');
Error('\P{Is_Block=_:=Arabic	presentation	forms-A}');
Expect(1, 65023, '\p{Is_Block=arabicpresentationformsa}', "");
Expect(0, 65023, '\p{^Is_Block=arabicpresentationformsa}', "");
Expect(0, 65023, '\P{Is_Block=arabicpresentationformsa}', "");
Expect(1, 65023, '\P{^Is_Block=arabicpresentationformsa}', "");
Expect(0, 64335, '\p{Is_Block=arabicpresentationformsa}', "");
Expect(1, 64335, '\p{^Is_Block=arabicpresentationformsa}', "");
Expect(1, 64335, '\P{Is_Block=arabicpresentationformsa}', "");
Expect(0, 64335, '\P{^Is_Block=arabicpresentationformsa}', "");
Expect(1, 65023, '\p{Is_Block=		Arabic-presentation Forms	a}', "");
Expect(0, 65023, '\p{^Is_Block=		Arabic-presentation Forms	a}', "");
Expect(0, 65023, '\P{Is_Block=		Arabic-presentation Forms	a}', "");
Expect(1, 65023, '\P{^Is_Block=		Arabic-presentation Forms	a}', "");
Expect(0, 64335, '\p{Is_Block=		Arabic-presentation Forms	a}', "");
Expect(1, 64335, '\p{^Is_Block=		Arabic-presentation Forms	a}', "");
Expect(1, 64335, '\P{Is_Block=		Arabic-presentation Forms	a}', "");
Expect(0, 64335, '\P{^Is_Block=		Arabic-presentation Forms	a}', "");
Error('\p{Is_Blk=_Arabic-presentation Forms A:=}');
Error('\P{Is_Blk=_Arabic-presentation Forms A:=}');
Expect(1, 65023, '\p{Is_Blk: arabicpresentationformsa}', "");
Expect(0, 65023, '\p{^Is_Blk: arabicpresentationformsa}', "");
Expect(0, 65023, '\P{Is_Blk: arabicpresentationformsa}', "");
Expect(1, 65023, '\P{^Is_Blk: arabicpresentationformsa}', "");
Expect(0, 64335, '\p{Is_Blk: arabicpresentationformsa}', "");
Expect(1, 64335, '\p{^Is_Blk: arabicpresentationformsa}', "");
Expect(1, 64335, '\P{Is_Blk: arabicpresentationformsa}', "");
Expect(0, 64335, '\P{^Is_Blk: arabicpresentationformsa}', "");
Expect(1, 65023, '\p{Is_Blk=	-arabicpresentationForms A}', "");
Expect(0, 65023, '\p{^Is_Blk=	-arabicpresentationForms A}', "");
Expect(0, 65023, '\P{Is_Blk=	-arabicpresentationForms A}', "");
Expect(1, 65023, '\P{^Is_Blk=	-arabicpresentationForms A}', "");
Expect(0, 64335, '\p{Is_Blk=	-arabicpresentationForms A}', "");
Expect(1, 64335, '\p{^Is_Blk=	-arabicpresentationForms A}', "");
Expect(1, 64335, '\P{Is_Blk=	-arabicpresentationForms A}', "");
Expect(0, 64335, '\P{^Is_Blk=	-arabicpresentationForms A}', "");
Error('\p{Block=:=Taile}');
Error('\P{Block=:=Taile}');
Expect(1, 6527, '\p{Block:   taile}', "");
Expect(0, 6527, '\p{^Block:   taile}', "");
Expect(0, 6527, '\P{Block:   taile}', "");
Expect(1, 6527, '\P{^Block:   taile}', "");
Expect(0, 6479, '\p{Block:   taile}', "");
Expect(1, 6479, '\p{^Block:   taile}', "");
Expect(1, 6479, '\P{Block:   taile}', "");
Expect(0, 6479, '\P{^Block:   taile}', "");
Expect(1, 6527, '\p{Block= 	TaiLe}', "");
Expect(0, 6527, '\p{^Block= 	TaiLe}', "");
Expect(0, 6527, '\P{Block= 	TaiLe}', "");
Expect(1, 6527, '\P{^Block= 	TaiLe}', "");
Expect(0, 6479, '\p{Block= 	TaiLe}', "");
Expect(1, 6479, '\p{^Block= 	TaiLe}', "");
Expect(1, 6479, '\P{Block= 	TaiLe}', "");
Expect(0, 6479, '\P{^Block= 	TaiLe}', "");
Error('\p{Blk=-tai	le/a/}');
Error('\P{Blk=-tai	le/a/}');
Expect(1, 6527, '\p{Blk=taile}', "");
Expect(0, 6527, '\p{^Blk=taile}', "");
Expect(0, 6527, '\P{Blk=taile}', "");
Expect(1, 6527, '\P{^Blk=taile}', "");
Expect(0, 6479, '\p{Blk=taile}', "");
Expect(1, 6479, '\p{^Blk=taile}', "");
Expect(1, 6479, '\P{Blk=taile}', "");
Expect(0, 6479, '\P{^Blk=taile}', "");
Expect(1, 6527, '\p{Blk=	Taile}', "");
Expect(0, 6527, '\p{^Blk=	Taile}', "");
Expect(0, 6527, '\P{Blk=	Taile}', "");
Expect(1, 6527, '\P{^Blk=	Taile}', "");
Expect(0, 6479, '\p{Blk=	Taile}', "");
Expect(1, 6479, '\p{^Blk=	Taile}', "");
Expect(1, 6479, '\P{Blk=	Taile}', "");
Expect(0, 6479, '\P{^Blk=	Taile}', "");
Error('\p{Is_Block=/a/tai Le}');
Error('\P{Is_Block=/a/tai Le}');
Expect(1, 6527, '\p{Is_Block=taile}', "");
Expect(0, 6527, '\p{^Is_Block=taile}', "");
Expect(0, 6527, '\P{Is_Block=taile}', "");
Expect(1, 6527, '\P{^Is_Block=taile}', "");
Expect(0, 6479, '\p{Is_Block=taile}', "");
Expect(1, 6479, '\p{^Is_Block=taile}', "");
Expect(1, 6479, '\P{Is_Block=taile}', "");
Expect(0, 6479, '\P{^Is_Block=taile}', "");
Expect(1, 6527, '\p{Is_Block= _Tai le}', "");
Expect(0, 6527, '\p{^Is_Block= _Tai le}', "");
Expect(0, 6527, '\P{Is_Block= _Tai le}', "");
Expect(1, 6527, '\P{^Is_Block= _Tai le}', "");
Expect(0, 6479, '\p{Is_Block= _Tai le}', "");
Expect(1, 6479, '\p{^Is_Block= _Tai le}', "");
Expect(1, 6479, '\P{Is_Block= _Tai le}', "");
Expect(0, 6479, '\P{^Is_Block= _Tai le}', "");
Error('\p{Is_Blk=-	TAI/a/LE}');
Error('\P{Is_Blk=-	TAI/a/LE}');
Expect(1, 6527, '\p{Is_Blk=taile}', "");
Expect(0, 6527, '\p{^Is_Blk=taile}', "");
Expect(0, 6527, '\P{Is_Blk=taile}', "");
Expect(1, 6527, '\P{^Is_Blk=taile}', "");
Expect(0, 6479, '\p{Is_Blk=taile}', "");
Expect(1, 6479, '\p{^Is_Blk=taile}', "");
Expect(1, 6479, '\P{Is_Blk=taile}', "");
Expect(0, 6479, '\P{^Is_Blk=taile}', "");
Expect(1, 6527, '\p{Is_Blk=_Tai-le}', "");
Expect(0, 6527, '\p{^Is_Blk=_Tai-le}', "");
Expect(0, 6527, '\P{Is_Blk=_Tai-le}', "");
Expect(1, 6527, '\P{^Is_Blk=_Tai-le}', "");
Expect(0, 6479, '\p{Is_Blk=_Tai-le}', "");
Expect(1, 6479, '\p{^Is_Blk=_Tai-le}', "");
Expect(1, 6479, '\P{Is_Blk=_Tai-le}', "");
Expect(0, 6479, '\P{^Is_Blk=_Tai-le}', "");
Error('\p{Block= /a/Combining Diacritical	Marks}');
Error('\P{Block= /a/Combining Diacritical	Marks}');
Expect(1, 879, '\p{Block=combiningdiacriticalmarks}', "");
Expect(0, 879, '\p{^Block=combiningdiacriticalmarks}', "");
Expect(0, 879, '\P{Block=combiningdiacriticalmarks}', "");
Expect(1, 879, '\P{^Block=combiningdiacriticalmarks}', "");
Expect(0, 767, '\p{Block=combiningdiacriticalmarks}', "");
Expect(1, 767, '\p{^Block=combiningdiacriticalmarks}', "");
Expect(1, 767, '\P{Block=combiningdiacriticalmarks}', "");
Expect(0, 767, '\P{^Block=combiningdiacriticalmarks}', "");
Expect(1, 879, '\p{Block=-_Combining	DIACRITICAL	MARKS}', "");
Expect(0, 879, '\p{^Block=-_Combining	DIACRITICAL	MARKS}', "");
Expect(0, 879, '\P{Block=-_Combining	DIACRITICAL	MARKS}', "");
Expect(1, 879, '\P{^Block=-_Combining	DIACRITICAL	MARKS}', "");
Expect(0, 767, '\p{Block=-_Combining	DIACRITICAL	MARKS}', "");
Expect(1, 767, '\p{^Block=-_Combining	DIACRITICAL	MARKS}', "");
Expect(1, 767, '\P{Block=-_Combining	DIACRITICAL	MARKS}', "");
Expect(0, 767, '\P{^Block=-_Combining	DIACRITICAL	MARKS}', "");
Error('\p{Blk=__COMBINING_DIACRITICAL:=Marks}');
Error('\P{Blk=__COMBINING_DIACRITICAL:=Marks}');
Expect(1, 879, '\p{Blk: combiningdiacriticalmarks}', "");
Expect(0, 879, '\p{^Blk: combiningdiacriticalmarks}', "");
Expect(0, 879, '\P{Blk: combiningdiacriticalmarks}', "");
Expect(1, 879, '\P{^Blk: combiningdiacriticalmarks}', "");
Expect(0, 767, '\p{Blk: combiningdiacriticalmarks}', "");
Expect(1, 767, '\p{^Blk: combiningdiacriticalmarks}', "");
Expect(1, 767, '\P{Blk: combiningdiacriticalmarks}', "");
Expect(0, 767, '\P{^Blk: combiningdiacriticalmarks}', "");
Expect(1, 879, '\p{Blk= 	COMBINING	Diacritical	marks}', "");
Expect(0, 879, '\p{^Blk= 	COMBINING	Diacritical	marks}', "");
Expect(0, 879, '\P{Blk= 	COMBINING	Diacritical	marks}', "");
Expect(1, 879, '\P{^Blk= 	COMBINING	Diacritical	marks}', "");
Expect(0, 767, '\p{Blk= 	COMBINING	Diacritical	marks}', "");
Expect(1, 767, '\p{^Blk= 	COMBINING	Diacritical	marks}', "");
Expect(1, 767, '\P{Blk= 	COMBINING	Diacritical	marks}', "");
Expect(0, 767, '\P{^Blk= 	COMBINING	Diacritical	marks}', "");
Error('\p{Is_Block=-Combining:=diacritical-MARKS}');
Error('\P{Is_Block=-Combining:=diacritical-MARKS}');
Expect(1, 879, '\p{Is_Block=combiningdiacriticalmarks}', "");
Expect(0, 879, '\p{^Is_Block=combiningdiacriticalmarks}', "");
Expect(0, 879, '\P{Is_Block=combiningdiacriticalmarks}', "");
Expect(1, 879, '\P{^Is_Block=combiningdiacriticalmarks}', "");
Expect(0, 767, '\p{Is_Block=combiningdiacriticalmarks}', "");
Expect(1, 767, '\p{^Is_Block=combiningdiacriticalmarks}', "");
Expect(1, 767, '\P{Is_Block=combiningdiacriticalmarks}', "");
Expect(0, 767, '\P{^Is_Block=combiningdiacriticalmarks}', "");
Expect(1, 879, '\p{Is_Block=	_COMBINING_diacritical_Marks}', "");
Expect(0, 879, '\p{^Is_Block=	_COMBINING_diacritical_Marks}', "");
Expect(0, 879, '\P{Is_Block=	_COMBINING_diacritical_Marks}', "");
Expect(1, 879, '\P{^Is_Block=	_COMBINING_diacritical_Marks}', "");
Expect(0, 767, '\p{Is_Block=	_COMBINING_diacritical_Marks}', "");
Expect(1, 767, '\p{^Is_Block=	_COMBINING_diacritical_Marks}', "");
Expect(1, 767, '\P{Is_Block=	_COMBINING_diacritical_Marks}', "");
Expect(0, 767, '\P{^Is_Block=	_COMBINING_diacritical_Marks}', "");
Error('\p{Is_Blk= Combining_Diacritical:=Marks}');
Error('\P{Is_Blk= Combining_Diacritical:=Marks}');
Expect(1, 879, '\p{Is_Blk=combiningdiacriticalmarks}', "");
Expect(0, 879, '\p{^Is_Blk=combiningdiacriticalmarks}', "");
Expect(0, 879, '\P{Is_Blk=combiningdiacriticalmarks}', "");
Expect(1, 879, '\P{^Is_Blk=combiningdiacriticalmarks}', "");
Expect(0, 767, '\p{Is_Blk=combiningdiacriticalmarks}', "");
Expect(1, 767, '\p{^Is_Blk=combiningdiacriticalmarks}', "");
Expect(1, 767, '\P{Is_Blk=combiningdiacriticalmarks}', "");
Expect(0, 767, '\P{^Is_Blk=combiningdiacriticalmarks}', "");
Expect(1, 879, '\p{Is_Blk=	Combining Diacritical_Marks}', "");
Expect(0, 879, '\p{^Is_Blk=	Combining Diacritical_Marks}', "");
Expect(0, 879, '\P{Is_Blk=	Combining Diacritical_Marks}', "");
Expect(1, 879, '\P{^Is_Blk=	Combining Diacritical_Marks}', "");
Expect(0, 767, '\p{Is_Blk=	Combining Diacritical_Marks}', "");
Expect(1, 767, '\p{^Is_Blk=	Combining Diacritical_Marks}', "");
Expect(1, 767, '\P{Is_Blk=	Combining Diacritical_Marks}', "");
Expect(0, 767, '\P{^Is_Blk=	Combining Diacritical_Marks}', "");
Error('\p{Block:	-Latin-extended-b:=}');
Error('\P{Block:	-Latin-extended-b:=}');
Expect(1, 591, '\p{Block=latinextendedb}', "");
Expect(0, 591, '\p{^Block=latinextendedb}', "");
Expect(0, 591, '\P{Block=latinextendedb}', "");
Expect(1, 591, '\P{^Block=latinextendedb}', "");
Expect(0, 383, '\p{Block=latinextendedb}', "");
Expect(1, 383, '\p{^Block=latinextendedb}', "");
Expect(1, 383, '\P{Block=latinextendedb}', "");
Expect(0, 383, '\P{^Block=latinextendedb}', "");
Expect(1, 591, '\p{Block=-Latin extended_B}', "");
Expect(0, 591, '\p{^Block=-Latin extended_B}', "");
Expect(0, 591, '\P{Block=-Latin extended_B}', "");
Expect(1, 591, '\P{^Block=-Latin extended_B}', "");
Expect(0, 383, '\p{Block=-Latin extended_B}', "");
Expect(1, 383, '\p{^Block=-Latin extended_B}', "");
Expect(1, 383, '\P{Block=-Latin extended_B}', "");
Expect(0, 383, '\P{^Block=-Latin extended_B}', "");
Error('\p{Blk=	:=latin	extended-B}');
Error('\P{Blk=	:=latin	extended-B}');
Expect(1, 591, '\p{Blk=latinextendedb}', "");
Expect(0, 591, '\p{^Blk=latinextendedb}', "");
Expect(0, 591, '\P{Blk=latinextendedb}', "");
Expect(1, 591, '\P{^Blk=latinextendedb}', "");
Expect(0, 383, '\p{Blk=latinextendedb}', "");
Expect(1, 383, '\p{^Blk=latinextendedb}', "");
Expect(1, 383, '\P{Blk=latinextendedb}', "");
Expect(0, 383, '\P{^Blk=latinextendedb}', "");
Expect(1, 591, '\p{Blk=	 Latin-EXTENDED	b}', "");
Expect(0, 591, '\p{^Blk=	 Latin-EXTENDED	b}', "");
Expect(0, 591, '\P{Blk=	 Latin-EXTENDED	b}', "");
Expect(1, 591, '\P{^Blk=	 Latin-EXTENDED	b}', "");
Expect(0, 383, '\p{Blk=	 Latin-EXTENDED	b}', "");
Expect(1, 383, '\p{^Blk=	 Latin-EXTENDED	b}', "");
Expect(1, 383, '\P{Blk=	 Latin-EXTENDED	b}', "");
Expect(0, 383, '\P{^Blk=	 Latin-EXTENDED	b}', "");
Error('\p{Is_Block= Latin EXTENDED_b:=}');
Error('\P{Is_Block= Latin EXTENDED_b:=}');
Expect(1, 591, '\p{Is_Block=latinextendedb}', "");
Expect(0, 591, '\p{^Is_Block=latinextendedb}', "");
Expect(0, 591, '\P{Is_Block=latinextendedb}', "");
Expect(1, 591, '\P{^Is_Block=latinextendedb}', "");
Expect(0, 383, '\p{Is_Block=latinextendedb}', "");
Expect(1, 383, '\p{^Is_Block=latinextendedb}', "");
Expect(1, 383, '\P{Is_Block=latinextendedb}', "");
Expect(0, 383, '\P{^Is_Block=latinextendedb}', "");
Expect(1, 591, '\p{Is_Block=  latin_ExtendedB}', "");
Expect(0, 591, '\p{^Is_Block=  latin_ExtendedB}', "");
Expect(0, 591, '\P{Is_Block=  latin_ExtendedB}', "");
Expect(1, 591, '\P{^Is_Block=  latin_ExtendedB}', "");
Expect(0, 383, '\p{Is_Block=  latin_ExtendedB}', "");
Expect(1, 383, '\p{^Is_Block=  latin_ExtendedB}', "");
Expect(1, 383, '\P{Is_Block=  latin_ExtendedB}', "");
Expect(0, 383, '\P{^Is_Block=  latin_ExtendedB}', "");
Error('\p{Is_Blk=-_Latin/a/Extended_b}');
Error('\P{Is_Blk=-_Latin/a/Extended_b}');
Expect(1, 591, '\p{Is_Blk=latinextendedb}', "");
Expect(0, 591, '\p{^Is_Blk=latinextendedb}', "");
Expect(0, 591, '\P{Is_Blk=latinextendedb}', "");
Expect(1, 591, '\P{^Is_Blk=latinextendedb}', "");
Expect(0, 383, '\p{Is_Blk=latinextendedb}', "");
Expect(1, 383, '\p{^Is_Blk=latinextendedb}', "");
Expect(1, 383, '\P{Is_Blk=latinextendedb}', "");
Expect(0, 383, '\P{^Is_Blk=latinextendedb}', "");
Expect(1, 591, '\p{Is_Blk=	-LATIN-Extended	B}', "");
Expect(0, 591, '\p{^Is_Blk=	-LATIN-Extended	B}', "");
Expect(0, 591, '\P{Is_Blk=	-LATIN-Extended	B}', "");
Expect(1, 591, '\P{^Is_Blk=	-LATIN-Extended	B}', "");
Expect(0, 383, '\p{Is_Blk=	-LATIN-Extended	B}', "");
Expect(1, 383, '\p{^Is_Blk=	-LATIN-Extended	B}', "");
Expect(1, 383, '\P{Is_Blk=	-LATIN-Extended	B}', "");
Expect(0, 383, '\P{^Is_Blk=	-LATIN-Extended	B}', "");
Error('\p{Block=Supplemental:=ARROWSA}');
Error('\P{Block=Supplemental:=ARROWSA}');
Expect(1, 10239, '\p{Block=supplementalarrowsa}', "");
Expect(0, 10239, '\p{^Block=supplementalarrowsa}', "");
Expect(0, 10239, '\P{Block=supplementalarrowsa}', "");
Expect(1, 10239, '\P{^Block=supplementalarrowsa}', "");
Expect(0, 10223, '\p{Block=supplementalarrowsa}', "");
Expect(1, 10223, '\p{^Block=supplementalarrowsa}', "");
Expect(1, 10223, '\P{Block=supplementalarrowsa}', "");
Expect(0, 10223, '\P{^Block=supplementalarrowsa}', "");
Expect(1, 10239, '\p{Block=	-SUPPLEMENTAL_arrowsA}', "");
Expect(0, 10239, '\p{^Block=	-SUPPLEMENTAL_arrowsA}', "");
Expect(0, 10239, '\P{Block=	-SUPPLEMENTAL_arrowsA}', "");
Expect(1, 10239, '\P{^Block=	-SUPPLEMENTAL_arrowsA}', "");
Expect(0, 10223, '\p{Block=	-SUPPLEMENTAL_arrowsA}', "");
Expect(1, 10223, '\p{^Block=	-SUPPLEMENTAL_arrowsA}', "");
Expect(1, 10223, '\P{Block=	-SUPPLEMENTAL_arrowsA}', "");
Expect(0, 10223, '\P{^Block=	-SUPPLEMENTAL_arrowsA}', "");
Error('\p{Blk=/a/_supplementalArrows	A}');
Error('\P{Blk=/a/_supplementalArrows	A}');
Expect(1, 10239, '\p{Blk=supplementalarrowsa}', "");
Expect(0, 10239, '\p{^Blk=supplementalarrowsa}', "");
Expect(0, 10239, '\P{Blk=supplementalarrowsa}', "");
Expect(1, 10239, '\P{^Blk=supplementalarrowsa}', "");
Expect(0, 10223, '\p{Blk=supplementalarrowsa}', "");
Expect(1, 10223, '\p{^Blk=supplementalarrowsa}', "");
Expect(1, 10223, '\P{Blk=supplementalarrowsa}', "");
Expect(0, 10223, '\P{^Blk=supplementalarrowsa}', "");
Expect(1, 10239, '\p{Blk=__supplemental-Arrowsa}', "");
Expect(0, 10239, '\p{^Blk=__supplemental-Arrowsa}', "");
Expect(0, 10239, '\P{Blk=__supplemental-Arrowsa}', "");
Expect(1, 10239, '\P{^Blk=__supplemental-Arrowsa}', "");
Expect(0, 10223, '\p{Blk=__supplemental-Arrowsa}', "");
Expect(1, 10223, '\p{^Blk=__supplemental-Arrowsa}', "");
Expect(1, 10223, '\P{Blk=__supplemental-Arrowsa}', "");
Expect(0, 10223, '\P{^Blk=__supplemental-Arrowsa}', "");
Error('\p{Is_Block=	 SUPPLEMENTAL:=ARROWS_a}');
Error('\P{Is_Block=	 SUPPLEMENTAL:=ARROWS_a}');
Expect(1, 10239, '\p{Is_Block=supplementalarrowsa}', "");
Expect(0, 10239, '\p{^Is_Block=supplementalarrowsa}', "");
Expect(0, 10239, '\P{Is_Block=supplementalarrowsa}', "");
Expect(1, 10239, '\P{^Is_Block=supplementalarrowsa}', "");
Expect(0, 10223, '\p{Is_Block=supplementalarrowsa}', "");
Expect(1, 10223, '\p{^Is_Block=supplementalarrowsa}', "");
Expect(1, 10223, '\P{Is_Block=supplementalarrowsa}', "");
Expect(0, 10223, '\P{^Is_Block=supplementalarrowsa}', "");
Expect(1, 10239, '\p{Is_Block=		supplementalArrowsA}', "");
Expect(0, 10239, '\p{^Is_Block=		supplementalArrowsA}', "");
Expect(0, 10239, '\P{Is_Block=		supplementalArrowsA}', "");
Expect(1, 10239, '\P{^Is_Block=		supplementalArrowsA}', "");
Expect(0, 10223, '\p{Is_Block=		supplementalArrowsA}', "");
Expect(1, 10223, '\p{^Is_Block=		supplementalArrowsA}', "");
Expect(1, 10223, '\P{Is_Block=		supplementalArrowsA}', "");
Expect(0, 10223, '\P{^Is_Block=		supplementalArrowsA}', "");
Error('\p{Is_Blk:		-Supplemental:=Arrows A}');
Error('\P{Is_Blk:		-Supplemental:=Arrows A}');
Expect(1, 10239, '\p{Is_Blk=supplementalarrowsa}', "");
Expect(0, 10239, '\p{^Is_Blk=supplementalarrowsa}', "");
Expect(0, 10239, '\P{Is_Blk=supplementalarrowsa}', "");
Expect(1, 10239, '\P{^Is_Blk=supplementalarrowsa}', "");
Expect(0, 10223, '\p{Is_Blk=supplementalarrowsa}', "");
Expect(1, 10223, '\p{^Is_Blk=supplementalarrowsa}', "");
Expect(1, 10223, '\P{Is_Blk=supplementalarrowsa}', "");
Expect(0, 10223, '\P{^Is_Blk=supplementalarrowsa}', "");
Expect(1, 10239, '\p{Is_Blk=	 Supplemental	ARROWS A}', "");
Expect(0, 10239, '\p{^Is_Blk=	 Supplemental	ARROWS A}', "");
Expect(0, 10239, '\P{Is_Blk=	 Supplemental	ARROWS A}', "");
Expect(1, 10239, '\P{^Is_Blk=	 Supplemental	ARROWS A}', "");
Expect(0, 10223, '\p{Is_Blk=	 Supplemental	ARROWS A}', "");
Expect(1, 10223, '\p{^Is_Blk=	 Supplemental	ARROWS A}', "");
Expect(1, 10223, '\P{Is_Blk=	 Supplemental	ARROWS A}', "");
Expect(0, 10223, '\P{^Is_Blk=	 Supplemental	ARROWS A}', "");
Error('\p{Block=--Javanese/a/}');
Error('\P{Block=--Javanese/a/}');
Expect(1, 43487, '\p{Block=javanese}', "");
Expect(0, 43487, '\p{^Block=javanese}', "");
Expect(0, 43487, '\P{Block=javanese}', "");
Expect(1, 43487, '\P{^Block=javanese}', "");
Expect(0, 43391, '\p{Block=javanese}', "");
Expect(1, 43391, '\p{^Block=javanese}', "");
Expect(1, 43391, '\P{Block=javanese}', "");
Expect(0, 43391, '\P{^Block=javanese}', "");
Expect(1, 43487, '\p{Block=-javanese}', "");
Expect(0, 43487, '\p{^Block=-javanese}', "");
Expect(0, 43487, '\P{Block=-javanese}', "");
Expect(1, 43487, '\P{^Block=-javanese}', "");
Expect(0, 43391, '\p{Block=-javanese}', "");
Expect(1, 43391, '\p{^Block=-javanese}', "");
Expect(1, 43391, '\P{Block=-javanese}', "");
Expect(0, 43391, '\P{^Block=-javanese}', "");
Error('\p{Blk=	-Javanese/a/}');
Error('\P{Blk=	-Javanese/a/}');
Expect(1, 43487, '\p{Blk=javanese}', "");
Expect(0, 43487, '\p{^Blk=javanese}', "");
Expect(0, 43487, '\P{Blk=javanese}', "");
Expect(1, 43487, '\P{^Blk=javanese}', "");
Expect(0, 43391, '\p{Blk=javanese}', "");
Expect(1, 43391, '\p{^Blk=javanese}', "");
Expect(1, 43391, '\P{Blk=javanese}', "");
Expect(0, 43391, '\P{^Blk=javanese}', "");
Expect(1, 43487, '\p{Blk=_ javanese}', "");
Expect(0, 43487, '\p{^Blk=_ javanese}', "");
Expect(0, 43487, '\P{Blk=_ javanese}', "");
Expect(1, 43487, '\P{^Blk=_ javanese}', "");
Expect(0, 43391, '\p{Blk=_ javanese}', "");
Expect(1, 43391, '\p{^Blk=_ javanese}', "");
Expect(1, 43391, '\P{Blk=_ javanese}', "");
Expect(0, 43391, '\P{^Blk=_ javanese}', "");
Error('\p{Is_Block:_:=Javanese}');
Error('\P{Is_Block:_:=Javanese}');
Expect(1, 43487, '\p{Is_Block=javanese}', "");
Expect(0, 43487, '\p{^Is_Block=javanese}', "");
Expect(0, 43487, '\P{Is_Block=javanese}', "");
Expect(1, 43487, '\P{^Is_Block=javanese}', "");
Expect(0, 43391, '\p{Is_Block=javanese}', "");
Expect(1, 43391, '\p{^Is_Block=javanese}', "");
Expect(1, 43391, '\P{Is_Block=javanese}', "");
Expect(0, 43391, '\P{^Is_Block=javanese}', "");
Expect(1, 43487, '\p{Is_Block= Javanese}', "");
Expect(0, 43487, '\p{^Is_Block= Javanese}', "");
Expect(0, 43487, '\P{Is_Block= Javanese}', "");
Expect(1, 43487, '\P{^Is_Block= Javanese}', "");
Expect(0, 43391, '\p{Is_Block= Javanese}', "");
Expect(1, 43391, '\p{^Is_Block= Javanese}', "");
Expect(1, 43391, '\P{Is_Block= Javanese}', "");
Expect(0, 43391, '\P{^Is_Block= Javanese}', "");
Error('\p{Is_Blk= -Javanese:=}');
Error('\P{Is_Blk= -Javanese:=}');
Expect(1, 43487, '\p{Is_Blk=javanese}', "");
Expect(0, 43487, '\p{^Is_Blk=javanese}', "");
Expect(0, 43487, '\P{Is_Blk=javanese}', "");
Expect(1, 43487, '\P{^Is_Blk=javanese}', "");
Expect(0, 43391, '\p{Is_Blk=javanese}', "");
Expect(1, 43391, '\p{^Is_Blk=javanese}', "");
Expect(1, 43391, '\P{Is_Blk=javanese}', "");
Expect(0, 43391, '\P{^Is_Blk=javanese}', "");
Expect(1, 43487, '\p{Is_Blk=-Javanese}', "");
Expect(0, 43487, '\p{^Is_Blk=-Javanese}', "");
Expect(0, 43487, '\P{Is_Blk=-Javanese}', "");
Expect(1, 43487, '\P{^Is_Blk=-Javanese}', "");
Expect(0, 43391, '\p{Is_Blk=-Javanese}', "");
Expect(1, 43391, '\p{^Is_Blk=-Javanese}', "");
Expect(1, 43391, '\P{Is_Blk=-Javanese}', "");
Expect(0, 43391, '\P{^Is_Blk=-Javanese}', "");
Error('\p{Block=:=Supplementary-Private	UseArea_A}');
Error('\P{Block=:=Supplementary-Private	UseArea_A}');
Expect(1, 983040, '\p{Block=supplementaryprivateuseareaa}', "");
Expect(0, 983040, '\p{^Block=supplementaryprivateuseareaa}', "");
Expect(0, 983040, '\P{Block=supplementaryprivateuseareaa}', "");
Expect(1, 983040, '\P{^Block=supplementaryprivateuseareaa}', "");
Expect(0, 1, '\p{Block=supplementaryprivateuseareaa}', "");
Expect(1, 1, '\p{^Block=supplementaryprivateuseareaa}', "");
Expect(1, 1, '\P{Block=supplementaryprivateuseareaa}', "");
Expect(0, 1, '\P{^Block=supplementaryprivateuseareaa}', "");
Expect(1, 983040, '\p{Block=-	supplementary_PrivateUSE-Area_A}', "");
Expect(0, 983040, '\p{^Block=-	supplementary_PrivateUSE-Area_A}', "");
Expect(0, 983040, '\P{Block=-	supplementary_PrivateUSE-Area_A}', "");
Expect(1, 983040, '\P{^Block=-	supplementary_PrivateUSE-Area_A}', "");
Expect(0, 1, '\p{Block=-	supplementary_PrivateUSE-Area_A}', "");
Expect(1, 1, '\p{^Block=-	supplementary_PrivateUSE-Area_A}', "");
Expect(1, 1, '\P{Block=-	supplementary_PrivateUSE-Area_A}', "");
Expect(0, 1, '\P{^Block=-	supplementary_PrivateUSE-Area_A}', "");
Error('\p{Blk=-Supplementary-PRIVATE	Use area:=A}');
Error('\P{Blk=-Supplementary-PRIVATE	Use area:=A}');
Expect(1, 983040, '\p{Blk=supplementaryprivateuseareaa}', "");
Expect(0, 983040, '\p{^Blk=supplementaryprivateuseareaa}', "");
Expect(0, 983040, '\P{Blk=supplementaryprivateuseareaa}', "");
Expect(1, 983040, '\P{^Blk=supplementaryprivateuseareaa}', "");
Expect(0, 1, '\p{Blk=supplementaryprivateuseareaa}', "");
Expect(1, 1, '\p{^Blk=supplementaryprivateuseareaa}', "");
Expect(1, 1, '\P{Blk=supplementaryprivateuseareaa}', "");
Expect(0, 1, '\P{^Blk=supplementaryprivateuseareaa}', "");
Expect(1, 983040, '\p{Blk=--SupplementaryPrivate Usearea_A}', "");
Expect(0, 983040, '\p{^Blk=--SupplementaryPrivate Usearea_A}', "");
Expect(0, 983040, '\P{Blk=--SupplementaryPrivate Usearea_A}', "");
Expect(1, 983040, '\P{^Blk=--SupplementaryPrivate Usearea_A}', "");
Expect(0, 1, '\p{Blk=--SupplementaryPrivate Usearea_A}', "");
Expect(1, 1, '\p{^Blk=--SupplementaryPrivate Usearea_A}', "");
Expect(1, 1, '\P{Blk=--SupplementaryPrivate Usearea_A}', "");
Expect(0, 1, '\P{^Blk=--SupplementaryPrivate Usearea_A}', "");
Error('\p{Is_Block=_Supplementary/a/PRIVATE USE AREA	A}');
Error('\P{Is_Block=_Supplementary/a/PRIVATE USE AREA	A}');
Expect(1, 983040, '\p{Is_Block=supplementaryprivateuseareaa}', "");
Expect(0, 983040, '\p{^Is_Block=supplementaryprivateuseareaa}', "");
Expect(0, 983040, '\P{Is_Block=supplementaryprivateuseareaa}', "");
Expect(1, 983040, '\P{^Is_Block=supplementaryprivateuseareaa}', "");
Expect(0, 1, '\p{Is_Block=supplementaryprivateuseareaa}', "");
Expect(1, 1, '\p{^Is_Block=supplementaryprivateuseareaa}', "");
Expect(1, 1, '\P{Is_Block=supplementaryprivateuseareaa}', "");
Expect(0, 1, '\P{^Is_Block=supplementaryprivateuseareaa}', "");
Expect(1, 983040, '\p{Is_Block=	 Supplementary Private_UseareaA}', "");
Expect(0, 983040, '\p{^Is_Block=	 Supplementary Private_UseareaA}', "");
Expect(0, 983040, '\P{Is_Block=	 Supplementary Private_UseareaA}', "");
Expect(1, 983040, '\P{^Is_Block=	 Supplementary Private_UseareaA}', "");
Expect(0, 1, '\p{Is_Block=	 Supplementary Private_UseareaA}', "");
Expect(1, 1, '\p{^Is_Block=	 Supplementary Private_UseareaA}', "");
Expect(1, 1, '\P{Is_Block=	 Supplementary Private_UseareaA}', "");
Expect(0, 1, '\P{^Is_Block=	 Supplementary Private_UseareaA}', "");
Error('\p{Is_Blk:  /a/SUPPLEMENTARY	PRIVATE_use-Area	A}');
Error('\P{Is_Blk:  /a/SUPPLEMENTARY	PRIVATE_use-Area	A}');
Expect(1, 983040, '\p{Is_Blk=supplementaryprivateuseareaa}', "");
Expect(0, 983040, '\p{^Is_Blk=supplementaryprivateuseareaa}', "");
Expect(0, 983040, '\P{Is_Blk=supplementaryprivateuseareaa}', "");
Expect(1, 983040, '\P{^Is_Blk=supplementaryprivateuseareaa}', "");
Expect(0, 1, '\p{Is_Blk=supplementaryprivateuseareaa}', "");
Expect(1, 1, '\p{^Is_Blk=supplementaryprivateuseareaa}', "");
Expect(1, 1, '\P{Is_Blk=supplementaryprivateuseareaa}', "");
Expect(0, 1, '\P{^Is_Blk=supplementaryprivateuseareaa}', "");
Expect(1, 983040, '\p{Is_Blk=	SUPPLEMENTARY PRIVATE_use-Area-A}', "");
Expect(0, 983040, '\p{^Is_Blk=	SUPPLEMENTARY PRIVATE_use-Area-A}', "");
Expect(0, 983040, '\P{Is_Blk=	SUPPLEMENTARY PRIVATE_use-Area-A}', "");
Expect(1, 983040, '\P{^Is_Blk=	SUPPLEMENTARY PRIVATE_use-Area-A}', "");
Expect(0, 1, '\p{Is_Blk=	SUPPLEMENTARY PRIVATE_use-Area-A}', "");
Expect(1, 1, '\p{^Is_Blk=	SUPPLEMENTARY PRIVATE_use-Area-A}', "");
Expect(1, 1, '\P{Is_Blk=	SUPPLEMENTARY PRIVATE_use-Area-A}', "");
Expect(0, 1, '\P{^Is_Blk=	SUPPLEMENTARY PRIVATE_use-Area-A}', "");
Error('\p{Block=-:=hanunoo}');
Error('\P{Block=-:=hanunoo}');
Expect(1, 5951, '\p{Block=hanunoo}', "");
Expect(0, 5951, '\p{^Block=hanunoo}', "");
Expect(0, 5951, '\P{Block=hanunoo}', "");
Expect(1, 5951, '\P{^Block=hanunoo}', "");
Expect(0, 5919, '\p{Block=hanunoo}', "");
Expect(1, 5919, '\p{^Block=hanunoo}', "");
Expect(1, 5919, '\P{Block=hanunoo}', "");
Expect(0, 5919, '\P{^Block=hanunoo}', "");
Expect(1, 5951, '\p{Block=--Hanunoo}', "");
Expect(0, 5951, '\p{^Block=--Hanunoo}', "");
Expect(0, 5951, '\P{Block=--Hanunoo}', "");
Expect(1, 5951, '\P{^Block=--Hanunoo}', "");
Expect(0, 5919, '\p{Block=--Hanunoo}', "");
Expect(1, 5919, '\p{^Block=--Hanunoo}', "");
Expect(1, 5919, '\P{Block=--Hanunoo}', "");
Expect(0, 5919, '\P{^Block=--Hanunoo}', "");
Error('\p{Blk= 	hanunoo/a/}');
Error('\P{Blk= 	hanunoo/a/}');
Expect(1, 5951, '\p{Blk=hanunoo}', "");
Expect(0, 5951, '\p{^Blk=hanunoo}', "");
Expect(0, 5951, '\P{Blk=hanunoo}', "");
Expect(1, 5951, '\P{^Blk=hanunoo}', "");
Expect(0, 5919, '\p{Blk=hanunoo}', "");
Expect(1, 5919, '\p{^Blk=hanunoo}', "");
Expect(1, 5919, '\P{Blk=hanunoo}', "");
Expect(0, 5919, '\P{^Blk=hanunoo}', "");
Expect(1, 5951, '\p{Blk:  	HANUNOO}', "");
Expect(0, 5951, '\p{^Blk:  	HANUNOO}', "");
Expect(0, 5951, '\P{Blk:  	HANUNOO}', "");
Expect(1, 5951, '\P{^Blk:  	HANUNOO}', "");
Expect(0, 5919, '\p{Blk:  	HANUNOO}', "");
Expect(1, 5919, '\p{^Blk:  	HANUNOO}', "");
Expect(1, 5919, '\P{Blk:  	HANUNOO}', "");
Expect(0, 5919, '\P{^Blk:  	HANUNOO}', "");
Error('\p{Is_Block=		Hanunoo/a/}');
Error('\P{Is_Block=		Hanunoo/a/}');
Expect(1, 5951, '\p{Is_Block=hanunoo}', "");
Expect(0, 5951, '\p{^Is_Block=hanunoo}', "");
Expect(0, 5951, '\P{Is_Block=hanunoo}', "");
Expect(1, 5951, '\P{^Is_Block=hanunoo}', "");
Expect(0, 5919, '\p{Is_Block=hanunoo}', "");
Expect(1, 5919, '\p{^Is_Block=hanunoo}', "");
Expect(1, 5919, '\P{Is_Block=hanunoo}', "");
Expect(0, 5919, '\P{^Is_Block=hanunoo}', "");
Expect(1, 5951, '\p{Is_Block=		Hanunoo}', "");
Expect(0, 5951, '\p{^Is_Block=		Hanunoo}', "");
Expect(0, 5951, '\P{Is_Block=		Hanunoo}', "");
Expect(1, 5951, '\P{^Is_Block=		Hanunoo}', "");
Expect(0, 5919, '\p{Is_Block=		Hanunoo}', "");
Expect(1, 5919, '\p{^Is_Block=		Hanunoo}', "");
Expect(1, 5919, '\P{Is_Block=		Hanunoo}', "");
Expect(0, 5919, '\P{^Is_Block=		Hanunoo}', "");
Error('\p{Is_Blk=/a/_	HANUNOO}');
Error('\P{Is_Blk=/a/_	HANUNOO}');
Expect(1, 5951, '\p{Is_Blk=hanunoo}', "");
Expect(0, 5951, '\p{^Is_Blk=hanunoo}', "");
Expect(0, 5951, '\P{Is_Blk=hanunoo}', "");
Expect(1, 5951, '\P{^Is_Blk=hanunoo}', "");
Expect(0, 5919, '\p{Is_Blk=hanunoo}', "");
Expect(1, 5919, '\p{^Is_Blk=hanunoo}', "");
Expect(1, 5919, '\P{Is_Blk=hanunoo}', "");
Expect(0, 5919, '\P{^Is_Blk=hanunoo}', "");
Expect(1, 5951, '\p{Is_Blk=-Hanunoo}', "");
Expect(0, 5951, '\p{^Is_Blk=-Hanunoo}', "");
Expect(0, 5951, '\P{Is_Blk=-Hanunoo}', "");
Expect(1, 5951, '\P{^Is_Blk=-Hanunoo}', "");
Expect(0, 5919, '\p{Is_Blk=-Hanunoo}', "");
Expect(1, 5919, '\p{^Is_Blk=-Hanunoo}', "");
Expect(1, 5919, '\P{Is_Blk=-Hanunoo}', "");
Expect(0, 5919, '\P{^Is_Blk=-Hanunoo}', "");
Error('\p{Block=_/a/low surrogates}');
Error('\P{Block=_/a/low surrogates}');
Expect(0, 1, '\p{Block=lowsurrogates}', "");
Expect(1, 1, '\p{^Block=lowsurrogates}', "");
Expect(1, 1, '\P{Block=lowsurrogates}', "");
Expect(0, 1, '\P{^Block=lowsurrogates}', "");
Expect(0, 1, '\p{Block=--LOW	Surrogates}', "");
Expect(1, 1, '\p{^Block=--LOW	Surrogates}', "");
Expect(1, 1, '\P{Block=--LOW	Surrogates}', "");
Expect(0, 1, '\P{^Block=--LOW	Surrogates}', "");
Error('\p{Blk=-_Low:=Surrogates}');
Error('\P{Blk=-_Low:=Surrogates}');
Expect(0, 1, '\p{Blk=lowsurrogates}', "");
Expect(1, 1, '\p{^Blk=lowsurrogates}', "");
Expect(1, 1, '\P{Blk=lowsurrogates}', "");
Expect(0, 1, '\P{^Blk=lowsurrogates}', "");
Expect(0, 1, '\p{Blk=  LowSurrogates}', "");
Expect(1, 1, '\p{^Blk=  LowSurrogates}', "");
Expect(1, 1, '\P{Blk=  LowSurrogates}', "");
Expect(0, 1, '\P{^Blk=  LowSurrogates}', "");
Error('\p{Is_Block=/a/	 Low	Surrogates}');
Error('\P{Is_Block=/a/	 Low	Surrogates}');
Expect(0, 1, '\p{Is_Block=lowsurrogates}', "");
Expect(1, 1, '\p{^Is_Block=lowsurrogates}', "");
Expect(1, 1, '\P{Is_Block=lowsurrogates}', "");
Expect(0, 1, '\P{^Is_Block=lowsurrogates}', "");
Expect(0, 1, '\p{Is_Block=_ low	Surrogates}', "");
Expect(1, 1, '\p{^Is_Block=_ low	Surrogates}', "");
Expect(1, 1, '\P{Is_Block=_ low	Surrogates}', "");
Expect(0, 1, '\P{^Is_Block=_ low	Surrogates}', "");
Error('\p{Is_Blk=- LOW-Surrogates/a/}');
Error('\P{Is_Blk=- LOW-Surrogates/a/}');
Expect(0, 1, '\p{Is_Blk=lowsurrogates}', "");
Expect(1, 1, '\p{^Is_Blk=lowsurrogates}', "");
Expect(1, 1, '\P{Is_Blk=lowsurrogates}', "");
Expect(0, 1, '\P{^Is_Blk=lowsurrogates}', "");
Expect(0, 1, '\p{Is_Blk=_	low-Surrogates}', "");
Expect(1, 1, '\p{^Is_Blk=_	low-Surrogates}', "");
Expect(1, 1, '\P{Is_Blk=_	low-Surrogates}', "");
Expect(0, 1, '\P{^Is_Blk=_	low-Surrogates}', "");
Error('\p{Block=	/a/Katakana}');
Error('\P{Block=	/a/Katakana}');
Expect(1, 12543, '\p{Block=katakana}', "");
Expect(0, 12543, '\p{^Block=katakana}', "");
Expect(0, 12543, '\P{Block=katakana}', "");
Expect(1, 12543, '\P{^Block=katakana}', "");
Expect(0, 12447, '\p{Block=katakana}', "");
Expect(1, 12447, '\p{^Block=katakana}', "");
Expect(1, 12447, '\P{Block=katakana}', "");
Expect(0, 12447, '\P{^Block=katakana}', "");
Expect(1, 12543, '\p{Block=	KATAKANA}', "");
Expect(0, 12543, '\p{^Block=	KATAKANA}', "");
Expect(0, 12543, '\P{Block=	KATAKANA}', "");
Expect(1, 12543, '\P{^Block=	KATAKANA}', "");
Expect(0, 12447, '\p{Block=	KATAKANA}', "");
Expect(1, 12447, '\p{^Block=	KATAKANA}', "");
Expect(1, 12447, '\P{Block=	KATAKANA}', "");
Expect(0, 12447, '\P{^Block=	KATAKANA}', "");
Error('\p{Blk: 		katakana/a/}');
Error('\P{Blk: 		katakana/a/}');
Expect(1, 12543, '\p{Blk=katakana}', "");
Expect(0, 12543, '\p{^Blk=katakana}', "");
Expect(0, 12543, '\P{Blk=katakana}', "");
Expect(1, 12543, '\P{^Blk=katakana}', "");
Expect(0, 12447, '\p{Blk=katakana}', "");
Expect(1, 12447, '\p{^Blk=katakana}', "");
Expect(1, 12447, '\P{Blk=katakana}', "");
Expect(0, 12447, '\P{^Blk=katakana}', "");
Expect(1, 12543, '\p{Blk:-Katakana}', "");
Expect(0, 12543, '\p{^Blk:-Katakana}', "");
Expect(0, 12543, '\P{Blk:-Katakana}', "");
Expect(1, 12543, '\P{^Blk:-Katakana}', "");
Expect(0, 12447, '\p{Blk:-Katakana}', "");
Expect(1, 12447, '\p{^Blk:-Katakana}', "");
Expect(1, 12447, '\P{Blk:-Katakana}', "");
Expect(0, 12447, '\P{^Blk:-Katakana}', "");
Error('\p{Is_Block=-KATAKANA:=}');
Error('\P{Is_Block=-KATAKANA:=}');
Expect(1, 12543, '\p{Is_Block=katakana}', "");
Expect(0, 12543, '\p{^Is_Block=katakana}', "");
Expect(0, 12543, '\P{Is_Block=katakana}', "");
Expect(1, 12543, '\P{^Is_Block=katakana}', "");
Expect(0, 12447, '\p{Is_Block=katakana}', "");
Expect(1, 12447, '\p{^Is_Block=katakana}', "");
Expect(1, 12447, '\P{Is_Block=katakana}', "");
Expect(0, 12447, '\P{^Is_Block=katakana}', "");
Expect(1, 12543, '\p{Is_Block= _Katakana}', "");
Expect(0, 12543, '\p{^Is_Block= _Katakana}', "");
Expect(0, 12543, '\P{Is_Block= _Katakana}', "");
Expect(1, 12543, '\P{^Is_Block= _Katakana}', "");
Expect(0, 12447, '\p{Is_Block= _Katakana}', "");
Expect(1, 12447, '\p{^Is_Block= _Katakana}', "");
Expect(1, 12447, '\P{Is_Block= _Katakana}', "");
Expect(0, 12447, '\P{^Is_Block= _Katakana}', "");
Error('\p{Is_Blk=:=	 KATAKANA}');
Error('\P{Is_Blk=:=	 KATAKANA}');
Expect(1, 12543, '\p{Is_Blk=katakana}', "");
Expect(0, 12543, '\p{^Is_Blk=katakana}', "");
Expect(0, 12543, '\P{Is_Blk=katakana}', "");
Expect(1, 12543, '\P{^Is_Blk=katakana}', "");
Expect(0, 12447, '\p{Is_Blk=katakana}', "");
Expect(1, 12447, '\p{^Is_Blk=katakana}', "");
Expect(1, 12447, '\P{Is_Blk=katakana}', "");
Expect(0, 12447, '\P{^Is_Blk=katakana}', "");
Expect(1, 12543, '\p{Is_Blk:		Katakana}', "");
Expect(0, 12543, '\p{^Is_Blk:		Katakana}', "");
Expect(0, 12543, '\P{Is_Blk:		Katakana}', "");
Expect(1, 12543, '\P{^Is_Blk:		Katakana}', "");
Expect(0, 12447, '\p{Is_Blk:		Katakana}', "");
Expect(1, 12447, '\p{^Is_Blk:		Katakana}', "");
Expect(1, 12447, '\P{Is_Blk:		Katakana}', "");
Expect(0, 12447, '\P{^Is_Blk:		Katakana}', "");
Error('\p{Block=/a/Cuneiform}');
Error('\P{Block=/a/Cuneiform}');
Expect(1, 74751, '\p{Block=cuneiform}', "");
Expect(0, 74751, '\p{^Block=cuneiform}', "");
Expect(0, 74751, '\P{Block=cuneiform}', "");
Expect(1, 74751, '\P{^Block=cuneiform}', "");
Expect(0, 73727, '\p{Block=cuneiform}', "");
Expect(1, 73727, '\p{^Block=cuneiform}', "");
Expect(1, 73727, '\P{Block=cuneiform}', "");
Expect(0, 73727, '\P{^Block=cuneiform}', "");
Expect(1, 74751, '\p{Block= -cuneiform}', "");
Expect(0, 74751, '\p{^Block= -cuneiform}', "");
Expect(0, 74751, '\P{Block= -cuneiform}', "");
Expect(1, 74751, '\P{^Block= -cuneiform}', "");
Expect(0, 73727, '\p{Block= -cuneiform}', "");
Expect(1, 73727, '\p{^Block= -cuneiform}', "");
Expect(1, 73727, '\P{Block= -cuneiform}', "");
Expect(0, 73727, '\P{^Block= -cuneiform}', "");
Error('\p{Blk=-	CUNEIFORM/a/}');
Error('\P{Blk=-	CUNEIFORM/a/}');
Expect(1, 74751, '\p{Blk=cuneiform}', "");
Expect(0, 74751, '\p{^Blk=cuneiform}', "");
Expect(0, 74751, '\P{Blk=cuneiform}', "");
Expect(1, 74751, '\P{^Blk=cuneiform}', "");
Expect(0, 73727, '\p{Blk=cuneiform}', "");
Expect(1, 73727, '\p{^Blk=cuneiform}', "");
Expect(1, 73727, '\P{Blk=cuneiform}', "");
Expect(0, 73727, '\P{^Blk=cuneiform}', "");
Expect(1, 74751, '\p{Blk:	CUNEIFORM}', "");
Expect(0, 74751, '\p{^Blk:	CUNEIFORM}', "");
Expect(0, 74751, '\P{Blk:	CUNEIFORM}', "");
Expect(1, 74751, '\P{^Blk:	CUNEIFORM}', "");
Expect(0, 73727, '\p{Blk:	CUNEIFORM}', "");
Expect(1, 73727, '\p{^Blk:	CUNEIFORM}', "");
Expect(1, 73727, '\P{Blk:	CUNEIFORM}', "");
Expect(0, 73727, '\P{^Blk:	CUNEIFORM}', "");
Error('\p{Is_Block:			CUNEIFORM:=}');
Error('\P{Is_Block:			CUNEIFORM:=}');
Expect(1, 74751, '\p{Is_Block=cuneiform}', "");
Expect(0, 74751, '\p{^Is_Block=cuneiform}', "");
Expect(0, 74751, '\P{Is_Block=cuneiform}', "");
Expect(1, 74751, '\P{^Is_Block=cuneiform}', "");
Expect(0, 73727, '\p{Is_Block=cuneiform}', "");
Expect(1, 73727, '\p{^Is_Block=cuneiform}', "");
Expect(1, 73727, '\P{Is_Block=cuneiform}', "");
Expect(0, 73727, '\P{^Is_Block=cuneiform}', "");
Expect(1, 74751, '\p{Is_Block= -CUNEIFORM}', "");
Expect(0, 74751, '\p{^Is_Block= -CUNEIFORM}', "");
Expect(0, 74751, '\P{Is_Block= -CUNEIFORM}', "");
Expect(1, 74751, '\P{^Is_Block= -CUNEIFORM}', "");
Expect(0, 73727, '\p{Is_Block= -CUNEIFORM}', "");
Expect(1, 73727, '\p{^Is_Block= -CUNEIFORM}', "");
Expect(1, 73727, '\P{Is_Block= -CUNEIFORM}', "");
Expect(0, 73727, '\P{^Is_Block= -CUNEIFORM}', "");
Error('\p{Is_Blk=:= -CUNEIFORM}');
Error('\P{Is_Blk=:= -CUNEIFORM}');
Expect(1, 74751, '\p{Is_Blk=cuneiform}', "");
Expect(0, 74751, '\p{^Is_Blk=cuneiform}', "");
Expect(0, 74751, '\P{Is_Blk=cuneiform}', "");
Expect(1, 74751, '\P{^Is_Blk=cuneiform}', "");
Expect(0, 73727, '\p{Is_Blk=cuneiform}', "");
Expect(1, 73727, '\p{^Is_Blk=cuneiform}', "");
Expect(1, 73727, '\P{Is_Blk=cuneiform}', "");
Expect(0, 73727, '\P{^Is_Blk=cuneiform}', "");
Expect(1, 74751, '\p{Is_Blk:	-cuneiform}', "");
Expect(0, 74751, '\p{^Is_Blk:	-cuneiform}', "");
Expect(0, 74751, '\P{Is_Blk:	-cuneiform}', "");
Expect(1, 74751, '\P{^Is_Blk:	-cuneiform}', "");
Expect(0, 73727, '\p{Is_Blk:	-cuneiform}', "");
Expect(1, 73727, '\p{^Is_Blk:	-cuneiform}', "");
Expect(1, 73727, '\P{Is_Blk:	-cuneiform}', "");
Expect(0, 73727, '\P{^Is_Blk:	-cuneiform}', "");
Error('\p{Block= High/a/SURROGATES}');
Error('\P{Block= High/a/SURROGATES}');
Expect(0, 55295, '\p{Block=highsurrogates}', "");
Expect(1, 55295, '\p{^Block=highsurrogates}', "");
Expect(1, 55295, '\P{Block=highsurrogates}', "");
Expect(0, 55295, '\P{^Block=highsurrogates}', "");
Expect(0, 55295, '\p{Block=		high	Surrogates}', "");
Expect(1, 55295, '\p{^Block=		high	Surrogates}', "");
Expect(1, 55295, '\P{Block=		high	Surrogates}', "");
Expect(0, 55295, '\P{^Block=		high	Surrogates}', "");
Error('\p{Blk=-High/a/Surrogates}');
Error('\P{Blk=-High/a/Surrogates}');
Expect(0, 55295, '\p{Blk=highsurrogates}', "");
Expect(1, 55295, '\p{^Blk=highsurrogates}', "");
Expect(1, 55295, '\P{Blk=highsurrogates}', "");
Expect(0, 55295, '\P{^Blk=highsurrogates}', "");
Expect(0, 55295, '\p{Blk=high_surrogates}', "");
Expect(1, 55295, '\p{^Blk=high_surrogates}', "");
Expect(1, 55295, '\P{Blk=high_surrogates}', "");
Expect(0, 55295, '\P{^Blk=high_surrogates}', "");
Error('\p{Is_Block=-	High/a/Surrogates}');
Error('\P{Is_Block=-	High/a/Surrogates}');
Expect(0, 55295, '\p{Is_Block=highsurrogates}', "");
Expect(1, 55295, '\p{^Is_Block=highsurrogates}', "");
Expect(1, 55295, '\P{Is_Block=highsurrogates}', "");
Expect(0, 55295, '\P{^Is_Block=highsurrogates}', "");
Expect(0, 55295, '\p{Is_Block=		highSurrogates}', "");
Expect(1, 55295, '\p{^Is_Block=		highSurrogates}', "");
Expect(1, 55295, '\P{Is_Block=		highSurrogates}', "");
Expect(0, 55295, '\P{^Is_Block=		highSurrogates}', "");
Error('\p{Is_Blk=--High-Surrogates/a/}');
Error('\P{Is_Blk=--High-Surrogates/a/}');
Expect(0, 55295, '\p{Is_Blk=highsurrogates}', "");
Expect(1, 55295, '\p{^Is_Blk=highsurrogates}', "");
Expect(1, 55295, '\P{Is_Blk=highsurrogates}', "");
Expect(0, 55295, '\P{^Is_Blk=highsurrogates}', "");
Expect(0, 55295, '\p{Is_Blk=_ highSURROGATES}', "");
Expect(1, 55295, '\p{^Is_Blk=_ highSURROGATES}', "");
Expect(1, 55295, '\P{Is_Blk=_ highSURROGATES}', "");
Expect(0, 55295, '\P{^Is_Blk=_ highSURROGATES}', "");
Error('\p{Block=:=	 rumi-NUMERAL	SYMBOLS}');
Error('\P{Block=:=	 rumi-NUMERAL	SYMBOLS}');
Expect(1, 69247, '\p{Block=ruminumeralsymbols}', "");
Expect(0, 69247, '\p{^Block=ruminumeralsymbols}', "");
Expect(0, 69247, '\P{Block=ruminumeralsymbols}', "");
Expect(1, 69247, '\P{^Block=ruminumeralsymbols}', "");
Expect(0, 69215, '\p{Block=ruminumeralsymbols}', "");
Expect(1, 69215, '\p{^Block=ruminumeralsymbols}', "");
Expect(1, 69215, '\P{Block=ruminumeralsymbols}', "");
Expect(0, 69215, '\P{^Block=ruminumeralsymbols}', "");
Expect(1, 69247, '\p{Block= 	Rumi-Numeral SYMBOLS}', "");
Expect(0, 69247, '\p{^Block= 	Rumi-Numeral SYMBOLS}', "");
Expect(0, 69247, '\P{Block= 	Rumi-Numeral SYMBOLS}', "");
Expect(1, 69247, '\P{^Block= 	Rumi-Numeral SYMBOLS}', "");
Expect(0, 69215, '\p{Block= 	Rumi-Numeral SYMBOLS}', "");
Expect(1, 69215, '\p{^Block= 	Rumi-Numeral SYMBOLS}', "");
Expect(1, 69215, '\P{Block= 	Rumi-Numeral SYMBOLS}', "");
Expect(0, 69215, '\P{^Block= 	Rumi-Numeral SYMBOLS}', "");
Error('\p{Blk=:= RUMI	Numeralsymbols}');
Error('\P{Blk=:= RUMI	Numeralsymbols}');
Expect(1, 69247, '\p{Blk=ruminumeralsymbols}', "");
Expect(0, 69247, '\p{^Blk=ruminumeralsymbols}', "");
Expect(0, 69247, '\P{Blk=ruminumeralsymbols}', "");
Expect(1, 69247, '\P{^Blk=ruminumeralsymbols}', "");
Expect(0, 69215, '\p{Blk=ruminumeralsymbols}', "");
Expect(1, 69215, '\p{^Blk=ruminumeralsymbols}', "");
Expect(1, 69215, '\P{Blk=ruminumeralsymbols}', "");
Expect(0, 69215, '\P{^Blk=ruminumeralsymbols}', "");
Expect(1, 69247, '\p{Blk=_-RumiNumeral-symbols}', "");
Expect(0, 69247, '\p{^Blk=_-RumiNumeral-symbols}', "");
Expect(0, 69247, '\P{Blk=_-RumiNumeral-symbols}', "");
Expect(1, 69247, '\P{^Blk=_-RumiNumeral-symbols}', "");
Expect(0, 69215, '\p{Blk=_-RumiNumeral-symbols}', "");
Expect(1, 69215, '\p{^Blk=_-RumiNumeral-symbols}', "");
Expect(1, 69215, '\P{Blk=_-RumiNumeral-symbols}', "");
Expect(0, 69215, '\P{^Blk=_-RumiNumeral-symbols}', "");
Error('\p{Is_Block=/a/Rumi-NumeralSYMBOLS}');
Error('\P{Is_Block=/a/Rumi-NumeralSYMBOLS}');
Expect(1, 69247, '\p{Is_Block=ruminumeralsymbols}', "");
Expect(0, 69247, '\p{^Is_Block=ruminumeralsymbols}', "");
Expect(0, 69247, '\P{Is_Block=ruminumeralsymbols}', "");
Expect(1, 69247, '\P{^Is_Block=ruminumeralsymbols}', "");
Expect(0, 69215, '\p{Is_Block=ruminumeralsymbols}', "");
Expect(1, 69215, '\p{^Is_Block=ruminumeralsymbols}', "");
Expect(1, 69215, '\P{Is_Block=ruminumeralsymbols}', "");
Expect(0, 69215, '\P{^Is_Block=ruminumeralsymbols}', "");
Expect(1, 69247, '\p{Is_Block=	Rumi_Numeral	Symbols}', "");
Expect(0, 69247, '\p{^Is_Block=	Rumi_Numeral	Symbols}', "");
Expect(0, 69247, '\P{Is_Block=	Rumi_Numeral	Symbols}', "");
Expect(1, 69247, '\P{^Is_Block=	Rumi_Numeral	Symbols}', "");
Expect(0, 69215, '\p{Is_Block=	Rumi_Numeral	Symbols}', "");
Expect(1, 69215, '\p{^Is_Block=	Rumi_Numeral	Symbols}', "");
Expect(1, 69215, '\P{Is_Block=	Rumi_Numeral	Symbols}', "");
Expect(0, 69215, '\P{^Is_Block=	Rumi_Numeral	Symbols}', "");
Error('\p{Is_Blk=	_RUMI-NUMERAL:=Symbols}');
Error('\P{Is_Blk=	_RUMI-NUMERAL:=Symbols}');
Expect(1, 69247, '\p{Is_Blk=ruminumeralsymbols}', "");
Expect(0, 69247, '\p{^Is_Blk=ruminumeralsymbols}', "");
Expect(0, 69247, '\P{Is_Blk=ruminumeralsymbols}', "");
Expect(1, 69247, '\P{^Is_Blk=ruminumeralsymbols}', "");
Expect(0, 69215, '\p{Is_Blk=ruminumeralsymbols}', "");
Expect(1, 69215, '\p{^Is_Blk=ruminumeralsymbols}', "");
Expect(1, 69215, '\P{Is_Blk=ruminumeralsymbols}', "");
Expect(0, 69215, '\P{^Is_Blk=ruminumeralsymbols}', "");
Expect(1, 69247, '\p{Is_Blk=--RUMI Numeral-Symbols}', "");
Expect(0, 69247, '\p{^Is_Blk=--RUMI Numeral-Symbols}', "");
Expect(0, 69247, '\P{Is_Blk=--RUMI Numeral-Symbols}', "");
Expect(1, 69247, '\P{^Is_Blk=--RUMI Numeral-Symbols}', "");
Expect(0, 69215, '\p{Is_Blk=--RUMI Numeral-Symbols}', "");
Expect(1, 69215, '\p{^Is_Blk=--RUMI Numeral-Symbols}', "");
Expect(1, 69215, '\P{Is_Blk=--RUMI Numeral-Symbols}', "");
Expect(0, 69215, '\P{^Is_Blk=--RUMI Numeral-Symbols}', "");
Error('\p{Block=:=	_variation	selectors	SUPPLEMENT}');
Error('\P{Block=:=	_variation	selectors	SUPPLEMENT}');
Expect(1, 917999, '\p{Block=variationselectorssupplement}', "");
Expect(0, 917999, '\p{^Block=variationselectorssupplement}', "");
Expect(0, 917999, '\P{Block=variationselectorssupplement}', "");
Expect(1, 917999, '\P{^Block=variationselectorssupplement}', "");
Expect(0, 917759, '\p{Block=variationselectorssupplement}', "");
Expect(1, 917759, '\p{^Block=variationselectorssupplement}', "");
Expect(1, 917759, '\P{Block=variationselectorssupplement}', "");
Expect(0, 917759, '\P{^Block=variationselectorssupplement}', "");
Expect(1, 917999, '\p{Block=- Variation_SELECTORSsupplement}', "");
Expect(0, 917999, '\p{^Block=- Variation_SELECTORSsupplement}', "");
Expect(0, 917999, '\P{Block=- Variation_SELECTORSsupplement}', "");
Expect(1, 917999, '\P{^Block=- Variation_SELECTORSsupplement}', "");
Expect(0, 917759, '\p{Block=- Variation_SELECTORSsupplement}', "");
Expect(1, 917759, '\p{^Block=- Variation_SELECTORSsupplement}', "");
Expect(1, 917759, '\P{Block=- Variation_SELECTORSsupplement}', "");
Expect(0, 917759, '\P{^Block=- Variation_SELECTORSsupplement}', "");
Error('\p{Blk=/a/ -Variation	selectorssupplement}');
Error('\P{Blk=/a/ -Variation	selectorssupplement}');
Expect(1, 917999, '\p{Blk=variationselectorssupplement}', "");
Expect(0, 917999, '\p{^Blk=variationselectorssupplement}', "");
Expect(0, 917999, '\P{Blk=variationselectorssupplement}', "");
Expect(1, 917999, '\P{^Blk=variationselectorssupplement}', "");
Expect(0, 917759, '\p{Blk=variationselectorssupplement}', "");
Expect(1, 917759, '\p{^Blk=variationselectorssupplement}', "");
Expect(1, 917759, '\P{Blk=variationselectorssupplement}', "");
Expect(0, 917759, '\P{^Blk=variationselectorssupplement}', "");
Expect(1, 917999, '\p{Blk= -variationSELECTORS	SUPPLEMENT}', "");
Expect(0, 917999, '\p{^Blk= -variationSELECTORS	SUPPLEMENT}', "");
Expect(0, 917999, '\P{Blk= -variationSELECTORS	SUPPLEMENT}', "");
Expect(1, 917999, '\P{^Blk= -variationSELECTORS	SUPPLEMENT}', "");
Expect(0, 917759, '\p{Blk= -variationSELECTORS	SUPPLEMENT}', "");
Expect(1, 917759, '\p{^Blk= -variationSELECTORS	SUPPLEMENT}', "");
Expect(1, 917759, '\P{Blk= -variationSELECTORS	SUPPLEMENT}', "");
Expect(0, 917759, '\P{^Blk= -variationSELECTORS	SUPPLEMENT}', "");
Error('\p{Is_Block=		variation:=SELECTORSSupplement}');
Error('\P{Is_Block=		variation:=SELECTORSSupplement}');
Expect(1, 917999, '\p{Is_Block=variationselectorssupplement}', "");
Expect(0, 917999, '\p{^Is_Block=variationselectorssupplement}', "");
Expect(0, 917999, '\P{Is_Block=variationselectorssupplement}', "");
Expect(1, 917999, '\P{^Is_Block=variationselectorssupplement}', "");
Expect(0, 917759, '\p{Is_Block=variationselectorssupplement}', "");
Expect(1, 917759, '\p{^Is_Block=variationselectorssupplement}', "");
Expect(1, 917759, '\P{Is_Block=variationselectorssupplement}', "");
Expect(0, 917759, '\P{^Is_Block=variationselectorssupplement}', "");
Expect(1, 917999, '\p{Is_Block:   --variation	Selectors Supplement}', "");
Expect(0, 917999, '\p{^Is_Block:   --variation	Selectors Supplement}', "");
Expect(0, 917999, '\P{Is_Block:   --variation	Selectors Supplement}', "");
Expect(1, 917999, '\P{^Is_Block:   --variation	Selectors Supplement}', "");
Expect(0, 917759, '\p{Is_Block:   --variation	Selectors Supplement}', "");
Expect(1, 917759, '\p{^Is_Block:   --variation	Selectors Supplement}', "");
Expect(1, 917759, '\P{Is_Block:   --variation	Selectors Supplement}', "");
Expect(0, 917759, '\P{^Is_Block:   --variation	Selectors Supplement}', "");
Error('\p{Is_Blk=-	VARIATIONSelectors:=Supplement}');
Error('\P{Is_Blk=-	VARIATIONSelectors:=Supplement}');
Expect(1, 917999, '\p{Is_Blk=variationselectorssupplement}', "");
Expect(0, 917999, '\p{^Is_Blk=variationselectorssupplement}', "");
Expect(0, 917999, '\P{Is_Blk=variationselectorssupplement}', "");
Expect(1, 917999, '\P{^Is_Blk=variationselectorssupplement}', "");
Expect(0, 917759, '\p{Is_Blk=variationselectorssupplement}', "");
Expect(1, 917759, '\p{^Is_Blk=variationselectorssupplement}', "");
Expect(1, 917759, '\P{Is_Blk=variationselectorssupplement}', "");
Expect(0, 917759, '\P{^Is_Blk=variationselectorssupplement}', "");
Expect(1, 917999, '\p{Is_Blk=_	Variation	Selectors_supplement}', "");
Expect(0, 917999, '\p{^Is_Blk=_	Variation	Selectors_supplement}', "");
Expect(0, 917999, '\P{Is_Blk=_	Variation	Selectors_supplement}', "");
Expect(1, 917999, '\P{^Is_Blk=_	Variation	Selectors_supplement}', "");
Expect(0, 917759, '\p{Is_Blk=_	Variation	Selectors_supplement}', "");
Expect(1, 917759, '\p{^Is_Blk=_	Variation	Selectors_supplement}', "");
Expect(1, 917759, '\P{Is_Blk=_	Variation	Selectors_supplement}', "");
Expect(0, 917759, '\P{^Is_Blk=_	Variation	Selectors_supplement}', "");
Error('\p{Block=_	Georgian:=Supplement}');
Error('\P{Block=_	Georgian:=Supplement}');
Expect(1, 11567, '\p{Block=georgiansupplement}', "");
Expect(0, 11567, '\p{^Block=georgiansupplement}', "");
Expect(0, 11567, '\P{Block=georgiansupplement}', "");
Expect(1, 11567, '\P{^Block=georgiansupplement}', "");
Expect(0, 11519, '\p{Block=georgiansupplement}', "");
Expect(1, 11519, '\p{^Block=georgiansupplement}', "");
Expect(1, 11519, '\P{Block=georgiansupplement}', "");
Expect(0, 11519, '\P{^Block=georgiansupplement}', "");
Expect(1, 11567, '\p{Block=		Georgian	supplement}', "");
Expect(0, 11567, '\p{^Block=		Georgian	supplement}', "");
Expect(0, 11567, '\P{Block=		Georgian	supplement}', "");
Expect(1, 11567, '\P{^Block=		Georgian	supplement}', "");
Expect(0, 11519, '\p{Block=		Georgian	supplement}', "");
Expect(1, 11519, '\p{^Block=		Georgian	supplement}', "");
Expect(1, 11519, '\P{Block=		Georgian	supplement}', "");
Expect(0, 11519, '\P{^Block=		Georgian	supplement}', "");
Error('\p{Blk=_:=Georgian_supplement}');
Error('\P{Blk=_:=Georgian_supplement}');
Expect(1, 11567, '\p{Blk=georgiansupplement}', "");
Expect(0, 11567, '\p{^Blk=georgiansupplement}', "");
Expect(0, 11567, '\P{Blk=georgiansupplement}', "");
Expect(1, 11567, '\P{^Blk=georgiansupplement}', "");
Expect(0, 11519, '\p{Blk=georgiansupplement}', "");
Expect(1, 11519, '\p{^Blk=georgiansupplement}', "");
Expect(1, 11519, '\P{Blk=georgiansupplement}', "");
Expect(0, 11519, '\P{^Blk=georgiansupplement}', "");
Expect(1, 11567, '\p{Blk=__Georgian supplement}', "");
Expect(0, 11567, '\p{^Blk=__Georgian supplement}', "");
Expect(0, 11567, '\P{Blk=__Georgian supplement}', "");
Expect(1, 11567, '\P{^Blk=__Georgian supplement}', "");
Expect(0, 11519, '\p{Blk=__Georgian supplement}', "");
Expect(1, 11519, '\p{^Blk=__Georgian supplement}', "");
Expect(1, 11519, '\P{Blk=__Georgian supplement}', "");
Expect(0, 11519, '\P{^Blk=__Georgian supplement}', "");
Error('\p{Is_Block:		:=GEORGIAN-Supplement}');
Error('\P{Is_Block:		:=GEORGIAN-Supplement}');
Expect(1, 11567, '\p{Is_Block=georgiansupplement}', "");
Expect(0, 11567, '\p{^Is_Block=georgiansupplement}', "");
Expect(0, 11567, '\P{Is_Block=georgiansupplement}', "");
Expect(1, 11567, '\P{^Is_Block=georgiansupplement}', "");
Expect(0, 11519, '\p{Is_Block=georgiansupplement}', "");
Expect(1, 11519, '\p{^Is_Block=georgiansupplement}', "");
Expect(1, 11519, '\P{Is_Block=georgiansupplement}', "");
Expect(0, 11519, '\P{^Is_Block=georgiansupplement}', "");
Expect(1, 11567, '\p{Is_Block=_ Georgian	Supplement}', "");
Expect(0, 11567, '\p{^Is_Block=_ Georgian	Supplement}', "");
Expect(0, 11567, '\P{Is_Block=_ Georgian	Supplement}', "");
Expect(1, 11567, '\P{^Is_Block=_ Georgian	Supplement}', "");
Expect(0, 11519, '\p{Is_Block=_ Georgian	Supplement}', "");
Expect(1, 11519, '\p{^Is_Block=_ Georgian	Supplement}', "");
Expect(1, 11519, '\P{Is_Block=_ Georgian	Supplement}', "");
Expect(0, 11519, '\P{^Is_Block=_ Georgian	Supplement}', "");
Error('\p{Is_Blk=		Georgian_Supplement:=}');
Error('\P{Is_Blk=		Georgian_Supplement:=}');
Expect(1, 11567, '\p{Is_Blk=georgiansupplement}', "");
Expect(0, 11567, '\p{^Is_Blk=georgiansupplement}', "");
Expect(0, 11567, '\P{Is_Blk=georgiansupplement}', "");
Expect(1, 11567, '\P{^Is_Blk=georgiansupplement}', "");
Expect(0, 11519, '\p{Is_Blk=georgiansupplement}', "");
Expect(1, 11519, '\p{^Is_Blk=georgiansupplement}', "");
Expect(1, 11519, '\P{Is_Blk=georgiansupplement}', "");
Expect(0, 11519, '\P{^Is_Blk=georgiansupplement}', "");
Expect(1, 11567, '\p{Is_Blk=GEORGIAN-Supplement}', "");
Expect(0, 11567, '\p{^Is_Blk=GEORGIAN-Supplement}', "");
Expect(0, 11567, '\P{Is_Blk=GEORGIAN-Supplement}', "");
Expect(1, 11567, '\P{^Is_Blk=GEORGIAN-Supplement}', "");
Expect(0, 11519, '\p{Is_Blk=GEORGIAN-Supplement}', "");
Expect(1, 11519, '\p{^Is_Blk=GEORGIAN-Supplement}', "");
Expect(1, 11519, '\P{Is_Blk=GEORGIAN-Supplement}', "");
Expect(0, 11519, '\P{^Is_Blk=GEORGIAN-Supplement}', "");
Error('\p{Block=-/a/myanmar}');
Error('\P{Block=-/a/myanmar}');
Expect(1, 4255, '\p{Block=myanmar}', "");
Expect(0, 4255, '\p{^Block=myanmar}', "");
Expect(0, 4255, '\P{Block=myanmar}', "");
Expect(1, 4255, '\P{^Block=myanmar}', "");
Expect(0, 4095, '\p{Block=myanmar}', "");
Expect(1, 4095, '\p{^Block=myanmar}', "");
Expect(1, 4095, '\P{Block=myanmar}', "");
Expect(0, 4095, '\P{^Block=myanmar}', "");
Expect(1, 4255, '\p{Block:   _Myanmar}', "");
Expect(0, 4255, '\p{^Block:   _Myanmar}', "");
Expect(0, 4255, '\P{Block:   _Myanmar}', "");
Expect(1, 4255, '\P{^Block:   _Myanmar}', "");
Expect(0, 4095, '\p{Block:   _Myanmar}', "");
Expect(1, 4095, '\p{^Block:   _Myanmar}', "");
Expect(1, 4095, '\P{Block:   _Myanmar}', "");
Expect(0, 4095, '\P{^Block:   _Myanmar}', "");
Error('\p{Blk= /a/MYANMAR}');
Error('\P{Blk= /a/MYANMAR}');
Expect(1, 4255, '\p{Blk:myanmar}', "");
Expect(0, 4255, '\p{^Blk:myanmar}', "");
Expect(0, 4255, '\P{Blk:myanmar}', "");
Expect(1, 4255, '\P{^Blk:myanmar}', "");
Expect(0, 4095, '\p{Blk:myanmar}', "");
Expect(1, 4095, '\p{^Blk:myanmar}', "");
Expect(1, 4095, '\P{Blk:myanmar}', "");
Expect(0, 4095, '\P{^Blk:myanmar}', "");
Expect(1, 4255, '\p{Blk=_Myanmar}', "");
Expect(0, 4255, '\p{^Blk=_Myanmar}', "");
Expect(0, 4255, '\P{Blk=_Myanmar}', "");
Expect(1, 4255, '\P{^Blk=_Myanmar}', "");
Expect(0, 4095, '\p{Blk=_Myanmar}', "");
Expect(1, 4095, '\p{^Blk=_Myanmar}', "");
Expect(1, 4095, '\P{Blk=_Myanmar}', "");
Expect(0, 4095, '\P{^Blk=_Myanmar}', "");
Error('\p{Is_Block=_/a/Myanmar}');
Error('\P{Is_Block=_/a/Myanmar}');
Expect(1, 4255, '\p{Is_Block=myanmar}', "");
Expect(0, 4255, '\p{^Is_Block=myanmar}', "");
Expect(0, 4255, '\P{Is_Block=myanmar}', "");
Expect(1, 4255, '\P{^Is_Block=myanmar}', "");
Expect(0, 4095, '\p{Is_Block=myanmar}', "");
Expect(1, 4095, '\p{^Is_Block=myanmar}', "");
Expect(1, 4095, '\P{Is_Block=myanmar}', "");
Expect(0, 4095, '\P{^Is_Block=myanmar}', "");
Expect(1, 4255, '\p{Is_Block= 	MYANMAR}', "");
Expect(0, 4255, '\p{^Is_Block= 	MYANMAR}', "");
Expect(0, 4255, '\P{Is_Block= 	MYANMAR}', "");
Expect(1, 4255, '\P{^Is_Block= 	MYANMAR}', "");
Expect(0, 4095, '\p{Is_Block= 	MYANMAR}', "");
Expect(1, 4095, '\p{^Is_Block= 	MYANMAR}', "");
Expect(1, 4095, '\P{Is_Block= 	MYANMAR}', "");
Expect(0, 4095, '\P{^Is_Block= 	MYANMAR}', "");
Error('\p{Is_Blk=__Myanmar:=}');
Error('\P{Is_Blk=__Myanmar:=}');
Expect(1, 4255, '\p{Is_Blk=myanmar}', "");
Expect(0, 4255, '\p{^Is_Blk=myanmar}', "");
Expect(0, 4255, '\P{Is_Blk=myanmar}', "");
Expect(1, 4255, '\P{^Is_Blk=myanmar}', "");
Expect(0, 4095, '\p{Is_Blk=myanmar}', "");
Expect(1, 4095, '\p{^Is_Blk=myanmar}', "");
Expect(1, 4095, '\P{Is_Blk=myanmar}', "");
Expect(0, 4095, '\P{^Is_Blk=myanmar}', "");
Expect(1, 4255, '\p{Is_Blk=--Myanmar}', "");
Expect(0, 4255, '\p{^Is_Blk=--Myanmar}', "");
Expect(0, 4255, '\P{Is_Blk=--Myanmar}', "");
Expect(1, 4255, '\P{^Is_Blk=--Myanmar}', "");
Expect(0, 4095, '\p{Is_Blk=--Myanmar}', "");
Expect(1, 4095, '\p{^Is_Blk=--Myanmar}', "");
Expect(1, 4095, '\P{Is_Blk=--Myanmar}', "");
Expect(0, 4095, '\P{^Is_Blk=--Myanmar}', "");
Error('\p{Block=_Vertical	Forms:=}');
Error('\P{Block=_Vertical	Forms:=}');
Expect(1, 65055, '\p{Block=verticalforms}', "");
Expect(0, 65055, '\p{^Block=verticalforms}', "");
Expect(0, 65055, '\P{Block=verticalforms}', "");
Expect(1, 65055, '\P{^Block=verticalforms}', "");
Expect(0, 65039, '\p{Block=verticalforms}', "");
Expect(1, 65039, '\p{^Block=verticalforms}', "");
Expect(1, 65039, '\P{Block=verticalforms}', "");
Expect(0, 65039, '\P{^Block=verticalforms}', "");
Expect(1, 65055, '\p{Block:-_Vertical_Forms}', "");
Expect(0, 65055, '\p{^Block:-_Vertical_Forms}', "");
Expect(0, 65055, '\P{Block:-_Vertical_Forms}', "");
Expect(1, 65055, '\P{^Block:-_Vertical_Forms}', "");
Expect(0, 65039, '\p{Block:-_Vertical_Forms}', "");
Expect(1, 65039, '\p{^Block:-_Vertical_Forms}', "");
Expect(1, 65039, '\P{Block:-_Vertical_Forms}', "");
Expect(0, 65039, '\P{^Block:-_Vertical_Forms}', "");
Error('\p{Blk=__Vertical	FORMS:=}');
Error('\P{Blk=__Vertical	FORMS:=}');
Expect(1, 65055, '\p{Blk=verticalforms}', "");
Expect(0, 65055, '\p{^Blk=verticalforms}', "");
Expect(0, 65055, '\P{Blk=verticalforms}', "");
Expect(1, 65055, '\P{^Blk=verticalforms}', "");
Expect(0, 65039, '\p{Blk=verticalforms}', "");
Expect(1, 65039, '\p{^Blk=verticalforms}', "");
Expect(1, 65039, '\P{Blk=verticalforms}', "");
Expect(0, 65039, '\P{^Blk=verticalforms}', "");
Expect(1, 65055, '\p{Blk=-vertical_FORMS}', "");
Expect(0, 65055, '\p{^Blk=-vertical_FORMS}', "");
Expect(0, 65055, '\P{Blk=-vertical_FORMS}', "");
Expect(1, 65055, '\P{^Blk=-vertical_FORMS}', "");
Expect(0, 65039, '\p{Blk=-vertical_FORMS}', "");
Expect(1, 65039, '\p{^Blk=-vertical_FORMS}', "");
Expect(1, 65039, '\P{Blk=-vertical_FORMS}', "");
Expect(0, 65039, '\P{^Blk=-vertical_FORMS}', "");
Error('\p{Is_Block=/a/_Vertical-forms}');
Error('\P{Is_Block=/a/_Vertical-forms}');
Expect(1, 65055, '\p{Is_Block=verticalforms}', "");
Expect(0, 65055, '\p{^Is_Block=verticalforms}', "");
Expect(0, 65055, '\P{Is_Block=verticalforms}', "");
Expect(1, 65055, '\P{^Is_Block=verticalforms}', "");
Expect(0, 65039, '\p{Is_Block=verticalforms}', "");
Expect(1, 65039, '\p{^Is_Block=verticalforms}', "");
Expect(1, 65039, '\P{Is_Block=verticalforms}', "");
Expect(0, 65039, '\P{^Is_Block=verticalforms}', "");
Expect(1, 65055, '\p{Is_Block=  Vertical	FORMS}', "");
Expect(0, 65055, '\p{^Is_Block=  Vertical	FORMS}', "");
Expect(0, 65055, '\P{Is_Block=  Vertical	FORMS}', "");
Expect(1, 65055, '\P{^Is_Block=  Vertical	FORMS}', "");
Expect(0, 65039, '\p{Is_Block=  Vertical	FORMS}', "");
Expect(1, 65039, '\p{^Is_Block=  Vertical	FORMS}', "");
Expect(1, 65039, '\P{Is_Block=  Vertical	FORMS}', "");
Expect(0, 65039, '\P{^Is_Block=  Vertical	FORMS}', "");
Error('\p{Is_Blk:	  VERTICAL/a/forms}');
Error('\P{Is_Blk:	  VERTICAL/a/forms}');
Expect(1, 65055, '\p{Is_Blk=verticalforms}', "");
Expect(0, 65055, '\p{^Is_Blk=verticalforms}', "");
Expect(0, 65055, '\P{Is_Blk=verticalforms}', "");
Expect(1, 65055, '\P{^Is_Blk=verticalforms}', "");
Expect(0, 65039, '\p{Is_Blk=verticalforms}', "");
Expect(1, 65039, '\p{^Is_Blk=verticalforms}', "");
Expect(1, 65039, '\P{Is_Blk=verticalforms}', "");
Expect(0, 65039, '\P{^Is_Blk=verticalforms}', "");
Expect(1, 65055, '\p{Is_Blk:   -_Vertical-Forms}', "");
Expect(0, 65055, '\p{^Is_Blk:   -_Vertical-Forms}', "");
Expect(0, 65055, '\P{Is_Blk:   -_Vertical-Forms}', "");
Expect(1, 65055, '\P{^Is_Blk:   -_Vertical-Forms}', "");
Expect(0, 65039, '\p{Is_Blk:   -_Vertical-Forms}', "");
Expect(1, 65039, '\p{^Is_Blk:   -_Vertical-Forms}', "");
Expect(1, 65039, '\P{Is_Blk:   -_Vertical-Forms}', "");
Expect(0, 65039, '\P{^Is_Blk:   -_Vertical-Forms}', "");
Error('\p{Block=:=-Kaithi}');
Error('\P{Block=:=-Kaithi}');
Expect(1, 69839, '\p{Block=kaithi}', "");
Expect(0, 69839, '\p{^Block=kaithi}', "");
Expect(0, 69839, '\P{Block=kaithi}', "");
Expect(1, 69839, '\P{^Block=kaithi}', "");
Expect(0, 69759, '\p{Block=kaithi}', "");
Expect(1, 69759, '\p{^Block=kaithi}', "");
Expect(1, 69759, '\P{Block=kaithi}', "");
Expect(0, 69759, '\P{^Block=kaithi}', "");
Expect(1, 69839, '\p{Block=_ Kaithi}', "");
Expect(0, 69839, '\p{^Block=_ Kaithi}', "");
Expect(0, 69839, '\P{Block=_ Kaithi}', "");
Expect(1, 69839, '\P{^Block=_ Kaithi}', "");
Expect(0, 69759, '\p{Block=_ Kaithi}', "");
Expect(1, 69759, '\p{^Block=_ Kaithi}', "");
Expect(1, 69759, '\P{Block=_ Kaithi}', "");
Expect(0, 69759, '\P{^Block=_ Kaithi}', "");
Error('\p{Blk=/a/kaithi}');
Error('\P{Blk=/a/kaithi}');
Expect(1, 69839, '\p{Blk=kaithi}', "");
Expect(0, 69839, '\p{^Blk=kaithi}', "");
Expect(0, 69839, '\P{Blk=kaithi}', "");
Expect(1, 69839, '\P{^Blk=kaithi}', "");
Expect(0, 69759, '\p{Blk=kaithi}', "");
Expect(1, 69759, '\p{^Blk=kaithi}', "");
Expect(1, 69759, '\P{Blk=kaithi}', "");
Expect(0, 69759, '\P{^Blk=kaithi}', "");
Expect(1, 69839, '\p{Blk=-	kaithi}', "");
Expect(0, 69839, '\p{^Blk=-	kaithi}', "");
Expect(0, 69839, '\P{Blk=-	kaithi}', "");
Expect(1, 69839, '\P{^Blk=-	kaithi}', "");
Expect(0, 69759, '\p{Blk=-	kaithi}', "");
Expect(1, 69759, '\p{^Blk=-	kaithi}', "");
Expect(1, 69759, '\P{Blk=-	kaithi}', "");
Expect(0, 69759, '\P{^Blk=-	kaithi}', "");
Error('\p{Is_Block= _Kaithi:=}');
Error('\P{Is_Block= _Kaithi:=}');
Expect(1, 69839, '\p{Is_Block=kaithi}', "");
Expect(0, 69839, '\p{^Is_Block=kaithi}', "");
Expect(0, 69839, '\P{Is_Block=kaithi}', "");
Expect(1, 69839, '\P{^Is_Block=kaithi}', "");
Expect(0, 69759, '\p{Is_Block=kaithi}', "");
Expect(1, 69759, '\p{^Is_Block=kaithi}', "");
Expect(1, 69759, '\P{Is_Block=kaithi}', "");
Expect(0, 69759, '\P{^Is_Block=kaithi}', "");
Expect(1, 69839, '\p{Is_Block=-	Kaithi}', "");
Expect(0, 69839, '\p{^Is_Block=-	Kaithi}', "");
Expect(0, 69839, '\P{Is_Block=-	Kaithi}', "");
Expect(1, 69839, '\P{^Is_Block=-	Kaithi}', "");
Expect(0, 69759, '\p{Is_Block=-	Kaithi}', "");
Expect(1, 69759, '\p{^Is_Block=-	Kaithi}', "");
Expect(1, 69759, '\P{Is_Block=-	Kaithi}', "");
Expect(0, 69759, '\P{^Is_Block=-	Kaithi}', "");
Error('\p{Is_Blk:/a/Kaithi}');
Error('\P{Is_Blk:/a/Kaithi}');
Expect(1, 69839, '\p{Is_Blk=kaithi}', "");
Expect(0, 69839, '\p{^Is_Blk=kaithi}', "");
Expect(0, 69839, '\P{Is_Blk=kaithi}', "");
Expect(1, 69839, '\P{^Is_Blk=kaithi}', "");
Expect(0, 69759, '\p{Is_Blk=kaithi}', "");
Expect(1, 69759, '\p{^Is_Blk=kaithi}', "");
Expect(1, 69759, '\P{Is_Blk=kaithi}', "");
Expect(0, 69759, '\P{^Is_Blk=kaithi}', "");
Expect(1, 69839, '\p{Is_Blk=	KAITHI}', "");
Expect(0, 69839, '\p{^Is_Blk=	KAITHI}', "");
Expect(0, 69839, '\P{Is_Blk=	KAITHI}', "");
Expect(1, 69839, '\P{^Is_Blk=	KAITHI}', "");
Expect(0, 69759, '\p{Is_Blk=	KAITHI}', "");
Expect(1, 69759, '\p{^Is_Blk=	KAITHI}', "");
Expect(1, 69759, '\P{Is_Blk=	KAITHI}', "");
Expect(0, 69759, '\P{^Is_Blk=	KAITHI}', "");
Error('\p{Block:/a/-	sinhala}');
Error('\P{Block:/a/-	sinhala}');
Expect(1, 3583, '\p{Block=sinhala}', "");
Expect(0, 3583, '\p{^Block=sinhala}', "");
Expect(0, 3583, '\P{Block=sinhala}', "");
Expect(1, 3583, '\P{^Block=sinhala}', "");
Expect(0, 3455, '\p{Block=sinhala}', "");
Expect(1, 3455, '\p{^Block=sinhala}', "");
Expect(1, 3455, '\P{Block=sinhala}', "");
Expect(0, 3455, '\P{^Block=sinhala}', "");
Expect(1, 3583, '\p{Block=  Sinhala}', "");
Expect(0, 3583, '\p{^Block=  Sinhala}', "");
Expect(0, 3583, '\P{Block=  Sinhala}', "");
Expect(1, 3583, '\P{^Block=  Sinhala}', "");
Expect(0, 3455, '\p{Block=  Sinhala}', "");
Expect(1, 3455, '\p{^Block=  Sinhala}', "");
Expect(1, 3455, '\P{Block=  Sinhala}', "");
Expect(0, 3455, '\P{^Block=  Sinhala}', "");
Error('\p{Blk=:=_ Sinhala}');
Error('\P{Blk=:=_ Sinhala}');
Expect(1, 3583, '\p{Blk=sinhala}', "");
Expect(0, 3583, '\p{^Blk=sinhala}', "");
Expect(0, 3583, '\P{Blk=sinhala}', "");
Expect(1, 3583, '\P{^Blk=sinhala}', "");
Expect(0, 3455, '\p{Blk=sinhala}', "");
Expect(1, 3455, '\p{^Blk=sinhala}', "");
Expect(1, 3455, '\P{Blk=sinhala}', "");
Expect(0, 3455, '\P{^Blk=sinhala}', "");
Expect(1, 3583, '\p{Blk=_sinhala}', "");
Expect(0, 3583, '\p{^Blk=_sinhala}', "");
Expect(0, 3583, '\P{Blk=_sinhala}', "");
Expect(1, 3583, '\P{^Blk=_sinhala}', "");
Expect(0, 3455, '\p{Blk=_sinhala}', "");
Expect(1, 3455, '\p{^Blk=_sinhala}', "");
Expect(1, 3455, '\P{Blk=_sinhala}', "");
Expect(0, 3455, '\P{^Blk=_sinhala}', "");
Error('\p{Is_Block= :=SINHALA}');
Error('\P{Is_Block= :=SINHALA}');
Expect(1, 3583, '\p{Is_Block=sinhala}', "");
Expect(0, 3583, '\p{^Is_Block=sinhala}', "");
Expect(0, 3583, '\P{Is_Block=sinhala}', "");
Expect(1, 3583, '\P{^Is_Block=sinhala}', "");
Expect(0, 3455, '\p{Is_Block=sinhala}', "");
Expect(1, 3455, '\p{^Is_Block=sinhala}', "");
Expect(1, 3455, '\P{Is_Block=sinhala}', "");
Expect(0, 3455, '\P{^Is_Block=sinhala}', "");
Expect(1, 3583, '\p{Is_Block=__SINHALA}', "");
Expect(0, 3583, '\p{^Is_Block=__SINHALA}', "");
Expect(0, 3583, '\P{Is_Block=__SINHALA}', "");
Expect(1, 3583, '\P{^Is_Block=__SINHALA}', "");
Expect(0, 3455, '\p{Is_Block=__SINHALA}', "");
Expect(1, 3455, '\p{^Is_Block=__SINHALA}', "");
Expect(1, 3455, '\P{Is_Block=__SINHALA}', "");
Expect(0, 3455, '\P{^Is_Block=__SINHALA}', "");
Error('\p{Is_Blk=:=Sinhala}');
Error('\P{Is_Blk=:=Sinhala}');
Expect(1, 3583, '\p{Is_Blk:	sinhala}', "");
Expect(0, 3583, '\p{^Is_Blk:	sinhala}', "");
Expect(0, 3583, '\P{Is_Blk:	sinhala}', "");
Expect(1, 3583, '\P{^Is_Blk:	sinhala}', "");
Expect(0, 3455, '\p{Is_Blk:	sinhala}', "");
Expect(1, 3455, '\p{^Is_Blk:	sinhala}', "");
Expect(1, 3455, '\P{Is_Blk:	sinhala}', "");
Expect(0, 3455, '\P{^Is_Blk:	sinhala}', "");
Expect(1, 3583, '\p{Is_Blk=	 Sinhala}', "");
Expect(0, 3583, '\p{^Is_Blk=	 Sinhala}', "");
Expect(0, 3583, '\P{Is_Blk=	 Sinhala}', "");
Expect(1, 3583, '\P{^Is_Blk=	 Sinhala}', "");
Expect(0, 3455, '\p{Is_Blk=	 Sinhala}', "");
Expect(1, 3455, '\p{^Is_Blk=	 Sinhala}', "");
Expect(1, 3455, '\P{Is_Blk=	 Sinhala}', "");
Expect(0, 3455, '\P{^Is_Blk=	 Sinhala}', "");
Error('\p{Block::=glagolitic}');
Error('\P{Block::=glagolitic}');
Expect(1, 11359, '\p{Block=glagolitic}', "");
Expect(0, 11359, '\p{^Block=glagolitic}', "");
Expect(0, 11359, '\P{Block=glagolitic}', "");
Expect(1, 11359, '\P{^Block=glagolitic}', "");
Expect(0, 11263, '\p{Block=glagolitic}', "");
Expect(1, 11263, '\p{^Block=glagolitic}', "");
Expect(1, 11263, '\P{Block=glagolitic}', "");
Expect(0, 11263, '\P{^Block=glagolitic}', "");
Expect(1, 11359, '\p{Block=	glagolitic}', "");
Expect(0, 11359, '\p{^Block=	glagolitic}', "");
Expect(0, 11359, '\P{Block=	glagolitic}', "");
Expect(1, 11359, '\P{^Block=	glagolitic}', "");
Expect(0, 11263, '\p{Block=	glagolitic}', "");
Expect(1, 11263, '\p{^Block=	glagolitic}', "");
Expect(1, 11263, '\P{Block=	glagolitic}', "");
Expect(0, 11263, '\P{^Block=	glagolitic}', "");
Error('\p{Blk=-Glagolitic:=}');
Error('\P{Blk=-Glagolitic:=}');
Expect(1, 11359, '\p{Blk=glagolitic}', "");
Expect(0, 11359, '\p{^Blk=glagolitic}', "");
Expect(0, 11359, '\P{Blk=glagolitic}', "");
Expect(1, 11359, '\P{^Blk=glagolitic}', "");
Expect(0, 11263, '\p{Blk=glagolitic}', "");
Expect(1, 11263, '\p{^Blk=glagolitic}', "");
Expect(1, 11263, '\P{Blk=glagolitic}', "");
Expect(0, 11263, '\P{^Blk=glagolitic}', "");
Expect(1, 11359, '\p{Blk= GLAGOLITIC}', "");
Expect(0, 11359, '\p{^Blk= GLAGOLITIC}', "");
Expect(0, 11359, '\P{Blk= GLAGOLITIC}', "");
Expect(1, 11359, '\P{^Blk= GLAGOLITIC}', "");
Expect(0, 11263, '\p{Blk= GLAGOLITIC}', "");
Expect(1, 11263, '\p{^Blk= GLAGOLITIC}', "");
Expect(1, 11263, '\P{Blk= GLAGOLITIC}', "");
Expect(0, 11263, '\P{^Blk= GLAGOLITIC}', "");
Error('\p{Is_Block=/a/ -GLAGOLITIC}');
Error('\P{Is_Block=/a/ -GLAGOLITIC}');
Expect(1, 11359, '\p{Is_Block=glagolitic}', "");
Expect(0, 11359, '\p{^Is_Block=glagolitic}', "");
Expect(0, 11359, '\P{Is_Block=glagolitic}', "");
Expect(1, 11359, '\P{^Is_Block=glagolitic}', "");
Expect(0, 11263, '\p{Is_Block=glagolitic}', "");
Expect(1, 11263, '\p{^Is_Block=glagolitic}', "");
Expect(1, 11263, '\P{Is_Block=glagolitic}', "");
Expect(0, 11263, '\P{^Is_Block=glagolitic}', "");
Expect(1, 11359, '\p{Is_Block=_Glagolitic}', "");
Expect(0, 11359, '\p{^Is_Block=_Glagolitic}', "");
Expect(0, 11359, '\P{Is_Block=_Glagolitic}', "");
Expect(1, 11359, '\P{^Is_Block=_Glagolitic}', "");
Expect(0, 11263, '\p{Is_Block=_Glagolitic}', "");
Expect(1, 11263, '\p{^Is_Block=_Glagolitic}', "");
Expect(1, 11263, '\P{Is_Block=_Glagolitic}', "");
Expect(0, 11263, '\P{^Is_Block=_Glagolitic}', "");
Error('\p{Is_Blk=:=Glagolitic}');
Error('\P{Is_Blk=:=Glagolitic}');
Expect(1, 11359, '\p{Is_Blk=glagolitic}', "");
Expect(0, 11359, '\p{^Is_Blk=glagolitic}', "");
Expect(0, 11359, '\P{Is_Blk=glagolitic}', "");
Expect(1, 11359, '\P{^Is_Blk=glagolitic}', "");
Expect(0, 11263, '\p{Is_Blk=glagolitic}', "");
Expect(1, 11263, '\p{^Is_Blk=glagolitic}', "");
Expect(1, 11263, '\P{Is_Blk=glagolitic}', "");
Expect(0, 11263, '\P{^Is_Blk=glagolitic}', "");
Expect(1, 11359, '\p{Is_Blk=_GLAGOLITIC}', "");
Expect(0, 11359, '\p{^Is_Blk=_GLAGOLITIC}', "");
Expect(0, 11359, '\P{Is_Blk=_GLAGOLITIC}', "");
Expect(1, 11359, '\P{^Is_Blk=_GLAGOLITIC}', "");
Expect(0, 11263, '\p{Is_Blk=_GLAGOLITIC}', "");
Expect(1, 11263, '\p{^Is_Blk=_GLAGOLITIC}', "");
Expect(1, 11263, '\P{Is_Blk=_GLAGOLITIC}', "");
Expect(0, 11263, '\P{^Is_Blk=_GLAGOLITIC}', "");
Error('\p{Block=	tagalog/a/}');
Error('\P{Block=	tagalog/a/}');
Expect(1, 5919, '\p{Block=tagalog}', "");
Expect(0, 5919, '\p{^Block=tagalog}', "");
Expect(0, 5919, '\P{Block=tagalog}', "");
Expect(1, 5919, '\P{^Block=tagalog}', "");
Expect(0, 5887, '\p{Block=tagalog}', "");
Expect(1, 5887, '\p{^Block=tagalog}', "");
Expect(1, 5887, '\P{Block=tagalog}', "");
Expect(0, 5887, '\P{^Block=tagalog}', "");
Expect(1, 5919, '\p{Block:	_tagalog}', "");
Expect(0, 5919, '\p{^Block:	_tagalog}', "");
Expect(0, 5919, '\P{Block:	_tagalog}', "");
Expect(1, 5919, '\P{^Block:	_tagalog}', "");
Expect(0, 5887, '\p{Block:	_tagalog}', "");
Expect(1, 5887, '\p{^Block:	_tagalog}', "");
Expect(1, 5887, '\P{Block:	_tagalog}', "");
Expect(0, 5887, '\P{^Block:	_tagalog}', "");
Error('\p{Blk=/a/TAGALOG}');
Error('\P{Blk=/a/TAGALOG}');
Expect(1, 5919, '\p{Blk=tagalog}', "");
Expect(0, 5919, '\p{^Blk=tagalog}', "");
Expect(0, 5919, '\P{Blk=tagalog}', "");
Expect(1, 5919, '\P{^Blk=tagalog}', "");
Expect(0, 5887, '\p{Blk=tagalog}', "");
Expect(1, 5887, '\p{^Blk=tagalog}', "");
Expect(1, 5887, '\P{Blk=tagalog}', "");
Expect(0, 5887, '\P{^Blk=tagalog}', "");
Expect(1, 5919, '\p{Blk= 	TAGALOG}', "");
Expect(0, 5919, '\p{^Blk= 	TAGALOG}', "");
Expect(0, 5919, '\P{Blk= 	TAGALOG}', "");
Expect(1, 5919, '\P{^Blk= 	TAGALOG}', "");
Expect(0, 5887, '\p{Blk= 	TAGALOG}', "");
Expect(1, 5887, '\p{^Blk= 	TAGALOG}', "");
Expect(1, 5887, '\P{Blk= 	TAGALOG}', "");
Expect(0, 5887, '\P{^Blk= 	TAGALOG}', "");
Error('\p{Is_Block=_	Tagalog:=}');
Error('\P{Is_Block=_	Tagalog:=}');
Expect(1, 5919, '\p{Is_Block=tagalog}', "");
Expect(0, 5919, '\p{^Is_Block=tagalog}', "");
Expect(0, 5919, '\P{Is_Block=tagalog}', "");
Expect(1, 5919, '\P{^Is_Block=tagalog}', "");
Expect(0, 5887, '\p{Is_Block=tagalog}', "");
Expect(1, 5887, '\p{^Is_Block=tagalog}', "");
Expect(1, 5887, '\P{Is_Block=tagalog}', "");
Expect(0, 5887, '\P{^Is_Block=tagalog}', "");
Expect(1, 5919, '\p{Is_Block= 	Tagalog}', "");
Expect(0, 5919, '\p{^Is_Block= 	Tagalog}', "");
Expect(0, 5919, '\P{Is_Block= 	Tagalog}', "");
Expect(1, 5919, '\P{^Is_Block= 	Tagalog}', "");
Expect(0, 5887, '\p{Is_Block= 	Tagalog}', "");
Expect(1, 5887, '\p{^Is_Block= 	Tagalog}', "");
Expect(1, 5887, '\P{Is_Block= 	Tagalog}', "");
Expect(0, 5887, '\P{^Is_Block= 	Tagalog}', "");
Error('\p{Is_Blk=_:=TAGALOG}');
Error('\P{Is_Blk=_:=TAGALOG}');
Expect(1, 5919, '\p{Is_Blk: tagalog}', "");
Expect(0, 5919, '\p{^Is_Blk: tagalog}', "");
Expect(0, 5919, '\P{Is_Blk: tagalog}', "");
Expect(1, 5919, '\P{^Is_Blk: tagalog}', "");
Expect(0, 5887, '\p{Is_Blk: tagalog}', "");
Expect(1, 5887, '\p{^Is_Blk: tagalog}', "");
Expect(1, 5887, '\P{Is_Blk: tagalog}', "");
Expect(0, 5887, '\P{^Is_Blk: tagalog}', "");
Expect(1, 5919, '\p{Is_Blk= TAGALOG}', "");
Expect(0, 5919, '\p{^Is_Blk= TAGALOG}', "");
Expect(0, 5919, '\P{Is_Blk= TAGALOG}', "");
Expect(1, 5919, '\P{^Is_Blk= TAGALOG}', "");
Expect(0, 5887, '\p{Is_Blk= TAGALOG}', "");
Expect(1, 5887, '\p{^Is_Blk= TAGALOG}', "");
Expect(1, 5887, '\P{Is_Blk= TAGALOG}', "");
Expect(0, 5887, '\P{^Is_Blk= TAGALOG}', "");
Error('\p{Block=	 kharoshthi/a/}');
Error('\P{Block=	 kharoshthi/a/}');
Expect(1, 68191, '\p{Block: kharoshthi}', "");
Expect(0, 68191, '\p{^Block: kharoshthi}', "");
Expect(0, 68191, '\P{Block: kharoshthi}', "");
Expect(1, 68191, '\P{^Block: kharoshthi}', "");
Expect(0, 68095, '\p{Block: kharoshthi}', "");
Expect(1, 68095, '\p{^Block: kharoshthi}', "");
Expect(1, 68095, '\P{Block: kharoshthi}', "");
Expect(0, 68095, '\P{^Block: kharoshthi}', "");
Expect(1, 68191, '\p{Block=-KHAROSHTHI}', "");
Expect(0, 68191, '\p{^Block=-KHAROSHTHI}', "");
Expect(0, 68191, '\P{Block=-KHAROSHTHI}', "");
Expect(1, 68191, '\P{^Block=-KHAROSHTHI}', "");
Expect(0, 68095, '\p{Block=-KHAROSHTHI}', "");
Expect(1, 68095, '\p{^Block=-KHAROSHTHI}', "");
Expect(1, 68095, '\P{Block=-KHAROSHTHI}', "");
Expect(0, 68095, '\P{^Block=-KHAROSHTHI}', "");
Error('\p{Blk=		KHAROSHTHI:=}');
Error('\P{Blk=		KHAROSHTHI:=}');
Expect(1, 68191, '\p{Blk=kharoshthi}', "");
Expect(0, 68191, '\p{^Blk=kharoshthi}', "");
Expect(0, 68191, '\P{Blk=kharoshthi}', "");
Expect(1, 68191, '\P{^Blk=kharoshthi}', "");
Expect(0, 68095, '\p{Blk=kharoshthi}', "");
Expect(1, 68095, '\p{^Blk=kharoshthi}', "");
Expect(1, 68095, '\P{Blk=kharoshthi}', "");
Expect(0, 68095, '\P{^Blk=kharoshthi}', "");
Expect(1, 68191, '\p{Blk=_Kharoshthi}', "");
Expect(0, 68191, '\p{^Blk=_Kharoshthi}', "");
Expect(0, 68191, '\P{Blk=_Kharoshthi}', "");
Expect(1, 68191, '\P{^Blk=_Kharoshthi}', "");
Expect(0, 68095, '\p{Blk=_Kharoshthi}', "");
Expect(1, 68095, '\p{^Blk=_Kharoshthi}', "");
Expect(1, 68095, '\P{Blk=_Kharoshthi}', "");
Expect(0, 68095, '\P{^Blk=_Kharoshthi}', "");
Error('\p{Is_Block=  Kharoshthi/a/}');
Error('\P{Is_Block=  Kharoshthi/a/}');
Expect(1, 68191, '\p{Is_Block=kharoshthi}', "");
Expect(0, 68191, '\p{^Is_Block=kharoshthi}', "");
Expect(0, 68191, '\P{Is_Block=kharoshthi}', "");
Expect(1, 68191, '\P{^Is_Block=kharoshthi}', "");
Expect(0, 68095, '\p{Is_Block=kharoshthi}', "");
Expect(1, 68095, '\p{^Is_Block=kharoshthi}', "");
Expect(1, 68095, '\P{Is_Block=kharoshthi}', "");
Expect(0, 68095, '\P{^Is_Block=kharoshthi}', "");
Expect(1, 68191, '\p{Is_Block=	kharoshthi}', "");
Expect(0, 68191, '\p{^Is_Block=	kharoshthi}', "");
Expect(0, 68191, '\P{Is_Block=	kharoshthi}', "");
Expect(1, 68191, '\P{^Is_Block=	kharoshthi}', "");
Expect(0, 68095, '\p{Is_Block=	kharoshthi}', "");
Expect(1, 68095, '\p{^Is_Block=	kharoshthi}', "");
Expect(1, 68095, '\P{Is_Block=	kharoshthi}', "");
Expect(0, 68095, '\P{^Is_Block=	kharoshthi}', "");
Error('\p{Is_Blk=/a/-	KHAROSHTHI}');
Error('\P{Is_Blk=/a/-	KHAROSHTHI}');
Expect(1, 68191, '\p{Is_Blk=kharoshthi}', "");
Expect(0, 68191, '\p{^Is_Blk=kharoshthi}', "");
Expect(0, 68191, '\P{Is_Blk=kharoshthi}', "");
Expect(1, 68191, '\P{^Is_Blk=kharoshthi}', "");
Expect(0, 68095, '\p{Is_Blk=kharoshthi}', "");
Expect(1, 68095, '\p{^Is_Blk=kharoshthi}', "");
Expect(1, 68095, '\P{Is_Blk=kharoshthi}', "");
Expect(0, 68095, '\P{^Is_Blk=kharoshthi}', "");
Expect(1, 68191, '\p{Is_Blk= 	KHAROSHTHI}', "");
Expect(0, 68191, '\p{^Is_Blk= 	KHAROSHTHI}', "");
Expect(0, 68191, '\P{Is_Blk= 	KHAROSHTHI}', "");
Expect(1, 68191, '\P{^Is_Blk= 	KHAROSHTHI}', "");
Expect(0, 68095, '\p{Is_Blk= 	KHAROSHTHI}', "");
Expect(1, 68095, '\p{^Is_Blk= 	KHAROSHTHI}', "");
Expect(1, 68095, '\P{Is_Blk= 	KHAROSHTHI}', "");
Expect(0, 68095, '\P{^Is_Blk= 	KHAROSHTHI}', "");
Error('\p{Block=_ arabic-Supplement/a/}');
Error('\P{Block=_ arabic-Supplement/a/}');
Expect(1, 1919, '\p{Block=arabicsupplement}', "");
Expect(0, 1919, '\p{^Block=arabicsupplement}', "");
Expect(0, 1919, '\P{Block=arabicsupplement}', "");
Expect(1, 1919, '\P{^Block=arabicsupplement}', "");
Expect(0, 1871, '\p{Block=arabicsupplement}', "");
Expect(1, 1871, '\p{^Block=arabicsupplement}', "");
Expect(1, 1871, '\P{Block=arabicsupplement}', "");
Expect(0, 1871, '\P{^Block=arabicsupplement}', "");
Expect(1, 1919, '\p{Block=		arabic-Supplement}', "");
Expect(0, 1919, '\p{^Block=		arabic-Supplement}', "");
Expect(0, 1919, '\P{Block=		arabic-Supplement}', "");
Expect(1, 1919, '\P{^Block=		arabic-Supplement}', "");
Expect(0, 1871, '\p{Block=		arabic-Supplement}', "");
Expect(1, 1871, '\p{^Block=		arabic-Supplement}', "");
Expect(1, 1871, '\P{Block=		arabic-Supplement}', "");
Expect(0, 1871, '\P{^Block=		arabic-Supplement}', "");
Error('\p{Blk=-_ArabicSupplement:=}');
Error('\P{Blk=-_ArabicSupplement:=}');
Expect(1, 1919, '\p{Blk=arabicsupplement}', "");
Expect(0, 1919, '\p{^Blk=arabicsupplement}', "");
Expect(0, 1919, '\P{Blk=arabicsupplement}', "");
Expect(1, 1919, '\P{^Blk=arabicsupplement}', "");
Expect(0, 1871, '\p{Blk=arabicsupplement}', "");
Expect(1, 1871, '\p{^Blk=arabicsupplement}', "");
Expect(1, 1871, '\P{Blk=arabicsupplement}', "");
Expect(0, 1871, '\P{^Blk=arabicsupplement}', "");
Expect(1, 1919, '\p{Blk=- Arabic SUPPLEMENT}', "");
Expect(0, 1919, '\p{^Blk=- Arabic SUPPLEMENT}', "");
Expect(0, 1919, '\P{Blk=- Arabic SUPPLEMENT}', "");
Expect(1, 1919, '\P{^Blk=- Arabic SUPPLEMENT}', "");
Expect(0, 1871, '\p{Blk=- Arabic SUPPLEMENT}', "");
Expect(1, 1871, '\p{^Blk=- Arabic SUPPLEMENT}', "");
Expect(1, 1871, '\P{Blk=- Arabic SUPPLEMENT}', "");
Expect(0, 1871, '\P{^Blk=- Arabic SUPPLEMENT}', "");
Error('\p{Is_Block=:=ARABIC-Supplement}');
Error('\P{Is_Block=:=ARABIC-Supplement}');
Expect(1, 1919, '\p{Is_Block=arabicsupplement}', "");
Expect(0, 1919, '\p{^Is_Block=arabicsupplement}', "");
Expect(0, 1919, '\P{Is_Block=arabicsupplement}', "");
Expect(1, 1919, '\P{^Is_Block=arabicsupplement}', "");
Expect(0, 1871, '\p{Is_Block=arabicsupplement}', "");
Expect(1, 1871, '\p{^Is_Block=arabicsupplement}', "");
Expect(1, 1871, '\P{Is_Block=arabicsupplement}', "");
Expect(0, 1871, '\P{^Is_Block=arabicsupplement}', "");
Expect(1, 1919, '\p{Is_Block= Arabic-supplement}', "");
Expect(0, 1919, '\p{^Is_Block= Arabic-supplement}', "");
Expect(0, 1919, '\P{Is_Block= Arabic-supplement}', "");
Expect(1, 1919, '\P{^Is_Block= Arabic-supplement}', "");
Expect(0, 1871, '\p{Is_Block= Arabic-supplement}', "");
Expect(1, 1871, '\p{^Is_Block= Arabic-supplement}', "");
Expect(1, 1871, '\P{Is_Block= Arabic-supplement}', "");
Expect(0, 1871, '\P{^Is_Block= Arabic-supplement}', "");
Error('\p{Is_Blk=/a/Arabic-Supplement}');
Error('\P{Is_Blk=/a/Arabic-Supplement}');
Expect(1, 1919, '\p{Is_Blk=arabicsupplement}', "");
Expect(0, 1919, '\p{^Is_Blk=arabicsupplement}', "");
Expect(0, 1919, '\P{Is_Blk=arabicsupplement}', "");
Expect(1, 1919, '\P{^Is_Blk=arabicsupplement}', "");
Expect(0, 1871, '\p{Is_Blk=arabicsupplement}', "");
Expect(1, 1871, '\p{^Is_Blk=arabicsupplement}', "");
Expect(1, 1871, '\P{Is_Blk=arabicsupplement}', "");
Expect(0, 1871, '\P{^Is_Blk=arabicsupplement}', "");
Expect(1, 1919, '\p{Is_Blk=_Arabic	SUPPLEMENT}', "");
Expect(0, 1919, '\p{^Is_Blk=_Arabic	SUPPLEMENT}', "");
Expect(0, 1919, '\P{Is_Blk=_Arabic	SUPPLEMENT}', "");
Expect(1, 1919, '\P{^Is_Blk=_Arabic	SUPPLEMENT}', "");
Expect(0, 1871, '\p{Is_Blk=_Arabic	SUPPLEMENT}', "");
Expect(1, 1871, '\p{^Is_Blk=_Arabic	SUPPLEMENT}', "");
Expect(1, 1871, '\P{Is_Blk=_Arabic	SUPPLEMENT}', "");
Expect(0, 1871, '\P{^Is_Blk=_Arabic	SUPPLEMENT}', "");
Error('\p{Block=	:=cuneiform	numbersAnd_punctuation}');
Error('\P{Block=	:=cuneiform	numbersAnd_punctuation}');
Expect(1, 74879, '\p{Block=cuneiformnumbersandpunctuation}', "");
Expect(0, 74879, '\p{^Block=cuneiformnumbersandpunctuation}', "");
Expect(0, 74879, '\P{Block=cuneiformnumbersandpunctuation}', "");
Expect(1, 74879, '\P{^Block=cuneiformnumbersandpunctuation}', "");
Expect(0, 74751, '\p{Block=cuneiformnumbersandpunctuation}', "");
Expect(1, 74751, '\p{^Block=cuneiformnumbersandpunctuation}', "");
Expect(1, 74751, '\P{Block=cuneiformnumbersandpunctuation}', "");
Expect(0, 74751, '\P{^Block=cuneiformnumbersandpunctuation}', "");
Expect(1, 74879, '\p{Block=-Cuneiform	NUMBERS_And Punctuation}', "");
Expect(0, 74879, '\p{^Block=-Cuneiform	NUMBERS_And Punctuation}', "");
Expect(0, 74879, '\P{Block=-Cuneiform	NUMBERS_And Punctuation}', "");
Expect(1, 74879, '\P{^Block=-Cuneiform	NUMBERS_And Punctuation}', "");
Expect(0, 74751, '\p{Block=-Cuneiform	NUMBERS_And Punctuation}', "");
Expect(1, 74751, '\p{^Block=-Cuneiform	NUMBERS_And Punctuation}', "");
Expect(1, 74751, '\P{Block=-Cuneiform	NUMBERS_And Punctuation}', "");
Expect(0, 74751, '\P{^Block=-Cuneiform	NUMBERS_And Punctuation}', "");
Error('\p{Blk=-/a/CUNEIFORM NUMBERS-And_Punctuation}');
Error('\P{Blk=-/a/CUNEIFORM NUMBERS-And_Punctuation}');
Expect(1, 74879, '\p{Blk=cuneiformnumbersandpunctuation}', "");
Expect(0, 74879, '\p{^Blk=cuneiformnumbersandpunctuation}', "");
Expect(0, 74879, '\P{Blk=cuneiformnumbersandpunctuation}', "");
Expect(1, 74879, '\P{^Blk=cuneiformnumbersandpunctuation}', "");
Expect(0, 74751, '\p{Blk=cuneiformnumbersandpunctuation}', "");
Expect(1, 74751, '\p{^Blk=cuneiformnumbersandpunctuation}', "");
Expect(1, 74751, '\P{Blk=cuneiformnumbersandpunctuation}', "");
Expect(0, 74751, '\P{^Blk=cuneiformnumbersandpunctuation}', "");
Expect(1, 74879, '\p{Blk=	-Cuneiform-numbers_and Punctuation}', "");
Expect(0, 74879, '\p{^Blk=	-Cuneiform-numbers_and Punctuation}', "");
Expect(0, 74879, '\P{Blk=	-Cuneiform-numbers_and Punctuation}', "");
Expect(1, 74879, '\P{^Blk=	-Cuneiform-numbers_and Punctuation}', "");
Expect(0, 74751, '\p{Blk=	-Cuneiform-numbers_and Punctuation}', "");
Expect(1, 74751, '\p{^Blk=	-Cuneiform-numbers_and Punctuation}', "");
Expect(1, 74751, '\P{Blk=	-Cuneiform-numbers_and Punctuation}', "");
Expect(0, 74751, '\P{^Blk=	-Cuneiform-numbers_and Punctuation}', "");
Error('\p{Is_Block=:=- Cuneiform NUMBERS_AND-PUNCTUATION}');
Error('\P{Is_Block=:=- Cuneiform NUMBERS_AND-PUNCTUATION}');
Expect(1, 74879, '\p{Is_Block=cuneiformnumbersandpunctuation}', "");
Expect(0, 74879, '\p{^Is_Block=cuneiformnumbersandpunctuation}', "");
Expect(0, 74879, '\P{Is_Block=cuneiformnumbersandpunctuation}', "");
Expect(1, 74879, '\P{^Is_Block=cuneiformnumbersandpunctuation}', "");
Expect(0, 74751, '\p{Is_Block=cuneiformnumbersandpunctuation}', "");
Expect(1, 74751, '\p{^Is_Block=cuneiformnumbersandpunctuation}', "");
Expect(1, 74751, '\P{Is_Block=cuneiformnumbersandpunctuation}', "");
Expect(0, 74751, '\P{^Is_Block=cuneiformnumbersandpunctuation}', "");
Expect(1, 74879, '\p{Is_Block=	-CUNEIFORM-Numbers_and Punctuation}', "");
Expect(0, 74879, '\p{^Is_Block=	-CUNEIFORM-Numbers_and Punctuation}', "");
Expect(0, 74879, '\P{Is_Block=	-CUNEIFORM-Numbers_and Punctuation}', "");
Expect(1, 74879, '\P{^Is_Block=	-CUNEIFORM-Numbers_and Punctuation}', "");
Expect(0, 74751, '\p{Is_Block=	-CUNEIFORM-Numbers_and Punctuation}', "");
Expect(1, 74751, '\p{^Is_Block=	-CUNEIFORM-Numbers_and Punctuation}', "");
Expect(1, 74751, '\P{Is_Block=	-CUNEIFORM-Numbers_and Punctuation}', "");
Expect(0, 74751, '\P{^Is_Block=	-CUNEIFORM-Numbers_and Punctuation}', "");
Error('\p{Is_Blk=-cuneiformnumbers and Punctuation:=}');
Error('\P{Is_Blk=-cuneiformnumbers and Punctuation:=}');
Expect(1, 74879, '\p{Is_Blk=cuneiformnumbersandpunctuation}', "");
Expect(0, 74879, '\p{^Is_Blk=cuneiformnumbersandpunctuation}', "");
Expect(0, 74879, '\P{Is_Blk=cuneiformnumbersandpunctuation}', "");
Expect(1, 74879, '\P{^Is_Blk=cuneiformnumbersandpunctuation}', "");
Expect(0, 74751, '\p{Is_Blk=cuneiformnumbersandpunctuation}', "");
Expect(1, 74751, '\p{^Is_Blk=cuneiformnumbersandpunctuation}', "");
Expect(1, 74751, '\P{Is_Blk=cuneiformnumbersandpunctuation}', "");
Expect(0, 74751, '\P{^Is_Blk=cuneiformnumbersandpunctuation}', "");
Expect(1, 74879, '\p{Is_Blk=--Cuneiform-Numbers	And	Punctuation}', "");
Expect(0, 74879, '\p{^Is_Blk=--Cuneiform-Numbers	And	Punctuation}', "");
Expect(0, 74879, '\P{Is_Blk=--Cuneiform-Numbers	And	Punctuation}', "");
Expect(1, 74879, '\P{^Is_Blk=--Cuneiform-Numbers	And	Punctuation}', "");
Expect(0, 74751, '\p{Is_Blk=--Cuneiform-Numbers	And	Punctuation}', "");
Expect(1, 74751, '\p{^Is_Blk=--Cuneiform-Numbers	And	Punctuation}', "");
Expect(1, 74751, '\P{Is_Blk=--Cuneiform-Numbers	And	Punctuation}', "");
Expect(0, 74751, '\P{^Is_Blk=--Cuneiform-Numbers	And	Punctuation}', "");
Error('\p{Block=_devanagari:=extended}');
Error('\P{Block=_devanagari:=extended}');
Expect(1, 43263, '\p{Block=devanagariextended}', "");
Expect(0, 43263, '\p{^Block=devanagariextended}', "");
Expect(0, 43263, '\P{Block=devanagariextended}', "");
Expect(1, 43263, '\P{^Block=devanagariextended}', "");
Expect(0, 43231, '\p{Block=devanagariextended}', "");
Expect(1, 43231, '\p{^Block=devanagariextended}', "");
Expect(1, 43231, '\P{Block=devanagariextended}', "");
Expect(0, 43231, '\P{^Block=devanagariextended}', "");
Expect(1, 43263, '\p{Block=-	Devanagari-EXTENDED}', "");
Expect(0, 43263, '\p{^Block=-	Devanagari-EXTENDED}', "");
Expect(0, 43263, '\P{Block=-	Devanagari-EXTENDED}', "");
Expect(1, 43263, '\P{^Block=-	Devanagari-EXTENDED}', "");
Expect(0, 43231, '\p{Block=-	Devanagari-EXTENDED}', "");
Expect(1, 43231, '\p{^Block=-	Devanagari-EXTENDED}', "");
Expect(1, 43231, '\P{Block=-	Devanagari-EXTENDED}', "");
Expect(0, 43231, '\P{^Block=-	Devanagari-EXTENDED}', "");
Error('\p{Blk=	Devanagari_Extended:=}');
Error('\P{Blk=	Devanagari_Extended:=}');
Expect(1, 43263, '\p{Blk=devanagariextended}', "");
Expect(0, 43263, '\p{^Blk=devanagariextended}', "");
Expect(0, 43263, '\P{Blk=devanagariextended}', "");
Expect(1, 43263, '\P{^Blk=devanagariextended}', "");
Expect(0, 43231, '\p{Blk=devanagariextended}', "");
Expect(1, 43231, '\p{^Blk=devanagariextended}', "");
Expect(1, 43231, '\P{Blk=devanagariextended}', "");
Expect(0, 43231, '\P{^Blk=devanagariextended}', "");
Expect(1, 43263, '\p{Blk=_Devanagari EXTENDED}', "");
Expect(0, 43263, '\p{^Blk=_Devanagari EXTENDED}', "");
Expect(0, 43263, '\P{Blk=_Devanagari EXTENDED}', "");
Expect(1, 43263, '\P{^Blk=_Devanagari EXTENDED}', "");
Expect(0, 43231, '\p{Blk=_Devanagari EXTENDED}', "");
Expect(1, 43231, '\p{^Blk=_Devanagari EXTENDED}', "");
Expect(1, 43231, '\P{Blk=_Devanagari EXTENDED}', "");
Expect(0, 43231, '\P{^Blk=_Devanagari EXTENDED}', "");
Error('\p{Is_Block= -devanagari	extended:=}');
Error('\P{Is_Block= -devanagari	extended:=}');
Expect(1, 43263, '\p{Is_Block=devanagariextended}', "");
Expect(0, 43263, '\p{^Is_Block=devanagariextended}', "");
Expect(0, 43263, '\P{Is_Block=devanagariextended}', "");
Expect(1, 43263, '\P{^Is_Block=devanagariextended}', "");
Expect(0, 43231, '\p{Is_Block=devanagariextended}', "");
Expect(1, 43231, '\p{^Is_Block=devanagariextended}', "");
Expect(1, 43231, '\P{Is_Block=devanagariextended}', "");
Expect(0, 43231, '\P{^Is_Block=devanagariextended}', "");
Expect(1, 43263, '\p{Is_Block=	DevanagariExtended}', "");
Expect(0, 43263, '\p{^Is_Block=	DevanagariExtended}', "");
Expect(0, 43263, '\P{Is_Block=	DevanagariExtended}', "");
Expect(1, 43263, '\P{^Is_Block=	DevanagariExtended}', "");
Expect(0, 43231, '\p{Is_Block=	DevanagariExtended}', "");
Expect(1, 43231, '\p{^Is_Block=	DevanagariExtended}', "");
Expect(1, 43231, '\P{Is_Block=	DevanagariExtended}', "");
Expect(0, 43231, '\P{^Is_Block=	DevanagariExtended}', "");
Error('\p{Is_Blk:    DEVANAGARI/a/EXTENDED}');
Error('\P{Is_Blk:    DEVANAGARI/a/EXTENDED}');
Expect(1, 43263, '\p{Is_Blk=devanagariextended}', "");
Expect(0, 43263, '\p{^Is_Blk=devanagariextended}', "");
Expect(0, 43263, '\P{Is_Blk=devanagariextended}', "");
Expect(1, 43263, '\P{^Is_Blk=devanagariextended}', "");
Expect(0, 43231, '\p{Is_Blk=devanagariextended}', "");
Expect(1, 43231, '\p{^Is_Blk=devanagariextended}', "");
Expect(1, 43231, '\P{Is_Blk=devanagariextended}', "");
Expect(0, 43231, '\P{^Is_Blk=devanagariextended}', "");
Expect(1, 43263, '\p{Is_Blk:	 _DEVANAGARI-Extended}', "");
Expect(0, 43263, '\p{^Is_Blk:	 _DEVANAGARI-Extended}', "");
Expect(0, 43263, '\P{Is_Blk:	 _DEVANAGARI-Extended}', "");
Expect(1, 43263, '\P{^Is_Blk:	 _DEVANAGARI-Extended}', "");
Expect(0, 43231, '\p{Is_Blk:	 _DEVANAGARI-Extended}', "");
Expect(1, 43231, '\p{^Is_Blk:	 _DEVANAGARI-Extended}', "");
Expect(1, 43231, '\P{Is_Blk:	 _DEVANAGARI-Extended}', "");
Expect(0, 43231, '\P{^Is_Blk:	 _DEVANAGARI-Extended}', "");
Error('\p{Block: /a/--yi_syllables}');
Error('\P{Block: /a/--yi_syllables}');
Expect(1, 42127, '\p{Block=yisyllables}', "");
Expect(0, 42127, '\p{^Block=yisyllables}', "");
Expect(0, 42127, '\P{Block=yisyllables}', "");
Expect(1, 42127, '\P{^Block=yisyllables}', "");
Expect(0, 40959, '\p{Block=yisyllables}', "");
Expect(1, 40959, '\p{^Block=yisyllables}', "");
Expect(1, 40959, '\P{Block=yisyllables}', "");
Expect(0, 40959, '\P{^Block=yisyllables}', "");
Expect(1, 42127, '\p{Block:   _Yisyllables}', "");
Expect(0, 42127, '\p{^Block:   _Yisyllables}', "");
Expect(0, 42127, '\P{Block:   _Yisyllables}', "");
Expect(1, 42127, '\P{^Block:   _Yisyllables}', "");
Expect(0, 40959, '\p{Block:   _Yisyllables}', "");
Expect(1, 40959, '\p{^Block:   _Yisyllables}', "");
Expect(1, 40959, '\P{Block:   _Yisyllables}', "");
Expect(0, 40959, '\P{^Block:   _Yisyllables}', "");
Error('\p{Blk=_Yi/a/SYLLABLES}');
Error('\P{Blk=_Yi/a/SYLLABLES}');
Expect(1, 42127, '\p{Blk=yisyllables}', "");
Expect(0, 42127, '\p{^Blk=yisyllables}', "");
Expect(0, 42127, '\P{Blk=yisyllables}', "");
Expect(1, 42127, '\P{^Blk=yisyllables}', "");
Expect(0, 40959, '\p{Blk=yisyllables}', "");
Expect(1, 40959, '\p{^Blk=yisyllables}', "");
Expect(1, 40959, '\P{Blk=yisyllables}', "");
Expect(0, 40959, '\P{^Blk=yisyllables}', "");
Expect(1, 42127, '\p{Blk=		Yi Syllables}', "");
Expect(0, 42127, '\p{^Blk=		Yi Syllables}', "");
Expect(0, 42127, '\P{Blk=		Yi Syllables}', "");
Expect(1, 42127, '\P{^Blk=		Yi Syllables}', "");
Expect(0, 40959, '\p{Blk=		Yi Syllables}', "");
Expect(1, 40959, '\p{^Blk=		Yi Syllables}', "");
Expect(1, 40959, '\P{Blk=		Yi Syllables}', "");
Expect(0, 40959, '\P{^Blk=		Yi Syllables}', "");
Error('\p{Is_Block:  	Yi Syllables/a/}');
Error('\P{Is_Block:  	Yi Syllables/a/}');
Expect(1, 42127, '\p{Is_Block=yisyllables}', "");
Expect(0, 42127, '\p{^Is_Block=yisyllables}', "");
Expect(0, 42127, '\P{Is_Block=yisyllables}', "");
Expect(1, 42127, '\P{^Is_Block=yisyllables}', "");
Expect(0, 40959, '\p{Is_Block=yisyllables}', "");
Expect(1, 40959, '\p{^Is_Block=yisyllables}', "");
Expect(1, 40959, '\P{Is_Block=yisyllables}', "");
Expect(0, 40959, '\P{^Is_Block=yisyllables}', "");
Expect(1, 42127, '\p{Is_Block=_Yi_Syllables}', "");
Expect(0, 42127, '\p{^Is_Block=_Yi_Syllables}', "");
Expect(0, 42127, '\P{Is_Block=_Yi_Syllables}', "");
Expect(1, 42127, '\P{^Is_Block=_Yi_Syllables}', "");
Expect(0, 40959, '\p{Is_Block=_Yi_Syllables}', "");
Expect(1, 40959, '\p{^Is_Block=_Yi_Syllables}', "");
Expect(1, 40959, '\P{Is_Block=_Yi_Syllables}', "");
Expect(0, 40959, '\P{^Is_Block=_Yi_Syllables}', "");
Error('\p{Is_Blk=_ Yi/a/syllables}');
Error('\P{Is_Blk=_ Yi/a/syllables}');
Expect(1, 42127, '\p{Is_Blk=yisyllables}', "");
Expect(0, 42127, '\p{^Is_Blk=yisyllables}', "");
Expect(0, 42127, '\P{Is_Blk=yisyllables}', "");
Expect(1, 42127, '\P{^Is_Blk=yisyllables}', "");
Expect(0, 40959, '\p{Is_Blk=yisyllables}', "");
Expect(1, 40959, '\p{^Is_Blk=yisyllables}', "");
Expect(1, 40959, '\P{Is_Blk=yisyllables}', "");
Expect(0, 40959, '\P{^Is_Blk=yisyllables}', "");
Expect(1, 42127, '\p{Is_Blk: -Yi	Syllables}', "");
Expect(0, 42127, '\p{^Is_Blk: -Yi	Syllables}', "");
Expect(0, 42127, '\P{Is_Blk: -Yi	Syllables}', "");
Expect(1, 42127, '\P{^Is_Blk: -Yi	Syllables}', "");
Expect(0, 40959, '\p{Is_Blk: -Yi	Syllables}', "");
Expect(1, 40959, '\p{^Is_Blk: -Yi	Syllables}', "");
Expect(1, 40959, '\P{Is_Blk: -Yi	Syllables}', "");
Expect(0, 40959, '\P{^Is_Blk: -Yi	Syllables}', "");
Error('\p{Block=:=- combining-Half-marks}');
Error('\P{Block=:=- combining-Half-marks}');
Expect(1, 65071, '\p{Block=combininghalfmarks}', "");
Expect(0, 65071, '\p{^Block=combininghalfmarks}', "");
Expect(0, 65071, '\P{Block=combininghalfmarks}', "");
Expect(1, 65071, '\P{^Block=combininghalfmarks}', "");
Expect(0, 65055, '\p{Block=combininghalfmarks}', "");
Expect(1, 65055, '\p{^Block=combininghalfmarks}', "");
Expect(1, 65055, '\P{Block=combininghalfmarks}', "");
Expect(0, 65055, '\P{^Block=combininghalfmarks}', "");
Expect(1, 65071, '\p{Block=	Combining	HALFmarks}', "");
Expect(0, 65071, '\p{^Block=	Combining	HALFmarks}', "");
Expect(0, 65071, '\P{Block=	Combining	HALFmarks}', "");
Expect(1, 65071, '\P{^Block=	Combining	HALFmarks}', "");
Expect(0, 65055, '\p{Block=	Combining	HALFmarks}', "");
Expect(1, 65055, '\p{^Block=	Combining	HALFmarks}', "");
Expect(1, 65055, '\P{Block=	Combining	HALFmarks}', "");
Expect(0, 65055, '\P{^Block=	Combining	HALFmarks}', "");
Error('\p{Blk=-combining HALF	marks:=}');
Error('\P{Blk=-combining HALF	marks:=}');
Expect(1, 65071, '\p{Blk:combininghalfmarks}', "");
Expect(0, 65071, '\p{^Blk:combininghalfmarks}', "");
Expect(0, 65071, '\P{Blk:combininghalfmarks}', "");
Expect(1, 65071, '\P{^Blk:combininghalfmarks}', "");
Expect(0, 65055, '\p{Blk:combininghalfmarks}', "");
Expect(1, 65055, '\p{^Blk:combininghalfmarks}', "");
Expect(1, 65055, '\P{Blk:combininghalfmarks}', "");
Expect(0, 65055, '\P{^Blk:combininghalfmarks}', "");
Expect(1, 65071, '\p{Blk=_ Combining-half-marks}', "");
Expect(0, 65071, '\p{^Blk=_ Combining-half-marks}', "");
Expect(0, 65071, '\P{Blk=_ Combining-half-marks}', "");
Expect(1, 65071, '\P{^Blk=_ Combining-half-marks}', "");
Expect(0, 65055, '\p{Blk=_ Combining-half-marks}', "");
Expect(1, 65055, '\p{^Blk=_ Combining-half-marks}', "");
Expect(1, 65055, '\P{Blk=_ Combining-half-marks}', "");
Expect(0, 65055, '\P{^Blk=_ Combining-half-marks}', "");
Error('\p{Is_Block=_-Combininghalf	Marks:=}');
Error('\P{Is_Block=_-Combininghalf	Marks:=}');
Expect(1, 65071, '\p{Is_Block:combininghalfmarks}', "");
Expect(0, 65071, '\p{^Is_Block:combininghalfmarks}', "");
Expect(0, 65071, '\P{Is_Block:combininghalfmarks}', "");
Expect(1, 65071, '\P{^Is_Block:combininghalfmarks}', "");
Expect(0, 65055, '\p{Is_Block:combininghalfmarks}', "");
Expect(1, 65055, '\p{^Is_Block:combininghalfmarks}', "");
Expect(1, 65055, '\P{Is_Block:combininghalfmarks}', "");
Expect(0, 65055, '\P{^Is_Block:combininghalfmarks}', "");
Expect(1, 65071, '\p{Is_Block=	 COMBININGhalf MARKS}', "");
Expect(0, 65071, '\p{^Is_Block=	 COMBININGhalf MARKS}', "");
Expect(0, 65071, '\P{Is_Block=	 COMBININGhalf MARKS}', "");
Expect(1, 65071, '\P{^Is_Block=	 COMBININGhalf MARKS}', "");
Expect(0, 65055, '\p{Is_Block=	 COMBININGhalf MARKS}', "");
Expect(1, 65055, '\p{^Is_Block=	 COMBININGhalf MARKS}', "");
Expect(1, 65055, '\P{Is_Block=	 COMBININGhalf MARKS}', "");
Expect(0, 65055, '\P{^Is_Block=	 COMBININGhalf MARKS}', "");
Error('\p{Is_Blk= -combining:=Half	MARKS}');
Error('\P{Is_Blk= -combining:=Half	MARKS}');
Expect(1, 65071, '\p{Is_Blk=combininghalfmarks}', "");
Expect(0, 65071, '\p{^Is_Blk=combininghalfmarks}', "");
Expect(0, 65071, '\P{Is_Blk=combininghalfmarks}', "");
Expect(1, 65071, '\P{^Is_Blk=combininghalfmarks}', "");
Expect(0, 65055, '\p{Is_Blk=combininghalfmarks}', "");
Expect(1, 65055, '\p{^Is_Blk=combininghalfmarks}', "");
Expect(1, 65055, '\P{Is_Blk=combininghalfmarks}', "");
Expect(0, 65055, '\P{^Is_Blk=combininghalfmarks}', "");
Expect(1, 65071, '\p{Is_Blk=		CombiningHalfMARKS}', "");
Expect(0, 65071, '\p{^Is_Blk=		CombiningHalfMARKS}', "");
Expect(0, 65071, '\P{Is_Blk=		CombiningHalfMARKS}', "");
Expect(1, 65071, '\P{^Is_Blk=		CombiningHalfMARKS}', "");
Expect(0, 65055, '\p{Is_Blk=		CombiningHalfMARKS}', "");
Expect(1, 65055, '\p{^Is_Blk=		CombiningHalfMARKS}', "");
Expect(1, 65055, '\P{Is_Blk=		CombiningHalfMARKS}', "");
Expect(0, 65055, '\P{^Is_Blk=		CombiningHalfMARKS}', "");
Error('\p{Block= /a/miscellaneousSYMBOLSand-Arrows}');
Error('\P{Block= /a/miscellaneousSYMBOLSand-Arrows}');
Expect(1, 11263, '\p{Block=miscellaneoussymbolsandarrows}', "");
Expect(0, 11263, '\p{^Block=miscellaneoussymbolsandarrows}', "");
Expect(0, 11263, '\P{Block=miscellaneoussymbolsandarrows}', "");
Expect(1, 11263, '\P{^Block=miscellaneoussymbolsandarrows}', "");
Expect(0, 11007, '\p{Block=miscellaneoussymbolsandarrows}', "");
Expect(1, 11007, '\p{^Block=miscellaneoussymbolsandarrows}', "");
Expect(1, 11007, '\P{Block=miscellaneoussymbolsandarrows}', "");
Expect(0, 11007, '\P{^Block=miscellaneoussymbolsandarrows}', "");
Expect(1, 11263, '\p{Block=_ MiscellaneousSymbols	andArrows}', "");
Expect(0, 11263, '\p{^Block=_ MiscellaneousSymbols	andArrows}', "");
Expect(0, 11263, '\P{Block=_ MiscellaneousSymbols	andArrows}', "");
Expect(1, 11263, '\P{^Block=_ MiscellaneousSymbols	andArrows}', "");
Expect(0, 11007, '\p{Block=_ MiscellaneousSymbols	andArrows}', "");
Expect(1, 11007, '\p{^Block=_ MiscellaneousSymbols	andArrows}', "");
Expect(1, 11007, '\P{Block=_ MiscellaneousSymbols	andArrows}', "");
Expect(0, 11007, '\P{^Block=_ MiscellaneousSymbols	andArrows}', "");
Error('\p{Blk=-	Miscellaneous_Symbols	And/a/Arrows}');
Error('\P{Blk=-	Miscellaneous_Symbols	And/a/Arrows}');
Expect(1, 11263, '\p{Blk=miscellaneoussymbolsandarrows}', "");
Expect(0, 11263, '\p{^Blk=miscellaneoussymbolsandarrows}', "");
Expect(0, 11263, '\P{Blk=miscellaneoussymbolsandarrows}', "");
Expect(1, 11263, '\P{^Blk=miscellaneoussymbolsandarrows}', "");
Expect(0, 11007, '\p{Blk=miscellaneoussymbolsandarrows}', "");
Expect(1, 11007, '\p{^Blk=miscellaneoussymbolsandarrows}', "");
Expect(1, 11007, '\P{Blk=miscellaneoussymbolsandarrows}', "");
Expect(0, 11007, '\P{^Blk=miscellaneoussymbolsandarrows}', "");
Expect(1, 11263, '\p{Blk=	-Miscellaneous SYMBOLSAnd ARROWS}', "");
Expect(0, 11263, '\p{^Blk=	-Miscellaneous SYMBOLSAnd ARROWS}', "");
Expect(0, 11263, '\P{Blk=	-Miscellaneous SYMBOLSAnd ARROWS}', "");
Expect(1, 11263, '\P{^Blk=	-Miscellaneous SYMBOLSAnd ARROWS}', "");
Expect(0, 11007, '\p{Blk=	-Miscellaneous SYMBOLSAnd ARROWS}', "");
Expect(1, 11007, '\p{^Blk=	-Miscellaneous SYMBOLSAnd ARROWS}', "");
Expect(1, 11007, '\P{Blk=	-Miscellaneous SYMBOLSAnd ARROWS}', "");
Expect(0, 11007, '\P{^Blk=	-Miscellaneous SYMBOLSAnd ARROWS}', "");
Error('\p{Is_Block=__miscellaneous_Symbols And:=ARROWS}');
Error('\P{Is_Block=__miscellaneous_Symbols And:=ARROWS}');
Expect(1, 11263, '\p{Is_Block=miscellaneoussymbolsandarrows}', "");
Expect(0, 11263, '\p{^Is_Block=miscellaneoussymbolsandarrows}', "");
Expect(0, 11263, '\P{Is_Block=miscellaneoussymbolsandarrows}', "");
Expect(1, 11263, '\P{^Is_Block=miscellaneoussymbolsandarrows}', "");
Expect(0, 11007, '\p{Is_Block=miscellaneoussymbolsandarrows}', "");
Expect(1, 11007, '\p{^Is_Block=miscellaneoussymbolsandarrows}', "");
Expect(1, 11007, '\P{Is_Block=miscellaneoussymbolsandarrows}', "");
Expect(0, 11007, '\P{^Is_Block=miscellaneoussymbolsandarrows}', "");
Expect(1, 11263, '\p{Is_Block:	- Miscellaneous_Symbols	And Arrows}', "");
Expect(0, 11263, '\p{^Is_Block:	- Miscellaneous_Symbols	And Arrows}', "");
Expect(0, 11263, '\P{Is_Block:	- Miscellaneous_Symbols	And Arrows}', "");
Expect(1, 11263, '\P{^Is_Block:	- Miscellaneous_Symbols	And Arrows}', "");
Expect(0, 11007, '\p{Is_Block:	- Miscellaneous_Symbols	And Arrows}', "");
Expect(1, 11007, '\p{^Is_Block:	- Miscellaneous_Symbols	And Arrows}', "");
Expect(1, 11007, '\P{Is_Block:	- Miscellaneous_Symbols	And Arrows}', "");
Expect(0, 11007, '\P{^Is_Block:	- Miscellaneous_Symbols	And Arrows}', "");
Error('\p{Is_Blk= /a/MISCELLANEOUS_Symbols	And Arrows}');
Error('\P{Is_Blk= /a/MISCELLANEOUS_Symbols	And Arrows}');
Expect(1, 11263, '\p{Is_Blk=miscellaneoussymbolsandarrows}', "");
Expect(0, 11263, '\p{^Is_Blk=miscellaneoussymbolsandarrows}', "");
Expect(0, 11263, '\P{Is_Blk=miscellaneoussymbolsandarrows}', "");
Expect(1, 11263, '\P{^Is_Blk=miscellaneoussymbolsandarrows}', "");
Expect(0, 11007, '\p{Is_Blk=miscellaneoussymbolsandarrows}', "");
Expect(1, 11007, '\p{^Is_Blk=miscellaneoussymbolsandarrows}', "");
Expect(1, 11007, '\P{Is_Blk=miscellaneoussymbolsandarrows}', "");
Expect(0, 11007, '\P{^Is_Blk=miscellaneoussymbolsandarrows}', "");
Expect(1, 11263, '\p{Is_Blk=--MISCELLANEOUS_SymbolsAnd_Arrows}', "");
Expect(0, 11263, '\p{^Is_Blk=--MISCELLANEOUS_SymbolsAnd_Arrows}', "");
Expect(0, 11263, '\P{Is_Blk=--MISCELLANEOUS_SymbolsAnd_Arrows}', "");
Expect(1, 11263, '\P{^Is_Blk=--MISCELLANEOUS_SymbolsAnd_Arrows}', "");
Expect(0, 11007, '\p{Is_Blk=--MISCELLANEOUS_SymbolsAnd_Arrows}', "");
Expect(1, 11007, '\p{^Is_Blk=--MISCELLANEOUS_SymbolsAnd_Arrows}', "");
Expect(1, 11007, '\P{Is_Blk=--MISCELLANEOUS_SymbolsAnd_Arrows}', "");
Expect(0, 11007, '\P{^Is_Blk=--MISCELLANEOUS_SymbolsAnd_Arrows}', "");
Error('\p{Block=:=Halfwidth And_fullwidth-Forms}');
Error('\P{Block=:=Halfwidth And_fullwidth-Forms}');
Expect(1, 65519, '\p{Block=halfwidthandfullwidthforms}', "");
Expect(0, 65519, '\p{^Block=halfwidthandfullwidthforms}', "");
Expect(0, 65519, '\P{Block=halfwidthandfullwidthforms}', "");
Expect(1, 65519, '\P{^Block=halfwidthandfullwidthforms}', "");
Expect(0, 65279, '\p{Block=halfwidthandfullwidthforms}', "");
Expect(1, 65279, '\p{^Block=halfwidthandfullwidthforms}', "");
Expect(1, 65279, '\P{Block=halfwidthandfullwidthforms}', "");
Expect(0, 65279, '\P{^Block=halfwidthandfullwidthforms}', "");
Expect(1, 65519, '\p{Block=	 Halfwidth	AndFullwidthforms}', "");
Expect(0, 65519, '\p{^Block=	 Halfwidth	AndFullwidthforms}', "");
Expect(0, 65519, '\P{Block=	 Halfwidth	AndFullwidthforms}', "");
Expect(1, 65519, '\P{^Block=	 Halfwidth	AndFullwidthforms}', "");
Expect(0, 65279, '\p{Block=	 Halfwidth	AndFullwidthforms}', "");
Expect(1, 65279, '\p{^Block=	 Halfwidth	AndFullwidthforms}', "");
Expect(1, 65279, '\P{Block=	 Halfwidth	AndFullwidthforms}', "");
Expect(0, 65279, '\P{^Block=	 Halfwidth	AndFullwidthforms}', "");
Error('\p{Blk=	/a/Halfwidth_and_fullwidth Forms}');
Error('\P{Blk=	/a/Halfwidth_and_fullwidth Forms}');
Expect(1, 65519, '\p{Blk=halfwidthandfullwidthforms}', "");
Expect(0, 65519, '\p{^Blk=halfwidthandfullwidthforms}', "");
Expect(0, 65519, '\P{Blk=halfwidthandfullwidthforms}', "");
Expect(1, 65519, '\P{^Blk=halfwidthandfullwidthforms}', "");
Expect(0, 65279, '\p{Blk=halfwidthandfullwidthforms}', "");
Expect(1, 65279, '\p{^Blk=halfwidthandfullwidthforms}', "");
Expect(1, 65279, '\P{Blk=halfwidthandfullwidthforms}', "");
Expect(0, 65279, '\P{^Blk=halfwidthandfullwidthforms}', "");
Expect(1, 65519, '\p{Blk= halfwidth	and_Fullwidth Forms}', "");
Expect(0, 65519, '\p{^Blk= halfwidth	and_Fullwidth Forms}', "");
Expect(0, 65519, '\P{Blk= halfwidth	and_Fullwidth Forms}', "");
Expect(1, 65519, '\P{^Blk= halfwidth	and_Fullwidth Forms}', "");
Expect(0, 65279, '\p{Blk= halfwidth	and_Fullwidth Forms}', "");
Expect(1, 65279, '\p{^Blk= halfwidth	and_Fullwidth Forms}', "");
Expect(1, 65279, '\P{Blk= halfwidth	and_Fullwidth Forms}', "");
Expect(0, 65279, '\P{^Blk= halfwidth	and_Fullwidth Forms}', "");
Error('\p{Is_Block= /a/halfwidth-AND_fullwidth	forms}');
Error('\P{Is_Block= /a/halfwidth-AND_fullwidth	forms}');
Expect(1, 65519, '\p{Is_Block=halfwidthandfullwidthforms}', "");
Expect(0, 65519, '\p{^Is_Block=halfwidthandfullwidthforms}', "");
Expect(0, 65519, '\P{Is_Block=halfwidthandfullwidthforms}', "");
Expect(1, 65519, '\P{^Is_Block=halfwidthandfullwidthforms}', "");
Expect(0, 65279, '\p{Is_Block=halfwidthandfullwidthforms}', "");
Expect(1, 65279, '\p{^Is_Block=halfwidthandfullwidthforms}', "");
Expect(1, 65279, '\P{Is_Block=halfwidthandfullwidthforms}', "");
Expect(0, 65279, '\P{^Is_Block=halfwidthandfullwidthforms}', "");
Expect(1, 65519, '\p{Is_Block=_ Halfwidth	And Fullwidth_Forms}', "");
Expect(0, 65519, '\p{^Is_Block=_ Halfwidth	And Fullwidth_Forms}', "");
Expect(0, 65519, '\P{Is_Block=_ Halfwidth	And Fullwidth_Forms}', "");
Expect(1, 65519, '\P{^Is_Block=_ Halfwidth	And Fullwidth_Forms}', "");
Expect(0, 65279, '\p{Is_Block=_ Halfwidth	And Fullwidth_Forms}', "");
Expect(1, 65279, '\p{^Is_Block=_ Halfwidth	And Fullwidth_Forms}', "");
Expect(1, 65279, '\P{Is_Block=_ Halfwidth	And Fullwidth_Forms}', "");
Expect(0, 65279, '\P{^Is_Block=_ Halfwidth	And Fullwidth_Forms}', "");
Error('\p{Is_Blk=_/a/HALFWIDTH-and-Fullwidth	Forms}');
Error('\P{Is_Blk=_/a/HALFWIDTH-and-Fullwidth	Forms}');
Expect(1, 65519, '\p{Is_Blk=halfwidthandfullwidthforms}', "");
Expect(0, 65519, '\p{^Is_Blk=halfwidthandfullwidthforms}', "");
Expect(0, 65519, '\P{Is_Blk=halfwidthandfullwidthforms}', "");
Expect(1, 65519, '\P{^Is_Blk=halfwidthandfullwidthforms}', "");
Expect(0, 65279, '\p{Is_Blk=halfwidthandfullwidthforms}', "");
Expect(1, 65279, '\p{^Is_Blk=halfwidthandfullwidthforms}', "");
Expect(1, 65279, '\P{Is_Blk=halfwidthandfullwidthforms}', "");
Expect(0, 65279, '\P{^Is_Blk=halfwidthandfullwidthforms}', "");
Expect(1, 65519, '\p{Is_Blk=	_Halfwidth	and	FullwidthForms}', "");
Expect(0, 65519, '\p{^Is_Blk=	_Halfwidth	and	FullwidthForms}', "");
Expect(0, 65519, '\P{Is_Blk=	_Halfwidth	and	FullwidthForms}', "");
Expect(1, 65519, '\P{^Is_Blk=	_Halfwidth	and	FullwidthForms}', "");
Expect(0, 65279, '\p{Is_Blk=	_Halfwidth	and	FullwidthForms}', "");
Expect(1, 65279, '\p{^Is_Blk=	_Halfwidth	and	FullwidthForms}', "");
Expect(1, 65279, '\P{Is_Blk=	_Halfwidth	and	FullwidthForms}', "");
Expect(0, 65279, '\P{^Is_Blk=	_Halfwidth	and	FullwidthForms}', "");
Error('\p{Block=_SupplementaryPrivate	Use/a/AreaB}');
Error('\P{Block=_SupplementaryPrivate	Use/a/AreaB}');
Expect(1, 1048576, '\p{Block=supplementaryprivateuseareab}', "");
Expect(0, 1048576, '\p{^Block=supplementaryprivateuseareab}', "");
Expect(0, 1048576, '\P{Block=supplementaryprivateuseareab}', "");
Expect(1, 1048576, '\P{^Block=supplementaryprivateuseareab}', "");
Expect(0, 1, '\p{Block=supplementaryprivateuseareab}', "");
Expect(1, 1, '\p{^Block=supplementaryprivateuseareab}', "");
Expect(1, 1, '\P{Block=supplementaryprivateuseareab}', "");
Expect(0, 1, '\P{^Block=supplementaryprivateuseareab}', "");
Expect(1, 1048576, '\p{Block=-Supplementary-private	Use-area-B}', "");
Expect(0, 1048576, '\p{^Block=-Supplementary-private	Use-area-B}', "");
Expect(0, 1048576, '\P{Block=-Supplementary-private	Use-area-B}', "");
Expect(1, 1048576, '\P{^Block=-Supplementary-private	Use-area-B}', "");
Expect(0, 1, '\p{Block=-Supplementary-private	Use-area-B}', "");
Expect(1, 1, '\p{^Block=-Supplementary-private	Use-area-B}', "");
Expect(1, 1, '\P{Block=-Supplementary-private	Use-area-B}', "");
Expect(0, 1, '\P{^Block=-Supplementary-private	Use-area-B}', "");
Error('\p{Blk=_Supplementary/a/Private Use areab}');
Error('\P{Blk=_Supplementary/a/Private Use areab}');
Expect(1, 1048576, '\p{Blk=supplementaryprivateuseareab}', "");
Expect(0, 1048576, '\p{^Blk=supplementaryprivateuseareab}', "");
Expect(0, 1048576, '\P{Blk=supplementaryprivateuseareab}', "");
Expect(1, 1048576, '\P{^Blk=supplementaryprivateuseareab}', "");
Expect(0, 1, '\p{Blk=supplementaryprivateuseareab}', "");
Expect(1, 1, '\p{^Blk=supplementaryprivateuseareab}', "");
Expect(1, 1, '\P{Blk=supplementaryprivateuseareab}', "");
Expect(0, 1, '\P{^Blk=supplementaryprivateuseareab}', "");
Expect(1, 1048576, '\p{Blk= SupplementaryprivateUSE-AREA-B}', "");
Expect(0, 1048576, '\p{^Blk= SupplementaryprivateUSE-AREA-B}', "");
Expect(0, 1048576, '\P{Blk= SupplementaryprivateUSE-AREA-B}', "");
Expect(1, 1048576, '\P{^Blk= SupplementaryprivateUSE-AREA-B}', "");
Expect(0, 1, '\p{Blk= SupplementaryprivateUSE-AREA-B}', "");
Expect(1, 1, '\p{^Blk= SupplementaryprivateUSE-AREA-B}', "");
Expect(1, 1, '\P{Blk= SupplementaryprivateUSE-AREA-B}', "");
Expect(0, 1, '\P{^Blk= SupplementaryprivateUSE-AREA-B}', "");
Error('\p{Is_Block=- Supplementary:=Private-Use-Area-B}');
Error('\P{Is_Block=- Supplementary:=Private-Use-Area-B}');
Expect(1, 1048576, '\p{Is_Block=supplementaryprivateuseareab}', "");
Expect(0, 1048576, '\p{^Is_Block=supplementaryprivateuseareab}', "");
Expect(0, 1048576, '\P{Is_Block=supplementaryprivateuseareab}', "");
Expect(1, 1048576, '\P{^Is_Block=supplementaryprivateuseareab}', "");
Expect(0, 1, '\p{Is_Block=supplementaryprivateuseareab}', "");
Expect(1, 1, '\p{^Is_Block=supplementaryprivateuseareab}', "");
Expect(1, 1, '\P{Is_Block=supplementaryprivateuseareab}', "");
Expect(0, 1, '\P{^Is_Block=supplementaryprivateuseareab}', "");
Expect(1, 1048576, '\p{Is_Block=-_Supplementary Private use-Area_B}', "");
Expect(0, 1048576, '\p{^Is_Block=-_Supplementary Private use-Area_B}', "");
Expect(0, 1048576, '\P{Is_Block=-_Supplementary Private use-Area_B}', "");
Expect(1, 1048576, '\P{^Is_Block=-_Supplementary Private use-Area_B}', "");
Expect(0, 1, '\p{Is_Block=-_Supplementary Private use-Area_B}', "");
Expect(1, 1, '\p{^Is_Block=-_Supplementary Private use-Area_B}', "");
Expect(1, 1, '\P{Is_Block=-_Supplementary Private use-Area_B}', "");
Expect(0, 1, '\P{^Is_Block=-_Supplementary Private use-Area_B}', "");
Error('\p{Is_Blk=_	SUPPLEMENTARY	Private:=Use AREAB}');
Error('\P{Is_Blk=_	SUPPLEMENTARY	Private:=Use AREAB}');
Expect(1, 1048576, '\p{Is_Blk:   supplementaryprivateuseareab}', "");
Expect(0, 1048576, '\p{^Is_Blk:   supplementaryprivateuseareab}', "");
Expect(0, 1048576, '\P{Is_Blk:   supplementaryprivateuseareab}', "");
Expect(1, 1048576, '\P{^Is_Blk:   supplementaryprivateuseareab}', "");
Expect(0, 1, '\p{Is_Blk:   supplementaryprivateuseareab}', "");
Expect(1, 1, '\p{^Is_Blk:   supplementaryprivateuseareab}', "");
Expect(1, 1, '\P{Is_Blk:   supplementaryprivateuseareab}', "");
Expect(0, 1, '\P{^Is_Blk:   supplementaryprivateuseareab}', "");
Expect(1, 1048576, '\p{Is_Blk=-	supplementary PRIVATE	use AREA-b}', "");
Expect(0, 1048576, '\p{^Is_Blk=-	supplementary PRIVATE	use AREA-b}', "");
Expect(0, 1048576, '\P{Is_Blk=-	supplementary PRIVATE	use AREA-b}', "");
Expect(1, 1048576, '\P{^Is_Blk=-	supplementary PRIVATE	use AREA-b}', "");
Expect(0, 1, '\p{Is_Blk=-	supplementary PRIVATE	use AREA-b}', "");
Expect(1, 1, '\p{^Is_Blk=-	supplementary PRIVATE	use AREA-b}', "");
Expect(1, 1, '\P{Is_Blk=-	supplementary PRIVATE	use AREA-b}', "");
Expect(0, 1, '\P{^Is_Blk=-	supplementary PRIVATE	use AREA-b}', "");
Error('\p{Block:   /a/ _Sundanese}');
Error('\P{Block:   /a/ _Sundanese}');
Expect(1, 7103, '\p{Block=sundanese}', "");
Expect(0, 7103, '\p{^Block=sundanese}', "");
Expect(0, 7103, '\P{Block=sundanese}', "");
Expect(1, 7103, '\P{^Block=sundanese}', "");
Expect(0, 7039, '\p{Block=sundanese}', "");
Expect(1, 7039, '\p{^Block=sundanese}', "");
Expect(1, 7039, '\P{Block=sundanese}', "");
Expect(0, 7039, '\P{^Block=sundanese}', "");
Expect(1, 7103, '\p{Block=	_Sundanese}', "");
Expect(0, 7103, '\p{^Block=	_Sundanese}', "");
Expect(0, 7103, '\P{Block=	_Sundanese}', "");
Expect(1, 7103, '\P{^Block=	_Sundanese}', "");
Expect(0, 7039, '\p{Block=	_Sundanese}', "");
Expect(1, 7039, '\p{^Block=	_Sundanese}', "");
Expect(1, 7039, '\P{Block=	_Sundanese}', "");
Expect(0, 7039, '\P{^Block=	_Sundanese}', "");
Error('\p{Blk:   	:=sundanese}');
Error('\P{Blk:   	:=sundanese}');
Expect(1, 7103, '\p{Blk=sundanese}', "");
Expect(0, 7103, '\p{^Blk=sundanese}', "");
Expect(0, 7103, '\P{Blk=sundanese}', "");
Expect(1, 7103, '\P{^Blk=sundanese}', "");
Expect(0, 7039, '\p{Blk=sundanese}', "");
Expect(1, 7039, '\p{^Blk=sundanese}', "");
Expect(1, 7039, '\P{Blk=sundanese}', "");
Expect(0, 7039, '\P{^Blk=sundanese}', "");
Expect(1, 7103, '\p{Blk=	 sundanese}', "");
Expect(0, 7103, '\p{^Blk=	 sundanese}', "");
Expect(0, 7103, '\P{Blk=	 sundanese}', "");
Expect(1, 7103, '\P{^Blk=	 sundanese}', "");
Expect(0, 7039, '\p{Blk=	 sundanese}', "");
Expect(1, 7039, '\p{^Blk=	 sundanese}', "");
Expect(1, 7039, '\P{Blk=	 sundanese}', "");
Expect(0, 7039, '\P{^Blk=	 sundanese}', "");
Error('\p{Is_Block=_ Sundanese/a/}');
Error('\P{Is_Block=_ Sundanese/a/}');
Expect(1, 7103, '\p{Is_Block=sundanese}', "");
Expect(0, 7103, '\p{^Is_Block=sundanese}', "");
Expect(0, 7103, '\P{Is_Block=sundanese}', "");
Expect(1, 7103, '\P{^Is_Block=sundanese}', "");
Expect(0, 7039, '\p{Is_Block=sundanese}', "");
Expect(1, 7039, '\p{^Is_Block=sundanese}', "");
Expect(1, 7039, '\P{Is_Block=sundanese}', "");
Expect(0, 7039, '\P{^Is_Block=sundanese}', "");
Expect(1, 7103, '\p{Is_Block=	_Sundanese}', "");
Expect(0, 7103, '\p{^Is_Block=	_Sundanese}', "");
Expect(0, 7103, '\P{Is_Block=	_Sundanese}', "");
Expect(1, 7103, '\P{^Is_Block=	_Sundanese}', "");
Expect(0, 7039, '\p{Is_Block=	_Sundanese}', "");
Expect(1, 7039, '\p{^Is_Block=	_Sundanese}', "");
Expect(1, 7039, '\P{Is_Block=	_Sundanese}', "");
Expect(0, 7039, '\P{^Is_Block=	_Sundanese}', "");
Error('\p{Is_Blk=	:=SUNDANESE}');
Error('\P{Is_Blk=	:=SUNDANESE}');
Expect(1, 7103, '\p{Is_Blk=sundanese}', "");
Expect(0, 7103, '\p{^Is_Blk=sundanese}', "");
Expect(0, 7103, '\P{Is_Blk=sundanese}', "");
Expect(1, 7103, '\P{^Is_Blk=sundanese}', "");
Expect(0, 7039, '\p{Is_Blk=sundanese}', "");
Expect(1, 7039, '\p{^Is_Blk=sundanese}', "");
Expect(1, 7039, '\P{Is_Blk=sundanese}', "");
Expect(0, 7039, '\P{^Is_Blk=sundanese}', "");
Expect(1, 7103, '\p{Is_Blk=_-Sundanese}', "");
Expect(0, 7103, '\p{^Is_Blk=_-Sundanese}', "");
Expect(0, 7103, '\P{Is_Blk=_-Sundanese}', "");
Expect(1, 7103, '\P{^Is_Blk=_-Sundanese}', "");
Expect(0, 7039, '\p{Is_Blk=_-Sundanese}', "");
Expect(1, 7039, '\p{^Is_Blk=_-Sundanese}', "");
Expect(1, 7039, '\P{Is_Blk=_-Sundanese}', "");
Expect(0, 7039, '\P{^Is_Blk=_-Sundanese}', "");
Error('\p{Block=--Enclosed:=ALPHANUMERICS}');
Error('\P{Block=--Enclosed:=ALPHANUMERICS}');
Expect(1, 9471, '\p{Block=enclosedalphanumerics}', "");
Expect(0, 9471, '\p{^Block=enclosedalphanumerics}', "");
Expect(0, 9471, '\P{Block=enclosedalphanumerics}', "");
Expect(1, 9471, '\P{^Block=enclosedalphanumerics}', "");
Expect(0, 9311, '\p{Block=enclosedalphanumerics}', "");
Expect(1, 9311, '\p{^Block=enclosedalphanumerics}', "");
Expect(1, 9311, '\P{Block=enclosedalphanumerics}', "");
Expect(0, 9311, '\P{^Block=enclosedalphanumerics}', "");
Expect(1, 9471, '\p{Block= 	enclosed-alphanumerics}', "");
Expect(0, 9471, '\p{^Block= 	enclosed-alphanumerics}', "");
Expect(0, 9471, '\P{Block= 	enclosed-alphanumerics}', "");
Expect(1, 9471, '\P{^Block= 	enclosed-alphanumerics}', "");
Expect(0, 9311, '\p{Block= 	enclosed-alphanumerics}', "");
Expect(1, 9311, '\p{^Block= 	enclosed-alphanumerics}', "");
Expect(1, 9311, '\P{Block= 	enclosed-alphanumerics}', "");
Expect(0, 9311, '\P{^Block= 	enclosed-alphanumerics}', "");
Error('\p{Blk=		Enclosed:=ALPHANUMERICS}');
Error('\P{Blk=		Enclosed:=ALPHANUMERICS}');
Expect(1, 9471, '\p{Blk=enclosedalphanumerics}', "");
Expect(0, 9471, '\p{^Blk=enclosedalphanumerics}', "");
Expect(0, 9471, '\P{Blk=enclosedalphanumerics}', "");
Expect(1, 9471, '\P{^Blk=enclosedalphanumerics}', "");
Expect(0, 9311, '\p{Blk=enclosedalphanumerics}', "");
Expect(1, 9311, '\p{^Blk=enclosedalphanumerics}', "");
Expect(1, 9311, '\P{Blk=enclosedalphanumerics}', "");
Expect(0, 9311, '\P{^Blk=enclosedalphanumerics}', "");
Expect(1, 9471, '\p{Blk= -EnclosedAlphanumerics}', "");
Expect(0, 9471, '\p{^Blk= -EnclosedAlphanumerics}', "");
Expect(0, 9471, '\P{Blk= -EnclosedAlphanumerics}', "");
Expect(1, 9471, '\P{^Blk= -EnclosedAlphanumerics}', "");
Expect(0, 9311, '\p{Blk= -EnclosedAlphanumerics}', "");
Expect(1, 9311, '\p{^Blk= -EnclosedAlphanumerics}', "");
Expect(1, 9311, '\P{Blk= -EnclosedAlphanumerics}', "");
Expect(0, 9311, '\P{^Blk= -EnclosedAlphanumerics}', "");
Error('\p{Is_Block=_Enclosed-Alphanumerics:=}');
Error('\P{Is_Block=_Enclosed-Alphanumerics:=}');
Expect(1, 9471, '\p{Is_Block: enclosedalphanumerics}', "");
Expect(0, 9471, '\p{^Is_Block: enclosedalphanumerics}', "");
Expect(0, 9471, '\P{Is_Block: enclosedalphanumerics}', "");
Expect(1, 9471, '\P{^Is_Block: enclosedalphanumerics}', "");
Expect(0, 9311, '\p{Is_Block: enclosedalphanumerics}', "");
Expect(1, 9311, '\p{^Is_Block: enclosedalphanumerics}', "");
Expect(1, 9311, '\P{Is_Block: enclosedalphanumerics}', "");
Expect(0, 9311, '\P{^Is_Block: enclosedalphanumerics}', "");
Expect(1, 9471, '\p{Is_Block=	-enclosed-ALPHANUMERICS}', "");
Expect(0, 9471, '\p{^Is_Block=	-enclosed-ALPHANUMERICS}', "");
Expect(0, 9471, '\P{Is_Block=	-enclosed-ALPHANUMERICS}', "");
Expect(1, 9471, '\P{^Is_Block=	-enclosed-ALPHANUMERICS}', "");
Expect(0, 9311, '\p{Is_Block=	-enclosed-ALPHANUMERICS}', "");
Expect(1, 9311, '\p{^Is_Block=	-enclosed-ALPHANUMERICS}', "");
Expect(1, 9311, '\P{Is_Block=	-enclosed-ALPHANUMERICS}', "");
Expect(0, 9311, '\P{^Is_Block=	-enclosed-ALPHANUMERICS}', "");
Error('\p{Is_Blk=/a/_ Enclosed-Alphanumerics}');
Error('\P{Is_Blk=/a/_ Enclosed-Alphanumerics}');
Expect(1, 9471, '\p{Is_Blk=enclosedalphanumerics}', "");
Expect(0, 9471, '\p{^Is_Blk=enclosedalphanumerics}', "");
Expect(0, 9471, '\P{Is_Blk=enclosedalphanumerics}', "");
Expect(1, 9471, '\P{^Is_Blk=enclosedalphanumerics}', "");
Expect(0, 9311, '\p{Is_Blk=enclosedalphanumerics}', "");
Expect(1, 9311, '\p{^Is_Blk=enclosedalphanumerics}', "");
Expect(1, 9311, '\P{Is_Blk=enclosedalphanumerics}', "");
Expect(0, 9311, '\P{^Is_Blk=enclosedalphanumerics}', "");
Expect(1, 9471, '\p{Is_Blk: - EnclosedALPHANUMERICS}', "");
Expect(0, 9471, '\p{^Is_Blk: - EnclosedALPHANUMERICS}', "");
Expect(0, 9471, '\P{Is_Blk: - EnclosedALPHANUMERICS}', "");
Expect(1, 9471, '\P{^Is_Blk: - EnclosedALPHANUMERICS}', "");
Expect(0, 9311, '\p{Is_Blk: - EnclosedALPHANUMERICS}', "");
Expect(1, 9311, '\p{^Is_Blk: - EnclosedALPHANUMERICS}', "");
Expect(1, 9311, '\P{Is_Blk: - EnclosedALPHANUMERICS}', "");
Expect(0, 9311, '\P{^Is_Blk: - EnclosedALPHANUMERICS}', "");
Error('\p{Block=	:=Old	SouthARABIAN}');
Error('\P{Block=	:=Old	SouthARABIAN}');
Expect(1, 68223, '\p{Block=oldsoutharabian}', "");
Expect(0, 68223, '\p{^Block=oldsoutharabian}', "");
Expect(0, 68223, '\P{Block=oldsoutharabian}', "");
Expect(1, 68223, '\P{^Block=oldsoutharabian}', "");
Expect(0, 68191, '\p{Block=oldsoutharabian}', "");
Expect(1, 68191, '\p{^Block=oldsoutharabian}', "");
Expect(1, 68191, '\P{Block=oldsoutharabian}', "");
Expect(0, 68191, '\P{^Block=oldsoutharabian}', "");
Expect(1, 68223, '\p{Block=_-Old_SOUTH arabian}', "");
Expect(0, 68223, '\p{^Block=_-Old_SOUTH arabian}', "");
Expect(0, 68223, '\P{Block=_-Old_SOUTH arabian}', "");
Expect(1, 68223, '\P{^Block=_-Old_SOUTH arabian}', "");
Expect(0, 68191, '\p{Block=_-Old_SOUTH arabian}', "");
Expect(1, 68191, '\p{^Block=_-Old_SOUTH arabian}', "");
Expect(1, 68191, '\P{Block=_-Old_SOUTH arabian}', "");
Expect(0, 68191, '\P{^Block=_-Old_SOUTH arabian}', "");
Error('\p{Blk=/a/__old SOUTH	Arabian}');
Error('\P{Blk=/a/__old SOUTH	Arabian}');
Expect(1, 68223, '\p{Blk=oldsoutharabian}', "");
Expect(0, 68223, '\p{^Blk=oldsoutharabian}', "");
Expect(0, 68223, '\P{Blk=oldsoutharabian}', "");
Expect(1, 68223, '\P{^Blk=oldsoutharabian}', "");
Expect(0, 68191, '\p{Blk=oldsoutharabian}', "");
Expect(1, 68191, '\p{^Blk=oldsoutharabian}', "");
Expect(1, 68191, '\P{Blk=oldsoutharabian}', "");
Expect(0, 68191, '\P{^Blk=oldsoutharabian}', "");
Expect(1, 68223, '\p{Blk=Old South ARABIAN}', "");
Expect(0, 68223, '\p{^Blk=Old South ARABIAN}', "");
Expect(0, 68223, '\P{Blk=Old South ARABIAN}', "");
Expect(1, 68223, '\P{^Blk=Old South ARABIAN}', "");
Expect(0, 68191, '\p{Blk=Old South ARABIAN}', "");
Expect(1, 68191, '\p{^Blk=Old South ARABIAN}', "");
Expect(1, 68191, '\P{Blk=Old South ARABIAN}', "");
Expect(0, 68191, '\P{^Blk=Old South ARABIAN}', "");
Error('\p{Is_Block=_:=old	SOUTHARABIAN}');
Error('\P{Is_Block=_:=old	SOUTHARABIAN}');
Expect(1, 68223, '\p{Is_Block=oldsoutharabian}', "");
Expect(0, 68223, '\p{^Is_Block=oldsoutharabian}', "");
Expect(0, 68223, '\P{Is_Block=oldsoutharabian}', "");
Expect(1, 68223, '\P{^Is_Block=oldsoutharabian}', "");
Expect(0, 68191, '\p{Is_Block=oldsoutharabian}', "");
Expect(1, 68191, '\p{^Is_Block=oldsoutharabian}', "");
Expect(1, 68191, '\P{Is_Block=oldsoutharabian}', "");
Expect(0, 68191, '\P{^Is_Block=oldsoutharabian}', "");
Expect(1, 68223, '\p{Is_Block:   _oldSOUTH Arabian}', "");
Expect(0, 68223, '\p{^Is_Block:   _oldSOUTH Arabian}', "");
Expect(0, 68223, '\P{Is_Block:   _oldSOUTH Arabian}', "");
Expect(1, 68223, '\P{^Is_Block:   _oldSOUTH Arabian}', "");
Expect(0, 68191, '\p{Is_Block:   _oldSOUTH Arabian}', "");
Expect(1, 68191, '\p{^Is_Block:   _oldSOUTH Arabian}', "");
Expect(1, 68191, '\P{Is_Block:   _oldSOUTH Arabian}', "");
Expect(0, 68191, '\P{^Is_Block:   _oldSOUTH Arabian}', "");
Error('\p{Is_Blk=_	old south Arabian/a/}');
Error('\P{Is_Blk=_	old south Arabian/a/}');
Expect(1, 68223, '\p{Is_Blk=oldsoutharabian}', "");
Expect(0, 68223, '\p{^Is_Blk=oldsoutharabian}', "");
Expect(0, 68223, '\P{Is_Blk=oldsoutharabian}', "");
Expect(1, 68223, '\P{^Is_Blk=oldsoutharabian}', "");
Expect(0, 68191, '\p{Is_Blk=oldsoutharabian}', "");
Expect(1, 68191, '\p{^Is_Blk=oldsoutharabian}', "");
Expect(1, 68191, '\P{Is_Blk=oldsoutharabian}', "");
Expect(0, 68191, '\P{^Is_Blk=oldsoutharabian}', "");
Expect(1, 68223, '\p{Is_Blk=		OLD south arabian}', "");
Expect(0, 68223, '\p{^Is_Blk=		OLD south arabian}', "");
Expect(0, 68223, '\P{Is_Blk=		OLD south arabian}', "");
Expect(1, 68223, '\P{^Is_Blk=		OLD south arabian}', "");
Expect(0, 68191, '\p{Is_Blk=		OLD south arabian}', "");
Expect(1, 68191, '\p{^Is_Blk=		OLD south arabian}', "");
Expect(1, 68191, '\P{Is_Blk=		OLD south arabian}', "");
Expect(0, 68191, '\P{^Is_Blk=		OLD south arabian}', "");
Error('\p{Block:	_/a/Tags}');
Error('\P{Block:	_/a/Tags}');
Expect(1, 917631, '\p{Block=tags}', "");
Expect(0, 917631, '\p{^Block=tags}', "");
Expect(0, 917631, '\P{Block=tags}', "");
Expect(1, 917631, '\P{^Block=tags}', "");
Expect(0, 1, '\p{Block=tags}', "");
Expect(1, 1, '\p{^Block=tags}', "");
Expect(1, 1, '\P{Block=tags}', "");
Expect(0, 1, '\P{^Block=tags}', "");
Expect(1, 917631, '\p{Block=- Tags}', "");
Expect(0, 917631, '\p{^Block=- Tags}', "");
Expect(0, 917631, '\P{Block=- Tags}', "");
Expect(1, 917631, '\P{^Block=- Tags}', "");
Expect(0, 1, '\p{Block=- Tags}', "");
Expect(1, 1, '\p{^Block=- Tags}', "");
Expect(1, 1, '\P{Block=- Tags}', "");
Expect(0, 1, '\P{^Block=- Tags}', "");
Error('\p{Blk=--Tags/a/}');
Error('\P{Blk=--Tags/a/}');
Expect(1, 917631, '\p{Blk=tags}', "");
Expect(0, 917631, '\p{^Blk=tags}', "");
Expect(0, 917631, '\P{Blk=tags}', "");
Expect(1, 917631, '\P{^Blk=tags}', "");
Expect(0, 1, '\p{Blk=tags}', "");
Expect(1, 1, '\p{^Blk=tags}', "");
Expect(1, 1, '\P{Blk=tags}', "");
Expect(0, 1, '\P{^Blk=tags}', "");
Expect(1, 917631, '\p{Blk=_	tags}', "");
Expect(0, 917631, '\p{^Blk=_	tags}', "");
Expect(0, 917631, '\P{Blk=_	tags}', "");
Expect(1, 917631, '\P{^Blk=_	tags}', "");
Expect(0, 1, '\p{Blk=_	tags}', "");
Expect(1, 1, '\p{^Blk=_	tags}', "");
Expect(1, 1, '\P{Blk=_	tags}', "");
Expect(0, 1, '\P{^Blk=_	tags}', "");
Error('\p{Is_Block=/a/-Tags}');
Error('\P{Is_Block=/a/-Tags}');
Expect(1, 917631, '\p{Is_Block=tags}', "");
Expect(0, 917631, '\p{^Is_Block=tags}', "");
Expect(0, 917631, '\P{Is_Block=tags}', "");
Expect(1, 917631, '\P{^Is_Block=tags}', "");
Expect(0, 1, '\p{Is_Block=tags}', "");
Expect(1, 1, '\p{^Is_Block=tags}', "");
Expect(1, 1, '\P{Is_Block=tags}', "");
Expect(0, 1, '\P{^Is_Block=tags}', "");
Expect(1, 917631, '\p{Is_Block=	 Tags}', "");
Expect(0, 917631, '\p{^Is_Block=	 Tags}', "");
Expect(0, 917631, '\P{Is_Block=	 Tags}', "");
Expect(1, 917631, '\P{^Is_Block=	 Tags}', "");
Expect(0, 1, '\p{Is_Block=	 Tags}', "");
Expect(1, 1, '\p{^Is_Block=	 Tags}', "");
Expect(1, 1, '\P{Is_Block=	 Tags}', "");
Expect(0, 1, '\P{^Is_Block=	 Tags}', "");
Error('\p{Is_Blk=_-Tags:=}');
Error('\P{Is_Blk=_-Tags:=}');
Expect(1, 917631, '\p{Is_Blk=tags}', "");
Expect(0, 917631, '\p{^Is_Blk=tags}', "");
Expect(0, 917631, '\P{Is_Blk=tags}', "");
Expect(1, 917631, '\P{^Is_Blk=tags}', "");
Expect(0, 1, '\p{Is_Blk=tags}', "");
Expect(1, 1, '\p{^Is_Blk=tags}', "");
Expect(1, 1, '\P{Is_Blk=tags}', "");
Expect(0, 1, '\P{^Is_Blk=tags}', "");
Expect(1, 917631, '\p{Is_Blk=  Tags}', "");
Expect(0, 917631, '\p{^Is_Blk=  Tags}', "");
Expect(0, 917631, '\P{Is_Blk=  Tags}', "");
Expect(1, 917631, '\P{^Is_Blk=  Tags}', "");
Expect(0, 1, '\p{Is_Blk=  Tags}', "");
Expect(1, 1, '\p{^Is_Blk=  Tags}', "");
Expect(1, 1, '\P{Is_Blk=  Tags}', "");
Expect(0, 1, '\P{^Is_Blk=  Tags}', "");
Error('\p{Block=_Miscellaneous-MATHEMATICAL:=SymbolsA}');
Error('\P{Block=_Miscellaneous-MATHEMATICAL:=SymbolsA}');
Expect(1, 10223, '\p{Block=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10223, '\p{^Block=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10223, '\P{Block=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10223, '\P{^Block=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10175, '\p{Block=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10175, '\p{^Block=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10175, '\P{Block=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10175, '\P{^Block=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10223, '\p{Block=-	Miscellaneous-MATHEMATICAL-SYMBOLS	A}', "");
Expect(0, 10223, '\p{^Block=-	Miscellaneous-MATHEMATICAL-SYMBOLS	A}', "");
Expect(0, 10223, '\P{Block=-	Miscellaneous-MATHEMATICAL-SYMBOLS	A}', "");
Expect(1, 10223, '\P{^Block=-	Miscellaneous-MATHEMATICAL-SYMBOLS	A}', "");
Expect(0, 10175, '\p{Block=-	Miscellaneous-MATHEMATICAL-SYMBOLS	A}', "");
Expect(1, 10175, '\p{^Block=-	Miscellaneous-MATHEMATICAL-SYMBOLS	A}', "");
Expect(1, 10175, '\P{Block=-	Miscellaneous-MATHEMATICAL-SYMBOLS	A}', "");
Expect(0, 10175, '\P{^Block=-	Miscellaneous-MATHEMATICAL-SYMBOLS	A}', "");
Error('\p{Blk=  Miscellaneous_mathematical Symbols:=A}');
Error('\P{Blk=  Miscellaneous_mathematical Symbols:=A}');
Expect(1, 10223, '\p{Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10223, '\p{^Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10223, '\P{Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10223, '\P{^Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10175, '\p{Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10175, '\p{^Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10175, '\P{Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10175, '\P{^Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10223, '\p{Blk=	 miscellaneous	mathematical-symbols_A}', "");
Expect(0, 10223, '\p{^Blk=	 miscellaneous	mathematical-symbols_A}', "");
Expect(0, 10223, '\P{Blk=	 miscellaneous	mathematical-symbols_A}', "");
Expect(1, 10223, '\P{^Blk=	 miscellaneous	mathematical-symbols_A}', "");
Expect(0, 10175, '\p{Blk=	 miscellaneous	mathematical-symbols_A}', "");
Expect(1, 10175, '\p{^Blk=	 miscellaneous	mathematical-symbols_A}', "");
Expect(1, 10175, '\P{Blk=	 miscellaneous	mathematical-symbols_A}', "");
Expect(0, 10175, '\P{^Blk=	 miscellaneous	mathematical-symbols_A}', "");
Error('\p{Is_Block= MISCELLANEOUS_MATHEMATICAL_symbols	A/a/}');
Error('\P{Is_Block= MISCELLANEOUS_MATHEMATICAL_symbols	A/a/}');
Expect(1, 10223, '\p{Is_Block=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10223, '\p{^Is_Block=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10223, '\P{Is_Block=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10223, '\P{^Is_Block=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10175, '\p{Is_Block=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10175, '\p{^Is_Block=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10175, '\P{Is_Block=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10175, '\P{^Is_Block=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10223, '\p{Is_Block: 		miscellaneous_MathematicalSymbols a}', "");
Expect(0, 10223, '\p{^Is_Block: 		miscellaneous_MathematicalSymbols a}', "");
Expect(0, 10223, '\P{Is_Block: 		miscellaneous_MathematicalSymbols a}', "");
Expect(1, 10223, '\P{^Is_Block: 		miscellaneous_MathematicalSymbols a}', "");
Expect(0, 10175, '\p{Is_Block: 		miscellaneous_MathematicalSymbols a}', "");
Expect(1, 10175, '\p{^Is_Block: 		miscellaneous_MathematicalSymbols a}', "");
Expect(1, 10175, '\P{Is_Block: 		miscellaneous_MathematicalSymbols a}', "");
Expect(0, 10175, '\P{^Is_Block: 		miscellaneous_MathematicalSymbols a}', "");
Error('\p{Is_Blk= -MISCELLANEOUS/a/MathematicalSymbols A}');
Error('\P{Is_Blk= -MISCELLANEOUS/a/MathematicalSymbols A}');
Expect(1, 10223, '\p{Is_Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10223, '\p{^Is_Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10223, '\P{Is_Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10223, '\P{^Is_Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10175, '\p{Is_Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10175, '\p{^Is_Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10175, '\P{Is_Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(0, 10175, '\P{^Is_Blk=miscellaneousmathematicalsymbolsa}', "");
Expect(1, 10223, '\p{Is_Blk=-miscellaneousMathematical_symbols-a}', "");
Expect(0, 10223, '\p{^Is_Blk=-miscellaneousMathematical_symbols-a}', "");
Expect(0, 10223, '\P{Is_Blk=-miscellaneousMathematical_symbols-a}', "");
Expect(1, 10223, '\P{^Is_Blk=-miscellaneousMathematical_symbols-a}', "");
Expect(0, 10175, '\p{Is_Blk=-miscellaneousMathematical_symbols-a}', "");
Expect(1, 10175, '\p{^Is_Blk=-miscellaneousMathematical_symbols-a}', "");
Expect(1, 10175, '\P{Is_Blk=-miscellaneousMathematical_symbols-a}', "");
Expect(0, 10175, '\P{^Is_Blk=-miscellaneousMathematical_symbols-a}', "");
Error('\p{Block=:=-braillepatterns}');
Error('\P{Block=:=-braillepatterns}');
Expect(1, 10495, '\p{Block=braillepatterns}', "");
Expect(0, 10495, '\p{^Block=braillepatterns}', "");
Expect(0, 10495, '\P{Block=braillepatterns}', "");
Expect(1, 10495, '\P{^Block=braillepatterns}', "");
Expect(0, 10239, '\p{Block=braillepatterns}', "");
Expect(1, 10239, '\p{^Block=braillepatterns}', "");
Expect(1, 10239, '\P{Block=braillepatterns}', "");
Expect(0, 10239, '\P{^Block=braillepatterns}', "");
Expect(1, 10495, '\p{Block= _Braillepatterns}', "");
Expect(0, 10495, '\p{^Block= _Braillepatterns}', "");
Expect(0, 10495, '\P{Block= _Braillepatterns}', "");
Expect(1, 10495, '\P{^Block= _Braillepatterns}', "");
Expect(0, 10239, '\p{Block= _Braillepatterns}', "");
Expect(1, 10239, '\p{^Block= _Braillepatterns}', "");
Expect(1, 10239, '\P{Block= _Braillepatterns}', "");
Expect(0, 10239, '\P{^Block= _Braillepatterns}', "");
Error('\p{Blk=:=	BRAILLE	PATTERNS}');
Error('\P{Blk=:=	BRAILLE	PATTERNS}');
Expect(1, 10495, '\p{Blk=braillepatterns}', "");
Expect(0, 10495, '\p{^Blk=braillepatterns}', "");
Expect(0, 10495, '\P{Blk=braillepatterns}', "");
Expect(1, 10495, '\P{^Blk=braillepatterns}', "");
Expect(0, 10239, '\p{Blk=braillepatterns}', "");
Expect(1, 10239, '\p{^Blk=braillepatterns}', "");
Expect(1, 10239, '\P{Blk=braillepatterns}', "");
Expect(0, 10239, '\P{^Blk=braillepatterns}', "");
Expect(1, 10495, '\p{Blk= Braillepatterns}', "");
Expect(0, 10495, '\p{^Blk= Braillepatterns}', "");
Expect(0, 10495, '\P{Blk= Braillepatterns}', "");
Expect(1, 10495, '\P{^Blk= Braillepatterns}', "");
Expect(0, 10239, '\p{Blk= Braillepatterns}', "");
Expect(1, 10239, '\p{^Blk= Braillepatterns}', "");
Expect(1, 10239, '\P{Blk= Braillepatterns}', "");
Expect(0, 10239, '\P{^Blk= Braillepatterns}', "");
Error('\p{Is_Block= 	braille:=Patterns}');
Error('\P{Is_Block= 	braille:=Patterns}');
Expect(1, 10495, '\p{Is_Block=braillepatterns}', "");
Expect(0, 10495, '\p{^Is_Block=braillepatterns}', "");
Expect(0, 10495, '\P{Is_Block=braillepatterns}', "");
Expect(1, 10495, '\P{^Is_Block=braillepatterns}', "");
Expect(0, 10239, '\p{Is_Block=braillepatterns}', "");
Expect(1, 10239, '\p{^Is_Block=braillepatterns}', "");
Expect(1, 10239, '\P{Is_Block=braillepatterns}', "");
Expect(0, 10239, '\P{^Is_Block=braillepatterns}', "");
Expect(1, 10495, '\p{Is_Block=__BRAILLEPATTERNS}', "");
Expect(0, 10495, '\p{^Is_Block=__BRAILLEPATTERNS}', "");
Expect(0, 10495, '\P{Is_Block=__BRAILLEPATTERNS}', "");
Expect(1, 10495, '\P{^Is_Block=__BRAILLEPATTERNS}', "");
Expect(0, 10239, '\p{Is_Block=__BRAILLEPATTERNS}', "");
Expect(1, 10239, '\p{^Is_Block=__BRAILLEPATTERNS}', "");
Expect(1, 10239, '\P{Is_Block=__BRAILLEPATTERNS}', "");
Expect(0, 10239, '\P{^Is_Block=__BRAILLEPATTERNS}', "");
Error('\p{Is_Blk: :=_Braille Patterns}');
Error('\P{Is_Blk: :=_Braille Patterns}');
Expect(1, 10495, '\p{Is_Blk: braillepatterns}', "");
Expect(0, 10495, '\p{^Is_Blk: braillepatterns}', "");
Expect(0, 10495, '\P{Is_Blk: braillepatterns}', "");
Expect(1, 10495, '\P{^Is_Blk: braillepatterns}', "");
Expect(0, 10239, '\p{Is_Blk: braillepatterns}', "");
Expect(1, 10239, '\p{^Is_Blk: braillepatterns}', "");
Expect(1, 10239, '\P{Is_Blk: braillepatterns}', "");
Expect(0, 10239, '\P{^Is_Blk: braillepatterns}', "");
Expect(1, 10495, '\p{Is_Blk=_ BRAILLEpatterns}', "");
Expect(0, 10495, '\p{^Is_Blk=_ BRAILLEpatterns}', "");
Expect(0, 10495, '\P{Is_Blk=_ BRAILLEpatterns}', "");
Expect(1, 10495, '\P{^Is_Blk=_ BRAILLEpatterns}', "");
Expect(0, 10239, '\p{Is_Blk=_ BRAILLEpatterns}', "");
Expect(1, 10239, '\p{^Is_Blk=_ BRAILLEpatterns}', "");
Expect(1, 10239, '\P{Is_Blk=_ BRAILLEpatterns}', "");
Expect(0, 10239, '\P{^Is_Blk=_ BRAILLEpatterns}', "");
Error('\p{Block=/a/ORIYA}');
Error('\P{Block=/a/ORIYA}');
Expect(1, 2943, '\p{Block=oriya}', "");
Expect(0, 2943, '\p{^Block=oriya}', "");
Expect(0, 2943, '\P{Block=oriya}', "");
Expect(1, 2943, '\P{^Block=oriya}', "");
Expect(0, 2815, '\p{Block=oriya}', "");
Expect(1, 2815, '\p{^Block=oriya}', "");
Expect(1, 2815, '\P{Block=oriya}', "");
Expect(0, 2815, '\P{^Block=oriya}', "");
Expect(1, 2943, '\p{Block=  Oriya}', "");
Expect(0, 2943, '\p{^Block=  Oriya}', "");
Expect(0, 2943, '\P{Block=  Oriya}', "");
Expect(1, 2943, '\P{^Block=  Oriya}', "");
Expect(0, 2815, '\p{Block=  Oriya}', "");
Expect(1, 2815, '\p{^Block=  Oriya}', "");
Expect(1, 2815, '\P{Block=  Oriya}', "");
Expect(0, 2815, '\P{^Block=  Oriya}', "");
Error('\p{Blk=:=--ORIYA}');
Error('\P{Blk=:=--ORIYA}');
Expect(1, 2943, '\p{Blk=oriya}', "");
Expect(0, 2943, '\p{^Blk=oriya}', "");
Expect(0, 2943, '\P{Blk=oriya}', "");
Expect(1, 2943, '\P{^Blk=oriya}', "");
Expect(0, 2815, '\p{Blk=oriya}', "");
Expect(1, 2815, '\p{^Blk=oriya}', "");
Expect(1, 2815, '\P{Blk=oriya}', "");
Expect(0, 2815, '\P{^Blk=oriya}', "");
Expect(1, 2943, '\p{Blk=_-ORIYA}', "");
Expect(0, 2943, '\p{^Blk=_-ORIYA}', "");
Expect(0, 2943, '\P{Blk=_-ORIYA}', "");
Expect(1, 2943, '\P{^Blk=_-ORIYA}', "");
Expect(0, 2815, '\p{Blk=_-ORIYA}', "");
Expect(1, 2815, '\p{^Blk=_-ORIYA}', "");
Expect(1, 2815, '\P{Blk=_-ORIYA}', "");
Expect(0, 2815, '\P{^Blk=_-ORIYA}', "");
Error('\p{Is_Block=/a/	-ORIYA}');
Error('\P{Is_Block=/a/	-ORIYA}');
Expect(1, 2943, '\p{Is_Block=oriya}', "");
Expect(0, 2943, '\p{^Is_Block=oriya}', "");
Expect(0, 2943, '\P{Is_Block=oriya}', "");
Expect(1, 2943, '\P{^Is_Block=oriya}', "");
Expect(0, 2815, '\p{Is_Block=oriya}', "");
Expect(1, 2815, '\p{^Is_Block=oriya}', "");
Expect(1, 2815, '\P{Is_Block=oriya}', "");
Expect(0, 2815, '\P{^Is_Block=oriya}', "");
Expect(1, 2943, '\p{Is_Block= -Oriya}', "");
Expect(0, 2943, '\p{^Is_Block= -Oriya}', "");
Expect(0, 2943, '\P{Is_Block= -Oriya}', "");
Expect(1, 2943, '\P{^Is_Block= -Oriya}', "");
Expect(0, 2815, '\p{Is_Block= -Oriya}', "");
Expect(1, 2815, '\p{^Is_Block= -Oriya}', "");
Expect(1, 2815, '\P{Is_Block= -Oriya}', "");
Expect(0, 2815, '\P{^Is_Block= -Oriya}', "");
Error('\p{Is_Blk=:=_ORIYA}');
Error('\P{Is_Blk=:=_ORIYA}');
Expect(1, 2943, '\p{Is_Blk=oriya}', "");
Expect(0, 2943, '\p{^Is_Blk=oriya}', "");
Expect(0, 2943, '\P{Is_Blk=oriya}', "");
Expect(1, 2943, '\P{^Is_Blk=oriya}', "");
Expect(0, 2815, '\p{Is_Blk=oriya}', "");
Expect(1, 2815, '\p{^Is_Blk=oriya}', "");
Expect(1, 2815, '\P{Is_Blk=oriya}', "");
Expect(0, 2815, '\P{^Is_Blk=oriya}', "");
Expect(1, 2943, '\p{Is_Blk=--oriya}', "");
Expect(0, 2943, '\p{^Is_Blk=--oriya}', "");
Expect(0, 2943, '\P{Is_Blk=--oriya}', "");
Expect(1, 2943, '\P{^Is_Blk=--oriya}', "");
Expect(0, 2815, '\p{Is_Blk=--oriya}', "");
Expect(1, 2815, '\p{^Is_Blk=--oriya}', "");
Expect(1, 2815, '\P{Is_Blk=--oriya}', "");
Expect(0, 2815, '\P{^Is_Blk=--oriya}', "");
Error('\p{Block:_-Linear/a/BIdeograms}');
Error('\P{Block:_-Linear/a/BIdeograms}');
Expect(1, 65791, '\p{Block=linearbideograms}', "");
Expect(0, 65791, '\p{^Block=linearbideograms}', "");
Expect(0, 65791, '\P{Block=linearbideograms}', "");
Expect(1, 65791, '\P{^Block=linearbideograms}', "");
Expect(0, 65663, '\p{Block=linearbideograms}', "");
Expect(1, 65663, '\p{^Block=linearbideograms}', "");
Expect(1, 65663, '\P{Block=linearbideograms}', "");
Expect(0, 65663, '\P{^Block=linearbideograms}', "");
Expect(1, 65791, '\p{Block=-Linear	B_ideograms}', "");
Expect(0, 65791, '\p{^Block=-Linear	B_ideograms}', "");
Expect(0, 65791, '\P{Block=-Linear	B_ideograms}', "");
Expect(1, 65791, '\P{^Block=-Linear	B_ideograms}', "");
Expect(0, 65663, '\p{Block=-Linear	B_ideograms}', "");
Expect(1, 65663, '\p{^Block=-Linear	B_ideograms}', "");
Expect(1, 65663, '\P{Block=-Linear	B_ideograms}', "");
Expect(0, 65663, '\P{^Block=-Linear	B_ideograms}', "");
Error('\p{Blk=_:=Linear-b_Ideograms}');
Error('\P{Blk=_:=Linear-b_Ideograms}');
Expect(1, 65791, '\p{Blk=linearbideograms}', "");
Expect(0, 65791, '\p{^Blk=linearbideograms}', "");
Expect(0, 65791, '\P{Blk=linearbideograms}', "");
Expect(1, 65791, '\P{^Blk=linearbideograms}', "");
Expect(0, 65663, '\p{Blk=linearbideograms}', "");
Expect(1, 65663, '\p{^Blk=linearbideograms}', "");
Expect(1, 65663, '\P{Blk=linearbideograms}', "");
Expect(0, 65663, '\P{^Blk=linearbideograms}', "");
Expect(1, 65791, '\p{Blk=-_LinearB	Ideograms}', "");
Expect(0, 65791, '\p{^Blk=-_LinearB	Ideograms}', "");
Expect(0, 65791, '\P{Blk=-_LinearB	Ideograms}', "");
Expect(1, 65791, '\P{^Blk=-_LinearB	Ideograms}', "");
Expect(0, 65663, '\p{Blk=-_LinearB	Ideograms}', "");
Expect(1, 65663, '\p{^Blk=-_LinearB	Ideograms}', "");
Expect(1, 65663, '\P{Blk=-_LinearB	Ideograms}', "");
Expect(0, 65663, '\P{^Blk=-_LinearB	Ideograms}', "");
Error('\p{Is_Block= /a/linear-B Ideograms}');
Error('\P{Is_Block= /a/linear-B Ideograms}');
Expect(1, 65791, '\p{Is_Block=linearbideograms}', "");
Expect(0, 65791, '\p{^Is_Block=linearbideograms}', "");
Expect(0, 65791, '\P{Is_Block=linearbideograms}', "");
Expect(1, 65791, '\P{^Is_Block=linearbideograms}', "");
Expect(0, 65663, '\p{Is_Block=linearbideograms}', "");
Expect(1, 65663, '\p{^Is_Block=linearbideograms}', "");
Expect(1, 65663, '\P{Is_Block=linearbideograms}', "");
Expect(0, 65663, '\P{^Is_Block=linearbideograms}', "");
Expect(1, 65791, '\p{Is_Block=_-LinearBIDEOGRAMS}', "");
Expect(0, 65791, '\p{^Is_Block=_-LinearBIDEOGRAMS}', "");
Expect(0, 65791, '\P{Is_Block=_-LinearBIDEOGRAMS}', "");
Expect(1, 65791, '\P{^Is_Block=_-LinearBIDEOGRAMS}', "");
Expect(0, 65663, '\p{Is_Block=_-LinearBIDEOGRAMS}', "");
Expect(1, 65663, '\p{^Is_Block=_-LinearBIDEOGRAMS}', "");
Expect(1, 65663, '\P{Is_Block=_-LinearBIDEOGRAMS}', "");
Expect(0, 65663, '\P{^Is_Block=_-LinearBIDEOGRAMS}', "");
Error('\p{Is_Blk=  Linear_B:=Ideograms}');
Error('\P{Is_Blk=  Linear_B:=Ideograms}');
Expect(1, 65791, '\p{Is_Blk=linearbideograms}', "");
Expect(0, 65791, '\p{^Is_Blk=linearbideograms}', "");
Expect(0, 65791, '\P{Is_Blk=linearbideograms}', "");
Expect(1, 65791, '\P{^Is_Blk=linearbideograms}', "");
Expect(0, 65663, '\p{Is_Blk=linearbideograms}', "");
Expect(1, 65663, '\p{^Is_Blk=linearbideograms}', "");
Expect(1, 65663, '\P{Is_Blk=linearbideograms}', "");
Expect(0, 65663, '\P{^Is_Blk=linearbideograms}', "");
Expect(1, 65791, '\p{Is_Blk:   _Linear-BIdeograms}', "");
Expect(0, 65791, '\p{^Is_Blk:   _Linear-BIdeograms}', "");
Expect(0, 65791, '\P{Is_Blk:   _Linear-BIdeograms}', "");
Expect(1, 65791, '\P{^Is_Blk:   _Linear-BIdeograms}', "");
Expect(0, 65663, '\p{Is_Blk:   _Linear-BIdeograms}', "");
Expect(1, 65663, '\p{^Is_Blk:   _Linear-BIdeograms}', "");
Expect(1, 65663, '\P{Is_Blk:   _Linear-BIdeograms}', "");
Expect(0, 65663, '\P{^Is_Blk:   _Linear-BIdeograms}', "");
Error('\p{Block:   -	Cherokee/a/}');
Error('\P{Block:   -	Cherokee/a/}');
Expect(1, 5119, '\p{Block=cherokee}', "");
Expect(0, 5119, '\p{^Block=cherokee}', "");
Expect(0, 5119, '\P{Block=cherokee}', "");
Expect(1, 5119, '\P{^Block=cherokee}', "");
Expect(0, 5023, '\p{Block=cherokee}', "");
Expect(1, 5023, '\p{^Block=cherokee}', "");
Expect(1, 5023, '\P{Block=cherokee}', "");
Expect(0, 5023, '\P{^Block=cherokee}', "");
Expect(1, 5119, '\p{Block=-	Cherokee}', "");
Expect(0, 5119, '\p{^Block=-	Cherokee}', "");
Expect(0, 5119, '\P{Block=-	Cherokee}', "");
Expect(1, 5119, '\P{^Block=-	Cherokee}', "");
Expect(0, 5023, '\p{Block=-	Cherokee}', "");
Expect(1, 5023, '\p{^Block=-	Cherokee}', "");
Expect(1, 5023, '\P{Block=-	Cherokee}', "");
Expect(0, 5023, '\P{^Block=-	Cherokee}', "");
Error('\p{Blk=:=_-Cherokee}');
Error('\P{Blk=:=_-Cherokee}');
Expect(1, 5119, '\p{Blk=cherokee}', "");
Expect(0, 5119, '\p{^Blk=cherokee}', "");
Expect(0, 5119, '\P{Blk=cherokee}', "");
Expect(1, 5119, '\P{^Blk=cherokee}', "");
Expect(0, 5023, '\p{Blk=cherokee}', "");
Expect(1, 5023, '\p{^Blk=cherokee}', "");
Expect(1, 5023, '\P{Blk=cherokee}', "");
Expect(0, 5023, '\P{^Blk=cherokee}', "");
Expect(1, 5119, '\p{Blk=-Cherokee}', "");
Expect(0, 5119, '\p{^Blk=-Cherokee}', "");
Expect(0, 5119, '\P{Blk=-Cherokee}', "");
Expect(1, 5119, '\P{^Blk=-Cherokee}', "");
Expect(0, 5023, '\p{Blk=-Cherokee}', "");
Expect(1, 5023, '\p{^Blk=-Cherokee}', "");
Expect(1, 5023, '\P{Blk=-Cherokee}', "");
Expect(0, 5023, '\P{^Blk=-Cherokee}', "");
Error('\p{Is_Block:   /a/  Cherokee}');
Error('\P{Is_Block:   /a/  Cherokee}');
Expect(1, 5119, '\p{Is_Block=cherokee}', "");
Expect(0, 5119, '\p{^Is_Block=cherokee}', "");
Expect(0, 5119, '\P{Is_Block=cherokee}', "");
Expect(1, 5119, '\P{^Is_Block=cherokee}', "");
Expect(0, 5023, '\p{Is_Block=cherokee}', "");
Expect(1, 5023, '\p{^Is_Block=cherokee}', "");
Expect(1, 5023, '\P{Is_Block=cherokee}', "");
Expect(0, 5023, '\P{^Is_Block=cherokee}', "");
Expect(1, 5119, '\p{Is_Block=Cherokee}', "");
Expect(0, 5119, '\p{^Is_Block=Cherokee}', "");
Expect(0, 5119, '\P{Is_Block=Cherokee}', "");
Expect(1, 5119, '\P{^Is_Block=Cherokee}', "");
Expect(0, 5023, '\p{Is_Block=Cherokee}', "");
Expect(1, 5023, '\p{^Is_Block=Cherokee}', "");
Expect(1, 5023, '\P{Is_Block=Cherokee}', "");
Expect(0, 5023, '\P{^Is_Block=Cherokee}', "");
Error('\p{Is_Blk= /a/Cherokee}');
Error('\P{Is_Blk= /a/Cherokee}');
Expect(1, 5119, '\p{Is_Blk=cherokee}', "");
Expect(0, 5119, '\p{^Is_Blk=cherokee}', "");
Expect(0, 5119, '\P{Is_Blk=cherokee}', "");
Expect(1, 5119, '\P{^Is_Blk=cherokee}', "");
Expect(0, 5023, '\p{Is_Blk=cherokee}', "");
Expect(1, 5023, '\p{^Is_Blk=cherokee}', "");
Expect(1, 5023, '\P{Is_Blk=cherokee}', "");
Expect(0, 5023, '\P{^Is_Blk=cherokee}', "");
Expect(1, 5119, '\p{Is_Blk=-_Cherokee}', "");
Expect(0, 5119, '\p{^Is_Blk=-_Cherokee}', "");
Expect(0, 5119, '\P{Is_Blk=-_Cherokee}', "");
Expect(1, 5119, '\P{^Is_Blk=-_Cherokee}', "");
Expect(0, 5023, '\p{Is_Blk=-_Cherokee}', "");
Expect(1, 5023, '\p{^Is_Blk=-_Cherokee}', "");
Expect(1, 5023, '\P{Is_Blk=-_Cherokee}', "");
Expect(0, 5023, '\P{^Is_Blk=-_Cherokee}', "");
Error('\p{Block=		Bopomofo:=Extended}');
Error('\P{Block=		Bopomofo:=Extended}');
Expect(1, 12735, '\p{Block=bopomofoextended}', "");
Expect(0, 12735, '\p{^Block=bopomofoextended}', "");
Expect(0, 12735, '\P{Block=bopomofoextended}', "");
Expect(1, 12735, '\P{^Block=bopomofoextended}', "");
Expect(0, 12703, '\p{Block=bopomofoextended}', "");
Expect(1, 12703, '\p{^Block=bopomofoextended}', "");
Expect(1, 12703, '\P{Block=bopomofoextended}', "");
Expect(0, 12703, '\P{^Block=bopomofoextended}', "");
Expect(1, 12735, '\p{Block=_-bopomofo Extended}', "");
Expect(0, 12735, '\p{^Block=_-bopomofo Extended}', "");
Expect(0, 12735, '\P{Block=_-bopomofo Extended}', "");
Expect(1, 12735, '\P{^Block=_-bopomofo Extended}', "");
Expect(0, 12703, '\p{Block=_-bopomofo Extended}', "");
Expect(1, 12703, '\p{^Block=_-bopomofo Extended}', "");
Expect(1, 12703, '\P{Block=_-bopomofo Extended}', "");
Expect(0, 12703, '\P{^Block=_-bopomofo Extended}', "");
Error('\p{Blk:	:=BOPOMOFO_Extended}');
Error('\P{Blk:	:=BOPOMOFO_Extended}');
Expect(1, 12735, '\p{Blk:   bopomofoextended}', "");
Expect(0, 12735, '\p{^Blk:   bopomofoextended}', "");
Expect(0, 12735, '\P{Blk:   bopomofoextended}', "");
Expect(1, 12735, '\P{^Blk:   bopomofoextended}', "");
Expect(0, 12703, '\p{Blk:   bopomofoextended}', "");
Expect(1, 12703, '\p{^Blk:   bopomofoextended}', "");
Expect(1, 12703, '\P{Blk:   bopomofoextended}', "");
Expect(0, 12703, '\P{^Blk:   bopomofoextended}', "");
Expect(1, 12735, '\p{Blk= BopomofoExtended}', "");
Expect(0, 12735, '\p{^Blk= BopomofoExtended}', "");
Expect(0, 12735, '\P{Blk= BopomofoExtended}', "");
Expect(1, 12735, '\P{^Blk= BopomofoExtended}', "");
Expect(0, 12703, '\p{Blk= BopomofoExtended}', "");
Expect(1, 12703, '\p{^Blk= BopomofoExtended}', "");
Expect(1, 12703, '\P{Blk= BopomofoExtended}', "");
Expect(0, 12703, '\P{^Blk= BopomofoExtended}', "");
Error('\p{Is_Block=-:=Bopomofo	Extended}');
Error('\P{Is_Block=-:=Bopomofo	Extended}');
Expect(1, 12735, '\p{Is_Block=bopomofoextended}', "");
Expect(0, 12735, '\p{^Is_Block=bopomofoextended}', "");
Expect(0, 12735, '\P{Is_Block=bopomofoextended}', "");
Expect(1, 12735, '\P{^Is_Block=bopomofoextended}', "");
Expect(0, 12703, '\p{Is_Block=bopomofoextended}', "");
Expect(1, 12703, '\p{^Is_Block=bopomofoextended}', "");
Expect(1, 12703, '\P{Is_Block=bopomofoextended}', "");
Expect(0, 12703, '\P{^Is_Block=bopomofoextended}', "");
Expect(1, 12735, '\p{Is_Block=__Bopomofo extended}', "");
Expect(0, 12735, '\p{^Is_Block=__Bopomofo extended}', "");
Expect(0, 12735, '\P{Is_Block=__Bopomofo extended}', "");
Expect(1, 12735, '\P{^Is_Block=__Bopomofo extended}', "");
Expect(0, 12703, '\p{Is_Block=__Bopomofo extended}', "");
Expect(1, 12703, '\p{^Is_Block=__Bopomofo extended}', "");
Expect(1, 12703, '\P{Is_Block=__Bopomofo extended}', "");
Expect(0, 12703, '\P{^Is_Block=__Bopomofo extended}', "");
Error('\p{Is_Blk=_	Bopomofo-EXTENDED:=}');
Error('\P{Is_Blk=_	Bopomofo-EXTENDED:=}');
Expect(1, 12735, '\p{Is_Blk=bopomofoextended}', "");
Expect(0, 12735, '\p{^Is_Blk=bopomofoextended}', "");
Expect(0, 12735, '\P{Is_Blk=bopomofoextended}', "");
Expect(1, 12735, '\P{^Is_Blk=bopomofoextended}', "");
Expect(0, 12703, '\p{Is_Blk=bopomofoextended}', "");
Expect(1, 12703, '\p{^Is_Blk=bopomofoextended}', "");
Expect(1, 12703, '\P{Is_Blk=bopomofoextended}', "");
Expect(0, 12703, '\P{^Is_Blk=bopomofoextended}', "");
Expect(1, 12735, '\p{Is_Blk=	 Bopomofo EXTENDED}', "");
Expect(0, 12735, '\p{^Is_Blk=	 Bopomofo EXTENDED}', "");
Expect(0, 12735, '\P{Is_Blk=	 Bopomofo EXTENDED}', "");
Expect(1, 12735, '\P{^Is_Blk=	 Bopomofo EXTENDED}', "");
Expect(0, 12703, '\p{Is_Blk=	 Bopomofo EXTENDED}', "");
Expect(1, 12703, '\p{^Is_Blk=	 Bopomofo EXTENDED}', "");
Expect(1, 12703, '\P{Is_Blk=	 Bopomofo EXTENDED}', "");
Expect(0, 12703, '\P{^Is_Blk=	 Bopomofo EXTENDED}', "");
Error('\p{Block=  OGHAM/a/}');
Error('\P{Block=  OGHAM/a/}');
Expect(1, 5791, '\p{Block=ogham}', "");
Expect(0, 5791, '\p{^Block=ogham}', "");
Expect(0, 5791, '\P{Block=ogham}', "");
Expect(1, 5791, '\P{^Block=ogham}', "");
Expect(0, 5759, '\p{Block=ogham}', "");
Expect(1, 5759, '\p{^Block=ogham}', "");
Expect(1, 5759, '\P{Block=ogham}', "");
Expect(0, 5759, '\P{^Block=ogham}', "");
Expect(1, 5791, '\p{Block=	-ogham}', "");
Expect(0, 5791, '\p{^Block=	-ogham}', "");
Expect(0, 5791, '\P{Block=	-ogham}', "");
Expect(1, 5791, '\P{^Block=	-ogham}', "");
Expect(0, 5759, '\p{Block=	-ogham}', "");
Expect(1, 5759, '\p{^Block=	-ogham}', "");
Expect(1, 5759, '\P{Block=	-ogham}', "");
Expect(0, 5759, '\P{^Block=	-ogham}', "");
Error('\p{Blk: :=	_Ogham}');
Error('\P{Blk: :=	_Ogham}');
Expect(1, 5791, '\p{Blk=ogham}', "");
Expect(0, 5791, '\p{^Blk=ogham}', "");
Expect(0, 5791, '\P{Blk=ogham}', "");
Expect(1, 5791, '\P{^Blk=ogham}', "");
Expect(0, 5759, '\p{Blk=ogham}', "");
Expect(1, 5759, '\p{^Blk=ogham}', "");
Expect(1, 5759, '\P{Blk=ogham}', "");
Expect(0, 5759, '\P{^Blk=ogham}', "");
Expect(1, 5791, '\p{Blk=-ogham}', "");
Expect(0, 5791, '\p{^Blk=-ogham}', "");
Expect(0, 5791, '\P{Blk=-ogham}', "");
Expect(1, 5791, '\P{^Blk=-ogham}', "");
Expect(0, 5759, '\p{Blk=-ogham}', "");
Expect(1, 5759, '\p{^Blk=-ogham}', "");
Expect(1, 5759, '\P{Blk=-ogham}', "");
Expect(0, 5759, '\P{^Blk=-ogham}', "");
Error('\p{Is_Block=:= ogham}');
Error('\P{Is_Block=:= ogham}');
Expect(1, 5791, '\p{Is_Block=ogham}', "");
Expect(0, 5791, '\p{^Is_Block=ogham}', "");
Expect(0, 5791, '\P{Is_Block=ogham}', "");
Expect(1, 5791, '\P{^Is_Block=ogham}', "");
Expect(0, 5759, '\p{Is_Block=ogham}', "");
Expect(1, 5759, '\p{^Is_Block=ogham}', "");
Expect(1, 5759, '\P{Is_Block=ogham}', "");
Expect(0, 5759, '\P{^Is_Block=ogham}', "");
Expect(1, 5791, '\p{Is_Block= Ogham}', "");
Expect(0, 5791, '\p{^Is_Block= Ogham}', "");
Expect(0, 5791, '\P{Is_Block= Ogham}', "");
Expect(1, 5791, '\P{^Is_Block= Ogham}', "");
Expect(0, 5759, '\p{Is_Block= Ogham}', "");
Expect(1, 5759, '\p{^Is_Block= Ogham}', "");
Expect(1, 5759, '\P{Is_Block= Ogham}', "");
Expect(0, 5759, '\P{^Is_Block= Ogham}', "");
Error('\p{Is_Blk=:=Ogham}');
Error('\P{Is_Blk=:=Ogham}');
Expect(1, 5791, '\p{Is_Blk=ogham}', "");
Expect(0, 5791, '\p{^Is_Blk=ogham}', "");
Expect(0, 5791, '\P{Is_Blk=ogham}', "");
Expect(1, 5791, '\P{^Is_Blk=ogham}', "");
Expect(0, 5759, '\p{Is_Blk=ogham}', "");
Expect(1, 5759, '\p{^Is_Blk=ogham}', "");
Expect(1, 5759, '\P{Is_Blk=ogham}', "");
Expect(0, 5759, '\P{^Is_Blk=ogham}', "");
Expect(1, 5791, '\p{Is_Blk=-Ogham}', "");
Expect(0, 5791, '\p{^Is_Blk=-Ogham}', "");
Expect(0, 5791, '\P{Is_Blk=-Ogham}', "");
Expect(1, 5791, '\P{^Is_Blk=-Ogham}', "");
Expect(0, 5759, '\p{Is_Blk=-Ogham}', "");
Expect(1, 5759, '\p{^Is_Blk=-Ogham}', "");
Expect(1, 5759, '\P{Is_Blk=-Ogham}', "");
Expect(0, 5759, '\P{^Is_Blk=-Ogham}', "");
Error('\p{Block=:=_-samaritan}');
Error('\P{Block=:=_-samaritan}');
Expect(1, 2111, '\p{Block=samaritan}', "");
Expect(0, 2111, '\p{^Block=samaritan}', "");
Expect(0, 2111, '\P{Block=samaritan}', "");
Expect(1, 2111, '\P{^Block=samaritan}', "");
Expect(0, 2047, '\p{Block=samaritan}', "");
Expect(1, 2047, '\p{^Block=samaritan}', "");
Expect(1, 2047, '\P{Block=samaritan}', "");
Expect(0, 2047, '\P{^Block=samaritan}', "");
Expect(1, 2111, '\p{Block= _Samaritan}', "");
Expect(0, 2111, '\p{^Block= _Samaritan}', "");
Expect(0, 2111, '\P{Block= _Samaritan}', "");
Expect(1, 2111, '\P{^Block= _Samaritan}', "");
Expect(0, 2047, '\p{Block= _Samaritan}', "");
Expect(1, 2047, '\p{^Block= _Samaritan}', "");
Expect(1, 2047, '\P{Block= _Samaritan}', "");
Expect(0, 2047, '\P{^Block= _Samaritan}', "");
Error('\p{Blk=_Samaritan:=}');
Error('\P{Blk=_Samaritan:=}');
Expect(1, 2111, '\p{Blk=samaritan}', "");
Expect(0, 2111, '\p{^Blk=samaritan}', "");
Expect(0, 2111, '\P{Blk=samaritan}', "");
Expect(1, 2111, '\P{^Blk=samaritan}', "");
Expect(0, 2047, '\p{Blk=samaritan}', "");
Expect(1, 2047, '\p{^Blk=samaritan}', "");
Expect(1, 2047, '\P{Blk=samaritan}', "");
Expect(0, 2047, '\P{^Blk=samaritan}', "");
Expect(1, 2111, '\p{Blk:	-Samaritan}', "");
Expect(0, 2111, '\p{^Blk:	-Samaritan}', "");
Expect(0, 2111, '\P{Blk:	-Samaritan}', "");
Expect(1, 2111, '\P{^Blk:	-Samaritan}', "");
Expect(0, 2047, '\p{Blk:	-Samaritan}', "");
Expect(1, 2047, '\p{^Blk:	-Samaritan}', "");
Expect(1, 2047, '\P{Blk:	-Samaritan}', "");
Expect(0, 2047, '\P{^Blk:	-Samaritan}', "");
Error('\p{Is_Block=	_Samaritan/a/}');
Error('\P{Is_Block=	_Samaritan/a/}');
Expect(1, 2111, '\p{Is_Block=samaritan}', "");
Expect(0, 2111, '\p{^Is_Block=samaritan}', "");
Expect(0, 2111, '\P{Is_Block=samaritan}', "");
Expect(1, 2111, '\P{^Is_Block=samaritan}', "");
Expect(0, 2047, '\p{Is_Block=samaritan}', "");
Expect(1, 2047, '\p{^Is_Block=samaritan}', "");
Expect(1, 2047, '\P{Is_Block=samaritan}', "");
Expect(0, 2047, '\P{^Is_Block=samaritan}', "");
Expect(1, 2111, '\p{Is_Block=--Samaritan}', "");
Expect(0, 2111, '\p{^Is_Block=--Samaritan}', "");
Expect(0, 2111, '\P{Is_Block=--Samaritan}', "");
Expect(1, 2111, '\P{^Is_Block=--Samaritan}', "");
Expect(0, 2047, '\p{Is_Block=--Samaritan}', "");
Expect(1, 2047, '\p{^Is_Block=--Samaritan}', "");
Expect(1, 2047, '\P{Is_Block=--Samaritan}', "");
Expect(0, 2047, '\P{^Is_Block=--Samaritan}', "");
Error('\p{Is_Blk=:=Samaritan}');
Error('\P{Is_Blk=:=Samaritan}');
Expect(1, 2111, '\p{Is_Blk=samaritan}', "");
Expect(0, 2111, '\p{^Is_Blk=samaritan}', "");
Expect(0, 2111, '\P{Is_Blk=samaritan}', "");
Expect(1, 2111, '\P{^Is_Blk=samaritan}', "");
Expect(0, 2047, '\p{Is_Blk=samaritan}', "");
Expect(1, 2047, '\p{^Is_Blk=samaritan}', "");
Expect(1, 2047, '\P{Is_Blk=samaritan}', "");
Expect(0, 2047, '\P{^Is_Blk=samaritan}', "");
Expect(1, 2111, '\p{Is_Blk= 	samaritan}', "");
Expect(0, 2111, '\p{^Is_Blk= 	samaritan}', "");
Expect(0, 2111, '\P{Is_Blk= 	samaritan}', "");
Expect(1, 2111, '\P{^Is_Blk= 	samaritan}', "");
Expect(0, 2047, '\p{Is_Blk= 	samaritan}', "");
Expect(1, 2047, '\p{^Is_Blk= 	samaritan}', "");
Expect(1, 2047, '\P{Is_Blk= 	samaritan}', "");
Expect(0, 2047, '\P{^Is_Blk= 	samaritan}', "");
Error('\p{Block=:=_ VAI}');
Error('\P{Block=:=_ VAI}');
Expect(1, 42559, '\p{Block=vai}', "");
Expect(0, 42559, '\p{^Block=vai}', "");
Expect(0, 42559, '\P{Block=vai}', "");
Expect(1, 42559, '\P{^Block=vai}', "");
Expect(0, 42239, '\p{Block=vai}', "");
Expect(1, 42239, '\p{^Block=vai}', "");
Expect(1, 42239, '\P{Block=vai}', "");
Expect(0, 42239, '\P{^Block=vai}', "");
Expect(1, 42559, '\p{Block=-vai}', "");
Expect(0, 42559, '\p{^Block=-vai}', "");
Expect(0, 42559, '\P{Block=-vai}', "");
Expect(1, 42559, '\P{^Block=-vai}', "");
Expect(0, 42239, '\p{Block=-vai}', "");
Expect(1, 42239, '\p{^Block=-vai}', "");
Expect(1, 42239, '\P{Block=-vai}', "");
Expect(0, 42239, '\P{^Block=-vai}', "");
Error('\p{Blk=/a/- VAI}');
Error('\P{Blk=/a/- VAI}');
Expect(1, 42559, '\p{Blk=vai}', "");
Expect(0, 42559, '\p{^Blk=vai}', "");
Expect(0, 42559, '\P{Blk=vai}', "");
Expect(1, 42559, '\P{^Blk=vai}', "");
Expect(0, 42239, '\p{Blk=vai}', "");
Expect(1, 42239, '\p{^Blk=vai}', "");
Expect(1, 42239, '\P{Blk=vai}', "");
Expect(0, 42239, '\P{^Blk=vai}', "");
Expect(1, 42559, '\p{Blk=		Vai}', "");
Expect(0, 42559, '\p{^Blk=		Vai}', "");
Expect(0, 42559, '\P{Blk=		Vai}', "");
Expect(1, 42559, '\P{^Blk=		Vai}', "");
Expect(0, 42239, '\p{Blk=		Vai}', "");
Expect(1, 42239, '\p{^Blk=		Vai}', "");
Expect(1, 42239, '\P{Blk=		Vai}', "");
Expect(0, 42239, '\P{^Blk=		Vai}', "");
Error('\p{Is_Block=-	VAI:=}');
Error('\P{Is_Block=-	VAI:=}');
Expect(1, 42559, '\p{Is_Block=vai}', "");
Expect(0, 42559, '\p{^Is_Block=vai}', "");
Expect(0, 42559, '\P{Is_Block=vai}', "");
Expect(1, 42559, '\P{^Is_Block=vai}', "");
Expect(0, 42239, '\p{Is_Block=vai}', "");
Expect(1, 42239, '\p{^Is_Block=vai}', "");
Expect(1, 42239, '\P{Is_Block=vai}', "");
Expect(0, 42239, '\P{^Is_Block=vai}', "");
Expect(1, 42559, '\p{Is_Block=	 Vai}', "");
Expect(0, 42559, '\p{^Is_Block=	 Vai}', "");
Expect(0, 42559, '\P{Is_Block=	 Vai}', "");
Expect(1, 42559, '\P{^Is_Block=	 Vai}', "");
Expect(0, 42239, '\p{Is_Block=	 Vai}', "");
Expect(1, 42239, '\p{^Is_Block=	 Vai}', "");
Expect(1, 42239, '\P{Is_Block=	 Vai}', "");
Expect(0, 42239, '\P{^Is_Block=	 Vai}', "");
Error('\p{Is_Blk:   _/a/VAI}');
Error('\P{Is_Blk:   _/a/VAI}');
Expect(1, 42559, '\p{Is_Blk:	vai}', "");
Expect(0, 42559, '\p{^Is_Blk:	vai}', "");
Expect(0, 42559, '\P{Is_Blk:	vai}', "");
Expect(1, 42559, '\P{^Is_Blk:	vai}', "");
Expect(0, 42239, '\p{Is_Blk:	vai}', "");
Expect(1, 42239, '\p{^Is_Blk:	vai}', "");
Expect(1, 42239, '\P{Is_Blk:	vai}', "");
Expect(0, 42239, '\P{^Is_Blk:	vai}', "");
Expect(1, 42559, '\p{Is_Blk=	vai}', "");
Expect(0, 42559, '\p{^Is_Blk=	vai}', "");
Expect(0, 42559, '\P{Is_Blk=	vai}', "");
Expect(1, 42559, '\P{^Is_Blk=	vai}', "");
Expect(0, 42239, '\p{Is_Blk=	vai}', "");
Expect(1, 42239, '\p{^Is_Blk=	vai}', "");
Expect(1, 42239, '\P{Is_Blk=	vai}', "");
Expect(0, 42239, '\P{^Is_Blk=	vai}', "");
Error('\p{Block=	General:=Punctuation}');
Error('\P{Block=	General:=Punctuation}');
Expect(1, 8303, '\p{Block:	generalpunctuation}', "");
Expect(0, 8303, '\p{^Block:	generalpunctuation}', "");
Expect(0, 8303, '\P{Block:	generalpunctuation}', "");
Expect(1, 8303, '\P{^Block:	generalpunctuation}', "");
Expect(0, 8191, '\p{Block:	generalpunctuation}', "");
Expect(1, 8191, '\p{^Block:	generalpunctuation}', "");
Expect(1, 8191, '\P{Block:	generalpunctuation}', "");
Expect(0, 8191, '\P{^Block:	generalpunctuation}', "");
Expect(1, 8303, '\p{Block=_	GENERALPunctuation}', "");
Expect(0, 8303, '\p{^Block=_	GENERALPunctuation}', "");
Expect(0, 8303, '\P{Block=_	GENERALPunctuation}', "");
Expect(1, 8303, '\P{^Block=_	GENERALPunctuation}', "");
Expect(0, 8191, '\p{Block=_	GENERALPunctuation}', "");
Expect(1, 8191, '\p{^Block=_	GENERALPunctuation}', "");
Expect(1, 8191, '\P{Block=_	GENERALPunctuation}', "");
Expect(0, 8191, '\P{^Block=_	GENERALPunctuation}', "");
Error('\p{Blk= :=GENERAL PUNCTUATION}');
Error('\P{Blk= :=GENERAL PUNCTUATION}');
Expect(1, 8303, '\p{Blk:   generalpunctuation}', "");
Expect(0, 8303, '\p{^Blk:   generalpunctuation}', "");
Expect(0, 8303, '\P{Blk:   generalpunctuation}', "");
Expect(1, 8303, '\P{^Blk:   generalpunctuation}', "");
Expect(0, 8191, '\p{Blk:   generalpunctuation}', "");
Expect(1, 8191, '\p{^Blk:   generalpunctuation}', "");
Expect(1, 8191, '\P{Blk:   generalpunctuation}', "");
Expect(0, 8191, '\P{^Blk:   generalpunctuation}', "");
Expect(1, 8303, '\p{Blk= _general Punctuation}', "");
Expect(0, 8303, '\p{^Blk= _general Punctuation}', "");
Expect(0, 8303, '\P{Blk= _general Punctuation}', "");
Expect(1, 8303, '\P{^Blk= _general Punctuation}', "");
Expect(0, 8191, '\p{Blk= _general Punctuation}', "");
Expect(1, 8191, '\p{^Blk= _general Punctuation}', "");
Expect(1, 8191, '\P{Blk= _general Punctuation}', "");
Expect(0, 8191, '\P{^Blk= _general Punctuation}', "");
Error('\p{Is_Block:   GeneralPunctuation/a/}');
Error('\P{Is_Block:   GeneralPunctuation/a/}');
Expect(1, 8303, '\p{Is_Block=generalpunctuation}', "");
Expect(0, 8303, '\p{^Is_Block=generalpunctuation}', "");
Expect(0, 8303, '\P{Is_Block=generalpunctuation}', "");
Expect(1, 8303, '\P{^Is_Block=generalpunctuation}', "");
Expect(0, 8191, '\p{Is_Block=generalpunctuation}', "");
Expect(1, 8191, '\p{^Is_Block=generalpunctuation}', "");
Expect(1, 8191, '\P{Is_Block=generalpunctuation}', "");
Expect(0, 8191, '\P{^Is_Block=generalpunctuation}', "");
Expect(1, 8303, '\p{Is_Block=-_General_Punctuation}', "");
Expect(0, 8303, '\p{^Is_Block=-_General_Punctuation}', "");
Expect(0, 8303, '\P{Is_Block=-_General_Punctuation}', "");
Expect(1, 8303, '\P{^Is_Block=-_General_Punctuation}', "");
Expect(0, 8191, '\p{Is_Block=-_General_Punctuation}', "");
Expect(1, 8191, '\p{^Is_Block=-_General_Punctuation}', "");
Expect(1, 8191, '\P{Is_Block=-_General_Punctuation}', "");
Expect(0, 8191, '\P{^Is_Block=-_General_Punctuation}', "");
Error('\p{Is_Blk=-general	Punctuation:=}');
Error('\P{Is_Blk=-general	Punctuation:=}');
Expect(1, 8303, '\p{Is_Blk=generalpunctuation}', "");
Expect(0, 8303, '\p{^Is_Blk=generalpunctuation}', "");
Expect(0, 8303, '\P{Is_Blk=generalpunctuation}', "");
Expect(1, 8303, '\P{^Is_Blk=generalpunctuation}', "");
Expect(0, 8191, '\p{Is_Blk=generalpunctuation}', "");
Expect(1, 8191, '\p{^Is_Blk=generalpunctuation}', "");
Expect(1, 8191, '\P{Is_Blk=generalpunctuation}', "");
Expect(0, 8191, '\P{^Is_Blk=generalpunctuation}', "");
Expect(1, 8303, '\p{Is_Blk=-_Generalpunctuation}', "");
Expect(0, 8303, '\p{^Is_Blk=-_Generalpunctuation}', "");
Expect(0, 8303, '\P{Is_Blk=-_Generalpunctuation}', "");
Expect(1, 8303, '\P{^Is_Blk=-_Generalpunctuation}', "");
Expect(0, 8191, '\p{Is_Blk=-_Generalpunctuation}', "");
Expect(1, 8191, '\p{^Is_Blk=-_Generalpunctuation}', "");
Expect(1, 8191, '\P{Is_Blk=-_Generalpunctuation}', "");
Expect(0, 8191, '\P{^Is_Blk=-_Generalpunctuation}', "");
Error('\p{Block= :=REJANG}');
Error('\P{Block= :=REJANG}');
Expect(1, 43359, '\p{Block=rejang}', "");
Expect(0, 43359, '\p{^Block=rejang}', "");
Expect(0, 43359, '\P{Block=rejang}', "");
Expect(1, 43359, '\P{^Block=rejang}', "");
Expect(0, 43311, '\p{Block=rejang}', "");
Expect(1, 43311, '\p{^Block=rejang}', "");
Expect(1, 43311, '\P{Block=rejang}', "");
Expect(0, 43311, '\P{^Block=rejang}', "");
Expect(1, 43359, '\p{Block=	REJANG}', "");
Expect(0, 43359, '\p{^Block=	REJANG}', "");
Expect(0, 43359, '\P{Block=	REJANG}', "");
Expect(1, 43359, '\P{^Block=	REJANG}', "");
Expect(0, 43311, '\p{Block=	REJANG}', "");
Expect(1, 43311, '\p{^Block=	REJANG}', "");
Expect(1, 43311, '\P{Block=	REJANG}', "");
Expect(0, 43311, '\P{^Block=	REJANG}', "");
Error('\p{Blk=_/a/Rejang}');
Error('\P{Blk=_/a/Rejang}');
Expect(1, 43359, '\p{Blk=rejang}', "");
Expect(0, 43359, '\p{^Blk=rejang}', "");
Expect(0, 43359, '\P{Blk=rejang}', "");
Expect(1, 43359, '\P{^Blk=rejang}', "");
Expect(0, 43311, '\p{Blk=rejang}', "");
Expect(1, 43311, '\p{^Blk=rejang}', "");
Expect(1, 43311, '\P{Blk=rejang}', "");
Expect(0, 43311, '\P{^Blk=rejang}', "");
Expect(1, 43359, '\p{Blk=	_Rejang}', "");
Expect(0, 43359, '\p{^Blk=	_Rejang}', "");
Expect(0, 43359, '\P{Blk=	_Rejang}', "");
Expect(1, 43359, '\P{^Blk=	_Rejang}', "");
Expect(0, 43311, '\p{Blk=	_Rejang}', "");
Expect(1, 43311, '\p{^Blk=	_Rejang}', "");
Expect(1, 43311, '\P{Blk=	_Rejang}', "");
Expect(0, 43311, '\P{^Blk=	_Rejang}', "");
Error('\p{Is_Block=/a/_-Rejang}');
Error('\P{Is_Block=/a/_-Rejang}');
Expect(1, 43359, '\p{Is_Block=rejang}', "");
Expect(0, 43359, '\p{^Is_Block=rejang}', "");
Expect(0, 43359, '\P{Is_Block=rejang}', "");
Expect(1, 43359, '\P{^Is_Block=rejang}', "");
Expect(0, 43311, '\p{Is_Block=rejang}', "");
Expect(1, 43311, '\p{^Is_Block=rejang}', "");
Expect(1, 43311, '\P{Is_Block=rejang}', "");
Expect(0, 43311, '\P{^Is_Block=rejang}', "");
Expect(1, 43359, '\p{Is_Block=_	Rejang}', "");
Expect(0, 43359, '\p{^Is_Block=_	Rejang}', "");
Expect(0, 43359, '\P{Is_Block=_	Rejang}', "");
Expect(1, 43359, '\P{^Is_Block=_	Rejang}', "");
Expect(0, 43311, '\p{Is_Block=_	Rejang}', "");
Expect(1, 43311, '\p{^Is_Block=_	Rejang}', "");
Expect(1, 43311, '\P{Is_Block=_	Rejang}', "");
Expect(0, 43311, '\P{^Is_Block=_	Rejang}', "");
Error('\p{Is_Blk=-	rejang/a/}');
Error('\P{Is_Blk=-	rejang/a/}');
Expect(1, 43359, '\p{Is_Blk=rejang}', "");
Expect(0, 43359, '\p{^Is_Blk=rejang}', "");
Expect(0, 43359, '\P{Is_Blk=rejang}', "");
Expect(1, 43359, '\P{^Is_Blk=rejang}', "");
Expect(0, 43311, '\p{Is_Blk=rejang}', "");
Expect(1, 43311, '\p{^Is_Blk=rejang}', "");
Expect(1, 43311, '\P{Is_Blk=rejang}', "");
Expect(0, 43311, '\P{^Is_Blk=rejang}', "");
Expect(1, 43359, '\p{Is_Blk= _rejang}', "");
Expect(0, 43359, '\p{^Is_Blk= _rejang}', "");
Expect(0, 43359, '\P{Is_Blk= _rejang}', "");
Expect(1, 43359, '\P{^Is_Blk= _rejang}', "");
Expect(0, 43311, '\p{Is_Blk= _rejang}', "");
Expect(1, 43311, '\p{^Is_Blk= _rejang}', "");
Expect(1, 43311, '\P{Is_Blk= _rejang}', "");
Expect(0, 43311, '\P{^Is_Blk= _rejang}', "");
Error('\p{Block= :=oldturkic}');
Error('\P{Block= :=oldturkic}');
Expect(1, 68687, '\p{Block=oldturkic}', "");
Expect(0, 68687, '\p{^Block=oldturkic}', "");
Expect(0, 68687, '\P{Block=oldturkic}', "");
Expect(1, 68687, '\P{^Block=oldturkic}', "");
Expect(0, 68607, '\p{Block=oldturkic}', "");
Expect(1, 68607, '\p{^Block=oldturkic}', "");
Expect(1, 68607, '\P{Block=oldturkic}', "");
Expect(0, 68607, '\P{^Block=oldturkic}', "");
Expect(1, 68687, '\p{Block=_ OldTurkic}', "");
Expect(0, 68687, '\p{^Block=_ OldTurkic}', "");
Expect(0, 68687, '\P{Block=_ OldTurkic}', "");
Expect(1, 68687, '\P{^Block=_ OldTurkic}', "");
Expect(0, 68607, '\p{Block=_ OldTurkic}', "");
Expect(1, 68607, '\p{^Block=_ OldTurkic}', "");
Expect(1, 68607, '\P{Block=_ OldTurkic}', "");
Expect(0, 68607, '\P{^Block=_ OldTurkic}', "");
Error('\p{Blk:    :=OLD	Turkic}');
Error('\P{Blk:    :=OLD	Turkic}');
Expect(1, 68687, '\p{Blk=oldturkic}', "");
Expect(0, 68687, '\p{^Blk=oldturkic}', "");
Expect(0, 68687, '\P{Blk=oldturkic}', "");
Expect(1, 68687, '\P{^Blk=oldturkic}', "");
Expect(0, 68607, '\p{Blk=oldturkic}', "");
Expect(1, 68607, '\p{^Blk=oldturkic}', "");
Expect(1, 68607, '\P{Blk=oldturkic}', "");
Expect(0, 68607, '\P{^Blk=oldturkic}', "");
Expect(1, 68687, '\p{Blk= OLD_TURKIC}', "");
Expect(0, 68687, '\p{^Blk= OLD_TURKIC}', "");
Expect(0, 68687, '\P{Blk= OLD_TURKIC}', "");
Expect(1, 68687, '\P{^Blk= OLD_TURKIC}', "");
Expect(0, 68607, '\p{Blk= OLD_TURKIC}', "");
Expect(1, 68607, '\p{^Blk= OLD_TURKIC}', "");
Expect(1, 68607, '\P{Blk= OLD_TURKIC}', "");
Expect(0, 68607, '\P{^Blk= OLD_TURKIC}', "");
Error('\p{Is_Block=	Old/a/turkic}');
Error('\P{Is_Block=	Old/a/turkic}');
Expect(1, 68687, '\p{Is_Block:oldturkic}', "");
Expect(0, 68687, '\p{^Is_Block:oldturkic}', "");
Expect(0, 68687, '\P{Is_Block:oldturkic}', "");
Expect(1, 68687, '\P{^Is_Block:oldturkic}', "");
Expect(0, 68607, '\p{Is_Block:oldturkic}', "");
Expect(1, 68607, '\p{^Is_Block:oldturkic}', "");
Expect(1, 68607, '\P{Is_Block:oldturkic}', "");
Expect(0, 68607, '\P{^Is_Block:oldturkic}', "");
Expect(1, 68687, '\p{Is_Block=_Old-turkic}', "");
Expect(0, 68687, '\p{^Is_Block=_Old-turkic}', "");
Expect(0, 68687, '\P{Is_Block=_Old-turkic}', "");
Expect(1, 68687, '\P{^Is_Block=_Old-turkic}', "");
Expect(0, 68607, '\p{Is_Block=_Old-turkic}', "");
Expect(1, 68607, '\p{^Is_Block=_Old-turkic}', "");
Expect(1, 68607, '\P{Is_Block=_Old-turkic}', "");
Expect(0, 68607, '\P{^Is_Block=_Old-turkic}', "");
Error('\p{Is_Blk=__Old-TURKIC:=}');
Error('\P{Is_Blk=__Old-TURKIC:=}');
Expect(1, 68687, '\p{Is_Blk=oldturkic}', "");
Expect(0, 68687, '\p{^Is_Blk=oldturkic}', "");
Expect(0, 68687, '\P{Is_Blk=oldturkic}', "");
Expect(1, 68687, '\P{^Is_Blk=oldturkic}', "");
Expect(0, 68607, '\p{Is_Blk=oldturkic}', "");
Expect(1, 68607, '\p{^Is_Blk=oldturkic}', "");
Expect(1, 68607, '\P{Is_Blk=oldturkic}', "");
Expect(0, 68607, '\P{^Is_Blk=oldturkic}', "");
Expect(1, 68687, '\p{Is_Blk=-Old	Turkic}', "");
Expect(0, 68687, '\p{^Is_Blk=-Old	Turkic}', "");
Expect(0, 68687, '\P{Is_Blk=-Old	Turkic}', "");
Expect(1, 68687, '\P{^Is_Blk=-Old	Turkic}', "");
Expect(0, 68607, '\p{Is_Blk=-Old	Turkic}', "");
Expect(1, 68607, '\p{^Is_Blk=-Old	Turkic}', "");
Expect(1, 68607, '\P{Is_Blk=-Old	Turkic}', "");
Expect(0, 68607, '\P{^Is_Blk=-Old	Turkic}', "");
Error('\p{Block= ol/a/chiki}');
Error('\P{Block= ol/a/chiki}');
Expect(1, 7295, '\p{Block=olchiki}', "");
Expect(0, 7295, '\p{^Block=olchiki}', "");
Expect(0, 7295, '\P{Block=olchiki}', "");
Expect(1, 7295, '\P{^Block=olchiki}', "");
Expect(0, 7247, '\p{Block=olchiki}', "");
Expect(1, 7247, '\p{^Block=olchiki}', "");
Expect(1, 7247, '\P{Block=olchiki}', "");
Expect(0, 7247, '\P{^Block=olchiki}', "");
Expect(1, 7295, '\p{Block=  OL-Chiki}', "");
Expect(0, 7295, '\p{^Block=  OL-Chiki}', "");
Expect(0, 7295, '\P{Block=  OL-Chiki}', "");
Expect(1, 7295, '\P{^Block=  OL-Chiki}', "");
Expect(0, 7247, '\p{Block=  OL-Chiki}', "");
Expect(1, 7247, '\p{^Block=  OL-Chiki}', "");
Expect(1, 7247, '\P{Block=  OL-Chiki}', "");
Expect(0, 7247, '\P{^Block=  OL-Chiki}', "");
Error('\p{Blk=		Ol	CHIKI/a/}');
Error('\P{Blk=		Ol	CHIKI/a/}');
Expect(1, 7295, '\p{Blk=olchiki}', "");
Expect(0, 7295, '\p{^Blk=olchiki}', "");
Expect(0, 7295, '\P{Blk=olchiki}', "");
Expect(1, 7295, '\P{^Blk=olchiki}', "");
Expect(0, 7247, '\p{Blk=olchiki}', "");
Expect(1, 7247, '\p{^Blk=olchiki}', "");
Expect(1, 7247, '\P{Blk=olchiki}', "");
Expect(0, 7247, '\P{^Blk=olchiki}', "");
Expect(1, 7295, '\p{Blk:   	OL	CHIKI}', "");
Expect(0, 7295, '\p{^Blk:   	OL	CHIKI}', "");
Expect(0, 7295, '\P{Blk:   	OL	CHIKI}', "");
Expect(1, 7295, '\P{^Blk:   	OL	CHIKI}', "");
Expect(0, 7247, '\p{Blk:   	OL	CHIKI}', "");
Expect(1, 7247, '\p{^Blk:   	OL	CHIKI}', "");
Expect(1, 7247, '\P{Blk:   	OL	CHIKI}', "");
Expect(0, 7247, '\P{^Blk:   	OL	CHIKI}', "");
Error('\p{Is_Block:   _OL:=CHIKI}');
Error('\P{Is_Block:   _OL:=CHIKI}');
Expect(1, 7295, '\p{Is_Block:	olchiki}', "");
Expect(0, 7295, '\p{^Is_Block:	olchiki}', "");
Expect(0, 7295, '\P{Is_Block:	olchiki}', "");
Expect(1, 7295, '\P{^Is_Block:	olchiki}', "");
Expect(0, 7247, '\p{Is_Block:	olchiki}', "");
Expect(1, 7247, '\p{^Is_Block:	olchiki}', "");
Expect(1, 7247, '\P{Is_Block:	olchiki}', "");
Expect(0, 7247, '\P{^Is_Block:	olchiki}', "");
Expect(1, 7295, '\p{Is_Block=	-Ol_Chiki}', "");
Expect(0, 7295, '\p{^Is_Block=	-Ol_Chiki}', "");
Expect(0, 7295, '\P{Is_Block=	-Ol_Chiki}', "");
Expect(1, 7295, '\P{^Is_Block=	-Ol_Chiki}', "");
Expect(0, 7247, '\p{Is_Block=	-Ol_Chiki}', "");
Expect(1, 7247, '\p{^Is_Block=	-Ol_Chiki}', "");
Expect(1, 7247, '\P{Is_Block=	-Ol_Chiki}', "");
Expect(0, 7247, '\P{^Is_Block=	-Ol_Chiki}', "");
Error('\p{Is_Blk:	-_Ol-Chiki/a/}');
Error('\P{Is_Blk:	-_Ol-Chiki/a/}');
Expect(1, 7295, '\p{Is_Blk=olchiki}', "");
Expect(0, 7295, '\p{^Is_Blk=olchiki}', "");
Expect(0, 7295, '\P{Is_Blk=olchiki}', "");
Expect(1, 7295, '\P{^Is_Blk=olchiki}', "");
Expect(0, 7247, '\p{Is_Blk=olchiki}', "");
Expect(1, 7247, '\p{^Is_Blk=olchiki}', "");
Expect(1, 7247, '\P{Is_Blk=olchiki}', "");
Expect(0, 7247, '\P{^Is_Blk=olchiki}', "");
Expect(1, 7295, '\p{Is_Blk=- Olchiki}', "");
Expect(0, 7295, '\p{^Is_Blk=- Olchiki}', "");
Expect(0, 7295, '\P{Is_Blk=- Olchiki}', "");
Expect(1, 7295, '\P{^Is_Blk=- Olchiki}', "");
Expect(0, 7247, '\p{Is_Blk=- Olchiki}', "");
Expect(1, 7247, '\p{^Is_Blk=- Olchiki}', "");
Expect(1, 7247, '\P{Is_Blk=- Olchiki}', "");
Expect(0, 7247, '\P{^Is_Blk=- Olchiki}', "");
Error('\p{Block=Kanbun/a/}');
Error('\P{Block=Kanbun/a/}');
Expect(1, 12703, '\p{Block=kanbun}', "");
Expect(0, 12703, '\p{^Block=kanbun}', "");
Expect(0, 12703, '\P{Block=kanbun}', "");
Expect(1, 12703, '\P{^Block=kanbun}', "");
Expect(0, 12687, '\p{Block=kanbun}', "");
Expect(1, 12687, '\p{^Block=kanbun}', "");
Expect(1, 12687, '\P{Block=kanbun}', "");
Expect(0, 12687, '\P{^Block=kanbun}', "");
Expect(1, 12703, '\p{Block=-	KANBUN}', "");
Expect(0, 12703, '\p{^Block=-	KANBUN}', "");
Expect(0, 12703, '\P{Block=-	KANBUN}', "");
Expect(1, 12703, '\P{^Block=-	KANBUN}', "");
Expect(0, 12687, '\p{Block=-	KANBUN}', "");
Expect(1, 12687, '\p{^Block=-	KANBUN}', "");
Expect(1, 12687, '\P{Block=-	KANBUN}', "");
Expect(0, 12687, '\P{^Block=-	KANBUN}', "");
Error('\p{Blk=:=  kanbun}');
Error('\P{Blk=:=  kanbun}');
Expect(1, 12703, '\p{Blk=kanbun}', "");
Expect(0, 12703, '\p{^Blk=kanbun}', "");
Expect(0, 12703, '\P{Blk=kanbun}', "");
Expect(1, 12703, '\P{^Blk=kanbun}', "");
Expect(0, 12687, '\p{Blk=kanbun}', "");
Expect(1, 12687, '\p{^Blk=kanbun}', "");
Expect(1, 12687, '\P{Blk=kanbun}', "");
Expect(0, 12687, '\P{^Blk=kanbun}', "");
Expect(1, 12703, '\p{Blk: -kanbun}', "");
Expect(0, 12703, '\p{^Blk: -kanbun}', "");
Expect(0, 12703, '\P{Blk: -kanbun}', "");
Expect(1, 12703, '\P{^Blk: -kanbun}', "");
Expect(0, 12687, '\p{Blk: -kanbun}', "");
Expect(1, 12687, '\p{^Blk: -kanbun}', "");
Expect(1, 12687, '\P{Blk: -kanbun}', "");
Expect(0, 12687, '\P{^Blk: -kanbun}', "");
Error('\p{Is_Block=	-Kanbun:=}');
Error('\P{Is_Block=	-Kanbun:=}');
Expect(1, 12703, '\p{Is_Block=kanbun}', "");
Expect(0, 12703, '\p{^Is_Block=kanbun}', "");
Expect(0, 12703, '\P{Is_Block=kanbun}', "");
Expect(1, 12703, '\P{^Is_Block=kanbun}', "");
Expect(0, 12687, '\p{Is_Block=kanbun}', "");
Expect(1, 12687, '\p{^Is_Block=kanbun}', "");
Expect(1, 12687, '\P{Is_Block=kanbun}', "");
Expect(0, 12687, '\P{^Is_Block=kanbun}', "");
Expect(1, 12703, '\p{Is_Block=_	Kanbun}', "");
Expect(0, 12703, '\p{^Is_Block=_	Kanbun}', "");
Expect(0, 12703, '\P{Is_Block=_	Kanbun}', "");
Expect(1, 12703, '\P{^Is_Block=_	Kanbun}', "");
Expect(0, 12687, '\p{Is_Block=_	Kanbun}', "");
Expect(1, 12687, '\p{^Is_Block=_	Kanbun}', "");
Expect(1, 12687, '\P{Is_Block=_	Kanbun}', "");
Expect(0, 12687, '\P{^Is_Block=_	Kanbun}', "");
Error('\p{Is_Blk=/a/ _Kanbun}');
Error('\P{Is_Blk=/a/ _Kanbun}');
Expect(1, 12703, '\p{Is_Blk=kanbun}', "");
Expect(0, 12703, '\p{^Is_Blk=kanbun}', "");
Expect(0, 12703, '\P{Is_Blk=kanbun}', "");
Expect(1, 12703, '\P{^Is_Blk=kanbun}', "");
Expect(0, 12687, '\p{Is_Blk=kanbun}', "");
Expect(1, 12687, '\p{^Is_Blk=kanbun}', "");
Expect(1, 12687, '\P{Is_Blk=kanbun}', "");
Expect(0, 12687, '\P{^Is_Blk=kanbun}', "");
Expect(1, 12703, '\p{Is_Blk=-Kanbun}', "");
Expect(0, 12703, '\p{^Is_Blk=-Kanbun}', "");
Expect(0, 12703, '\P{Is_Blk=-Kanbun}', "");
Expect(1, 12703, '\P{^Is_Blk=-Kanbun}', "");
Expect(0, 12687, '\p{Is_Blk=-Kanbun}', "");
Expect(1, 12687, '\p{^Is_Blk=-Kanbun}', "");
Expect(1, 12687, '\P{Is_Blk=-Kanbun}', "");
Expect(0, 12687, '\P{^Is_Blk=-Kanbun}', "");
Error('\p{Block=-cyrillic-Extended A/a/}');
Error('\P{Block=-cyrillic-Extended A/a/}');
Expect(1, 11775, '\p{Block=cyrillicextendeda}', "");
Expect(0, 11775, '\p{^Block=cyrillicextendeda}', "");
Expect(0, 11775, '\P{Block=cyrillicextendeda}', "");
Expect(1, 11775, '\P{^Block=cyrillicextendeda}', "");
Expect(0, 11743, '\p{Block=cyrillicextendeda}', "");
Expect(1, 11743, '\p{^Block=cyrillicextendeda}', "");
Expect(1, 11743, '\P{Block=cyrillicextendeda}', "");
Expect(0, 11743, '\P{^Block=cyrillicextendeda}', "");
Expect(1, 11775, '\p{Block=		CYRILLICextended-A}', "");
Expect(0, 11775, '\p{^Block=		CYRILLICextended-A}', "");
Expect(0, 11775, '\P{Block=		CYRILLICextended-A}', "");
Expect(1, 11775, '\P{^Block=		CYRILLICextended-A}', "");
Expect(0, 11743, '\p{Block=		CYRILLICextended-A}', "");
Expect(1, 11743, '\p{^Block=		CYRILLICextended-A}', "");
Expect(1, 11743, '\P{Block=		CYRILLICextended-A}', "");
Expect(0, 11743, '\P{^Block=		CYRILLICextended-A}', "");
Error('\p{Blk:_-Cyrillic/a/ExtendedA}');
Error('\P{Blk:_-Cyrillic/a/ExtendedA}');
Expect(1, 11775, '\p{Blk:cyrillicextendeda}', "");
Expect(0, 11775, '\p{^Blk:cyrillicextendeda}', "");
Expect(0, 11775, '\P{Blk:cyrillicextendeda}', "");
Expect(1, 11775, '\P{^Blk:cyrillicextendeda}', "");
Expect(0, 11743, '\p{Blk:cyrillicextendeda}', "");
Expect(1, 11743, '\p{^Blk:cyrillicextendeda}', "");
Expect(1, 11743, '\P{Blk:cyrillicextendeda}', "");
Expect(0, 11743, '\P{^Blk:cyrillicextendeda}', "");
Expect(1, 11775, '\p{Blk= Cyrillic	extended	A}', "");
Expect(0, 11775, '\p{^Blk= Cyrillic	extended	A}', "");
Expect(0, 11775, '\P{Blk= Cyrillic	extended	A}', "");
Expect(1, 11775, '\P{^Blk= Cyrillic	extended	A}', "");
Expect(0, 11743, '\p{Blk= Cyrillic	extended	A}', "");
Expect(1, 11743, '\p{^Blk= Cyrillic	extended	A}', "");
Expect(1, 11743, '\P{Blk= Cyrillic	extended	A}', "");
Expect(0, 11743, '\P{^Blk= Cyrillic	extended	A}', "");
Error('\p{Is_Block= 	Cyrillic-Extended-a/a/}');
Error('\P{Is_Block= 	Cyrillic-Extended-a/a/}');
Expect(1, 11775, '\p{Is_Block=cyrillicextendeda}', "");
Expect(0, 11775, '\p{^Is_Block=cyrillicextendeda}', "");
Expect(0, 11775, '\P{Is_Block=cyrillicextendeda}', "");
Expect(1, 11775, '\P{^Is_Block=cyrillicextendeda}', "");
Expect(0, 11743, '\p{Is_Block=cyrillicextendeda}', "");
Expect(1, 11743, '\p{^Is_Block=cyrillicextendeda}', "");
Expect(1, 11743, '\P{Is_Block=cyrillicextendeda}', "");
Expect(0, 11743, '\P{^Is_Block=cyrillicextendeda}', "");
Expect(1, 11775, '\p{Is_Block= 	CYRILLIC Extended_A}', "");
Expect(0, 11775, '\p{^Is_Block= 	CYRILLIC Extended_A}', "");
Expect(0, 11775, '\P{Is_Block= 	CYRILLIC Extended_A}', "");
Expect(1, 11775, '\P{^Is_Block= 	CYRILLIC Extended_A}', "");
Expect(0, 11743, '\p{Is_Block= 	CYRILLIC Extended_A}', "");
Expect(1, 11743, '\p{^Is_Block= 	CYRILLIC Extended_A}', "");
Expect(1, 11743, '\P{Is_Block= 	CYRILLIC Extended_A}', "");
Expect(0, 11743, '\P{^Is_Block= 	CYRILLIC Extended_A}', "");
Error('\p{Is_Blk=:=-	CYRILLIC-extended-A}');
Error('\P{Is_Blk=:=-	CYRILLIC-extended-A}');
Expect(1, 11775, '\p{Is_Blk=cyrillicextendeda}', "");
Expect(0, 11775, '\p{^Is_Blk=cyrillicextendeda}', "");
Expect(0, 11775, '\P{Is_Blk=cyrillicextendeda}', "");
Expect(1, 11775, '\P{^Is_Blk=cyrillicextendeda}', "");
Expect(0, 11743, '\p{Is_Blk=cyrillicextendeda}', "");
Expect(1, 11743, '\p{^Is_Blk=cyrillicextendeda}', "");
Expect(1, 11743, '\P{Is_Blk=cyrillicextendeda}', "");
Expect(0, 11743, '\P{^Is_Blk=cyrillicextendeda}', "");
Expect(1, 11775, '\p{Is_Blk:	_CYRILLIC EXTENDED_A}', "");
Expect(0, 11775, '\p{^Is_Blk:	_CYRILLIC EXTENDED_A}', "");
Expect(0, 11775, '\P{Is_Blk:	_CYRILLIC EXTENDED_A}', "");
Expect(1, 11775, '\P{^Is_Blk:	_CYRILLIC EXTENDED_A}', "");
Expect(0, 11743, '\p{Is_Blk:	_CYRILLIC EXTENDED_A}', "");
Expect(1, 11743, '\p{^Is_Blk:	_CYRILLIC EXTENDED_A}', "");
Expect(1, 11743, '\P{Is_Blk:	_CYRILLIC EXTENDED_A}', "");
Expect(0, 11743, '\P{^Is_Blk:	_CYRILLIC EXTENDED_A}', "");
Error('\p{Block=	/a/HEBREW}');
Error('\P{Block=	/a/HEBREW}');
Expect(1, 1535, '\p{Block=hebrew}', "");
Expect(0, 1535, '\p{^Block=hebrew}', "");
Expect(0, 1535, '\P{Block=hebrew}', "");
Expect(1, 1535, '\P{^Block=hebrew}', "");
Expect(0, 1423, '\p{Block=hebrew}', "");
Expect(1, 1423, '\p{^Block=hebrew}', "");
Expect(1, 1423, '\P{Block=hebrew}', "");
Expect(0, 1423, '\P{^Block=hebrew}', "");
Expect(1, 1535, '\p{Block= _hebrew}', "");
Expect(0, 1535, '\p{^Block= _hebrew}', "");
Expect(0, 1535, '\P{Block= _hebrew}', "");
Expect(1, 1535, '\P{^Block= _hebrew}', "");
Expect(0, 1423, '\p{Block= _hebrew}', "");
Expect(1, 1423, '\p{^Block= _hebrew}', "");
Expect(1, 1423, '\P{Block= _hebrew}', "");
Expect(0, 1423, '\P{^Block= _hebrew}', "");
Error('\p{Blk=:=--Hebrew}');
Error('\P{Blk=:=--Hebrew}');
Expect(1, 1535, '\p{Blk=hebrew}', "");
Expect(0, 1535, '\p{^Blk=hebrew}', "");
Expect(0, 1535, '\P{Blk=hebrew}', "");
Expect(1, 1535, '\P{^Blk=hebrew}', "");
Expect(0, 1423, '\p{Blk=hebrew}', "");
Expect(1, 1423, '\p{^Blk=hebrew}', "");
Expect(1, 1423, '\P{Blk=hebrew}', "");
Expect(0, 1423, '\P{^Blk=hebrew}', "");
Expect(1, 1535, '\p{Blk=-_hebrew}', "");
Expect(0, 1535, '\p{^Blk=-_hebrew}', "");
Expect(0, 1535, '\P{Blk=-_hebrew}', "");
Expect(1, 1535, '\P{^Blk=-_hebrew}', "");
Expect(0, 1423, '\p{Blk=-_hebrew}', "");
Expect(1, 1423, '\p{^Blk=-_hebrew}', "");
Expect(1, 1423, '\P{Blk=-_hebrew}', "");
Expect(0, 1423, '\P{^Blk=-_hebrew}', "");
Error('\p{Is_Block=/a/_hebrew}');
Error('\P{Is_Block=/a/_hebrew}');
Expect(1, 1535, '\p{Is_Block=hebrew}', "");
Expect(0, 1535, '\p{^Is_Block=hebrew}', "");
Expect(0, 1535, '\P{Is_Block=hebrew}', "");
Expect(1, 1535, '\P{^Is_Block=hebrew}', "");
Expect(0, 1423, '\p{Is_Block=hebrew}', "");
Expect(1, 1423, '\p{^Is_Block=hebrew}', "");
Expect(1, 1423, '\P{Is_Block=hebrew}', "");
Expect(0, 1423, '\P{^Is_Block=hebrew}', "");
Expect(1, 1535, '\p{Is_Block= _Hebrew}', "");
Expect(0, 1535, '\p{^Is_Block= _Hebrew}', "");
Expect(0, 1535, '\P{Is_Block= _Hebrew}', "");
Expect(1, 1535, '\P{^Is_Block= _Hebrew}', "");
Expect(0, 1423, '\p{Is_Block= _Hebrew}', "");
Expect(1, 1423, '\p{^Is_Block= _Hebrew}', "");
Expect(1, 1423, '\P{Is_Block= _Hebrew}', "");
Expect(0, 1423, '\P{^Is_Block= _Hebrew}', "");
Error('\p{Is_Blk=:= Hebrew}');
Error('\P{Is_Blk=:= Hebrew}');
Expect(1, 1535, '\p{Is_Blk: hebrew}', "");
Expect(0, 1535, '\p{^Is_Blk: hebrew}', "");
Expect(0, 1535, '\P{Is_Blk: hebrew}', "");
Expect(1, 1535, '\P{^Is_Blk: hebrew}', "");
Expect(0, 1423, '\p{Is_Blk: hebrew}', "");
Expect(1, 1423, '\p{^Is_Blk: hebrew}', "");
Expect(1, 1423, '\P{Is_Blk: hebrew}', "");
Expect(0, 1423, '\P{^Is_Blk: hebrew}', "");
Expect(1, 1535, '\p{Is_Blk=	_hebrew}', "");
Expect(0, 1535, '\p{^Is_Blk=	_hebrew}', "");
Expect(0, 1535, '\P{Is_Blk=	_hebrew}', "");
Expect(1, 1535, '\P{^Is_Blk=	_hebrew}', "");
Expect(0, 1423, '\p{Is_Blk=	_hebrew}', "");
Expect(1, 1423, '\p{^Is_Blk=	_hebrew}', "");
Expect(1, 1423, '\P{Is_Blk=	_hebrew}', "");
Expect(0, 1423, '\P{^Is_Blk=	_hebrew}', "");
Error('\p{Block= CYRILLIC/a/}');
Error('\P{Block= CYRILLIC/a/}');
Expect(1, 1279, '\p{Block=cyrillic}', "");
Expect(0, 1279, '\p{^Block=cyrillic}', "");
Expect(0, 1279, '\P{Block=cyrillic}', "");
Expect(1, 1279, '\P{^Block=cyrillic}', "");
Expect(0, 1023, '\p{Block=cyrillic}', "");
Expect(1, 1023, '\p{^Block=cyrillic}', "");
Expect(1, 1023, '\P{Block=cyrillic}', "");
Expect(0, 1023, '\P{^Block=cyrillic}', "");
Expect(1, 1279, '\p{Block: -Cyrillic}', "");
Expect(0, 1279, '\p{^Block: -Cyrillic}', "");
Expect(0, 1279, '\P{Block: -Cyrillic}', "");
Expect(1, 1279, '\P{^Block: -Cyrillic}', "");
Expect(0, 1023, '\p{Block: -Cyrillic}', "");
Expect(1, 1023, '\p{^Block: -Cyrillic}', "");
Expect(1, 1023, '\P{Block: -Cyrillic}', "");
Expect(0, 1023, '\P{^Block: -Cyrillic}', "");
Error('\p{Blk=-CYRILLIC/a/}');
Error('\P{Blk=-CYRILLIC/a/}');
Expect(1, 1279, '\p{Blk=cyrillic}', "");
Expect(0, 1279, '\p{^Blk=cyrillic}', "");
Expect(0, 1279, '\P{Blk=cyrillic}', "");
Expect(1, 1279, '\P{^Blk=cyrillic}', "");
Expect(0, 1023, '\p{Blk=cyrillic}', "");
Expect(1, 1023, '\p{^Blk=cyrillic}', "");
Expect(1, 1023, '\P{Blk=cyrillic}', "");
Expect(0, 1023, '\P{^Blk=cyrillic}', "");
Expect(1, 1279, '\p{Blk=_-Cyrillic}', "");
Expect(0, 1279, '\p{^Blk=_-Cyrillic}', "");
Expect(0, 1279, '\P{Blk=_-Cyrillic}', "");
Expect(1, 1279, '\P{^Blk=_-Cyrillic}', "");
Expect(0, 1023, '\p{Blk=_-Cyrillic}', "");
Expect(1, 1023, '\p{^Blk=_-Cyrillic}', "");
Expect(1, 1023, '\P{Blk=_-Cyrillic}', "");
Expect(0, 1023, '\P{^Blk=_-Cyrillic}', "");
Error('\p{Is_Block=-cyrillic/a/}');
Error('\P{Is_Block=-cyrillic/a/}');
Expect(1, 1279, '\p{Is_Block=cyrillic}', "");
Expect(0, 1279, '\p{^Is_Block=cyrillic}', "");
Expect(0, 1279, '\P{Is_Block=cyrillic}', "");
Expect(1, 1279, '\P{^Is_Block=cyrillic}', "");
Expect(0, 1023, '\p{Is_Block=cyrillic}', "");
Expect(1, 1023, '\p{^Is_Block=cyrillic}', "");
Expect(1, 1023, '\P{Is_Block=cyrillic}', "");
Expect(0, 1023, '\P{^Is_Block=cyrillic}', "");
Expect(1, 1279, '\p{Is_Block= _Cyrillic}', "");
Expect(0, 1279, '\p{^Is_Block= _Cyrillic}', "");
Expect(0, 1279, '\P{Is_Block= _Cyrillic}', "");
Expect(1, 1279, '\P{^Is_Block= _Cyrillic}', "");
Expect(0, 1023, '\p{Is_Block= _Cyrillic}', "");
Expect(1, 1023, '\p{^Is_Block= _Cyrillic}', "");
Expect(1, 1023, '\P{Is_Block= _Cyrillic}', "");
Expect(0, 1023, '\P{^Is_Block= _Cyrillic}', "");
Error('\p{Is_Blk=_/a/cyrillic}');
Error('\P{Is_Blk=_/a/cyrillic}');
Expect(1, 1279, '\p{Is_Blk=cyrillic}', "");
Expect(0, 1279, '\p{^Is_Blk=cyrillic}', "");
Expect(0, 1279, '\P{Is_Blk=cyrillic}', "");
Expect(1, 1279, '\P{^Is_Blk=cyrillic}', "");
Expect(0, 1023, '\p{Is_Blk=cyrillic}', "");
Expect(1, 1023, '\p{^Is_Blk=cyrillic}', "");
Expect(1, 1023, '\P{Is_Blk=cyrillic}', "");
Expect(0, 1023, '\P{^Is_Blk=cyrillic}', "");
Expect(1, 1279, '\p{Is_Blk=_-cyrillic}', "");
Expect(0, 1279, '\p{^Is_Blk=_-cyrillic}', "");
Expect(0, 1279, '\P{Is_Blk=_-cyrillic}', "");
Expect(1, 1279, '\P{^Is_Blk=_-cyrillic}', "");
Expect(0, 1023, '\p{Is_Blk=_-cyrillic}', "");
Expect(1, 1023, '\p{^Is_Blk=_-cyrillic}', "");
Expect(1, 1023, '\P{Is_Blk=_-cyrillic}', "");
Expect(0, 1023, '\P{^Is_Blk=_-cyrillic}', "");
Error('\p{Block=_LATIN Extended:=a}');
Error('\P{Block=_LATIN Extended:=a}');
Expect(1, 383, '\p{Block=latinextendeda}', "");
Expect(0, 383, '\p{^Block=latinextendeda}', "");
Expect(0, 383, '\P{Block=latinextendeda}', "");
Expect(1, 383, '\P{^Block=latinextendeda}', "");
Expect(0, 255, '\p{Block=latinextendeda}', "");
Expect(1, 255, '\p{^Block=latinextendeda}', "");
Expect(1, 255, '\P{Block=latinextendeda}', "");
Expect(0, 255, '\P{^Block=latinextendeda}', "");
Expect(1, 383, '\p{Block=--Latin EXTENDED-A}', "");
Expect(0, 383, '\p{^Block=--Latin EXTENDED-A}', "");
Expect(0, 383, '\P{Block=--Latin EXTENDED-A}', "");
Expect(1, 383, '\P{^Block=--Latin EXTENDED-A}', "");
Expect(0, 255, '\p{Block=--Latin EXTENDED-A}', "");
Expect(1, 255, '\p{^Block=--Latin EXTENDED-A}', "");
Expect(1, 255, '\P{Block=--Latin EXTENDED-A}', "");
Expect(0, 255, '\P{^Block=--Latin EXTENDED-A}', "");
Error('\p{Blk=/a/LATIN	extended-A}');
Error('\P{Blk=/a/LATIN	extended-A}');
Expect(1, 383, '\p{Blk=latinextendeda}', "");
Expect(0, 383, '\p{^Blk=latinextendeda}', "");
Expect(0, 383, '\P{Blk=latinextendeda}', "");
Expect(1, 383, '\P{^Blk=latinextendeda}', "");
Expect(0, 255, '\p{Blk=latinextendeda}', "");
Expect(1, 255, '\p{^Blk=latinextendeda}', "");
Expect(1, 255, '\P{Blk=latinextendeda}', "");
Expect(0, 255, '\P{^Blk=latinextendeda}', "");
Expect(1, 383, '\p{Blk=__LATIN-extended	A}', "");
Expect(0, 383, '\p{^Blk=__LATIN-extended	A}', "");
Expect(0, 383, '\P{Blk=__LATIN-extended	A}', "");
Expect(1, 383, '\P{^Blk=__LATIN-extended	A}', "");
Expect(0, 255, '\p{Blk=__LATIN-extended	A}', "");
Expect(1, 255, '\p{^Blk=__LATIN-extended	A}', "");
Expect(1, 255, '\P{Blk=__LATIN-extended	A}', "");
Expect(0, 255, '\P{^Blk=__LATIN-extended	A}', "");
Error('\p{Is_Block= -Latin Extended/a/A}');
Error('\P{Is_Block= -Latin Extended/a/A}');
Expect(1, 383, '\p{Is_Block=latinextendeda}', "");
Expect(0, 383, '\p{^Is_Block=latinextendeda}', "");
Expect(0, 383, '\P{Is_Block=latinextendeda}', "");
Expect(1, 383, '\P{^Is_Block=latinextendeda}', "");
Expect(0, 255, '\p{Is_Block=latinextendeda}', "");
Expect(1, 255, '\p{^Is_Block=latinextendeda}', "");
Expect(1, 255, '\P{Is_Block=latinextendeda}', "");
Expect(0, 255, '\P{^Is_Block=latinextendeda}', "");
Expect(1, 383, '\p{Is_Block=_LatinEXTENDED-a}', "");
Expect(0, 383, '\p{^Is_Block=_LatinEXTENDED-a}', "");
Expect(0, 383, '\P{Is_Block=_LatinEXTENDED-a}', "");
Expect(1, 383, '\P{^Is_Block=_LatinEXTENDED-a}', "");
Expect(0, 255, '\p{Is_Block=_LatinEXTENDED-a}', "");
Expect(1, 255, '\p{^Is_Block=_LatinEXTENDED-a}', "");
Expect(1, 255, '\P{Is_Block=_LatinEXTENDED-a}', "");
Expect(0, 255, '\P{^Is_Block=_LatinEXTENDED-a}', "");
Error('\p{Is_Blk=_-Latin-Extended_a:=}');
Error('\P{Is_Blk=_-Latin-Extended_a:=}');
Expect(1, 383, '\p{Is_Blk=latinextendeda}', "");
Expect(0, 383, '\p{^Is_Blk=latinextendeda}', "");
Expect(0, 383, '\P{Is_Blk=latinextendeda}', "");
Expect(1, 383, '\P{^Is_Blk=latinextendeda}', "");
Expect(0, 255, '\p{Is_Blk=latinextendeda}', "");
Expect(1, 255, '\p{^Is_Blk=latinextendeda}', "");
Expect(1, 255, '\P{Is_Blk=latinextendeda}', "");
Expect(0, 255, '\P{^Is_Blk=latinextendeda}', "");
Expect(1, 383, '\p{Is_Blk=-Latin_EXTENDED-a}', "");
Expect(0, 383, '\p{^Is_Blk=-Latin_EXTENDED-a}', "");
Expect(0, 383, '\P{Is_Blk=-Latin_EXTENDED-a}', "");
Expect(1, 383, '\P{^Is_Blk=-Latin_EXTENDED-a}', "");
Expect(0, 255, '\p{Is_Blk=-Latin_EXTENDED-a}', "");
Expect(1, 255, '\p{^Is_Blk=-Latin_EXTENDED-a}', "");
Expect(1, 255, '\P{Is_Blk=-Latin_EXTENDED-a}', "");
Expect(0, 255, '\P{^Is_Blk=-Latin_EXTENDED-a}', "");
Error('\p{Block=_ balinese/a/}');
Error('\P{Block=_ balinese/a/}');
Expect(1, 7039, '\p{Block=balinese}', "");
Expect(0, 7039, '\p{^Block=balinese}', "");
Expect(0, 7039, '\P{Block=balinese}', "");
Expect(1, 7039, '\P{^Block=balinese}', "");
Expect(0, 6911, '\p{Block=balinese}', "");
Expect(1, 6911, '\p{^Block=balinese}', "");
Expect(1, 6911, '\P{Block=balinese}', "");
Expect(0, 6911, '\P{^Block=balinese}', "");
Expect(1, 7039, '\p{Block=_-Balinese}', "");
Expect(0, 7039, '\p{^Block=_-Balinese}', "");
Expect(0, 7039, '\P{Block=_-Balinese}', "");
Expect(1, 7039, '\P{^Block=_-Balinese}', "");
Expect(0, 6911, '\p{Block=_-Balinese}', "");
Expect(1, 6911, '\p{^Block=_-Balinese}', "");
Expect(1, 6911, '\P{Block=_-Balinese}', "");
Expect(0, 6911, '\P{^Block=_-Balinese}', "");
Error('\p{Blk=:=_balinese}');
Error('\P{Blk=:=_balinese}');
Expect(1, 7039, '\p{Blk=balinese}', "");
Expect(0, 7039, '\p{^Blk=balinese}', "");
Expect(0, 7039, '\P{Blk=balinese}', "");
Expect(1, 7039, '\P{^Blk=balinese}', "");
Expect(0, 6911, '\p{Blk=balinese}', "");
Expect(1, 6911, '\p{^Blk=balinese}', "");
Expect(1, 6911, '\P{Blk=balinese}', "");
Expect(0, 6911, '\P{^Blk=balinese}', "");
Expect(1, 7039, '\p{Blk=  Balinese}', "");
Expect(0, 7039, '\p{^Blk=  Balinese}', "");
Expect(0, 7039, '\P{Blk=  Balinese}', "");
Expect(1, 7039, '\P{^Blk=  Balinese}', "");
Expect(0, 6911, '\p{Blk=  Balinese}', "");
Expect(1, 6911, '\p{^Blk=  Balinese}', "");
Expect(1, 6911, '\P{Blk=  Balinese}', "");
Expect(0, 6911, '\P{^Blk=  Balinese}', "");
Error('\p{Is_Block=-Balinese:=}');
Error('\P{Is_Block=-Balinese:=}');
Expect(1, 7039, '\p{Is_Block=balinese}', "");
Expect(0, 7039, '\p{^Is_Block=balinese}', "");
Expect(0, 7039, '\P{Is_Block=balinese}', "");
Expect(1, 7039, '\P{^Is_Block=balinese}', "");
Expect(0, 6911, '\p{Is_Block=balinese}', "");
Expect(1, 6911, '\p{^Is_Block=balinese}', "");
Expect(1, 6911, '\P{Is_Block=balinese}', "");
Expect(0, 6911, '\P{^Is_Block=balinese}', "");
Expect(1, 7039, '\p{Is_Block= -BALINESE}', "");
Expect(0, 7039, '\p{^Is_Block= -BALINESE}', "");
Expect(0, 7039, '\P{Is_Block= -BALINESE}', "");
Expect(1, 7039, '\P{^Is_Block= -BALINESE}', "");
Expect(0, 6911, '\p{Is_Block= -BALINESE}', "");
Expect(1, 6911, '\p{^Is_Block= -BALINESE}', "");
Expect(1, 6911, '\P{Is_Block= -BALINESE}', "");
Expect(0, 6911, '\P{^Is_Block= -BALINESE}', "");
Error('\p{Is_Blk=-_Balinese:=}');
Error('\P{Is_Blk=-_Balinese:=}');
Expect(1, 7039, '\p{Is_Blk=balinese}', "");
Expect(0, 7039, '\p{^Is_Blk=balinese}', "");
Expect(0, 7039, '\P{Is_Blk=balinese}', "");
Expect(1, 7039, '\P{^Is_Blk=balinese}', "");
Expect(0, 6911, '\p{Is_Blk=balinese}', "");
Expect(1, 6911, '\p{^Is_Blk=balinese}', "");
Expect(1, 6911, '\P{Is_Blk=balinese}', "");
Expect(0, 6911, '\P{^Is_Blk=balinese}', "");
Expect(1, 7039, '\p{Is_Blk= Balinese}', "");
Expect(0, 7039, '\p{^Is_Blk= Balinese}', "");
Expect(0, 7039, '\P{Is_Blk= Balinese}', "");
Expect(1, 7039, '\P{^Is_Blk= Balinese}', "");
Expect(0, 6911, '\p{Is_Blk= Balinese}', "");
Expect(1, 6911, '\p{^Is_Blk= Balinese}', "");
Expect(1, 6911, '\P{Is_Blk= Balinese}', "");
Expect(0, 6911, '\P{^Is_Blk= Balinese}', "");
Error('\p{Block=/a/	 Avestan}');
Error('\P{Block=/a/	 Avestan}');
Expect(1, 68415, '\p{Block=avestan}', "");
Expect(0, 68415, '\p{^Block=avestan}', "");
Expect(0, 68415, '\P{Block=avestan}', "");
Expect(1, 68415, '\P{^Block=avestan}', "");
Expect(0, 68351, '\p{Block=avestan}', "");
Expect(1, 68351, '\p{^Block=avestan}', "");
Expect(1, 68351, '\P{Block=avestan}', "");
Expect(0, 68351, '\P{^Block=avestan}', "");
Expect(1, 68415, '\p{Block=_	Avestan}', "");
Expect(0, 68415, '\p{^Block=_	Avestan}', "");
Expect(0, 68415, '\P{Block=_	Avestan}', "");
Expect(1, 68415, '\P{^Block=_	Avestan}', "");
Expect(0, 68351, '\p{Block=_	Avestan}', "");
Expect(1, 68351, '\p{^Block=_	Avestan}', "");
Expect(1, 68351, '\P{Block=_	Avestan}', "");
Expect(0, 68351, '\P{^Block=_	Avestan}', "");
Error('\p{Blk=	Avestan:=}');
Error('\P{Blk=	Avestan:=}');
Expect(1, 68415, '\p{Blk=avestan}', "");
Expect(0, 68415, '\p{^Blk=avestan}', "");
Expect(0, 68415, '\P{Blk=avestan}', "");
Expect(1, 68415, '\P{^Blk=avestan}', "");
Expect(0, 68351, '\p{Blk=avestan}', "");
Expect(1, 68351, '\p{^Blk=avestan}', "");
Expect(1, 68351, '\P{Blk=avestan}', "");
Expect(0, 68351, '\P{^Blk=avestan}', "");
Expect(1, 68415, '\p{Blk=-	avestan}', "");
Expect(0, 68415, '\p{^Blk=-	avestan}', "");
Expect(0, 68415, '\P{Blk=-	avestan}', "");
Expect(1, 68415, '\P{^Blk=-	avestan}', "");
Expect(0, 68351, '\p{Blk=-	avestan}', "");
Expect(1, 68351, '\p{^Blk=-	avestan}', "");
Expect(1, 68351, '\P{Blk=-	avestan}', "");
Expect(0, 68351, '\P{^Blk=-	avestan}', "");
Error('\p{Is_Block=:=-Avestan}');
Error('\P{Is_Block=:=-Avestan}');
Expect(1, 68415, '\p{Is_Block=avestan}', "");
Expect(0, 68415, '\p{^Is_Block=avestan}', "");
Expect(0, 68415, '\P{Is_Block=avestan}', "");
Expect(1, 68415, '\P{^Is_Block=avestan}', "");
Expect(0, 68351, '\p{Is_Block=avestan}', "");
Expect(1, 68351, '\p{^Is_Block=avestan}', "");
Expect(1, 68351, '\P{Is_Block=avestan}', "");
Expect(0, 68351, '\P{^Is_Block=avestan}', "");
Expect(1, 68415, '\p{Is_Block=_-Avestan}', "");
Expect(0, 68415, '\p{^Is_Block=_-Avestan}', "");
Expect(0, 68415, '\P{Is_Block=_-Avestan}', "");
Expect(1, 68415, '\P{^Is_Block=_-Avestan}', "");
Expect(0, 68351, '\p{Is_Block=_-Avestan}', "");
Expect(1, 68351, '\p{^Is_Block=_-Avestan}', "");
Expect(1, 68351, '\P{Is_Block=_-Avestan}', "");
Expect(0, 68351, '\P{^Is_Block=_-Avestan}', "");
Error('\p{Is_Blk=-AVESTAN:=}');
Error('\P{Is_Blk=-AVESTAN:=}');
Expect(1, 68415, '\p{Is_Blk=avestan}', "");
Expect(0, 68415, '\p{^Is_Blk=avestan}', "");
Expect(0, 68415, '\P{Is_Blk=avestan}', "");
Expect(1, 68415, '\P{^Is_Blk=avestan}', "");
Expect(0, 68351, '\p{Is_Blk=avestan}', "");
Expect(1, 68351, '\p{^Is_Blk=avestan}', "");
Expect(1, 68351, '\P{Is_Blk=avestan}', "");
Expect(0, 68351, '\P{^Is_Blk=avestan}', "");
Expect(1, 68415, '\p{Is_Blk:	__Avestan}', "");
Expect(0, 68415, '\p{^Is_Blk:	__Avestan}', "");
Expect(0, 68415, '\P{Is_Blk:	__Avestan}', "");
Expect(1, 68415, '\P{^Is_Blk:	__Avestan}', "");
Expect(0, 68351, '\p{Is_Blk:	__Avestan}', "");
Expect(1, 68351, '\p{^Is_Blk:	__Avestan}', "");
Expect(1, 68351, '\P{Is_Blk:	__Avestan}', "");
Expect(0, 68351, '\P{^Is_Blk:	__Avestan}', "");
Error('\p{Block=	:=myanmar	Extended-A}');
Error('\P{Block=	:=myanmar	Extended-A}');
Expect(1, 43647, '\p{Block=myanmarextendeda}', "");
Expect(0, 43647, '\p{^Block=myanmarextendeda}', "");
Expect(0, 43647, '\P{Block=myanmarextendeda}', "");
Expect(1, 43647, '\P{^Block=myanmarextendeda}', "");
Expect(0, 43615, '\p{Block=myanmarextendeda}', "");
Expect(1, 43615, '\p{^Block=myanmarextendeda}', "");
Expect(1, 43615, '\P{Block=myanmarextendeda}', "");
Expect(0, 43615, '\P{^Block=myanmarextendeda}', "");
Expect(1, 43647, '\p{Block=-MYANMAR_EXTENDEDA}', "");
Expect(0, 43647, '\p{^Block=-MYANMAR_EXTENDEDA}', "");
Expect(0, 43647, '\P{Block=-MYANMAR_EXTENDEDA}', "");
Expect(1, 43647, '\P{^Block=-MYANMAR_EXTENDEDA}', "");
Expect(0, 43615, '\p{Block=-MYANMAR_EXTENDEDA}', "");
Expect(1, 43615, '\p{^Block=-MYANMAR_EXTENDEDA}', "");
Expect(1, 43615, '\P{Block=-MYANMAR_EXTENDEDA}', "");
Expect(0, 43615, '\P{^Block=-MYANMAR_EXTENDEDA}', "");
Error('\p{Blk=  myanmar EXTENDED:=A}');
Error('\P{Blk=  myanmar EXTENDED:=A}');
Expect(1, 43647, '\p{Blk=myanmarextendeda}', "");
Expect(0, 43647, '\p{^Blk=myanmarextendeda}', "");
Expect(0, 43647, '\P{Blk=myanmarextendeda}', "");
Expect(1, 43647, '\P{^Blk=myanmarextendeda}', "");
Expect(0, 43615, '\p{Blk=myanmarextendeda}', "");
Expect(1, 43615, '\p{^Blk=myanmarextendeda}', "");
Expect(1, 43615, '\P{Blk=myanmarextendeda}', "");
Expect(0, 43615, '\P{^Blk=myanmarextendeda}', "");
Expect(1, 43647, '\p{Blk=-	Myanmar	EXTENDED_A}', "");
Expect(0, 43647, '\p{^Blk=-	Myanmar	EXTENDED_A}', "");
Expect(0, 43647, '\P{Blk=-	Myanmar	EXTENDED_A}', "");
Expect(1, 43647, '\P{^Blk=-	Myanmar	EXTENDED_A}', "");
Expect(0, 43615, '\p{Blk=-	Myanmar	EXTENDED_A}', "");
Expect(1, 43615, '\p{^Blk=-	Myanmar	EXTENDED_A}', "");
Expect(1, 43615, '\P{Blk=-	Myanmar	EXTENDED_A}', "");
Expect(0, 43615, '\P{^Blk=-	Myanmar	EXTENDED_A}', "");
Error('\p{Is_Block=:=myanmar	Extended	a}');
Error('\P{Is_Block=:=myanmar	Extended	a}');
Expect(1, 43647, '\p{Is_Block=myanmarextendeda}', "");
Expect(0, 43647, '\p{^Is_Block=myanmarextendeda}', "");
Expect(0, 43647, '\P{Is_Block=myanmarextendeda}', "");
Expect(1, 43647, '\P{^Is_Block=myanmarextendeda}', "");
Expect(0, 43615, '\p{Is_Block=myanmarextendeda}', "");
Expect(1, 43615, '\p{^Is_Block=myanmarextendeda}', "");
Expect(1, 43615, '\P{Is_Block=myanmarextendeda}', "");
Expect(0, 43615, '\P{^Is_Block=myanmarextendeda}', "");
Expect(1, 43647, '\p{Is_Block=-_Myanmar-Extended-A}', "");
Expect(0, 43647, '\p{^Is_Block=-_Myanmar-Extended-A}', "");
Expect(0, 43647, '\P{Is_Block=-_Myanmar-Extended-A}', "");
Expect(1, 43647, '\P{^Is_Block=-_Myanmar-Extended-A}', "");
Expect(0, 43615, '\p{Is_Block=-_Myanmar-Extended-A}', "");
Expect(1, 43615, '\p{^Is_Block=-_Myanmar-Extended-A}', "");
Expect(1, 43615, '\P{Is_Block=-_Myanmar-Extended-A}', "");
Expect(0, 43615, '\P{^Is_Block=-_Myanmar-Extended-A}', "");
Error('\p{Is_Blk=_/a/Myanmar-EXTENDEDa}');
Error('\P{Is_Blk=_/a/Myanmar-EXTENDEDa}');
Expect(1, 43647, '\p{Is_Blk=myanmarextendeda}', "");
Expect(0, 43647, '\p{^Is_Blk=myanmarextendeda}', "");
Expect(0, 43647, '\P{Is_Blk=myanmarextendeda}', "");
Expect(1, 43647, '\P{^Is_Blk=myanmarextendeda}', "");
Expect(0, 43615, '\p{Is_Blk=myanmarextendeda}', "");
Expect(1, 43615, '\p{^Is_Blk=myanmarextendeda}', "");
Expect(1, 43615, '\P{Is_Blk=myanmarextendeda}', "");
Expect(0, 43615, '\P{^Is_Blk=myanmarextendeda}', "");
Expect(1, 43647, '\p{Is_Blk=-myanmar-ExtendedA}', "");
Expect(0, 43647, '\p{^Is_Blk=-myanmar-ExtendedA}', "");
Expect(0, 43647, '\P{Is_Blk=-myanmar-ExtendedA}', "");
Expect(1, 43647, '\P{^Is_Blk=-myanmar-ExtendedA}', "");
Expect(0, 43615, '\p{Is_Blk=-myanmar-ExtendedA}', "");
Expect(1, 43615, '\p{^Is_Blk=-myanmar-ExtendedA}', "");
Expect(1, 43615, '\P{Is_Blk=-myanmar-ExtendedA}', "");
Expect(0, 43615, '\P{^Is_Blk=-myanmar-ExtendedA}', "");
Error('\p{Block=_Counting:=rod	numerals}');
Error('\P{Block=_Counting:=rod	numerals}');
Expect(1, 119679, '\p{Block=countingrodnumerals}', "");
Expect(0, 119679, '\p{^Block=countingrodnumerals}', "");
Expect(0, 119679, '\P{Block=countingrodnumerals}', "");
Expect(1, 119679, '\P{^Block=countingrodnumerals}', "");
Expect(0, 119647, '\p{Block=countingrodnumerals}', "");
Expect(1, 119647, '\p{^Block=countingrodnumerals}', "");
Expect(1, 119647, '\P{Block=countingrodnumerals}', "");
Expect(0, 119647, '\P{^Block=countingrodnumerals}', "");
Expect(1, 119679, '\p{Block=-Countingrod-Numerals}', "");
Expect(0, 119679, '\p{^Block=-Countingrod-Numerals}', "");
Expect(0, 119679, '\P{Block=-Countingrod-Numerals}', "");
Expect(1, 119679, '\P{^Block=-Countingrod-Numerals}', "");
Expect(0, 119647, '\p{Block=-Countingrod-Numerals}', "");
Expect(1, 119647, '\p{^Block=-Countingrod-Numerals}', "");
Expect(1, 119647, '\P{Block=-Countingrod-Numerals}', "");
Expect(0, 119647, '\P{^Block=-Countingrod-Numerals}', "");
Error('\p{Blk::=COUNTING	RODnumerals}');
Error('\P{Blk::=COUNTING	RODnumerals}');
Expect(1, 119679, '\p{Blk=countingrodnumerals}', "");
Expect(0, 119679, '\p{^Blk=countingrodnumerals}', "");
Expect(0, 119679, '\P{Blk=countingrodnumerals}', "");
Expect(1, 119679, '\P{^Blk=countingrodnumerals}', "");
Expect(0, 119647, '\p{Blk=countingrodnumerals}', "");
Expect(1, 119647, '\p{^Blk=countingrodnumerals}', "");
Expect(1, 119647, '\P{Blk=countingrodnumerals}', "");
Expect(0, 119647, '\P{^Blk=countingrodnumerals}', "");
Expect(1, 119679, '\p{Blk=--COUNTING-ROD	NUMERALS}', "");
Expect(0, 119679, '\p{^Blk=--COUNTING-ROD	NUMERALS}', "");
Expect(0, 119679, '\P{Blk=--COUNTING-ROD	NUMERALS}', "");
Expect(1, 119679, '\P{^Blk=--COUNTING-ROD	NUMERALS}', "");
Expect(0, 119647, '\p{Blk=--COUNTING-ROD	NUMERALS}', "");
Expect(1, 119647, '\p{^Blk=--COUNTING-ROD	NUMERALS}', "");
Expect(1, 119647, '\P{Blk=--COUNTING-ROD	NUMERALS}', "");
Expect(0, 119647, '\P{^Blk=--COUNTING-ROD	NUMERALS}', "");
Error('\p{Is_Block=_/a/counting RodNumerals}');
Error('\P{Is_Block=_/a/counting RodNumerals}');
Expect(1, 119679, '\p{Is_Block=countingrodnumerals}', "");
Expect(0, 119679, '\p{^Is_Block=countingrodnumerals}', "");
Expect(0, 119679, '\P{Is_Block=countingrodnumerals}', "");
Expect(1, 119679, '\P{^Is_Block=countingrodnumerals}', "");
Expect(0, 119647, '\p{Is_Block=countingrodnumerals}', "");
Expect(1, 119647, '\p{^Is_Block=countingrodnumerals}', "");
Expect(1, 119647, '\P{Is_Block=countingrodnumerals}', "");
Expect(0, 119647, '\P{^Is_Block=countingrodnumerals}', "");
Expect(1, 119679, '\p{Is_Block=	 counting-RodNumerals}', "");
Expect(0, 119679, '\p{^Is_Block=	 counting-RodNumerals}', "");
Expect(0, 119679, '\P{Is_Block=	 counting-RodNumerals}', "");
Expect(1, 119679, '\P{^Is_Block=	 counting-RodNumerals}', "");
Expect(0, 119647, '\p{Is_Block=	 counting-RodNumerals}', "");
Expect(1, 119647, '\p{^Is_Block=	 counting-RodNumerals}', "");
Expect(1, 119647, '\P{Is_Block=	 counting-RodNumerals}', "");
Expect(0, 119647, '\P{^Is_Block=	 counting-RodNumerals}', "");
Error('\p{Is_Blk=:=	counting_Rodnumerals}');
Error('\P{Is_Blk=:=	counting_Rodnumerals}');
Expect(1, 119679, '\p{Is_Blk=countingrodnumerals}', "");
Expect(0, 119679, '\p{^Is_Blk=countingrodnumerals}', "");
Expect(0, 119679, '\P{Is_Blk=countingrodnumerals}', "");
Expect(1, 119679, '\P{^Is_Blk=countingrodnumerals}', "");
Expect(0, 119647, '\p{Is_Blk=countingrodnumerals}', "");
Expect(1, 119647, '\p{^Is_Blk=countingrodnumerals}', "");
Expect(1, 119647, '\P{Is_Blk=countingrodnumerals}', "");
Expect(0, 119647, '\P{^Is_Blk=countingrodnumerals}', "");
Expect(1, 119679, '\p{Is_Blk= -Counting-Rod-Numerals}', "");
Expect(0, 119679, '\p{^Is_Blk= -Counting-Rod-Numerals}', "");
Expect(0, 119679, '\P{Is_Blk= -Counting-Rod-Numerals}', "");
Expect(1, 119679, '\P{^Is_Blk= -Counting-Rod-Numerals}', "");
Expect(0, 119647, '\p{Is_Blk= -Counting-Rod-Numerals}', "");
Expect(1, 119647, '\p{^Is_Blk= -Counting-Rod-Numerals}', "");
Expect(1, 119647, '\P{Is_Blk= -Counting-Rod-Numerals}', "");
Expect(0, 119647, '\P{^Is_Blk= -Counting-Rod-Numerals}', "");
Error('\p{Block=-_Byzantine:=Musical_Symbols}');
Error('\P{Block=-_Byzantine:=Musical_Symbols}');
Expect(1, 119039, '\p{Block=byzantinemusicalsymbols}', "");
Expect(0, 119039, '\p{^Block=byzantinemusicalsymbols}', "");
Expect(0, 119039, '\P{Block=byzantinemusicalsymbols}', "");
Expect(1, 119039, '\P{^Block=byzantinemusicalsymbols}', "");
Expect(0, 118783, '\p{Block=byzantinemusicalsymbols}', "");
Expect(1, 118783, '\p{^Block=byzantinemusicalsymbols}', "");
Expect(1, 118783, '\P{Block=byzantinemusicalsymbols}', "");
Expect(0, 118783, '\P{^Block=byzantinemusicalsymbols}', "");
Expect(1, 119039, '\p{Block= -byzantine_Musical	Symbols}', "");
Expect(0, 119039, '\p{^Block= -byzantine_Musical	Symbols}', "");
Expect(0, 119039, '\P{Block= -byzantine_Musical	Symbols}', "");
Expect(1, 119039, '\P{^Block= -byzantine_Musical	Symbols}', "");
Expect(0, 118783, '\p{Block= -byzantine_Musical	Symbols}', "");
Expect(1, 118783, '\p{^Block= -byzantine_Musical	Symbols}', "");
Expect(1, 118783, '\P{Block= -byzantine_Musical	Symbols}', "");
Expect(0, 118783, '\P{^Block= -byzantine_Musical	Symbols}', "");
Error('\p{Blk= 	Byzantine	musical/a/Symbols}');
Error('\P{Blk= 	Byzantine	musical/a/Symbols}');
Expect(1, 119039, '\p{Blk=byzantinemusicalsymbols}', "");
Expect(0, 119039, '\p{^Blk=byzantinemusicalsymbols}', "");
Expect(0, 119039, '\P{Blk=byzantinemusicalsymbols}', "");
Expect(1, 119039, '\P{^Blk=byzantinemusicalsymbols}', "");
Expect(0, 118783, '\p{Blk=byzantinemusicalsymbols}', "");
Expect(1, 118783, '\p{^Blk=byzantinemusicalsymbols}', "");
Expect(1, 118783, '\P{Blk=byzantinemusicalsymbols}', "");
Expect(0, 118783, '\P{^Blk=byzantinemusicalsymbols}', "");
Expect(1, 119039, '\p{Blk=_	byzantine MusicalSYMBOLS}', "");
Expect(0, 119039, '\p{^Blk=_	byzantine MusicalSYMBOLS}', "");
Expect(0, 119039, '\P{Blk=_	byzantine MusicalSYMBOLS}', "");
Expect(1, 119039, '\P{^Blk=_	byzantine MusicalSYMBOLS}', "");
Expect(0, 118783, '\p{Blk=_	byzantine MusicalSYMBOLS}', "");
Expect(1, 118783, '\p{^Blk=_	byzantine MusicalSYMBOLS}', "");
Expect(1, 118783, '\P{Blk=_	byzantine MusicalSYMBOLS}', "");
Expect(0, 118783, '\P{^Blk=_	byzantine MusicalSYMBOLS}', "");
Error('\p{Is_Block: 	BYZANTINE:=MusicalSymbols}');
Error('\P{Is_Block: 	BYZANTINE:=MusicalSymbols}');
Expect(1, 119039, '\p{Is_Block=byzantinemusicalsymbols}', "");
Expect(0, 119039, '\p{^Is_Block=byzantinemusicalsymbols}', "");
Expect(0, 119039, '\P{Is_Block=byzantinemusicalsymbols}', "");
Expect(1, 119039, '\P{^Is_Block=byzantinemusicalsymbols}', "");
Expect(0, 118783, '\p{Is_Block=byzantinemusicalsymbols}', "");
Expect(1, 118783, '\p{^Is_Block=byzantinemusicalsymbols}', "");
Expect(1, 118783, '\P{Is_Block=byzantinemusicalsymbols}', "");
Expect(0, 118783, '\P{^Is_Block=byzantinemusicalsymbols}', "");
Expect(1, 119039, '\p{Is_Block= _byzantineMusical-symbols}', "");
Expect(0, 119039, '\p{^Is_Block= _byzantineMusical-symbols}', "");
Expect(0, 119039, '\P{Is_Block= _byzantineMusical-symbols}', "");
Expect(1, 119039, '\P{^Is_Block= _byzantineMusical-symbols}', "");
Expect(0, 118783, '\p{Is_Block= _byzantineMusical-symbols}', "");
Expect(1, 118783, '\p{^Is_Block= _byzantineMusical-symbols}', "");
Expect(1, 118783, '\P{Is_Block= _byzantineMusical-symbols}', "");
Expect(0, 118783, '\P{^Is_Block= _byzantineMusical-symbols}', "");
Error('\p{Is_Blk=	ByzantineMUSICAL-Symbols/a/}');
Error('\P{Is_Blk=	ByzantineMUSICAL-Symbols/a/}');
Expect(1, 119039, '\p{Is_Blk=byzantinemusicalsymbols}', "");
Expect(0, 119039, '\p{^Is_Blk=byzantinemusicalsymbols}', "");
Expect(0, 119039, '\P{Is_Blk=byzantinemusicalsymbols}', "");
Expect(1, 119039, '\P{^Is_Blk=byzantinemusicalsymbols}', "");
Expect(0, 118783, '\p{Is_Blk=byzantinemusicalsymbols}', "");
Expect(1, 118783, '\p{^Is_Blk=byzantinemusicalsymbols}', "");
Expect(1, 118783, '\P{Is_Blk=byzantinemusicalsymbols}', "");
Expect(0, 118783, '\P{^Is_Blk=byzantinemusicalsymbols}', "");
Expect(1, 119039, '\p{Is_Blk=- byzantineMUSICAL	Symbols}', "");
Expect(0, 119039, '\p{^Is_Blk=- byzantineMUSICAL	Symbols}', "");
Expect(0, 119039, '\P{Is_Blk=- byzantineMUSICAL	Symbols}', "");
Expect(1, 119039, '\P{^Is_Blk=- byzantineMUSICAL	Symbols}', "");
Expect(0, 118783, '\p{Is_Blk=- byzantineMUSICAL	Symbols}', "");
Expect(1, 118783, '\p{^Is_Blk=- byzantineMUSICAL	Symbols}', "");
Expect(1, 118783, '\P{Is_Blk=- byzantineMUSICAL	Symbols}', "");
Expect(0, 118783, '\P{^Is_Blk=- byzantineMUSICAL	Symbols}', "");
Error('\p{Block=/a/	 tamil}');
Error('\P{Block=/a/	 tamil}');
Expect(1, 3071, '\p{Block=tamil}', "");
Expect(0, 3071, '\p{^Block=tamil}', "");
Expect(0, 3071, '\P{Block=tamil}', "");
Expect(1, 3071, '\P{^Block=tamil}', "");
Expect(0, 2943, '\p{Block=tamil}', "");
Expect(1, 2943, '\p{^Block=tamil}', "");
Expect(1, 2943, '\P{Block=tamil}', "");
Expect(0, 2943, '\P{^Block=tamil}', "");
Expect(1, 3071, '\p{Block= 	Tamil}', "");
Expect(0, 3071, '\p{^Block= 	Tamil}', "");
Expect(0, 3071, '\P{Block= 	Tamil}', "");
Expect(1, 3071, '\P{^Block= 	Tamil}', "");
Expect(0, 2943, '\p{Block= 	Tamil}', "");
Expect(1, 2943, '\p{^Block= 	Tamil}', "");
Expect(1, 2943, '\P{Block= 	Tamil}', "");
Expect(0, 2943, '\P{^Block= 	Tamil}', "");
Error('\p{Blk=	:=Tamil}');
Error('\P{Blk=	:=Tamil}');
Expect(1, 3071, '\p{Blk=tamil}', "");
Expect(0, 3071, '\p{^Blk=tamil}', "");
Expect(0, 3071, '\P{Blk=tamil}', "");
Expect(1, 3071, '\P{^Blk=tamil}', "");
Expect(0, 2943, '\p{Blk=tamil}', "");
Expect(1, 2943, '\p{^Blk=tamil}', "");
Expect(1, 2943, '\P{Blk=tamil}', "");
Expect(0, 2943, '\P{^Blk=tamil}', "");
Expect(1, 3071, '\p{Blk=	_Tamil}', "");
Expect(0, 3071, '\p{^Blk=	_Tamil}', "");
Expect(0, 3071, '\P{Blk=	_Tamil}', "");
Expect(1, 3071, '\P{^Blk=	_Tamil}', "");
Expect(0, 2943, '\p{Blk=	_Tamil}', "");
Expect(1, 2943, '\p{^Blk=	_Tamil}', "");
Expect(1, 2943, '\P{Blk=	_Tamil}', "");
Expect(0, 2943, '\P{^Blk=	_Tamil}', "");
Error('\p{Is_Block=/a/-	tamil}');
Error('\P{Is_Block=/a/-	tamil}');
Expect(1, 3071, '\p{Is_Block=tamil}', "");
Expect(0, 3071, '\p{^Is_Block=tamil}', "");
Expect(0, 3071, '\P{Is_Block=tamil}', "");
Expect(1, 3071, '\P{^Is_Block=tamil}', "");
Expect(0, 2943, '\p{Is_Block=tamil}', "");
Expect(1, 2943, '\p{^Is_Block=tamil}', "");
Expect(1, 2943, '\P{Is_Block=tamil}', "");
Expect(0, 2943, '\P{^Is_Block=tamil}', "");
Expect(1, 3071, '\p{Is_Block=  Tamil}', "");
Expect(0, 3071, '\p{^Is_Block=  Tamil}', "");
Expect(0, 3071, '\P{Is_Block=  Tamil}', "");
Expect(1, 3071, '\P{^Is_Block=  Tamil}', "");
Expect(0, 2943, '\p{Is_Block=  Tamil}', "");
Expect(1, 2943, '\p{^Is_Block=  Tamil}', "");
Expect(1, 2943, '\P{Is_Block=  Tamil}', "");
Expect(0, 2943, '\P{^Is_Block=  Tamil}', "");
Error('\p{Is_Blk=  tamil:=}');
Error('\P{Is_Blk=  tamil:=}');
Expect(1, 3071, '\p{Is_Blk=tamil}', "");
Expect(0, 3071, '\p{^Is_Blk=tamil}', "");
Expect(0, 3071, '\P{Is_Blk=tamil}', "");
Expect(1, 3071, '\P{^Is_Blk=tamil}', "");
Expect(0, 2943, '\p{Is_Blk=tamil}', "");
Expect(1, 2943, '\p{^Is_Blk=tamil}', "");
Expect(1, 2943, '\P{Is_Blk=tamil}', "");
Expect(0, 2943, '\P{^Is_Blk=tamil}', "");
Expect(1, 3071, '\p{Is_Blk=	Tamil}', "");
Expect(0, 3071, '\p{^Is_Blk=	Tamil}', "");
Expect(0, 3071, '\P{Is_Blk=	Tamil}', "");
Expect(1, 3071, '\P{^Is_Blk=	Tamil}', "");
Expect(0, 2943, '\p{Is_Blk=	Tamil}', "");
Expect(1, 2943, '\p{^Is_Blk=	Tamil}', "");
Expect(1, 2943, '\P{Is_Blk=	Tamil}', "");
Expect(0, 2943, '\P{^Is_Blk=	Tamil}', "");
Error('\p{Block= :=specials}');
Error('\P{Block= :=specials}');
Expect(1, 65520, '\p{Block=specials}', "");
Expect(0, 65520, '\p{^Block=specials}', "");
Expect(0, 65520, '\P{Block=specials}', "");
Expect(1, 65520, '\P{^Block=specials}', "");
Expect(0, 65519, '\p{Block=specials}', "");
Expect(1, 65519, '\p{^Block=specials}', "");
Expect(1, 65519, '\P{Block=specials}', "");
Expect(0, 65519, '\P{^Block=specials}', "");
Expect(1, 65520, '\p{Block=		Specials}', "");
Expect(0, 65520, '\p{^Block=		Specials}', "");
Expect(0, 65520, '\P{Block=		Specials}', "");
Expect(1, 65520, '\P{^Block=		Specials}', "");
Expect(0, 65519, '\p{Block=		Specials}', "");
Expect(1, 65519, '\p{^Block=		Specials}', "");
Expect(1, 65519, '\P{Block=		Specials}', "");
Expect(0, 65519, '\P{^Block=		Specials}', "");
Error('\p{Blk=  specials/a/}');
Error('\P{Blk=  specials/a/}');
Expect(1, 65520, '\p{Blk=specials}', "");
Expect(0, 65520, '\p{^Blk=specials}', "");
Expect(0, 65520, '\P{Blk=specials}', "");
Expect(1, 65520, '\P{^Blk=specials}', "");
Expect(0, 65519, '\p{Blk=specials}', "");
Expect(1, 65519, '\p{^Blk=specials}', "");
Expect(1, 65519, '\P{Blk=specials}', "");
Expect(0, 65519, '\P{^Blk=specials}', "");
Expect(1, 65520, '\p{Blk= _Specials}', "");
Expect(0, 65520, '\p{^Blk= _Specials}', "");
Expect(0, 65520, '\P{Blk= _Specials}', "");
Expect(1, 65520, '\P{^Blk= _Specials}', "");
Expect(0, 65519, '\p{Blk= _Specials}', "");
Expect(1, 65519, '\p{^Blk= _Specials}', "");
Expect(1, 65519, '\P{Blk= _Specials}', "");
Expect(0, 65519, '\P{^Blk= _Specials}', "");
Error('\p{Is_Block:   _ Specials:=}');
Error('\P{Is_Block:   _ Specials:=}');
Expect(1, 65520, '\p{Is_Block=specials}', "");
Expect(0, 65520, '\p{^Is_Block=specials}', "");
Expect(0, 65520, '\P{Is_Block=specials}', "");
Expect(1, 65520, '\P{^Is_Block=specials}', "");
Expect(0, 65519, '\p{Is_Block=specials}', "");
Expect(1, 65519, '\p{^Is_Block=specials}', "");
Expect(1, 65519, '\P{Is_Block=specials}', "");
Expect(0, 65519, '\P{^Is_Block=specials}', "");
Expect(1, 65520, '\p{Is_Block:__SPECIALS}', "");
Expect(0, 65520, '\p{^Is_Block:__SPECIALS}', "");
Expect(0, 65520, '\P{Is_Block:__SPECIALS}', "");
Expect(1, 65520, '\P{^Is_Block:__SPECIALS}', "");
Expect(0, 65519, '\p{Is_Block:__SPECIALS}', "");
Expect(1, 65519, '\p{^Is_Block:__SPECIALS}', "");
Expect(1, 65519, '\P{Is_Block:__SPECIALS}', "");
Expect(0, 65519, '\P{^Is_Block:__SPECIALS}', "");
Error('\p{Is_Blk=__Specials/a/}');
Error('\P{Is_Blk=__Specials/a/}');
Expect(1, 65520, '\p{Is_Blk=specials}', "");
Expect(0, 65520, '\p{^Is_Blk=specials}', "");
Expect(0, 65520, '\P{Is_Blk=specials}', "");
Expect(1, 65520, '\P{^Is_Blk=specials}', "");
Expect(0, 65519, '\p{Is_Blk=specials}', "");
Expect(1, 65519, '\p{^Is_Blk=specials}', "");
Expect(1, 65519, '\P{Is_Blk=specials}', "");
Expect(0, 65519, '\P{^Is_Blk=specials}', "");
Expect(1, 65520, '\p{Is_Blk:  Specials}', "");
Expect(0, 65520, '\p{^Is_Blk:  Specials}', "");
Expect(0, 65520, '\P{Is_Blk:  Specials}', "");
Expect(1, 65520, '\P{^Is_Blk:  Specials}', "");
Expect(0, 65519, '\p{Is_Blk:  Specials}', "");
Expect(1, 65519, '\p{^Is_Blk:  Specials}', "");
Expect(1, 65519, '\P{Is_Blk:  Specials}', "");
Expect(0, 65519, '\P{^Is_Blk:  Specials}', "");
Error('\p{Block: /a/-	Georgian}');
Error('\P{Block: /a/-	Georgian}');
Expect(1, 4351, '\p{Block=georgian}', "");
Expect(0, 4351, '\p{^Block=georgian}', "");
Expect(0, 4351, '\P{Block=georgian}', "");
Expect(1, 4351, '\P{^Block=georgian}', "");
Expect(0, 4255, '\p{Block=georgian}', "");
Expect(1, 4255, '\p{^Block=georgian}', "");
Expect(1, 4255, '\P{Block=georgian}', "");
Expect(0, 4255, '\P{^Block=georgian}', "");
Expect(1, 4351, '\p{Block=__GEORGIAN}', "");
Expect(0, 4351, '\p{^Block=__GEORGIAN}', "");
Expect(0, 4351, '\P{Block=__GEORGIAN}', "");
Expect(1, 4351, '\P{^Block=__GEORGIAN}', "");
Expect(0, 4255, '\p{Block=__GEORGIAN}', "");
Expect(1, 4255, '\p{^Block=__GEORGIAN}', "");
Expect(1, 4255, '\P{Block=__GEORGIAN}', "");
Expect(0, 4255, '\P{^Block=__GEORGIAN}', "");
Error('\p{Blk=/a/	-Georgian}');
Error('\P{Blk=/a/	-Georgian}');
Expect(1, 4351, '\p{Blk=georgian}', "");
Expect(0, 4351, '\p{^Blk=georgian}', "");
Expect(0, 4351, '\P{Blk=georgian}', "");
Expect(1, 4351, '\P{^Blk=georgian}', "");
Expect(0, 4255, '\p{Blk=georgian}', "");
Expect(1, 4255, '\p{^Blk=georgian}', "");
Expect(1, 4255, '\P{Blk=georgian}', "");
Expect(0, 4255, '\P{^Blk=georgian}', "");
Expect(1, 4351, '\p{Blk=- Georgian}', "");
Expect(0, 4351, '\p{^Blk=- Georgian}', "");
Expect(0, 4351, '\P{Blk=- Georgian}', "");
Expect(1, 4351, '\P{^Blk=- Georgian}', "");
Expect(0, 4255, '\p{Blk=- Georgian}', "");
Expect(1, 4255, '\p{^Blk=- Georgian}', "");
Expect(1, 4255, '\P{Blk=- Georgian}', "");
Expect(0, 4255, '\P{^Blk=- Georgian}', "");
Error('\p{Is_Block=--georgian:=}');
Error('\P{Is_Block=--georgian:=}');
Expect(1, 4351, '\p{Is_Block: georgian}', "");
Expect(0, 4351, '\p{^Is_Block: georgian}', "");
Expect(0, 4351, '\P{Is_Block: georgian}', "");
Expect(1, 4351, '\P{^Is_Block: georgian}', "");
Expect(0, 4255, '\p{Is_Block: georgian}', "");
Expect(1, 4255, '\p{^Is_Block: georgian}', "");
Expect(1, 4255, '\P{Is_Block: georgian}', "");
Expect(0, 4255, '\P{^Is_Block: georgian}', "");
Expect(1, 4351, '\p{Is_Block=	_Georgian}', "");
Expect(0, 4351, '\p{^Is_Block=	_Georgian}', "");
Expect(0, 4351, '\P{Is_Block=	_Georgian}', "");
Expect(1, 4351, '\P{^Is_Block=	_Georgian}', "");
Expect(0, 4255, '\p{Is_Block=	_Georgian}', "");
Expect(1, 4255, '\p{^Is_Block=	_Georgian}', "");
Expect(1, 4255, '\P{Is_Block=	_Georgian}', "");
Expect(0, 4255, '\P{^Is_Block=	_Georgian}', "");
Error('\p{Is_Blk=/a/- GEORGIAN}');
Error('\P{Is_Blk=/a/- GEORGIAN}');
Expect(1, 4351, '\p{Is_Blk=georgian}', "");
Expect(0, 4351, '\p{^Is_Blk=georgian}', "");
Expect(0, 4351, '\P{Is_Blk=georgian}', "");
Expect(1, 4351, '\P{^Is_Blk=georgian}', "");
Expect(0, 4255, '\p{Is_Blk=georgian}', "");
Expect(1, 4255, '\p{^Is_Blk=georgian}', "");
Expect(1, 4255, '\P{Is_Blk=georgian}', "");
Expect(0, 4255, '\P{^Is_Blk=georgian}', "");
Expect(1, 4351, '\p{Is_Blk=	_Georgian}', "");
Expect(0, 4351, '\p{^Is_Blk=	_Georgian}', "");
Expect(0, 4351, '\P{Is_Blk=	_Georgian}', "");
Expect(1, 4351, '\P{^Is_Blk=	_Georgian}', "");
Expect(0, 4255, '\p{Is_Blk=	_Georgian}', "");
Expect(1, 4255, '\p{^Is_Blk=	_Georgian}', "");
Expect(1, 4255, '\P{Is_Blk=	_Georgian}', "");
Expect(0, 4255, '\P{^Is_Blk=	_Georgian}', "");
Error('\p{Block= -KAYAH	Li/a/}');
Error('\P{Block= -KAYAH	Li/a/}');
Expect(1, 43311, '\p{Block=kayahli}', "");
Expect(0, 43311, '\p{^Block=kayahli}', "");
Expect(0, 43311, '\P{Block=kayahli}', "");
Expect(1, 43311, '\P{^Block=kayahli}', "");
Expect(0, 43263, '\p{Block=kayahli}', "");
Expect(1, 43263, '\p{^Block=kayahli}', "");
Expect(1, 43263, '\P{Block=kayahli}', "");
Expect(0, 43263, '\P{^Block=kayahli}', "");
Expect(1, 43311, '\p{Block=_-KAYAH	Li}', "");
Expect(0, 43311, '\p{^Block=_-KAYAH	Li}', "");
Expect(0, 43311, '\P{Block=_-KAYAH	Li}', "");
Expect(1, 43311, '\P{^Block=_-KAYAH	Li}', "");
Expect(0, 43263, '\p{Block=_-KAYAH	Li}', "");
Expect(1, 43263, '\p{^Block=_-KAYAH	Li}', "");
Expect(1, 43263, '\P{Block=_-KAYAH	Li}', "");
Expect(0, 43263, '\P{^Block=_-KAYAH	Li}', "");
Error('\p{Blk=_/a/kayah-LI}');
Error('\P{Blk=_/a/kayah-LI}');
Expect(1, 43311, '\p{Blk=kayahli}', "");
Expect(0, 43311, '\p{^Blk=kayahli}', "");
Expect(0, 43311, '\P{Blk=kayahli}', "");
Expect(1, 43311, '\P{^Blk=kayahli}', "");
Expect(0, 43263, '\p{Blk=kayahli}', "");
Expect(1, 43263, '\p{^Blk=kayahli}', "");
Expect(1, 43263, '\P{Blk=kayahli}', "");
Expect(0, 43263, '\P{^Blk=kayahli}', "");
Expect(1, 43311, '\p{Blk=-Kayah	li}', "");
Expect(0, 43311, '\p{^Blk=-Kayah	li}', "");
Expect(0, 43311, '\P{Blk=-Kayah	li}', "");
Expect(1, 43311, '\P{^Blk=-Kayah	li}', "");
Expect(0, 43263, '\p{Blk=-Kayah	li}', "");
Expect(1, 43263, '\p{^Blk=-Kayah	li}', "");
Expect(1, 43263, '\P{Blk=-Kayah	li}', "");
Expect(0, 43263, '\P{^Blk=-Kayah	li}', "");
Error('\p{Is_Block= :=Kayahli}');
Error('\P{Is_Block= :=Kayahli}');
Expect(1, 43311, '\p{Is_Block=kayahli}', "");
Expect(0, 43311, '\p{^Is_Block=kayahli}', "");
Expect(0, 43311, '\P{Is_Block=kayahli}', "");
Expect(1, 43311, '\P{^Is_Block=kayahli}', "");
Expect(0, 43263, '\p{Is_Block=kayahli}', "");
Expect(1, 43263, '\p{^Is_Block=kayahli}', "");
Expect(1, 43263, '\P{Is_Block=kayahli}', "");
Expect(0, 43263, '\P{^Is_Block=kayahli}', "");
Expect(1, 43311, '\p{Is_Block= _Kayah	Li}', "");
Expect(0, 43311, '\p{^Is_Block= _Kayah	Li}', "");
Expect(0, 43311, '\P{Is_Block= _Kayah	Li}', "");
Expect(1, 43311, '\P{^Is_Block= _Kayah	Li}', "");
Expect(0, 43263, '\p{Is_Block= _Kayah	Li}', "");
Expect(1, 43263, '\p{^Is_Block= _Kayah	Li}', "");
Expect(1, 43263, '\P{Is_Block= _Kayah	Li}', "");
Expect(0, 43263, '\P{^Is_Block= _Kayah	Li}', "");
Error('\p{Is_Blk=	_kayah:=LI}');
Error('\P{Is_Blk=	_kayah:=LI}');
Expect(1, 43311, '\p{Is_Blk=kayahli}', "");
Expect(0, 43311, '\p{^Is_Blk=kayahli}', "");
Expect(0, 43311, '\P{Is_Blk=kayahli}', "");
Expect(1, 43311, '\P{^Is_Blk=kayahli}', "");
Expect(0, 43263, '\p{Is_Blk=kayahli}', "");
Expect(1, 43263, '\p{^Is_Blk=kayahli}', "");
Expect(1, 43263, '\P{Is_Blk=kayahli}', "");
Expect(0, 43263, '\P{^Is_Blk=kayahli}', "");
Expect(1, 43311, '\p{Is_Blk=KAYAH-Li}', "");
Expect(0, 43311, '\p{^Is_Blk=KAYAH-Li}', "");
Expect(0, 43311, '\P{Is_Blk=KAYAH-Li}', "");
Expect(1, 43311, '\P{^Is_Blk=KAYAH-Li}', "");
Expect(0, 43263, '\p{Is_Blk=KAYAH-Li}', "");
Expect(1, 43263, '\p{^Is_Blk=KAYAH-Li}', "");
Expect(1, 43263, '\P{Is_Blk=KAYAH-Li}', "");
Expect(0, 43263, '\P{^Is_Blk=KAYAH-Li}', "");
Error('\p{Block:    _CJKCompatibility forms/a/}');
Error('\P{Block:    _CJKCompatibility forms/a/}');
Expect(1, 65103, '\p{Block=cjkcompatibilityforms}', "");
Expect(0, 65103, '\p{^Block=cjkcompatibilityforms}', "");
Expect(0, 65103, '\P{Block=cjkcompatibilityforms}', "");
Expect(1, 65103, '\P{^Block=cjkcompatibilityforms}', "");
Expect(0, 65071, '\p{Block=cjkcompatibilityforms}', "");
Expect(1, 65071, '\p{^Block=cjkcompatibilityforms}', "");
Expect(1, 65071, '\P{Block=cjkcompatibilityforms}', "");
Expect(0, 65071, '\P{^Block=cjkcompatibilityforms}', "");
Expect(1, 65103, '\p{Block=_	CJK-Compatibility_forms}', "");
Expect(0, 65103, '\p{^Block=_	CJK-Compatibility_forms}', "");
Expect(0, 65103, '\P{Block=_	CJK-Compatibility_forms}', "");
Expect(1, 65103, '\P{^Block=_	CJK-Compatibility_forms}', "");
Expect(0, 65071, '\p{Block=_	CJK-Compatibility_forms}', "");
Expect(1, 65071, '\p{^Block=_	CJK-Compatibility_forms}', "");
Expect(1, 65071, '\P{Block=_	CJK-Compatibility_forms}', "");
Expect(0, 65071, '\P{^Block=_	CJK-Compatibility_forms}', "");
Error('\p{Blk=	 CJK compatibility	Forms/a/}');
Error('\P{Blk=	 CJK compatibility	Forms/a/}');
Expect(1, 65103, '\p{Blk=cjkcompatibilityforms}', "");
Expect(0, 65103, '\p{^Blk=cjkcompatibilityforms}', "");
Expect(0, 65103, '\P{Blk=cjkcompatibilityforms}', "");
Expect(1, 65103, '\P{^Blk=cjkcompatibilityforms}', "");
Expect(0, 65071, '\p{Blk=cjkcompatibilityforms}', "");
Expect(1, 65071, '\p{^Blk=cjkcompatibilityforms}', "");
Expect(1, 65071, '\P{Blk=cjkcompatibilityforms}', "");
Expect(0, 65071, '\P{^Blk=cjkcompatibilityforms}', "");
Expect(1, 65103, '\p{Blk=	 CJKcompatibility Forms}', "");
Expect(0, 65103, '\p{^Blk=	 CJKcompatibility Forms}', "");
Expect(0, 65103, '\P{Blk=	 CJKcompatibility Forms}', "");
Expect(1, 65103, '\P{^Blk=	 CJKcompatibility Forms}', "");
Expect(0, 65071, '\p{Blk=	 CJKcompatibility Forms}', "");
Expect(1, 65071, '\p{^Blk=	 CJKcompatibility Forms}', "");
Expect(1, 65071, '\P{Blk=	 CJKcompatibility Forms}', "");
Expect(0, 65071, '\P{^Blk=	 CJKcompatibility Forms}', "");
Error('\p{Is_Block=/a/--CJK-Compatibilityforms}');
Error('\P{Is_Block=/a/--CJK-Compatibilityforms}');
Expect(1, 65103, '\p{Is_Block=cjkcompatibilityforms}', "");
Expect(0, 65103, '\p{^Is_Block=cjkcompatibilityforms}', "");
Expect(0, 65103, '\P{Is_Block=cjkcompatibilityforms}', "");
Expect(1, 65103, '\P{^Is_Block=cjkcompatibilityforms}', "");
Expect(0, 65071, '\p{Is_Block=cjkcompatibilityforms}', "");
Expect(1, 65071, '\p{^Is_Block=cjkcompatibilityforms}', "");
Expect(1, 65071, '\P{Is_Block=cjkcompatibilityforms}', "");
Expect(0, 65071, '\P{^Is_Block=cjkcompatibilityforms}', "");
Expect(1, 65103, '\p{Is_Block:   _cjk_compatibility-FORMS}', "");
Expect(0, 65103, '\p{^Is_Block:   _cjk_compatibility-FORMS}', "");
Expect(0, 65103, '\P{Is_Block:   _cjk_compatibility-FORMS}', "");
Expect(1, 65103, '\P{^Is_Block:   _cjk_compatibility-FORMS}', "");
Expect(0, 65071, '\p{Is_Block:   _cjk_compatibility-FORMS}', "");
Expect(1, 65071, '\p{^Is_Block:   _cjk_compatibility-FORMS}', "");
Expect(1, 65071, '\P{Is_Block:   _cjk_compatibility-FORMS}', "");
Expect(0, 65071, '\P{^Is_Block:   _cjk_compatibility-FORMS}', "");
Error('\p{Is_Blk: 		CJKCompatibility:=FORMS}');
Error('\P{Is_Blk: 		CJKCompatibility:=FORMS}');
Expect(1, 65103, '\p{Is_Blk=cjkcompatibilityforms}', "");
Expect(0, 65103, '\p{^Is_Blk=cjkcompatibilityforms}', "");
Expect(0, 65103, '\P{Is_Blk=cjkcompatibilityforms}', "");
Expect(1, 65103, '\P{^Is_Blk=cjkcompatibilityforms}', "");
Expect(0, 65071, '\p{Is_Blk=cjkcompatibilityforms}', "");
Expect(1, 65071, '\p{^Is_Blk=cjkcompatibilityforms}', "");
Expect(1, 65071, '\P{Is_Blk=cjkcompatibilityforms}', "");
Expect(0, 65071, '\P{^Is_Blk=cjkcompatibilityforms}', "");
Expect(1, 65103, '\p{Is_Blk= cjk_Compatibility-Forms}', "");
Expect(0, 65103, '\p{^Is_Blk= cjk_Compatibility-Forms}', "");
Expect(0, 65103, '\P{Is_Blk= cjk_Compatibility-Forms}', "");
Expect(1, 65103, '\P{^Is_Blk= cjk_Compatibility-Forms}', "");
Expect(0, 65071, '\p{Is_Blk= cjk_Compatibility-Forms}', "");
Expect(1, 65071, '\p{^Is_Blk= cjk_Compatibility-Forms}', "");
Expect(1, 65071, '\P{Is_Blk= cjk_Compatibility-Forms}', "");
Expect(0, 65071, '\P{^Is_Blk= cjk_Compatibility-Forms}', "");
Error('\p{Block=	/a/Tifinagh}');
Error('\P{Block=	/a/Tifinagh}');
Expect(1, 11647, '\p{Block=tifinagh}', "");
Expect(0, 11647, '\p{^Block=tifinagh}', "");
Expect(0, 11647, '\P{Block=tifinagh}', "");
Expect(1, 11647, '\P{^Block=tifinagh}', "");
Expect(0, 11567, '\p{Block=tifinagh}', "");
Expect(1, 11567, '\p{^Block=tifinagh}', "");
Expect(1, 11567, '\P{Block=tifinagh}', "");
Expect(0, 11567, '\P{^Block=tifinagh}', "");
Expect(1, 11647, '\p{Block=-	TIFINAGH}', "");
Expect(0, 11647, '\p{^Block=-	TIFINAGH}', "");
Expect(0, 11647, '\P{Block=-	TIFINAGH}', "");
Expect(1, 11647, '\P{^Block=-	TIFINAGH}', "");
Expect(0, 11567, '\p{Block=-	TIFINAGH}', "");
Expect(1, 11567, '\p{^Block=-	TIFINAGH}', "");
Expect(1, 11567, '\P{Block=-	TIFINAGH}', "");
Expect(0, 11567, '\P{^Block=-	TIFINAGH}', "");
Error('\p{Blk:   _Tifinagh/a/}');
Error('\P{Blk:   _Tifinagh/a/}');
Expect(1, 11647, '\p{Blk=tifinagh}', "");
Expect(0, 11647, '\p{^Blk=tifinagh}', "");
Expect(0, 11647, '\P{Blk=tifinagh}', "");
Expect(1, 11647, '\P{^Blk=tifinagh}', "");
Expect(0, 11567, '\p{Blk=tifinagh}', "");
Expect(1, 11567, '\p{^Blk=tifinagh}', "");
Expect(1, 11567, '\P{Blk=tifinagh}', "");
Expect(0, 11567, '\P{^Blk=tifinagh}', "");
Expect(1, 11647, '\p{Blk=_	TIFINAGH}', "");
Expect(0, 11647, '\p{^Blk=_	TIFINAGH}', "");
Expect(0, 11647, '\P{Blk=_	TIFINAGH}', "");
Expect(1, 11647, '\P{^Blk=_	TIFINAGH}', "");
Expect(0, 11567, '\p{Blk=_	TIFINAGH}', "");
Expect(1, 11567, '\p{^Blk=_	TIFINAGH}', "");
Expect(1, 11567, '\P{Blk=_	TIFINAGH}', "");
Expect(0, 11567, '\P{^Blk=_	TIFINAGH}', "");
Error('\p{Is_Block=-/a/tifinagh}');
Error('\P{Is_Block=-/a/tifinagh}');
Expect(1, 11647, '\p{Is_Block=tifinagh}', "");
Expect(0, 11647, '\p{^Is_Block=tifinagh}', "");
Expect(0, 11647, '\P{Is_Block=tifinagh}', "");
Expect(1, 11647, '\P{^Is_Block=tifinagh}', "");
Expect(0, 11567, '\p{Is_Block=tifinagh}', "");
Expect(1, 11567, '\p{^Is_Block=tifinagh}', "");
Expect(1, 11567, '\P{Is_Block=tifinagh}', "");
Expect(0, 11567, '\P{^Is_Block=tifinagh}', "");
Expect(1, 11647, '\p{Is_Block: _ Tifinagh}', "");
Expect(0, 11647, '\p{^Is_Block: _ Tifinagh}', "");
Expect(0, 11647, '\P{Is_Block: _ Tifinagh}', "");
Expect(1, 11647, '\P{^Is_Block: _ Tifinagh}', "");
Expect(0, 11567, '\p{Is_Block: _ Tifinagh}', "");
Expect(1, 11567, '\p{^Is_Block: _ Tifinagh}', "");
Expect(1, 11567, '\P{Is_Block: _ Tifinagh}', "");
Expect(0, 11567, '\P{^Is_Block: _ Tifinagh}', "");
Error('\p{Is_Blk=/a/Tifinagh}');
Error('\P{Is_Blk=/a/Tifinagh}');
Expect(1, 11647, '\p{Is_Blk=tifinagh}', "");
Expect(0, 11647, '\p{^Is_Blk=tifinagh}', "");
Expect(0, 11647, '\P{Is_Blk=tifinagh}', "");
Expect(1, 11647, '\P{^Is_Blk=tifinagh}', "");
Expect(0, 11567, '\p{Is_Blk=tifinagh}', "");
Expect(1, 11567, '\p{^Is_Blk=tifinagh}', "");
Expect(1, 11567, '\P{Is_Blk=tifinagh}', "");
Expect(0, 11567, '\P{^Is_Blk=tifinagh}', "");
Expect(1, 11647, '\p{Is_Blk=	Tifinagh}', "");
Expect(0, 11647, '\p{^Is_Blk=	Tifinagh}', "");
Expect(0, 11647, '\P{Is_Blk=	Tifinagh}', "");
Expect(1, 11647, '\P{^Is_Blk=	Tifinagh}', "");
Expect(0, 11567, '\p{Is_Blk=	Tifinagh}', "");
Expect(1, 11567, '\p{^Is_Blk=	Tifinagh}', "");
Expect(1, 11567, '\P{Is_Blk=	Tifinagh}', "");
Expect(0, 11567, '\P{^Is_Blk=	Tifinagh}', "");
Error('\p{Block=-/a/HangulJamoEXTENDED b}');
Error('\P{Block=-/a/HangulJamoEXTENDED b}');
Expect(1, 55295, '\p{Block=hanguljamoextendedb}', "");
Expect(0, 55295, '\p{^Block=hanguljamoextendedb}', "");
Expect(0, 55295, '\P{Block=hanguljamoextendedb}', "");
Expect(1, 55295, '\P{^Block=hanguljamoextendedb}', "");
Expect(0, 55215, '\p{Block=hanguljamoextendedb}', "");
Expect(1, 55215, '\p{^Block=hanguljamoextendedb}', "");
Expect(1, 55215, '\P{Block=hanguljamoextendedb}', "");
Expect(0, 55215, '\P{^Block=hanguljamoextendedb}', "");
Expect(1, 55295, '\p{Block= 	Hangul Jamo_Extended B}', "");
Expect(0, 55295, '\p{^Block= 	Hangul Jamo_Extended B}', "");
Expect(0, 55295, '\P{Block= 	Hangul Jamo_Extended B}', "");
Expect(1, 55295, '\P{^Block= 	Hangul Jamo_Extended B}', "");
Expect(0, 55215, '\p{Block= 	Hangul Jamo_Extended B}', "");
Expect(1, 55215, '\p{^Block= 	Hangul Jamo_Extended B}', "");
Expect(1, 55215, '\P{Block= 	Hangul Jamo_Extended B}', "");
Expect(0, 55215, '\P{^Block= 	Hangul Jamo_Extended B}', "");
Error('\p{Blk=_:=hangul-Jamo extendedB}');
Error('\P{Blk=_:=hangul-Jamo extendedB}');
Expect(1, 55295, '\p{Blk=hanguljamoextendedb}', "");
Expect(0, 55295, '\p{^Blk=hanguljamoextendedb}', "");
Expect(0, 55295, '\P{Blk=hanguljamoextendedb}', "");
Expect(1, 55295, '\P{^Blk=hanguljamoextendedb}', "");
Expect(0, 55215, '\p{Blk=hanguljamoextendedb}', "");
Expect(1, 55215, '\p{^Blk=hanguljamoextendedb}', "");
Expect(1, 55215, '\P{Blk=hanguljamoextendedb}', "");
Expect(0, 55215, '\P{^Blk=hanguljamoextendedb}', "");
Expect(1, 55295, '\p{Blk=_HANGUL	Jamo	Extended-B}', "");
Expect(0, 55295, '\p{^Blk=_HANGUL	Jamo	Extended-B}', "");
Expect(0, 55295, '\P{Blk=_HANGUL	Jamo	Extended-B}', "");
Expect(1, 55295, '\P{^Blk=_HANGUL	Jamo	Extended-B}', "");
Expect(0, 55215, '\p{Blk=_HANGUL	Jamo	Extended-B}', "");
Expect(1, 55215, '\p{^Blk=_HANGUL	Jamo	Extended-B}', "");
Expect(1, 55215, '\P{Blk=_HANGUL	Jamo	Extended-B}', "");
Expect(0, 55215, '\P{^Blk=_HANGUL	Jamo	Extended-B}', "");
Error('\p{Is_Block=	hangul-JAMO/a/EXTENDEDB}');
Error('\P{Is_Block=	hangul-JAMO/a/EXTENDEDB}');
Expect(1, 55295, '\p{Is_Block=hanguljamoextendedb}', "");
Expect(0, 55295, '\p{^Is_Block=hanguljamoextendedb}', "");
Expect(0, 55295, '\P{Is_Block=hanguljamoextendedb}', "");
Expect(1, 55295, '\P{^Is_Block=hanguljamoextendedb}', "");
Expect(0, 55215, '\p{Is_Block=hanguljamoextendedb}', "");
Expect(1, 55215, '\p{^Is_Block=hanguljamoextendedb}', "");
Expect(1, 55215, '\P{Is_Block=hanguljamoextendedb}', "");
Expect(0, 55215, '\P{^Is_Block=hanguljamoextendedb}', "");
Expect(1, 55295, '\p{Is_Block= -HANGUL	jamo extended_B}', "");
Expect(0, 55295, '\p{^Is_Block= -HANGUL	jamo extended_B}', "");
Expect(0, 55295, '\P{Is_Block= -HANGUL	jamo extended_B}', "");
Expect(1, 55295, '\P{^Is_Block= -HANGUL	jamo extended_B}', "");
Expect(0, 55215, '\p{Is_Block= -HANGUL	jamo extended_B}', "");
Expect(1, 55215, '\p{^Is_Block= -HANGUL	jamo extended_B}', "");
Expect(1, 55215, '\P{Is_Block= -HANGUL	jamo extended_B}', "");
Expect(0, 55215, '\P{^Is_Block= -HANGUL	jamo extended_B}', "");
Error('\p{Is_Blk=_Hangul_JAMO/a/EXTENDED-B}');
Error('\P{Is_Blk=_Hangul_JAMO/a/EXTENDED-B}');
Expect(1, 55295, '\p{Is_Blk=hanguljamoextendedb}', "");
Expect(0, 55295, '\p{^Is_Blk=hanguljamoextendedb}', "");
Expect(0, 55295, '\P{Is_Blk=hanguljamoextendedb}', "");
Expect(1, 55295, '\P{^Is_Blk=hanguljamoextendedb}', "");
Expect(0, 55215, '\p{Is_Blk=hanguljamoextendedb}', "");
Expect(1, 55215, '\p{^Is_Blk=hanguljamoextendedb}', "");
Expect(1, 55215, '\P{Is_Blk=hanguljamoextendedb}', "");
Expect(0, 55215, '\P{^Is_Blk=hanguljamoextendedb}', "");
Expect(1, 55295, '\p{Is_Blk=-_HANGUL-Jamo-extendedB}', "");
Expect(0, 55295, '\p{^Is_Blk=-_HANGUL-Jamo-extendedB}', "");
Expect(0, 55295, '\P{Is_Blk=-_HANGUL-Jamo-extendedB}', "");
Expect(1, 55295, '\P{^Is_Blk=-_HANGUL-Jamo-extendedB}', "");
Expect(0, 55215, '\p{Is_Blk=-_HANGUL-Jamo-extendedB}', "");
Expect(1, 55215, '\p{^Is_Blk=-_HANGUL-Jamo-extendedB}', "");
Expect(1, 55215, '\P{Is_Blk=-_HANGUL-Jamo-extendedB}', "");
Expect(0, 55215, '\P{^Is_Blk=-_HANGUL-Jamo-extendedB}', "");
Error('\p{Block=_:=Thai}');
Error('\P{Block=_:=Thai}');
Expect(1, 3711, '\p{Block=thai}', "");
Expect(0, 3711, '\p{^Block=thai}', "");
Expect(0, 3711, '\P{Block=thai}', "");
Expect(1, 3711, '\P{^Block=thai}', "");
Expect(0, 3583, '\p{Block=thai}', "");
Expect(1, 3583, '\p{^Block=thai}', "");
Expect(1, 3583, '\P{Block=thai}', "");
Expect(0, 3583, '\P{^Block=thai}', "");
Expect(1, 3711, '\p{Block= _thai}', "");
Expect(0, 3711, '\p{^Block= _thai}', "");
Expect(0, 3711, '\P{Block= _thai}', "");
Expect(1, 3711, '\P{^Block= _thai}', "");
Expect(0, 3583, '\p{Block= _thai}', "");
Expect(1, 3583, '\p{^Block= _thai}', "");
Expect(1, 3583, '\P{Block= _thai}', "");
Expect(0, 3583, '\P{^Block= _thai}', "");
Error('\p{Blk=--thai/a/}');
Error('\P{Blk=--thai/a/}');
Expect(1, 3711, '\p{Blk=thai}', "");
Expect(0, 3711, '\p{^Blk=thai}', "");
Expect(0, 3711, '\P{Blk=thai}', "");
Expect(1, 3711, '\P{^Blk=thai}', "");
Expect(0, 3583, '\p{Blk=thai}', "");
Expect(1, 3583, '\p{^Blk=thai}', "");
Expect(1, 3583, '\P{Blk=thai}', "");
Expect(0, 3583, '\P{^Blk=thai}', "");
Expect(1, 3711, '\p{Blk=	_Thai}', "");
Expect(0, 3711, '\p{^Blk=	_Thai}', "");
Expect(0, 3711, '\P{Blk=	_Thai}', "");
Expect(1, 3711, '\P{^Blk=	_Thai}', "");
Expect(0, 3583, '\p{Blk=	_Thai}', "");
Expect(1, 3583, '\p{^Blk=	_Thai}', "");
Expect(1, 3583, '\P{Blk=	_Thai}', "");
Expect(0, 3583, '\P{^Blk=	_Thai}', "");
Error('\p{Is_Block=	:=THAI}');
Error('\P{Is_Block=	:=THAI}');
Expect(1, 3711, '\p{Is_Block=thai}', "");
Expect(0, 3711, '\p{^Is_Block=thai}', "");
Expect(0, 3711, '\P{Is_Block=thai}', "");
Expect(1, 3711, '\P{^Is_Block=thai}', "");
Expect(0, 3583, '\p{Is_Block=thai}', "");
Expect(1, 3583, '\p{^Is_Block=thai}', "");
Expect(1, 3583, '\P{Is_Block=thai}', "");
Expect(0, 3583, '\P{^Is_Block=thai}', "");
Expect(1, 3711, '\p{Is_Block= 	Thai}', "");
Expect(0, 3711, '\p{^Is_Block= 	Thai}', "");
Expect(0, 3711, '\P{Is_Block= 	Thai}', "");
Expect(1, 3711, '\P{^Is_Block= 	Thai}', "");
Expect(0, 3583, '\p{Is_Block= 	Thai}', "");
Expect(1, 3583, '\p{^Is_Block= 	Thai}', "");
Expect(1, 3583, '\P{Is_Block= 	Thai}', "");
Expect(0, 3583, '\P{^Is_Block= 	Thai}', "");
Error('\p{Is_Blk::=_ THAI}');
Error('\P{Is_Blk::=_ THAI}');
Expect(1, 3711, '\p{Is_Blk:   thai}', "");
Expect(0, 3711, '\p{^Is_Blk:   thai}', "");
Expect(0, 3711, '\P{Is_Blk:   thai}', "");
Expect(1, 3711, '\P{^Is_Blk:   thai}', "");
Expect(0, 3583, '\p{Is_Blk:   thai}', "");
Expect(1, 3583, '\p{^Is_Blk:   thai}', "");
Expect(1, 3583, '\P{Is_Blk:   thai}', "");
Expect(0, 3583, '\P{^Is_Blk:   thai}', "");
Expect(1, 3711, '\p{Is_Blk: __thai}', "");
Expect(0, 3711, '\p{^Is_Blk: __thai}', "");
Expect(0, 3711, '\P{Is_Blk: __thai}', "");
Expect(1, 3711, '\P{^Is_Blk: __thai}', "");
Expect(0, 3583, '\p{Is_Blk: __thai}', "");
Expect(1, 3583, '\p{^Is_Blk: __thai}', "");
Expect(1, 3583, '\P{Is_Blk: __thai}', "");
Expect(0, 3583, '\P{^Is_Blk: __thai}', "");
Error('\p{Block=	-KHMER:=}');
Error('\P{Block=	-KHMER:=}');
Expect(1, 6143, '\p{Block=khmer}', "");
Expect(0, 6143, '\p{^Block=khmer}', "");
Expect(0, 6143, '\P{Block=khmer}', "");
Expect(1, 6143, '\P{^Block=khmer}', "");
Expect(0, 6015, '\p{Block=khmer}', "");
Expect(1, 6015, '\p{^Block=khmer}', "");
Expect(1, 6015, '\P{Block=khmer}', "");
Expect(0, 6015, '\P{^Block=khmer}', "");
Expect(1, 6143, '\p{Block=	Khmer}', "");
Expect(0, 6143, '\p{^Block=	Khmer}', "");
Expect(0, 6143, '\P{Block=	Khmer}', "");
Expect(1, 6143, '\P{^Block=	Khmer}', "");
Expect(0, 6015, '\p{Block=	Khmer}', "");
Expect(1, 6015, '\p{^Block=	Khmer}', "");
Expect(1, 6015, '\P{Block=	Khmer}', "");
Expect(0, 6015, '\P{^Block=	Khmer}', "");
Error('\p{Blk=:=-_khmer}');
Error('\P{Blk=:=-_khmer}');
Expect(1, 6143, '\p{Blk:khmer}', "");
Expect(0, 6143, '\p{^Blk:khmer}', "");
Expect(0, 6143, '\P{Blk:khmer}', "");
Expect(1, 6143, '\P{^Blk:khmer}', "");
Expect(0, 6015, '\p{Blk:khmer}', "");
Expect(1, 6015, '\p{^Blk:khmer}', "");
Expect(1, 6015, '\P{Blk:khmer}', "");
Expect(0, 6015, '\P{^Blk:khmer}', "");
Expect(1, 6143, '\p{Blk=	 KHMER}', "");
Expect(0, 6143, '\p{^Blk=	 KHMER}', "");
Expect(0, 6143, '\P{Blk=	 KHMER}', "");
Expect(1, 6143, '\P{^Blk=	 KHMER}', "");
Expect(0, 6015, '\p{Blk=	 KHMER}', "");
Expect(1, 6015, '\p{^Blk=	 KHMER}', "");
Expect(1, 6015, '\P{Blk=	 KHMER}', "");
Expect(0, 6015, '\P{^Blk=	 KHMER}', "");
Error('\p{Is_Block=-:=Khmer}');
Error('\P{Is_Block=-:=Khmer}');
Expect(1, 6143, '\p{Is_Block=khmer}', "");
Expect(0, 6143, '\p{^Is_Block=khmer}', "");
Expect(0, 6143, '\P{Is_Block=khmer}', "");
Expect(1, 6143, '\P{^Is_Block=khmer}', "");
Expect(0, 6015, '\p{Is_Block=khmer}', "");
Expect(1, 6015, '\p{^Is_Block=khmer}', "");
Expect(1, 6015, '\P{Is_Block=khmer}', "");
Expect(0, 6015, '\P{^Is_Block=khmer}', "");
Expect(1, 6143, '\p{Is_Block:	__khmer}', "");
Expect(0, 6143, '\p{^Is_Block:	__khmer}', "");
Expect(0, 6143, '\P{Is_Block:	__khmer}', "");
Expect(1, 6143, '\P{^Is_Block:	__khmer}', "");
Expect(0, 6015, '\p{Is_Block:	__khmer}', "");
Expect(1, 6015, '\p{^Is_Block:	__khmer}', "");
Expect(1, 6015, '\P{Is_Block:	__khmer}', "");
Expect(0, 6015, '\P{^Is_Block:	__khmer}', "");
Error('\p{Is_Blk:	:=  khmer}');
Error('\P{Is_Blk:	:=  khmer}');
Expect(1, 6143, '\p{Is_Blk=khmer}', "");
Expect(0, 6143, '\p{^Is_Blk=khmer}', "");
Expect(0, 6143, '\P{Is_Blk=khmer}', "");
Expect(1, 6143, '\P{^Is_Blk=khmer}', "");
Expect(0, 6015, '\p{Is_Blk=khmer}', "");
Expect(1, 6015, '\p{^Is_Blk=khmer}', "");
Expect(1, 6015, '\P{Is_Blk=khmer}', "");
Expect(0, 6015, '\P{^Is_Blk=khmer}', "");
Expect(1, 6143, '\p{Is_Blk=	-khmer}', "");
Expect(0, 6143, '\p{^Is_Blk=	-khmer}', "");
Expect(0, 6143, '\P{Is_Blk=	-khmer}', "");
Expect(1, 6143, '\P{^Is_Blk=	-khmer}', "");
Expect(0, 6015, '\p{Is_Blk=	-khmer}', "");
Expect(1, 6015, '\p{^Is_Blk=	-khmer}', "");
Expect(1, 6015, '\P{Is_Blk=	-khmer}', "");
Expect(0, 6015, '\P{^Is_Blk=	-khmer}', "");
Error('\p{Block=	 Saurashtra:=}');
Error('\P{Block=	 Saurashtra:=}');
Expect(1, 43231, '\p{Block=saurashtra}', "");
Expect(0, 43231, '\p{^Block=saurashtra}', "");
Expect(0, 43231, '\P{Block=saurashtra}', "");
Expect(1, 43231, '\P{^Block=saurashtra}', "");
Expect(0, 43135, '\p{Block=saurashtra}', "");
Expect(1, 43135, '\p{^Block=saurashtra}', "");
Expect(1, 43135, '\P{Block=saurashtra}', "");
Expect(0, 43135, '\P{^Block=saurashtra}', "");
Expect(1, 43231, '\p{Block=_SAURASHTRA}', "");
Expect(0, 43231, '\p{^Block=_SAURASHTRA}', "");
Expect(0, 43231, '\P{Block=_SAURASHTRA}', "");
Expect(1, 43231, '\P{^Block=_SAURASHTRA}', "");
Expect(0, 43135, '\p{Block=_SAURASHTRA}', "");
Expect(1, 43135, '\p{^Block=_SAURASHTRA}', "");
Expect(1, 43135, '\P{Block=_SAURASHTRA}', "");
Expect(0, 43135, '\P{^Block=_SAURASHTRA}', "");
Error('\p{Blk= :=Saurashtra}');
Error('\P{Blk= :=Saurashtra}');
Expect(1, 43231, '\p{Blk=saurashtra}', "");
Expect(0, 43231, '\p{^Blk=saurashtra}', "");
Expect(0, 43231, '\P{Blk=saurashtra}', "");
Expect(1, 43231, '\P{^Blk=saurashtra}', "");
Expect(0, 43135, '\p{Blk=saurashtra}', "");
Expect(1, 43135, '\p{^Blk=saurashtra}', "");
Expect(1, 43135, '\P{Blk=saurashtra}', "");
Expect(0, 43135, '\P{^Blk=saurashtra}', "");
Expect(1, 43231, '\p{Blk=  SAURASHTRA}', "");
Expect(0, 43231, '\p{^Blk=  SAURASHTRA}', "");
Expect(0, 43231, '\P{Blk=  SAURASHTRA}', "");
Expect(1, 43231, '\P{^Blk=  SAURASHTRA}', "");
Expect(0, 43135, '\p{Blk=  SAURASHTRA}', "");
Expect(1, 43135, '\p{^Blk=  SAURASHTRA}', "");
Expect(1, 43135, '\P{Blk=  SAURASHTRA}', "");
Expect(0, 43135, '\P{^Blk=  SAURASHTRA}', "");
Error('\p{Is_Block=_:=saurashtra}');
Error('\P{Is_Block=_:=saurashtra}');
Expect(1, 43231, '\p{Is_Block=saurashtra}', "");
Expect(0, 43231, '\p{^Is_Block=saurashtra}', "");
Expect(0, 43231, '\P{Is_Block=saurashtra}', "");
Expect(1, 43231, '\P{^Is_Block=saurashtra}', "");
Expect(0, 43135, '\p{Is_Block=saurashtra}', "");
Expect(1, 43135, '\p{^Is_Block=saurashtra}', "");
Expect(1, 43135, '\P{Is_Block=saurashtra}', "");
Expect(0, 43135, '\P{^Is_Block=saurashtra}', "");
Expect(1, 43231, '\p{Is_Block=-SAURASHTRA}', "");
Expect(0, 43231, '\p{^Is_Block=-SAURASHTRA}', "");
Expect(0, 43231, '\P{Is_Block=-SAURASHTRA}', "");
Expect(1, 43231, '\P{^Is_Block=-SAURASHTRA}', "");
Expect(0, 43135, '\p{Is_Block=-SAURASHTRA}', "");
Expect(1, 43135, '\p{^Is_Block=-SAURASHTRA}', "");
Expect(1, 43135, '\P{Is_Block=-SAURASHTRA}', "");
Expect(0, 43135, '\P{^Is_Block=-SAURASHTRA}', "");
Error('\p{Is_Blk=_ Saurashtra/a/}');
Error('\P{Is_Blk=_ Saurashtra/a/}');
Expect(1, 43231, '\p{Is_Blk=saurashtra}', "");
Expect(0, 43231, '\p{^Is_Blk=saurashtra}', "");
Expect(0, 43231, '\P{Is_Blk=saurashtra}', "");
Expect(1, 43231, '\P{^Is_Blk=saurashtra}', "");
Expect(0, 43135, '\p{Is_Blk=saurashtra}', "");
Expect(1, 43135, '\p{^Is_Blk=saurashtra}', "");
Expect(1, 43135, '\P{Is_Blk=saurashtra}', "");
Expect(0, 43135, '\P{^Is_Blk=saurashtra}', "");
Expect(1, 43231, '\p{Is_Blk= _Saurashtra}', "");
Expect(0, 43231, '\p{^Is_Blk= _Saurashtra}', "");
Expect(0, 43231, '\P{Is_Blk= _Saurashtra}', "");
Expect(1, 43231, '\P{^Is_Blk= _Saurashtra}', "");
Expect(0, 43135, '\p{Is_Blk= _Saurashtra}', "");
Expect(1, 43135, '\p{^Is_Blk= _Saurashtra}', "");
Expect(1, 43135, '\P{Is_Blk= _Saurashtra}', "");
Expect(0, 43135, '\P{^Is_Blk= _Saurashtra}', "");
Error('\p{Block= _Gujarati:=}');
Error('\P{Block= _Gujarati:=}');
Expect(1, 2815, '\p{Block=gujarati}', "");
Expect(0, 2815, '\p{^Block=gujarati}', "");
Expect(0, 2815, '\P{Block=gujarati}', "");
Expect(1, 2815, '\P{^Block=gujarati}', "");
Expect(0, 2687, '\p{Block=gujarati}', "");
Expect(1, 2687, '\p{^Block=gujarati}', "");
Expect(1, 2687, '\P{Block=gujarati}', "");
Expect(0, 2687, '\P{^Block=gujarati}', "");
Expect(1, 2815, '\p{Block= Gujarati}', "");
Expect(0, 2815, '\p{^Block= Gujarati}', "");
Expect(0, 2815, '\P{Block= Gujarati}', "");
Expect(1, 2815, '\P{^Block= Gujarati}', "");
Expect(0, 2687, '\p{Block= Gujarati}', "");
Expect(1, 2687, '\p{^Block= Gujarati}', "");
Expect(1, 2687, '\P{Block= Gujarati}', "");
Expect(0, 2687, '\P{^Block= Gujarati}', "");
Error('\p{Blk= /a/gujarati}');
Error('\P{Blk= /a/gujarati}');
Expect(1, 2815, '\p{Blk=gujarati}', "");
Expect(0, 2815, '\p{^Blk=gujarati}', "");
Expect(0, 2815, '\P{Blk=gujarati}', "");
Expect(1, 2815, '\P{^Blk=gujarati}', "");
Expect(0, 2687, '\p{Blk=gujarati}', "");
Expect(1, 2687, '\p{^Blk=gujarati}', "");
Expect(1, 2687, '\P{Blk=gujarati}', "");
Expect(0, 2687, '\P{^Blk=gujarati}', "");
Expect(1, 2815, '\p{Blk=-_Gujarati}', "");
Expect(0, 2815, '\p{^Blk=-_Gujarati}', "");
Expect(0, 2815, '\P{Blk=-_Gujarati}', "");
Expect(1, 2815, '\P{^Blk=-_Gujarati}', "");
Expect(0, 2687, '\p{Blk=-_Gujarati}', "");
Expect(1, 2687, '\p{^Blk=-_Gujarati}', "");
Expect(1, 2687, '\P{Blk=-_Gujarati}', "");
Expect(0, 2687, '\P{^Blk=-_Gujarati}', "");
Error('\p{Is_Block=/a/ gujarati}');
Error('\P{Is_Block=/a/ gujarati}');
Expect(1, 2815, '\p{Is_Block: gujarati}', "");
Expect(0, 2815, '\p{^Is_Block: gujarati}', "");
Expect(0, 2815, '\P{Is_Block: gujarati}', "");
Expect(1, 2815, '\P{^Is_Block: gujarati}', "");
Expect(0, 2687, '\p{Is_Block: gujarati}', "");
Expect(1, 2687, '\p{^Is_Block: gujarati}', "");
Expect(1, 2687, '\P{Is_Block: gujarati}', "");
Expect(0, 2687, '\P{^Is_Block: gujarati}', "");
Expect(1, 2815, '\p{Is_Block:	 -gujarati}', "");
Expect(0, 2815, '\p{^Is_Block:	 -gujarati}', "");
Expect(0, 2815, '\P{Is_Block:	 -gujarati}', "");
Expect(1, 2815, '\P{^Is_Block:	 -gujarati}', "");
Expect(0, 2687, '\p{Is_Block:	 -gujarati}', "");
Expect(1, 2687, '\p{^Is_Block:	 -gujarati}', "");
Expect(1, 2687, '\P{Is_Block:	 -gujarati}', "");
Expect(0, 2687, '\P{^Is_Block:	 -gujarati}', "");
Error('\p{Is_Blk=:=GUJARATI}');
Error('\P{Is_Blk=:=GUJARATI}');
Expect(1, 2815, '\p{Is_Blk=gujarati}', "");
Expect(0, 2815, '\p{^Is_Blk=gujarati}', "");
Expect(0, 2815, '\P{Is_Blk=gujarati}', "");
Expect(1, 2815, '\P{^Is_Blk=gujarati}', "");
Expect(0, 2687, '\p{Is_Blk=gujarati}', "");
Expect(1, 2687, '\p{^Is_Blk=gujarati}', "");
Expect(1, 2687, '\P{Is_Blk=gujarati}', "");
Expect(0, 2687, '\P{^Is_Blk=gujarati}', "");
Expect(1, 2815, '\p{Is_Blk=	GUJARATI}', "");
Expect(0, 2815, '\p{^Is_Blk=	GUJARATI}', "");
Expect(0, 2815, '\P{Is_Blk=	GUJARATI}', "");
Expect(1, 2815, '\P{^Is_Blk=	GUJARATI}', "");
Expect(0, 2687, '\p{Is_Blk=	GUJARATI}', "");
Expect(1, 2687, '\p{^Is_Blk=	GUJARATI}', "");
Expect(1, 2687, '\P{Is_Blk=	GUJARATI}', "");
Expect(0, 2687, '\P{^Is_Blk=	GUJARATI}', "");
Error('\p{Block=_-Telugu/a/}');
Error('\P{Block=_-Telugu/a/}');
Expect(1, 3199, '\p{Block=telugu}', "");
Expect(0, 3199, '\p{^Block=telugu}', "");
Expect(0, 3199, '\P{Block=telugu}', "");
Expect(1, 3199, '\P{^Block=telugu}', "");
Expect(0, 3071, '\p{Block=telugu}', "");
Expect(1, 3071, '\p{^Block=telugu}', "");
Expect(1, 3071, '\P{Block=telugu}', "");
Expect(0, 3071, '\P{^Block=telugu}', "");
Expect(1, 3199, '\p{Block=_ telugu}', "");
Expect(0, 3199, '\p{^Block=_ telugu}', "");
Expect(0, 3199, '\P{Block=_ telugu}', "");
Expect(1, 3199, '\P{^Block=_ telugu}', "");
Expect(0, 3071, '\p{Block=_ telugu}', "");
Expect(1, 3071, '\p{^Block=_ telugu}', "");
Expect(1, 3071, '\P{Block=_ telugu}', "");
Expect(0, 3071, '\P{^Block=_ telugu}', "");
Error('\p{Blk=:= 	Telugu}');
Error('\P{Blk=:= 	Telugu}');
Expect(1, 3199, '\p{Blk=telugu}', "");
Expect(0, 3199, '\p{^Blk=telugu}', "");
Expect(0, 3199, '\P{Blk=telugu}', "");
Expect(1, 3199, '\P{^Blk=telugu}', "");
Expect(0, 3071, '\p{Blk=telugu}', "");
Expect(1, 3071, '\p{^Blk=telugu}', "");
Expect(1, 3071, '\P{Blk=telugu}', "");
Expect(0, 3071, '\P{^Blk=telugu}', "");
Expect(1, 3199, '\p{Blk=_Telugu}', "");
Expect(0, 3199, '\p{^Blk=_Telugu}', "");
Expect(0, 3199, '\P{Blk=_Telugu}', "");
Expect(1, 3199, '\P{^Blk=_Telugu}', "");
Expect(0, 3071, '\p{Blk=_Telugu}', "");
Expect(1, 3071, '\p{^Blk=_Telugu}', "");
Expect(1, 3071, '\P{Blk=_Telugu}', "");
Expect(0, 3071, '\P{^Blk=_Telugu}', "");
Error('\p{Is_Block=-/a/Telugu}');
Error('\P{Is_Block=-/a/Telugu}');
Expect(1, 3199, '\p{Is_Block=telugu}', "");
Expect(0, 3199, '\p{^Is_Block=telugu}', "");
Expect(0, 3199, '\P{Is_Block=telugu}', "");
Expect(1, 3199, '\P{^Is_Block=telugu}', "");
Expect(0, 3071, '\p{Is_Block=telugu}', "");
Expect(1, 3071, '\p{^Is_Block=telugu}', "");
Expect(1, 3071, '\P{Is_Block=telugu}', "");
Expect(0, 3071, '\P{^Is_Block=telugu}', "");
Expect(1, 3199, '\p{Is_Block= TELUGU}', "");
Expect(0, 3199, '\p{^Is_Block= TELUGU}', "");
Expect(0, 3199, '\P{Is_Block= TELUGU}', "");
Expect(1, 3199, '\P{^Is_Block= TELUGU}', "");
Expect(0, 3071, '\p{Is_Block= TELUGU}', "");
Expect(1, 3071, '\p{^Is_Block= TELUGU}', "");
Expect(1, 3071, '\P{Is_Block= TELUGU}', "");
Expect(0, 3071, '\P{^Is_Block= TELUGU}', "");
Error('\p{Is_Blk: :=telugu}');
Error('\P{Is_Blk: :=telugu}');
Expect(1, 3199, '\p{Is_Blk:	telugu}', "");
Expect(0, 3199, '\p{^Is_Blk:	telugu}', "");
Expect(0, 3199, '\P{Is_Blk:	telugu}', "");
Expect(1, 3199, '\P{^Is_Blk:	telugu}', "");
Expect(0, 3071, '\p{Is_Blk:	telugu}', "");
Expect(1, 3071, '\p{^Is_Blk:	telugu}', "");
Expect(1, 3071, '\P{Is_Blk:	telugu}', "");
Expect(0, 3071, '\P{^Is_Blk:	telugu}', "");
Expect(1, 3199, '\p{Is_Blk=-TELUGU}', "");
Expect(0, 3199, '\p{^Is_Blk=-TELUGU}', "");
Expect(0, 3199, '\P{Is_Blk=-TELUGU}', "");
Expect(1, 3199, '\P{^Is_Blk=-TELUGU}', "");
Expect(0, 3071, '\p{Is_Blk=-TELUGU}', "");
Expect(1, 3071, '\p{^Is_Blk=-TELUGU}', "");
Expect(1, 3071, '\P{Is_Blk=-TELUGU}', "");
Expect(0, 3071, '\P{^Is_Blk=-TELUGU}', "");
Error('\p{Block= /a/YI	Radicals}');
Error('\P{Block= /a/YI	Radicals}');
Expect(1, 42191, '\p{Block=yiradicals}', "");
Expect(0, 42191, '\p{^Block=yiradicals}', "");
Expect(0, 42191, '\P{Block=yiradicals}', "");
Expect(1, 42191, '\P{^Block=yiradicals}', "");
Expect(0, 42127, '\p{Block=yiradicals}', "");
Expect(1, 42127, '\p{^Block=yiradicals}', "");
Expect(1, 42127, '\P{Block=yiradicals}', "");
Expect(0, 42127, '\P{^Block=yiradicals}', "");
Expect(1, 42191, '\p{Block=	 yiradicals}', "");
Expect(0, 42191, '\p{^Block=	 yiradicals}', "");
Expect(0, 42191, '\P{Block=	 yiradicals}', "");
Expect(1, 42191, '\P{^Block=	 yiradicals}', "");
Expect(0, 42127, '\p{Block=	 yiradicals}', "");
Expect(1, 42127, '\p{^Block=	 yiradicals}', "");
Expect(1, 42127, '\P{Block=	 yiradicals}', "");
Expect(0, 42127, '\P{^Block=	 yiradicals}', "");
Error('\p{Blk=- yi	radicals:=}');
Error('\P{Blk=- yi	radicals:=}');
Expect(1, 42191, '\p{Blk:yiradicals}', "");
Expect(0, 42191, '\p{^Blk:yiradicals}', "");
Expect(0, 42191, '\P{Blk:yiradicals}', "");
Expect(1, 42191, '\P{^Blk:yiradicals}', "");
Expect(0, 42127, '\p{Blk:yiradicals}', "");
Expect(1, 42127, '\p{^Blk:yiradicals}', "");
Expect(1, 42127, '\P{Blk:yiradicals}', "");
Expect(0, 42127, '\P{^Blk:yiradicals}', "");
Expect(1, 42191, '\p{Blk: _	Yi RADICALS}', "");
Expect(0, 42191, '\p{^Blk: _	Yi RADICALS}', "");
Expect(0, 42191, '\P{Blk: _	Yi RADICALS}', "");
Expect(1, 42191, '\P{^Blk: _	Yi RADICALS}', "");
Expect(0, 42127, '\p{Blk: _	Yi RADICALS}', "");
Expect(1, 42127, '\p{^Blk: _	Yi RADICALS}', "");
Expect(1, 42127, '\P{Blk: _	Yi RADICALS}', "");
Expect(0, 42127, '\P{^Blk: _	Yi RADICALS}', "");
Error('\p{Is_Block=_ Yi:=RADICALS}');
Error('\P{Is_Block=_ Yi:=RADICALS}');
Expect(1, 42191, '\p{Is_Block: yiradicals}', "");
Expect(0, 42191, '\p{^Is_Block: yiradicals}', "");
Expect(0, 42191, '\P{Is_Block: yiradicals}', "");
Expect(1, 42191, '\P{^Is_Block: yiradicals}', "");
Expect(0, 42127, '\p{Is_Block: yiradicals}', "");
Expect(1, 42127, '\p{^Is_Block: yiradicals}', "");
Expect(1, 42127, '\P{Is_Block: yiradicals}', "");
Expect(0, 42127, '\P{^Is_Block: yiradicals}', "");
Expect(1, 42191, '\p{Is_Block=	-YiRadicals}', "");
Expect(0, 42191, '\p{^Is_Block=	-YiRadicals}', "");
Expect(0, 42191, '\P{Is_Block=	-YiRadicals}', "");
Expect(1, 42191, '\P{^Is_Block=	-YiRadicals}', "");
Expect(0, 42127, '\p{Is_Block=	-YiRadicals}', "");
Expect(1, 42127, '\p{^Is_Block=	-YiRadicals}', "");
Expect(1, 42127, '\P{Is_Block=	-YiRadicals}', "");
Expect(0, 42127, '\P{^Is_Block=	-YiRadicals}', "");
Error('\p{Is_Blk:	/a/ -Yi-RADICALS}');
Error('\P{Is_Blk:	/a/ -Yi-RADICALS}');
Expect(1, 42191, '\p{Is_Blk=yiradicals}', "");
Expect(0, 42191, '\p{^Is_Blk=yiradicals}', "");
Expect(0, 42191, '\P{Is_Blk=yiradicals}', "");
Expect(1, 42191, '\P{^Is_Blk=yiradicals}', "");
Expect(0, 42127, '\p{Is_Blk=yiradicals}', "");
Expect(1, 42127, '\p{^Is_Blk=yiradicals}', "");
Expect(1, 42127, '\P{Is_Blk=yiradicals}', "");
Expect(0, 42127, '\P{^Is_Blk=yiradicals}', "");
Expect(1, 42191, '\p{Is_Blk=yi	RADICALS}', "");
Expect(0, 42191, '\p{^Is_Blk=yi	RADICALS}', "");
Expect(0, 42191, '\P{Is_Blk=yi	RADICALS}', "");
Expect(1, 42191, '\P{^Is_Blk=yi	RADICALS}', "");
Expect(0, 42127, '\p{Is_Blk=yi	RADICALS}', "");
Expect(1, 42127, '\p{^Is_Blk=yi	RADICALS}', "");
Expect(1, 42127, '\P{Is_Blk=yi	RADICALS}', "");
Expect(0, 42127, '\P{^Is_Blk=yi	RADICALS}', "");
Error('\p{East_Asian_Width=-_Wide:=}');
Error('\P{East_Asian_Width=-_Wide:=}');
Expect(1, 4447, '\p{East_Asian_Width:wide}', "");
Expect(0, 4447, '\p{^East_Asian_Width:wide}', "");
Expect(0, 4447, '\P{East_Asian_Width:wide}', "");
Expect(1, 4447, '\P{^East_Asian_Width:wide}', "");
Expect(0, 4351, '\p{East_Asian_Width:wide}', "");
Expect(1, 4351, '\p{^East_Asian_Width:wide}', "");
Expect(1, 4351, '\P{East_Asian_Width:wide}', "");
Expect(0, 4351, '\P{^East_Asian_Width:wide}', "");
Expect(1, 4447, '\p{East_Asian_Width:   	Wide}', "");
Expect(0, 4447, '\p{^East_Asian_Width:   	Wide}', "");
Expect(0, 4447, '\P{East_Asian_Width:   	Wide}', "");
Expect(1, 4447, '\P{^East_Asian_Width:   	Wide}', "");
Expect(0, 4351, '\p{East_Asian_Width:   	Wide}', "");
Expect(1, 4351, '\p{^East_Asian_Width:   	Wide}', "");
Expect(1, 4351, '\P{East_Asian_Width:   	Wide}', "");
Expect(0, 4351, '\P{^East_Asian_Width:   	Wide}', "");
Error('\p{Ea=_ W:=}');
Error('\P{Ea=_ W:=}');
Expect(1, 4447, '\p{Ea=w}', "");
Expect(0, 4447, '\p{^Ea=w}', "");
Expect(0, 4447, '\P{Ea=w}', "");
Expect(1, 4447, '\P{^Ea=w}', "");
Expect(0, 4351, '\p{Ea=w}', "");
Expect(1, 4351, '\p{^Ea=w}', "");
Expect(1, 4351, '\P{Ea=w}', "");
Expect(0, 4351, '\P{^Ea=w}', "");
Expect(1, 4447, '\p{Ea=-W}', "");
Expect(0, 4447, '\p{^Ea=-W}', "");
Expect(0, 4447, '\P{Ea=-W}', "");
Expect(1, 4447, '\P{^Ea=-W}', "");
Expect(0, 4351, '\p{Ea=-W}', "");
Expect(1, 4351, '\p{^Ea=-W}', "");
Expect(1, 4351, '\P{Ea=-W}', "");
Expect(0, 4351, '\P{^Ea=-W}', "");
Error('\p{Is_East_Asian_Width=_:=wide}');
Error('\P{Is_East_Asian_Width=_:=wide}');
Expect(1, 4447, '\p{Is_East_Asian_Width=wide}', "");
Expect(0, 4447, '\p{^Is_East_Asian_Width=wide}', "");
Expect(0, 4447, '\P{Is_East_Asian_Width=wide}', "");
Expect(1, 4447, '\P{^Is_East_Asian_Width=wide}', "");
Expect(0, 4351, '\p{Is_East_Asian_Width=wide}', "");
Expect(1, 4351, '\p{^Is_East_Asian_Width=wide}', "");
Expect(1, 4351, '\P{Is_East_Asian_Width=wide}', "");
Expect(0, 4351, '\P{^Is_East_Asian_Width=wide}', "");
Expect(1, 4447, '\p{Is_East_Asian_Width=	 Wide}', "");
Expect(0, 4447, '\p{^Is_East_Asian_Width=	 Wide}', "");
Expect(0, 4447, '\P{Is_East_Asian_Width=	 Wide}', "");
Expect(1, 4447, '\P{^Is_East_Asian_Width=	 Wide}', "");
Expect(0, 4351, '\p{Is_East_Asian_Width=	 Wide}', "");
Expect(1, 4351, '\p{^Is_East_Asian_Width=	 Wide}', "");
Expect(1, 4351, '\P{Is_East_Asian_Width=	 Wide}', "");
Expect(0, 4351, '\P{^Is_East_Asian_Width=	 Wide}', "");
Error('\p{Is_Ea=-	W/a/}');
Error('\P{Is_Ea=-	W/a/}');
Expect(1, 4447, '\p{Is_Ea=w}', "");
Expect(0, 4447, '\p{^Is_Ea=w}', "");
Expect(0, 4447, '\P{Is_Ea=w}', "");
Expect(1, 4447, '\P{^Is_Ea=w}', "");
Expect(0, 4351, '\p{Is_Ea=w}', "");
Expect(1, 4351, '\p{^Is_Ea=w}', "");
Expect(1, 4351, '\P{Is_Ea=w}', "");
Expect(0, 4351, '\P{^Is_Ea=w}', "");
Expect(1, 4447, '\p{Is_Ea=_ W}', "");
Expect(0, 4447, '\p{^Is_Ea=_ W}', "");
Expect(0, 4447, '\P{Is_Ea=_ W}', "");
Expect(1, 4447, '\P{^Is_Ea=_ W}', "");
Expect(0, 4351, '\p{Is_Ea=_ W}', "");
Expect(1, 4351, '\p{^Is_Ea=_ W}', "");
Expect(1, 4351, '\P{Is_Ea=_ W}', "");
Expect(0, 4351, '\P{^Is_Ea=_ W}', "");
Error('\p{East_Asian_Width=/a/-fullwidth}');
Error('\P{East_Asian_Width=/a/-fullwidth}');
Expect(1, 12288, '\p{East_Asian_Width=fullwidth}', "");
Expect(0, 12288, '\p{^East_Asian_Width=fullwidth}', "");
Expect(0, 12288, '\P{East_Asian_Width=fullwidth}', "");
Expect(1, 12288, '\P{^East_Asian_Width=fullwidth}', "");
Expect(0, 12287, '\p{East_Asian_Width=fullwidth}', "");
Expect(1, 12287, '\p{^East_Asian_Width=fullwidth}', "");
Expect(1, 12287, '\P{East_Asian_Width=fullwidth}', "");
Expect(0, 12287, '\P{^East_Asian_Width=fullwidth}', "");
Expect(1, 12288, '\p{East_Asian_Width=--FULLWIDTH}', "");
Expect(0, 12288, '\p{^East_Asian_Width=--FULLWIDTH}', "");
Expect(0, 12288, '\P{East_Asian_Width=--FULLWIDTH}', "");
Expect(1, 12288, '\P{^East_Asian_Width=--FULLWIDTH}', "");
Expect(0, 12287, '\p{East_Asian_Width=--FULLWIDTH}', "");
Expect(1, 12287, '\p{^East_Asian_Width=--FULLWIDTH}', "");
Expect(1, 12287, '\P{East_Asian_Width=--FULLWIDTH}', "");
Expect(0, 12287, '\P{^East_Asian_Width=--FULLWIDTH}', "");
Error('\p{Ea=/a/	 F}');
Error('\P{Ea=/a/	 F}');
Expect(1, 12288, '\p{Ea=f}', "");
Expect(0, 12288, '\p{^Ea=f}', "");
Expect(0, 12288, '\P{Ea=f}', "");
Expect(1, 12288, '\P{^Ea=f}', "");
Expect(0, 12287, '\p{Ea=f}', "");
Expect(1, 12287, '\p{^Ea=f}', "");
Expect(1, 12287, '\P{Ea=f}', "");
Expect(0, 12287, '\P{^Ea=f}', "");
Expect(1, 12288, '\p{Ea= F}', "");
Expect(0, 12288, '\p{^Ea= F}', "");
Expect(0, 12288, '\P{Ea= F}', "");
Expect(1, 12288, '\P{^Ea= F}', "");
Expect(0, 12287, '\p{Ea= F}', "");
Expect(1, 12287, '\p{^Ea= F}', "");
Expect(1, 12287, '\P{Ea= F}', "");
Expect(0, 12287, '\P{^Ea= F}', "");
Error('\p{Is_East_Asian_Width=/a/FULLWIDTH}');
Error('\P{Is_East_Asian_Width=/a/FULLWIDTH}');
Expect(1, 12288, '\p{Is_East_Asian_Width=fullwidth}', "");
Expect(0, 12288, '\p{^Is_East_Asian_Width=fullwidth}', "");
Expect(0, 12288, '\P{Is_East_Asian_Width=fullwidth}', "");
Expect(1, 12288, '\P{^Is_East_Asian_Width=fullwidth}', "");
Expect(0, 12287, '\p{Is_East_Asian_Width=fullwidth}', "");
Expect(1, 12287, '\p{^Is_East_Asian_Width=fullwidth}', "");
Expect(1, 12287, '\P{Is_East_Asian_Width=fullwidth}', "");
Expect(0, 12287, '\P{^Is_East_Asian_Width=fullwidth}', "");
Expect(1, 12288, '\p{Is_East_Asian_Width= _fullwidth}', "");
Expect(0, 12288, '\p{^Is_East_Asian_Width= _fullwidth}', "");
Expect(0, 12288, '\P{Is_East_Asian_Width= _fullwidth}', "");
Expect(1, 12288, '\P{^Is_East_Asian_Width= _fullwidth}', "");
Expect(0, 12287, '\p{Is_East_Asian_Width= _fullwidth}', "");
Expect(1, 12287, '\p{^Is_East_Asian_Width= _fullwidth}', "");
Expect(1, 12287, '\P{Is_East_Asian_Width= _fullwidth}', "");
Expect(0, 12287, '\P{^Is_East_Asian_Width= _fullwidth}', "");
Error('\p{Is_Ea= :=F}');
Error('\P{Is_Ea= :=F}');
Expect(1, 12288, '\p{Is_Ea:   f}', "");
Expect(0, 12288, '\p{^Is_Ea:   f}', "");
Expect(0, 12288, '\P{Is_Ea:   f}', "");
Expect(1, 12288, '\P{^Is_Ea:   f}', "");
Expect(0, 12287, '\p{Is_Ea:   f}', "");
Expect(1, 12287, '\p{^Is_Ea:   f}', "");
Expect(1, 12287, '\P{Is_Ea:   f}', "");
Expect(0, 12287, '\P{^Is_Ea:   f}', "");
Expect(1, 12288, '\p{Is_Ea=_F}', "");
Expect(0, 12288, '\p{^Is_Ea=_F}', "");
Expect(0, 12288, '\P{Is_Ea=_F}', "");
Expect(1, 12288, '\P{^Is_Ea=_F}', "");
Expect(0, 12287, '\p{Is_Ea=_F}', "");
Expect(1, 12287, '\p{^Is_Ea=_F}', "");
Expect(1, 12287, '\P{Is_Ea=_F}', "");
Expect(0, 12287, '\P{^Is_Ea=_F}', "");
Error('\p{East_Asian_Width=_/a/Ambiguous}');
Error('\P{East_Asian_Width=_/a/Ambiguous}');
Expect(1, 161, '\p{East_Asian_Width=ambiguous}', "");
Expect(0, 161, '\p{^East_Asian_Width=ambiguous}', "");
Expect(0, 161, '\P{East_Asian_Width=ambiguous}', "");
Expect(1, 161, '\P{^East_Asian_Width=ambiguous}', "");
Expect(0, 160, '\p{East_Asian_Width=ambiguous}', "");
Expect(1, 160, '\p{^East_Asian_Width=ambiguous}', "");
Expect(1, 160, '\P{East_Asian_Width=ambiguous}', "");
Expect(0, 160, '\P{^East_Asian_Width=ambiguous}', "");
Expect(1, 161, '\p{East_Asian_Width= _AMBIGUOUS}', "");
Expect(0, 161, '\p{^East_Asian_Width= _AMBIGUOUS}', "");
Expect(0, 161, '\P{East_Asian_Width= _AMBIGUOUS}', "");
Expect(1, 161, '\P{^East_Asian_Width= _AMBIGUOUS}', "");
Expect(0, 160, '\p{East_Asian_Width= _AMBIGUOUS}', "");
Expect(1, 160, '\p{^East_Asian_Width= _AMBIGUOUS}', "");
Expect(1, 160, '\P{East_Asian_Width= _AMBIGUOUS}', "");
Expect(0, 160, '\P{^East_Asian_Width= _AMBIGUOUS}', "");
Error('\p{Ea: /a/--a}');
Error('\P{Ea: /a/--a}');
Expect(1, 161, '\p{Ea=a}', "");
Expect(0, 161, '\p{^Ea=a}', "");
Expect(0, 161, '\P{Ea=a}', "");
Expect(1, 161, '\P{^Ea=a}', "");
Expect(0, 160, '\p{Ea=a}', "");
Expect(1, 160, '\p{^Ea=a}', "");
Expect(1, 160, '\P{Ea=a}', "");
Expect(0, 160, '\P{^Ea=a}', "");
Expect(1, 161, '\p{Ea:  a}', "");
Expect(0, 161, '\p{^Ea:  a}', "");
Expect(0, 161, '\P{Ea:  a}', "");
Expect(1, 161, '\P{^Ea:  a}', "");
Expect(0, 160, '\p{Ea:  a}', "");
Expect(1, 160, '\p{^Ea:  a}', "");
Expect(1, 160, '\P{Ea:  a}', "");
Expect(0, 160, '\P{^Ea:  a}', "");
Error('\p{Is_East_Asian_Width=/a/_ambiguous}');
Error('\P{Is_East_Asian_Width=/a/_ambiguous}');
Expect(1, 161, '\p{Is_East_Asian_Width=ambiguous}', "");
Expect(0, 161, '\p{^Is_East_Asian_Width=ambiguous}', "");
Expect(0, 161, '\P{Is_East_Asian_Width=ambiguous}', "");
Expect(1, 161, '\P{^Is_East_Asian_Width=ambiguous}', "");
Expect(0, 160, '\p{Is_East_Asian_Width=ambiguous}', "");
Expect(1, 160, '\p{^Is_East_Asian_Width=ambiguous}', "");
Expect(1, 160, '\P{Is_East_Asian_Width=ambiguous}', "");
Expect(0, 160, '\P{^Is_East_Asian_Width=ambiguous}', "");
Expect(1, 161, '\p{Is_East_Asian_Width=	Ambiguous}', "");
Expect(0, 161, '\p{^Is_East_Asian_Width=	Ambiguous}', "");
Expect(0, 161, '\P{Is_East_Asian_Width=	Ambiguous}', "");
Expect(1, 161, '\P{^Is_East_Asian_Width=	Ambiguous}', "");
Expect(0, 160, '\p{Is_East_Asian_Width=	Ambiguous}', "");
Expect(1, 160, '\p{^Is_East_Asian_Width=	Ambiguous}', "");
Expect(1, 160, '\P{Is_East_Asian_Width=	Ambiguous}', "");
Expect(0, 160, '\P{^Is_East_Asian_Width=	Ambiguous}', "");
Error('\p{Is_Ea= A:=}');
Error('\P{Is_Ea= A:=}');
Expect(1, 161, '\p{Is_Ea=a}', "");
Expect(0, 161, '\p{^Is_Ea=a}', "");
Expect(0, 161, '\P{Is_Ea=a}', "");
Expect(1, 161, '\P{^Is_Ea=a}', "");
Expect(0, 160, '\p{Is_Ea=a}', "");
Expect(1, 160, '\p{^Is_Ea=a}', "");
Expect(1, 160, '\P{Is_Ea=a}', "");
Expect(0, 160, '\P{^Is_Ea=a}', "");
Expect(1, 161, '\p{Is_Ea=		A}', "");
Expect(0, 161, '\p{^Is_Ea=		A}', "");
Expect(0, 161, '\P{Is_Ea=		A}', "");
Expect(1, 161, '\P{^Is_Ea=		A}', "");
Expect(0, 160, '\p{Is_Ea=		A}', "");
Expect(1, 160, '\p{^Is_Ea=		A}', "");
Expect(1, 160, '\P{Is_Ea=		A}', "");
Expect(0, 160, '\P{^Is_Ea=		A}', "");
Error('\p{East_Asian_Width=/a/narrow}');
Error('\P{East_Asian_Width=/a/narrow}');
Expect(1, 126, '\p{East_Asian_Width=narrow}', "");
Expect(0, 126, '\p{^East_Asian_Width=narrow}', "");
Expect(0, 126, '\P{East_Asian_Width=narrow}', "");
Expect(1, 126, '\P{^East_Asian_Width=narrow}', "");
Expect(0, 31, '\p{East_Asian_Width=narrow}', "");
Expect(1, 31, '\p{^East_Asian_Width=narrow}', "");
Expect(1, 31, '\P{East_Asian_Width=narrow}', "");
Expect(0, 31, '\P{^East_Asian_Width=narrow}', "");
Expect(1, 126, '\p{East_Asian_Width=	NARROW}', "");
Expect(0, 126, '\p{^East_Asian_Width=	NARROW}', "");
Expect(0, 126, '\P{East_Asian_Width=	NARROW}', "");
Expect(1, 126, '\P{^East_Asian_Width=	NARROW}', "");
Expect(0, 31, '\p{East_Asian_Width=	NARROW}', "");
Expect(1, 31, '\p{^East_Asian_Width=	NARROW}', "");
Expect(1, 31, '\P{East_Asian_Width=	NARROW}', "");
Expect(0, 31, '\P{^East_Asian_Width=	NARROW}', "");
Error('\p{Ea=:=- Na}');
Error('\P{Ea=:=- Na}');
Expect(1, 126, '\p{Ea=na}', "");
Expect(0, 126, '\p{^Ea=na}', "");
Expect(0, 126, '\P{Ea=na}', "");
Expect(1, 126, '\P{^Ea=na}', "");
Expect(0, 31, '\p{Ea=na}', "");
Expect(1, 31, '\p{^Ea=na}', "");
Expect(1, 31, '\P{Ea=na}', "");
Expect(0, 31, '\P{^Ea=na}', "");
Expect(1, 126, '\p{Ea=	 NA}', "");
Expect(0, 126, '\p{^Ea=	 NA}', "");
Expect(0, 126, '\P{Ea=	 NA}', "");
Expect(1, 126, '\P{^Ea=	 NA}', "");
Expect(0, 31, '\p{Ea=	 NA}', "");
Expect(1, 31, '\p{^Ea=	 NA}', "");
Expect(1, 31, '\P{Ea=	 NA}', "");
Expect(0, 31, '\P{^Ea=	 NA}', "");
Error('\p{Is_East_Asian_Width=:=Narrow}');
Error('\P{Is_East_Asian_Width=:=Narrow}');
Expect(1, 126, '\p{Is_East_Asian_Width=narrow}', "");
Expect(0, 126, '\p{^Is_East_Asian_Width=narrow}', "");
Expect(0, 126, '\P{Is_East_Asian_Width=narrow}', "");
Expect(1, 126, '\P{^Is_East_Asian_Width=narrow}', "");
Expect(0, 31, '\p{Is_East_Asian_Width=narrow}', "");
Expect(1, 31, '\p{^Is_East_Asian_Width=narrow}', "");
Expect(1, 31, '\P{Is_East_Asian_Width=narrow}', "");
Expect(0, 31, '\P{^Is_East_Asian_Width=narrow}', "");
Expect(1, 126, '\p{Is_East_Asian_Width=	-Narrow}', "");
Expect(0, 126, '\p{^Is_East_Asian_Width=	-Narrow}', "");
Expect(0, 126, '\P{Is_East_Asian_Width=	-Narrow}', "");
Expect(1, 126, '\P{^Is_East_Asian_Width=	-Narrow}', "");
Expect(0, 31, '\p{Is_East_Asian_Width=	-Narrow}', "");
Expect(1, 31, '\p{^Is_East_Asian_Width=	-Narrow}', "");
Expect(1, 31, '\P{Is_East_Asian_Width=	-Narrow}', "");
Expect(0, 31, '\P{^Is_East_Asian_Width=	-Narrow}', "");
Error('\p{Is_Ea=_	Na:=}');
Error('\P{Is_Ea=_	Na:=}');
Expect(1, 126, '\p{Is_Ea=na}', "");
Expect(0, 126, '\p{^Is_Ea=na}', "");
Expect(0, 126, '\P{Is_Ea=na}', "");
Expect(1, 126, '\P{^Is_Ea=na}', "");
Expect(0, 31, '\p{Is_Ea=na}', "");
Expect(1, 31, '\p{^Is_Ea=na}', "");
Expect(1, 31, '\P{Is_Ea=na}', "");
Expect(0, 31, '\P{^Is_Ea=na}', "");
Expect(1, 126, '\p{Is_Ea=	na}', "");
Expect(0, 126, '\p{^Is_Ea=	na}', "");
Expect(0, 126, '\P{Is_Ea=	na}', "");
Expect(1, 126, '\P{^Is_Ea=	na}', "");
Expect(0, 31, '\p{Is_Ea=	na}', "");
Expect(1, 31, '\p{^Is_Ea=	na}', "");
Expect(1, 31, '\P{Is_Ea=	na}', "");
Expect(0, 31, '\P{^Is_Ea=	na}', "");
Error('\p{East_Asian_Width= -Neutral:=}');
Error('\P{East_Asian_Width= -Neutral:=}');
Expect(1, 31, '\p{East_Asian_Width=neutral}', "");
Expect(0, 31, '\p{^East_Asian_Width=neutral}', "");
Expect(0, 31, '\P{East_Asian_Width=neutral}', "");
Expect(1, 31, '\P{^East_Asian_Width=neutral}', "");
Expect(0, 126, '\p{East_Asian_Width=neutral}', "");
Expect(1, 126, '\p{^East_Asian_Width=neutral}', "");
Expect(1, 126, '\P{East_Asian_Width=neutral}', "");
Expect(0, 126, '\P{^East_Asian_Width=neutral}', "");
Expect(1, 31, '\p{East_Asian_Width:	_NEUTRAL}', "");
Expect(0, 31, '\p{^East_Asian_Width:	_NEUTRAL}', "");
Expect(0, 31, '\P{East_Asian_Width:	_NEUTRAL}', "");
Expect(1, 31, '\P{^East_Asian_Width:	_NEUTRAL}', "");
Expect(0, 126, '\p{East_Asian_Width:	_NEUTRAL}', "");
Expect(1, 126, '\p{^East_Asian_Width:	_NEUTRAL}', "");
Expect(1, 126, '\P{East_Asian_Width:	_NEUTRAL}', "");
Expect(0, 126, '\P{^East_Asian_Width:	_NEUTRAL}', "");
Error('\p{Ea=n/a/}');
Error('\P{Ea=n/a/}');
Expect(1, 31, '\p{Ea=n}', "");
Expect(0, 31, '\p{^Ea=n}', "");
Expect(0, 31, '\P{Ea=n}', "");
Expect(1, 31, '\P{^Ea=n}', "");
Expect(0, 126, '\p{Ea=n}', "");
Expect(1, 126, '\p{^Ea=n}', "");
Expect(1, 126, '\P{Ea=n}', "");
Expect(0, 126, '\P{^Ea=n}', "");
Expect(1, 31, '\p{Ea=--N}', "");
Expect(0, 31, '\p{^Ea=--N}', "");
Expect(0, 31, '\P{Ea=--N}', "");
Expect(1, 31, '\P{^Ea=--N}', "");
Expect(0, 126, '\p{Ea=--N}', "");
Expect(1, 126, '\p{^Ea=--N}', "");
Expect(1, 126, '\P{Ea=--N}', "");
Expect(0, 126, '\P{^Ea=--N}', "");
Error('\p{Is_East_Asian_Width: 	-neutral:=}');
Error('\P{Is_East_Asian_Width: 	-neutral:=}');
Expect(1, 31, '\p{Is_East_Asian_Width=neutral}', "");
Expect(0, 31, '\p{^Is_East_Asian_Width=neutral}', "");
Expect(0, 31, '\P{Is_East_Asian_Width=neutral}', "");
Expect(1, 31, '\P{^Is_East_Asian_Width=neutral}', "");
Expect(0, 126, '\p{Is_East_Asian_Width=neutral}', "");
Expect(1, 126, '\p{^Is_East_Asian_Width=neutral}', "");
Expect(1, 126, '\P{Is_East_Asian_Width=neutral}', "");
Expect(0, 126, '\P{^Is_East_Asian_Width=neutral}', "");
Expect(1, 31, '\p{Is_East_Asian_Width=	NEUTRAL}', "");
Expect(0, 31, '\p{^Is_East_Asian_Width=	NEUTRAL}', "");
Expect(0, 31, '\P{Is_East_Asian_Width=	NEUTRAL}', "");
Expect(1, 31, '\P{^Is_East_Asian_Width=	NEUTRAL}', "");
Expect(0, 126, '\p{Is_East_Asian_Width=	NEUTRAL}', "");
Expect(1, 126, '\p{^Is_East_Asian_Width=	NEUTRAL}', "");
Expect(1, 126, '\P{Is_East_Asian_Width=	NEUTRAL}', "");
Expect(0, 126, '\P{^Is_East_Asian_Width=	NEUTRAL}', "");
Error('\p{Is_Ea=	/a/n}');
Error('\P{Is_Ea=	/a/n}');
Expect(1, 31, '\p{Is_Ea=n}', "");
Expect(0, 31, '\p{^Is_Ea=n}', "");
Expect(0, 31, '\P{Is_Ea=n}', "");
Expect(1, 31, '\P{^Is_Ea=n}', "");
Expect(0, 126, '\p{Is_Ea=n}', "");
Expect(1, 126, '\p{^Is_Ea=n}', "");
Expect(1, 126, '\P{Is_Ea=n}', "");
Expect(0, 126, '\P{^Is_Ea=n}', "");
Expect(1, 31, '\p{Is_Ea=	_N}', "");
Expect(0, 31, '\p{^Is_Ea=	_N}', "");
Expect(0, 31, '\P{Is_Ea=	_N}', "");
Expect(1, 31, '\P{^Is_Ea=	_N}', "");
Expect(0, 126, '\p{Is_Ea=	_N}', "");
Expect(1, 126, '\p{^Is_Ea=	_N}', "");
Expect(1, 126, '\P{Is_Ea=	_N}', "");
Expect(0, 126, '\P{^Is_Ea=	_N}', "");
Error('\p{East_Asian_Width=/a/ Halfwidth}');
Error('\P{East_Asian_Width=/a/ Halfwidth}');
Expect(1, 8361, '\p{East_Asian_Width=halfwidth}', "");
Expect(0, 8361, '\p{^East_Asian_Width=halfwidth}', "");
Expect(0, 8361, '\P{East_Asian_Width=halfwidth}', "");
Expect(1, 8361, '\P{^East_Asian_Width=halfwidth}', "");
Expect(0, 8360, '\p{East_Asian_Width=halfwidth}', "");
Expect(1, 8360, '\p{^East_Asian_Width=halfwidth}', "");
Expect(1, 8360, '\P{East_Asian_Width=halfwidth}', "");
Expect(0, 8360, '\P{^East_Asian_Width=halfwidth}', "");
Expect(1, 8361, '\p{East_Asian_Width:_halfwidth}', "");
Expect(0, 8361, '\p{^East_Asian_Width:_halfwidth}', "");
Expect(0, 8361, '\P{East_Asian_Width:_halfwidth}', "");
Expect(1, 8361, '\P{^East_Asian_Width:_halfwidth}', "");
Expect(0, 8360, '\p{East_Asian_Width:_halfwidth}', "");
Expect(1, 8360, '\p{^East_Asian_Width:_halfwidth}', "");
Expect(1, 8360, '\P{East_Asian_Width:_halfwidth}', "");
Expect(0, 8360, '\P{^East_Asian_Width:_halfwidth}', "");
Error('\p{Ea=	h/a/}');
Error('\P{Ea=	h/a/}');
Expect(1, 8361, '\p{Ea=h}', "");
Expect(0, 8361, '\p{^Ea=h}', "");
Expect(0, 8361, '\P{Ea=h}', "");
Expect(1, 8361, '\P{^Ea=h}', "");
Expect(0, 8360, '\p{Ea=h}', "");
Expect(1, 8360, '\p{^Ea=h}', "");
Expect(1, 8360, '\P{Ea=h}', "");
Expect(0, 8360, '\P{^Ea=h}', "");
Expect(1, 8361, '\p{Ea=	_H}', "");
Expect(0, 8361, '\p{^Ea=	_H}', "");
Expect(0, 8361, '\P{Ea=	_H}', "");
Expect(1, 8361, '\P{^Ea=	_H}', "");
Expect(0, 8360, '\p{Ea=	_H}', "");
Expect(1, 8360, '\p{^Ea=	_H}', "");
Expect(1, 8360, '\P{Ea=	_H}', "");
Expect(0, 8360, '\P{^Ea=	_H}', "");
Error('\p{Is_East_Asian_Width:   :=	halfwidth}');
Error('\P{Is_East_Asian_Width:   :=	halfwidth}');
Expect(1, 8361, '\p{Is_East_Asian_Width=halfwidth}', "");
Expect(0, 8361, '\p{^Is_East_Asian_Width=halfwidth}', "");
Expect(0, 8361, '\P{Is_East_Asian_Width=halfwidth}', "");
Expect(1, 8361, '\P{^Is_East_Asian_Width=halfwidth}', "");
Expect(0, 8360, '\p{Is_East_Asian_Width=halfwidth}', "");
Expect(1, 8360, '\p{^Is_East_Asian_Width=halfwidth}', "");
Expect(1, 8360, '\P{Is_East_Asian_Width=halfwidth}', "");
Expect(0, 8360, '\P{^Is_East_Asian_Width=halfwidth}', "");
Expect(1, 8361, '\p{Is_East_Asian_Width=	HALFWIDTH}', "");
Expect(0, 8361, '\p{^Is_East_Asian_Width=	HALFWIDTH}', "");
Expect(0, 8361, '\P{Is_East_Asian_Width=	HALFWIDTH}', "");
Expect(1, 8361, '\P{^Is_East_Asian_Width=	HALFWIDTH}', "");
Expect(0, 8360, '\p{Is_East_Asian_Width=	HALFWIDTH}', "");
Expect(1, 8360, '\p{^Is_East_Asian_Width=	HALFWIDTH}', "");
Expect(1, 8360, '\P{Is_East_Asian_Width=	HALFWIDTH}', "");
Expect(0, 8360, '\P{^Is_East_Asian_Width=	HALFWIDTH}', "");
Error('\p{Is_Ea=/a/H}');
Error('\P{Is_Ea=/a/H}');
Expect(1, 8361, '\p{Is_Ea:h}', "");
Expect(0, 8361, '\p{^Is_Ea:h}', "");
Expect(0, 8361, '\P{Is_Ea:h}', "");
Expect(1, 8361, '\P{^Is_Ea:h}', "");
Expect(0, 8360, '\p{Is_Ea:h}', "");
Expect(1, 8360, '\p{^Is_Ea:h}', "");
Expect(1, 8360, '\P{Is_Ea:h}', "");
Expect(0, 8360, '\P{^Is_Ea:h}', "");
Expect(1, 8361, '\p{Is_Ea:   H}', "");
Expect(0, 8361, '\p{^Is_Ea:   H}', "");
Expect(0, 8361, '\P{Is_Ea:   H}', "");
Expect(1, 8361, '\P{^Is_Ea:   H}', "");
Expect(0, 8360, '\p{Is_Ea:   H}', "");
Expect(1, 8360, '\p{^Is_Ea:   H}', "");
Expect(1, 8360, '\P{Is_Ea:   H}', "");
Expect(0, 8360, '\P{^Is_Ea:   H}', "");
Error('\p{ASCII_Hex_Digit=/a/		Yes}');
Error('\P{ASCII_Hex_Digit=/a/		Yes}');
Expect(1, 57, '\p{ASCII_Hex_Digit=yes}', "");
Expect(0, 57, '\p{^ASCII_Hex_Digit=yes}', "");
Expect(0, 57, '\P{ASCII_Hex_Digit=yes}', "");
Expect(1, 57, '\P{^ASCII_Hex_Digit=yes}', "");
Expect(0, 47, '\p{ASCII_Hex_Digit=yes}', "");
Expect(1, 47, '\p{^ASCII_Hex_Digit=yes}', "");
Expect(1, 47, '\P{ASCII_Hex_Digit=yes}', "");
Expect(0, 47, '\P{^ASCII_Hex_Digit=yes}', "");
Expect(1, 57, '\p{ASCII_Hex_Digit=-	Yes}', "");
Expect(0, 57, '\p{^ASCII_Hex_Digit=-	Yes}', "");
Expect(0, 57, '\P{ASCII_Hex_Digit=-	Yes}', "");
Expect(1, 57, '\P{^ASCII_Hex_Digit=-	Yes}', "");
Expect(0, 47, '\p{ASCII_Hex_Digit=-	Yes}', "");
Expect(1, 47, '\p{^ASCII_Hex_Digit=-	Yes}', "");
Expect(1, 47, '\P{ASCII_Hex_Digit=-	Yes}', "");
Expect(0, 47, '\P{^ASCII_Hex_Digit=-	Yes}', "");
Error('\p{AHex=/a/	 Y}');
Error('\P{AHex=/a/	 Y}');
Expect(1, 57, '\p{AHex=y}', "");
Expect(0, 57, '\p{^AHex=y}', "");
Expect(0, 57, '\P{AHex=y}', "");
Expect(1, 57, '\P{^AHex=y}', "");
Expect(0, 47, '\p{AHex=y}', "");
Expect(1, 47, '\p{^AHex=y}', "");
Expect(1, 47, '\P{AHex=y}', "");
Expect(0, 47, '\P{^AHex=y}', "");
Expect(1, 57, '\p{AHex=_	Y}', "");
Expect(0, 57, '\p{^AHex=_	Y}', "");
Expect(0, 57, '\P{AHex=_	Y}', "");
Expect(1, 57, '\P{^AHex=_	Y}', "");
Expect(0, 47, '\p{AHex=_	Y}', "");
Expect(1, 47, '\p{^AHex=_	Y}', "");
Expect(1, 47, '\P{AHex=_	Y}', "");
Expect(0, 47, '\P{^AHex=_	Y}', "");
Error('\p{Is_ASCII_Hex_Digit=/a/_T}');
Error('\P{Is_ASCII_Hex_Digit=/a/_T}');
Expect(1, 57, '\p{Is_ASCII_Hex_Digit=t}', "");
Expect(0, 57, '\p{^Is_ASCII_Hex_Digit=t}', "");
Expect(0, 57, '\P{Is_ASCII_Hex_Digit=t}', "");
Expect(1, 57, '\P{^Is_ASCII_Hex_Digit=t}', "");
Expect(0, 47, '\p{Is_ASCII_Hex_Digit=t}', "");
Expect(1, 47, '\p{^Is_ASCII_Hex_Digit=t}', "");
Expect(1, 47, '\P{Is_ASCII_Hex_Digit=t}', "");
Expect(0, 47, '\P{^Is_ASCII_Hex_Digit=t}', "");
Expect(1, 57, '\p{Is_ASCII_Hex_Digit=	t}', "");
Expect(0, 57, '\p{^Is_ASCII_Hex_Digit=	t}', "");
Expect(0, 57, '\P{Is_AS