#!/bin/sh
source cs00_common.sh
PFX="${LOGDIR}/cs03"
TASK="--fifo=MAX"

if [ ! -e /proc/cabi/cabi_status ] ; then
    echo "ERROR cabi disable!"
    exit 1
fi

TEST="1_AO"
echo "[ TEST ] ${TEST} START"
AOCOUNT=200
COUNT=4
for (( i=0; i < $COUNT ; i=i+1 )) ; do
    TOTALCOUNT=$( expr ${i} \* ${AOCOUNT} )
    if [ ${TOTALCOUNT} == 0 ] ; then
        TOTALCOUNT="000"
    fi
    LOGNAME="${PFX}_${TEST}${TOTALCOUNT}_${LOGNAMEBASE}"
    RESULT="${LOGNAME}.result"
    echo "AO count=${TOTALCOUNT}" > ${RESULT}
    if [ $i != 0 ] ; then
        ctcreate --count=$AOCOUNT --TERM_SIGNAL --sig=0 --cpu_time=1 --cpu_period=2 &> /dev/null
        if [ $? != 0 ] ; then
            echo "[ TEST ] ${TEST} fail"
            exit 1
        fi
    fi
    echo "free memory count AO ${TOTALCOUNT}"
    sleep 1
    free -b >> ${RESULT}
done

for (( i=0; i < $COUNT ; i=i+1 )) ; do
    TOTALCOUNT=$( expr ${i} \* ${AOCOUNT} )
    if [ ${TOTALCOUNT} == 0 ] ; then
        TOTALCOUNT="000"
    fi
    LOGNAME="${PFX}_${TEST}_${TOTALCOUNT}_${LOGNAMEBASE}"
    RESULT="${LOGNAME}.result"
    echo "output result ${RESULT}"
done
echo "[ TEST ] ${TEST} SUCCESS"
echo ""
echo ""

ctdestroy `cabiid`
