/*
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <cabi/cabi_error.h>
#include <unistd.h>
#include "common.h"

int main (int argc, char **argv)
{
	int ret, c, index = 0, showpgid = 0;
	unsigned long cabiid = -1;
	pid_t pgid;
	struct option *options;
	static struct option ctbindpgid_options[] = {
		{"showpgid", no_argument, 0, 's'},	/* 52  */
		{0,0,0,0},
	};


	/* make option table */
	options = append_common_options(ctbindpgid_options, 0);
	options = append_cabiid_options(options, 1);
	options = append_pgid_options(options, 1);

	c = 0;
	while( c != -1 ){
		c = getopt_long_only (argc, argv, "", options, &index);

		switch( c ){
		case 's':
			showpgid = 1;
			break;
		case -1:	// end of argument
			break;
		default:
			if ( !check_common(c, options, index) ){
				// accept argument : NOP
			} else if ( !check_cabiid(c, options, index, &cabiid) ){
				// accept argument : NOP
			} else if ( !check_pgid(c, options, index, &pgid) ){
				// accept argument : NOP
			} else {
				unknown_option(index, c, optarg);
			}
		}
	}
	
	/* --showpgid  */
	if ( showpgid ){
		cabi_information("PREV pid=%d pgid=%d\n", getpid(), getpgrp());
	}
	cabi_export_int(ENV_CT_PREV_PGID, getpgrp());
	
	ret = cabi_account_bind_pgid(cabiid, pgid);
	
	/* --showpgid  */
	if ( showpgid ){
		cabi_information("POST pid=%d pgid=%d\n", getpid(), getpgrp());
	}
	cabi_export_int(ENV_CT_POST_PGID, getpgrp());
	
	check_setarg_cabiid(0, "Usage: ctbindpgid --cabiid=x");
	check_setarg_pgid(0, "Usage: ctbindpgid --pgid=x");
	cabi_result(ret, 1);

	cabi_information("account bind pgid. object_id [%lu(0x%lx)] pgid [%d(0x%x)]\n",
			 cabiid, cabiid, pgid, pgid);
	
	return 0;	
}


