/*
 * ctgetstatus
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <cabi/cabi_error.h>
#include "common.h"

#define STATUS_ADR	0x01
#define COUNT_ADR	0x02

#define CT_STATUS_MARK_L "<<<CTSTATUS"
#define CT_STATUS_MARK_R "CTSTATUS>>>"
#define CT_COUNT_MARK_L "<<<CTCOUNT"
#define CT_COUNT_MARK_R "CTCOUNT>>>"

int main (int argc, char **argv)
{
	int ret, c, index = 0;
	unsigned long cabiid = -1;
	struct option *options;
        static struct option ctgetstatus_options[] = {
                {"status_adr", required_argument, 0, STATUS_ADR},
                {"count_adr", required_argument, 0, COUNT_ADR},
                {0,0,0,0},
        };
        int status=0;
        int *statusp=NULL;
	unsigned long count=0;
	unsigned long *countp=NULL;
	int setstatus_adr=-1;
	int setcount_adr=-1;

	/* make option table */
	options = append_common_options(ctgetstatus_options, 0);
	options = append_cabiid_options(options, 1);

	c = 0;
	while( c != -1 ){
		c = getopt_long_only (argc, argv, "", options, &index);

		switch( c ){
                case STATUS_ADR:
                        setstatus_adr = parse_int(options[index].name, optarg);
                        break;
                case COUNT_ADR:
                        setcount_adr = parse_int(options[index].name, optarg);
                        break;
		case -1:	// end of argument
			break;
		default:
			if ( !check_common(c, options, index) ){
				// accept argument : NOP
			} else if ( !check_cabiid(c, options, index, &cabiid) ){
				// accept argument : NOP
			} else {
				unknown_option(index, c, optarg);
			}
		}
	}

        /* --status_adr=0 */
        if (setstatus_adr == -1) {
                statusp = &status;
        } else {
                statusp = (unsigned int *)setstatus_adr;
        }

        /* --count_adr=0 */
        if (setcount_adr == -1) {
                countp = &count;
        } else {
                countp = (unsigned long *)setcount_adr;
        }

	cabi_information("get status. object_id [%lu(0x%lx)] status_adr[%p] count_adr[%p]\n", cabiid, cabiid, statusp, countp);
	ret = cabi_get_status(cabiid, statusp, countp);
        if ( setstatus_adr == -1 ) {
                if (cabi_export()) {
                        cabi_information("%s%d%s\n",
                                         CT_STATUS_MARK_L, status, CT_STATUS_MARK_R);
                } else {
                        cabi_information("AO get status status=%d\n", status);
                }
        }
        if ( setcount_adr == -1 ) {
                if (cabi_export()) {
                        cabi_information("%s%lu%s\n",
                                         CT_COUNT_MARK_L, count, CT_COUNT_MARK_R);
                } else {
                        cabi_information("AO get status count=%lu\n", count);
                }
        }
	check_setarg_cabiid(0, "Usage: ctgetbindpid --cabiid=x");
	cabi_result(ret, 1);

	return 0;
}


