/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.MulticastService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.browser.ExternalControl;
import com.limegroup.gnutella.chat.ChatManager;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.http.HTTPRequestMethod;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SettingsHandler;
import com.limegroup.gnutella.statistics.HTTPStat;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Random12;
import com.sun.java.util.collections.Arrays;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Acceptor
implements Runnable {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor));
    static long INCOMING_EXPIRE_TIME = 540000000L;
    static long WAIT_TIME_AFTER_REQUESTS = 30000L;
    static long TIME_BETWEEN_VALIDATES = 2400000L;
    private volatile ServerSocket _socket = null;
    private volatile int _port = 6346;
    private final Object SOCKET_LOCK = new Object();
    private static byte[] _address = new byte[4];
    private static byte[] _externalAddress = new byte[4];
    private volatile boolean _acceptedIncoming = false;
    private volatile long _lastIncomingTime = 0L;
    private volatile long _lastConnectBackTime = System.currentTimeMillis();
    private static final boolean RECORD_STATS = !CommonUtils.isJava118();
    static /* synthetic */ Class class$com$limegroup$gnutella$Acceptor;

    void resetLastConnectBackTime() {
        this._lastConnectBackTime = System.currentTimeMillis() - INCOMING_EXPIRE_TIME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAddress(InetAddress address) {
        byte[] byteAddr = address.getAddress();
        if (!NetworkUtils.isValidAddress(byteAddr)) {
            return;
        }
        if (byteAddr[0] == 127 && ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return;
        }
        boolean addrChanged = false;
        Class clazz = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
        synchronized (clazz) {
            if (!Arrays.equals((byte[])_address, (byte[])byteAddr)) {
                _address = byteAddr;
                addrChanged = true;
            }
        }
        if (addrChanged) {
            RouterService.addressChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExternalAddress(InetAddress address) {
        byte[] byteAddr = address.getAddress();
        if (byteAddr[0] == 127 && ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return;
        }
        Class clazz = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
        synchronized (clazz) {
            _externalAddress = byteAddr;
        }
    }

    public void start() {
        MulticastService.instance().start();
        UDPService.instance().start();
        ManagedThread at = new ManagedThread(this, "Acceptor");
        at.setDaemon(true);
        at.start();
        RouterService.schedule(new IncomingValidator(), TIME_BETWEEN_VALIDATES, TIME_BETWEEN_VALIDATES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAddressExternal() {
        if (!ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return true;
        }
        Class clazz = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
        synchronized (clazz) {
            return Arrays.equals((byte[])this.getAddress(true), (byte[])_externalAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getExternalAddress() {
        Class clazz = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
        synchronized (clazz) {
            return _externalAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getAddress(boolean checkForce) {
        if (checkForce && ConnectionSettings.FORCE_IP_ADDRESS.getValue()) {
            String address = ConnectionSettings.FORCED_IP_ADDRESS_STRING.getValue();
            try {
                InetAddress ia = InetAddress.getByName(address);
                return ia.getAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        Class clazz = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
        synchronized (clazz) {
            return _address;
        }
    }

    public int getPort(boolean checkForce) {
        if (checkForce && ConnectionSettings.FORCE_IP_ADDRESS.getValue()) {
            return ConnectionSettings.FORCED_PORT.getValue();
        }
        return this._port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListeningPort(int port) throws IOException {
        LOG.trace((Object)"Acceptor.setListeningPort(): entered.");
        if (this._socket != null && this._port == port) {
            return;
        }
        if (port == 0) {
            LOG.trace((Object)"Acceptor.setListeningPort(): shutting off service.");
            if (this._socket != null) {
                try {
                    this._socket.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            Object e = this.SOCKET_LOCK;
            synchronized (e) {
                this._socket = null;
                this._port = 0;
                this.SOCKET_LOCK.notify();
            }
            UDPService.instance().setListeningSocket(null);
            MulticastService.instance().setListeningSocket(null);
            LOG.trace((Object)"Acceptor.setListeningPort(): service OFF.");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Acceptor.setListeningPort(): changing port to " + port));
        }
        DatagramSocket udpServiceSocket = UDPService.instance().newListeningSocket(port);
        LOG.trace((Object)"Acceptor.setListeningPort(): UDP Service is ready.");
        MulticastSocket mcastServiceSocket = null;
        try {
            InetAddress mgroup = InetAddress.getByName(ConnectionSettings.MULTICAST_ADDRESS.getValue());
            mcastServiceSocket = MulticastService.instance().newListeningSocket(ConnectionSettings.MULTICAST_PORT.getValue(), mgroup);
            LOG.trace((Object)"Acceptor.setListeningPort(): Multicast Service is ready.");
        }
        catch (IOException e) {
            mcastServiceSocket = null;
            LOG.debug((Object)"Acceptor.setListeningPort(): Unable to start multicast service.", (Throwable)e);
        }
        ServerSocket newSocket = null;
        try {
            newSocket = new ServerSocket(port);
        }
        catch (IOException e) {
            udpServiceSocket.close();
            throw e;
        }
        catch (IllegalArgumentException e) {
            udpServiceSocket.close();
            throw new IOException("could not create a listening socket");
        }
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        Object object = this.SOCKET_LOCK;
        synchronized (object) {
            this._socket = newSocket;
            this._port = port;
            this.SOCKET_LOCK.notify();
        }
        LOG.trace((Object)"Acceptor.setListeningPort(): I am ready.");
        UDPService.instance().setListeningSocket(udpServiceSocket);
        if (mcastServiceSocket != null) {
            MulticastService.instance().setListeningSocket(mcastServiceSocket);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Acceptor.setListeningPort(): listening UDP/TCP on " + this._port));
        }
    }

    public boolean acceptedIncoming() {
        return this._acceptedIncoming;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        IOException socketError;
        int oldPort;
        block32: {
            int tempPort = ConnectionSettings.PORT.getValue();
            try {
                this.setAddress(InetAddress.getLocalHost());
            }
            catch (UnknownHostException e) {
            }
            catch (SecurityException e) {
                // empty catch block
            }
            oldPort = tempPort;
            socketError = null;
            try {
                this.setListeningPort(tempPort);
                this._port = tempPort;
            }
            catch (IOException e) {
                socketError = e;
                int numToTry = 20;
                Random12 gen = null;
                for (int i = 0; i < numToTry; ++i) {
                    if (i < 10) {
                        tempPort = i + 6346;
                    } else {
                        if (gen == null) {
                            gen = new Random12();
                        }
                        tempPort = gen.nextInt(50000);
                        tempPort += 2000;
                    }
                    if (tempPort == ConnectionSettings.MULTICAST_PORT.getValue()) {
                        ++numToTry;
                        continue;
                    }
                    try {
                        this.setListeningPort(tempPort);
                        this._port = tempPort;
                        break;
                    }
                    catch (IOException e2) {
                        socketError = e2;
                    }
                }
                if (this._socket != null) break block32;
                MessageService.showError("ERROR_NO_PORTS_AVAILABLE");
            }
        }
        socketError = null;
        if (this._port != oldPort) {
            ConnectionSettings.PORT.setValue(this._port);
            SettingsHandler.save();
            RouterService.addressChanged();
        }
        while (true) {
            try {
                while (true) {
                    Socket client = null;
                    Object numToTry = this.SOCKET_LOCK;
                    synchronized (numToTry) {
                        if (this._socket != null) {
                            try {
                                client = this._socket.accept();
                            }
                            catch (IOException e) {
                                continue;
                            }
                        }
                        try {
                            this.SOCKET_LOCK.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        continue;
                    }
                    InetAddress address = client.getInetAddress();
                    if (this.isBannedIP(address.getHostAddress())) {
                        if (RECORD_STATS) {
                            HTTPStat.BANNED_REQUESTS.incrementStat();
                        }
                        client.close();
                        continue;
                    }
                    InetAddress localAddress = client.getLocalAddress();
                    this.setAddress(localAddress);
                    if (this.isOutsideConnection(address)) {
                        Class i = class$com$limegroup$gnutella$Acceptor == null ? Acceptor.class$("com.limegroup.gnutella.Acceptor") : class$com$limegroup$gnutella$Acceptor;
                        synchronized (i) {
                            this._acceptedIncoming = true;
                            ConnectionSettings.EVER_ACCEPTED_INCOMING.setValue(this._acceptedIncoming);
                            this._lastIncomingTime = System.currentTimeMillis();
                        }
                    }
                    ConnectionDispatchRunner dispatcher = new ConnectionDispatchRunner(client);
                    ManagedThread dispatchThread = new ManagedThread(dispatcher, "ConnectionDispatchRunner");
                    dispatchThread.setDaemon(true);
                    dispatchThread.start();
                }
            }
            catch (SecurityException e) {
                ErrorService.error(e);
                continue;
            }
            catch (Throwable e) {
                ErrorService.error(e);
                continue;
            }
            break;
        }
    }

    private boolean isOutsideConnection(InetAddress addr) {
        if (!ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return true;
        }
        String host = addr.getHostAddress();
        byte[] bytes = addr.getAddress();
        return !RouterService.getConnectionManager().isConnectedTo(host) && !NetworkUtils.isCloseIP(bytes, this.getAddress(false)) && !NetworkUtils.isLocalAddress(addr);
    }

    public boolean isBannedIP(String ip) {
        return !IPFilter.instance().allow(ip);
    }

    public boolean isBannedIP(byte[] addr) {
        return !IPFilter.instance().allow(addr);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ boolean access$102(Acceptor x0, boolean x1) {
        x0._acceptedIncoming = x1;
        return x0._acceptedIncoming;
    }

    private class IncomingValidator
    implements Runnable {
        public void run() {
            long currTime = System.currentTimeMillis();
            ConnectionManager cm = RouterService.getConnectionManager();
            if ((Acceptor.this._acceptedIncoming && currTime - Acceptor.this._lastIncomingTime > INCOMING_EXPIRE_TIME || !Acceptor.this._acceptedIncoming && currTime - Acceptor.this._lastConnectBackTime > INCOMING_EXPIRE_TIME) && cm.sendTCPConnectBackRequests()) {
                Acceptor.this._lastConnectBackTime = System.currentTimeMillis();
                Runnable checkThread = new Runnable(this, currTime){
                    private final /* synthetic */ long val$currTime;
                    private final /* synthetic */ IncomingValidator this$1;
                    {
                        this.this$1 = this$1;
                        this.val$currTime = val$currTime;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Class clazz = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
                        synchronized (clazz) {
                            if (Acceptor.access$200(IncomingValidator.access$400(this.this$1)) < this.val$currTime) {
                                Acceptor.access$102(IncomingValidator.access$400(this.this$1), false);
                            }
                        }
                    }
                };
                RouterService.schedule(checkThread, WAIT_TIME_AFTER_REQUESTS, 0L);
            }
        }

        static /* synthetic */ Acceptor access$400(IncomingValidator x0) {
            return x0.Acceptor.this;
        }
    }

    private static class ConnectionDispatchRunner
    implements Runnable {
        private final Socket _socket;

        public ConnectionDispatchRunner(Socket socket) {
            this._socket = socket;
        }

        public void run() {
            block26: {
                ConnectionManager cm = RouterService.getConnectionManager();
                UploadManager um = RouterService.getUploadManager();
                DownloadManager dm = RouterService.getDownloadManager();
                try {
                    InputStream in = null;
                    try {
                        in = this._socket.getInputStream();
                    }
                    catch (IOException e) {
                        if (RECORD_STATS) {
                            HTTPStat.CLOSED_REQUESTS.incrementStat();
                        }
                        throw new IOException(e.getMessage());
                    }
                    catch (NullPointerException e) {
                        throw new IOException(e.getMessage());
                    }
                    this._socket.setSoTimeout(8000);
                    String word = IOUtils.readWord(in, 8);
                    this._socket.setSoTimeout(0);
                    if (!word.equals("MAGNET")) {
                        InetAddress address = this._socket.getInetAddress();
                        byte[] addressBytes = address.getAddress();
                        if (ConnectionSettings.LOCAL_IS_PRIVATE.getValue() && addressBytes[0] == 127) {
                            this._socket.close();
                            return;
                        }
                    }
                    boolean useDefaultConnect = ConnectionSettings.CONNECT_STRING.isDefault();
                    if (word.equals("GNUTELLA")) {
                        if (RECORD_STATS) {
                            HTTPStat.GNUTELLA_REQUESTS.incrementStat();
                        }
                        cm.acceptConnection(this._socket);
                        break block26;
                    }
                    if (useDefaultConnect && word.equals("LIMEWIRE")) {
                        if (RECORD_STATS) {
                            HTTPStat.GNUTELLA_LIMEWIRE_REQUESTS.incrementStat();
                        }
                        cm.acceptConnection(this._socket);
                        break block26;
                    }
                    if (word.equals("GET")) {
                        if (RECORD_STATS) {
                            HTTPStat.GET_REQUESTS.incrementStat();
                        }
                        um.acceptUpload(HTTPRequestMethod.GET, this._socket, false);
                        break block26;
                    }
                    if (word.equals("HEAD")) {
                        if (RECORD_STATS) {
                            HTTPStat.HEAD_REQUESTS.incrementStat();
                        }
                        um.acceptUpload(HTTPRequestMethod.HEAD, this._socket, false);
                        break block26;
                    }
                    if (word.equals("GIV")) {
                        if (RECORD_STATS) {
                            HTTPStat.GIV_REQUESTS.incrementStat();
                        }
                        dm.acceptDownload(this._socket);
                        break block26;
                    }
                    if (word.equals("CHAT")) {
                        if (RECORD_STATS) {
                            HTTPStat.CHAT_REQUESTS.incrementStat();
                        }
                        ChatManager.instance().accept(this._socket);
                        break block26;
                    }
                    if (word.equals("MAGNET")) {
                        if (RECORD_STATS) {
                            HTTPStat.MAGNET_REQUESTS.incrementStat();
                        }
                        ExternalControl.fireMagnet(this._socket);
                        break block26;
                    }
                    if (RECORD_STATS) {
                        HTTPStat.UNKNOWN_REQUESTS.incrementStat();
                    }
                    throw new IOException("UNKOWN PROTOCOL: " + word);
                }
                catch (IOException e) {
                    try {
                        this._socket.close();
                    }
                    catch (IOException e2) {}
                }
                catch (Throwable e) {
                    ErrorService.error(e);
                }
            }
        }
    }
}

