/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.bitzi.util.Base32;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.BrowseHostHandler;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.PushProxyInterface;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.AutoDownloadDetails;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.FileExistsException;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.MagnetDownloader;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.RequeryDownloader;
import com.limegroup.gnutella.downloader.ResumeDownloader;
import com.limegroup.gnutella.http.HttpClientManager;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.URLDecoder;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Set;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadManager
implements BandwidthTracker {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$DownloadManager == null ? (class$com$limegroup$gnutella$DownloadManager = DownloadManager.class$("com.limegroup.gnutella.DownloadManager")) : class$com$limegroup$gnutella$DownloadManager));
    private int SNAPSHOT_CHECKPOINT_TIME = 30000;
    private ActivityCallback callback;
    private MessageRouter router;
    private FileManager fileManager;
    private IncompleteFileManager incompleteFileManager = new IncompleteFileManager();
    private List active = new LinkedList();
    private List waiting = new LinkedList();
    public static long TIME_BETWEEN_REQUERIES = 2700000L;
    private long lastRequeryTime = 0L;
    private List querySentMDs = new ArrayList();
    private int numMeasures = 0;
    private float averageBandwidth = 0.0f;
    static /* synthetic */ Class class$com$limegroup$gnutella$DownloadManager;

    public void initialize() {
        this.callback = RouterService.getCallback();
        this.router = RouterService.getMessageRouter();
        this.fileManager = RouterService.getFileManager();
    }

    public void postGuiInit() {
        File real = SharingSettings.DOWNLOAD_SNAPSHOT_FILE.getValue();
        File backup = SharingSettings.DOWNLOAD_SNAPSHOT_BACKUP_FILE.getValue();
        if (!this.readSnapshot(real)) {
            LOG.debug((Object)"Reading real downloads.dat failed");
            if (this.readSnapshot(backup)) {
                LOG.debug((Object)"Reading backup downloads.bak succeeded.");
                this.copyBackupToReal();
            } else if (backup.exists() || real.exists()) {
                LOG.debug((Object)"Reading both downloads files failed.");
                MessageService.showError("DOWNLOAD_COULD_NOT_READ_SNAPSHOT");
            }
        } else {
            LOG.debug((Object)"Reading downloads.dat worked!");
        }
        Runnable checkpointer = new Runnable(){

            public void run() {
                try {
                    if (DownloadManager.this.downloadsInProgress() > 0 && !DownloadManager.this.writeSnapshot()) {
                        DownloadManager.this.copyBackupToReal();
                    }
                }
                catch (Throwable t) {
                    ErrorService.error(t);
                }
            }
        };
        RouterService.schedule(checkpointer, this.SNAPSHOT_CHECKPOINT_TIME, this.SNAPSHOT_CHECKPOINT_TIME);
    }

    private synchronized void copyBackupToReal() {
        File real = SharingSettings.DOWNLOAD_SNAPSHOT_FILE.getValue();
        File backup = SharingSettings.DOWNLOAD_SNAPSHOT_BACKUP_FILE.getValue();
        real.delete();
        CommonUtils.copy(backup, real);
    }

    public boolean isIncomplete(URN urn) {
        return this.incompleteFileManager.getFileForUrn(urn) != null;
    }

    public IncompleteFileManager getIncompleteFileManager() {
        return this.incompleteFileManager;
    }

    public synchronized int downloadsInProgress() {
        return this.active.size() + this.waiting.size();
    }

    public synchronized int getNumIndividualDownloaders() {
        int ret = 0;
        Iterator iter = this.active.iterator();
        while (iter.hasNext()) {
            ManagedDownloader md = (ManagedDownloader)iter.next();
            ret += md.getNumDownloaders();
        }
        return ret;
    }

    public synchronized int getNumActiveDownloads() {
        return this.active.size();
    }

    public synchronized int getNumWaitingDownloads() {
        return this.waiting.size();
    }

    public synchronized boolean isGuidForQueryDownloading(GUID guid) {
        GUID dGUID;
        Iterator iter = this.active.iterator();
        while (iter.hasNext()) {
            dGUID = ((ManagedDownloader)iter.next()).getQueryGUID();
            if (dGUID == null || !dGUID.equals(guid)) continue;
            return true;
        }
        iter = this.waiting.iterator();
        while (iter.hasNext()) {
            dGUID = ((ManagedDownloader)iter.next()).getQueryGUID();
            if (dGUID == null || !dGUID.equals(guid)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean writeSnapshot() {
        ArrayList buf = new ArrayList();
        buf.addAll((Collection)this.active);
        buf.addAll((Collection)this.waiting);
        File outFile = SharingSettings.DOWNLOAD_SNAPSHOT_FILE.getValue();
        SharingSettings.DOWNLOAD_SNAPSHOT_BACKUP_FILE.getValue().delete();
        outFile.renameTo(SharingSettings.DOWNLOAD_SNAPSHOT_BACKUP_FILE.getValue());
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(SharingSettings.DOWNLOAD_SNAPSHOT_FILE.getValue()));
            out.writeObject(buf);
            IncompleteFileManager incompleteFileManager = this.incompleteFileManager;
            synchronized (incompleteFileManager) {
                out.writeObject(this.incompleteFileManager);
            }
            out.flush();
            out.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public synchronized boolean readSnapshot(File file) {
        List buf = null;
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
            buf = (List)in.readObject();
            this.incompleteFileManager = (IncompleteFileManager)in.readObject();
        }
        catch (IOException e) {
            LOG.debug((Object)e);
            return false;
        }
        catch (ClassCastException e) {
            LOG.debug((Object)e);
            return false;
        }
        catch (ClassNotFoundException e) {
            LOG.debug((Object)e);
            return false;
        }
        catch (ArrayStoreException e) {
            LOG.debug((Object)e);
            return false;
        }
        catch (IndexOutOfBoundsException e) {
            LOG.debug((Object)e);
            return false;
        }
        catch (NegativeArraySizeException e) {
            LOG.debug((Object)e);
            return false;
        }
        catch (IllegalStateException e) {
            LOG.debug((Object)e);
            return false;
        }
        catch (SecurityException e) {
            LOG.debug((Object)e);
            return false;
        }
        if (this.incompleteFileManager.purge(true)) {
            this.writeSnapshot();
        }
        try {
            Iterator iter = buf.iterator();
            while (iter.hasNext()) {
                ManagedDownloader downloader = (ManagedDownloader)iter.next();
                this.waiting.add((Object)downloader);
                downloader.initialize(this, this.fileManager, this.callback, true);
                this.callback.addDownload(downloader);
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public synchronized Downloader download(RemoteFileDesc[] files, List alts, boolean overwrite, GUID queryGUID) throws FileExistsException, AlreadyDownloadingException, FileNotFoundException {
        String filename;
        File downloadDir;
        File completeFile;
        String conflict = this.conflicts(files, null);
        if (conflict != null) {
            throw new AlreadyDownloadingException(conflict);
        }
        if (!overwrite && (completeFile = new File(downloadDir = SharingSettings.getSaveDirectory(), filename = files[0].getFileName())).exists()) {
            throw new FileExistsException(filename);
        }
        this.incompleteFileManager.purge(false);
        ManagedDownloader downloader = new ManagedDownloader(files, this.incompleteFileManager, queryGUID);
        this.startDownload(downloader, false);
        Iterator iter = alts.iterator();
        while (iter.hasNext()) {
            RemoteFileDesc rfd = (RemoteFileDesc)iter.next();
            downloader.addDownload(rfd, false);
        }
        return downloader;
    }

    public synchronized Downloader download(URN urn, String textQuery, String filename, String[] defaultURL, boolean overwrite) throws IllegalArgumentException, AlreadyDownloadingException, FileExistsException {
        File downloadDir;
        File completeFile;
        if (textQuery == null && urn == null && filename == null && (defaultURL == null || defaultURL.length == 0)) {
            throw new IllegalArgumentException("Need something for requeries");
        }
        if (!overwrite && filename != null && !filename.equals("") && (completeFile = new File(downloadDir = SharingSettings.getSaveDirectory(), filename)).exists()) {
            throw new FileExistsException(filename);
        }
        this.incompleteFileManager.purge(false);
        if (urn != null && this.conflicts(urn)) {
            String ex = filename != null && !filename.equals("") ? filename : urn.toString();
            throw new AlreadyDownloadingException(ex);
        }
        MagnetDownloader downloader = new MagnetDownloader(this.incompleteFileManager, urn, textQuery, filename, defaultURL);
        this.startDownload(downloader, false);
        return downloader;
    }

    public synchronized Downloader download(File incompleteFile) throws AlreadyDownloadingException, CantResumeException {
        ManagedDownloader md;
        Iterator iter = this.active.iterator();
        while (iter.hasNext()) {
            md = (ManagedDownloader)iter.next();
            if (!md.conflicts(incompleteFile)) continue;
            throw new AlreadyDownloadingException(md.getFileName());
        }
        iter = this.waiting.iterator();
        while (iter.hasNext()) {
            md = (ManagedDownloader)iter.next();
            if (!md.conflicts(incompleteFile)) continue;
            throw new AlreadyDownloadingException(md.getFileName());
        }
        this.incompleteFileManager.purge(false);
        ResumeDownloader downloader = null;
        try {
            incompleteFile = FileUtils.getCanonicalFile(incompleteFile);
            String name = IncompleteFileManager.getCompletedName(incompleteFile);
            int size = ByteOrder.long2int(IncompleteFileManager.getCompletedSize(incompleteFile));
            downloader = new ResumeDownloader(this.incompleteFileManager, incompleteFile, name, size);
        }
        catch (IllegalArgumentException e) {
            throw new CantResumeException(incompleteFile.getName());
        }
        catch (IOException ioe) {
            throw new CantResumeException(incompleteFile.getName());
        }
        this.startDownload(downloader, false);
        return downloader;
    }

    public synchronized Downloader download(String query, String richQuery, byte[] guid, MediaType type) throws AlreadyDownloadingException {
        AutoDownloadDetails add = new AutoDownloadDetails(query, richQuery, guid, type);
        if (this.requeryConflicts(add)) {
            throw new AlreadyDownloadingException(query);
        }
        this.incompleteFileManager.purge(false);
        RequeryDownloader downloader = new RequeryDownloader(this.incompleteFileManager, add, new GUID(guid));
        this.startDownload(downloader, false);
        return downloader;
    }

    private void startDownload(ManagedDownloader md, boolean deserialized) {
        md.initialize(this, this.fileManager, this.callback, deserialized);
        this.waiting.add((Object)md);
        this.callback.addDownload(md);
        this.writeSnapshot();
    }

    public synchronized String conflicts(RemoteFileDesc[] files, ManagedDownloader dloader) {
        for (int i = 0; i < files.length; ++i) {
            ManagedDownloader md;
            Iterator iter = this.active.iterator();
            while (iter.hasNext()) {
                md = (ManagedDownloader)iter.next();
                if (dloader != null && md == dloader || !md.conflicts(files[i])) continue;
                return files[i].getFileName();
            }
            iter = this.waiting.iterator();
            while (iter.hasNext()) {
                md = (ManagedDownloader)iter.next();
                if (dloader != null && md == dloader || !md.conflicts(files[i])) continue;
                return files[i].getFileName();
            }
        }
        return null;
    }

    private synchronized boolean conflicts(URN urn) {
        ManagedDownloader md;
        Iterator iter = this.active.iterator();
        while (iter.hasNext()) {
            md = (ManagedDownloader)iter.next();
            if (!md.conflicts(urn)) continue;
            return true;
        }
        iter = this.waiting.iterator();
        while (iter.hasNext()) {
            md = (ManagedDownloader)iter.next();
            if (!md.conflicts(urn)) continue;
            return true;
        }
        return false;
    }

    private synchronized boolean requeryConflicts(AutoDownloadDetails add) {
        RequeryDownloader rd;
        ManagedDownloader md;
        boolean retVal = false;
        Iterator iter = this.active.iterator();
        while (iter.hasNext() && !retVal) {
            md = (ManagedDownloader)iter.next();
            if (!(md instanceof RequeryDownloader)) continue;
            rd = (RequeryDownloader)md;
            retVal = rd.conflicts(add);
        }
        iter = this.waiting.iterator();
        while (iter.hasNext() && !retVal) {
            md = (ManagedDownloader)iter.next();
            if (!(md instanceof RequeryDownloader)) continue;
            rd = (RequeryDownloader)md;
            retVal = rd.conflicts(add);
        }
        return retVal;
    }

    public void handleQueryReply(QueryReply qr) {
        HostData data;
        List responses;
        if (qr.calculateQualityOfService(!RouterService.acceptedIncomingConnection()) < 1) {
            return;
        }
        try {
            responses = qr.getResultsAsList();
            data = qr.getHostData();
        }
        catch (BadPacketException bpe) {
            return;
        }
        this.addDownloadWithResponses(responses, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDownloadWithResponses(List responses, HostData data) {
        if (responses == null) {
            throw new NullPointerException("null responses");
        }
        if (data == null) {
            throw new NullPointerException("null hostdata");
        }
        ArrayList downloaders = new ArrayList(this.active.size() + this.waiting.size());
        DownloadManager downloadManager = this;
        synchronized (downloadManager) {
            downloaders.addAll((Collection)this.active);
            downloaders.addAll((Collection)this.waiting);
        }
        if (downloaders.isEmpty()) {
            return;
        }
        Iterator i = responses.iterator();
        block3: while (i.hasNext()) {
            Response r = (Response)i.next();
            RemoteFileDesc rfd = r.toRemoteFileDesc(data);
            Iterator j = downloaders.iterator();
            while (j.hasNext()) {
                ManagedDownloader currD = (ManagedDownloader)j.next();
                if (!currD.addDownload(rfd, true)) continue;
                Set alts = r.getLocations();
                Iterator k = alts.iterator();
                while (k.hasNext()) {
                    Endpoint ep = (Endpoint)k.next();
                    currD.addDownload(new RemoteFileDesc(rfd, ep), false);
                }
                continue block3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptDownload(Socket socket) {
        Thread.currentThread().setName("PushDownloadThread");
        try {
            GIVLine line = DownloadManager.parseGIV(socket);
            String file = line.file;
            int index = line.index;
            byte[] clientGUID = line.clientGUID;
            DownloadManager downloadManager = this;
            synchronized (downloadManager) {
                ManagedDownloader md;
                if (BrowseHostHandler.handlePush(index, new GUID(clientGUID), socket)) {
                    return;
                }
                Iterator iter = this.active.iterator();
                while (iter.hasNext()) {
                    md = (ManagedDownloader)iter.next();
                    if (!md.acceptDownload(file, socket, index, clientGUID)) continue;
                    return;
                }
                iter = this.waiting.iterator();
                while (iter.hasNext()) {
                    md = (ManagedDownloader)iter.next();
                    if (!md.acceptDownload(file, socket, index, clientGUID)) continue;
                    return;
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean hasFreeSlot() {
        return this.active.size() < DownloadSettings.MAX_SIM_DOWNLOAD.getValue();
    }

    public synchronized void waitForSlot(ManagedDownloader downloader) throws InterruptedException {
        while (!this.hasFreeSlot()) {
            this.wait();
        }
        this.waiting.remove((Object)downloader);
        this.active.add((Object)downloader);
    }

    public synchronized void yieldSlot(ManagedDownloader downloader) {
        Assert.that(downloader != null, "Null downloader");
        Assert.that(this.active != null, "Null active");
        Assert.that(this.waiting != null, "Null waiting");
        this.active.remove((Object)downloader);
        this.waiting.add((Object)downloader);
        this.notify();
    }

    public synchronized void remove(ManagedDownloader downloader, boolean success) {
        this.active.remove((Object)downloader);
        this.waiting.remove((Object)downloader);
        this.querySentMDs.remove((Object)downloader);
        downloader.finish();
        if (downloader.getQueryGUID() != null) {
            this.router.downloadFinished(downloader.getQueryGUID());
        }
        this.notify();
        this.callback.removeDownload(downloader);
        this.writeSnapshot();
        if (this.active.isEmpty() && this.waiting.isEmpty()) {
            this.callback.downloadsComplete();
        }
    }

    public synchronized boolean sendQuery(ManagedDownloader requerier, QueryRequest query) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("DM.sendQuery():" + query.getQuery()));
        }
        Assert.that(this.waiting.contains((Object)requerier), "Unknown or non-waiting MD trying to send requery.");
        boolean isRequery = GUID.isLimeRequeryGUID(query.getGUID());
        long elapsed = System.currentTimeMillis() - this.lastRequeryTime;
        if (isRequery && elapsed <= TIME_BETWEEN_REQUERIES) {
            return false;
        }
        if (this.querySentMDs.size() >= this.waiting.size()) {
            LOG.trace((Object)"DM.sendQuery(): reseting query sent queue");
            this.querySentMDs.clear();
        }
        if (this.querySentMDs.contains((Object)requerier)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("DM.sendQuery(): out of turn:" + query.getQuery()));
            }
            return false;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("DM.sendQuery(): requery allowed:" + query.getQuery()));
        }
        this.querySentMDs.add((Object)requerier);
        this.lastRequeryTime = System.currentTimeMillis();
        this.router.sendDynamicQuery(query);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendPush(RemoteFileDesc file) {
        int port;
        byte[] addr;
        LOG.trace((Object)"DM.sendPush(): entered.");
        if (file.isReplyToMulticast()) {
            addr = RouterService.getNonForcedAddress();
            port = RouterService.getNonForcedPort();
            if (NetworkUtils.isValidAddress(addr) && NetworkUtils.isValidPort(port)) {
                PushRequest pr = new PushRequest(GUID.makeGuid(), 1, file.getClientGUID(), file.getIndex(), addr, port);
                this.router.sendMulticastPushRequest(pr);
                return true;
            }
        }
        addr = RouterService.getAddress();
        port = RouterService.getPort();
        if (!NetworkUtils.isValidAddress(addr) || !NetworkUtils.isValidPort(port)) {
            return false;
        }
        Set proxies = file.getPushProxies();
        if (!proxies.isEmpty()) {
            LOG.info((Object)"DM.sendPush(): proxy info exists.");
            boolean requestSuccessful = false;
            String requestString = "/gnutella/push-proxy?ServerID=" + Base32.encode(file.getClientGUID());
            String nodeString = "X-Node";
            String nodeValue = NetworkUtils.ip2string(addr) + ":" + port;
            Iterator iter = proxies.iterator();
            while (iter.hasNext() && !requestSuccessful) {
                PushProxyInterface ppi = (PushProxyInterface)iter.next();
                String ppIp = ppi.getPushProxyAddress().getHostAddress();
                int ppPort = ppi.getPushProxyPort();
                String connectTo = "http://" + ppIp + ":" + ppPort + requestString;
                HeadMethod head = new HeadMethod(connectTo);
                head.addRequestHeader("X-Node", nodeValue);
                head.addRequestHeader("Cache-Control", "no-cache");
                HttpClient client = HttpClientManager.getNewClient();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Push Proxy Requesting with: " + connectTo));
                }
                try {
                    client.executeMethod((HttpMethod)head);
                    if (head.getStatusCode() == 202) {
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)("Succesful push proxy: " + connectTo));
                        }
                        requestSuccessful = true;
                        continue;
                    }
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn((Object)("Invalid push proxy: " + connectTo + ", response: " + head.getStatusCode()));
                }
                catch (IOException ioe) {
                    LOG.warn((Object)"PushProxy request exception", (Throwable)ioe);
                }
                finally {
                    if (head == null) continue;
                    head.releaseConnection();
                }
            }
            if (requestSuccessful) {
                return requestSuccessful;
            }
        }
        PushRequest pr = new PushRequest(GUID.makeGuid(), ConnectionSettings.TTL.getValue(), file.getClientGUID(), file.getIndex(), addr, port);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Sending push request through Gnutella: " + pr));
        }
        try {
            this.router.sendPushRequest(pr);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static GIVLine parseGIV(Socket s) throws IOException {
        InputStream istream = null;
        try {
            istream = s.getInputStream();
        }
        catch (Exception e) {
            throw new IOException();
        }
        ByteReader br = new ByteReader(istream);
        String command = br.readLine();
        if (command == null) {
            throw new IOException();
        }
        String next = br.readLine();
        if (next == null || !next.equals("")) {
            throw new IOException();
        }
        try {
            int i = command.indexOf(":");
            int index = Integer.parseInt(command.substring(0, i));
            int j = command.indexOf("/", i);
            byte[] guid = GUID.fromHexString(command.substring(i + 1, j));
            String filename = URLDecoder.decode(command.substring(j + 1));
            return new GIVLine(filename, index, guid);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException();
        }
        catch (NumberFormatException e) {
            throw new IOException();
        }
        catch (IllegalArgumentException e) {
            throw new IOException();
        }
    }

    public synchronized void measureBandwidth() {
        float currentTotal = 0.0f;
        boolean c = false;
        Iterator iter = this.active.iterator();
        while (iter.hasNext()) {
            c = true;
            BandwidthTracker bt = (BandwidthTracker)iter.next();
            bt.measureBandwidth();
            currentTotal += bt.getAverageBandwidth();
        }
        if (c) {
            this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + currentTotal) / (float)(++this.numMeasures);
        }
    }

    public synchronized float getMeasuredBandwidth() {
        float sum = 0.0f;
        Iterator iter = this.active.iterator();
        while (iter.hasNext()) {
            BandwidthTracker bt = (BandwidthTracker)iter.next();
            float curr = 0.0f;
            try {
                curr = bt.getMeasuredBandwidth();
            }
            catch (InsufficientDataException ide) {
                curr = 0.0f;
            }
            sum += curr;
        }
        return sum;
    }

    public synchronized float getAverageBandwidth() {
        return this.averageBandwidth;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class GIVLine {
        final String file;
        final int index;
        final byte[] clientGUID;

        GIVLine(String file, int index, byte[] clientGUID) {
            this.file = file;
            this.index = index;
            this.clientGUID = clientGUID;
        }
    }
}

