/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SavedFileManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.routing.QueryRouteTable;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.Comparators;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.Function;
import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.util.IntSet;
import com.limegroup.gnutella.util.KeyValue;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.util.Trie;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.TreeMap;
import com.sun.java.util.collections.TreeSet;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

public abstract class FileManager {
    public static final String INDEXING_QUERY = "    ";
    public static final String BROWSE_QUERY = "*.*";
    private long _size;
    private int _numFiles;
    private int _numPendingFiles;
    private int _numIncompleteFiles;
    private List _files;
    private Map _fileToFileDesc;
    private Trie _index;
    private Map _urnIndex;
    private static Set _extensions;
    private Map _sharedDirectories;
    private IntSet _incompletesShared;
    private Thread _loadThread;
    private boolean _loadThreadInterrupted = false;
    private Object _loadThreadLock = new Object();
    private boolean _loadFinished = false;
    public static FilenameFilter SHAREABLE_FILE_FILTER;
    public static FilenameFilter DIRECTORY_FILTER;
    protected static QueryRouteTable _queryRouteTable;
    protected static volatile boolean _needRebuild;
    public static final String DELIMETERS = " -._+/*()\\";
    private static boolean debugOn;
    private static final Response[] EMPTY_RESPONSES;
    private boolean DEBUG = false;

    private static final boolean isDelimeter(char c) {
        switch (c) {
            case ' ': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '/': 
            case '\\': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    public FileManager() {
        this.resetVariables();
    }

    private void resetVariables() {
        this._size = 0L;
        this._numFiles = 0;
        this._numIncompleteFiles = 0;
        this._numPendingFiles = 0;
        this._files = new ArrayList();
        this._index = new Trie(true);
        this._urnIndex = new HashMap();
        _extensions = new TreeSet(Comparators.stringComparator());
        this._sharedDirectories = new TreeMap(Comparators.fileComparator());
        this._incompletesShared = new IntSet();
        this._fileToFileDesc = new HashMap();
    }

    public void start() {
        this.loadSettings(false);
    }

    public int getSize() {
        return ByteOrder.long2int(this._size);
    }

    public int getNumFiles() {
        return this._numFiles;
    }

    public int getNumIncompleteFiles() {
        return this._numIncompleteFiles;
    }

    public int getNumPendingFiles() {
        return this._numPendingFiles;
    }

    public synchronized FileDesc get(int i) {
        return (FileDesc)this._files.get(i);
    }

    public synchronized boolean isValidIndex(int i) {
        return i >= 0 && i < this._files.size();
    }

    public synchronized URN getURNForFile(File f) {
        FileDesc fd = this.getFileDescForFile(f);
        if (fd != null) {
            return fd.getSHA1Urn();
        }
        return null;
    }

    public synchronized FileDesc getFileDescForFile(File f) {
        try {
            f = FileUtils.getCanonicalFile(f);
        }
        catch (IOException ioe) {
            return null;
        }
        return (FileDesc)this._fileToFileDesc.get((Object)f);
    }

    public synchronized boolean isUrnShared(URN urn) {
        FileDesc fd = this.getFileDescForUrn(urn);
        return fd != null && !(fd instanceof IncompleteFileDesc);
    }

    public synchronized FileDesc getFileDescForUrn(URN urn) {
        IntSet indeces = (IntSet)this._urnIndex.get((Object)urn);
        if (indeces == null) {
            return null;
        }
        IntSet.IntSetIterator iter = indeces.iterator();
        FileDesc ret = null;
        while (iter.hasNext() && (ret == null || ret instanceof IncompleteFileDesc)) {
            int index = iter.next();
            ret = (FileDesc)this._files.get(index);
        }
        return ret;
    }

    public synchronized FileDesc[] getIncompleteFileDescriptors() {
        if (this._incompletesShared == null) {
            return null;
        }
        FileDesc[] ret = new FileDesc[this._incompletesShared.size()];
        IntSet.IntSetIterator iter = this._incompletesShared.iterator();
        int i = 0;
        while (iter.hasNext()) {
            FileDesc fd = (FileDesc)this._files.get(iter.next());
            Assert.that(fd != null, "Directory has null entry");
            ret[i] = fd;
            ++i;
        }
        return ret;
    }

    public synchronized FileDesc[] getAllSharedFileDescriptors() {
        Object[] fds = new FileDesc[this._fileToFileDesc.size()];
        fds = (FileDesc[])this._fileToFileDesc.values().toArray(fds);
        return fds;
    }

    public synchronized FileDesc[] getSharedFileDescriptors(File directory) {
        if (directory == null) {
            throw new NullPointerException("null directory");
        }
        try {
            directory = FileUtils.getCanonicalFile(directory);
        }
        catch (IOException e) {
            return null;
        }
        IntSet indices = (IntSet)this._sharedDirectories.get((Object)directory);
        if (indices == null) {
            return null;
        }
        FileDesc[] fds = new FileDesc[indices.size()];
        IntSet.IntSetIterator iter = indices.iterator();
        int i = 0;
        while (iter.hasNext()) {
            FileDesc fd = (FileDesc)this._files.get(iter.next());
            Assert.that(fd != null, "Directory has null entry");
            fds[i] = fd;
            ++i;
        }
        return fds;
    }

    public static File[] getFilesRecursive(File directory, String[] filter) {
        FileManager.debug("FileManager.getFilesRecursive(): entered.");
        ArrayList dirs = new ArrayList();
        ArrayList retFileArray = new ArrayList();
        File[] retArray = null;
        if (directory.exists() && directory.isDirectory()) {
            dirs.add((Object)directory);
        }
        while (dirs.size() > 0) {
            File currDir = (File)dirs.remove(0);
            FileManager.debug("FileManager.getFilesRecursive(): currDir = " + currDir);
            String[] listedFiles = currDir.list();
            for (int i = 0; listedFiles != null && i < listedFiles.length; ++i) {
                File currFile = new File(currDir, listedFiles[i]);
                if (currFile.isDirectory()) {
                    dirs.add((Object)currFile);
                    continue;
                }
                if (!currFile.isFile()) continue;
                boolean shouldAdd = false;
                if (filter == null) {
                    shouldAdd = true;
                } else {
                    String ext = FileUtils.getFileExtension(currFile);
                    for (int j = 0; j < filter.length && ext != null; ++j) {
                        if (!ext.equalsIgnoreCase(filter[j])) continue;
                        shouldAdd = true;
                        break;
                    }
                }
                if (!shouldAdd) continue;
                retFileArray.add((Object)currFile);
            }
        }
        if (!retFileArray.isEmpty()) {
            retArray = new File[retFileArray.size()];
            for (int i = 0; i < retArray.length; ++i) {
                retArray[i] = (File)retFileArray.get(i);
            }
        }
        FileManager.debug("FileManager.getFilesRecursive(): returning.");
        return retArray;
    }

    public static void debug(String out) {
        if (debugOn) {
            System.out.println(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSettings(boolean notifyOnClear) {
        Object object = this._loadThreadLock;
        synchronized (object) {
            if (this._loadThread != null) {
                this._loadThreadInterrupted = true;
                this._loadThread.interrupt();
                try {
                    this._loadThread.join();
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            final boolean notifyOnClearFinal = notifyOnClear;
            this._loadThreadInterrupted = false;
            this._loadFinished = false;
            this._loadThread = new ManagedThread("FileManager.loadSettingsBlocking"){

                public void managedRun() {
                    try {
                        FileManager.this.loadSettingsBlocking(notifyOnClearFinal);
                        RouterService.getCallback().fileManagerLoaded();
                    }
                    catch (Throwable t) {
                        ErrorService.error(t);
                    }
                    FileManager.this._loadFinished = true;
                    SavedFileManager.instance().run();
                }
            };
            this._loadThread.start();
        }
    }

    protected boolean loadThreadInterrupted() {
        return this._loadThreadInterrupted;
    }

    public boolean isLoadFinished() {
        return this._loadFinished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadSettingsBlocking(boolean notifyOnClear) {
        Object[] tempDirVar;
        FileManager fileManager = this;
        synchronized (fileManager) {
            this.resetVariables();
            String[] extensions = StringUtils.split(SharingSettings.EXTENSIONS_TO_SHARE.getValue(), ";");
            for (int i = 0; i < extensions.length && !this.loadThreadInterrupted(); ++i) {
                _extensions.add((Object)extensions[i].toLowerCase());
            }
            Object[] directories = SharingSettings.DIRECTORIES_TO_SHARE.getValue();
            Arrays.sort((Object[])directories, (Comparator)new Comparator(){

                public int compare(Object a, Object b) {
                    return a.toString().length() - b.toString().length();
                }
            });
            tempDirVar = directories;
        }
        Object[] directories = tempDirVar;
        if (notifyOnClear) {
            RouterService.getCallback().clearSharedFiles();
        }
        LinkedList added = new LinkedList();
        for (int i = 0; i < directories.length && !this.loadThreadInterrupted(); ++i) {
            added.addAll((Collection)this.updateDirectories((File)directories[i], null));
        }
        if (!this.loadThreadInterrupted()) {
            this.updateSharedFiles((List)added);
        }
        if (!this.loadThreadInterrupted()) {
            this.trim();
        }
        if (!this.loadThreadInterrupted()) {
            RouterService.getDownloadManager().getIncompleteFileManager().registerAllIncompleteFiles();
        }
        CreationTimeCache.instance().pruneTimes();
        UrnCache.instance().persistCache();
        CreationTimeCache.instance().persistCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List updateDirectories(File directory, File parent) {
        try {
            directory = FileUtils.getCanonicalFile(directory);
        }
        catch (IOException e) {
            return DataUtils.EMPTY_LIST;
        }
        if (directory.equals(SharingSettings.INCOMPLETE_DIRECTORY.getValue())) {
            return DataUtils.EMPTY_LIST;
        }
        File[] dir_list = FileUtils.listFiles(directory, DIRECTORY_FILTER);
        File[] file_list = FileUtils.listFiles(directory, SHAREABLE_FILE_FILTER);
        if (dir_list == null && file_list == null) {
            return DataUtils.EMPTY_LIST;
        }
        int numShareable = file_list.length;
        int numSubDirs = dir_list.length;
        FileManager fileManager = this;
        synchronized (fileManager) {
            if (this._sharedDirectories.get((Object)directory) != null) {
                return DataUtils.EMPTY_LIST;
            }
            this._sharedDirectories.put((Object)directory, (Object)new IntSet());
            RouterService.getCallback().addSharedDirectory(directory, parent);
            this._numPendingFiles += numShareable;
        }
        LinkedList added = new LinkedList();
        added.add((Object)new KeyValue(directory, file_list));
        for (int i = 0; i < numSubDirs && !this.loadThreadInterrupted(); ++i) {
            added.addAll((Collection)this.updateDirectories(dir_list[i], directory));
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSharedFiles(List toShare) {
        Iterator i = toShare.iterator();
        while (i.hasNext() && !this.loadThreadInterrupted()) {
            KeyValue info = (KeyValue)i.next();
            File[] shareables = (File[])info.getValue();
            for (int j = 0; j < shareables.length && !this.loadThreadInterrupted(); ++j) {
                this.addFile(shareables[j]);
                FileManager fileManager = this;
                synchronized (fileManager) {
                    --this._numPendingFiles;
                    continue;
                }
            }
            info.setValue(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileDesc addFileIfShared(File file) {
        FileDesc fd;
        boolean directoryShared;
        File f = null;
        try {
            f = FileUtils.getCanonicalFile(file);
            if (!f.exists()) {
                return null;
            }
        }
        catch (IOException e) {
            return null;
        }
        File dir = FileUtils.getParentFile(f);
        if (dir == null) {
            return null;
        }
        FileManager fileManager = this;
        synchronized (fileManager) {
            directoryShared = this._sharedDirectories.containsKey((Object)dir);
            if (directoryShared) {
                ++this._numPendingFiles;
            }
        }
        if (directoryShared) {
            fd = this.addFile(f);
            FileManager fileManager2 = this;
            synchronized (fileManager2) {
                --this._numPendingFiles;
            }
            _needRebuild = true;
        } else {
            fd = null;
        }
        return fd;
    }

    public abstract FileDesc addFileIfShared(File var1, List var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileDesc addFile(File file) {
        this.repOk();
        long fileLength = file.length();
        if (!FileManager.isFileShareable(file, fileLength)) {
            return null;
        }
        Set urns = null;
        try {
            urns = FileDesc.calculateAndCacheURN(file);
        }
        catch (IOException e) {
            return null;
        }
        catch (InterruptedException e) {
            return null;
        }
        if (this.loadThreadInterrupted()) {
            return null;
        }
        if (urns.size() == 0) {
            return null;
        }
        FileManager fileManager = this;
        synchronized (fileManager) {
            this._size += fileLength;
            int fileIndex = this._files.size();
            FileDesc fileDesc = new FileDesc(file, urns, fileIndex);
            this._files.add((Object)fileDesc);
            this._fileToFileDesc.put((Object)file, (Object)fileDesc);
            ++this._numFiles;
            File parent = FileUtils.getParentFile(file);
            Assert.that(parent != null, "Null parent to \"" + file + "\"");
            IntSet siblings = (IntSet)this._sharedDirectories.get((Object)parent);
            Assert.that(siblings != null, "Add directory \"" + parent + "\" not in " + this._sharedDirectories);
            boolean added = siblings.add(fileIndex);
            Assert.that(added, "File " + fileIndex + " already found in " + siblings);
            RouterService.getCallback().addSharedFile(fileDesc, parent);
            String[] keywords = FileManager.extractKeywords(fileDesc);
            for (int i = 0; i < keywords.length; ++i) {
                String keyword = keywords[i];
                IntSet indices = (IntSet)this._index.get(keyword);
                if (indices == null) {
                    indices = new IntSet();
                    this._index.add(keyword, indices);
                }
                indices.add(fileIndex);
            }
            if (!this.isInstallerFile(file)) {
                CreationTimeCache ctCache;
                URN mainURN = fileDesc.getSHA1Urn();
                CreationTimeCache creationTimeCache = ctCache = CreationTimeCache.instance();
                synchronized (creationTimeCache) {
                    Long cTime = ctCache.getCreationTime(mainURN);
                    if (cTime == null) {
                        cTime = new Long(file.lastModified());
                    }
                    if (cTime > 0L) {
                        ctCache.addTime(mainURN, cTime);
                        ctCache.commitTime(mainURN);
                    }
                }
            }
            this.updateUrnIndex(fileDesc);
            _needRebuild = true;
            this.repOk();
            return fileDesc;
        }
    }

    protected boolean isInstallerFile(File file) {
        String fileName = file.getName().toLowerCase();
        if (fileName.length() < 12) {
            return false;
        }
        String pre = fileName.substring(0, 8);
        int lastDotIndex = fileName.lastIndexOf(46);
        if (lastDotIndex < 0) {
            return false;
        }
        String post = fileName.substring(lastDotIndex);
        return pre.equals("limewire") && (post.equals(".dmg") || post.equals(".bin") || post.equals(".zip") || post.equals(".exe") || post.equals(".tgz"));
    }

    public synchronized void addIncompleteFile(File incompleteFile, Set urns, String name, int size, VerifyingFile vf) {
        try {
            incompleteFile = FileUtils.getCanonicalFile(incompleteFile);
        }
        catch (IOException ioe) {
            return;
        }
        Iterator iter = urns.iterator();
        while (iter.hasNext()) {
            IntSet shared = (IntSet)this._urnIndex.get(iter.next());
            if (shared == null) continue;
            IntSet.IntSetIterator isIter = shared.iterator();
            while (isIter.hasNext()) {
                String path;
                String incPath;
                int i = isIter.next();
                FileDesc desc = (FileDesc)this._files.get(i);
                if (desc == null || !(incPath = incompleteFile.getAbsolutePath()).equals(path = desc.getFile().getAbsolutePath())) continue;
                return;
            }
        }
        int fileIndex = this._files.size();
        this._incompletesShared.add(fileIndex);
        IncompleteFileDesc ifd = new IncompleteFileDesc(incompleteFile, urns, fileIndex, name, size, vf);
        this._files.add((Object)ifd);
        this._fileToFileDesc.put((Object)incompleteFile, (Object)ifd);
        this.updateUrnIndex(ifd);
        ++this._numIncompleteFiles;
        _needRebuild = true;
        File parent = FileUtils.getParentFile(incompleteFile);
        RouterService.getCallback().addSharedFile(ifd, parent);
    }

    private synchronized void updateUrnIndex(FileDesc fileDesc) {
        Iterator iter = fileDesc.getUrns().iterator();
        while (iter.hasNext()) {
            URN urn = (URN)iter.next();
            IntSet indices = (IntSet)this._urnIndex.get((Object)urn);
            if (indices == null) {
                indices = new IntSet();
                this._urnIndex.put((Object)urn, (Object)indices);
            }
            indices.add(fileDesc.getIndex());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileDesc fileChanged(File f) {
        URN oldURN = this.getURNForFile(f);
        CreationTimeCache ctCache = CreationTimeCache.instance();
        Long cTime = ctCache.getCreationTime(oldURN);
        FileDesc removed = this.removeFileIfShared(f);
        if (removed == null) {
            return null;
        }
        FileDesc fd = this.addFileIfShared(f);
        if (fd != null && cTime != null) {
            CreationTimeCache creationTimeCache = ctCache;
            synchronized (creationTimeCache) {
                ctCache.removeTime(fd.getSHA1Urn());
                ctCache.addTime(fd.getSHA1Urn(), cTime);
                ctCache.commitTime(fd.getSHA1Urn());
            }
        }
        return fd;
    }

    public synchronized FileDesc removeFileIfShared(File f) {
        this.repOk();
        try {
            f = FileUtils.getCanonicalFile(f);
        }
        catch (IOException e) {
            this.repOk();
            return null;
        }
        FileDesc fd = (FileDesc)this._fileToFileDesc.get((Object)f);
        if (fd == null) {
            return null;
        }
        int i = fd.getIndex();
        Assert.that(((FileDesc)this._files.get(i)).getFile().equals(f), "invariant broken!");
        this._files.set(i, null);
        this._fileToFileDesc.remove((Object)f);
        _needRebuild = true;
        if (fd instanceof IncompleteFileDesc) {
            this.removeUrnIndex(fd);
            --this._numIncompleteFiles;
            boolean removed = this._incompletesShared.remove(i);
            Assert.that(removed, "File " + i + " not found in " + this._incompletesShared);
            this.repOk();
            return null;
        }
        --this._numFiles;
        this._size -= fd.getSize();
        File parent = FileUtils.getParentFile(f);
        IntSet siblings = (IntSet)this._sharedDirectories.get((Object)parent);
        Assert.that(siblings != null, "Rem directory \"" + parent + "\" not in " + this._sharedDirectories);
        boolean removed = siblings.remove(i);
        Assert.that(removed, "File " + i + " not found in " + siblings);
        String[] keywords = FileManager.extractKeywords(fd);
        for (int j = 0; j < keywords.length; ++j) {
            String keyword = keywords[j];
            IntSet indices = (IntSet)this._index.get(keyword);
            if (indices == null) continue;
            indices.remove(i);
        }
        this.removeUrnIndex(fd);
        if (this._urnIndex.get((Object)fd.getSHA1Urn()) == null) {
            CreationTimeCache.instance().removeTime(fd.getSHA1Urn());
        }
        this.repOk();
        return fd;
    }

    private static String[] extractKeywords(FileDesc fd) {
        return StringUtils.split(I18NConvert.instance().getNorm(fd.getPath()), DELIMETERS);
    }

    private synchronized void removeUrnIndex(FileDesc fileDesc) {
        Iterator iter = fileDesc.getUrns().iterator();
        while (iter.hasNext()) {
            URN urn = (URN)iter.next();
            IntSet indices = (IntSet)this._urnIndex.get((Object)urn);
            Assert.that(indices != null, "Invariant broken");
            indices.remove(fileDesc.getIndex());
            if (indices.size() != 0) continue;
            this._urnIndex.remove((Object)urn);
        }
    }

    public synchronized boolean renameFileIfShared(File oldName, File newName) {
        FileDesc fd = this.getFileDescForFile(oldName);
        if (fd == null) {
            return false;
        }
        LinkedList xmlDocs = new LinkedList();
        xmlDocs.addAll((Collection)fd.getLimeXMLDocuments());
        fd = this.removeFileIfShared(oldName);
        Assert.that(fd != null, "invariant broken.");
        fd = this.addFileIfShared(newName, (List)xmlDocs);
        return fd != null;
    }

    private synchronized void trim() {
        this._index.trim(new Function(){

            public Object apply(Object intSet) {
                ((IntSet)intSet).trim();
                return intSet;
            }
        });
    }

    private static boolean hasExtension(String filename) {
        int begin = filename.lastIndexOf(".");
        if (begin == -1) {
            return false;
        }
        String ext = filename.substring(begin + 1).toLowerCase();
        return _extensions.contains((Object)ext);
    }

    public synchronized boolean isFileInSharedDirectories(File f) {
        File dir = FileUtils.getParentFile(f);
        if (dir == null) {
            return false;
        }
        return this._sharedDirectories.containsKey((Object)dir);
    }

    public static boolean isFileShareable(File file, long fileLength) {
        if (fileLength > Integer.MAX_VALUE || fileLength <= 0L) {
            return false;
        }
        if (file.isDirectory() || !file.canRead()) {
            return false;
        }
        return file.getName().toUpperCase().startsWith("LIMEWIRE") || FileManager.hasExtension(file.getName());
    }

    public synchronized QueryRouteTable getQRT() {
        if (_needRebuild) {
            this.buildQRT();
            _needRebuild = false;
        }
        QueryRouteTable qrt = new QueryRouteTable(_queryRouteTable.getSize());
        qrt.addAll(_queryRouteTable);
        return qrt;
    }

    protected synchronized void buildQRT() {
        _queryRouteTable = new QueryRouteTable();
        FileDesc[] fds = this.getAllSharedFileDescriptors();
        for (int i = 0; i < fds.length; ++i) {
            this.addToQRT(fds[i]);
        }
    }

    protected void addToQRT(FileDesc fd) {
        if (fd instanceof IncompleteFileDesc) {
            return;
        }
        _queryRouteTable.add(fd.getPath());
        Set urns = fd.getUrns();
        Iterator iter = urns.iterator();
        while (iter.hasNext()) {
            _queryRouteTable.addIndivisible(((URN)iter.next()).httpStringValue());
        }
    }

    public synchronized Response[] query(QueryRequest request) {
        String str = request.getQuery();
        boolean includeXML = this.shouldIncludeXMLInResponse(request);
        if (request.isWhatIsNewRequest()) {
            return this.respondToWhatIsNewRequest(request, includeXML);
        }
        if (str.equals(INDEXING_QUERY) || str.equals(BROWSE_QUERY)) {
            return this.respondToIndexingQuery(includeXML);
        }
        IntSet matches = null;
        str = this._index.canonicalCase(str);
        matches = this.search(str, matches);
        if (request.getQueryUrns().size() > 0) {
            matches = this.urnSearch(request.getQueryUrns().iterator(), matches);
        }
        if (matches == null) {
            return EMPTY_RESPONSES;
        }
        LinkedList responses = new LinkedList();
        MediaType.Aggregator filter = MediaType.getAggregator(request);
        IntSet.IntSetIterator iter = matches.iterator();
        while (iter.hasNext()) {
            int i = iter.next();
            FileDesc desc = (FileDesc)this._files.get(i);
            if (desc == null) {
                Assert.that(false, "unexpected null in FileManager for query:\n" + request);
            }
            if (filter != null && !filter.allow(desc.getName())) continue;
            desc.incrementHitCount();
            RouterService.getCallback().handleSharedFileUpdate(desc.getFile());
            Response resp = new Response(desc);
            if (includeXML) {
                this.addXMLToResponse(resp, desc);
            }
            responses.add((Object)resp);
        }
        if (responses.size() == 0) {
            return EMPTY_RESPONSES;
        }
        return (Response[])responses.toArray((Object[])new Response[responses.size()]);
    }

    private Response[] respondToWhatIsNewRequest(QueryRequest request, boolean includeXML) {
        List urnList = CreationTimeCache.instance().getFiles(request, 3);
        if (urnList.size() == 0) {
            return EMPTY_RESPONSES;
        }
        Response[] resps = new Response[urnList.size()];
        for (int i = 0; i < urnList.size(); ++i) {
            URN currURN = (URN)urnList.get(i);
            FileDesc desc = this.getFileDescForUrn(currURN);
            if (desc == null || desc instanceof IncompleteFileDesc) {
                throw new RuntimeException("Bad Rep - No IFDs allowed!");
            }
            Response r = new Response(desc);
            if (includeXML) {
                this.addXMLToResponse(r, desc);
            }
            resps[i] = r;
        }
        return resps;
    }

    private Response[] respondToIndexingQuery(boolean includeXML) {
        if (this._numFiles == 0) {
            return EMPTY_RESPONSES;
        }
        Response[] ret = new Response[this._numFiles];
        int j = 0;
        for (int i = 0; i < this._files.size(); ++i) {
            FileDesc desc = (FileDesc)this._files.get(i);
            if (desc == null || desc instanceof IncompleteFileDesc) continue;
            Assert.that(j < ret.length, "_numFiles is too small");
            ret[j] = new Response(desc);
            if (includeXML) {
                this.addXMLToResponse(ret[j], desc);
            }
            ++j;
        }
        Assert.that(j == ret.length, "_numFiles is too large");
        return ret;
    }

    protected abstract boolean shouldIncludeXMLInResponse(QueryRequest var1);

    protected abstract void addXMLToResponse(Response var1, FileDesc var2);

    protected IntSet search(String query, IntSet priors) {
        IntSet ret = priors;
        int i = 0;
        while (i < query.length()) {
            int j;
            if (FileManager.isDelimeter(query.charAt(i))) {
                ++i;
                continue;
            }
            for (j = i + 1; j < query.length() && !FileManager.isDelimeter(query.charAt(j)); ++j) {
            }
            Iterator iter = this._index.getPrefixedBy(query, i, j);
            if (iter.hasNext()) {
                IntSet matches = null;
                while (iter.hasNext()) {
                    IntSet s = (IntSet)iter.next();
                    if (matches == null) {
                        if (i == 0 && j == query.length() && !iter.hasNext()) {
                            return s;
                        }
                        matches = new IntSet();
                    }
                    matches.addAll(s);
                }
                if (ret == null) {
                    ret = matches;
                } else {
                    ret.retainAll(matches);
                }
            } else {
                return null;
            }
            if (ret.size() == 0) {
                return null;
            }
            i = j;
        }
        if (ret == null || ret.size() == 0) {
            return null;
        }
        return ret;
    }

    private synchronized IntSet urnSearch(Iterator urnsIter, IntSet priors) {
        IntSet ret = priors;
        while (urnsIter.hasNext()) {
            URN urn = (URN)urnsIter.next();
            IntSet hits = (IntSet)this._urnIndex.get((Object)urn);
            if (hits == null) continue;
            IntSet.IntSetIterator iter = hits.iterator();
            while (iter.hasNext()) {
                FileDesc fd = (FileDesc)this._files.get(iter.next());
                if (fd == null || fd instanceof IncompleteFileDesc || !fd.containsUrn(urn)) continue;
                if (ret == null) {
                    ret = new IntSet();
                }
                ret.add(fd.getIndex());
            }
        }
        return ret;
    }

    protected synchronized void repOk() {
        FileDesc fd;
        int i;
        IntSet.IntSetIterator iter2;
        if (!this.DEBUG) {
            return;
        }
        System.err.println("WARNING: running repOk()");
        IntSet indices = new IntSet();
        Object iter = this._index.getPrefixedBy("");
        while (iter.hasNext()) {
            IntSet set = (IntSet)iter.next();
            indices.addAll(set);
        }
        iter = indices.iterator();
        while (((IntSet.IntSetIterator)iter).hasNext()) {
            int i2 = ((IntSet.IntSetIterator)iter).next();
            FileDesc desc = (FileDesc)this._files.get(i2);
            Assert.that(desc != null, "Null entry for index value " + i2);
        }
        iter = this._urnIndex.keySet().iterator();
        while (iter.hasNext()) {
            URN urn = (URN)iter.next();
            IntSet indices2 = (IntSet)this._urnIndex.get((Object)urn);
            iter2 = indices2.iterator();
            while (iter2.hasNext()) {
                i = iter2.next();
                fd = (FileDesc)this._files.get(i);
                Assert.that(fd != null, "Missing file for urn");
                Assert.that(fd.containsUrn(urn), "URN mismatch");
            }
        }
        iter = this._sharedDirectories.keySet().iterator();
        while (iter.hasNext()) {
            File directory = (File)iter.next();
            IntSet children = (IntSet)this._sharedDirectories.get((Object)directory);
            iter2 = children.iterator();
            while (iter2.hasNext()) {
                i = iter2.next();
                Assert.that(i >= 0 && i < this._files.size(), "Bad index " + i + " in directory");
                fd = (FileDesc)this._files.get(i);
                Assert.that(fd != null, "Directory listing points to empty file");
            }
        }
        int numFilesCount = 0;
        int sizeFilesCount = 0;
        for (int i3 = 0; i3 < this._files.size(); ++i3) {
            if (this._files.get(i3) == null) continue;
            FileDesc desc = (FileDesc)this._files.get(i3);
            ++numFilesCount;
            sizeFilesCount = (int)((long)sizeFilesCount + desc.getSize());
            Assert.that(desc.getIndex() == i3, "Bad index value.  Got " + desc.getIndex() + " not " + i3);
            Assert.that(indices.contains(i3), "Index does not contain entry for " + i3);
            try {
                IntSet siblings = (IntSet)this._sharedDirectories.get((Object)FileUtils.getCanonicalFile(FileUtils.getParentFile(desc.getFile())));
                Assert.that(siblings != null, "Directory for " + desc.getPath() + " isn't shared");
                Assert.that(siblings.contains(i3), "Index " + i3 + " not in directory");
            }
            catch (IOException e) {
                Assert.that(false);
            }
            iter = desc.getUrns().iterator();
            while (iter.hasNext()) {
                URN urn = (URN)iter.next();
                IntSet indices2 = (IntSet)this._urnIndex.get((Object)urn);
                Assert.that(indices2 != null, "Urn not found");
                Assert.that(indices2.contains(desc.getIndex()));
            }
        }
        Assert.that(this._numFiles == numFilesCount, this._numFiles + " should be " + numFilesCount);
        Assert.that(this._size == (long)sizeFilesCount, this._size + " should be " + sizeFilesCount);
    }

    static {
        SHAREABLE_FILE_FILTER = new ShareableFileFilter();
        DIRECTORY_FILTER = new DirectoryFilter();
        _needRebuild = true;
        debugOn = false;
        EMPTY_RESPONSES = new Response[0];
    }

    private static class DirectoryFilter
    implements FilenameFilter {
        private DirectoryFilter() {
        }

        public boolean accept(File dir, String name) {
            File f = new File(dir, name);
            return f.isDirectory();
        }
    }

    private static class ShareableFileFilter
    implements FilenameFilter {
        private ShareableFileFilter() {
        }

        public boolean accept(File dir, String name) {
            File f = new File(dir, name);
            return FileManager.isFileShareable(f, f.length());
        }
    }
}

